(ns
 com.palletops.awaze.iam
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.iam :as iam]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1792__auto__))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m12355]
   (clojure.core/let
    [credentials12356 (:credentials m12355) args12357 (:args m12355)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12358
      (com.palletops.awaze.common/aws-client :iam credentials12356)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12358
       listGroupsForUser
       (identitymanagement/list-groups-for-user-request
        (clojure.core/nth args12357 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-groups-for-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupsForUser"}
   [credentials12360 & args12361]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12362
     (com.palletops.awaze.common/aws-client :iam credentials12360)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12362
      listGroupsForUser
      (identitymanagement/list-groups-for-user-request
       (clojure.core/nth args12361 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m12363]
   (clojure.core/let
    [credentials12364 (:credentials m12363) args12365 (:args m12363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12366
      (com.palletops.awaze.common/aws-client :iam credentials12364)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12366
       createUser
       (identitymanagement/create-user-request
        (clojure.core/nth args12365 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createUser"}
   [credentials12368 & args12369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12370
     (com.palletops.awaze.common/aws-client :iam credentials12368)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12370
      createUser
      (identitymanagement/create-user-request
       (clojure.core/nth args12369 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-credential-report
   [m12371]
   (clojure.core/let
    [credentials12372 (:credentials m12371) args12373 (:args m12371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12374
      (com.palletops.awaze.common/aws-client :iam credentials12372)]
     (clojure.core/case
      (clojure.core/count args12373)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12374
        getCredentialReport
        (identitymanagement/get-credential-report-request
         (clojure.core/nth args12373 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12374
        getCredentialReport))))))
  (clojure.core/defn
   get-credential-report-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getCredentialReport, getCredentialReport"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-credential-report
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getCredentialReport, getCredentialReport"}
   [credentials12376 & args12377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12378
     (com.palletops.awaze.common/aws-client :iam credentials12376)]
    (clojure.core/case
     (clojure.core/count args12377)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12378
       getCredentialReport
       (identitymanagement/get-credential-report-request
        (clojure.core/nth args12377 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12378
       getCredentialReport))))))
 (do
  (clojure.core/defmethod
   iam
   :get-open-idconnect-provider
   [m12379]
   (clojure.core/let
    [credentials12380 (:credentials m12379) args12381 (:args m12379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12382
      (com.palletops.awaze.common/aws-client :iam credentials12380)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12382
       getOpenIDConnectProvider
       (identitymanagement/get-open-idconnect-provider-request
        (clojure.core/nth args12381 0)))))))
  (clojure.core/defn
   get-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getOpenIDConnectProvider"}
   [credentials12384 & args12385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12386
     (com.palletops.awaze.common/aws-client :iam credentials12384)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12386
      getOpenIDConnectProvider
      (identitymanagement/get-open-idconnect-provider-request
       (clojure.core/nth args12385 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m12387]
   (clojure.core/let
    [credentials12388 (:credentials m12387) args12389 (:args m12387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12390
      (com.palletops.awaze.common/aws-client :iam credentials12388)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12390
       deleteSigningCertificate
       (identitymanagement/delete-signing-certificate-request
        (clojure.core/nth args12389 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials12392 & args12393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12394
     (com.palletops.awaze.common/aws-client :iam credentials12392)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12394
      deleteSigningCertificate
      (identitymanagement/delete-signing-certificate-request
       (clojure.core/nth args12393 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m12395]
   (clojure.core/let
    [credentials12396 (:credentials m12395) args12397 (:args m12395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12398
      (com.palletops.awaze.common/aws-client :iam credentials12396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12398
       changePassword
       (identitymanagement/change-password-request
        (clojure.core/nth args12397 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-password,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Call changePassword"}
   [credentials12400 & args12401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12402
     (com.palletops.awaze.common/aws-client :iam credentials12400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12402
      changePassword
      (identitymanagement/change-password-request
       (clojure.core/nth args12401 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m12403]
   (clojure.core/let
    [credentials12404 (:credentials m12403) args12405 (:args m12403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12406
      (com.palletops.awaze.common/aws-client :iam credentials12404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12406
       listInstanceProfilesForRole
       (identitymanagement/list-instance-profiles-for-role-request
        (clojure.core/nth args12405 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials12408 & args12409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12410
     (com.palletops.awaze.common/aws-client :iam credentials12408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12410
      listInstanceProfilesForRole
      (identitymanagement/list-instance-profiles-for-role-request
       (clojure.core/nth args12409 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m12411]
   (clojure.core/let
    [credentials12412 (:credentials m12411) args12413 (:args m12411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12414
      (com.palletops.awaze.common/aws-client :iam credentials12412)]
     (clojure.core/case
      (clojure.core/count args12413)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12414
        listInstanceProfiles
        (identitymanagement/list-instance-profiles-request
         (clojure.core/nth args12413 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12414
        listInstanceProfiles))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-instance-profiles,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-profiles,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials12416 & args12417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12418
     (com.palletops.awaze.common/aws-client :iam credentials12416)]
    (clojure.core/case
     (clojure.core/count args12417)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12418
       listInstanceProfiles
       (identitymanagement/list-instance-profiles-request
        (clojure.core/nth args12417 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12418
       listInstanceProfiles))))))
 (do
  (clojure.core/defmethod
   iam
   :set-default-policy-version
   [m12419]
   (clojure.core/let
    [credentials12420 (:credentials m12419) args12421 (:args m12419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12422
      (com.palletops.awaze.common/aws-client :iam credentials12420)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12422
       setDefaultPolicyVersion
       (identitymanagement/set-default-policy-version-request
        (clojure.core/nth args12421 0)))))))
  (clojure.core/defn
   set-default-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDefaultPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-default-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   set-default-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call setDefaultPolicyVersion"}
   [credentials12424 & args12425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12426
     (com.palletops.awaze.common/aws-client :iam credentials12424)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12426
      setDefaultPolicyVersion
      (identitymanagement/set-default-policy-version-request
       (clojure.core/nth args12425 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m12427]
   (clojure.core/let
    [credentials12428 (:credentials m12427) args12429 (:args m12427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12430
      (com.palletops.awaze.common/aws-client :iam credentials12428)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12430
       deleteUserPolicy
       (identitymanagement/delete-user-policy-request
        (clojure.core/nth args12429 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials12432 & args12433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12434
     (com.palletops.awaze.common/aws-client :iam credentials12432)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12434
      deleteUserPolicy
      (identitymanagement/delete-user-policy-request
       (clojure.core/nth args12433 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-access-key-last-used
   [m12435]
   (clojure.core/let
    [credentials12436 (:credentials m12435) args12437 (:args m12435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12438
      (com.palletops.awaze.common/aws-client :iam credentials12436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12438
       getAccessKeyLastUsed
       (identitymanagement/get-access-key-last-used-request
        (clojure.core/nth args12437 0)))))))
  (clojure.core/defn
   get-access-key-last-used-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for getAccessKeyLastUsed"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-access-key-last-used,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-access-key-last-used
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call getAccessKeyLastUsed"}
   [credentials12440 & args12441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12442
     (com.palletops.awaze.common/aws-client :iam credentials12440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12442
      getAccessKeyLastUsed
      (identitymanagement/get-access-key-last-used-request
       (clojure.core/nth args12441 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-group-policy
   [m12443]
   (clojure.core/let
    [credentials12444 (:credentials m12443) args12445 (:args m12443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12446
      (com.palletops.awaze.common/aws-client :iam credentials12444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12446
       attachGroupPolicy
       (identitymanagement/attach-group-policy-request
        (clojure.core/nth args12445 0)))))))
  (clojure.core/defn
   attach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachGroupPolicy"}
   [credentials12448 & args12449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12450
     (com.palletops.awaze.common/aws-client :iam credentials12448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12450
      attachGroupPolicy
      (identitymanagement/attach-group-policy-request
       (clojure.core/nth args12449 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m12451]
   (clojure.core/let
    [credentials12452 (:credentials m12451) args12453 (:args m12451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12454
      (com.palletops.awaze.common/aws-client :iam credentials12452)]
     (clojure.core/case
      (clojure.core/count args12453)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12454
        getUser))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12454
        getUser
        (identitymanagement/get-user-request
         (clojure.core/nth args12453 0))))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-user,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getUser, getUser"}
   [credentials12456 & args12457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12458
     (com.palletops.awaze.common/aws-client :iam credentials12456)]
    (clojure.core/case
     (clojure.core/count args12457)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12458
       getUser))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12458
       getUser
       (identitymanagement/get-user-request
        (clojure.core/nth args12457 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :generate-credential-report
   [m12459]
   (clojure.core/let
    [credentials12460 (:credentials m12459) args12461 (:args m12459)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12462
      (com.palletops.awaze.common/aws-client :iam credentials12460)]
     (clojure.core/case
      (clojure.core/count args12461)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12462
        generateCredentialReport))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12462
        generateCredentialReport
        (identitymanagement/generate-credential-report-request
         (clojure.core/nth args12461 0))))))))
  (clojure.core/defn
   generate-credential-report-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for generateCredentialReport, generateCredentialReport"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :generate-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :generate-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   generate-credential-report
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call generateCredentialReport, generateCredentialReport"}
   [credentials12464 & args12465]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12466
     (com.palletops.awaze.common/aws-client :iam credentials12464)]
    (clojure.core/case
     (clojure.core/count args12465)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12466
       generateCredentialReport))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12466
       generateCredentialReport
       (identitymanagement/generate-credential-report-request
        (clojure.core/nth args12465 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-sshpublic-key
   [m12467]
   (clojure.core/let
    [credentials12468 (:credentials m12467) args12469 (:args m12467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12470
      (com.palletops.awaze.common/aws-client :iam credentials12468)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12470
       getSSHPublicKey
       (identitymanagement/get-sshpublic-key-request
        (clojure.core/nth args12469 0)))))))
  (clojure.core/defn
   get-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSSHPublicKey"}
   [credentials12472 & args12473]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12474
     (com.palletops.awaze.common/aws-client :iam credentials12472)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12474
      getSSHPublicKey
      (identitymanagement/get-sshpublic-key-request
       (clojure.core/nth args12473 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m12475]
   (clojure.core/let
    [credentials12476 (:credentials m12475) args12477 (:args m12475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12478
      (com.palletops.awaze.common/aws-client :iam credentials12476)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12478
       createAccountAlias
       (identitymanagement/create-account-alias-request
        (clojure.core/nth args12477 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-account-alias,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call createAccountAlias"}
   [credentials12480 & args12481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12482
     (com.palletops.awaze.common/aws-client :iam credentials12480)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12482
      createAccountAlias
      (identitymanagement/create-account-alias-request
       (clojure.core/nth args12481 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-samlprovider
   [m12483]
   (clojure.core/let
    [credentials12484 (:credentials m12483) args12485 (:args m12483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12486
      (com.palletops.awaze.common/aws-client :iam credentials12484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12486
       getSAMLProvider
       (identitymanagement/get-samlprovider-request
        (clojure.core/nth args12485 0)))))))
  (clojure.core/defn
   get-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSAMLProvider"}
   [credentials12488 & args12489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12490
     (com.palletops.awaze.common/aws-client :iam credentials12488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12490
      getSAMLProvider
      (identitymanagement/get-samlprovider-request
       (clojure.core/nth args12489 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy-version
   [m12491]
   (clojure.core/let
    [credentials12492 (:credentials m12491) args12493 (:args m12491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12494
      (com.palletops.awaze.common/aws-client :iam credentials12492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12494
       getPolicyVersion
       (identitymanagement/get-policy-version-request
        (clojure.core/nth args12493 0)))))))
  (clojure.core/defn
   get-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicyVersion"}
   [credentials12496 & args12497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12498
     (com.palletops.awaze.common/aws-client :iam credentials12496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12498
      getPolicyVersion
      (identitymanagement/get-policy-version-request
       (clojure.core/nth args12497 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m12499]
   (clojure.core/let
    [credentials12500 (:credentials m12499) args12501 (:args m12499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12502
      (com.palletops.awaze.common/aws-client :iam credentials12500)]
     (clojure.core/case
      (clojure.core/count args12501)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12502
        listMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12502
        listMFADevices
        (identitymanagement/list-mfadevices-request
         (clojure.core/nth args12501 0))))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials12504 & args12505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12506
     (com.palletops.awaze.common/aws-client :iam credentials12504)]
    (clojure.core/case
     (clojure.core/count args12505)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12506
       listMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12506
       listMFADevices
       (identitymanagement/list-mfadevices-request
        (clojure.core/nth args12505 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m12507]
   (clojure.core/let
    [credentials12508 (:credentials m12507) args12509 (:args m12507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12510
      (com.palletops.awaze.common/aws-client :iam credentials12508)]
     (clojure.core/case
      (clojure.core/count args12509)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12510
        listServerCertificates
        (identitymanagement/list-server-certificates-request
         (clojure.core/nth args12509 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12510
        listServerCertificates))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-server-certificates,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-server-certificates,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials12512 & args12513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12514
     (com.palletops.awaze.common/aws-client :iam credentials12512)]
    (clojure.core/case
     (clojure.core/count args12513)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12514
       listServerCertificates
       (identitymanagement/list-server-certificates-request
        (clojure.core/nth args12513 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12514
       listServerCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m12515]
   (clojure.core/let
    [credentials12516 (:credentials m12515) args12517 (:args m12515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12518
      (com.palletops.awaze.common/aws-client :iam credentials12516)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12518
       putGroupPolicy
       (identitymanagement/put-group-policy-request
        (clojure.core/nth args12517 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putGroupPolicy"}
   [credentials12520 & args12521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12522
     (com.palletops.awaze.common/aws-client :iam credentials12520)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12522
      putGroupPolicy
      (identitymanagement/put-group-policy-request
       (clojure.core/nth args12521 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-authorization-details
   [m12523]
   (clojure.core/let
    [credentials12524 (:credentials m12523) args12525 (:args m12523)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12526
      (com.palletops.awaze.common/aws-client :iam credentials12524)]
     (clojure.core/case
      (clojure.core/count args12525)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12526
        getAccountAuthorizationDetails))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12526
        getAccountAuthorizationDetails
        (identitymanagement/get-account-authorization-details-request
         (clojure.core/nth args12525 0))))))))
  (clojure.core/defn
   get-account-authorization-details-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-authorization-details,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-authorization-details,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-authorization-details
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   [credentials12528 & args12529]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12530
     (com.palletops.awaze.common/aws-client :iam credentials12528)]
    (clojure.core/case
     (clojure.core/count args12529)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12530
       getAccountAuthorizationDetails))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12530
       getAccountAuthorizationDetails
       (identitymanagement/get-account-authorization-details-request
        (clojure.core/nth args12529 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m12531]
   (clojure.core/let
    [credentials12532 (:credentials m12531) args12533 (:args m12531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12534
      (com.palletops.awaze.common/aws-client :iam credentials12532)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12534
       deleteGroupPolicy
       (identitymanagement/delete-group-policy-request
        (clojure.core/nth args12533 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials12536 & args12537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12538
     (com.palletops.awaze.common/aws-client :iam credentials12536)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12538
      deleteGroupPolicy
      (identitymanagement/delete-group-policy-request
       (clojure.core/nth args12537 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-open-idconnect-providers
   [m12539]
   (clojure.core/let
    [credentials12540 (:credentials m12539) args12541 (:args m12539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12542
      (com.palletops.awaze.common/aws-client :iam credentials12540)]
     (clojure.core/case
      (clojure.core/count args12541)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12542
        listOpenIDConnectProviders))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12542
        listOpenIDConnectProviders
        (identitymanagement/list-open-idconnect-providers-request
         (clojure.core/nth args12541 0))))))))
  (clojure.core/defn
   list-open-idconnect-providers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listOpenIDConnectProviders, listOpenIDConnectProviders"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-open-idconnect-providers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listOpenIDConnectProviders, listOpenIDConnectProviders"}
   [credentials12544 & args12545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12546
     (com.palletops.awaze.common/aws-client :iam credentials12544)]
    (clojure.core/case
     (clojure.core/count args12545)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12546
       listOpenIDConnectProviders))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12546
       listOpenIDConnectProviders
       (identitymanagement/list-open-idconnect-providers-request
        (clojure.core/nth args12545 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m12547]
   (clojure.core/let
    [credentials12548 (:credentials m12547) args12549 (:args m12547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12550
      (com.palletops.awaze.common/aws-client :iam credentials12548)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12550
       listRolePolicies
       (identitymanagement/list-role-policies-request
        (clojure.core/nth args12549 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-role-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRolePolicies"}
   [credentials12552 & args12553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12554
     (com.palletops.awaze.common/aws-client :iam credentials12552)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12554
      listRolePolicies
      (identitymanagement/list-role-policies-request
       (clojure.core/nth args12553 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m12555]
   (clojure.core/let
    [credentials12556 (:credentials m12555) args12557 (:args m12555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12558
      (com.palletops.awaze.common/aws-client :iam credentials12556)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12558
       updateAccountPasswordPolicy
       (identitymanagement/update-account-password-policy-request
        (clojure.core/nth args12557 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials12560 & args12561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12562
     (com.palletops.awaze.common/aws-client :iam credentials12560)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12562
      updateAccountPasswordPolicy
      (identitymanagement/update-account-password-policy-request
       (clojure.core/nth args12561 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m12563]
   (clojure.core/let
    [credentials12564 (:credentials m12563) args12565 (:args m12563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12566
      (com.palletops.awaze.common/aws-client :iam credentials12564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12566
       putUserPolicy
       (identitymanagement/put-user-policy-request
        (clojure.core/nth args12565 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putUserPolicy"}
   [credentials12568 & args12569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12570
     (com.palletops.awaze.common/aws-client :iam credentials12568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12570
      putUserPolicy
      (identitymanagement/put-user-policy-request
       (clojure.core/nth args12569 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m12571]
   (clojure.core/let
    [credentials12572 (:credentials m12571) args12573 (:args m12571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12574
      (com.palletops.awaze.common/aws-client :iam credentials12572)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12574
       updateAssumeRolePolicy
       (identitymanagement/update-assume-role-policy-request
        (clojure.core/nth args12573 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-assume-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials12576 & args12577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12578
     (com.palletops.awaze.common/aws-client :iam credentials12576)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12578
      updateAssumeRolePolicy
      (identitymanagement/update-assume-role-policy-request
       (clojure.core/nth args12577 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy
   [m12579]
   (clojure.core/let
    [credentials12580 (:credentials m12579) args12581 (:args m12579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12582
      (com.palletops.awaze.common/aws-client :iam credentials12580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12582
       getPolicy
       (identitymanagement/get-policy-request
        (clojure.core/nth args12581 0)))))))
  (clojure.core/defn
   get-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicy"}
   [credentials12584 & args12585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12586
     (com.palletops.awaze.common/aws-client :iam credentials12584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12586
      getPolicy
      (identitymanagement/get-policy-request
       (clojure.core/nth args12585 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m12587]
   (clojure.core/let
    [credentials12588 (:credentials m12587) args12589 (:args m12587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12590
      (com.palletops.awaze.common/aws-client :iam credentials12588)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12590
       updateUser
       (identitymanagement/update-user-request
        (clojure.core/nth args12589 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateUser"}
   [credentials12592 & args12593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12594
     (com.palletops.awaze.common/aws-client :iam credentials12592)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12594
      updateUser
      (identitymanagement/update-user-request
       (clojure.core/nth args12593 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m12595]
   (clojure.core/let
    [credentials12596 (:credentials m12595) args12597 (:args m12595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12598
      (com.palletops.awaze.common/aws-client :iam credentials12596)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12598
       getRolePolicy
       (identitymanagement/get-role-policy-request
        (clojure.core/nth args12597 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRolePolicy"}
   [credentials12600 & args12601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12602
     (com.palletops.awaze.common/aws-client :iam credentials12600)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12602
      getRolePolicy
      (identitymanagement/get-role-policy-request
       (clojure.core/nth args12601 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m12603]
   (clojure.core/let
    [credentials12604 (:credentials m12603) args12605 (:args m12603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12606
      (com.palletops.awaze.common/aws-client :iam credentials12604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12606
       deleteGroup
       (identitymanagement/delete-group-request
        (clojure.core/nth args12605 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroup"}
   [credentials12608 & args12609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12610
     (com.palletops.awaze.common/aws-client :iam credentials12608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12610
      deleteGroup
      (identitymanagement/delete-group-request
       (clojure.core/nth args12609 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m12611]
   (clojure.core/let
    [credentials12612 (:credentials m12611) args12613 (:args m12611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12614
      (com.palletops.awaze.common/aws-client :iam credentials12612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12614
       getLoginProfile
       (identitymanagement/get-login-profile-request
        (clojure.core/nth args12613 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getLoginProfile"}
   [credentials12616 & args12617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12618
     (com.palletops.awaze.common/aws-client :iam credentials12616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12618
      getLoginProfile
      (identitymanagement/get-login-profile-request
       (clojure.core/nth args12617 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-samlproviders
   [m12619]
   (clojure.core/let
    [credentials12620 (:credentials m12619) args12621 (:args m12619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12622
      (com.palletops.awaze.common/aws-client :iam credentials12620)]
     (clojure.core/case
      (clojure.core/count args12621)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12622
        listSAMLProviders
        (identitymanagement/list-samlproviders-request
         (clojure.core/nth args12621 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12622
        listSAMLProviders))))))
  (clojure.core/defn
   list-samlproviders-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listSAMLProviders, listSAMLProviders"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-samlproviders,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-samlproviders,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-samlproviders
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listSAMLProviders, listSAMLProviders"}
   [credentials12624 & args12625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12626
     (com.palletops.awaze.common/aws-client :iam credentials12624)]
    (clojure.core/case
     (clojure.core/count args12625)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12626
       listSAMLProviders
       (identitymanagement/list-samlproviders-request
        (clojure.core/nth args12625 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12626
       listSAMLProviders))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m12627]
   (clojure.core/let
    [credentials12628 (:credentials m12627) args12629 (:args m12627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12630
      (com.palletops.awaze.common/aws-client :iam credentials12628)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12630
       createRole
       (identitymanagement/create-role-request
        (clojure.core/nth args12629 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRole"}
   [credentials12632 & args12633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12634
     (com.palletops.awaze.common/aws-client :iam credentials12632)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12634
      createRole
      (identitymanagement/create-role-request
       (clojure.core/nth args12633 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-group-policies
   [m12635]
   (clojure.core/let
    [credentials12636 (:credentials m12635) args12637 (:args m12635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12638
      (com.palletops.awaze.common/aws-client :iam credentials12636)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12638
       listAttachedGroupPolicies
       (identitymanagement/list-attached-group-policies-request
        (clojure.core/nth args12637 0)))))))
  (clojure.core/defn
   list-attached-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedGroupPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-group-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedGroupPolicies"}
   [credentials12640 & args12641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12642
     (com.palletops.awaze.common/aws-client :iam credentials12640)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12642
      listAttachedGroupPolicies
      (identitymanagement/list-attached-group-policies-request
       (clojure.core/nth args12641 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m12643]
   (clojure.core/let
    [credentials12644 (:credentials m12643) args12645 (:args m12643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12646
      (com.palletops.awaze.common/aws-client :iam credentials12644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12646
       deleteAccessKey
       (identitymanagement/delete-access-key-request
        (clojure.core/nth args12645 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call deleteAccessKey"}
   [credentials12648 & args12649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12650
     (com.palletops.awaze.common/aws-client :iam credentials12648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12650
      deleteAccessKey
      (identitymanagement/delete-access-key-request
       (clojure.core/nth args12649 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m12651]
   (clojure.core/let
    [credentials12652 (:credentials m12651) args12653 (:args m12651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12654
      (com.palletops.awaze.common/aws-client :iam credentials12652)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12654
       getGroup
       (identitymanagement/get-group-request
        (clojure.core/nth args12653 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroup"}
   [credentials12656 & args12657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12658
     (com.palletops.awaze.common/aws-client :iam credentials12656)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12658
      getGroup
      (identitymanagement/get-group-request
       (clojure.core/nth args12657 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m12659]
   (clojure.core/let
    [credentials12660 (:credentials m12659) args12661 (:args m12659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12662
      (com.palletops.awaze.common/aws-client :iam credentials12660)]
     (clojure.core/case
      (clojure.core/count args12661)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12662
        deleteAccountPasswordPolicy
        (identitymanagement/delete-account-password-policy-request
         (clojure.core/nth args12661 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12662
        deleteAccountPasswordPolicy))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :delete-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials12664 & args12665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12666
     (com.palletops.awaze.common/aws-client :iam credentials12664)]
    (clojure.core/case
     (clojure.core/count args12665)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12666
       deleteAccountPasswordPolicy
       (identitymanagement/delete-account-password-policy-request
        (clojure.core/nth args12665 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12666
       deleteAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m12667]
   (clojure.core/let
    [credentials12668 (:credentials m12667) args12669 (:args m12667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12670
      (com.palletops.awaze.common/aws-client :iam credentials12668)]
     (clojure.core/case
      (clojure.core/count args12669)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12670
        getAccountSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12670
        getAccountSummary
        (identitymanagement/get-account-summary-request
         (clojure.core/nth args12669 0))))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-summary,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-summary,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials12672 & args12673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12674
     (com.palletops.awaze.common/aws-client :iam credentials12672)]
    (clojure.core/case
     (clojure.core/count args12673)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12674
       getAccountSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12674
       getAccountSummary
       (identitymanagement/get-account-summary-request
        (clojure.core/nth args12673 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy
   [m12675]
   (clojure.core/let
    [credentials12676 (:credentials m12675) args12677 (:args m12675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12678
      (com.palletops.awaze.common/aws-client :iam credentials12676)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12678
       deletePolicy
       (identitymanagement/delete-policy-request
        (clojure.core/nth args12677 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicy"}
   [credentials12680 & args12681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12682
     (com.palletops.awaze.common/aws-client :iam credentials12680)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12682
      deletePolicy
      (identitymanagement/delete-policy-request
       (clojure.core/nth args12681 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m12683]
   (clojure.core/let
    [credentials12684 (:credentials m12683) args12685 (:args m12683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12686
      (com.palletops.awaze.common/aws-client :iam credentials12684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12686
       createGroup
       (identitymanagement/create-group-request
        (clojure.core/nth args12685 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createGroup"}
   [credentials12688 & args12689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12690
     (com.palletops.awaze.common/aws-client :iam credentials12688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12690
      createGroup
      (identitymanagement/create-group-request
       (clojure.core/nth args12689 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m12691]
   (clojure.core/let
    [credentials12692 (:credentials m12691) args12693 (:args m12691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12694
      (com.palletops.awaze.common/aws-client :iam credentials12692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12694
       getRole
       (identitymanagement/get-role-request
        (clojure.core/nth args12693 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRole"}
   [credentials12696 & args12697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12698
     (com.palletops.awaze.common/aws-client :iam credentials12696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12698
      getRole
      (identitymanagement/get-role-request
       (clojure.core/nth args12697 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policy-versions
   [m12699]
   (clojure.core/let
    [credentials12700 (:credentials m12699) args12701 (:args m12699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12702
      (com.palletops.awaze.common/aws-client :iam credentials12700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12702
       listPolicyVersions
       (identitymanagement/list-policy-versions-request
        (clojure.core/nth args12701 0)))))))
  (clojure.core/defn
   list-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPolicyVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-policy-versions,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listPolicyVersions"}
   [credentials12704 & args12705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12706
     (com.palletops.awaze.common/aws-client :iam credentials12704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12706
      listPolicyVersions
      (identitymanagement/list-policy-versions-request
       (clojure.core/nth args12705 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m12707]
   (clojure.core/let
    [credentials12708 (:credentials m12707) args12709 (:args m12707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12710
      (com.palletops.awaze.common/aws-client :iam credentials12708)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12710
       listGroupPolicies
       (identitymanagement/list-group-policies-request
        (clojure.core/nth args12709 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-group-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupPolicies"}
   [credentials12712 & args12713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12714
     (com.palletops.awaze.common/aws-client :iam credentials12712)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12714
      listGroupPolicies
      (identitymanagement/list-group-policies-request
       (clojure.core/nth args12713 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-samlprovider
   [m12715]
   (clojure.core/let
    [credentials12716 (:credentials m12715) args12717 (:args m12715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12718
      (com.palletops.awaze.common/aws-client :iam credentials12716)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12718
       deleteSAMLProvider
       (identitymanagement/delete-samlprovider-request
        (clojure.core/nth args12717 0)))))))
  (clojure.core/defn
   delete-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSAMLProvider"}
   [credentials12720 & args12721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12722
     (com.palletops.awaze.common/aws-client :iam credentials12720)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12722
      deleteSAMLProvider
      (identitymanagement/delete-samlprovider-request
       (clojure.core/nth args12721 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-role-policy
   [m12723]
   (clojure.core/let
    [credentials12724 (:credentials m12723) args12725 (:args m12723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12726
      (com.palletops.awaze.common/aws-client :iam credentials12724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12726
       detachRolePolicy
       (identitymanagement/detach-role-policy-request
        (clojure.core/nth args12725 0)))))))
  (clojure.core/defn
   detach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachRolePolicy"}
   [credentials12728 & args12729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12730
     (com.palletops.awaze.common/aws-client :iam credentials12728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12730
      detachRolePolicy
      (identitymanagement/detach-role-policy-request
       (clojure.core/nth args12729 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m12731]
   (clojure.core/let
    [credentials12732 (:credentials m12731) args12733 (:args m12731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12734
      (com.palletops.awaze.common/aws-client :iam credentials12732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12734
       updateLoginProfile
       (identitymanagement/update-login-profile-request
        (clojure.core/nth args12733 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateLoginProfile"}
   [credentials12736 & args12737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12738
     (com.palletops.awaze.common/aws-client :iam credentials12736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12738
      updateLoginProfile
      (identitymanagement/update-login-profile-request
       (clojure.core/nth args12737 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-open-idconnect-provider-thumbprint
   [m12739]
   (clojure.core/let
    [credentials12740 (:credentials m12739) args12741 (:args m12739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12742
      (com.palletops.awaze.common/aws-client :iam credentials12740)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12742
       updateOpenIDConnectProviderThumbprint
       (identitymanagement/update-open-idconnect-provider-thumbprint-request
        (clojure.core/nth args12741 0)))))))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateOpenIDConnectProviderThumbprint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-open-idconnect-provider-thumbprint,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateOpenIDConnectProviderThumbprint"}
   [credentials12744 & args12745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12746
     (com.palletops.awaze.common/aws-client :iam credentials12744)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12746
      updateOpenIDConnectProviderThumbprint
      (identitymanagement/update-open-idconnect-provider-thumbprint-request
       (clojure.core/nth args12745 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-sshpublic-key
   [m12747]
   (clojure.core/let
    [credentials12748 (:credentials m12747) args12749 (:args m12747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12750
      (com.palletops.awaze.common/aws-client :iam credentials12748)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12750
       updateSSHPublicKey
       (identitymanagement/update-sshpublic-key-request
        (clojure.core/nth args12749 0)))))))
  (clojure.core/defn
   update-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSSHPublicKey"}
   [credentials12752 & args12753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12754
     (com.palletops.awaze.common/aws-client :iam credentials12752)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12754
      updateSSHPublicKey
      (identitymanagement/update-sshpublic-key-request
       (clojure.core/nth args12753 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m12755]
   (clojure.core/let
    [credentials12756 (:credentials m12755) args12757 (:args m12755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12758
      (com.palletops.awaze.common/aws-client :iam credentials12756)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12758
       deleteServerCertificate
       (identitymanagement/delete-server-certificate-request
        (clojure.core/nth args12757 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials12760 & args12761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12762
     (com.palletops.awaze.common/aws-client :iam credentials12760)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12762
      deleteServerCertificate
      (identitymanagement/delete-server-certificate-request
       (clojure.core/nth args12761 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m12763]
   (clojure.core/let
    [credentials12764 (:credentials m12763) args12765 (:args m12763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12766
      (com.palletops.awaze.common/aws-client :iam credentials12764)]
     (clojure.core/case
      (clojure.core/count args12765)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12766
        listVirtualMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12766
        listVirtualMFADevices
        (identitymanagement/list-virtual-mfadevices-request
         (clojure.core/nth args12765 0))))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials12768 & args12769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12770
     (com.palletops.awaze.common/aws-client :iam credentials12768)]
    (clojure.core/case
     (clojure.core/count args12769)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12770
       listVirtualMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12770
       listVirtualMFADevices
       (identitymanagement/list-virtual-mfadevices-request
        (clojure.core/nth args12769 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m12771]
   (clojure.core/let
    [credentials12772 (:credentials m12771) args12773 (:args m12771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12774
      (com.palletops.awaze.common/aws-client :iam credentials12772)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12774
       getServerCertificate
       (identitymanagement/get-server-certificate-request
        (clojure.core/nth args12773 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getServerCertificate"}
   [credentials12776 & args12777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12778
     (com.palletops.awaze.common/aws-client :iam credentials12776)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12778
      getServerCertificate
      (identitymanagement/get-server-certificate-request
       (clojure.core/nth args12777 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m12779]
   (clojure.core/let
    [credentials12780 (:credentials m12779) args12781 (:args m12779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12782
      (com.palletops.awaze.common/aws-client :iam credentials12780)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12782
       deleteRolePolicy
       (identitymanagement/delete-role-policy-request
        (clojure.core/nth args12781 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials12784 & args12785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12786
     (com.palletops.awaze.common/aws-client :iam credentials12784)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12786
      deleteRolePolicy
      (identitymanagement/delete-role-policy-request
       (clojure.core/nth args12785 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m12787]
   (clojure.core/let
    [credentials12788 (:credentials m12787) args12789 (:args m12787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12790
      (com.palletops.awaze.common/aws-client :iam credentials12788)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12790
       deleteInstanceProfile
       (identitymanagement/delete-instance-profile-request
        (clojure.core/nth args12789 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials12792 & args12793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12794
     (com.palletops.awaze.common/aws-client :iam credentials12792)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12794
      deleteInstanceProfile
      (identitymanagement/delete-instance-profile-request
       (clojure.core/nth args12793 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m12795]
   (clojure.core/let
    [credentials12796 (:credentials m12795) args12797 (:args m12795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12798
      (com.palletops.awaze.common/aws-client :iam credentials12796)]
     (clojure.core/case
      (clojure.core/count args12797)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12798
        listAccountAliases))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12798
        listAccountAliases
        (identitymanagement/list-account-aliases-request
         (clojure.core/nth args12797 0))))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-account-aliases,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-account-aliases,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials12800 & args12801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12802
     (com.palletops.awaze.common/aws-client :iam credentials12800)]
    (clojure.core/case
     (clojure.core/count args12801)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12802
       listAccountAliases))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12802
       listAccountAliases
       (identitymanagement/list-account-aliases-request
        (clojure.core/nth args12801 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m12803]
   (clojure.core/let
    [credentials12804 (:credentials m12803) args12805 (:args m12803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12806
      (com.palletops.awaze.common/aws-client :iam credentials12804)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12806
       addUserToGroup
       (identitymanagement/add-user-to-group-request
        (clojure.core/nth args12805 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-user-to-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addUserToGroup"}
   [credentials12808 & args12809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12810
     (com.palletops.awaze.common/aws-client :iam credentials12808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12810
      addUserToGroup
      (identitymanagement/add-user-to-group-request
       (clojure.core/nth args12809 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-open-idconnect-provider
   [m12811]
   (clojure.core/let
    [credentials12812 (:credentials m12811) args12813 (:args m12811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12814
      (com.palletops.awaze.common/aws-client :iam credentials12812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12814
       deleteOpenIDConnectProvider
       (identitymanagement/delete-open-idconnect-provider-request
        (clojure.core/nth args12813 0)))))))
  (clojure.core/defn
   delete-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteOpenIDConnectProvider"}
   [credentials12816 & args12817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12818
     (com.palletops.awaze.common/aws-client :iam credentials12816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12818
      deleteOpenIDConnectProvider
      (identitymanagement/delete-open-idconnect-provider-request
       (clojure.core/nth args12817 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m12819]
   (clojure.core/let
    [credentials12820 (:credentials m12819) args12821 (:args m12819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12822
      (com.palletops.awaze.common/aws-client :iam credentials12820)]
     (clojure.core/case
      (clojure.core/count args12821)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12822
        listUsers
        (identitymanagement/list-users-request
         (clojure.core/nth args12821 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12822
        listUsers))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-users,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-users,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listUsers, listUsers"}
   [credentials12824 & args12825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12826
     (com.palletops.awaze.common/aws-client :iam credentials12824)]
    (clojure.core/case
     (clojure.core/count args12825)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12826
       listUsers
       (identitymanagement/list-users-request
        (clojure.core/nth args12825 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12826
       listUsers))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m12827]
   (clojure.core/let
    [credentials12828 (:credentials m12827) args12829 (:args m12827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12830
      (com.palletops.awaze.common/aws-client :iam credentials12828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12830
       createInstanceProfile
       (identitymanagement/create-instance-profile-request
        (clojure.core/nth args12829 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceProfile"}
   [credentials12832 & args12833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12834
     (com.palletops.awaze.common/aws-client :iam credentials12832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12834
      createInstanceProfile
      (identitymanagement/create-instance-profile-request
       (clojure.core/nth args12833 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m12835]
   (clojure.core/let
    [credentials12836 (:credentials m12835) args12837 (:args m12835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12838
      (com.palletops.awaze.common/aws-client :iam credentials12836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12838
       getUserPolicy
       (identitymanagement/get-user-policy-request
        (clojure.core/nth args12837 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getUserPolicy"}
   [credentials12840 & args12841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12842
     (com.palletops.awaze.common/aws-client :iam credentials12840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12842
      getUserPolicy
      (identitymanagement/get-user-policy-request
       (clojure.core/nth args12841 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m12843]
   (clojure.core/let
    [credentials12844 (:credentials m12843) args12845 (:args m12843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12846
      (com.palletops.awaze.common/aws-client :iam credentials12844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12846
       deleteLoginProfile
       (identitymanagement/delete-login-profile-request
        (clojure.core/nth args12845 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials12848 & args12849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12850
     (com.palletops.awaze.common/aws-client :iam credentials12848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12850
      deleteLoginProfile
      (identitymanagement/delete-login-profile-request
       (clojure.core/nth args12849 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-user-policy
   [m12851]
   (clojure.core/let
    [credentials12852 (:credentials m12851) args12853 (:args m12851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12854
      (com.palletops.awaze.common/aws-client :iam credentials12852)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12854
       attachUserPolicy
       (identitymanagement/attach-user-policy-request
        (clojure.core/nth args12853 0)))))))
  (clojure.core/defn
   attach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachUserPolicy"}
   [credentials12856 & args12857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12858
     (com.palletops.awaze.common/aws-client :iam credentials12856)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12858
      attachUserPolicy
      (identitymanagement/attach-user-policy-request
       (clojure.core/nth args12857 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m12859]
   (clojure.core/let
    [credentials12860 (:credentials m12859) args12861 (:args m12859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12862
      (com.palletops.awaze.common/aws-client :iam credentials12860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12862
       putRolePolicy
       (identitymanagement/put-role-policy-request
        (clojure.core/nth args12861 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putRolePolicy"}
   [credentials12864 & args12865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12866
     (com.palletops.awaze.common/aws-client :iam credentials12864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12866
      putRolePolicy
      (identitymanagement/put-role-policy-request
       (clojure.core/nth args12865 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m12867]
   (clojure.core/let
    [credentials12868 (:credentials m12867) args12869 (:args m12867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12870
      (com.palletops.awaze.common/aws-client :iam credentials12868)]
     (clojure.core/case
      (clojure.core/count args12869)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12870
        listAccessKeys
        (identitymanagement/list-access-keys-request
         (clojure.core/nth args12869 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12870
        listAccessKeys))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-access-keys,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-access-keys,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials12872 & args12873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12874
     (com.palletops.awaze.common/aws-client :iam credentials12872)]
    (clojure.core/case
     (clojure.core/count args12873)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12874
       listAccessKeys
       (identitymanagement/list-access-keys-request
        (clojure.core/nth args12873 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12874
       listAccessKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m12875]
   (clojure.core/let
    [credentials12876 (:credentials m12875) args12877 (:args m12875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12878
      (com.palletops.awaze.common/aws-client :iam credentials12876)]
     (clojure.core/case
      (clojure.core/count args12877)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12878
        listSigningCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12878
        listSigningCertificates
        (identitymanagement/list-signing-certificates-request
         (clojure.core/nth args12877 0))))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-signing-certificates,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-signing-certificates,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials12880 & args12881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12882
     (com.palletops.awaze.common/aws-client :iam credentials12880)]
    (clojure.core/case
     (clojure.core/count args12881)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12882
       listSigningCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12882
       listSigningCertificates
       (identitymanagement/list-signing-certificates-request
        (clojure.core/nth args12881 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-group-policy
   [m12883]
   (clojure.core/let
    [credentials12884 (:credentials m12883) args12885 (:args m12883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12886
      (com.palletops.awaze.common/aws-client :iam credentials12884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12886
       detachGroupPolicy
       (identitymanagement/detach-group-policy-request
        (clojure.core/nth args12885 0)))))))
  (clojure.core/defn
   detach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachGroupPolicy"}
   [credentials12888 & args12889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12890
     (com.palletops.awaze.common/aws-client :iam credentials12888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12890
      detachGroupPolicy
      (identitymanagement/detach-group-policy-request
       (clojure.core/nth args12889 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m12891]
   (clojure.core/let
    [credentials12892 (:credentials m12891) args12893 (:args m12891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12894
      (com.palletops.awaze.common/aws-client :iam credentials12892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12894
       updateAccessKey
       (identitymanagement/update-access-key-request
        (clojure.core/nth args12893 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call updateAccessKey"}
   [credentials12896 & args12897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12898
     (com.palletops.awaze.common/aws-client :iam credentials12896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12898
      updateAccessKey
      (identitymanagement/update-access-key-request
       (clojure.core/nth args12897 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-sshpublic-key
   [m12899]
   (clojure.core/let
    [credentials12900 (:credentials m12899) args12901 (:args m12899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12902
      (com.palletops.awaze.common/aws-client :iam credentials12900)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12902
       uploadSSHPublicKey
       (identitymanagement/upload-sshpublic-key-request
        (clojure.core/nth args12901 0)))))))
  (clojure.core/defn
   upload-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSSHPublicKey"}
   [credentials12904 & args12905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12906
     (com.palletops.awaze.common/aws-client :iam credentials12904)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12906
      uploadSSHPublicKey
      (identitymanagement/upload-sshpublic-key-request
       (clojure.core/nth args12905 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m12907]
   (clojure.core/let
    [credentials12908 (:credentials m12907) args12909 (:args m12907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12910
      (com.palletops.awaze.common/aws-client :iam credentials12908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12910
       uploadServerCertificate
       (identitymanagement/upload-server-certificate-request
        (clojure.core/nth args12909 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials12912 & args12913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12914
     (com.palletops.awaze.common/aws-client :iam credentials12912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12914
      uploadServerCertificate
      (identitymanagement/upload-server-certificate-request
       (clojure.core/nth args12913 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m12915]
   (clojure.core/let
    [credentials12916 (:credentials m12915) args12917 (:args m12915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12918
      (com.palletops.awaze.common/aws-client :iam credentials12916)]
     (clojure.core/case
      (clojure.core/count args12917)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12918
        getAccountPasswordPolicy))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12918
        getAccountPasswordPolicy
        (identitymanagement/get-account-password-policy-request
         (clojure.core/nth args12917 0))))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials12920 & args12921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12922
     (com.palletops.awaze.common/aws-client :iam credentials12920)]
    (clojure.core/case
     (clojure.core/count args12921)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12922
       getAccountPasswordPolicy))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12922
       getAccountPasswordPolicy
       (identitymanagement/get-account-password-policy-request
        (clojure.core/nth args12921 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m12923]
   (clojure.core/let
    [credentials12924 (:credentials m12923) args12925 (:args m12923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12926
      (com.palletops.awaze.common/aws-client :iam credentials12924)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12926
       deleteRole
       (identitymanagement/delete-role-request
        (clojure.core/nth args12925 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRole"}
   [credentials12928 & args12929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12930
     (com.palletops.awaze.common/aws-client :iam credentials12928)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12930
      deleteRole
      (identitymanagement/delete-role-request
       (clojure.core/nth args12929 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-client-idfrom-open-idconnect-provider
   [m12931]
   (clojure.core/let
    [credentials12932 (:credentials m12931) args12933 (:args m12931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12934
      (com.palletops.awaze.common/aws-client :iam credentials12932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12934
       removeClientIDFromOpenIDConnectProvider
       (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
        (clojure.core/nth args12933 0)))))))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeClientIDFromOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-client-idfrom-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeClientIDFromOpenIDConnectProvider"}
   [credentials12936 & args12937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12938
     (com.palletops.awaze.common/aws-client :iam credentials12936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12938
      removeClientIDFromOpenIDConnectProvider
      (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
       (clojure.core/nth args12937 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m12939]
   (clojure.core/let
    [credentials12940 (:credentials m12939) args12941 (:args m12939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12942
      (com.palletops.awaze.common/aws-client :iam credentials12940)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12942
       removeUserFromGroup
       (identitymanagement/remove-user-from-group-request
        (clojure.core/nth args12941 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-user-from-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials12944 & args12945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12946
     (com.palletops.awaze.common/aws-client :iam credentials12944)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12946
      removeUserFromGroup
      (identitymanagement/remove-user-from-group-request
       (clojure.core/nth args12945 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m12947]
   (clojure.core/let
    [credentials12948 (:credentials m12947) args12949 (:args m12947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12950
      (com.palletops.awaze.common/aws-client :iam credentials12948)]
     (clojure.core/case
      (clojure.core/count args12949)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12950
        listRoles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12950
        listRoles
        (identitymanagement/list-roles-request
         (clojure.core/nth args12949 0))))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-roles,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-roles,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRoles, listRoles"}
   [credentials12952 & args12953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12954
     (com.palletops.awaze.common/aws-client :iam credentials12952)]
    (clojure.core/case
     (clojure.core/count args12953)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12954
       listRoles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12954
       listRoles
       (identitymanagement/list-roles-request
        (clojure.core/nth args12953 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-role-policies
   [m12955]
   (clojure.core/let
    [credentials12956 (:credentials m12955) args12957 (:args m12955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12958
      (com.palletops.awaze.common/aws-client :iam credentials12956)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12958
       listAttachedRolePolicies
       (identitymanagement/list-attached-role-policies-request
        (clojure.core/nth args12957 0)))))))
  (clojure.core/defn
   list-attached-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedRolePolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-role-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedRolePolicies"}
   [credentials12960 & args12961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12962
     (com.palletops.awaze.common/aws-client :iam credentials12960)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12962
      listAttachedRolePolicies
      (identitymanagement/list-attached-role-policies-request
       (clojure.core/nth args12961 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m12963]
   (clojure.core/let
    [credentials12964 (:credentials m12963) args12965 (:args m12963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12966
      (com.palletops.awaze.common/aws-client :iam credentials12964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12966
       removeRoleFromInstanceProfile
       (identitymanagement/remove-role-from-instance-profile-request
        (clojure.core/nth args12965 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials12968 & args12969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12970
     (com.palletops.awaze.common/aws-client :iam credentials12968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12970
      removeRoleFromInstanceProfile
      (identitymanagement/remove-role-from-instance-profile-request
       (clojure.core/nth args12969 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy
   [m12971]
   (clojure.core/let
    [credentials12972 (:credentials m12971) args12973 (:args m12971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12974
      (com.palletops.awaze.common/aws-client :iam credentials12972)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12974
       createPolicy
       (identitymanagement/create-policy-request
        (clojure.core/nth args12973 0)))))))
  (clojure.core/defn
   create-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPolicy"}
   [credentials12976 & args12977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12978
     (com.palletops.awaze.common/aws-client :iam credentials12976)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12978
      createPolicy
      (identitymanagement/create-policy-request
       (clojure.core/nth args12977 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-client-idto-open-idconnect-provider
   [m12979]
   (clojure.core/let
    [credentials12980 (:credentials m12979) args12981 (:args m12979)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12982
      (com.palletops.awaze.common/aws-client :iam credentials12980)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12982
       addClientIDToOpenIDConnectProvider
       (identitymanagement/add-client-idto-open-idconnect-provider-request
        (clojure.core/nth args12981 0)))))))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addClientIDToOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-client-idto-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addClientIDToOpenIDConnectProvider"}
   [credentials12984 & args12985]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12986
     (com.palletops.awaze.common/aws-client :iam credentials12984)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12986
      addClientIDToOpenIDConnectProvider
      (identitymanagement/add-client-idto-open-idconnect-provider-request
       (clojure.core/nth args12985 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m12987]
   (clojure.core/let
    [credentials12988 (:credentials m12987) args12989 (:args m12987)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12990
      (com.palletops.awaze.common/aws-client :iam credentials12988)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12990
       createVirtualMFADevice
       (identitymanagement/create-virtual-mfadevice-request
        (clojure.core/nth args12989 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-virtual-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials12992 & args12993]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12994
     (com.palletops.awaze.common/aws-client :iam credentials12992)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12994
      createVirtualMFADevice
      (identitymanagement/create-virtual-mfadevice-request
       (clojure.core/nth args12993 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m12995]
   (clojure.core/let
    [credentials12996 (:credentials m12995) args12997 (:args m12995)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12998
      (com.palletops.awaze.common/aws-client :iam credentials12996)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12998
       deleteAccountAlias
       (identitymanagement/delete-account-alias-request
        (clojure.core/nth args12997 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-account-alias,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials13000 & args13001]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13002
     (com.palletops.awaze.common/aws-client :iam credentials13000)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13002
      deleteAccountAlias
      (identitymanagement/delete-account-alias-request
       (clojure.core/nth args13001 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m13003]
   (clojure.core/let
    [credentials13004 (:credentials m13003) args13005 (:args m13003)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13006
      (com.palletops.awaze.common/aws-client :iam credentials13004)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13006
       uploadSigningCertificate
       (identitymanagement/upload-signing-certificate-request
        (clojure.core/nth args13005 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials13008 & args13009]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13010
     (com.palletops.awaze.common/aws-client :iam credentials13008)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13010
      uploadSigningCertificate
      (identitymanagement/upload-signing-certificate-request
       (clojure.core/nth args13009 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m13011]
   (clojure.core/let
    [credentials13012 (:credentials m13011) args13013 (:args m13011)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13014
      (com.palletops.awaze.common/aws-client :iam credentials13012)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13014
       deactivateMFADevice
       (identitymanagement/deactivate-mfadevice-request
        (clojure.core/nth args13013 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deactivate-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials13016 & args13017]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13018
     (com.palletops.awaze.common/aws-client :iam credentials13016)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13018
      deactivateMFADevice
      (identitymanagement/deactivate-mfadevice-request
       (clojure.core/nth args13017 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m13019]
   (clojure.core/let
    [credentials13020 (:credentials m13019) args13021 (:args m13019)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13022
      (com.palletops.awaze.common/aws-client :iam credentials13020)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13022
       resyncMFADevice
       (identitymanagement/resync-mfadevice-request
        (clojure.core/nth args13021 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :resync-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resyncMFADevice"}
   [credentials13024 & args13025]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13026
     (com.palletops.awaze.common/aws-client :iam credentials13024)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13026
      resyncMFADevice
      (identitymanagement/resync-mfadevice-request
       (clojure.core/nth args13025 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-sshpublic-keys
   [m13027]
   (clojure.core/let
    [credentials13028 (:credentials m13027) args13029 (:args m13027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13030
      (com.palletops.awaze.common/aws-client :iam credentials13028)]
     (clojure.core/case
      (clojure.core/count args13029)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13030
        listSSHPublicKeys))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13030
        listSSHPublicKeys
        (identitymanagement/list-sshpublic-keys-request
         (clojure.core/nth args13029 0))))))))
  (clojure.core/defn
   list-sshpublic-keys-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listSSHPublicKeys, listSSHPublicKeys"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-sshpublic-keys,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-sshpublic-keys,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-sshpublic-keys
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listSSHPublicKeys, listSSHPublicKeys"}
   [credentials13032 & args13033]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13034
     (com.palletops.awaze.common/aws-client :iam credentials13032)]
    (clojure.core/case
     (clojure.core/count args13033)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13034
       listSSHPublicKeys))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13034
       listSSHPublicKeys
       (identitymanagement/list-sshpublic-keys-request
        (clojure.core/nth args13033 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m13035]
   (clojure.core/let
    [credentials13036 (:credentials m13035) args13037 (:args m13035)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13038
      (com.palletops.awaze.common/aws-client :iam credentials13036)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13038
       addRoleToInstanceProfile
       (identitymanagement/add-role-to-instance-profile-request
        (clojure.core/nth args13037 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-role-to-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials13040 & args13041]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13042
     (com.palletops.awaze.common/aws-client :iam credentials13040)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13042
      addRoleToInstanceProfile
      (identitymanagement/add-role-to-instance-profile-request
       (clojure.core/nth args13041 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m13043]
   (clojure.core/let
    [credentials13044 (:credentials m13043) args13045 (:args m13043)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13046
      (com.palletops.awaze.common/aws-client :iam credentials13044)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13046
       enableMFADevice
       (identitymanagement/enable-mfadevice-request
        (clojure.core/nth args13045 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableMFADevice"}
   [credentials13048 & args13049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13050
     (com.palletops.awaze.common/aws-client :iam credentials13048)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13050
      enableMFADevice
      (identitymanagement/enable-mfadevice-request
       (clojure.core/nth args13049 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m13051]
   (clojure.core/let
    [credentials13052 (:credentials m13051) args13053 (:args m13051)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13054
      (com.palletops.awaze.common/aws-client :iam credentials13052)]
     (clojure.core/case
      (clojure.core/count args13053)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13054
        listGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13054
        listGroups
        (identitymanagement/list-groups-request
         (clojure.core/nth args13053 0))))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-groups,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-groups,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroups, listGroups"}
   [credentials13056 & args13057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13058
     (com.palletops.awaze.common/aws-client :iam credentials13056)]
    (clojure.core/case
     (clojure.core/count args13057)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13058
       listGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13058
       listGroups
       (identitymanagement/list-groups-request
        (clojure.core/nth args13057 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy-version
   [m13059]
   (clojure.core/let
    [credentials13060 (:credentials m13059) args13061 (:args m13059)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13062
      (com.palletops.awaze.common/aws-client :iam credentials13060)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13062
       deletePolicyVersion
       (identitymanagement/delete-policy-version-request
        (clojure.core/nth args13061 0)))))))
  (clojure.core/defn
   delete-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicyVersion"}
   [credentials13064 & args13065]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13066
     (com.palletops.awaze.common/aws-client :iam credentials13064)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13066
      deletePolicyVersion
      (identitymanagement/delete-policy-version-request
       (clojure.core/nth args13065 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m13067]
   (clojure.core/let
    [credentials13068 (:credentials m13067) args13069 (:args m13067)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13070
      (com.palletops.awaze.common/aws-client :iam credentials13068)]
     (clojure.core/case
      (clojure.core/count args13069)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13070
        createAccessKey))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13070
        createAccessKey
        (identitymanagement/create-access-key-request
         (clojure.core/nth args13069 0))))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-access-key,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials13072 & args13073]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13074
     (com.palletops.awaze.common/aws-client :iam credentials13072)]
    (clojure.core/case
     (clojure.core/count args13073)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13074
       createAccessKey))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13074
       createAccessKey
       (identitymanagement/create-access-key-request
        (clojure.core/nth args13073 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m13075]
   (clojure.core/let
    [credentials13076 (:credentials m13075) args13077 (:args m13075)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13078
      (com.palletops.awaze.common/aws-client :iam credentials13076)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13078
       deleteVirtualMFADevice
       (identitymanagement/delete-virtual-mfadevice-request
        (clojure.core/nth args13077 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials13080 & args13081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13082
     (com.palletops.awaze.common/aws-client :iam credentials13080)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13082
      deleteVirtualMFADevice
      (identitymanagement/delete-virtual-mfadevice-request
       (clojure.core/nth args13081 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m13083]
   (clojure.core/let
    [credentials13084 (:credentials m13083) args13085 (:args m13083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13086
      (com.palletops.awaze.common/aws-client :iam credentials13084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13086
       getInstanceProfile
       (identitymanagement/get-instance-profile-request
        (clojure.core/nth args13085 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInstanceProfile"}
   [credentials13088 & args13089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13090
     (com.palletops.awaze.common/aws-client :iam credentials13088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13090
      getInstanceProfile
      (identitymanagement/get-instance-profile-request
       (clojure.core/nth args13089 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-samlprovider
   [m13091]
   (clojure.core/let
    [credentials13092 (:credentials m13091) args13093 (:args m13091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13094
      (com.palletops.awaze.common/aws-client :iam credentials13092)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13094
       createSAMLProvider
       (identitymanagement/create-samlprovider-request
        (clojure.core/nth args13093 0)))))))
  (clojure.core/defn
   create-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSAMLProvider"}
   [credentials13096 & args13097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13098
     (com.palletops.awaze.common/aws-client :iam credentials13096)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13098
      createSAMLProvider
      (identitymanagement/create-samlprovider-request
       (clojure.core/nth args13097 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-samlprovider
   [m13099]
   (clojure.core/let
    [credentials13100 (:credentials m13099) args13101 (:args m13099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13102
      (com.palletops.awaze.common/aws-client :iam credentials13100)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13102
       updateSAMLProvider
       (identitymanagement/update-samlprovider-request
        (clojure.core/nth args13101 0)))))))
  (clojure.core/defn
   update-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSAMLProvider"}
   [credentials13104 & args13105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13106
     (com.palletops.awaze.common/aws-client :iam credentials13104)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13106
      updateSAMLProvider
      (identitymanagement/update-samlprovider-request
       (clojure.core/nth args13105 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-sshpublic-key
   [m13107]
   (clojure.core/let
    [credentials13108 (:credentials m13107) args13109 (:args m13107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13110
      (com.palletops.awaze.common/aws-client :iam credentials13108)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13110
       deleteSSHPublicKey
       (identitymanagement/delete-sshpublic-key-request
        (clojure.core/nth args13109 0)))))))
  (clojure.core/defn
   delete-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSSHPublicKey"}
   [credentials13112 & args13113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13114
     (com.palletops.awaze.common/aws-client :iam credentials13112)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13114
      deleteSSHPublicKey
      (identitymanagement/delete-sshpublic-key-request
       (clojure.core/nth args13113 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-custom-policy
   [m13115]
   (clojure.core/let
    [credentials13116 (:credentials m13115) args13117 (:args m13115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13118
      (com.palletops.awaze.common/aws-client :iam credentials13116)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13118
       simulateCustomPolicy
       (identitymanagement/simulate-custom-policy-request
        (clojure.core/nth args13117 0)))))))
  (clojure.core/defn
   simulate-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulateCustomPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :simulate-custom-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulateCustomPolicy"}
   [credentials13120 & args13121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13122
     (com.palletops.awaze.common/aws-client :iam credentials13120)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13122
      simulateCustomPolicy
      (identitymanagement/simulate-custom-policy-request
       (clojure.core/nth args13121 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-custom-policy
   [m13123]
   (clojure.core/let
    [credentials13124 (:credentials m13123) args13125 (:args m13123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13126
      (com.palletops.awaze.common/aws-client :iam credentials13124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13126
       getContextKeysForCustomPolicy
       (identitymanagement/get-context-keys-for-custom-policy-request
        (clojure.core/nth args13125 0)))))))
  (clojure.core/defn
   get-context-keys-for-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForCustomPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-custom-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForCustomPolicy"}
   [credentials13128 & args13129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13130
     (com.palletops.awaze.common/aws-client :iam credentials13128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13130
      getContextKeysForCustomPolicy
      (identitymanagement/get-context-keys-for-custom-policy-request
       (clojure.core/nth args13129 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m13131]
   (clojure.core/let
    [credentials13132 (:credentials m13131) args13133 (:args m13131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13134
      (com.palletops.awaze.common/aws-client :iam credentials13132)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13134
       listUserPolicies
       (identitymanagement/list-user-policies-request
        (clojure.core/nth args13133 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-user-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUserPolicies"}
   [credentials13136 & args13137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13138
     (com.palletops.awaze.common/aws-client :iam credentials13136)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13138
      listUserPolicies
      (identitymanagement/list-user-policies-request
       (clojure.core/nth args13137 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m13139]
   (clojure.core/let
    [credentials13140 (:credentials m13139) args13141 (:args m13139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13142
      (com.palletops.awaze.common/aws-client :iam credentials13140)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13142
       updateGroup
       (identitymanagement/update-group-request
        (clojure.core/nth args13141 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Call updateGroup"}
   [credentials13144 & args13145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13146
     (com.palletops.awaze.common/aws-client :iam credentials13144)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13146
      updateGroup
      (identitymanagement/update-group-request
       (clojure.core/nth args13145 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-entities-for-policy
   [m13147]
   (clojure.core/let
    [credentials13148 (:credentials m13147) args13149 (:args m13147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13150
      (com.palletops.awaze.common/aws-client :iam credentials13148)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13150
       listEntitiesForPolicy
       (identitymanagement/list-entities-for-policy-request
        (clojure.core/nth args13149 0)))))))
  (clojure.core/defn
   list-entities-for-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listEntitiesForPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-entities-for-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-entities-for-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listEntitiesForPolicy"}
   [credentials13152 & args13153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13154
     (com.palletops.awaze.common/aws-client :iam credentials13152)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13154
      listEntitiesForPolicy
      (identitymanagement/list-entities-for-policy-request
       (clojure.core/nth args13153 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policies
   [m13155]
   (clojure.core/let
    [credentials13156 (:credentials m13155) args13157 (:args m13155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13158
      (com.palletops.awaze.common/aws-client :iam credentials13156)]
     (clojure.core/case
      (clojure.core/count args13157)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13158
        listPolicies
        (identitymanagement/list-policies-request
         (clojure.core/nth args13157 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13158
        listPolicies))))))
  (clojure.core/defn
   list-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listPolicies, listPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-policies,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listPolicies, listPolicies"}
   [credentials13160 & args13161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13162
     (com.palletops.awaze.common/aws-client :iam credentials13160)]
    (clojure.core/case
     (clojure.core/count args13161)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13162
       listPolicies
       (identitymanagement/list-policies-request
        (clojure.core/nth args13161 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13162
       listPolicies))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m13163]
   (clojure.core/let
    [credentials13164 (:credentials m13163) args13165 (:args m13163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13166
      (com.palletops.awaze.common/aws-client :iam credentials13164)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13166
       deleteUser
       (identitymanagement/delete-user-request
        (clojure.core/nth args13165 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUser"}
   [credentials13168 & args13169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13170
     (com.palletops.awaze.common/aws-client :iam credentials13168)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13170
      deleteUser
      (identitymanagement/delete-user-request
       (clojure.core/nth args13169 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m13171]
   (clojure.core/let
    [credentials13172 (:credentials m13171) args13173 (:args m13171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13174
      (com.palletops.awaze.common/aws-client :iam credentials13172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13174
       updateSigningCertificate
       (identitymanagement/update-signing-certificate-request
        (clojure.core/nth args13173 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials13176 & args13177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13178
     (com.palletops.awaze.common/aws-client :iam credentials13176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13178
      updateSigningCertificate
      (identitymanagement/update-signing-certificate-request
       (clojure.core/nth args13177 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-principal-policy
   [m13179]
   (clojure.core/let
    [credentials13180 (:credentials m13179) args13181 (:args m13179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13182
      (com.palletops.awaze.common/aws-client :iam credentials13180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13182
       getContextKeysForPrincipalPolicy
       (identitymanagement/get-context-keys-for-principal-policy-request
        (clojure.core/nth args13181 0)))))))
  (clojure.core/defn
   get-context-keys-for-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForPrincipalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-principal-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForPrincipalPolicy"}
   [credentials13184 & args13185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13186
     (com.palletops.awaze.common/aws-client :iam credentials13184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13186
      getContextKeysForPrincipalPolicy
      (identitymanagement/get-context-keys-for-principal-policy-request
       (clojure.core/nth args13185 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m13187]
   (clojure.core/let
    [credentials13188 (:credentials m13187) args13189 (:args m13187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13190
      (com.palletops.awaze.common/aws-client :iam credentials13188)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13190
       updateServerCertificate
       (identitymanagement/update-server-certificate-request
        (clojure.core/nth args13189 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServerCertificate"}
   [credentials13192 & args13193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13194
     (com.palletops.awaze.common/aws-client :iam credentials13192)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13194
      updateServerCertificate
      (identitymanagement/update-server-certificate-request
       (clojure.core/nth args13193 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-user-policies
   [m13195]
   (clojure.core/let
    [credentials13196 (:credentials m13195) args13197 (:args m13195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13198
      (com.palletops.awaze.common/aws-client :iam credentials13196)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13198
       listAttachedUserPolicies
       (identitymanagement/list-attached-user-policies-request
        (clojure.core/nth args13197 0)))))))
  (clojure.core/defn
   list-attached-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedUserPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-user-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedUserPolicies"}
   [credentials13200 & args13201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13202
     (com.palletops.awaze.common/aws-client :iam credentials13200)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13202
      listAttachedUserPolicies
      (identitymanagement/list-attached-user-policies-request
       (clojure.core/nth args13201 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy-version
   [m13203]
   (clojure.core/let
    [credentials13204 (:credentials m13203) args13205 (:args m13203)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13206
      (com.palletops.awaze.common/aws-client :iam credentials13204)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13206
       createPolicyVersion
       (identitymanagement/create-policy-version-request
        (clojure.core/nth args13205 0)))))))
  (clojure.core/defn
   create-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Generate map for createPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Call createPolicyVersion"}
   [credentials13208 & args13209]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13210
     (com.palletops.awaze.common/aws-client :iam credentials13208)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13210
      createPolicyVersion
      (identitymanagement/create-policy-version-request
       (clojure.core/nth args13209 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m13211]
   (clojure.core/let
    [credentials13212 (:credentials m13211) args13213 (:args m13211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13214
      (com.palletops.awaze.common/aws-client :iam credentials13212)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13214
       createLoginProfile
       (identitymanagement/create-login-profile-request
        (clojure.core/nth args13213 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoginProfile"}
   [credentials13216 & args13217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13218
     (com.palletops.awaze.common/aws-client :iam credentials13216)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13218
      createLoginProfile
      (identitymanagement/create-login-profile-request
       (clojure.core/nth args13217 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-principal-policy
   [m13219]
   (clojure.core/let
    [credentials13220 (:credentials m13219) args13221 (:args m13219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13222
      (com.palletops.awaze.common/aws-client :iam credentials13220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13222
       simulatePrincipalPolicy
       (identitymanagement/simulate-principal-policy-request
        (clojure.core/nth args13221 0)))))))
  (clojure.core/defn
   simulate-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulatePrincipalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :simulate-principal-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulatePrincipalPolicy"}
   [credentials13224 & args13225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13226
     (com.palletops.awaze.common/aws-client :iam credentials13224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13226
      simulatePrincipalPolicy
      (identitymanagement/simulate-principal-policy-request
       (clojure.core/nth args13225 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-open-idconnect-provider
   [m13227]
   (clojure.core/let
    [credentials13228 (:credentials m13227) args13229 (:args m13227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13230
      (com.palletops.awaze.common/aws-client :iam credentials13228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13230
       createOpenIDConnectProvider
       (identitymanagement/create-open-idconnect-provider-request
        (clojure.core/nth args13229 0)))))))
  (clojure.core/defn
   create-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Call createOpenIDConnectProvider"}
   [credentials13232 & args13233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13234
     (com.palletops.awaze.common/aws-client :iam credentials13232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13234
      createOpenIDConnectProvider
      (identitymanagement/create-open-idconnect-provider-request
       (clojure.core/nth args13233 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-role-policy
   [m13235]
   (clojure.core/let
    [credentials13236 (:credentials m13235) args13237 (:args m13235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13238
      (com.palletops.awaze.common/aws-client :iam credentials13236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13238
       attachRolePolicy
       (identitymanagement/attach-role-policy-request
        (clojure.core/nth args13237 0)))))))
  (clojure.core/defn
   attach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachRolePolicy"}
   [credentials13240 & args13241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13242
     (com.palletops.awaze.common/aws-client :iam credentials13240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13242
      attachRolePolicy
      (identitymanagement/attach-role-policy-request
       (clojure.core/nth args13241 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m13243]
   (clojure.core/let
    [credentials13244 (:credentials m13243) args13245 (:args m13243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13246
      (com.palletops.awaze.common/aws-client :iam credentials13244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13246
       getGroupPolicy
       (identitymanagement/get-group-policy-request
        (clojure.core/nth args13245 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroupPolicy"}
   [credentials13248 & args13249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13250
     (com.palletops.awaze.common/aws-client :iam credentials13248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13250
      getGroupPolicy
      (identitymanagement/get-group-policy-request
       (clojure.core/nth args13249 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-user-policy
   [m13251]
   (clojure.core/let
    [credentials13252 (:credentials m13251) args13253 (:args m13251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13254
      (com.palletops.awaze.common/aws-client :iam credentials13252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13254
       detachUserPolicy
       (identitymanagement/detach-user-policy-request
        (clojure.core/nth args13253 0)))))))
  (clojure.core/defn
   detach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachUserPolicy"}
   [credentials13256 & args13257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13258
     (com.palletops.awaze.common/aws-client :iam credentials13256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13258
      detachUserPolicy
      (identitymanagement/detach-user-policy-request
       (clojure.core/nth args13257 0))))))))
