(ns
 com.palletops.awaze.glacier
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.glacier :as glacier]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :glacier
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.glacier.AmazonGlacierClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InventoryRetrievalJobInput}
inventory-retrieval-job-input
  [m5763]
  (clojure.core/let
   [bean5762
    (new
     com.amazonaws.services.glacier.model.InventoryRetrievalJobInput)]
   (clojure.core/let
    [v5764 (:limit m5763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5764 :com.palletops.awaze.client-builder/undef)
     (. bean5762 setLimit (clojure.core/str v5764))))
   (clojure.core/let
    [v5764
     (:start-date m5763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5764 :com.palletops.awaze.client-builder/undef)
     (. bean5762 setStartDate (clojure.core/str v5764))))
   (clojure.core/let
    [v5764
     (:end-date m5763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5764 :com.palletops.awaze.client-builder/undef)
     (. bean5762 setEndDate (clojure.core/str v5764))))
   (clojure.core/let
    [v5764 (:marker m5763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5764 :com.palletops.awaze.client-builder/undef)
     (. bean5762 setMarker (clojure.core/str v5764))))
   bean5762))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DataRetrievalRule}
data-retrieval-rule
  [m5766]
  (clojure.core/let
   [bean5765
    (new com.amazonaws.services.glacier.model.DataRetrievalRule)]
   (clojure.core/let
    [v5767
     (:bytes-per-hour m5766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5767 :com.palletops.awaze.client-builder/undef)
     (. bean5765 setBytesPerHour (clojure.core/long v5767))))
   (clojure.core/let
    [v5767
     (:strategy m5766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5767 :com.palletops.awaze.client-builder/undef)
     (. bean5765 setStrategy (clojure.core/str v5767))))
   bean5765))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.JobParameters}
job-parameters
  [m5769]
  (clojure.core/let
   [bean5768 (new com.amazonaws.services.glacier.model.JobParameters)]
   (clojure.core/let
    [v5770 (:format m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setFormat (clojure.core/str v5770))))
   (clojure.core/let
    [v5770
     (:description m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setDescription (clojure.core/str v5770))))
   (clojure.core/let
    [v5770 (:type m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setType (clojure.core/str v5770))))
   (clojure.core/let
    [v5770
     (:archive-id m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setArchiveId (clojure.core/str v5770))))
   (clojure.core/let
    [v5770
     (:snstopic m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setSNSTopic (clojure.core/str v5770))))
   (clojure.core/let
    [v5770
     (:retrieval-byte-range
      m5769
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setRetrievalByteRange (clojure.core/str v5770))))
   (clojure.core/let
    [v5770
     (:inventory-retrieval-parameters
      m5769
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (.
      bean5768
      setInventoryRetrievalParameters
      (glacier/inventory-retrieval-job-input v5770))))
   bean5768))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultNotificationConfig}
vault-notification-config
  [m5772]
  (clojure.core/let
   [bean5771
    (new com.amazonaws.services.glacier.model.VaultNotificationConfig)]
   (clojure.core/let
    [v5773 (:events m5772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5773 :com.palletops.awaze.client-builder/undef)
     (.
      bean5771
      setEvents
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5876] (clojure.core/str arg5876))
 v5773))))
   (clojure.core/let
    [v5773
     (:snstopic m5772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5773 :com.palletops.awaze.client-builder/undef)
     (. bean5771 setSNSTopic (clojure.core/str v5773))))
   bean5771))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultAccessPolicy}
vault-access-policy
  [m5775]
  (clojure.core/let
   [bean5774
    (new com.amazonaws.services.glacier.model.VaultAccessPolicy)]
   (clojure.core/let
    [v5776 (:policy m5775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5776 :com.palletops.awaze.client-builder/undef)
     (. bean5774 setPolicy (clojure.core/str v5776))))
   bean5774))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultLockPolicy}
vault-lock-policy
  [m5778]
  (clojure.core/let
   [bean5777
    (new com.amazonaws.services.glacier.model.VaultLockPolicy)]
   (clojure.core/let
    [v5779 (:policy m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setPolicy (clojure.core/str v5779))))
   bean5777))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DataRetrievalPolicy}
data-retrieval-policy
  [m5781]
  (clojure.core/let
   [bean5780
    (new com.amazonaws.services.glacier.model.DataRetrievalPolicy)]
   (clojure.core/let
    [v5782 (:rules m5781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5782 :com.palletops.awaze.client-builder/undef)
     (.
      bean5780
      setRules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5877] (glacier/data-retrieval-rule arg5877))
 v5782))))
   bean5780))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m5784]
  (clojure.core/let
   [bean5783
    (new
     com.amazonaws.services.glacier.model.ListMultipartUploadsRequest)]
   (clojure.core/let
    [v5785 (:limit m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setLimit (clojure.core/str v5785))))
   (clojure.core/let
    [v5785
     (:account-id m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setAccountId (clojure.core/str v5785))))
   (clojure.core/let
    [v5785
     (:upload-id-marker
      m5784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setUploadIdMarker (clojure.core/str v5785))))
   (clojure.core/let
    [v5785
     (:vault-name m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setVaultName (clojure.core/str v5785))))
   bean5783))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultRequest}
delete-vault-request
  [m5787]
  (clojure.core/let
   [bean5786
    (new com.amazonaws.services.glacier.model.DeleteVaultRequest)]
   (clojure.core/let
    [v5788
     (:account-id m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setAccountId (clojure.core/str v5788))))
   (clojure.core/let
    [v5788
     (:vault-name m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setVaultName (clojure.core/str v5788))))
   bean5786))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteVaultLockRequest}
complete-vault-lock-request
  [m5790]
  (clojure.core/let
   [bean5789
    (new
     com.amazonaws.services.glacier.model.CompleteVaultLockRequest)]
   (clojure.core/let
    [v5791
     (:account-id m5790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5791 :com.palletops.awaze.client-builder/undef)
     (. bean5789 setAccountId (clojure.core/str v5791))))
   (clojure.core/let
    [v5791
     (:vault-name m5790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5791 :com.palletops.awaze.client-builder/undef)
     (. bean5789 setVaultName (clojure.core/str v5791))))
   (clojure.core/let
    [v5791 (:lock-id m5790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5791 :com.palletops.awaze.client-builder/undef)
     (. bean5789 setLockId (clojure.core/str v5791))))
   bean5789))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest}
delete-vault-notifications-request
  [m5793]
  (clojure.core/let
   [bean5792
    (new
     com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest)]
   (clojure.core/let
    [v5794
     (:account-id m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setAccountId (clojure.core/str v5794))))
   (clojure.core/let
    [v5794
     (:vault-name m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setVaultName (clojure.core/str v5794))))
   bean5792))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest}
delete-vault-access-policy-request
  [m5796]
  (clojure.core/let
   [bean5795
    (new
     com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5797
     (:account-id m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setAccountId (clojure.core/str v5797))))
   (clojure.core/let
    [v5797
     (:vault-name m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setVaultName (clojure.core/str v5797))))
   bean5795))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest}
remove-tags-from-vault-request
  [m5799]
  (clojure.core/let
   [bean5798
    (new
     com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest)]
   (clojure.core/let
    [v5800
     (:account-id m5799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5800 :com.palletops.awaze.client-builder/undef)
     (. bean5798 setAccountId (clojure.core/str v5800))))
   (clojure.core/let
    [v5800
     (:vault-name m5799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5800 :com.palletops.awaze.client-builder/undef)
     (. bean5798 setVaultName (clojure.core/str v5800))))
   (clojure.core/let
    [v5800
     (:tag-keys m5799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5800 :com.palletops.awaze.client-builder/undef)
     (.
      bean5798
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5878] (clojure.core/str arg5878))
 v5800))))
   bean5798))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m5802]
  (clojure.core/let
   [bean5801
    (new
     com.amazonaws.services.glacier.model.AbortMultipartUploadRequest)]
   (clojure.core/let
    [v5803
     (:account-id m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setAccountId (clojure.core/str v5803))))
   (clojure.core/let
    [v5803
     (:vault-name m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setVaultName (clojure.core/str v5803))))
   (clojure.core/let
    [v5803
     (:upload-id m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setUploadId (clojure.core/str v5803))))
   bean5801))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadMultipartPartRequest}
upload-multipart-part-request
  [m5805]
  (clojure.core/let
   [bean5804
    (new
     com.amazonaws.services.glacier.model.UploadMultipartPartRequest)]
   (clojure.core/let
    [v5806
     (:account-id m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setAccountId (clojure.core/str v5806))))
   (clojure.core/let
    [v5806
     (:vault-name m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setVaultName (clojure.core/str v5806))))
   (clojure.core/let
    [v5806
     (:checksum m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setChecksum (clojure.core/str v5806))))
   (clojure.core/let
    [v5806 (:range m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setRange (clojure.core/str v5806))))
   (clojure.core/let
    [v5806
     (:upload-id m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setUploadId (clojure.core/str v5806))))
   (clojure.core/let
    [v5806 (:body m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setBody (clojure.java.io/input-stream v5806))))
   bean5804))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListVaultsRequest}
list-vaults-request
  [m5808]
  (clojure.core/let
   [bean5807
    (new com.amazonaws.services.glacier.model.ListVaultsRequest)]
   (clojure.core/let
    [v5809 (:limit m5808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (. bean5807 setLimit (clojure.core/str v5809))))
   (clojure.core/let
    [v5809 (:marker m5808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (. bean5807 setMarker (clojure.core/str v5809))))
   (clojure.core/let
    [v5809
     (:account-id m5808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (. bean5807 setAccountId (clojure.core/str v5809))))
   bean5807))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateJobRequest}
initiate-job-request
  [m5811]
  (clojure.core/let
   [bean5810
    (new com.amazonaws.services.glacier.model.InitiateJobRequest)]
   (clojure.core/let
    [v5812
     (:account-id m5811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5812 :com.palletops.awaze.client-builder/undef)
     (. bean5810 setAccountId (clojure.core/str v5812))))
   (clojure.core/let
    [v5812
     (:job-parameters m5811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5812 :com.palletops.awaze.client-builder/undef)
     (. bean5810 setJobParameters (glacier/job-parameters v5812))))
   (clojure.core/let
    [v5812
     (:vault-name m5811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5812 :com.palletops.awaze.client-builder/undef)
     (. bean5810 setVaultName (clojure.core/str v5812))))
   bean5810))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListPartsRequest}
list-parts-request
  [m5814]
  (clojure.core/let
   [bean5813
    (new com.amazonaws.services.glacier.model.ListPartsRequest)]
   (clojure.core/let
    [v5815 (:limit m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setLimit (clojure.core/str v5815))))
   (clojure.core/let
    [v5815 (:marker m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setMarker (clojure.core/str v5815))))
   (clojure.core/let
    [v5815
     (:account-id m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setAccountId (clojure.core/str v5815))))
   (clojure.core/let
    [v5815
     (:vault-name m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setVaultName (clojure.core/str v5815))))
   (clojure.core/let
    [v5815
     (:upload-id m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setUploadId (clojure.core/str v5815))))
   bean5813))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultNotificationsRequest}
get-vault-notifications-request
  [m5817]
  (clojure.core/let
   [bean5816
    (new
     com.amazonaws.services.glacier.model.GetVaultNotificationsRequest)]
   (clojure.core/let
    [v5818
     (:account-id m5817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5818 :com.palletops.awaze.client-builder/undef)
     (. bean5816 setAccountId (clojure.core/str v5818))))
   (clojure.core/let
    [v5818
     (:vault-name m5817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5818 :com.palletops.awaze.client-builder/undef)
     (. bean5816 setVaultName (clojure.core/str v5818))))
   bean5816))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetJobOutputRequest}
get-job-output-request
  [m5820]
  (clojure.core/let
   [bean5819
    (new com.amazonaws.services.glacier.model.GetJobOutputRequest)]
   (clojure.core/let
    [v5821
     (:account-id m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setAccountId (clojure.core/str v5821))))
   (clojure.core/let
    [v5821 (:job-id m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setJobId (clojure.core/str v5821))))
   (clojure.core/let
    [v5821
     (:vault-name m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setVaultName (clojure.core/str v5821))))
   (clojure.core/let
    [v5821 (:range m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setRange (clojure.core/str v5821))))
   bean5819))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeJobRequest}
describe-job-request
  [m5823]
  (clojure.core/let
   [bean5822
    (new com.amazonaws.services.glacier.model.DescribeJobRequest)]
   (clojure.core/let
    [v5824
     (:account-id m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setAccountId (clojure.core/str v5824))))
   (clojure.core/let
    [v5824 (:job-id m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setJobId (clojure.core/str v5824))))
   (clojure.core/let
    [v5824
     (:vault-name m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setVaultName (clojure.core/str v5824))))
   bean5822))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultNotificationsRequest}
set-vault-notifications-request
  [m5826]
  (clojure.core/let
   [bean5825
    (new
     com.amazonaws.services.glacier.model.SetVaultNotificationsRequest)]
   (clojure.core/let
    [v5827
     (:account-id m5826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5827 :com.palletops.awaze.client-builder/undef)
     (. bean5825 setAccountId (clojure.core/str v5827))))
   (clojure.core/let
    [v5827
     (:vault-name m5826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5827 :com.palletops.awaze.client-builder/undef)
     (. bean5825 setVaultName (clojure.core/str v5827))))
   (clojure.core/let
    [v5827
     (:vault-notification-config
      m5826
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5827 :com.palletops.awaze.client-builder/undef)
     (.
      bean5825
      setVaultNotificationConfig
      (glacier/vault-notification-config v5827))))
   bean5825))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeVaultRequest}
describe-vault-request
  [m5829]
  (clojure.core/let
   [bean5828
    (new com.amazonaws.services.glacier.model.DescribeVaultRequest)]
   (clojure.core/let
    [v5830
     (:account-id m5829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5830 :com.palletops.awaze.client-builder/undef)
     (. bean5828 setAccountId (clojure.core/str v5830))))
   (clojure.core/let
    [v5830
     (:vault-name m5829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5830 :com.palletops.awaze.client-builder/undef)
     (. bean5828 setVaultName (clojure.core/str v5830))))
   bean5828))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortVaultLockRequest}
abort-vault-lock-request
  [m5832]
  (clojure.core/let
   [bean5831
    (new com.amazonaws.services.glacier.model.AbortVaultLockRequest)]
   (clojure.core/let
    [v5833
     (:account-id m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setAccountId (clojure.core/str v5833))))
   (clojure.core/let
    [v5833
     (:vault-name m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setVaultName (clojure.core/str v5833))))
   bean5831))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AddTagsToVaultRequest}
add-tags-to-vault-request
  [m5835]
  (clojure.core/let
   [bean5834
    (new com.amazonaws.services.glacier.model.AddTagsToVaultRequest)]
   (clojure.core/let
    [v5836
     (:account-id m5835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (. bean5834 setAccountId (clojure.core/str v5836))))
   (clojure.core/let
    [v5836
     (:vault-name m5835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (. bean5834 setVaultName (clojure.core/str v5836))))
   (clojure.core/let
    [v5836 (:tags m5835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (.
      bean5834
      setTags
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg5879] (clojure.core/str arg5879))
  (clojure.core/keys v5836))
 (clojure.core/map
  (clojure.core/fn [arg5879] (clojure.core/str arg5879))
  (clojure.core/vals v5836))))))
   bean5834))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest}
set-vault-access-policy-request
  [m5838]
  (clojure.core/let
   [bean5837
    (new
     com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5839 (:policy m5838 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5839 :com.palletops.awaze.client-builder/undef)
     (. bean5837 setPolicy (glacier/vault-access-policy v5839))))
   (clojure.core/let
    [v5839
     (:account-id m5838 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5839 :com.palletops.awaze.client-builder/undef)
     (. bean5837 setAccountId (clojure.core/str v5839))))
   (clojure.core/let
    [v5839
     (:vault-name m5838 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5839 :com.palletops.awaze.client-builder/undef)
     (. bean5837 setVaultName (clojure.core/str v5839))))
   bean5837))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m5841]
  (clojure.core/let
   [bean5840
    (new
     com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v5842
     (:account-id m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setAccountId (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:vault-name m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setVaultName (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:checksum m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setChecksum (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:archive-size m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setArchiveSize (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:upload-id m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setUploadId (clojure.core/str v5842))))
   bean5840))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest}
get-data-retrieval-policy-request
  [m5844]
  (clojure.core/let
   [bean5843
    (new
     com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest)]
   (clojure.core/let
    [v5845
     (:account-id m5844 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5845 :com.palletops.awaze.client-builder/undef)
     (. bean5843 setAccountId (clojure.core/str v5845))))
   bean5843))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateVaultLockRequest}
initiate-vault-lock-request
  [m5847]
  (clojure.core/let
   [bean5846
    (new
     com.amazonaws.services.glacier.model.InitiateVaultLockRequest)]
   (clojure.core/let
    [v5848 (:policy m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setPolicy (glacier/vault-lock-policy v5848))))
   (clojure.core/let
    [v5848
     (:account-id m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setAccountId (clojure.core/str v5848))))
   (clojure.core/let
    [v5848
     (:vault-name m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setVaultName (clojure.core/str v5848))))
   bean5846))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteArchiveRequest}
delete-archive-request
  [m5850]
  (clojure.core/let
   [bean5849
    (new com.amazonaws.services.glacier.model.DeleteArchiveRequest)]
   (clojure.core/let
    [v5851
     (:account-id m5850 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5851 :com.palletops.awaze.client-builder/undef)
     (. bean5849 setAccountId (clojure.core/str v5851))))
   (clojure.core/let
    [v5851
     (:vault-name m5850 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5851 :com.palletops.awaze.client-builder/undef)
     (. bean5849 setVaultName (clojure.core/str v5851))))
   (clojure.core/let
    [v5851
     (:archive-id m5850 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5851 :com.palletops.awaze.client-builder/undef)
     (. bean5849 setArchiveId (clojure.core/str v5851))))
   bean5849))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest}
set-data-retrieval-policy-request
  [m5853]
  (clojure.core/let
   [bean5852
    (new
     com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest)]
   (clojure.core/let
    [v5854 (:policy m5853 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5854 :com.palletops.awaze.client-builder/undef)
     (. bean5852 setPolicy (glacier/data-retrieval-policy v5854))))
   (clojure.core/let
    [v5854
     (:account-id m5853 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5854 :com.palletops.awaze.client-builder/undef)
     (. bean5852 setAccountId (clojure.core/str v5854))))
   bean5852))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultLockRequest}
get-vault-lock-request
  [m5856]
  (clojure.core/let
   [bean5855
    (new com.amazonaws.services.glacier.model.GetVaultLockRequest)]
   (clojure.core/let
    [v5857
     (:account-id m5856 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5857 :com.palletops.awaze.client-builder/undef)
     (. bean5855 setAccountId (clojure.core/str v5857))))
   (clojure.core/let
    [v5857
     (:vault-name m5856 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5857 :com.palletops.awaze.client-builder/undef)
     (. bean5855 setVaultName (clojure.core/str v5857))))
   bean5855))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListJobsRequest}
list-jobs-request
  [m5859]
  (clojure.core/let
   [bean5858
    (new com.amazonaws.services.glacier.model.ListJobsRequest)]
   (clojure.core/let
    [v5860 (:limit m5859 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5860 :com.palletops.awaze.client-builder/undef)
     (. bean5858 setLimit (clojure.core/str v5860))))
   (clojure.core/let
    [v5860 (:marker m5859 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5860 :com.palletops.awaze.client-builder/undef)
     (. bean5858 setMarker (clojure.core/str v5860))))
   (clojure.core/let
    [v5860
     (:account-id m5859 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5860 :com.palletops.awaze.client-builder/undef)
     (. bean5858 setAccountId (clojure.core/str v5860))))
   (clojure.core/let
    [v5860
     (:vault-name m5859 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5860 :com.palletops.awaze.client-builder/undef)
     (. bean5858 setVaultName (clojure.core/str v5860))))
   (clojure.core/let
    [v5860
     (:statuscode m5859 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5860 :com.palletops.awaze.client-builder/undef)
     (. bean5858 setStatuscode (clojure.core/str v5860))))
   (clojure.core/let
    [v5860
     (:completed m5859 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5860 :com.palletops.awaze.client-builder/undef)
     (. bean5858 setCompleted (clojure.core/str v5860))))
   bean5858))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m5862]
  (clojure.core/let
   [bean5861
    (new
     com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest)]
   (clojure.core/let
    [v5863
     (:account-id m5862 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5863 :com.palletops.awaze.client-builder/undef)
     (. bean5861 setAccountId (clojure.core/str v5863))))
   (clojure.core/let
    [v5863
     (:archive-description
      m5862
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5863 :com.palletops.awaze.client-builder/undef)
     (. bean5861 setArchiveDescription (clojure.core/str v5863))))
   (clojure.core/let
    [v5863
     (:part-size m5862 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5863 :com.palletops.awaze.client-builder/undef)
     (. bean5861 setPartSize (clojure.core/str v5863))))
   (clojure.core/let
    [v5863
     (:vault-name m5862 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5863 :com.palletops.awaze.client-builder/undef)
     (. bean5861 setVaultName (clojure.core/str v5863))))
   bean5861))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListTagsForVaultRequest}
list-tags-for-vault-request
  [m5865]
  (clojure.core/let
   [bean5864
    (new com.amazonaws.services.glacier.model.ListTagsForVaultRequest)]
   (clojure.core/let
    [v5866
     (:account-id m5865 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5866 :com.palletops.awaze.client-builder/undef)
     (. bean5864 setAccountId (clojure.core/str v5866))))
   (clojure.core/let
    [v5866
     (:vault-name m5865 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5866 :com.palletops.awaze.client-builder/undef)
     (. bean5864 setVaultName (clojure.core/str v5866))))
   bean5864))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CreateVaultRequest}
create-vault-request
  [m5868]
  (clojure.core/let
   [bean5867
    (new com.amazonaws.services.glacier.model.CreateVaultRequest)]
   (clojure.core/let
    [v5869
     (:account-id m5868 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5869 :com.palletops.awaze.client-builder/undef)
     (. bean5867 setAccountId (clojure.core/str v5869))))
   (clojure.core/let
    [v5869
     (:vault-name m5868 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5869 :com.palletops.awaze.client-builder/undef)
     (. bean5867 setVaultName (clojure.core/str v5869))))
   bean5867))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest}
get-vault-access-policy-request
  [m5871]
  (clojure.core/let
   [bean5870
    (new
     com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5872
     (:account-id m5871 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5872 :com.palletops.awaze.client-builder/undef)
     (. bean5870 setAccountId (clojure.core/str v5872))))
   (clojure.core/let
    [v5872
     (:vault-name m5871 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5872 :com.palletops.awaze.client-builder/undef)
     (. bean5870 setVaultName (clojure.core/str v5872))))
   bean5870))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadArchiveRequest}
upload-archive-request
  [m5874]
  (clojure.core/let
   [bean5873
    (new com.amazonaws.services.glacier.model.UploadArchiveRequest)]
   (clojure.core/let
    [v5875
     (:content-length m5874 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5875 :com.palletops.awaze.client-builder/undef)
     (. bean5873 setContentLength (clojure.core/long v5875))))
   (clojure.core/let
    [v5875
     (:account-id m5874 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5875 :com.palletops.awaze.client-builder/undef)
     (. bean5873 setAccountId (clojure.core/str v5875))))
   (clojure.core/let
    [v5875
     (:archive-description
      m5874
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5875 :com.palletops.awaze.client-builder/undef)
     (. bean5873 setArchiveDescription (clojure.core/str v5875))))
   (clojure.core/let
    [v5875
     (:vault-name m5874 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5875 :com.palletops.awaze.client-builder/undef)
     (. bean5873 setVaultName (clojure.core/str v5875))))
   (clojure.core/let
    [v5875
     (:checksum m5874 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5875 :com.palletops.awaze.client-builder/undef)
     (. bean5873 setChecksum (clojure.core/str v5875))))
   (clojure.core/let
    [v5875 (:body m5874 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5875 :com.palletops.awaze.client-builder/undef)
     (. bean5873 setBody (clojure.java.io/input-stream v5875))))
   bean5873))
 (clojure.core/defmulti
  glacier
  (clojure.core/fn glacier [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   glacier
   :list-multipart-uploads
   [m5880]
   (clojure.core/let
    [credentials5881 (:credentials m5880) args5882 (:args m5880)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5883
      (com.palletops.awaze.common/aws-client :glacier credentials5881)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5883
       listMultipartUploads
       (glacier/list-multipart-uploads-request
        (clojure.core/nth args5882 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         upload-id-marker
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         upload-id-marker
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listMultipartUploads"}
   [credentials5885 & args5886]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5887
     (com.palletops.awaze.common/aws-client :glacier credentials5885)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5887
      listMultipartUploads
      (glacier/list-multipart-uploads-request
       (clojure.core/nth args5886 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault
   [m5888]
   (clojure.core/let
    [credentials5889 (:credentials m5888) args5890 (:args m5888)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5891
      (com.palletops.awaze.common/aws-client :glacier credentials5889)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5891
       deleteVault
       (glacier/delete-vault-request (clojure.core/nth args5890 0)))))))
  (clojure.core/defn
   delete-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVault"}
   [credentials5893 & args5894]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5895
     (com.palletops.awaze.common/aws-client :glacier credentials5893)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5895
      deleteVault
      (glacier/delete-vault-request (clojure.core/nth args5894 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-vault-lock
   [m5896]
   (clojure.core/let
    [credentials5897 (:credentials m5896) args5898 (:args m5896)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5899
      (com.palletops.awaze.common/aws-client :glacier credentials5897)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5899
       completeVaultLock
       (glacier/complete-vault-lock-request
        (clojure.core/nth args5898 0)))))))
  (clojure.core/defn
   complete-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         lock-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for completeVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   complete-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         lock-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call completeVaultLock"}
   [credentials5901 & args5902]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5903
     (com.palletops.awaze.common/aws-client :glacier credentials5901)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5903
      completeVaultLock
      (glacier/complete-vault-lock-request
       (clojure.core/nth args5902 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-notifications
   [m5904]
   (clojure.core/let
    [credentials5905 (:credentials m5904) args5906 (:args m5904)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5907
      (com.palletops.awaze.common/aws-client :glacier credentials5905)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5907
       deleteVaultNotifications
       (glacier/delete-vault-notifications-request
        (clojure.core/nth args5906 0)))))))
  (clojure.core/defn
   delete-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVaultNotifications"}
   [credentials5909 & args5910]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5911
     (com.palletops.awaze.common/aws-client :glacier credentials5909)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5911
      deleteVaultNotifications
      (glacier/delete-vault-notifications-request
       (clojure.core/nth args5910 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-access-policy
   [m5912]
   (clojure.core/let
    [credentials5913 (:credentials m5912) args5914 (:args m5912)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5915
      (com.palletops.awaze.common/aws-client :glacier credentials5913)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5915
       deleteVaultAccessPolicy
       (glacier/delete-vault-access-policy-request
        (clojure.core/nth args5914 0)))))))
  (clojure.core/defn
   delete-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVaultAccessPolicy"}
   [credentials5917 & args5918]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5919
     (com.palletops.awaze.common/aws-client :glacier credentials5917)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5919
      deleteVaultAccessPolicy
      (glacier/delete-vault-access-policy-request
       (clojure.core/nth args5918 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :remove-tags-from-vault
   [m5920]
   (clojure.core/let
    [credentials5921 (:credentials m5920) args5922 (:args m5920)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5923
      (com.palletops.awaze.common/aws-client :glacier credentials5921)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5923
       removeTagsFromVault
       (glacier/remove-tags-from-vault-request
        (clojure.core/nth args5922 0)))))))
  (clojure.core/defn
   remove-tags-from-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         tag-keys
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   remove-tags-from-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         tag-keys
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromVault"}
   [credentials5925 & args5926]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5927
     (com.palletops.awaze.common/aws-client :glacier credentials5925)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5927
      removeTagsFromVault
      (glacier/remove-tags-from-vault-request
       (clojure.core/nth args5926 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-multipart-upload
   [m5928]
   (clojure.core/let
    [credentials5929 (:credentials m5928) args5930 (:args m5928)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5931
      (com.palletops.awaze.common/aws-client :glacier credentials5929)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5931
       abortMultipartUpload
       (glacier/abort-multipart-upload-request
        (clojure.core/nth args5930 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials5933 & args5934]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5935
     (com.palletops.awaze.common/aws-client :glacier credentials5933)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5935
      abortMultipartUpload
      (glacier/abort-multipart-upload-request
       (clojure.core/nth args5934 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-multipart-part
   [m5936]
   (clojure.core/let
    [credentials5937 (:credentials m5936) args5938 (:args m5936)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5939
      (com.palletops.awaze.common/aws-client :glacier credentials5937)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5939
       uploadMultipartPart
       (glacier/upload-multipart-part-request
        (clojure.core/nth args5938 0)))))))
  (clojure.core/defn
   upload-multipart-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root
                         range]}]]),
    :doc "Generate map for uploadMultipartPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-multipart-part,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   upload-multipart-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root
                         range]}]]),
    :doc "Call uploadMultipartPart"}
   [credentials5941 & args5942]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5943
     (com.palletops.awaze.common/aws-client :glacier credentials5941)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5943
      uploadMultipartPart
      (glacier/upload-multipart-part-request
       (clojure.core/nth args5942 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-vaults
   [m5944]
   (clojure.core/let
    [credentials5945 (:credentials m5944) args5946 (:args m5944)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5947
      (com.palletops.awaze.common/aws-client :glacier credentials5945)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5947
       listVaults
       (glacier/list-vaults-request (clojure.core/nth args5946 0)))))))
  (clojure.core/defn
   list-vaults-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVaults"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-vaults,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-vaults
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVaults"}
   [credentials5949 & args5950]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5951
     (com.palletops.awaze.common/aws-client :glacier credentials5949)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5951
      listVaults
      (glacier/list-vaults-request (clojure.core/nth args5950 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-job
   [m5952]
   (clojure.core/let
    [credentials5953 (:credentials m5952) args5954 (:args m5952)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5955
      (com.palletops.awaze.common/aws-client :glacier credentials5953)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5955
       initiateJob
       (glacier/initiate-job-request (clojure.core/nth args5954 0)))))))
  (clojure.core/defn
   initiate-job-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         job-parameters]}]]),
    :doc "Generate map for initiateJob"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-job,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-job
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         job-parameters]}]]),
    :doc "Call initiateJob"}
   [credentials5957 & args5958]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5959
     (com.palletops.awaze.common/aws-client :glacier credentials5957)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5959
      initiateJob
      (glacier/initiate-job-request (clojure.core/nth args5958 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-parts
   [m5960]
   (clojure.core/let
    [credentials5961 (:credentials m5960) args5962 (:args m5960)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5963
      (com.palletops.awaze.common/aws-client :glacier credentials5961)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5963
       listParts
       (glacier/list-parts-request (clojure.core/nth args5962 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listParts"}
   [credentials5965 & args5966]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5967
     (com.palletops.awaze.common/aws-client :glacier credentials5965)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5967
      listParts
      (glacier/list-parts-request (clojure.core/nth args5966 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-notifications
   [m5968]
   (clojure.core/let
    [credentials5969 (:credentials m5968) args5970 (:args m5968)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5971
      (com.palletops.awaze.common/aws-client :glacier credentials5969)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5971
       getVaultNotifications
       (glacier/get-vault-notifications-request
        (clojure.core/nth args5970 0)))))))
  (clojure.core/defn
   get-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultNotifications"}
   [credentials5973 & args5974]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5975
     (com.palletops.awaze.common/aws-client :glacier credentials5973)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5975
      getVaultNotifications
      (glacier/get-vault-notifications-request
       (clojure.core/nth args5974 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-job-output
   [m5976]
   (clojure.core/let
    [credentials5977 (:credentials m5976) args5978 (:args m5976)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5979
      (com.palletops.awaze.common/aws-client :glacier credentials5977)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5979
       getJobOutput
       (glacier/get-job-output-request (clojure.core/nth args5978 0)))))))
  (clojure.core/defn
   get-job-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         range]}]]),
    :doc "Generate map for getJobOutput"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-job-output,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-job-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         range]}]]),
    :doc "Call getJobOutput"}
   [credentials5981 & args5982]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5983
     (com.palletops.awaze.common/aws-client :glacier credentials5981)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5983
      getJobOutput
      (glacier/get-job-output-request (clojure.core/nth args5982 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-job
   [m5984]
   (clojure.core/let
    [credentials5985 (:credentials m5984) args5986 (:args m5984)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5987
      (com.palletops.awaze.common/aws-client :glacier credentials5985)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5987
       describeJob
       (glacier/describe-job-request (clojure.core/nth args5986 0)))))))
  (clojure.core/defn
   describe-job-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeJob"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-job,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   describe-job
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeJob"}
   [credentials5989 & args5990]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5991
     (com.palletops.awaze.common/aws-client :glacier credentials5989)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5991
      describeJob
      (glacier/describe-job-request (clojure.core/nth args5990 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-notifications
   [m5992]
   (clojure.core/let
    [credentials5993 (:credentials m5992) args5994 (:args m5992)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5995
      (com.palletops.awaze.common/aws-client :glacier credentials5993)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5995
       setVaultNotifications
       (glacier/set-vault-notifications-request
        (clojure.core/nth args5994 0)))))))
  (clojure.core/defn
   set-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vault-notification-config
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vault-notification-config
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVaultNotifications"}
   [credentials5997 & args5998]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5999
     (com.palletops.awaze.common/aws-client :glacier credentials5997)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5999
      setVaultNotifications
      (glacier/set-vault-notifications-request
       (clojure.core/nth args5998 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-vault
   [m6000]
   (clojure.core/let
    [credentials6001 (:credentials m6000) args6002 (:args m6000)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6003
      (com.palletops.awaze.common/aws-client :glacier credentials6001)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6003
       describeVault
       (glacier/describe-vault-request (clojure.core/nth args6002 0)))))))
  (clojure.core/defn
   describe-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   describe-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVault"}
   [credentials6005 & args6006]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6007
     (com.palletops.awaze.common/aws-client :glacier credentials6005)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6007
      describeVault
      (glacier/describe-vault-request (clojure.core/nth args6006 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-vault-lock
   [m6008]
   (clojure.core/let
    [credentials6009 (:credentials m6008) args6010 (:args m6008)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6011
      (com.palletops.awaze.common/aws-client :glacier credentials6009)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6011
       abortVaultLock
       (glacier/abort-vault-lock-request
        (clojure.core/nth args6010 0)))))))
  (clojure.core/defn
   abort-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for abortVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   abort-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call abortVaultLock"}
   [credentials6013 & args6014]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6015
     (com.palletops.awaze.common/aws-client :glacier credentials6013)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6015
      abortVaultLock
      (glacier/abort-vault-lock-request (clojure.core/nth args6014 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :add-tags-to-vault
   [m6016]
   (clojure.core/let
    [credentials6017 (:credentials m6016) args6018 (:args m6016)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6019
      (com.palletops.awaze.common/aws-client :glacier credentials6017)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6019
       addTagsToVault
       (glacier/add-tags-to-vault-request
        (clojure.core/nth args6018 0)))))))
  (clojure.core/defn
   add-tags-to-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   add-tags-to-vault
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToVault"}
   [credentials6021 & args6022]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6023
     (com.palletops.awaze.common/aws-client :glacier credentials6021)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6023
      addTagsToVault
      (glacier/add-tags-to-vault-request
       (clojure.core/nth args6022 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-access-policy
   [m6024]
   (clojure.core/let
    [credentials6025 (:credentials m6024) args6026 (:args m6024)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6027
      (com.palletops.awaze.common/aws-client :glacier credentials6025)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6027
       setVaultAccessPolicy
       (glacier/set-vault-access-policy-request
        (clojure.core/nth args6026 0)))))))
  (clojure.core/defn
   set-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVaultAccessPolicy"}
   [credentials6029 & args6030]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6031
     (com.palletops.awaze.common/aws-client :glacier credentials6029)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6031
      setVaultAccessPolicy
      (glacier/set-vault-access-policy-request
       (clojure.core/nth args6030 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-multipart-upload
   [m6032]
   (clojure.core/let
    [credentials6033 (:credentials m6032) args6034 (:args m6032)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6035
      (com.palletops.awaze.common/aws-client :glacier credentials6033)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6035
       completeMultipartUpload
       (glacier/complete-multipart-upload-request
        (clojure.core/nth args6034 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         clone-root
                         archive-size]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         clone-root
                         archive-size]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials6037 & args6038]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6039
     (com.palletops.awaze.common/aws-client :glacier credentials6037)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6039
      completeMultipartUpload
      (glacier/complete-multipart-upload-request
       (clojure.core/nth args6038 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-data-retrieval-policy
   [m6040]
   (clojure.core/let
    [credentials6041 (:credentials m6040) args6042 (:args m6040)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6043
      (com.palletops.awaze.common/aws-client :glacier credentials6041)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6043
       getDataRetrievalPolicy
       (glacier/get-data-retrieval-policy-request
        (clojure.core/nth args6042 0)))))))
  (clojure.core/defn
   get-data-retrieval-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDataRetrievalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-data-retrieval-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-data-retrieval-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDataRetrievalPolicy"}
   [credentials6045 & args6046]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6047
     (com.palletops.awaze.common/aws-client :glacier credentials6045)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6047
      getDataRetrievalPolicy
      (glacier/get-data-retrieval-policy-request
       (clojure.core/nth args6046 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-vault-lock
   [m6048]
   (clojure.core/let
    [credentials6049 (:credentials m6048) args6050 (:args m6048)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6051
      (com.palletops.awaze.common/aws-client :glacier credentials6049)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6051
       initiateVaultLock
       (glacier/initiate-vault-lock-request
        (clojure.core/nth args6050 0)))))))
  (clojure.core/defn
   initiate-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for initiateVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call initiateVaultLock"}
   [credentials6053 & args6054]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6055
     (com.palletops.awaze.common/aws-client :glacier credentials6053)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6055
      initiateVaultLock
      (glacier/initiate-vault-lock-request
       (clojure.core/nth args6054 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-archive
   [m6056]
   (clojure.core/let
    [credentials6057 (:credentials m6056) args6058 (:args m6056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6059
      (com.palletops.awaze.common/aws-client :glacier credentials6057)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6059
       deleteArchive
       (glacier/delete-archive-request (clojure.core/nth args6058 0)))))))
  (clojure.core/defn
   delete-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         archive-id
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-archive,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         archive-id
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteArchive"}
   [credentials6061 & args6062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6063
     (com.palletops.awaze.common/aws-client :glacier credentials6061)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6063
      deleteArchive
      (glacier/delete-archive-request (clojure.core/nth args6062 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-data-retrieval-policy
   [m6064]
   (clojure.core/let
    [credentials6065 (:credentials m6064) args6066 (:args m6064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6067
      (com.palletops.awaze.common/aws-client :glacier credentials6065)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6067
       setDataRetrievalPolicy
       (glacier/set-data-retrieval-policy-request
        (clojure.core/nth args6066 0)))))))
  (clojure.core/defn
   set-data-retrieval-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDataRetrievalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-data-retrieval-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-data-retrieval-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setDataRetrievalPolicy"}
   [credentials6069 & args6070]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6071
     (com.palletops.awaze.common/aws-client :glacier credentials6069)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6071
      setDataRetrievalPolicy
      (glacier/set-data-retrieval-policy-request
       (clojure.core/nth args6070 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-lock
   [m6072]
   (clojure.core/let
    [credentials6073 (:credentials m6072) args6074 (:args m6072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6075
      (com.palletops.awaze.common/aws-client :glacier credentials6073)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6075
       getVaultLock
       (glacier/get-vault-lock-request (clojure.core/nth args6074 0)))))))
  (clojure.core/defn
   get-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultLock"}
   [credentials6077 & args6078]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6079
     (com.palletops.awaze.common/aws-client :glacier credentials6077)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6079
      getVaultLock
      (glacier/get-vault-lock-request (clojure.core/nth args6078 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-jobs
   [m6080]
   (clojure.core/let
    [credentials6081 (:credentials m6080) args6082 (:args m6080)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6083
      (com.palletops.awaze.common/aws-client :glacier credentials6081)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6083
       listJobs
       (glacier/list-jobs-request (clojure.core/nth args6082 0)))))))
  (clojure.core/defn
   list-jobs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         completed
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         statuscode
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listJobs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-jobs,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-jobs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         completed
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         statuscode
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listJobs"}
   [credentials6085 & args6086]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6087
     (com.palletops.awaze.common/aws-client :glacier credentials6085)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6087
      listJobs
      (glacier/list-jobs-request (clojure.core/nth args6086 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-multipart-upload
   [m6088]
   (clojure.core/let
    [credentials6089 (:credentials m6088) args6090 (:args m6088)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6091
      (com.palletops.awaze.common/aws-client :glacier credentials6089)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6091
       initiateMultipartUpload
       (glacier/initiate-multipart-upload-request
        (clojure.core/nth args6090 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         part-size
                         clone-root]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         part-size
                         clone-root]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials6093 & args6094]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6095
     (com.palletops.awaze.common/aws-client :glacier credentials6093)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6095
      initiateMultipartUpload
      (glacier/initiate-multipart-upload-request
       (clojure.core/nth args6094 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-tags-for-vault
   [m6096]
   (clojure.core/let
    [credentials6097 (:credentials m6096) args6098 (:args m6096)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6099
      (com.palletops.awaze.common/aws-client :glacier credentials6097)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6099
       listTagsForVault
       (glacier/list-tags-for-vault-request
        (clojure.core/nth args6098 0)))))))
  (clojure.core/defn
   list-tags-for-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-tags-for-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForVault"}
   [credentials6101 & args6102]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6103
     (com.palletops.awaze.common/aws-client :glacier credentials6101)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6103
      listTagsForVault
      (glacier/list-tags-for-vault-request
       (clojure.core/nth args6102 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :create-vault
   [m6104]
   (clojure.core/let
    [credentials6105 (:credentials m6104) args6106 (:args m6104)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6107
      (com.palletops.awaze.common/aws-client :glacier credentials6105)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6107
       createVault
       (glacier/create-vault-request (clojure.core/nth args6106 0)))))))
  (clojure.core/defn
   create-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   create-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVault"}
   [credentials6109 & args6110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6111
     (com.palletops.awaze.common/aws-client :glacier credentials6109)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6111
      createVault
      (glacier/create-vault-request (clojure.core/nth args6110 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-access-policy
   [m6112]
   (clojure.core/let
    [credentials6113 (:credentials m6112) args6114 (:args m6112)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6115
      (com.palletops.awaze.common/aws-client :glacier credentials6113)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6115
       getVaultAccessPolicy
       (glacier/get-vault-access-policy-request
        (clojure.core/nth args6114 0)))))))
  (clojure.core/defn
   get-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultAccessPolicy"}
   [credentials6117 & args6118]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6119
     (com.palletops.awaze.common/aws-client :glacier credentials6117)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6119
      getVaultAccessPolicy
      (glacier/get-vault-access-policy-request
       (clojure.core/nth args6118 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-archive
   [m6120]
   (clojure.core/let
    [credentials6121 (:credentials m6120) args6122 (:args m6120)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6123
      (com.palletops.awaze.common/aws-client :glacier credentials6121)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6123
       uploadArchive
       (glacier/upload-archive-request (clojure.core/nth args6122 0)))))))
  (clojure.core/defn
   upload-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         content-length
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root]}]]),
    :doc "Generate map for uploadArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-archive,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   upload-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         content-length
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root]}]]),
    :doc "Call uploadArchive"}
   [credentials6125 & args6126]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6127
     (com.palletops.awaze.common/aws-client :glacier credentials6125)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6127
      uploadArchive
      (glacier/upload-archive-request (clojure.core/nth args6126 0))))))))
