(ns
 com.palletops.awaze.elasticmapreduce
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticmapreduce :as elasticmapreduce]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Configuration}
configuration
  [m8168]
  (clojure.core/let
   [bean8167
    (new com.amazonaws.services.elasticmapreduce.model.Configuration)]
   (clojure.core/let
    [v8169
     (:classification m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (. bean8167 setClassification (clojure.core/str v8169))))
   (clojure.core/let
    [v8169
     (:configurations m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (.
      bean8167
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8275] (elasticmapreduce/configuration arg8275))
 v8169))))
   (clojure.core/let
    [v8169
     (:properties m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (.
      bean8167
      setProperties
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8276] (clojure.core/str arg8276))
  (clojure.core/keys v8169))
 (clojure.core/map
  (clojure.core/fn [arg8276] (clojure.core/str arg8276))
  (clojure.core/vals v8169))))))
   bean8167))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.VolumeSpecification}
volume-specification
  [m8171]
  (clojure.core/let
   [bean8170
    (new
     com.amazonaws.services.elasticmapreduce.model.VolumeSpecification)]
   (clojure.core/let
    [v8172
     (:size-in-gb m8171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8172 :com.palletops.awaze.client-builder/undef)
     (. bean8170 setSizeInGB (clojure.core/int v8172))))
   (clojure.core/let
    [v8172
     (:volume-type m8171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8172 :com.palletops.awaze.client-builder/undef)
     (. bean8170 setVolumeType (clojure.core/str v8172))))
   (clojure.core/let
    [v8172 (:iops m8171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8172 :com.palletops.awaze.client-builder/undef)
     (. bean8170 setIops (clojure.core/int v8172))))
   bean8170))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig}
ebs-block-device-config
  [m8174]
  (clojure.core/let
   [bean8173
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig)]
   (clojure.core/let
    [v8175
     (:volume-specification
      m8174
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (.
      bean8173
      setVolumeSpecification
      (elasticmapreduce/volume-specification v8175))))
   (clojure.core/let
    [v8175
     (:volumes-per-instance
      m8174
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setVolumesPerInstance (clojure.core/int v8175))))
   bean8173))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.MarketType}
market-type
  [m8177]
  (.
   com.amazonaws.services.elasticmapreduce.model.MarketType
   fromValue
   (clojure.core/name m8177)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceRoleType}
instance-role-type
  [m8180]
  (.
   com.amazonaws.services.elasticmapreduce.model.InstanceRoleType
   fromValue
   (clojure.core/name m8180)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsConfiguration}
ebs-configuration
  [m8183]
  (clojure.core/let
   [bean8182
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsConfiguration)]
   (clojure.core/let
    [v8184
     (:ebs-optimized m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setEbsOptimized (clojure.core/boolean v8184))))
   (clojure.core/let
    [v8184
     (:ebs-block-device-configs
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setEbsBlockDeviceConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8277]
  (elasticmapreduce/ebs-block-device-config arg8277))
 v8184))))
   bean8182))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.KeyValue}
key-value
  [m8186]
  (clojure.core/let
   [bean8185
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/let
    [v8187 (:key m8186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (. bean8185 setKey (clojure.core/str v8187))))
   (clojure.core/let
    [v8187 (:value m8186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (. bean8185 setValue (clojure.core/str v8187))))
   bean8185))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.PlacementType}
placement-type
  [m8189]
  (clojure.core/let
   [bean8188
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/let
    [v8190
     (:availability-zone
      m8189
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8190 :com.palletops.awaze.client-builder/undef)
     (. bean8188 setAvailabilityZone (clojure.core/str v8190))))
   bean8188))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig}
instance-group-config
  [m8192]
  (clojure.core/let
   [bean8191
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/let
    [v8193
     (:instance-type m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setInstanceType (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:instance-count m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setInstanceCount (clojure.core/int v8193))))
   (clojure.core/let
    [v8193 (:market m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setMarket (elasticmapreduce/market-type v8193))))
   (clojure.core/let
    [v8193
     (:instance-role m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setInstanceRole
      (elasticmapreduce/instance-role-type v8193))))
   (clojure.core/let
    [v8193
     (:bid-price m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setBidPrice (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:ebs-configuration
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setEbsConfiguration
      (elasticmapreduce/ebs-configuration v8193))))
   (clojure.core/let
    [v8193
     (:configurations m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8278] (elasticmapreduce/configuration arg8278))
 v8193))))
   (clojure.core/let
    [v8193 (:name m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setName (clojure.core/str v8193))))
   bean8191))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig}
hadoop-jar-step-config
  [m8195]
  (clojure.core/let
   [bean8194
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/let
    [v8196 (:args m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (.
      bean8194
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8279] (clojure.core/str arg8279))
 v8196))))
   (clojure.core/let
    [v8196 (:jar m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (. bean8194 setJar (clojure.core/str v8196))))
   (clojure.core/let
    [v8196
     (:main-class m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (. bean8194 setMainClass (clojure.core/str v8196))))
   (clojure.core/let
    [v8196
     (:properties m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (.
      bean8194
      setProperties
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8280] (elasticmapreduce/key-value arg8280))
 v8196))))
   bean8194))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ActionOnFailure}
action-on-failure
  [m8198]
  (.
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   fromValue
   (clojure.core/name m8198)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig}
script-bootstrap-action-config
  [m8201]
  (clojure.core/let
   [bean8200
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/let
    [v8202 (:args m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (.
      bean8200
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8281] (clojure.core/str arg8281))
 v8202))))
   (clojure.core/let
    [v8202 (:path m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (. bean8200 setPath (clojure.core/str v8202))))
   bean8200))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig}
instance-group-modify-config
  [m8204]
  (clojure.core/let
   [bean8203
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/let
    [v8205
     (:instance-count m8204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (. bean8203 setInstanceCount (clojure.core/int v8205))))
   (clojure.core/let
    [v8205
     (:ec2instance-ids-to-terminate
      m8204
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (.
      bean8203
      setEC2InstanceIdsToTerminate
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8282] (clojure.core/str arg8282))
 v8205))))
   (clojure.core/let
    [v8205
     (:instance-group-id
      m8204
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (. bean8203 setInstanceGroupId (clojure.core/str v8205))))
   bean8203))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Tag}
tag
  [m8207]
  (clojure.core/let
   [bean8206 (new com.amazonaws.services.elasticmapreduce.model.Tag)]
   (clojure.core/let
    [v8208 (:key m8207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8208 :com.palletops.awaze.client-builder/undef)
     (. bean8206 setKey (clojure.core/str v8208))))
   (clojure.core/let
    [v8208 (:value m8207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8208 :com.palletops.awaze.client-builder/undef)
     (. bean8206 setValue (clojure.core/str v8208))))
   bean8206))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig}
job-flow-instances-config
  [m8210]
  (clojure.core/let
   [bean8209
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/let
    [v8211
     (:additional-master-security-groups
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setAdditionalMasterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8283] (clojure.core/str arg8283))
 v8211))))
   (clojure.core/let
    [v8211
     (:keep-job-flow-alive-when-no-steps
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setKeepJobFlowAliveWhenNoSteps
      (clojure.core/boolean v8211))))
   (clojure.core/let
    [v8211
     (:placement m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setPlacement (elasticmapreduce/placement-type v8211))))
   (clojure.core/let
    [v8211
     (:hadoop-version m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setHadoopVersion (clojure.core/str v8211))))
   (clojure.core/let
    [v8211
     (:ec2subnet-id m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setEc2SubnetId (clojure.core/str v8211))))
   (clojure.core/let
    [v8211
     (:master-instance-type
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setMasterInstanceType (clojure.core/str v8211))))
   (clojure.core/let
    [v8211
     (:slave-instance-type
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setSlaveInstanceType (clojure.core/str v8211))))
   (clojure.core/let
    [v8211
     (:termination-protected
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setTerminationProtected (clojure.core/boolean v8211))))
   (clojure.core/let
    [v8211
     (:emr-managed-master-security-group
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setEmrManagedMasterSecurityGroup
      (clojure.core/str v8211))))
   (clojure.core/let
    [v8211
     (:additional-slave-security-groups
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setAdditionalSlaveSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8284] (clojure.core/str arg8284))
 v8211))))
   (clojure.core/let
    [v8211
     (:ec2key-name m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setEc2KeyName (clojure.core/str v8211))))
   (clojure.core/let
    [v8211
     (:instance-count m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setInstanceCount (clojure.core/int v8211))))
   (clojure.core/let
    [v8211
     (:instance-groups
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8285]
  (elasticmapreduce/instance-group-config arg8285))
 v8211))))
   (clojure.core/let
    [v8211
     (:service-access-security-group
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setServiceAccessSecurityGroup
      (clojure.core/str v8211))))
   (clojure.core/let
    [v8211
     (:emr-managed-slave-security-group
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setEmrManagedSlaveSecurityGroup
      (clojure.core/str v8211))))
   bean8209))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Application}
application
  [m8213]
  (clojure.core/let
   [bean8212
    (new com.amazonaws.services.elasticmapreduce.model.Application)]
   (clojure.core/let
    [v8214 (:version m8213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (. bean8212 setVersion (clojure.core/str v8214))))
   (clojure.core/let
    [v8214
     (:additional-info
      m8213
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (.
      bean8212
      setAdditionalInfo
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8286] (clojure.core/str arg8286))
  (clojure.core/keys v8214))
 (clojure.core/map
  (clojure.core/fn [arg8286] (clojure.core/str arg8286))
  (clojure.core/vals v8214))))))
   (clojure.core/let
    [v8214 (:args m8213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (.
      bean8212
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8287] (clojure.core/str arg8287))
 v8214))))
   (clojure.core/let
    [v8214 (:name m8213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (. bean8212 setName (clojure.core/str v8214))))
   bean8212))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.StepConfig}
step-config
  [m8216]
  (clojure.core/let
   [bean8215
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/let
    [v8217
     (:hadoop-jar-step
      m8216
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (.
      bean8215
      setHadoopJarStep
      (elasticmapreduce/hadoop-jar-step-config v8217))))
   (clojure.core/let
    [v8217
     (:action-on-failure
      m8216
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (.
      bean8215
      setActionOnFailure
      (elasticmapreduce/action-on-failure v8217))))
   (clojure.core/let
    [v8217 (:name m8216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (. bean8215 setName (clojure.core/str v8217))))
   bean8215))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig}
supported-product-config
  [m8219]
  (clojure.core/let
   [bean8218
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/let
    [v8220 (:args m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (.
      bean8218
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8288] (clojure.core/str arg8288))
 v8220))))
   (clojure.core/let
    [v8220 (:name m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (. bean8218 setName (clojure.core/str v8220))))
   bean8218))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig}
bootstrap-action-config
  [m8222]
  (clojure.core/let
   [bean8221
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/let
    [v8223
     (:script-bootstrap-action
      m8222
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8223 :com.palletops.awaze.client-builder/undef)
     (.
      bean8221
      setScriptBootstrapAction
      (elasticmapreduce/script-bootstrap-action-config v8223))))
   (clojure.core/let
    [v8223 (:name m8222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8223 :com.palletops.awaze.client-builder/undef)
     (. bean8221 setName (clojure.core/str v8223))))
   bean8221))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest}
modify-instance-groups-request
  [m8225]
  (clojure.core/let
   [bean8224
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/let
    [v8226
     (:instance-groups
      m8225
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8226 :com.palletops.awaze.client-builder/undef)
     (.
      bean8224
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8289]
  (elasticmapreduce/instance-group-modify-config arg8289))
 v8226))))
   bean8224))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest}
list-instance-groups-request
  [m8228]
  (clojure.core/let
   [bean8227
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/let
    [v8229 (:marker m8228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (. bean8227 setMarker (clojure.core/str v8229))))
   (clojure.core/let
    [v8229
     (:cluster-id m8228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (. bean8227 setClusterId (clojure.core/str v8229))))
   bean8227))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListClustersRequest}
list-clusters-request
  [m8231]
  (clojure.core/let
   [bean8230
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/let
    [v8232 (:marker m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setMarker (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:created-after m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8232))))
   (clojure.core/let
    [v8232
     (:created-before m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8232))))
   (clojure.core/let
    [v8232
     (:cluster-states m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setClusterStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8290] (clojure.core/str arg8290))
 v8232))))
   bean8230))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest}
remove-tags-request
  [m8234]
  (clojure.core/let
   [bean8233
    (new
     com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest)]
   (clojure.core/let
    [v8235
     (:tag-keys m8234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8235 :com.palletops.awaze.client-builder/undef)
     (.
      bean8233
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8291] (clojure.core/str arg8291))
 v8235))))
   (clojure.core/let
    [v8235
     (:resource-id m8234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8235 :com.palletops.awaze.client-builder/undef)
     (. bean8233 setResourceId (clojure.core/str v8235))))
   bean8233))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddTagsRequest}
add-tags-request
  [m8237]
  (clojure.core/let
   [bean8236
    (new com.amazonaws.services.elasticmapreduce.model.AddTagsRequest)]
   (clojure.core/let
    [v8238
     (:resource-id m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (. bean8236 setResourceId (clojure.core/str v8238))))
   (clojure.core/let
    [v8238 (:tags m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (.
      bean8236
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8292] (elasticmapreduce/tag arg8292))
 v8238))))
   bean8236))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest}
set-visible-to-all-users-request
  [m8240]
  (clojure.core/let
   [bean8239
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/let
    [v8241
     (:job-flow-ids m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8293] (clojure.core/str arg8293))
 v8241))))
   (clojure.core/let
    [v8241
     (:visible-to-all-users
      m8240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setVisibleToAllUsers (clojure.core/boolean v8241))))
   bean8239))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest}
list-instances-request
  [m8243]
  (clojure.core/let
   [bean8242
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/let
    [v8244 (:marker m8243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (. bean8242 setMarker (clojure.core/str v8244))))
   (clojure.core/let
    [v8244
     (:instance-group-id
      m8243
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (. bean8242 setInstanceGroupId (clojure.core/str v8244))))
   (clojure.core/let
    [v8244
     (:instance-group-types
      m8243
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (.
      bean8242
      setInstanceGroupTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8294] (clojure.core/str arg8294))
 v8244))))
   (clojure.core/let
    [v8244
     (:cluster-id m8243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (. bean8242 setClusterId (clojure.core/str v8244))))
   bean8242))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest}
describe-cluster-request
  [m8246]
  (clojure.core/let
   [bean8245
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/let
    [v8247
     (:cluster-id m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setClusterId (clojure.core/str v8247))))
   bean8245))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest}
list-bootstrap-actions-request
  [m8249]
  (clojure.core/let
   [bean8248
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/let
    [v8250 (:marker m8249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8250 :com.palletops.awaze.client-builder/undef)
     (. bean8248 setMarker (clojure.core/str v8250))))
   (clojure.core/let
    [v8250
     (:cluster-id m8249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8250 :com.palletops.awaze.client-builder/undef)
     (. bean8248 setClusterId (clojure.core/str v8250))))
   bean8248))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest}
terminate-job-flows-request
  [m8252]
  (clojure.core/let
   [bean8251
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/let
    [v8253
     (:job-flow-ids m8252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8253 :com.palletops.awaze.client-builder/undef)
     (.
      bean8251
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8295] (clojure.core/str arg8295))
 v8253))))
   bean8251))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest}
describe-job-flows-request
  [m8255]
  (clojure.core/let
   [bean8254
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/let
    [v8256
     (:created-after m8255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8256 :com.palletops.awaze.client-builder/undef)
     (.
      bean8254
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8256))))
   (clojure.core/let
    [v8256
     (:created-before m8255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8256 :com.palletops.awaze.client-builder/undef)
     (.
      bean8254
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8256))))
   (clojure.core/let
    [v8256
     (:job-flow-ids m8255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8256 :com.palletops.awaze.client-builder/undef)
     (.
      bean8254
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8296] (clojure.core/str arg8296))
 v8256))))
   (clojure.core/let
    [v8256
     (:job-flow-states
      m8255
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8256 :com.palletops.awaze.client-builder/undef)
     (.
      bean8254
      setJobFlowStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8297] (clojure.core/str arg8297))
 v8256))))
   bean8254))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest}
run-job-flow-request
  [m8258]
  (clojure.core/let
   [bean8257
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/let
    [v8259
     (:job-flow-role m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setJobFlowRole (clojure.core/str v8259))))
   (clojure.core/let
    [v8259
     (:instances m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setInstances
      (elasticmapreduce/job-flow-instances-config v8259))))
   (clojure.core/let
    [v8259
     (:additional-info
      m8258
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setAdditionalInfo (clojure.core/str v8259))))
   (clojure.core/let
    [v8259
     (:visible-to-all-users
      m8258
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setVisibleToAllUsers (clojure.core/boolean v8259))))
   (clojure.core/let
    [v8259 (:name m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setName (clojure.core/str v8259))))
   (clojure.core/let
    [v8259
     (:applications m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setApplications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8378] (elasticmapreduce/application arg8378))
 v8259))))
   (clojure.core/let
    [v8259
     (:service-role m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setServiceRole (clojure.core/str v8259))))
   (clojure.core/let
    [v8259 (:steps m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8379] (elasticmapreduce/step-config arg8379))
 v8259))))
   (clojure.core/let
    [v8259
     (:supported-products
      m8258
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8380] (clojure.core/str arg8380))
 v8259))))
   (clojure.core/let
    [v8259
     (:ami-version m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setAmiVersion (clojure.core/str v8259))))
   (clojure.core/let
    [v8259 (:tags m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8381] (elasticmapreduce/tag arg8381))
 v8259))))
   (clojure.core/let
    [v8259 (:log-uri m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setLogUri (clojure.core/str v8259))))
   (clojure.core/let
    [v8259
     (:configurations m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8382] (elasticmapreduce/configuration arg8382))
 v8259))))
   (clojure.core/let
    [v8259
     (:release-label m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setReleaseLabel (clojure.core/str v8259))))
   (clojure.core/let
    [v8259
     (:new-supported-products
      m8258
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setNewSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8383]
  (elasticmapreduce/supported-product-config arg8383))
 v8259))))
   (clojure.core/let
    [v8259
     (:bootstrap-actions
      m8258
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setBootstrapActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8384]
  (elasticmapreduce/bootstrap-action-config arg8384))
 v8259))))
   bean8257))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest}
add-instance-groups-request
  [m8261]
  (clojure.core/let
   [bean8260
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/let
    [v8262
     (:instance-groups
      m8261
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8262 :com.palletops.awaze.client-builder/undef)
     (.
      bean8260
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8385]
  (elasticmapreduce/instance-group-config arg8385))
 v8262))))
   (clojure.core/let
    [v8262
     (:job-flow-id m8261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8262 :com.palletops.awaze.client-builder/undef)
     (. bean8260 setJobFlowId (clojure.core/str v8262))))
   bean8260))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListStepsRequest}
list-steps-request
  [m8264]
  (clojure.core/let
   [bean8263
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/let
    [v8265 (:marker m8264 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8265 :com.palletops.awaze.client-builder/undef)
     (. bean8263 setMarker (clojure.core/str v8265))))
   (clojure.core/let
    [v8265
     (:step-states m8264 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8265 :com.palletops.awaze.client-builder/undef)
     (.
      bean8263
      setStepStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8386] (clojure.core/str arg8386))
 v8265))))
   (clojure.core/let
    [v8265
     (:step-ids m8264 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8265 :com.palletops.awaze.client-builder/undef)
     (.
      bean8263
      setStepIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8387] (clojure.core/str arg8387))
 v8265))))
   (clojure.core/let
    [v8265
     (:cluster-id m8264 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8265 :com.palletops.awaze.client-builder/undef)
     (. bean8263 setClusterId (clojure.core/str v8265))))
   bean8263))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest}
add-job-flow-steps-request
  [m8267]
  (clojure.core/let
   [bean8266
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/let
    [v8268 (:steps m8267 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8268 :com.palletops.awaze.client-builder/undef)
     (.
      bean8266
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8388] (elasticmapreduce/step-config arg8388))
 v8268))))
   (clojure.core/let
    [v8268
     (:job-flow-id m8267 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8268 :com.palletops.awaze.client-builder/undef)
     (. bean8266 setJobFlowId (clojure.core/str v8268))))
   bean8266))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest}
set-termination-protection-request
  [m8270]
  (clojure.core/let
   [bean8269
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/let
    [v8271
     (:job-flow-ids m8270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8271 :com.palletops.awaze.client-builder/undef)
     (.
      bean8269
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8389] (clojure.core/str arg8389))
 v8271))))
   (clojure.core/let
    [v8271
     (:termination-protected
      m8270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8271 :com.palletops.awaze.client-builder/undef)
     (. bean8269 setTerminationProtected (clojure.core/boolean v8271))))
   bean8269))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest}
describe-step-request
  [m8273]
  (clojure.core/let
   [bean8272
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/let
    [v8274 (:step-id m8273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8274 :com.palletops.awaze.client-builder/undef)
     (. bean8272 setStepId (clojure.core/str v8274))))
   (clojure.core/let
    [v8274
     (:cluster-id m8273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8274 :com.palletops.awaze.client-builder/undef)
     (. bean8272 setClusterId (clojure.core/str v8274))))
   bean8272))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m8298]
   (clojure.core/let
    [credentials8299 (:credentials m8298) args8300 (:args m8298)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8301
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8299)]
     (clojure.core/case
      (clojure.core/count args8300)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8301
        modifyInstanceGroups
        (elasticmapreduce/modify-instance-groups-request
         (clojure.core/nth args8300 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8301
        modifyInstanceGroups))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :modify-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials8303 & args8304]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8305
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8303)]
    (clojure.core/case
     (clojure.core/count args8304)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8305
       modifyInstanceGroups
       (elasticmapreduce/modify-instance-groups-request
        (clojure.core/nth args8304 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8305
       modifyInstanceGroups))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m8306]
   (clojure.core/let
    [credentials8307 (:credentials m8306) args8308 (:args m8306)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8309
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8307)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8309
       listInstanceGroups
       (elasticmapreduce/list-instance-groups-request
        (clojure.core/nth args8308 0)))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceGroups"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceGroups"}
   [credentials8311 & args8312]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8313
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8311)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8313
      listInstanceGroups
      (elasticmapreduce/list-instance-groups-request
       (clojure.core/nth args8312 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m8314]
   (clojure.core/let
    [credentials8315 (:credentials m8314) args8316 (:args m8314)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8317
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8315)]
     (clojure.core/case
      (clojure.core/count args8316)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8317
        listClusters
        (elasticmapreduce/list-clusters-request
         (clojure.core/nth args8316 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8317
        listClusters))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Call listClusters, listClusters"}
   [credentials8319 & args8320]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8321
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8319)]
    (clojure.core/case
     (clojure.core/count args8320)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8321
       listClusters
       (elasticmapreduce/list-clusters-request
        (clojure.core/nth args8320 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8321
       listClusters))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :remove-tags
   [m8322]
   (clojure.core/let
    [credentials8323 (:credentials m8322) args8324 (:args m8322)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8325
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8323)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8325
       removeTags
       (elasticmapreduce/remove-tags-request
        (clojure.core/nth args8324 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials8327 & args8328]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8329
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8327)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8329
      removeTags
      (elasticmapreduce/remove-tags-request
       (clojure.core/nth args8328 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-tags
   [m8330]
   (clojure.core/let
    [credentials8331 (:credentials m8330) args8332 (:args m8330)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8333
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8331)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8333
       addTags
       (elasticmapreduce/add-tags-request
        (clojure.core/nth args8332 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials8335 & args8336]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8337
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8335)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8337
      addTags
      (elasticmapreduce/add-tags-request
       (clojure.core/nth args8336 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m8338]
   (clojure.core/let
    [credentials8339 (:credentials m8338) args8340 (:args m8338)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8341
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8339)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8341
       setVisibleToAllUsers
       (elasticmapreduce/set-visible-to-all-users-request
        (clojure.core/nth args8340 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-visible-to-all-users,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials8343 & args8344]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8345
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8343)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8345
      setVisibleToAllUsers
      (elasticmapreduce/set-visible-to-all-users-request
       (clojure.core/nth args8344 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m8346]
   (clojure.core/let
    [credentials8347 (:credentials m8346) args8348 (:args m8346)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8349
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8347)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8349
       listInstances
       (elasticmapreduce/list-instances-request
        (clojure.core/nth args8348 0)))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instances,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstances"}
   [credentials8351 & args8352]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8353
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8351)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8353
      listInstances
      (elasticmapreduce/list-instances-request
       (clojure.core/nth args8352 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m8354]
   (clojure.core/let
    [credentials8355 (:credentials m8354) args8356 (:args m8354)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8357
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8355)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8357
       describeCluster
       (elasticmapreduce/describe-cluster-request
        (clojure.core/nth args8356 0)))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCluster"}
   [credentials8359 & args8360]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8361
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8359)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8361
      describeCluster
      (elasticmapreduce/describe-cluster-request
       (clojure.core/nth args8360 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m8362]
   (clojure.core/let
    [credentials8363 (:credentials m8362) args8364 (:args m8362)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8365
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8363)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8365
       listBootstrapActions
       (elasticmapreduce/list-bootstrap-actions-request
        (clojure.core/nth args8364 0)))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listBootstrapActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-bootstrap-actions,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listBootstrapActions"}
   [credentials8367 & args8368]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8369
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8367)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8369
      listBootstrapActions
      (elasticmapreduce/list-bootstrap-actions-request
       (clojure.core/nth args8368 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m8370]
   (clojure.core/let
    [credentials8371 (:credentials m8370) args8372 (:args m8370)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8373
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8371)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8373
       terminateJobFlows
       (elasticmapreduce/terminate-job-flows-request
        (clojure.core/nth args8372 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateJobFlows"}
   [credentials8375 & args8376]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8377
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8375)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8377
      terminateJobFlows
      (elasticmapreduce/terminate-job-flows-request
       (clojure.core/nth args8376 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m8390]
   (clojure.core/let
    [credentials8391 (:credentials m8390) args8392 (:args m8390)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8393
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8391)]
     (clojure.core/case
      (clojure.core/count args8392)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8393
        describeJobFlows))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8393
        describeJobFlows
        (elasticmapreduce/describe-job-flows-request
         (clojure.core/nth args8392 0))))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials8395 & args8396]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8397
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8395)]
    (clojure.core/case
     (clojure.core/count args8396)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8397
       describeJobFlows))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8397
       describeJobFlows
       (elasticmapreduce/describe-job-flows-request
        (clojure.core/nth args8396 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m8398]
   (clojure.core/let
    [credentials8399 (:credentials m8398) args8400 (:args m8398)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8401
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8399)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8401
       runJobFlow
       (elasticmapreduce/run-job-flow-request
        (clojure.core/nth args8400 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-job-flow,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Call runJobFlow"}
   [credentials8403 & args8404]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8405
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8403)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8405
      runJobFlow
      (elasticmapreduce/run-job-flow-request
       (clojure.core/nth args8404 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m8406]
   (clojure.core/let
    [credentials8407 (:credentials m8406) args8408 (:args m8406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8409
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8407)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8409
       addInstanceGroups
       (elasticmapreduce/add-instance-groups-request
        (clojure.core/nth args8408 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addInstanceGroups"}
   [credentials8411 & args8412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8413
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8411)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8413
      addInstanceGroups
      (elasticmapreduce/add-instance-groups-request
       (clojure.core/nth args8412 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m8414]
   (clojure.core/let
    [credentials8415 (:credentials m8414) args8416 (:args m8414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8417
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8415)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8417
       listSteps
       (elasticmapreduce/list-steps-request
        (clojure.core/nth args8416 0)))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Generate map for listSteps"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-steps,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Call listSteps"}
   [credentials8419 & args8420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8421
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8419)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8421
      listSteps
      (elasticmapreduce/list-steps-request
       (clojure.core/nth args8420 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m8422]
   (clojure.core/let
    [credentials8423 (:credentials m8422) args8424 (:args m8422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8425
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8425
       addJobFlowSteps
       (elasticmapreduce/add-job-flow-steps-request
        (clojure.core/nth args8424 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-job-flow-steps,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials8427 & args8428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8429
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8429
      addJobFlowSteps
      (elasticmapreduce/add-job-flow-steps-request
       (clojure.core/nth args8428 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m8430]
   (clojure.core/let
    [credentials8431 (:credentials m8430) args8432 (:args m8430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8433
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8433
       setTerminationProtection
       (elasticmapreduce/set-termination-protection-request
        (clojure.core/nth args8432 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-termination-protection,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setTerminationProtection"}
   [credentials8435 & args8436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8437
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8437
      setTerminationProtection
      (elasticmapreduce/set-termination-protection-request
       (clojure.core/nth args8436 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m8438]
   (clojure.core/let
    [credentials8439 (:credentials m8438) args8440 (:args m8438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8441
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8441
       describeStep
       (elasticmapreduce/describe-step-request
        (clojure.core/nth args8440 0)))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Generate map for describeStep"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-step,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Call describeStep"}
   [credentials8443 & args8444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8445
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8445
      describeStep
      (elasticmapreduce/describe-step-request
       (clojure.core/nth args8444 0))))))))
