(ns
 com.palletops.awaze.elasticloadbalancing
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticloadbalancing :as elasticloadbalancing]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing}
cross-zone-load-balancing
  [m4553]
  (clojure.core/let
   [bean4552
    (new
     com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing)]
   (clojure.core/let
    [v4554 (:enabled m4553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setEnabled (clojure.core/boolean v4554))))
   bean4552))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining}
connection-draining
  [m4556]
  (clojure.core/let
   [bean4555
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining)]
   (clojure.core/let
    [v4557 (:enabled m4556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setEnabled (clojure.core/boolean v4557))))
   (clojure.core/let
    [v4557 (:timeout m4556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setTimeout (clojure.core/int v4557))))
   bean4555))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings}
connection-settings
  [m4559]
  (clojure.core/let
   [bean4558
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings)]
   (clojure.core/let
    [v4560
     (:idle-timeout m4559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setIdleTimeout (clojure.core/int v4560))))
   bean4558))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute}
additional-attribute
  [m4562]
  (clojure.core/let
   [bean4561
    (new
     com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute)]
   (clojure.core/let
    [v4563 (:key m4562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4563 :com.palletops.awaze.client-builder/undef)
     (. bean4561 setKey (clojure.core/str v4563))))
   (clojure.core/let
    [v4563 (:value m4562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4563 :com.palletops.awaze.client-builder/undef)
     (. bean4561 setValue (clojure.core/str v4563))))
   bean4561))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AccessLog}
access-log
  [m4565]
  (clojure.core/let
   [bean4564
    (new com.amazonaws.services.elasticloadbalancing.model.AccessLog)]
   (clojure.core/let
    [v4566 (:enabled m4565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (. bean4564 setEnabled (clojure.core/boolean v4566))))
   (clojure.core/let
    [v4566
     (:s3bucket-name m4565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (. bean4564 setS3BucketName (clojure.core/str v4566))))
   (clojure.core/let
    [v4566
     (:emit-interval m4565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (. bean4564 setEmitInterval (clojure.core/int v4566))))
   (clojure.core/let
    [v4566
     (:s3bucket-prefix
      m4565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (. bean4564 setS3BucketPrefix (clojure.core/str v4566))))
   bean4564))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Listener}
listener
  [m4568]
  (clojure.core/let
   [bean4567
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/let
    [v4569
     (:protocol m4568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setProtocol (clojure.core/str v4569))))
   (clojure.core/let
    [v4569
     (:load-balancer-port
      m4568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setLoadBalancerPort (clojure.core/int v4569))))
   (clojure.core/let
    [v4569
     (:instance-port m4568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setInstancePort (clojure.core/int v4569))))
   (clojure.core/let
    [v4569
     (:sslcertificate-id
      m4568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setSSLCertificateId (clojure.core/str v4569))))
   (clojure.core/let
    [v4569
     (:instance-protocol
      m4568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setInstanceProtocol (clojure.core/str v4569))))
   bean4567))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Tag}
tag
  [m4571]
  (clojure.core/let
   [bean4570
    (new com.amazonaws.services.elasticloadbalancing.model.Tag)]
   (clojure.core/let
    [v4572 (:key m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setKey (clojure.core/str v4572))))
   (clojure.core/let
    [v4572 (:value m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setValue (clojure.core/str v4572))))
   bean4570))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly}
tag-key-only
  [m4574]
  (clojure.core/let
   [bean4573
    (new com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly)]
   (clojure.core/let
    [v4575 (:key m4574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setKey (clojure.core/str v4575))))
   bean4573))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute}
policy-attribute
  [m4577]
  (clojure.core/let
   [bean4576
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/let
    [v4578
     (:attribute-name m4577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (. bean4576 setAttributeName (clojure.core/str v4578))))
   (clojure.core/let
    [v4578
     (:attribute-value
      m4577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (. bean4576 setAttributeValue (clojure.core/str v4578))))
   bean4576))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Instance}
instance
  [m4580]
  (clojure.core/let
   [bean4579
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/let
    [v4581
     (:instance-id m4580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4581 :com.palletops.awaze.client-builder/undef)
     (. bean4579 setInstanceId (clojure.core/str v4581))))
   bean4579))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes}
load-balancer-attributes
  [m4583]
  (clojure.core/let
   [bean4582
    (new
     com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes)]
   (clojure.core/let
    [v4584
     (:cross-zone-load-balancing
      m4583
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (.
      bean4582
      setCrossZoneLoadBalancing
      (elasticloadbalancing/cross-zone-load-balancing v4584))))
   (clojure.core/let
    [v4584
     (:connection-draining
      m4583
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (.
      bean4582
      setConnectionDraining
      (elasticloadbalancing/connection-draining v4584))))
   (clojure.core/let
    [v4584
     (:connection-settings
      m4583
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (.
      bean4582
      setConnectionSettings
      (elasticloadbalancing/connection-settings v4584))))
   (clojure.core/let
    [v4584
     (:additional-attributes
      m4583
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (.
      bean4582
      setAdditionalAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4672]
  (elasticloadbalancing/additional-attribute arg4672))
 v4584))))
   (clojure.core/let
    [v4584
     (:access-log m4583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (. bean4582 setAccessLog (elasticloadbalancing/access-log v4584))))
   bean4582))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.HealthCheck}
health-check
  [m4586]
  (clojure.core/let
   [bean4585
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/let
    [v4587
     (:interval m4586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setInterval (clojure.core/int v4587))))
   (clojure.core/let
    [v4587 (:timeout m4586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setTimeout (clojure.core/int v4587))))
   (clojure.core/let
    [v4587
     (:unhealthy-threshold
      m4586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setUnhealthyThreshold (clojure.core/int v4587))))
   (clojure.core/let
    [v4587
     (:healthy-threshold
      m4586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setHealthyThreshold (clojure.core/int v4587))))
   (clojure.core/let
    [v4587 (:target m4586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setTarget (clojure.core/str v4587))))
   bean4585))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest}
create-load-balancer-request
  [m4589]
  (clojure.core/let
   [bean4588
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/let
    [v4590
     (:availability-zones
      m4589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (.
      bean4588
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4673] (clojure.core/str arg4673))
 v4590))))
   (clojure.core/let
    [v4590
     (:security-groups
      m4589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (.
      bean4588
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4674] (clojure.core/str arg4674))
 v4590))))
   (clojure.core/let
    [v4590
     (:load-balancer-name
      m4589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setLoadBalancerName (clojure.core/str v4590))))
   (clojure.core/let
    [v4590
     (:listeners m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (.
      bean4588
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4675] (elasticloadbalancing/listener arg4675))
 v4590))))
   (clojure.core/let
    [v4590 (:scheme m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setScheme (clojure.core/str v4590))))
   (clojure.core/let
    [v4590 (:subnets m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (.
      bean4588
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4676] (clojure.core/str arg4676))
 v4590))))
   (clojure.core/let
    [v4590 (:tags m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (.
      bean4588
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4677] (elasticloadbalancing/tag arg4677))
 v4590))))
   bean4588))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest}
delete-load-balancer-listeners-request
  [m4592]
  (clojure.core/let
   [bean4591
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4593
     (:load-balancer-name
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (. bean4591 setLoadBalancerName (clojure.core/str v4593))))
   (clojure.core/let
    [v4593
     (:load-balancer-ports
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (.
      bean4591
      setLoadBalancerPorts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4678] (clojure.core/int arg4678))
 v4593))))
   bean4591))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest}
enable-availability-zones-for-load-balancer-request
  [m4595]
  (clojure.core/let
   [bean4594
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4596
     (:availability-zones
      m4595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4596 :com.palletops.awaze.client-builder/undef)
     (.
      bean4594
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4679] (clojure.core/str arg4679))
 v4596))))
   (clojure.core/let
    [v4596
     (:load-balancer-name
      m4595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4596 :com.palletops.awaze.client-builder/undef)
     (. bean4594 setLoadBalancerName (clojure.core/str v4596))))
   bean4594))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m4598]
  (clojure.core/let
   [bean4597
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v4599 (:marker m4598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (. bean4597 setMarker (clojure.core/str v4599))))
   (clojure.core/let
    [v4599
     (:load-balancer-names
      m4598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (.
      bean4597
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4680] (clojure.core/str arg4680))
 v4599))))
   (clojure.core/let
    [v4599
     (:page-size m4598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (. bean4597 setPageSize (clojure.core/int v4599))))
   bean4597))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest}
delete-load-balancer-policy-request
  [m4601]
  (clojure.core/let
   [bean4600
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4602
     (:load-balancer-name
      m4601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (. bean4600 setLoadBalancerName (clojure.core/str v4602))))
   (clojure.core/let
    [v4602
     (:policy-name m4601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (. bean4600 setPolicyName (clojure.core/str v4602))))
   bean4600))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest}
describe-load-balancer-policies-request
  [m4604]
  (clojure.core/let
   [bean4603
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/let
    [v4605
     (:load-balancer-name
      m4604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4605 :com.palletops.awaze.client-builder/undef)
     (. bean4603 setLoadBalancerName (clojure.core/str v4605))))
   (clojure.core/let
    [v4605
     (:policy-names m4604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4605 :com.palletops.awaze.client-builder/undef)
     (.
      bean4603
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4681] (clojure.core/str arg4681))
 v4605))))
   bean4603))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest}
remove-tags-request
  [m4607]
  (clojure.core/let
   [bean4606
    (new
     com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest)]
   (clojure.core/let
    [v4608
     (:load-balancer-names
      m4607
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4608 :com.palletops.awaze.client-builder/undef)
     (.
      bean4606
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4682] (clojure.core/str arg4682))
 v4608))))
   (clojure.core/let
    [v4608 (:tags m4607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4608 :com.palletops.awaze.client-builder/undef)
     (.
      bean4606
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4683]
  (elasticloadbalancing/tag-key-only arg4683))
 v4608))))
   bean4606))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest}
create-load-balancer-policy-request
  [m4610]
  (clojure.core/let
   [bean4609
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4611
     (:load-balancer-name
      m4610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (. bean4609 setLoadBalancerName (clojure.core/str v4611))))
   (clojure.core/let
    [v4611
     (:policy-name m4610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (. bean4609 setPolicyName (clojure.core/str v4611))))
   (clojure.core/let
    [v4611
     (:policy-type-name
      m4610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (. bean4609 setPolicyTypeName (clojure.core/str v4611))))
   (clojure.core/let
    [v4611
     (:policy-attributes
      m4610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (.
      bean4609
      setPolicyAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4684]
  (elasticloadbalancing/policy-attribute arg4684))
 v4611))))
   bean4609))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest}
create-load-balancer-listeners-request
  [m4613]
  (clojure.core/let
   [bean4612
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4614
     (:load-balancer-name
      m4613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (. bean4612 setLoadBalancerName (clojure.core/str v4614))))
   (clojure.core/let
    [v4614
     (:listeners m4613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (.
      bean4612
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4685] (elasticloadbalancing/listener arg4685))
 v4614))))
   bean4612))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest}
set-load-balancer-policies-for-backend-server-request
  [m4616]
  (clojure.core/let
   [bean4615
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/let
    [v4617
     (:load-balancer-name
      m4616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (. bean4615 setLoadBalancerName (clojure.core/str v4617))))
   (clojure.core/let
    [v4617
     (:policy-names m4616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (.
      bean4615
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4686] (clojure.core/str arg4686))
 v4617))))
   (clojure.core/let
    [v4617
     (:instance-port m4616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (. bean4615 setInstancePort (clojure.core/int v4617))))
   bean4615))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest}
describe-instance-health-request
  [m4619]
  (clojure.core/let
   [bean4618
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/let
    [v4620
     (:instances m4619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (.
      bean4618
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4687] (elasticloadbalancing/instance arg4687))
 v4620))))
   (clojure.core/let
    [v4620
     (:load-balancer-name
      m4619
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (. bean4618 setLoadBalancerName (clojure.core/str v4620))))
   bean4618))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest}
delete-load-balancer-request
  [m4622]
  (clojure.core/let
   [bean4621
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/let
    [v4623
     (:load-balancer-name
      m4622
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4623 :com.palletops.awaze.client-builder/undef)
     (. bean4621 setLoadBalancerName (clojure.core/str v4623))))
   bean4621))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest}
detach-load-balancer-from-subnets-request
  [m4625]
  (clojure.core/let
   [bean4624
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/let
    [v4626
     (:load-balancer-name
      m4625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4626 :com.palletops.awaze.client-builder/undef)
     (. bean4624 setLoadBalancerName (clojure.core/str v4626))))
   (clojure.core/let
    [v4626 (:subnets m4625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4626 :com.palletops.awaze.client-builder/undef)
     (.
      bean4624
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4688] (clojure.core/str arg4688))
 v4626))))
   bean4624))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest}
disable-availability-zones-for-load-balancer-request
  [m4628]
  (clojure.core/let
   [bean4627
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4629
     (:availability-zones
      m4628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4629 :com.palletops.awaze.client-builder/undef)
     (.
      bean4627
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4689] (clojure.core/str arg4689))
 v4629))))
   (clojure.core/let
    [v4629
     (:load-balancer-name
      m4628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4629 :com.palletops.awaze.client-builder/undef)
     (. bean4627 setLoadBalancerName (clojure.core/str v4629))))
   bean4627))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest}
set-load-balancer-policies-of-listener-request
  [m4631]
  (clojure.core/let
   [bean4630
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/let
    [v4632
     (:load-balancer-name
      m4631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setLoadBalancerName (clojure.core/str v4632))))
   (clojure.core/let
    [v4632
     (:policy-names m4631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (.
      bean4630
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4690] (clojure.core/str arg4690))
 v4632))))
   (clojure.core/let
    [v4632
     (:load-balancer-port
      m4631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setLoadBalancerPort (clojure.core/int v4632))))
   bean4630))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest}
add-tags-request
  [m4634]
  (clojure.core/let
   [bean4633
    (new
     com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest)]
   (clojure.core/let
    [v4635
     (:load-balancer-names
      m4634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4635 :com.palletops.awaze.client-builder/undef)
     (.
      bean4633
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4691] (clojure.core/str arg4691))
 v4635))))
   (clojure.core/let
    [v4635 (:tags m4634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4635 :com.palletops.awaze.client-builder/undef)
     (.
      bean4633
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4692] (elasticloadbalancing/tag arg4692))
 v4635))))
   bean4633))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest}
register-instances-with-load-balancer-request
  [m4637]
  (clojure.core/let
   [bean4636
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/let
    [v4638
     (:instances m4637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (.
      bean4636
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4693] (elasticloadbalancing/instance arg4693))
 v4638))))
   (clojure.core/let
    [v4638
     (:load-balancer-name
      m4637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (. bean4636 setLoadBalancerName (clojure.core/str v4638))))
   bean4636))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest}
describe-tags-request
  [m4640]
  (clojure.core/let
   [bean4639
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest)]
   (clojure.core/let
    [v4641
     (:load-balancer-names
      m4640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4641 :com.palletops.awaze.client-builder/undef)
     (.
      bean4639
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4694] (clojure.core/str arg4694))
 v4641))))
   bean4639))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest}
create-app-cookie-stickiness-policy-request
  [m4643]
  (clojure.core/let
   [bean4642
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4644
     (:load-balancer-name
      m4643
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4644 :com.palletops.awaze.client-builder/undef)
     (. bean4642 setLoadBalancerName (clojure.core/str v4644))))
   (clojure.core/let
    [v4644
     (:policy-name m4643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4644 :com.palletops.awaze.client-builder/undef)
     (. bean4642 setPolicyName (clojure.core/str v4644))))
   (clojure.core/let
    [v4644
     (:cookie-name m4643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4644 :com.palletops.awaze.client-builder/undef)
     (. bean4642 setCookieName (clojure.core/str v4644))))
   bean4642))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest}
modify-load-balancer-attributes-request
  [m4646]
  (clojure.core/let
   [bean4645
    (new
     com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4647
     (:load-balancer-name
      m4646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (. bean4645 setLoadBalancerName (clojure.core/str v4647))))
   (clojure.core/let
    [v4647
     (:load-balancer-attributes
      m4646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (.
      bean4645
      setLoadBalancerAttributes
      (elasticloadbalancing/load-balancer-attributes v4647))))
   bean4645))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest}
set-load-balancer-listener-sslcertificate-request
  [m4649]
  (clojure.core/let
   [bean4648
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/let
    [v4650
     (:load-balancer-name
      m4649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4650 :com.palletops.awaze.client-builder/undef)
     (. bean4648 setLoadBalancerName (clojure.core/str v4650))))
   (clojure.core/let
    [v4650
     (:load-balancer-port
      m4649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4650 :com.palletops.awaze.client-builder/undef)
     (. bean4648 setLoadBalancerPort (clojure.core/int v4650))))
   (clojure.core/let
    [v4650
     (:sslcertificate-id
      m4649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4650 :com.palletops.awaze.client-builder/undef)
     (. bean4648 setSSLCertificateId (clojure.core/str v4650))))
   bean4648))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest}
describe-load-balancer-attributes-request
  [m4652]
  (clojure.core/let
   [bean4651
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4653
     (:load-balancer-name
      m4652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (. bean4651 setLoadBalancerName (clojure.core/str v4653))))
   bean4651))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest}
configure-health-check-request
  [m4655]
  (clojure.core/let
   [bean4654
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/let
    [v4656
     (:load-balancer-name
      m4655
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4656 :com.palletops.awaze.client-builder/undef)
     (. bean4654 setLoadBalancerName (clojure.core/str v4656))))
   (clojure.core/let
    [v4656
     (:health-check m4655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4656 :com.palletops.awaze.client-builder/undef)
     (.
      bean4654
      setHealthCheck
      (elasticloadbalancing/health-check v4656))))
   bean4654))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest}
attach-load-balancer-to-subnets-request
  [m4658]
  (clojure.core/let
   [bean4657
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/let
    [v4659
     (:load-balancer-name
      m4658
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4659 :com.palletops.awaze.client-builder/undef)
     (. bean4657 setLoadBalancerName (clojure.core/str v4659))))
   (clojure.core/let
    [v4659 (:subnets m4658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4659 :com.palletops.awaze.client-builder/undef)
     (.
      bean4657
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4743] (clojure.core/str arg4743))
 v4659))))
   bean4657))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest}
describe-load-balancer-policy-types-request
  [m4661]
  (clojure.core/let
   [bean4660
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/let
    [v4662
     (:policy-type-names
      m4661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4662 :com.palletops.awaze.client-builder/undef)
     (.
      bean4660
      setPolicyTypeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4744] (clojure.core/str arg4744))
 v4662))))
   bean4660))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest}
deregister-instances-from-load-balancer-request
  [m4664]
  (clojure.core/let
   [bean4663
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/let
    [v4665
     (:instances m4664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4665 :com.palletops.awaze.client-builder/undef)
     (.
      bean4663
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4745] (elasticloadbalancing/instance arg4745))
 v4665))))
   (clojure.core/let
    [v4665
     (:load-balancer-name
      m4664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4665 :com.palletops.awaze.client-builder/undef)
     (. bean4663 setLoadBalancerName (clojure.core/str v4665))))
   bean4663))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest}
apply-security-groups-to-load-balancer-request
  [m4667]
  (clojure.core/let
   [bean4666
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/let
    [v4668
     (:security-groups
      m4667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4668 :com.palletops.awaze.client-builder/undef)
     (.
      bean4666
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4746] (clojure.core/str arg4746))
 v4668))))
   (clojure.core/let
    [v4668
     (:load-balancer-name
      m4667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4668 :com.palletops.awaze.client-builder/undef)
     (. bean4666 setLoadBalancerName (clojure.core/str v4668))))
   bean4666))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest}
create-lbcookie-stickiness-policy-request
  [m4670]
  (clojure.core/let
   [bean4669
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4671
     (:load-balancer-name
      m4670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4671 :com.palletops.awaze.client-builder/undef)
     (. bean4669 setLoadBalancerName (clojure.core/str v4671))))
   (clojure.core/let
    [v4671
     (:cookie-expiration-period
      m4670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4671 :com.palletops.awaze.client-builder/undef)
     (. bean4669 setCookieExpirationPeriod (clojure.core/long v4671))))
   (clojure.core/let
    [v4671
     (:policy-name m4670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4671 :com.palletops.awaze.client-builder/undef)
     (. bean4669 setPolicyName (clojure.core/str v4671))))
   bean4669))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4695]
   (clojure.core/let
    [credentials4696 (:credentials m4695) args4697 (:args m4695)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4698
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4696)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4698
       createLoadBalancer
       (elasticloadbalancing/create-load-balancer-request
        (clojure.core/nth args4697 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4700 & args4701]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4702
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4700)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4702
      createLoadBalancer
      (elasticloadbalancing/create-load-balancer-request
       (clojure.core/nth args4701 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4703]
   (clojure.core/let
    [credentials4704 (:credentials m4703) args4705 (:args m4703)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4706
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4704)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4706
       deleteLoadBalancerListeners
       (elasticloadbalancing/delete-load-balancer-listeners-request
        (clojure.core/nth args4705 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4708 & args4709]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4710
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4708)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4710
      deleteLoadBalancerListeners
      (elasticloadbalancing/delete-load-balancer-listeners-request
       (clojure.core/nth args4709 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4711]
   (clojure.core/let
    [credentials4712 (:credentials m4711) args4713 (:args m4711)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4714
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4712)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4714
       enableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4713 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4716 & args4717]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4718
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4716)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4718
      enableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4717 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4719]
   (clojure.core/let
    [credentials4720 (:credentials m4719) args4721 (:args m4719)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4722
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4720)]
     (clojure.core/case
      (clojure.core/count args4721)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4722
        describeLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4722
        describeLoadBalancers
        (elasticloadbalancing/describe-load-balancers-request
         (clojure.core/nth args4721 0))))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4724 & args4725]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4726
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4724)]
    (clojure.core/case
     (clojure.core/count args4725)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4726
       describeLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4726
       describeLoadBalancers
       (elasticloadbalancing/describe-load-balancers-request
        (clojure.core/nth args4725 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4727]
   (clojure.core/let
    [credentials4728 (:credentials m4727) args4729 (:args m4727)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4730
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4728)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4730
       deleteLoadBalancerPolicy
       (elasticloadbalancing/delete-load-balancer-policy-request
        (clojure.core/nth args4729 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4732 & args4733]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4734
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4732)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4734
      deleteLoadBalancerPolicy
      (elasticloadbalancing/delete-load-balancer-policy-request
       (clojure.core/nth args4733 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4735]
   (clojure.core/let
    [credentials4736 (:credentials m4735) args4737 (:args m4735)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4738
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4736)]
     (clojure.core/case
      (clojure.core/count args4737)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4738
        describeLoadBalancerPolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4738
        describeLoadBalancerPolicies
        (elasticloadbalancing/describe-load-balancer-policies-request
         (clojure.core/nth args4737 0))))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4740 & args4741]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4742
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4740)]
    (clojure.core/case
     (clojure.core/count args4741)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4742
       describeLoadBalancerPolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4742
       describeLoadBalancerPolicies
       (elasticloadbalancing/describe-load-balancer-policies-request
        (clojure.core/nth args4741 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :remove-tags
   [m4747]
   (clojure.core/let
    [credentials4748 (:credentials m4747) args4749 (:args m4747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4750
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4748)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4750
       removeTags
       (elasticloadbalancing/remove-tags-request
        (clojure.core/nth args4749 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials4752 & args4753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4754
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4752)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4754
      removeTags
      (elasticloadbalancing/remove-tags-request
       (clojure.core/nth args4753 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4755]
   (clojure.core/let
    [credentials4756 (:credentials m4755) args4757 (:args m4755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4758
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4756)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4758
       createLoadBalancerPolicy
       (elasticloadbalancing/create-load-balancer-policy-request
        (clojure.core/nth args4757 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4760 & args4761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4762
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4760)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4762
      createLoadBalancerPolicy
      (elasticloadbalancing/create-load-balancer-policy-request
       (clojure.core/nth args4761 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4763]
   (clojure.core/let
    [credentials4764 (:credentials m4763) args4765 (:args m4763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4766
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4764)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4766
       createLoadBalancerListeners
       (elasticloadbalancing/create-load-balancer-listeners-request
        (clojure.core/nth args4765 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer-listeners,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4768 & args4769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4770
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4768)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4770
      createLoadBalancerListeners
      (elasticloadbalancing/create-load-balancer-listeners-request
       (clojure.core/nth args4769 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4771]
   (clojure.core/let
    [credentials4772 (:credentials m4771) args4773 (:args m4771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4774
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4772)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4774
       setLoadBalancerPoliciesForBackendServer
       (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4773 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4776 & args4777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4778
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4776)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4778
      setLoadBalancerPoliciesForBackendServer
      (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4777 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4779]
   (clojure.core/let
    [credentials4780 (:credentials m4779) args4781 (:args m4779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4782
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4780)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4782
       describeInstanceHealth
       (elasticloadbalancing/describe-instance-health-request
        (clojure.core/nth args4781 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-health,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4784 & args4785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4786
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4784)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4786
      describeInstanceHealth
      (elasticloadbalancing/describe-instance-health-request
       (clojure.core/nth args4785 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4787]
   (clojure.core/let
    [credentials4788 (:credentials m4787) args4789 (:args m4787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4790
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4788)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4790
       deleteLoadBalancer
       (elasticloadbalancing/delete-load-balancer-request
        (clojure.core/nth args4789 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4792 & args4793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4794
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4792)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4794
      deleteLoadBalancer
      (elasticloadbalancing/delete-load-balancer-request
       (clojure.core/nth args4793 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4795]
   (clojure.core/let
    [credentials4796 (:credentials m4795) args4797 (:args m4795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4798
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4796)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4798
       detachLoadBalancerFromSubnets
       (elasticloadbalancing/detach-load-balancer-from-subnets-request
        (clojure.core/nth args4797 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4800 & args4801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4802
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4800)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4802
      detachLoadBalancerFromSubnets
      (elasticloadbalancing/detach-load-balancer-from-subnets-request
       (clojure.core/nth args4801 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4803]
   (clojure.core/let
    [credentials4804 (:credentials m4803) args4805 (:args m4803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4806
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4804)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4806
       disableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4805 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4808 & args4809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4810
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4810
      disableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4809 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4811]
   (clojure.core/let
    [credentials4812 (:credentials m4811) args4813 (:args m4811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4814
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4814
       setLoadBalancerPoliciesOfListener
       (elasticloadbalancing/set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4813 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4816 & args4817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4818
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4818
      setLoadBalancerPoliciesOfListener
      (elasticloadbalancing/set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4817 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :add-tags
   [m4819]
   (clojure.core/let
    [credentials4820 (:credentials m4819) args4821 (:args m4819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4822
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4822
       addTags
       (elasticloadbalancing/add-tags-request
        (clojure.core/nth args4821 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials4824 & args4825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4826
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4824)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4826
      addTags
      (elasticloadbalancing/add-tags-request
       (clojure.core/nth args4825 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4827]
   (clojure.core/let
    [credentials4828 (:credentials m4827) args4829 (:args m4827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4830
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4830
       registerInstancesWithLoadBalancer
       (elasticloadbalancing/register-instances-with-load-balancer-request
        (clojure.core/nth args4829 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4832 & args4833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4834
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4834
      registerInstancesWithLoadBalancer
      (elasticloadbalancing/register-instances-with-load-balancer-request
       (clojure.core/nth args4833 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-tags
   [m4835]
   (clojure.core/let
    [credentials4836 (:credentials m4835) args4837 (:args m4835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4838
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4838
       describeTags
       (elasticloadbalancing/describe-tags-request
        (clojure.core/nth args4837 0)))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTags"}
   [credentials4840 & args4841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4842
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4842
      describeTags
      (elasticloadbalancing/describe-tags-request
       (clojure.core/nth args4841 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4843]
   (clojure.core/let
    [credentials4844 (:credentials m4843) args4845 (:args m4843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4846
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4846
       createAppCookieStickinessPolicy
       (elasticloadbalancing/create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4845 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4848 & args4849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4850
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4850
      createAppCookieStickinessPolicy
      (elasticloadbalancing/create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4849 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :modify-load-balancer-attributes
   [m4851]
   (clojure.core/let
    [credentials4852 (:credentials m4851) args4853 (:args m4851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4854
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4852)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4854
       modifyLoadBalancerAttributes
       (elasticloadbalancing/modify-load-balancer-attributes-request
        (clojure.core/nth args4853 0)))))))
  (clojure.core/defn
   modify-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyLoadBalancerAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-load-balancer-attributes,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   modify-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyLoadBalancerAttributes"}
   [credentials4856 & args4857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4858
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4856)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4858
      modifyLoadBalancerAttributes
      (elasticloadbalancing/modify-load-balancer-attributes-request
       (clojure.core/nth args4857 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4859]
   (clojure.core/let
    [credentials4860 (:credentials m4859) args4861 (:args m4859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4862
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4862
       setLoadBalancerListenerSSLCertificate
       (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4861 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4864 & args4865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4866
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4866
      setLoadBalancerListenerSSLCertificate
      (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4865 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-attributes
   [m4867]
   (clojure.core/let
    [credentials4868 (:credentials m4867) args4869 (:args m4867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4870
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4868)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4870
       describeLoadBalancerAttributes
       (elasticloadbalancing/describe-load-balancer-attributes-request
        (clojure.core/nth args4869 0)))))))
  (clojure.core/defn
   describe-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-attributes,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerAttributes"}
   [credentials4872 & args4873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4874
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4874
      describeLoadBalancerAttributes
      (elasticloadbalancing/describe-load-balancer-attributes-request
       (clojure.core/nth args4873 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4875]
   (clojure.core/let
    [credentials4876 (:credentials m4875) args4877 (:args m4875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4878
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4878
       configureHealthCheck
       (elasticloadbalancing/configure-health-check-request
        (clojure.core/nth args4877 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :configure-health-check,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4880 & args4881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4882
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4882
      configureHealthCheck
      (elasticloadbalancing/configure-health-check-request
       (clojure.core/nth args4881 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4883]
   (clojure.core/let
    [credentials4884 (:credentials m4883) args4885 (:args m4883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4886
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4886
       attachLoadBalancerToSubnets
       (elasticloadbalancing/attach-load-balancer-to-subnets-request
        (clojure.core/nth args4885 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4888 & args4889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4890
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4890
      attachLoadBalancerToSubnets
      (elasticloadbalancing/attach-load-balancer-to-subnets-request
       (clojure.core/nth args4889 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4891]
   (clojure.core/let
    [credentials4892 (:credentials m4891) args4893 (:args m4891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4894
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4892)]
     (clojure.core/case
      (clojure.core/count args4893)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4894
        describeLoadBalancerPolicyTypes
        (elasticloadbalancing/describe-load-balancer-policy-types-request
         (clojure.core/nth args4893 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4894
        describeLoadBalancerPolicyTypes))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4896 & args4897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4898
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4896)]
    (clojure.core/case
     (clojure.core/count args4897)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4898
       describeLoadBalancerPolicyTypes
       (elasticloadbalancing/describe-load-balancer-policy-types-request
        (clojure.core/nth args4897 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4898
       describeLoadBalancerPolicyTypes))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4899]
   (clojure.core/let
    [credentials4900 (:credentials m4899) args4901 (:args m4899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4902
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4900)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4902
       deregisterInstancesFromLoadBalancer
       (elasticloadbalancing/deregister-instances-from-load-balancer-request
        (clojure.core/nth args4901 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4904 & args4905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4906
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4904)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4906
      deregisterInstancesFromLoadBalancer
      (elasticloadbalancing/deregister-instances-from-load-balancer-request
       (clojure.core/nth args4905 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4907]
   (clojure.core/let
    [credentials4908 (:credentials m4907) args4909 (:args m4907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4910
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4910
       applySecurityGroupsToLoadBalancer
       (elasticloadbalancing/apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4909 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4912 & args4913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4914
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4914
      applySecurityGroupsToLoadBalancer
      (elasticloadbalancing/apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4913 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4915]
   (clojure.core/let
    [credentials4916 (:credentials m4915) args4917 (:args m4915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4918
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4916)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4918
       createLBCookieStickinessPolicy
       (elasticloadbalancing/create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4917 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4920 & args4921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4922
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4920)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4922
      createLBCookieStickinessPolicy
      (elasticloadbalancing/create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4921 0))))))))
