(ns
 com.palletops.awaze.elasticbeanstalk
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticbeanstalk :as elasticbeanstalk]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EventSeverity}
event-severity
  [m10728]
  (.
   com.amazonaws.services.elasticbeanstalk.model.EventSeverity
   fromValue
   (clojure.core/name m10728)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.OptionSpecification}
option-specification
  [m10731]
  (clojure.core/let
   [bean10730
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/let
    [v10732
     (:namespace m10731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10732 :com.palletops.awaze.client-builder/undef)
     (. bean10730 setNamespace (clojure.core/str v10732))))
   (clojure.core/let
    [v10732
     (:option-name m10731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10732 :com.palletops.awaze.client-builder/undef)
     (. bean10730 setOptionName (clojure.core/str v10732))))
   (clojure.core/let
    [v10732
     (:resource-name m10731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10732 :com.palletops.awaze.client-builder/undef)
     (. bean10730 setResourceName (clojure.core/str v10732))))
   bean10730))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting}
configuration-option-setting
  [m10734]
  (clojure.core/let
   [bean10733
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/let
    [v10735
     (:namespace m10734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10735 :com.palletops.awaze.client-builder/undef)
     (. bean10733 setNamespace (clojure.core/str v10735))))
   (clojure.core/let
    [v10735
     (:option-name m10734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10735 :com.palletops.awaze.client-builder/undef)
     (. bean10733 setOptionName (clojure.core/str v10735))))
   (clojure.core/let
    [v10735
     (:resource-name m10734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10735 :com.palletops.awaze.client-builder/undef)
     (. bean10733 setResourceName (clojure.core/str v10735))))
   (clojure.core/let
    [v10735 (:value m10734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10735 :com.palletops.awaze.client-builder/undef)
     (. bean10733 setValue (clojure.core/str v10735))))
   bean10733))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration}
source-configuration
  [m10737]
  (clojure.core/let
   [bean10736
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/let
    [v10738
     (:application-name
      m10737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10738 :com.palletops.awaze.client-builder/undef)
     (. bean10736 setApplicationName (clojure.core/str v10738))))
   (clojure.core/let
    [v10738
     (:template-name m10737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10738 :com.palletops.awaze.client-builder/undef)
     (. bean10736 setTemplateName (clojure.core/str v10738))))
   bean10736))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier}
environment-tier
  [m10740]
  (clojure.core/let
   [bean10739
    (new
     com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier)]
   (clojure.core/let
    [v10741
     (:version m10740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10741 :com.palletops.awaze.client-builder/undef)
     (. bean10739 setVersion (clojure.core/str v10741))))
   (clojure.core/let
    [v10741 (:type m10740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10741 :com.palletops.awaze.client-builder/undef)
     (. bean10739 setType (clojure.core/str v10741))))
   (clojure.core/let
    [v10741 (:name m10740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10741 :com.palletops.awaze.client-builder/undef)
     (. bean10739 setName (clojure.core/str v10741))))
   bean10739))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.S3Location}
s3location
  [m10743]
  (clojure.core/let
   [bean10742
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/let
    [v10744
     (:s3bucket m10743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10744 :com.palletops.awaze.client-builder/undef)
     (. bean10742 setS3Bucket (clojure.core/str v10744))))
   (clojure.core/let
    [v10744 (:s3key m10743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10744 :com.palletops.awaze.client-builder/undef)
     (. bean10742 setS3Key (clojure.core/str v10744))))
   bean10742))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.Tag}
tag
  [m10746]
  (clojure.core/let
   [bean10745 (new com.amazonaws.services.elasticbeanstalk.model.Tag)]
   (clojure.core/let
    [v10747 (:key m10746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10747 :com.palletops.awaze.client-builder/undef)
     (. bean10745 setKey (clojure.core/str v10747))))
   (clojure.core/let
    [v10747 (:value m10746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10747 :com.palletops.awaze.client-builder/undef)
     (. bean10745 setValue (clojure.core/str v10747))))
   bean10745))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest}
describe-application-versions-request
  [m10749]
  (clojure.core/let
   [bean10748
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/let
    [v10750
     (:application-name
      m10749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setApplicationName (clojure.core/str v10750))))
   (clojure.core/let
    [v10750
     (:version-labels
      m10749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (.
      bean10748
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10847] (clojure.core/str arg10847))
 v10750))))
   bean10748))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest}
compose-environments-request
  [m10752]
  (clojure.core/let
   [bean10751
    (new
     com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest)]
   (clojure.core/let
    [v10753
     (:application-name
      m10752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10753 :com.palletops.awaze.client-builder/undef)
     (. bean10751 setApplicationName (clojure.core/str v10753))))
   (clojure.core/let
    [v10753
     (:version-labels
      m10752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10753 :com.palletops.awaze.client-builder/undef)
     (.
      bean10751
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10848] (clojure.core/str arg10848))
 v10753))))
   (clojure.core/let
    [v10753
     (:group-name m10752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10753 :com.palletops.awaze.client-builder/undef)
     (. bean10751 setGroupName (clojure.core/str v10753))))
   bean10751))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest}
rebuild-environment-request
  [m10755]
  (clojure.core/let
   [bean10754
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/let
    [v10756
     (:environment-id
      m10755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10756 :com.palletops.awaze.client-builder/undef)
     (. bean10754 setEnvironmentId (clojure.core/str v10756))))
   (clojure.core/let
    [v10756
     (:environment-name
      m10755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10756 :com.palletops.awaze.client-builder/undef)
     (. bean10754 setEnvironmentName (clojure.core/str v10756))))
   bean10754))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest}
update-application-version-request
  [m10758]
  (clojure.core/let
   [bean10757
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/let
    [v10759
     (:application-name
      m10758
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10759 :com.palletops.awaze.client-builder/undef)
     (. bean10757 setApplicationName (clojure.core/str v10759))))
   (clojure.core/let
    [v10759
     (:version-label m10758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10759 :com.palletops.awaze.client-builder/undef)
     (. bean10757 setVersionLabel (clojure.core/str v10759))))
   (clojure.core/let
    [v10759
     (:description m10758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10759 :com.palletops.awaze.client-builder/undef)
     (. bean10757 setDescription (clojure.core/str v10759))))
   bean10757))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest}
delete-environment-configuration-request
  [m10761]
  (clojure.core/let
   [bean10760
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/let
    [v10762
     (:environment-name
      m10761
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10762 :com.palletops.awaze.client-builder/undef)
     (. bean10760 setEnvironmentName (clojure.core/str v10762))))
   (clojure.core/let
    [v10762
     (:application-name
      m10761
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10762 :com.palletops.awaze.client-builder/undef)
     (. bean10760 setApplicationName (clojure.core/str v10762))))
   bean10760))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest}
describe-events-request
  [m10764]
  (clojure.core/let
   [bean10763
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/let
    [v10765
     (:start-time m10764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (.
      bean10763
      setStartTime
      (com.palletops.awaze.common/to-date v10765))))
   (clojure.core/let
    [v10765
     (:version-label m10764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (. bean10763 setVersionLabel (clojure.core/str v10765))))
   (clojure.core/let
    [v10765
     (:template-name m10764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (. bean10763 setTemplateName (clojure.core/str v10765))))
   (clojure.core/let
    [v10765
     (:environment-name
      m10764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (. bean10763 setEnvironmentName (clojure.core/str v10765))))
   (clojure.core/let
    [v10765
     (:max-records m10764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (. bean10763 setMaxRecords (clojure.core/int v10765))))
   (clojure.core/let
    [v10765
     (:severity m10764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (.
      bean10763
      setSeverity
      (elasticbeanstalk/event-severity v10765))))
   (clojure.core/let
    [v10765
     (:end-time m10764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (.
      bean10763
      setEndTime
      (com.palletops.awaze.common/to-date v10765))))
   (clojure.core/let
    [v10765
     (:request-id m10764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (. bean10763 setRequestId (clojure.core/str v10765))))
   (clojure.core/let
    [v10765
     (:environment-id
      m10764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (. bean10763 setEnvironmentId (clojure.core/str v10765))))
   (clojure.core/let
    [v10765
     (:next-token m10764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (. bean10763 setNextToken (clojure.core/str v10765))))
   (clojure.core/let
    [v10765
     (:application-name
      m10764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10765 :com.palletops.awaze.client-builder/undef)
     (. bean10763 setApplicationName (clojure.core/str v10765))))
   bean10763))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest}
describe-configuration-settings-request
  [m10767]
  (clojure.core/let
   [bean10766
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/let
    [v10768
     (:environment-name
      m10767
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10768 :com.palletops.awaze.client-builder/undef)
     (. bean10766 setEnvironmentName (clojure.core/str v10768))))
   (clojure.core/let
    [v10768
     (:application-name
      m10767
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10768 :com.palletops.awaze.client-builder/undef)
     (. bean10766 setApplicationName (clojure.core/str v10768))))
   (clojure.core/let
    [v10768
     (:template-name m10767 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10768 :com.palletops.awaze.client-builder/undef)
     (. bean10766 setTemplateName (clojure.core/str v10768))))
   bean10766))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest}
terminate-environment-request
  [m10770]
  (clojure.core/let
   [bean10769
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/let
    [v10771
     (:environment-id
      m10770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10771 :com.palletops.awaze.client-builder/undef)
     (. bean10769 setEnvironmentId (clojure.core/str v10771))))
   (clojure.core/let
    [v10771
     (:environment-name
      m10770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10771 :com.palletops.awaze.client-builder/undef)
     (. bean10769 setEnvironmentName (clojure.core/str v10771))))
   (clojure.core/let
    [v10771
     (:terminate-resources
      m10770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10771 :com.palletops.awaze.client-builder/undef)
     (. bean10769 setTerminateResources (clojure.core/boolean v10771))))
   (clojure.core/let
    [v10771
     (:force-terminate
      m10770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10771 :com.palletops.awaze.client-builder/undef)
     (. bean10769 setForceTerminate (clojure.core/boolean v10771))))
   bean10769))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest}
describe-configuration-options-request
  [m10773]
  (clojure.core/let
   [bean10772
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/let
    [v10774
     (:environment-name
      m10773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10774 :com.palletops.awaze.client-builder/undef)
     (. bean10772 setEnvironmentName (clojure.core/str v10774))))
   (clojure.core/let
    [v10774
     (:application-name
      m10773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10774 :com.palletops.awaze.client-builder/undef)
     (. bean10772 setApplicationName (clojure.core/str v10774))))
   (clojure.core/let
    [v10774
     (:template-name m10773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10774 :com.palletops.awaze.client-builder/undef)
     (. bean10772 setTemplateName (clojure.core/str v10774))))
   (clojure.core/let
    [v10774
     (:solution-stack-name
      m10773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10774 :com.palletops.awaze.client-builder/undef)
     (. bean10772 setSolutionStackName (clojure.core/str v10774))))
   (clojure.core/let
    [v10774
     (:options m10773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10774 :com.palletops.awaze.client-builder/undef)
     (.
      bean10772
      setOptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10849]
  (elasticbeanstalk/option-specification arg10849))
 v10774))))
   bean10772))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest}
create-configuration-template-request
  [m10776]
  (clojure.core/let
   [bean10775
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10777
     (:option-settings
      m10776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10777 :com.palletops.awaze.client-builder/undef)
     (.
      bean10775
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10850]
  (elasticbeanstalk/configuration-option-setting arg10850))
 v10777))))
   (clojure.core/let
    [v10777
     (:environment-id
      m10776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10777 :com.palletops.awaze.client-builder/undef)
     (. bean10775 setEnvironmentId (clojure.core/str v10777))))
   (clojure.core/let
    [v10777
     (:application-name
      m10776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10777 :com.palletops.awaze.client-builder/undef)
     (. bean10775 setApplicationName (clojure.core/str v10777))))
   (clojure.core/let
    [v10777
     (:template-name m10776 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10777 :com.palletops.awaze.client-builder/undef)
     (. bean10775 setTemplateName (clojure.core/str v10777))))
   (clojure.core/let
    [v10777
     (:solution-stack-name
      m10776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10777 :com.palletops.awaze.client-builder/undef)
     (. bean10775 setSolutionStackName (clojure.core/str v10777))))
   (clojure.core/let
    [v10777
     (:source-configuration
      m10776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10777 :com.palletops.awaze.client-builder/undef)
     (.
      bean10775
      setSourceConfiguration
      (elasticbeanstalk/source-configuration v10777))))
   (clojure.core/let
    [v10777
     (:description m10776 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10777 :com.palletops.awaze.client-builder/undef)
     (. bean10775 setDescription (clojure.core/str v10777))))
   bean10775))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest}
update-environment-request
  [m10779]
  (clojure.core/let
   [bean10778
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/let
    [v10780
     (:option-settings
      m10779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (.
      bean10778
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10851]
  (elasticbeanstalk/configuration-option-setting arg10851))
 v10780))))
   (clojure.core/let
    [v10780
     (:description m10779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setDescription (clojure.core/str v10780))))
   (clojure.core/let
    [v10780
     (:solution-stack-name
      m10779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setSolutionStackName (clojure.core/str v10780))))
   (clojure.core/let
    [v10780 (:tier m10779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setTier (elasticbeanstalk/environment-tier v10780))))
   (clojure.core/let
    [v10780
     (:version-label m10779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setVersionLabel (clojure.core/str v10780))))
   (clojure.core/let
    [v10780
     (:template-name m10779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setTemplateName (clojure.core/str v10780))))
   (clojure.core/let
    [v10780
     (:environment-name
      m10779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setEnvironmentName (clojure.core/str v10780))))
   (clojure.core/let
    [v10780
     (:options-to-remove
      m10779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (.
      bean10778
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10852]
  (elasticbeanstalk/option-specification arg10852))
 v10780))))
   (clojure.core/let
    [v10780
     (:group-name m10779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setGroupName (clojure.core/str v10780))))
   (clojure.core/let
    [v10780
     (:environment-id
      m10779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setEnvironmentId (clojure.core/str v10780))))
   (clojure.core/let
    [v10780
     (:application-name
      m10779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10780 :com.palletops.awaze.client-builder/undef)
     (. bean10778 setApplicationName (clojure.core/str v10780))))
   bean10778))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest}
describe-applications-request
  [m10782]
  (clojure.core/let
   [bean10781
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/let
    [v10783
     (:application-names
      m10782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10783 :com.palletops.awaze.client-builder/undef)
     (.
      bean10781
      setApplicationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10853] (clojure.core/str arg10853))
 v10783))))
   bean10781))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest}
create-storage-location-request
  [m10785]
  (clojure.core/let
   [bean10784
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean10784))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest}
restart-app-server-request
  [m10788]
  (clojure.core/let
   [bean10787
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/let
    [v10789
     (:environment-id
      m10788
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10789 :com.palletops.awaze.client-builder/undef)
     (. bean10787 setEnvironmentId (clojure.core/str v10789))))
   (clojure.core/let
    [v10789
     (:environment-name
      m10788
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10789 :com.palletops.awaze.client-builder/undef)
     (. bean10787 setEnvironmentName (clojure.core/str v10789))))
   bean10787))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest}
delete-application-request
  [m10791]
  (clojure.core/let
   [bean10790
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/let
    [v10792
     (:application-name
      m10791
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10792 :com.palletops.awaze.client-builder/undef)
     (. bean10790 setApplicationName (clojure.core/str v10792))))
   (clojure.core/let
    [v10792
     (:terminate-env-by-force
      m10791
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10792 :com.palletops.awaze.client-builder/undef)
     (.
      bean10790
      setTerminateEnvByForce
      (clojure.core/boolean v10792))))
   bean10790))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest}
create-application-request
  [m10794]
  (clojure.core/let
   [bean10793
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/let
    [v10795
     (:application-name
      m10794
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10795 :com.palletops.awaze.client-builder/undef)
     (. bean10793 setApplicationName (clojure.core/str v10795))))
   (clojure.core/let
    [v10795
     (:description m10794 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10795 :com.palletops.awaze.client-builder/undef)
     (. bean10793 setDescription (clojure.core/str v10795))))
   bean10793))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest}
delete-configuration-template-request
  [m10797]
  (clojure.core/let
   [bean10796
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/let
    [v10798
     (:application-name
      m10797
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10798 :com.palletops.awaze.client-builder/undef)
     (. bean10796 setApplicationName (clojure.core/str v10798))))
   (clojure.core/let
    [v10798
     (:template-name m10797 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10798 :com.palletops.awaze.client-builder/undef)
     (. bean10796 setTemplateName (clojure.core/str v10798))))
   bean10796))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest}
swap-environment-cnames-request
  [m10800]
  (clojure.core/let
   [bean10799
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/let
    [v10801
     (:source-environment-id
      m10800
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10801 :com.palletops.awaze.client-builder/undef)
     (. bean10799 setSourceEnvironmentId (clojure.core/str v10801))))
   (clojure.core/let
    [v10801
     (:source-environment-name
      m10800
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10801 :com.palletops.awaze.client-builder/undef)
     (. bean10799 setSourceEnvironmentName (clojure.core/str v10801))))
   (clojure.core/let
    [v10801
     (:destination-environment-id
      m10800
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10801 :com.palletops.awaze.client-builder/undef)
     (.
      bean10799
      setDestinationEnvironmentId
      (clojure.core/str v10801))))
   (clojure.core/let
    [v10801
     (:destination-environment-name
      m10800
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10801 :com.palletops.awaze.client-builder/undef)
     (.
      bean10799
      setDestinationEnvironmentName
      (clojure.core/str v10801))))
   bean10799))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest}
describe-environment-health-request
  [m10803]
  (clojure.core/let
   [bean10802
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest)]
   (clojure.core/let
    [v10804
     (:environment-id
      m10803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10804 :com.palletops.awaze.client-builder/undef)
     (. bean10802 setEnvironmentId (clojure.core/str v10804))))
   (clojure.core/let
    [v10804
     (:environment-name
      m10803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10804 :com.palletops.awaze.client-builder/undef)
     (. bean10802 setEnvironmentName (clojure.core/str v10804))))
   (clojure.core/let
    [v10804
     (:attribute-names
      m10803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10804 :com.palletops.awaze.client-builder/undef)
     (.
      bean10802
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10854] (clojure.core/str arg10854))
 v10804))))
   bean10802))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest}
abort-environment-update-request
  [m10806]
  (clojure.core/let
   [bean10805
    (new
     com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest)]
   (clojure.core/let
    [v10807
     (:environment-id
      m10806
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10807 :com.palletops.awaze.client-builder/undef)
     (. bean10805 setEnvironmentId (clojure.core/str v10807))))
   (clojure.core/let
    [v10807
     (:environment-name
      m10806
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10807 :com.palletops.awaze.client-builder/undef)
     (. bean10805 setEnvironmentName (clojure.core/str v10807))))
   bean10805))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest}
check-dnsavailability-request
  [m10809]
  (clojure.core/let
   [bean10808
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/let
    [v10810
     (:cnameprefix m10809 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10810 :com.palletops.awaze.client-builder/undef)
     (. bean10808 setCNAMEPrefix (clojure.core/str v10810))))
   bean10808))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest}
retrieve-environment-info-request
  [m10812]
  (clojure.core/let
   [bean10811
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/let
    [v10813
     (:environment-id
      m10812
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10813 :com.palletops.awaze.client-builder/undef)
     (. bean10811 setEnvironmentId (clojure.core/str v10813))))
   (clojure.core/let
    [v10813
     (:environment-name
      m10812
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10813 :com.palletops.awaze.client-builder/undef)
     (. bean10811 setEnvironmentName (clojure.core/str v10813))))
   (clojure.core/let
    [v10813
     (:info-type m10812 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10813 :com.palletops.awaze.client-builder/undef)
     (. bean10811 setInfoType (clojure.core/str v10813))))
   bean10811))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest}
create-application-version-request
  [m10815]
  (clojure.core/let
   [bean10814
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/let
    [v10816
     (:application-name
      m10815
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10816 :com.palletops.awaze.client-builder/undef)
     (. bean10814 setApplicationName (clojure.core/str v10816))))
   (clojure.core/let
    [v10816
     (:process m10815 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10816 :com.palletops.awaze.client-builder/undef)
     (. bean10814 setProcess (clojure.core/boolean v10816))))
   (clojure.core/let
    [v10816
     (:version-label m10815 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10816 :com.palletops.awaze.client-builder/undef)
     (. bean10814 setVersionLabel (clojure.core/str v10816))))
   (clojure.core/let
    [v10816
     (:source-bundle m10815 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10816 :com.palletops.awaze.client-builder/undef)
     (.
      bean10814
      setSourceBundle
      (elasticbeanstalk/s3location v10816))))
   (clojure.core/let
    [v10816
     (:auto-create-application
      m10815
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10816 :com.palletops.awaze.client-builder/undef)
     (.
      bean10814
      setAutoCreateApplication
      (clojure.core/boolean v10816))))
   (clojure.core/let
    [v10816
     (:description m10815 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10816 :com.palletops.awaze.client-builder/undef)
     (. bean10814 setDescription (clojure.core/str v10816))))
   bean10814))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest}
describe-environments-request
  [m10818]
  (clojure.core/let
   [bean10817
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/let
    [v10819
     (:application-name
      m10818
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10819 :com.palletops.awaze.client-builder/undef)
     (. bean10817 setApplicationName (clojure.core/str v10819))))
   (clojure.core/let
    [v10819
     (:version-label m10818 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10819 :com.palletops.awaze.client-builder/undef)
     (. bean10817 setVersionLabel (clojure.core/str v10819))))
   (clojure.core/let
    [v10819
     (:environment-names
      m10818
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10819 :com.palletops.awaze.client-builder/undef)
     (.
      bean10817
      setEnvironmentNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10903] (clojure.core/str arg10903))
 v10819))))
   (clojure.core/let
    [v10819
     (:include-deleted
      m10818
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10819 :com.palletops.awaze.client-builder/undef)
     (. bean10817 setIncludeDeleted (clojure.core/boolean v10819))))
   (clojure.core/let
    [v10819
     (:included-deleted-back-to
      m10818
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10819 :com.palletops.awaze.client-builder/undef)
     (.
      bean10817
      setIncludedDeletedBackTo
      (com.palletops.awaze.common/to-date v10819))))
   (clojure.core/let
    [v10819
     (:environment-ids
      m10818
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10819 :com.palletops.awaze.client-builder/undef)
     (.
      bean10817
      setEnvironmentIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10904] (clojure.core/str arg10904))
 v10819))))
   bean10817))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest}
update-configuration-template-request
  [m10821]
  (clojure.core/let
   [bean10820
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10822
     (:option-settings
      m10821
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10822 :com.palletops.awaze.client-builder/undef)
     (.
      bean10820
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10905]
  (elasticbeanstalk/configuration-option-setting arg10905))
 v10822))))
   (clojure.core/let
    [v10822
     (:application-name
      m10821
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10822 :com.palletops.awaze.client-builder/undef)
     (. bean10820 setApplicationName (clojure.core/str v10822))))
   (clojure.core/let
    [v10822
     (:template-name m10821 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10822 :com.palletops.awaze.client-builder/undef)
     (. bean10820 setTemplateName (clojure.core/str v10822))))
   (clojure.core/let
    [v10822
     (:description m10821 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10822 :com.palletops.awaze.client-builder/undef)
     (. bean10820 setDescription (clojure.core/str v10822))))
   (clojure.core/let
    [v10822
     (:options-to-remove
      m10821
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10822 :com.palletops.awaze.client-builder/undef)
     (.
      bean10820
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10906]
  (elasticbeanstalk/option-specification arg10906))
 v10822))))
   bean10820))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest}
describe-environment-resources-request
  [m10824]
  (clojure.core/let
   [bean10823
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/let
    [v10825
     (:environment-id
      m10824
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10825 :com.palletops.awaze.client-builder/undef)
     (. bean10823 setEnvironmentId (clojure.core/str v10825))))
   (clojure.core/let
    [v10825
     (:environment-name
      m10824
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10825 :com.palletops.awaze.client-builder/undef)
     (. bean10823 setEnvironmentName (clojure.core/str v10825))))
   bean10823))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest}
list-available-solution-stacks-request
  [m10827]
  (clojure.core/let
   [bean10826
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean10826))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest}
validate-configuration-settings-request
  [m10830]
  (clojure.core/let
   [bean10829
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/let
    [v10831
     (:option-settings
      m10830
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10831 :com.palletops.awaze.client-builder/undef)
     (.
      bean10829
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10907]
  (elasticbeanstalk/configuration-option-setting arg10907))
 v10831))))
   (clojure.core/let
    [v10831
     (:environment-name
      m10830
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10831 :com.palletops.awaze.client-builder/undef)
     (. bean10829 setEnvironmentName (clojure.core/str v10831))))
   (clojure.core/let
    [v10831
     (:application-name
      m10830
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10831 :com.palletops.awaze.client-builder/undef)
     (. bean10829 setApplicationName (clojure.core/str v10831))))
   (clojure.core/let
    [v10831
     (:template-name m10830 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10831 :com.palletops.awaze.client-builder/undef)
     (. bean10829 setTemplateName (clojure.core/str v10831))))
   bean10829))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest}
describe-instances-health-request
  [m10833]
  (clojure.core/let
   [bean10832
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest)]
   (clojure.core/let
    [v10834
     (:environment-id
      m10833
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10834 :com.palletops.awaze.client-builder/undef)
     (. bean10832 setEnvironmentId (clojure.core/str v10834))))
   (clojure.core/let
    [v10834
     (:environment-name
      m10833
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10834 :com.palletops.awaze.client-builder/undef)
     (. bean10832 setEnvironmentName (clojure.core/str v10834))))
   (clojure.core/let
    [v10834
     (:next-token m10833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10834 :com.palletops.awaze.client-builder/undef)
     (. bean10832 setNextToken (clojure.core/str v10834))))
   (clojure.core/let
    [v10834
     (:attribute-names
      m10833
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10834 :com.palletops.awaze.client-builder/undef)
     (.
      bean10832
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10908] (clojure.core/str arg10908))
 v10834))))
   bean10832))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest}
update-application-request
  [m10836]
  (clojure.core/let
   [bean10835
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/let
    [v10837
     (:application-name
      m10836
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10837 :com.palletops.awaze.client-builder/undef)
     (. bean10835 setApplicationName (clojure.core/str v10837))))
   (clojure.core/let
    [v10837
     (:description m10836 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10837 :com.palletops.awaze.client-builder/undef)
     (. bean10835 setDescription (clojure.core/str v10837))))
   bean10835))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest}
request-environment-info-request
  [m10839]
  (clojure.core/let
   [bean10838
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/let
    [v10840
     (:environment-id
      m10839
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10840 :com.palletops.awaze.client-builder/undef)
     (. bean10838 setEnvironmentId (clojure.core/str v10840))))
   (clojure.core/let
    [v10840
     (:environment-name
      m10839
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10840 :com.palletops.awaze.client-builder/undef)
     (. bean10838 setEnvironmentName (clojure.core/str v10840))))
   (clojure.core/let
    [v10840
     (:info-type m10839 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10840 :com.palletops.awaze.client-builder/undef)
     (. bean10838 setInfoType (clojure.core/str v10840))))
   bean10838))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest}
create-environment-request
  [m10842]
  (clojure.core/let
   [bean10841
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/let
    [v10843
     (:option-settings
      m10842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (.
      bean10841
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10909]
  (elasticbeanstalk/configuration-option-setting arg10909))
 v10843))))
   (clojure.core/let
    [v10843
     (:description m10842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setDescription (clojure.core/str v10843))))
   (clojure.core/let
    [v10843
     (:cnameprefix m10842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setCNAMEPrefix (clojure.core/str v10843))))
   (clojure.core/let
    [v10843
     (:solution-stack-name
      m10842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setSolutionStackName (clojure.core/str v10843))))
   (clojure.core/let
    [v10843 (:tier m10842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setTier (elasticbeanstalk/environment-tier v10843))))
   (clojure.core/let
    [v10843
     (:version-label m10842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setVersionLabel (clojure.core/str v10843))))
   (clojure.core/let
    [v10843
     (:template-name m10842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setTemplateName (clojure.core/str v10843))))
   (clojure.core/let
    [v10843
     (:environment-name
      m10842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setEnvironmentName (clojure.core/str v10843))))
   (clojure.core/let
    [v10843 (:tags m10842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (.
      bean10841
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10910] (elasticbeanstalk/tag arg10910))
 v10843))))
   (clojure.core/let
    [v10843
     (:options-to-remove
      m10842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (.
      bean10841
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10911]
  (elasticbeanstalk/option-specification arg10911))
 v10843))))
   (clojure.core/let
    [v10843
     (:group-name m10842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setGroupName (clojure.core/str v10843))))
   (clojure.core/let
    [v10843
     (:application-name
      m10842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10843 :com.palletops.awaze.client-builder/undef)
     (. bean10841 setApplicationName (clojure.core/str v10843))))
   bean10841))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest}
delete-application-version-request
  [m10845]
  (clojure.core/let
   [bean10844
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/let
    [v10846
     (:application-name
      m10845
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10846 :com.palletops.awaze.client-builder/undef)
     (. bean10844 setApplicationName (clojure.core/str v10846))))
   (clojure.core/let
    [v10846
     (:version-label m10845 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10846 :com.palletops.awaze.client-builder/undef)
     (. bean10844 setVersionLabel (clojure.core/str v10846))))
   (clojure.core/let
    [v10846
     (:delete-source-bundle
      m10845
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10846 :com.palletops.awaze.client-builder/undef)
     (. bean10844 setDeleteSourceBundle (clojure.core/boolean v10846))))
   bean10844))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m10855]
   (clojure.core/let
    [credentials10856 (:credentials m10855) args10857 (:args m10855)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10858
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10856)]
     (clojure.core/case
      (clojure.core/count args10857)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10858
        describeApplicationVersions
        (elasticbeanstalk/describe-application-versions-request
         (clojure.core/nth args10857 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10858
        describeApplicationVersions))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-application-versions,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-application-versions,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-application-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials10860 & args10861]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10862
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10860)]
    (clojure.core/case
     (clojure.core/count args10861)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10862
       describeApplicationVersions
       (elasticbeanstalk/describe-application-versions-request
        (clojure.core/nth args10861 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10862
       describeApplicationVersions))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :compose-environments
   [m10863]
   (clojure.core/let
    [credentials10864 (:credentials m10863) args10865 (:args m10863)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10866
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10864)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10866
       composeEnvironments
       (elasticbeanstalk/compose-environments-request
        (clojure.core/nth args10865 0)))))))
  (clojure.core/defn
   compose-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for composeEnvironments"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :compose-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   compose-environments
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call composeEnvironments"}
   [credentials10868 & args10869]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10870
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10868)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10870
      composeEnvironments
      (elasticbeanstalk/compose-environments-request
       (clojure.core/nth args10869 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m10871]
   (clojure.core/let
    [credentials10872 (:credentials m10871) args10873 (:args m10871)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10874
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10872)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10874
       rebuildEnvironment
       (elasticbeanstalk/rebuild-environment-request
        (clojure.core/nth args10873 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :rebuild-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   rebuild-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call rebuildEnvironment"}
   [credentials10876 & args10877]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10878
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10876)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10878
      rebuildEnvironment
      (elasticbeanstalk/rebuild-environment-request
       (clojure.core/nth args10877 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m10879]
   (clojure.core/let
    [credentials10880 (:credentials m10879) args10881 (:args m10879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10882
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10880)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10882
       updateApplicationVersion
       (elasticbeanstalk/update-application-version-request
        (clojure.core/nth args10881 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplicationVersion"}
   [credentials10884 & args10885]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10886
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10884)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10886
      updateApplicationVersion
      (elasticbeanstalk/update-application-version-request
       (clojure.core/nth args10885 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m10887]
   (clojure.core/let
    [credentials10888 (:credentials m10887) args10889 (:args m10887)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10890
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10888)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10890
       deleteEnvironmentConfiguration
       (elasticbeanstalk/delete-environment-configuration-request
        (clojure.core/nth args10889 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-environment-configuration,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials10892 & args10893]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10894
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10892)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10894
      deleteEnvironmentConfiguration
      (elasticbeanstalk/delete-environment-configuration-request
       (clojure.core/nth args10893 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m10895]
   (clojure.core/let
    [credentials10896 (:credentials m10895) args10897 (:args m10895)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10898
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10896)]
     (clojure.core/case
      (clojure.core/count args10897)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10898
        describeEvents
        (elasticbeanstalk/describe-events-request
         (clojure.core/nth args10897 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10898
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials10900 & args10901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10902
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10900)]
    (clojure.core/case
     (clojure.core/count args10901)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10902
       describeEvents
       (elasticbeanstalk/describe-events-request
        (clojure.core/nth args10901 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10902
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m10912]
   (clojure.core/let
    [credentials10913 (:credentials m10912) args10914 (:args m10912)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10915
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10913)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10915
       describeConfigurationSettings
       (elasticbeanstalk/describe-configuration-settings-request
        (clojure.core/nth args10914 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-configuration-settings,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationSettings"}
   [credentials10917 & args10918]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10919
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10917)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10919
      describeConfigurationSettings
      (elasticbeanstalk/describe-configuration-settings-request
       (clojure.core/nth args10918 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m10920]
   (clojure.core/let
    [credentials10921 (:credentials m10920) args10922 (:args m10920)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10923
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10921)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10923
       terminateEnvironment
       (elasticbeanstalk/terminate-environment-request
        (clojure.core/nth args10922 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for terminateEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   terminate-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call terminateEnvironment"}
   [credentials10925 & args10926]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10927
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10925)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10927
      terminateEnvironment
      (elasticbeanstalk/terminate-environment-request
       (clojure.core/nth args10926 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m10928]
   (clojure.core/let
    [credentials10929 (:credentials m10928) args10930 (:args m10928)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10931
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10929)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10931
       describeConfigurationOptions
       (elasticbeanstalk/describe-configuration-options-request
        (clojure.core/nth args10930 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-configuration-options,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationOptions"}
   [credentials10933 & args10934]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10935
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10933)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10935
      describeConfigurationOptions
      (elasticbeanstalk/describe-configuration-options-request
       (clojure.core/nth args10934 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m10936]
   (clojure.core/let
    [credentials10937 (:credentials m10936) args10938 (:args m10936)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10939
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10937)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10939
       createConfigurationTemplate
       (elasticbeanstalk/create-configuration-template-request
        (clojure.core/nth args10938 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call createConfigurationTemplate"}
   [credentials10941 & args10942]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10943
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10941)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10943
      createConfigurationTemplate
      (elasticbeanstalk/create-configuration-template-request
       (clojure.core/nth args10942 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m10944]
   (clojure.core/let
    [credentials10945 (:credentials m10944) args10946 (:args m10944)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10947
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10945)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10947
       updateEnvironment
       (elasticbeanstalk/update-environment-request
        (clojure.core/nth args10946 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for updateEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call updateEnvironment"}
   [credentials10949 & args10950]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10951
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10949)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10951
      updateEnvironment
      (elasticbeanstalk/update-environment-request
       (clojure.core/nth args10950 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m10952]
   (clojure.core/let
    [credentials10953 (:credentials m10952) args10954 (:args m10952)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10955
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10953)]
     (clojure.core/case
      (clojure.core/count args10954)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10955
        describeApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10955
        describeApplications
        (elasticbeanstalk/describe-applications-request
         (clojure.core/nth args10954 0))))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]]),
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-applications,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-applications,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-applications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]]),
    :doc "Call describeApplications, describeApplications"}
   [credentials10957 & args10958]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10959
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10957)]
    (clojure.core/case
     (clojure.core/count args10958)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10959
       describeApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10959
       describeApplications
       (elasticbeanstalk/describe-applications-request
        (clojure.core/nth args10958 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m10960]
   (clojure.core/let
    [credentials10961 (:credentials m10960) args10962 (:args m10960)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10963
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10961)]
     (clojure.core/case
      (clojure.core/count args10962)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10963
        createStorageLocation
        (elasticbeanstalk/create-storage-location-request
         (clojure.core/nth args10962 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10963
        createStorageLocation))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-storage-location,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-storage-location,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-storage-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials10965 & args10966]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10967
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10965)]
    (clojure.core/case
     (clojure.core/count args10966)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10967
       createStorageLocation
       (elasticbeanstalk/create-storage-location-request
        (clojure.core/nth args10966 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10967
       createStorageLocation))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m10968]
   (clojure.core/let
    [credentials10969 (:credentials m10968) args10970 (:args m10968)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10971
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10969)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10971
       restartAppServer
       (elasticbeanstalk/restart-app-server-request
        (clojure.core/nth args10970 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for restartAppServer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restart-app-server,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   restart-app-server
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call restartAppServer"}
   [credentials10973 & args10974]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10975
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10973)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10975
      restartAppServer
      (elasticbeanstalk/restart-app-server-request
       (clojure.core/nth args10974 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m10976]
   (clojure.core/let
    [credentials10977 (:credentials m10976) args10978 (:args m10976)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10979
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10977)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10979
       deleteApplication
       (elasticbeanstalk/delete-application-request
        (clojure.core/nth args10978 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplication"}
   [credentials10981 & args10982]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10983
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10981)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10983
      deleteApplication
      (elasticbeanstalk/delete-application-request
       (clojure.core/nth args10982 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m10984]
   (clojure.core/let
    [credentials10985 (:credentials m10984) args10986 (:args m10984)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10987
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10985)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10987
       createApplication
       (elasticbeanstalk/create-application-request
        (clojure.core/nth args10986 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createApplication"}
   [credentials10989 & args10990]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10991
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10989)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10991
      createApplication
      (elasticbeanstalk/create-application-request
       (clojure.core/nth args10990 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m10992]
   (clojure.core/let
    [credentials10993 (:credentials m10992) args10994 (:args m10992)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10995
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10993)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10995
       deleteConfigurationTemplate
       (elasticbeanstalk/delete-configuration-template-request
        (clojure.core/nth args10994 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConfigurationTemplate"}
   [credentials10997 & args10998]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10999
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10997)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10999
      deleteConfigurationTemplate
      (elasticbeanstalk/delete-configuration-template-request
       (clojure.core/nth args10998 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m11000]
   (clojure.core/let
    [credentials11001 (:credentials m11000) args11002 (:args m11000)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11003
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11001)]
     (clojure.core/case
      (clojure.core/count args11002)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11003
        swapEnvironmentCNAMEs
        (elasticbeanstalk/swap-environment-cnames-request
         (clojure.core/nth args11002 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11003
        swapEnvironmentCNAMEs))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]
                [credentials]]),
    :doc "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :swap-environment-cnames,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :swap-environment-cnames,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]
                [credentials]]),
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials11005 & args11006]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11007
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11005)]
    (clojure.core/case
     (clojure.core/count args11006)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11007
       swapEnvironmentCNAMEs
       (elasticbeanstalk/swap-environment-cnames-request
        (clojure.core/nth args11006 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11007
       swapEnvironmentCNAMEs))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-health
   [m11008]
   (clojure.core/let
    [credentials11009 (:credentials m11008) args11010 (:args m11008)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11011
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11009)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11011
       describeEnvironmentHealth
       (elasticbeanstalk/describe-environment-health-request
        (clojure.core/nth args11010 0)))))))
  (clojure.core/defn
   describe-environment-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environment-health,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentHealth"}
   [credentials11013 & args11014]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11015
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11013)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11015
      describeEnvironmentHealth
      (elasticbeanstalk/describe-environment-health-request
       (clojure.core/nth args11014 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :abort-environment-update
   [m11016]
   (clojure.core/let
    [credentials11017 (:credentials m11016) args11018 (:args m11016)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11019
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11017)]
     (clojure.core/case
      (clojure.core/count args11018)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11019
        abortEnvironmentUpdate
        (elasticbeanstalk/abort-environment-update-request
         (clojure.core/nth args11018 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11019
        abortEnvironmentUpdate))))))
  (clojure.core/defn
   abort-environment-update-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for abortEnvironmentUpdate, abortEnvironmentUpdate"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :abort-environment-update,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-environment-update,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   abort-environment-update
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]
                [credentials]]),
    :doc "Call abortEnvironmentUpdate, abortEnvironmentUpdate"}
   [credentials11021 & args11022]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11023
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11021)]
    (clojure.core/case
     (clojure.core/count args11022)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11023
       abortEnvironmentUpdate
       (elasticbeanstalk/abort-environment-update-request
        (clojure.core/nth args11022 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11023
       abortEnvironmentUpdate))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m11024]
   (clojure.core/let
    [credentials11025 (:credentials m11024) args11026 (:args m11024)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11027
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11025)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11027
       checkDNSAvailability
       (elasticbeanstalk/check-dnsavailability-request
        (clojure.core/nth args11026 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :check-dnsavailability,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call checkDNSAvailability"}
   [credentials11029 & args11030]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11031
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11029)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11031
      checkDNSAvailability
      (elasticbeanstalk/check-dnsavailability-request
       (clojure.core/nth args11030 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m11032]
   (clojure.core/let
    [credentials11033 (:credentials m11032) args11034 (:args m11032)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11035
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11033)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11035
       retrieveEnvironmentInfo
       (elasticbeanstalk/retrieve-environment-info-request
        (clojure.core/nth args11034 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-environment-info,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call retrieveEnvironmentInfo"}
   [credentials11037 & args11038]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11039
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11037)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11039
      retrieveEnvironmentInfo
      (elasticbeanstalk/retrieve-environment-info-request
       (clojure.core/nth args11038 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m11040]
   (clojure.core/let
    [credentials11041 (:credentials m11040) args11042 (:args m11040)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11043
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11041)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11043
       createApplicationVersion
       (elasticbeanstalk/create-application-version-request
        (clojure.core/nth args11042 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Generate map for createApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Call createApplicationVersion"}
   [credentials11045 & args11046]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11047
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11045)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11047
      createApplicationVersion
      (elasticbeanstalk/create-application-version-request
       (clojure.core/nth args11046 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m11048]
   (clojure.core/let
    [credentials11049 (:credentials m11048) args11050 (:args m11048)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11051
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11049)]
     (clojure.core/case
      (clojure.core/count args11050)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11051
        describeEnvironments))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11051
        describeEnvironments
        (elasticbeanstalk/describe-environments-request
         (clojure.core/nth args11050 0))))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]]),
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environments
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]]),
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials11053 & args11054]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11055
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11053)]
    (clojure.core/case
     (clojure.core/count args11054)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11055
       describeEnvironments))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11055
       describeEnvironments
       (elasticbeanstalk/describe-environments-request
        (clojure.core/nth args11054 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m11056]
   (clojure.core/let
    [credentials11057 (:credentials m11056) args11058 (:args m11056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11059
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11057)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11059
       updateConfigurationTemplate
       (elasticbeanstalk/update-configuration-template-request
        (clojure.core/nth args11058 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call updateConfigurationTemplate"}
   [credentials11061 & args11062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11063
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11061)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11063
      updateConfigurationTemplate
      (elasticbeanstalk/update-configuration-template-request
       (clojure.core/nth args11062 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m11064]
   (clojure.core/let
    [credentials11065 (:credentials m11064) args11066 (:args m11064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11067
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11065)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11067
       describeEnvironmentResources
       (elasticbeanstalk/describe-environment-resources-request
        (clojure.core/nth args11066 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environment-resources,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentResources"}
   [credentials11069 & args11070]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11071
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11069)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11071
      describeEnvironmentResources
      (elasticbeanstalk/describe-environment-resources-request
       (clojure.core/nth args11070 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m11072]
   (clojure.core/let
    [credentials11073 (:credentials m11072) args11074 (:args m11072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11075
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11073)]
     (clojure.core/case
      (clojure.core/count args11074)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11075
        listAvailableSolutionStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11075
        listAvailableSolutionStacks
        (elasticbeanstalk/list-available-solution-stacks-request
         (clojure.core/nth args11074 0))))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-available-solution-stacks,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-available-solution-stacks,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials11077 & args11078]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11079
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11077)]
    (clojure.core/case
     (clojure.core/count args11078)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11079
       listAvailableSolutionStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11079
       listAvailableSolutionStacks
       (elasticbeanstalk/list-available-solution-stacks-request
        (clojure.core/nth args11078 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m11080]
   (clojure.core/let
    [credentials11081 (:credentials m11080) args11082 (:args m11080)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11083
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11081)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11083
       validateConfigurationSettings
       (elasticbeanstalk/validate-configuration-settings-request
        (clojure.core/nth args11082 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-configuration-settings,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call validateConfigurationSettings"}
   [credentials11085 & args11086]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11087
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11085)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11087
      validateConfigurationSettings
      (elasticbeanstalk/validate-configuration-settings-request
       (clojure.core/nth args11086 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-instances-health
   [m11088]
   (clojure.core/let
    [credentials11089 (:credentials m11088) args11090 (:args m11088)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11091
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11089)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11091
       describeInstancesHealth
       (elasticbeanstalk/describe-instances-health-request
        (clojure.core/nth args11090 0)))))))
  (clojure.core/defn
   describe-instances-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstancesHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instances-health,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-instances-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstancesHealth"}
   [credentials11093 & args11094]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11095
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11093)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11095
      describeInstancesHealth
      (elasticbeanstalk/describe-instances-health-request
       (clojure.core/nth args11094 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m11096]
   (clojure.core/let
    [credentials11097 (:credentials m11096) args11098 (:args m11096)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11099
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11097)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11099
       updateApplication
       (elasticbeanstalk/update-application-request
        (clojure.core/nth args11098 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplication"}
   [credentials11101 & args11102]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11103
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11101)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11103
      updateApplication
      (elasticbeanstalk/update-application-request
       (clojure.core/nth args11102 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m11104]
   (clojure.core/let
    [credentials11105 (:credentials m11104) args11106 (:args m11104)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11107
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11105)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11107
       requestEnvironmentInfo
       (elasticbeanstalk/request-environment-info-request
        (clojure.core/nth args11106 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-environment-info,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   request-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call requestEnvironmentInfo"}
   [credentials11109 & args11110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11111
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11109)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11111
      requestEnvironmentInfo
      (elasticbeanstalk/request-environment-info-request
       (clojure.core/nth args11110 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m11112]
   (clojure.core/let
    [credentials11113 (:credentials m11112) args11114 (:args m11112)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11115
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11113)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11115
       createEnvironment
       (elasticbeanstalk/create-environment-request
        (clojure.core/nth args11114 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for createEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call createEnvironment"}
   [credentials11117 & args11118]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11119
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11117)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11119
      createEnvironment
      (elasticbeanstalk/create-environment-request
       (clojure.core/nth args11118 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m11120]
   (clojure.core/let
    [credentials11121 (:credentials m11120) args11122 (:args m11120)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11123
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11121)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11123
       deleteApplicationVersion
       (elasticbeanstalk/delete-application-version-request
        (clojure.core/nth args11122 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application-version
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplicationVersion"}
   [credentials11125 & args11126]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11127
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11125)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11127
      deleteApplicationVersion
      (elasticbeanstalk/delete-application-version-request
       (clojure.core/nth args11126 0))))))))
