(ns
 com.palletops.awaze.elasticache
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticache :as elasticache]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ParameterNameValue}
parameter-name-value
  [m14351]
  (clojure.core/let
   [bean14350
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/let
    [v14352
     (:parameter-name
      m14351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setParameterName (clojure.core/str v14352))))
   (clojure.core/let
    [v14352
     (:parameter-value
      m14351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setParameterValue (clojure.core/str v14352))))
   bean14350))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AZMode}
azmode
  [m14354]
  (.
   com.amazonaws.services.elasticache.model.AZMode
   fromValue
   (clojure.core/name m14354)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.Tag}
tag
  [m14357]
  (clojure.core/let
   [bean14356 (new com.amazonaws.services.elasticache.model.Tag)]
   (clojure.core/let
    [v14358 (:key m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setKey (clojure.core/str v14358))))
   (clojure.core/let
    [v14358 (:value m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setValue (clojure.core/str v14358))))
   bean14356))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.SourceType}
source-type
  [m14360]
  (.
   com.amazonaws.services.elasticache.model.SourceType
   fromValue
   (clojure.core/name m14360)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest}
modify-cache-parameter-group-request
  [m14363]
  (clojure.core/let
   [bean14362
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/let
    [v14364
     (:parameter-name-values
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14476]
  (elasticache/parameter-name-value arg14476))
 v14364))))
   (clojure.core/let
    [v14364
     (:cache-parameter-group-name
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setCacheParameterGroupName
      (clojure.core/str v14364))))
   bean14362))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest}
describe-replication-groups-request
  [m14366]
  (clojure.core/let
   [bean14365
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/let
    [v14367
     (:replication-group-id
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setReplicationGroupId (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:marker m14366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setMarker (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:max-records m14366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setMaxRecords (clojure.core/int v14367))))
   bean14365))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheClusterRequest}
create-cache-cluster-request
  [m14369]
  (clojure.core/let
   [bean14368
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/let
    [v14370
     (:engine m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setEngine (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:preferred-availability-zones
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setPreferredAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14477] (clojure.core/str arg14477))
 v14370))))
   (clojure.core/let
    [v14370
     (:cache-subnet-group-name
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setCacheSubnetGroupName (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:replication-group-id
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setReplicationGroupId (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:security-group-ids
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14478] (clojure.core/str arg14478))
 v14370))))
   (clojure.core/let
    [v14370
     (:snapshot-retention-limit
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setSnapshotRetentionLimit (clojure.core/int v14370))))
   (clojure.core/let
    [v14370
     (:preferred-maintenance-window
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setPreferredMaintenanceWindow
      (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:azmode m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setAZMode (elasticache/azmode v14370))))
   (clojure.core/let
    [v14370
     (:notification-topic-arn
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setNotificationTopicArn (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:cache-security-group-names
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14479] (clojure.core/str arg14479))
 v14370))))
   (clojure.core/let
    [v14370
     (:snapshot-name m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setSnapshotName (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:preferred-availability-zone
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setPreferredAvailabilityZone
      (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:snapshot-arns m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14480] (clojure.core/str arg14480))
 v14370))))
   (clojure.core/let
    [v14370 (:port m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setPort (clojure.core/int v14370))))
   (clojure.core/let
    [v14370 (:tags m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14481] (elasticache/tag arg14481))
 v14370))))
   (clojure.core/let
    [v14370
     (:cache-parameter-group-name
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setCacheParameterGroupName
      (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:cache-cluster-id
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setCacheClusterId (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:num-cache-nodes
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setNumCacheNodes (clojure.core/int v14370))))
   (clojure.core/let
    [v14370
     (:auto-minor-version-upgrade
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14370))))
   (clojure.core/let
    [v14370
     (:snapshot-window
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setSnapshotWindow (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:engine-version
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setEngineVersion (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:cache-node-type
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setCacheNodeType (clojure.core/str v14370))))
   bean14368))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest}
describe-cache-parameter-groups-request
  [m14372]
  (clojure.core/let
   [bean14371
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/let
    [v14373
     (:cache-parameter-group-name
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setCacheParameterGroupName
      (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:marker m14372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setMarker (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:max-records m14372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setMaxRecords (clojure.core/int v14373))))
   bean14371))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest}
delete-cache-parameter-group-request
  [m14375]
  (clojure.core/let
   [bean14374
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/let
    [v14376
     (:cache-parameter-group-name
      m14375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14376 :com.palletops.awaze.client-builder/undef)
     (.
      bean14374
      setCacheParameterGroupName
      (clojure.core/str v14376))))
   bean14374))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest}
create-cache-security-group-request
  [m14378]
  (clojure.core/let
   [bean14377
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14379
     (:cache-security-group-name
      m14378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (. bean14377 setCacheSecurityGroupName (clojure.core/str v14379))))
   (clojure.core/let
    [v14379
     (:description m14378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (. bean14377 setDescription (clojure.core/str v14379))))
   bean14377))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m14381]
  (clojure.core/let
   [bean14380
    (new
     com.amazonaws.services.elasticache.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v14382
     (:resource-name m14381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setResourceName (clojure.core/str v14382))))
   (clojure.core/let
    [v14382 (:tags m14381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14482] (elasticache/tag arg14482))
 v14382))))
   bean14380))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEventsRequest}
describe-events-request
  [m14384]
  (clojure.core/let
   [bean14383
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/let
    [v14385
     (:start-time m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (.
      bean14383
      setStartTime
      (com.palletops.awaze.common/to-date v14385))))
   (clojure.core/let
    [v14385
     (:end-time m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (.
      bean14383
      setEndTime
      (com.palletops.awaze.common/to-date v14385))))
   (clojure.core/let
    [v14385
     (:marker m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setMarker (clojure.core/str v14385))))
   (clojure.core/let
    [v14385
     (:source-identifier
      m14384
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setSourceIdentifier (clojure.core/str v14385))))
   (clojure.core/let
    [v14385
     (:source-type m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setSourceType (elasticache/source-type v14385))))
   (clojure.core/let
    [v14385
     (:duration m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setDuration (clojure.core/int v14385))))
   (clojure.core/let
    [v14385
     (:max-records m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setMaxRecords (clojure.core/int v14385))))
   bean14383))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest}
modify-cache-subnet-group-request
  [m14387]
  (clojure.core/let
   [bean14386
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14388
     (:cache-subnet-group-name
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setCacheSubnetGroupName (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:cache-subnet-group-description
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (.
      bean14386
      setCacheSubnetGroupDescription
      (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:subnet-ids m14387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (.
      bean14386
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14483] (clojure.core/str arg14483))
 v14388))))
   bean14386))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest}
revoke-cache-security-group-ingress-request
  [m14390]
  (clojure.core/let
   [bean14389
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14391
     (:cache-security-group-name
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setCacheSecurityGroupName (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:ec2security-group-name
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setEC2SecurityGroupName (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:ec2security-group-owner-id
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14391))))
   bean14389))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest}
describe-reserved-cache-nodes-request
  [m14393]
  (clojure.core/let
   [bean14392
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/let
    [v14394
     (:cache-node-type
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setCacheNodeType (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:reserved-cache-node-id
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setReservedCacheNodeId (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:reserved-cache-nodes-offering-id
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setReservedCacheNodesOfferingId
      (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:offering-type m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setOfferingType (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:product-description
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setProductDescription (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:marker m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setMarker (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:duration m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setDuration (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:max-records m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setMaxRecords (clojure.core/int v14394))))
   bean14392))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RebootCacheClusterRequest}
reboot-cache-cluster-request
  [m14396]
  (clojure.core/let
   [bean14395
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/let
    [v14397
     (:cache-cluster-id
      m14396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setCacheClusterId (clojure.core/str v14397))))
   (clojure.core/let
    [v14397
     (:cache-node-ids-to-reboot
      m14396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (.
      bean14395
      setCacheNodeIdsToReboot
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14484] (clojure.core/str arg14484))
 v14397))))
   bean14395))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest}
describe-cache-clusters-request
  [m14399]
  (clojure.core/let
   [bean14398
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/let
    [v14400
     (:cache-cluster-id
      m14399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setCacheClusterId (clojure.core/str v14400))))
   (clojure.core/let
    [v14400
     (:show-cache-node-info
      m14399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setShowCacheNodeInfo (clojure.core/boolean v14400))))
   (clojure.core/let
    [v14400
     (:marker m14399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setMarker (clojure.core/str v14400))))
   (clojure.core/let
    [v14400
     (:max-records m14399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setMaxRecords (clojure.core/int v14400))))
   bean14398))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CopySnapshotRequest}
copy-snapshot-request
  [m14402]
  (clojure.core/let
   [bean14401
    (new com.amazonaws.services.elasticache.model.CopySnapshotRequest)]
   (clojure.core/let
    [v14403
     (:source-snapshot-name
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setSourceSnapshotName (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:target-snapshot-name
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setTargetSnapshotName (clojure.core/str v14403))))
   bean14401))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m14405]
  (clojure.core/let
   [bean14404
    (new
     com.amazonaws.services.elasticache.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v14406
     (:snapshot-name m14405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14406 :com.palletops.awaze.client-builder/undef)
     (. bean14404 setSnapshotName (clojure.core/str v14406))))
   bean14404))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest}
describe-cache-engine-versions-request
  [m14408]
  (clojure.core/let
   [bean14407
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/let
    [v14409
     (:cache-parameter-group-family
      m14408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (.
      bean14407
      setCacheParameterGroupFamily
      (clojure.core/str v14409))))
   (clojure.core/let
    [v14409
     (:marker m14408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setMarker (clojure.core/str v14409))))
   (clojure.core/let
    [v14409
     (:max-records m14408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setMaxRecords (clojure.core/int v14409))))
   (clojure.core/let
    [v14409
     (:engine m14408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setEngine (clojure.core/str v14409))))
   (clojure.core/let
    [v14409
     (:engine-version
      m14408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setEngineVersion (clojure.core/str v14409))))
   (clojure.core/let
    [v14409
     (:default-only m14408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setDefaultOnly (clojure.core/boolean v14409))))
   bean14407))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m14411]
  (clojure.core/let
   [bean14410
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/let
    [v14412
     (:cache-parameter-group-family
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setCacheParameterGroupFamily
      (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:marker m14411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setMarker (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:max-records m14411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setMaxRecords (clojure.core/int v14412))))
   bean14410))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest}
delete-replication-group-request
  [m14414]
  (clojure.core/let
   [bean14413
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/let
    [v14415
     (:replication-group-id
      m14414
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14415 :com.palletops.awaze.client-builder/undef)
     (. bean14413 setReplicationGroupId (clojure.core/str v14415))))
   (clojure.core/let
    [v14415
     (:final-snapshot-identifier
      m14414
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14415 :com.palletops.awaze.client-builder/undef)
     (.
      bean14413
      setFinalSnapshotIdentifier
      (clojure.core/str v14415))))
   (clojure.core/let
    [v14415
     (:retain-primary-cluster
      m14414
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14415 :com.palletops.awaze.client-builder/undef)
     (.
      bean14413
      setRetainPrimaryCluster
      (clojure.core/boolean v14415))))
   bean14413))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest}
create-cache-subnet-group-request
  [m14417]
  (clojure.core/let
   [bean14416
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14418
     (:cache-subnet-group-name
      m14417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setCacheSubnetGroupName (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:cache-subnet-group-description
      m14417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (.
      bean14416
      setCacheSubnetGroupDescription
      (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:subnet-ids m14417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (.
      bean14416
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14485] (clojure.core/str arg14485))
 v14418))))
   bean14416))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest}
modify-cache-cluster-request
  [m14420]
  (clojure.core/let
   [bean14419
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/let
    [v14421
     (:new-availability-zones
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setNewAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14486] (clojure.core/str arg14486))
 v14421))))
   (clojure.core/let
    [v14421
     (:security-group-ids
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14487] (clojure.core/str arg14487))
 v14421))))
   (clojure.core/let
    [v14421
     (:snapshot-retention-limit
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setSnapshotRetentionLimit (clojure.core/int v14421))))
   (clojure.core/let
    [v14421
     (:apply-immediately
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setApplyImmediately (clojure.core/boolean v14421))))
   (clojure.core/let
    [v14421
     (:preferred-maintenance-window
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setPreferredMaintenanceWindow
      (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:azmode m14420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setAZMode (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:notification-topic-arn
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setNotificationTopicArn (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:cache-security-group-names
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14488] (clojure.core/str arg14488))
 v14421))))
   (clojure.core/let
    [v14421
     (:cache-parameter-group-name
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setCacheParameterGroupName
      (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:cache-cluster-id
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setCacheClusterId (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:notification-topic-status
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setNotificationTopicStatus
      (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:num-cache-nodes
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setNumCacheNodes (clojure.core/int v14421))))
   (clojure.core/let
    [v14421
     (:cache-node-ids-to-remove
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setCacheNodeIdsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14489] (clojure.core/str arg14489))
 v14421))))
   (clojure.core/let
    [v14421
     (:auto-minor-version-upgrade
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14421))))
   (clojure.core/let
    [v14421
     (:snapshot-window
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setSnapshotWindow (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:engine-version
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setEngineVersion (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:cache-node-type
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setCacheNodeType (clojure.core/str v14421))))
   bean14419))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest}
authorize-cache-security-group-ingress-request
  [m14423]
  (clojure.core/let
   [bean14422
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14424
     (:cache-security-group-name
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setCacheSecurityGroupName (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:ec2security-group-name
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setEC2SecurityGroupName (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:ec2security-group-owner-id
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14424))))
   bean14422))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest}
describe-cache-parameters-request
  [m14426]
  (clojure.core/let
   [bean14425
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/let
    [v14427
     (:cache-parameter-group-name
      m14426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14427 :com.palletops.awaze.client-builder/undef)
     (.
      bean14425
      setCacheParameterGroupName
      (clojure.core/str v14427))))
   (clojure.core/let
    [v14427
     (:marker m14426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14427 :com.palletops.awaze.client-builder/undef)
     (. bean14425 setMarker (clojure.core/str v14427))))
   (clojure.core/let
    [v14427
     (:source m14426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14427 :com.palletops.awaze.client-builder/undef)
     (. bean14425 setSource (clojure.core/str v14427))))
   (clojure.core/let
    [v14427
     (:max-records m14426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14427 :com.palletops.awaze.client-builder/undef)
     (. bean14425 setMaxRecords (clojure.core/int v14427))))
   bean14425))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest}
delete-cache-cluster-request
  [m14429]
  (clojure.core/let
   [bean14428
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/let
    [v14430
     (:cache-cluster-id
      m14429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14430 :com.palletops.awaze.client-builder/undef)
     (. bean14428 setCacheClusterId (clojure.core/str v14430))))
   (clojure.core/let
    [v14430
     (:final-snapshot-identifier
      m14429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14430 :com.palletops.awaze.client-builder/undef)
     (.
      bean14428
      setFinalSnapshotIdentifier
      (clojure.core/str v14430))))
   bean14428))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest}
list-allowed-node-type-modifications-request
  [m14432]
  (clojure.core/let
   [bean14431
    (new
     com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest)]
   (clojure.core/let
    [v14433
     (:cache-cluster-id
      m14432
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14433 :com.palletops.awaze.client-builder/undef)
     (. bean14431 setCacheClusterId (clojure.core/str v14433))))
   (clojure.core/let
    [v14433
     (:replication-group-id
      m14432
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14433 :com.palletops.awaze.client-builder/undef)
     (. bean14431 setReplicationGroupId (clojure.core/str v14433))))
   bean14431))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest}
create-cache-parameter-group-request
  [m14435]
  (clojure.core/let
   [bean14434
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/let
    [v14436
     (:cache-parameter-group-name
      m14435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14436 :com.palletops.awaze.client-builder/undef)
     (.
      bean14434
      setCacheParameterGroupName
      (clojure.core/str v14436))))
   (clojure.core/let
    [v14436
     (:cache-parameter-group-family
      m14435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14436 :com.palletops.awaze.client-builder/undef)
     (.
      bean14434
      setCacheParameterGroupFamily
      (clojure.core/str v14436))))
   (clojure.core/let
    [v14436
     (:description m14435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14436 :com.palletops.awaze.client-builder/undef)
     (. bean14434 setDescription (clojure.core/str v14436))))
   bean14434))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest}
modify-replication-group-request
  [m14438]
  (clojure.core/let
   [bean14437
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/let
    [v14439
     (:snapshotting-cluster-id
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setSnapshottingClusterId (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:replication-group-description
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (.
      bean14437
      setReplicationGroupDescription
      (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:replication-group-id
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setReplicationGroupId (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:security-group-ids
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (.
      bean14437
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14490] (clojure.core/str arg14490))
 v14439))))
   (clojure.core/let
    [v14439
     (:snapshot-retention-limit
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setSnapshotRetentionLimit (clojure.core/int v14439))))
   (clojure.core/let
    [v14439
     (:apply-immediately
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setApplyImmediately (clojure.core/boolean v14439))))
   (clojure.core/let
    [v14439
     (:primary-cluster-id
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setPrimaryClusterId (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:preferred-maintenance-window
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (.
      bean14437
      setPreferredMaintenanceWindow
      (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:notification-topic-arn
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setNotificationTopicArn (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:cache-security-group-names
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (.
      bean14437
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14491] (clojure.core/str arg14491))
 v14439))))
   (clojure.core/let
    [v14439
     (:cache-parameter-group-name
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (.
      bean14437
      setCacheParameterGroupName
      (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:notification-topic-status
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (.
      bean14437
      setNotificationTopicStatus
      (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:auto-minor-version-upgrade
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (.
      bean14437
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14439))))
   (clojure.core/let
    [v14439
     (:automatic-failover-enabled
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (.
      bean14437
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14439))))
   (clojure.core/let
    [v14439
     (:snapshot-window
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setSnapshotWindow (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:engine-version
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setEngineVersion (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:cache-node-type
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setCacheNodeType (clojure.core/str v14439))))
   bean14437))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m14441]
  (clojure.core/let
   [bean14440
    (new
     com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v14442
     (:tag-keys m14441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14442 :com.palletops.awaze.client-builder/undef)
     (.
      bean14440
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14524] (clojure.core/str arg14524))
 v14442))))
   (clojure.core/let
    [v14442
     (:resource-name m14441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14442 :com.palletops.awaze.client-builder/undef)
     (. bean14440 setResourceName (clojure.core/str v14442))))
   bean14440))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest}
describe-reserved-cache-nodes-offerings-request
  [m14444]
  (clojure.core/let
   [bean14443
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/let
    [v14445
     (:cache-node-type
      m14444
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14445 :com.palletops.awaze.client-builder/undef)
     (. bean14443 setCacheNodeType (clojure.core/str v14445))))
   (clojure.core/let
    [v14445
     (:reserved-cache-nodes-offering-id
      m14444
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14445 :com.palletops.awaze.client-builder/undef)
     (.
      bean14443
      setReservedCacheNodesOfferingId
      (clojure.core/str v14445))))
   (clojure.core/let
    [v14445
     (:offering-type m14444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14445 :com.palletops.awaze.client-builder/undef)
     (. bean14443 setOfferingType (clojure.core/str v14445))))
   (clojure.core/let
    [v14445
     (:product-description
      m14444
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14445 :com.palletops.awaze.client-builder/undef)
     (. bean14443 setProductDescription (clojure.core/str v14445))))
   (clojure.core/let
    [v14445
     (:marker m14444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14445 :com.palletops.awaze.client-builder/undef)
     (. bean14443 setMarker (clojure.core/str v14445))))
   (clojure.core/let
    [v14445
     (:duration m14444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14445 :com.palletops.awaze.client-builder/undef)
     (. bean14443 setDuration (clojure.core/str v14445))))
   (clojure.core/let
    [v14445
     (:max-records m14444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14445 :com.palletops.awaze.client-builder/undef)
     (. bean14443 setMaxRecords (clojure.core/int v14445))))
   bean14443))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest}
describe-cache-security-groups-request
  [m14447]
  (clojure.core/let
   [bean14446
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/let
    [v14448
     (:cache-security-group-name
      m14447
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14448 :com.palletops.awaze.client-builder/undef)
     (. bean14446 setCacheSecurityGroupName (clojure.core/str v14448))))
   (clojure.core/let
    [v14448
     (:marker m14447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14448 :com.palletops.awaze.client-builder/undef)
     (. bean14446 setMarker (clojure.core/str v14448))))
   (clojure.core/let
    [v14448
     (:max-records m14447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14448 :com.palletops.awaze.client-builder/undef)
     (. bean14446 setMaxRecords (clojure.core/int v14448))))
   bean14446))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest}
create-replication-group-request
  [m14450]
  (clojure.core/let
   [bean14449
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/let
    [v14451
     (:preferred-cache-cluster-azs
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setPreferredCacheClusterAZs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14525] (clojure.core/str arg14525))
 v14451))))
   (clojure.core/let
    [v14451
     (:engine m14450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setEngine (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:replication-group-description
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setReplicationGroupDescription
      (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:cache-subnet-group-name
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setCacheSubnetGroupName (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:replication-group-id
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setReplicationGroupId (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:security-group-ids
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14526] (clojure.core/str arg14526))
 v14451))))
   (clojure.core/let
    [v14451
     (:snapshot-retention-limit
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setSnapshotRetentionLimit (clojure.core/int v14451))))
   (clojure.core/let
    [v14451
     (:primary-cluster-id
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setPrimaryClusterId (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:preferred-maintenance-window
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setPreferredMaintenanceWindow
      (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:notification-topic-arn
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setNotificationTopicArn (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:cache-security-group-names
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14527] (clojure.core/str arg14527))
 v14451))))
   (clojure.core/let
    [v14451
     (:snapshot-name m14450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setSnapshotName (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:snapshot-arns m14450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14528] (clojure.core/str arg14528))
 v14451))))
   (clojure.core/let
    [v14451 (:port m14450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setPort (clojure.core/int v14451))))
   (clojure.core/let
    [v14451 (:tags m14450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14529] (elasticache/tag arg14529))
 v14451))))
   (clojure.core/let
    [v14451
     (:cache-parameter-group-name
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setCacheParameterGroupName
      (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:auto-minor-version-upgrade
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14451))))
   (clojure.core/let
    [v14451
     (:automatic-failover-enabled
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (.
      bean14449
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14451))))
   (clojure.core/let
    [v14451
     (:snapshot-window
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setSnapshotWindow (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:engine-version
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setEngineVersion (clojure.core/str v14451))))
   (clojure.core/let
    [v14451
     (:num-cache-clusters
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setNumCacheClusters (clojure.core/int v14451))))
   (clojure.core/let
    [v14451
     (:cache-node-type
      m14450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14451 :com.palletops.awaze.client-builder/undef)
     (. bean14449 setCacheNodeType (clojure.core/str v14451))))
   bean14449))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m14453]
  (clojure.core/let
   [bean14452
    (new
     com.amazonaws.services.elasticache.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v14454
     (:resource-name m14453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14454 :com.palletops.awaze.client-builder/undef)
     (. bean14452 setResourceName (clojure.core/str v14454))))
   bean14452))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest}
reset-cache-parameter-group-request
  [m14456]
  (clojure.core/let
   [bean14455
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/let
    [v14457
     (:parameter-name-values
      m14456
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14457 :com.palletops.awaze.client-builder/undef)
     (.
      bean14455
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14530]
  (elasticache/parameter-name-value arg14530))
 v14457))))
   (clojure.core/let
    [v14457
     (:cache-parameter-group-name
      m14456
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14457 :com.palletops.awaze.client-builder/undef)
     (.
      bean14455
      setCacheParameterGroupName
      (clojure.core/str v14457))))
   (clojure.core/let
    [v14457
     (:reset-all-parameters
      m14456
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14457 :com.palletops.awaze.client-builder/undef)
     (. bean14455 setResetAllParameters (clojure.core/boolean v14457))))
   bean14455))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m14459]
  (clojure.core/let
   [bean14458
    (new
     com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v14460
     (:cache-cluster-id
      m14459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14460 :com.palletops.awaze.client-builder/undef)
     (. bean14458 setCacheClusterId (clojure.core/str v14460))))
   (clojure.core/let
    [v14460
     (:snapshot-name m14459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14460 :com.palletops.awaze.client-builder/undef)
     (. bean14458 setSnapshotName (clojure.core/str v14460))))
   (clojure.core/let
    [v14460
     (:snapshot-source
      m14459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14460 :com.palletops.awaze.client-builder/undef)
     (. bean14458 setSnapshotSource (clojure.core/str v14460))))
   (clojure.core/let
    [v14460
     (:marker m14459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14460 :com.palletops.awaze.client-builder/undef)
     (. bean14458 setMarker (clojure.core/str v14460))))
   (clojure.core/let
    [v14460
     (:max-records m14459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14460 :com.palletops.awaze.client-builder/undef)
     (. bean14458 setMaxRecords (clojure.core/int v14460))))
   bean14458))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest}
delete-cache-subnet-group-request
  [m14462]
  (clojure.core/let
   [bean14461
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14463
     (:cache-subnet-group-name
      m14462
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14463 :com.palletops.awaze.client-builder/undef)
     (. bean14461 setCacheSubnetGroupName (clojure.core/str v14463))))
   bean14461))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateSnapshotRequest}
create-snapshot-request
  [m14465]
  (clojure.core/let
   [bean14464
    (new
     com.amazonaws.services.elasticache.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v14466
     (:cache-cluster-id
      m14465
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14466 :com.palletops.awaze.client-builder/undef)
     (. bean14464 setCacheClusterId (clojure.core/str v14466))))
   (clojure.core/let
    [v14466
     (:snapshot-name m14465 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14466 :com.palletops.awaze.client-builder/undef)
     (. bean14464 setSnapshotName (clojure.core/str v14466))))
   bean14464))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest}
purchase-reserved-cache-nodes-offering-request
  [m14468]
  (clojure.core/let
   [bean14467
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/let
    [v14469
     (:cache-node-count
      m14468
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14469 :com.palletops.awaze.client-builder/undef)
     (. bean14467 setCacheNodeCount (clojure.core/int v14469))))
   (clojure.core/let
    [v14469
     (:reserved-cache-node-id
      m14468
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14469 :com.palletops.awaze.client-builder/undef)
     (. bean14467 setReservedCacheNodeId (clojure.core/str v14469))))
   (clojure.core/let
    [v14469
     (:reserved-cache-nodes-offering-id
      m14468
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14469 :com.palletops.awaze.client-builder/undef)
     (.
      bean14467
      setReservedCacheNodesOfferingId
      (clojure.core/str v14469))))
   bean14467))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest}
delete-cache-security-group-request
  [m14471]
  (clojure.core/let
   [bean14470
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14472
     (:cache-security-group-name
      m14471
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14472 :com.palletops.awaze.client-builder/undef)
     (. bean14470 setCacheSecurityGroupName (clojure.core/str v14472))))
   bean14470))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest}
describe-cache-subnet-groups-request
  [m14474]
  (clojure.core/let
   [bean14473
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/let
    [v14475
     (:cache-subnet-group-name
      m14474
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14475 :com.palletops.awaze.client-builder/undef)
     (. bean14473 setCacheSubnetGroupName (clojure.core/str v14475))))
   (clojure.core/let
    [v14475
     (:marker m14474 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14475 :com.palletops.awaze.client-builder/undef)
     (. bean14473 setMarker (clojure.core/str v14475))))
   (clojure.core/let
    [v14475
     (:max-records m14474 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14475 :com.palletops.awaze.client-builder/undef)
     (. bean14473 setMaxRecords (clojure.core/int v14475))))
   bean14473))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m14492]
   (clojure.core/let
    [credentials14493 (:credentials m14492) args14494 (:args m14492)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14495
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14493)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14495
       modifyCacheParameterGroup
       (elasticache/modify-cache-parameter-group-request
        (clojure.core/nth args14494 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials14497 & args14498]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14499
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14497)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14499
      modifyCacheParameterGroup
      (elasticache/modify-cache-parameter-group-request
       (clojure.core/nth args14498 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m14500]
   (clojure.core/let
    [credentials14501 (:credentials m14500) args14502 (:args m14500)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14503
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14501)]
     (clojure.core/case
      (clojure.core/count args14502)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14503
        describeReplicationGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14503
        describeReplicationGroups
        (elasticache/describe-replication-groups-request
         (clojure.core/nth args14502 0))))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-replication-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-replication-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials14505 & args14506]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14507
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14505)]
    (clojure.core/case
     (clojure.core/count args14506)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14507
       describeReplicationGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14507
       describeReplicationGroups
       (elasticache/describe-replication-groups-request
        (clojure.core/nth args14506 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m14508]
   (clojure.core/let
    [credentials14509 (:credentials m14508) args14510 (:args m14508)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14511
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14509)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14511
       createCacheCluster
       (elasticache/create-cache-cluster-request
        (clojure.core/nth args14510 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createCacheCluster"}
   [credentials14513 & args14514]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14515
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14513)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14515
      createCacheCluster
      (elasticache/create-cache-cluster-request
       (clojure.core/nth args14514 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m14516]
   (clojure.core/let
    [credentials14517 (:credentials m14516) args14518 (:args m14516)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14519
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14517)]
     (clojure.core/case
      (clojure.core/count args14518)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14519
        describeCacheParameterGroups
        (elasticache/describe-cache-parameter-groups-request
         (clojure.core/nth args14518 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14519
        describeCacheParameterGroups))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials14521 & args14522]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14523
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14521)]
    (clojure.core/case
     (clojure.core/count args14522)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14523
       describeCacheParameterGroups
       (elasticache/describe-cache-parameter-groups-request
        (clojure.core/nth args14522 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14523
       describeCacheParameterGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m14531]
   (clojure.core/let
    [credentials14532 (:credentials m14531) args14533 (:args m14531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14534
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14532)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14534
       deleteCacheParameterGroup
       (elasticache/delete-cache-parameter-group-request
        (clojure.core/nth args14533 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials14536 & args14537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14538
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14536)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14538
      deleteCacheParameterGroup
      (elasticache/delete-cache-parameter-group-request
       (clojure.core/nth args14537 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m14539]
   (clojure.core/let
    [credentials14540 (:credentials m14539) args14541 (:args m14539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14542
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14540)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14542
       createCacheSecurityGroup
       (elasticache/create-cache-security-group-request
        (clojure.core/nth args14541 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-security-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials14544 & args14545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14546
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14544)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14546
      createCacheSecurityGroup
      (elasticache/create-cache-security-group-request
       (clojure.core/nth args14545 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :add-tags-to-resource
   [m14547]
   (clojure.core/let
    [credentials14548 (:credentials m14547) args14549 (:args m14547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14550
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14548)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14550
       addTagsToResource
       (elasticache/add-tags-to-resource-request
        (clojure.core/nth args14549 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials14552 & args14553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14554
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14552)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14554
      addTagsToResource
      (elasticache/add-tags-to-resource-request
       (clojure.core/nth args14553 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m14555]
   (clojure.core/let
    [credentials14556 (:credentials m14555) args14557 (:args m14555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14558
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14556)]
     (clojure.core/case
      (clojure.core/count args14557)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14558
        describeEvents
        (elasticache/describe-events-request
         (clojure.core/nth args14557 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14558
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials14560 & args14561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14562
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14560)]
    (clojure.core/case
     (clojure.core/count args14561)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14562
       describeEvents
       (elasticache/describe-events-request
        (clojure.core/nth args14561 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14562
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m14563]
   (clojure.core/let
    [credentials14564 (:credentials m14563) args14565 (:args m14563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14566
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14566
       modifyCacheSubnetGroup
       (elasticache/modify-cache-subnet-group-request
        (clojure.core/nth args14565 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials14568 & args14569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14570
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14570
      modifyCacheSubnetGroup
      (elasticache/modify-cache-subnet-group-request
       (clojure.core/nth args14569 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m14571]
   (clojure.core/let
    [credentials14572 (:credentials m14571) args14573 (:args m14571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14574
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14572)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14574
       revokeCacheSecurityGroupIngress
       (elasticache/revoke-cache-security-group-ingress-request
        (clojure.core/nth args14573 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials14576 & args14577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14578
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14576)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14578
      revokeCacheSecurityGroupIngress
      (elasticache/revoke-cache-security-group-ingress-request
       (clojure.core/nth args14577 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m14579]
   (clojure.core/let
    [credentials14580 (:credentials m14579) args14581 (:args m14579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14582
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14580)]
     (clojure.core/case
      (clojure.core/count args14581)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14582
        describeReservedCacheNodes
        (elasticache/describe-reserved-cache-nodes-request
         (clojure.core/nth args14581 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14582
        describeReservedCacheNodes))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials14584 & args14585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14586
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14584)]
    (clojure.core/case
     (clojure.core/count args14585)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14586
       describeReservedCacheNodes
       (elasticache/describe-reserved-cache-nodes-request
        (clojure.core/nth args14585 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14586
       describeReservedCacheNodes))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m14587]
   (clojure.core/let
    [credentials14588 (:credentials m14587) args14589 (:args m14587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14590
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14588)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14590
       rebootCacheCluster
       (elasticache/reboot-cache-cluster-request
        (clojure.core/nth args14589 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials14592 & args14593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14594
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14592)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14594
      rebootCacheCluster
      (elasticache/reboot-cache-cluster-request
       (clojure.core/nth args14593 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m14595]
   (clojure.core/let
    [credentials14596 (:credentials m14595) args14597 (:args m14595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14598
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14596)]
     (clojure.core/case
      (clojure.core/count args14597)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14598
        describeCacheClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14598
        describeCacheClusters
        (elasticache/describe-cache-clusters-request
         (clojure.core/nth args14597 0))))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials14600 & args14601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14602
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14600)]
    (clojure.core/case
     (clojure.core/count args14601)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14602
       describeCacheClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14602
       describeCacheClusters
       (elasticache/describe-cache-clusters-request
        (clojure.core/nth args14601 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :copy-snapshot
   [m14603]
   (clojure.core/let
    [credentials14604 (:credentials m14603) args14605 (:args m14603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14606
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14606
       copySnapshot
       (elasticache/copy-snapshot-request
        (clojure.core/nth args14605 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Call copySnapshot"}
   [credentials14608 & args14609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14610
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14610
      copySnapshot
      (elasticache/copy-snapshot-request
       (clojure.core/nth args14609 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-snapshot
   [m14611]
   (clojure.core/let
    [credentials14612 (:credentials m14611) args14613 (:args m14611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14614
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14614
       deleteSnapshot
       (elasticache/delete-snapshot-request
        (clojure.core/nth args14613 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials14616 & args14617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14618
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14618
      deleteSnapshot
      (elasticache/delete-snapshot-request
       (clojure.core/nth args14617 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m14619]
   (clojure.core/let
    [credentials14620 (:credentials m14619) args14621 (:args m14619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14622
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14620)]
     (clojure.core/case
      (clojure.core/count args14621)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14622
        describeCacheEngineVersions
        (elasticache/describe-cache-engine-versions-request
         (clojure.core/nth args14621 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14622
        describeCacheEngineVersions))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]
                [credentials]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]
                [credentials]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials14624 & args14625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14626
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14624)]
    (clojure.core/case
     (clojure.core/count args14625)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14626
       describeCacheEngineVersions
       (elasticache/describe-cache-engine-versions-request
        (clojure.core/nth args14625 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14626
       describeCacheEngineVersions))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m14627]
   (clojure.core/let
    [credentials14628 (:credentials m14627) args14629 (:args m14627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14630
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14628)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14630
       describeEngineDefaultParameters
       (elasticache/describe-engine-default-parameters-request
        (clojure.core/nth args14629 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-engine-default-parameters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials14632 & args14633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14634
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14632)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14634
      describeEngineDefaultParameters
      (elasticache/describe-engine-default-parameters-request
       (clojure.core/nth args14633 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m14635]
   (clojure.core/let
    [credentials14636 (:credentials m14635) args14637 (:args m14635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14638
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14636)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14638
       deleteReplicationGroup
       (elasticache/delete-replication-group-request
        (clojure.core/nth args14637 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials14640 & args14641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14642
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14640)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14642
      deleteReplicationGroup
      (elasticache/delete-replication-group-request
       (clojure.core/nth args14641 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m14643]
   (clojure.core/let
    [credentials14644 (:credentials m14643) args14645 (:args m14643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14646
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14646
       createCacheSubnetGroup
       (elasticache/create-cache-subnet-group-request
        (clojure.core/nth args14645 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials14648 & args14649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14650
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14650
      createCacheSubnetGroup
      (elasticache/create-cache-subnet-group-request
       (clojure.core/nth args14649 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m14651]
   (clojure.core/let
    [credentials14652 (:credentials m14651) args14653 (:args m14651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14654
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14652)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14654
       modifyCacheCluster
       (elasticache/modify-cache-cluster-request
        (clojure.core/nth args14653 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials14656 & args14657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14658
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14656)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14658
      modifyCacheCluster
      (elasticache/modify-cache-cluster-request
       (clojure.core/nth args14657 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m14659]
   (clojure.core/let
    [credentials14660 (:credentials m14659) args14661 (:args m14659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14662
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14660)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14662
       authorizeCacheSecurityGroupIngress
       (elasticache/authorize-cache-security-group-ingress-request
        (clojure.core/nth args14661 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials14664 & args14665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14666
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14664)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14666
      authorizeCacheSecurityGroupIngress
      (elasticache/authorize-cache-security-group-ingress-request
       (clojure.core/nth args14665 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m14667]
   (clojure.core/let
    [credentials14668 (:credentials m14667) args14669 (:args m14667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14670
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14668)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14670
       describeCacheParameters
       (elasticache/describe-cache-parameters-request
        (clojure.core/nth args14669 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-parameters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call describeCacheParameters"}
   [credentials14672 & args14673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14674
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14672)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14674
      describeCacheParameters
      (elasticache/describe-cache-parameters-request
       (clojure.core/nth args14673 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m14675]
   (clojure.core/let
    [credentials14676 (:credentials m14675) args14677 (:args m14675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14678
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14676)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14678
       deleteCacheCluster
       (elasticache/delete-cache-cluster-request
        (clojure.core/nth args14677 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials14680 & args14681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14682
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14680)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14682
      deleteCacheCluster
      (elasticache/delete-cache-cluster-request
       (clojure.core/nth args14681 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-allowed-node-type-modifications
   [m14683]
   (clojure.core/let
    [credentials14684 (:credentials m14683) args14685 (:args m14683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14686
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14684)]
     (clojure.core/case
      (clojure.core/count args14685)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14686
        listAllowedNodeTypeModifications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14686
        listAllowedNodeTypeModifications
        (elasticache/list-allowed-node-type-modifications-request
         (clojure.core/nth args14685 0))))))))
  (clojure.core/defn
   list-allowed-node-type-modifications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-allowed-node-type-modifications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   [credentials14688 & args14689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14690
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14688)]
    (clojure.core/case
     (clojure.core/count args14689)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14690
       listAllowedNodeTypeModifications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14690
       listAllowedNodeTypeModifications
       (elasticache/list-allowed-node-type-modifications-request
        (clojure.core/nth args14689 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m14691]
   (clojure.core/let
    [credentials14692 (:credentials m14691) args14693 (:args m14691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14694
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14694
       createCacheParameterGroup
       (elasticache/create-cache-parameter-group-request
        (clojure.core/nth args14693 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials14696 & args14697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14698
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14698
      createCacheParameterGroup
      (elasticache/create-cache-parameter-group-request
       (clojure.core/nth args14697 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m14699]
   (clojure.core/let
    [credentials14700 (:credentials m14699) args14701 (:args m14699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14702
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14702
       modifyReplicationGroup
       (elasticache/modify-replication-group-request
        (clojure.core/nth args14701 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials14704 & args14705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14706
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14706
      modifyReplicationGroup
      (elasticache/modify-replication-group-request
       (clojure.core/nth args14705 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :remove-tags-from-resource
   [m14707]
   (clojure.core/let
    [credentials14708 (:credentials m14707) args14709 (:args m14707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14710
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14708)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14710
       removeTagsFromResource
       (elasticache/remove-tags-from-resource-request
        (clojure.core/nth args14709 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials14712 & args14713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14714
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14712)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14714
      removeTagsFromResource
      (elasticache/remove-tags-from-resource-request
       (clojure.core/nth args14713 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m14715]
   (clojure.core/let
    [credentials14716 (:credentials m14715) args14717 (:args m14715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14718
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14716)]
     (clojure.core/case
      (clojure.core/count args14717)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14718
        describeReservedCacheNodesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14718
        describeReservedCacheNodesOfferings
        (elasticache/describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args14717 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials14720 & args14721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14722
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14720)]
    (clojure.core/case
     (clojure.core/count args14721)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14722
       describeReservedCacheNodesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14722
       describeReservedCacheNodesOfferings
       (elasticache/describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args14721 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m14723]
   (clojure.core/let
    [credentials14724 (:credentials m14723) args14725 (:args m14723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14726
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14724)]
     (clojure.core/case
      (clojure.core/count args14725)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14726
        describeCacheSecurityGroups
        (elasticache/describe-cache-security-groups-request
         (clojure.core/nth args14725 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14726
        describeCacheSecurityGroups))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-security-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-security-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials14728 & args14729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14730
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14728)]
    (clojure.core/case
     (clojure.core/count args14729)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14730
       describeCacheSecurityGroups
       (elasticache/describe-cache-security-groups-request
        (clojure.core/nth args14729 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14730
       describeCacheSecurityGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m14731]
   (clojure.core/let
    [credentials14732 (:credentials m14731) args14733 (:args m14731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14734
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14734
       createReplicationGroup
       (elasticache/create-replication-group-request
        (clojure.core/nth args14733 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createReplicationGroup"}
   [credentials14736 & args14737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14738
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14738
      createReplicationGroup
      (elasticache/create-replication-group-request
       (clojure.core/nth args14737 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-tags-for-resource
   [m14739]
   (clojure.core/let
    [credentials14740 (:credentials m14739) args14741 (:args m14739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14742
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14740)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14742
       listTagsForResource
       (elasticache/list-tags-for-resource-request
        (clojure.core/nth args14741 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials14744 & args14745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14746
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14744)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14746
      listTagsForResource
      (elasticache/list-tags-for-resource-request
       (clojure.core/nth args14745 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m14747]
   (clojure.core/let
    [credentials14748 (:credentials m14747) args14749 (:args m14747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14750
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14748)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14750
       resetCacheParameterGroup
       (elasticache/reset-cache-parameter-group-request
        (clojure.core/nth args14749 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials14752 & args14753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14754
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14752)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14754
      resetCacheParameterGroup
      (elasticache/reset-cache-parameter-group-request
       (clojure.core/nth args14753 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-snapshots
   [m14755]
   (clojure.core/let
    [credentials14756 (:credentials m14755) args14757 (:args m14755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14758
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14756)]
     (clojure.core/case
      (clojure.core/count args14757)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14758
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14758
        describeSnapshots
        (elasticache/describe-snapshots-request
         (clojure.core/nth args14757 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials14760 & args14761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14762
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14760)]
    (clojure.core/case
     (clojure.core/count args14761)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14762
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14762
       describeSnapshots
       (elasticache/describe-snapshots-request
        (clojure.core/nth args14761 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m14763]
   (clojure.core/let
    [credentials14764 (:credentials m14763) args14765 (:args m14763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14766
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14764)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14766
       deleteCacheSubnetGroup
       (elasticache/delete-cache-subnet-group-request
        (clojure.core/nth args14765 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials14768 & args14769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14770
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14768)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14770
      deleteCacheSubnetGroup
      (elasticache/delete-cache-subnet-group-request
       (clojure.core/nth args14769 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-snapshot
   [m14771]
   (clojure.core/let
    [credentials14772 (:credentials m14771) args14773 (:args m14771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14774
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14772)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14774
       createSnapshot
       (elasticache/create-snapshot-request
        (clojure.core/nth args14773 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials14776 & args14777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14778
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14776)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14778
      createSnapshot
      (elasticache/create-snapshot-request
       (clojure.core/nth args14777 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m14779]
   (clojure.core/let
    [credentials14780 (:credentials m14779) args14781 (:args m14779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14782
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14780)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14782
       purchaseReservedCacheNodesOffering
       (elasticache/purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args14781 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials14784 & args14785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14786
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14784)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14786
      purchaseReservedCacheNodesOffering
      (elasticache/purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args14785 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m14787]
   (clojure.core/let
    [credentials14788 (:credentials m14787) args14789 (:args m14787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14790
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14788)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14790
       deleteCacheSecurityGroup
       (elasticache/delete-cache-security-group-request
        (clojure.core/nth args14789 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-security-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials14792 & args14793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14794
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14792)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14794
      deleteCacheSecurityGroup
      (elasticache/delete-cache-security-group-request
       (clojure.core/nth args14793 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m14795]
   (clojure.core/let
    [credentials14796 (:credentials m14795) args14797 (:args m14795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14798
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14796)]
     (clojure.core/case
      (clojure.core/count args14797)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14798
        describeCacheSubnetGroups
        (elasticache/describe-cache-subnet-groups-request
         (clojure.core/nth args14797 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14798
        describeCacheSubnetGroups))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials14800 & args14801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14802
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14800)]
    (clojure.core/case
     (clojure.core/count args14801)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14802
       describeCacheSubnetGroups
       (elasticache/describe-cache-subnet-groups-request
        (clojure.core/nth args14801 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14802
       describeCacheSubnetGroups)))))))
