(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.ec2 :as ec2]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeType}
volume-type
  [m1947]
  (.
   com.amazonaws.services.ec2.model.VolumeType
   fromValue
   (clojure.core/name m1947)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsBlockDevice}
ebs-block-device
  [m1950]
  (clojure.core/let
   [bean1949 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/let
    [v1951
     (:delete-on-termination
      m1950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setDeleteOnTermination (clojure.core/boolean v1951))))
   (clojure.core/let
    [v1951
     (:volume-size m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setVolumeSize (clojure.core/int v1951))))
   (clojure.core/let
    [v1951
     (:snapshot-id m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setSnapshotId (clojure.core/str v1951))))
   (clojure.core/let
    [v1951
     (:encrypted m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setEncrypted (clojure.core/boolean v1951))))
   (clojure.core/let
    [v1951
     (:volume-type m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setVolumeType (ec2/volume-type v1951))))
   (clojure.core/let
    [v1951 (:iops m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setIops (clojure.core/int v1951))))
   bean1949))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrivateIpAddressSpecification}
private-ip-address-specification
  [m1953]
  (clojure.core/let
   [bean1952
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/let
    [v1954 (:primary m1953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1954 :com.palletops.awaze.client-builder/undef)
     (. bean1952 setPrimary (clojure.core/boolean v1954))))
   (clojure.core/let
    [v1954
     (:private-ip-address
      m1953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1954 :com.palletops.awaze.client-builder/undef)
     (. bean1952 setPrivateIpAddress (clojure.core/str v1954))))
   bean1952))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageFormat}
disk-image-format
  [m1956]
  (.
   com.amazonaws.services.ec2.model.DiskImageFormat
   fromValue
   (clojure.core/name m1956)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IamInstanceProfileSpecification}
iam-instance-profile-specification
  [m1959]
  (clojure.core/let
   [bean1958
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/let
    [v1960 (:arn m1959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1960 :com.palletops.awaze.client-builder/undef)
     (. bean1958 setArn (clojure.core/str v1960))))
   (clojure.core/let
    [v1960 (:name m1959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1960 :com.palletops.awaze.client-builder/undef)
     (. bean1958 setName (clojure.core/str v1960))))
   bean1958))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotPlacement}
spot-placement
  [m1962]
  (clojure.core/let
   [bean1961 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/let
    [v1963
     (:availability-zone
      m1962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1963 :com.palletops.awaze.client-builder/undef)
     (. bean1961 setAvailabilityZone (clojure.core/str v1963))))
   (clojure.core/let
    [v1963
     (:group-name m1962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1963 :com.palletops.awaze.client-builder/undef)
     (. bean1961 setGroupName (clojure.core/str v1963))))
   bean1961))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceType}
instance-type
  [m1965]
  (.
   com.amazonaws.services.ec2.model.InstanceType
   fromValue
   (clojure.core/name m1965)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetMonitoring}
spot-fleet-monitoring
  [m1968]
  (clojure.core/let
   [bean1967
    (new com.amazonaws.services.ec2.model.SpotFleetMonitoring)]
   (clojure.core/let
    [v1969 (:enabled m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setEnabled (clojure.core/boolean v1969))))
   bean1967))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GroupIdentifier}
group-identifier
  [m1971]
  (clojure.core/let
   [bean1970 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/let
    [v1972
     (:group-id m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setGroupId (clojure.core/str v1972))))
   (clojure.core/let
    [v1972
     (:group-name m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setGroupName (clojure.core/str v1972))))
   bean1970))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BlockDeviceMapping}
block-device-mapping
  [m1974]
  (clojure.core/let
   [bean1973
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/let
    [v1975
     (:device-name m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setDeviceName (clojure.core/str v1975))))
   (clojure.core/let
    [v1975
     (:virtual-name m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setVirtualName (clojure.core/str v1975))))
   (clojure.core/let
    [v1975 (:ebs m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setEbs (ec2/ebs-block-device v1975))))
   (clojure.core/let
    [v1975
     (:no-device m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setNoDevice (clojure.core/str v1975))))
   bean1973))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification}
instance-network-interface-specification
  [m1977]
  (clojure.core/let
   [bean1976
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/let
    [v1978
     (:description m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setDescription (clojure.core/str v1978))))
   (clojure.core/let
    [v1978
     (:subnet-id m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setSubnetId (clojure.core/str v1978))))
   (clojure.core/let
    [v1978
     (:secondary-private-ip-address-count
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (.
      bean1976
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v1978))))
   (clojure.core/let
    [v1978
     (:device-index m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setDeviceIndex (clojure.core/int v1978))))
   (clojure.core/let
    [v1978
     (:private-ip-address
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setPrivateIpAddress (clojure.core/str v1978))))
   (clojure.core/let
    [v1978 (:groups m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (.
      bean1976
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2777] (clojure.core/str arg2777))
 v1978))))
   (clojure.core/let
    [v1978
     (:network-interface-id
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setNetworkInterfaceId (clojure.core/str v1978))))
   (clojure.core/let
    [v1978
     (:associate-public-ip-address
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (.
      bean1976
      setAssociatePublicIpAddress
      (clojure.core/boolean v1978))))
   (clojure.core/let
    [v1978
     (:private-ip-addresses
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (.
      bean1976
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2778]
  (ec2/private-ip-address-specification arg2778))
 v1978))))
   (clojure.core/let
    [v1978
     (:delete-on-termination
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setDeleteOnTermination (clojure.core/boolean v1978))))
   bean1976))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesEbs}
scheduled-instances-ebs
  [m1980]
  (clojure.core/let
   [bean1979
    (new com.amazonaws.services.ec2.model.ScheduledInstancesEbs)]
   (clojure.core/let
    [v1981
     (:delete-on-termination
      m1980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setDeleteOnTermination (clojure.core/boolean v1981))))
   (clojure.core/let
    [v1981
     (:volume-size m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setVolumeSize (clojure.core/int v1981))))
   (clojure.core/let
    [v1981
     (:snapshot-id m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setSnapshotId (clojure.core/str v1981))))
   (clojure.core/let
    [v1981
     (:encrypted m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setEncrypted (clojure.core/boolean v1981))))
   (clojure.core/let
    [v1981
     (:volume-type m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setVolumeType (clojure.core/str v1981))))
   (clojure.core/let
    [v1981 (:iops m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setIops (clojure.core/int v1981))))
   bean1979))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig}
scheduled-instances-private-ip-address-config
  [m1983]
  (clojure.core/let
   [bean1982
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig)]
   (clojure.core/let
    [v1984 (:primary m1983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setPrimary (clojure.core/boolean v1984))))
   (clojure.core/let
    [v1984
     (:private-ip-address
      m1983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setPrivateIpAddress (clojure.core/str v1984))))
   bean1982))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CurrencyCodeValues}
currency-code-values
  [m1986]
  (.
   com.amazonaws.services.ec2.model.CurrencyCodeValues
   fromValue
   (clojure.core/name m1986)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserIdGroupPair}
user-id-group-pair
  [m1989]
  (clojure.core/let
   [bean1988 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/let
    [v1990 (:user-id m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setUserId (clojure.core/str v1990))))
   (clojure.core/let
    [v1990
     (:peering-status m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setPeeringStatus (clojure.core/str v1990))))
   (clojure.core/let
    [v1990 (:vpc-id m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setVpcId (clojure.core/str v1990))))
   (clojure.core/let
    [v1990
     (:vpc-peering-connection-id
      m1989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setVpcPeeringConnectionId (clojure.core/str v1990))))
   (clojure.core/let
    [v1990
     (:group-id m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setGroupId (clojure.core/str v1990))))
   (clojure.core/let
    [v1990
     (:group-name m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setGroupName (clojure.core/str v1990))))
   bean1988))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrefixListId}
prefix-list-id
  [m1992]
  (clojure.core/let
   [bean1991 (new com.amazonaws.services.ec2.model.PrefixListId)]
   (clojure.core/let
    [v1993
     (:prefix-list-id m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setPrefixListId (clojure.core/str v1993))))
   bean1991))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification}
ebs-instance-block-device-specification
  [m1995]
  (clojure.core/let
   [bean1994
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/let
    [v1996
     (:delete-on-termination
      m1995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (. bean1994 setDeleteOnTermination (clojure.core/boolean v1996))))
   (clojure.core/let
    [v1996
     (:volume-id m1995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (. bean1994 setVolumeId (clojure.core/str v1996))))
   bean1994))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Placement}
placement
  [m1998]
  (clojure.core/let
   [bean1997 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/let
    [v1999
     (:availability-zone
      m1998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1999 :com.palletops.awaze.client-builder/undef)
     (. bean1997 setAvailabilityZone (clojure.core/str v1999))))
   (clojure.core/let
    [v1999 (:tenancy m1998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1999 :com.palletops.awaze.client-builder/undef)
     (. bean1997 setTenancy (clojure.core/str v1999))))
   (clojure.core/let
    [v1999
     (:affinity m1998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1999 :com.palletops.awaze.client-builder/undef)
     (. bean1997 setAffinity (clojure.core/str v1999))))
   (clojure.core/let
    [v1999 (:host-id m1998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1999 :com.palletops.awaze.client-builder/undef)
     (. bean1997 setHostId (clojure.core/str v1999))))
   (clojure.core/let
    [v1999
     (:group-name m1998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1999 :com.palletops.awaze.client-builder/undef)
     (. bean1997 setGroupName (clojure.core/str v1999))))
   bean1997))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ShutdownBehavior}
shutdown-behavior
  [m2001]
  (.
   com.amazonaws.services.ec2.model.ShutdownBehavior
   fromValue
   (clojure.core/name m2001)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ArchitectureValues}
architecture-values
  [m2004]
  (.
   com.amazonaws.services.ec2.model.ArchitectureValues
   fromValue
   (clojure.core/name m2004)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserData}
user-data
  [m2007]
  (clojure.core/let
   [bean2006 (new com.amazonaws.services.ec2.model.UserData)]
   (clojure.core/let
    [v2008 (:data m2007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2008 :com.palletops.awaze.client-builder/undef)
     (. bean2006 setData (clojure.core/str v2008))))
   bean2006))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeDetail}
volume-detail
  [m2010]
  (clojure.core/let
   [bean2009 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/let
    [v2011 (:size m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setSize (clojure.core/long v2011))))
   bean2009))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageDetail}
disk-image-detail
  [m2013]
  (clojure.core/let
   [bean2012 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/let
    [v2014 (:format m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setFormat (ec2/disk-image-format v2014))))
   (clojure.core/let
    [v2014 (:bytes m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setBytes (clojure.core/long v2014))))
   (clojure.core/let
    [v2014
     (:import-manifest-url
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setImportManifestUrl (clojure.core/str v2014))))
   bean2012))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermission}
create-volume-permission
  [m2016]
  (clojure.core/let
   [bean2015
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/let
    [v2017 (:group m2016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2017 :com.palletops.awaze.client-builder/undef)
     (. bean2015 setGroup (clojure.core/str v2017))))
   (clojure.core/let
    [v2017 (:user-id m2016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2017 :com.palletops.awaze.client-builder/undef)
     (. bean2015 setUserId (clojure.core/str v2017))))
   bean2015))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification}
spot-fleet-launch-specification
  [m2019]
  (clojure.core/let
   [bean2018
    (new
     com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification)]
   (clojure.core/let
    [v2020
     (:spot-price m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setSpotPrice (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:iam-instance-profile
      m2019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (.
      bean2018
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2020))))
   (clojure.core/let
    [v2020
     (:subnet-id m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setSubnetId (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:placement m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setPlacement (ec2/spot-placement v2020))))
   (clojure.core/let
    [v2020
     (:addressing-type
      m2019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setAddressingType (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:instance-type m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setInstanceType (ec2/instance-type v2020))))
   (clojure.core/let
    [v2020
     (:ebs-optimized m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setEbsOptimized (clojure.core/boolean v2020))))
   (clojure.core/let
    [v2020
     (:ramdisk-id m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setRamdiskId (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:weighted-capacity
      m2019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setWeightedCapacity (clojure.core/double v2020))))
   (clojure.core/let
    [v2020
     (:image-id m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setImageId (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:key-name m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setKeyName (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:kernel-id m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setKernelId (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:monitoring m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setMonitoring (ec2/spot-fleet-monitoring v2020))))
   (clojure.core/let
    [v2020
     (:security-groups
      m2019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (.
      bean2018
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2779] (ec2/group-identifier arg2779))
 v2020))))
   (clojure.core/let
    [v2020
     (:block-device-mappings
      m2019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (.
      bean2018
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2780] (ec2/block-device-mapping arg2780))
 v2020))))
   (clojure.core/let
    [v2020
     (:user-data m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setUserData (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:network-interfaces
      m2019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (.
      bean2018
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2781]
  (ec2/instance-network-interface-specification arg2781))
 v2020))))
   bean2018))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocationStrategy}
allocation-strategy
  [m2022]
  (.
   com.amazonaws.services.ec2.model.AllocationStrategy
   fromValue
   (clojure.core/name m2022)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserBucket}
user-bucket
  [m2025]
  (clojure.core/let
   [bean2024 (new com.amazonaws.services.ec2.model.UserBucket)]
   (clojure.core/let
    [v2026
     (:s3bucket m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setS3Bucket (clojure.core/str v2026))))
   (clojure.core/let
    [v2026 (:s3key m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setS3Key (clojure.core/str v2026))))
   bean2024))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.S3Storage}
s3storage
  [m2028]
  (clojure.core/let
   [bean2027 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/let
    [v2029
     (:awsaccess-key-id
      m2028
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setAWSAccessKeyId (clojure.core/str v2029))))
   (clojure.core/let
    [v2029
     (:upload-policy m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setUploadPolicy (clojure.core/str v2029))))
   (clojure.core/let
    [v2029
     (:upload-policy-signature
      m2028
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setUploadPolicySignature (clojure.core/str v2029))))
   (clojure.core/let
    [v2029 (:bucket m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setBucket (clojure.core/str v2029))))
   (clojure.core/let
    [v2029 (:prefix m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setPrefix (clojure.core/str v2029))))
   bean2027))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermission}
launch-permission
  [m2031]
  (clojure.core/let
   [bean2030 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/let
    [v2032 (:group m2031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setGroup (clojure.core/str v2032))))
   (clojure.core/let
    [v2032 (:user-id m2031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setUserId (clojure.core/str v2032))))
   bean2030))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile}
scheduled-instances-iam-instance-profile
  [m2034]
  (clojure.core/let
   [bean2033
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile)]
   (clojure.core/let
    [v2035 (:arn m2034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (. bean2033 setArn (clojure.core/str v2035))))
   (clojure.core/let
    [v2035 (:name m2034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (. bean2033 setName (clojure.core/str v2035))))
   bean2033))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPlacement}
scheduled-instances-placement
  [m2037]
  (clojure.core/let
   [bean2036
    (new com.amazonaws.services.ec2.model.ScheduledInstancesPlacement)]
   (clojure.core/let
    [v2038
     (:availability-zone
      m2037
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setAvailabilityZone (clojure.core/str v2038))))
   (clojure.core/let
    [v2038
     (:group-name m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setGroupName (clojure.core/str v2038))))
   bean2036))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring}
scheduled-instances-monitoring
  [m2040]
  (clojure.core/let
   [bean2039
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring)]
   (clojure.core/let
    [v2041 (:enabled m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setEnabled (clojure.core/boolean v2041))))
   bean2039))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping}
scheduled-instances-block-device-mapping
  [m2043]
  (clojure.core/let
   [bean2042
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping)]
   (clojure.core/let
    [v2044
     (:device-name m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setDeviceName (clojure.core/str v2044))))
   (clojure.core/let
    [v2044
     (:virtual-name m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setVirtualName (clojure.core/str v2044))))
   (clojure.core/let
    [v2044 (:ebs m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setEbs (ec2/scheduled-instances-ebs v2044))))
   (clojure.core/let
    [v2044
     (:no-device m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setNoDevice (clojure.core/str v2044))))
   bean2042))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface}
scheduled-instances-network-interface
  [m2046]
  (clojure.core/let
   [bean2045
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface)]
   (clojure.core/let
    [v2047
     (:description m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setDescription (clojure.core/str v2047))))
   (clojure.core/let
    [v2047
     (:subnet-id m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setSubnetId (clojure.core/str v2047))))
   (clojure.core/let
    [v2047
     (:secondary-private-ip-address-count
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2047))))
   (clojure.core/let
    [v2047
     (:device-index m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setDeviceIndex (clojure.core/int v2047))))
   (clojure.core/let
    [v2047
     (:private-ip-address
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setPrivateIpAddress (clojure.core/str v2047))))
   (clojure.core/let
    [v2047
     (:private-ip-address-configs
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setPrivateIpAddressConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2782]
  (ec2/scheduled-instances-private-ip-address-config arg2782))
 v2047))))
   (clojure.core/let
    [v2047 (:groups m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2783] (clojure.core/str arg2783))
 v2047))))
   (clojure.core/let
    [v2047
     (:network-interface-id
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setNetworkInterfaceId (clojure.core/str v2047))))
   (clojure.core/let
    [v2047
     (:associate-public-ip-address
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setAssociatePublicIpAddress
      (clojure.core/boolean v2047))))
   (clojure.core/let
    [v2047
     (:delete-on-termination
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setDeleteOnTermination (clojure.core/boolean v2047))))
   bean2045))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PriceScheduleSpecification}
price-schedule-specification
  [m2049]
  (clojure.core/let
   [bean2048
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/let
    [v2050 (:price m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setPrice (clojure.core/double v2050))))
   (clojure.core/let
    [v2050 (:term m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setTerm (clojure.core/long v2050))))
   (clojure.core/let
    [v2050
     (:currency-code m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setCurrencyCode (ec2/currency-code-values v2050))))
   bean2048))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IpPermission}
ip-permission
  [m2052]
  (clojure.core/let
   [bean2051 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/let
    [v2053
     (:user-id-group-pairs
      m2052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setUserIdGroupPairs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2784] (ec2/user-id-group-pair arg2784))
 v2053))))
   (clojure.core/let
    [v2053
     (:ip-ranges m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setIpRanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2785] (clojure.core/str arg2785))
 v2053))))
   (clojure.core/let
    [v2053
     (:ip-protocol m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setIpProtocol (clojure.core/str v2053))))
   (clojure.core/let
    [v2053
     (:from-port m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setFromPort (clojure.core/int v2053))))
   (clojure.core/let
    [v2053 (:to-port m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setToPort (clojure.core/int v2053))))
   (clojure.core/let
    [v2053
     (:prefix-list-ids
      m2052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2786] (ec2/prefix-list-id arg2786))
 v2053))))
   bean2051))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification}
instance-block-device-mapping-specification
  [m2055]
  (clojure.core/let
   [bean2054
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/let
    [v2056
     (:device-name m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setDeviceName (clojure.core/str v2056))))
   (clojure.core/let
    [v2056
     (:virtual-name m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setVirtualName (clojure.core/str v2056))))
   (clojure.core/let
    [v2056 (:ebs m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (.
      bean2054
      setEbs
      (ec2/ebs-instance-block-device-specification v2056))))
   (clojure.core/let
    [v2056
     (:no-device m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setNoDevice (clojure.core/str v2056))))
   bean2054))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Filter}
filter
  [m2058]
  (clojure.core/let
   [bean2057 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/let
    [v2059 (:values m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (.
      bean2057
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2787] (clojure.core/str arg2787))
 v2059))))
   (clojure.core/let
    [v2059 (:name m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (. bean2057 setName (clojure.core/str v2059))))
   bean2057))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportStatusType}
report-status-type
  [m2061]
  (.
   com.amazonaws.services.ec2.model.ReportStatusType
   fromValue
   (clojure.core/name m2061)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest}
slot-start-time-range-request
  [m2064]
  (clojure.core/let
   [bean2063
    (new com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest)]
   (clojure.core/let
    [v2065
     (:latest-time m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (.
      bean2063
      setLatestTime
      (com.palletops.awaze.common/to-date v2065))))
   (clojure.core/let
    [v2065
     (:earliest-time m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (.
      bean2063
      setEarliestTime
      (com.palletops.awaze.common/to-date v2065))))
   bean2063))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tenancy}
tenancy
  [m2067]
  (.
   com.amazonaws.services.ec2.model.Tenancy
   fromValue
   (clojure.core/name m2067)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IcmpTypeCode}
icmp-type-code
  [m2070]
  (clojure.core/let
   [bean2069 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/let
    [v2071 (:code m2070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2071 :com.palletops.awaze.client-builder/undef)
     (. bean2069 setCode (clojure.core/int v2071))))
   (clojure.core/let
    [v2071 (:type m2070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2071 :com.palletops.awaze.client-builder/undef)
     (. bean2069 setType (clojure.core/int v2071))))
   bean2069))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PortRange}
port-range
  [m2073]
  (clojure.core/let
   [bean2072 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/let
    [v2074 (:from m2073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2074 :com.palletops.awaze.client-builder/undef)
     (. bean2072 setFrom (clojure.core/int v2074))))
   (clojure.core/let
    [v2074 (:to m2073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2074 :com.palletops.awaze.client-builder/undef)
     (. bean2072 setTo (clojure.core/int v2074))))
   bean2072))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DomainType}
domain-type
  [m2076]
  (.
   com.amazonaws.services.ec2.model.DomainType
   fromValue
   (clojure.core/name m2076)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PlatformValues}
platform-values
  [m2079]
  (.
   com.amazonaws.services.ec2.model.PlatformValues
   fromValue
   (clojure.core/name m2079)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification}
import-instance-launch-specification
  [m2082]
  (clojure.core/let
   [bean2081
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/let
    [v2083
     (:group-ids m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (.
      bean2081
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2788] (clojure.core/str arg2788))
 v2083))))
   (clojure.core/let
    [v2083
     (:subnet-id m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setSubnetId (clojure.core/str v2083))))
   (clojure.core/let
    [v2083
     (:additional-info
      m2082
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setAdditionalInfo (clojure.core/str v2083))))
   (clojure.core/let
    [v2083
     (:placement m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setPlacement (ec2/placement v2083))))
   (clojure.core/let
    [v2083
     (:group-names m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (.
      bean2081
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2789] (clojure.core/str arg2789))
 v2083))))
   (clojure.core/let
    [v2083
     (:private-ip-address
      m2082
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setPrivateIpAddress (clojure.core/str v2083))))
   (clojure.core/let
    [v2083
     (:instance-type m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setInstanceType (clojure.core/str v2083))))
   (clojure.core/let
    [v2083
     (:instance-initiated-shutdown-behavior
      m2082
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (.
      bean2081
      setInstanceInitiatedShutdownBehavior
      (ec2/shutdown-behavior v2083))))
   (clojure.core/let
    [v2083
     (:monitoring m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setMonitoring (clojure.core/boolean v2083))))
   (clojure.core/let
    [v2083
     (:architecture m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setArchitecture (ec2/architecture-values v2083))))
   (clojure.core/let
    [v2083
     (:user-data m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setUserData (ec2/user-data v2083))))
   bean2081))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImage}
disk-image
  [m2085]
  (clojure.core/let
   [bean2084 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/let
    [v2086
     (:description m2085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setDescription (clojure.core/str v2086))))
   (clojure.core/let
    [v2086 (:volume m2085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setVolume (ec2/volume-detail v2086))))
   (clojure.core/let
    [v2086 (:image m2085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setImage (ec2/disk-image-detail v2086))))
   bean2084))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermissionModifications}
create-volume-permission-modifications
  [m2088]
  (clojure.core/let
   [bean2087
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/let
    [v2089 (:add m2088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (.
      bean2087
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2790] (ec2/create-volume-permission arg2790))
 v2089))))
   (clojure.core/let
    [v2089 (:remove m2088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (.
      bean2087
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2791] (ec2/create-volume-permission arg2791))
 v2089))))
   bean2087))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetRequestConfigData}
spot-fleet-request-config-data
  [m2091]
  (clojure.core/let
   [bean2090
    (new com.amazonaws.services.ec2.model.SpotFleetRequestConfigData)]
   (clojure.core/let
    [v2092
     (:iam-fleet-role m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setIamFleetRole (clojure.core/str v2092))))
   (clojure.core/let
    [v2092
     (:spot-price m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setSpotPrice (clojure.core/str v2092))))
   (clojure.core/let
    [v2092
     (:launch-specifications
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setLaunchSpecifications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2792]
  (ec2/spot-fleet-launch-specification arg2792))
 v2092))))
   (clojure.core/let
    [v2092
     (:valid-from m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setValidFrom
      (com.palletops.awaze.common/to-date v2092))))
   (clojure.core/let
    [v2092
     (:client-token m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setClientToken (clojure.core/str v2092))))
   (clojure.core/let
    [v2092
     (:allocation-strategy
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setAllocationStrategy
      (ec2/allocation-strategy v2092))))
   (clojure.core/let
    [v2092
     (:terminate-instances-with-expiration
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setTerminateInstancesWithExpiration
      (clojure.core/boolean v2092))))
   (clojure.core/let
    [v2092
     (:target-capacity
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setTargetCapacity (clojure.core/int v2092))))
   (clojure.core/let
    [v2092
     (:valid-until m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setValidUntil
      (com.palletops.awaze.common/to-date v2092))))
   (clojure.core/let
    [v2092
     (:excess-capacity-termination-policy
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setExcessCapacityTerminationPolicy
      (clojure.core/str v2092))))
   bean2090))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportEnvironment}
export-environment
  [m2094]
  (.
   com.amazonaws.services.ec2.model.ExportEnvironment
   fromValue
   (clojure.core/name m2094)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportToS3TaskSpecification}
export-to-s3task-specification
  [m2097]
  (clojure.core/let
   [bean2096
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/let
    [v2098
     (:disk-image-format
      m2097
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setDiskImageFormat (ec2/disk-image-format v2098))))
   (clojure.core/let
    [v2098
     (:container-format
      m2097
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setContainerFormat (clojure.core/str v2098))))
   (clojure.core/let
    [v2098
     (:s3bucket m2097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setS3Bucket (clojure.core/str v2098))))
   (clojure.core/let
    [v2098
     (:s3prefix m2097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setS3Prefix (clojure.core/str v2098))))
   bean2096))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseRequest}
purchase-request
  [m2100]
  (clojure.core/let
   [bean2099 (new com.amazonaws.services.ec2.model.PurchaseRequest)]
   (clojure.core/let
    [v2101
     (:purchase-token m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setPurchaseToken (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:instance-count m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setInstanceCount (clojure.core/int v2101))))
   bean2099))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice}
reserved-instance-limit-price
  [m2103]
  (clojure.core/let
   [bean2102
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/let
    [v2104 (:amount m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setAmount (clojure.core/double v2104))))
   (clojure.core/let
    [v2104
     (:currency-code m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setCurrencyCode (clojure.core/str v2104))))
   bean2102))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DhcpConfiguration}
dhcp-configuration
  [m2106]
  (clojure.core/let
   [bean2105 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/let
    [v2107 (:values m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (.
      bean2105
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2793] (clojure.core/str arg2793))
 v2107))))
   (clojure.core/let
    [v2107 (:key m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (. bean2105 setKey (clojure.core/str v2107))))
   bean2105))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotInstanceType}
spot-instance-type
  [m2109]
  (.
   com.amazonaws.services.ec2.model.SpotInstanceType
   fromValue
   (clojure.core/name m2109)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchSpecification}
launch-specification
  [m2112]
  (clojure.core/let
   [bean2111
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/let
    [v2113
     (:iam-instance-profile
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2113))))
   (clojure.core/let
    [v2113
     (:subnet-id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setSubnetId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:placement m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setPlacement (ec2/spot-placement v2113))))
   (clojure.core/let
    [v2113
     (:addressing-type
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setAddressingType (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:instance-type m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setInstanceType (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:ebs-optimized m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setEbsOptimized (clojure.core/boolean v2113))))
   (clojure.core/let
    [v2113
     (:ramdisk-id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setRamdiskId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:all-security-groups
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setAllSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2794] (ec2/group-identifier arg2794))
 v2113))))
   (clojure.core/let
    [v2113
     (:image-id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setImageId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:key-name m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setKeyName (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:monitoring-enabled
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setMonitoringEnabled (clojure.core/boolean v2113))))
   (clojure.core/let
    [v2113
     (:kernel-id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setKernelId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:security-groups
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2795] (clojure.core/str arg2795))
 v2113))))
   (clojure.core/let
    [v2113
     (:block-device-mappings
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2796] (ec2/block-device-mapping arg2796))
 v2113))))
   (clojure.core/let
    [v2113
     (:user-data m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setUserData (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:network-interfaces
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2797]
  (ec2/instance-network-interface-specification arg2797))
 v2113))))
   bean2111))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ClientData}
client-data
  [m2115]
  (clojure.core/let
   [bean2114 (new com.amazonaws.services.ec2.model.ClientData)]
   (clojure.core/let
    [v2116 (:comment m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (. bean2114 setComment (clojure.core/str v2116))))
   (clojure.core/let
    [v2116
     (:upload-end m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (.
      bean2114
      setUploadEnd
      (com.palletops.awaze.common/to-date v2116))))
   (clojure.core/let
    [v2116
     (:upload-size m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (. bean2114 setUploadSize (clojure.core/double v2116))))
   (clojure.core/let
    [v2116
     (:upload-start m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (.
      bean2114
      setUploadStart
      (com.palletops.awaze.common/to-date v2116))))
   bean2114))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotDiskContainer}
snapshot-disk-container
  [m2118]
  (clojure.core/let
   [bean2117
    (new com.amazonaws.services.ec2.model.SnapshotDiskContainer)]
   (clojure.core/let
    [v2119 (:format m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (. bean2117 setFormat (clojure.core/str v2119))))
   (clojure.core/let
    [v2119 (:url m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (. bean2117 setUrl (clojure.core/str v2119))))
   (clojure.core/let
    [v2119
     (:user-bucket m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (. bean2117 setUserBucket (ec2/user-bucket v2119))))
   (clojure.core/let
    [v2119
     (:description m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (. bean2117 setDescription (clojure.core/str v2119))))
   bean2117))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tag}
tag
  [m2121]
  (clojure.core/let
   [bean2120 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/let
    [v2122 (:key m2121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2122 :com.palletops.awaze.client-builder/undef)
     (. bean2120 setKey (clojure.core/str v2122))))
   (clojure.core/let
    [v2122 (:value m2121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2122 :com.palletops.awaze.client-builder/undef)
     (. bean2120 setValue (clojure.core/str v2122))))
   bean2120))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RIProductDescription}
riproduct-description
  [m2124]
  (.
   com.amazonaws.services.ec2.model.RIProductDescription
   fromValue
   (clojure.core/name m2124)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GatewayType}
gateway-type
  [m2127]
  (.
   com.amazonaws.services.ec2.model.GatewayType
   fromValue
   (clojure.core/name m2127)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.FlowLogsResourceType}
flow-logs-resource-type
  [m2130]
  (.
   com.amazonaws.services.ec2.model.FlowLogsResourceType
   fromValue
   (clojure.core/name m2130)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Storage}
storage
  [m2133]
  (clojure.core/let
   [bean2132 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/let
    [v2134 (:s3 m2133 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2134 :com.palletops.awaze.client-builder/undef)
     (. bean2132 setS3 (ec2/s3storage v2134))))
   bean2132))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Affinity}
affinity
  [m2136]
  (.
   com.amazonaws.services.ec2.model.Affinity
   fromValue
   (clojure.core/name m2136)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OperationType}
operation-type
  [m2139]
  (.
   com.amazonaws.services.ec2.model.OperationType
   fromValue
   (clojure.core/name m2139)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermissionModifications}
launch-permission-modifications
  [m2142]
  (clojure.core/let
   [bean2141
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/let
    [v2143 (:add m2142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2143 :com.palletops.awaze.client-builder/undef)
     (.
      bean2141
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2798] (ec2/launch-permission arg2798))
 v2143))))
   (clojure.core/let
    [v2143 (:remove m2142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2143 :com.palletops.awaze.client-builder/undef)
     (.
      bean2141
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2799] (ec2/launch-permission arg2799))
 v2143))))
   bean2141))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification}
vpn-connection-options-specification
  [m2145]
  (clojure.core/let
   [bean2144
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/let
    [v2146
     (:static-routes-only
      m2145
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2146 :com.palletops.awaze.client-builder/undef)
     (. bean2144 setStaticRoutesOnly (clojure.core/boolean v2146))))
   bean2144))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest}
scheduled-instance-recurrence-request
  [m2148]
  (clojure.core/let
   [bean2147
    (new
     com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest)]
   (clojure.core/let
    [v2149
     (:frequency m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setFrequency (clojure.core/str v2149))))
   (clojure.core/let
    [v2149
     (:interval m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setInterval (clojure.core/int v2149))))
   (clojure.core/let
    [v2149
     (:occurrence-days
      m2148
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (.
      bean2147
      setOccurrenceDays
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2800] (clojure.core/int arg2800))
 v2149))))
   (clojure.core/let
    [v2149
     (:occurrence-relative-to-end
      m2148
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (.
      bean2147
      setOccurrenceRelativeToEnd
      (clojure.core/boolean v2149))))
   (clojure.core/let
    [v2149
     (:occurrence-unit
      m2148
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setOccurrenceUnit (clojure.core/str v2149))))
   bean2147))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest}
slot-date-time-range-request
  [m2151]
  (clojure.core/let
   [bean2150
    (new com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest)]
   (clojure.core/let
    [v2152
     (:latest-time m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (.
      bean2150
      setLatestTime
      (com.palletops.awaze.common/to-date v2152))))
   (clojure.core/let
    [v2152
     (:earliest-time m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (.
      bean2150
      setEarliestTime
      (com.palletops.awaze.common/to-date v2152))))
   bean2150))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OfferingTypeValues}
offering-type-values
  [m2154]
  (.
   com.amazonaws.services.ec2.model.OfferingTypeValues
   fromValue
   (clojure.core/name m2154)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpcAttributeName}
vpc-attribute-name
  [m2157]
  (.
   com.amazonaws.services.ec2.model.VpcAttributeName
   fromValue
   (clojure.core/name m2157)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImageDiskContainer}
image-disk-container
  [m2160]
  (clojure.core/let
   [bean2159
    (new com.amazonaws.services.ec2.model.ImageDiskContainer)]
   (clojure.core/let
    [v2161 (:format m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setFormat (clojure.core/str v2161))))
   (clojure.core/let
    [v2161
     (:device-name m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setDeviceName (clojure.core/str v2161))))
   (clojure.core/let
    [v2161 (:url m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setUrl (clojure.core/str v2161))))
   (clojure.core/let
    [v2161
     (:user-bucket m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setUserBucket (ec2/user-bucket v2161))))
   (clojure.core/let
    [v2161
     (:snapshot-id m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setSnapshotId (clojure.core/str v2161))))
   (clojure.core/let
    [v2161
     (:description m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setDescription (clojure.core/str v2161))))
   bean2159))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeAttributeName}
volume-attribute-name
  [m2163]
  (.
   com.amazonaws.services.ec2.model.VolumeAttributeName
   fromValue
   (clojure.core/name m2163)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification}
scheduled-instances-launch-specification
  [m2166]
  (clojure.core/let
   [bean2165
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification)]
   (clojure.core/let
    [v2167
     (:iam-instance-profile
      m2166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (.
      bean2165
      setIamInstanceProfile
      (ec2/scheduled-instances-iam-instance-profile v2167))))
   (clojure.core/let
    [v2167
     (:subnet-id m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setSubnetId (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:security-group-ids
      m2166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (.
      bean2165
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2801] (clojure.core/str arg2801))
 v2167))))
   (clojure.core/let
    [v2167
     (:placement m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (.
      bean2165
      setPlacement
      (ec2/scheduled-instances-placement v2167))))
   (clojure.core/let
    [v2167
     (:instance-type m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setInstanceType (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:ebs-optimized m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setEbsOptimized (clojure.core/boolean v2167))))
   (clojure.core/let
    [v2167
     (:ramdisk-id m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setRamdiskId (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:image-id m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setImageId (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:key-name m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setKeyName (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:kernel-id m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setKernelId (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:monitoring m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (.
      bean2165
      setMonitoring
      (ec2/scheduled-instances-monitoring v2167))))
   (clojure.core/let
    [v2167
     (:block-device-mappings
      m2166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (.
      bean2165
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2802]
  (ec2/scheduled-instances-block-device-mapping arg2802))
 v2167))))
   (clojure.core/let
    [v2167
     (:user-data m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setUserData (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:network-interfaces
      m2166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (.
      bean2165
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2803]
  (ec2/scheduled-instances-network-interface arg2803))
 v2167))))
   bean2165))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstancesConfiguration}
reserved-instances-configuration
  [m2169]
  (clojure.core/let
   [bean2168
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/let
    [v2170
     (:instance-type m2169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setInstanceType (ec2/instance-type v2170))))
   (clojure.core/let
    [v2170
     (:availability-zone
      m2169
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setAvailabilityZone (clojure.core/str v2170))))
   (clojure.core/let
    [v2170
     (:platform m2169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setPlatform (clojure.core/str v2170))))
   (clojure.core/let
    [v2170
     (:instance-count m2169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setInstanceCount (clojure.core/int v2170))))
   bean2168))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges}
network-interface-attachment-changes
  [m2172]
  (clojure.core/let
   [bean2171
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/let
    [v2173
     (:delete-on-termination
      m2172
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setDeleteOnTermination (clojure.core/boolean v2173))))
   (clojure.core/let
    [v2173
     (:attachment-id m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setAttachmentId (clojure.core/str v2173))))
   bean2171))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy}
excess-capacity-termination-policy
  [m2175]
  (.
   com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy
   fromValue
   (clojure.core/name m2175)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest}
delete-vpc-endpoints-request
  [m2178]
  (clojure.core/let
   [bean2177
    (new com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest)]
   (clojure.core/let
    [v2179
     (:vpc-endpoint-ids
      m2178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (.
      bean2177
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2804] (clojure.core/str arg2804))
 v2179))))
   bean2177))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNatGatewayRequest}
create-nat-gateway-request
  [m2181]
  (clojure.core/let
   [bean2180
    (new com.amazonaws.services.ec2.model.CreateNatGatewayRequest)]
   (clojure.core/let
    [v2182
     (:client-token m2181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2182 :com.palletops.awaze.client-builder/undef)
     (. bean2180 setClientToken (clojure.core/str v2182))))
   (clojure.core/let
    [v2182
     (:subnet-id m2181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2182 :com.palletops.awaze.client-builder/undef)
     (. bean2180 setSubnetId (clojure.core/str v2182))))
   (clojure.core/let
    [v2182
     (:allocation-id m2181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2182 :com.palletops.awaze.client-builder/undef)
     (. bean2180 setAllocationId (clojure.core/str v2182))))
   bean2180))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StopInstancesRequest}
stop-instances-request
  [m2184]
  (clojure.core/let
   [bean2183
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/let
    [v2185 (:force m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setForce (clojure.core/boolean v2185))))
   (clojure.core/let
    [v2185
     (:instance-ids m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (.
      bean2183
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2805] (clojure.core/str arg2805))
 v2185))))
   bean2183))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreatePlacementGroupRequest}
create-placement-group-request
  [m2187]
  (clojure.core/let
   [bean2186
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/let
    [v2188
     (:group-name m2187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2188 :com.palletops.awaze.client-builder/undef)
     (. bean2186 setGroupName (clojure.core/str v2188))))
   (clojure.core/let
    [v2188
     (:strategy m2187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2188 :com.palletops.awaze.client-builder/undef)
     (. bean2186 setStrategy (clojure.core/str v2188))))
   bean2186))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest}
create-reserved-instances-listing-request
  [m2190]
  (clojure.core/let
   [bean2189
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/let
    [v2191
     (:reserved-instances-id
      m2190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setReservedInstancesId (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:client-token m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setClientToken (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:instance-count m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setInstanceCount (clojure.core/int v2191))))
   (clojure.core/let
    [v2191
     (:price-schedules
      m2190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (.
      bean2189
      setPriceSchedules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2806]
  (ec2/price-schedule-specification arg2806))
 v2191))))
   bean2189))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseHostsRequest}
release-hosts-request
  [m2193]
  (clojure.core/let
   [bean2192
    (new com.amazonaws.services.ec2.model.ReleaseHostsRequest)]
   (clojure.core/let
    [v2194
     (:host-ids m2193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2194 :com.palletops.awaze.client-builder/undef)
     (.
      bean2192
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2807] (clojure.core/str arg2807))
 v2194))))
   bean2192))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest}
revoke-security-group-ingress-request
  [m2196]
  (clojure.core/let
   [bean2195
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2197 (:cidr-ip m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setCidrIp (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:group-id m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setGroupId (clojure.core/str v2197))))
   (clojure.core/let
    [v2197 (:to-port m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setToPort (clojure.core/int v2197))))
   (clojure.core/let
    [v2197
     (:source-security-group-owner-id
      m2196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:ip-permissions m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2808] (ec2/ip-permission arg2808))
 v2197))))
   (clojure.core/let
    [v2197
     (:source-security-group-name
      m2196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setSourceSecurityGroupName (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:group-name m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setGroupName (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:ip-protocol m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setIpProtocol (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:from-port m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setFromPort (clojure.core/int v2197))))
   bean2195))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest}
attach-classic-link-vpc-request
  [m2199]
  (clojure.core/let
   [bean2198
    (new com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2200 (:vpc-id m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setVpcId (clojure.core/str v2200))))
   (clojure.core/let
    [v2200 (:groups m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2809] (clojure.core/str arg2809))
 v2200))))
   (clojure.core/let
    [v2200
     (:instance-id m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setInstanceId (clojure.core/str v2200))))
   bean2198))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest}
replace-network-acl-association-request
  [m2202]
  (clojure.core/let
   [bean2201
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/let
    [v2203
     (:association-id m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (. bean2201 setAssociationId (clojure.core/str v2203))))
   (clojure.core/let
    [v2203
     (:network-acl-id m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (. bean2201 setNetworkAclId (clojure.core/str v2203))))
   bean2201))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNatGatewayRequest}
delete-nat-gateway-request
  [m2205]
  (clojure.core/let
   [bean2204
    (new com.amazonaws.services.ec2.model.DeleteNatGatewayRequest)]
   (clojure.core/let
    [v2206
     (:nat-gateway-id m2205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (. bean2204 setNatGatewayId (clojure.core/str v2206))))
   bean2204))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest}
modify-instance-attribute-request
  [m2208]
  (clojure.core/let
   [bean2207
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/let
    [v2209 (:kernel m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setKernel (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:instance-type m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setInstanceType (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:ebs-optimized m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setEbsOptimized (clojure.core/boolean v2209))))
   (clojure.core/let
    [v2209
     (:source-dest-check
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setSourceDestCheck (clojure.core/boolean v2209))))
   (clojure.core/let
    [v2209
     (:instance-id m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setInstanceId (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:instance-initiated-shutdown-behavior
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (.
      bean2207
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v2209))))
   (clojure.core/let
    [v2209 (:groups m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (.
      bean2207
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2810] (clojure.core/str arg2810))
 v2209))))
   (clojure.core/let
    [v2209
     (:disable-api-termination
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (.
      bean2207
      setDisableApiTermination
      (clojure.core/boolean v2209))))
   (clojure.core/let
    [v2209
     (:attribute m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setAttribute (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:sriov-net-support
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setSriovNetSupport (clojure.core/str v2209))))
   (clojure.core/let
    [v2209 (:value m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setValue (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:block-device-mappings
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (.
      bean2207
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2811]
  (ec2/instance-block-device-mapping-specification arg2811))
 v2209))))
   (clojure.core/let
    [v2209 (:ramdisk m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setRamdisk (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:user-data m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setUserData (clojure.core/str v2209))))
   bean2207))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest}
describe-network-acls-request
  [m2211]
  (clojure.core/let
   [bean2210
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/let
    [v2212 (:filters m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (.
      bean2210
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2812] (ec2/filter arg2812))
 v2212))))
   (clojure.core/let
    [v2212
     (:network-acl-ids
      m2211
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (.
      bean2210
      setNetworkAclIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2813] (clojure.core/str arg2813))
 v2212))))
   bean2210))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportInstanceStatusRequest}
report-instance-status-request
  [m2214]
  (clojure.core/let
   [bean2213
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/let
    [v2215
     (:start-time m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (.
      bean2213
      setStartTime
      (com.palletops.awaze.common/to-date v2215))))
   (clojure.core/let
    [v2215
     (:end-time m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (.
      bean2213
      setEndTime
      (com.palletops.awaze.common/to-date v2215))))
   (clojure.core/let
    [v2215
     (:description m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setDescription (clojure.core/str v2215))))
   (clojure.core/let
    [v2215 (:status m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setStatus (ec2/report-status-type v2215))))
   (clojure.core/let
    [v2215
     (:reason-codes m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (.
      bean2213
      setReasonCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2814] (clojure.core/str arg2814))
 v2215))))
   (clojure.core/let
    [v2215
     (:instances m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (.
      bean2213
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2815] (clojure.core/str arg2815))
 v2215))))
   bean2213))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImagesRequest}
describe-images-request
  [m2217]
  (clojure.core/let
   [bean2216
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/let
    [v2218
     (:image-ids m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (.
      bean2216
      setImageIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2816] (clojure.core/str arg2816))
 v2218))))
   (clojure.core/let
    [v2218 (:owners m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (.
      bean2216
      setOwners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2817] (clojure.core/str arg2817))
 v2218))))
   (clojure.core/let
    [v2218
     (:executable-users
      m2217
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (.
      bean2216
      setExecutableUsers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2818] (clojure.core/str arg2818))
 v2218))))
   (clojure.core/let
    [v2218 (:filters m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (.
      bean2216
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2819] (ec2/filter arg2819))
 v2218))))
   bean2216))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest}
describe-import-image-tasks-request
  [m2220]
  (clojure.core/let
   [bean2219
    (new
     com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest)]
   (clojure.core/let
    [v2221
     (:next-token m2220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (. bean2219 setNextToken (clojure.core/str v2221))))
   (clojure.core/let
    [v2221
     (:max-results m2220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (. bean2219 setMaxResults (clojure.core/int v2221))))
   (clojure.core/let
    [v2221
     (:import-task-ids
      m2220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (.
      bean2219
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2820] (clojure.core/str arg2820))
 v2221))))
   (clojure.core/let
    [v2221 (:filters m2220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (.
      bean2219
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2821] (ec2/filter arg2821))
 v2221))))
   bean2219))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyHostsRequest}
modify-hosts-request
  [m2223]
  (clojure.core/let
   [bean2222
    (new com.amazonaws.services.ec2.model.ModifyHostsRequest)]
   (clojure.core/let
    [v2224
     (:host-ids m2223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (.
      bean2222
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2822] (clojure.core/str arg2822))
 v2224))))
   (clojure.core/let
    [v2224
     (:auto-placement m2223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (. bean2222 setAutoPlacement (clojure.core/str v2224))))
   bean2222))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RegisterImageRequest}
register-image-request
  [m2226]
  (clojure.core/let
   [bean2225
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/let
    [v2227
     (:description m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setDescription (clojure.core/str v2227))))
   (clojure.core/let
    [v2227 (:name m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setName (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:root-device-name
      m2226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setRootDeviceName (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:ramdisk-id m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setRamdiskId (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:virtualization-type
      m2226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setVirtualizationType (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:sriov-net-support
      m2226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setSriovNetSupport (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:kernel-id m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setKernelId (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:image-location m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setImageLocation (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:architecture m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setArchitecture (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:block-device-mappings
      m2226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (.
      bean2225
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2823] (ec2/block-device-mapping arg2823))
 v2227))))
   bean2225))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVpnGatewayRequest}
detach-vpn-gateway-request
  [m2229]
  (clojure.core/let
   [bean2228
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/let
    [v2230 (:vpc-id m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setVpcId (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:vpn-gateway-id m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setVpnGatewayId (clojure.core/str v2230))))
   bean2228))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVolumeRequest}
delete-volume-request
  [m2232]
  (clojure.core/let
   [bean2231
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v2233
     (:volume-id m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setVolumeId (clojure.core/str v2233))))
   bean2231))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest}
delete-internet-gateway-request
  [m2235]
  (clojure.core/let
   [bean2234
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/let
    [v2236
     (:internet-gateway-id
      m2235
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2236 :com.palletops.awaze.client-builder/undef)
     (. bean2234 setInternetGatewayId (clojure.core/str v2236))))
   bean2234))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSubnetRequest}
delete-subnet-request
  [m2238]
  (clojure.core/let
   [bean2237
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/let
    [v2239
     (:subnet-id m2238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (. bean2237 setSubnetId (clojure.core/str v2239))))
   bean2237))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest}
reset-instance-attribute-request
  [m2241]
  (clojure.core/let
   [bean2240
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/let
    [v2242
     (:attribute m2241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2242 :com.palletops.awaze.client-builder/undef)
     (. bean2240 setAttribute (clojure.core/str v2242))))
   (clojure.core/let
    [v2242
     (:instance-id m2241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2242 :com.palletops.awaze.client-builder/undef)
     (. bean2240 setInstanceId (clojure.core/str v2242))))
   bean2240))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVolumeRequest}
detach-volume-request
  [m2244]
  (clojure.core/let
   [bean2243
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/let
    [v2245
     (:volume-id m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (. bean2243 setVolumeId (clojure.core/str v2245))))
   (clojure.core/let
    [v2245 (:force m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (. bean2243 setForce (clojure.core/boolean v2245))))
   (clojure.core/let
    [v2245 (:device m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (. bean2243 setDevice (clojure.core/str v2245))))
   (clojure.core/let
    [v2245
     (:instance-id m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (. bean2243 setInstanceId (clojure.core/str v2245))))
   bean2243))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeExportTasksRequest}
describe-export-tasks-request
  [m2247]
  (clojure.core/let
   [bean2246
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/let
    [v2248
     (:export-task-ids
      m2247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (.
      bean2246
      setExportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2824] (clojure.core/str arg2824))
 v2248))))
   bean2246))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest}
describe-scheduled-instances-request
  [m2250]
  (clojure.core/let
   [bean2249
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest)]
   (clojure.core/let
    [v2251
     (:scheduled-instance-ids
      m2250
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (.
      bean2249
      setScheduledInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2825] (clojure.core/str arg2825))
 v2251))))
   (clojure.core/let
    [v2251
     (:slot-start-time-range
      m2250
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (.
      bean2249
      setSlotStartTimeRange
      (ec2/slot-start-time-range-request v2251))))
   (clojure.core/let
    [v2251
     (:next-token m2250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (. bean2249 setNextToken (clojure.core/str v2251))))
   (clojure.core/let
    [v2251
     (:max-results m2250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (. bean2249 setMaxResults (clojure.core/int v2251))))
   (clojure.core/let
    [v2251 (:filters m2250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (.
      bean2249
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2826] (ec2/filter arg2826))
 v2251))))
   bean2249))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteFlowLogsRequest}
delete-flow-logs-request
  [m2253]
  (clojure.core/let
   [bean2252
    (new com.amazonaws.services.ec2.model.DeleteFlowLogsRequest)]
   (clojure.core/let
    [v2254
     (:flow-log-ids m2253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (.
      bean2252
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2827] (clojure.core/str arg2827))
 v2254))))
   bean2252))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcRequest}
create-vpc-request
  [m2256]
  (clojure.core/let
   [bean2255 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/let
    [v2257
     (:instance-tenancy
      m2256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2257 :com.palletops.awaze.client-builder/undef)
     (. bean2255 setInstanceTenancy (ec2/tenancy v2257))))
   (clojure.core/let
    [v2257
     (:cidr-block m2256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2257 :com.palletops.awaze.client-builder/undef)
     (. bean2255 setCidrBlock (clojure.core/str v2257))))
   bean2255))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest}
create-spot-datafeed-subscription-request
  [m2259]
  (clojure.core/let
   [bean2258
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/let
    [v2260 (:bucket m2259 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setBucket (clojure.core/str v2260))))
   (clojure.core/let
    [v2260 (:prefix m2259 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setPrefix (clojure.core/str v2260))))
   bean2258))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest}
describe-vpc-classic-link-request
  [m2262]
  (clojure.core/let
   [bean2261
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest)]
   (clojure.core/let
    [v2263 (:vpc-ids m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (.
      bean2261
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2828] (clojure.core/str arg2828))
 v2263))))
   (clojure.core/let
    [v2263 (:filters m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (.
      bean2261
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2829] (ec2/filter arg2829))
 v2263))))
   bean2261))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteRequest}
delete-route-request
  [m2265]
  (clojure.core/let
   [bean2264
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/let
    [v2266
     (:route-table-id m2265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2266 :com.palletops.awaze.client-builder/undef)
     (. bean2264 setRouteTableId (clojure.core/str v2266))))
   (clojure.core/let
    [v2266
     (:destination-cidr-block
      m2265
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2266 :com.palletops.awaze.client-builder/undef)
     (. bean2264 setDestinationCidrBlock (clojure.core/str v2266))))
   bean2264))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeIdFormatRequest}
describe-id-format-request
  [m2268]
  (clojure.core/let
   [bean2267
    (new com.amazonaws.services.ec2.model.DescribeIdFormatRequest)]
   (clojure.core/let
    [v2269
     (:resource m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setResource (clojure.core/str v2269))))
   bean2267))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVolumeRequest}
attach-volume-request
  [m2271]
  (clojure.core/let
   [bean2270
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/let
    [v2272
     (:volume-id m2271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2272 :com.palletops.awaze.client-builder/undef)
     (. bean2270 setVolumeId (clojure.core/str v2272))))
   (clojure.core/let
    [v2272 (:device m2271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2272 :com.palletops.awaze.client-builder/undef)
     (. bean2270 setDevice (clojure.core/str v2272))))
   (clojure.core/let
    [v2272
     (:instance-id m2271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2272 :com.palletops.awaze.client-builder/undef)
     (. bean2270 setInstanceId (clojure.core/str v2272))))
   bean2270))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVolumeIORequest}
enable-volume-iorequest
  [m2274]
  (clojure.core/let
   [bean2273
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/let
    [v2275
     (:volume-id m2274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2275 :com.palletops.awaze.client-builder/undef)
     (. bean2273 setVolumeId (clojure.core/str v2275))))
   bean2273))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVpnGatewayRequest}
attach-vpn-gateway-request
  [m2277]
  (clojure.core/let
   [bean2276
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/let
    [v2278 (:vpc-id m2277 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2278 :com.palletops.awaze.client-builder/undef)
     (. bean2276 setVpcId (clojure.core/str v2278))))
   (clojure.core/let
    [v2278
     (:vpn-gateway-id m2277 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2278 :com.palletops.awaze.client-builder/undef)
     (. bean2276 setVpnGatewayId (clojure.core/str v2278))))
   bean2276))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest}
replace-network-acl-entry-request
  [m2280]
  (clojure.core/let
   [bean2279
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/let
    [v2281
     (:network-acl-id m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setNetworkAclId (clojure.core/str v2281))))
   (clojure.core/let
    [v2281
     (:rule-number m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setRuleNumber (clojure.core/int v2281))))
   (clojure.core/let
    [v2281
     (:rule-action m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setRuleAction (clojure.core/str v2281))))
   (clojure.core/let
    [v2281 (:egress m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setEgress (clojure.core/boolean v2281))))
   (clojure.core/let
    [v2281
     (:cidr-block m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setCidrBlock (clojure.core/str v2281))))
   (clojure.core/let
    [v2281
     (:icmp-type-code m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setIcmpTypeCode (ec2/icmp-type-code v2281))))
   (clojure.core/let
    [v2281
     (:port-range m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setPortRange (ec2/port-range v2281))))
   (clojure.core/let
    [v2281
     (:protocol m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setProtocol (clojure.core/str v2281))))
   bean2279))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest}
describe-snapshot-attribute-request
  [m2283]
  (clojure.core/let
   [bean2282
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/let
    [v2284
     (:attribute m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setAttribute (clojure.core/str v2284))))
   (clojure.core/let
    [v2284
     (:snapshot-id m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setSnapshotId (clojure.core/str v2284))))
   bean2282))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RebootInstancesRequest}
reboot-instances-request
  [m2286]
  (clojure.core/let
   [bean2285
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/let
    [v2287
     (:instance-ids m2286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2287 :com.palletops.awaze.client-builder/undef)
     (.
      bean2285
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2830] (clojure.core/str arg2830))
 v2287))))
   bean2285))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest}
reject-vpc-peering-connection-request
  [m2289]
  (clojure.core/let
   [bean2288
    (new
     com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2290
     (:vpc-peering-connection-id
      m2289
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2290 :com.palletops.awaze.client-builder/undef)
     (. bean2288 setVpcPeeringConnectionId (clojure.core/str v2290))))
   bean2288))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSecurityGroupRequest}
create-security-group-request
  [m2292]
  (clojure.core/let
   [bean2291
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/let
    [v2293 (:vpc-id m2292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setVpcId (clojure.core/str v2293))))
   (clojure.core/let
    [v2293
     (:description m2292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setDescription (clojure.core/str v2293))))
   (clojure.core/let
    [v2293
     (:group-name m2292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setGroupName (clojure.core/str v2293))))
   bean2291))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest}
describe-spot-instance-requests-request
  [m2295]
  (clojure.core/let
   [bean2294
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2296
     (:spot-instance-request-ids
      m2295
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (.
      bean2294
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2831] (clojure.core/str arg2831))
 v2296))))
   (clojure.core/let
    [v2296 (:filters m2295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (.
      bean2294
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2832] (ec2/filter arg2832))
 v2296))))
   bean2294))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest}
describe-spot-datafeed-subscription-request
  [m2298]
  (clojure.core/let
   [bean2297
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean2297))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MoveAddressToVpcRequest}
move-address-to-vpc-request
  [m2301]
  (clojure.core/let
   [bean2300
    (new com.amazonaws.services.ec2.model.MoveAddressToVpcRequest)]
   (clojure.core/let
    [v2302
     (:public-ip m2301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2302 :com.palletops.awaze.client-builder/undef)
     (. bean2300 setPublicIp (clojure.core/str v2302))))
   bean2300))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest}
modify-vpc-endpoint-request
  [m2304]
  (clojure.core/let
   [bean2303
    (new com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest)]
   (clojure.core/let
    [v2305
     (:vpc-endpoint-id
      m2304
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (. bean2303 setVpcEndpointId (clojure.core/str v2305))))
   (clojure.core/let
    [v2305
     (:reset-policy m2304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (. bean2303 setResetPolicy (clojure.core/boolean v2305))))
   (clojure.core/let
    [v2305
     (:policy-document
      m2304
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (. bean2303 setPolicyDocument (clojure.core/str v2305))))
   (clojure.core/let
    [v2305
     (:add-route-table-ids
      m2304
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (.
      bean2303
      setAddRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2833] (clojure.core/str arg2833))
 v2305))))
   (clojure.core/let
    [v2305
     (:remove-route-table-ids
      m2304
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (.
      bean2303
      setRemoveRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2834] (clojure.core/str arg2834))
 v2305))))
   bean2303))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest}
attach-network-interface-request
  [m2307]
  (clojure.core/let
   [bean2306
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2308
     (:device-index m2307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setDeviceIndex (clojure.core/int v2308))))
   (clojure.core/let
    [v2308
     (:instance-id m2307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setInstanceId (clojure.core/str v2308))))
   (clojure.core/let
    [v2308
     (:network-interface-id
      m2307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setNetworkInterfaceId (clojure.core/str v2308))))
   bean2306))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest}
detach-network-interface-request
  [m2310]
  (clojure.core/let
   [bean2309
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2311 (:force m2310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2311 :com.palletops.awaze.client-builder/undef)
     (. bean2309 setForce (clojure.core/boolean v2311))))
   (clojure.core/let
    [v2311
     (:attachment-id m2310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2311 :com.palletops.awaze.client-builder/undef)
     (. bean2309 setAttachmentId (clojure.core/str v2311))))
   bean2309))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest}
delete-dhcp-options-request
  [m2313]
  (clojure.core/let
   [bean2312
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/let
    [v2314
     (:dhcp-options-id
      m2313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setDhcpOptionsId (clojure.core/str v2314))))
   bean2312))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest}
describe-vpc-endpoints-request
  [m2316]
  (clojure.core/let
   [bean2315
    (new com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest)]
   (clojure.core/let
    [v2317
     (:vpc-endpoint-ids
      m2316
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2317 :com.palletops.awaze.client-builder/undef)
     (.
      bean2315
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2835] (clojure.core/str arg2835))
 v2317))))
   (clojure.core/let
    [v2317
     (:next-token m2316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2317 :com.palletops.awaze.client-builder/undef)
     (. bean2315 setNextToken (clojure.core/str v2317))))
   (clojure.core/let
    [v2317
     (:max-results m2316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2317 :com.palletops.awaze.client-builder/undef)
     (. bean2315 setMaxResults (clojure.core/int v2317))))
   (clojure.core/let
    [v2317 (:filters m2316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2317 :com.palletops.awaze.client-builder/undef)
     (.
      bean2315
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2836] (ec2/filter arg2836))
 v2317))))
   bean2315))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest}
confirm-product-instance-request
  [m2319]
  (clojure.core/let
   [bean2318
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/let
    [v2320
     (:product-code m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setProductCode (clojure.core/str v2320))))
   (clojure.core/let
    [v2320
     (:instance-id m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setInstanceId (clojure.core/str v2320))))
   bean2318))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateAddressRequest}
allocate-address-request
  [m2322]
  (clojure.core/let
   [bean2321
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/let
    [v2323 (:domain m2322 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2323 :com.palletops.awaze.client-builder/undef)
     (. bean2321 setDomain (ec2/domain-type v2323))))
   bean2321))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcEndpointRequest}
create-vpc-endpoint-request
  [m2325]
  (clojure.core/let
   [bean2324
    (new com.amazonaws.services.ec2.model.CreateVpcEndpointRequest)]
   (clojure.core/let
    [v2326
     (:route-table-ids
      m2325
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (.
      bean2324
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2837] (clojure.core/str arg2837))
 v2326))))
   (clojure.core/let
    [v2326 (:vpc-id m2325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (. bean2324 setVpcId (clojure.core/str v2326))))
   (clojure.core/let
    [v2326
     (:client-token m2325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (. bean2324 setClientToken (clojure.core/str v2326))))
   (clojure.core/let
    [v2326
     (:policy-document
      m2325
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (. bean2324 setPolicyDocument (clojure.core/str v2326))))
   (clojure.core/let
    [v2326
     (:service-name m2325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (. bean2324 setServiceName (clojure.core/str v2326))))
   bean2324))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportKeyPairRequest}
import-key-pair-request
  [m2328]
  (clojure.core/let
   [bean2327
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/let
    [v2329
     (:key-name m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setKeyName (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:public-key-material
      m2328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setPublicKeyMaterial (clojure.core/str v2329))))
   bean2327))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopySnapshotRequest}
copy-snapshot-request
  [m2331]
  (clojure.core/let
   [bean2330
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/let
    [v2332
     (:description m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setDescription (clojure.core/str v2332))))
   (clojure.core/let
    [v2332
     (:source-snapshot-id
      m2331
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setSourceSnapshotId (clojure.core/str v2332))))
   (clojure.core/let
    [v2332
     (:destination-region
      m2331
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setDestinationRegion (clojure.core/str v2332))))
   (clojure.core/let
    [v2332
     (:presigned-url m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setPresignedUrl (clojure.core/str v2332))))
   (clojure.core/let
    [v2332
     (:source-region m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setSourceRegion (clojure.core/str v2332))))
   (clojure.core/let
    [v2332
     (:encrypted m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setEncrypted (clojure.core/boolean v2332))))
   (clojure.core/let
    [v2332
     (:kms-key-id m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setKmsKeyId (clojure.core/str v2332))))
   bean2330))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m2334]
  (clojure.core/let
   [bean2333
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v2335
     (:snapshot-id m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setSnapshotId (clojure.core/str v2335))))
   bean2333))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeRequest}
reset-image-attribute-request
  [m2337]
  (clojure.core/let
   [bean2336
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/let
    [v2338
     (:attribute m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setAttribute (clojure.core/str v2338))))
   (clojure.core/let
    [v2338
     (:image-id m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setImageId (clojure.core/str v2338))))
   bean2336))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInternetGatewayRequest}
create-internet-gateway-request
  [m2340]
  (clojure.core/let
   [bean2339
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean2339))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MonitorInstancesRequest}
monitor-instances-request
  [m2343]
  (clojure.core/let
   [bean2342
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/let
    [v2344
     (:instance-ids m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (.
      bean2342
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2838] (clojure.core/str arg2838))
 v2344))))
   bean2342))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest}
revoke-security-group-egress-request
  [m2346]
  (clojure.core/let
   [bean2345
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2347
     (:group-id m2346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (. bean2345 setGroupId (clojure.core/str v2347))))
   (clojure.core/let
    [v2347
     (:source-security-group-name
      m2346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (. bean2345 setSourceSecurityGroupName (clojure.core/str v2347))))
   (clojure.core/let
    [v2347
     (:source-security-group-owner-id
      m2346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (.
      bean2345
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2347))))
   (clojure.core/let
    [v2347
     (:ip-protocol m2346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (. bean2345 setIpProtocol (clojure.core/str v2347))))
   (clojure.core/let
    [v2347
     (:from-port m2346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (. bean2345 setFromPort (clojure.core/int v2347))))
   (clojure.core/let
    [v2347 (:to-port m2346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (. bean2345 setToPort (clojure.core/int v2347))))
   (clojure.core/let
    [v2347 (:cidr-ip m2346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (. bean2345 setCidrIp (clojure.core/str v2347))))
   (clojure.core/let
    [v2347
     (:ip-permissions m2346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (.
      bean2345
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2839] (ec2/ip-permission arg2839))
 v2347))))
   bean2345))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcsRequest}
describe-vpcs-request
  [m2349]
  (clojure.core/let
   [bean2348
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/let
    [v2350 (:vpc-ids m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (.
      bean2348
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2840] (clojure.core/str arg2840))
 v2350))))
   (clojure.core/let
    [v2350 (:filters m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (.
      bean2348
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2841] (ec2/filter arg2841))
 v2350))))
   bean2348))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceRequest}
import-instance-request
  [m2352]
  (clojure.core/let
   [bean2351
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/let
    [v2353
     (:description m2352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (. bean2351 setDescription (clojure.core/str v2353))))
   (clojure.core/let
    [v2353
     (:platform m2352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (. bean2351 setPlatform (ec2/platform-values v2353))))
   (clojure.core/let
    [v2353
     (:launch-specification
      m2352
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (.
      bean2351
      setLaunchSpecification
      (ec2/import-instance-launch-specification v2353))))
   (clojure.core/let
    [v2353
     (:disk-images m2352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (.
      bean2351
      setDiskImages
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2842] (ec2/disk-image arg2842))
 v2353))))
   bean2351))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopyImageRequest}
copy-image-request
  [m2355]
  (clojure.core/let
   [bean2354 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/let
    [v2356
     (:description m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setDescription (clojure.core/str v2356))))
   (clojure.core/let
    [v2356
     (:client-token m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setClientToken (clojure.core/str v2356))))
   (clojure.core/let
    [v2356
     (:source-region m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setSourceRegion (clojure.core/str v2356))))
   (clojure.core/let
    [v2356
     (:source-image-id
      m2355
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setSourceImageId (clojure.core/str v2356))))
   (clojure.core/let
    [v2356
     (:encrypted m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setEncrypted (clojure.core/boolean v2356))))
   (clojure.core/let
    [v2356
     (:kms-key-id m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setKmsKeyId (clojure.core/str v2356))))
   (clojure.core/let
    [v2356 (:name m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setName (clojure.core/str v2356))))
   bean2354))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetConsoleOutputRequest}
get-console-output-request
  [m2358]
  (clojure.core/let
   [bean2357
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/let
    [v2359
     (:instance-id m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setInstanceId (clojure.core/str v2359))))
   bean2357))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest}
modify-snapshot-attribute-request
  [m2361]
  (clojure.core/let
   [bean2360
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/let
    [v2362
     (:attribute m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setAttribute (clojure.core/str v2362))))
   (clojure.core/let
    [v2362
     (:snapshot-id m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setSnapshotId (clojure.core/str v2362))))
   (clojure.core/let
    [v2362
     (:operation-type m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setOperationType (clojure.core/str v2362))))
   (clojure.core/let
    [v2362
     (:user-ids m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (.
      bean2360
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2843] (clojure.core/str arg2843))
 v2362))))
   (clojure.core/let
    [v2362
     (:create-volume-permission
      m2361
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (.
      bean2360
      setCreateVolumePermission
      (ec2/create-volume-permission-modifications v2362))))
   (clojure.core/let
    [v2362
     (:group-names m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (.
      bean2360
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2844] (clojure.core/str arg2844))
 v2362))))
   bean2360))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotFleetRequest}
request-spot-fleet-request
  [m2364]
  (clojure.core/let
   [bean2363
    (new com.amazonaws.services.ec2.model.RequestSpotFleetRequest)]
   (clojure.core/let
    [v2365
     (:spot-fleet-request-config
      m2364
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setSpotFleetRequestConfig
      (ec2/spot-fleet-request-config-data v2365))))
   bean2363))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest}
restore-address-to-classic-request
  [m2367]
  (clojure.core/let
   [bean2366
    (new
     com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest)]
   (clojure.core/let
    [v2368
     (:public-ip m2367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setPublicIp (clojure.core/str v2368))))
   bean2366))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest}
modify-subnet-attribute-request
  [m2370]
  (clojure.core/let
   [bean2369
    (new
     com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest)]
   (clojure.core/let
    [v2371
     (:subnet-id m2370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setSubnetId (clojure.core/str v2371))))
   (clojure.core/let
    [v2371
     (:map-public-ip-on-launch
      m2370
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setMapPublicIpOnLaunch (clojure.core/boolean v2371))))
   bean2369))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeConversionTasksRequest}
describe-conversion-tasks-request
  [m2373]
  (clojure.core/let
   [bean2372
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/let
    [v2374 (:filters m2373 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (.
      bean2372
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2845] (ec2/filter arg2845))
 v2374))))
   (clojure.core/let
    [v2374
     (:conversion-task-ids
      m2373
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (.
      bean2372
      setConversionTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2846] (clojure.core/str arg2846))
 v2374))))
   bean2372))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest}
authorize-security-group-egress-request
  [m2376]
  (clojure.core/let
   [bean2375
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2377
     (:group-id m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setGroupId (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:source-security-group-name
      m2376
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setSourceSecurityGroupName (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:source-security-group-owner-id
      m2376
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (.
      bean2375
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:ip-protocol m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setIpProtocol (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:from-port m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setFromPort (clojure.core/int v2377))))
   (clojure.core/let
    [v2377 (:to-port m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setToPort (clojure.core/int v2377))))
   (clojure.core/let
    [v2377 (:cidr-ip m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setCidrIp (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:ip-permissions m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (.
      bean2375
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2847] (ec2/ip-permission arg2847))
 v2377))))
   bean2375))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest}
authorize-security-group-ingress-request
  [m2379]
  (clojure.core/let
   [bean2378
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2380 (:cidr-ip m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setCidrIp (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:group-id m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setGroupId (clojure.core/str v2380))))
   (clojure.core/let
    [v2380 (:to-port m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setToPort (clojure.core/int v2380))))
   (clojure.core/let
    [v2380
     (:source-security-group-owner-id
      m2379
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (.
      bean2378
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:ip-permissions m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (.
      bean2378
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2848] (ec2/ip-permission arg2848))
 v2380))))
   (clojure.core/let
    [v2380
     (:source-security-group-name
      m2379
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setSourceSecurityGroupName (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:group-name m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setGroupName (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:ip-protocol m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setIpProtocol (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:from-port m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setFromPort (clojure.core/int v2380))))
   bean2378))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAddressesRequest}
describe-addresses-request
  [m2382]
  (clojure.core/let
   [bean2381
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/let
    [v2383 (:filters m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (.
      bean2381
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2849] (ec2/filter arg2849))
 v2383))))
   (clojure.core/let
    [v2383
     (:public-ips m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (.
      bean2381
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2850] (clojure.core/str arg2850))
 v2383))))
   (clojure.core/let
    [v2383
     (:allocation-ids m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (.
      bean2381
      setAllocationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2851] (clojure.core/str arg2851))
 v2383))))
   bean2381))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest}
create-vpn-connection-route-request
  [m2385]
  (clojure.core/let
   [bean2384
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2386
     (:destination-cidr-block
      m2385
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (. bean2384 setDestinationCidrBlock (clojure.core/str v2386))))
   (clojure.core/let
    [v2386
     (:vpn-connection-id
      m2385
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (. bean2384 setVpnConnectionId (clojure.core/str v2386))))
   bean2384))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateAddressRequest}
associate-address-request
  [m2388]
  (clojure.core/let
   [bean2387
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/let
    [v2389
     (:public-ip m2388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setPublicIp (clojure.core/str v2389))))
   (clojure.core/let
    [v2389
     (:allocation-id m2388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setAllocationId (clojure.core/str v2389))))
   (clojure.core/let
    [v2389
     (:private-ip-address
      m2388
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setPrivateIpAddress (clojure.core/str v2389))))
   (clojure.core/let
    [v2389
     (:allow-reassociation
      m2388
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setAllowReassociation (clojure.core/boolean v2389))))
   (clojure.core/let
    [v2389
     (:instance-id m2388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setInstanceId (clojure.core/str v2389))))
   (clojure.core/let
    [v2389
     (:network-interface-id
      m2388
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setNetworkInterfaceId (clojure.core/str v2389))))
   bean2387))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest}
create-instance-export-task-request
  [m2391]
  (clojure.core/let
   [bean2390
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/let
    [v2392
     (:description m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setDescription (clojure.core/str v2392))))
   (clojure.core/let
    [v2392
     (:instance-id m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setInstanceId (clojure.core/str v2392))))
   (clojure.core/let
    [v2392
     (:target-environment
      m2391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setTargetEnvironment (ec2/export-environment v2392))))
   (clojure.core/let
    [v2392
     (:export-to-s3task
      m2391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (.
      bean2390
      setExportToS3Task
      (ec2/export-to-s3task-specification v2392))))
   bean2390))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeKeyPairsRequest}
describe-key-pairs-request
  [m2394]
  (clojure.core/let
   [bean2393
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/let
    [v2395 (:filters m2394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2395 :com.palletops.awaze.client-builder/undef)
     (.
      bean2393
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2852] (ec2/filter arg2852))
 v2395))))
   (clojure.core/let
    [v2395
     (:key-names m2394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2395 :com.palletops.awaze.client-builder/undef)
     (.
      bean2393
      setKeyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2853] (clojure.core/str arg2853))
 v2395))))
   bean2393))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest}
describe-spot-fleet-requests-request
  [m2397]
  (clojure.core/let
   [bean2396
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2398
     (:spot-fleet-request-ids
      m2397
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2398 :com.palletops.awaze.client-builder/undef)
     (.
      bean2396
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2854] (clojure.core/str arg2854))
 v2398))))
   (clojure.core/let
    [v2398
     (:next-token m2397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2398 :com.palletops.awaze.client-builder/undef)
     (. bean2396 setNextToken (clojure.core/str v2398))))
   (clojure.core/let
    [v2398
     (:max-results m2397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2398 :com.palletops.awaze.client-builder/undef)
     (. bean2396 setMaxResults (clojure.core/int v2398))))
   bean2396))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImageAttributeRequest}
describe-image-attribute-request
  [m2400]
  (clojure.core/let
   [bean2399
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/let
    [v2401
     (:attribute m2400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (. bean2399 setAttribute (clojure.core/str v2401))))
   (clojure.core/let
    [v2401
     (:image-id m2400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (. bean2399 setImageId (clojure.core/str v2401))))
   bean2399))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest}
describe-moving-addresses-request
  [m2403]
  (clojure.core/let
   [bean2402
    (new
     com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest)]
   (clojure.core/let
    [v2404
     (:next-token m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (. bean2402 setNextToken (clojure.core/str v2404))))
   (clojure.core/let
    [v2404
     (:max-results m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (. bean2402 setMaxResults (clojure.core/int v2404))))
   (clojure.core/let
    [v2404 (:filters m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (.
      bean2402
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2855] (ec2/filter arg2855))
 v2404))))
   (clojure.core/let
    [v2404
     (:public-ips m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (.
      bean2402
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2856] (clojure.core/str arg2856))
 v2404))))
   bean2402))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclRequest}
delete-network-acl-request
  [m2406]
  (clojure.core/let
   [bean2405
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/let
    [v2407
     (:network-acl-id m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (. bean2405 setNetworkAclId (clojure.core/str v2407))))
   bean2405))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest}
delete-network-interface-request
  [m2409]
  (clojure.core/let
   [bean2408
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/let
    [v2410
     (:network-interface-id
      m2409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2410 :com.palletops.awaze.client-builder/undef)
     (. bean2408 setNetworkInterfaceId (clojure.core/str v2410))))
   bean2408))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest}
delete-vpn-connection-request
  [m2412]
  (clojure.core/let
   [bean2411
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/let
    [v2413
     (:vpn-connection-id
      m2412
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2413 :com.palletops.awaze.client-builder/undef)
     (. bean2411 setVpnConnectionId (clojure.core/str v2413))))
   bean2411))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest}
purchase-scheduled-instances-request
  [m2415]
  (clojure.core/let
   [bean2414
    (new
     com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest)]
   (clojure.core/let
    [v2416
     (:client-token m2415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2416 :com.palletops.awaze.client-builder/undef)
     (. bean2414 setClientToken (clojure.core/str v2416))))
   (clojure.core/let
    [v2416
     (:purchase-requests
      m2415
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2416 :com.palletops.awaze.client-builder/undef)
     (.
      bean2414
      setPurchaseRequests
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2857] (ec2/purchase-request arg2857))
 v2416))))
   bean2414))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest}
describe-reserved-instances-modifications-request
  [m2418]
  (clojure.core/let
   [bean2417
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/let
    [v2419
     (:reserved-instances-modification-ids
      m2418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (.
      bean2417
      setReservedInstancesModificationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2858] (clojure.core/str arg2858))
 v2419))))
   (clojure.core/let
    [v2419
     (:next-token m2418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (. bean2417 setNextToken (clojure.core/str v2419))))
   (clojure.core/let
    [v2419 (:filters m2418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (.
      bean2417
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2859] (ec2/filter arg2859))
 v2419))))
   bean2417))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest}
describe-classic-link-instances-request
  [m2421]
  (clojure.core/let
   [bean2420
    (new
     com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest)]
   (clojure.core/let
    [v2422
     (:next-token m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setNextToken (clojure.core/str v2422))))
   (clojure.core/let
    [v2422
     (:max-results m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setMaxResults (clojure.core/int v2422))))
   (clojure.core/let
    [v2422 (:filters m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (.
      bean2420
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2860] (ec2/filter arg2860))
 v2422))))
   (clojure.core/let
    [v2422
     (:instance-ids m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (.
      bean2420
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2861] (clojure.core/str arg2861))
 v2422))))
   bean2420))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest}
purchase-reserved-instances-offering-request
  [m2424]
  (clojure.core/let
   [bean2423
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/let
    [v2425
     (:instance-count m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (. bean2423 setInstanceCount (clojure.core/int v2425))))
   (clojure.core/let
    [v2425
     (:reserved-instances-offering-id
      m2424
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (.
      bean2423
      setReservedInstancesOfferingId
      (clojure.core/str v2425))))
   (clojure.core/let
    [v2425
     (:limit-price m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (.
      bean2423
      setLimitPrice
      (ec2/reserved-instance-limit-price v2425))))
   bean2423))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StartInstancesRequest}
start-instances-request
  [m2427]
  (clojure.core/let
   [bean2426
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/let
    [v2428
     (:additional-info
      m2427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setAdditionalInfo (clojure.core/str v2428))))
   (clojure.core/let
    [v2428
     (:instance-ids m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (.
      bean2426
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2862] (clojure.core/str arg2862))
 v2428))))
   bean2426))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest}
describe-instance-attribute-request
  [m2430]
  (clojure.core/let
   [bean2429
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/let
    [v2431
     (:attribute m2430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (. bean2429 setAttribute (clojure.core/str v2431))))
   (clojure.core/let
    [v2431
     (:instance-id m2430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (. bean2429 setInstanceId (clojure.core/str v2431))))
   bean2429))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest}
cancel-spot-fleet-requests-request
  [m2433]
  (clojure.core/let
   [bean2432
    (new
     com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2434
     (:spot-fleet-request-ids
      m2433
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2434 :com.palletops.awaze.client-builder/undef)
     (.
      bean2432
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2863] (clojure.core/str arg2863))
 v2434))))
   (clojure.core/let
    [v2434
     (:terminate-instances
      m2433
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2434 :com.palletops.awaze.client-builder/undef)
     (. bean2432 setTerminateInstances (clojure.core/boolean v2434))))
   bean2432))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSubnetsRequest}
describe-subnets-request
  [m2436]
  (clojure.core/let
   [bean2435
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/let
    [v2437
     (:subnet-ids m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (.
      bean2435
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2864] (clojure.core/str arg2864))
 v2437))))
   (clojure.core/let
    [v2437 (:filters m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (.
      bean2435
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2865] (ec2/filter arg2865))
 v2437))))
   bean2435))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumeRequest}
create-volume-request
  [m2439]
  (clojure.core/let
   [bean2438
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/let
    [v2440
     (:snapshot-id m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setSnapshotId (clojure.core/str v2440))))
   (clojure.core/let
    [v2440
     (:availability-zone
      m2439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setAvailabilityZone (clojure.core/str v2440))))
   (clojure.core/let
    [v2440
     (:encrypted m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setEncrypted (clojure.core/boolean v2440))))
   (clojure.core/let
    [v2440
     (:kms-key-id m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setKmsKeyId (clojure.core/str v2440))))
   (clojure.core/let
    [v2440
     (:volume-type m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setVolumeType (clojure.core/str v2440))))
   (clojure.core/let
    [v2440 (:iops m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setIops (clojure.core/int v2440))))
   (clojure.core/let
    [v2440 (:size m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setSize (clojure.core/int v2440))))
   bean2438))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest}
describe-reserved-instances-listings-request
  [m2442]
  (clojure.core/let
   [bean2441
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/let
    [v2443
     (:reserved-instances-id
      m2442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setReservedInstancesId (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:reserved-instances-listing-id
      m2442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (.
      bean2441
      setReservedInstancesListingId
      (clojure.core/str v2443))))
   (clojure.core/let
    [v2443 (:filters m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (.
      bean2441
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2866] (ec2/filter arg2866))
 v2443))))
   bean2441))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest}
create-dhcp-options-request
  [m2445]
  (clojure.core/let
   [bean2444
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/let
    [v2446
     (:dhcp-configurations
      m2445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (.
      bean2444
      setDhcpConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2867] (ec2/dhcp-configuration arg2867))
 v2446))))
   bean2444))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachInternetGatewayRequest}
detach-internet-gateway-request
  [m2448]
  (clojure.core/let
   [bean2447
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/let
    [v2449 (:vpc-id m2448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (. bean2447 setVpcId (clojure.core/str v2449))))
   (clojure.core/let
    [v2449
     (:internet-gateway-id
      m2448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (. bean2447 setInternetGatewayId (clojure.core/str v2449))))
   bean2447))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest}
delete-vpn-gateway-request
  [m2451]
  (clojure.core/let
   [bean2450
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/let
    [v2452
     (:vpn-gateway-id m2451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2452 :com.palletops.awaze.client-builder/undef)
     (. bean2450 setVpnGatewayId (clojure.core/str v2452))))
   bean2450))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotInstancesRequest}
request-spot-instances-request
  [m2454]
  (clojure.core/let
   [bean2453
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/let
    [v2455
     (:spot-price m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setSpotPrice (clojure.core/str v2455))))
   (clojure.core/let
    [v2455
     (:valid-from m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (.
      bean2453
      setValidFrom
      (com.palletops.awaze.common/to-date v2455))))
   (clojure.core/let
    [v2455
     (:block-duration-minutes
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setBlockDurationMinutes (clojure.core/int v2455))))
   (clojure.core/let
    [v2455 (:type m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setType (ec2/spot-instance-type v2455))))
   (clojure.core/let
    [v2455
     (:client-token m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setClientToken (clojure.core/str v2455))))
   (clojure.core/let
    [v2455
     (:launch-group m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setLaunchGroup (clojure.core/str v2455))))
   (clojure.core/let
    [v2455
     (:instance-count m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setInstanceCount (clojure.core/int v2455))))
   (clojure.core/let
    [v2455
     (:launch-specification
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (.
      bean2453
      setLaunchSpecification
      (ec2/launch-specification v2455))))
   (clojure.core/let
    [v2455
     (:valid-until m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (.
      bean2453
      setValidUntil
      (com.palletops.awaze.common/to-date v2455))))
   (clojure.core/let
    [v2455
     (:availability-zone-group
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setAvailabilityZoneGroup (clojure.core/str v2455))))
   bean2453))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportVolumeRequest}
import-volume-request
  [m2457]
  (clojure.core/let
   [bean2456
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/let
    [v2458
     (:availability-zone
      m2457
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setAvailabilityZone (clojure.core/str v2458))))
   (clojure.core/let
    [v2458
     (:description m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setDescription (clojure.core/str v2458))))
   (clojure.core/let
    [v2458 (:volume m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setVolume (ec2/volume-detail v2458))))
   (clojure.core/let
    [v2458 (:image m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setImage (ec2/disk-image-detail v2458))))
   bean2456))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportSnapshotRequest}
import-snapshot-request
  [m2460]
  (clojure.core/let
   [bean2459
    (new com.amazonaws.services.ec2.model.ImportSnapshotRequest)]
   (clojure.core/let
    [v2461
     (:description m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setDescription (clojure.core/str v2461))))
   (clojure.core/let
    [v2461
     (:client-data m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setClientData (ec2/client-data v2461))))
   (clojure.core/let
    [v2461
     (:client-token m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setClientToken (clojure.core/str v2461))))
   (clojure.core/let
    [v2461
     (:role-name m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setRoleName (clojure.core/str v2461))))
   (clojure.core/let
    [v2461
     (:disk-container m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setDiskContainer (ec2/snapshot-disk-container v2461))))
   bean2459))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeTagsRequest}
describe-tags-request
  [m2463]
  (clojure.core/let
   [bean2462
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/let
    [v2464
     (:next-token m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setNextToken (clojure.core/str v2464))))
   (clojure.core/let
    [v2464
     (:max-results m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setMaxResults (clojure.core/int v2464))))
   (clojure.core/let
    [v2464 (:filters m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (.
      bean2462
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2868] (ec2/filter arg2868))
 v2464))))
   bean2462))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteTagsRequest}
delete-tags-request
  [m2466]
  (clojure.core/let
   [bean2465 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/let
    [v2467
     (:resources m2466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (.
      bean2465
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2869] (clojure.core/str arg2869))
 v2467))))
   (clojure.core/let
    [v2467 (:tags m2466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (.
      bean2465
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2870] (ec2/tag arg2870)) v2467))))
   bean2465))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest}
enable-vpc-classic-link-request
  [m2469]
  (clojure.core/let
   [bean2468
    (new com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2470 (:vpc-id m2469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2470 :com.palletops.awaze.client-builder/undef)
     (. bean2468 setVpcId (clojure.core/str v2470))))
   bean2468))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest}
describe-reserved-instances-offerings-request
  [m2472]
  (clojure.core/let
   [bean2471
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/let
    [v2473
     (:include-marketplace
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setIncludeMarketplace (clojure.core/boolean v2473))))
   (clojure.core/let
    [v2473
     (:reserved-instances-offering-ids
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (.
      bean2471
      setReservedInstancesOfferingIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2871] (clojure.core/str arg2871))
 v2473))))
   (clojure.core/let
    [v2473
     (:product-description
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (.
      bean2471
      setProductDescription
      (ec2/riproduct-description v2473))))
   (clojure.core/let
    [v2473
     (:availability-zone
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setAvailabilityZone (clojure.core/str v2473))))
   (clojure.core/let
    [v2473
     (:min-duration m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setMinDuration (clojure.core/long v2473))))
   (clojure.core/let
    [v2473
     (:instance-type m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setInstanceType (clojure.core/str v2473))))
   (clojure.core/let
    [v2473 (:filters m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (.
      bean2471
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2872] (ec2/filter arg2872))
 v2473))))
   (clojure.core/let
    [v2473
     (:offering-type m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setOfferingType (clojure.core/str v2473))))
   (clojure.core/let
    [v2473
     (:instance-tenancy
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setInstanceTenancy (ec2/tenancy v2473))))
   (clojure.core/let
    [v2473
     (:max-duration m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setMaxDuration (clojure.core/long v2473))))
   (clojure.core/let
    [v2473
     (:next-token m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setNextToken (clojure.core/str v2473))))
   (clojure.core/let
    [v2473
     (:max-results m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setMaxResults (clojure.core/int v2473))))
   (clojure.core/let
    [v2473
     (:max-instance-count
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setMaxInstanceCount (clojure.core/int v2473))))
   bean2471))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnGatewayRequest}
create-vpn-gateway-request
  [m2475]
  (clojure.core/let
   [bean2474
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/let
    [v2476
     (:availability-zone
      m2475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setAvailabilityZone (clojure.core/str v2476))))
   (clojure.core/let
    [v2476 (:type m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setType (ec2/gateway-type v2476))))
   bean2474))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRouteTablesRequest}
describe-route-tables-request
  [m2478]
  (clojure.core/let
   [bean2477
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/let
    [v2479
     (:route-table-ids
      m2478
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (.
      bean2477
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2873] (clojure.core/str arg2873))
 v2479))))
   (clojure.core/let
    [v2479 (:filters m2478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (.
      bean2477
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2874] (ec2/filter arg2874))
 v2479))))
   bean2477))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest}
cancel-spot-instance-requests-request
  [m2481]
  (clojure.core/let
   [bean2480
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2482
     (:spot-instance-request-ids
      m2481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (.
      bean2480
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2875] (clojure.core/str arg2875))
 v2482))))
   bean2480))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest}
assign-private-ip-addresses-request
  [m2484]
  (clojure.core/let
   [bean2483
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2485
     (:private-ip-addresses
      m2484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (.
      bean2483
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2876] (clojure.core/str arg2876))
 v2485))))
   (clojure.core/let
    [v2485
     (:secondary-private-ip-address-count
      m2484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (.
      bean2483
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2485))))
   (clojure.core/let
    [v2485
     (:allow-reassignment
      m2484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (. bean2483 setAllowReassignment (clojure.core/boolean v2485))))
   (clojure.core/let
    [v2485
     (:network-interface-id
      m2484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (. bean2483 setNetworkInterfaceId (clojure.core/str v2485))))
   bean2483))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest}
disable-vpc-classic-link-dns-support-request
  [m2487]
  (clojure.core/let
   [bean2486
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2488 (:vpc-id m2487 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (. bean2486 setVpcId (clojure.core/str v2488))))
   bean2486))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeletePlacementGroupRequest}
delete-placement-group-request
  [m2490]
  (clojure.core/let
   [bean2489
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/let
    [v2491
     (:group-name m2490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setGroupName (clojure.core/str v2491))))
   bean2489))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstancesRequest}
describe-instances-request
  [m2493]
  (clojure.core/let
   [bean2492
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/let
    [v2494
     (:next-token m2493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (. bean2492 setNextToken (clojure.core/str v2494))))
   (clojure.core/let
    [v2494
     (:max-results m2493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (. bean2492 setMaxResults (clojure.core/int v2494))))
   (clojure.core/let
    [v2494 (:filters m2493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (.
      bean2492
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2877] (ec2/filter arg2877))
 v2494))))
   (clojure.core/let
    [v2494
     (:instance-ids m2493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (.
      bean2492
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2878] (clojure.core/str arg2878))
 v2494))))
   bean2492))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumesRequest}
describe-volumes-request
  [m2496]
  (clojure.core/let
   [bean2495
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/let
    [v2497
     (:volume-ids m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (.
      bean2495
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2879] (clojure.core/str arg2879))
 v2497))))
   (clojure.core/let
    [v2497
     (:next-token m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setNextToken (clojure.core/str v2497))))
   (clojure.core/let
    [v2497
     (:max-results m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setMaxResults (clojure.core/int v2497))))
   (clojure.core/let
    [v2497 (:filters m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (.
      bean2495
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2880] (ec2/filter arg2880))
 v2497))))
   bean2495))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeBundleTasksRequest}
describe-bundle-tasks-request
  [m2499]
  (clojure.core/let
   [bean2498
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/let
    [v2500 (:filters m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (.
      bean2498
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2881] (ec2/filter arg2881))
 v2500))))
   (clojure.core/let
    [v2500
     (:bundle-ids m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (.
      bean2498
      setBundleIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2882] (clojure.core/str arg2882))
 v2500))))
   bean2498))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest}
associate-dhcp-options-request
  [m2502]
  (clojure.core/let
   [bean2501
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/let
    [v2503 (:vpc-id m2502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2503 :com.palletops.awaze.client-builder/undef)
     (. bean2501 setVpcId (clojure.core/str v2503))))
   (clojure.core/let
    [v2503
     (:dhcp-options-id
      m2502
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2503 :com.palletops.awaze.client-builder/undef)
     (. bean2501 setDhcpOptionsId (clojure.core/str v2503))))
   bean2501))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest}
modify-vpc-attribute-request
  [m2505]
  (clojure.core/let
   [bean2504
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/let
    [v2506 (:vpc-id m2505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (. bean2504 setVpcId (clojure.core/str v2506))))
   (clojure.core/let
    [v2506
     (:enable-dns-support
      m2505
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (. bean2504 setEnableDnsSupport (clojure.core/boolean v2506))))
   (clojure.core/let
    [v2506
     (:enable-dns-hostnames
      m2505
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (. bean2504 setEnableDnsHostnames (clojure.core/boolean v2506))))
   bean2504))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateFlowLogsRequest}
create-flow-logs-request
  [m2508]
  (clojure.core/let
   [bean2507
    (new com.amazonaws.services.ec2.model.CreateFlowLogsRequest)]
   (clojure.core/let
    [v2509
     (:client-token m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setClientToken (clojure.core/str v2509))))
   (clojure.core/let
    [v2509
     (:resource-ids m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (.
      bean2507
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2883] (clojure.core/str arg2883))
 v2509))))
   (clojure.core/let
    [v2509
     (:resource-type m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setResourceType (ec2/flow-logs-resource-type v2509))))
   (clojure.core/let
    [v2509
     (:traffic-type m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setTrafficType (clojure.core/str v2509))))
   (clojure.core/let
    [v2509
     (:log-group-name m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setLogGroupName (clojure.core/str v2509))))
   (clojure.core/let
    [v2509
     (:deliver-logs-permission-arn
      m2508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setDeliverLogsPermissionArn (clojure.core/str v2509))))
   bean2507))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateAddressRequest}
disassociate-address-request
  [m2511]
  (clojure.core/let
   [bean2510
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/let
    [v2512
     (:public-ip m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setPublicIp (clojure.core/str v2512))))
   (clojure.core/let
    [v2512
     (:association-id m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setAssociationId (clojure.core/str v2512))))
   bean2510))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest}
reset-network-interface-attribute-request
  [m2514]
  (clojure.core/let
   [bean2513
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2515
     (:source-dest-check
      m2514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (. bean2513 setSourceDestCheck (clojure.core/str v2515))))
   (clojure.core/let
    [v2515
     (:network-interface-id
      m2514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (. bean2513 setNetworkInterfaceId (clojure.core/str v2515))))
   bean2513))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest}
describe-placement-groups-request
  [m2517]
  (clojure.core/let
   [bean2516
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/let
    [v2518 (:filters m2517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (.
      bean2516
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2884] (ec2/filter arg2884))
 v2518))))
   (clojure.core/let
    [v2518
     (:group-names m2517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (.
      bean2516
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2885] (clojure.core/str arg2885))
 v2518))))
   bean2516))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest}
reset-snapshot-attribute-request
  [m2520]
  (clojure.core/let
   [bean2519
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/let
    [v2521
     (:attribute m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (. bean2519 setAttribute (clojure.core/str v2521))))
   (clojure.core/let
    [v2521
     (:snapshot-id m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (. bean2519 setSnapshotId (clojure.core/str v2521))))
   bean2519))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseAddressRequest}
release-address-request
  [m2523]
  (clojure.core/let
   [bean2522
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/let
    [v2524
     (:public-ip m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setPublicIp (clojure.core/str v2524))))
   (clojure.core/let
    [v2524
     (:allocation-id m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setAllocationId (clojure.core/str v2524))))
   bean2522))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest}
describe-volume-status-request
  [m2526]
  (clojure.core/let
   [bean2525
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/let
    [v2527
     (:volume-ids m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (.
      bean2525
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2886] (clojure.core/str arg2886))
 v2527))))
   (clojure.core/let
    [v2527
     (:next-token m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setNextToken (clojure.core/str v2527))))
   (clojure.core/let
    [v2527
     (:max-results m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setMaxResults (clojure.core/int v2527))))
   (clojure.core/let
    [v2527 (:filters m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (.
      bean2525
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2887] (ec2/filter arg2887))
 v2527))))
   bean2525))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BundleInstanceRequest}
bundle-instance-request
  [m2529]
  (clojure.core/let
   [bean2528
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/let
    [v2530 (:storage m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (. bean2528 setStorage (ec2/storage v2530))))
   (clojure.core/let
    [v2530
     (:instance-id m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (. bean2528 setInstanceId (clojure.core/str v2530))))
   bean2528))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest}
describe-vpn-connections-request
  [m2532]
  (clojure.core/let
   [bean2531
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/let
    [v2533
     (:vpn-connection-ids
      m2532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2533 :com.palletops.awaze.client-builder/undef)
     (.
      bean2531
      setVpnConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2888] (clojure.core/str arg2888))
 v2533))))
   (clojure.core/let
    [v2533 (:filters m2532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2533 :com.palletops.awaze.client-builder/undef)
     (.
      bean2531
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2889] (ec2/filter arg2889))
 v2533))))
   bean2531))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteRequest}
create-route-request
  [m2535]
  (clojure.core/let
   [bean2534
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/let
    [v2536
     (:route-table-id m2535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (. bean2534 setRouteTableId (clojure.core/str v2536))))
   (clojure.core/let
    [v2536
     (:gateway-id m2535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (. bean2534 setGatewayId (clojure.core/str v2536))))
   (clojure.core/let
    [v2536
     (:vpc-peering-connection-id
      m2535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (. bean2534 setVpcPeeringConnectionId (clojure.core/str v2536))))
   (clojure.core/let
    [v2536
     (:destination-cidr-block
      m2535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (. bean2534 setDestinationCidrBlock (clojure.core/str v2536))))
   (clojure.core/let
    [v2536
     (:nat-gateway-id m2535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (. bean2534 setNatGatewayId (clojure.core/str v2536))))
   (clojure.core/let
    [v2536
     (:instance-id m2535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (. bean2534 setInstanceId (clojure.core/str v2536))))
   (clojure.core/let
    [v2536
     (:network-interface-id
      m2535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (. bean2534 setNetworkInterfaceId (clojure.core/str v2536))))
   bean2534))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest}
describe-spot-price-history-request
  [m2538]
  (clojure.core/let
   [bean2537
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/let
    [v2539
     (:start-time m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (.
      bean2537
      setStartTime
      (com.palletops.awaze.common/to-date v2539))))
   (clojure.core/let
    [v2539
     (:availability-zone
      m2538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setAvailabilityZone (clojure.core/str v2539))))
   (clojure.core/let
    [v2539
     (:end-time m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (.
      bean2537
      setEndTime
      (com.palletops.awaze.common/to-date v2539))))
   (clojure.core/let
    [v2539
     (:instance-types m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (.
      bean2537
      setInstanceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2890] (clojure.core/str arg2890))
 v2539))))
   (clojure.core/let
    [v2539
     (:product-descriptions
      m2538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (.
      bean2537
      setProductDescriptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2891] (clojure.core/str arg2891))
 v2539))))
   (clojure.core/let
    [v2539
     (:next-token m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setNextToken (clojure.core/str v2539))))
   (clojure.core/let
    [v2539
     (:max-results m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setMaxResults (clojure.core/int v2539))))
   (clojure.core/let
    [v2539 (:filters m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (.
      bean2537
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2892] (ec2/filter arg2892))
 v2539))))
   bean2537))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest}
describe-availability-zones-request
  [m2541]
  (clojure.core/let
   [bean2540
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/let
    [v2542 (:filters m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2893] (ec2/filter arg2893))
 v2542))))
   (clojure.core/let
    [v2542
     (:zone-names m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setZoneNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2894] (clojure.core/str arg2894))
 v2542))))
   bean2540))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest}
create-vpc-peering-connection-request
  [m2544]
  (clojure.core/let
   [bean2543
    (new
     com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2545 (:vpc-id m2544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2545 :com.palletops.awaze.client-builder/undef)
     (. bean2543 setVpcId (clojure.core/str v2545))))
   (clojure.core/let
    [v2545
     (:peer-vpc-id m2544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2545 :com.palletops.awaze.client-builder/undef)
     (. bean2543 setPeerVpcId (clojure.core/str v2545))))
   (clojure.core/let
    [v2545
     (:peer-owner-id m2544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2545 :com.palletops.awaze.client-builder/undef)
     (. bean2543 setPeerOwnerId (clojure.core/str v2545))))
   bean2543))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest}
describe-internet-gateways-request
  [m2547]
  (clojure.core/let
   [bean2546
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/let
    [v2548 (:filters m2547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2548 :com.palletops.awaze.client-builder/undef)
     (.
      bean2546
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2895] (ec2/filter arg2895))
 v2548))))
   (clojure.core/let
    [v2548
     (:internet-gateway-ids
      m2547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2548 :com.palletops.awaze.client-builder/undef)
     (.
      bean2546
      setInternetGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2896] (clojure.core/str arg2896))
 v2548))))
   bean2546))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateRouteTableRequest}
disassociate-route-table-request
  [m2550]
  (clojure.core/let
   [bean2549
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/let
    [v2551
     (:association-id m2550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2551 :com.palletops.awaze.client-builder/undef)
     (. bean2549 setAssociationId (clojure.core/str v2551))))
   bean2549))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRegionsRequest}
describe-regions-request
  [m2553]
  (clojure.core/let
   [bean2552
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/let
    [v2554
     (:region-names m2553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2554 :com.palletops.awaze.client-builder/undef)
     (.
      bean2552
      setRegionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2897] (clojure.core/str arg2897))
 v2554))))
   (clojure.core/let
    [v2554 (:filters m2553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2554 :com.palletops.awaze.client-builder/undef)
     (.
      bean2552
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2898] (ec2/filter arg2898))
 v2554))))
   bean2552))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest}
enable-vpc-classic-link-dns-support-request
  [m2556]
  (clojure.core/let
   [bean2555
    (new
     com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2557 (:vpc-id m2556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (. bean2555 setVpcId (clojure.core/str v2557))))
   bean2555))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeregisterImageRequest}
deregister-image-request
  [m2559]
  (clojure.core/let
   [bean2558
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/let
    [v2560
     (:image-id m2559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setImageId (clojure.core/str v2560))))
   bean2558))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest}
delete-spot-datafeed-subscription-request
  [m2562]
  (clojure.core/let
   [bean2561
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean2561))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest}
describe-customer-gateways-request
  [m2565]
  (clojure.core/let
   [bean2564
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/let
    [v2566 (:filters m2565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2566 :com.palletops.awaze.client-builder/undef)
     (.
      bean2564
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2899] (ec2/filter arg2899))
 v2566))))
   (clojure.core/let
    [v2566
     (:customer-gateway-ids
      m2565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2566 :com.palletops.awaze.client-builder/undef)
     (.
      bean2564
      setCustomerGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2900] (clojure.core/str arg2900))
 v2566))))
   bean2564))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest}
describe-spot-fleet-request-history-request
  [m2568]
  (clojure.core/let
   [bean2567
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest)]
   (clojure.core/let
    [v2569
     (:spot-fleet-request-id
      m2568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setSpotFleetRequestId (clojure.core/str v2569))))
   (clojure.core/let
    [v2569
     (:event-type m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setEventType (clojure.core/str v2569))))
   (clojure.core/let
    [v2569
     (:start-time m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (.
      bean2567
      setStartTime
      (com.palletops.awaze.common/to-date v2569))))
   (clojure.core/let
    [v2569
     (:next-token m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setNextToken (clojure.core/str v2569))))
   (clojure.core/let
    [v2569
     (:max-results m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setMaxResults (clojure.core/int v2569))))
   bean2567))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSubnetRequest}
create-subnet-request
  [m2571]
  (clojure.core/let
   [bean2570
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/let
    [v2572
     (:availability-zone
      m2571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setAvailabilityZone (clojure.core/str v2572))))
   (clojure.core/let
    [v2572 (:vpc-id m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setVpcId (clojure.core/str v2572))))
   (clojure.core/let
    [v2572
     (:cidr-block m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setCidrBlock (clojure.core/str v2572))))
   bean2570))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest}
describe-network-interface-attribute-request
  [m2574]
  (clojure.core/let
   [bean2573
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2575
     (:attribute m2574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setAttribute (clojure.core/str v2575))))
   (clojure.core/let
    [v2575
     (:network-interface-id
      m2574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setNetworkInterfaceId (clojure.core/str v2575))))
   bean2573))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest}
modify-instance-placement-request
  [m2577]
  (clojure.core/let
   [bean2576
    (new
     com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest)]
   (clojure.core/let
    [v2578 (:tenancy m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setTenancy (clojure.core/str v2578))))
   (clojure.core/let
    [v2578
     (:affinity m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setAffinity (ec2/affinity v2578))))
   (clojure.core/let
    [v2578 (:host-id m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setHostId (clojure.core/str v2578))))
   (clojure.core/let
    [v2578
     (:instance-id m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setInstanceId (clojure.core/str v2578))))
   bean2576))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest}
detach-classic-link-vpc-request
  [m2580]
  (clojure.core/let
   [bean2579
    (new com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2581 (:vpc-id m2580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2581 :com.palletops.awaze.client-builder/undef)
     (. bean2579 setVpcId (clojure.core/str v2581))))
   (clojure.core/let
    [v2581
     (:instance-id m2580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2581 :com.palletops.awaze.client-builder/undef)
     (. bean2579 setInstanceId (clojure.core/str v2581))))
   bean2579))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelConversionTaskRequest}
cancel-conversion-task-request
  [m2583]
  (clojure.core/let
   [bean2582
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/let
    [v2584
     (:conversion-task-id
      m2583
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2584 :com.palletops.awaze.client-builder/undef)
     (. bean2582 setConversionTaskId (clojure.core/str v2584))))
   (clojure.core/let
    [v2584
     (:reason-message m2583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2584 :com.palletops.awaze.client-builder/undef)
     (. bean2582 setReasonMessage (clojure.core/str v2584))))
   bean2582))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest}
create-network-interface-request
  [m2586]
  (clojure.core/let
   [bean2585
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/let
    [v2587
     (:description m2586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (. bean2585 setDescription (clojure.core/str v2587))))
   (clojure.core/let
    [v2587 (:groups m2586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (.
      bean2585
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2901] (clojure.core/str arg2901))
 v2587))))
   (clojure.core/let
    [v2587
     (:subnet-id m2586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (. bean2585 setSubnetId (clojure.core/str v2587))))
   (clojure.core/let
    [v2587
     (:private-ip-address
      m2586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (. bean2585 setPrivateIpAddress (clojure.core/str v2587))))
   (clojure.core/let
    [v2587
     (:private-ip-addresses
      m2586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (.
      bean2585
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2902]
  (ec2/private-ip-address-specification arg2902))
 v2587))))
   (clojure.core/let
    [v2587
     (:secondary-private-ip-address-count
      m2586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (.
      bean2585
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2587))))
   bean2585))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyImageAttributeRequest}
modify-image-attribute-request
  [m2589]
  (clojure.core/let
   [bean2588
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/let
    [v2590
     (:description m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setDescription (clojure.core/str v2590))))
   (clojure.core/let
    [v2590
     (:operation-type m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setOperationType (ec2/operation-type v2590))))
   (clojure.core/let
    [v2590
     (:product-codes m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (.
      bean2588
      setProductCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2903] (clojure.core/str arg2903))
 v2590))))
   (clojure.core/let
    [v2590
     (:user-ids m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (.
      bean2588
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2904] (clojure.core/str arg2904))
 v2590))))
   (clojure.core/let
    [v2590
     (:attribute m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setAttribute (clojure.core/str v2590))))
   (clojure.core/let
    [v2590
     (:image-id m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setImageId (clojure.core/str v2590))))
   (clojure.core/let
    [v2590
     (:launch-permission
      m2589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (.
      bean2588
      setLaunchPermission
      (ec2/launch-permission-modifications v2590))))
   (clojure.core/let
    [v2590 (:value m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setValue (clojure.core/str v2590))))
   (clojure.core/let
    [v2590
     (:user-groups m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (.
      bean2588
      setUserGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2905] (clojure.core/str arg2905))
 v2590))))
   bean2588))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteTableRequest}
delete-route-table-request
  [m2592]
  (clojure.core/let
   [bean2591
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/let
    [v2593
     (:route-table-id m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setRouteTableId (clojure.core/str v2593))))
   bean2591))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateRouteTableRequest}
associate-route-table-request
  [m2595]
  (clojure.core/let
   [bean2594
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/let
    [v2596
     (:route-table-id m2595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setRouteTableId (clojure.core/str v2596))))
   (clojure.core/let
    [v2596
     (:subnet-id m2595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setSubnetId (clojure.core/str v2596))))
   bean2594))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest}
delete-customer-gateway-request
  [m2598]
  (clojure.core/let
   [bean2597
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/let
    [v2599
     (:customer-gateway-id
      m2598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (. bean2597 setCustomerGatewayId (clojure.core/str v2599))))
   bean2597))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest}
replace-route-table-association-request
  [m2601]
  (clojure.core/let
   [bean2600
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/let
    [v2602
     (:route-table-id m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setRouteTableId (clojure.core/str v2602))))
   (clojure.core/let
    [v2602
     (:association-id m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setAssociationId (clojure.core/str v2602))))
   bean2600))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcRequest}
delete-vpc-request
  [m2604]
  (clojure.core/let
   [bean2603 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/let
    [v2605 (:vpc-id m2604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2605 :com.palletops.awaze.client-builder/undef)
     (. bean2603 setVpcId (clojure.core/str v2605))))
   bean2603))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateKeyPairRequest}
create-key-pair-request
  [m2607]
  (clojure.core/let
   [bean2606
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/let
    [v2608
     (:key-name m2607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (. bean2606 setKeyName (clojure.core/str v2608))))
   bean2606))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateHostsRequest}
allocate-hosts-request
  [m2610]
  (clojure.core/let
   [bean2609
    (new com.amazonaws.services.ec2.model.AllocateHostsRequest)]
   (clojure.core/let
    [v2611
     (:instance-type m2610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (. bean2609 setInstanceType (clojure.core/str v2611))))
   (clojure.core/let
    [v2611
     (:availability-zone
      m2610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (. bean2609 setAvailabilityZone (clojure.core/str v2611))))
   (clojure.core/let
    [v2611
     (:client-token m2610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (. bean2609 setClientToken (clojure.core/str v2611))))
   (clojure.core/let
    [v2611
     (:auto-placement m2610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (. bean2609 setAutoPlacement (clojure.core/str v2611))))
   (clojure.core/let
    [v2611
     (:quantity m2610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (. bean2609 setQuantity (clojure.core/int v2611))))
   bean2609))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteRequest}
replace-route-request
  [m2613]
  (clojure.core/let
   [bean2612
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/let
    [v2614
     (:route-table-id m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setRouteTableId (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:gateway-id m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setGatewayId (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:vpc-peering-connection-id
      m2613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setVpcPeeringConnectionId (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:destination-cidr-block
      m2613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setDestinationCidrBlock (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:nat-gateway-id m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setNatGatewayId (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:instance-id m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setInstanceId (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:network-interface-id
      m2613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setNetworkInterfaceId (clojure.core/str v2614))))
   bean2612))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TerminateInstancesRequest}
terminate-instances-request
  [m2616]
  (clojure.core/let
   [bean2615
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/let
    [v2617
     (:instance-ids m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (.
      bean2615
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2906] (clojure.core/str arg2906))
 v2617))))
   bean2615))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m2619]
  (clojure.core/let
   [bean2618
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v2620
     (:restorable-by-user-ids
      m2619
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (.
      bean2618
      setRestorableByUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2907] (clojure.core/str arg2907))
 v2620))))
   (clojure.core/let
    [v2620
     (:owner-ids m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (.
      bean2618
      setOwnerIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2908] (clojure.core/str arg2908))
 v2620))))
   (clojure.core/let
    [v2620
     (:snapshot-ids m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (.
      bean2618
      setSnapshotIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2909] (clojure.core/str arg2909))
 v2620))))
   (clojure.core/let
    [v2620
     (:next-token m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (. bean2618 setNextToken (clojure.core/str v2620))))
   (clojure.core/let
    [v2620
     (:max-results m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (. bean2618 setMaxResults (clojure.core/int v2620))))
   (clojure.core/let
    [v2620 (:filters m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (.
      bean2618
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2910] (ec2/filter arg2910))
 v2620))))
   bean2618))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest}
describe-vpn-gateways-request
  [m2622]
  (clojure.core/let
   [bean2621
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/let
    [v2623
     (:vpn-gateway-ids
      m2622
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (.
      bean2621
      setVpnGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2911] (clojure.core/str arg2911))
 v2623))))
   (clojure.core/let
    [v2623 (:filters m2622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (.
      bean2621
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2912] (ec2/filter arg2912))
 v2623))))
   bean2621))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetPasswordDataRequest}
get-password-data-request
  [m2625]
  (clojure.core/let
   [bean2624
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/let
    [v2626
     (:instance-id m2625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (. bean2624 setInstanceId (clojure.core/str v2626))))
   bean2624))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest}
modify-volume-attribute-request
  [m2628]
  (clojure.core/let
   [bean2627
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/let
    [v2629
     (:volume-id m2628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2629 :com.palletops.awaze.client-builder/undef)
     (. bean2627 setVolumeId (clojure.core/str v2629))))
   (clojure.core/let
    [v2629
     (:auto-enable-io m2628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2629 :com.palletops.awaze.client-builder/undef)
     (. bean2627 setAutoEnableIO (clojure.core/boolean v2629))))
   bean2627))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest}
disable-vgw-route-propagation-request
  [m2631]
  (clojure.core/let
   [bean2630
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2632
     (:route-table-id m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setRouteTableId (clojure.core/str v2632))))
   (clojure.core/let
    [v2632
     (:gateway-id m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setGatewayId (clojure.core/str v2632))))
   bean2630))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest}
describe-spot-fleet-instances-request
  [m2634]
  (clojure.core/let
   [bean2633
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest)]
   (clojure.core/let
    [v2635
     (:spot-fleet-request-id
      m2634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (. bean2633 setSpotFleetRequestId (clojure.core/str v2635))))
   (clojure.core/let
    [v2635
     (:next-token m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (. bean2633 setNextToken (clojure.core/str v2635))))
   (clojure.core/let
    [v2635
     (:max-results m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (. bean2633 setMaxResults (clojure.core/int v2635))))
   bean2633))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePrefixListsRequest}
describe-prefix-lists-request
  [m2637]
  (clojure.core/let
   [bean2636
    (new com.amazonaws.services.ec2.model.DescribePrefixListsRequest)]
   (clojure.core/let
    [v2638
     (:next-token m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setNextToken (clojure.core/str v2638))))
   (clojure.core/let
    [v2638
     (:max-results m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setMaxResults (clojure.core/int v2638))))
   (clojure.core/let
    [v2638 (:filters m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (.
      bean2636
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2913] (ec2/filter arg2913))
 v2638))))
   (clojure.core/let
    [v2638
     (:prefix-list-ids
      m2637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (.
      bean2636
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2914] (clojure.core/str arg2914))
 v2638))))
   bean2636))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m2640]
  (clojure.core/let
   [bean2639
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/let
    [v2641
     (:attribute-names
      m2640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (.
      bean2639
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2915] (clojure.core/str arg2915))
 v2641))))
   bean2639))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRequest}
create-vpn-connection-request
  [m2643]
  (clojure.core/let
   [bean2642
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/let
    [v2644
     (:vpn-gateway-id m2643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2644 :com.palletops.awaze.client-builder/undef)
     (. bean2642 setVpnGatewayId (clojure.core/str v2644))))
   (clojure.core/let
    [v2644 (:type m2643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2644 :com.palletops.awaze.client-builder/undef)
     (. bean2642 setType (clojure.core/str v2644))))
   (clojure.core/let
    [v2644 (:options m2643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2644 :com.palletops.awaze.client-builder/undef)
     (.
      bean2642
      setOptions
      (ec2/vpn-connection-options-specification v2644))))
   (clojure.core/let
    [v2644
     (:customer-gateway-id
      m2643
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2644 :com.palletops.awaze.client-builder/undef)
     (. bean2642 setCustomerGatewayId (clojure.core/str v2644))))
   bean2642))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest}
describe-vpc-peering-connections-request
  [m2646]
  (clojure.core/let
   [bean2645
    (new
     com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest)]
   (clojure.core/let
    [v2647
     (:vpc-peering-connection-ids
      m2646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (.
      bean2645
      setVpcPeeringConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2916] (clojure.core/str arg2916))
 v2647))))
   (clojure.core/let
    [v2647 (:filters m2646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (.
      bean2645
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2917] (ec2/filter arg2917))
 v2647))))
   bean2645))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest}
describe-scheduled-instance-availability-request
  [m2649]
  (clojure.core/let
   [bean2648
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest)]
   (clojure.core/let
    [v2650
     (:recurrence m2649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (.
      bean2648
      setRecurrence
      (ec2/scheduled-instance-recurrence-request v2650))))
   (clojure.core/let
    [v2650
     (:first-slot-start-time-range
      m2649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (.
      bean2648
      setFirstSlotStartTimeRange
      (ec2/slot-date-time-range-request v2650))))
   (clojure.core/let
    [v2650
     (:min-slot-duration-in-hours
      m2649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (. bean2648 setMinSlotDurationInHours (clojure.core/int v2650))))
   (clojure.core/let
    [v2650
     (:max-slot-duration-in-hours
      m2649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (. bean2648 setMaxSlotDurationInHours (clojure.core/int v2650))))
   (clojure.core/let
    [v2650
     (:next-token m2649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (. bean2648 setNextToken (clojure.core/str v2650))))
   (clojure.core/let
    [v2650
     (:max-results m2649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (. bean2648 setMaxResults (clojure.core/int v2650))))
   (clojure.core/let
    [v2650 (:filters m2649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (.
      bean2648
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2918] (ec2/filter arg2918))
 v2650))))
   bean2648))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeFlowLogsRequest}
describe-flow-logs-request
  [m2652]
  (clojure.core/let
   [bean2651
    (new com.amazonaws.services.ec2.model.DescribeFlowLogsRequest)]
   (clojure.core/let
    [v2653
     (:flow-log-ids m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (.
      bean2651
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2919] (clojure.core/str arg2919))
 v2653))))
   (clojure.core/let
    [v2653
     (:next-token m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setNextToken (clojure.core/str v2653))))
   (clojure.core/let
    [v2653
     (:max-results m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setMaxResults (clojure.core/int v2653))))
   (clojure.core/let
    [v2653 (:filter m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (.
      bean2651
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2920] (ec2/filter arg2920))
 v2653))))
   bean2651))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelBundleTaskRequest}
cancel-bundle-task-request
  [m2655]
  (clojure.core/let
   [bean2654
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/let
    [v2656
     (:bundle-id m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (. bean2654 setBundleId (clojure.core/str v2656))))
   bean2654))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest}
describe-reserved-instances-request
  [m2658]
  (clojure.core/let
   [bean2657
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/let
    [v2659
     (:reserved-instances-ids
      m2658
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2659 :com.palletops.awaze.client-builder/undef)
     (.
      bean2657
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2921] (clojure.core/str arg2921))
 v2659))))
   (clojure.core/let
    [v2659
     (:offering-type m2658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2659 :com.palletops.awaze.client-builder/undef)
     (. bean2657 setOfferingType (ec2/offering-type-values v2659))))
   (clojure.core/let
    [v2659 (:filters m2658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2659 :com.palletops.awaze.client-builder/undef)
     (.
      bean2657
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2922] (ec2/filter arg2922))
 v2659))))
   bean2657))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnmonitorInstancesRequest}
unmonitor-instances-request
  [m2661]
  (clojure.core/let
   [bean2660
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/let
    [v2662
     (:instance-ids m2661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2662 :com.palletops.awaze.client-builder/undef)
     (.
      bean2660
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2923] (clojure.core/str arg2923))
 v2662))))
   bean2660))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest}
delete-security-group-request
  [m2664]
  (clojure.core/let
   [bean2663
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/let
    [v2665
     (:group-id m2664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2665 :com.palletops.awaze.client-builder/undef)
     (. bean2663 setGroupId (clojure.core/str v2665))))
   (clojure.core/let
    [v2665
     (:group-name m2664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2665 :com.palletops.awaze.client-builder/undef)
     (. bean2663 setGroupName (clojure.core/str v2665))))
   bean2663))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest}
describe-vpc-attribute-request
  [m2667]
  (clojure.core/let
   [bean2666
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/let
    [v2668
     (:attribute m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setAttribute (ec2/vpc-attribute-name v2668))))
   (clojure.core/let
    [v2668 (:vpc-id m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setVpcId (clojure.core/str v2668))))
   bean2666))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclRequest}
create-network-acl-request
  [m2670]
  (clojure.core/let
   [bean2669
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/let
    [v2671 (:vpc-id m2670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (. bean2669 setVpcId (clojure.core/str v2671))))
   bean2669))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelImportTaskRequest}
cancel-import-task-request
  [m2673]
  (clojure.core/let
   [bean2672
    (new com.amazonaws.services.ec2.model.CancelImportTaskRequest)]
   (clojure.core/let
    [v2674
     (:import-task-id m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setImportTaskId (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:cancel-reason m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setCancelReason (clojure.core/str v2674))))
   bean2672))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest}
accept-vpc-peering-connection-request
  [m2676]
  (clojure.core/let
   [bean2675
    (new
     com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2677
     (:vpc-peering-connection-id
      m2676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (. bean2675 setVpcPeeringConnectionId (clojure.core/str v2677))))
   bean2675))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest}
describe-vpc-endpoint-services-request
  [m2679]
  (clojure.core/let
   [bean2678
    (new
     com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest)]
   (clojure.core/let
    [v2680
     (:next-token m2679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (. bean2678 setNextToken (clojure.core/str v2680))))
   (clojure.core/let
    [v2680
     (:max-results m2679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (. bean2678 setMaxResults (clojure.core/int v2680))))
   bean2678))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest}
delete-vpc-peering-connection-request
  [m2682]
  (clojure.core/let
   [bean2681
    (new
     com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2683
     (:vpc-peering-connection-id
      m2682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2683 :com.palletops.awaze.client-builder/undef)
     (. bean2681 setVpcPeeringConnectionId (clojure.core/str v2683))))
   bean2681))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunInstancesRequest}
run-instances-request
  [m2685]
  (clojure.core/let
   [bean2684
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/let
    [v2686
     (:iam-instance-profile
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2686))))
   (clojure.core/let
    [v2686
     (:max-count m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setMaxCount (clojure.core/int v2686))))
   (clojure.core/let
    [v2686
     (:subnet-id m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setSubnetId (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:additional-info
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setAdditionalInfo (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:security-group-ids
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2924] (clojure.core/str arg2924))
 v2686))))
   (clojure.core/let
    [v2686
     (:placement m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setPlacement (ec2/placement v2686))))
   (clojure.core/let
    [v2686
     (:private-ip-address
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setPrivateIpAddress (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:client-token m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setClientToken (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:instance-type m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setInstanceType (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:ebs-optimized m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setEbsOptimized (clojure.core/boolean v2686))))
   (clojure.core/let
    [v2686
     (:ramdisk-id m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setRamdiskId (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:instance-initiated-shutdown-behavior
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setInstanceInitiatedShutdownBehavior
      (ec2/shutdown-behavior v2686))))
   (clojure.core/let
    [v2686
     (:disable-api-termination
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setDisableApiTermination
      (clojure.core/boolean v2686))))
   (clojure.core/let
    [v2686
     (:image-id m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setImageId (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:key-name m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setKeyName (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:min-count m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setMinCount (clojure.core/int v2686))))
   (clojure.core/let
    [v2686
     (:kernel-id m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setKernelId (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:monitoring m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setMonitoring (clojure.core/boolean v2686))))
   (clojure.core/let
    [v2686
     (:security-groups
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2925] (clojure.core/str arg2925))
 v2686))))
   (clojure.core/let
    [v2686
     (:block-device-mappings
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2926] (ec2/block-device-mapping arg2926))
 v2686))))
   (clojure.core/let
    [v2686
     (:user-data m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setUserData (clojure.core/str v2686))))
   (clojure.core/let
    [v2686
     (:network-interfaces
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2927]
  (ec2/instance-network-interface-specification arg2927))
 v2686))))
   bean2684))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest}
describe-instance-status-request
  [m2688]
  (clojure.core/let
   [bean2687
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/let
    [v2689
     (:next-token m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setNextToken (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:max-results m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setMaxResults (clojure.core/int v2689))))
   (clojure.core/let
    [v2689 (:filters m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2928] (ec2/filter arg2928))
 v2689))))
   (clojure.core/let
    [v2689
     (:instance-ids m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2929] (clojure.core/str arg2929))
 v2689))))
   (clojure.core/let
    [v2689
     (:include-all-instances
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setIncludeAllInstances (clojure.core/boolean v2689))))
   bean2687))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest}
describe-vpc-classic-link-dns-support-request
  [m2691]
  (clojure.core/let
   [bean2690
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2692 (:vpc-ids m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (.
      bean2690
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2930] (clojure.core/str arg2930))
 v2692))))
   (clojure.core/let
    [v2692
     (:next-token m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (. bean2690 setNextToken (clojure.core/str v2692))))
   (clojure.core/let
    [v2692
     (:max-results m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (. bean2690 setMaxResults (clojure.core/int v2692))))
   bean2690))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest}
unassign-private-ip-addresses-request
  [m2694]
  (clojure.core/let
   [bean2693
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2695
     (:private-ip-addresses
      m2694
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (.
      bean2693
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2931] (clojure.core/str arg2931))
 v2695))))
   (clojure.core/let
    [v2695
     (:network-interface-id
      m2694
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (. bean2693 setNetworkInterfaceId (clojure.core/str v2695))))
   bean2693))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest}
describe-security-groups-request
  [m2697]
  (clojure.core/let
   [bean2696
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/let
    [v2698
     (:group-ids m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (.
      bean2696
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2932] (clojure.core/str arg2932))
 v2698))))
   (clojure.core/let
    [v2698 (:filters m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (.
      bean2696
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2933] (ec2/filter arg2933))
 v2698))))
   (clojure.core/let
    [v2698
     (:group-names m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (.
      bean2696
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2934] (clojure.core/str arg2934))
 v2698))))
   bean2696))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest}
describe-network-interfaces-request
  [m2700]
  (clojure.core/let
   [bean2699
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/let
    [v2701 (:filters m2700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2701 :com.palletops.awaze.client-builder/undef)
     (.
      bean2699
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2935] (ec2/filter arg2935))
 v2701))))
   (clojure.core/let
    [v2701
     (:network-interface-ids
      m2700
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2701 :com.palletops.awaze.client-builder/undef)
     (.
      bean2699
      setNetworkInterfaceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2936] (clojure.core/str arg2936))
 v2701))))
   bean2699))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest}
create-customer-gateway-request
  [m2703]
  (clojure.core/let
   [bean2702
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/let
    [v2704
     (:public-ip m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setPublicIp (clojure.core/str v2704))))
   (clojure.core/let
    [v2704 (:type m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setType (ec2/gateway-type v2704))))
   (clojure.core/let
    [v2704 (:bgp-asn m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setBgpAsn (clojure.core/int v2704))))
   bean2702))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest}
describe-dhcp-options-request
  [m2706]
  (clojure.core/let
   [bean2705
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/let
    [v2707
     (:dhcp-options-ids
      m2706
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2707 :com.palletops.awaze.client-builder/undef)
     (.
      bean2705
      setDhcpOptionsIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2937] (clojure.core/str arg2937))
 v2707))))
   (clojure.core/let
    [v2707 (:filters m2706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2707 :com.palletops.awaze.client-builder/undef)
     (.
      bean2705
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2938] (ec2/filter arg2938))
 v2707))))
   bean2705))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateTagsRequest}
create-tags-request
  [m2709]
  (clojure.core/let
   [bean2708 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/let
    [v2710
     (:resources m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (.
      bean2708
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2939] (clojure.core/str arg2939))
 v2710))))
   (clojure.core/let
    [v2710 (:tags m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (.
      bean2708
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2940] (ec2/tag arg2940)) v2710))))
   bean2708))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSnapshotRequest}
create-snapshot-request
  [m2712]
  (clojure.core/let
   [bean2711
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v2713
     (:volume-id m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setVolumeId (clojure.core/str v2713))))
   (clojure.core/let
    [v2713
     (:description m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setDescription (clojure.core/str v2713))))
   bean2711))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportImageRequest}
import-image-request
  [m2715]
  (clojure.core/let
   [bean2714
    (new com.amazonaws.services.ec2.model.ImportImageRequest)]
   (clojure.core/let
    [v2716
     (:description m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setDescription (clojure.core/str v2716))))
   (clojure.core/let
    [v2716
     (:disk-containers
      m2715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (.
      bean2714
      setDiskContainers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2941] (ec2/image-disk-container arg2941))
 v2716))))
   (clojure.core/let
    [v2716
     (:client-data m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setClientData (ec2/client-data v2716))))
   (clojure.core/let
    [v2716
     (:client-token m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setClientToken (clojure.core/str v2716))))
   (clojure.core/let
    [v2716
     (:role-name m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setRoleName (clojure.core/str v2716))))
   (clojure.core/let
    [v2716
     (:hypervisor m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setHypervisor (clojure.core/str v2716))))
   (clojure.core/let
    [v2716
     (:platform m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setPlatform (clojure.core/str v2716))))
   (clojure.core/let
    [v2716
     (:license-type m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setLicenseType (clojure.core/str v2716))))
   (clojure.core/let
    [v2716
     (:architecture m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setArchitecture (clojure.core/str v2716))))
   bean2714))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteTableRequest}
create-route-table-request
  [m2718]
  (clojure.core/let
   [bean2717
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/let
    [v2719 (:vpc-id m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setVpcId (clojure.core/str v2719))))
   bean2717))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeHostsRequest}
describe-hosts-request
  [m2721]
  (clojure.core/let
   [bean2720
    (new com.amazonaws.services.ec2.model.DescribeHostsRequest)]
   (clojure.core/let
    [v2722
     (:host-ids m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (.
      bean2720
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2942] (clojure.core/str arg2942))
 v2722))))
   (clojure.core/let
    [v2722
     (:next-token m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (. bean2720 setNextToken (clojure.core/str v2722))))
   (clojure.core/let
    [v2722
     (:max-results m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (. bean2720 setMaxResults (clojure.core/int v2722))))
   (clojure.core/let
    [v2722 (:filter m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (.
      bean2720
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2943] (ec2/filter arg2943))
 v2722))))
   bean2720))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest}
describe-volume-attribute-request
  [m2724]
  (clojure.core/let
   [bean2723
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/let
    [v2725
     (:attribute m2724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (. bean2723 setAttribute (ec2/volume-attribute-name v2725))))
   (clojure.core/let
    [v2725
     (:volume-id m2724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (. bean2723 setVolumeId (clojure.core/str v2725))))
   bean2723))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyIdFormatRequest}
modify-id-format-request
  [m2727]
  (clojure.core/let
   [bean2726
    (new com.amazonaws.services.ec2.model.ModifyIdFormatRequest)]
   (clojure.core/let
    [v2728
     (:use-long-ids m2727 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2728 :com.palletops.awaze.client-builder/undef)
     (. bean2726 setUseLongIds (clojure.core/boolean v2728))))
   (clojure.core/let
    [v2728
     (:resource m2727 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2728 :com.palletops.awaze.client-builder/undef)
     (. bean2726 setResource (clojure.core/str v2728))))
   bean2726))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest}
create-network-acl-entry-request
  [m2730]
  (clojure.core/let
   [bean2729
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/let
    [v2731
     (:network-acl-id m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setNetworkAclId (clojure.core/str v2731))))
   (clojure.core/let
    [v2731
     (:rule-number m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setRuleNumber (clojure.core/int v2731))))
   (clojure.core/let
    [v2731
     (:rule-action m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setRuleAction (clojure.core/str v2731))))
   (clojure.core/let
    [v2731 (:egress m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setEgress (clojure.core/boolean v2731))))
   (clojure.core/let
    [v2731
     (:cidr-block m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setCidrBlock (clojure.core/str v2731))))
   (clojure.core/let
    [v2731
     (:icmp-type-code m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setIcmpTypeCode (ec2/icmp-type-code v2731))))
   (clojure.core/let
    [v2731
     (:port-range m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setPortRange (ec2/port-range v2731))))
   (clojure.core/let
    [v2731
     (:protocol m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setProtocol (clojure.core/str v2731))))
   bean2729))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest}
describe-nat-gateways-request
  [m2733]
  (clojure.core/let
   [bean2732
    (new com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest)]
   (clojure.core/let
    [v2734
     (:next-token m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setNextToken (clojure.core/str v2734))))
   (clojure.core/let
    [v2734
     (:max-results m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setMaxResults (clojure.core/int v2734))))
   (clojure.core/let
    [v2734 (:filter m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (.
      bean2732
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2944] (ec2/filter arg2944))
 v2734))))
   (clojure.core/let
    [v2734
     (:nat-gateway-ids
      m2733
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (.
      bean2732
      setNatGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2945] (clojure.core/str arg2945))
 v2734))))
   bean2732))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest}
cancel-reserved-instances-listing-request
  [m2736]
  (clojure.core/let
   [bean2735
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/let
    [v2737
     (:reserved-instances-listing-id
      m2736
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (.
      bean2735
      setReservedInstancesListingId
      (clojure.core/str v2737))))
   bean2735))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest}
disable-vpc-classic-link-request
  [m2739]
  (clojure.core/let
   [bean2738
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2740 (:vpc-id m2739 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (. bean2738 setVpcId (clojure.core/str v2740))))
   bean2738))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunScheduledInstancesRequest}
run-scheduled-instances-request
  [m2742]
  (clojure.core/let
   [bean2741
    (new
     com.amazonaws.services.ec2.model.RunScheduledInstancesRequest)]
   (clojure.core/let
    [v2743
     (:client-token m2742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (. bean2741 setClientToken (clojure.core/str v2743))))
   (clojure.core/let
    [v2743
     (:launch-specification
      m2742
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (.
      bean2741
      setLaunchSpecification
      (ec2/scheduled-instances-launch-specification v2743))))
   (clojure.core/let
    [v2743
     (:instance-count m2742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (. bean2741 setInstanceCount (clojure.core/int v2743))))
   (clojure.core/let
    [v2743
     (:scheduled-instance-id
      m2742
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (. bean2741 setScheduledInstanceId (clojure.core/str v2743))))
   bean2741))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteKeyPairRequest}
delete-key-pair-request
  [m2745]
  (clojure.core/let
   [bean2744
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/let
    [v2746
     (:key-name m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setKeyName (clojure.core/str v2746))))
   bean2744))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest}
modify-reserved-instances-request
  [m2748]
  (clojure.core/let
   [bean2747
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/let
    [v2749
     (:reserved-instances-ids
      m2748
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2749 :com.palletops.awaze.client-builder/undef)
     (.
      bean2747
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2946] (clojure.core/str arg2946))
 v2749))))
   (clojure.core/let
    [v2749
     (:client-token m2748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2749 :com.palletops.awaze.client-builder/undef)
     (. bean2747 setClientToken (clojure.core/str v2749))))
   (clojure.core/let
    [v2749
     (:target-configurations
      m2748
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2749 :com.palletops.awaze.client-builder/undef)
     (.
      bean2747
      setTargetConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2947]
  (ec2/reserved-instances-configuration arg2947))
 v2749))))
   bean2747))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest}
delete-vpn-connection-route-request
  [m2751]
  (clojure.core/let
   [bean2750
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2752
     (:destination-cidr-block
      m2751
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setDestinationCidrBlock (clojure.core/str v2752))))
   (clojure.core/let
    [v2752
     (:vpn-connection-id
      m2751
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setVpnConnectionId (clojure.core/str v2752))))
   bean2750))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachInternetGatewayRequest}
attach-internet-gateway-request
  [m2754]
  (clojure.core/let
   [bean2753
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/let
    [v2755 (:vpc-id m2754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2755 :com.palletops.awaze.client-builder/undef)
     (. bean2753 setVpcId (clojure.core/str v2755))))
   (clojure.core/let
    [v2755
     (:internet-gateway-id
      m2754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2755 :com.palletops.awaze.client-builder/undef)
     (. bean2753 setInternetGatewayId (clojure.core/str v2755))))
   bean2753))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest}
modify-network-interface-attribute-request
  [m2757]
  (clojure.core/let
   [bean2756
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2758
     (:description m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setDescription (clojure.core/str v2758))))
   (clojure.core/let
    [v2758
     (:source-dest-check
      m2757
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setSourceDestCheck (clojure.core/boolean v2758))))
   (clojure.core/let
    [v2758 (:groups m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (.
      bean2756
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3020] (clojure.core/str arg3020))
 v2758))))
   (clojure.core/let
    [v2758
     (:attachment m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (.
      bean2756
      setAttachment
      (ec2/network-interface-attachment-changes v2758))))
   (clojure.core/let
    [v2758
     (:network-interface-id
      m2757
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setNetworkInterfaceId (clojure.core/str v2758))))
   bean2756))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest}
enable-vgw-route-propagation-request
  [m2760]
  (clojure.core/let
   [bean2759
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2761
     (:route-table-id m2760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (. bean2759 setRouteTableId (clojure.core/str v2761))))
   (clojure.core/let
    [v2761
     (:gateway-id m2760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (. bean2759 setGatewayId (clojure.core/str v2761))))
   bean2759))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest}
delete-network-acl-entry-request
  [m2763]
  (clojure.core/let
   [bean2762
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/let
    [v2764
     (:network-acl-id m2763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (. bean2762 setNetworkAclId (clojure.core/str v2764))))
   (clojure.core/let
    [v2764
     (:rule-number m2763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (. bean2762 setRuleNumber (clojure.core/int v2764))))
   (clojure.core/let
    [v2764 (:egress m2763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (. bean2762 setEgress (clojure.core/boolean v2764))))
   bean2762))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelExportTaskRequest}
cancel-export-task-request
  [m2766]
  (clojure.core/let
   [bean2765
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/let
    [v2767
     (:export-task-id m2766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2767 :com.palletops.awaze.client-builder/undef)
     (. bean2765 setExportTaskId (clojure.core/str v2767))))
   bean2765))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateImageRequest}
create-image-request
  [m2769]
  (clojure.core/let
   [bean2768
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/let
    [v2770
     (:description m2769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2770 :com.palletops.awaze.client-builder/undef)
     (. bean2768 setDescription (clojure.core/str v2770))))
   (clojure.core/let
    [v2770
     (:block-device-mappings
      m2769
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2770 :com.palletops.awaze.client-builder/undef)
     (.
      bean2768
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3021] (ec2/block-device-mapping arg3021))
 v2770))))
   (clojure.core/let
    [v2770
     (:instance-id m2769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2770 :com.palletops.awaze.client-builder/undef)
     (. bean2768 setInstanceId (clojure.core/str v2770))))
   (clojure.core/let
    [v2770
     (:no-reboot m2769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2770 :com.palletops.awaze.client-builder/undef)
     (. bean2768 setNoReboot (clojure.core/boolean v2770))))
   (clojure.core/let
    [v2770 (:name m2769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2770 :com.palletops.awaze.client-builder/undef)
     (. bean2768 setName (clojure.core/str v2770))))
   bean2768))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest}
modify-spot-fleet-request-request
  [m2772]
  (clojure.core/let
   [bean2771
    (new
     com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest)]
   (clojure.core/let
    [v2773
     (:spot-fleet-request-id
      m2772
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2773 :com.palletops.awaze.client-builder/undef)
     (. bean2771 setSpotFleetRequestId (clojure.core/str v2773))))
   (clojure.core/let
    [v2773
     (:target-capacity
      m2772
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2773 :com.palletops.awaze.client-builder/undef)
     (. bean2771 setTargetCapacity (clojure.core/int v2773))))
   (clojure.core/let
    [v2773
     (:excess-capacity-termination-policy
      m2772
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2773 :com.palletops.awaze.client-builder/undef)
     (.
      bean2771
      setExcessCapacityTerminationPolicy
      (ec2/excess-capacity-termination-policy v2773))))
   bean2771))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest}
describe-import-snapshot-tasks-request
  [m2775]
  (clojure.core/let
   [bean2774
    (new
     com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest)]
   (clojure.core/let
    [v2776
     (:next-token m2775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2776 :com.palletops.awaze.client-builder/undef)
     (. bean2774 setNextToken (clojure.core/str v2776))))
   (clojure.core/let
    [v2776
     (:max-results m2775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2776 :com.palletops.awaze.client-builder/undef)
     (. bean2774 setMaxResults (clojure.core/int v2776))))
   (clojure.core/let
    [v2776
     (:import-task-ids
      m2775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2776 :com.palletops.awaze.client-builder/undef)
     (.
      bean2774
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3022] (clojure.core/str arg3022))
 v2776))))
   (clojure.core/let
    [v2776 (:filters m2775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2776 :com.palletops.awaze.client-builder/undef)
     (.
      bean2774
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3023] (ec2/filter arg3023))
 v2776))))
   bean2774))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-endpoints
   [m2948]
   (clojure.core/let
    [credentials2949 (:credentials m2948) args2950 (:args m2948)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2951
      (com.palletops.awaze.common/aws-client :ec2 credentials2949)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2951
       deleteVpcEndpoints
       (ec2/delete-vpc-endpoints-request
        (clojure.core/nth args2950 0)))))))
  (clojure.core/defn
   delete-vpc-endpoints-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Generate map for deleteVpcEndpoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-endpoints
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Call deleteVpcEndpoints"}
   [credentials2953 & args2954]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2955
     (com.palletops.awaze.common/aws-client :ec2 credentials2953)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2955
      deleteVpcEndpoints
      (ec2/delete-vpc-endpoints-request (clojure.core/nth args2954 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-nat-gateway
   [m2956]
   (clojure.core/let
    [credentials2957 (:credentials m2956) args2958 (:args m2956)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2959
      (com.palletops.awaze.common/aws-client :ec2 credentials2957)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2959
       createNatGateway
       (ec2/create-nat-gateway-request (clojure.core/nth args2958 0)))))))
  (clojure.core/defn
   create-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createNatGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-nat-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createNatGateway"}
   [credentials2961 & args2962]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2963
     (com.palletops.awaze.common/aws-client :ec2 credentials2961)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2963
      createNatGateway
      (ec2/create-nat-gateway-request (clojure.core/nth args2962 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m2964]
   (clojure.core/let
    [credentials2965 (:credentials m2964) args2966 (:args m2964)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2967
      (com.palletops.awaze.common/aws-client :ec2 credentials2965)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2967
       stopInstances
       (ec2/stop-instances-request (clojure.core/nth args2966 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :stop-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call stopInstances"}
   [credentials2969 & args2970]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2971
     (com.palletops.awaze.common/aws-client :ec2 credentials2969)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2971
      stopInstances
      (ec2/stop-instances-request (clojure.core/nth args2970 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m2972]
   (clojure.core/let
    [credentials2973 (:credentials m2972) args2974 (:args m2972)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2975
      (com.palletops.awaze.common/aws-client :ec2 credentials2973)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2975
       createPlacementGroup
       (ec2/create-placement-group-request
        (clojure.core/nth args2974 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-placement-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPlacementGroup"}
   [credentials2977 & args2978]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2979
     (com.palletops.awaze.common/aws-client :ec2 credentials2977)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2979
      createPlacementGroup
      (ec2/create-placement-group-request
       (clojure.core/nth args2978 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m2980]
   (clojure.core/let
    [credentials2981 (:credentials m2980) args2982 (:args m2980)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2983
      (com.palletops.awaze.common/aws-client :ec2 credentials2981)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2983
       createReservedInstancesListing
       (ec2/create-reserved-instances-listing-request
        (clojure.core/nth args2982 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-reserved-instances-listing,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials2985 & args2986]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2987
     (com.palletops.awaze.common/aws-client :ec2 credentials2985)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2987
      createReservedInstancesListing
      (ec2/create-reserved-instances-listing-request
       (clojure.core/nth args2986 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-hosts
   [m2988]
   (clojure.core/let
    [credentials2989 (:credentials m2988) args2990 (:args m2988)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2991
      (com.palletops.awaze.common/aws-client :ec2 credentials2989)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2991
       releaseHosts
       (ec2/release-hosts-request (clojure.core/nth args2990 0)))))))
  (clojure.core/defn
   release-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for releaseHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :release-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call releaseHosts"}
   [credentials2993 & args2994]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2995
     (com.palletops.awaze.common/aws-client :ec2 credentials2993)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2995
      releaseHosts
      (ec2/release-hosts-request (clojure.core/nth args2994 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m2996]
   (clojure.core/let
    [credentials2997 (:credentials m2996) args2998 (:args m2996)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2999
      (com.palletops.awaze.common/aws-client :ec2 credentials2997)]
     (clojure.core/case
      (clojure.core/count args2998)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2999
        revokeSecurityGroupIngress
        (ec2/revoke-security-group-ingress-request
         (clojure.core/nth args2998 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2999
        revokeSecurityGroupIngress))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]
                [credentials]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials3001 & args3002]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3003
     (com.palletops.awaze.common/aws-client :ec2 credentials3001)]
    (clojure.core/case
     (clojure.core/count args3002)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3003
       revokeSecurityGroupIngress
       (ec2/revoke-security-group-ingress-request
        (clojure.core/nth args3002 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3003
       revokeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-classic-link-vpc
   [m3004]
   (clojure.core/let
    [credentials3005 (:credentials m3004) args3006 (:args m3004)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3007
      (com.palletops.awaze.common/aws-client :ec2 credentials3005)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3007
       attachClassicLinkVpc
       (ec2/attach-classic-link-vpc-request
        (clojure.core/nth args3006 0)))))))
  (clojure.core/defn
   attach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Generate map for attachClassicLinkVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-classic-link-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Call attachClassicLinkVpc"}
   [credentials3009 & args3010]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3011
     (com.palletops.awaze.common/aws-client :ec2 credentials3009)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3011
      attachClassicLinkVpc
      (ec2/attach-classic-link-vpc-request
       (clojure.core/nth args3010 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m3012]
   (clojure.core/let
    [credentials3013 (:credentials m3012) args3014 (:args m3012)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3015
      (com.palletops.awaze.common/aws-client :ec2 credentials3013)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3015
       replaceNetworkAclAssociation
       (ec2/replace-network-acl-association-request
        (clojure.core/nth args3014 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-network-acl-association,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials3017 & args3018]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3019
     (com.palletops.awaze.common/aws-client :ec2 credentials3017)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3019
      replaceNetworkAclAssociation
      (ec2/replace-network-acl-association-request
       (clojure.core/nth args3018 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-nat-gateway
   [m3024]
   (clojure.core/let
    [credentials3025 (:credentials m3024) args3026 (:args m3024)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3027
      (com.palletops.awaze.common/aws-client :ec2 credentials3025)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3027
       deleteNatGateway
       (ec2/delete-nat-gateway-request (clojure.core/nth args3026 0)))))))
  (clojure.core/defn
   delete-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNatGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-nat-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNatGateway"}
   [credentials3029 & args3030]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3031
     (com.palletops.awaze.common/aws-client :ec2 credentials3029)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3031
      deleteNatGateway
      (ec2/delete-nat-gateway-request (clojure.core/nth args3030 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m3032]
   (clojure.core/let
    [credentials3033 (:credentials m3032) args3034 (:args m3032)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3035
      (com.palletops.awaze.common/aws-client :ec2 credentials3033)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3035
       modifyInstanceAttribute
       (ec2/modify-instance-attribute-request
        (clojure.core/nth args3034 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials3037 & args3038]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3039
     (com.palletops.awaze.common/aws-client :ec2 credentials3037)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3039
      modifyInstanceAttribute
      (ec2/modify-instance-attribute-request
       (clojure.core/nth args3038 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m3040]
   (clojure.core/let
    [credentials3041 (:credentials m3040) args3042 (:args m3040)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3043
      (com.palletops.awaze.common/aws-client :ec2 credentials3041)]
     (clojure.core/case
      (clojure.core/count args3042)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3043
        describeNetworkAcls))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3043
        describeNetworkAcls
        (ec2/describe-network-acls-request
         (clojure.core/nth args3042 0))))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-network-acls,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-acls,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials3045 & args3046]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3047
     (com.palletops.awaze.common/aws-client :ec2 credentials3045)]
    (clojure.core/case
     (clojure.core/count args3046)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3047
       describeNetworkAcls))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3047
       describeNetworkAcls
       (ec2/describe-network-acls-request
        (clojure.core/nth args3046 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m3048]
   (clojure.core/let
    [credentials3049 (:credentials m3048) args3050 (:args m3048)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3051
      (com.palletops.awaze.common/aws-client :ec2 credentials3049)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3051
       reportInstanceStatus
       (ec2/report-instance-status-request
        (clojure.core/nth args3050 0)))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportInstanceStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportInstanceStatus"}
   [credentials3053 & args3054]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3055
     (com.palletops.awaze.common/aws-client :ec2 credentials3053)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3055
      reportInstanceStatus
      (ec2/report-instance-status-request
       (clojure.core/nth args3054 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m3056]
   (clojure.core/let
    [credentials3057 (:credentials m3056) args3058 (:args m3056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3059
      (com.palletops.awaze.common/aws-client :ec2 credentials3057)]
     (clojure.core/case
      (clojure.core/count args3058)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3059
        describeImages))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3059
        describeImages
        (ec2/describe-images-request (clojure.core/nth args3058 0))))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-images,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-images,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImages, describeImages"}
   [credentials3061 & args3062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3063
     (com.palletops.awaze.common/aws-client :ec2 credentials3061)]
    (clojure.core/case
     (clojure.core/count args3062)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3063
       describeImages))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3063
       describeImages
       (ec2/describe-images-request (clojure.core/nth args3062 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-image-tasks
   [m3064]
   (clojure.core/let
    [credentials3065 (:credentials m3064) args3066 (:args m3064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3067
      (com.palletops.awaze.common/aws-client :ec2 credentials3065)]
     (clojure.core/case
      (clojure.core/count args3066)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3067
        describeImportImageTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3067
        describeImportImageTasks
        (ec2/describe-import-image-tasks-request
         (clojure.core/nth args3066 0))))))))
  (clojure.core/defn
   describe-import-image-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeImportImageTasks, describeImportImageTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-import-image-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-import-image-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-image-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeImportImageTasks, describeImportImageTasks"}
   [credentials3069 & args3070]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3071
     (com.palletops.awaze.common/aws-client :ec2 credentials3069)]
    (clojure.core/case
     (clojure.core/count args3070)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3071
       describeImportImageTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3071
       describeImportImageTasks
       (ec2/describe-import-image-tasks-request
        (clojure.core/nth args3070 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-hosts
   [m3072]
   (clojure.core/let
    [credentials3073 (:credentials m3072) args3074 (:args m3072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3075
      (com.palletops.awaze.common/aws-client :ec2 credentials3073)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3075
       modifyHosts
       (ec2/modify-hosts-request (clojure.core/nth args3074 0)))))))
  (clojure.core/defn
   modify-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyHosts"}
   [credentials3077 & args3078]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3079
     (com.palletops.awaze.common/aws-client :ec2 credentials3077)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3079
      modifyHosts
      (ec2/modify-hosts-request (clojure.core/nth args3078 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m3080]
   (clojure.core/let
    [credentials3081 (:credentials m3080) args3082 (:args m3080)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3083
      (com.palletops.awaze.common/aws-client :ec2 credentials3081)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3083
       registerImage
       (ec2/register-image-request (clojure.core/nth args3082 0)))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for registerImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :register-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call registerImage"}
   [credentials3085 & args3086]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3087
     (com.palletops.awaze.common/aws-client :ec2 credentials3085)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3087
      registerImage
      (ec2/register-image-request (clojure.core/nth args3086 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m3088]
   (clojure.core/let
    [credentials3089 (:credentials m3088) args3090 (:args m3088)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3091
      (com.palletops.awaze.common/aws-client :ec2 credentials3089)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3091
       detachVpnGateway
       (ec2/detach-vpn-gateway-request (clojure.core/nth args3090 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVpnGateway"}
   [credentials3093 & args3094]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3095
     (com.palletops.awaze.common/aws-client :ec2 credentials3093)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3095
      detachVpnGateway
      (ec2/detach-vpn-gateway-request (clojure.core/nth args3094 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m3096]
   (clojure.core/let
    [credentials3097 (:credentials m3096) args3098 (:args m3096)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3099
      (com.palletops.awaze.common/aws-client :ec2 credentials3097)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3099
       deleteVolume
       (ec2/delete-volume-request (clojure.core/nth args3098 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials3101 & args3102]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3103
     (com.palletops.awaze.common/aws-client :ec2 credentials3101)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3103
      deleteVolume
      (ec2/delete-volume-request (clojure.core/nth args3102 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m3104]
   (clojure.core/let
    [credentials3105 (:credentials m3104) args3106 (:args m3104)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3107
      (com.palletops.awaze.common/aws-client :ec2 credentials3105)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3107
       deleteInternetGateway
       (ec2/delete-internet-gateway-request
        (clojure.core/nth args3106 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials3109 & args3110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3111
     (com.palletops.awaze.common/aws-client :ec2 credentials3109)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3111
      deleteInternetGateway
      (ec2/delete-internet-gateway-request
       (clojure.core/nth args3110 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m3112]
   (clojure.core/let
    [credentials3113 (:credentials m3112) args3114 (:args m3112)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3115
      (com.palletops.awaze.common/aws-client :ec2 credentials3113)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3115
       deleteSubnet
       (ec2/delete-subnet-request (clojure.core/nth args3114 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-subnet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSubnet"}
   [credentials3117 & args3118]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3119
     (com.palletops.awaze.common/aws-client :ec2 credentials3117)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3119
      deleteSubnet
      (ec2/delete-subnet-request (clojure.core/nth args3118 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m3120]
   (clojure.core/let
    [credentials3121 (:credentials m3120) args3122 (:args m3120)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3123
      (com.palletops.awaze.common/aws-client :ec2 credentials3121)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3123
       resetInstanceAttribute
       (ec2/reset-instance-attribute-request
        (clojure.core/nth args3122 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials3125 & args3126]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3127
     (com.palletops.awaze.common/aws-client :ec2 credentials3125)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3127
      resetInstanceAttribute
      (ec2/reset-instance-attribute-request
       (clojure.core/nth args3126 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m3128]
   (clojure.core/let
    [credentials3129 (:credentials m3128) args3130 (:args m3128)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3131
      (com.palletops.awaze.common/aws-client :ec2 credentials3129)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3131
       detachVolume
       (ec2/detach-volume-request (clojure.core/nth args3130 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVolume"}
   [credentials3133 & args3134]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3135
     (com.palletops.awaze.common/aws-client :ec2 credentials3133)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3135
      detachVolume
      (ec2/detach-volume-request (clojure.core/nth args3134 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m3136]
   (clojure.core/let
    [credentials3137 (:credentials m3136) args3138 (:args m3136)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3139
      (com.palletops.awaze.common/aws-client :ec2 credentials3137)]
     (clojure.core/case
      (clojure.core/count args3138)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3139
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3139
        describeExportTasks
        (ec2/describe-export-tasks-request
         (clojure.core/nth args3138 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-export-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-export-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials3141 & args3142]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3143
     (com.palletops.awaze.common/aws-client :ec2 credentials3141)]
    (clojure.core/case
     (clojure.core/count args3142)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3143
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3143
       describeExportTasks
       (ec2/describe-export-tasks-request
        (clojure.core/nth args3142 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instances
   [m3144]
   (clojure.core/let
    [credentials3145 (:credentials m3144) args3146 (:args m3144)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3147
      (com.palletops.awaze.common/aws-client :ec2 credentials3145)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3147
       describeScheduledInstances
       (ec2/describe-scheduled-instances-request
        (clojure.core/nth args3146 0)))))))
  (clojure.core/defn
   describe-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstances"}
   [credentials3149 & args3150]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3151
     (com.palletops.awaze.common/aws-client :ec2 credentials3149)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3151
      describeScheduledInstances
      (ec2/describe-scheduled-instances-request
       (clojure.core/nth args3150 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-flow-logs
   [m3152]
   (clojure.core/let
    [credentials3153 (:credentials m3152) args3154 (:args m3152)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3155
      (com.palletops.awaze.common/aws-client :ec2 credentials3153)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3155
       deleteFlowLogs
       (ec2/delete-flow-logs-request (clojure.core/nth args3154 0)))))))
  (clojure.core/defn
   delete-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteFlowLogs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteFlowLogs"}
   [credentials3157 & args3158]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3159
     (com.palletops.awaze.common/aws-client :ec2 credentials3157)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3159
      deleteFlowLogs
      (ec2/delete-flow-logs-request (clojure.core/nth args3158 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m3160]
   (clojure.core/let
    [credentials3161 (:credentials m3160) args3162 (:args m3160)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3163
      (com.palletops.awaze.common/aws-client :ec2 credentials3161)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3163
       createVpc
       (ec2/create-vpc-request (clojure.core/nth args3162 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Call createVpc"}
   [credentials3165 & args3166]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3167
     (com.palletops.awaze.common/aws-client :ec2 credentials3165)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3167
      createVpc
      (ec2/create-vpc-request (clojure.core/nth args3166 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m3168]
   (clojure.core/let
    [credentials3169 (:credentials m3168) args3170 (:args m3168)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3171
      (com.palletops.awaze.common/aws-client :ec2 credentials3169)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3171
       createSpotDatafeedSubscription
       (ec2/create-spot-datafeed-subscription-request
        (clojure.core/nth args3170 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials3173 & args3174]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3175
     (com.palletops.awaze.common/aws-client :ec2 credentials3173)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3175
      createSpotDatafeedSubscription
      (ec2/create-spot-datafeed-subscription-request
       (clojure.core/nth args3174 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link
   [m3176]
   (clojure.core/let
    [credentials3177 (:credentials m3176) args3178 (:args m3176)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3179
      (com.palletops.awaze.common/aws-client :ec2 credentials3177)]
     (clojure.core/case
      (clojure.core/count args3178)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3179
        describeVpcClassicLink
        (ec2/describe-vpc-classic-link-request
         (clojure.core/nth args3178 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3179
        describeVpcClassicLink))))))
  (clojure.core/defn
   describe-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcClassicLink, describeVpcClassicLink"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcClassicLink, describeVpcClassicLink"}
   [credentials3181 & args3182]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3183
     (com.palletops.awaze.common/aws-client :ec2 credentials3181)]
    (clojure.core/case
     (clojure.core/count args3182)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3183
       describeVpcClassicLink
       (ec2/describe-vpc-classic-link-request
        (clojure.core/nth args3182 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3183
       describeVpcClassicLink))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m3184]
   (clojure.core/let
    [credentials3185 (:credentials m3184) args3186 (:args m3184)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3187
      (com.palletops.awaze.common/aws-client :ec2 credentials3185)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3187
       deleteRoute
       (ec2/delete-route-request (clojure.core/nth args3186 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRoute"}
   [credentials3189 & args3190]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3191
     (com.palletops.awaze.common/aws-client :ec2 credentials3189)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3191
      deleteRoute
      (ec2/delete-route-request (clojure.core/nth args3190 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-id-format
   [m3192]
   (clojure.core/let
    [credentials3193 (:credentials m3192) args3194 (:args m3192)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3195
      (com.palletops.awaze.common/aws-client :ec2 credentials3193)]
     (clojure.core/case
      (clojure.core/count args3194)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3195
        describeIdFormat))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3195
        describeIdFormat
        (ec2/describe-id-format-request (clojure.core/nth args3194 0))))))))
  (clojure.core/defn
   describe-id-format-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeIdFormat, describeIdFormat"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-id-format
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeIdFormat, describeIdFormat"}
   [credentials3197 & args3198]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3199
     (com.palletops.awaze.common/aws-client :ec2 credentials3197)]
    (clojure.core/case
     (clojure.core/count args3198)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3199
       describeIdFormat))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3199
       describeIdFormat
       (ec2/describe-id-format-request (clojure.core/nth args3198 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m3200]
   (clojure.core/let
    [credentials3201 (:credentials m3200) args3202 (:args m3200)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3203
      (com.palletops.awaze.common/aws-client :ec2 credentials3201)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3203
       attachVolume
       (ec2/attach-volume-request (clojure.core/nth args3202 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVolume"}
   [credentials3205 & args3206]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3207
     (com.palletops.awaze.common/aws-client :ec2 credentials3205)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3207
      attachVolume
      (ec2/attach-volume-request (clojure.core/nth args3206 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m3208]
   (clojure.core/let
    [credentials3209 (:credentials m3208) args3210 (:args m3208)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3211
      (com.palletops.awaze.common/aws-client :ec2 credentials3209)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3211
       enableVolumeIO
       (ec2/enable-volume-iorequest (clojure.core/nth args3210 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-volume-io,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVolumeIO"}
   [credentials3213 & args3214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3215
     (com.palletops.awaze.common/aws-client :ec2 credentials3213)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3215
      enableVolumeIO
      (ec2/enable-volume-iorequest (clojure.core/nth args3214 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m3216]
   (clojure.core/let
    [credentials3217 (:credentials m3216) args3218 (:args m3216)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3219
      (com.palletops.awaze.common/aws-client :ec2 credentials3217)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3219
       attachVpnGateway
       (ec2/attach-vpn-gateway-request (clojure.core/nth args3218 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVpnGateway"}
   [credentials3221 & args3222]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3223
     (com.palletops.awaze.common/aws-client :ec2 credentials3221)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3223
      attachVpnGateway
      (ec2/attach-vpn-gateway-request (clojure.core/nth args3222 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m3224]
   (clojure.core/let
    [credentials3225 (:credentials m3224) args3226 (:args m3224)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3227
      (com.palletops.awaze.common/aws-client :ec2 credentials3225)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3227
       replaceNetworkAclEntry
       (ec2/replace-network-acl-entry-request
        (clojure.core/nth args3226 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials3229 & args3230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3231
     (com.palletops.awaze.common/aws-client :ec2 credentials3229)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3231
      replaceNetworkAclEntry
      (ec2/replace-network-acl-entry-request
       (clojure.core/nth args3230 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m3232]
   (clojure.core/let
    [credentials3233 (:credentials m3232) args3234 (:args m3232)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3235
      (com.palletops.awaze.common/aws-client :ec2 credentials3233)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3235
       describeSnapshotAttribute
       (ec2/describe-snapshot-attribute-request
        (clojure.core/nth args3234 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials3237 & args3238]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3239
     (com.palletops.awaze.common/aws-client :ec2 credentials3237)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3239
      describeSnapshotAttribute
      (ec2/describe-snapshot-attribute-request
       (clojure.core/nth args3238 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m3240]
   (clojure.core/let
    [credentials3241 (:credentials m3240) args3242 (:args m3240)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3243
      (com.palletops.awaze.common/aws-client :ec2 credentials3241)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3243
       rebootInstances
       (ec2/reboot-instances-request (clojure.core/nth args3242 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootInstances"}
   [credentials3245 & args3246]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3247
     (com.palletops.awaze.common/aws-client :ec2 credentials3245)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3247
      rebootInstances
      (ec2/reboot-instances-request (clojure.core/nth args3246 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reject-vpc-peering-connection
   [m3248]
   (clojure.core/let
    [credentials3249 (:credentials m3248) args3250 (:args m3248)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3251
      (com.palletops.awaze.common/aws-client :ec2 credentials3249)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3251
       rejectVpcPeeringConnection
       (ec2/reject-vpc-peering-connection-request
        (clojure.core/nth args3250 0)))))))
  (clojure.core/defn
   reject-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rejectVpcPeeringConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reject-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rejectVpcPeeringConnection"}
   [credentials3253 & args3254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3255
     (com.palletops.awaze.common/aws-client :ec2 credentials3253)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3255
      rejectVpcPeeringConnection
      (ec2/reject-vpc-peering-connection-request
       (clojure.core/nth args3254 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m3256]
   (clojure.core/let
    [credentials3257 (:credentials m3256) args3258 (:args m3256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3259
      (com.palletops.awaze.common/aws-client :ec2 credentials3257)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3259
       createSecurityGroup
       (ec2/create-security-group-request
        (clojure.core/nth args3258 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-security-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSecurityGroup"}
   [credentials3261 & args3262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3263
     (com.palletops.awaze.common/aws-client :ec2 credentials3261)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3263
      createSecurityGroup
      (ec2/create-security-group-request
       (clojure.core/nth args3262 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m3264]
   (clojure.core/let
    [credentials3265 (:credentials m3264) args3266 (:args m3264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3267
      (com.palletops.awaze.common/aws-client :ec2 credentials3265)]
     (clojure.core/case
      (clojure.core/count args3266)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3267
        describeSpotInstanceRequests
        (ec2/describe-spot-instance-requests-request
         (clojure.core/nth args3266 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3267
        describeSpotInstanceRequests))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials3269 & args3270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3271
     (com.palletops.awaze.common/aws-client :ec2 credentials3269)]
    (clojure.core/case
     (clojure.core/count args3270)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3271
       describeSpotInstanceRequests
       (ec2/describe-spot-instance-requests-request
        (clojure.core/nth args3270 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3271
       describeSpotInstanceRequests))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m3272]
   (clojure.core/let
    [credentials3273 (:credentials m3272) args3274 (:args m3272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3275
      (com.palletops.awaze.common/aws-client :ec2 credentials3273)]
     (clojure.core/case
      (clojure.core/count args3274)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3275
        describeSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3275
        describeSpotDatafeedSubscription
        (ec2/describe-spot-datafeed-subscription-request
         (clojure.core/nth args3274 0))))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials3277 & args3278]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3279
     (com.palletops.awaze.common/aws-client :ec2 credentials3277)]
    (clojure.core/case
     (clojure.core/count args3278)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3279
       describeSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3279
       describeSpotDatafeedSubscription
       (ec2/describe-spot-datafeed-subscription-request
        (clojure.core/nth args3278 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :move-address-to-vpc
   [m3280]
   (clojure.core/let
    [credentials3281 (:credentials m3280) args3282 (:args m3280)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3283
      (com.palletops.awaze.common/aws-client :ec2 credentials3281)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3283
       moveAddressToVpc
       (ec2/move-address-to-vpc-request (clojure.core/nth args3282 0)))))))
  (clojure.core/defn
   move-address-to-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for moveAddressToVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :move-address-to-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   move-address-to-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call moveAddressToVpc"}
   [credentials3285 & args3286]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3287
     (com.palletops.awaze.common/aws-client :ec2 credentials3285)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3287
      moveAddressToVpc
      (ec2/move-address-to-vpc-request (clojure.core/nth args3286 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-endpoint
   [m3288]
   (clojure.core/let
    [credentials3289 (:credentials m3288) args3290 (:args m3288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3291
      (com.palletops.awaze.common/aws-client :ec2 credentials3289)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3291
       modifyVpcEndpoint
       (ec2/modify-vpc-endpoint-request (clojure.core/nth args3290 0)))))))
  (clojure.core/defn
   modify-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Generate map for modifyVpcEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-vpc-endpoint,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Call modifyVpcEndpoint"}
   [credentials3293 & args3294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3295
     (com.palletops.awaze.common/aws-client :ec2 credentials3293)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3295
      modifyVpcEndpoint
      (ec2/modify-vpc-endpoint-request (clojure.core/nth args3294 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m3296]
   (clojure.core/let
    [credentials3297 (:credentials m3296) args3298 (:args m3296)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3299
      (com.palletops.awaze.common/aws-client :ec2 credentials3297)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3299
       attachNetworkInterface
       (ec2/attach-network-interface-request
        (clojure.core/nth args3298 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials3301 & args3302]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3303
     (com.palletops.awaze.common/aws-client :ec2 credentials3301)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3303
      attachNetworkInterface
      (ec2/attach-network-interface-request
       (clojure.core/nth args3302 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m3304]
   (clojure.core/let
    [credentials3305 (:credentials m3304) args3306 (:args m3304)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3307
      (com.palletops.awaze.common/aws-client :ec2 credentials3305)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3307
       detachNetworkInterface
       (ec2/detach-network-interface-request
        (clojure.core/nth args3306 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials3309 & args3310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3311
     (com.palletops.awaze.common/aws-client :ec2 credentials3309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3311
      detachNetworkInterface
      (ec2/detach-network-interface-request
       (clojure.core/nth args3310 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m3312]
   (clojure.core/let
    [credentials3313 (:credentials m3312) args3314 (:args m3312)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3315
      (com.palletops.awaze.common/aws-client :ec2 credentials3313)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3315
       deleteDhcpOptions
       (ec2/delete-dhcp-options-request (clojure.core/nth args3314 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials3317 & args3318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3319
     (com.palletops.awaze.common/aws-client :ec2 credentials3317)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3319
      deleteDhcpOptions
      (ec2/delete-dhcp-options-request (clojure.core/nth args3318 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoints
   [m3320]
   (clojure.core/let
    [credentials3321 (:credentials m3320) args3322 (:args m3320)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3323
      (com.palletops.awaze.common/aws-client :ec2 credentials3321)]
     (clojure.core/case
      (clojure.core/count args3322)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3323
        describeVpcEndpoints
        (ec2/describe-vpc-endpoints-request
         (clojure.core/nth args3322 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3323
        describeVpcEndpoints))))))
  (clojure.core/defn
   describe-vpc-endpoints-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVpcEndpoints, describeVpcEndpoints"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoints
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVpcEndpoints, describeVpcEndpoints"}
   [credentials3325 & args3326]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3327
     (com.palletops.awaze.common/aws-client :ec2 credentials3325)]
    (clojure.core/case
     (clojure.core/count args3326)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3327
       describeVpcEndpoints
       (ec2/describe-vpc-endpoints-request
        (clojure.core/nth args3326 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3327
       describeVpcEndpoints))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m3328]
   (clojure.core/let
    [credentials3329 (:credentials m3328) args3330 (:args m3328)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3331
      (com.palletops.awaze.common/aws-client :ec2 credentials3329)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3331
       confirmProductInstance
       (ec2/confirm-product-instance-request
        (clojure.core/nth args3330 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-product-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmProductInstance"}
   [credentials3333 & args3334]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3335
     (com.palletops.awaze.common/aws-client :ec2 credentials3333)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3335
      confirmProductInstance
      (ec2/confirm-product-instance-request
       (clojure.core/nth args3334 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m3336]
   (clojure.core/let
    [credentials3337 (:credentials m3336) args3338 (:args m3336)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3339
      (com.palletops.awaze.common/aws-client :ec2 credentials3337)]
     (clojure.core/case
      (clojure.core/count args3338)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3339
        allocateAddress
        (ec2/allocate-address-request (clojure.core/nth args3338 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3339
        allocateAddress))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :allocate-address,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials3341 & args3342]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3343
     (com.palletops.awaze.common/aws-client :ec2 credentials3341)]
    (clojure.core/case
     (clojure.core/count args3342)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3343
       allocateAddress
       (ec2/allocate-address-request (clojure.core/nth args3342 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3343
       allocateAddress))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-endpoint
   [m3344]
   (clojure.core/let
    [credentials3345 (:credentials m3344) args3346 (:args m3344)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3347
      (com.palletops.awaze.common/aws-client :ec2 credentials3345)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3347
       createVpcEndpoint
       (ec2/create-vpc-endpoint-request (clojure.core/nth args3346 0)))))))
  (clojure.core/defn
   create-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createVpcEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc-endpoint,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createVpcEndpoint"}
   [credentials3349 & args3350]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3351
     (com.palletops.awaze.common/aws-client :ec2 credentials3349)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3351
      createVpcEndpoint
      (ec2/create-vpc-endpoint-request (clojure.core/nth args3350 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m3352]
   (clojure.core/let
    [credentials3353 (:credentials m3352) args3354 (:args m3352)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3355
      (com.palletops.awaze.common/aws-client :ec2 credentials3353)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3355
       importKeyPair
       (ec2/import-key-pair-request (clojure.core/nth args3354 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call importKeyPair"}
   [credentials3357 & args3358]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3359
     (com.palletops.awaze.common/aws-client :ec2 credentials3357)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3359
      importKeyPair
      (ec2/import-key-pair-request (clojure.core/nth args3358 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m3360]
   (clojure.core/let
    [credentials3361 (:credentials m3360) args3362 (:args m3360)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3363
      (com.palletops.awaze.common/aws-client :ec2 credentials3361)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3363
       copySnapshot
       (ec2/copy-snapshot-request (clojure.core/nth args3362 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Call copySnapshot"}
   [credentials3365 & args3366]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3367
     (com.palletops.awaze.common/aws-client :ec2 credentials3365)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3367
      copySnapshot
      (ec2/copy-snapshot-request (clojure.core/nth args3366 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m3368]
   (clojure.core/let
    [credentials3369 (:credentials m3368) args3370 (:args m3368)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3371
      (com.palletops.awaze.common/aws-client :ec2 credentials3369)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3371
       deleteSnapshot
       (ec2/delete-snapshot-request (clojure.core/nth args3370 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials3373 & args3374]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3375
     (com.palletops.awaze.common/aws-client :ec2 credentials3373)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3375
      deleteSnapshot
      (ec2/delete-snapshot-request (clojure.core/nth args3374 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m3376]
   (clojure.core/let
    [credentials3377 (:credentials m3376) args3378 (:args m3376)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3379
      (com.palletops.awaze.common/aws-client :ec2 credentials3377)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3379
       resetImageAttribute
       (ec2/reset-image-attribute-request
        (clojure.core/nth args3378 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetImageAttribute"}
   [credentials3381 & args3382]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3383
     (com.palletops.awaze.common/aws-client :ec2 credentials3381)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3383
      resetImageAttribute
      (ec2/reset-image-attribute-request
       (clojure.core/nth args3382 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m3384]
   (clojure.core/let
    [credentials3385 (:credentials m3384) args3386 (:args m3384)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3387
      (com.palletops.awaze.common/aws-client :ec2 credentials3385)]
     (clojure.core/case
      (clojure.core/count args3386)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3387
        createInternetGateway
        (ec2/create-internet-gateway-request
         (clojure.core/nth args3386 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3387
        createInternetGateway))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials3389 & args3390]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3391
     (com.palletops.awaze.common/aws-client :ec2 credentials3389)]
    (clojure.core/case
     (clojure.core/count args3390)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3391
       createInternetGateway
       (ec2/create-internet-gateway-request
        (clojure.core/nth args3390 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3391
       createInternetGateway))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m3392]
   (clojure.core/let
    [credentials3393 (:credentials m3392) args3394 (:args m3392)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3395
      (com.palletops.awaze.common/aws-client :ec2 credentials3393)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3395
       monitorInstances
       (ec2/monitor-instances-request (clojure.core/nth args3394 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :monitor-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call monitorInstances"}
   [credentials3397 & args3398]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3399
     (com.palletops.awaze.common/aws-client :ec2 credentials3397)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3399
      monitorInstances
      (ec2/monitor-instances-request (clojure.core/nth args3398 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m3400]
   (clojure.core/let
    [credentials3401 (:credentials m3400) args3402 (:args m3400)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3403
      (com.palletops.awaze.common/aws-client :ec2 credentials3401)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3403
       revokeSecurityGroupEgress
       (ec2/revoke-security-group-egress-request
        (clojure.core/nth args3402 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-security-group-egress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials3405 & args3406]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3407
     (com.palletops.awaze.common/aws-client :ec2 credentials3405)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3407
      revokeSecurityGroupEgress
      (ec2/revoke-security-group-egress-request
       (clojure.core/nth args3406 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m3408]
   (clojure.core/let
    [credentials3409 (:credentials m3408) args3410 (:args m3408)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3411
      (com.palletops.awaze.common/aws-client :ec2 credentials3409)]
     (clojure.core/case
      (clojure.core/count args3410)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3411
        describeVpcs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3411
        describeVpcs
        (ec2/describe-vpcs-request (clojure.core/nth args3410 0))))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpcs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpcs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials3413 & args3414]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3415
     (com.palletops.awaze.common/aws-client :ec2 credentials3413)]
    (clojure.core/case
     (clojure.core/count args3414)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3415
       describeVpcs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3415
       describeVpcs
       (ec2/describe-vpcs-request (clojure.core/nth args3414 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m3416]
   (clojure.core/let
    [credentials3417 (:credentials m3416) args3418 (:args m3416)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3419
      (com.palletops.awaze.common/aws-client :ec2 credentials3417)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3419
       importInstance
       (ec2/import-instance-request (clojure.core/nth args3418 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Call importInstance"}
   [credentials3421 & args3422]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3423
     (com.palletops.awaze.common/aws-client :ec2 credentials3421)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3423
      importInstance
      (ec2/import-instance-request (clojure.core/nth args3422 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m3424]
   (clojure.core/let
    [credentials3425 (:credentials m3424) args3426 (:args m3424)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3427
      (com.palletops.awaze.common/aws-client :ec2 credentials3425)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3427
       copyImage
       (ec2/copy-image-request (clojure.core/nth args3426 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Call copyImage"}
   [credentials3429 & args3430]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3431
     (com.palletops.awaze.common/aws-client :ec2 credentials3429)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3431
      copyImage
      (ec2/copy-image-request (clojure.core/nth args3430 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m3432]
   (clojure.core/let
    [credentials3433 (:credentials m3432) args3434 (:args m3432)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3435
      (com.palletops.awaze.common/aws-client :ec2 credentials3433)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3435
       getConsoleOutput
       (ec2/get-console-output-request (clojure.core/nth args3434 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-console-output,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getConsoleOutput"}
   [credentials3437 & args3438]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3439
     (com.palletops.awaze.common/aws-client :ec2 credentials3437)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3439
      getConsoleOutput
      (ec2/get-console-output-request (clojure.core/nth args3438 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m3440]
   (clojure.core/let
    [credentials3441 (:credentials m3440) args3442 (:args m3440)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3443
      (com.palletops.awaze.common/aws-client :ec2 credentials3441)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3443
       modifySnapshotAttribute
       (ec2/modify-snapshot-attribute-request
        (clojure.core/nth args3442 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials3445 & args3446]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3447
     (com.palletops.awaze.common/aws-client :ec2 credentials3445)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3447
      modifySnapshotAttribute
      (ec2/modify-snapshot-attribute-request
       (clojure.core/nth args3446 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-fleet
   [m3448]
   (clojure.core/let
    [credentials3449 (:credentials m3448) args3450 (:args m3448)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3451
      (com.palletops.awaze.common/aws-client :ec2 credentials3449)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3451
       requestSpotFleet
       (ec2/request-spot-fleet-request (clojure.core/nth args3450 0)))))))
  (clojure.core/defn
   request-spot-fleet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for requestSpotFleet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-spot-fleet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-fleet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call requestSpotFleet"}
   [credentials3453 & args3454]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3455
     (com.palletops.awaze.common/aws-client :ec2 credentials3453)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3455
      requestSpotFleet
      (ec2/request-spot-fleet-request (clojure.core/nth args3454 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :restore-address-to-classic
   [m3456]
   (clojure.core/let
    [credentials3457 (:credentials m3456) args3458 (:args m3456)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3459
      (com.palletops.awaze.common/aws-client :ec2 credentials3457)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3459
       restoreAddressToClassic
       (ec2/restore-address-to-classic-request
        (clojure.core/nth args3458 0)))))))
  (clojure.core/defn
   restore-address-to-classic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for restoreAddressToClassic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-address-to-classic,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   restore-address-to-classic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call restoreAddressToClassic"}
   [credentials3461 & args3462]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3463
     (com.palletops.awaze.common/aws-client :ec2 credentials3461)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3463
      restoreAddressToClassic
      (ec2/restore-address-to-classic-request
       (clojure.core/nth args3462 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-subnet-attribute
   [m3464]
   (clojure.core/let
    [credentials3465 (:credentials m3464) args3466 (:args m3464)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3467
      (com.palletops.awaze.common/aws-client :ec2 credentials3465)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3467
       modifySubnetAttribute
       (ec2/modify-subnet-attribute-request
        (clojure.core/nth args3466 0)))))))
  (clojure.core/defn
   modify-subnet-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySubnetAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-subnet-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-subnet-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySubnetAttribute"}
   [credentials3469 & args3470]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3471
     (com.palletops.awaze.common/aws-client :ec2 credentials3469)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3471
      modifySubnetAttribute
      (ec2/modify-subnet-attribute-request
       (clojure.core/nth args3470 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m3472]
   (clojure.core/let
    [credentials3473 (:credentials m3472) args3474 (:args m3472)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3475
      (com.palletops.awaze.common/aws-client :ec2 credentials3473)]
     (clojure.core/case
      (clojure.core/count args3474)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3475
        describeConversionTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3475
        describeConversionTasks
        (ec2/describe-conversion-tasks-request
         (clojure.core/nth args3474 0))))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-conversion-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-conversion-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials3477 & args3478]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3479
     (com.palletops.awaze.common/aws-client :ec2 credentials3477)]
    (clojure.core/case
     (clojure.core/count args3478)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3479
       describeConversionTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3479
       describeConversionTasks
       (ec2/describe-conversion-tasks-request
        (clojure.core/nth args3478 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m3480]
   (clojure.core/let
    [credentials3481 (:credentials m3480) args3482 (:args m3480)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3483
      (com.palletops.awaze.common/aws-client :ec2 credentials3481)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3483
       authorizeSecurityGroupEgress
       (ec2/authorize-security-group-egress-request
        (clojure.core/nth args3482 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-security-group-egress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials3485 & args3486]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3487
     (com.palletops.awaze.common/aws-client :ec2 credentials3485)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3487
      authorizeSecurityGroupEgress
      (ec2/authorize-security-group-egress-request
       (clojure.core/nth args3486 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m3488]
   (clojure.core/let
    [credentials3489 (:credentials m3488) args3490 (:args m3488)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3491
      (com.palletops.awaze.common/aws-client :ec2 credentials3489)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3491
       authorizeSecurityGroupIngress
       (ec2/authorize-security-group-ingress-request
        (clojure.core/nth args3490 0)))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupIngress"}
   [credentials3493 & args3494]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3495
     (com.palletops.awaze.common/aws-client :ec2 credentials3493)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3495
      authorizeSecurityGroupIngress
      (ec2/authorize-security-group-ingress-request
       (clojure.core/nth args3494 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m3496]
   (clojure.core/let
    [credentials3497 (:credentials m3496) args3498 (:args m3496)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3499
      (com.palletops.awaze.common/aws-client :ec2 credentials3497)]
     (clojure.core/case
      (clojure.core/count args3498)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3499
        describeAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3499
        describeAddresses
        (ec2/describe-addresses-request (clojure.core/nth args3498 0))))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials3501 & args3502]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3503
     (com.palletops.awaze.common/aws-client :ec2 credentials3501)]
    (clojure.core/case
     (clojure.core/count args3502)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3503
       describeAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3503
       describeAddresses
       (ec2/describe-addresses-request (clojure.core/nth args3502 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m3504]
   (clojure.core/let
    [credentials3505 (:credentials m3504) args3506 (:args m3504)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3507
      (com.palletops.awaze.common/aws-client :ec2 credentials3505)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3507
       createVpnConnectionRoute
       (ec2/create-vpn-connection-route-request
        (clojure.core/nth args3506 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-connection-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials3509 & args3510]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3511
     (com.palletops.awaze.common/aws-client :ec2 credentials3509)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3511
      createVpnConnectionRoute
      (ec2/create-vpn-connection-route-request
       (clojure.core/nth args3510 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m3512]
   (clojure.core/let
    [credentials3513 (:credentials m3512) args3514 (:args m3512)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3515
      (com.palletops.awaze.common/aws-client :ec2 credentials3513)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3515
       associateAddress
       (ec2/associate-address-request (clojure.core/nth args3514 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call associateAddress"}
   [credentials3517 & args3518]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3519
     (com.palletops.awaze.common/aws-client :ec2 credentials3517)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3519
      associateAddress
      (ec2/associate-address-request (clojure.core/nth args3518 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m3520]
   (clojure.core/let
    [credentials3521 (:credentials m3520) args3522 (:args m3520)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3523
      (com.palletops.awaze.common/aws-client :ec2 credentials3521)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3523
       createInstanceExportTask
       (ec2/create-instance-export-task-request
        (clojure.core/nth args3522 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-instance-export-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials3525 & args3526]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3527
     (com.palletops.awaze.common/aws-client :ec2 credentials3525)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3527
      createInstanceExportTask
      (ec2/create-instance-export-task-request
       (clojure.core/nth args3526 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m3528]
   (clojure.core/let
    [credentials3529 (:credentials m3528) args3530 (:args m3528)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3531
      (com.palletops.awaze.common/aws-client :ec2 credentials3529)]
     (clojure.core/case
      (clojure.core/count args3530)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3531
        describeKeyPairs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3531
        describeKeyPairs
        (ec2/describe-key-pairs-request (clojure.core/nth args3530 0))))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-key-pairs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-key-pairs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials3533 & args3534]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3535
     (com.palletops.awaze.common/aws-client :ec2 credentials3533)]
    (clojure.core/case
     (clojure.core/count args3534)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3535
       describeKeyPairs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3535
       describeKeyPairs
       (ec2/describe-key-pairs-request (clojure.core/nth args3534 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-requests
   [m3536]
   (clojure.core/let
    [credentials3537 (:credentials m3536) args3538 (:args m3536)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3539
      (com.palletops.awaze.common/aws-client :ec2 credentials3537)]
     (clojure.core/case
      (clojure.core/count args3538)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3539
        describeSpotFleetRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3539
        describeSpotFleetRequests
        (ec2/describe-spot-fleet-requests-request
         (clojure.core/nth args3538 0))))))))
  (clojure.core/defn
   describe-spot-fleet-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetRequests, describeSpotFleetRequests"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetRequests, describeSpotFleetRequests"}
   [credentials3541 & args3542]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3543
     (com.palletops.awaze.common/aws-client :ec2 credentials3541)]
    (clojure.core/case
     (clojure.core/count args3542)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3543
       describeSpotFleetRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3543
       describeSpotFleetRequests
       (ec2/describe-spot-fleet-requests-request
        (clojure.core/nth args3542 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m3544]
   (clojure.core/let
    [credentials3545 (:credentials m3544) args3546 (:args m3544)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3547
      (com.palletops.awaze.common/aws-client :ec2 credentials3545)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3547
       describeImageAttribute
       (ec2/describe-image-attribute-request
        (clojure.core/nth args3546 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImageAttribute"}
   [credentials3549 & args3550]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3551
     (com.palletops.awaze.common/aws-client :ec2 credentials3549)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3551
      describeImageAttribute
      (ec2/describe-image-attribute-request
       (clojure.core/nth args3550 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-moving-addresses
   [m3552]
   (clojure.core/let
    [credentials3553 (:credentials m3552) args3554 (:args m3552)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3555
      (com.palletops.awaze.common/aws-client :ec2 credentials3553)]
     (clojure.core/case
      (clojure.core/count args3554)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3555
        describeMovingAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3555
        describeMovingAddresses
        (ec2/describe-moving-addresses-request
         (clojure.core/nth args3554 0))))))))
  (clojure.core/defn
   describe-moving-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeMovingAddresses, describeMovingAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-moving-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-moving-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-moving-addresses
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeMovingAddresses, describeMovingAddresses"}
   [credentials3557 & args3558]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3559
     (com.palletops.awaze.common/aws-client :ec2 credentials3557)]
    (clojure.core/case
     (clojure.core/count args3558)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3559
       describeMovingAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3559
       describeMovingAddresses
       (ec2/describe-moving-addresses-request
        (clojure.core/nth args3558 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m3560]
   (clojure.core/let
    [credentials3561 (:credentials m3560) args3562 (:args m3560)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3563
      (com.palletops.awaze.common/aws-client :ec2 credentials3561)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3563
       deleteNetworkAcl
       (ec2/delete-network-acl-request (clojure.core/nth args3562 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-acl,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials3565 & args3566]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3567
     (com.palletops.awaze.common/aws-client :ec2 credentials3565)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3567
      deleteNetworkAcl
      (ec2/delete-network-acl-request (clojure.core/nth args3566 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m3568]
   (clojure.core/let
    [credentials3569 (:credentials m3568) args3570 (:args m3568)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3571
      (com.palletops.awaze.common/aws-client :ec2 credentials3569)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3571
       deleteNetworkInterface
       (ec2/delete-network-interface-request
        (clojure.core/nth args3570 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials3573 & args3574]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3575
     (com.palletops.awaze.common/aws-client :ec2 credentials3573)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3575
      deleteNetworkInterface
      (ec2/delete-network-interface-request
       (clojure.core/nth args3574 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m3576]
   (clojure.core/let
    [credentials3577 (:credentials m3576) args3578 (:args m3576)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3579
      (com.palletops.awaze.common/aws-client :ec2 credentials3577)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3579
       deleteVpnConnection
       (ec2/delete-vpn-connection-request
        (clojure.core/nth args3578 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials3581 & args3582]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3583
     (com.palletops.awaze.common/aws-client :ec2 credentials3581)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3583
      deleteVpnConnection
      (ec2/delete-vpn-connection-request
       (clojure.core/nth args3582 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-scheduled-instances
   [m3584]
   (clojure.core/let
    [credentials3585 (:credentials m3584) args3586 (:args m3584)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3587
      (com.palletops.awaze.common/aws-client :ec2 credentials3585)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3587
       purchaseScheduledInstances
       (ec2/purchase-scheduled-instances-request
        (clojure.core/nth args3586 0)))))))
  (clojure.core/defn
   purchase-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for purchaseScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call purchaseScheduledInstances"}
   [credentials3589 & args3590]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3591
     (com.palletops.awaze.common/aws-client :ec2 credentials3589)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3591
      purchaseScheduledInstances
      (ec2/purchase-scheduled-instances-request
       (clojure.core/nth args3590 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m3592]
   (clojure.core/let
    [credentials3593 (:credentials m3592) args3594 (:args m3592)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3595
      (com.palletops.awaze.common/aws-client :ec2 credentials3593)]
     (clojure.core/case
      (clojure.core/count args3594)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3595
        describeReservedInstancesModifications
        (ec2/describe-reserved-instances-modifications-request
         (clojure.core/nth args3594 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3595
        describeReservedInstancesModifications))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials3597 & args3598]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3599
     (com.palletops.awaze.common/aws-client :ec2 credentials3597)]
    (clojure.core/case
     (clojure.core/count args3598)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3599
       describeReservedInstancesModifications
       (ec2/describe-reserved-instances-modifications-request
        (clojure.core/nth args3598 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3599
       describeReservedInstancesModifications))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-classic-link-instances
   [m3600]
   (clojure.core/let
    [credentials3601 (:credentials m3600) args3602 (:args m3600)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3603
      (com.palletops.awaze.common/aws-client :ec2 credentials3601)]
     (clojure.core/case
      (clojure.core/count args3602)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3603
        describeClassicLinkInstances
        (ec2/describe-classic-link-instances-request
         (clojure.core/nth args3602 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3603
        describeClassicLinkInstances))))))
  (clojure.core/defn
   describe-classic-link-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeClassicLinkInstances, describeClassicLinkInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-classic-link-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-classic-link-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-classic-link-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeClassicLinkInstances, describeClassicLinkInstances"}
   [credentials3605 & args3606]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3607
     (com.palletops.awaze.common/aws-client :ec2 credentials3605)]
    (clojure.core/case
     (clojure.core/count args3606)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3607
       describeClassicLinkInstances
       (ec2/describe-classic-link-instances-request
        (clojure.core/nth args3606 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3607
       describeClassicLinkInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m3608]
   (clojure.core/let
    [credentials3609 (:credentials m3608) args3610 (:args m3608)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3611
      (com.palletops.awaze.common/aws-client :ec2 credentials3609)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3611
       purchaseReservedInstancesOffering
       (ec2/purchase-reserved-instances-offering-request
        (clojure.core/nth args3610 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials3613 & args3614]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3615
     (com.palletops.awaze.common/aws-client :ec2 credentials3613)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3615
      purchaseReservedInstancesOffering
      (ec2/purchase-reserved-instances-offering-request
       (clojure.core/nth args3614 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m3616]
   (clojure.core/let
    [credentials3617 (:credentials m3616) args3618 (:args m3616)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3619
      (com.palletops.awaze.common/aws-client :ec2 credentials3617)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3619
       startInstances
       (ec2/start-instances-request (clojure.core/nth args3618 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :start-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call startInstances"}
   [credentials3621 & args3622]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3623
     (com.palletops.awaze.common/aws-client :ec2 credentials3621)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3623
      startInstances
      (ec2/start-instances-request (clojure.core/nth args3622 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m3624]
   (clojure.core/let
    [credentials3625 (:credentials m3624) args3626 (:args m3624)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3627
      (com.palletops.awaze.common/aws-client :ec2 credentials3625)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3627
       describeInstanceAttribute
       (ec2/describe-instance-attribute-request
        (clojure.core/nth args3626 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials3629 & args3630]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3631
     (com.palletops.awaze.common/aws-client :ec2 credentials3629)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3631
      describeInstanceAttribute
      (ec2/describe-instance-attribute-request
       (clojure.core/nth args3630 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-fleet-requests
   [m3632]
   (clojure.core/let
    [credentials3633 (:credentials m3632) args3634 (:args m3632)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3635
      (com.palletops.awaze.common/aws-client :ec2 credentials3633)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3635
       cancelSpotFleetRequests
       (ec2/cancel-spot-fleet-requests-request
        (clojure.core/nth args3634 0)))))))
  (clojure.core/defn
   cancel-spot-fleet-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Generate map for cancelSpotFleetRequests"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-fleet-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Call cancelSpotFleetRequests"}
   [credentials3637 & args3638]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3639
     (com.palletops.awaze.common/aws-client :ec2 credentials3637)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3639
      cancelSpotFleetRequests
      (ec2/cancel-spot-fleet-requests-request
       (clojure.core/nth args3638 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m3640]
   (clojure.core/let
    [credentials3641 (:credentials m3640) args3642 (:args m3640)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3643
      (com.palletops.awaze.common/aws-client :ec2 credentials3641)]
     (clojure.core/case
      (clojure.core/count args3642)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3643
        describeSubnets
        (ec2/describe-subnets-request (clojure.core/nth args3642 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3643
        describeSubnets))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-subnets,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-subnets,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials3645 & args3646]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3647
     (com.palletops.awaze.common/aws-client :ec2 credentials3645)]
    (clojure.core/case
     (clojure.core/count args3646)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3647
       describeSubnets
       (ec2/describe-subnets-request (clojure.core/nth args3646 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3647
       describeSubnets))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m3648]
   (clojure.core/let
    [credentials3649 (:credentials m3648) args3650 (:args m3648)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3651
      (com.palletops.awaze.common/aws-client :ec2 credentials3649)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3651
       createVolume
       (ec2/create-volume-request (clojure.core/nth args3650 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Call createVolume"}
   [credentials3653 & args3654]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3655
     (com.palletops.awaze.common/aws-client :ec2 credentials3653)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3655
      createVolume
      (ec2/create-volume-request (clojure.core/nth args3654 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m3656]
   (clojure.core/let
    [credentials3657 (:credentials m3656) args3658 (:args m3656)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3659
      (com.palletops.awaze.common/aws-client :ec2 credentials3657)]
     (clojure.core/case
      (clojure.core/count args3658)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3659
        describeReservedInstancesListings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3659
        describeReservedInstancesListings
        (ec2/describe-reserved-instances-listings-request
         (clojure.core/nth args3658 0))))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials3661 & args3662]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3663
     (com.palletops.awaze.common/aws-client :ec2 credentials3661)]
    (clojure.core/case
     (clojure.core/count args3662)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3663
       describeReservedInstancesListings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3663
       describeReservedInstancesListings
       (ec2/describe-reserved-instances-listings-request
        (clojure.core/nth args3662 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m3664]
   (clojure.core/let
    [credentials3665 (:credentials m3664) args3666 (:args m3664)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3667
      (com.palletops.awaze.common/aws-client :ec2 credentials3665)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3667
       createDhcpOptions
       (ec2/create-dhcp-options-request (clojure.core/nth args3666 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Call createDhcpOptions"}
   [credentials3669 & args3670]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3671
     (com.palletops.awaze.common/aws-client :ec2 credentials3669)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3671
      createDhcpOptions
      (ec2/create-dhcp-options-request (clojure.core/nth args3670 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m3672]
   (clojure.core/let
    [credentials3673 (:credentials m3672) args3674 (:args m3672)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3675
      (com.palletops.awaze.common/aws-client :ec2 credentials3673)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3675
       detachInternetGateway
       (ec2/detach-internet-gateway-request
        (clojure.core/nth args3674 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call detachInternetGateway"}
   [credentials3677 & args3678]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3679
     (com.palletops.awaze.common/aws-client :ec2 credentials3677)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3679
      detachInternetGateway
      (ec2/detach-internet-gateway-request
       (clojure.core/nth args3678 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m3680]
   (clojure.core/let
    [credentials3681 (:credentials m3680) args3682 (:args m3680)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3683
      (com.palletops.awaze.common/aws-client :ec2 credentials3681)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3683
       deleteVpnGateway
       (ec2/delete-vpn-gateway-request (clojure.core/nth args3682 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials3685 & args3686]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3687
     (com.palletops.awaze.common/aws-client :ec2 credentials3685)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3687
      deleteVpnGateway
      (ec2/delete-vpn-gateway-request (clojure.core/nth args3686 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m3688]
   (clojure.core/let
    [credentials3689 (:credentials m3688) args3690 (:args m3688)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3691
      (com.palletops.awaze.common/aws-client :ec2 credentials3689)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3691
       requestSpotInstances
       (ec2/request-spot-instances-request
        (clojure.core/nth args3690 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-spot-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call requestSpotInstances"}
   [credentials3693 & args3694]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3695
     (com.palletops.awaze.common/aws-client :ec2 credentials3693)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3695
      requestSpotInstances
      (ec2/request-spot-instances-request
       (clojure.core/nth args3694 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m3696]
   (clojure.core/let
    [credentials3697 (:credentials m3696) args3698 (:args m3696)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3699
      (com.palletops.awaze.common/aws-client :ec2 credentials3697)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3699
       importVolume
       (ec2/import-volume-request (clojure.core/nth args3698 0)))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Call importVolume"}
   [credentials3701 & args3702]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3703
     (com.palletops.awaze.common/aws-client :ec2 credentials3701)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3703
      importVolume
      (ec2/import-volume-request (clojure.core/nth args3702 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-snapshot
   [m3704]
   (clojure.core/let
    [credentials3705 (:credentials m3704) args3706 (:args m3704)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3707
      (com.palletops.awaze.common/aws-client :ec2 credentials3705)]
     (clojure.core/case
      (clojure.core/count args3706)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3707
        importSnapshot
        (ec2/import-snapshot-request (clojure.core/nth args3706 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3707
        importSnapshot))))))
  (clojure.core/defn
   import-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]
                [credentials]]),
    :doc "Generate map for importSnapshot, importSnapshot"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :import-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]
                [credentials]]),
    :doc "Call importSnapshot, importSnapshot"}
   [credentials3709 & args3710]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3711
     (com.palletops.awaze.common/aws-client :ec2 credentials3709)]
    (clojure.core/case
     (clojure.core/count args3710)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3711
       importSnapshot
       (ec2/import-snapshot-request (clojure.core/nth args3710 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3711
       importSnapshot))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m3712]
   (clojure.core/let
    [credentials3713 (:credentials m3712) args3714 (:args m3712)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3715
      (com.palletops.awaze.common/aws-client :ec2 credentials3713)]
     (clojure.core/case
      (clojure.core/count args3714)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3715
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3715
        describeTags
        (ec2/describe-tags-request (clojure.core/nth args3714 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials3717 & args3718]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3719
     (com.palletops.awaze.common/aws-client :ec2 credentials3717)]
    (clojure.core/case
     (clojure.core/count args3718)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3719
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3719
       describeTags
       (ec2/describe-tags-request (clojure.core/nth args3718 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m3720]
   (clojure.core/let
    [credentials3721 (:credentials m3720) args3722 (:args m3720)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3723
      (com.palletops.awaze.common/aws-client :ec2 credentials3721)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3723
       deleteTags
       (ec2/delete-tags-request (clojure.core/nth args3722 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials3725 & args3726]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3727
     (com.palletops.awaze.common/aws-client :ec2 credentials3725)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3727
      deleteTags
      (ec2/delete-tags-request (clojure.core/nth args3726 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link
   [m3728]
   (clojure.core/let
    [credentials3729 (:credentials m3728) args3730 (:args m3728)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3731
      (com.palletops.awaze.common/aws-client :ec2 credentials3729)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3731
       enableVpcClassicLink
       (ec2/enable-vpc-classic-link-request
        (clojure.core/nth args3730 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLink"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLink"}
   [credentials3733 & args3734]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3735
     (com.palletops.awaze.common/aws-client :ec2 credentials3733)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3735
      enableVpcClassicLink
      (ec2/enable-vpc-classic-link-request
       (clojure.core/nth args3734 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m3736]
   (clojure.core/let
    [credentials3737 (:credentials m3736) args3738 (:args m3736)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3739
      (com.palletops.awaze.common/aws-client :ec2 credentials3737)]
     (clojure.core/case
      (clojure.core/count args3738)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3739
        describeReservedInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3739
        describeReservedInstancesOfferings
        (ec2/describe-reserved-instances-offerings-request
         (clojure.core/nth args3738 0))))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials3741 & args3742]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3743
     (com.palletops.awaze.common/aws-client :ec2 credentials3741)]
    (clojure.core/case
     (clojure.core/count args3742)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3743
       describeReservedInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3743
       describeReservedInstancesOfferings
       (ec2/describe-reserved-instances-offerings-request
        (clojure.core/nth args3742 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m3744]
   (clojure.core/let
    [credentials3745 (:credentials m3744) args3746 (:args m3744)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3747
      (com.palletops.awaze.common/aws-client :ec2 credentials3745)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3747
       createVpnGateway
       (ec2/create-vpn-gateway-request (clojure.core/nth args3746 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnGateway"}
   [credentials3749 & args3750]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3751
     (com.palletops.awaze.common/aws-client :ec2 credentials3749)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3751
      createVpnGateway
      (ec2/create-vpn-gateway-request (clojure.core/nth args3750 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m3752]
   (clojure.core/let
    [credentials3753 (:credentials m3752) args3754 (:args m3752)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3755
      (com.palletops.awaze.common/aws-client :ec2 credentials3753)]
     (clojure.core/case
      (clojure.core/count args3754)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3755
        describeRouteTables
        (ec2/describe-route-tables-request
         (clojure.core/nth args3754 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3755
        describeRouteTables))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-route-tables,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-route-tables,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials3757 & args3758]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3759
     (com.palletops.awaze.common/aws-client :ec2 credentials3757)]
    (clojure.core/case
     (clojure.core/count args3758)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3759
       describeRouteTables
       (ec2/describe-route-tables-request
        (clojure.core/nth args3758 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3759
       describeRouteTables))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m3760]
   (clojure.core/let
    [credentials3761 (:credentials m3760) args3762 (:args m3760)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3763
      (com.palletops.awaze.common/aws-client :ec2 credentials3761)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3763
       cancelSpotInstanceRequests
       (ec2/cancel-spot-instance-requests-request
        (clojure.core/nth args3762 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials3765 & args3766]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3767
     (com.palletops.awaze.common/aws-client :ec2 credentials3765)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3767
      cancelSpotInstanceRequests
      (ec2/cancel-spot-instance-requests-request
       (clojure.core/nth args3766 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m3768]
   (clojure.core/let
    [credentials3769 (:credentials m3768) args3770 (:args m3768)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3771
      (com.palletops.awaze.common/aws-client :ec2 credentials3769)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3771
       assignPrivateIpAddresses
       (ec2/assign-private-ip-addresses-request
        (clojure.core/nth args3770 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assign-private-ip-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials3773 & args3774]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3775
     (com.palletops.awaze.common/aws-client :ec2 credentials3773)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3775
      assignPrivateIpAddresses
      (ec2/assign-private-ip-addresses-request
       (clojure.core/nth args3774 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link-dns-support
   [m3776]
   (clojure.core/let
    [credentials3777 (:credentials m3776) args3778 (:args m3776)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3779
      (com.palletops.awaze.common/aws-client :ec2 credentials3777)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3779
       disableVpcClassicLinkDnsSupport
       (ec2/disable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3778 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLinkDnsSupport"}
   [credentials3781 & args3782]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3783
     (com.palletops.awaze.common/aws-client :ec2 credentials3781)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3783
      disableVpcClassicLinkDnsSupport
      (ec2/disable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3782 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m3784]
   (clojure.core/let
    [credentials3785 (:credentials m3784) args3786 (:args m3784)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3787
      (com.palletops.awaze.common/aws-client :ec2 credentials3785)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3787
       deletePlacementGroup
       (ec2/delete-placement-group-request
        (clojure.core/nth args3786 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-placement-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials3789 & args3790]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3791
     (com.palletops.awaze.common/aws-client :ec2 credentials3789)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3791
      deletePlacementGroup
      (ec2/delete-placement-group-request
       (clojure.core/nth args3790 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m3792]
   (clojure.core/let
    [credentials3793 (:credentials m3792) args3794 (:args m3792)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3795
      (com.palletops.awaze.common/aws-client :ec2 credentials3793)]
     (clojure.core/case
      (clojure.core/count args3794)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3795
        describeInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3795
        describeInstances
        (ec2/describe-instances-request (clojure.core/nth args3794 0))))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials3797 & args3798]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3799
     (com.palletops.awaze.common/aws-client :ec2 credentials3797)]
    (clojure.core/case
     (clojure.core/count args3798)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3799
       describeInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3799
       describeInstances
       (ec2/describe-instances-request (clojure.core/nth args3798 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m3800]
   (clojure.core/let
    [credentials3801 (:credentials m3800) args3802 (:args m3800)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3803
      (com.palletops.awaze.common/aws-client :ec2 credentials3801)]
     (clojure.core/case
      (clojure.core/count args3802)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3803
        describeVolumes
        (ec2/describe-volumes-request (clojure.core/nth args3802 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3803
        describeVolumes))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-volumes,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volumes,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials3805 & args3806]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3807
     (com.palletops.awaze.common/aws-client :ec2 credentials3805)]
    (clojure.core/case
     (clojure.core/count args3806)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3807
       describeVolumes
       (ec2/describe-volumes-request (clojure.core/nth args3806 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3807
       describeVolumes))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m3808]
   (clojure.core/let
    [credentials3809 (:credentials m3808) args3810 (:args m3808)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3811
      (com.palletops.awaze.common/aws-client :ec2 credentials3809)]
     (clojure.core/case
      (clojure.core/count args3810)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3811
        describeBundleTasks
        (ec2/describe-bundle-tasks-request
         (clojure.core/nth args3810 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3811
        describeBundleTasks))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]
                [credentials]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-bundle-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-bundle-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]
                [credentials]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials3813 & args3814]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3815
     (com.palletops.awaze.common/aws-client :ec2 credentials3813)]
    (clojure.core/case
     (clojure.core/count args3814)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3815
       describeBundleTasks
       (ec2/describe-bundle-tasks-request
        (clojure.core/nth args3814 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3815
       describeBundleTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m3816]
   (clojure.core/let
    [credentials3817 (:credentials m3816) args3818 (:args m3816)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3819
      (com.palletops.awaze.common/aws-client :ec2 credentials3817)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3819
       associateDhcpOptions
       (ec2/associate-dhcp-options-request
        (clojure.core/nth args3818 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials3821 & args3822]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3823
     (com.palletops.awaze.common/aws-client :ec2 credentials3821)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3823
      associateDhcpOptions
      (ec2/associate-dhcp-options-request
       (clojure.core/nth args3822 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m3824]
   (clojure.core/let
    [credentials3825 (:credentials m3824) args3826 (:args m3824)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3827
      (com.palletops.awaze.common/aws-client :ec2 credentials3825)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3827
       modifyVpcAttribute
       (ec2/modify-vpc-attribute-request
        (clojure.core/nth args3826 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-vpc-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials3829 & args3830]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3831
     (com.palletops.awaze.common/aws-client :ec2 credentials3829)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3831
      modifyVpcAttribute
      (ec2/modify-vpc-attribute-request (clojure.core/nth args3830 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-flow-logs
   [m3832]
   (clojure.core/let
    [credentials3833 (:credentials m3832) args3834 (:args m3832)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3835
      (com.palletops.awaze.common/aws-client :ec2 credentials3833)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3835
       createFlowLogs
       (ec2/create-flow-logs-request (clojure.core/nth args3834 0)))))))
  (clojure.core/defn
   create-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createFlowLogs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createFlowLogs"}
   [credentials3837 & args3838]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3839
     (com.palletops.awaze.common/aws-client :ec2 credentials3837)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3839
      createFlowLogs
      (ec2/create-flow-logs-request (clojure.core/nth args3838 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m3840]
   (clojure.core/let
    [credentials3841 (:credentials m3840) args3842 (:args m3840)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3843
      (com.palletops.awaze.common/aws-client :ec2 credentials3841)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3843
       disassociateAddress
       (ec2/disassociate-address-request
        (clojure.core/nth args3842 0)))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for disassociateAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call disassociateAddress"}
   [credentials3845 & args3846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3847
     (com.palletops.awaze.common/aws-client :ec2 credentials3845)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3847
      disassociateAddress
      (ec2/disassociate-address-request (clojure.core/nth args3846 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m3848]
   (clojure.core/let
    [credentials3849 (:credentials m3848) args3850 (:args m3848)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3851
      (com.palletops.awaze.common/aws-client :ec2 credentials3849)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3851
       resetNetworkInterfaceAttribute
       (ec2/reset-network-interface-attribute-request
        (clojure.core/nth args3850 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials3853 & args3854]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3855
     (com.palletops.awaze.common/aws-client :ec2 credentials3853)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3855
      resetNetworkInterfaceAttribute
      (ec2/reset-network-interface-attribute-request
       (clojure.core/nth args3854 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m3856]
   (clojure.core/let
    [credentials3857 (:credentials m3856) args3858 (:args m3856)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3859
      (com.palletops.awaze.common/aws-client :ec2 credentials3857)]
     (clojure.core/case
      (clojure.core/count args3858)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3859
        describePlacementGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3859
        describePlacementGroups
        (ec2/describe-placement-groups-request
         (clojure.core/nth args3858 0))))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-placement-groups,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-placement-groups,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials3861 & args3862]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3863
     (com.palletops.awaze.common/aws-client :ec2 credentials3861)]
    (clojure.core/case
     (clojure.core/count args3862)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3863
       describePlacementGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3863
       describePlacementGroups
       (ec2/describe-placement-groups-request
        (clojure.core/nth args3862 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m3864]
   (clojure.core/let
    [credentials3865 (:credentials m3864) args3866 (:args m3864)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3867
      (com.palletops.awaze.common/aws-client :ec2 credentials3865)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3867
       resetSnapshotAttribute
       (ec2/reset-snapshot-attribute-request
        (clojure.core/nth args3866 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials3869 & args3870]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3871
     (com.palletops.awaze.common/aws-client :ec2 credentials3869)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3871
      resetSnapshotAttribute
      (ec2/reset-snapshot-attribute-request
       (clojure.core/nth args3870 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m3872]
   (clojure.core/let
    [credentials3873 (:credentials m3872) args3874 (:args m3872)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3875
      (com.palletops.awaze.common/aws-client :ec2 credentials3873)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3875
       releaseAddress
       (ec2/release-address-request (clojure.core/nth args3874 0)))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for releaseAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :release-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call releaseAddress"}
   [credentials3877 & args3878]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3879
     (com.palletops.awaze.common/aws-client :ec2 credentials3877)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3879
      releaseAddress
      (ec2/release-address-request (clojure.core/nth args3878 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m3880]
   (clojure.core/let
    [credentials3881 (:credentials m3880) args3882 (:args m3880)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3883
      (com.palletops.awaze.common/aws-client :ec2 credentials3881)]
     (clojure.core/case
      (clojure.core/count args3882)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3883
        describeVolumeStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3883
        describeVolumeStatus
        (ec2/describe-volume-status-request
         (clojure.core/nth args3882 0))))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-volume-status,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volume-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials3885 & args3886]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3887
     (com.palletops.awaze.common/aws-client :ec2 credentials3885)]
    (clojure.core/case
     (clojure.core/count args3886)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3887
       describeVolumeStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3887
       describeVolumeStatus
       (ec2/describe-volume-status-request
        (clojure.core/nth args3886 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m3888]
   (clojure.core/let
    [credentials3889 (:credentials m3888) args3890 (:args m3888)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3891
      (com.palletops.awaze.common/aws-client :ec2 credentials3889)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3891
       bundleInstance
       (ec2/bundle-instance-request (clojure.core/nth args3890 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :bundle-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Call bundleInstance"}
   [credentials3893 & args3894]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3895
     (com.palletops.awaze.common/aws-client :ec2 credentials3893)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3895
      bundleInstance
      (ec2/bundle-instance-request (clojure.core/nth args3894 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m3896]
   (clojure.core/let
    [credentials3897 (:credentials m3896) args3898 (:args m3896)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3899
      (com.palletops.awaze.common/aws-client :ec2 credentials3897)]
     (clojure.core/case
      (clojure.core/count args3898)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3899
        describeVpnConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3899
        describeVpnConnections
        (ec2/describe-vpn-connections-request
         (clojure.core/nth args3898 0))))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpn-connections,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpn-connections,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials3901 & args3902]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3903
     (com.palletops.awaze.common/aws-client :ec2 credentials3901)]
    (clojure.core/case
     (clojure.core/count args3902)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3903
       describeVpnConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3903
       describeVpnConnections
       (ec2/describe-vpn-connections-request
        (clojure.core/nth args3902 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m3904]
   (clojure.core/let
    [credentials3905 (:credentials m3904) args3906 (:args m3904)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3907
      (com.palletops.awaze.common/aws-client :ec2 credentials3905)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3907
       createRoute
       (ec2/create-route-request (clojure.core/nth args3906 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call createRoute"}
   [credentials3909 & args3910]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3911
     (com.palletops.awaze.common/aws-client :ec2 credentials3909)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3911
      createRoute
      (ec2/create-route-request (clojure.core/nth args3910 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m3912]
   (clojure.core/let
    [credentials3913 (:credentials m3912) args3914 (:args m3912)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3915
      (com.palletops.awaze.common/aws-client :ec2 credentials3913)]
     (clojure.core/case
      (clojure.core/count args3914)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3915
        describeSpotPriceHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3915
        describeSpotPriceHistory
        (ec2/describe-spot-price-history-request
         (clojure.core/nth args3914 0))))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-price-history,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-price-history,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials3917 & args3918]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3919
     (com.palletops.awaze.common/aws-client :ec2 credentials3917)]
    (clojure.core/case
     (clojure.core/count args3918)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3919
       describeSpotPriceHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3919
       describeSpotPriceHistory
       (ec2/describe-spot-price-history-request
        (clojure.core/nth args3918 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m3920]
   (clojure.core/let
    [credentials3921 (:credentials m3920) args3922 (:args m3920)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3923
      (com.palletops.awaze.common/aws-client :ec2 credentials3921)]
     (clojure.core/case
      (clojure.core/count args3922)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3923
        describeAvailabilityZones
        (ec2/describe-availability-zones-request
         (clojure.core/nth args3922 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3923
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-availability-zones,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-availability-zones,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials3925 & args3926]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3927
     (com.palletops.awaze.common/aws-client :ec2 credentials3925)]
    (clojure.core/case
     (clojure.core/count args3926)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3927
       describeAvailabilityZones
       (ec2/describe-availability-zones-request
        (clojure.core/nth args3926 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3927
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-peering-connection
   [m3928]
   (clojure.core/let
    [credentials3929 (:credentials m3928) args3930 (:args m3928)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3931
      (com.palletops.awaze.common/aws-client :ec2 credentials3929)]
     (clojure.core/case
      (clojure.core/count args3930)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3931
        createVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3931
        createVpcPeeringConnection
        (ec2/create-vpc-peering-connection-request
         (clojure.core/nth args3930 0))))))))
  (clojure.core/defn
   create-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpcPeeringConnection, createVpcPeeringConnection"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpcPeeringConnection, createVpcPeeringConnection"}
   [credentials3933 & args3934]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3935
     (com.palletops.awaze.common/aws-client :ec2 credentials3933)]
    (clojure.core/case
     (clojure.core/count args3934)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3935
       createVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3935
       createVpcPeeringConnection
       (ec2/create-vpc-peering-connection-request
        (clojure.core/nth args3934 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m3936]
   (clojure.core/let
    [credentials3937 (:credentials m3936) args3938 (:args m3936)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3939
      (com.palletops.awaze.common/aws-client :ec2 credentials3937)]
     (clojure.core/case
      (clojure.core/count args3938)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3939
        describeInternetGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3939
        describeInternetGateways
        (ec2/describe-internet-gateways-request
         (clojure.core/nth args3938 0))))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-internet-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-internet-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials3941 & args3942]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3943
     (com.palletops.awaze.common/aws-client :ec2 credentials3941)]
    (clojure.core/case
     (clojure.core/count args3942)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3943
       describeInternetGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3943
       describeInternetGateways
       (ec2/describe-internet-gateways-request
        (clojure.core/nth args3942 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m3944]
   (clojure.core/let
    [credentials3945 (:credentials m3944) args3946 (:args m3944)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3947
      (com.palletops.awaze.common/aws-client :ec2 credentials3945)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3947
       disassociateRouteTable
       (ec2/disassociate-route-table-request
        (clojure.core/nth args3946 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials3949 & args3950]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3951
     (com.palletops.awaze.common/aws-client :ec2 credentials3949)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3951
      disassociateRouteTable
      (ec2/disassociate-route-table-request
       (clojure.core/nth args3950 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m3952]
   (clojure.core/let
    [credentials3953 (:credentials m3952) args3954 (:args m3952)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3955
      (com.palletops.awaze.common/aws-client :ec2 credentials3953)]
     (clojure.core/case
      (clojure.core/count args3954)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3955
        describeRegions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3955
        describeRegions
        (ec2/describe-regions-request (clojure.core/nth args3954 0))))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-regions,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-regions,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials3957 & args3958]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3959
     (com.palletops.awaze.common/aws-client :ec2 credentials3957)]
    (clojure.core/case
     (clojure.core/count args3958)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3959
       describeRegions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3959
       describeRegions
       (ec2/describe-regions-request (clojure.core/nth args3958 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link-dns-support
   [m3960]
   (clojure.core/let
    [credentials3961 (:credentials m3960) args3962 (:args m3960)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3963
      (com.palletops.awaze.common/aws-client :ec2 credentials3961)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3963
       enableVpcClassicLinkDnsSupport
       (ec2/enable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3962 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLinkDnsSupport"}
   [credentials3965 & args3966]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3967
     (com.palletops.awaze.common/aws-client :ec2 credentials3965)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3967
      enableVpcClassicLinkDnsSupport
      (ec2/enable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3966 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m3968]
   (clojure.core/let
    [credentials3969 (:credentials m3968) args3970 (:args m3968)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3971
      (com.palletops.awaze.common/aws-client :ec2 credentials3969)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3971
       deregisterImage
       (ec2/deregister-image-request (clojure.core/nth args3970 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deregister-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterImage"}
   [credentials3973 & args3974]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3975
     (com.palletops.awaze.common/aws-client :ec2 credentials3973)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3975
      deregisterImage
      (ec2/deregister-image-request (clojure.core/nth args3974 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m3976]
   (clojure.core/let
    [credentials3977 (:credentials m3976) args3978 (:args m3976)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3979
      (com.palletops.awaze.common/aws-client :ec2 credentials3977)]
     (clojure.core/case
      (clojure.core/count args3978)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3979
        deleteSpotDatafeedSubscription
        (ec2/delete-spot-datafeed-subscription-request
         (clojure.core/nth args3978 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3979
        deleteSpotDatafeedSubscription))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials3981 & args3982]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3983
     (com.palletops.awaze.common/aws-client :ec2 credentials3981)]
    (clojure.core/case
     (clojure.core/count args3982)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3983
       deleteSpotDatafeedSubscription
       (ec2/delete-spot-datafeed-subscription-request
        (clojure.core/nth args3982 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3983
       deleteSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m3984]
   (clojure.core/let
    [credentials3985 (:credentials m3984) args3986 (:args m3984)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3987
      (com.palletops.awaze.common/aws-client :ec2 credentials3985)]
     (clojure.core/case
      (clojure.core/count args3986)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3987
        describeCustomerGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3987
        describeCustomerGateways
        (ec2/describe-customer-gateways-request
         (clojure.core/nth args3986 0))))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-customer-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-customer-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials3989 & args3990]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3991
     (com.palletops.awaze.common/aws-client :ec2 credentials3989)]
    (clojure.core/case
     (clojure.core/count args3990)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3991
       describeCustomerGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3991
       describeCustomerGateways
       (ec2/describe-customer-gateways-request
        (clojure.core/nth args3990 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-request-history
   [m3992]
   (clojure.core/let
    [credentials3993 (:credentials m3992) args3994 (:args m3992)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3995
      (com.palletops.awaze.common/aws-client :ec2 credentials3993)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3995
       describeSpotFleetRequestHistory
       (ec2/describe-spot-fleet-request-history-request
        (clojure.core/nth args3994 0)))))))
  (clojure.core/defn
   describe-spot-fleet-request-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetRequestHistory"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-request-history,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-request-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetRequestHistory"}
   [credentials3997 & args3998]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3999
     (com.palletops.awaze.common/aws-client :ec2 credentials3997)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3999
      describeSpotFleetRequestHistory
      (ec2/describe-spot-fleet-request-history-request
       (clojure.core/nth args3998 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m4000]
   (clojure.core/let
    [credentials4001 (:credentials m4000) args4002 (:args m4000)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4003
      (com.palletops.awaze.common/aws-client :ec2 credentials4001)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4003
       createSubnet
       (ec2/create-subnet-request (clojure.core/nth args4002 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-subnet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createSubnet"}
   [credentials4005 & args4006]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4007
     (com.palletops.awaze.common/aws-client :ec2 credentials4005)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4007
      createSubnet
      (ec2/create-subnet-request (clojure.core/nth args4006 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m4008]
   (clojure.core/let
    [credentials4009 (:credentials m4008) args4010 (:args m4008)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4011
      (com.palletops.awaze.common/aws-client :ec2 credentials4009)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4011
       describeNetworkInterfaceAttribute
       (ec2/describe-network-interface-attribute-request
        (clojure.core/nth args4010 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials4013 & args4014]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4015
     (com.palletops.awaze.common/aws-client :ec2 credentials4013)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4015
      describeNetworkInterfaceAttribute
      (ec2/describe-network-interface-attribute-request
       (clojure.core/nth args4014 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-placement
   [m4016]
   (clojure.core/let
    [credentials4017 (:credentials m4016) args4018 (:args m4016)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4019
      (com.palletops.awaze.common/aws-client :ec2 credentials4017)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4019
       modifyInstancePlacement
       (ec2/modify-instance-placement-request
        (clojure.core/nth args4018 0)))))))
  (clojure.core/defn
   modify-instance-placement-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstancePlacement"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-placement,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-placement
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstancePlacement"}
   [credentials4021 & args4022]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4023
     (com.palletops.awaze.common/aws-client :ec2 credentials4021)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4023
      modifyInstancePlacement
      (ec2/modify-instance-placement-request
       (clojure.core/nth args4022 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-classic-link-vpc
   [m4024]
   (clojure.core/let
    [credentials4025 (:credentials m4024) args4026 (:args m4024)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4027
      (com.palletops.awaze.common/aws-client :ec2 credentials4025)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4027
       detachClassicLinkVpc
       (ec2/detach-classic-link-vpc-request
        (clojure.core/nth args4026 0)))))))
  (clojure.core/defn
   detach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachClassicLinkVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-classic-link-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachClassicLinkVpc"}
   [credentials4029 & args4030]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4031
     (com.palletops.awaze.common/aws-client :ec2 credentials4029)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4031
      detachClassicLinkVpc
      (ec2/detach-classic-link-vpc-request
       (clojure.core/nth args4030 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m4032]
   (clojure.core/let
    [credentials4033 (:credentials m4032) args4034 (:args m4032)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4035
      (com.palletops.awaze.common/aws-client :ec2 credentials4033)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4035
       cancelConversionTask
       (ec2/cancel-conversion-task-request
        (clojure.core/nth args4034 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-conversion-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelConversionTask"}
   [credentials4037 & args4038]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4039
     (com.palletops.awaze.common/aws-client :ec2 credentials4037)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4039
      cancelConversionTask
      (ec2/cancel-conversion-task-request
       (clojure.core/nth args4038 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m4040]
   (clojure.core/let
    [credentials4041 (:credentials m4040) args4042 (:args m4040)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4043
      (com.palletops.awaze.common/aws-client :ec2 credentials4041)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4043
       createNetworkInterface
       (ec2/create-network-interface-request
        (clojure.core/nth args4042 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Call createNetworkInterface"}
   [credentials4045 & args4046]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4047
     (com.palletops.awaze.common/aws-client :ec2 credentials4045)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4047
      createNetworkInterface
      (ec2/create-network-interface-request
       (clojure.core/nth args4046 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m4048]
   (clojure.core/let
    [credentials4049 (:credentials m4048) args4050 (:args m4048)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4051
      (com.palletops.awaze.common/aws-client :ec2 credentials4049)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4051
       modifyImageAttribute
       (ec2/modify-image-attribute-request
        (clojure.core/nth args4050 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials4053 & args4054]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4055
     (com.palletops.awaze.common/aws-client :ec2 credentials4053)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4055
      modifyImageAttribute
      (ec2/modify-image-attribute-request
       (clojure.core/nth args4054 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m4056]
   (clojure.core/let
    [credentials4057 (:credentials m4056) args4058 (:args m4056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4059
      (com.palletops.awaze.common/aws-client :ec2 credentials4057)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4059
       deleteRouteTable
       (ec2/delete-route-table-request (clojure.core/nth args4058 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRouteTable"}
   [credentials4061 & args4062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4063
     (com.palletops.awaze.common/aws-client :ec2 credentials4061)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4063
      deleteRouteTable
      (ec2/delete-route-table-request (clojure.core/nth args4062 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m4064]
   (clojure.core/let
    [credentials4065 (:credentials m4064) args4066 (:args m4064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4067
      (com.palletops.awaze.common/aws-client :ec2 credentials4065)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4067
       associateRouteTable
       (ec2/associate-route-table-request
        (clojure.core/nth args4066 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call associateRouteTable"}
   [credentials4069 & args4070]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4071
     (com.palletops.awaze.common/aws-client :ec2 credentials4069)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4071
      associateRouteTable
      (ec2/associate-route-table-request
       (clojure.core/nth args4070 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m4072]
   (clojure.core/let
    [credentials4073 (:credentials m4072) args4074 (:args m4072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4075
      (com.palletops.awaze.common/aws-client :ec2 credentials4073)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4075
       deleteCustomerGateway
       (ec2/delete-customer-gateway-request
        (clojure.core/nth args4074 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-customer-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials4077 & args4078]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4079
     (com.palletops.awaze.common/aws-client :ec2 credentials4077)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4079
      deleteCustomerGateway
      (ec2/delete-customer-gateway-request
       (clojure.core/nth args4078 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m4080]
   (clojure.core/let
    [credentials4081 (:credentials m4080) args4082 (:args m4080)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4083
      (com.palletops.awaze.common/aws-client :ec2 credentials4081)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4083
       replaceRouteTableAssociation
       (ec2/replace-route-table-association-request
        (clojure.core/nth args4082 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-route-table-association,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials4085 & args4086]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4087
     (com.palletops.awaze.common/aws-client :ec2 credentials4085)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4087
      replaceRouteTableAssociation
      (ec2/replace-route-table-association-request
       (clojure.core/nth args4086 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m4088]
   (clojure.core/let
    [credentials4089 (:credentials m4088) args4090 (:args m4088)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4091
      (com.palletops.awaze.common/aws-client :ec2 credentials4089)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4091
       deleteVpc
       (ec2/delete-vpc-request (clojure.core/nth args4090 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpc"}
   [credentials4093 & args4094]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4095
     (com.palletops.awaze.common/aws-client :ec2 credentials4093)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4095
      deleteVpc
      (ec2/delete-vpc-request (clojure.core/nth args4094 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m4096]
   (clojure.core/let
    [credentials4097 (:credentials m4096) args4098 (:args m4096)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4099
      (com.palletops.awaze.common/aws-client :ec2 credentials4097)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4099
       createKeyPair
       (ec2/create-key-pair-request (clojure.core/nth args4098 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createKeyPair"}
   [credentials4101 & args4102]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4103
     (com.palletops.awaze.common/aws-client :ec2 credentials4101)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4103
      createKeyPair
      (ec2/create-key-pair-request (clojure.core/nth args4102 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-hosts
   [m4104]
   (clojure.core/let
    [credentials4105 (:credentials m4104) args4106 (:args m4104)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4107
      (com.palletops.awaze.common/aws-client :ec2 credentials4105)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4107
       allocateHosts
       (ec2/allocate-hosts-request (clojure.core/nth args4106 0)))))))
  (clojure.core/defn
   allocate-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Generate map for allocateHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Call allocateHosts"}
   [credentials4109 & args4110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4111
     (com.palletops.awaze.common/aws-client :ec2 credentials4109)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4111
      allocateHosts
      (ec2/allocate-hosts-request (clojure.core/nth args4110 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m4112]
   (clojure.core/let
    [credentials4113 (:credentials m4112) args4114 (:args m4112)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4115
      (com.palletops.awaze.common/aws-client :ec2 credentials4113)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4115
       replaceRoute
       (ec2/replace-route-request (clojure.core/nth args4114 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRoute"}
   [credentials4117 & args4118]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4119
     (com.palletops.awaze.common/aws-client :ec2 credentials4117)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4119
      replaceRoute
      (ec2/replace-route-request (clojure.core/nth args4118 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m4120]
   (clojure.core/let
    [credentials4121 (:credentials m4120) args4122 (:args m4120)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4123
      (com.palletops.awaze.common/aws-client :ec2 credentials4121)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4123
       terminateInstances
       (ec2/terminate-instances-request (clojure.core/nth args4122 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstances"}
   [credentials4125 & args4126]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4127
     (com.palletops.awaze.common/aws-client :ec2 credentials4125)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4127
      terminateInstances
      (ec2/terminate-instances-request (clojure.core/nth args4126 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m4128]
   (clojure.core/let
    [credentials4129 (:credentials m4128) args4130 (:args m4128)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4131
      (com.palletops.awaze.common/aws-client :ec2 credentials4129)]
     (clojure.core/case
      (clojure.core/count args4130)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4131
        describeSnapshots
        (ec2/describe-snapshots-request (clojure.core/nth args4130 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4131
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials4133 & args4134]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4135
     (com.palletops.awaze.common/aws-client :ec2 credentials4133)]
    (clojure.core/case
     (clojure.core/count args4134)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4135
       describeSnapshots
       (ec2/describe-snapshots-request (clojure.core/nth args4134 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4135
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m4136]
   (clojure.core/let
    [credentials4137 (:credentials m4136) args4138 (:args m4136)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4139
      (com.palletops.awaze.common/aws-client :ec2 credentials4137)]
     (clojure.core/case
      (clojure.core/count args4138)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4139
        describeVpnGateways
        (ec2/describe-vpn-gateways-request
         (clojure.core/nth args4138 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4139
        describeVpnGateways))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpn-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpn-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials4141 & args4142]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4143
     (com.palletops.awaze.common/aws-client :ec2 credentials4141)]
    (clojure.core/case
     (clojure.core/count args4142)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4143
       describeVpnGateways
       (ec2/describe-vpn-gateways-request
        (clojure.core/nth args4142 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4143
       describeVpnGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m4144]
   (clojure.core/let
    [credentials4145 (:credentials m4144) args4146 (:args m4144)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4147
      (com.palletops.awaze.common/aws-client :ec2 credentials4145)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4147
       getPasswordData
       (ec2/get-password-data-request (clojure.core/nth args4146 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-password-data,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPasswordData"}
   [credentials4149 & args4150]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4151
     (com.palletops.awaze.common/aws-client :ec2 credentials4149)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4151
      getPasswordData
      (ec2/get-password-data-request (clojure.core/nth args4150 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m4152]
   (clojure.core/let
    [credentials4153 (:credentials m4152) args4154 (:args m4152)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4155
      (com.palletops.awaze.common/aws-client :ec2 credentials4153)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4155
       modifyVolumeAttribute
       (ec2/modify-volume-attribute-request
        (clojure.core/nth args4154 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-volume-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials4157 & args4158]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4159
     (com.palletops.awaze.common/aws-client :ec2 credentials4157)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4159
      modifyVolumeAttribute
      (ec2/modify-volume-attribute-request
       (clojure.core/nth args4158 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m4160]
   (clojure.core/let
    [credentials4161 (:credentials m4160) args4162 (:args m4160)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4163
      (com.palletops.awaze.common/aws-client :ec2 credentials4161)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4163
       disableVgwRoutePropagation
       (ec2/disable-vgw-route-propagation-request
        (clojure.core/nth args4162 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials4165 & args4166]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4167
     (com.palletops.awaze.common/aws-client :ec2 credentials4165)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4167
      disableVgwRoutePropagation
      (ec2/disable-vgw-route-propagation-request
       (clojure.core/nth args4166 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-instances
   [m4168]
   (clojure.core/let
    [credentials4169 (:credentials m4168) args4170 (:args m4168)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4171
      (com.palletops.awaze.common/aws-client :ec2 credentials4169)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4171
       describeSpotFleetInstances
       (ec2/describe-spot-fleet-instances-request
        (clojure.core/nth args4170 0)))))))
  (clojure.core/defn
   describe-spot-fleet-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetInstances"}
   [credentials4173 & args4174]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4175
     (com.palletops.awaze.common/aws-client :ec2 credentials4173)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4175
      describeSpotFleetInstances
      (ec2/describe-spot-fleet-instances-request
       (clojure.core/nth args4174 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-prefix-lists
   [m4176]
   (clojure.core/let
    [credentials4177 (:credentials m4176) args4178 (:args m4176)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4179
      (com.palletops.awaze.common/aws-client :ec2 credentials4177)]
     (clojure.core/case
      (clojure.core/count args4178)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4179
        describePrefixLists
        (ec2/describe-prefix-lists-request
         (clojure.core/nth args4178 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4179
        describePrefixLists))))))
  (clojure.core/defn
   describe-prefix-lists-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describePrefixLists, describePrefixLists"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-prefix-lists,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-prefix-lists,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-prefix-lists
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describePrefixLists, describePrefixLists"}
   [credentials4181 & args4182]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4183
     (com.palletops.awaze.common/aws-client :ec2 credentials4181)]
    (clojure.core/case
     (clojure.core/count args4182)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4183
       describePrefixLists
       (ec2/describe-prefix-lists-request
        (clojure.core/nth args4182 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4183
       describePrefixLists))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m4184]
   (clojure.core/let
    [credentials4185 (:credentials m4184) args4186 (:args m4184)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4187
      (com.palletops.awaze.common/aws-client :ec2 credentials4185)]
     (clojure.core/case
      (clojure.core/count args4186)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4187
        describeAccountAttributes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4187
        describeAccountAttributes
        (ec2/describe-account-attributes-request
         (clojure.core/nth args4186 0))))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials4189 & args4190]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4191
     (com.palletops.awaze.common/aws-client :ec2 credentials4189)]
    (clojure.core/case
     (clojure.core/count args4190)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4191
       describeAccountAttributes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4191
       describeAccountAttributes
       (ec2/describe-account-attributes-request
        (clojure.core/nth args4190 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m4192]
   (clojure.core/let
    [credentials4193 (:credentials m4192) args4194 (:args m4192)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4195
      (com.palletops.awaze.common/aws-client :ec2 credentials4193)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4195
       createVpnConnection
       (ec2/create-vpn-connection-request
        (clojure.core/nth args4194 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnection"}
   [credentials4197 & args4198]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4199
     (com.palletops.awaze.common/aws-client :ec2 credentials4197)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4199
      createVpnConnection
      (ec2/create-vpn-connection-request
       (clojure.core/nth args4198 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-peering-connections
   [m4200]
   (clojure.core/let
    [credentials4201 (:credentials m4200) args4202 (:args m4200)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4203
      (com.palletops.awaze.common/aws-client :ec2 credentials4201)]
     (clojure.core/case
      (clojure.core/count args4202)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4203
        describeVpcPeeringConnections
        (ec2/describe-vpc-peering-connections-request
         (clojure.core/nth args4202 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4203
        describeVpcPeeringConnections))))))
  (clojure.core/defn
   describe-vpc-peering-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcPeeringConnections, describeVpcPeeringConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-peering-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcPeeringConnections, describeVpcPeeringConnections"}
   [credentials4205 & args4206]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4207
     (com.palletops.awaze.common/aws-client :ec2 credentials4205)]
    (clojure.core/case
     (clojure.core/count args4206)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4207
       describeVpcPeeringConnections
       (ec2/describe-vpc-peering-connections-request
        (clojure.core/nth args4206 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4207
       describeVpcPeeringConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instance-availability
   [m4208]
   (clojure.core/let
    [credentials4209 (:credentials m4208) args4210 (:args m4208)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4211
      (com.palletops.awaze.common/aws-client :ec2 credentials4209)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4211
       describeScheduledInstanceAvailability
       (ec2/describe-scheduled-instance-availability-request
        (clojure.core/nth args4210 0)))))))
  (clojure.core/defn
   describe-scheduled-instance-availability-map
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstanceAvailability"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instance-availability,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instance-availability
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstanceAvailability"}
   [credentials4213 & args4214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4215
     (com.palletops.awaze.common/aws-client :ec2 credentials4213)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4215
      describeScheduledInstanceAvailability
      (ec2/describe-scheduled-instance-availability-request
       (clojure.core/nth args4214 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-flow-logs
   [m4216]
   (clojure.core/let
    [credentials4217 (:credentials m4216) args4218 (:args m4216)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4219
      (com.palletops.awaze.common/aws-client :ec2 credentials4217)]
     (clojure.core/case
      (clojure.core/count args4218)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4219
        describeFlowLogs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4219
        describeFlowLogs
        (ec2/describe-flow-logs-request (clojure.core/nth args4218 0))))))))
  (clojure.core/defn
   describe-flow-logs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeFlowLogs, describeFlowLogs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-flow-logs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeFlowLogs, describeFlowLogs"}
   [credentials4221 & args4222]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4223
     (com.palletops.awaze.common/aws-client :ec2 credentials4221)]
    (clojure.core/case
     (clojure.core/count args4222)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4223
       describeFlowLogs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4223
       describeFlowLogs
       (ec2/describe-flow-logs-request (clojure.core/nth args4222 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m4224]
   (clojure.core/let
    [credentials4225 (:credentials m4224) args4226 (:args m4224)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4227
      (com.palletops.awaze.common/aws-client :ec2 credentials4225)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4227
       cancelBundleTask
       (ec2/cancel-bundle-task-request (clojure.core/nth args4226 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-bundle-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelBundleTask"}
   [credentials4229 & args4230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4231
     (com.palletops.awaze.common/aws-client :ec2 credentials4229)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4231
      cancelBundleTask
      (ec2/cancel-bundle-task-request (clojure.core/nth args4230 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m4232]
   (clojure.core/let
    [credentials4233 (:credentials m4232) args4234 (:args m4232)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4235
      (com.palletops.awaze.common/aws-client :ec2 credentials4233)]
     (clojure.core/case
      (clojure.core/count args4234)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4235
        describeReservedInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4235
        describeReservedInstances
        (ec2/describe-reserved-instances-request
         (clojure.core/nth args4234 0))))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials4237 & args4238]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4239
     (com.palletops.awaze.common/aws-client :ec2 credentials4237)]
    (clojure.core/case
     (clojure.core/count args4238)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4239
       describeReservedInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4239
       describeReservedInstances
       (ec2/describe-reserved-instances-request
        (clojure.core/nth args4238 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m4240]
   (clojure.core/let
    [credentials4241 (:credentials m4240) args4242 (:args m4240)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4243
      (com.palletops.awaze.common/aws-client :ec2 credentials4241)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4243
       unmonitorInstances
       (ec2/unmonitor-instances-request (clojure.core/nth args4242 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unmonitor-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unmonitorInstances"}
   [credentials4245 & args4246]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4247
     (com.palletops.awaze.common/aws-client :ec2 credentials4245)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4247
      unmonitorInstances
      (ec2/unmonitor-instances-request (clojure.core/nth args4246 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m4248]
   (clojure.core/let
    [credentials4249 (:credentials m4248) args4250 (:args m4248)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4251
      (com.palletops.awaze.common/aws-client :ec2 credentials4249)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4251
       deleteSecurityGroup
       (ec2/delete-security-group-request
        (clojure.core/nth args4250 0)))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-security-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSecurityGroup"}
   [credentials4253 & args4254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4255
     (com.palletops.awaze.common/aws-client :ec2 credentials4253)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4255
      deleteSecurityGroup
      (ec2/delete-security-group-request
       (clojure.core/nth args4254 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m4256]
   (clojure.core/let
    [credentials4257 (:credentials m4256) args4258 (:args m4256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4259
      (com.palletops.awaze.common/aws-client :ec2 credentials4257)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4259
       describeVpcAttribute
       (ec2/describe-vpc-attribute-request
        (clojure.core/nth args4258 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials4261 & args4262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4263
     (com.palletops.awaze.common/aws-client :ec2 credentials4261)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4263
      describeVpcAttribute
      (ec2/describe-vpc-attribute-request
       (clojure.core/nth args4262 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m4264]
   (clojure.core/let
    [credentials4265 (:credentials m4264) args4266 (:args m4264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4267
      (com.palletops.awaze.common/aws-client :ec2 credentials4265)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4267
       createNetworkAcl
       (ec2/create-network-acl-request (clojure.core/nth args4266 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-acl,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createNetworkAcl"}
   [credentials4269 & args4270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4271
     (com.palletops.awaze.common/aws-client :ec2 credentials4269)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4271
      createNetworkAcl
      (ec2/create-network-acl-request (clojure.core/nth args4270 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-import-task
   [m4272]
   (clojure.core/let
    [credentials4273 (:credentials m4272) args4274 (:args m4272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4275
      (com.palletops.awaze.common/aws-client :ec2 credentials4273)]
     (clojure.core/case
      (clojure.core/count args4274)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4275
        cancelImportTask))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4275
        cancelImportTask
        (ec2/cancel-import-task-request (clojure.core/nth args4274 0))))))))
  (clojure.core/defn
   cancel-import-task-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]]),
    :doc "Generate map for cancelImportTask, cancelImportTask"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :cancel-import-task,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-import-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-import-task
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]]),
    :doc "Call cancelImportTask, cancelImportTask"}
   [credentials4277 & args4278]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4279
     (com.palletops.awaze.common/aws-client :ec2 credentials4277)]
    (clojure.core/case
     (clojure.core/count args4278)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4279
       cancelImportTask))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4279
       cancelImportTask
       (ec2/cancel-import-task-request (clojure.core/nth args4278 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :accept-vpc-peering-connection
   [m4280]
   (clojure.core/let
    [credentials4281 (:credentials m4280) args4282 (:args m4280)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4283
      (com.palletops.awaze.common/aws-client :ec2 credentials4281)]
     (clojure.core/case
      (clojure.core/count args4282)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4283
        acceptVpcPeeringConnection
        (ec2/accept-vpc-peering-connection-request
         (clojure.core/nth args4282 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4283
        acceptVpcPeeringConnection))))))
  (clojure.core/defn
   accept-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   accept-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   [credentials4285 & args4286]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4287
     (com.palletops.awaze.common/aws-client :ec2 credentials4285)]
    (clojure.core/case
     (clojure.core/count args4286)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4287
       acceptVpcPeeringConnection
       (ec2/accept-vpc-peering-connection-request
        (clojure.core/nth args4286 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4287
       acceptVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoint-services
   [m4288]
   (clojure.core/let
    [credentials4289 (:credentials m4288) args4290 (:args m4288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4291
      (com.palletops.awaze.common/aws-client :ec2 credentials4289)]
     (clojure.core/case
      (clojure.core/count args4290)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4291
        describeVpcEndpointServices
        (ec2/describe-vpc-endpoint-services-request
         (clojure.core/nth args4290 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4291
        describeVpcEndpointServices))))))
  (clojure.core/defn
   describe-vpc-endpoint-services-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVpcEndpointServices, describeVpcEndpointServices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoint-services
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVpcEndpointServices, describeVpcEndpointServices"}
   [credentials4293 & args4294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4295
     (com.palletops.awaze.common/aws-client :ec2 credentials4293)]
    (clojure.core/case
     (clojure.core/count args4294)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4295
       describeVpcEndpointServices
       (ec2/describe-vpc-endpoint-services-request
        (clojure.core/nth args4294 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4295
       describeVpcEndpointServices))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-peering-connection
   [m4296]
   (clojure.core/let
    [credentials4297 (:credentials m4296) args4298 (:args m4296)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4299
      (com.palletops.awaze.common/aws-client :ec2 credentials4297)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4299
       deleteVpcPeeringConnection
       (ec2/delete-vpc-peering-connection-request
        (clojure.core/nth args4298 0)))))))
  (clojure.core/defn
   delete-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpcPeeringConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpcPeeringConnection"}
   [credentials4301 & args4302]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4303
     (com.palletops.awaze.common/aws-client :ec2 credentials4301)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4303
      deleteVpcPeeringConnection
      (ec2/delete-vpc-peering-connection-request
       (clojure.core/nth args4302 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m4304]
   (clojure.core/let
    [credentials4305 (:credentials m4304) args4306 (:args m4304)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4307
      (com.palletops.awaze.common/aws-client :ec2 credentials4305)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4307
       runInstances
       (ec2/run-instances-request (clojure.core/nth args4306 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call runInstances"}
   [credentials4309 & args4310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4311
     (com.palletops.awaze.common/aws-client :ec2 credentials4309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4311
      runInstances
      (ec2/run-instances-request (clojure.core/nth args4310 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m4312]
   (clojure.core/let
    [credentials4313 (:credentials m4312) args4314 (:args m4312)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4315
      (com.palletops.awaze.common/aws-client :ec2 credentials4313)]
     (clojure.core/case
      (clojure.core/count args4314)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4315
        describeInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4315
        describeInstanceStatus
        (ec2/describe-instance-status-request
         (clojure.core/nth args4314 0))))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials4317 & args4318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4319
     (com.palletops.awaze.common/aws-client :ec2 credentials4317)]
    (clojure.core/case
     (clojure.core/count args4318)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4319
       describeInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4319
       describeInstanceStatus
       (ec2/describe-instance-status-request
        (clojure.core/nth args4318 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link-dns-support
   [m4320]
   (clojure.core/let
    [credentials4321 (:credentials m4320) args4322 (:args m4320)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4323
      (com.palletops.awaze.common/aws-client :ec2 credentials4321)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4323
       describeVpcClassicLinkDnsSupport
       (ec2/describe-vpc-classic-link-dns-support-request
        (clojure.core/nth args4322 0)))))))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcClassicLinkDnsSupport"}
   [credentials4325 & args4326]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4327
     (com.palletops.awaze.common/aws-client :ec2 credentials4325)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4327
      describeVpcClassicLinkDnsSupport
      (ec2/describe-vpc-classic-link-dns-support-request
       (clojure.core/nth args4326 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m4328]
   (clojure.core/let
    [credentials4329 (:credentials m4328) args4330 (:args m4328)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4331
      (com.palletops.awaze.common/aws-client :ec2 credentials4329)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4331
       unassignPrivateIpAddresses
       (ec2/unassign-private-ip-addresses-request
        (clojure.core/nth args4330 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials4333 & args4334]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4335
     (com.palletops.awaze.common/aws-client :ec2 credentials4333)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4335
      unassignPrivateIpAddresses
      (ec2/unassign-private-ip-addresses-request
       (clojure.core/nth args4334 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m4336]
   (clojure.core/let
    [credentials4337 (:credentials m4336) args4338 (:args m4336)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4339
      (com.palletops.awaze.common/aws-client :ec2 credentials4337)]
     (clojure.core/case
      (clojure.core/count args4338)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4339
        describeSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4339
        describeSecurityGroups
        (ec2/describe-security-groups-request
         (clojure.core/nth args4338 0))))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-security-groups,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-security-groups,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials4341 & args4342]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4343
     (com.palletops.awaze.common/aws-client :ec2 credentials4341)]
    (clojure.core/case
     (clojure.core/count args4342)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4343
       describeSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4343
       describeSecurityGroups
       (ec2/describe-security-groups-request
        (clojure.core/nth args4342 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m4344]
   (clojure.core/let
    [credentials4345 (:credentials m4344) args4346 (:args m4344)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4347
      (com.palletops.awaze.common/aws-client :ec2 credentials4345)]
     (clojure.core/case
      (clojure.core/count args4346)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4347
        describeNetworkInterfaces
        (ec2/describe-network-interfaces-request
         (clojure.core/nth args4346 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4347
        describeNetworkInterfaces))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]
                [credentials]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-network-interfaces,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-interfaces,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]
                [credentials]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials4349 & args4350]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4351
     (com.palletops.awaze.common/aws-client :ec2 credentials4349)]
    (clojure.core/case
     (clojure.core/count args4350)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4351
       describeNetworkInterfaces
       (ec2/describe-network-interfaces-request
        (clojure.core/nth args4350 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4351
       describeNetworkInterfaces))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m4352]
   (clojure.core/let
    [credentials4353 (:credentials m4352) args4354 (:args m4352)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4355
      (com.palletops.awaze.common/aws-client :ec2 credentials4353)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4355
       createCustomerGateway
       (ec2/create-customer-gateway-request
        (clojure.core/nth args4354 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-customer-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call createCustomerGateway"}
   [credentials4357 & args4358]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4359
     (com.palletops.awaze.common/aws-client :ec2 credentials4357)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4359
      createCustomerGateway
      (ec2/create-customer-gateway-request
       (clojure.core/nth args4358 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m4360]
   (clojure.core/let
    [credentials4361 (:credentials m4360) args4362 (:args m4360)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4363
      (com.palletops.awaze.common/aws-client :ec2 credentials4361)]
     (clojure.core/case
      (clojure.core/count args4362)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4363
        describeDhcpOptions
        (ec2/describe-dhcp-options-request
         (clojure.core/nth args4362 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4363
        describeDhcpOptions))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials4365 & args4366]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4367
     (com.palletops.awaze.common/aws-client :ec2 credentials4365)]
    (clojure.core/case
     (clojure.core/count args4366)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4367
       describeDhcpOptions
       (ec2/describe-dhcp-options-request
        (clojure.core/nth args4366 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4367
       describeDhcpOptions))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m4368]
   (clojure.core/let
    [credentials4369 (:credentials m4368) args4370 (:args m4368)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4371
      (com.palletops.awaze.common/aws-client :ec2 credentials4369)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4371
       createTags
       (ec2/create-tags-request (clojure.core/nth args4370 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials4373 & args4374]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4375
     (com.palletops.awaze.common/aws-client :ec2 credentials4373)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4375
      createTags
      (ec2/create-tags-request (clojure.core/nth args4374 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m4376]
   (clojure.core/let
    [credentials4377 (:credentials m4376) args4378 (:args m4376)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4379
      (com.palletops.awaze.common/aws-client :ec2 credentials4377)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4379
       createSnapshot
       (ec2/create-snapshot-request (clojure.core/nth args4378 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials4381 & args4382]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4383
     (com.palletops.awaze.common/aws-client :ec2 credentials4381)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4383
      createSnapshot
      (ec2/create-snapshot-request (clojure.core/nth args4382 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-image
   [m4384]
   (clojure.core/let
    [credentials4385 (:credentials m4384) args4386 (:args m4384)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4387
      (com.palletops.awaze.common/aws-client :ec2 credentials4385)]
     (clojure.core/case
      (clojure.core/count args4386)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4387
        importImage))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4387
        importImage
        (ec2/import-image-request (clojure.core/nth args4386 0))))))))
  (clojure.core/defn
   import-image-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]]),
    :doc "Generate map for importImage, importImage"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :import-image,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-image
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]]),
    :doc "Call importImage, importImage"}
   [credentials4389 & args4390]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4391
     (com.palletops.awaze.common/aws-client :ec2 credentials4389)]
    (clojure.core/case
     (clojure.core/count args4390)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4391
       importImage))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4391
       importImage
       (ec2/import-image-request (clojure.core/nth args4390 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m4392]
   (clojure.core/let
    [credentials4393 (:credentials m4392) args4394 (:args m4392)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4395
      (com.palletops.awaze.common/aws-client :ec2 credentials4393)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4395
       createRouteTable
       (ec2/create-route-table-request (clojure.core/nth args4394 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRouteTable"}
   [credentials4397 & args4398]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4399
     (com.palletops.awaze.common/aws-client :ec2 credentials4397)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4399
      createRouteTable
      (ec2/create-route-table-request (clojure.core/nth args4398 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-hosts
   [m4400]
   (clojure.core/let
    [credentials4401 (:credentials m4400) args4402 (:args m4400)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4403
      (com.palletops.awaze.common/aws-client :ec2 credentials4401)]
     (clojure.core/case
      (clojure.core/count args4402)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4403
        describeHosts))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4403
        describeHosts
        (ec2/describe-hosts-request (clojure.core/nth args4402 0))))))))
  (clojure.core/defn
   describe-hosts-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeHosts, describeHosts"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-hosts
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeHosts, describeHosts"}
   [credentials4405 & args4406]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4407
     (com.palletops.awaze.common/aws-client :ec2 credentials4405)]
    (clojure.core/case
     (clojure.core/count args4406)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4407
       describeHosts))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4407
       describeHosts
       (ec2/describe-hosts-request (clojure.core/nth args4406 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m4408]
   (clojure.core/let
    [credentials4409 (:credentials m4408) args4410 (:args m4408)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4411
      (com.palletops.awaze.common/aws-client :ec2 credentials4409)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4411
       describeVolumeAttribute
       (ec2/describe-volume-attribute-request
        (clojure.core/nth args4410 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volume-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials4413 & args4414]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4415
     (com.palletops.awaze.common/aws-client :ec2 credentials4413)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4415
      describeVolumeAttribute
      (ec2/describe-volume-attribute-request
       (clojure.core/nth args4414 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-id-format
   [m4416]
   (clojure.core/let
    [credentials4417 (:credentials m4416) args4418 (:args m4416)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4419
      (com.palletops.awaze.common/aws-client :ec2 credentials4417)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4419
       modifyIdFormat
       (ec2/modify-id-format-request (clojure.core/nth args4418 0)))))))
  (clojure.core/defn
   modify-id-format-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyIdFormat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-id-format
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyIdFormat"}
   [credentials4421 & args4422]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4423
     (com.palletops.awaze.common/aws-client :ec2 credentials4421)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4423
      modifyIdFormat
      (ec2/modify-id-format-request (clojure.core/nth args4422 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m4424]
   (clojure.core/let
    [credentials4425 (:credentials m4424) args4426 (:args m4424)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4427
      (com.palletops.awaze.common/aws-client :ec2 credentials4425)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4427
       createNetworkAclEntry
       (ec2/create-network-acl-entry-request
        (clojure.core/nth args4426 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials4429 & args4430]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4431
     (com.palletops.awaze.common/aws-client :ec2 credentials4429)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4431
      createNetworkAclEntry
      (ec2/create-network-acl-entry-request
       (clojure.core/nth args4430 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-nat-gateways
   [m4432]
   (clojure.core/let
    [credentials4433 (:credentials m4432) args4434 (:args m4432)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4435
      (com.palletops.awaze.common/aws-client :ec2 credentials4433)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4435
       describeNatGateways
       (ec2/describe-nat-gateways-request
        (clojure.core/nth args4434 0)))))))
  (clojure.core/defn
   describe-nat-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeNatGateways"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-nat-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-nat-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeNatGateways"}
   [credentials4437 & args4438]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4439
     (com.palletops.awaze.common/aws-client :ec2 credentials4437)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4439
      describeNatGateways
      (ec2/describe-nat-gateways-request
       (clojure.core/nth args4438 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m4440]
   (clojure.core/let
    [credentials4441 (:credentials m4440) args4442 (:args m4440)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4443
      (com.palletops.awaze.common/aws-client :ec2 credentials4441)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4443
       cancelReservedInstancesListing
       (ec2/cancel-reserved-instances-listing-request
        (clojure.core/nth args4442 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials4445 & args4446]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4447
     (com.palletops.awaze.common/aws-client :ec2 credentials4445)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4447
      cancelReservedInstancesListing
      (ec2/cancel-reserved-instances-listing-request
       (clojure.core/nth args4446 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link
   [m4448]
   (clojure.core/let
    [credentials4449 (:credentials m4448) args4450 (:args m4448)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4451
      (com.palletops.awaze.common/aws-client :ec2 credentials4449)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4451
       disableVpcClassicLink
       (ec2/disable-vpc-classic-link-request
        (clojure.core/nth args4450 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLink"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLink"}
   [credentials4453 & args4454]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4455
     (com.palletops.awaze.common/aws-client :ec2 credentials4453)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4455
      disableVpcClassicLink
      (ec2/disable-vpc-classic-link-request
       (clojure.core/nth args4454 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-scheduled-instances
   [m4456]
   (clojure.core/let
    [credentials4457 (:credentials m4456) args4458 (:args m4456)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4459
      (com.palletops.awaze.common/aws-client :ec2 credentials4457)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4459
       runScheduledInstances
       (ec2/run-scheduled-instances-request
        (clojure.core/nth args4458 0)))))))
  (clojure.core/defn
   run-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for runScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call runScheduledInstances"}
   [credentials4461 & args4462]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4463
     (com.palletops.awaze.common/aws-client :ec2 credentials4461)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4463
      runScheduledInstances
      (ec2/run-scheduled-instances-request
       (clojure.core/nth args4462 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m4464]
   (clojure.core/let
    [credentials4465 (:credentials m4464) args4466 (:args m4464)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4467
      (com.palletops.awaze.common/aws-client :ec2 credentials4465)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4467
       deleteKeyPair
       (ec2/delete-key-pair-request (clojure.core/nth args4466 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteKeyPair"}
   [credentials4469 & args4470]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4471
     (com.palletops.awaze.common/aws-client :ec2 credentials4469)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4471
      deleteKeyPair
      (ec2/delete-key-pair-request (clojure.core/nth args4470 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m4472]
   (clojure.core/let
    [credentials4473 (:credentials m4472) args4474 (:args m4472)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4475
      (com.palletops.awaze.common/aws-client :ec2 credentials4473)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4475
       modifyReservedInstances
       (ec2/modify-reserved-instances-request
        (clojure.core/nth args4474 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials4477 & args4478]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4479
     (com.palletops.awaze.common/aws-client :ec2 credentials4477)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4479
      modifyReservedInstances
      (ec2/modify-reserved-instances-request
       (clojure.core/nth args4478 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m4480]
   (clojure.core/let
    [credentials4481 (:credentials m4480) args4482 (:args m4480)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4483
      (com.palletops.awaze.common/aws-client :ec2 credentials4481)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4483
       deleteVpnConnectionRoute
       (ec2/delete-vpn-connection-route-request
        (clojure.core/nth args4482 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials4485 & args4486]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4487
     (com.palletops.awaze.common/aws-client :ec2 credentials4485)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4487
      deleteVpnConnectionRoute
      (ec2/delete-vpn-connection-route-request
       (clojure.core/nth args4486 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m4488]
   (clojure.core/let
    [credentials4489 (:credentials m4488) args4490 (:args m4488)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4491
      (com.palletops.awaze.common/aws-client :ec2 credentials4489)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4491
       attachInternetGateway
       (ec2/attach-internet-gateway-request
        (clojure.core/nth args4490 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call attachInternetGateway"}
   [credentials4493 & args4494]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4495
     (com.palletops.awaze.common/aws-client :ec2 credentials4493)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4495
      attachInternetGateway
      (ec2/attach-internet-gateway-request
       (clojure.core/nth args4494 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m4496]
   (clojure.core/let
    [credentials4497 (:credentials m4496) args4498 (:args m4496)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4499
      (com.palletops.awaze.common/aws-client :ec2 credentials4497)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4499
       modifyNetworkInterfaceAttribute
       (ec2/modify-network-interface-attribute-request
        (clojure.core/nth args4498 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials4501 & args4502]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4503
     (com.palletops.awaze.common/aws-client :ec2 credentials4501)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4503
      modifyNetworkInterfaceAttribute
      (ec2/modify-network-interface-attribute-request
       (clojure.core/nth args4502 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m4504]
   (clojure.core/let
    [credentials4505 (:credentials m4504) args4506 (:args m4504)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4507
      (com.palletops.awaze.common/aws-client :ec2 credentials4505)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4507
       enableVgwRoutePropagation
       (ec2/enable-vgw-route-propagation-request
        (clojure.core/nth args4506 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials4509 & args4510]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4511
     (com.palletops.awaze.common/aws-client :ec2 credentials4509)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4511
      enableVgwRoutePropagation
      (ec2/enable-vgw-route-propagation-request
       (clojure.core/nth args4510 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m4512]
   (clojure.core/let
    [credentials4513 (:credentials m4512) args4514 (:args m4512)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4515
      (com.palletops.awaze.common/aws-client :ec2 credentials4513)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4515
       deleteNetworkAclEntry
       (ec2/delete-network-acl-entry-request
        (clojure.core/nth args4514 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials4517 & args4518]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4519
     (com.palletops.awaze.common/aws-client :ec2 credentials4517)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4519
      deleteNetworkAclEntry
      (ec2/delete-network-acl-entry-request
       (clojure.core/nth args4518 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m4520]
   (clojure.core/let
    [credentials4521 (:credentials m4520) args4522 (:args m4520)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4523
      (com.palletops.awaze.common/aws-client :ec2 credentials4521)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4523
       cancelExportTask
       (ec2/cancel-export-task-request (clojure.core/nth args4522 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-export-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelExportTask"}
   [credentials4525 & args4526]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4527
     (com.palletops.awaze.common/aws-client :ec2 credentials4525)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4527
      cancelExportTask
      (ec2/cancel-export-task-request (clojure.core/nth args4526 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m4528]
   (clojure.core/let
    [credentials4529 (:credentials m4528) args4530 (:args m4528)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4531
      (com.palletops.awaze.common/aws-client :ec2 credentials4529)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4531
       createImage
       (ec2/create-image-request (clojure.core/nth args4530 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createImage"}
   [credentials4533 & args4534]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4535
     (com.palletops.awaze.common/aws-client :ec2 credentials4533)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4535
      createImage
      (ec2/create-image-request (clojure.core/nth args4534 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-spot-fleet-request
   [m4536]
   (clojure.core/let
    [credentials4537 (:credentials m4536) args4538 (:args m4536)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4539
      (com.palletops.awaze.common/aws-client :ec2 credentials4537)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4539
       modifySpotFleetRequest
       (ec2/modify-spot-fleet-request-request
        (clojure.core/nth args4538 0)))))))
  (clojure.core/defn
   modify-spot-fleet-request-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Generate map for modifySpotFleetRequest"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-spot-fleet-request,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-spot-fleet-request
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Call modifySpotFleetRequest"}
   [credentials4541 & args4542]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4543
     (com.palletops.awaze.common/aws-client :ec2 credentials4541)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4543
      modifySpotFleetRequest
      (ec2/modify-spot-fleet-request-request
       (clojure.core/nth args4542 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-snapshot-tasks
   [m4544]
   (clojure.core/let
    [credentials4545 (:credentials m4544) args4546 (:args m4544)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4547
      (com.palletops.awaze.common/aws-client :ec2 credentials4545)]
     (clojure.core/case
      (clojure.core/count args4546)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4547
        describeImportSnapshotTasks
        (ec2/describe-import-snapshot-tasks-request
         (clojure.core/nth args4546 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4547
        describeImportSnapshotTasks))))))
  (clojure.core/defn
   describe-import-snapshot-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeImportSnapshotTasks, describeImportSnapshotTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-snapshot-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeImportSnapshotTasks, describeImportSnapshotTasks"}
   [credentials4549 & args4550]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4551
     (com.palletops.awaze.common/aws-client :ec2 credentials4549)]
    (clojure.core/case
     (clojure.core/count args4550)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4551
       describeImportSnapshotTasks
       (ec2/describe-import-snapshot-tasks-request
        (clojure.core/nth args4550 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4551
       describeImportSnapshotTasks)))))))
