(ns
 com.palletops.awaze.directconnect
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.directconnect :as directconnect]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.RouteFilterPrefix}
route-filter-prefix
  [m11773]
  (clojure.core/let
   [bean11772
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/let
    [v11774 (:cidr m11773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11774 :com.palletops.awaze.client-builder/undef)
     (. bean11772 setCidr (clojure.core/str v11774))))
   bean11772))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation}
new-private-virtual-interface-allocation
  [m11776]
  (clojure.core/let
   [bean11775
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11777 (:vlan m11776 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (. bean11775 setVlan (clojure.core/int v11777))))
   (clojure.core/let
    [v11777
     (:virtual-interface-name
      m11776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (. bean11775 setVirtualInterfaceName (clojure.core/str v11777))))
   (clojure.core/let
    [v11777 (:asn m11776 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (. bean11775 setAsn (clojure.core/int v11777))))
   (clojure.core/let
    [v11777
     (:auth-key m11776 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (. bean11775 setAuthKey (clojure.core/str v11777))))
   (clojure.core/let
    [v11777
     (:amazon-address
      m11776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (. bean11775 setAmazonAddress (clojure.core/str v11777))))
   (clojure.core/let
    [v11777
     (:customer-address
      m11776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (. bean11775 setCustomerAddress (clojure.core/str v11777))))
   bean11775))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation}
new-public-virtual-interface-allocation
  [m11779]
  (clojure.core/let
   [bean11778
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11780 (:vlan m11779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (. bean11778 setVlan (clojure.core/int v11780))))
   (clojure.core/let
    [v11780
     (:virtual-interface-name
      m11779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (. bean11778 setVirtualInterfaceName (clojure.core/str v11780))))
   (clojure.core/let
    [v11780 (:asn m11779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (. bean11778 setAsn (clojure.core/int v11780))))
   (clojure.core/let
    [v11780
     (:auth-key m11779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (. bean11778 setAuthKey (clojure.core/str v11780))))
   (clojure.core/let
    [v11780
     (:amazon-address
      m11779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (. bean11778 setAmazonAddress (clojure.core/str v11780))))
   (clojure.core/let
    [v11780
     (:customer-address
      m11779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (. bean11778 setCustomerAddress (clojure.core/str v11780))))
   (clojure.core/let
    [v11780
     (:route-filter-prefixes
      m11779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (.
      bean11778
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11844]
  (directconnect/route-filter-prefix arg11844))
 v11780))))
   bean11778))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface}
new-private-virtual-interface
  [m11782]
  (clojure.core/let
   [bean11781
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/let
    [v11783 (:vlan m11782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setVlan (clojure.core/int v11783))))
   (clojure.core/let
    [v11783
     (:virtual-gateway-id
      m11782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setVirtualGatewayId (clojure.core/str v11783))))
   (clojure.core/let
    [v11783
     (:virtual-interface-name
      m11782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setVirtualInterfaceName (clojure.core/str v11783))))
   (clojure.core/let
    [v11783 (:asn m11782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setAsn (clojure.core/int v11783))))
   (clojure.core/let
    [v11783
     (:auth-key m11782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setAuthKey (clojure.core/str v11783))))
   (clojure.core/let
    [v11783
     (:amazon-address
      m11782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setAmazonAddress (clojure.core/str v11783))))
   (clojure.core/let
    [v11783
     (:customer-address
      m11782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setCustomerAddress (clojure.core/str v11783))))
   bean11781))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterface}
new-public-virtual-interface
  [m11785]
  (clojure.core/let
   [bean11784
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/let
    [v11786 (:vlan m11785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setVlan (clojure.core/int v11786))))
   (clojure.core/let
    [v11786
     (:virtual-interface-name
      m11785
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setVirtualInterfaceName (clojure.core/str v11786))))
   (clojure.core/let
    [v11786 (:asn m11785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setAsn (clojure.core/int v11786))))
   (clojure.core/let
    [v11786
     (:auth-key m11785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setAuthKey (clojure.core/str v11786))))
   (clojure.core/let
    [v11786
     (:amazon-address
      m11785
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setAmazonAddress (clojure.core/str v11786))))
   (clojure.core/let
    [v11786
     (:customer-address
      m11785
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setCustomerAddress (clojure.core/str v11786))))
   (clojure.core/let
    [v11786
     (:route-filter-prefixes
      m11785
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (.
      bean11784
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11845]
  (directconnect/route-filter-prefix arg11845))
 v11786))))
   bean11784))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest}
describe-connections-on-interconnect-request
  [m11788]
  (clojure.core/let
   [bean11787
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/let
    [v11789
     (:interconnect-id
      m11788
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11789 :com.palletops.awaze.client-builder/undef)
     (. bean11787 setInterconnectId (clojure.core/str v11789))))
   bean11787))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest}
allocate-private-virtual-interface-request
  [m11791]
  (clojure.core/let
   [bean11790
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11792
     (:new-private-virtual-interface-allocation
      m11791
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11792 :com.palletops.awaze.client-builder/undef)
     (.
      bean11790
      setNewPrivateVirtualInterfaceAllocation
      (directconnect/new-private-virtual-interface-allocation v11792))))
   (clojure.core/let
    [v11792
     (:connection-id m11791 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11792 :com.palletops.awaze.client-builder/undef)
     (. bean11790 setConnectionId (clojure.core/str v11792))))
   (clojure.core/let
    [v11792
     (:owner-account m11791 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11792 :com.palletops.awaze.client-builder/undef)
     (. bean11790 setOwnerAccount (clojure.core/str v11792))))
   bean11790))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest}
describe-virtual-interfaces-request
  [m11794]
  (clojure.core/let
   [bean11793
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/let
    [v11795
     (:virtual-interface-id
      m11794
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11795 :com.palletops.awaze.client-builder/undef)
     (. bean11793 setVirtualInterfaceId (clojure.core/str v11795))))
   (clojure.core/let
    [v11795
     (:connection-id m11794 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11795 :com.palletops.awaze.client-builder/undef)
     (. bean11793 setConnectionId (clojure.core/str v11795))))
   bean11793))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest}
allocate-public-virtual-interface-request
  [m11797]
  (clojure.core/let
   [bean11796
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11798
     (:new-public-virtual-interface-allocation
      m11797
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11798 :com.palletops.awaze.client-builder/undef)
     (.
      bean11796
      setNewPublicVirtualInterfaceAllocation
      (directconnect/new-public-virtual-interface-allocation v11798))))
   (clojure.core/let
    [v11798
     (:connection-id m11797 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11798 :com.palletops.awaze.client-builder/undef)
     (. bean11796 setConnectionId (clojure.core/str v11798))))
   (clojure.core/let
    [v11798
     (:owner-account m11797 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11798 :com.palletops.awaze.client-builder/undef)
     (. bean11796 setOwnerAccount (clojure.core/str v11798))))
   bean11796))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest}
describe-interconnects-request
  [m11800]
  (clojure.core/let
   [bean11799
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/let
    [v11801
     (:interconnect-id
      m11800
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11801 :com.palletops.awaze.client-builder/undef)
     (. bean11799 setInterconnectId (clojure.core/str v11801))))
   bean11799))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest}
delete-virtual-interface-request
  [m11803]
  (clojure.core/let
   [bean11802
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/let
    [v11804
     (:virtual-interface-id
      m11803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11804 :com.palletops.awaze.client-builder/undef)
     (. bean11802 setVirtualInterfaceId (clojure.core/str v11804))))
   bean11802))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeLocationsRequest}
describe-locations-request
  [m11806]
  (clojure.core/let
   [bean11805
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean11805))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest}
allocate-connection-on-interconnect-request
  [m11809]
  (clojure.core/let
   [bean11808
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/let
    [v11810
     (:bandwidth m11809 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11810 :com.palletops.awaze.client-builder/undef)
     (. bean11808 setBandwidth (clojure.core/str v11810))))
   (clojure.core/let
    [v11810
     (:connection-name
      m11809
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11810 :com.palletops.awaze.client-builder/undef)
     (. bean11808 setConnectionName (clojure.core/str v11810))))
   (clojure.core/let
    [v11810
     (:interconnect-id
      m11809
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11810 :com.palletops.awaze.client-builder/undef)
     (. bean11808 setInterconnectId (clojure.core/str v11810))))
   (clojure.core/let
    [v11810 (:vlan m11809 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11810 :com.palletops.awaze.client-builder/undef)
     (. bean11808 setVlan (clojure.core/int v11810))))
   (clojure.core/let
    [v11810
     (:owner-account m11809 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11810 :com.palletops.awaze.client-builder/undef)
     (. bean11808 setOwnerAccount (clojure.core/str v11810))))
   bean11808))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateInterconnectRequest}
create-interconnect-request
  [m11812]
  (clojure.core/let
   [bean11811
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/let
    [v11813
     (:bandwidth m11812 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11813 :com.palletops.awaze.client-builder/undef)
     (. bean11811 setBandwidth (clojure.core/str v11813))))
   (clojure.core/let
    [v11813
     (:interconnect-name
      m11812
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11813 :com.palletops.awaze.client-builder/undef)
     (. bean11811 setInterconnectName (clojure.core/str v11813))))
   (clojure.core/let
    [v11813
     (:location m11812 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11813 :com.palletops.awaze.client-builder/undef)
     (. bean11811 setLocation (clojure.core/str v11813))))
   bean11811))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteConnectionRequest}
delete-connection-request
  [m11815]
  (clojure.core/let
   [bean11814
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/let
    [v11816
     (:connection-id m11815 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11816 :com.palletops.awaze.client-builder/undef)
     (. bean11814 setConnectionId (clojure.core/str v11816))))
   bean11814))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest}
create-private-virtual-interface-request
  [m11818]
  (clojure.core/let
   [bean11817
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11819
     (:new-private-virtual-interface
      m11818
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11819 :com.palletops.awaze.client-builder/undef)
     (.
      bean11817
      setNewPrivateVirtualInterface
      (directconnect/new-private-virtual-interface v11819))))
   (clojure.core/let
    [v11819
     (:connection-id m11818 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11819 :com.palletops.awaze.client-builder/undef)
     (. bean11817 setConnectionId (clojure.core/str v11819))))
   bean11817))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteInterconnectRequest}
delete-interconnect-request
  [m11821]
  (clojure.core/let
   [bean11820
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/let
    [v11822
     (:interconnect-id
      m11821
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11822 :com.palletops.awaze.client-builder/undef)
     (. bean11820 setInterconnectId (clojure.core/str v11822))))
   bean11820))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest}
create-public-virtual-interface-request
  [m11824]
  (clojure.core/let
   [bean11823
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11825
     (:new-public-virtual-interface
      m11824
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11825 :com.palletops.awaze.client-builder/undef)
     (.
      bean11823
      setNewPublicVirtualInterface
      (directconnect/new-public-virtual-interface v11825))))
   (clojure.core/let
    [v11825
     (:connection-id m11824 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11825 :com.palletops.awaze.client-builder/undef)
     (. bean11823 setConnectionId (clojure.core/str v11825))))
   bean11823))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateConnectionRequest}
create-connection-request
  [m11827]
  (clojure.core/let
   [bean11826
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/let
    [v11828
     (:bandwidth m11827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11828 :com.palletops.awaze.client-builder/undef)
     (. bean11826 setBandwidth (clojure.core/str v11828))))
   (clojure.core/let
    [v11828
     (:connection-name
      m11827
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11828 :com.palletops.awaze.client-builder/undef)
     (. bean11826 setConnectionName (clojure.core/str v11828))))
   (clojure.core/let
    [v11828
     (:location m11827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11828 :com.palletops.awaze.client-builder/undef)
     (. bean11826 setLocation (clojure.core/str v11828))))
   bean11826))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmConnectionRequest}
confirm-connection-request
  [m11830]
  (clojure.core/let
   [bean11829
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/let
    [v11831
     (:connection-id m11830 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11831 :com.palletops.awaze.client-builder/undef)
     (. bean11829 setConnectionId (clojure.core/str v11831))))
   bean11829))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest}
describe-virtual-gateways-request
  [m11833]
  (clojure.core/let
   [bean11832
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean11832))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsRequest}
describe-connections-request
  [m11836]
  (clojure.core/let
   [bean11835
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/let
    [v11837
     (:connection-id m11836 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11837 :com.palletops.awaze.client-builder/undef)
     (. bean11835 setConnectionId (clojure.core/str v11837))))
   bean11835))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest}
confirm-public-virtual-interface-request
  [m11839]
  (clojure.core/let
   [bean11838
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11840
     (:virtual-interface-id
      m11839
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11840 :com.palletops.awaze.client-builder/undef)
     (. bean11838 setVirtualInterfaceId (clojure.core/str v11840))))
   bean11838))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest}
confirm-private-virtual-interface-request
  [m11842]
  (clojure.core/let
   [bean11841
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11843
     (:virtual-interface-id
      m11842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11843 :com.palletops.awaze.client-builder/undef)
     (. bean11841 setVirtualInterfaceId (clojure.core/str v11843))))
   (clojure.core/let
    [v11843
     (:virtual-gateway-id
      m11842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11843 :com.palletops.awaze.client-builder/undef)
     (. bean11841 setVirtualGatewayId (clojure.core/str v11843))))
   bean11841))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m11846]
   (clojure.core/let
    [credentials11847 (:credentials m11846) args11848 (:args m11846)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11849
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11847)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11849
       describeConnectionsOnInterconnect
       (directconnect/describe-connections-on-interconnect-request
        (clojure.core/nth args11848 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials11851 & args11852]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11853
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11851)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11853
      describeConnectionsOnInterconnect
      (directconnect/describe-connections-on-interconnect-request
       (clojure.core/nth args11852 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m11854]
   (clojure.core/let
    [credentials11855 (:credentials m11854) args11856 (:args m11854)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11857
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11855)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11857
       allocatePrivateVirtualInterface
       (directconnect/allocate-private-virtual-interface-request
        (clojure.core/nth args11856 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials11859 & args11860]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11861
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11859)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11861
      allocatePrivateVirtualInterface
      (directconnect/allocate-private-virtual-interface-request
       (clojure.core/nth args11860 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m11862]
   (clojure.core/let
    [credentials11863 (:credentials m11862) args11864 (:args m11862)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11865
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11863)]
     (clojure.core/case
      (clojure.core/count args11864)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11865
        describeVirtualInterfaces
        (directconnect/describe-virtual-interfaces-request
         (clojure.core/nth args11864 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11865
        describeVirtualInterfaces))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials11867 & args11868]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11869
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11867)]
    (clojure.core/case
     (clojure.core/count args11868)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11869
       describeVirtualInterfaces
       (directconnect/describe-virtual-interfaces-request
        (clojure.core/nth args11868 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11869
       describeVirtualInterfaces))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m11870]
   (clojure.core/let
    [credentials11871 (:credentials m11870) args11872 (:args m11870)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11873
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11871)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11873
       allocatePublicVirtualInterface
       (directconnect/allocate-public-virtual-interface-request
        (clojure.core/nth args11872 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials11875 & args11876]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11877
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11875)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11877
      allocatePublicVirtualInterface
      (directconnect/allocate-public-virtual-interface-request
       (clojure.core/nth args11876 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m11878]
   (clojure.core/let
    [credentials11879 (:credentials m11878) args11880 (:args m11878)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11881
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11879)]
     (clojure.core/case
      (clojure.core/count args11880)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11881
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11881
        describeInterconnects
        (directconnect/describe-interconnects-request
         (clojure.core/nth args11880 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-interconnects,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-interconnects,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials11883 & args11884]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11885
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11883)]
    (clojure.core/case
     (clojure.core/count args11884)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11885
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11885
       describeInterconnects
       (directconnect/describe-interconnects-request
        (clojure.core/nth args11884 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m11886]
   (clojure.core/let
    [credentials11887 (:credentials m11886) args11888 (:args m11886)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11889
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11887)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11889
       deleteVirtualInterface
       (directconnect/delete-virtual-interface-request
        (clojure.core/nth args11888 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials11891 & args11892]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11893
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11891)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11893
      deleteVirtualInterface
      (directconnect/delete-virtual-interface-request
       (clojure.core/nth args11892 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m11894]
   (clojure.core/let
    [credentials11895 (:credentials m11894) args11896 (:args m11894)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11897
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11895)]
     (clojure.core/case
      (clojure.core/count args11896)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11897
        describeLocations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11897
        describeLocations
        (directconnect/describe-locations-request
         (clojure.core/nth args11896 0))))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-locations,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-locations,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials11899 & args11900]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11901
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11899)]
    (clojure.core/case
     (clojure.core/count args11900)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11901
       describeLocations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11901
       describeLocations
       (directconnect/describe-locations-request
        (clojure.core/nth args11900 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m11902]
   (clojure.core/let
    [credentials11903 (:credentials m11902) args11904 (:args m11902)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11905
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11903)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11905
       allocateConnectionOnInterconnect
       (directconnect/allocate-connection-on-interconnect-request
        (clojure.core/nth args11904 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials11907 & args11908]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11909
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11907)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11909
      allocateConnectionOnInterconnect
      (directconnect/allocate-connection-on-interconnect-request
       (clojure.core/nth args11908 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m11910]
   (clojure.core/let
    [credentials11911 (:credentials m11910) args11912 (:args m11910)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11913
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11911)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11913
       createInterconnect
       (directconnect/create-interconnect-request
        (clojure.core/nth args11912 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Call createInterconnect"}
   [credentials11915 & args11916]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11917
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11915)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11917
      createInterconnect
      (directconnect/create-interconnect-request
       (clojure.core/nth args11916 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m11918]
   (clojure.core/let
    [credentials11919 (:credentials m11918) args11920 (:args m11918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11921
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11919)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11921
       deleteConnection
       (directconnect/delete-connection-request
        (clojure.core/nth args11920 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConnection"}
   [credentials11923 & args11924]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11925
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11923)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11925
      deleteConnection
      (directconnect/delete-connection-request
       (clojure.core/nth args11924 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m11926]
   (clojure.core/let
    [credentials11927 (:credentials m11926) args11928 (:args m11926)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11929
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11927)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11929
       createPrivateVirtualInterface
       (directconnect/create-private-virtual-interface-request
        (clojure.core/nth args11928 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials11931 & args11932]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11933
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11931)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11933
      createPrivateVirtualInterface
      (directconnect/create-private-virtual-interface-request
       (clojure.core/nth args11932 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m11934]
   (clojure.core/let
    [credentials11935 (:credentials m11934) args11936 (:args m11934)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11937
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11935)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11937
       deleteInterconnect
       (directconnect/delete-interconnect-request
        (clojure.core/nth args11936 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInterconnect"}
   [credentials11939 & args11940]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11941
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11939)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11941
      deleteInterconnect
      (directconnect/delete-interconnect-request
       (clojure.core/nth args11940 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m11942]
   (clojure.core/let
    [credentials11943 (:credentials m11942) args11944 (:args m11942)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11945
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11943)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11945
       createPublicVirtualInterface
       (directconnect/create-public-virtual-interface-request
        (clojure.core/nth args11944 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials11947 & args11948]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11949
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11947)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11949
      createPublicVirtualInterface
      (directconnect/create-public-virtual-interface-request
       (clojure.core/nth args11948 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m11950]
   (clojure.core/let
    [credentials11951 (:credentials m11950) args11952 (:args m11950)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11953
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11951)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11953
       createConnection
       (directconnect/create-connection-request
        (clojure.core/nth args11952 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Call createConnection"}
   [credentials11955 & args11956]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11957
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11955)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11957
      createConnection
      (directconnect/create-connection-request
       (clojure.core/nth args11956 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m11958]
   (clojure.core/let
    [credentials11959 (:credentials m11958) args11960 (:args m11958)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11961
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11959)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11961
       confirmConnection
       (directconnect/confirm-connection-request
        (clojure.core/nth args11960 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmConnection"}
   [credentials11963 & args11964]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11965
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11963)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11965
      confirmConnection
      (directconnect/confirm-connection-request
       (clojure.core/nth args11964 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m11966]
   (clojure.core/let
    [credentials11967 (:credentials m11966) args11968 (:args m11966)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11969
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11967)]
     (clojure.core/case
      (clojure.core/count args11968)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11969
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11969
        describeVirtualGateways
        (directconnect/describe-virtual-gateways-request
         (clojure.core/nth args11968 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-virtual-gateways,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-virtual-gateways,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials11971 & args11972]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11973
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11971)]
    (clojure.core/case
     (clojure.core/count args11972)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11973
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11973
       describeVirtualGateways
       (directconnect/describe-virtual-gateways-request
        (clojure.core/nth args11972 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m11974]
   (clojure.core/let
    [credentials11975 (:credentials m11974) args11976 (:args m11974)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11977
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11975)]
     (clojure.core/case
      (clojure.core/count args11976)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11977
        describeConnections
        (directconnect/describe-connections-request
         (clojure.core/nth args11976 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11977
        describeConnections))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-connections,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-connections,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials11979 & args11980]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11981
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11979)]
    (clojure.core/case
     (clojure.core/count args11980)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11981
       describeConnections
       (directconnect/describe-connections-request
        (clojure.core/nth args11980 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11981
       describeConnections))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m11982]
   (clojure.core/let
    [credentials11983 (:credentials m11982) args11984 (:args m11982)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11985
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11983)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11985
       confirmPublicVirtualInterface
       (directconnect/confirm-public-virtual-interface-request
        (clojure.core/nth args11984 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials11987 & args11988]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11989
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11987)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11989
      confirmPublicVirtualInterface
      (directconnect/confirm-public-virtual-interface-request
       (clojure.core/nth args11988 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m11990]
   (clojure.core/let
    [credentials11991 (:credentials m11990) args11992 (:args m11990)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11993
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11991)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11993
       confirmPrivateVirtualInterface
       (directconnect/confirm-private-virtual-interface-request
        (clojure.core/nth args11992 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials11995 & args11996]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11997
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11995)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11997
      confirmPrivateVirtualInterface
      (directconnect/confirm-private-virtual-interface-request
       (clojure.core/nth args11996 0))))))))
