(ns
 com.palletops.awaze.datapipeline
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.datapipeline :as datapipeline]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Operator}
operator
  [m7628]
  (clojure.core/let
   [bean7627 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/let
    [v7629 (:values m7628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7629 :com.palletops.awaze.client-builder/undef)
     (.
      bean7627
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7717] (clojure.core/str arg7717))
 v7629))))
   (clojure.core/let
    [v7629 (:type m7628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7629 :com.palletops.awaze.client-builder/undef)
     (. bean7627 setType (clojure.core/str v7629))))
   bean7627))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterAttribute}
parameter-attribute
  [m7631]
  (clojure.core/let
   [bean7630
    (new com.amazonaws.services.datapipeline.model.ParameterAttribute)]
   (clojure.core/let
    [v7632
     (:string-value m7631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7632 :com.palletops.awaze.client-builder/undef)
     (. bean7630 setStringValue (clojure.core/str v7632))))
   (clojure.core/let
    [v7632 (:key m7631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7632 :com.palletops.awaze.client-builder/undef)
     (. bean7630 setKey (clojure.core/str v7632))))
   bean7630))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Field}
field
  [m7634]
  (clojure.core/let
   [bean7633 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/let
    [v7635
     (:string-value m7634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7635 :com.palletops.awaze.client-builder/undef)
     (. bean7633 setStringValue (clojure.core/str v7635))))
   (clojure.core/let
    [v7635 (:key m7634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7635 :com.palletops.awaze.client-builder/undef)
     (. bean7633 setKey (clojure.core/str v7635))))
   (clojure.core/let
    [v7635
     (:ref-value m7634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7635 :com.palletops.awaze.client-builder/undef)
     (. bean7633 setRefValue (clojure.core/str v7635))))
   bean7633))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Selector}
selector
  [m7637]
  (clojure.core/let
   [bean7636 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/let
    [v7638
     (:field-name m7637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7638 :com.palletops.awaze.client-builder/undef)
     (. bean7636 setFieldName (clojure.core/str v7638))))
   (clojure.core/let
    [v7638
     (:operator m7637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7638 :com.palletops.awaze.client-builder/undef)
     (. bean7636 setOperator (datapipeline/operator v7638))))
   bean7636))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterObject}
parameter-object
  [m7640]
  (clojure.core/let
   [bean7639
    (new com.amazonaws.services.datapipeline.model.ParameterObject)]
   (clojure.core/let
    [v7641
     (:attributes m7640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (.
      bean7639
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg7718]
  (datapipeline/parameter-attribute arg7718))
 v7641))))
   (clojure.core/let
    [v7641 (:id m7640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (. bean7639 setId (clojure.core/str v7641))))
   bean7639))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PipelineObject}
pipeline-object
  [m7643]
  (clojure.core/let
   [bean7642
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/let
    [v7644 (:fields m7643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7644 :com.palletops.awaze.client-builder/undef)
     (.
      bean7642
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7719] (datapipeline/field arg7719))
 v7644))))
   (clojure.core/let
    [v7644 (:id m7643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7644 :com.palletops.awaze.client-builder/undef)
     (. bean7642 setId (clojure.core/str v7644))))
   (clojure.core/let
    [v7644 (:name m7643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7644 :com.palletops.awaze.client-builder/undef)
     (. bean7642 setName (clojure.core/str v7644))))
   bean7642))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterValue}
parameter-value
  [m7646]
  (clojure.core/let
   [bean7645
    (new com.amazonaws.services.datapipeline.model.ParameterValue)]
   (clojure.core/let
    [v7647
     (:string-value m7646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7647 :com.palletops.awaze.client-builder/undef)
     (. bean7645 setStringValue (clojure.core/str v7647))))
   (clojure.core/let
    [v7647 (:id m7646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7647 :com.palletops.awaze.client-builder/undef)
     (. bean7645 setId (clojure.core/str v7647))))
   bean7645))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.InstanceIdentity}
instance-identity
  [m7649]
  (clojure.core/let
   [bean7648
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/let
    [v7650
     (:document m7649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (. bean7648 setDocument (clojure.core/str v7650))))
   (clojure.core/let
    [v7650
     (:signature m7649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (. bean7648 setSignature (clojure.core/str v7650))))
   bean7648))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Tag}
tag
  [m7652]
  (clojure.core/let
   [bean7651 (new com.amazonaws.services.datapipeline.model.Tag)]
   (clojure.core/let
    [v7653 (:key m7652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (. bean7651 setKey (clojure.core/str v7653))))
   (clojure.core/let
    [v7653 (:value m7652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (. bean7651 setValue (clojure.core/str v7653))))
   bean7651))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Query}
query
  [m7655]
  (clojure.core/let
   [bean7654 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/let
    [v7656
     (:selectors m7655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7656 :com.palletops.awaze.client-builder/undef)
     (.
      bean7654
      setSelectors
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7720] (datapipeline/selector arg7720))
 v7656))))
   bean7654))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.TaskStatus}
task-status
  [m7658]
  (.
   com.amazonaws.services.datapipeline.model.TaskStatus
   fromValue
   (clojure.core/name m7658)))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest}
get-pipeline-definition-request
  [m7661]
  (clojure.core/let
   [bean7660
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/let
    [v7662 (:version m7661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (. bean7660 setVersion (clojure.core/str v7662))))
   (clojure.core/let
    [v7662
     (:pipeline-id m7661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (. bean7660 setPipelineId (clojure.core/str v7662))))
   bean7660))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest}
validate-pipeline-definition-request
  [m7664]
  (clojure.core/let
   [bean7663
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/let
    [v7665
     (:pipeline-id m7664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (. bean7663 setPipelineId (clojure.core/str v7665))))
   (clojure.core/let
    [v7665
     (:parameter-objects
      m7664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (.
      bean7663
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7721] (datapipeline/parameter-object arg7721))
 v7665))))
   (clojure.core/let
    [v7665
     (:pipeline-objects
      m7664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (.
      bean7663
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7722] (datapipeline/pipeline-object arg7722))
 v7665))))
   (clojure.core/let
    [v7665
     (:parameter-values
      m7664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (.
      bean7663
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7723] (datapipeline/parameter-value arg7723))
 v7665))))
   bean7663))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest}
report-task-progress-request
  [m7667]
  (clojure.core/let
   [bean7666
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/let
    [v7668 (:fields m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (.
      bean7666
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7724] (datapipeline/field arg7724))
 v7668))))
   (clojure.core/let
    [v7668 (:task-id m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setTaskId (clojure.core/str v7668))))
   bean7666))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.RemoveTagsRequest}
remove-tags-request
  [m7670]
  (clojure.core/let
   [bean7669
    (new com.amazonaws.services.datapipeline.model.RemoveTagsRequest)]
   (clojure.core/let
    [v7671
     (:pipeline-id m7670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7671 :com.palletops.awaze.client-builder/undef)
     (. bean7669 setPipelineId (clojure.core/str v7671))))
   (clojure.core/let
    [v7671
     (:tag-keys m7670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7671 :com.palletops.awaze.client-builder/undef)
     (.
      bean7669
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7725] (clojure.core/str arg7725))
 v7671))))
   bean7669))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribePipelinesRequest}
describe-pipelines-request
  [m7673]
  (clojure.core/let
   [bean7672
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/let
    [v7674
     (:pipeline-ids m7673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7674 :com.palletops.awaze.client-builder/undef)
     (.
      bean7672
      setPipelineIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7726] (clojure.core/str arg7726))
 v7674))))
   bean7672))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PollForTaskRequest}
poll-for-task-request
  [m7676]
  (clojure.core/let
   [bean7675
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/let
    [v7677
     (:hostname m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setHostname (clojure.core/str v7677))))
   (clojure.core/let
    [v7677
     (:worker-group m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setWorkerGroup (clojure.core/str v7677))))
   (clojure.core/let
    [v7677
     (:instance-identity
      m7676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (.
      bean7675
      setInstanceIdentity
      (datapipeline/instance-identity v7677))))
   bean7675))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.AddTagsRequest}
add-tags-request
  [m7679]
  (clojure.core/let
   [bean7678
    (new com.amazonaws.services.datapipeline.model.AddTagsRequest)]
   (clojure.core/let
    [v7680
     (:pipeline-id m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setPipelineId (clojure.core/str v7680))))
   (clojure.core/let
    [v7680 (:tags m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (.
      bean7678
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7727] (datapipeline/tag arg7727))
 v7680))))
   bean7678))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.QueryObjectsRequest}
query-objects-request
  [m7682]
  (clojure.core/let
   [bean7681
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/let
    [v7683 (:limit m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setLimit (clojure.core/int v7683))))
   (clojure.core/let
    [v7683
     (:pipeline-id m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setPipelineId (clojure.core/str v7683))))
   (clojure.core/let
    [v7683 (:marker m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setMarker (clojure.core/str v7683))))
   (clojure.core/let
    [v7683 (:query m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setQuery (datapipeline/query v7683))))
   (clojure.core/let
    [v7683 (:sphere m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setSphere (clojure.core/str v7683))))
   bean7681))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ListPipelinesRequest}
list-pipelines-request
  [m7685]
  (clojure.core/let
   [bean7684
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/let
    [v7686 (:marker m7685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (. bean7684 setMarker (clojure.core/str v7686))))
   bean7684))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest}
report-task-runner-heartbeat-request
  [m7688]
  (clojure.core/let
   [bean7687
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/let
    [v7689
     (:taskrunner-id m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setTaskrunnerId (clojure.core/str v7689))))
   (clojure.core/let
    [v7689
     (:hostname m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setHostname (clojure.core/str v7689))))
   (clojure.core/let
    [v7689
     (:worker-group m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setWorkerGroup (clojure.core/str v7689))))
   bean7687))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetTaskStatusRequest}
set-task-status-request
  [m7691]
  (clojure.core/let
   [bean7690
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/let
    [v7692
     (:error-stack-trace
      m7691
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setErrorStackTrace (clojure.core/str v7692))))
   (clojure.core/let
    [v7692
     (:error-message m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setErrorMessage (clojure.core/str v7692))))
   (clojure.core/let
    [v7692
     (:task-status m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setTaskStatus (datapipeline/task-status v7692))))
   (clojure.core/let
    [v7692
     (:error-id m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setErrorId (clojure.core/str v7692))))
   (clojure.core/let
    [v7692 (:task-id m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setTaskId (clojure.core/str v7692))))
   bean7690))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.CreatePipelineRequest}
create-pipeline-request
  [m7694]
  (clojure.core/let
   [bean7693
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/let
    [v7695
     (:description m7694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7695 :com.palletops.awaze.client-builder/undef)
     (. bean7693 setDescription (clojure.core/str v7695))))
   (clojure.core/let
    [v7695
     (:unique-id m7694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7695 :com.palletops.awaze.client-builder/undef)
     (. bean7693 setUniqueId (clojure.core/str v7695))))
   (clojure.core/let
    [v7695 (:tags m7694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7695 :com.palletops.awaze.client-builder/undef)
     (.
      bean7693
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7728] (datapipeline/tag arg7728))
 v7695))))
   (clojure.core/let
    [v7695 (:name m7694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7695 :com.palletops.awaze.client-builder/undef)
     (. bean7693 setName (clojure.core/str v7695))))
   bean7693))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeletePipelineRequest}
delete-pipeline-request
  [m7697]
  (clojure.core/let
   [bean7696
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/let
    [v7698
     (:pipeline-id m7697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (. bean7696 setPipelineId (clojure.core/str v7698))))
   bean7696))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest}
put-pipeline-definition-request
  [m7700]
  (clojure.core/let
   [bean7699
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/let
    [v7701
     (:pipeline-id m7700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (. bean7699 setPipelineId (clojure.core/str v7701))))
   (clojure.core/let
    [v7701
     (:parameter-objects
      m7700
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (.
      bean7699
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7729] (datapipeline/parameter-object arg7729))
 v7701))))
   (clojure.core/let
    [v7701
     (:pipeline-objects
      m7700
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (.
      bean7699
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7730] (datapipeline/pipeline-object arg7730))
 v7701))))
   (clojure.core/let
    [v7701
     (:parameter-values
      m7700
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (.
      bean7699
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7731] (datapipeline/parameter-value arg7731))
 v7701))))
   bean7699))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest}
deactivate-pipeline-request
  [m7703]
  (clojure.core/let
   [bean7702
    (new
     com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest)]
   (clojure.core/let
    [v7704
     (:pipeline-id m7703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7704 :com.palletops.awaze.client-builder/undef)
     (. bean7702 setPipelineId (clojure.core/str v7704))))
   (clojure.core/let
    [v7704
     (:cancel-active m7703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7704 :com.palletops.awaze.client-builder/undef)
     (. bean7702 setCancelActive (clojure.core/boolean v7704))))
   bean7702))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetStatusRequest}
set-status-request
  [m7706]
  (clojure.core/let
   [bean7705
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/let
    [v7707
     (:pipeline-id m7706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7707 :com.palletops.awaze.client-builder/undef)
     (. bean7705 setPipelineId (clojure.core/str v7707))))
   (clojure.core/let
    [v7707 (:status m7706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7707 :com.palletops.awaze.client-builder/undef)
     (. bean7705 setStatus (clojure.core/str v7707))))
   (clojure.core/let
    [v7707
     (:object-ids m7706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7707 :com.palletops.awaze.client-builder/undef)
     (.
      bean7705
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7732] (clojure.core/str arg7732))
 v7707))))
   bean7705))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest}
evaluate-expression-request
  [m7709]
  (clojure.core/let
   [bean7708
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/let
    [v7710
     (:pipeline-id m7709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7710 :com.palletops.awaze.client-builder/undef)
     (. bean7708 setPipelineId (clojure.core/str v7710))))
   (clojure.core/let
    [v7710
     (:object-id m7709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7710 :com.palletops.awaze.client-builder/undef)
     (. bean7708 setObjectId (clojure.core/str v7710))))
   (clojure.core/let
    [v7710
     (:expression m7709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7710 :com.palletops.awaze.client-builder/undef)
     (. bean7708 setExpression (clojure.core/str v7710))))
   bean7708))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribeObjectsRequest}
describe-objects-request
  [m7712]
  (clojure.core/let
   [bean7711
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/let
    [v7713
     (:pipeline-id m7712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7713 :com.palletops.awaze.client-builder/undef)
     (. bean7711 setPipelineId (clojure.core/str v7713))))
   (clojure.core/let
    [v7713
     (:evaluate-expressions
      m7712
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7713 :com.palletops.awaze.client-builder/undef)
     (. bean7711 setEvaluateExpressions (clojure.core/boolean v7713))))
   (clojure.core/let
    [v7713 (:marker m7712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7713 :com.palletops.awaze.client-builder/undef)
     (. bean7711 setMarker (clojure.core/str v7713))))
   (clojure.core/let
    [v7713
     (:object-ids m7712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7713 :com.palletops.awaze.client-builder/undef)
     (.
      bean7711
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7733] (clojure.core/str arg7733))
 v7713))))
   bean7711))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ActivatePipelineRequest}
activate-pipeline-request
  [m7715]
  (clojure.core/let
   [bean7714
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/let
    [v7716
     (:pipeline-id m7715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7716 :com.palletops.awaze.client-builder/undef)
     (. bean7714 setPipelineId (clojure.core/str v7716))))
   (clojure.core/let
    [v7716
     (:start-timestamp
      m7715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7716 :com.palletops.awaze.client-builder/undef)
     (.
      bean7714
      setStartTimestamp
      (com.palletops.awaze.common/to-date v7716))))
   (clojure.core/let
    [v7716
     (:parameter-values
      m7715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7716 :com.palletops.awaze.client-builder/undef)
     (.
      bean7714
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7734] (datapipeline/parameter-value arg7734))
 v7716))))
   bean7714))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn
   datapipeline
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m7735]
   (clojure.core/let
    [credentials7736 (:credentials m7735) args7737 (:args m7735)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7738
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7736)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7738
       getPipelineDefinition
       (datapipeline/get-pipeline-definition-request
        (clojure.core/nth args7737 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Call getPipelineDefinition"}
   [credentials7740 & args7741]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7742
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7740)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7742
      getPipelineDefinition
      (datapipeline/get-pipeline-definition-request
       (clojure.core/nth args7741 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m7743]
   (clojure.core/let
    [credentials7744 (:credentials m7743) args7745 (:args m7743)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7746
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7744)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7746
       validatePipelineDefinition
       (datapipeline/validate-pipeline-definition-request
        (clojure.core/nth args7745 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call validatePipelineDefinition"}
   [credentials7748 & args7749]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7750
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7748)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7750
      validatePipelineDefinition
      (datapipeline/validate-pipeline-definition-request
       (clojure.core/nth args7749 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m7751]
   (clojure.core/let
    [credentials7752 (:credentials m7751) args7753 (:args m7751)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7754
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7752)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7754
       reportTaskProgress
       (datapipeline/report-task-progress-request
        (clojure.core/nth args7753 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskProgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-task-progress,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-progress
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskProgress"}
   [credentials7756 & args7757]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7758
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7756)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7758
      reportTaskProgress
      (datapipeline/report-task-progress-request
       (clojure.core/nth args7757 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :remove-tags
   [m7759]
   (clojure.core/let
    [credentials7760 (:credentials m7759) args7761 (:args m7759)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7762
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7760)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7762
       removeTags
       (datapipeline/remove-tags-request
        (clojure.core/nth args7761 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials7764 & args7765]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7766
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7764)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7766
      removeTags
      (datapipeline/remove-tags-request (clojure.core/nth args7765 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m7767]
   (clojure.core/let
    [credentials7768 (:credentials m7767) args7769 (:args m7767)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7770
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7768)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7770
       describePipelines
       (datapipeline/describe-pipelines-request
        (clojure.core/nth args7769 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Generate map for describePipelines"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Call describePipelines"}
   [credentials7772 & args7773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7774
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7772)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7774
      describePipelines
      (datapipeline/describe-pipelines-request
       (clojure.core/nth args7773 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m7775]
   (clojure.core/let
    [credentials7776 (:credentials m7775) args7777 (:args m7775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7778
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7776)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7778
       pollForTask
       (datapipeline/poll-for-task-request
        (clojure.core/nth args7777 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Generate map for pollForTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :poll-for-task,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   poll-for-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Call pollForTask"}
   [credentials7780 & args7781]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7782
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7780)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7782
      pollForTask
      (datapipeline/poll-for-task-request
       (clojure.core/nth args7781 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :add-tags
   [m7783]
   (clojure.core/let
    [credentials7784 (:credentials m7783) args7785 (:args m7783)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7786
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7784)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7786
       addTags
       (datapipeline/add-tags-request (clojure.core/nth args7785 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials7788 & args7789]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7790
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7788)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7790
      addTags
      (datapipeline/add-tags-request (clojure.core/nth args7789 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m7791]
   (clojure.core/let
    [credentials7792 (:credentials m7791) args7793 (:args m7791)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7794
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7792)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7794
       queryObjects
       (datapipeline/query-objects-request
        (clojure.core/nth args7793 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for queryObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :query-objects,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   query-objects
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Call queryObjects"}
   [credentials7796 & args7797]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7798
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7796)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7798
      queryObjects
      (datapipeline/query-objects-request
       (clojure.core/nth args7797 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m7799]
   (clojure.core/let
    [credentials7800 (:credentials m7799) args7801 (:args m7799)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7802
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7800)]
     (clojure.core/case
      (clojure.core/count args7801)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7802
        listPipelines))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7802
        listPipelines
        (datapipeline/list-pipelines-request
         (clojure.core/nth args7801 0))))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   list-pipelines
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listPipelines, listPipelines"}
   [credentials7804 & args7805]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7806
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7804)]
    (clojure.core/case
     (clojure.core/count args7805)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7806
       listPipelines))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7806
       listPipelines
       (datapipeline/list-pipelines-request
        (clojure.core/nth args7805 0))))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m7807]
   (clojure.core/let
    [credentials7808 (:credentials m7807) args7809 (:args m7807)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7810
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7808)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7810
       reportTaskRunnerHeartbeat
       (datapipeline/report-task-runner-heartbeat-request
        (clojure.core/nth args7809 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-task-runner-heartbeat,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials7812 & args7813]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7814
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7812)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7814
      reportTaskRunnerHeartbeat
      (datapipeline/report-task-runner-heartbeat-request
       (clojure.core/nth args7813 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m7815]
   (clojure.core/let
    [credentials7816 (:credentials m7815) args7817 (:args m7815)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7818
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7816)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7818
       setTaskStatus
       (datapipeline/set-task-status-request
        (clojure.core/nth args7817 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTaskStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-task-status,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-task-status
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Call setTaskStatus"}
   [credentials7820 & args7821]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7822
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7820)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7822
      setTaskStatus
      (datapipeline/set-task-status-request
       (clojure.core/nth args7821 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m7823]
   (clojure.core/let
    [credentials7824 (:credentials m7823) args7825 (:args m7823)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7826
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7824)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7826
       createPipeline
       (datapipeline/create-pipeline-request
        (clojure.core/nth args7825 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   create-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Call createPipeline"}
   [credentials7828 & args7829]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7830
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7828)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7830
      createPipeline
      (datapipeline/create-pipeline-request
       (clojure.core/nth args7829 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m7831]
   (clojure.core/let
    [credentials7832 (:credentials m7831) args7833 (:args m7831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7834
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7832)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7834
       deletePipeline
       (datapipeline/delete-pipeline-request
        (clojure.core/nth args7833 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deletePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   delete-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deletePipeline"}
   [credentials7836 & args7837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7838
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7836)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7838
      deletePipeline
      (datapipeline/delete-pipeline-request
       (clojure.core/nth args7837 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m7839]
   (clojure.core/let
    [credentials7840 (:credentials m7839) args7841 (:args m7839)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7842
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7840)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7842
       putPipelineDefinition
       (datapipeline/put-pipeline-definition-request
        (clojure.core/nth args7841 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call putPipelineDefinition"}
   [credentials7844 & args7845]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7846
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7844)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7846
      putPipelineDefinition
      (datapipeline/put-pipeline-definition-request
       (clojure.core/nth args7845 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :deactivate-pipeline
   [m7847]
   (clojure.core/let
    [credentials7848 (:credentials m7847) args7849 (:args m7847)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7850
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7848)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7850
       deactivatePipeline
       (datapipeline/deactivate-pipeline-request
        (clojure.core/nth args7849 0)))))))
  (clojure.core/defn
   deactivate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deactivatePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deactivate-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   deactivate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deactivatePipeline"}
   [credentials7852 & args7853]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7854
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7852)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7854
      deactivatePipeline
      (datapipeline/deactivate-pipeline-request
       (clojure.core/nth args7853 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m7855]
   (clojure.core/let
    [credentials7856 (:credentials m7855) args7857 (:args m7855)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7858
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7856)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7858
       setStatus
       (datapipeline/set-status-request (clojure.core/nth args7857 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for setStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-status,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call setStatus"}
   [credentials7860 & args7861]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7862
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7860)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7862
      setStatus
      (datapipeline/set-status-request (clojure.core/nth args7861 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m7863]
   (clojure.core/let
    [credentials7864 (:credentials m7863) args7865 (:args m7863)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7866
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7864)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7866
       evaluateExpression
       (datapipeline/evaluate-expression-request
        (clojure.core/nth args7865 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for evaluateExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :evaluate-expression,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   evaluate-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call evaluateExpression"}
   [credentials7868 & args7869]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7870
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7868)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7870
      evaluateExpression
      (datapipeline/evaluate-expression-request
       (clojure.core/nth args7869 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m7871]
   (clojure.core/let
    [credentials7872 (:credentials m7871) args7873 (:args m7871)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7874
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7872)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7874
       describeObjects
       (datapipeline/describe-objects-request
        (clojure.core/nth args7873 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for describeObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-objects,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Call describeObjects"}
   [credentials7876 & args7877]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7878
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7876)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7878
      describeObjects
      (datapipeline/describe-objects-request
       (clojure.core/nth args7877 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m7879]
   (clojure.core/let
    [credentials7880 (:credentials m7879) args7881 (:args m7879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7882
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7880)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7882
       activatePipeline
       (datapipeline/activate-pipeline-request
        (clojure.core/nth args7881 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for activatePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :activate-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   activate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call activatePipeline"}
   [credentials7884 & args7885]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7886
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7884)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7886
      activatePipeline
      (datapipeline/activate-pipeline-request
       (clojure.core/nth args7885 0))))))))
