(ns
 com.palletops.awaze.cloudwatch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudwatch :as cloudwatch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Dimension}
dimension
  [m10575]
  (clojure.core/let
   [bean10574 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/let
    [v10576 (:name m10575 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10576 :com.palletops.awaze.client-builder/undef)
     (. bean10574 setName (clojure.core/str v10576))))
   (clojure.core/let
    [v10576 (:value m10575 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10576 :com.palletops.awaze.client-builder/undef)
     (. bean10574 setValue (clojure.core/str v10576))))
   bean10574))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StandardUnit}
standard-unit
  [m10578]
  (.
   com.amazonaws.services.cloudwatch.model.StandardUnit
   fromValue
   (clojure.core/name m10578)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StatisticSet}
statistic-set
  [m10581]
  (clojure.core/let
   [bean10580
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/let
    [v10582
     (:sample-count m10581 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10582 :com.palletops.awaze.client-builder/undef)
     (. bean10580 setSampleCount (clojure.core/double v10582))))
   (clojure.core/let
    [v10582 (:sum m10581 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10582 :com.palletops.awaze.client-builder/undef)
     (. bean10580 setSum (clojure.core/double v10582))))
   (clojure.core/let
    [v10582
     (:minimum m10581 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10582 :com.palletops.awaze.client-builder/undef)
     (. bean10580 setMinimum (clojure.core/double v10582))))
   (clojure.core/let
    [v10582
     (:maximum m10581 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10582 :com.palletops.awaze.client-builder/undef)
     (. bean10580 setMaximum (clojure.core/double v10582))))
   bean10580))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.MetricDatum}
metric-datum
  [m10584]
  (clojure.core/let
   [bean10583
    (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/let
    [v10585
     (:metric-name m10584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10585 :com.palletops.awaze.client-builder/undef)
     (. bean10583 setMetricName (clojure.core/str v10585))))
   (clojure.core/let
    [v10585
     (:dimensions m10584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10585 :com.palletops.awaze.client-builder/undef)
     (.
      bean10583
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10625] (cloudwatch/dimension arg10625))
 v10585))))
   (clojure.core/let
    [v10585 (:unit m10584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10585 :com.palletops.awaze.client-builder/undef)
     (. bean10583 setUnit (cloudwatch/standard-unit v10585))))
   (clojure.core/let
    [v10585
     (:statistic-values
      m10584
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10585 :com.palletops.awaze.client-builder/undef)
     (.
      bean10583
      setStatisticValues
      (cloudwatch/statistic-set v10585))))
   (clojure.core/let
    [v10585 (:value m10584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10585 :com.palletops.awaze.client-builder/undef)
     (. bean10583 setValue (clojure.core/double v10585))))
   (clojure.core/let
    [v10585
     (:timestamp m10584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10585 :com.palletops.awaze.client-builder/undef)
     (.
      bean10583
      setTimestamp
      (com.palletops.awaze.common/to-date v10585))))
   bean10583))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Statistic}
statistic
  [m10587]
  (.
   com.amazonaws.services.cloudwatch.model.Statistic
   fromValue
   (clojure.core/name m10587)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DimensionFilter}
dimension-filter
  [m10590]
  (clojure.core/let
   [bean10589
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/let
    [v10591 (:name m10590 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10591 :com.palletops.awaze.client-builder/undef)
     (. bean10589 setName (clojure.core/str v10591))))
   (clojure.core/let
    [v10591 (:value m10590 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10591 :com.palletops.awaze.client-builder/undef)
     (. bean10589 setValue (clojure.core/str v10591))))
   bean10589))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest}
delete-alarms-request
  [m10593]
  (clojure.core/let
   [bean10592
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/let
    [v10594
     (:alarm-names m10593 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10594 :com.palletops.awaze.client-builder/undef)
     (.
      bean10592
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10626] (clojure.core/str arg10626))
 v10594))))
   bean10592))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest}
enable-alarm-actions-request
  [m10596]
  (clojure.core/let
   [bean10595
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/let
    [v10597
     (:alarm-names m10596 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10597 :com.palletops.awaze.client-builder/undef)
     (.
      bean10595
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10627] (clojure.core/str arg10627))
 v10597))))
   bean10595))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest}
disable-alarm-actions-request
  [m10599]
  (clojure.core/let
   [bean10598
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/let
    [v10600
     (:alarm-names m10599 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10600 :com.palletops.awaze.client-builder/undef)
     (.
      bean10598
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10628] (clojure.core/str arg10628))
 v10600))))
   bean10598))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest}
set-alarm-state-request
  [m10602]
  (clojure.core/let
   [bean10601
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/let
    [v10603
     (:alarm-name m10602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10603 :com.palletops.awaze.client-builder/undef)
     (. bean10601 setAlarmName (clojure.core/str v10603))))
   (clojure.core/let
    [v10603
     (:state-value m10602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10603 :com.palletops.awaze.client-builder/undef)
     (. bean10601 setStateValue (clojure.core/str v10603))))
   (clojure.core/let
    [v10603
     (:state-reason m10602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10603 :com.palletops.awaze.client-builder/undef)
     (. bean10601 setStateReason (clojure.core/str v10603))))
   (clojure.core/let
    [v10603
     (:state-reason-data
      m10602
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10603 :com.palletops.awaze.client-builder/undef)
     (. bean10601 setStateReasonData (clojure.core/str v10603))))
   bean10601))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest}
describe-alarms-for-metric-request
  [m10605]
  (clojure.core/let
   [bean10604
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/let
    [v10606
     (:namespace m10605 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10606 :com.palletops.awaze.client-builder/undef)
     (. bean10604 setNamespace (clojure.core/str v10606))))
   (clojure.core/let
    [v10606
     (:metric-name m10605 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10606 :com.palletops.awaze.client-builder/undef)
     (. bean10604 setMetricName (clojure.core/str v10606))))
   (clojure.core/let
    [v10606
     (:dimensions m10605 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10606 :com.palletops.awaze.client-builder/undef)
     (.
      bean10604
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10629] (cloudwatch/dimension arg10629))
 v10606))))
   (clojure.core/let
    [v10606
     (:statistic m10605 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10606 :com.palletops.awaze.client-builder/undef)
     (. bean10604 setStatistic (clojure.core/str v10606))))
   (clojure.core/let
    [v10606
     (:period m10605 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10606 :com.palletops.awaze.client-builder/undef)
     (. bean10604 setPeriod (clojure.core/int v10606))))
   (clojure.core/let
    [v10606 (:unit m10605 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10606 :com.palletops.awaze.client-builder/undef)
     (. bean10604 setUnit (clojure.core/str v10606))))
   bean10604))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricDataRequest}
put-metric-data-request
  [m10608]
  (clojure.core/let
   [bean10607
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/let
    [v10609
     (:namespace m10608 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10609 :com.palletops.awaze.client-builder/undef)
     (. bean10607 setNamespace (clojure.core/str v10609))))
   (clojure.core/let
    [v10609
     (:metric-data m10608 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10609 :com.palletops.awaze.client-builder/undef)
     (.
      bean10607
      setMetricData
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10630] (cloudwatch/metric-datum arg10630))
 v10609))))
   bean10607))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest}
describe-alarms-request
  [m10611]
  (clojure.core/let
   [bean10610
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/let
    [v10612
     (:alarm-names m10611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10612 :com.palletops.awaze.client-builder/undef)
     (.
      bean10610
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10631] (clojure.core/str arg10631))
 v10612))))
   (clojure.core/let
    [v10612
     (:state-value m10611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10612 :com.palletops.awaze.client-builder/undef)
     (. bean10610 setStateValue (clojure.core/str v10612))))
   (clojure.core/let
    [v10612
     (:alarm-name-prefix
      m10611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10612 :com.palletops.awaze.client-builder/undef)
     (. bean10610 setAlarmNamePrefix (clojure.core/str v10612))))
   (clojure.core/let
    [v10612
     (:action-prefix m10611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10612 :com.palletops.awaze.client-builder/undef)
     (. bean10610 setActionPrefix (clojure.core/str v10612))))
   (clojure.core/let
    [v10612
     (:next-token m10611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10612 :com.palletops.awaze.client-builder/undef)
     (. bean10610 setNextToken (clojure.core/str v10612))))
   (clojure.core/let
    [v10612
     (:max-records m10611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10612 :com.palletops.awaze.client-builder/undef)
     (. bean10610 setMaxRecords (clojure.core/int v10612))))
   bean10610))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest}
describe-alarm-history-request
  [m10614]
  (clojure.core/let
   [bean10613
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/let
    [v10615
     (:start-date m10614 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10615 :com.palletops.awaze.client-builder/undef)
     (.
      bean10613
      setStartDate
      (com.palletops.awaze.common/to-date v10615))))
   (clojure.core/let
    [v10615
     (:end-date m10614 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10615 :com.palletops.awaze.client-builder/undef)
     (.
      bean10613
      setEndDate
      (com.palletops.awaze.common/to-date v10615))))
   (clojure.core/let
    [v10615
     (:alarm-name m10614 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10615 :com.palletops.awaze.client-builder/undef)
     (. bean10613 setAlarmName (clojure.core/str v10615))))
   (clojure.core/let
    [v10615
     (:history-item-type
      m10614
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10615 :com.palletops.awaze.client-builder/undef)
     (. bean10613 setHistoryItemType (clojure.core/str v10615))))
   (clojure.core/let
    [v10615
     (:next-token m10614 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10615 :com.palletops.awaze.client-builder/undef)
     (. bean10613 setNextToken (clojure.core/str v10615))))
   (clojure.core/let
    [v10615
     (:max-records m10614 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10615 :com.palletops.awaze.client-builder/undef)
     (. bean10613 setMaxRecords (clojure.core/int v10615))))
   bean10613))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest}
put-metric-alarm-request
  [m10617]
  (clojure.core/let
   [bean10616
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/let
    [v10618
     (:alarm-name m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setAlarmName (clojure.core/str v10618))))
   (clojure.core/let
    [v10618
     (:alarm-description
      m10617
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setAlarmDescription (clojure.core/str v10618))))
   (clojure.core/let
    [v10618
     (:okactions m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (.
      bean10616
      setOKActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10720] (clojure.core/str arg10720))
 v10618))))
   (clojure.core/let
    [v10618 (:unit m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setUnit (clojure.core/str v10618))))
   (clojure.core/let
    [v10618
     (:metric-name m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setMetricName (clojure.core/str v10618))))
   (clojure.core/let
    [v10618
     (:dimensions m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (.
      bean10616
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10721] (cloudwatch/dimension arg10721))
 v10618))))
   (clojure.core/let
    [v10618
     (:evaluation-periods
      m10617
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setEvaluationPeriods (clojure.core/int v10618))))
   (clojure.core/let
    [v10618
     (:namespace m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setNamespace (clojure.core/str v10618))))
   (clojure.core/let
    [v10618
     (:period m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setPeriod (clojure.core/int v10618))))
   (clojure.core/let
    [v10618
     (:comparison-operator
      m10617
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setComparisonOperator (clojure.core/str v10618))))
   (clojure.core/let
    [v10618
     (:actions-enabled
      m10617
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setActionsEnabled (clojure.core/boolean v10618))))
   (clojure.core/let
    [v10618
     (:alarm-actions m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (.
      bean10616
      setAlarmActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10722] (clojure.core/str arg10722))
 v10618))))
   (clojure.core/let
    [v10618
     (:insufficient-data-actions
      m10617
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (.
      bean10616
      setInsufficientDataActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10723] (clojure.core/str arg10723))
 v10618))))
   (clojure.core/let
    [v10618
     (:threshold m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setThreshold (clojure.core/double v10618))))
   (clojure.core/let
    [v10618
     (:statistic m10617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10618 :com.palletops.awaze.client-builder/undef)
     (. bean10616 setStatistic (cloudwatch/statistic v10618))))
   bean10616))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest}
get-metric-statistics-request
  [m10620]
  (clojure.core/let
   [bean10619
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/let
    [v10621
     (:namespace m10620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10621 :com.palletops.awaze.client-builder/undef)
     (. bean10619 setNamespace (clojure.core/str v10621))))
   (clojure.core/let
    [v10621
     (:metric-name m10620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10621 :com.palletops.awaze.client-builder/undef)
     (. bean10619 setMetricName (clojure.core/str v10621))))
   (clojure.core/let
    [v10621
     (:dimensions m10620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10621 :com.palletops.awaze.client-builder/undef)
     (.
      bean10619
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10724] (cloudwatch/dimension arg10724))
 v10621))))
   (clojure.core/let
    [v10621
     (:period m10620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10621 :com.palletops.awaze.client-builder/undef)
     (. bean10619 setPeriod (clojure.core/int v10621))))
   (clojure.core/let
    [v10621 (:unit m10620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10621 :com.palletops.awaze.client-builder/undef)
     (. bean10619 setUnit (cloudwatch/standard-unit v10621))))
   (clojure.core/let
    [v10621
     (:statistics m10620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10621 :com.palletops.awaze.client-builder/undef)
     (.
      bean10619
      setStatistics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10725] (clojure.core/str arg10725))
 v10621))))
   (clojure.core/let
    [v10621
     (:start-time m10620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10621 :com.palletops.awaze.client-builder/undef)
     (.
      bean10619
      setStartTime
      (com.palletops.awaze.common/to-date v10621))))
   (clojure.core/let
    [v10621
     (:end-time m10620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10621 :com.palletops.awaze.client-builder/undef)
     (.
      bean10619
      setEndTime
      (com.palletops.awaze.common/to-date v10621))))
   bean10619))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ListMetricsRequest}
list-metrics-request
  [m10623]
  (clojure.core/let
   [bean10622
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/let
    [v10624
     (:namespace m10623 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10624 :com.palletops.awaze.client-builder/undef)
     (. bean10622 setNamespace (clojure.core/str v10624))))
   (clojure.core/let
    [v10624
     (:metric-name m10623 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10624 :com.palletops.awaze.client-builder/undef)
     (. bean10622 setMetricName (clojure.core/str v10624))))
   (clojure.core/let
    [v10624
     (:dimensions m10623 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10624 :com.palletops.awaze.client-builder/undef)
     (.
      bean10622
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10726] (cloudwatch/dimension-filter arg10726))
 v10624))))
   (clojure.core/let
    [v10624
     (:next-token m10623 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10624 :com.palletops.awaze.client-builder/undef)
     (. bean10622 setNextToken (clojure.core/str v10624))))
   bean10622))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m10632]
   (clojure.core/let
    [credentials10633 (:credentials m10632) args10634 (:args m10632)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10635
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10633)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10635
       deleteAlarms
       (cloudwatch/delete-alarms-request
        (clojure.core/nth args10634 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteAlarms"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   delete-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteAlarms"}
   [credentials10637 & args10638]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10639
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10637)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10639
      deleteAlarms
      (cloudwatch/delete-alarms-request
       (clojure.core/nth args10638 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m10640]
   (clojure.core/let
    [credentials10641 (:credentials m10640) args10642 (:args m10640)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10643
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10641)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10643
       enableAlarmActions
       (cloudwatch/enable-alarm-actions-request
        (clojure.core/nth args10642 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAlarmActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-alarm-actions,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAlarmActions"}
   [credentials10645 & args10646]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10647
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10645)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10647
      enableAlarmActions
      (cloudwatch/enable-alarm-actions-request
       (clojure.core/nth args10646 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m10648]
   (clojure.core/let
    [credentials10649 (:credentials m10648) args10650 (:args m10648)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10651
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10649)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10651
       disableAlarmActions
       (cloudwatch/disable-alarm-actions-request
        (clojure.core/nth args10650 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAlarmActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-alarm-actions,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAlarmActions"}
   [credentials10653 & args10654]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10655
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10653)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10655
      disableAlarmActions
      (cloudwatch/disable-alarm-actions-request
       (clojure.core/nth args10654 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m10656]
   (clojure.core/let
    [credentials10657 (:credentials m10656) args10658 (:args m10656)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10659
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10657)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10659
       setAlarmState
       (cloudwatch/set-alarm-state-request
        (clojure.core/nth args10658 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Generate map for setAlarmState"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-alarm-state,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   set-alarm-state
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Call setAlarmState"}
   [credentials10661 & args10662]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10663
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10661)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10663
      setAlarmState
      (cloudwatch/set-alarm-state-request
       (clojure.core/nth args10662 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m10664]
   (clojure.core/let
    [credentials10665 (:credentials m10664) args10666 (:args m10664)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10667
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10665)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10667
       describeAlarmsForMetric
       (cloudwatch/describe-alarms-for-metric-request
        (clojure.core/nth args10666 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarms-for-metric,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call describeAlarmsForMetric"}
   [credentials10669 & args10670]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10671
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10669)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10671
      describeAlarmsForMetric
      (cloudwatch/describe-alarms-for-metric-request
       (clojure.core/nth args10670 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m10672]
   (clojure.core/let
    [credentials10673 (:credentials m10672) args10674 (:args m10672)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10675
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10673)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10675
       putMetricData
       (cloudwatch/put-metric-data-request
        (clojure.core/nth args10674 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricData"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-metric-data,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricData"}
   [credentials10677 & args10678]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10679
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10677)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10679
      putMetricData
      (cloudwatch/put-metric-data-request
       (clojure.core/nth args10678 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m10680]
   (clojure.core/let
    [credentials10681 (:credentials m10680) args10682 (:args m10680)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10683
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10681)]
     (clojure.core/case
      (clojure.core/count args10682)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10683
        describeAlarms
        (cloudwatch/describe-alarms-request
         (clojure.core/nth args10682 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10683
        describeAlarms))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAlarms, describeAlarms"}
   [credentials10685 & args10686]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10687
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10685)]
    (clojure.core/case
     (clojure.core/count args10686)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10687
       describeAlarms
       (cloudwatch/describe-alarms-request
        (clojure.core/nth args10686 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10687
       describeAlarms))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m10688]
   (clojure.core/let
    [credentials10689 (:credentials m10688) args10690 (:args m10688)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10691
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10689)]
     (clojure.core/case
      (clojure.core/count args10690)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10691
        describeAlarmHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10691
        describeAlarmHistory
        (cloudwatch/describe-alarm-history-request
         (clojure.core/nth args10690 0))))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-alarm-history,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarm-history,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]]),
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials10693 & args10694]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10695
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10693)]
    (clojure.core/case
     (clojure.core/count args10694)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10695
       describeAlarmHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10695
       describeAlarmHistory
       (cloudwatch/describe-alarm-history-request
        (clojure.core/nth args10694 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m10696]
   (clojure.core/let
    [credentials10697 (:credentials m10696) args10698 (:args m10696)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10699
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10697)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10699
       putMetricAlarm
       (cloudwatch/put-metric-alarm-request
        (clojure.core/nth args10698 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricAlarm"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-metric-alarm,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricAlarm"}
   [credentials10701 & args10702]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10703
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10701)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10703
      putMetricAlarm
      (cloudwatch/put-metric-alarm-request
       (clojure.core/nth args10702 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m10704]
   (clojure.core/let
    [credentials10705 (:credentials m10704) args10706 (:args m10704)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10707
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10705)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10707
       getMetricStatistics
       (cloudwatch/get-metric-statistics-request
        (clojure.core/nth args10706 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for getMetricStatistics"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-metric-statistics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call getMetricStatistics"}
   [credentials10709 & args10710]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10711
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10709)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10711
      getMetricStatistics
      (cloudwatch/get-metric-statistics-request
       (clojure.core/nth args10710 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m10712]
   (clojure.core/let
    [credentials10713 (:credentials m10712) args10714 (:args m10712)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10715
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10713)]
     (clojure.core/case
      (clojure.core/count args10714)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10715
        listMetrics))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10715
        listMetrics
        (cloudwatch/list-metrics-request
         (clojure.core/nth args10714 0))))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-metrics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-metrics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   list-metrics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]]),
    :doc "Call listMetrics, listMetrics"}
   [credentials10717 & args10718]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10719
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10717)]
    (clojure.core/case
     (clojure.core/count args10718)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10719
       listMetrics))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10719
       listMetrics
       (cloudwatch/list-metrics-request
        (clojure.core/nth args10718 0)))))))))
