(ns
 com.palletops.awaze.cloudsearch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudsearch :as cloudsearch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceData}
source-data
  [m7888]
  (clojure.core/let
   [bean7887
    (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/let
    [v7889
     (:default-value m7888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7889 :com.palletops.awaze.client-builder/undef)
     (. bean7887 setDefaultValue (clojure.core/str v7889))))
   (clojure.core/let
    [v7889
     (:source-name m7888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7889 :com.palletops.awaze.client-builder/undef)
     (. bean7887 setSourceName (clojure.core/str v7889))))
   bean7887))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle}
source-data-trim-title
  [m7891]
  (clojure.core/let
   [bean7890
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/let
    [v7892
     (:default-value m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setDefaultValue (clojure.core/str v7892))))
   (clojure.core/let
    [v7892
     (:source-name m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setSourceName (clojure.core/str v7892))))
   (clojure.core/let
    [v7892
     (:separator m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setSeparator (clojure.core/str v7892))))
   (clojure.core/let
    [v7892
     (:language m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setLanguage (clojure.core/str v7892))))
   bean7890))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataMap}
source-data-map
  [m7894]
  (clojure.core/let
   [bean7893
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/let
    [v7895
     (:default-value m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setDefaultValue (clojure.core/str v7895))))
   (clojure.core/let
    [v7895
     (:source-name m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setSourceName (clojure.core/str v7895))))
   (clojure.core/let
    [v7895 (:cases m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (.
      bean7893
      setCases
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg7986] (clojure.core/str arg7986))
  (clojure.core/keys v7895))
 (clojure.core/map
  (clojure.core/fn [arg7986] (clojure.core/str arg7986))
  (clojure.core/vals v7895))))))
   bean7893))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataFunction}
source-data-function
  [m7897]
  (.
   com.amazonaws.services.cloudsearch.model.SourceDataFunction
   fromValue
   (clojure.core/name m7897)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexFieldType}
index-field-type
  [m7900]
  (.
   com.amazonaws.services.cloudsearch.model.IndexFieldType
   fromValue
   (clojure.core/name m7900)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UIntOptions}
uint-options
  [m7903]
  (clojure.core/let
   [bean7902
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/let
    [v7904
     (:default-value m7903 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7904 :com.palletops.awaze.client-builder/undef)
     (. bean7902 setDefaultValue (clojure.core/int v7904))))
   bean7902))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.LiteralOptions}
literal-options
  [m7906]
  (clojure.core/let
   [bean7905
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/let
    [v7907
     (:default-value m7906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7907 :com.palletops.awaze.client-builder/undef)
     (. bean7905 setDefaultValue (clojure.core/str v7907))))
   (clojure.core/let
    [v7907
     (:search-enabled m7906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7907 :com.palletops.awaze.client-builder/undef)
     (. bean7905 setSearchEnabled (clojure.core/boolean v7907))))
   (clojure.core/let
    [v7907
     (:facet-enabled m7906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7907 :com.palletops.awaze.client-builder/undef)
     (. bean7905 setFacetEnabled (clojure.core/boolean v7907))))
   (clojure.core/let
    [v7907
     (:result-enabled m7906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7907 :com.palletops.awaze.client-builder/undef)
     (. bean7905 setResultEnabled (clojure.core/boolean v7907))))
   bean7905))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.TextOptions}
text-options
  [m7909]
  (clojure.core/let
   [bean7908
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/let
    [v7910
     (:default-value m7909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setDefaultValue (clojure.core/str v7910))))
   (clojure.core/let
    [v7910
     (:facet-enabled m7909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setFacetEnabled (clojure.core/boolean v7910))))
   (clojure.core/let
    [v7910
     (:result-enabled m7909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setResultEnabled (clojure.core/boolean v7910))))
   (clojure.core/let
    [v7910
     (:text-processor m7909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setTextProcessor (clojure.core/str v7910))))
   bean7908))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceAttribute}
source-attribute
  [m7912]
  (clojure.core/let
   [bean7911
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/let
    [v7913
     (:source-data-copy
      m7912
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7913 :com.palletops.awaze.client-builder/undef)
     (. bean7911 setSourceDataCopy (cloudsearch/source-data v7913))))
   (clojure.core/let
    [v7913
     (:source-data-trim-title
      m7912
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7913 :com.palletops.awaze.client-builder/undef)
     (.
      bean7911
      setSourceDataTrimTitle
      (cloudsearch/source-data-trim-title v7913))))
   (clojure.core/let
    [v7913
     (:source-data-map
      m7912
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7913 :com.palletops.awaze.client-builder/undef)
     (. bean7911 setSourceDataMap (cloudsearch/source-data-map v7913))))
   (clojure.core/let
    [v7913
     (:source-data-function
      m7912
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7913 :com.palletops.awaze.client-builder/undef)
     (.
      bean7911
      setSourceDataFunction
      (cloudsearch/source-data-function v7913))))
   bean7911))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.NamedRankExpression}
named-rank-expression
  [m7915]
  (clojure.core/let
   [bean7914
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/let
    [v7916
     (:rank-name m7915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7916 :com.palletops.awaze.client-builder/undef)
     (. bean7914 setRankName (clojure.core/str v7916))))
   (clojure.core/let
    [v7916
     (:rank-expression
      m7915
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7916 :com.palletops.awaze.client-builder/undef)
     (. bean7914 setRankExpression (clojure.core/str v7916))))
   bean7914))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexField}
index-field
  [m7918]
  (clojure.core/let
   [bean7917
    (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/let
    [v7919
     (:index-field-name
      m7918
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (. bean7917 setIndexFieldName (clojure.core/str v7919))))
   (clojure.core/let
    [v7919
     (:index-field-type
      m7918
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (.
      bean7917
      setIndexFieldType
      (cloudsearch/index-field-type v7919))))
   (clojure.core/let
    [v7919
     (:uint-options m7918 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (. bean7917 setUIntOptions (cloudsearch/uint-options v7919))))
   (clojure.core/let
    [v7919
     (:literal-options
      m7918
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (.
      bean7917
      setLiteralOptions
      (cloudsearch/literal-options v7919))))
   (clojure.core/let
    [v7919
     (:text-options m7918 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (. bean7917 setTextOptions (cloudsearch/text-options v7919))))
   (clojure.core/let
    [v7919
     (:source-attributes
      m7918
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (.
      bean7917
      setSourceAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7987] (cloudsearch/source-attribute arg7987))
 v7919))))
   bean7917))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest}
update-stemming-options-request
  [m7921]
  (clojure.core/let
   [bean7920
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/let
    [v7922
     (:domain-name m7921 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7922 :com.palletops.awaze.client-builder/undef)
     (. bean7920 setDomainName (clojure.core/str v7922))))
   (clojure.core/let
    [v7922 (:stems m7921 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7922 :com.palletops.awaze.client-builder/undef)
     (. bean7920 setStems (clojure.core/str v7922))))
   bean7920))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest}
update-synonym-options-request
  [m7924]
  (clojure.core/let
   [bean7923
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/let
    [v7925
     (:domain-name m7924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7925 :com.palletops.awaze.client-builder/undef)
     (. bean7923 setDomainName (clojure.core/str v7925))))
   (clojure.core/let
    [v7925
     (:synonyms m7924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7925 :com.palletops.awaze.client-builder/undef)
     (. bean7923 setSynonyms (clojure.core/str v7925))))
   bean7923))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteDomainRequest}
delete-domain-request
  [m7927]
  (clojure.core/let
   [bean7926
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/let
    [v7928
     (:domain-name m7927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7928 :com.palletops.awaze.client-builder/undef)
     (. bean7926 setDomainName (clojure.core/str v7928))))
   bean7926))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest}
define-rank-expression-request
  [m7930]
  (clojure.core/let
   [bean7929
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/let
    [v7931
     (:domain-name m7930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7931 :com.palletops.awaze.client-builder/undef)
     (. bean7929 setDomainName (clojure.core/str v7931))))
   (clojure.core/let
    [v7931
     (:rank-expression
      m7930
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7931 :com.palletops.awaze.client-builder/undef)
     (.
      bean7929
      setRankExpression
      (cloudsearch/named-rank-expression v7931))))
   bean7929))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest}
update-stopword-options-request
  [m7933]
  (clojure.core/let
   [bean7932
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/let
    [v7934
     (:domain-name m7933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7934 :com.palletops.awaze.client-builder/undef)
     (. bean7932 setDomainName (clojure.core/str v7934))))
   (clojure.core/let
    [v7934
     (:stopwords m7933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7934 :com.palletops.awaze.client-builder/undef)
     (. bean7932 setStopwords (clojure.core/str v7934))))
   bean7932))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest}
describe-domains-request
  [m7936]
  (clojure.core/let
   [bean7935
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/let
    [v7937
     (:domain-names m7936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7937 :com.palletops.awaze.client-builder/undef)
     (.
      bean7935
      setDomainNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7988] (clojure.core/str arg7988))
 v7937))))
   bean7935))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest}
describe-rank-expressions-request
  [m7939]
  (clojure.core/let
   [bean7938
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/let
    [v7940
     (:domain-name m7939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7940 :com.palletops.awaze.client-builder/undef)
     (. bean7938 setDomainName (clojure.core/str v7940))))
   (clojure.core/let
    [v7940
     (:rank-names m7939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7940 :com.palletops.awaze.client-builder/undef)
     (.
      bean7938
      setRankNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7989] (clojure.core/str arg7989))
 v7940))))
   bean7938))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest}
index-documents-request
  [m7942]
  (clojure.core/let
   [bean7941
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/let
    [v7943
     (:domain-name m7942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7943 :com.palletops.awaze.client-builder/undef)
     (. bean7941 setDomainName (clojure.core/str v7943))))
   bean7941))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest}
describe-stemming-options-request
  [m7945]
  (clojure.core/let
   [bean7944
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/let
    [v7946
     (:domain-name m7945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7946 :com.palletops.awaze.client-builder/undef)
     (. bean7944 setDomainName (clojure.core/str v7946))))
   bean7944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest}
define-index-field-request
  [m7948]
  (clojure.core/let
   [bean7947
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/let
    [v7949
     (:domain-name m7948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7949 :com.palletops.awaze.client-builder/undef)
     (. bean7947 setDomainName (clojure.core/str v7949))))
   (clojure.core/let
    [v7949
     (:index-field m7948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7949 :com.palletops.awaze.client-builder/undef)
     (. bean7947 setIndexField (cloudsearch/index-field v7949))))
   bean7947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest}
describe-default-search-field-request
  [m7951]
  (clojure.core/let
   [bean7950
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/let
    [v7952
     (:domain-name m7951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7952 :com.palletops.awaze.client-builder/undef)
     (. bean7950 setDomainName (clojure.core/str v7952))))
   bean7950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest}
update-default-search-field-request
  [m7954]
  (clojure.core/let
   [bean7953
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/let
    [v7955
     (:domain-name m7954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7955 :com.palletops.awaze.client-builder/undef)
     (. bean7953 setDomainName (clojure.core/str v7955))))
   (clojure.core/let
    [v7955
     (:default-search-field
      m7954
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7955 :com.palletops.awaze.client-builder/undef)
     (. bean7953 setDefaultSearchField (clojure.core/str v7955))))
   bean7953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest}
describe-index-fields-request
  [m7957]
  (clojure.core/let
   [bean7956
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/let
    [v7958
     (:domain-name m7957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7958 :com.palletops.awaze.client-builder/undef)
     (. bean7956 setDomainName (clojure.core/str v7958))))
   (clojure.core/let
    [v7958
     (:field-names m7957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7958 :com.palletops.awaze.client-builder/undef)
     (.
      bean7956
      setFieldNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7990] (clojure.core/str arg7990))
 v7958))))
   bean7956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest}
update-availability-options-request
  [m7960]
  (clojure.core/let
   [bean7959
    (new
     com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest)]
   (clojure.core/let
    [v7961
     (:domain-name m7960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7961 :com.palletops.awaze.client-builder/undef)
     (. bean7959 setDomainName (clojure.core/str v7961))))
   (clojure.core/let
    [v7961
     (:multi-az m7960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7961 :com.palletops.awaze.client-builder/undef)
     (. bean7959 setMultiAZ (clojure.core/boolean v7961))))
   bean7959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest}
update-service-access-policies-request
  [m7963]
  (clojure.core/let
   [bean7962
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v7964
     (:domain-name m7963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7964 :com.palletops.awaze.client-builder/undef)
     (. bean7962 setDomainName (clojure.core/str v7964))))
   (clojure.core/let
    [v7964
     (:access-policies
      m7963
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7964 :com.palletops.awaze.client-builder/undef)
     (. bean7962 setAccessPolicies (clojure.core/str v7964))))
   bean7962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest}
describe-service-access-policies-request
  [m7966]
  (clojure.core/let
   [bean7965
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v7967
     (:domain-name m7966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7967 :com.palletops.awaze.client-builder/undef)
     (. bean7965 setDomainName (clojure.core/str v7967))))
   bean7965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest}
describe-stopword-options-request
  [m7969]
  (clojure.core/let
   [bean7968
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/let
    [v7970
     (:domain-name m7969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7970 :com.palletops.awaze.client-builder/undef)
     (. bean7968 setDomainName (clojure.core/str v7970))))
   bean7968))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest}
describe-synonym-options-request
  [m7972]
  (clojure.core/let
   [bean7971
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/let
    [v7973
     (:domain-name m7972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7973 :com.palletops.awaze.client-builder/undef)
     (. bean7971 setDomainName (clojure.core/str v7973))))
   bean7971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest}
delete-rank-expression-request
  [m7975]
  (clojure.core/let
   [bean7974
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/let
    [v7976
     (:domain-name m7975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7976 :com.palletops.awaze.client-builder/undef)
     (. bean7974 setDomainName (clojure.core/str v7976))))
   (clojure.core/let
    [v7976
     (:rank-name m7975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7976 :com.palletops.awaze.client-builder/undef)
     (. bean7974 setRankName (clojure.core/str v7976))))
   bean7974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest}
delete-index-field-request
  [m7978]
  (clojure.core/let
   [bean7977
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/let
    [v7979
     (:domain-name m7978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7979 :com.palletops.awaze.client-builder/undef)
     (. bean7977 setDomainName (clojure.core/str v7979))))
   (clojure.core/let
    [v7979
     (:index-field-name
      m7978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7979 :com.palletops.awaze.client-builder/undef)
     (. bean7977 setIndexFieldName (clojure.core/str v7979))))
   bean7977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest}
describe-availability-options-request
  [m7981]
  (clojure.core/let
   [bean7980
    (new
     com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest)]
   (clojure.core/let
    [v7982
     (:domain-name m7981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7982 :com.palletops.awaze.client-builder/undef)
     (. bean7980 setDomainName (clojure.core/str v7982))))
   bean7980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.CreateDomainRequest}
create-domain-request
  [m7984]
  (clojure.core/let
   [bean7983
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/let
    [v7985
     (:domain-name m7984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7985 :com.palletops.awaze.client-builder/undef)
     (. bean7983 setDomainName (clojure.core/str v7985))))
   bean7983))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn
   cloudsearch
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m7991]
   (clojure.core/let
    [credentials7992 (:credentials m7991) args7993 (:args m7991)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7994
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7992)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7994
       updateStemmingOptions
       (cloudsearch/update-stemming-options-request
        (clojure.core/nth args7993 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         stems
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stemming-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         stems
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStemmingOptions"}
   [credentials7996 & args7997]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7998
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7996)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7998
      updateStemmingOptions
      (cloudsearch/update-stemming-options-request
       (clojure.core/nth args7997 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m7999]
   (clojure.core/let
    [credentials8000 (:credentials m7999) args8001 (:args m7999)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8002
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8000)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8002
       updateSynonymOptions
       (cloudsearch/update-synonym-options-request
        (clojure.core/nth args8001 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         synonyms
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-synonym-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         synonyms
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSynonymOptions"}
   [credentials8004 & args8005]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8006
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8004)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8006
      updateSynonymOptions
      (cloudsearch/update-synonym-options-request
       (clojure.core/nth args8005 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m8007]
   (clojure.core/let
    [credentials8008 (:credentials m8007) args8009 (:args m8007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8010
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8008)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8010
       deleteDomain
       (cloudsearch/delete-domain-request
        (clojure.core/nth args8009 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials8012 & args8013]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8014
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8012)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8014
      deleteDomain
      (cloudsearch/delete-domain-request
       (clojure.core/nth args8013 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m8015]
   (clojure.core/let
    [credentials8016 (:credentials m8015) args8017 (:args m8015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8018
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8016)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8018
       defineRankExpression
       (cloudsearch/define-rank-expression-request
        (clojure.core/nth args8017 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-expression
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for defineRankExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :define-rank-expression,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   define-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-expression
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call defineRankExpression"}
   [credentials8020 & args8021]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8022
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8020)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8022
      defineRankExpression
      (cloudsearch/define-rank-expression-request
       (clojure.core/nth args8021 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m8023]
   (clojure.core/let
    [credentials8024 (:credentials m8023) args8025 (:args m8023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8026
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8026
       updateStopwordOptions
       (cloudsearch/update-stopword-options-request
        (clojure.core/nth args8025 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         stopwords
                         clone-root]}]]),
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stopword-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         stopwords
                         clone-root]}]]),
    :doc "Call updateStopwordOptions"}
   [credentials8028 & args8029]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8030
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8028)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8030
      updateStopwordOptions
      (cloudsearch/update-stopword-options-request
       (clojure.core/nth args8029 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m8031]
   (clojure.core/let
    [credentials8032 (:credentials m8031) args8033 (:args m8031)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8034
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8032)]
     (clojure.core/case
      (clojure.core/count args8033)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8034
        describeDomains))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8034
        describeDomains
        (cloudsearch/describe-domains-request
         (clojure.core/nth args8033 0))))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         domain-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-domains,
     :credentials credentials__1842__auto__,
     :client :cloudsearch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-domains,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-domains
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         domain-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDomains, describeDomains"}
   [credentials8036 & args8037]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8038
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8036)]
    (clojure.core/case
     (clojure.core/count args8037)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8038
       describeDomains))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8038
       describeDomains
       (cloudsearch/describe-domains-request
        (clojure.core/nth args8037 0))))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m8039]
   (clojure.core/let
    [credentials8040 (:credentials m8039) args8041 (:args m8039)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8042
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8040)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8042
       describeRankExpressions
       (cloudsearch/describe-rank-expressions-request
        (clojure.core/nth args8041 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-names
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRankExpressions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-rank-expressions,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-names
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRankExpressions"}
   [credentials8044 & args8045]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8046
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8044)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8046
      describeRankExpressions
      (cloudsearch/describe-rank-expressions-request
       (clojure.core/nth args8045 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m8047]
   (clojure.core/let
    [credentials8048 (:credentials m8047) args8049 (:args m8047)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8050
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8048)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8050
       indexDocuments
       (cloudsearch/index-documents-request
        (clojure.core/nth args8049 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for indexDocuments"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :index-documents,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   index-documents
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call indexDocuments"}
   [credentials8052 & args8053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8054
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8052)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8054
      indexDocuments
      (cloudsearch/index-documents-request
       (clojure.core/nth args8053 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m8055]
   (clojure.core/let
    [credentials8056 (:credentials m8055) args8057 (:args m8055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8058
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8056)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8058
       describeStemmingOptions
       (cloudsearch/describe-stemming-options-request
        (clojure.core/nth args8057 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stemming-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStemmingOptions"}
   [credentials8060 & args8061]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8062
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8060)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8062
      describeStemmingOptions
      (cloudsearch/describe-stemming-options-request
       (clojure.core/nth args8061 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m8063]
   (clojure.core/let
    [credentials8064 (:credentials m8063) args8065 (:args m8063)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8066
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8064)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8066
       defineIndexField
       (cloudsearch/define-index-field-request
        (clojure.core/nth args8065 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for defineIndexField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :define-index-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   define-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call defineIndexField"}
   [credentials8068 & args8069]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8070
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8068)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8070
      defineIndexField
      (cloudsearch/define-index-field-request
       (clojure.core/nth args8069 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m8071]
   (clojure.core/let
    [credentials8072 (:credentials m8071) args8073 (:args m8071)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8074
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8072)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8074
       describeDefaultSearchField
       (cloudsearch/describe-default-search-field-request
        (clojure.core/nth args8073 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-default-search-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultSearchField"}
   [credentials8076 & args8077]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8078
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8076)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8078
      describeDefaultSearchField
      (cloudsearch/describe-default-search-field-request
       (clojure.core/nth args8077 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m8079]
   (clojure.core/let
    [credentials8080 (:credentials m8079) args8081 (:args m8079)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8082
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8080)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8082
       updateDefaultSearchField
       (cloudsearch/update-default-search-field-request
        (clojure.core/nth args8081 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root
                         default-search-field]}]]),
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-default-search-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root
                         default-search-field]}]]),
    :doc "Call updateDefaultSearchField"}
   [credentials8084 & args8085]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8086
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8084)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8086
      updateDefaultSearchField
      (cloudsearch/update-default-search-field-request
       (clojure.core/nth args8085 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m8087]
   (clojure.core/let
    [credentials8088 (:credentials m8087) args8089 (:args m8087)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8090
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8088)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8090
       describeIndexFields
       (cloudsearch/describe-index-fields-request
        (clojure.core/nth args8089 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         field-names
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeIndexFields"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-index-fields,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-index-fields
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         field-names
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeIndexFields"}
   [credentials8092 & args8093]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8094
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8092)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8094
      describeIndexFields
      (cloudsearch/describe-index-fields-request
       (clojure.core/nth args8093 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-availability-options
   [m8095]
   (clojure.core/let
    [credentials8096 (:credentials m8095) args8097 (:args m8095)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8098
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8096)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8098
       updateAvailabilityOptions
       (cloudsearch/update-availability-options-request
        (clojure.core/nth args8097 0)))))))
  (clojure.core/defn
   update-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         multi-az
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAvailabilityOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-availability-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         multi-az
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAvailabilityOptions"}
   [credentials8100 & args8101]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8102
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8100)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8102
      updateAvailabilityOptions
      (cloudsearch/update-availability-options-request
       (clojure.core/nth args8101 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m8103]
   (clojure.core/let
    [credentials8104 (:credentials m8103) args8105 (:args m8103)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8106
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8104)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8106
       updateServiceAccessPolicies
       (cloudsearch/update-service-access-policies-request
        (clojure.core/nth args8105 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         access-policies
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-service-access-policies,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         access-policies
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServiceAccessPolicies"}
   [credentials8108 & args8109]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8110
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8108)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8110
      updateServiceAccessPolicies
      (cloudsearch/update-service-access-policies-request
       (clojure.core/nth args8109 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m8111]
   (clojure.core/let
    [credentials8112 (:credentials m8111) args8113 (:args m8111)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8114
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8112)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8114
       describeServiceAccessPolicies
       (cloudsearch/describe-service-access-policies-request
        (clojure.core/nth args8113 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-service-access-policies,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeServiceAccessPolicies"}
   [credentials8116 & args8117]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8118
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8116)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8118
      describeServiceAccessPolicies
      (cloudsearch/describe-service-access-policies-request
       (clojure.core/nth args8117 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m8119]
   (clojure.core/let
    [credentials8120 (:credentials m8119) args8121 (:args m8119)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8122
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8120)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8122
       describeStopwordOptions
       (cloudsearch/describe-stopword-options-request
        (clojure.core/nth args8121 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stopword-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStopwordOptions"}
   [credentials8124 & args8125]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8126
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8124)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8126
      describeStopwordOptions
      (cloudsearch/describe-stopword-options-request
       (clojure.core/nth args8125 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m8127]
   (clojure.core/let
    [credentials8128 (:credentials m8127) args8129 (:args m8127)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8130
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8128)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8130
       describeSynonymOptions
       (cloudsearch/describe-synonym-options-request
        (clojure.core/nth args8129 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-synonym-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSynonymOptions"}
   [credentials8132 & args8133]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8134
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8132)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8134
      describeSynonymOptions
      (cloudsearch/describe-synonym-options-request
       (clojure.core/nth args8133 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m8135]
   (clojure.core/let
    [credentials8136 (:credentials m8135) args8137 (:args m8135)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8138
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8136)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8138
       deleteRankExpression
       (cloudsearch/delete-rank-expression-request
        (clojure.core/nth args8137 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         rank-name
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRankExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-rank-expression,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         rank-name
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRankExpression"}
   [credentials8140 & args8141]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8142
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8140)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8142
      deleteRankExpression
      (cloudsearch/delete-rank-expression-request
       (clojure.core/nth args8141 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m8143]
   (clojure.core/let
    [credentials8144 (:credentials m8143) args8145 (:args m8143)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8146
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8144)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8146
       deleteIndexField
       (cloudsearch/delete-index-field-request
        (clojure.core/nth args8145 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         index-field-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIndexField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-index-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-index-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         index-field-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIndexField"}
   [credentials8148 & args8149]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8150
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8148)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8150
      deleteIndexField
      (cloudsearch/delete-index-field-request
       (clojure.core/nth args8149 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-availability-options
   [m8151]
   (clojure.core/let
    [credentials8152 (:credentials m8151) args8153 (:args m8151)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8154
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8152)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8154
       describeAvailabilityOptions
       (cloudsearch/describe-availability-options-request
        (clojure.core/nth args8153 0)))))))
  (clojure.core/defn
   describe-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAvailabilityOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-availability-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAvailabilityOptions"}
   [credentials8156 & args8157]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8158
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8156)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8158
      describeAvailabilityOptions
      (cloudsearch/describe-availability-options-request
       (clojure.core/nth args8157 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m8159]
   (clojure.core/let
    [credentials8160 (:credentials m8159) args8161 (:args m8159)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8162
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8160)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8162
       createDomain
       (cloudsearch/create-domain-request
        (clojure.core/nth args8161 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8164 & args8165]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8166
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8164)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8166
      createDomain
      (cloudsearch/create-domain-request
       (clojure.core/nth args8165 0))))))))
