(ns
 com.palletops.awaze.cloudfront
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudfront :as cloudfront]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ItemSelection}
item-selection
  [m11999]
  (.
   com.amazonaws.services.cloudfront.model.ItemSelection
   fromValue
   (clojure.core/name m11999)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookieNames}
cookie-names
  [m12002]
  (clojure.core/let
   [bean12001
    (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/let
    [v12003
     (:quantity m12002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (. bean12001 setQuantity (clojure.core/int v12003))))
   (clojure.core/let
    [v12003 (:items m12002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (.
      bean12001
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12166] (clojure.core/str arg12166))
 v12003))))
   bean12001))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Headers}
headers
  [m12005]
  (clojure.core/let
   [bean12004 (new com.amazonaws.services.cloudfront.model.Headers)]
   (clojure.core/let
    [v12006
     (:quantity m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setQuantity (clojure.core/int v12006))))
   (clojure.core/let
    [v12006 (:items m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (.
      bean12004
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12167] (clojure.core/str arg12167))
 v12006))))
   bean12004))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookiePreference}
cookie-preference
  [m12008]
  (clojure.core/let
   [bean12007
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/let
    [v12009
     (:forward m12008 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12009 :com.palletops.awaze.client-builder/undef)
     (. bean12007 setForward (cloudfront/item-selection v12009))))
   (clojure.core/let
    [v12009
     (:whitelisted-names
      m12008
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12009 :com.palletops.awaze.client-builder/undef)
     (.
      bean12007
      setWhitelistedNames
      (cloudfront/cookie-names v12009))))
   bean12007))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CachedMethods}
cached-methods
  [m12011]
  (clojure.core/let
   [bean12010
    (new com.amazonaws.services.cloudfront.model.CachedMethods)]
   (clojure.core/let
    [v12012
     (:quantity m12011 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setQuantity (clojure.core/int v12012))))
   (clojure.core/let
    [v12012 (:items m12011 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (.
      bean12010
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12168] (clojure.core/str arg12168))
 v12012))))
   bean12010))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginCustomHeader}
origin-custom-header
  [m12014]
  (clojure.core/let
   [bean12013
    (new com.amazonaws.services.cloudfront.model.OriginCustomHeader)]
   (clojure.core/let
    [v12015
     (:header-name m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setHeaderName (clojure.core/str v12015))))
   (clojure.core/let
    [v12015
     (:header-value m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setHeaderValue (clojure.core/str v12015))))
   bean12013))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginSslProtocols}
origin-ssl-protocols
  [m12017]
  (clojure.core/let
   [bean12016
    (new com.amazonaws.services.cloudfront.model.OriginSslProtocols)]
   (clojure.core/let
    [v12018
     (:quantity m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setQuantity (clojure.core/int v12018))))
   (clojure.core/let
    [v12018 (:items m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (.
      bean12016
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12169] (clojure.core/str arg12169))
 v12018))))
   bean12016))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ForwardedValues}
forwarded-values
  [m12020]
  (clojure.core/let
   [bean12019
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/let
    [v12021
     (:headers m12020 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setHeaders (cloudfront/headers v12021))))
   (clojure.core/let
    [v12021
     (:query-string m12020 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setQueryString (clojure.core/boolean v12021))))
   (clojure.core/let
    [v12021
     (:cookies m12020 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setCookies (cloudfront/cookie-preference v12021))))
   bean12019))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.TrustedSigners}
trusted-signers
  [m12023]
  (clojure.core/let
   [bean12022
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/let
    [v12024
     (:enabled m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setEnabled (clojure.core/boolean v12024))))
   (clojure.core/let
    [v12024
     (:quantity m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setQuantity (clojure.core/int v12024))))
   (clojure.core/let
    [v12024 (:items m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (.
      bean12022
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12170] (clojure.core/str arg12170))
 v12024))))
   bean12022))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy}
viewer-protocol-policy
  [m12026]
  (.
   com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy
   fromValue
   (clojure.core/name m12026)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.AllowedMethods}
allowed-methods
  [m12029]
  (clojure.core/let
   [bean12028
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/let
    [v12030
     (:cached-methods
      m12029
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (. bean12028 setCachedMethods (cloudfront/cached-methods v12030))))
   (clojure.core/let
    [v12030
     (:quantity m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (. bean12028 setQuantity (clojure.core/int v12030))))
   (clojure.core/let
    [v12030 (:items m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (.
      bean12028
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12171] (clojure.core/str arg12171))
 v12030))))
   bean12028))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomHeaders}
custom-headers
  [m12032]
  (clojure.core/let
   [bean12031
    (new com.amazonaws.services.cloudfront.model.CustomHeaders)]
   (clojure.core/let
    [v12033
     (:quantity m12032 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (. bean12031 setQuantity (clojure.core/int v12033))))
   (clojure.core/let
    [v12033 (:items m12032 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (.
      bean12031
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12172]
  (cloudfront/origin-custom-header arg12172))
 v12033))))
   bean12031))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3OriginConfig}
s3origin-config
  [m12035]
  (clojure.core/let
   [bean12034
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/let
    [v12036
     (:origin-access-identity
      m12035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setOriginAccessIdentity (clojure.core/str v12036))))
   bean12034))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomOriginConfig}
custom-origin-config
  [m12038]
  (clojure.core/let
   [bean12037
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/let
    [v12039
     (:httpport m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setHTTPPort (clojure.core/int v12039))))
   (clojure.core/let
    [v12039
     (:httpsport m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setHTTPSPort (clojure.core/int v12039))))
   (clojure.core/let
    [v12039
     (:origin-protocol-policy
      m12038
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setOriginProtocolPolicy (clojure.core/str v12039))))
   (clojure.core/let
    [v12039
     (:origin-ssl-protocols
      m12038
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (.
      bean12037
      setOriginSslProtocols
      (cloudfront/origin-ssl-protocols v12039))))
   bean12037))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GeoRestriction}
geo-restriction
  [m12041]
  (clojure.core/let
   [bean12040
    (new com.amazonaws.services.cloudfront.model.GeoRestriction)]
   (clojure.core/let
    [v12042
     (:restriction-type
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setRestrictionType (clojure.core/str v12042))))
   (clojure.core/let
    [v12042
     (:quantity m12041 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setQuantity (clojure.core/int v12042))))
   (clojure.core/let
    [v12042 (:items m12041 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (.
      bean12040
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12173] (clojure.core/str arg12173))
 v12042))))
   bean12040))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehavior}
cache-behavior
  [m12044]
  (clojure.core/let
   [bean12043
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/let
    [v12045
     (:smooth-streaming
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setSmoothStreaming (clojure.core/boolean v12045))))
   (clojure.core/let
    [v12045
     (:path-pattern m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setPathPattern (clojure.core/str v12045))))
   (clojure.core/let
    [v12045
     (:forwarded-values
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (.
      bean12043
      setForwardedValues
      (cloudfront/forwarded-values v12045))))
   (clojure.core/let
    [v12045
     (:trusted-signers
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (.
      bean12043
      setTrustedSigners
      (cloudfront/trusted-signers v12045))))
   (clojure.core/let
    [v12045
     (:max-ttl m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setMaxTTL (clojure.core/long v12045))))
   (clojure.core/let
    [v12045
     (:viewer-protocol-policy
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (.
      bean12043
      setViewerProtocolPolicy
      (cloudfront/viewer-protocol-policy v12045))))
   (clojure.core/let
    [v12045
     (:target-origin-id
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setTargetOriginId (clojure.core/str v12045))))
   (clojure.core/let
    [v12045
     (:default-ttl m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setDefaultTTL (clojure.core/long v12045))))
   (clojure.core/let
    [v12045
     (:compress m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setCompress (clojure.core/boolean v12045))))
   (clojure.core/let
    [v12045
     (:allowed-methods
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (.
      bean12043
      setAllowedMethods
      (cloudfront/allowed-methods v12045))))
   (clojure.core/let
    [v12045
     (:min-ttl m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setMinTTL (clojure.core/long v12045))))
   bean12043))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.MinimumProtocolVersion}
minimum-protocol-version
  [m12047]
  (.
   com.amazonaws.services.cloudfront.model.MinimumProtocolVersion
   fromValue
   (clojure.core/name m12047)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origin}
origin
  [m12050]
  (clojure.core/let
   [bean12049 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/let
    [v12051
     (:origin-path m12050 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setOriginPath (clojure.core/str v12051))))
   (clojure.core/let
    [v12051
     (:custom-headers
      m12050
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setCustomHeaders (cloudfront/custom-headers v12051))))
   (clojure.core/let
    [v12051
     (:s3origin-config
      m12050
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (.
      bean12049
      setS3OriginConfig
      (cloudfront/s3origin-config v12051))))
   (clojure.core/let
    [v12051
     (:custom-origin-config
      m12050
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (.
      bean12049
      setCustomOriginConfig
      (cloudfront/custom-origin-config v12051))))
   (clojure.core/let
    [v12051
     (:domain-name m12050 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setDomainName (clojure.core/str v12051))))
   (clojure.core/let
    [v12051 (:id m12050 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setId (clojure.core/str v12051))))
   bean12049))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponse}
custom-error-response
  [m12053]
  (clojure.core/let
   [bean12052
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/let
    [v12054
     (:response-page-path
      m12053
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setResponsePagePath (clojure.core/str v12054))))
   (clojure.core/let
    [v12054
     (:response-code m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setResponseCode (clojure.core/str v12054))))
   (clojure.core/let
    [v12054
     (:error-caching-min-ttl
      m12053
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setErrorCachingMinTTL (clojure.core/long v12054))))
   (clojure.core/let
    [v12054
     (:error-code m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setErrorCode (clojure.core/int v12054))))
   bean12052))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Paths}
paths
  [m12056]
  (clojure.core/let
   [bean12055 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/let
    [v12057
     (:quantity m12056 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12057 :com.palletops.awaze.client-builder/undef)
     (. bean12055 setQuantity (clojure.core/int v12057))))
   (clojure.core/let
    [v12057 (:items m12056 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12057 :com.palletops.awaze.client-builder/undef)
     (.
      bean12055
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12174] (clojure.core/str arg12174))
 v12057))))
   bean12055))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Restrictions}
restrictions
  [m12059]
  (clojure.core/let
   [bean12058
    (new com.amazonaws.services.cloudfront.model.Restrictions)]
   (clojure.core/let
    [v12060
     (:geo-restriction
      m12059
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12060 :com.palletops.awaze.client-builder/undef)
     (.
      bean12058
      setGeoRestriction
      (cloudfront/geo-restriction v12060))))
   bean12058))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DefaultCacheBehavior}
default-cache-behavior
  [m12062]
  (clojure.core/let
   [bean12061
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/let
    [v12063
     (:smooth-streaming
      m12062
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setSmoothStreaming (clojure.core/boolean v12063))))
   (clojure.core/let
    [v12063
     (:forwarded-values
      m12062
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (.
      bean12061
      setForwardedValues
      (cloudfront/forwarded-values v12063))))
   (clojure.core/let
    [v12063
     (:trusted-signers
      m12062
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (.
      bean12061
      setTrustedSigners
      (cloudfront/trusted-signers v12063))))
   (clojure.core/let
    [v12063
     (:max-ttl m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setMaxTTL (clojure.core/long v12063))))
   (clojure.core/let
    [v12063
     (:viewer-protocol-policy
      m12062
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (.
      bean12061
      setViewerProtocolPolicy
      (cloudfront/viewer-protocol-policy v12063))))
   (clojure.core/let
    [v12063
     (:target-origin-id
      m12062
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setTargetOriginId (clojure.core/str v12063))))
   (clojure.core/let
    [v12063
     (:default-ttl m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setDefaultTTL (clojure.core/long v12063))))
   (clojure.core/let
    [v12063
     (:compress m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setCompress (clojure.core/boolean v12063))))
   (clojure.core/let
    [v12063
     (:allowed-methods
      m12062
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (.
      bean12061
      setAllowedMethods
      (cloudfront/allowed-methods v12063))))
   (clojure.core/let
    [v12063
     (:min-ttl m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setMinTTL (clojure.core/long v12063))))
   bean12061))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehaviors}
cache-behaviors
  [m12065]
  (clojure.core/let
   [bean12064
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/let
    [v12066
     (:quantity m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setQuantity (clojure.core/int v12066))))
   (clojure.core/let
    [v12066 (:items m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (.
      bean12064
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12175] (cloudfront/cache-behavior arg12175))
 v12066))))
   bean12064))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerCertificate}
viewer-certificate
  [m12068]
  (clojure.core/let
   [bean12067
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/let
    [v12069
     (:certificate m12068 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (. bean12067 setCertificate (clojure.core/str v12069))))
   (clojure.core/let
    [v12069
     (:certificate-source
      m12068
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (. bean12067 setCertificateSource (clojure.core/str v12069))))
   (clojure.core/let
    [v12069
     (:cloud-front-default-certificate
      m12068
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (.
      bean12067
      setCloudFrontDefaultCertificate
      (clojure.core/boolean v12069))))
   (clojure.core/let
    [v12069
     (:iamcertificate-id
      m12068
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (. bean12067 setIAMCertificateId (clojure.core/str v12069))))
   (clojure.core/let
    [v12069
     (:acmcertificate-arn
      m12068
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (. bean12067 setACMCertificateArn (clojure.core/str v12069))))
   (clojure.core/let
    [v12069
     (:sslsupport-method
      m12068
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (. bean12067 setSSLSupportMethod (clojure.core/str v12069))))
   (clojure.core/let
    [v12069
     (:minimum-protocol-version
      m12068
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (.
      bean12067
      setMinimumProtocolVersion
      (cloudfront/minimum-protocol-version v12069))))
   bean12067))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Aliases}
aliases
  [m12071]
  (clojure.core/let
   [bean12070 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/let
    [v12072
     (:quantity m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setQuantity (clojure.core/int v12072))))
   (clojure.core/let
    [v12072 (:items m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (.
      bean12070
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12176] (clojure.core/str arg12176))
 v12072))))
   bean12070))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origins}
origins
  [m12074]
  (clojure.core/let
   [bean12073 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/let
    [v12075
     (:quantity m12074 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12075 :com.palletops.awaze.client-builder/undef)
     (. bean12073 setQuantity (clojure.core/int v12075))))
   (clojure.core/let
    [v12075 (:items m12074 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12075 :com.palletops.awaze.client-builder/undef)
     (.
      bean12073
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12177] (cloudfront/origin arg12177))
 v12075))))
   bean12073))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.LoggingConfig}
logging-config
  [m12077]
  (clojure.core/let
   [bean12076
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/let
    [v12078
     (:enabled m12077 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (. bean12076 setEnabled (clojure.core/boolean v12078))))
   (clojure.core/let
    [v12078
     (:include-cookies
      m12077
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (. bean12076 setIncludeCookies (clojure.core/boolean v12078))))
   (clojure.core/let
    [v12078
     (:bucket m12077 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (. bean12076 setBucket (clojure.core/str v12078))))
   (clojure.core/let
    [v12078
     (:prefix m12077 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (. bean12076 setPrefix (clojure.core/str v12078))))
   bean12076))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponses}
custom-error-responses
  [m12080]
  (clojure.core/let
   [bean12079
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/let
    [v12081
     (:quantity m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (. bean12079 setQuantity (clojure.core/int v12081))))
   (clojure.core/let
    [v12081 (:items m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (.
      bean12079
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12178]
  (cloudfront/custom-error-response arg12178))
 v12081))))
   bean12079))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingLoggingConfig}
streaming-logging-config
  [m12083]
  (clojure.core/let
   [bean12082
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/let
    [v12084
     (:enabled m12083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12084 :com.palletops.awaze.client-builder/undef)
     (. bean12082 setEnabled (clojure.core/boolean v12084))))
   (clojure.core/let
    [v12084
     (:bucket m12083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12084 :com.palletops.awaze.client-builder/undef)
     (. bean12082 setBucket (clojure.core/str v12084))))
   (clojure.core/let
    [v12084
     (:prefix m12083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12084 :com.palletops.awaze.client-builder/undef)
     (. bean12082 setPrefix (clojure.core/str v12084))))
   bean12082))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3Origin}
s3origin
  [m12086]
  (clojure.core/let
   [bean12085 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/let
    [v12087
     (:origin-access-identity
      m12086
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12087 :com.palletops.awaze.client-builder/undef)
     (. bean12085 setOriginAccessIdentity (clojure.core/str v12087))))
   (clojure.core/let
    [v12087
     (:domain-name m12086 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12087 :com.palletops.awaze.client-builder/undef)
     (. bean12085 setDomainName (clojure.core/str v12087))))
   bean12085))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.InvalidationBatch}
invalidation-batch
  [m12089]
  (clojure.core/let
   [bean12088
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/let
    [v12090
     (:caller-reference
      m12089
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setCallerReference (clojure.core/str v12090))))
   (clojure.core/let
    [v12090 (:paths m12089 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setPaths (cloudfront/paths v12090))))
   bean12088))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DistributionConfig}
distribution-config
  [m12092]
  (clojure.core/let
   [bean12091
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/let
    [v12093
     (:restrictions m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setRestrictions (cloudfront/restrictions v12093))))
   (clojure.core/let
    [v12093
     (:default-root-object
      m12092
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setDefaultRootObject (clojure.core/str v12093))))
   (clojure.core/let
    [v12093
     (:default-cache-behavior
      m12092
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (.
      bean12091
      setDefaultCacheBehavior
      (cloudfront/default-cache-behavior v12093))))
   (clojure.core/let
    [v12093
     (:comment m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setComment (clojure.core/str v12093))))
   (clojure.core/let
    [v12093
     (:cache-behaviors
      m12092
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (.
      bean12091
      setCacheBehaviors
      (cloudfront/cache-behaviors v12093))))
   (clojure.core/let
    [v12093
     (:viewer-certificate
      m12092
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (.
      bean12091
      setViewerCertificate
      (cloudfront/viewer-certificate v12093))))
   (clojure.core/let
    [v12093
     (:aliases m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setAliases (cloudfront/aliases v12093))))
   (clojure.core/let
    [v12093
     (:enabled m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setEnabled (clojure.core/boolean v12093))))
   (clojure.core/let
    [v12093
     (:price-class m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setPriceClass (clojure.core/str v12093))))
   (clojure.core/let
    [v12093
     (:origins m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setOrigins (cloudfront/origins v12093))))
   (clojure.core/let
    [v12093
     (:caller-reference
      m12092
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setCallerReference (clojure.core/str v12093))))
   (clojure.core/let
    [v12093
     (:logging m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setLogging (cloudfront/logging-config v12093))))
   (clojure.core/let
    [v12093
     (:web-aclid m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setWebACLId (clojure.core/str v12093))))
   (clojure.core/let
    [v12093
     (:custom-error-responses
      m12092
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (.
      bean12091
      setCustomErrorResponses
      (cloudfront/custom-error-responses v12093))))
   bean12091))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig}
cloud-front-origin-access-identity-config
  [m12095]
  (clojure.core/let
   [bean12094
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/let
    [v12096
     (:comment m12095 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12096 :com.palletops.awaze.client-builder/undef)
     (. bean12094 setComment (clojure.core/str v12096))))
   (clojure.core/let
    [v12096
     (:caller-reference
      m12095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12096 :com.palletops.awaze.client-builder/undef)
     (. bean12094 setCallerReference (clojure.core/str v12096))))
   bean12094))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingDistributionConfig}
streaming-distribution-config
  [m12098]
  (clojure.core/let
   [bean12097
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/let
    [v12099
     (:comment m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setComment (clojure.core/str v12099))))
   (clojure.core/let
    [v12099
     (:enabled m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setEnabled (clojure.core/boolean v12099))))
   (clojure.core/let
    [v12099
     (:caller-reference
      m12098
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setCallerReference (clojure.core/str v12099))))
   (clojure.core/let
    [v12099
     (:aliases m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setAliases (cloudfront/aliases v12099))))
   (clojure.core/let
    [v12099
     (:logging m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (.
      bean12097
      setLogging
      (cloudfront/streaming-logging-config v12099))))
   (clojure.core/let
    [v12099
     (:price-class m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setPriceClass (clojure.core/str v12099))))
   (clojure.core/let
    [v12099
     (:s3origin m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setS3Origin (cloudfront/s3origin v12099))))
   (clojure.core/let
    [v12099
     (:trusted-signers
      m12098
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (.
      bean12097
      setTrustedSigners
      (cloudfront/trusted-signers v12099))))
   bean12097))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest}
get-streaming-distribution-request
  [m12101]
  (clojure.core/let
   [bean12100
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/let
    [v12102 (:id m12101 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12102 :com.palletops.awaze.client-builder/undef)
     (. bean12100 setId (clojure.core/str v12102))))
   bean12100))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateInvalidationRequest}
create-invalidation-request
  [m12104]
  (clojure.core/let
   [bean12103
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/let
    [v12105
     (:distribution-id
      m12104
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (. bean12103 setDistributionId (clojure.core/str v12105))))
   (clojure.core/let
    [v12105
     (:invalidation-batch
      m12104
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (.
      bean12103
      setInvalidationBatch
      (cloudfront/invalidation-batch v12105))))
   bean12103))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteDistributionRequest}
delete-distribution-request
  [m12107]
  (clojure.core/let
   [bean12106
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/let
    [v12108
     (:if-match m12107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12108 :com.palletops.awaze.client-builder/undef)
     (. bean12106 setIfMatch (clojure.core/str v12108))))
   (clojure.core/let
    [v12108 (:id m12107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12108 :com.palletops.awaze.client-builder/undef)
     (. bean12106 setId (clojure.core/str v12108))))
   bean12106))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest}
delete-cloud-front-origin-access-identity-request
  [m12110]
  (clojure.core/let
   [bean12109
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12111
     (:if-match m12110 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12111 :com.palletops.awaze.client-builder/undef)
     (. bean12109 setIfMatch (clojure.core/str v12111))))
   (clojure.core/let
    [v12111 (:id m12110 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12111 :com.palletops.awaze.client-builder/undef)
     (. bean12109 setId (clojure.core/str v12111))))
   bean12109))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateDistributionRequest}
create-distribution-request
  [m12113]
  (clojure.core/let
   [bean12112
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/let
    [v12114
     (:distribution-config
      m12113
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12114 :com.palletops.awaze.client-builder/undef)
     (.
      bean12112
      setDistributionConfig
      (cloudfront/distribution-config v12114))))
   bean12112))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListInvalidationsRequest}
list-invalidations-request
  [m12116]
  (clojure.core/let
   [bean12115
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/let
    [v12117
     (:distribution-id
      m12116
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12117 :com.palletops.awaze.client-builder/undef)
     (. bean12115 setDistributionId (clojure.core/str v12117))))
   (clojure.core/let
    [v12117
     (:marker m12116 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12117 :com.palletops.awaze.client-builder/undef)
     (. bean12115 setMarker (clojure.core/str v12117))))
   (clojure.core/let
    [v12117
     (:max-items m12116 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12117 :com.palletops.awaze.client-builder/undef)
     (. bean12115 setMaxItems (clojure.core/str v12117))))
   bean12115))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest}
list-streaming-distributions-request
  [m12119]
  (clojure.core/let
   [bean12118
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/let
    [v12120
     (:marker m12119 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12120 :com.palletops.awaze.client-builder/undef)
     (. bean12118 setMarker (clojure.core/str v12120))))
   (clojure.core/let
    [v12120
     (:max-items m12119 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12120 :com.palletops.awaze.client-builder/undef)
     (. bean12118 setMaxItems (clojure.core/str v12120))))
   bean12118))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest}
get-cloud-front-origin-access-identity-config-request
  [m12122]
  (clojure.core/let
   [bean12121
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/let
    [v12123 (:id m12122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12123 :com.palletops.awaze.client-builder/undef)
     (. bean12121 setId (clojure.core/str v12123))))
   bean12121))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsRequest}
list-distributions-request
  [m12125]
  (clojure.core/let
   [bean12124
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/let
    [v12126
     (:marker m12125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12126 :com.palletops.awaze.client-builder/undef)
     (. bean12124 setMarker (clojure.core/str v12126))))
   (clojure.core/let
    [v12126
     (:max-items m12125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12126 :com.palletops.awaze.client-builder/undef)
     (. bean12124 setMaxItems (clojure.core/str v12126))))
   bean12124))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest}
create-cloud-front-origin-access-identity-request
  [m12128]
  (clojure.core/let
   [bean12127
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12129
     (:cloud-front-origin-access-identity-config
      m12128
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12129 :com.palletops.awaze.client-builder/undef)
     (.
      bean12127
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12129))))
   bean12127))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest}
update-streaming-distribution-request
  [m12131]
  (clojure.core/let
   [bean12130
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/let
    [v12132
     (:streaming-distribution-config
      m12131
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12132 :com.palletops.awaze.client-builder/undef)
     (.
      bean12130
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12132))))
   (clojure.core/let
    [v12132
     (:if-match m12131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12132 :com.palletops.awaze.client-builder/undef)
     (. bean12130 setIfMatch (clojure.core/str v12132))))
   (clojure.core/let
    [v12132 (:id m12131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12132 :com.palletops.awaze.client-builder/undef)
     (. bean12130 setId (clojure.core/str v12132))))
   bean12130))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest}
list-distributions-by-web-aclid-request
  [m12134]
  (clojure.core/let
   [bean12133
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest)]
   (clojure.core/let
    [v12135
     (:web-aclid m12134 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12135 :com.palletops.awaze.client-builder/undef)
     (. bean12133 setWebACLId (clojure.core/str v12135))))
   (clojure.core/let
    [v12135
     (:marker m12134 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12135 :com.palletops.awaze.client-builder/undef)
     (. bean12133 setMarker (clojure.core/str v12135))))
   (clojure.core/let
    [v12135
     (:max-items m12134 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12135 :com.palletops.awaze.client-builder/undef)
     (. bean12133 setMaxItems (clojure.core/str v12135))))
   bean12133))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest}
list-cloud-front-origin-access-identities-request
  [m12137]
  (clojure.core/let
   [bean12136
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/let
    [v12138
     (:marker m12137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12138 :com.palletops.awaze.client-builder/undef)
     (. bean12136 setMarker (clojure.core/str v12138))))
   (clojure.core/let
    [v12138
     (:max-items m12137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12138 :com.palletops.awaze.client-builder/undef)
     (. bean12136 setMaxItems (clojure.core/str v12138))))
   bean12136))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionRequest}
get-distribution-request
  [m12140]
  (clojure.core/let
   [bean12139
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/let
    [v12141 (:id m12140 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12141 :com.palletops.awaze.client-builder/undef)
     (. bean12139 setId (clojure.core/str v12141))))
   bean12139))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest}
delete-streaming-distribution-request
  [m12143]
  (clojure.core/let
   [bean12142
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/let
    [v12144
     (:if-match m12143 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12144 :com.palletops.awaze.client-builder/undef)
     (. bean12142 setIfMatch (clojure.core/str v12144))))
   (clojure.core/let
    [v12144 (:id m12143 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12144 :com.palletops.awaze.client-builder/undef)
     (. bean12142 setId (clojure.core/str v12144))))
   bean12142))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest}
get-distribution-config-request
  [m12146]
  (clojure.core/let
   [bean12145
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/let
    [v12147 (:id m12146 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12147 :com.palletops.awaze.client-builder/undef)
     (. bean12145 setId (clojure.core/str v12147))))
   bean12145))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateDistributionRequest}
update-distribution-request
  [m12149]
  (clojure.core/let
   [bean12148
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/let
    [v12150
     (:distribution-config
      m12149
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12150 :com.palletops.awaze.client-builder/undef)
     (.
      bean12148
      setDistributionConfig
      (cloudfront/distribution-config v12150))))
   (clojure.core/let
    [v12150
     (:if-match m12149 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12150 :com.palletops.awaze.client-builder/undef)
     (. bean12148 setIfMatch (clojure.core/str v12150))))
   (clojure.core/let
    [v12150 (:id m12149 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12150 :com.palletops.awaze.client-builder/undef)
     (. bean12148 setId (clojure.core/str v12150))))
   bean12148))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest}
get-cloud-front-origin-access-identity-request
  [m12152]
  (clojure.core/let
   [bean12151
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12153 (:id m12152 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12153 :com.palletops.awaze.client-builder/undef)
     (. bean12151 setId (clojure.core/str v12153))))
   bean12151))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest}
get-streaming-distribution-config-request
  [m12155]
  (clojure.core/let
   [bean12154
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/let
    [v12156 (:id m12155 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12156 :com.palletops.awaze.client-builder/undef)
     (. bean12154 setId (clojure.core/str v12156))))
   bean12154))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest}
update-cloud-front-origin-access-identity-request
  [m12158]
  (clojure.core/let
   [bean12157
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12159
     (:cloud-front-origin-access-identity-config
      m12158
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12159 :com.palletops.awaze.client-builder/undef)
     (.
      bean12157
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12159))))
   (clojure.core/let
    [v12159
     (:if-match m12158 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12159 :com.palletops.awaze.client-builder/undef)
     (. bean12157 setIfMatch (clojure.core/str v12159))))
   (clojure.core/let
    [v12159 (:id m12158 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12159 :com.palletops.awaze.client-builder/undef)
     (. bean12157 setId (clojure.core/str v12159))))
   bean12157))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest}
create-streaming-distribution-request
  [m12161]
  (clojure.core/let
   [bean12160
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/let
    [v12162
     (:streaming-distribution-config
      m12161
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12162 :com.palletops.awaze.client-builder/undef)
     (.
      bean12160
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12162))))
   bean12160))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetInvalidationRequest}
get-invalidation-request
  [m12164]
  (clojure.core/let
   [bean12163
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/let
    [v12165
     (:distribution-id
      m12164
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12165 :com.palletops.awaze.client-builder/undef)
     (. bean12163 setDistributionId (clojure.core/str v12165))))
   (clojure.core/let
    [v12165 (:id m12164 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12165 :com.palletops.awaze.client-builder/undef)
     (. bean12163 setId (clojure.core/str v12165))))
   bean12163))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m12179]
   (clojure.core/let
    [credentials12180 (:credentials m12179) args12181 (:args m12179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12182
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12182
       getStreamingDistribution
       (cloudfront/get-streaming-distribution-request
        (clojure.core/nth args12181 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistribution"}
   [credentials12184 & args12185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12186
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12186
      getStreamingDistribution
      (cloudfront/get-streaming-distribution-request
       (clojure.core/nth args12185 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m12187]
   (clojure.core/let
    [credentials12188 (:credentials m12187) args12189 (:args m12187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12190
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12188)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12190
       createInvalidation
       (cloudfront/create-invalidation-request
        (clojure.core/nth args12189 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInvalidation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-invalidation,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInvalidation"}
   [credentials12192 & args12193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12194
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12192)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12194
      createInvalidation
      (cloudfront/create-invalidation-request
       (clojure.core/nth args12193 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m12195]
   (clojure.core/let
    [credentials12196 (:credentials m12195) args12197 (:args m12195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12198
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12196)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12198
       deleteDistribution
       (cloudfront/delete-distribution-request
        (clojure.core/nth args12197 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDistribution"}
   [credentials12200 & args12201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12202
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12200)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12202
      deleteDistribution
      (cloudfront/delete-distribution-request
       (clojure.core/nth args12201 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m12203]
   (clojure.core/let
    [credentials12204 (:credentials m12203) args12205 (:args m12203)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12206
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12204)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12206
       deleteCloudFrontOriginAccessIdentity
       (cloudfront/delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args12205 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials12208 & args12209]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12210
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12208)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12210
      deleteCloudFrontOriginAccessIdentity
      (cloudfront/delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args12209 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m12211]
   (clojure.core/let
    [credentials12212 (:credentials m12211) args12213 (:args m12211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12214
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12212)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12214
       createDistribution
       (cloudfront/create-distribution-request
        (clojure.core/nth args12213 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDistribution"}
   [credentials12216 & args12217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12218
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12216)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12218
      createDistribution
      (cloudfront/create-distribution-request
       (clojure.core/nth args12217 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m12219]
   (clojure.core/let
    [credentials12220 (:credentials m12219) args12221 (:args m12219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12222
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12222
       listInvalidations
       (cloudfront/list-invalidations-request
        (clojure.core/nth args12221 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInvalidations"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-invalidations,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-invalidations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInvalidations"}
   [credentials12224 & args12225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12226
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12226
      listInvalidations
      (cloudfront/list-invalidations-request
       (clojure.core/nth args12225 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m12227]
   (clojure.core/let
    [credentials12228 (:credentials m12227) args12229 (:args m12227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12230
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12230
       listStreamingDistributions
       (cloudfront/list-streaming-distributions-request
        (clojure.core/nth args12229 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-streaming-distributions,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listStreamingDistributions"}
   [credentials12232 & args12233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12234
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12234
      listStreamingDistributions
      (cloudfront/list-streaming-distributions-request
       (clojure.core/nth args12233 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m12235]
   (clojure.core/let
    [credentials12236 (:credentials m12235) args12237 (:args m12235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12238
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12238
       getCloudFrontOriginAccessIdentityConfig
       (cloudfront/get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args12237 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials12240 & args12241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12242
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12242
      getCloudFrontOriginAccessIdentityConfig
      (cloudfront/get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args12241 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m12243]
   (clojure.core/let
    [credentials12244 (:credentials m12243) args12245 (:args m12243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12246
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12246
       listDistributions
       (cloudfront/list-distributions-request
        (clojure.core/nth args12245 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-distributions,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributions"}
   [credentials12248 & args12249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12250
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12250
      listDistributions
      (cloudfront/list-distributions-request
       (clojure.core/nth args12249 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m12251]
   (clojure.core/let
    [credentials12252 (:credentials m12251) args12253 (:args m12251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12254
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12254
       createCloudFrontOriginAccessIdentity
       (cloudfront/create-cloud-front-origin-access-identity-request
        (clojure.core/nth args12253 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials12256 & args12257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12258
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12258
      createCloudFrontOriginAccessIdentity
      (cloudfront/create-cloud-front-origin-access-identity-request
       (clojure.core/nth args12257 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m12259]
   (clojure.core/let
    [credentials12260 (:credentials m12259) args12261 (:args m12259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12262
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12262
       updateStreamingDistribution
       (cloudfront/update-streaming-distribution-request
        (clojure.core/nth args12261 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStreamingDistribution"}
   [credentials12264 & args12265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12266
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12266
      updateStreamingDistribution
      (cloudfront/update-streaming-distribution-request
       (clojure.core/nth args12265 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions-by-web-aclid
   [m12267]
   (clojure.core/let
    [credentials12268 (:credentials m12267) args12269 (:args m12267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12270
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12268)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12270
       listDistributionsByWebACLId
       (cloudfront/list-distributions-by-web-aclid-request
        (clojure.core/nth args12269 0)))))))
  (clojure.core/defn
   list-distributions-by-web-aclid-map
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributionsByWebACLId"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-distributions-by-web-aclid,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions-by-web-aclid
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributionsByWebACLId"}
   [credentials12272 & args12273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12274
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12272)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12274
      listDistributionsByWebACLId
      (cloudfront/list-distributions-by-web-aclid-request
       (clojure.core/nth args12273 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m12275]
   (clojure.core/let
    [credentials12276 (:credentials m12275) args12277 (:args m12275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12278
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12278
       listCloudFrontOriginAccessIdentities
       (cloudfront/list-cloud-front-origin-access-identities-request
        (clojure.core/nth args12277 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials12280 & args12281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12282
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12282
      listCloudFrontOriginAccessIdentities
      (cloudfront/list-cloud-front-origin-access-identities-request
       (clojure.core/nth args12281 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m12283]
   (clojure.core/let
    [credentials12284 (:credentials m12283) args12285 (:args m12283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12286
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12284)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12286
       getDistribution
       (cloudfront/get-distribution-request
        (clojure.core/nth args12285 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistribution"}
   [credentials12288 & args12289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12290
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12288)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12290
      getDistribution
      (cloudfront/get-distribution-request
       (clojure.core/nth args12289 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m12291]
   (clojure.core/let
    [credentials12292 (:credentials m12291) args12293 (:args m12291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12294
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12292)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12294
       deleteStreamingDistribution
       (cloudfront/delete-streaming-distribution-request
        (clojure.core/nth args12293 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStreamingDistribution"}
   [credentials12296 & args12297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12298
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12296)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12298
      deleteStreamingDistribution
      (cloudfront/delete-streaming-distribution-request
       (clojure.core/nth args12297 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m12299]
   (clojure.core/let
    [credentials12300 (:credentials m12299) args12301 (:args m12299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12302
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12300)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12302
       getDistributionConfig
       (cloudfront/get-distribution-config-request
        (clojure.core/nth args12301 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistributionConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-distribution-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistributionConfig"}
   [credentials12304 & args12305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12306
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12304)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12306
      getDistributionConfig
      (cloudfront/get-distribution-config-request
       (clojure.core/nth args12305 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m12307]
   (clojure.core/let
    [credentials12308 (:credentials m12307) args12309 (:args m12307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12310
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12310
       updateDistribution
       (cloudfront/update-distribution-request
        (clojure.core/nth args12309 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateDistribution"}
   [credentials12312 & args12313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12314
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12314
      updateDistribution
      (cloudfront/update-distribution-request
       (clojure.core/nth args12313 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m12315]
   (clojure.core/let
    [credentials12316 (:credentials m12315) args12317 (:args m12315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12318
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12316)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12318
       getCloudFrontOriginAccessIdentity
       (cloudfront/get-cloud-front-origin-access-identity-request
        (clojure.core/nth args12317 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials12320 & args12321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12322
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12320)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12322
      getCloudFrontOriginAccessIdentity
      (cloudfront/get-cloud-front-origin-access-identity-request
       (clojure.core/nth args12321 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m12323]
   (clojure.core/let
    [credentials12324 (:credentials m12323) args12325 (:args m12323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12326
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12324)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12326
       getStreamingDistributionConfig
       (cloudfront/get-streaming-distribution-config-request
        (clojure.core/nth args12325 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistributionConfig"}
   [credentials12328 & args12329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12330
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12328)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12330
      getStreamingDistributionConfig
      (cloudfront/get-streaming-distribution-config-request
       (clojure.core/nth args12329 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m12331]
   (clojure.core/let
    [credentials12332 (:credentials m12331) args12333 (:args m12331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12334
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12332)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12334
       updateCloudFrontOriginAccessIdentity
       (cloudfront/update-cloud-front-origin-access-identity-request
        (clojure.core/nth args12333 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials12336 & args12337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12338
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12336)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12338
      updateCloudFrontOriginAccessIdentity
      (cloudfront/update-cloud-front-origin-access-identity-request
       (clojure.core/nth args12337 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m12339]
   (clojure.core/let
    [credentials12340 (:credentials m12339) args12341 (:args m12339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12342
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12340)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12342
       createStreamingDistribution
       (cloudfront/create-streaming-distribution-request
        (clojure.core/nth args12341 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createStreamingDistribution"}
   [credentials12344 & args12345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12346
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12344)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12346
      createStreamingDistribution
      (cloudfront/create-streaming-distribution-request
       (clojure.core/nth args12345 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m12347]
   (clojure.core/let
    [credentials12348 (:credentials m12347) args12349 (:args m12347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12350
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12348)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12350
       getInvalidation
       (cloudfront/get-invalidation-request
        (clojure.core/nth args12349 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInvalidation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-invalidation,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInvalidation"}
   [credentials12352 & args12353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12354
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12352)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12354
      getInvalidation
      (cloudfront/get-invalidation-request
       (clojure.core/nth args12353 0))))))))
