(ns
 com.palletops.awaze.cloudformation
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudformation :as cloudformation]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Parameter}
parameter
  [m4924]
  (clojure.core/let
   [bean4923
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/let
    [v4925
     (:parameter-key m4924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4925 :com.palletops.awaze.client-builder/undef)
     (. bean4923 setParameterKey (clojure.core/str v4925))))
   (clojure.core/let
    [v4925
     (:parameter-value
      m4924
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4925 :com.palletops.awaze.client-builder/undef)
     (. bean4923 setParameterValue (clojure.core/str v4925))))
   (clojure.core/let
    [v4925
     (:use-previous-value
      m4924
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4925 :com.palletops.awaze.client-builder/undef)
     (. bean4923 setUsePreviousValue (clojure.core/boolean v4925))))
   bean4923))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Tag}
tag
  [m4927]
  (clojure.core/let
   [bean4926 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/let
    [v4928 (:key m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setKey (clojure.core/str v4928))))
   (clojure.core/let
    [v4928 (:value m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setValue (clojure.core/str v4928))))
   bean4926))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ResourceSignalStatus}
resource-signal-status
  [m4930]
  (.
   com.amazonaws.services.cloudformation.model.ResourceSignalStatus
   fromValue
   (clojure.core/name m4930)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest}
continue-update-rollback-request
  [m4933]
  (clojure.core/let
   [bean4932
    (new
     com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest)]
   (clojure.core/let
    [v4934
     (:stack-name m4933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4934 :com.palletops.awaze.client-builder/undef)
     (. bean4932 setStackName (clojure.core/str v4934))))
   bean4932))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest}
describe-change-set-request
  [m4936]
  (clojure.core/let
   [bean4935
    (new
     com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest)]
   (clojure.core/let
    [v4937
     (:next-token m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setNextToken (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:change-set-name
      m4936
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setChangeSetName (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:stack-name m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setStackName (clojure.core/str v4937))))
   bean4935))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SetStackPolicyRequest}
set-stack-policy-request
  [m4939]
  (clojure.core/let
   [bean4938
    (new
     com.amazonaws.services.cloudformation.model.SetStackPolicyRequest)]
   (clojure.core/let
    [v4940
     (:stack-policy-body
      m4939
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setStackPolicyBody (clojure.core/str v4940))))
   (clojure.core/let
    [v4940
     (:stack-policy-url
      m4939
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setStackPolicyURL (clojure.core/str v4940))))
   (clojure.core/let
    [v4940
     (:stack-name m4939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setStackName (clojure.core/str v4940))))
   bean4938))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStacksRequest}
describe-stacks-request
  [m4942]
  (clojure.core/let
   [bean4941
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/let
    [v4943
     (:next-token m4942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (. bean4941 setNextToken (clojure.core/str v4943))))
   (clojure.core/let
    [v4943
     (:stack-name m4942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (. bean4941 setStackName (clojure.core/str v4943))))
   bean4941))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.UpdateStackRequest}
update-stack-request
  [m4945]
  (clojure.core/let
   [bean4944
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/let
    [v4946
     (:use-previous-template
      m4945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setUsePreviousTemplate (clojure.core/boolean v4946))))
   (clojure.core/let
    [v4946
     (:stack-name m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setStackName (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:notification-arns
      m4945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (.
      bean4944
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5004] (clojure.core/str arg5004))
 v4946))))
   (clojure.core/let
    [v4946
     (:parameters m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (.
      bean4944
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5005] (cloudformation/parameter arg5005))
 v4946))))
   (clojure.core/let
    [v4946
     (:stack-policy-during-update-body
      m4945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (.
      bean4944
      setStackPolicyDuringUpdateBody
      (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:template-url m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setTemplateURL (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:stack-policy-url
      m4945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setStackPolicyURL (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:stack-policy-body
      m4945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setStackPolicyBody (clojure.core/str v4946))))
   (clojure.core/let
    [v4946 (:tags m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (.
      bean4944
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5006] (cloudformation/tag arg5006))
 v4946))))
   (clojure.core/let
    [v4946
     (:stack-policy-during-update-url
      m4945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (.
      bean4944
      setStackPolicyDuringUpdateURL
      (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:template-body m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setTemplateBody (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:resource-types m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (.
      bean4944
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5007] (clojure.core/str arg5007))
 v4946))))
   (clojure.core/let
    [v4946
     (:capabilities m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (.
      bean4944
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5008] (clojure.core/str arg5008))
 v4946))))
   bean4944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest}
estimate-template-cost-request
  [m4948]
  (clojure.core/let
   [bean4947
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/let
    [v4949
     (:template-url m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setTemplateURL (clojure.core/str v4949))))
   (clojure.core/let
    [v4949
     (:template-body m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setTemplateBody (clojure.core/str v4949))))
   (clojure.core/let
    [v4949
     (:parameters m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5009] (cloudformation/parameter arg5009))
 v4949))))
   bean4947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStacksRequest}
list-stacks-request
  [m4951]
  (clojure.core/let
   [bean4950
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/let
    [v4952
     (:next-token m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (. bean4950 setNextToken (clojure.core/str v4952))))
   (clojure.core/let
    [v4952
     (:stack-status-filters
      m4951
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (.
      bean4950
      setStackStatusFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5010] (clojure.core/str arg5010))
 v4952))))
   bean4950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest}
describe-stack-events-request
  [m4954]
  (clojure.core/let
   [bean4953
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/let
    [v4955
     (:next-token m4954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4955 :com.palletops.awaze.client-builder/undef)
     (. bean4953 setNextToken (clojure.core/str v4955))))
   (clojure.core/let
    [v4955
     (:stack-name m4954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4955 :com.palletops.awaze.client-builder/undef)
     (. bean4953 setStackName (clojure.core/str v4955))))
   bean4953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteStackRequest}
delete-stack-request
  [m4957]
  (clojure.core/let
   [bean4956
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/let
    [v4958
     (:retain-resources
      m4957
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4958 :com.palletops.awaze.client-builder/undef)
     (.
      bean4956
      setRetainResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5011] (clojure.core/str arg5011))
 v4958))))
   (clojure.core/let
    [v4958
     (:stack-name m4957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4958 :com.palletops.awaze.client-builder/undef)
     (. bean4956 setStackName (clojure.core/str v4958))))
   bean4956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ValidateTemplateRequest}
validate-template-request
  [m4960]
  (clojure.core/let
   [bean4959
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/let
    [v4961
     (:template-url m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setTemplateURL (clojure.core/str v4961))))
   (clojure.core/let
    [v4961
     (:template-body m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setTemplateBody (clojure.core/str v4961))))
   bean4959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest}
describe-stack-resources-request
  [m4963]
  (clojure.core/let
   [bean4962
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/let
    [v4964
     (:logical-resource-id
      m4963
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4964 :com.palletops.awaze.client-builder/undef)
     (. bean4962 setLogicalResourceId (clojure.core/str v4964))))
   (clojure.core/let
    [v4964
     (:physical-resource-id
      m4963
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4964 :com.palletops.awaze.client-builder/undef)
     (. bean4962 setPhysicalResourceId (clojure.core/str v4964))))
   (clojure.core/let
    [v4964
     (:stack-name m4963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4964 :com.palletops.awaze.client-builder/undef)
     (. bean4962 setStackName (clojure.core/str v4964))))
   bean4962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m4966]
  (clojure.core/let
   [bean4965
    (new
     com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest)]
   (clojure.core/let
    [v4967
     (:next-token m4966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4967 :com.palletops.awaze.client-builder/undef)
     (. bean4965 setNextToken (clojure.core/str v4967))))
   bean4965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SignalResourceRequest}
signal-resource-request
  [m4969]
  (clojure.core/let
   [bean4968
    (new
     com.amazonaws.services.cloudformation.model.SignalResourceRequest)]
   (clojure.core/let
    [v4970 (:status m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (.
      bean4968
      setStatus
      (cloudformation/resource-signal-status v4970))))
   (clojure.core/let
    [v4970
     (:logical-resource-id
      m4969
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setLogicalResourceId (clojure.core/str v4970))))
   (clojure.core/let
    [v4970
     (:unique-id m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setUniqueId (clojure.core/str v4970))))
   (clojure.core/let
    [v4970
     (:stack-name m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setStackName (clojure.core/str v4970))))
   bean4968))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateRequest}
get-template-request
  [m4972]
  (clojure.core/let
   [bean4971
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/let
    [v4973
     (:stack-name m4972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4973 :com.palletops.awaze.client-builder/undef)
     (. bean4971 setStackName (clojure.core/str v4973))))
   bean4971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetStackPolicyRequest}
get-stack-policy-request
  [m4975]
  (clojure.core/let
   [bean4974
    (new
     com.amazonaws.services.cloudformation.model.GetStackPolicyRequest)]
   (clojure.core/let
    [v4976
     (:stack-name m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setStackName (clojure.core/str v4976))))
   bean4974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateStackRequest}
create-stack-request
  [m4978]
  (clojure.core/let
   [bean4977
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/let
    [v4979
     (:stack-name m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setStackName (clojure.core/str v4979))))
   (clojure.core/let
    [v4979
     (:notification-arns
      m4978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (.
      bean4977
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5036] (clojure.core/str arg5036))
 v4979))))
   (clojure.core/let
    [v4979
     (:parameters m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (.
      bean4977
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5037] (cloudformation/parameter arg5037))
 v4979))))
   (clojure.core/let
    [v4979
     (:timeout-in-minutes
      m4978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setTimeoutInMinutes (clojure.core/int v4979))))
   (clojure.core/let
    [v4979
     (:disable-rollback
      m4978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setDisableRollback (clojure.core/boolean v4979))))
   (clojure.core/let
    [v4979
     (:template-url m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setTemplateURL (clojure.core/str v4979))))
   (clojure.core/let
    [v4979
     (:stack-policy-url
      m4978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setStackPolicyURL (clojure.core/str v4979))))
   (clojure.core/let
    [v4979
     (:stack-policy-body
      m4978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setStackPolicyBody (clojure.core/str v4979))))
   (clojure.core/let
    [v4979 (:tags m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (.
      bean4977
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5038] (cloudformation/tag arg5038))
 v4979))))
   (clojure.core/let
    [v4979
     (:template-body m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setTemplateBody (clojure.core/str v4979))))
   (clojure.core/let
    [v4979
     (:resource-types m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (.
      bean4977
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5039] (clojure.core/str arg5039))
 v4979))))
   (clojure.core/let
    [v4979
     (:capabilities m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (.
      bean4977
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5040] (clojure.core/str arg5040))
 v4979))))
   (clojure.core/let
    [v4979
     (:on-failure m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setOnFailure (clojure.core/str v4979))))
   bean4977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStackResourcesRequest}
list-stack-resources-request
  [m4981]
  (clojure.core/let
   [bean4980
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/let
    [v4982
     (:next-token m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setNextToken (clojure.core/str v4982))))
   (clojure.core/let
    [v4982
     (:stack-name m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setStackName (clojure.core/str v4982))))
   bean4980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest}
describe-stack-resource-request
  [m4984]
  (clojure.core/let
   [bean4983
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/let
    [v4985
     (:logical-resource-id
      m4984
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setLogicalResourceId (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:stack-name m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setStackName (clojure.core/str v4985))))
   bean4983))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListChangeSetsRequest}
list-change-sets-request
  [m4987]
  (clojure.core/let
   [bean4986
    (new
     com.amazonaws.services.cloudformation.model.ListChangeSetsRequest)]
   (clojure.core/let
    [v4988
     (:next-token m4987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4988 :com.palletops.awaze.client-builder/undef)
     (. bean4986 setNextToken (clojure.core/str v4988))))
   (clojure.core/let
    [v4988
     (:stack-name m4987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4988 :com.palletops.awaze.client-builder/undef)
     (. bean4986 setStackName (clojure.core/str v4988))))
   bean4986))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest}
cancel-update-stack-request
  [m4990]
  (clojure.core/let
   [bean4989
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/let
    [v4991
     (:stack-name m4990 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4991 :com.palletops.awaze.client-builder/undef)
     (. bean4989 setStackName (clojure.core/str v4991))))
   bean4989))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateChangeSetRequest}
create-change-set-request
  [m4993]
  (clojure.core/let
   [bean4992
    (new
     com.amazonaws.services.cloudformation.model.CreateChangeSetRequest)]
   (clojure.core/let
    [v4994
     (:description m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setDescription (clojure.core/str v4994))))
   (clojure.core/let
    [v4994
     (:use-previous-template
      m4993
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setUsePreviousTemplate (clojure.core/boolean v4994))))
   (clojure.core/let
    [v4994
     (:stack-name m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setStackName (clojure.core/str v4994))))
   (clojure.core/let
    [v4994
     (:notification-arns
      m4993
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (.
      bean4992
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5041] (clojure.core/str arg5041))
 v4994))))
   (clojure.core/let
    [v4994
     (:parameters m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (.
      bean4992
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5042] (cloudformation/parameter arg5042))
 v4994))))
   (clojure.core/let
    [v4994
     (:client-token m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setClientToken (clojure.core/str v4994))))
   (clojure.core/let
    [v4994
     (:template-url m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setTemplateURL (clojure.core/str v4994))))
   (clojure.core/let
    [v4994 (:tags m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (.
      bean4992
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5043] (cloudformation/tag arg5043))
 v4994))))
   (clojure.core/let
    [v4994
     (:change-set-name
      m4993
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setChangeSetName (clojure.core/str v4994))))
   (clojure.core/let
    [v4994
     (:template-body m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setTemplateBody (clojure.core/str v4994))))
   (clojure.core/let
    [v4994
     (:resource-types m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (.
      bean4992
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5044] (clojure.core/str arg5044))
 v4994))))
   (clojure.core/let
    [v4994
     (:capabilities m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (.
      bean4992
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5045] (clojure.core/str arg5045))
 v4994))))
   bean4992))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest}
execute-change-set-request
  [m4996]
  (clojure.core/let
   [bean4995
    (new
     com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest)]
   (clojure.core/let
    [v4997
     (:change-set-name
      m4996
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setChangeSetName (clojure.core/str v4997))))
   (clojure.core/let
    [v4997
     (:stack-name m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setStackName (clojure.core/str v4997))))
   bean4995))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest}
delete-change-set-request
  [m4999]
  (clojure.core/let
   [bean4998
    (new
     com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest)]
   (clojure.core/let
    [v5000
     (:change-set-name
      m4999
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5000 :com.palletops.awaze.client-builder/undef)
     (. bean4998 setChangeSetName (clojure.core/str v5000))))
   (clojure.core/let
    [v5000
     (:stack-name m4999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5000 :com.palletops.awaze.client-builder/undef)
     (. bean4998 setStackName (clojure.core/str v5000))))
   bean4998))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest}
get-template-summary-request
  [m5002]
  (clojure.core/let
   [bean5001
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest)]
   (clojure.core/let
    [v5003
     (:template-url m5002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5003 :com.palletops.awaze.client-builder/undef)
     (. bean5001 setTemplateURL (clojure.core/str v5003))))
   (clojure.core/let
    [v5003
     (:template-body m5002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5003 :com.palletops.awaze.client-builder/undef)
     (. bean5001 setTemplateBody (clojure.core/str v5003))))
   (clojure.core/let
    [v5003
     (:stack-name m5002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5003 :com.palletops.awaze.client-builder/undef)
     (. bean5001 setStackName (clojure.core/str v5003))))
   bean5001))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :continue-update-rollback
   [m5012]
   (clojure.core/let
    [credentials5013 (:credentials m5012) args5014 (:args m5012)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5015
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5013)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5015
       continueUpdateRollback
       (cloudformation/continue-update-rollback-request
        (clojure.core/nth args5014 0)))))))
  (clojure.core/defn
   continue-update-rollback-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for continueUpdateRollback"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :continue-update-rollback,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   continue-update-rollback
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call continueUpdateRollback"}
   [credentials5017 & args5018]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5019
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5017)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5019
      continueUpdateRollback
      (cloudformation/continue-update-rollback-request
       (clojure.core/nth args5018 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-change-set
   [m5020]
   (clojure.core/let
    [credentials5021 (:credentials m5020) args5022 (:args m5020)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5023
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5021)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5023
       describeChangeSet
       (cloudformation/describe-change-set-request
        (clojure.core/nth args5022 0)))))))
  (clojure.core/defn
   describe-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeChangeSet"}
   [credentials5025 & args5026]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5027
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5025)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5027
      describeChangeSet
      (cloudformation/describe-change-set-request
       (clojure.core/nth args5026 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :set-stack-policy
   [m5028]
   (clojure.core/let
    [credentials5029 (:credentials m5028) args5030 (:args m5028)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5031
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5029)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5031
       setStackPolicy
       (cloudformation/set-stack-policy-request
        (clojure.core/nth args5030 0)))))))
  (clojure.core/defn
   set-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for setStackPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-stack-policy,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   set-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call setStackPolicy"}
   [credentials5033 & args5034]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5035
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5033)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5035
      setStackPolicy
      (cloudformation/set-stack-policy-request
       (clojure.core/nth args5034 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m5046]
   (clojure.core/let
    [credentials5047 (:credentials m5046) args5048 (:args m5046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5049
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5047)]
     (clojure.core/case
      (clojure.core/count args5048)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5049
        describeStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5049
        describeStacks
        (cloudformation/describe-stacks-request
         (clojure.core/nth args5048 0))))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials5051 & args5052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5053
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5051)]
    (clojure.core/case
     (clojure.core/count args5052)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5053
       describeStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5053
       describeStacks
       (cloudformation/describe-stacks-request
        (clojure.core/nth args5052 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m5054]
   (clojure.core/let
    [credentials5055 (:credentials m5054) args5056 (:args m5054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5057
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5055)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5057
       updateStack
       (cloudformation/update-stack-request
        (clojure.core/nth args5056 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Call updateStack"}
   [credentials5059 & args5060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5061
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5059)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5061
      updateStack
      (cloudformation/update-stack-request
       (clojure.core/nth args5060 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m5062]
   (clojure.core/let
    [credentials5063 (:credentials m5062) args5064 (:args m5062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5065
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5063)]
     (clojure.core/case
      (clojure.core/count args5064)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5065
        estimateTemplateCost))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5065
        estimateTemplateCost
        (cloudformation/estimate-template-cost-request
         (clojure.core/nth args5064 0))))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :estimate-template-cost,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :estimate-template-cost,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials5067 & args5068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5069
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5067)]
    (clojure.core/case
     (clojure.core/count args5068)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5069
       estimateTemplateCost))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5069
       estimateTemplateCost
       (cloudformation/estimate-template-cost-request
        (clojure.core/nth args5068 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m5070]
   (clojure.core/let
    [credentials5071 (:credentials m5070) args5072 (:args m5070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5073
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5071)]
     (clojure.core/case
      (clojure.core/count args5072)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5073
        listStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5073
        listStacks
        (cloudformation/list-stacks-request
         (clojure.core/nth args5072 0))))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStacks, listStacks"}
   [credentials5075 & args5076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5077
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5075)]
    (clojure.core/case
     (clojure.core/count args5076)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5077
       listStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5077
       listStacks
       (cloudformation/list-stacks-request
        (clojure.core/nth args5076 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m5078]
   (clojure.core/let
    [credentials5079 (:credentials m5078) args5080 (:args m5078)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5081
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5079)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5081
       describeStackEvents
       (cloudformation/describe-stack-events-request
        (clojure.core/nth args5080 0)))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeStackEvents"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-events,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeStackEvents"}
   [credentials5083 & args5084]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5085
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5083)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5085
      describeStackEvents
      (cloudformation/describe-stack-events-request
       (clojure.core/nth args5084 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m5086]
   (clojure.core/let
    [credentials5087 (:credentials m5086) args5088 (:args m5086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5089
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5087)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5089
       deleteStack
       (cloudformation/delete-stack-request
        (clojure.core/nth args5088 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStack"}
   [credentials5091 & args5092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5093
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5091)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5093
      deleteStack
      (cloudformation/delete-stack-request
       (clojure.core/nth args5092 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m5094]
   (clojure.core/let
    [credentials5095 (:credentials m5094) args5096 (:args m5094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5097
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5095)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5097
       validateTemplate
       (cloudformation/validate-template-request
        (clojure.core/nth args5096 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-template,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Call validateTemplate"}
   [credentials5099 & args5100]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5101
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5099)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5101
      validateTemplate
      (cloudformation/validate-template-request
       (clojure.core/nth args5100 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m5102]
   (clojure.core/let
    [credentials5103 (:credentials m5102) args5104 (:args m5102)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5105
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5103)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5105
       describeStackResources
       (cloudformation/describe-stack-resources-request
        (clojure.core/nth args5104 0)))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-resources,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResources"}
   [credentials5107 & args5108]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5109
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5107)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5109
      describeStackResources
      (cloudformation/describe-stack-resources-request
       (clojure.core/nth args5108 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-account-limits
   [m5110]
   (clojure.core/let
    [credentials5111 (:credentials m5110) args5112 (:args m5110)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5113
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5111)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5113
       describeAccountLimits
       (cloudformation/describe-account-limits-request
        (clojure.core/nth args5112 0)))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAccountLimits"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAccountLimits"}
   [credentials5115 & args5116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5117
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5115)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5117
      describeAccountLimits
      (cloudformation/describe-account-limits-request
       (clojure.core/nth args5116 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :signal-resource
   [m5118]
   (clojure.core/let
    [credentials5119 (:credentials m5118) args5120 (:args m5118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5121
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5119)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5121
       signalResource
       (cloudformation/signal-resource-request
        (clojure.core/nth args5120 0)))))))
  (clojure.core/defn
   signal-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for signalResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :signal-resource,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   signal-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call signalResource"}
   [credentials5123 & args5124]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5125
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5123)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5125
      signalResource
      (cloudformation/signal-resource-request
       (clojure.core/nth args5124 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m5126]
   (clojure.core/let
    [credentials5127 (:credentials m5126) args5128 (:args m5126)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5129
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5127)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5129
       getTemplate
       (cloudformation/get-template-request
        (clojure.core/nth args5128 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-template,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTemplate"}
   [credentials5131 & args5132]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5133
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5131)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5133
      getTemplate
      (cloudformation/get-template-request
       (clojure.core/nth args5132 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-stack-policy
   [m5134]
   (clojure.core/let
    [credentials5135 (:credentials m5134) args5136 (:args m5134)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5137
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5135)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5137
       getStackPolicy
       (cloudformation/get-stack-policy-request
        (clojure.core/nth args5136 0)))))))
  (clojure.core/defn
   get-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStackPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-stack-policy,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStackPolicy"}
   [credentials5139 & args5140]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5141
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5139)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5141
      getStackPolicy
      (cloudformation/get-stack-policy-request
       (clojure.core/nth args5140 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m5142]
   (clojure.core/let
    [credentials5143 (:credentials m5142) args5144 (:args m5142)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5145
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5143)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5145
       createStack
       (cloudformation/create-stack-request
        (clojure.core/nth args5144 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call createStack"}
   [credentials5147 & args5148]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5149
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5147)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5149
      createStack
      (cloudformation/create-stack-request
       (clojure.core/nth args5148 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m5150]
   (clojure.core/let
    [credentials5151 (:credentials m5150) args5152 (:args m5150)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5153
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5151)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5153
       listStackResources
       (cloudformation/list-stack-resources-request
        (clojure.core/nth args5152 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-stack-resources,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStackResources"}
   [credentials5155 & args5156]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5157
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5155)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5157
      listStackResources
      (cloudformation/list-stack-resources-request
       (clojure.core/nth args5156 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m5158]
   (clojure.core/let
    [credentials5159 (:credentials m5158) args5160 (:args m5158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5161
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5159)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5161
       describeStackResource
       (cloudformation/describe-stack-resource-request
        (clojure.core/nth args5160 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-resource,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResource"}
   [credentials5163 & args5164]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5165
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5163)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5165
      describeStackResource
      (cloudformation/describe-stack-resource-request
       (clojure.core/nth args5164 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-change-sets
   [m5166]
   (clojure.core/let
    [credentials5167 (:credentials m5166) args5168 (:args m5166)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5169
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5167)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5169
       listChangeSets
       (cloudformation/list-change-sets-request
        (clojure.core/nth args5168 0)))))))
  (clojure.core/defn
   list-change-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listChangeSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-sets,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-change-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listChangeSets"}
   [credentials5171 & args5172]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5173
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5171)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5173
      listChangeSets
      (cloudformation/list-change-sets-request
       (clojure.core/nth args5172 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m5174]
   (clojure.core/let
    [credentials5175 (:credentials m5174) args5176 (:args m5174)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5177
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5175)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5177
       cancelUpdateStack
       (cloudformation/cancel-update-stack-request
        (clojure.core/nth args5176 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-update-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials5179 & args5180]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5181
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5179)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5181
      cancelUpdateStack
      (cloudformation/cancel-update-stack-request
       (clojure.core/nth args5180 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-change-set
   [m5182]
   (clojure.core/let
    [credentials5183 (:credentials m5182) args5184 (:args m5182)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5185
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5183)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5185
       createChangeSet
       (cloudformation/create-change-set-request
        (clojure.core/nth args5184 0)))))))
  (clojure.core/defn
   create-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Generate map for createChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-change-set
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Call createChangeSet"}
   [credentials5187 & args5188]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5189
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5187)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5189
      createChangeSet
      (cloudformation/create-change-set-request
       (clojure.core/nth args5188 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :execute-change-set
   [m5190]
   (clojure.core/let
    [credentials5191 (:credentials m5190) args5192 (:args m5190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5193
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5193
       executeChangeSet
       (cloudformation/execute-change-set-request
        (clojure.core/nth args5192 0)))))))
  (clojure.core/defn
   execute-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for executeChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :execute-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   execute-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call executeChangeSet"}
   [credentials5195 & args5196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5197
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5197
      executeChangeSet
      (cloudformation/execute-change-set-request
       (clojure.core/nth args5196 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-change-set
   [m5198]
   (clojure.core/let
    [credentials5199 (:credentials m5198) args5200 (:args m5198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5201
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5201
       deleteChangeSet
       (cloudformation/delete-change-set-request
        (clojure.core/nth args5200 0)))))))
  (clojure.core/defn
   delete-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteChangeSet"}
   [credentials5203 & args5204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5205
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5203)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5205
      deleteChangeSet
      (cloudformation/delete-change-set-request
       (clojure.core/nth args5204 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template-summary
   [m5206]
   (clojure.core/let
    [credentials5207 (:credentials m5206) args5208 (:args m5206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5209
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5207)]
     (clojure.core/case
      (clojure.core/count args5208)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5209
        getTemplateSummary
        (cloudformation/get-template-summary-request
         (clojure.core/nth args5208 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5209
        getTemplateSummary))))))
  (clojure.core/defn
   get-template-summary-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getTemplateSummary, getTemplateSummary"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-template-summary,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-template-summary,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template-summary
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]
                [credentials]]),
    :doc "Call getTemplateSummary, getTemplateSummary"}
   [credentials5211 & args5212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5213
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5211)]
    (clojure.core/case
     (clojure.core/count args5212)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5213
       getTemplateSummary
       (cloudformation/get-template-summary-request
        (clojure.core/nth args5212 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5213
       getTemplateSummary)))))))
