(ns
 com.palletops.awaze.autoscaling
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.autoscaling :as autoscaling]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Ebs}
ebs
  [m6418]
  (clojure.core/let
   [bean6417 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/let
    [v6419
     (:delete-on-termination
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setDeleteOnTermination (clojure.core/boolean v6419))))
   (clojure.core/let
    [v6419
     (:volume-size m6418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setVolumeSize (clojure.core/int v6419))))
   (clojure.core/let
    [v6419
     (:snapshot-id m6418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setSnapshotId (clojure.core/str v6419))))
   (clojure.core/let
    [v6419
     (:encrypted m6418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setEncrypted (clojure.core/boolean v6419))))
   (clojure.core/let
    [v6419
     (:volume-type m6418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setVolumeType (clojure.core/str v6419))))
   (clojure.core/let
    [v6419 (:iops m6418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setIops (clojure.core/int v6419))))
   bean6417))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Tag}
tag
  [m6421]
  (clojure.core/let
   [bean6420 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/let
    [v6422 (:key m6421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (. bean6420 setKey (clojure.core/str v6422))))
   (clojure.core/let
    [v6422
     (:resource-id m6421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (. bean6420 setResourceId (clojure.core/str v6422))))
   (clojure.core/let
    [v6422
     (:propagate-at-launch
      m6421
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (. bean6420 setPropagateAtLaunch (clojure.core/boolean v6422))))
   (clojure.core/let
    [v6422
     (:resource-type m6421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (. bean6420 setResourceType (clojure.core/str v6422))))
   (clojure.core/let
    [v6422 (:value m6421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (. bean6420 setValue (clojure.core/str v6422))))
   bean6420))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.StepAdjustment}
step-adjustment
  [m6424]
  (clojure.core/let
   [bean6423
    (new com.amazonaws.services.autoscaling.model.StepAdjustment)]
   (clojure.core/let
    [v6425
     (:metric-interval-lower-bound
      m6424
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6425 :com.palletops.awaze.client-builder/undef)
     (.
      bean6423
      setMetricIntervalLowerBound
      (clojure.core/double v6425))))
   (clojure.core/let
    [v6425
     (:metric-interval-upper-bound
      m6424
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6425 :com.palletops.awaze.client-builder/undef)
     (.
      bean6423
      setMetricIntervalUpperBound
      (clojure.core/double v6425))))
   (clojure.core/let
    [v6425
     (:scaling-adjustment
      m6424
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6425 :com.palletops.awaze.client-builder/undef)
     (. bean6423 setScalingAdjustment (clojure.core/int v6425))))
   bean6423))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Filter}
filter
  [m6427]
  (clojure.core/let
   [bean6426 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/let
    [v6428 (:values m6427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6428 :com.palletops.awaze.client-builder/undef)
     (.
      bean6426
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6582] (clojure.core/str arg6582))
 v6428))))
   (clojure.core/let
    [v6428 (:name m6427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6428 :com.palletops.awaze.client-builder/undef)
     (. bean6426 setName (clojure.core/str v6428))))
   bean6426))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.InstanceMonitoring}
instance-monitoring
  [m6430]
  (clojure.core/let
   [bean6429
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/let
    [v6431 (:enabled m6430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6431 :com.palletops.awaze.client-builder/undef)
     (. bean6429 setEnabled (clojure.core/boolean v6431))))
   bean6429))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.BlockDeviceMapping}
block-device-mapping
  [m6433]
  (clojure.core/let
   [bean6432
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/let
    [v6434
     (:device-name m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setDeviceName (clojure.core/str v6434))))
   (clojure.core/let
    [v6434
     (:virtual-name m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setVirtualName (clojure.core/str v6434))))
   (clojure.core/let
    [v6434 (:ebs m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setEbs (autoscaling/ebs v6434))))
   (clojure.core/let
    [v6434
     (:no-device m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setNoDevice (clojure.core/boolean v6434))))
   bean6432))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest}
update-auto-scaling-group-request
  [m6436]
  (clojure.core/let
   [bean6435
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/let
    [v6437
     (:health-check-type
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setHealthCheckType (clojure.core/str v6437))))
   (clojure.core/let
    [v6437
     (:new-instances-protected-from-scale-in
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (.
      bean6435
      setNewInstancesProtectedFromScaleIn
      (clojure.core/boolean v6437))))
   (clojure.core/let
    [v6437
     (:availability-zones
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (.
      bean6435
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6583] (clojure.core/str arg6583))
 v6437))))
   (clojure.core/let
    [v6437
     (:desired-capacity
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setDesiredCapacity (clojure.core/int v6437))))
   (clojure.core/let
    [v6437
     (:placement-group
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setPlacementGroup (clojure.core/str v6437))))
   (clojure.core/let
    [v6437
     (:min-size m6436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setMinSize (clojure.core/int v6437))))
   (clojure.core/let
    [v6437
     (:launch-configuration-name
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setLaunchConfigurationName (clojure.core/str v6437))))
   (clojure.core/let
    [v6437
     (:health-check-grace-period
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setHealthCheckGracePeriod (clojure.core/int v6437))))
   (clojure.core/let
    [v6437
     (:termination-policies
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (.
      bean6435
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6584] (clojure.core/str arg6584))
 v6437))))
   (clojure.core/let
    [v6437
     (:auto-scaling-group-name
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setAutoScalingGroupName (clojure.core/str v6437))))
   (clojure.core/let
    [v6437
     (:max-size m6436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setMaxSize (clojure.core/int v6437))))
   (clojure.core/let
    [v6437
     (:vpczone-identifier
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setVPCZoneIdentifier (clojure.core/str v6437))))
   (clojure.core/let
    [v6437
     (:default-cooldown
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setDefaultCooldown (clojure.core/int v6437))))
   bean6435))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest}
attach-load-balancers-request
  [m6439]
  (clojure.core/let
   [bean6438
    (new
     com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest)]
   (clojure.core/let
    [v6440
     (:auto-scaling-group-name
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setAutoScalingGroupName (clojure.core/str v6440))))
   (clojure.core/let
    [v6440
     (:load-balancer-names
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (.
      bean6438
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6585] (clojure.core/str arg6585))
 v6440))))
   bean6438))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest}
create-or-update-tags-request
  [m6442]
  (clojure.core/let
   [bean6441
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/let
    [v6443 (:tags m6442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (.
      bean6441
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6586] (autoscaling/tag arg6586))
 v6443))))
   bean6441))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ResumeProcessesRequest}
resume-processes-request
  [m6445]
  (clojure.core/let
   [bean6444
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/let
    [v6446
     (:auto-scaling-group-name
      m6445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6446 :com.palletops.awaze.client-builder/undef)
     (. bean6444 setAutoScalingGroupName (clojure.core/str v6446))))
   (clojure.core/let
    [v6446
     (:scaling-processes
      m6445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6446 :com.palletops.awaze.client-builder/undef)
     (.
      bean6444
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6587] (clojure.core/str arg6587))
 v6446))))
   bean6444))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest}
terminate-instance-in-auto-scaling-group-request
  [m6448]
  (clojure.core/let
   [bean6447
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/let
    [v6449
     (:instance-id m6448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setInstanceId (clojure.core/str v6449))))
   (clojure.core/let
    [v6449
     (:should-decrement-desired-capacity
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (.
      bean6447
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6449))))
   bean6447))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest}
delete-auto-scaling-group-request
  [m6451]
  (clojure.core/let
   [bean6450
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/let
    [v6452
     (:auto-scaling-group-name
      m6451
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6452 :com.palletops.awaze.client-builder/undef)
     (. bean6450 setAutoScalingGroupName (clojure.core/str v6452))))
   (clojure.core/let
    [v6452
     (:force-delete m6451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6452 :com.palletops.awaze.client-builder/undef)
     (. bean6450 setForceDelete (clojure.core/boolean v6452))))
   bean6450))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m6454]
  (clojure.core/let
   [bean6453
    (new
     com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v6455
     (:auto-scaling-group-name
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setAutoScalingGroupName (clojure.core/str v6455))))
   (clojure.core/let
    [v6455
     (:next-token m6454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setNextToken (clojure.core/str v6455))))
   (clojure.core/let
    [v6455
     (:max-records m6454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setMaxRecords (clojure.core/int v6455))))
   bean6453))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest}
disable-metrics-collection-request
  [m6457]
  (clojure.core/let
   [bean6456
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/let
    [v6458
     (:auto-scaling-group-name
      m6457
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6458 :com.palletops.awaze.client-builder/undef)
     (. bean6456 setAutoScalingGroupName (clojure.core/str v6458))))
   (clojure.core/let
    [v6458 (:metrics m6457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6458 :com.palletops.awaze.client-builder/undef)
     (.
      bean6456
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6588] (clojure.core/str arg6588))
 v6458))))
   bean6456))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest}
describe-scheduled-actions-request
  [m6460]
  (clojure.core/let
   [bean6459
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/let
    [v6461
     (:auto-scaling-group-name
      m6460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6461 :com.palletops.awaze.client-builder/undef)
     (. bean6459 setAutoScalingGroupName (clojure.core/str v6461))))
   (clojure.core/let
    [v6461
     (:start-time m6460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6461 :com.palletops.awaze.client-builder/undef)
     (.
      bean6459
      setStartTime
      (com.palletops.awaze.common/to-date v6461))))
   (clojure.core/let
    [v6461
     (:end-time m6460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6461 :com.palletops.awaze.client-builder/undef)
     (.
      bean6459
      setEndTime
      (com.palletops.awaze.common/to-date v6461))))
   (clojure.core/let
    [v6461
     (:next-token m6460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6461 :com.palletops.awaze.client-builder/undef)
     (. bean6459 setNextToken (clojure.core/str v6461))))
   (clojure.core/let
    [v6461
     (:max-records m6460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6461 :com.palletops.awaze.client-builder/undef)
     (. bean6459 setMaxRecords (clojure.core/int v6461))))
   (clojure.core/let
    [v6461
     (:scheduled-action-names
      m6460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6461 :com.palletops.awaze.client-builder/undef)
     (.
      bean6459
      setScheduledActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6589] (clojure.core/str arg6589))
 v6461))))
   bean6459))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest}
delete-notification-configuration-request
  [m6463]
  (clojure.core/let
   [bean6462
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/let
    [v6464
     (:auto-scaling-group-name
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setAutoScalingGroupName (clojure.core/str v6464))))
   (clojure.core/let
    [v6464
     (:topic-arn m6463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setTopicARN (clojure.core/str v6464))))
   bean6462))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest}
put-scaling-policy-request
  [m6466]
  (clojure.core/let
   [bean6465
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/let
    [v6467
     (:policy-type m6466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setPolicyType (clojure.core/str v6467))))
   (clojure.core/let
    [v6467
     (:policy-name m6466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setPolicyName (clojure.core/str v6467))))
   (clojure.core/let
    [v6467
     (:adjustment-type
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setAdjustmentType (clojure.core/str v6467))))
   (clojure.core/let
    [v6467
     (:step-adjustments
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (.
      bean6465
      setStepAdjustments
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6590] (autoscaling/step-adjustment arg6590))
 v6467))))
   (clojure.core/let
    [v6467
     (:min-adjustment-magnitude
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setMinAdjustmentMagnitude (clojure.core/int v6467))))
   (clojure.core/let
    [v6467
     (:scaling-adjustment
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setScalingAdjustment (clojure.core/int v6467))))
   (clojure.core/let
    [v6467
     (:auto-scaling-group-name
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setAutoScalingGroupName (clojure.core/str v6467))))
   (clojure.core/let
    [v6467
     (:cooldown m6466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setCooldown (clojure.core/int v6467))))
   (clojure.core/let
    [v6467
     (:metric-aggregation-type
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setMetricAggregationType (clojure.core/str v6467))))
   (clojure.core/let
    [v6467
     (:estimated-instance-warmup
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setEstimatedInstanceWarmup (clojure.core/int v6467))))
   (clojure.core/let
    [v6467
     (:min-adjustment-step
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setMinAdjustmentStep (clojure.core/int v6467))))
   bean6465))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest}
describe-scaling-activities-request
  [m6469]
  (clojure.core/let
   [bean6468
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/let
    [v6470
     (:auto-scaling-group-name
      m6469
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6470 :com.palletops.awaze.client-builder/undef)
     (. bean6468 setAutoScalingGroupName (clojure.core/str v6470))))
   (clojure.core/let
    [v6470
     (:next-token m6469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6470 :com.palletops.awaze.client-builder/undef)
     (. bean6468 setNextToken (clojure.core/str v6470))))
   (clojure.core/let
    [v6470
     (:max-records m6469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6470 :com.palletops.awaze.client-builder/undef)
     (. bean6468 setMaxRecords (clojure.core/int v6470))))
   (clojure.core/let
    [v6470
     (:activity-ids m6469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6470 :com.palletops.awaze.client-builder/undef)
     (.
      bean6468
      setActivityIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6591] (clojure.core/str arg6591))
 v6470))))
   bean6468))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest}
describe-lifecycle-hooks-request
  [m6472]
  (clojure.core/let
   [bean6471
    (new
     com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest)]
   (clojure.core/let
    [v6473
     (:auto-scaling-group-name
      m6472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6473 :com.palletops.awaze.client-builder/undef)
     (. bean6471 setAutoScalingGroupName (clojure.core/str v6473))))
   (clojure.core/let
    [v6473
     (:lifecycle-hook-names
      m6472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6473 :com.palletops.awaze.client-builder/undef)
     (.
      bean6471
      setLifecycleHookNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6592] (clojure.core/str arg6592))
 v6473))))
   bean6471))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest}
delete-launch-configuration-request
  [m6475]
  (clojure.core/let
   [bean6474
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/let
    [v6476
     (:launch-configuration-name
      m6475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6476 :com.palletops.awaze.client-builder/undef)
     (. bean6474 setLaunchConfigurationName (clojure.core/str v6476))))
   bean6474))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeletePolicyRequest}
delete-policy-request
  [m6478]
  (clojure.core/let
   [bean6477
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/let
    [v6479
     (:auto-scaling-group-name
      m6478
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6479 :com.palletops.awaze.client-builder/undef)
     (. bean6477 setAutoScalingGroupName (clojure.core/str v6479))))
   (clojure.core/let
    [v6479
     (:policy-name m6478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6479 :com.palletops.awaze.client-builder/undef)
     (. bean6477 setPolicyName (clojure.core/str v6479))))
   bean6477))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest}
create-auto-scaling-group-request
  [m6481]
  (clojure.core/let
   [bean6480
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/let
    [v6482
     (:health-check-type
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setHealthCheckType (clojure.core/str v6482))))
   (clojure.core/let
    [v6482
     (:new-instances-protected-from-scale-in
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (.
      bean6480
      setNewInstancesProtectedFromScaleIn
      (clojure.core/boolean v6482))))
   (clojure.core/let
    [v6482
     (:availability-zones
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (.
      bean6480
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6593] (clojure.core/str arg6593))
 v6482))))
   (clojure.core/let
    [v6482
     (:desired-capacity
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setDesiredCapacity (clojure.core/int v6482))))
   (clojure.core/let
    [v6482
     (:instance-id m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setInstanceId (clojure.core/str v6482))))
   (clojure.core/let
    [v6482
     (:placement-group
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setPlacementGroup (clojure.core/str v6482))))
   (clojure.core/let
    [v6482
     (:min-size m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setMinSize (clojure.core/int v6482))))
   (clojure.core/let
    [v6482 (:tags m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (.
      bean6480
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6594] (autoscaling/tag arg6594))
 v6482))))
   (clojure.core/let
    [v6482
     (:load-balancer-names
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (.
      bean6480
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6595] (clojure.core/str arg6595))
 v6482))))
   (clojure.core/let
    [v6482
     (:launch-configuration-name
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setLaunchConfigurationName (clojure.core/str v6482))))
   (clojure.core/let
    [v6482
     (:health-check-grace-period
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setHealthCheckGracePeriod (clojure.core/int v6482))))
   (clojure.core/let
    [v6482
     (:termination-policies
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (.
      bean6480
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6596] (clojure.core/str arg6596))
 v6482))))
   (clojure.core/let
    [v6482
     (:auto-scaling-group-name
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setAutoScalingGroupName (clojure.core/str v6482))))
   (clojure.core/let
    [v6482
     (:max-size m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setMaxSize (clojure.core/int v6482))))
   (clojure.core/let
    [v6482
     (:vpczone-identifier
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setVPCZoneIdentifier (clojure.core/str v6482))))
   (clojure.core/let
    [v6482
     (:default-cooldown
      m6481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setDefaultCooldown (clojure.core/int v6482))))
   bean6480))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest}
describe-scaling-process-types-request
  [m6484]
  (clojure.core/let
   [bean6483
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean6483))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m6487]
  (clojure.core/let
   [bean6486
    (new
     com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest)]
   bean6486))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest}
delete-scheduled-action-request
  [m6490]
  (clojure.core/let
   [bean6489
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/let
    [v6491
     (:auto-scaling-group-name
      m6490
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6491 :com.palletops.awaze.client-builder/undef)
     (. bean6489 setAutoScalingGroupName (clojure.core/str v6491))))
   (clojure.core/let
    [v6491
     (:scheduled-action-name
      m6490
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6491 :com.palletops.awaze.client-builder/undef)
     (. bean6489 setScheduledActionName (clojure.core/str v6491))))
   bean6489))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest}
describe-notification-configurations-request
  [m6493]
  (clojure.core/let
   [bean6492
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/let
    [v6494
     (:next-token m6493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6494 :com.palletops.awaze.client-builder/undef)
     (. bean6492 setNextToken (clojure.core/str v6494))))
   (clojure.core/let
    [v6494
     (:max-records m6493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6494 :com.palletops.awaze.client-builder/undef)
     (. bean6492 setMaxRecords (clojure.core/int v6494))))
   (clojure.core/let
    [v6494
     (:auto-scaling-group-names
      m6493
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6494 :com.palletops.awaze.client-builder/undef)
     (.
      bean6492
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6597] (clojure.core/str arg6597))
 v6494))))
   bean6492))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest}
describe-adjustment-types-request
  [m6496]
  (clojure.core/let
   [bean6495
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean6495))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest}
describe-auto-scaling-instances-request
  [m6499]
  (clojure.core/let
   [bean6498
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/let
    [v6500
     (:next-token m6499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (. bean6498 setNextToken (clojure.core/str v6500))))
   (clojure.core/let
    [v6500
     (:instance-ids m6499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (.
      bean6498
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6598] (clojure.core/str arg6598))
 v6500))))
   (clojure.core/let
    [v6500
     (:max-records m6499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (. bean6498 setMaxRecords (clojure.core/int v6500))))
   bean6498))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest}
describe-termination-policy-types-request
  [m6502]
  (clojure.core/let
   [bean6501
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean6501))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachInstancesRequest}
attach-instances-request
  [m6505]
  (clojure.core/let
   [bean6504
    (new
     com.amazonaws.services.autoscaling.model.AttachInstancesRequest)]
   (clojure.core/let
    [v6506
     (:auto-scaling-group-name
      m6505
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6506 :com.palletops.awaze.client-builder/undef)
     (. bean6504 setAutoScalingGroupName (clojure.core/str v6506))))
   (clojure.core/let
    [v6506
     (:instance-ids m6505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6506 :com.palletops.awaze.client-builder/undef)
     (.
      bean6504
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6599] (clojure.core/str arg6599))
 v6506))))
   bean6504))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTagsRequest}
describe-tags-request
  [m6508]
  (clojure.core/let
   [bean6507
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/let
    [v6509
     (:next-token m6508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setNextToken (clojure.core/str v6509))))
   (clojure.core/let
    [v6509 (:filters m6508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (.
      bean6507
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6600] (autoscaling/filter arg6600))
 v6509))))
   (clojure.core/let
    [v6509
     (:max-records m6508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setMaxRecords (clojure.core/int v6509))))
   bean6507))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteTagsRequest}
delete-tags-request
  [m6511]
  (clojure.core/let
   [bean6510
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/let
    [v6512 (:tags m6511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6512 :com.palletops.awaze.client-builder/undef)
     (.
      bean6510
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6601] (autoscaling/tag arg6601))
 v6512))))
   bean6510))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest}
put-notification-configuration-request
  [m6514]
  (clojure.core/let
   [bean6513
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/let
    [v6515
     (:auto-scaling-group-name
      m6514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (. bean6513 setAutoScalingGroupName (clojure.core/str v6515))))
   (clojure.core/let
    [v6515
     (:topic-arn m6514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (. bean6513 setTopicARN (clojure.core/str v6515))))
   (clojure.core/let
    [v6515
     (:notification-types
      m6514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (.
      bean6513
      setNotificationTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6602] (clojure.core/str arg6602))
 v6515))))
   bean6513))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest}
detach-load-balancers-request
  [m6517]
  (clojure.core/let
   [bean6516
    (new
     com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest)]
   (clojure.core/let
    [v6518
     (:auto-scaling-group-name
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setAutoScalingGroupName (clojure.core/str v6518))))
   (clojure.core/let
    [v6518
     (:load-balancer-names
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (.
      bean6516
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6603] (clojure.core/str arg6603))
 v6518))))
   bean6516))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest}
describe-auto-scaling-notification-types-request
  [m6520]
  (clojure.core/let
   [bean6519
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean6519))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest}
set-instance-protection-request
  [m6523]
  (clojure.core/let
   [bean6522
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest)]
   (clojure.core/let
    [v6524
     (:auto-scaling-group-name
      m6523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setAutoScalingGroupName (clojure.core/str v6524))))
   (clojure.core/let
    [v6524
     (:instance-ids m6523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (.
      bean6522
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6604] (clojure.core/str arg6604))
 v6524))))
   (clojure.core/let
    [v6524
     (:protected-from-scale-in
      m6523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setProtectedFromScaleIn (clojure.core/boolean v6524))))
   bean6522))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest}
complete-lifecycle-action-request
  [m6526]
  (clojure.core/let
   [bean6525
    (new
     com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest)]
   (clojure.core/let
    [v6527
     (:auto-scaling-group-name
      m6526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (. bean6525 setAutoScalingGroupName (clojure.core/str v6527))))
   (clojure.core/let
    [v6527
     (:instance-id m6526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (. bean6525 setInstanceId (clojure.core/str v6527))))
   (clojure.core/let
    [v6527
     (:lifecycle-hook-name
      m6526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (. bean6525 setLifecycleHookName (clojure.core/str v6527))))
   (clojure.core/let
    [v6527
     (:lifecycle-action-token
      m6526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (. bean6525 setLifecycleActionToken (clojure.core/str v6527))))
   (clojure.core/let
    [v6527
     (:lifecycle-action-result
      m6526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (. bean6525 setLifecycleActionResult (clojure.core/str v6527))))
   bean6525))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SuspendProcessesRequest}
suspend-processes-request
  [m6529]
  (clojure.core/let
   [bean6528
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/let
    [v6530
     (:auto-scaling-group-name
      m6529
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (. bean6528 setAutoScalingGroupName (clojure.core/str v6530))))
   (clojure.core/let
    [v6530
     (:scaling-processes
      m6529
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (.
      bean6528
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6605] (clojure.core/str arg6605))
 v6530))))
   bean6528))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest}
describe-auto-scaling-groups-request
  [m6532]
  (clojure.core/let
   [bean6531
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/let
    [v6533
     (:next-token m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setNextToken (clojure.core/str v6533))))
   (clojure.core/let
    [v6533
     (:max-records m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setMaxRecords (clojure.core/int v6533))))
   (clojure.core/let
    [v6533
     (:auto-scaling-group-names
      m6532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (.
      bean6531
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6606] (clojure.core/str arg6606))
 v6533))))
   bean6531))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest}
put-lifecycle-hook-request
  [m6535]
  (clojure.core/let
   [bean6534
    (new
     com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest)]
   (clojure.core/let
    [v6536
     (:auto-scaling-group-name
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setAutoScalingGroupName (clojure.core/str v6536))))
   (clojure.core/let
    [v6536
     (:lifecycle-hook-name
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setLifecycleHookName (clojure.core/str v6536))))
   (clojure.core/let
    [v6536
     (:lifecycle-transition
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setLifecycleTransition (clojure.core/str v6536))))
   (clojure.core/let
    [v6536
     (:role-arn m6535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setRoleARN (clojure.core/str v6536))))
   (clojure.core/let
    [v6536
     (:notification-target-arn
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setNotificationTargetARN (clojure.core/str v6536))))
   (clojure.core/let
    [v6536
     (:notification-metadata
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setNotificationMetadata (clojure.core/str v6536))))
   (clojure.core/let
    [v6536
     (:heartbeat-timeout
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setHeartbeatTimeout (clojure.core/int v6536))))
   (clojure.core/let
    [v6536
     (:default-result m6535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setDefaultResult (clojure.core/str v6536))))
   bean6534))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExecutePolicyRequest}
execute-policy-request
  [m6538]
  (clojure.core/let
   [bean6537
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/let
    [v6539
     (:auto-scaling-group-name
      m6538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setAutoScalingGroupName (clojure.core/str v6539))))
   (clojure.core/let
    [v6539
     (:policy-name m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setPolicyName (clojure.core/str v6539))))
   (clojure.core/let
    [v6539
     (:honor-cooldown m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setHonorCooldown (clojure.core/boolean v6539))))
   (clojure.core/let
    [v6539
     (:metric-value m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setMetricValue (clojure.core/double v6539))))
   (clojure.core/let
    [v6539
     (:breach-threshold
      m6538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setBreachThreshold (clojure.core/double v6539))))
   bean6537))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest}
record-lifecycle-action-heartbeat-request
  [m6541]
  (clojure.core/let
   [bean6540
    (new
     com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest)]
   (clojure.core/let
    [v6542
     (:auto-scaling-group-name
      m6541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setAutoScalingGroupName (clojure.core/str v6542))))
   (clojure.core/let
    [v6542
     (:instance-id m6541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setInstanceId (clojure.core/str v6542))))
   (clojure.core/let
    [v6542
     (:lifecycle-hook-name
      m6541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setLifecycleHookName (clojure.core/str v6542))))
   (clojure.core/let
    [v6542
     (:lifecycle-action-token
      m6541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setLifecycleActionToken (clojure.core/str v6542))))
   bean6540))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExitStandbyRequest}
exit-standby-request
  [m6544]
  (clojure.core/let
   [bean6543
    (new com.amazonaws.services.autoscaling.model.ExitStandbyRequest)]
   (clojure.core/let
    [v6545
     (:auto-scaling-group-name
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setAutoScalingGroupName (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:instance-ids m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (.
      bean6543
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6607] (clojure.core/str arg6607))
 v6545))))
   bean6543))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DetachInstancesRequest}
detach-instances-request
  [m6547]
  (clojure.core/let
   [bean6546
    (new
     com.amazonaws.services.autoscaling.model.DetachInstancesRequest)]
   (clojure.core/let
    [v6548
     (:auto-scaling-group-name
      m6547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6548 :com.palletops.awaze.client-builder/undef)
     (. bean6546 setAutoScalingGroupName (clojure.core/str v6548))))
   (clojure.core/let
    [v6548
     (:instance-ids m6547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6548 :com.palletops.awaze.client-builder/undef)
     (.
      bean6546
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6608] (clojure.core/str arg6608))
 v6548))))
   (clojure.core/let
    [v6548
     (:should-decrement-desired-capacity
      m6547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6548 :com.palletops.awaze.client-builder/undef)
     (.
      bean6546
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6548))))
   bean6546))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest}
set-desired-capacity-request
  [m6550]
  (clojure.core/let
   [bean6549
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/let
    [v6551
     (:auto-scaling-group-name
      m6550
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6551 :com.palletops.awaze.client-builder/undef)
     (. bean6549 setAutoScalingGroupName (clojure.core/str v6551))))
   (clojure.core/let
    [v6551
     (:desired-capacity
      m6550
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6551 :com.palletops.awaze.client-builder/undef)
     (. bean6549 setDesiredCapacity (clojure.core/int v6551))))
   (clojure.core/let
    [v6551
     (:honor-cooldown m6550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6551 :com.palletops.awaze.client-builder/undef)
     (. bean6549 setHonorCooldown (clojure.core/boolean v6551))))
   bean6549))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest}
set-instance-health-request
  [m6553]
  (clojure.core/let
   [bean6552
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/let
    [v6554
     (:instance-id m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setInstanceId (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:should-respect-grace-period
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (.
      bean6552
      setShouldRespectGracePeriod
      (clojure.core/boolean v6554))))
   (clojure.core/let
    [v6554
     (:health-status m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setHealthStatus (clojure.core/str v6554))))
   bean6552))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribePoliciesRequest}
describe-policies-request
  [m6556]
  (clojure.core/let
   [bean6555
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/let
    [v6557
     (:auto-scaling-group-name
      m6556
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6557 :com.palletops.awaze.client-builder/undef)
     (. bean6555 setAutoScalingGroupName (clojure.core/str v6557))))
   (clojure.core/let
    [v6557
     (:next-token m6556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6557 :com.palletops.awaze.client-builder/undef)
     (. bean6555 setNextToken (clojure.core/str v6557))))
   (clojure.core/let
    [v6557
     (:policy-names m6556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6557 :com.palletops.awaze.client-builder/undef)
     (.
      bean6555
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6665] (clojure.core/str arg6665))
 v6557))))
   (clojure.core/let
    [v6557
     (:max-records m6556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6557 :com.palletops.awaze.client-builder/undef)
     (. bean6555 setMaxRecords (clojure.core/int v6557))))
   (clojure.core/let
    [v6557
     (:policy-types m6556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6557 :com.palletops.awaze.client-builder/undef)
     (.
      bean6555
      setPolicyTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6666] (clojure.core/str arg6666))
 v6557))))
   bean6555))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest}
put-scheduled-update-group-action-request
  [m6559]
  (clojure.core/let
   [bean6558
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/let
    [v6560 (:time m6559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setTime (com.palletops.awaze.common/to-date v6560))))
   (clojure.core/let
    [v6560
     (:desired-capacity
      m6559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setDesiredCapacity (clojure.core/int v6560))))
   (clojure.core/let
    [v6560
     (:scheduled-action-name
      m6559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setScheduledActionName (clojure.core/str v6560))))
   (clojure.core/let
    [v6560
     (:start-time m6559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (.
      bean6558
      setStartTime
      (com.palletops.awaze.common/to-date v6560))))
   (clojure.core/let
    [v6560
     (:recurrence m6559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setRecurrence (clojure.core/str v6560))))
   (clojure.core/let
    [v6560
     (:min-size m6559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setMinSize (clojure.core/int v6560))))
   (clojure.core/let
    [v6560
     (:end-time m6559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (.
      bean6558
      setEndTime
      (com.palletops.awaze.common/to-date v6560))))
   (clojure.core/let
    [v6560
     (:auto-scaling-group-name
      m6559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setAutoScalingGroupName (clojure.core/str v6560))))
   (clojure.core/let
    [v6560
     (:max-size m6559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setMaxSize (clojure.core/int v6560))))
   bean6558))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnterStandbyRequest}
enter-standby-request
  [m6562]
  (clojure.core/let
   [bean6561
    (new com.amazonaws.services.autoscaling.model.EnterStandbyRequest)]
   (clojure.core/let
    [v6563
     (:auto-scaling-group-name
      m6562
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6563 :com.palletops.awaze.client-builder/undef)
     (. bean6561 setAutoScalingGroupName (clojure.core/str v6563))))
   (clojure.core/let
    [v6563
     (:instance-ids m6562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6563 :com.palletops.awaze.client-builder/undef)
     (.
      bean6561
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6667] (clojure.core/str arg6667))
 v6563))))
   (clojure.core/let
    [v6563
     (:should-decrement-desired-capacity
      m6562
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6563 :com.palletops.awaze.client-builder/undef)
     (.
      bean6561
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6563))))
   bean6561))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest}
enable-metrics-collection-request
  [m6565]
  (clojure.core/let
   [bean6564
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/let
    [v6566
     (:auto-scaling-group-name
      m6565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6566 :com.palletops.awaze.client-builder/undef)
     (. bean6564 setAutoScalingGroupName (clojure.core/str v6566))))
   (clojure.core/let
    [v6566 (:metrics m6565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6566 :com.palletops.awaze.client-builder/undef)
     (.
      bean6564
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6668] (clojure.core/str arg6668))
 v6566))))
   (clojure.core/let
    [v6566
     (:granularity m6565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6566 :com.palletops.awaze.client-builder/undef)
     (. bean6564 setGranularity (clojure.core/str v6566))))
   bean6564))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest}
describe-metric-collection-types-request
  [m6568]
  (clojure.core/let
   [bean6567
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean6567))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest}
create-launch-configuration-request
  [m6571]
  (clojure.core/let
   [bean6570
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/let
    [v6572
     (:instance-monitoring
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (.
      bean6570
      setInstanceMonitoring
      (autoscaling/instance-monitoring v6572))))
   (clojure.core/let
    [v6572
     (:spot-price m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setSpotPrice (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:iam-instance-profile
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setIamInstanceProfile (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:classic-link-vpcid
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setClassicLinkVPCId (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:instance-type m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setInstanceType (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:ebs-optimized m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setEbsOptimized (clojure.core/boolean v6572))))
   (clojure.core/let
    [v6572
     (:ramdisk-id m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setRamdiskId (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:instance-id m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setInstanceId (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:image-id m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setImageId (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:launch-configuration-name
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setLaunchConfigurationName (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:key-name m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setKeyName (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:classic-link-vpcsecurity-groups
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (.
      bean6570
      setClassicLinkVPCSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6669] (clojure.core/str arg6669))
 v6572))))
   (clojure.core/let
    [v6572
     (:placement-tenancy
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setPlacementTenancy (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:kernel-id m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setKernelId (clojure.core/str v6572))))
   (clojure.core/let
    [v6572
     (:associate-public-ip-address
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (.
      bean6570
      setAssociatePublicIpAddress
      (clojure.core/boolean v6572))))
   (clojure.core/let
    [v6572
     (:security-groups
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (.
      bean6570
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6670] (clojure.core/str arg6670))
 v6572))))
   (clojure.core/let
    [v6572
     (:block-device-mappings
      m6571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (.
      bean6570
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6671]
  (autoscaling/block-device-mapping arg6671))
 v6572))))
   (clojure.core/let
    [v6572
     (:user-data m6571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6572 :com.palletops.awaze.client-builder/undef)
     (. bean6570 setUserData (clojure.core/str v6572))))
   bean6570))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest}
delete-lifecycle-hook-request
  [m6574]
  (clojure.core/let
   [bean6573
    (new
     com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest)]
   (clojure.core/let
    [v6575
     (:auto-scaling-group-name
      m6574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6575 :com.palletops.awaze.client-builder/undef)
     (. bean6573 setAutoScalingGroupName (clojure.core/str v6575))))
   (clojure.core/let
    [v6575
     (:lifecycle-hook-name
      m6574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6575 :com.palletops.awaze.client-builder/undef)
     (. bean6573 setLifecycleHookName (clojure.core/str v6575))))
   bean6573))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest}
describe-launch-configurations-request
  [m6577]
  (clojure.core/let
   [bean6576
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/let
    [v6578
     (:next-token m6577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6578 :com.palletops.awaze.client-builder/undef)
     (. bean6576 setNextToken (clojure.core/str v6578))))
   (clojure.core/let
    [v6578
     (:max-records m6577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6578 :com.palletops.awaze.client-builder/undef)
     (. bean6576 setMaxRecords (clojure.core/int v6578))))
   (clojure.core/let
    [v6578
     (:launch-configuration-names
      m6577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6578 :com.palletops.awaze.client-builder/undef)
     (.
      bean6576
      setLaunchConfigurationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6672] (clojure.core/str arg6672))
 v6578))))
   bean6576))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest}
describe-lifecycle-hook-types-request
  [m6580]
  (clojure.core/let
   [bean6579
    (new
     com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest)]
   bean6579))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn
   autoscaling
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m6609]
   (clojure.core/let
    [credentials6610 (:credentials m6609) args6611 (:args m6609)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6612
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6610)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6612
       updateAutoScalingGroup
       (autoscaling/update-auto-scaling-group-request
        (clojure.core/nth args6611 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Call updateAutoScalingGroup"}
   [credentials6614 & args6615]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6616
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6614)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6616
      updateAutoScalingGroup
      (autoscaling/update-auto-scaling-group-request
       (clojure.core/nth args6615 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-load-balancers
   [m6617]
   (clojure.core/let
    [credentials6618 (:credentials m6617) args6619 (:args m6617)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6620
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6618)]
     (clojure.core/case
      (clojure.core/count args6619)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6620
        attachLoadBalancers
        (autoscaling/attach-load-balancers-request
         (clojure.core/nth args6619 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6620
        attachLoadBalancers))))))
  (clojure.core/defn
   attach-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Generate map for attachLoadBalancers, attachLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :attach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   attach-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Call attachLoadBalancers, attachLoadBalancers"}
   [credentials6622 & args6623]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6624
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6622)]
    (clojure.core/case
     (clojure.core/count args6623)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6624
       attachLoadBalancers
       (autoscaling/attach-load-balancers-request
        (clojure.core/nth args6623 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6624
       attachLoadBalancers))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m6625]
   (clojure.core/let
    [credentials6626 (:credentials m6625) args6627 (:args m6625)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6628
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6626)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6628
       createOrUpdateTags
       (autoscaling/create-or-update-tags-request
        (clojure.core/nth args6627 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-or-update-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createOrUpdateTags"}
   [credentials6630 & args6631]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6632
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6630)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6632
      createOrUpdateTags
      (autoscaling/create-or-update-tags-request
       (clojure.core/nth args6631 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m6633]
   (clojure.core/let
    [credentials6634 (:credentials m6633) args6635 (:args m6633)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6636
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6634)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6636
       resumeProcesses
       (autoscaling/resume-processes-request
        (clojure.core/nth args6635 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for resumeProcesses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :resume-processes,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   resume-processes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call resumeProcesses"}
   [credentials6638 & args6639]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6640
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6638)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6640
      resumeProcesses
      (autoscaling/resume-processes-request
       (clojure.core/nth args6639 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m6641]
   (clojure.core/let
    [credentials6642 (:credentials m6641) args6643 (:args m6641)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6644
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6642)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6644
       terminateInstanceInAutoScalingGroup
       (autoscaling/terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args6643 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         should-decrement-desired-capacity
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         should-decrement-desired-capacity
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials6646 & args6647]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6648
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6646)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6648
      terminateInstanceInAutoScalingGroup
      (autoscaling/terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args6647 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m6649]
   (clojure.core/let
    [credentials6650 (:credentials m6649) args6651 (:args m6649)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6652
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6650)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6652
       deleteAutoScalingGroup
       (autoscaling/delete-auto-scaling-group-request
        (clojure.core/nth args6651 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         force-delete
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         force-delete
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteAutoScalingGroup"}
   [credentials6654 & args6655]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6656
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6654)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6656
      deleteAutoScalingGroup
      (autoscaling/delete-auto-scaling-group-request
       (clojure.core/nth args6655 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-load-balancers
   [m6657]
   (clojure.core/let
    [credentials6658 (:credentials m6657) args6659 (:args m6657)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6660
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6658)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6660
       describeLoadBalancers
       (autoscaling/describe-load-balancers-request
        (clojure.core/nth args6659 0)))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeLoadBalancers"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeLoadBalancers"}
   [credentials6662 & args6663]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6664
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6662)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6664
      describeLoadBalancers
      (autoscaling/describe-load-balancers-request
       (clojure.core/nth args6663 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m6673]
   (clojure.core/let
    [credentials6674 (:credentials m6673) args6675 (:args m6673)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6676
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6674)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6676
       disableMetricsCollection
       (autoscaling/disable-metrics-collection-request
        (clojure.core/nth args6675 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-metrics-collection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call disableMetricsCollection"}
   [credentials6678 & args6679]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6680
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6678)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6680
      disableMetricsCollection
      (autoscaling/disable-metrics-collection-request
       (clojure.core/nth args6679 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m6681]
   (clojure.core/let
    [credentials6682 (:credentials m6681) args6683 (:args m6681)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6684
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6682)]
     (clojure.core/case
      (clojure.core/count args6683)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6684
        describeScheduledActions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6684
        describeScheduledActions
        (autoscaling/describe-scheduled-actions-request
         (clojure.core/nth args6683 0))))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scheduled-action-names
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scheduled-actions,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-actions,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scheduled-action-names
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials6686 & args6687]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6688
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6686)]
    (clojure.core/case
     (clojure.core/count args6687)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6688
       describeScheduledActions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6688
       describeScheduledActions
       (autoscaling/describe-scheduled-actions-request
        (clojure.core/nth args6687 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m6689]
   (clojure.core/let
    [credentials6690 (:credentials m6689) args6691 (:args m6689)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6692
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6690)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6692
       deleteNotificationConfiguration
       (autoscaling/delete-notification-configuration-request
        (clojure.core/nth args6691 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteNotificationConfiguration"}
   [credentials6694 & args6695]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6696
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6694)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6696
      deleteNotificationConfiguration
      (autoscaling/delete-notification-configuration-request
       (clojure.core/nth args6695 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m6697]
   (clojure.core/let
    [credentials6698 (:credentials m6697) args6699 (:args m6697)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6700
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6698)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6700
       putScalingPolicy
       (autoscaling/put-scaling-policy-request
        (clojure.core/nth args6699 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [estimated-instance-warmup
                         adjustment-type
                         custom-request-headers
                         sdk-client-execution-timeout
                         metric-aggregation-type
                         sdk-request-timeout
                         scaling-adjustment
                         min-adjustment-magnitude
                         custom-query-parameters
                         cooldown
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-type
                         clone-source
                         step-adjustments
                         clone-root
                         min-adjustment-step
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScalingPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-scaling-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists (quote
               [[credentials
                 {:keys [estimated-instance-warmup
                         adjustment-type
                         custom-request-headers
                         sdk-client-execution-timeout
                         metric-aggregation-type
                         sdk-request-timeout
                         scaling-adjustment
                         min-adjustment-magnitude
                         custom-query-parameters
                         cooldown
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-type
                         clone-source
                         step-adjustments
                         clone-root
                         min-adjustment-step
                         auto-scaling-group-name]}]]),
    :doc "Call putScalingPolicy"}
   [credentials6702 & args6703]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6704
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6702)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6704
      putScalingPolicy
      (autoscaling/put-scaling-policy-request
       (clojure.core/nth args6703 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m6705]
   (clojure.core/let
    [credentials6706 (:credentials m6705) args6707 (:args m6705)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6708
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6706)]
     (clojure.core/case
      (clojure.core/count args6707)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6708
        describeScalingActivities
        (autoscaling/describe-scaling-activities-request
         (clojure.core/nth args6707 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6708
        describeScalingActivities))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         activity-ids
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scaling-activities,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scaling-activities,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         activity-ids
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]
                [credentials]]),
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials6710 & args6711]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6712
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6710)]
    (clojure.core/case
     (clojure.core/count args6711)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6712
       describeScalingActivities
       (autoscaling/describe-scaling-activities-request
        (clojure.core/nth args6711 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6712
       describeScalingActivities))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-lifecycle-hooks
   [m6713]
   (clojure.core/let
    [credentials6714 (:credentials m6713) args6715 (:args m6713)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6716
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6714)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6716
       describeLifecycleHooks
       (autoscaling/describe-lifecycle-hooks-request
        (clojure.core/nth args6715 0)))))))
  (clojure.core/defn
   describe-lifecycle-hooks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-hook-names
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for describeLifecycleHooks"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-lifecycle-hooks,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-lifecycle-hooks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-hook-names
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call describeLifecycleHooks"}
   [credentials6718 & args6719]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6720
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6718)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6720
      describeLifecycleHooks
      (autoscaling/describe-lifecycle-hooks-request
       (clojure.core/nth args6719 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m6721]
   (clojure.core/let
    [credentials6722 (:credentials m6721) args6723 (:args m6721)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6724
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6722)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6724
       deleteLaunchConfiguration
       (autoscaling/delete-launch-configuration-request
        (clojure.core/nth args6723 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-launch-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLaunchConfiguration"}
   [credentials6726 & args6727]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6728
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6726)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6728
      deleteLaunchConfiguration
      (autoscaling/delete-launch-configuration-request
       (clojure.core/nth args6727 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m6729]
   (clojure.core/let
    [credentials6730 (:credentials m6729) args6731 (:args m6729)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6732
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6730)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6732
       deletePolicy
       (autoscaling/delete-policy-request
        (clojure.core/nth args6731 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deletePolicy"}
   [credentials6734 & args6735]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6736
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6734)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6736
      deletePolicy
      (autoscaling/delete-policy-request
       (clojure.core/nth args6735 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m6737]
   (clojure.core/let
    [credentials6738 (:credentials m6737) args6739 (:args m6737)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6740
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6738)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6740
       createAutoScalingGroup
       (autoscaling/create-auto-scaling-group-request
        (clojure.core/nth args6739 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         instance-id
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         instance-id
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Call createAutoScalingGroup"}
   [credentials6742 & args6743]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6744
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6742)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6744
      createAutoScalingGroup
      (autoscaling/create-auto-scaling-group-request
       (clojure.core/nth args6743 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m6745]
   (clojure.core/let
    [credentials6746 (:credentials m6745) args6747 (:args m6745)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6748
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6746)]
     (clojure.core/case
      (clojure.core/count args6747)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6748
        describeScalingProcessTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6748
        describeScalingProcessTypes
        (autoscaling/describe-scaling-process-types-request
         (clojure.core/nth args6747 0))))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scaling-process-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scaling-process-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials6750 & args6751]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6752
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6750)]
    (clojure.core/case
     (clojure.core/count args6751)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6752
       describeScalingProcessTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6752
       describeScalingProcessTypes
       (autoscaling/describe-scaling-process-types-request
        (clojure.core/nth args6751 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-account-limits
   [m6753]
   (clojure.core/let
    [credentials6754 (:credentials m6753) args6755 (:args m6753)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6756
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6754)]
     (clojure.core/case
      (clojure.core/count args6755)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6756
        describeAccountLimits))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6756
        describeAccountLimits
        (autoscaling/describe-account-limits-request
         (clojure.core/nth args6755 0))))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAccountLimits, describeAccountLimits"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAccountLimits, describeAccountLimits"}
   [credentials6758 & args6759]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6760
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6758)]
    (clojure.core/case
     (clojure.core/count args6759)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6760
       describeAccountLimits))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6760
       describeAccountLimits
       (autoscaling/describe-account-limits-request
        (clojure.core/nth args6759 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m6761]
   (clojure.core/let
    [credentials6762 (:credentials m6761) args6763 (:args m6761)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6764
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6762)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6764
       deleteScheduledAction
       (autoscaling/delete-scheduled-action-request
        (clojure.core/nth args6763 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-scheduled-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteScheduledAction"}
   [credentials6766 & args6767]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6768
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6766)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6768
      deleteScheduledAction
      (autoscaling/delete-scheduled-action-request
       (clojure.core/nth args6767 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m6769]
   (clojure.core/let
    [credentials6770 (:credentials m6769) args6771 (:args m6769)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6772
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6770)]
     (clojure.core/case
      (clojure.core/count args6771)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6772
        describeNotificationConfigurations
        (autoscaling/describe-notification-configurations-request
         (clojure.core/nth args6771 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6772
        describeNotificationConfigurations))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-notification-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-notification-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials6774 & args6775]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6776
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6774)]
    (clojure.core/case
     (clojure.core/count args6775)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6776
       describeNotificationConfigurations
       (autoscaling/describe-notification-configurations-request
        (clojure.core/nth args6775 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6776
       describeNotificationConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m6777]
   (clojure.core/let
    [credentials6778 (:credentials m6777) args6779 (:args m6777)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6780
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6778)]
     (clojure.core/case
      (clojure.core/count args6779)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6780
        describeAdjustmentTypes
        (autoscaling/describe-adjustment-types-request
         (clojure.core/nth args6779 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6780
        describeAdjustmentTypes))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-adjustment-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-adjustment-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials6782 & args6783]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6784
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6782)]
    (clojure.core/case
     (clojure.core/count args6783)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6784
       describeAdjustmentTypes
       (autoscaling/describe-adjustment-types-request
        (clojure.core/nth args6783 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6784
       describeAdjustmentTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m6785]
   (clojure.core/let
    [credentials6786 (:credentials m6785) args6787 (:args m6785)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6788
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6786)]
     (clojure.core/case
      (clojure.core/count args6787)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6788
        describeAutoScalingInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6788
        describeAutoScalingInstances
        (autoscaling/describe-auto-scaling-instances-request
         (clojure.core/nth args6787 0))))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials6790 & args6791]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6792
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6790)]
    (clojure.core/case
     (clojure.core/count args6791)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6792
       describeAutoScalingInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6792
       describeAutoScalingInstances
       (autoscaling/describe-auto-scaling-instances-request
        (clojure.core/nth args6791 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m6793]
   (clojure.core/let
    [credentials6794 (:credentials m6793) args6795 (:args m6793)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6796
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6794)]
     (clojure.core/case
      (clojure.core/count args6795)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6796
        describeTerminationPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6796
        describeTerminationPolicyTypes
        (autoscaling/describe-termination-policy-types-request
         (clojure.core/nth args6795 0))))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-termination-policy-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-termination-policy-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials6798 & args6799]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6800
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6798)]
    (clojure.core/case
     (clojure.core/count args6799)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6800
       describeTerminationPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6800
       describeTerminationPolicyTypes
       (autoscaling/describe-termination-policy-types-request
        (clojure.core/nth args6799 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-instances
   [m6801]
   (clojure.core/let
    [credentials6802 (:credentials m6801) args6803 (:args m6801)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6804
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6802)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6804
       attachInstances
       (autoscaling/attach-instances-request
        (clojure.core/nth args6803 0)))))))
  (clojure.core/defn
   attach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for attachInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   attach-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call attachInstances"}
   [credentials6806 & args6807]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6808
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6806)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6808
      attachInstances
      (autoscaling/attach-instances-request
       (clojure.core/nth args6807 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m6809]
   (clojure.core/let
    [credentials6810 (:credentials m6809) args6811 (:args m6809)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6812
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6810)]
     (clojure.core/case
      (clojure.core/count args6811)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6812
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6812
        describeTags
        (autoscaling/describe-tags-request
         (clojure.core/nth args6811 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials6814 & args6815]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6816
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6814)]
    (clojure.core/case
     (clojure.core/count args6815)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6816
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6816
       describeTags
       (autoscaling/describe-tags-request
        (clojure.core/nth args6815 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m6817]
   (clojure.core/let
    [credentials6818 (:credentials m6817) args6819 (:args m6817)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6820
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6818)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6820
       deleteTags
       (autoscaling/delete-tags-request (clojure.core/nth args6819 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials6822 & args6823]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6824
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6822)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6824
      deleteTags
      (autoscaling/delete-tags-request (clojure.core/nth args6823 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m6825]
   (clojure.core/let
    [credentials6826 (:credentials m6825) args6827 (:args m6825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6828
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6826)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6828
       putNotificationConfiguration
       (autoscaling/put-notification-configuration-request
        (clojure.core/nth args6827 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         notification-types
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         notification-types
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call putNotificationConfiguration"}
   [credentials6830 & args6831]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6832
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6830)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6832
      putNotificationConfiguration
      (autoscaling/put-notification-configuration-request
       (clojure.core/nth args6831 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :detach-load-balancers
   [m6833]
   (clojure.core/let
    [credentials6834 (:credentials m6833) args6835 (:args m6833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6836
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6834)]
     (clojure.core/case
      (clojure.core/count args6835)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6836
        detachLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6836
        detachLoadBalancers
        (autoscaling/detach-load-balancers-request
         (clojure.core/nth args6835 0))))))))
  (clojure.core/defn
   detach-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for detachLoadBalancers, detachLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :detach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   detach-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call detachLoadBalancers, detachLoadBalancers"}
   [credentials6838 & args6839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6840
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6838)]
    (clojure.core/case
     (clojure.core/count args6839)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6840
       detachLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6840
       detachLoadBalancers
       (autoscaling/detach-load-balancers-request
        (clojure.core/nth args6839 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m6841]
   (clojure.core/let
    [credentials6842 (:credentials m6841) args6843 (:args m6841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6844
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6842)]
     (clojure.core/case
      (clojure.core/count args6843)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6844
        describeAutoScalingNotificationTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6844
        describeAutoScalingNotificationTypes
        (autoscaling/describe-auto-scaling-notification-types-request
         (clojure.core/nth args6843 0))))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials6846 & args6847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6848
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6846)]
    (clojure.core/case
     (clojure.core/count args6847)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6848
       describeAutoScalingNotificationTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6848
       describeAutoScalingNotificationTypes
       (autoscaling/describe-auto-scaling-notification-types-request
        (clojure.core/nth args6847 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-protection
   [m6849]
   (clojure.core/let
    [credentials6850 (:credentials m6849) args6851 (:args m6849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6852
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6852
       setInstanceProtection
       (autoscaling/set-instance-protection-request
        (clojure.core/nth args6851 0)))))))
  (clojure.core/defn
   set-instance-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         protected-from-scale-in
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setInstanceProtection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-instance-protection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-instance-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         protected-from-scale-in
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call setInstanceProtection"}
   [credentials6854 & args6855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6856
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6856
      setInstanceProtection
      (autoscaling/set-instance-protection-request
       (clojure.core/nth args6855 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :complete-lifecycle-action
   [m6857]
   (clojure.core/let
    [credentials6858 (:credentials m6857) args6859 (:args m6857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6860
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6858)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6860
       completeLifecycleAction
       (autoscaling/complete-lifecycle-action-request
        (clojure.core/nth args6859 0)))))))
  (clojure.core/defn
   complete-lifecycle-action-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         lifecycle-action-result
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for completeLifecycleAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-lifecycle-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   complete-lifecycle-action
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         lifecycle-action-result
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call completeLifecycleAction"}
   [credentials6862 & args6863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6864
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6862)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6864
      completeLifecycleAction
      (autoscaling/complete-lifecycle-action-request
       (clojure.core/nth args6863 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m6865]
   (clojure.core/let
    [credentials6866 (:credentials m6865) args6867 (:args m6865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6868
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6868
       suspendProcesses
       (autoscaling/suspend-processes-request
        (clojure.core/nth args6867 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for suspendProcesses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :suspend-processes,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   suspend-processes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call suspendProcesses"}
   [credentials6870 & args6871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6872
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6872
      suspendProcesses
      (autoscaling/suspend-processes-request
       (clojure.core/nth args6871 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m6873]
   (clojure.core/let
    [credentials6874 (:credentials m6873) args6875 (:args m6873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6876
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6874)]
     (clojure.core/case
      (clojure.core/count args6875)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6876
        describeAutoScalingGroups
        (autoscaling/describe-auto-scaling-groups-request
         (clojure.core/nth args6875 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6876
        describeAutoScalingGroups))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials6878 & args6879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6880
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6878)]
    (clojure.core/case
     (clojure.core/count args6879)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6880
       describeAutoScalingGroups
       (autoscaling/describe-auto-scaling-groups-request
        (clojure.core/nth args6879 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6880
       describeAutoScalingGroups))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-lifecycle-hook
   [m6881]
   (clojure.core/let
    [credentials6882 (:credentials m6881) args6883 (:args m6881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6884
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6884
       putLifecycleHook
       (autoscaling/put-lifecycle-hook-request
        (clojure.core/nth args6883 0)))))))
  (clojure.core/defn
   put-lifecycle-hook-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-metadata
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-target-arn
                         sdk-request-timeout
                         custom-query-parameters
                         heartbeat-timeout
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-transition
                         clone-root
                         auto-scaling-group-name
                         default-result]}]]),
    :doc "Generate map for putLifecycleHook"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-lifecycle-hook,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-lifecycle-hook
   {:arglists (quote
               [[credentials
                 {:keys [notification-metadata
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-target-arn
                         sdk-request-timeout
                         custom-query-parameters
                         heartbeat-timeout
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-transition
                         clone-root
                         auto-scaling-group-name
                         default-result]}]]),
    :doc "Call putLifecycleHook"}
   [credentials6886 & args6887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6888
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6888
      putLifecycleHook
      (autoscaling/put-lifecycle-hook-request
       (clojure.core/nth args6887 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m6889]
   (clojure.core/let
    [credentials6890 (:credentials m6889) args6891 (:args m6889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6892
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6892
       executePolicy
       (autoscaling/execute-policy-request
        (clojure.core/nth args6891 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         breach-threshold
                         metric-value
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for executePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :execute-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   execute-policy
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         breach-threshold
                         metric-value
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call executePolicy"}
   [credentials6894 & args6895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6896
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6896
      executePolicy
      (autoscaling/execute-policy-request
       (clojure.core/nth args6895 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :record-lifecycle-action-heartbeat
   [m6897]
   (clojure.core/let
    [credentials6898 (:credentials m6897) args6899 (:args m6897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6900
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6900
       recordLifecycleActionHeartbeat
       (autoscaling/record-lifecycle-action-heartbeat-request
        (clojure.core/nth args6899 0)))))))
  (clojure.core/defn
   record-lifecycle-action-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for recordLifecycleActionHeartbeat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :record-lifecycle-action-heartbeat,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   record-lifecycle-action-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call recordLifecycleActionHeartbeat"}
   [credentials6902 & args6903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6904
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6904
      recordLifecycleActionHeartbeat
      (autoscaling/record-lifecycle-action-heartbeat-request
       (clojure.core/nth args6903 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :exit-standby
   [m6905]
   (clojure.core/let
    [credentials6906 (:credentials m6905) args6907 (:args m6905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6908
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6908
       exitStandby
       (autoscaling/exit-standby-request
        (clojure.core/nth args6907 0)))))))
  (clojure.core/defn
   exit-standby-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for exitStandby"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :exit-standby,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   exit-standby
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call exitStandby"}
   [credentials6910 & args6911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6912
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6912
      exitStandby
      (autoscaling/exit-standby-request (clojure.core/nth args6911 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :detach-instances
   [m6913]
   (clojure.core/let
    [credentials6914 (:credentials m6913) args6915 (:args m6913)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6916
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6914)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6916
       detachInstances
       (autoscaling/detach-instances-request
        (clojure.core/nth args6915 0)))))))
  (clojure.core/defn
   detach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for detachInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   detach-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call detachInstances"}
   [credentials6918 & args6919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6920
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6918)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6920
      detachInstances
      (autoscaling/detach-instances-request
       (clojure.core/nth args6919 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m6921]
   (clojure.core/let
    [credentials6922 (:credentials m6921) args6923 (:args m6921)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6924
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6922)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6924
       setDesiredCapacity
       (autoscaling/set-desired-capacity-request
        (clojure.core/nth args6923 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         desired-capacity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-desired-capacity,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         desired-capacity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call setDesiredCapacity"}
   [credentials6926 & args6927]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6928
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6926)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6928
      setDesiredCapacity
      (autoscaling/set-desired-capacity-request
       (clojure.core/nth args6927 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m6929]
   (clojure.core/let
    [credentials6930 (:credentials m6929) args6931 (:args m6929)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6932
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6930)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6932
       setInstanceHealth
       (autoscaling/set-instance-health-request
        (clojure.core/nth args6931 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [health-status
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         should-respect-grace-period]}]]),
    :doc "Generate map for setInstanceHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-instance-health,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [health-status
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         should-respect-grace-period]}]]),
    :doc "Call setInstanceHealth"}
   [credentials6934 & args6935]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6936
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6934)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6936
      setInstanceHealth
      (autoscaling/set-instance-health-request
       (clojure.core/nth args6935 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m6937]
   (clojure.core/let
    [credentials6938 (:credentials m6937) args6939 (:args m6937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6940
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6938)]
     (clojure.core/case
      (clojure.core/count args6939)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6940
        describePolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6940
        describePolicies
        (autoscaling/describe-policies-request
         (clojure.core/nth args6939 0))))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         policy-types
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-policies,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-policies,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         policy-types
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describePolicies, describePolicies"}
   [credentials6942 & args6943]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6944
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6942)]
    (clojure.core/case
     (clojure.core/count args6943)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6944
       describePolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6944
       describePolicies
       (autoscaling/describe-policies-request
        (clojure.core/nth args6943 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m6945]
   (clojure.core/let
    [credentials6946 (:credentials m6945) args6947 (:args m6945)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6948
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6946)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6948
       putScheduledUpdateGroupAction
       (autoscaling/put-scheduled-update-group-action-request
        (clojure.core/nth args6947 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         time
                         start-time
                         custom-query-parameters
                         end-time
                         max-size
                         desired-capacity
                         min-size
                         read-limit
                         general-progress-listener
                         recurrence
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-scheduled-update-group-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         time
                         start-time
                         custom-query-parameters
                         end-time
                         max-size
                         desired-capacity
                         min-size
                         read-limit
                         general-progress-listener
                         recurrence
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials6950 & args6951]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6952
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6950)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6952
      putScheduledUpdateGroupAction
      (autoscaling/put-scheduled-update-group-action-request
       (clojure.core/nth args6951 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enter-standby
   [m6953]
   (clojure.core/let
    [credentials6954 (:credentials m6953) args6955 (:args m6953)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6956
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6954)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6956
       enterStandby
       (autoscaling/enter-standby-request
        (clojure.core/nth args6955 0)))))))
  (clojure.core/defn
   enter-standby-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enterStandby"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enter-standby,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   enter-standby
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call enterStandby"}
   [credentials6958 & args6959]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6960
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6958)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6960
      enterStandby
      (autoscaling/enter-standby-request
       (clojure.core/nth args6959 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m6961]
   (clojure.core/let
    [credentials6962 (:credentials m6961) args6963 (:args m6961)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6964
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6962)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6964
       enableMetricsCollection
       (autoscaling/enable-metrics-collection-request
        (clojure.core/nth args6963 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         granularity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-metrics-collection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         granularity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call enableMetricsCollection"}
   [credentials6966 & args6967]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6968
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6966)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6968
      enableMetricsCollection
      (autoscaling/enable-metrics-collection-request
       (clojure.core/nth args6967 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m6969]
   (clojure.core/let
    [credentials6970 (:credentials m6969) args6971 (:args m6969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6972
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6970)]
     (clojure.core/case
      (clojure.core/count args6971)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6972
        describeMetricCollectionTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6972
        describeMetricCollectionTypes
        (autoscaling/describe-metric-collection-types-request
         (clojure.core/nth args6971 0))))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-metric-collection-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-metric-collection-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials6974 & args6975]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6976
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6974)]
    (clojure.core/case
     (clojure.core/count args6975)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6976
       describeMetricCollectionTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6976
       describeMetricCollectionTypes
       (autoscaling/describe-metric-collection-types-request
        (clojure.core/nth args6975 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m6977]
   (clojure.core/let
    [credentials6978 (:credentials m6977) args6979 (:args m6977)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6980
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6978)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6980
       createLaunchConfiguration
       (autoscaling/create-launch-configuration-request
        (clojure.core/nth args6979 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         security-groups
                         sdk-request-timeout
                         placement-tenancy
                         launch-configuration-name
                         instance-type
                         image-id
                         spot-price
                         instance-monitoring
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         iam-instance-profile
                         read-limit
                         classic-link-vpcsecurity-groups
                         kernel-id
                         general-progress-listener
                         associate-public-ip-address
                         classic-link-vpcid
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-launch-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         security-groups
                         sdk-request-timeout
                         placement-tenancy
                         launch-configuration-name
                         instance-type
                         image-id
                         spot-price
                         instance-monitoring
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         iam-instance-profile
                         read-limit
                         classic-link-vpcsecurity-groups
                         kernel-id
                         general-progress-listener
                         associate-public-ip-address
                         classic-link-vpcid
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createLaunchConfiguration"}
   [credentials6982 & args6983]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6984
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6982)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6984
      createLaunchConfiguration
      (autoscaling/create-launch-configuration-request
       (clojure.core/nth args6983 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-lifecycle-hook
   [m6985]
   (clojure.core/let
    [credentials6986 (:credentials m6985) args6987 (:args m6985)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6988
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6986)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6988
       deleteLifecycleHook
       (autoscaling/delete-lifecycle-hook-request
        (clojure.core/nth args6987 0)))))))
  (clojure.core/defn
   delete-lifecycle-hook-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteLifecycleHook"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-lifecycle-hook,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-lifecycle-hook
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteLifecycleHook"}
   [credentials6990 & args6991]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6992
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6990)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6992
      deleteLifecycleHook
      (autoscaling/delete-lifecycle-hook-request
       (clojure.core/nth args6991 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m6993]
   (clojure.core/let
    [credentials6994 (:credentials m6993) args6995 (:args m6993)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6996
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6994)]
     (clojure.core/case
      (clojure.core/count args6995)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6996
        describeLaunchConfigurations
        (autoscaling/describe-launch-configurations-request
         (clojure.core/nth args6995 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6996
        describeLaunchConfigurations))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-launch-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-launch-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials6998 & args6999]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client7000
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6998)]
    (clojure.core/case
     (clojure.core/count args6999)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client7000
       describeLaunchConfigurations
       (autoscaling/describe-launch-configurations-request
        (clojure.core/nth args6999 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client7000
       describeLaunchConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-lifecycle-hook-types
   [m7001]
   (clojure.core/let
    [credentials7002 (:credentials m7001) args7003 (:args m7001)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client7004
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials7002)]
     (clojure.core/case
      (clojure.core/count args7003)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client7004
        describeLifecycleHookTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client7004
        describeLifecycleHookTypes
        (autoscaling/describe-lifecycle-hook-types-request
         (clojure.core/nth args7003 0))))))))
  (clojure.core/defn
   describe-lifecycle-hook-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLifecycleHookTypes, describeLifecycleHookTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-lifecycle-hook-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-lifecycle-hook-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-lifecycle-hook-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLifecycleHookTypes, describeLifecycleHookTypes"}
   [credentials7006 & args7007]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client7008
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials7006)]
    (clojure.core/case
     (clojure.core/count args7007)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client7008
       describeLifecycleHookTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client7008
       describeLifecycleHookTypes
       (autoscaling/describe-lifecycle-hook-types-request
        (clojure.core/nth args7007 0)))))))))
