(ns
 com.palletops.awaze.sts
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sts :as sts]
  [com.palletops.awaze.beans.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sts
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1792__auto__))
 (clojure.core/defmulti
  sts
  (clojure.core/fn sts [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sts
   :assume-role
   [m11105]
   (clojure.core/let
    [credentials11106 (:credentials m11105) args11107 (:args m11105)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11108
      (com.palletops.awaze.common/aws-client :sts credentials11106)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11108
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args11107 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRole"}
   [credentials11110 & args11111]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11112
     (com.palletops.awaze.common/aws-client :sts credentials11110)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11112
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args11111 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-saml
   [m11113]
   (clojure.core/let
    [credentials11114 (:credentials m11113) args11115 (:args m11113)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11116
      (com.palletops.awaze.common/aws-client :sts credentials11114)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11116
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args11115 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-saml,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials11118 & args11119]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11120
     (com.palletops.awaze.common/aws-client :sts credentials11118)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11120
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args11119 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-web-identity
   [m11121]
   (clojure.core/let
    [credentials11122 (:credentials m11121) args11123 (:args m11121)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11124
      (com.palletops.awaze.common/aws-client :sts credentials11122)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11124
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args11123 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-web-identity,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials11126 & args11127]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11128
     (com.palletops.awaze.common/aws-client :sts credentials11126)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11128
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args11127 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :decode-authorization-message
   [m11129]
   (clojure.core/let
    [credentials11130 (:credentials m11129) args11131 (:args m11129)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11132
      (com.palletops.awaze.common/aws-client :sts credentials11130)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11132
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args11131 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :decode-authorization-message,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials11134 & args11135]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11136
     (com.palletops.awaze.common/aws-client :sts credentials11134)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11136
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args11135 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-federation-token
   [m11137]
   (clojure.core/let
    [credentials11138 (:credentials m11137) args11139 (:args m11137)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11140
      (com.palletops.awaze.common/aws-client :sts credentials11138)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11140
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args11139 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-federation-token,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getFederationToken"}
   [credentials11142 & args11143]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11144
     (com.palletops.awaze.common/aws-client :sts credentials11142)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11144
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args11143 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-session-token
   [m11145]
   (clojure.core/let
    [credentials11146 (:credentials m11145) args11147 (:args m11145)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11148
      (com.palletops.awaze.common/aws-client :sts credentials11146)]
     (clojure.core/case
      (clojure.core/count args11147)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11148
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args11147 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11148
        getSessionToken))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :sts})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials11150 & args11151]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11152
     (com.palletops.awaze.common/aws-client :sts credentials11150)]
    (clojure.core/case
     (clojure.core/count args11151)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11152
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args11151 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11152
       getSessionToken)))))))
