(ns
 com.palletops.awaze.storagegateway
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.storagegateway :as storagegateway]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.Tag}
tag
  [m6992]
  (clojure.core/let
   [bean6991 (new com.amazonaws.services.storagegateway.model.Tag)]
   (clojure.core/let
    [v6993 (:key m6992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6993 :com.palletops.awaze.client-builder/undef)
     (. bean6991 setKey (clojure.core/str v6993))))
   (clojure.core/let
    [v6993 (:value m6992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6993 :com.palletops.awaze.client-builder/undef)
     (. bean6991 setValue (clojure.core/str v6993))))
   bean6991))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest}
update-chap-credentials-request
  [m6995]
  (clojure.core/let
   [bean6994
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/let
    [v6996
     (:target-arn m6995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6996 :com.palletops.awaze.client-builder/undef)
     (. bean6994 setTargetARN (clojure.core/str v6996))))
   (clojure.core/let
    [v6996
     (:initiator-name m6995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6996 :com.palletops.awaze.client-builder/undef)
     (. bean6994 setInitiatorName (clojure.core/str v6996))))
   (clojure.core/let
    [v6996
     (:secret-to-authenticate-initiator
      m6995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6996 :com.palletops.awaze.client-builder/undef)
     (.
      bean6994
      setSecretToAuthenticateInitiator
      (clojure.core/str v6996))))
   (clojure.core/let
    [v6996
     (:secret-to-authenticate-target
      m6995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6996 :com.palletops.awaze.client-builder/undef)
     (.
      bean6994
      setSecretToAuthenticateTarget
      (clojure.core/str v6996))))
   bean6994))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest}
add-working-storage-request
  [m6998]
  (clojure.core/let
   [bean6997
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/let
    [v6999
     (:gateway-arn m6998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6999 :com.palletops.awaze.client-builder/undef)
     (. bean6997 setGatewayARN (clojure.core/str v6999))))
   (clojure.core/let
    [v6999
     (:disk-ids m6998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6999 :com.palletops.awaze.client-builder/undef)
     (.
      bean6997
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7159] (clojure.core/str arg7159))
 v6999))))
   bean6997))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest}
describe-gateway-information-request
  [m7001]
  (clojure.core/let
   [bean7000
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/let
    [v7002
     (:gateway-arn m7001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7002 :com.palletops.awaze.client-builder/undef)
     (. bean7000 setGatewayARN (clojure.core/str v7002))))
   bean7000))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeRequest}
delete-tape-request
  [m7004]
  (clojure.core/let
   [bean7003
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeRequest)]
   (clojure.core/let
    [v7005
     (:gateway-arn m7004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7005 :com.palletops.awaze.client-builder/undef)
     (. bean7003 setGatewayARN (clojure.core/str v7005))))
   (clojure.core/let
    [v7005
     (:tape-arn m7004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7005 :com.palletops.awaze.client-builder/undef)
     (. bean7003 setTapeARN (clojure.core/str v7005))))
   bean7003))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest}
describe-snapshot-schedule-request
  [m7007]
  (clojure.core/let
   [bean7006
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/let
    [v7008
     (:volume-arn m7007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7008 :com.palletops.awaze.client-builder/undef)
     (. bean7006 setVolumeARN (clojure.core/str v7008))))
   bean7006))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapesRequest}
create-tapes-request
  [m7010]
  (clojure.core/let
   [bean7009
    (new
     com.amazonaws.services.storagegateway.model.CreateTapesRequest)]
   (clojure.core/let
    [v7011
     (:client-token m7010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setClientToken (clojure.core/str v7011))))
   (clojure.core/let
    [v7011
     (:gateway-arn m7010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setGatewayARN (clojure.core/str v7011))))
   (clojure.core/let
    [v7011
     (:tape-size-in-bytes
      m7010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setTapeSizeInBytes (clojure.core/long v7011))))
   (clojure.core/let
    [v7011
     (:num-tapes-to-create
      m7010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setNumTapesToCreate (clojure.core/int v7011))))
   (clojure.core/let
    [v7011
     (:tape-barcode-prefix
      m7010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setTapeBarcodePrefix (clojure.core/str v7011))))
   bean7009))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest}
delete-chap-credentials-request
  [m7013]
  (clojure.core/let
   [bean7012
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/let
    [v7014
     (:target-arn m7013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7014 :com.palletops.awaze.client-builder/undef)
     (. bean7012 setTargetARN (clojure.core/str v7014))))
   (clojure.core/let
    [v7014
     (:initiator-name m7013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7014 :com.palletops.awaze.client-builder/undef)
     (. bean7012 setInitiatorName (clojure.core/str v7014))))
   bean7012))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelArchivalRequest}
cancel-archival-request
  [m7016]
  (clojure.core/let
   [bean7015
    (new
     com.amazonaws.services.storagegateway.model.CancelArchivalRequest)]
   (clojure.core/let
    [v7017
     (:gateway-arn m7016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7017 :com.palletops.awaze.client-builder/undef)
     (. bean7015 setGatewayARN (clojure.core/str v7017))))
   (clojure.core/let
    [v7017
     (:tape-arn m7016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7017 :com.palletops.awaze.client-builder/undef)
     (. bean7015 setTapeARN (clojure.core/str v7017))))
   bean7015))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelRetrievalRequest}
cancel-retrieval-request
  [m7019]
  (clojure.core/let
   [bean7018
    (new
     com.amazonaws.services.storagegateway.model.CancelRetrievalRequest)]
   (clojure.core/let
    [v7020
     (:gateway-arn m7019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7020 :com.palletops.awaze.client-builder/undef)
     (. bean7018 setGatewayARN (clojure.core/str v7020))))
   (clojure.core/let
    [v7020
     (:tape-arn m7019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7020 :com.palletops.awaze.client-builder/undef)
     (. bean7018 setTapeARN (clojure.core/str v7020))))
   bean7018))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteVolumeRequest}
delete-volume-request
  [m7022]
  (clojure.core/let
   [bean7021
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v7023
     (:volume-arn m7022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setVolumeARN (clojure.core/str v7023))))
   bean7021))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest}
describe-storedi-scsivolumes-request
  [m7025]
  (clojure.core/let
   [bean7024
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/let
    [v7026
     (:volume-arns m7025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7026 :com.palletops.awaze.client-builder/undef)
     (.
      bean7024
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7160] (clojure.core/str arg7160))
 v7026))))
   bean7024))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m7028]
  (clojure.core/let
   [bean7027
    (new
     com.amazonaws.services.storagegateway.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v7029 (:tags m7028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (.
      bean7027
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7161] (storagegateway/tag arg7161))
 v7029))))
   (clojure.core/let
    [v7029
     (:resource-arn m7028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (. bean7027 setResourceARN (clojure.core/str v7029))))
   bean7027))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest}
create-cachedi-scsivolume-request
  [m7031]
  (clojure.core/let
   [bean7030
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/let
    [v7032
     (:client-token m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setClientToken (clojure.core/str v7032))))
   (clojure.core/let
    [v7032
     (:network-interface-id
      m7031
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setNetworkInterfaceId (clojure.core/str v7032))))
   (clojure.core/let
    [v7032
     (:snapshot-id m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setSnapshotId (clojure.core/str v7032))))
   (clojure.core/let
    [v7032
     (:gateway-arn m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setGatewayARN (clojure.core/str v7032))))
   (clojure.core/let
    [v7032
     (:volume-size-in-bytes
      m7031
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setVolumeSizeInBytes (clojure.core/long v7032))))
   (clojure.core/let
    [v7032
     (:target-name m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setTargetName (clojure.core/str v7032))))
   bean7030))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest}
retrieve-tape-archive-request
  [m7034]
  (clojure.core/let
   [bean7033
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest)]
   (clojure.core/let
    [v7035
     (:gateway-arn m7034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7035 :com.palletops.awaze.client-builder/undef)
     (. bean7033 setGatewayARN (clojure.core/str v7035))))
   (clojure.core/let
    [v7035
     (:tape-arn m7034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7035 :com.palletops.awaze.client-builder/undef)
     (. bean7033 setTapeARN (clojure.core/str v7035))))
   bean7033))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddUploadBufferRequest}
add-upload-buffer-request
  [m7037]
  (clojure.core/let
   [bean7036
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/let
    [v7038
     (:gateway-arn m7037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7038 :com.palletops.awaze.client-builder/undef)
     (. bean7036 setGatewayARN (clojure.core/str v7038))))
   (clojure.core/let
    [v7038
     (:disk-ids m7037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7038 :com.palletops.awaze.client-builder/undef)
     (.
      bean7036
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7162] (clojure.core/str arg7162))
 v7038))))
   bean7036))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumesRequest}
list-volumes-request
  [m7040]
  (clojure.core/let
   [bean7039
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/let
    [v7041 (:limit m7040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7041 :com.palletops.awaze.client-builder/undef)
     (. bean7039 setLimit (clojure.core/int v7041))))
   (clojure.core/let
    [v7041 (:marker m7040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7041 :com.palletops.awaze.client-builder/undef)
     (. bean7039 setMarker (clojure.core/str v7041))))
   (clojure.core/let
    [v7041
     (:gateway-arn m7040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7041 :com.palletops.awaze.client-builder/undef)
     (. bean7039 setGatewayARN (clojure.core/str v7041))))
   bean7039))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest}
describe-tape-archives-request
  [m7043]
  (clojure.core/let
   [bean7042
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest)]
   (clojure.core/let
    [v7044 (:limit m7043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7044 :com.palletops.awaze.client-builder/undef)
     (. bean7042 setLimit (clojure.core/int v7044))))
   (clojure.core/let
    [v7044 (:marker m7043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7044 :com.palletops.awaze.client-builder/undef)
     (. bean7042 setMarker (clojure.core/str v7044))))
   (clojure.core/let
    [v7044
     (:tape-arns m7043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7044 :com.palletops.awaze.client-builder/undef)
     (.
      bean7042
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7163] (clojure.core/str arg7163))
 v7044))))
   bean7042))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest}
describe-upload-buffer-request
  [m7046]
  (clojure.core/let
   [bean7045
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/let
    [v7047
     (:gateway-arn m7046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7047 :com.palletops.awaze.client-builder/undef)
     (. bean7045 setGatewayARN (clojure.core/str v7047))))
   bean7045))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListLocalDisksRequest}
list-local-disks-request
  [m7049]
  (clojure.core/let
   [bean7048
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/let
    [v7050
     (:gateway-arn m7049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7050 :com.palletops.awaze.client-builder/undef)
     (. bean7048 setGatewayARN (clojure.core/str v7050))))
   bean7048))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateVTLDeviceTypeRequest}
update-vtldevice-type-request
  [m7052]
  (clojure.core/let
   [bean7051
    (new
     com.amazonaws.services.storagegateway.model.UpdateVTLDeviceTypeRequest)]
   (clojure.core/let
    [v7053
     (:vtldevice-arn m7052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7053 :com.palletops.awaze.client-builder/undef)
     (. bean7051 setVTLDeviceARN (clojure.core/str v7053))))
   (clojure.core/let
    [v7053
     (:device-type m7052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7053 :com.palletops.awaze.client-builder/undef)
     (. bean7051 setDeviceType (clojure.core/str v7053))))
   bean7051))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest}
describe-tape-recovery-points-request
  [m7055]
  (clojure.core/let
   [bean7054
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)]
   (clojure.core/let
    [v7056 (:limit m7055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7056 :com.palletops.awaze.client-builder/undef)
     (. bean7054 setLimit (clojure.core/int v7056))))
   (clojure.core/let
    [v7056 (:marker m7055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7056 :com.palletops.awaze.client-builder/undef)
     (. bean7054 setMarker (clojure.core/str v7056))))
   (clojure.core/let
    [v7056
     (:gateway-arn m7055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7056 :com.palletops.awaze.client-builder/undef)
     (. bean7054 setGatewayARN (clojure.core/str v7056))))
   bean7054))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest}
delete-tape-archive-request
  [m7058]
  (clojure.core/let
   [bean7057
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest)]
   (clojure.core/let
    [v7059
     (:tape-arn m7058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7059 :com.palletops.awaze.client-builder/undef)
     (. bean7057 setTapeARN (clojure.core/str v7059))))
   bean7057))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest}
delete-bandwidth-rate-limit-request
  [m7061]
  (clojure.core/let
   [bean7060
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7062
     (:gateway-arn m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setGatewayARN (clojure.core/str v7062))))
   (clojure.core/let
    [v7062
     (:bandwidth-type m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setBandwidthType (clojure.core/str v7062))))
   bean7060))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DisableGatewayRequest}
disable-gateway-request
  [m7064]
  (clojure.core/let
   [bean7063
    (new
     com.amazonaws.services.storagegateway.model.DisableGatewayRequest)]
   (clojure.core/let
    [v7065
     (:gateway-arn m7064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7065 :com.palletops.awaze.client-builder/undef)
     (. bean7063 setGatewayARN (clojure.core/str v7065))))
   bean7063))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteGatewayRequest}
delete-gateway-request
  [m7067]
  (clojure.core/let
   [bean7066
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/let
    [v7068
     (:gateway-arn m7067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7068 :com.palletops.awaze.client-builder/undef)
     (. bean7066 setGatewayARN (clojure.core/str v7068))))
   bean7066))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ActivateGatewayRequest}
activate-gateway-request
  [m7070]
  (clojure.core/let
   [bean7069
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/let
    [v7071
     (:gateway-name m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setGatewayName (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:gateway-timezone
      m7070
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setGatewayTimezone (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:activation-key m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setActivationKey (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:gateway-region m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setGatewayRegion (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:gateway-type m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setGatewayType (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:tape-drive-type
      m7070
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setTapeDriveType (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:medium-changer-type
      m7070
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setMediumChangerType (clojure.core/str v7071))))
   bean7069))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest}
describe-maintenance-start-time-request
  [m7073]
  (clojure.core/let
   [bean7072
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v7074
     (:gateway-arn m7073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7074 :com.palletops.awaze.client-builder/undef)
     (. bean7072 setGatewayARN (clojure.core/str v7074))))
   bean7072))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest}
describe-bandwidth-rate-limit-request
  [m7076]
  (clojure.core/let
   [bean7075
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7077
     (:gateway-arn m7076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7077 :com.palletops.awaze.client-builder/undef)
     (. bean7075 setGatewayARN (clojure.core/str v7077))))
   bean7075))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapesRequest}
describe-tapes-request
  [m7079]
  (clojure.core/let
   [bean7078
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapesRequest)]
   (clojure.core/let
    [v7080 (:limit m7079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (. bean7078 setLimit (clojure.core/int v7080))))
   (clojure.core/let
    [v7080 (:marker m7079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (. bean7078 setMarker (clojure.core/str v7080))))
   (clojure.core/let
    [v7080
     (:gateway-arn m7079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (. bean7078 setGatewayARN (clojure.core/str v7080))))
   (clojure.core/let
    [v7080
     (:tape-arns m7079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (.
      bean7078
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7164] (clojure.core/str arg7164))
 v7080))))
   bean7078))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.StartGatewayRequest}
start-gateway-request
  [m7082]
  (clojure.core/let
   [bean7081
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/let
    [v7083
     (:gateway-arn m7082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7083 :com.palletops.awaze.client-builder/undef)
     (. bean7081 setGatewayARN (clojure.core/str v7083))))
   bean7081))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest}
update-snapshot-schedule-request
  [m7085]
  (clojure.core/let
   [bean7084
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/let
    [v7086
     (:description m7085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setDescription (clojure.core/str v7086))))
   (clojure.core/let
    [v7086
     (:volume-arn m7085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setVolumeARN (clojure.core/str v7086))))
   (clojure.core/let
    [v7086
     (:start-at m7085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setStartAt (clojure.core/int v7086))))
   (clojure.core/let
    [v7086
     (:recurrence-in-hours
      m7085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setRecurrenceInHours (clojure.core/int v7086))))
   bean7084))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest}
update-bandwidth-rate-limit-request
  [m7088]
  (clojure.core/let
   [bean7087
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7089
     (:gateway-arn m7088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setGatewayARN (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:average-upload-rate-limit-in-bits-per-sec
      m7088
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (.
      bean7087
      setAverageUploadRateLimitInBitsPerSec
      (clojure.core/long v7089))))
   (clojure.core/let
    [v7089
     (:average-download-rate-limit-in-bits-per-sec
      m7088
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (.
      bean7087
      setAverageDownloadRateLimitInBitsPerSec
      (clojure.core/long v7089))))
   bean7087))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest}
update-gateway-software-now-request
  [m7091]
  (clojure.core/let
   [bean7090
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/let
    [v7092
     (:gateway-arn m7091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7092 :com.palletops.awaze.client-builder/undef)
     (. bean7090 setGatewayARN (clojure.core/str v7092))))
   bean7090))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest}
create-storedi-scsivolume-request
  [m7094]
  (clojure.core/let
   [bean7093
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/let
    [v7095
     (:network-interface-id
      m7094
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7095 :com.palletops.awaze.client-builder/undef)
     (. bean7093 setNetworkInterfaceId (clojure.core/str v7095))))
   (clojure.core/let
    [v7095
     (:snapshot-id m7094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7095 :com.palletops.awaze.client-builder/undef)
     (. bean7093 setSnapshotId (clojure.core/str v7095))))
   (clojure.core/let
    [v7095
     (:gateway-arn m7094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7095 :com.palletops.awaze.client-builder/undef)
     (. bean7093 setGatewayARN (clojure.core/str v7095))))
   (clojure.core/let
    [v7095 (:disk-id m7094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7095 :com.palletops.awaze.client-builder/undef)
     (. bean7093 setDiskId (clojure.core/str v7095))))
   (clojure.core/let
    [v7095
     (:preserve-existing-data
      m7094
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7095 :com.palletops.awaze.client-builder/undef)
     (. bean7093 setPreserveExistingData (clojure.core/boolean v7095))))
   (clojure.core/let
    [v7095
     (:target-name m7094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7095 :com.palletops.awaze.client-builder/undef)
     (. bean7093 setTargetName (clojure.core/str v7095))))
   bean7093))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest}
update-gateway-information-request
  [m7097]
  (clojure.core/let
   [bean7096
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/let
    [v7098
     (:gateway-arn m7097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7098 :com.palletops.awaze.client-builder/undef)
     (. bean7096 setGatewayARN (clojure.core/str v7098))))
   (clojure.core/let
    [v7098
     (:gateway-name m7097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7098 :com.palletops.awaze.client-builder/undef)
     (. bean7096 setGatewayName (clojure.core/str v7098))))
   (clojure.core/let
    [v7098
     (:gateway-timezone
      m7097
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7098 :com.palletops.awaze.client-builder/undef)
     (. bean7096 setGatewayTimezone (clojure.core/str v7098))))
   bean7096))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest}
delete-snapshot-schedule-request
  [m7100]
  (clojure.core/let
   [bean7099
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/let
    [v7101
     (:volume-arn m7100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7101 :com.palletops.awaze.client-builder/undef)
     (. bean7099 setVolumeARN (clojure.core/str v7101))))
   bean7099))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCacheRequest}
describe-cache-request
  [m7103]
  (clojure.core/let
   [bean7102
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/let
    [v7104
     (:gateway-arn m7103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7104 :com.palletops.awaze.client-builder/undef)
     (. bean7102 setGatewayARN (clojure.core/str v7104))))
   bean7102))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest}
describe-chap-credentials-request
  [m7106]
  (clojure.core/let
   [bean7105
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/let
    [v7107
     (:target-arn m7106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7107 :com.palletops.awaze.client-builder/undef)
     (. bean7105 setTargetARN (clojure.core/str v7107))))
   bean7105))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest}
list-volume-recovery-points-request
  [m7109]
  (clojure.core/let
   [bean7108
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/let
    [v7110
     (:gateway-arn m7109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7110 :com.palletops.awaze.client-builder/undef)
     (. bean7108 setGatewayARN (clojure.core/str v7110))))
   bean7108))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m7112]
  (clojure.core/let
   [bean7111
    (new
     com.amazonaws.services.storagegateway.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v7113
     (:resource-arn m7112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setResourceARN (clojure.core/str v7113))))
   (clojure.core/let
    [v7113
     (:tag-keys m7112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (.
      bean7111
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7165] (clojure.core/str arg7165))
 v7113))))
   bean7111))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest}
create-tape-with-barcode-request
  [m7115]
  (clojure.core/let
   [bean7114
    (new
     com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest)]
   (clojure.core/let
    [v7116
     (:gateway-arn m7115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setGatewayARN (clojure.core/str v7116))))
   (clojure.core/let
    [v7116
     (:tape-barcode m7115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setTapeBarcode (clojure.core/str v7116))))
   (clojure.core/let
    [v7116
     (:tape-size-in-bytes
      m7115
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setTapeSizeInBytes (clojure.core/long v7116))))
   bean7114))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddCacheRequest}
add-cache-request
  [m7118]
  (clojure.core/let
   [bean7117
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/let
    [v7119
     (:gateway-arn m7118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7119 :com.palletops.awaze.client-builder/undef)
     (. bean7117 setGatewayARN (clojure.core/str v7119))))
   (clojure.core/let
    [v7119
     (:disk-ids m7118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7119 :com.palletops.awaze.client-builder/undef)
     (.
      bean7117
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7166] (clojure.core/str arg7166))
 v7119))))
   bean7117))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListGatewaysRequest}
list-gateways-request
  [m7121]
  (clojure.core/let
   [bean7120
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/let
    [v7122 (:limit m7121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7122 :com.palletops.awaze.client-builder/undef)
     (. bean7120 setLimit (clojure.core/int v7122))))
   (clojure.core/let
    [v7122 (:marker m7121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7122 :com.palletops.awaze.client-builder/undef)
     (. bean7120 setMarker (clojure.core/str v7122))))
   bean7120))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m7124]
  (clojure.core/let
   [bean7123
    (new
     com.amazonaws.services.storagegateway.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v7125 (:limit m7124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7125 :com.palletops.awaze.client-builder/undef)
     (. bean7123 setLimit (clojure.core/int v7125))))
   (clojure.core/let
    [v7125 (:marker m7124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7125 :com.palletops.awaze.client-builder/undef)
     (. bean7123 setMarker (clojure.core/str v7125))))
   (clojure.core/let
    [v7125
     (:resource-arn m7124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7125 :com.palletops.awaze.client-builder/undef)
     (. bean7123 setResourceARN (clojure.core/str v7125))))
   bean7123))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest}
retrieve-tape-recovery-point-request
  [m7127]
  (clojure.core/let
   [bean7126
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest)]
   (clojure.core/let
    [v7128
     (:gateway-arn m7127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7128 :com.palletops.awaze.client-builder/undef)
     (. bean7126 setGatewayARN (clojure.core/str v7128))))
   (clojure.core/let
    [v7128
     (:tape-arn m7127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7128 :com.palletops.awaze.client-builder/undef)
     (. bean7126 setTapeARN (clojure.core/str v7128))))
   bean7126))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest}
update-maintenance-start-time-request
  [m7130]
  (clojure.core/let
   [bean7129
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v7131
     (:day-of-week m7130 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7131 :com.palletops.awaze.client-builder/undef)
     (. bean7129 setDayOfWeek (clojure.core/int v7131))))
   (clojure.core/let
    [v7131
     (:hour-of-day m7130 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7131 :com.palletops.awaze.client-builder/undef)
     (. bean7129 setHourOfDay (clojure.core/int v7131))))
   (clojure.core/let
    [v7131
     (:minute-of-hour m7130 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7131 :com.palletops.awaze.client-builder/undef)
     (. bean7129 setMinuteOfHour (clojure.core/int v7131))))
   (clojure.core/let
    [v7131
     (:gateway-arn m7130 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7131 :com.palletops.awaze.client-builder/undef)
     (. bean7129 setGatewayARN (clojure.core/str v7131))))
   bean7129))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ResetCacheRequest}
reset-cache-request
  [m7133]
  (clojure.core/let
   [bean7132
    (new
     com.amazonaws.services.storagegateway.model.ResetCacheRequest)]
   (clojure.core/let
    [v7134
     (:gateway-arn m7133 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7134 :com.palletops.awaze.client-builder/undef)
     (. bean7132 setGatewayARN (clojure.core/str v7134))))
   bean7132))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest}
describe-vtldevices-request
  [m7136]
  (clojure.core/let
   [bean7135
    (new
     com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest)]
   (clojure.core/let
    [v7137 (:limit m7136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7137 :com.palletops.awaze.client-builder/undef)
     (. bean7135 setLimit (clojure.core/int v7137))))
   (clojure.core/let
    [v7137 (:marker m7136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7137 :com.palletops.awaze.client-builder/undef)
     (. bean7135 setMarker (clojure.core/str v7137))))
   (clojure.core/let
    [v7137
     (:gateway-arn m7136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7137 :com.palletops.awaze.client-builder/undef)
     (. bean7135 setGatewayARN (clojure.core/str v7137))))
   (clojure.core/let
    [v7137
     (:vtldevice-arns m7136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7137 :com.palletops.awaze.client-builder/undef)
     (.
      bean7135
      setVTLDeviceARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7215] (clojure.core/str arg7215))
 v7137))))
   bean7135))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest}
describe-cachedi-scsivolumes-request
  [m7139]
  (clojure.core/let
   [bean7138
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/let
    [v7140
     (:volume-arns m7139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7140 :com.palletops.awaze.client-builder/undef)
     (.
      bean7138
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7216] (clojure.core/str arg7216))
 v7140))))
   bean7138))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.SetLocalConsolePasswordRequest}
set-local-console-password-request
  [m7142]
  (clojure.core/let
   [bean7141
    (new
     com.amazonaws.services.storagegateway.model.SetLocalConsolePasswordRequest)]
   (clojure.core/let
    [v7143
     (:local-console-password
      m7142
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7143 :com.palletops.awaze.client-builder/undef)
     (. bean7141 setLocalConsolePassword (clojure.core/str v7143))))
   (clojure.core/let
    [v7143
     (:gateway-arn m7142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7143 :com.palletops.awaze.client-builder/undef)
     (. bean7141 setGatewayARN (clojure.core/str v7143))))
   bean7141))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest}
create-snapshot-from-volume-recovery-point-request
  [m7145]
  (clojure.core/let
   [bean7144
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/let
    [v7146
     (:volume-arn m7145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7146 :com.palletops.awaze.client-builder/undef)
     (. bean7144 setVolumeARN (clojure.core/str v7146))))
   (clojure.core/let
    [v7146
     (:snapshot-description
      m7145
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7146 :com.palletops.awaze.client-builder/undef)
     (. bean7144 setSnapshotDescription (clojure.core/str v7146))))
   bean7144))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotRequest}
create-snapshot-request
  [m7148]
  (clojure.core/let
   [bean7147
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v7149
     (:volume-arn m7148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7149 :com.palletops.awaze.client-builder/undef)
     (. bean7147 setVolumeARN (clojure.core/str v7149))))
   (clojure.core/let
    [v7149
     (:snapshot-description
      m7148
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7149 :com.palletops.awaze.client-builder/undef)
     (. bean7147 setSnapshotDescription (clojure.core/str v7149))))
   bean7147))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest}
describe-working-storage-request
  [m7151]
  (clojure.core/let
   [bean7150
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/let
    [v7152
     (:gateway-arn m7151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7152 :com.palletops.awaze.client-builder/undef)
     (. bean7150 setGatewayARN (clojure.core/str v7152))))
   bean7150))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeInitiatorsRequest}
list-volume-initiators-request
  [m7154]
  (clojure.core/let
   [bean7153
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeInitiatorsRequest)]
   (clojure.core/let
    [v7155
     (:volume-arn m7154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7155 :com.palletops.awaze.client-builder/undef)
     (. bean7153 setVolumeARN (clojure.core/str v7155))))
   bean7153))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest}
shutdown-gateway-request
  [m7157]
  (clojure.core/let
   [bean7156
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/let
    [v7158
     (:gateway-arn m7157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7158 :com.palletops.awaze.client-builder/undef)
     (. bean7156 setGatewayARN (clojure.core/str v7158))))
   bean7156))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m7167]
   (clojure.core/let
    [credentials7168 (:credentials m7167) args7169 (:args m7167)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7170
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7168)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7170
       updateChapCredentials
       (storagegateway/update-chap-credentials-request
        (clojure.core/nth args7169 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         secret-to-authenticate-target
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn
                         secret-to-authenticate-initiator]}]]),
    :doc "Generate map for updateChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         secret-to-authenticate-target
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn
                         secret-to-authenticate-initiator]}]]),
    :doc "Call updateChapCredentials"}
   [credentials7172 & args7173]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7174
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7172)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7174
      updateChapCredentials
      (storagegateway/update-chap-credentials-request
       (clojure.core/nth args7173 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m7175]
   (clojure.core/let
    [credentials7176 (:credentials m7175) args7177 (:args m7175)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7178
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7176)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7178
       addWorkingStorage
       (storagegateway/add-working-storage-request
        (clojure.core/nth args7177 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addWorkingStorage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-working-storage,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addWorkingStorage"}
   [credentials7180 & args7181]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7182
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7180)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7182
      addWorkingStorage
      (storagegateway/add-working-storage-request
       (clojure.core/nth args7181 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m7183]
   (clojure.core/let
    [credentials7184 (:credentials m7183) args7185 (:args m7183)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7186
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7184)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7186
       describeGatewayInformation
       (storagegateway/describe-gateway-information-request
        (clojure.core/nth args7185 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-gateway-information,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeGatewayInformation"}
   [credentials7188 & args7189]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7190
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7188)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7190
      describeGatewayInformation
      (storagegateway/describe-gateway-information-request
       (clojure.core/nth args7189 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape
   [m7191]
   (clojure.core/let
    [credentials7192 (:credentials m7191) args7193 (:args m7191)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7194
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7192)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7194
       deleteTape
       (storagegateway/delete-tape-request
        (clojure.core/nth args7193 0)))))))
  (clojure.core/defn
   delete-tape-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for deleteTape"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tape,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-tape
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call deleteTape"}
   [credentials7196 & args7197]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7198
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7196)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7198
      deleteTape
      (storagegateway/delete-tape-request
       (clojure.core/nth args7197 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m7199]
   (clojure.core/let
    [credentials7200 (:credentials m7199) args7201 (:args m7199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7202
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7200)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7202
       describeSnapshotSchedule
       (storagegateway/describe-snapshot-schedule-request
        (clojure.core/nth args7201 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotSchedule"}
   [credentials7204 & args7205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7206
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7204)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7206
      describeSnapshotSchedule
      (storagegateway/describe-snapshot-schedule-request
       (clojure.core/nth args7205 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tapes
   [m7207]
   (clojure.core/let
    [credentials7208 (:credentials m7207) args7209 (:args m7207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7210
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7208)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7210
       createTapes
       (storagegateway/create-tapes-request
        (clojure.core/nth args7209 0)))))))
  (clojure.core/defn
   create-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         num-tapes-to-create
                         tape-barcode-prefix
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createTapes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tapes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-tapes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         num-tapes-to-create
                         tape-barcode-prefix
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         client-token
                         clone-root]}]]),
    :doc "Call createTapes"}
   [credentials7212 & args7213]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7214
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7212)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7214
      createTapes
      (storagegateway/create-tapes-request
       (clojure.core/nth args7213 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m7217]
   (clojure.core/let
    [credentials7218 (:credentials m7217) args7219 (:args m7217)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7220
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7218)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7220
       deleteChapCredentials
       (storagegateway/delete-chap-credentials-request
        (clojure.core/nth args7219 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Call deleteChapCredentials"}
   [credentials7222 & args7223]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7224
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7222)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7224
      deleteChapCredentials
      (storagegateway/delete-chap-credentials-request
       (clojure.core/nth args7223 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-archival
   [m7225]
   (clojure.core/let
    [credentials7226 (:credentials m7225) args7227 (:args m7225)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7228
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7226)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7228
       cancelArchival
       (storagegateway/cancel-archival-request
        (clojure.core/nth args7227 0)))))))
  (clojure.core/defn
   cancel-archival-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for cancelArchival"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-archival,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   cancel-archival
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call cancelArchival"}
   [credentials7230 & args7231]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7232
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7230)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7232
      cancelArchival
      (storagegateway/cancel-archival-request
       (clojure.core/nth args7231 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-retrieval
   [m7233]
   (clojure.core/let
    [credentials7234 (:credentials m7233) args7235 (:args m7233)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7236
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7234)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7236
       cancelRetrieval
       (storagegateway/cancel-retrieval-request
        (clojure.core/nth args7235 0)))))))
  (clojure.core/defn
   cancel-retrieval-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for cancelRetrieval"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-retrieval,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   cancel-retrieval
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call cancelRetrieval"}
   [credentials7238 & args7239]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7240
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7238)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7240
      cancelRetrieval
      (storagegateway/cancel-retrieval-request
       (clojure.core/nth args7239 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m7241]
   (clojure.core/let
    [credentials7242 (:credentials m7241) args7243 (:args m7241)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7244
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7242)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7244
       deleteVolume
       (storagegateway/delete-volume-request
        (clojure.core/nth args7243 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials7246 & args7247]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7248
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7246)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7248
      deleteVolume
      (storagegateway/delete-volume-request
       (clojure.core/nth args7247 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m7249]
   (clojure.core/let
    [credentials7250 (:credentials m7249) args7251 (:args m7249)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7252
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7250)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7252
       describeStorediSCSIVolumes
       (storagegateway/describe-storedi-scsivolumes-request
        (clojure.core/nth args7251 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStorediSCSIVolumes"}
   [credentials7254 & args7255]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7256
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7254)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7256
      describeStorediSCSIVolumes
      (storagegateway/describe-storedi-scsivolumes-request
       (clojure.core/nth args7255 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-tags-to-resource
   [m7257]
   (clojure.core/let
    [credentials7258 (:credentials m7257) args7259 (:args m7257)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7260
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7258)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7260
       addTagsToResource
       (storagegateway/add-tags-to-resource-request
        (clojure.core/nth args7259 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials7262 & args7263]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7264
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7262)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7264
      addTagsToResource
      (storagegateway/add-tags-to-resource-request
       (clojure.core/nth args7263 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m7265]
   (clojure.core/let
    [credentials7266 (:credentials m7265) args7267 (:args m7265)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7268
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7266)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7268
       createCachediSCSIVolume
       (storagegateway/create-cachedi-scsivolume-request
        (clojure.core/nth args7267 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         volume-size-in-bytes
                         clone-source
                         gateway-arn
                         client-token
                         clone-root
                         target-name]}]]),
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cachedi-scsivolume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         volume-size-in-bytes
                         clone-source
                         gateway-arn
                         client-token
                         clone-root
                         target-name]}]]),
    :doc "Call createCachediSCSIVolume"}
   [credentials7270 & args7271]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7272
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7270)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7272
      createCachediSCSIVolume
      (storagegateway/create-cachedi-scsivolume-request
       (clojure.core/nth args7271 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-archive
   [m7273]
   (clojure.core/let
    [credentials7274 (:credentials m7273) args7275 (:args m7273)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7276
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7274)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7276
       retrieveTapeArchive
       (storagegateway/retrieve-tape-archive-request
        (clojure.core/nth args7275 0)))))))
  (clojure.core/defn
   retrieve-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for retrieveTapeArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-tape-archive,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   retrieve-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call retrieveTapeArchive"}
   [credentials7278 & args7279]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7280
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7278)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7280
      retrieveTapeArchive
      (storagegateway/retrieve-tape-archive-request
       (clojure.core/nth args7279 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m7281]
   (clojure.core/let
    [credentials7282 (:credentials m7281) args7283 (:args m7281)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7284
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7282)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7284
       addUploadBuffer
       (storagegateway/add-upload-buffer-request
        (clojure.core/nth args7283 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addUploadBuffer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-upload-buffer,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addUploadBuffer"}
   [credentials7286 & args7287]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7288
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7286)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7288
      addUploadBuffer
      (storagegateway/add-upload-buffer-request
       (clojure.core/nth args7287 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m7289]
   (clojure.core/let
    [credentials7290 (:credentials m7289) args7291 (:args m7289)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7292
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7290)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7292
       listVolumes
       (storagegateway/list-volumes-request
        (clojure.core/nth args7291 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listVolumes"}
   [credentials7294 & args7295]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7296
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7294)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7296
      listVolumes
      (storagegateway/list-volumes-request
       (clojure.core/nth args7295 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-archives
   [m7297]
   (clojure.core/let
    [credentials7298 (:credentials m7297) args7299 (:args m7297)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7300
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7298)]
     (clojure.core/case
      (clojure.core/count args7299)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7300
        describeTapeArchives
        (storagegateway/describe-tape-archives-request
         (clojure.core/nth args7299 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7300
        describeTapeArchives))))))
  (clojure.core/defn
   describe-tape-archives-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeTapeArchives, describeTapeArchives"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tape-archives,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tape-archives,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tape-archives
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeTapeArchives, describeTapeArchives"}
   [credentials7302 & args7303]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7304
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7302)]
    (clojure.core/case
     (clojure.core/count args7303)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7304
       describeTapeArchives
       (storagegateway/describe-tape-archives-request
        (clojure.core/nth args7303 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7304
       describeTapeArchives))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m7305]
   (clojure.core/let
    [credentials7306 (:credentials m7305) args7307 (:args m7305)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7308
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7306)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7308
       describeUploadBuffer
       (storagegateway/describe-upload-buffer-request
        (clojure.core/nth args7307 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-upload-buffer,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeUploadBuffer"}
   [credentials7310 & args7311]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7312
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7310)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7312
      describeUploadBuffer
      (storagegateway/describe-upload-buffer-request
       (clojure.core/nth args7311 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m7313]
   (clojure.core/let
    [credentials7314 (:credentials m7313) args7315 (:args m7313)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7316
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7314)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7316
       listLocalDisks
       (storagegateway/list-local-disks-request
        (clojure.core/nth args7315 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listLocalDisks"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-local-disks,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-local-disks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listLocalDisks"}
   [credentials7318 & args7319]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7320
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7318)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7320
      listLocalDisks
      (storagegateway/list-local-disks-request
       (clojure.core/nth args7319 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-vtldevice-type
   [m7321]
   (clojure.core/let
    [credentials7322 (:credentials m7321) args7323 (:args m7321)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7324
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7322)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7324
       updateVTLDeviceType
       (storagegateway/update-vtldevice-type-request
        (clojure.core/nth args7323 0)))))))
  (clojure.core/defn
   update-vtldevice-type-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vtldevice-arn
                         custom-query-parameters
                         device-type
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateVTLDeviceType"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-vtldevice-type,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-vtldevice-type
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vtldevice-arn
                         custom-query-parameters
                         device-type
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateVTLDeviceType"}
   [credentials7326 & args7327]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7328
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7326)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7328
      updateVTLDeviceType
      (storagegateway/update-vtldevice-type-request
       (clojure.core/nth args7327 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-recovery-points
   [m7329]
   (clojure.core/let
    [credentials7330 (:credentials m7329) args7331 (:args m7329)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7332
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7330)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7332
       describeTapeRecoveryPoints
       (storagegateway/describe-tape-recovery-points-request
        (clojure.core/nth args7331 0)))))))
  (clojure.core/defn
   describe-tape-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeTapeRecoveryPoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tape-recovery-points,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tape-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeTapeRecoveryPoints"}
   [credentials7334 & args7335]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7336
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7334)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7336
      describeTapeRecoveryPoints
      (storagegateway/describe-tape-recovery-points-request
       (clojure.core/nth args7335 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape-archive
   [m7337]
   (clojure.core/let
    [credentials7338 (:credentials m7337) args7339 (:args m7337)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7340
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7338)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7340
       deleteTapeArchive
       (storagegateway/delete-tape-archive-request
        (clojure.core/nth args7339 0)))))))
  (clojure.core/defn
   delete-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTapeArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tape-archive,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTapeArchive"}
   [credentials7342 & args7343]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7344
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7342)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7344
      deleteTapeArchive
      (storagegateway/delete-tape-archive-request
       (clojure.core/nth args7343 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m7345]
   (clojure.core/let
    [credentials7346 (:credentials m7345) args7347 (:args m7345)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7348
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7346)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7348
       deleteBandwidthRateLimit
       (storagegateway/delete-bandwidth-rate-limit-request
        (clojure.core/nth args7347 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         bandwidth-type
                         clone-root]}]]),
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         bandwidth-type
                         clone-root]}]]),
    :doc "Call deleteBandwidthRateLimit"}
   [credentials7350 & args7351]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7352
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7350)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7352
      deleteBandwidthRateLimit
      (storagegateway/delete-bandwidth-rate-limit-request
       (clojure.core/nth args7351 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :disable-gateway
   [m7353]
   (clojure.core/let
    [credentials7354 (:credentials m7353) args7355 (:args m7353)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7356
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7354)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7356
       disableGateway
       (storagegateway/disable-gateway-request
        (clojure.core/nth args7355 0)))))))
  (clojure.core/defn
   disable-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for disableGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   disable-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call disableGateway"}
   [credentials7358 & args7359]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7360
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7358)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7360
      disableGateway
      (storagegateway/disable-gateway-request
       (clojure.core/nth args7359 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m7361]
   (clojure.core/let
    [credentials7362 (:credentials m7361) args7363 (:args m7361)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7364
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7362)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7364
       deleteGateway
       (storagegateway/delete-gateway-request
        (clojure.core/nth args7363 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for deleteGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call deleteGateway"}
   [credentials7366 & args7367]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7368
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7366)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7368
      deleteGateway
      (storagegateway/delete-gateway-request
       (clojure.core/nth args7367 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m7369]
   (clojure.core/let
    [credentials7370 (:credentials m7369) args7371 (:args m7369)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7372
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7370)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7372
       activateGateway
       (storagegateway/activate-gateway-request
        (clojure.core/nth args7371 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tape-drive-type
                         gateway-name
                         sdk-request-timeout
                         gateway-type
                         custom-query-parameters
                         activation-key
                         medium-changer-type
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-region
                         gateway-timezone
                         clone-root]}]]),
    :doc "Generate map for activateGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :activate-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   activate-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tape-drive-type
                         gateway-name
                         sdk-request-timeout
                         gateway-type
                         custom-query-parameters
                         activation-key
                         medium-changer-type
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-region
                         gateway-timezone
                         clone-root]}]]),
    :doc "Call activateGateway"}
   [credentials7374 & args7375]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7376
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7374)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7376
      activateGateway
      (storagegateway/activate-gateway-request
       (clojure.core/nth args7375 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m7377]
   (clojure.core/let
    [credentials7378 (:credentials m7377) args7379 (:args m7377)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7380
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7378)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7380
       describeMaintenanceStartTime
       (storagegateway/describe-maintenance-start-time-request
        (clojure.core/nth args7379 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-maintenance-start-time,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeMaintenanceStartTime"}
   [credentials7382 & args7383]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7384
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7382)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7384
      describeMaintenanceStartTime
      (storagegateway/describe-maintenance-start-time-request
       (clojure.core/nth args7383 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m7385]
   (clojure.core/let
    [credentials7386 (:credentials m7385) args7387 (:args m7385)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7388
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7386)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7388
       describeBandwidthRateLimit
       (storagegateway/describe-bandwidth-rate-limit-request
        (clojure.core/nth args7387 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeBandwidthRateLimit"}
   [credentials7390 & args7391]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7392
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7390)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7392
      describeBandwidthRateLimit
      (storagegateway/describe-bandwidth-rate-limit-request
       (clojure.core/nth args7391 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tapes
   [m7393]
   (clojure.core/let
    [credentials7394 (:credentials m7393) args7395 (:args m7393)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7396
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7394)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7396
       describeTapes
       (storagegateway/describe-tapes-request
        (clojure.core/nth args7395 0)))))))
  (clojure.core/defn
   describe-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeTapes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tapes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tapes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeTapes"}
   [credentials7398 & args7399]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7400
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7398)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7400
      describeTapes
      (storagegateway/describe-tapes-request
       (clojure.core/nth args7399 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m7401]
   (clojure.core/let
    [credentials7402 (:credentials m7401) args7403 (:args m7401)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7404
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7402)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7404
       startGateway
       (storagegateway/start-gateway-request
        (clojure.core/nth args7403 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for startGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :start-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   start-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call startGateway"}
   [credentials7406 & args7407]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7408
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7406)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7408
      startGateway
      (storagegateway/start-gateway-request
       (clojure.core/nth args7407 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m7409]
   (clojure.core/let
    [credentials7410 (:credentials m7409) args7411 (:args m7409)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7412
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7410)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7412
       updateSnapshotSchedule
       (storagegateway/update-snapshot-schedule-request
        (clojure.core/nth args7411 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-at
                         volume-arn
                         custom-query-parameters
                         recurrence-in-hours
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-at
                         volume-arn
                         custom-query-parameters
                         recurrence-in-hours
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSnapshotSchedule"}
   [credentials7414 & args7415]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7416
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7414)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7416
      updateSnapshotSchedule
      (storagegateway/update-snapshot-schedule-request
       (clojure.core/nth args7415 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m7417]
   (clojure.core/let
    [credentials7418 (:credentials m7417) args7419 (:args m7417)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7420
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7418)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7420
       updateBandwidthRateLimit
       (storagegateway/update-bandwidth-rate-limit-request
        (clojure.core/nth args7419 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         average-download-rate-limit-in-bits-per-sec
                         sdk-request-timeout
                         custom-query-parameters
                         average-upload-rate-limit-in-bits-per-sec
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         average-download-rate-limit-in-bits-per-sec
                         sdk-request-timeout
                         custom-query-parameters
                         average-upload-rate-limit-in-bits-per-sec
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call updateBandwidthRateLimit"}
   [credentials7422 & args7423]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7424
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7422)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7424
      updateBandwidthRateLimit
      (storagegateway/update-bandwidth-rate-limit-request
       (clojure.core/nth args7423 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m7425]
   (clojure.core/let
    [credentials7426 (:credentials m7425) args7427 (:args m7425)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7428
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7426)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7428
       updateGatewaySoftwareNow
       (storagegateway/update-gateway-software-now-request
        (clojure.core/nth args7427 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-gateway-software-now,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call updateGatewaySoftwareNow"}
   [credentials7430 & args7431]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7432
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7430)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7432
      updateGatewaySoftwareNow
      (storagegateway/update-gateway-software-now-request
       (clojure.core/nth args7431 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m7433]
   (clojure.core/let
    [credentials7434 (:credentials m7433) args7435 (:args m7433)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7436
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7434)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7436
       createStorediSCSIVolume
       (storagegateway/create-storedi-scsivolume-request
        (clojure.core/nth args7435 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         preserve-existing-data
                         general-progress-listener
                         disk-id
                         clone-source
                         gateway-arn
                         clone-root
                         target-name]}]]),
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-storedi-scsivolume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         preserve-existing-data
                         general-progress-listener
                         disk-id
                         clone-source
                         gateway-arn
                         clone-root
                         target-name]}]]),
    :doc "Call createStorediSCSIVolume"}
   [credentials7438 & args7439]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7440
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7438)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7440
      createStorediSCSIVolume
      (storagegateway/create-storedi-scsivolume-request
       (clojure.core/nth args7439 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m7441]
   (clojure.core/let
    [credentials7442 (:credentials m7441) args7443 (:args m7441)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7444
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7442)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7444
       updateGatewayInformation
       (storagegateway/update-gateway-information-request
        (clojure.core/nth args7443 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         gateway-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         gateway-timezone
                         clone-root]}]]),
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-gateway-information,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         gateway-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         gateway-timezone
                         clone-root]}]]),
    :doc "Call updateGatewayInformation"}
   [credentials7446 & args7447]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7448
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7446)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7448
      updateGatewayInformation
      (storagegateway/update-gateway-information-request
       (clojure.core/nth args7447 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m7449]
   (clojure.core/let
    [credentials7450 (:credentials m7449) args7451 (:args m7449)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7452
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7450)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7452
       deleteSnapshotSchedule
       (storagegateway/delete-snapshot-schedule-request
        (clojure.core/nth args7451 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshotSchedule"}
   [credentials7454 & args7455]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7456
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7454)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7456
      deleteSnapshotSchedule
      (storagegateway/delete-snapshot-schedule-request
       (clojure.core/nth args7455 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m7457]
   (clojure.core/let
    [credentials7458 (:credentials m7457) args7459 (:args m7457)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7460
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7458)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7460
       describeCache
       (storagegateway/describe-cache-request
        (clojure.core/nth args7459 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeCache"}
   [credentials7462 & args7463]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7464
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7462)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7464
      describeCache
      (storagegateway/describe-cache-request
       (clojure.core/nth args7463 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m7465]
   (clojure.core/let
    [credentials7466 (:credentials m7465) args7467 (:args m7465)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7468
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7466)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7468
       describeChapCredentials
       (storagegateway/describe-chap-credentials-request
        (clojure.core/nth args7467 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Generate map for describeChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Call describeChapCredentials"}
   [credentials7470 & args7471]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7472
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7470)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7472
      describeChapCredentials
      (storagegateway/describe-chap-credentials-request
       (clojure.core/nth args7471 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m7473]
   (clojure.core/let
    [credentials7474 (:credentials m7473) args7475 (:args m7473)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7476
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7474)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7476
       listVolumeRecoveryPoints
       (storagegateway/list-volume-recovery-points-request
        (clojure.core/nth args7475 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volume-recovery-points,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listVolumeRecoveryPoints"}
   [credentials7478 & args7479]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7480
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7478)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7480
      listVolumeRecoveryPoints
      (storagegateway/list-volume-recovery-points-request
       (clojure.core/nth args7479 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :remove-tags-from-resource
   [m7481]
   (clojure.core/let
    [credentials7482 (:credentials m7481) args7483 (:args m7481)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7484
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7482)]
     (clojure.core/case
      (clojure.core/count args7483)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7484
        removeTagsFromResource))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7484
        removeTagsFromResource
        (storagegateway/remove-tags-from-resource-request
         (clojure.core/nth args7483 0))))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromResource, removeTagsFromResource"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromResource, removeTagsFromResource"}
   [credentials7486 & args7487]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7488
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7486)]
    (clojure.core/case
     (clojure.core/count args7487)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7488
       removeTagsFromResource))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7488
       removeTagsFromResource
       (storagegateway/remove-tags-from-resource-request
        (clojure.core/nth args7487 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tape-with-barcode
   [m7489]
   (clojure.core/let
    [credentials7490 (:credentials m7489) args7491 (:args m7489)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7492
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7490)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7492
       createTapeWithBarcode
       (storagegateway/create-tape-with-barcode-request
        (clojure.core/nth args7491 0)))))))
  (clojure.core/defn
   create-tape-with-barcode-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tape-barcode
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for createTapeWithBarcode"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tape-with-barcode,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-tape-with-barcode
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tape-barcode
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         clone-root]}]]),
    :doc "Call createTapeWithBarcode"}
   [credentials7494 & args7495]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7496
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7494)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7496
      createTapeWithBarcode
      (storagegateway/create-tape-with-barcode-request
       (clojure.core/nth args7495 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m7497]
   (clojure.core/let
    [credentials7498 (:credentials m7497) args7499 (:args m7497)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7500
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7498)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7500
       addCache
       (storagegateway/add-cache-request
        (clojure.core/nth args7499 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addCache"}
   [credentials7502 & args7503]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7504
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7502)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7504
      addCache
      (storagegateway/add-cache-request (clojure.core/nth args7503 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m7505]
   (clojure.core/let
    [credentials7506 (:credentials m7505) args7507 (:args m7505)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7508
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7506)]
     (clojure.core/case
      (clojure.core/count args7507)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7508
        listGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7508
        listGateways
        (storagegateway/list-gateways-request
         (clojure.core/nth args7507 0))))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-gateways,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-gateways,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGateways, listGateways"}
   [credentials7510 & args7511]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7512
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7510)]
    (clojure.core/case
     (clojure.core/count args7511)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7512
       listGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7512
       listGateways
       (storagegateway/list-gateways-request
        (clojure.core/nth args7511 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-tags-for-resource
   [m7513]
   (clojure.core/let
    [credentials7514 (:credentials m7513) args7515 (:args m7513)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7516
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7514)]
     (clojure.core/case
      (clojure.core/count args7515)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7516
        listTagsForResource))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7516
        listTagsForResource
        (storagegateway/list-tags-for-resource-request
         (clojure.core/nth args7515 0))))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource, listTagsForResource"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource, listTagsForResource"}
   [credentials7518 & args7519]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7520
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7518)]
    (clojure.core/case
     (clojure.core/count args7519)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7520
       listTagsForResource))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7520
       listTagsForResource
       (storagegateway/list-tags-for-resource-request
        (clojure.core/nth args7519 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-recovery-point
   [m7521]
   (clojure.core/let
    [credentials7522 (:credentials m7521) args7523 (:args m7521)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7524
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7522)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7524
       retrieveTapeRecoveryPoint
       (storagegateway/retrieve-tape-recovery-point-request
        (clojure.core/nth args7523 0)))))))
  (clojure.core/defn
   retrieve-tape-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for retrieveTapeRecoveryPoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-tape-recovery-point,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   retrieve-tape-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call retrieveTapeRecoveryPoint"}
   [credentials7526 & args7527]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7528
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7526)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7528
      retrieveTapeRecoveryPoint
      (storagegateway/retrieve-tape-recovery-point-request
       (clojure.core/nth args7527 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m7529]
   (clojure.core/let
    [credentials7530 (:credentials m7529) args7531 (:args m7529)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7532
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7530)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7532
       updateMaintenanceStartTime
       (storagegateway/update-maintenance-start-time-request
        (clojure.core/nth args7531 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         day-of-week
                         hour-of-day
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root
                         minute-of-hour]}]]),
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-maintenance-start-time,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         day-of-week
                         hour-of-day
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root
                         minute-of-hour]}]]),
    :doc "Call updateMaintenanceStartTime"}
   [credentials7534 & args7535]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7536
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7534)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7536
      updateMaintenanceStartTime
      (storagegateway/update-maintenance-start-time-request
       (clojure.core/nth args7535 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :reset-cache
   [m7537]
   (clojure.core/let
    [credentials7538 (:credentials m7537) args7539 (:args m7537)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7540
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7538)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7540
       resetCache
       (storagegateway/reset-cache-request
        (clojure.core/nth args7539 0)))))))
  (clojure.core/defn
   reset-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for resetCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   reset-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call resetCache"}
   [credentials7542 & args7543]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7544
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7542)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7544
      resetCache
      (storagegateway/reset-cache-request
       (clojure.core/nth args7543 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-vtldevices
   [m7545]
   (clojure.core/let
    [credentials7546 (:credentials m7545) args7547 (:args m7545)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7548
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7546)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7548
       describeVTLDevices
       (storagegateway/describe-vtldevices-request
        (clojure.core/nth args7547 0)))))))
  (clojure.core/defn
   describe-vtldevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         vtldevice-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeVTLDevices"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vtldevices,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-vtldevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         vtldevice-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeVTLDevices"}
   [credentials7550 & args7551]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7552
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7550)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7552
      describeVTLDevices
      (storagegateway/describe-vtldevices-request
       (clojure.core/nth args7551 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m7553]
   (clojure.core/let
    [credentials7554 (:credentials m7553) args7555 (:args m7553)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7556
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7554)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7556
       describeCachediSCSIVolumes
       (storagegateway/describe-cachedi-scsivolumes-request
        (clojure.core/nth args7555 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCachediSCSIVolumes"}
   [credentials7558 & args7559]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7560
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7558)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7560
      describeCachediSCSIVolumes
      (storagegateway/describe-cachedi-scsivolumes-request
       (clojure.core/nth args7559 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :set-local-console-password
   [m7561]
   (clojure.core/let
    [credentials7562 (:credentials m7561) args7563 (:args m7561)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7564
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7562)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7564
       setLocalConsolePassword
       (storagegateway/set-local-console-password-request
        (clojure.core/nth args7563 0)))))))
  (clojure.core/defn
   set-local-console-password-map
   {:arglists (quote
               [[credentials
                 {:keys [local-console-password
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for setLocalConsolePassword"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-local-console-password,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   set-local-console-password
   {:arglists (quote
               [[credentials
                 {:keys [local-console-password
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call setLocalConsolePassword"}
   [credentials7566 & args7567]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7568
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7566)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7568
      setLocalConsolePassword
      (storagegateway/set-local-console-password-request
       (clojure.core/nth args7567 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m7569]
   (clojure.core/let
    [credentials7570 (:credentials m7569) args7571 (:args m7569)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7572
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7570)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7572
       createSnapshotFromVolumeRecoveryPoint
       (storagegateway/create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args7571 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials7574 & args7575]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7576
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7574)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7576
      createSnapshotFromVolumeRecoveryPoint
      (storagegateway/create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args7575 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m7577]
   (clojure.core/let
    [credentials7578 (:credentials m7577) args7579 (:args m7577)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7580
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7578)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7580
       createSnapshot
       (storagegateway/create-snapshot-request
        (clojure.core/nth args7579 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials7582 & args7583]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7584
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7582)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7584
      createSnapshot
      (storagegateway/create-snapshot-request
       (clojure.core/nth args7583 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m7585]
   (clojure.core/let
    [credentials7586 (:credentials m7585) args7587 (:args m7585)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7588
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7586)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7588
       describeWorkingStorage
       (storagegateway/describe-working-storage-request
        (clojure.core/nth args7587 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-working-storage,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeWorkingStorage"}
   [credentials7590 & args7591]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7592
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7590)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7592
      describeWorkingStorage
      (storagegateway/describe-working-storage-request
       (clojure.core/nth args7591 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-initiators
   [m7593]
   (clojure.core/let
    [credentials7594 (:credentials m7593) args7595 (:args m7593)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7596
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7594)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7596
       listVolumeInitiators
       (storagegateway/list-volume-initiators-request
        (clojure.core/nth args7595 0)))))))
  (clojure.core/defn
   list-volume-initiators-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVolumeInitiators"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volume-initiators,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volume-initiators
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVolumeInitiators"}
   [credentials7598 & args7599]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7600
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7598)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7600
      listVolumeInitiators
      (storagegateway/list-volume-initiators-request
       (clojure.core/nth args7599 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m7601]
   (clojure.core/let
    [credentials7602 (:credentials m7601) args7603 (:args m7601)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7604
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7602)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7604
       shutdownGateway
       (storagegateway/shutdown-gateway-request
        (clojure.core/nth args7603 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for shutdownGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :shutdown-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call shutdownGateway"}
   [credentials7606 & args7607]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7608
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7606)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7608
      shutdownGateway
      (storagegateway/shutdown-gateway-request
       (clojure.core/nth args7607 0))))))))
