(ns
 com.palletops.awaze.securitytoken
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleRequest}
assume-role-request
  [m8429]
  (clojure.core/let
   [bean8428
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/let
    [v8430 (:policy m8429 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8430 :com.palletops.awaze.client-builder/undef)
     (. bean8428 setPolicy (clojure.core/str v8430))))
   (clojure.core/let
    [v8430
     (:role-arn m8429 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8430 :com.palletops.awaze.client-builder/undef)
     (. bean8428 setRoleArn (clojure.core/str v8430))))
   (clojure.core/let
    [v8430
     (:role-session-name
      m8429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8430 :com.palletops.awaze.client-builder/undef)
     (. bean8428 setRoleSessionName (clojure.core/str v8430))))
   (clojure.core/let
    [v8430
     (:duration-seconds
      m8429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8430 :com.palletops.awaze.client-builder/undef)
     (. bean8428 setDurationSeconds (clojure.core/int v8430))))
   (clojure.core/let
    [v8430
     (:external-id m8429 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8430 :com.palletops.awaze.client-builder/undef)
     (. bean8428 setExternalId (clojure.core/str v8430))))
   (clojure.core/let
    [v8430
     (:serial-number m8429 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8430 :com.palletops.awaze.client-builder/undef)
     (. bean8428 setSerialNumber (clojure.core/str v8430))))
   (clojure.core/let
    [v8430
     (:token-code m8429 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8430 :com.palletops.awaze.client-builder/undef)
     (. bean8428 setTokenCode (clojure.core/str v8430))))
   bean8428))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest}
assume-role-with-samlrequest
  [m8432]
  (clojure.core/let
   [bean8431
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest)]
   (clojure.core/let
    [v8433 (:policy m8432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8433 :com.palletops.awaze.client-builder/undef)
     (. bean8431 setPolicy (clojure.core/str v8433))))
   (clojure.core/let
    [v8433
     (:principal-arn m8432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8433 :com.palletops.awaze.client-builder/undef)
     (. bean8431 setPrincipalArn (clojure.core/str v8433))))
   (clojure.core/let
    [v8433
     (:samlassertion m8432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8433 :com.palletops.awaze.client-builder/undef)
     (. bean8431 setSAMLAssertion (clojure.core/str v8433))))
   (clojure.core/let
    [v8433
     (:role-arn m8432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8433 :com.palletops.awaze.client-builder/undef)
     (. bean8431 setRoleArn (clojure.core/str v8433))))
   (clojure.core/let
    [v8433
     (:duration-seconds
      m8432
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8433 :com.palletops.awaze.client-builder/undef)
     (. bean8431 setDurationSeconds (clojure.core/int v8433))))
   bean8431))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest}
assume-role-with-web-identity-request
  [m8435]
  (clojure.core/let
   [bean8434
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/let
    [v8436 (:policy m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setPolicy (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:web-identity-token
      m8435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setWebIdentityToken (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:provider-id m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setProviderId (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:role-arn m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setRoleArn (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:role-session-name
      m8435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setRoleSessionName (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:duration-seconds
      m8435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setDurationSeconds (clojure.core/int v8436))))
   bean8434))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest}
decode-authorization-message-request
  [m8438]
  (clojure.core/let
   [bean8437
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/let
    [v8439
     (:encoded-message
      m8438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8439 :com.palletops.awaze.client-builder/undef)
     (. bean8437 setEncodedMessage (clojure.core/str v8439))))
   bean8437))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetFederationTokenRequest}
get-federation-token-request
  [m8441]
  (clojure.core/let
   [bean8440
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/let
    [v8442 (:policy m8441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setPolicy (clojure.core/str v8442))))
   (clojure.core/let
    [v8442
     (:duration-seconds
      m8441
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setDurationSeconds (clojure.core/int v8442))))
   (clojure.core/let
    [v8442 (:name m8441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setName (clojure.core/str v8442))))
   bean8440))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetSessionTokenRequest}
get-session-token-request
  [m8444]
  (clojure.core/let
   [bean8443
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/let
    [v8445
     (:duration-seconds
      m8444
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8445 :com.palletops.awaze.client-builder/undef)
     (. bean8443 setDurationSeconds (clojure.core/int v8445))))
   (clojure.core/let
    [v8445
     (:serial-number m8444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8445 :com.palletops.awaze.client-builder/undef)
     (. bean8443 setSerialNumber (clojure.core/str v8445))))
   (clojure.core/let
    [v8445
     (:token-code m8444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8445 :com.palletops.awaze.client-builder/undef)
     (. bean8443 setTokenCode (clojure.core/str v8445))))
   bean8443))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m8446]
   (clojure.core/let
    [credentials8447 (:credentials m8446) args8448 (:args m8446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8449
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8449
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args8448 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRole"}
   [credentials8451 & args8452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8453
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8453
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args8452 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-saml
   [m8454]
   (clojure.core/let
    [credentials8455 (:credentials m8454) args8456 (:args m8454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8457
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8455)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8457
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args8456 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-saml,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials8459 & args8460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8461
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8459)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8461
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args8460 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m8462]
   (clojure.core/let
    [credentials8463 (:credentials m8462) args8464 (:args m8462)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8465
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8463)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8465
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args8464 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-web-identity,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials8467 & args8468]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8469
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8467)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8469
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args8468 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m8470]
   (clojure.core/let
    [credentials8471 (:credentials m8470) args8472 (:args m8470)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8473
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8471)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8473
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args8472 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :decode-authorization-message,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials8475 & args8476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8477
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8475)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8477
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args8476 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m8478]
   (clojure.core/let
    [credentials8479 (:credentials m8478) args8480 (:args m8478)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8481
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8479)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8481
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args8480 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-federation-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getFederationToken"}
   [credentials8483 & args8484]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8485
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8483)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8485
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args8484 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m8486]
   (clojure.core/let
    [credentials8487 (:credentials m8486) args8488 (:args m8486)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8489
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8487)]
     (clojure.core/case
      (clojure.core/count args8488)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8489
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args8488 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8489
        getSessionToken))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials8491 & args8492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8493
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8491)]
    (clojure.core/case
     (clojure.core/count args8492)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8493
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args8492 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8493
       getSessionToken)))))))
