(ns
 com.palletops.awaze.s3
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.s3 :as s3]
  [com.palletops.awaze.beans.root :as root]
  [com.palletops.awaze.beans.metrics :as metrics]
  [com.palletops.awaze.beans.regions :as regions]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.StorageClass}
storage-class
  [m13215]
  (.
   com.amazonaws.services.s3.model.StorageClass
   fromValue
   (clojure.core/name m13215)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule$AllowedMethods}
corsrule-allowed-methods
  [m13218]
  (.
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   fromValue
   (clojure.core/name m13218)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition}
bucket-lifecycle-configuration-noncurrent-version-transition
  [m13221]
  (clojure.core/let
   [bean13220
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition)]
   (clojure.core/let
    [v13222
     (:storage-class m13221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13222 :com.palletops.awaze.client-builder/undef)
     (. bean13220 setStorageClass (s3/storage-class v13222))))
   (clojure.core/let
    [v13222 (:days m13221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13222 :com.palletops.awaze.client-builder/undef)
     (. bean13220 setDays (clojure.core/int v13222))))
   bean13220))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition}
bucket-lifecycle-configuration-transition
  [m13224]
  (clojure.core/let
   [bean13223
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/let
    [v13225 (:date m13224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13225 :com.palletops.awaze.client-builder/undef)
     (. bean13223 setDate (com.palletops.awaze.common/to-date v13225))))
   (clojure.core/let
    [v13225
     (:storage-class m13224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13225 :com.palletops.awaze.client-builder/undef)
     (. bean13223 setStorageClass (s3/storage-class v13225))))
   (clojure.core/let
    [v13225 (:days m13224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13225 :com.palletops.awaze.client-builder/undef)
     (. bean13223 setDays (clojure.core/int v13225))))
   bean13223))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload}
abort-incomplete-multipart-upload
  [m13227]
  (clojure.core/let
   [bean13226
    (new
     com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload)]
   (clojure.core/let
    [v13228
     (:days-after-initiation
      m13227
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13228 :com.palletops.awaze.client-builder/undef)
     (. bean13226 setDaysAfterInitiation (clojure.core/int v13228))))
   bean13226))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Owner}
owner
  [m13230]
  (clojure.core/let
   [bean13229 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/let
    [v13231
     (:display-name m13230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13231 :com.palletops.awaze.client-builder/undef)
     (. bean13229 setDisplayName (clojure.core/str v13231))))
   (clojure.core/let
    [v13231 (:id m13230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13231 :com.palletops.awaze.client-builder/undef)
     (. bean13229 setId (clojure.core/str v13231))))
   bean13229))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationDestinationConfig}
replication-destination-config
  [m13233]
  (clojure.core/let
   [bean13232
    (new com.amazonaws.services.s3.model.ReplicationDestinationConfig)]
   (clojure.core/let
    [v13234
     (:storage-class m13233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13234 :com.palletops.awaze.client-builder/undef)
     (. bean13232 setStorageClass (clojure.core/str v13234))))
   (clojure.core/let
    [v13234
     (:bucket-arn m13233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13234 :com.palletops.awaze.client-builder/undef)
     (. bean13232 setBucketARN (clojure.core/str v13234))))
   bean13232))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RedirectRule}
redirect-rule
  [m13236]
  (clojure.core/let
   [bean13235 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/let
    [v13237
     (:host-name m13236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setHostName (clojure.core/str v13237))))
   (clojure.core/let
    [v13237
     (:replace-key-prefix-with
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setReplaceKeyPrefixWith (clojure.core/str v13237))))
   (clojure.core/let
    [v13237
     (:replace-key-with
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setReplaceKeyWith (clojure.core/str v13237))))
   (clojure.core/let
    [v13237
     (:http-redirect-code
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setHttpRedirectCode (clojure.core/str v13237))))
   (clojure.core/let
    [v13237
     (:protocol m13236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setProtocol (clojure.core/str v13237))))
   bean13235))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRuleCondition}
routing-rule-condition
  [m13239]
  (clojure.core/let
   [bean13238
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/let
    [v13240
     (:key-prefix-equals
      m13239
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13240 :com.palletops.awaze.client-builder/undef)
     (. bean13238 setKeyPrefixEquals (clojure.core/str v13240))))
   (clojure.core/let
    [v13240
     (:http-error-code-returned-equals
      m13239
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13240 :com.palletops.awaze.client-builder/undef)
     (.
      bean13238
      setHttpErrorCodeReturnedEquals
      (clojure.core/str v13240))))
   bean13238))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule}
corsrule
  [m13242]
  (clojure.core/let
   [bean13241 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/let
    [v13243
     (:allowed-methods
      m13242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (.
      bean13241
      setAllowedMethods
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13578] (s3/corsrule-allowed-methods arg13578))
 v13243))))
   (clojure.core/let
    [v13243
     (:allowed-origins
      m13242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (.
      bean13241
      setAllowedOrigins
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13579] (clojure.core/str arg13579))
 v13243))))
   (clojure.core/let
    [v13243
     (:max-age-seconds
      m13242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (. bean13241 setMaxAgeSeconds (clojure.core/int v13243))))
   (clojure.core/let
    [v13243
     (:exposed-headers
      m13242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (.
      bean13241
      setExposedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13580] (clojure.core/str arg13580))
 v13243))))
   (clojure.core/let
    [v13243
     (:allowed-headers
      m13242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (.
      bean13241
      setAllowedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13581] (clojure.core/str arg13581))
 v13243))))
   (clojure.core/let
    [v13243 (:id m13242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (. bean13241 setId (clojure.core/str v13243))))
   bean13241))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule}
bucket-lifecycle-configuration-rule
  [m13245]
  (clojure.core/let
   [bean13244
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/let
    [v13246
     (:prefix m13245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (. bean13244 setPrefix (clojure.core/str v13246))))
   (clojure.core/let
    [v13246
     (:noncurrent-version-transition
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (.
      bean13244
      setNoncurrentVersionTransition
      (s3/bucket-lifecycle-configuration-noncurrent-version-transition
       v13246))))
   (clojure.core/let
    [v13246
     (:transitions m13245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (.
      bean13244
      setTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13582]
  (s3/bucket-lifecycle-configuration-transition arg13582))
 v13246))))
   (clojure.core/let
    [v13246
     (:abort-incomplete-multipart-upload
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (.
      bean13244
      setAbortIncompleteMultipartUpload
      (s3/abort-incomplete-multipart-upload v13246))))
   (clojure.core/let
    [v13246 (:id m13245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (. bean13244 setId (clojure.core/str v13246))))
   (clojure.core/let
    [v13246
     (:noncurrent-version-expiration-in-days
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (.
      bean13244
      setNoncurrentVersionExpirationInDays
      (clojure.core/int v13246))))
   (clojure.core/let
    [v13246
     (:expiration-in-days
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (. bean13244 setExpirationInDays (clojure.core/int v13246))))
   (clojure.core/let
    [v13246
     (:noncurrent-version-transitions
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (.
      bean13244
      setNoncurrentVersionTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13583]
  (s3/bucket-lifecycle-configuration-noncurrent-version-transition
   arg13583))
 v13246))))
   (clojure.core/let
    [v13246
     (:expiration-date
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (.
      bean13244
      setExpirationDate
      (com.palletops.awaze.common/to-date v13246))))
   (clojure.core/let
    [v13246
     (:expired-object-delete-marker
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (.
      bean13244
      setExpiredObjectDeleteMarker
      (clojure.core/boolean v13246))))
   (clojure.core/let
    [v13246
     (:transition m13245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (.
      bean13244
      setTransition
      (s3/bucket-lifecycle-configuration-transition v13246))))
   (clojure.core/let
    [v13246
     (:status m13245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (. bean13244 setStatus (clojure.core/str v13246))))
   bean13244))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration}
bucket-notification-configuration-topic-configuration
  [m13248]
  (clojure.core/let
   [arg13250
    nil
    arg13251
    nil
    bean13247
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg13250
     arg13251)]
   bean13247))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3VersionSummary}
s3version-summary
  [m13253]
  (clojure.core/let
   [bean13252 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/let
    [v13254
     (:bucket-name m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setBucketName (clojure.core/str v13254))))
   (clojure.core/let
    [v13254 (:owner m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setOwner (s3/owner v13254))))
   (clojure.core/let
    [v13254
     (:storage-class m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setStorageClass (clojure.core/str v13254))))
   (clojure.core/let
    [v13254
     (:is-latest m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setIsLatest (clojure.core/boolean v13254))))
   (clojure.core/let
    [v13254
     (:last-modified m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (.
      bean13252
      setLastModified
      (com.palletops.awaze.common/to-date v13254))))
   (clojure.core/let
    [v13254 (:key m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setKey (clojure.core/str v13254))))
   (clojure.core/let
    [v13254 (:etag m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setETag (clojure.core/str v13254))))
   (clojure.core/let
    [v13254 (:size m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setSize (clojure.core/long v13254))))
   (clojure.core/let
    [v13254
     (:version-id m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setVersionId (clojure.core/str v13254))))
   (clojure.core/let
    [v13254
     (:is-delete-marker
      m13253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setIsDeleteMarker (clojure.core/boolean v13254))))
   bean13252))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationRule}
replication-rule
  [m13256]
  (clojure.core/let
   [bean13255 (new com.amazonaws.services.s3.model.ReplicationRule)]
   (clojure.core/let
    [v13257
     (:destination-config
      m13256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13257 :com.palletops.awaze.client-builder/undef)
     (.
      bean13255
      setDestinationConfig
      (s3/replication-destination-config v13257))))
   (clojure.core/let
    [v13257
     (:status m13256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13257 :com.palletops.awaze.client-builder/undef)
     (. bean13255 setStatus (clojure.core/str v13257))))
   (clojure.core/let
    [v13257
     (:prefix m13256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13257 :com.palletops.awaze.client-builder/undef)
     (. bean13255 setPrefix (clojure.core/str v13257))))
   bean13255))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.TagSet}
tag-set
  [m13259]
  (clojure.core/let
   [bean13258 (new com.amazonaws.services.s3.model.TagSet)]
   bean13258))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRule}
routing-rule
  [m13262]
  (clojure.core/let
   [bean13261 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/let
    [v13263
     (:redirect m13262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13263 :com.palletops.awaze.client-builder/undef)
     (. bean13261 setRedirect (s3/redirect-rule v13263))))
   (clojure.core/let
    [v13263
     (:condition m13262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13263 :com.palletops.awaze.client-builder/undef)
     (. bean13261 setCondition (s3/routing-rule-condition v13263))))
   bean13261))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSECustomerKey}
ssecustomer-key
  [m13265]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13267
    nil
    bean13264
    (new
     com.amazonaws.services.s3.model.SSECustomerKey
^{:tag java.lang.String}
arg13267)]
   (clojure.core/let
    [v13266 (:md5 m13265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13266 :com.palletops.awaze.client-builder/undef)
     (. bean13264 setMd5 (clojure.core/str v13266))))
   (clojure.core/let
    [v13266
     (:algorithm m13265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13266 :com.palletops.awaze.client-builder/undef)
     (. bean13264 setAlgorithm (clojure.core/str v13266))))
   bean13264))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketCrossOriginConfiguration}
bucket-cross-origin-configuration
  [m13269]
  (clojure.core/let
   [bean13268
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/let
    [v13270 (:rules m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (.
      bean13268
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13584] (s3/corsrule arg13584))
 v13270))))
   bean13268))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration}
bucket-lifecycle-configuration
  [m13272]
  (clojure.core/let
   [bean13271
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/let
    [v13273 (:rules m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (.
      bean13271
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13585]
  (s3/bucket-lifecycle-configuration-rule arg13585))
 v13273))))
   bean13271))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
bucket-notification-configuration
  [m13275]
  (clojure.core/let
   [bean13274
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/let
    [v13276
     (:topic-configurations
      m13275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (.
      bean13274
      setTopicConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg13586]
  (s3/bucket-notification-configuration-topic-configuration arg13586))
 v13276))))
   (clojure.core/let
    [v13276
     (:configurations
      m13275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (.
      bean13274
      setConfigurations
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13587] (clojure.core/str arg13587))
  (clojure.core/keys v13276))
 (clojure.core/map
  (clojure.core/fn [arg13587] arg13587)
  (clojure.core/vals v13276))))))
   bean13274))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.VersionListing}
version-listing
  [m13278]
  (clojure.core/let
   [bean13277 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/let
    [v13279
     (:prefix m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setPrefix (clojure.core/str v13279))))
   (clojure.core/let
    [v13279
     (:next-version-id-marker
      m13278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setNextVersionIdMarker (clojure.core/str v13279))))
   (clojure.core/let
    [v13279
     (:version-summaries
      m13278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (.
      bean13277
      setVersionSummaries
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13588] (s3/s3version-summary arg13588))
 v13279))))
   (clojure.core/let
    [v13279
     (:bucket-name m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setBucketName (clojure.core/str v13279))))
   (clojure.core/let
    [v13279
     (:encoding-type m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setEncodingType (clojure.core/str v13279))))
   (clojure.core/let
    [v13279
     (:next-key-marker
      m13278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setNextKeyMarker (clojure.core/str v13279))))
   (clojure.core/let
    [v13279
     (:max-keys m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setMaxKeys (clojure.core/int v13279))))
   (clojure.core/let
    [v13279
     (:truncated m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setTruncated (clojure.core/boolean v13279))))
   (clojure.core/let
    [v13279
     (:version-id-marker
      m13278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setVersionIdMarker (clojure.core/str v13279))))
   (clojure.core/let
    [v13279
     (:common-prefixes
      m13278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (.
      bean13277
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13589] (clojure.core/str arg13589))
 v13279))))
   (clojure.core/let
    [v13279
     (:key-marker m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setKeyMarker (clojure.core/str v13279))))
   (clojure.core/let
    [v13279
     (:delimiter m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setDelimiter (clojure.core/str v13279))))
   bean13277))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAlgorithm}
ssealgorithm
  [m13281]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.SSEAlgorithm
   (clojure.core/name m13281)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ResponseHeaderOverrides}
response-header-overrides
  [m13284]
  (clojure.core/let
   [bean13283
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/let
    [v13285
     (:content-type m13284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13285 :com.palletops.awaze.client-builder/undef)
     (. bean13283 setContentType (clojure.core/str v13285))))
   (clojure.core/let
    [v13285
     (:content-encoding
      m13284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13285 :com.palletops.awaze.client-builder/undef)
     (. bean13283 setContentEncoding (clojure.core/str v13285))))
   (clojure.core/let
    [v13285
     (:cache-control m13284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13285 :com.palletops.awaze.client-builder/undef)
     (. bean13283 setCacheControl (clojure.core/str v13285))))
   (clojure.core/let
    [v13285
     (:content-disposition
      m13284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13285 :com.palletops.awaze.client-builder/undef)
     (. bean13283 setContentDisposition (clojure.core/str v13285))))
   (clojure.core/let
    [v13285
     (:content-language
      m13284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13285 :com.palletops.awaze.client-builder/undef)
     (. bean13283 setContentLanguage (clojure.core/str v13285))))
   (clojure.core/let
    [v13285
     (:expires m13284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13285 :com.palletops.awaze.client-builder/undef)
     (. bean13283 setExpires (clojure.core/str v13285))))
   bean13283))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
canned-access-control-list
  [m13287]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m13287)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AccessControlList}
access-control-list
  [m13290]
  (clojure.core/let
   [bean13289 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/let
    [v13291 (:owner m13290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (. bean13289 setOwner (s3/owner v13291))))
   (clojure.core/let
    [v13291
     (:requester-charged
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (. bean13289 setRequesterCharged (clojure.core/boolean v13291))))
   bean13289))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAwsKeyManagementParams}
sseaws-key-management-params
  [m13293]
  (clojure.core/let
   [bean13292
    (new com.amazonaws.services.s3.model.SSEAwsKeyManagementParams)]
   bean13292))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectMetadata}
object-metadata
  [m13296]
  (clojure.core/let
   [bean13295 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/let
    [v13297
     (:content-encoding
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setContentEncoding (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:expiration-time-rule-id
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setExpirationTimeRuleId (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:cache-control m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setCacheControl (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:requester-charged
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setRequesterCharged (clojure.core/boolean v13297))))
   (clojure.core/let
    [v13297
     (:restore-expiration-time
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (.
      bean13295
      setRestoreExpirationTime
      (com.palletops.awaze.common/to-date v13297))))
   (clojure.core/let
    [v13297
     (:content-type m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setContentType (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:content-length
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setContentLength (clojure.core/long v13297))))
   (clojure.core/let
    [v13297
     (:ssecustomer-key-md5
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setSSECustomerKeyMd5 (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:ongoing-restore
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setOngoingRestore (clojure.core/boolean v13297))))
   (clojure.core/let
    [v13297
     (:expiration-time
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (.
      bean13295
      setExpirationTime
      (com.palletops.awaze.common/to-date v13297))))
   (clojure.core/let
    [v13297
     (:user-metadata m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (.
      bean13295
      setUserMetadata
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13590] (clojure.core/str arg13590))
  (clojure.core/keys v13297))
 (clojure.core/map
  (clojure.core/fn [arg13590] (clojure.core/str arg13590))
  (clojure.core/vals v13297))))))
   (clojure.core/let
    [v13297
     (:last-modified m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (.
      bean13295
      setLastModified
      (com.palletops.awaze.common/to-date v13297))))
   (clojure.core/let
    [v13297
     (:content-md5 m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setContentMD5 (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:content-disposition
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setContentDisposition (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:server-side-encryption
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setServerSideEncryption (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:ssealgorithm m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setSSEAlgorithm (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:ssecustomer-algorithm
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setSSECustomerAlgorithm (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:http-expires-date
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (.
      bean13295
      setHttpExpiresDate
      (com.palletops.awaze.common/to-date v13297))))
   bean13295))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.MultiFactorAuthentication}
multi-factor-authentication
  [m13299]
  (clojure.core/let
   [arg13301
    nil
    arg13302
    nil
    bean13298
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg13301
     arg13302)]
   (clojure.core/let
    [v13300
     (:device-serial-number
      m13299
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13300 :com.palletops.awaze.client-builder/undef)
     (. bean13298 setDeviceSerialNumber (clojure.core/str v13300))))
   (clojure.core/let
    [v13300 (:token m13299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13300 :com.palletops.awaze.client-builder/undef)
     (. bean13298 setToken (clojure.core/str v13300))))
   bean13298))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion}
delete-objects-request-key-version
  [m13304]
  (clojure.core/let
   [arg13306
    nil
    bean13303
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg13306)]
   bean13303))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketVersioningConfiguration}
bucket-versioning-configuration
  [m13308]
  (clojure.core/let
   [bean13307
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/let
    [v13309
     (:mfa-delete-enabled
      m13308
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13309 :com.palletops.awaze.client-builder/undef)
     (. bean13307 setMfaDeleteEnabled (clojure.core/boolean v13309))))
   (clojure.core/let
    [v13309
     (:status m13308 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13309 :com.palletops.awaze.client-builder/undef)
     (. bean13307 setStatus (clojure.core/str v13309))))
   bean13307))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLoggingConfiguration}
bucket-logging-configuration
  [m13311]
  (clojure.core/let
   [bean13310
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/let
    [v13312
     (:destination-bucket-name
      m13311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13312 :com.palletops.awaze.client-builder/undef)
     (. bean13310 setDestinationBucketName (clojure.core/str v13312))))
   (clojure.core/let
    [v13312
     (:log-file-prefix
      m13311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13312 :com.palletops.awaze.client-builder/undef)
     (. bean13310 setLogFilePrefix (clojure.core/str v13312))))
   bean13310))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3ObjectId}
s3object-id
  [m13314]
  (clojure.core/let
   [arg13316
    nil
    arg13317
    nil
    bean13313
    (new com.amazonaws.services.s3.model.S3ObjectId arg13316 arg13317)]
   bean13313))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PartETag}
part-etag
  [m13319]
  (clojure.core/let
   [arg13321
    0
    arg13322
    nil
    bean13318
    (new com.amazonaws.services.s3.model.PartETag arg13321 arg13322)]
   (clojure.core/let
    [v13320 (:etag m13319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13320 :com.palletops.awaze.client-builder/undef)
     (. bean13318 setETag (clojure.core/str v13320))))
   (clojure.core/let
    [v13320
     (:part-number m13319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13320 :com.palletops.awaze.client-builder/undef)
     (. bean13318 setPartNumber (clojure.core/int v13320))))
   bean13318))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketReplicationConfiguration}
bucket-replication-configuration
  [m13324]
  (clojure.core/let
   [bean13323
    (new
     com.amazonaws.services.s3.model.BucketReplicationConfiguration)]
   (clojure.core/let
    [v13325
     (:role-arn m13324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13325 :com.palletops.awaze.client-builder/undef)
     (. bean13323 setRoleARN (clojure.core/str v13325))))
   (clojure.core/let
    [v13325 (:rules m13324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13325 :com.palletops.awaze.client-builder/undef)
     (.
      bean13323
      setRules
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13591] (clojure.core/str arg13591))
  (clojure.core/keys v13325))
 (clojure.core/map
  (clojure.core/fn [arg13591] (s3/replication-rule arg13591))
  (clojure.core/vals v13325))))))
   bean13323))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketTaggingConfiguration}
bucket-tagging-configuration
  [m13327]
  (clojure.core/let
   [bean13326
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/let
    [v13328
     (:tag-sets m13327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13328 :com.palletops.awaze.client-builder/undef)
     (.
      bean13326
      setTagSets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg13592] (s3/tag-set arg13592))
 v13328))))
   bean13326))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectListing}
object-listing
  [m13330]
  (clojure.core/let
   [bean13329 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/let
    [v13331
     (:prefix m13330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (. bean13329 setPrefix (clojure.core/str v13331))))
   (clojure.core/let
    [v13331
     (:bucket-name m13330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (. bean13329 setBucketName (clojure.core/str v13331))))
   (clojure.core/let
    [v13331
     (:encoding-type m13330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (. bean13329 setEncodingType (clojure.core/str v13331))))
   (clojure.core/let
    [v13331
     (:max-keys m13330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (. bean13329 setMaxKeys (clojure.core/int v13331))))
   (clojure.core/let
    [v13331
     (:marker m13330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (. bean13329 setMarker (clojure.core/str v13331))))
   (clojure.core/let
    [v13331
     (:next-marker m13330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (. bean13329 setNextMarker (clojure.core/str v13331))))
   (clojure.core/let
    [v13331
     (:truncated m13330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (. bean13329 setTruncated (clojure.core/boolean v13331))))
   (clojure.core/let
    [v13331
     (:common-prefixes
      m13330
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (.
      bean13329
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13593] (clojure.core/str arg13593))
 v13331))))
   (clojure.core/let
    [v13331
     (:delimiter m13330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13331 :com.palletops.awaze.client-builder/undef)
     (. bean13329 setDelimiter (clojure.core/str v13331))))
   bean13329))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketWebsiteConfiguration}
bucket-website-configuration
  [m13333]
  (clojure.core/let
   [bean13332
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/let
    [v13334
     (:index-document-suffix
      m13333
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13334 :com.palletops.awaze.client-builder/undef)
     (. bean13332 setIndexDocumentSuffix (clojure.core/str v13334))))
   (clojure.core/let
    [v13334
     (:error-document
      m13333
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13334 :com.palletops.awaze.client-builder/undef)
     (. bean13332 setErrorDocument (clojure.core/str v13334))))
   (clojure.core/let
    [v13334
     (:redirect-all-requests-to
      m13333
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13334 :com.palletops.awaze.client-builder/undef)
     (. bean13332 setRedirectAllRequestsTo (s3/redirect-rule v13334))))
   (clojure.core/let
    [v13334
     (:routing-rules m13333 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13334 :com.palletops.awaze.client-builder/undef)
     (.
      bean13332
      setRoutingRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13594] (s3/routing-rule arg13594))
 v13334))))
   bean13332))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
delete-bucket-website-configuration-request
  [m13336]
  (clojure.core/let
   [arg13338
    nil
    bean13335
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg13338)]
   bean13335))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetObjectAclRequest}
set-object-acl-request
  [m13340]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13342
    nil
^{:tag java.lang.String}
arg13343
    nil
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13344
    (access-control-list {})
    bean13339
    (new
     com.amazonaws.services.s3.model.SetObjectAclRequest
^{:tag java.lang.String}
arg13342
^{:tag java.lang.String}
arg13343
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13344)]
   (clojure.core/let
    [v13341
     (:requester-pays
      m13340
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13341 :com.palletops.awaze.client-builder/undef)
     (. bean13339 setRequesterPays (clojure.core/boolean v13341))))
   bean13339))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
get-bucket-lifecycle-configuration-request
  [m13346]
  (clojure.core/let
   [arg13348
    nil
    bean13345
    (new
     com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
     arg13348)]
   bean13345))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m13350]
  (clojure.core/let
   [arg13352
    nil
    bean13349
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg13352)]
   (clojure.core/let
    [v13351
     (:upload-id-marker
      m13350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (. bean13349 setUploadIdMarker (clojure.core/str v13351))))
   (clojure.core/let
    [v13351
     (:delimiter m13350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (. bean13349 setDelimiter (clojure.core/str v13351))))
   (clojure.core/let
    [v13351
     (:key-marker m13350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (. bean13349 setKeyMarker (clojure.core/str v13351))))
   (clojure.core/let
    [v13351
     (:encoding-type m13350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (. bean13349 setEncodingType (clojure.core/str v13351))))
   (clojure.core/let
    [v13351
     (:max-uploads m13350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (. bean13349 setMaxUploads (clojure.core/int v13351))))
   (clojure.core/let
    [v13351
     (:prefix m13350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (. bean13349 setPrefix (clojure.core/str v13351))))
   (clojure.core/let
    [v13351
     (:bucket-name m13350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (. bean13349 setBucketName (clojure.core/str v13351))))
   bean13349))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectMetadataRequest}
get-object-metadata-request
  [m13354]
  (clojure.core/let
   [arg13356
    nil
    arg13357
    nil
    bean13353
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg13356
     arg13357)]
   (clojure.core/let
    [v13355
     (:version-id m13354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13355 :com.palletops.awaze.client-builder/undef)
     (. bean13353 setVersionId (clojure.core/str v13355))))
   (clojure.core/let
    [v13355
     (:requester-pays
      m13354
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13355 :com.palletops.awaze.client-builder/undef)
     (. bean13353 setRequesterPays (clojure.core/boolean v13355))))
   (clojure.core/let
    [v13355
     (:ssecustomer-key
      m13354
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13355 :com.palletops.awaze.client-builder/undef)
     (. bean13353 setSSECustomerKey (s3/ssecustomer-key v13355))))
   (clojure.core/let
    [v13355 (:key m13354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13355 :com.palletops.awaze.client-builder/undef)
     (. bean13353 setKey (clojure.core/str v13355))))
   (clojure.core/let
    [v13355
     (:bucket-name m13354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13355 :com.palletops.awaze.client-builder/undef)
     (. bean13353 setBucketName (clojure.core/str v13355))))
   bean13353))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest}
set-bucket-cross-origin-configuration-request
  [m13359]
  (clojure.core/let
   [arg13361
    nil
    arg13362
    (bucket-cross-origin-configuration {})
    bean13358
    (new
     com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest
     arg13361
     arg13362)]
   (clojure.core/let
    [v13360
     (:cross-origin-configuration
      m13359
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13360 :com.palletops.awaze.client-builder/undef)
     (.
      bean13358
      setCrossOriginConfiguration
      (s3/bucket-cross-origin-configuration v13360))))
   (clojure.core/let
    [v13360
     (:bucket-name m13359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13360 :com.palletops.awaze.client-builder/undef)
     (. bean13358 setBucketName (clojure.core/str v13360))))
   bean13358))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
delete-bucket-replication-configuration-request
  [m13364]
  (clojure.core/let
   [arg13366
    nil
    bean13363
    (new
     com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
     arg13366)]
   bean13363))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest}
set-bucket-lifecycle-configuration-request
  [m13368]
  (clojure.core/let
   [arg13370
    nil
    arg13371
    (bucket-lifecycle-configuration {})
    bean13367
    (new
     com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest
     arg13370
     arg13371)]
   (clojure.core/let
    [v13369
     (:lifecycle-configuration
      m13368
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (.
      bean13367
      setLifecycleConfiguration
      (s3/bucket-lifecycle-configuration v13369))))
   (clojure.core/let
    [v13369
     (:bucket-name m13368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (. bean13367 setBucketName (clojure.core/str v13369))))
   bean13367))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest}
set-bucket-notification-configuration-request
  [m13373]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13375
    nil
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13376
    (bucket-notification-configuration {})
    bean13372
    (new
     com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest
^{:tag java.lang.String}
arg13375
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13376)]
   (clojure.core/let
    [v13374
     (:notification-configuration
      m13373
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13374 :com.palletops.awaze.client-builder/undef)
     (.
      bean13372
      setNotificationConfiguration
      (s3/bucket-notification-configuration v13374))))
   (clojure.core/let
    [v13374
     (:bucket-notification-configuration
      m13373
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13374 :com.palletops.awaze.client-builder/undef)
     (.
      bean13372
      setBucketNotificationConfiguration
      (s3/bucket-notification-configuration v13374))))
   (clojure.core/let
    [v13374
     (:bucket m13373 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13374 :com.palletops.awaze.client-builder/undef)
     (. bean13372 setBucket (clojure.core/str v13374))))
   (clojure.core/let
    [v13374
     (:bucket-name m13373 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13374 :com.palletops.awaze.client-builder/undef)
     (. bean13372 setBucketName (clojure.core/str v13374))))
   bean13372))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
delete-bucket-policy-request
  [m13378]
  (clojure.core/let
   [arg13380
    nil
    bean13377
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg13380)]
   (clojure.core/let
    [v13379
     (:bucket-name m13378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13379 :com.palletops.awaze.client-builder/undef)
     (. bean13377 setBucketName (clojure.core/str v13379))))
   bean13377))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.HeadBucketRequest}
head-bucket-request
  [m13382]
  (clojure.core/let
   [arg13384
    nil
    bean13381
    (new com.amazonaws.services.s3.model.HeadBucketRequest arg13384)]
   (clojure.core/let
    [v13383
     (:bucket-name m13382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13383 :com.palletops.awaze.client-builder/undef)
     (. bean13381 setBucketName (clojure.core/str v13383))))
   bean13381))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.S3ClientOptions}
s3client-options
  [m13386]
  (clojure.core/let
   [bean13385 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/let
    [v13387
     (:path-style-access
      m13386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13387 :com.palletops.awaze.client-builder/undef)
     (. bean13385 setPathStyleAccess (clojure.core/boolean v13387))))
   (clojure.core/let
    [v13387
     (:chunked-encoding-disabled
      m13386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13387 :com.palletops.awaze.client-builder/undef)
     (.
      bean13385
      setChunkedEncodingDisabled
      (clojure.core/boolean v13387))))
   bean13385))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
get-bucket-notification-configuration-request
  [m13389]
  (clojure.core/let
   [arg13391
    nil
    bean13388
    (new
     com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
     arg13391)]
   bean13388))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
delete-bucket-lifecycle-configuration-request
  [m13393]
  (clojure.core/let
   [arg13395
    nil
    bean13392
    (new
     com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
     arg13395)]
   bean13392))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
list-objects-request
  [m13397]
  (clojure.core/let
   [bean13396
    (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/let
    [v13398
     (:delimiter m13397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13398 :com.palletops.awaze.client-builder/undef)
     (. bean13396 setDelimiter (clojure.core/str v13398))))
   (clojure.core/let
    [v13398
     (:max-keys m13397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13398 :com.palletops.awaze.client-builder/undef)
     (. bean13396 setMaxKeys (clojure.core/int v13398))))
   (clojure.core/let
    [v13398
     (:encoding-type m13397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13398 :com.palletops.awaze.client-builder/undef)
     (. bean13396 setEncodingType (clojure.core/str v13398))))
   (clojure.core/let
    [v13398
     (:marker m13397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13398 :com.palletops.awaze.client-builder/undef)
     (. bean13396 setMarker (clojure.core/str v13398))))
   (clojure.core/let
    [v13398
     (:prefix m13397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13398 :com.palletops.awaze.client-builder/undef)
     (. bean13396 setPrefix (clojure.core/str v13398))))
   (clojure.core/let
    [v13398
     (:bucket-name m13397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13398 :com.palletops.awaze.client-builder/undef)
     (. bean13396 setBucketName (clojure.core/str v13398))))
   bean13396))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m13400]
  (clojure.core/let
   [arg13402
    nil
    arg13403
    nil
    arg13404
    nil
    bean13399
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg13402
     arg13403
     arg13404)]
   (clojure.core/let
    [v13401
     (:requester-pays
      m13400
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13401 :com.palletops.awaze.client-builder/undef)
     (. bean13399 setRequesterPays (clojure.core/boolean v13401))))
   (clojure.core/let
    [v13401
     (:upload-id m13400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13401 :com.palletops.awaze.client-builder/undef)
     (. bean13399 setUploadId (clojure.core/str v13401))))
   (clojure.core/let
    [v13401 (:key m13400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13401 :com.palletops.awaze.client-builder/undef)
     (. bean13399 setKey (clojure.core/str v13401))))
   (clojure.core/let
    [v13401
     (:bucket-name m13400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13401 :com.palletops.awaze.client-builder/undef)
     (. bean13399 setBucketName (clojure.core/str v13401))))
   bean13399))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetS3AccountOwnerRequest}
get-s3account-owner-request
  [m13406]
  (clojure.core/let
   [bean13405
    (new com.amazonaws.services.s3.model.GetS3AccountOwnerRequest)]
   bean13405))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListBucketsRequest}
list-buckets-request
  [m13409]
  (clojure.core/let
   [bean13408
    (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean13408))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
get-bucket-website-configuration-request
  [m13412]
  (clojure.core/let
   [arg13414
    nil
    bean13411
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg13414)]
   (clojure.core/let
    [v13413
     (:bucket-name m13412 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13413 :com.palletops.awaze.client-builder/undef)
     (. bean13411 setBucketName (clojure.core/str v13413))))
   bean13411))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListPartsRequest}
list-parts-request
  [m13416]
  (clojure.core/let
   [arg13418
    nil
    arg13419
    nil
    arg13420
    nil
    bean13415
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg13418
     arg13419
     arg13420)]
   (clojure.core/let
    [v13417
     (:requester-pays
      m13416
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13417 :com.palletops.awaze.client-builder/undef)
     (. bean13415 setRequesterPays (clojure.core/boolean v13417))))
   (clojure.core/let
    [v13417
     (:max-parts m13416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13417 :com.palletops.awaze.client-builder/undef)
     (. bean13415 setMaxParts (clojure.core/int v13417))))
   (clojure.core/let
    [v13417
     (:part-number-marker
      m13416
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13417 :com.palletops.awaze.client-builder/undef)
     (. bean13415 setPartNumberMarker (clojure.core/int v13417))))
   (clojure.core/let
    [v13417
     (:encoding-type m13416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13417 :com.palletops.awaze.client-builder/undef)
     (. bean13415 setEncodingType (clojure.core/str v13417))))
   (clojure.core/let
    [v13417
     (:upload-id m13416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13417 :com.palletops.awaze.client-builder/undef)
     (. bean13415 setUploadId (clojure.core/str v13417))))
   (clojure.core/let
    [v13417 (:key m13416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13417 :com.palletops.awaze.client-builder/undef)
     (. bean13415 setKey (clojure.core/str v13417))))
   (clojure.core/let
    [v13417
     (:bucket-name m13416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13417 :com.palletops.awaze.client-builder/undef)
     (. bean13415 setBucketName (clojure.core/str v13417))))
   bean13415))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketAclRequest}
set-bucket-acl-request
  [m13422]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13424
    nil
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13425
    (canned-access-control-list {})
    bean13421
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
^{:tag java.lang.String}
arg13424
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13425)]
   bean13421))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyPartRequest}
copy-part-request
  [m13427]
  (clojure.core/let
   [bean13426 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/let
    [v13428
     (:first-byte m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setFirstByte (clojure.core/long v13428))))
   (clojure.core/let
    [v13428
     (:source-version-id
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setSourceVersionId (clojure.core/str v13428))))
   (clojure.core/let
    [v13428
     (:source-bucket-name
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setSourceBucketName (clojure.core/str v13428))))
   (clojure.core/let
    [v13428
     (:last-byte m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setLastByte (clojure.core/long v13428))))
   (clojure.core/let
    [v13428
     (:unmodified-since-constraint
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13428))))
   (clojure.core/let
    [v13428
     (:modified-since-constraint
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13428))))
   (clojure.core/let
    [v13428
     (:destination-ssecustomer-key
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13428))))
   (clojure.core/let
    [v13428
     (:destination-bucket-name
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setDestinationBucketName (clojure.core/str v13428))))
   (clojure.core/let
    [v13428
     (:part-number m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setPartNumber (clojure.core/int v13428))))
   (clojure.core/let
    [v13428
     (:destination-key
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setDestinationKey (clojure.core/str v13428))))
   (clojure.core/let
    [v13428
     (:matching-etag-constraints
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13595] (clojure.core/str arg13595))
 v13428))))
   (clojure.core/let
    [v13428
     (:source-key m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setSourceKey (clojure.core/str v13428))))
   (clojure.core/let
    [v13428
     (:source-ssecustomer-key
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setSourceSSECustomerKey (s3/ssecustomer-key v13428))))
   (clojure.core/let
    [v13428
     (:nonmatching-etag-constraints
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13596] (clojure.core/str arg13596))
 v13428))))
   (clojure.core/let
    [v13428
     (:upload-id m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setUploadId (clojure.core/str v13428))))
   bean13426))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
get-bucket-replication-configuration-request
  [m13430]
  (clojure.core/let
   [arg13432
    nil
    bean13429
    (new
     com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
     arg13432)]
   bean13429))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
get-bucket-versioning-configuration-request
  [m13434]
  (clojure.core/let
   [arg13436
    nil
    bean13433
    (new
     com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
     arg13436)]
   bean13433))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
list-next-batch-of-versions-request
  [m13438]
  (clojure.core/let
   [arg13440
    (version-listing {})
    bean13437
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
     arg13440)]
   (clojure.core/let
    [v13439
     (:previous-version-listing
      m13438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13439 :com.palletops.awaze.client-builder/undef)
     (.
      bean13437
      setPreviousVersionListing
      (s3/version-listing v13439))))
   bean13437))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
get-bucket-acl-request
  [m13442]
  (clojure.core/let
   [arg13444
    nil
    bean13441
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg13444)]
   bean13441))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectRequest}
delete-object-request
  [m13446]
  (clojure.core/let
   [arg13448
    nil
    arg13449
    nil
    bean13445
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg13448
     arg13449)]
   (clojure.core/let
    [v13447
     (:requester-pays
      m13446
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13447 :com.palletops.awaze.client-builder/undef)
     (. bean13445 setRequesterPays (clojure.core/boolean v13447))))
   (clojure.core/let
    [v13447 (:key m13446 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13447 :com.palletops.awaze.client-builder/undef)
     (. bean13445 setKey (clojure.core/str v13447))))
   (clojure.core/let
    [v13447
     (:bucket-name m13446 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13447 :com.palletops.awaze.client-builder/undef)
     (. bean13445 setBucketName (clojure.core/str v13447))))
   bean13445))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
delete-bucket-tagging-configuration-request
  [m13451]
  (clojure.core/let
   [arg13453
    nil
    bean13450
    (new
     com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
     arg13453)]
   bean13450))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
get-bucket-logging-configuration-request
  [m13455]
  (clojure.core/let
   [arg13457
    nil
    bean13454
    (new
     com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
     arg13457)]
   bean13454))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GeneratePresignedUrlRequest}
generate-presigned-url-request
  [m13459]
  (clojure.core/let
   [arg13461
    nil
    arg13462
    nil
    bean13458
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg13461
     arg13462)]
   (clojure.core/let
    [v13460
     (:expiration m13459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (.
      bean13458
      setExpiration
      (com.palletops.awaze.common/to-date v13460))))
   (clojure.core/let
    [v13460
     (:kms-cmk-id m13459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setKmsCmkId (clojure.core/str v13460))))
   (clojure.core/let
    [v13460
     (:content-type m13459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setContentType (clojure.core/str v13460))))
   (clojure.core/let
    [v13460
     (:bucket-name m13459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setBucketName (clojure.core/str v13460))))
   (clojure.core/let
    [v13460
     (:ssecustomer-key
      m13459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setSSECustomerKey (s3/ssecustomer-key v13460))))
   (clojure.core/let
    [v13460
     (:method m13459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setMethod (root/http-method v13460))))
   (clojure.core/let
    [v13460
     (:ssecustomer-key-algorithm
      m13459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setSSECustomerKeyAlgorithm (s3/ssealgorithm v13460))))
   (clojure.core/let
    [v13460
     (:response-headers
      m13459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (.
      bean13458
      setResponseHeaders
      (s3/response-header-overrides v13460))))
   (clojure.core/let
    [v13460
     (:zero-byte-content
      m13459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setZeroByteContent (clojure.core/boolean v13460))))
   (clojure.core/let
    [v13460 (:key m13459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setKey (clojure.core/str v13460))))
   (clojure.core/let
    [v13460
     (:ssealgorithm m13459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setSSEAlgorithm (s3/ssealgorithm v13460))))
   (clojure.core/let
    [v13460
     (:content-md5 m13459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13460 :com.palletops.awaze.client-builder/undef)
     (. bean13458 setContentMd5 (clojure.core/str v13460))))
   bean13458))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyObjectRequest}
copy-object-request
  [m13464]
  (clojure.core/let
   [arg13466
    nil
    arg13467
    nil
    arg13468
    nil
    arg13469
    nil
    bean13463
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg13466
     arg13467
     arg13468
     arg13469)]
   (clojure.core/let
    [v13465
     (:canned-access-control-list
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (.
      bean13463
      setCannedAccessControlList
      (s3/canned-access-control-list v13465))))
   (clojure.core/let
    [v13465
     (:source-version-id
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setSourceVersionId (clojure.core/str v13465))))
   (clojure.core/let
    [v13465
     (:source-bucket-name
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setSourceBucketName (clojure.core/str v13465))))
   (clojure.core/let
    [v13465
     (:unmodified-since-constraint
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (.
      bean13463
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13465))))
   (clojure.core/let
    [v13465
     (:modified-since-constraint
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (.
      bean13463
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13465))))
   (clojure.core/let
    [v13465
     (:storage-class m13464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setStorageClass (clojure.core/str v13465))))
   (clojure.core/let
    [v13465
     (:destination-ssecustomer-key
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (.
      bean13463
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13465))))
   (clojure.core/let
    [v13465
     (:destination-bucket-name
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setDestinationBucketName (clojure.core/str v13465))))
   (clojure.core/let
    [v13465
     (:redirect-location
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setRedirectLocation (clojure.core/str v13465))))
   (clojure.core/let
    [v13465
     (:requester-pays
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setRequesterPays (clojure.core/boolean v13465))))
   (clojure.core/let
    [v13465
     (:access-control-list
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (.
      bean13463
      setAccessControlList
      (s3/access-control-list v13465))))
   (clojure.core/let
    [v13465
     (:sseaws-key-management-params
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (.
      bean13463
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13465))))
   (clojure.core/let
    [v13465
     (:destination-key
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setDestinationKey (clojure.core/str v13465))))
   (clojure.core/let
    [v13465
     (:matching-etag-constraints
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (.
      bean13463
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13597] (clojure.core/str arg13597))
 v13465))))
   (clojure.core/let
    [v13465
     (:source-key m13464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setSourceKey (clojure.core/str v13465))))
   (clojure.core/let
    [v13465
     (:source-ssecustomer-key
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setSourceSSECustomerKey (s3/ssecustomer-key v13465))))
   (clojure.core/let
    [v13465
     (:new-object-metadata
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setNewObjectMetadata (s3/object-metadata v13465))))
   (clojure.core/let
    [v13465
     (:nonmatching-etag-constraints
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (.
      bean13463
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13598] (clojure.core/str arg13598))
 v13465))))
   bean13463))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest}
delete-objects-request
  [m13471]
  (clojure.core/let
   [arg13473
    nil
    bean13470
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest
     arg13473)]
   (clojure.core/let
    [v13472
     (:requester-pays
      m13471
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13472 :com.palletops.awaze.client-builder/undef)
     (. bean13470 setRequesterPays (clojure.core/boolean v13472))))
   (clojure.core/let
    [v13472 (:mfa m13471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13472 :com.palletops.awaze.client-builder/undef)
     (. bean13470 setMfa (s3/multi-factor-authentication v13472))))
   (clojure.core/let
    [v13472 (:quiet m13471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13472 :com.palletops.awaze.client-builder/undef)
     (. bean13470 setQuiet (clojure.core/boolean v13472))))
   (clojure.core/let
    [v13472 (:keys m13471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13472 :com.palletops.awaze.client-builder/undef)
     (.
      bean13470
      setKeys
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13599]
  (s3/delete-objects-request-key-version arg13599))
 v13472))))
   (clojure.core/let
    [v13472
     (:bucket-name m13471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13472 :com.palletops.awaze.client-builder/undef)
     (. bean13470 setBucketName (clojure.core/str v13472))))
   bean13470))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest}
set-bucket-versioning-configuration-request
  [m13475]
  (clojure.core/let
   [arg13477
    nil
    arg13478
    (bucket-versioning-configuration {})
    bean13474
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg13477
     arg13478)]
   (clojure.core/let
    [v13476
     (:versioning-configuration
      m13475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13476 :com.palletops.awaze.client-builder/undef)
     (.
      bean13474
      setVersioningConfiguration
      (s3/bucket-versioning-configuration v13476))))
   (clojure.core/let
    [v13476 (:mfa m13475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13476 :com.palletops.awaze.client-builder/undef)
     (. bean13474 setMfa (s3/multi-factor-authentication v13476))))
   (clojure.core/let
    [v13476
     (:bucket-name m13475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13476 :com.palletops.awaze.client-builder/undef)
     (. bean13474 setBucketName (clojure.core/str v13476))))
   bean13474))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest}
set-bucket-logging-configuration-request
  [m13480]
  (clojure.core/let
   [arg13482
    nil
    arg13483
    (bucket-logging-configuration {})
    bean13479
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg13482
     arg13483)]
   (clojure.core/let
    [v13481
     (:logging-configuration
      m13480
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13481 :com.palletops.awaze.client-builder/undef)
     (.
      bean13479
      setLoggingConfiguration
      (s3/bucket-logging-configuration v13481))))
   (clojure.core/let
    [v13481
     (:bucket-name m13480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13481 :com.palletops.awaze.client-builder/undef)
     (. bean13479 setBucketName (clojure.core/str v13481))))
   bean13479))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
get-object-request
  [m13485]
  (clojure.core/let
   [arg13487
    nil
    arg13488
    nil
    bean13484
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg13487
     arg13488)]
   (clojure.core/let
    [v13486
     (:progress-listener
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setProgressListener v13486)))
   (clojure.core/let
    [v13486
     (:bucket-name m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setBucketName (clojure.core/str v13486))))
   (clojure.core/let
    [v13486
     (:ssecustomer-key
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setSSECustomerKey (s3/ssecustomer-key v13486))))
   (clojure.core/let
    [v13486
     (:unmodified-since-constraint
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (.
      bean13484
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13486))))
   (clojure.core/let
    [v13486
     (:modified-since-constraint
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (.
      bean13484
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13486))))
   (clojure.core/let
    [v13486 (:range m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setRange (clojure.core/long v13486))))
   (clojure.core/let
    [v13486
     (:s3object-id m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setS3ObjectId (s3/s3object-id v13486))))
   (clojure.core/let
    [v13486
     (:response-headers
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (.
      bean13484
      setResponseHeaders
      (s3/response-header-overrides v13486))))
   (clojure.core/let
    [v13486
     (:requester-pays
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setRequesterPays (clojure.core/boolean v13486))))
   (clojure.core/let
    [v13486 (:key m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setKey (clojure.core/str v13486))))
   (clojure.core/let
    [v13486
     (:matching-etag-constraints
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (.
      bean13484
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13600] (clojure.core/str arg13600))
 v13486))))
   (clojure.core/let
    [v13486
     (:version-id m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setVersionId (clojure.core/str v13486))))
   (clojure.core/let
    [v13486
     (:nonmatching-etag-constraints
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (.
      bean13484
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13601] (clojure.core/str arg13601))
 v13486))))
   bean13484))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
delete-bucket-cross-origin-configuration-request
  [m13490]
  (clojure.core/let
   [arg13492
    nil
    bean13489
    (new
     com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
     arg13492)]
   bean13489))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m13494]
  (clojure.core/let
   [bean13493
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v13495
     (:requester-pays
      m13494
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13495 :com.palletops.awaze.client-builder/undef)
     (. bean13493 setRequesterPays (clojure.core/boolean v13495))))
   (clojure.core/let
    [v13495
     (:part-etags m13494 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13495 :com.palletops.awaze.client-builder/undef)
     (.
      bean13493
      setPartETags
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13602] (s3/part-etag arg13602))
 v13495))))
   (clojure.core/let
    [v13495
     (:upload-id m13494 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13495 :com.palletops.awaze.client-builder/undef)
     (. bean13493 setUploadId (clojure.core/str v13495))))
   (clojure.core/let
    [v13495 (:key m13494 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13495 :com.palletops.awaze.client-builder/undef)
     (. bean13493 setKey (clojure.core/str v13495))))
   (clojure.core/let
    [v13495
     (:bucket-name m13494 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13495 :com.palletops.awaze.client-builder/undef)
     (. bean13493 setBucketName (clojure.core/str v13495))))
   bean13493))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RestoreObjectRequest}
restore-object-request
  [m13497]
  (clojure.core/let
   [arg13499
    nil
    arg13500
    nil
    bean13496
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg13499
     arg13500)]
   (clojure.core/let
    [v13498
     (:version-id m13497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13498 :com.palletops.awaze.client-builder/undef)
     (. bean13496 setVersionId (clojure.core/str v13498))))
   (clojure.core/let
    [v13498
     (:requester-pays
      m13497
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13498 :com.palletops.awaze.client-builder/undef)
     (. bean13496 setRequesterPays (clojure.core/boolean v13498))))
   (clojure.core/let
    [v13498
     (:expiration-in-days
      m13497
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13498 :com.palletops.awaze.client-builder/undef)
     (. bean13496 setExpirationInDays (clojure.core/int v13498))))
   (clojure.core/let
    [v13498 (:key m13497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13498 :com.palletops.awaze.client-builder/undef)
     (. bean13496 setKey (clojure.core/str v13498))))
   (clojure.core/let
    [v13498
     (:bucket-name m13497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13498 :com.palletops.awaze.client-builder/undef)
     (. bean13496 setBucketName (clojure.core/str v13498))))
   bean13496))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
get-bucket-policy-request
  [m13502]
  (clojure.core/let
   [arg13504
    nil
    bean13501
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg13504)]
   (clojure.core/let
    [v13503
     (:bucket-name m13502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13503 :com.palletops.awaze.client-builder/undef)
     (. bean13501 setBucketName (clojure.core/str v13503))))
   bean13501))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest}
set-bucket-replication-configuration-request
  [m13506]
  (clojure.core/let
   [bean13505
    (new
     com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest)]
   (clojure.core/let
    [v13507
     (:replication-configuration
      m13506
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13507 :com.palletops.awaze.client-builder/undef)
     (.
      bean13505
      setReplicationConfiguration
      (s3/bucket-replication-configuration v13507))))
   (clojure.core/let
    [v13507
     (:bucket-name m13506 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13507 :com.palletops.awaze.client-builder/undef)
     (. bean13505 setBucketName (clojure.core/str v13507))))
   bean13505))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
create-bucket-request
  [m13509]
  (clojure.core/let
   [arg13511
    nil
    bean13508
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg13511)]
   (clojure.core/let
    [v13510
     (:canned-acl m13509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setCannedAcl (s3/canned-access-control-list v13510))))
   (clojure.core/let
    [v13510
     (:access-control-list
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setAccessControlList
      (s3/access-control-list v13510))))
   (clojure.core/let
    [v13510
     (:region m13509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setRegion (clojure.core/str v13510))))
   (clojure.core/let
    [v13510
     (:bucket-name m13509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setBucketName (clojure.core/str v13510))))
   bean13508))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Region}
region
  [m13513]
  (.
   com.amazonaws.services.s3.model.Region
   fromValue
   (clojure.core/name m13513)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteVersionRequest}
delete-version-request
  [m13516]
  (clojure.core/let
   [arg13518
    nil
    arg13519
    nil
    arg13520
    nil
    bean13515
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg13518
     arg13519
     arg13520)]
   (clojure.core/let
    [v13517
     (:version-id m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setVersionId (clojure.core/str v13517))))
   (clojure.core/let
    [v13517 (:mfa m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setMfa (s3/multi-factor-authentication v13517))))
   (clojure.core/let
    [v13517 (:key m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setKey (clojure.core/str v13517))))
   (clojure.core/let
    [v13517
     (:bucket-name m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setBucketName (clojure.core/str v13517))))
   bean13515))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PutObjectRequest}
put-object-request
  [m13522]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13524
    nil
^{:tag java.lang.String}
arg13525
    nil
^{:tag java.lang.String}
arg13526
    nil
    bean13521
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
^{:tag java.lang.String}
arg13524
^{:tag java.lang.String}
arg13525
^{:tag java.lang.String}
arg13526)]
   (clojure.core/let
    [v13523
     (:requester-pays
      m13522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13523 :com.palletops.awaze.client-builder/undef)
     (. bean13521 setRequesterPays (clojure.core/boolean v13523))))
   bean13521))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListVersionsRequest}
list-versions-request
  [m13528]
  (clojure.core/let
   [bean13527
    (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/let
    [v13529
     (:delimiter m13528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13529 :com.palletops.awaze.client-builder/undef)
     (. bean13527 setDelimiter (clojure.core/str v13529))))
   (clojure.core/let
    [v13529
     (:key-marker m13528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13529 :com.palletops.awaze.client-builder/undef)
     (. bean13527 setKeyMarker (clojure.core/str v13529))))
   (clojure.core/let
    [v13529
     (:version-id-marker
      m13528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13529 :com.palletops.awaze.client-builder/undef)
     (. bean13527 setVersionIdMarker (clojure.core/str v13529))))
   (clojure.core/let
    [v13529
     (:encoding-type m13528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13529 :com.palletops.awaze.client-builder/undef)
     (. bean13527 setEncodingType (clojure.core/str v13529))))
   (clojure.core/let
    [v13529
     (:prefix m13528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13529 :com.palletops.awaze.client-builder/undef)
     (. bean13527 setPrefix (clojure.core/str v13529))))
   (clojure.core/let
    [v13529
     (:max-results m13528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13529 :com.palletops.awaze.client-builder/undef)
     (. bean13527 setMaxResults (clojure.core/int v13529))))
   (clojure.core/let
    [v13529
     (:bucket-name m13528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13529 :com.palletops.awaze.client-builder/undef)
     (. bean13527 setBucketName (clojure.core/str v13529))))
   bean13527))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest}
set-bucket-tagging-configuration-request
  [m13531]
  (clojure.core/let
   [arg13533
    nil
    arg13534
    (bucket-tagging-configuration {})
    bean13530
    (new
     com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest
     arg13533
     arg13534)]
   (clojure.core/let
    [v13532
     (:tagging-configuration
      m13531
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13532 :com.palletops.awaze.client-builder/undef)
     (.
      bean13530
      setTaggingConfiguration
      (s3/bucket-tagging-configuration v13532))))
   (clojure.core/let
    [v13532
     (:bucket-name m13531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13532 :com.palletops.awaze.client-builder/undef)
     (. bean13530 setBucketName (clojure.core/str v13532))))
   bean13530))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
get-bucket-cross-origin-configuration-request
  [m13536]
  (clojure.core/let
   [arg13538
    nil
    bean13535
    (new
     com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
     arg13538)]
   bean13535))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketPolicyRequest}
set-bucket-policy-request
  [m13540]
  (clojure.core/let
   [arg13542
    nil
    arg13543
    nil
    bean13539
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg13542
     arg13543)]
   (clojure.core/let
    [v13541
     (:policy-text m13540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setPolicyText (clojure.core/str v13541))))
   (clojure.core/let
    [v13541
     (:bucket-name m13540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setBucketName (clojure.core/str v13541))))
   bean13539))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
list-next-batch-of-objects-request
  [m13545]
  (clojure.core/let
   [arg13547
    (object-listing {})
    bean13544
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
     arg13547)]
   (clojure.core/let
    [v13546
     (:previous-object-listing
      m13545
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13546 :com.palletops.awaze.client-builder/undef)
     (. bean13544 setPreviousObjectListing (s3/object-listing v13546))))
   bean13544))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m13549]
  (clojure.core/let
   [arg13551
    nil
    arg13552
    nil
    bean13548
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg13551
     arg13552)]
   (clojure.core/let
    [v13550
     (:bucket-name m13549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setBucketName (clojure.core/str v13550))))
   (clojure.core/let
    [v13550
     (:ssecustomer-key
      m13549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setSSECustomerKey (s3/ssecustomer-key v13550))))
   (clojure.core/let
    [v13550
     (:canned-acl m13549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setCannedACL (s3/canned-access-control-list v13550))))
   (clojure.core/let
    [v13550
     (:storage-class m13549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setStorageClass (s3/storage-class v13550))))
   (clojure.core/let
    [v13550
     (:redirect-location
      m13549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setRedirectLocation (clojure.core/str v13550))))
   (clojure.core/let
    [v13550
     (:requester-pays
      m13549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setRequesterPays (clojure.core/boolean v13550))))
   (clojure.core/let
    [v13550
     (:object-metadata
      m13549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setObjectMetadata (s3/object-metadata v13550))))
   (clojure.core/let
    [v13550
     (:access-control-list
      m13549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (.
      bean13548
      setAccessControlList
      (s3/access-control-list v13550))))
   (clojure.core/let
    [v13550 (:key m13549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setKey (clojure.core/str v13550))))
   (clojure.core/let
    [v13550
     (:sseaws-key-management-params
      m13549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (.
      bean13548
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13550))))
   bean13548))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
delete-bucket-request
  [m13554]
  (clojure.core/let
   [arg13556
    nil
    bean13553
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg13556)]
   (clojure.core/let
    [v13555
     (:bucket-name m13554 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13555 :com.palletops.awaze.client-builder/undef)
     (. bean13553 setBucketName (clojure.core/str v13555))))
   bean13553))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
get-bucket-tagging-configuration-request
  [m13558]
  (clojure.core/let
   [arg13560
    nil
    bean13557
    (new
     com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
     arg13560)]
   bean13557))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
get-bucket-location-request
  [m13562]
  (clojure.core/let
   [arg13564
    nil
    bean13561
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg13564)]
   (clojure.core/let
    [v13563
     (:bucket-name m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setBucketName (clojure.core/str v13563))))
   bean13561))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectAclRequest}
get-object-acl-request
  [m13566]
  (clojure.core/let
   [arg13568
    nil
    arg13569
    nil
    bean13565
    (new
     com.amazonaws.services.s3.model.GetObjectAclRequest
     arg13568
     arg13569)]
   (clojure.core/let
    [v13567
     (:version-id m13566 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13567 :com.palletops.awaze.client-builder/undef)
     (. bean13565 setVersionId (clojure.core/str v13567))))
   (clojure.core/let
    [v13567
     (:requester-pays
      m13566
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13567 :com.palletops.awaze.client-builder/undef)
     (. bean13565 setRequesterPays (clojure.core/boolean v13567))))
   (clojure.core/let
    [v13567 (:key m13566 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13567 :com.palletops.awaze.client-builder/undef)
     (. bean13565 setKey (clojure.core/str v13567))))
   (clojure.core/let
    [v13567
     (:bucket-name m13566 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13567 :com.palletops.awaze.client-builder/undef)
     (. bean13565 setBucketName (clojure.core/str v13567))))
   bean13565))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.UploadPartRequest}
upload-part-request
  [m13571]
  (clojure.core/let
   [bean13570 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/let
    [v13572
     (:file-offset m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setFileOffset (clojure.core/long v13572))))
   (clojure.core/let
    [v13572
     (:progress-listener
      m13571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setProgressListener v13572)))
   (clojure.core/let
    [v13572
     (:bucket-name m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setBucketName (clojure.core/str v13572))))
   (clojure.core/let
    [v13572
     (:ssecustomer-key
      m13571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setSSECustomerKey (s3/ssecustomer-key v13572))))
   (clojure.core/let
    [v13572
     (:input-stream m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (.
      bean13570
      setInputStream
      (clojure.java.io/input-stream v13572))))
   (clojure.core/let
    [v13572
     (:md5digest m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setMd5Digest (clojure.core/str v13572))))
   (clojure.core/let
    [v13572
     (:part-size m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setPartSize (clojure.core/long v13572))))
   (clojure.core/let
    [v13572
     (:requester-pays
      m13571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setRequesterPays (clojure.core/boolean v13572))))
   (clojure.core/let
    [v13572
     (:object-metadata
      m13571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setObjectMetadata (s3/object-metadata v13572))))
   (clojure.core/let
    [v13572 (:key m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setKey (clojure.core/str v13572))))
   (clojure.core/let
    [v13572
     (:part-number m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setPartNumber (clojure.core/int v13572))))
   (clojure.core/let
    [v13572 (:file m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setFile (clojure.java.io/file v13572))))
   (clojure.core/let
    [v13572
     (:last-part m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setLastPart (clojure.core/boolean v13572))))
   (clojure.core/let
    [v13572
     (:upload-id m13571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13572 :com.palletops.awaze.client-builder/undef)
     (. bean13570 setUploadId (clojure.core/str v13572))))
   bean13570))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest}
set-bucket-website-configuration-request
  [m13574]
  (clojure.core/let
   [arg13576
    nil
    arg13577
    (bucket-website-configuration {})
    bean13573
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg13576
     arg13577)]
   (clojure.core/let
    [v13575
     (:configuration m13574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13575 :com.palletops.awaze.client-builder/undef)
     (.
      bean13573
      setConfiguration
      (s3/bucket-website-configuration v13575))))
   (clojure.core/let
    [v13575
     (:bucket-name m13574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13575 :com.palletops.awaze.client-builder/undef)
     (. bean13573 setBucketName (clojure.core/str v13575))))
   bean13573))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m13603]
   (clojure.core/let
    [credentials13604 (:credentials m13603) args13605 (:args m13603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13606
      (com.palletops.awaze.common/aws-client :s3 credentials13604)]
     (clojure.core/case
      (clojure.core/count args13605)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
           (clojure.core/nth args13605 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13606
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13605 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13606
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args13605}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials13609 & args13610]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13612
     (com.palletops.awaze.common/aws-client :s3 credentials13609)]
    (clojure.core/case
     (clojure.core/count args13610)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
          (clojure.core/nth args13610 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13612
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13610 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13612
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args13610}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m13613]
   (clojure.core/let
    [credentials13614 (:credentials m13613) args13615 (:args m13613)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13616
      (com.palletops.awaze.common/aws-client :s3 credentials13614)]
     (clojure.core/case
      (clojure.core/count args13615)
      5
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13615 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13615 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13615 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13615 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13615 4))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13616
           setObjectAcl
           a
           b
           c
           d
           e)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13615 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13615 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13615 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13615 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13615 4))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13616
               setObjectAcl
               a
               b
               c
               d
               e)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13615}))))))))))
      4
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13615 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13615 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13615 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13615 3))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13616
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13615 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13615 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13615 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13615 3))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13616
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13615}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13616
        setObjectAcl
        (s3/set-object-acl-request (clojure.core/nth args13615 0))))
      3
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13615 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13615 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13615 2))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13616
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13615 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13615 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13615 2))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13616
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13615}))))))))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d e]
    {:args [a b c d e],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-acl
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials13624 & args13625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13632
     (com.palletops.awaze.common/aws-client :s3 credentials13624)]
    (clojure.core/case
     (clojure.core/count args13625)
     5
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13625 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13625 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13625 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13625 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13625 4))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
          setObjectAcl
          a
          b
          c
          d
          e)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13625 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13625 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13625 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13625 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13625 4))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
              setObjectAcl
              a
              b
              c
              d
              e)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13625}))))))))))
     4
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13625 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13625 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13625 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13625 3))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13625 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13625 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13625 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13625 3))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13625}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
       setObjectAcl
       (s3/set-object-acl-request (clojure.core/nth args13625 0))))
     3
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13625 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13625 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13625 2))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13625 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13625 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13625 2))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13625}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m13633]
   (clojure.core/let
    [credentials13634 (:credentials m13633) args13635 (:args m13633)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13636
      (com.palletops.awaze.common/aws-client :s3 credentials13634)]
     (clojure.core/case
      (clojure.core/count args13635)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13635 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13636
           getBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
               (clojure.core/nth args13635 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13636
               getBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLifecycleConfiguration")
                {:args args13635}))))))))))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   [credentials13639 & args13640]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13642
     (com.palletops.awaze.common/aws-client :s3 credentials13639)]
    (clojure.core/case
     (clojure.core/count args13640)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13640 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13642
          getBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
              (clojure.core/nth args13640 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13642
              getBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLifecycleConfiguration")
               {:args args13640}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m13643]
   (clojure.core/let
    [credentials13644 (:credentials m13643) args13645 (:args m13643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13646
      (com.palletops.awaze.common/aws-client :s3 credentials13644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13646
       listMultipartUploads
       (s3/list-multipart-uploads-request
        (clojure.core/nth args13645 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Call listMultipartUploads"}
   [credentials13649 & args13650]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13652
     (com.palletops.awaze.common/aws-client :s3 credentials13649)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13652
      listMultipartUploads
      (s3/list-multipart-uploads-request
       (clojure.core/nth args13650 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m13653]
   (clojure.core/let
    [credentials13654 (:credentials m13653) args13655 (:args m13653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13656
      (com.palletops.awaze.common/aws-client :s3 credentials13654)]
     (clojure.core/case
      (clojure.core/count args13655)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13656
        getObjectMetadata
        (s3/get-object-metadata-request
         (clojure.core/nth args13655 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13656
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args13655 0))
        (clojure.core/str (clojure.core/nth args13655 1))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object-metadata,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object-metadata,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials13660 & args13661]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13664
     (com.palletops.awaze.common/aws-client :s3 credentials13660)]
    (clojure.core/case
     (clojure.core/count args13661)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13664
       getObjectMetadata
       (s3/get-object-metadata-request (clojure.core/nth args13661 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13664
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args13661 0))
       (clojure.core/str (clojure.core/nth args13661 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m13665]
   (clojure.core/let
    [credentials13666 (:credentials m13665) args13667 (:args m13665)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13668
      (com.palletops.awaze.common/aws-client :s3 credentials13666)]
     (clojure.core/case
      (clojure.core/count args13667)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13668
        setBucketCrossOriginConfiguration
        (clojure.core/str (clojure.core/nth args13667 0))
        (s3/bucket-cross-origin-configuration
         (clojure.core/nth args13667 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13668
        setBucketCrossOriginConfiguration
        (s3/set-bucket-cross-origin-configuration-request
         (clojure.core/nth args13667 0))))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   [credentials13672 & args13673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13676
     (com.palletops.awaze.common/aws-client :s3 credentials13672)]
    (clojure.core/case
     (clojure.core/count args13673)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13676
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args13673 0))
       (s3/bucket-cross-origin-configuration
        (clojure.core/nth args13673 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13676
       setBucketCrossOriginConfiguration
       (s3/set-bucket-cross-origin-configuration-request
        (clojure.core/nth args13673 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-replication-configuration
   [m13677]
   (clojure.core/let
    [credentials13678 (:credentials m13677) args13679 (:args m13677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13680
      (com.palletops.awaze.common/aws-client :s3 credentials13678)]
     (clojure.core/case
      (clojure.core/count args13679)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
           (clojure.core/nth args13679 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13680
           deleteBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13679 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13680
               deleteBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketReplicationConfiguration")
                {:args args13679}))))))))))))))
  (clojure.core/defn
   delete-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-replication-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   [credentials13683 & args13684]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13686
     (com.palletops.awaze.common/aws-client :s3 credentials13683)]
    (clojure.core/case
     (clojure.core/count args13684)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
          (clojure.core/nth args13684 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13686
          deleteBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13684 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13686
              deleteBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketReplicationConfiguration")
               {:args args13684}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m13687]
   (clojure.core/let
    [credentials13688 (:credentials m13687) args13689 (:args m13687)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13690
      (com.palletops.awaze.common/aws-client :s3 credentials13688)]
     (clojure.core/case
      (clojure.core/count args13689)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13690
        setBucketLifecycleConfiguration
        (s3/set-bucket-lifecycle-configuration-request
         (clojure.core/nth args13689 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13690
        setBucketLifecycleConfiguration
        (clojure.core/str (clojure.core/nth args13689 0))
        (s3/bucket-lifecycle-configuration
         (clojure.core/nth args13689 1))))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   [credentials13694 & args13695]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13698
     (com.palletops.awaze.common/aws-client :s3 credentials13694)]
    (clojure.core/case
     (clojure.core/count args13695)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13698
       setBucketLifecycleConfiguration
       (s3/set-bucket-lifecycle-configuration-request
        (clojure.core/nth args13695 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13698
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args13695 0))
       (s3/bucket-lifecycle-configuration
        (clojure.core/nth args13695 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-object-exist
   [m13699]
   (clojure.core/let
    [credentials13700 (:credentials m13699) args13701 (:args m13699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13702
      (com.palletops.awaze.common/aws-client :s3 credentials13700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13702
       doesObjectExist
       (clojure.core/str (clojure.core/nth args13701 0))
       (clojure.core/str (clojure.core/nth args13701 1)))))))
  (clojure.core/defn
   does-object-exist-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for doesObjectExist"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :does-object-exist,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   does-object-exist
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call doesObjectExist"}
   [credentials13704 & args13705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13706
     (com.palletops.awaze.common/aws-client :s3 credentials13704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13706
      doesObjectExist
      (clojure.core/str (clojure.core/nth args13705 0))
      (clojure.core/str (clojure.core/nth args13705 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m13707]
   (clojure.core/let
    [credentials13708 (:credentials m13707) args13709 (:args m13707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13710
      (com.palletops.awaze.common/aws-client :s3 credentials13708)]
     (clojure.core/case
      (clojure.core/count args13709)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13710
        setBucketNotificationConfiguration
        (s3/set-bucket-notification-configuration-request
         (clojure.core/nth args13709 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13710
        setBucketNotificationConfiguration
        (clojure.core/str (clojure.core/nth args13709 0))
        (s3/bucket-notification-configuration
         (clojure.core/nth args13709 1))))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Generate map for setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Call setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   [credentials13716 & args13717]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13722
     (com.palletops.awaze.common/aws-client :s3 credentials13716)]
    (clojure.core/case
     (clojure.core/count args13717)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13722
       setBucketNotificationConfiguration
       (s3/set-bucket-notification-configuration-request
        (clojure.core/nth args13717 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13722
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args13717 0))
       (s3/bucket-notification-configuration
        (clojure.core/nth args13717 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m13723]
   (clojure.core/let
    [credentials13724 (:credentials m13723) args13725 (:args m13723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13726
      (com.palletops.awaze.common/aws-client :s3 credentials13724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13726
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args13725 0))
       (clojure.core/str (clojure.core/nth args13725 1))
       (clojure.core/str (clojure.core/nth args13725 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-object-redirect-location,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Call setObjectRedirectLocation"}
   [credentials13728 & args13729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13730
     (com.palletops.awaze.common/aws-client :s3 credentials13728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13730
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args13729 0))
      (clojure.core/str (clojure.core/nth args13729 1))
      (clojure.core/str (clojure.core/nth args13729 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m13731]
   (clojure.core/let
    [credentials13732 (:credentials m13731) args13733 (:args m13731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13734
      (com.palletops.awaze.common/aws-client :s3 credentials13732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13734
       getUrl
       (clojure.core/str (clojure.core/nth args13733 0))
       (clojure.core/str (clojure.core/nth args13733 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getUrl"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getUrl"}
   [credentials13736 & args13737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13738
     (com.palletops.awaze.common/aws-client :s3 credentials13736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13738
      getUrl
      (clojure.core/str (clojure.core/nth args13737 0))
      (clojure.core/str (clojure.core/nth args13737 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m13739]
   (clojure.core/let
    [credentials13740 (:credentials m13739) args13741 (:args m13739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13742
      (com.palletops.awaze.common/aws-client :s3 credentials13740)]
     (clojure.core/case
      (clojure.core/count args13741)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13741 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13742
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
               (clojure.core/nth args13741 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13742
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args13741}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials13745 & args13746]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13748
     (com.palletops.awaze.common/aws-client :s3 credentials13745)]
    (clojure.core/case
     (clojure.core/count args13746)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13746 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13748
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
              (clojure.core/nth args13746 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13748
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args13746}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :disable-requester-pays
   [m13749]
   (clojure.core/let
    [credentials13750 (:credentials m13749) args13751 (:args m13749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13752
      (com.palletops.awaze.common/aws-client :s3 credentials13750)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13752
       disableRequesterPays
       (clojure.core/str (clojure.core/nth args13751 0)))))))
  (clojure.core/defn
   disable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for disableRequesterPays"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-requester-pays,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   disable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call disableRequesterPays"}
   [credentials13754 & args13755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13756
     (com.palletops.awaze.common/aws-client :s3 credentials13754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13756
      disableRequesterPays
      (clojure.core/str (clojure.core/nth args13755 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :head-bucket
   [m13757]
   (clojure.core/let
    [credentials13758 (:credentials m13757) args13759 (:args m13757)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13760
      (com.palletops.awaze.common/aws-client :s3 credentials13758)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13760
       headBucket
       (s3/head-bucket-request (clojure.core/nth args13759 0)))))))
  (clojure.core/defn
   head-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for headBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :head-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   head-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call headBucket"}
   [credentials13763 & args13764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13766
     (com.palletops.awaze.common/aws-client :s3 credentials13763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13766
      headBucket
      (s3/head-bucket-request (clojure.core/nth args13764 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m13767]
   (clojure.core/let
    [credentials13768 (:credentials m13767) args13769 (:args m13767)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13770
      (com.palletops.awaze.common/aws-client :s3 credentials13768)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13770
       setS3ClientOptions
       (s3/s3client-options (clojure.core/nth args13769 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-s3client-options,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-s3client-options
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Call setS3ClientOptions"}
   [credentials13772 & args13773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13774
     (com.palletops.awaze.common/aws-client :s3 credentials13772)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13774
      setS3ClientOptions
      (s3/s3client-options (clojure.core/nth args13773 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m13775]
   (clojure.core/let
    [credentials13776 (:credentials m13775) args13777 (:args m13775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13778
      (com.palletops.awaze.common/aws-client :s3 credentials13776)]
     (clojure.core/case
      (clojure.core/count args13777)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
           (clojure.core/nth args13777 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13778
           getBucketNotificationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13777 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13778
               getBucketNotificationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketNotificationConfiguration")
                {:args args13777}))))))))))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   [credentials13781 & args13782]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13784
     (com.palletops.awaze.common/aws-client :s3 credentials13781)]
    (clojure.core/case
     (clojure.core/count args13782)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
          (clojure.core/nth args13782 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13784
          getBucketNotificationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13782 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13784
              getBucketNotificationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketNotificationConfiguration")
               {:args args13782}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m13785]
   (clojure.core/let
    [credentials13786 (:credentials m13785) args13787 (:args m13785)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13788
      (com.palletops.awaze.common/aws-client :s3 credentials13786)]
     (clojure.core/case
      (clojure.core/count args13787)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
           (clojure.core/nth args13787 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13788
           deleteBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13787 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13788
               deleteBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketLifecycleConfiguration")
                {:args args13787}))))))))))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   [credentials13791 & args13792]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13794
     (com.palletops.awaze.common/aws-client :s3 credentials13791)]
    (clojure.core/case
     (clojure.core/count args13792)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
          (clojure.core/nth args13792 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13794
          deleteBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13792 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13794
              deleteBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketLifecycleConfiguration")
               {:args args13792}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m13795]
   (clojure.core/let
    [credentials13796 (:credentials m13795) args13797 (:args m13795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13798
      (com.palletops.awaze.common/aws-client :s3 credentials13796)]
     (clojure.core/case
      (clojure.core/count args13797)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13798
        listObjects
        (clojure.core/str (clojure.core/nth args13797 0))
        (clojure.core/str (clojure.core/nth args13797 1))))
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13797 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13798
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListObjectsRequest
               (clojure.core/nth args13797 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13798
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args13797}))))))))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-objects,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-objects
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials13800 & args13801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13802
     (com.palletops.awaze.common/aws-client :s3 credentials13800)]
    (clojure.core/case
     (clojure.core/count args13801)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13802
       listObjects
       (clojure.core/str (clojure.core/nth args13801 0))
       (clojure.core/str (clojure.core/nth args13801 1))))
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13801 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13802
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListObjectsRequest
              (clojure.core/nth args13801 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13802
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args13801}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m13803]
   (clojure.core/let
    [credentials13804 (:credentials m13803) args13805 (:args m13803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13806
      (com.palletops.awaze.common/aws-client :s3 credentials13804)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13806
       getResourceUrl
       (clojure.core/str (clojure.core/nth args13805 0))
       (clojure.core/str (clojure.core/nth args13805 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getResourceUrl"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-resource-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-resource-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getResourceUrl"}
   [credentials13808 & args13809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13810
     (com.palletops.awaze.common/aws-client :s3 credentials13808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13810
      getResourceUrl
      (clojure.core/str (clojure.core/nth args13809 0))
      (clojure.core/str (clojure.core/nth args13809 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :enable-requester-pays
   [m13811]
   (clojure.core/let
    [credentials13812 (:credentials m13811) args13813 (:args m13811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13814
      (com.palletops.awaze.common/aws-client :s3 credentials13812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13814
       enableRequesterPays
       (clojure.core/str (clojure.core/nth args13813 0)))))))
  (clojure.core/defn
   enable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for enableRequesterPays"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-requester-pays,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   enable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call enableRequesterPays"}
   [credentials13816 & args13817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13818
     (com.palletops.awaze.common/aws-client :s3 credentials13816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13818
      enableRequesterPays
      (clojure.core/str (clojure.core/nth args13817 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m13819]
   (clojure.core/let
    [credentials13820 (:credentials m13819) args13821 (:args m13819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13822
      (com.palletops.awaze.common/aws-client :s3 credentials13820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13822
       abortMultipartUpload
       (s3/abort-multipart-upload-request
        (clojure.core/nth args13821 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials13827 & args13828]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13832
     (com.palletops.awaze.common/aws-client :s3 credentials13827)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13832
      abortMultipartUpload
      (s3/abort-multipart-upload-request
       (clojure.core/nth args13828 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m13833]
   (clojure.core/let
    [credentials13834 (:credentials m13833) args13835 (:args m13833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13836
      (com.palletops.awaze.common/aws-client :s3 credentials13834)]
     (clojure.core/case
      (clojure.core/count args13835)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13836
        getS3AccountOwner
        (s3/get-s3account-owner-request
         (clojure.core/nth args13835 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13836
        getS3AccountOwner))))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getS3AccountOwner, getS3AccountOwner"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-s3account-owner,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-s3account-owner,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getS3AccountOwner, getS3AccountOwner"}
   [credentials13838 & args13839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13840
     (com.palletops.awaze.common/aws-client :s3 credentials13838)]
    (clojure.core/case
     (clojure.core/count args13839)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13840
       getS3AccountOwner
       (s3/get-s3account-owner-request (clojure.core/nth args13839 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13840
       getS3AccountOwner))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m13841]
   (clojure.core/let
    [credentials13842 (:credentials m13841) args13843 (:args m13841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13844
      (com.palletops.awaze.common/aws-client :s3 credentials13842)]
     (clojure.core/case
      (clojure.core/count args13843)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13844
        listBuckets
        (s3/list-buckets-request (clojure.core/nth args13843 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13844
        listBuckets))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-buckets,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-buckets,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-buckets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listBuckets, listBuckets"}
   [credentials13846 & args13847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13848
     (com.palletops.awaze.common/aws-client :s3 credentials13846)]
    (clojure.core/case
     (clojure.core/count args13847)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13848
       listBuckets
       (s3/list-buckets-request (clojure.core/nth args13847 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13848
       listBuckets))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m13849]
   (clojure.core/let
    [credentials13850 (:credentials m13849) args13851 (:args m13849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13852
      (com.palletops.awaze.common/aws-client :s3 credentials13850)]
     (clojure.core/case
      (clojure.core/count args13851)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13851 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13852
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
               (clojure.core/nth args13851 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13852
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args13851}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials13855 & args13856]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13858
     (com.palletops.awaze.common/aws-client :s3 credentials13855)]
    (clojure.core/case
     (clojure.core/count args13856)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13856 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13858
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
              (clojure.core/nth args13856 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13858
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args13856}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m13859]
   (clojure.core/let
    [credentials13860 (:credentials m13859) args13861 (:args m13859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13862
      (com.palletops.awaze.common/aws-client :s3 credentials13860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13862
       listParts
       (s3/list-parts-request (clojure.core/nth args13861 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Call listParts"}
   [credentials13867 & args13868]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13872
     (com.palletops.awaze.common/aws-client :s3 credentials13867)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13872
      listParts
      (s3/list-parts-request (clojure.core/nth args13868 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m13873]
   (clojure.core/let
    [credentials13874 (:credentials m13873) args13875 (:args m13873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13876
      (com.palletops.awaze.common/aws-client :s3 credentials13874)]
     (clojure.core/case
      (clojure.core/count args13875)
      3
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13875 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13875 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13875 2))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13876
           setBucketAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13875 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13875 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13875 2))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13876
               setBucketAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13875}))))))))))
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13875 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13875 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13876
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13875 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13875 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13876
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13875}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13876
        setBucketAcl
        (s3/set-bucket-acl-request (clojure.core/nth args13875 0))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]
                [credentials string-0 canned-access-control-list-1]]),
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]
                [credentials string-0 canned-access-control-list-1]]),
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials13882 & args13883]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13888
     (com.palletops.awaze.common/aws-client :s3 credentials13882)]
    (clojure.core/case
     (clojure.core/count args13883)
     3
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13883 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13883 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13883 2))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13888
          setBucketAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13883 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13883 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13883 2))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13888
              setBucketAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13883}))))))))))
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13883 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13883 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13888
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13883 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13883 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13888
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13883}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13888
       setBucketAcl
       (s3/set-bucket-acl-request (clojure.core/nth args13883 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m13889]
   (clojure.core/let
    [credentials13890 (:credentials m13889) args13891 (:args m13889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13892
      (com.palletops.awaze.common/aws-client :s3 credentials13890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13892
       copyPart
       (s3/copy-part-request (clojure.core/nth args13891 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Generate map for copyPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-part,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Call copyPart"}
   [credentials13894 & args13895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13896
     (com.palletops.awaze.common/aws-client :s3 credentials13894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13896
      copyPart
      (s3/copy-part-request (clojure.core/nth args13895 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-replication-configuration
   [m13897]
   (clojure.core/let
    [credentials13898 (:credentials m13897) args13899 (:args m13897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13900
      (com.palletops.awaze.common/aws-client :s3 credentials13898)]
     (clojure.core/case
      (clojure.core/count args13899)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13899 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13900
           getBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
               (clojure.core/nth args13899 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13900
               getBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketReplicationConfiguration")
                {:args args13899}))))))))))))))
  (clojure.core/defn
   get-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   [credentials13903 & args13904]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13906
     (com.palletops.awaze.common/aws-client :s3 credentials13903)]
    (clojure.core/case
     (clojure.core/count args13904)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13904 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13906
          getBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
              (clojure.core/nth args13904 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13906
              getBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketReplicationConfiguration")
               {:args args13904}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m13907]
   (clojure.core/let
    [credentials13908 (:credentials m13907) args13909 (:args m13907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13910
      (com.palletops.awaze.common/aws-client :s3 credentials13908)]
     (clojure.core/case
      (clojure.core/count args13909)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13909 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13910
           getBucketVersioningConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
               (clojure.core/nth args13909 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13910
               getBucketVersioningConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketVersioningConfiguration")
                {:args args13909}))))))))))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   [credentials13913 & args13914]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13916
     (com.palletops.awaze.common/aws-client :s3 credentials13913)]
    (clojure.core/case
     (clojure.core/count args13914)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13914 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13916
          getBucketVersioningConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
              (clojure.core/nth args13914 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13916
              getBucketVersioningConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketVersioningConfiguration")
               {:args args13914}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m13917]
   (clojure.core/let
    [credentials13918 (:credentials m13917) args13919 (:args m13917)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13920
      (com.palletops.awaze.common/aws-client :s3 credentials13918)]
     (clojure.core/case
      (clojure.core/count args13919)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.VersionListing}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.VersionListing
           (clojure.core/nth args13919 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13920
           listNextBatchOfVersions
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
               (clojure.core/nth args13919 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13920
               listNextBatchOfVersions
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfVersions")
                {:args args13919}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listNextBatchOfVersions, listNextBatchOfVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-versions,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]]),
    :doc "Call listNextBatchOfVersions, listNextBatchOfVersions"}
   [credentials13923 & args13924]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13926
     (com.palletops.awaze.common/aws-client :s3 credentials13923)]
    (clojure.core/case
     (clojure.core/count args13924)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.VersionListing}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.VersionListing
          (clojure.core/nth args13924 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13926
          listNextBatchOfVersions
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
              (clojure.core/nth args13924 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13926
              listNextBatchOfVersions
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfVersions")
               {:args args13924}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m13927]
   (clojure.core/let
    [credentials13928 (:credentials m13927) args13929 (:args m13927)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13930
      (com.palletops.awaze.common/aws-client :s3 credentials13928)]
     (clojure.core/case
      (clojure.core/count args13929)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13929 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13930
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketAclRequest
               (clojure.core/nth args13929 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13930
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args13929}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials13933 & args13934]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13936
     (com.palletops.awaze.common/aws-client :s3 credentials13933)]
    (clojure.core/case
     (clojure.core/count args13934)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13934 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13936
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketAclRequest
              (clojure.core/nth args13934 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13936
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args13934}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m13937]
   (clojure.core/let
    [credentials13938 (:credentials m13937) args13939 (:args m13937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13940
      (com.palletops.awaze.common/aws-client :s3 credentials13938)]
     (clojure.core/case
      (clojure.core/count args13939)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13940
        deleteObject
        (s3/delete-object-request (clojure.core/nth args13939 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13940
        deleteObject
        (clojure.core/str (clojure.core/nth args13939 0))
        (clojure.core/str (clojure.core/nth args13939 1))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-object
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call deleteObject, deleteObject"}
   [credentials13944 & args13945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13948
     (com.palletops.awaze.common/aws-client :s3 credentials13944)]
    (clojure.core/case
     (clojure.core/count args13945)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13948
       deleteObject
       (s3/delete-object-request (clojure.core/nth args13945 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13948
       deleteObject
       (clojure.core/str (clojure.core/nth args13945 0))
       (clojure.core/str (clojure.core/nth args13945 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m13949]
   (clojure.core/let
    [credentials13950 (:credentials m13949) args13951 (:args m13949)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13952
      (com.palletops.awaze.common/aws-client :s3 credentials13950)]
     (clojure.core/case
      (clojure.core/count args13951)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
           (clojure.core/nth args13951 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13952
           deleteBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13951 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13952
               deleteBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketTaggingConfiguration")
                {:args args13951}))))))))))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   [credentials13955 & args13956]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13958
     (com.palletops.awaze.common/aws-client :s3 credentials13955)]
    (clojure.core/case
     (clojure.core/count args13956)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
          (clojure.core/nth args13956 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13958
          deleteBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13956 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13958
              deleteBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketTaggingConfiguration")
               {:args args13956}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m13959]
   (clojure.core/let
    [credentials13960 (:credentials m13959) args13961 (:args m13959)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13962
      (com.palletops.awaze.common/aws-client :s3 credentials13960)]
     (clojure.core/case
      (clojure.core/count args13961)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
           (clojure.core/nth args13961 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13962
           getBucketLoggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13961 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13962
               getBucketLoggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLoggingConfiguration")
                {:args args13961}))))))))))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-logging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   [credentials13965 & args13966]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13968
     (com.palletops.awaze.common/aws-client :s3 credentials13965)]
    (clojure.core/case
     (clojure.core/count args13966)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
          (clojure.core/nth args13966 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13968
          getBucketLoggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13966 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13968
              getBucketLoggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLoggingConfiguration")
               {:args args13966}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m13969]
   (clojure.core/let
    [credentials13970 (:credentials m13969) args13971 (:args m13969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13972
      (com.palletops.awaze.common/aws-client :s3 credentials13970)]
     (clojure.core/case
      (clojure.core/count args13971)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13972
        generatePresignedUrl
        (s3/generate-presigned-url-request
         (clojure.core/nth args13971 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13972
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args13971 0))
        (clojure.core/str (clojure.core/nth args13971 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args13971 2))
        (root/http-method (clojure.core/nth args13971 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13972
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args13971 0))
        (clojure.core/str (clojure.core/nth args13971 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args13971 2))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]
                [credentials string-0 string-1 date-2 http-method-3]
                [credentials string-0 string-1 date-2]]),
    :doc "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]
                [credentials string-0 string-1 date-2 http-method-3]
                [credentials string-0 string-1 date-2]]),
    :doc "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials13976 & args13977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13980
     (com.palletops.awaze.common/aws-client :s3 credentials13976)]
    (clojure.core/case
     (clojure.core/count args13977)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13980
       generatePresignedUrl
       (s3/generate-presigned-url-request
        (clojure.core/nth args13977 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13980
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args13977 0))
       (clojure.core/str (clojure.core/nth args13977 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args13977 2))
       (root/http-method (clojure.core/nth args13977 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13980
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args13977 0))
       (clojure.core/str (clojure.core/nth args13977 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args13977 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :is-requester-pays-enabled
   [m13981]
   (clojure.core/let
    [credentials13982 (:credentials m13981) args13983 (:args m13981)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13984
      (com.palletops.awaze.common/aws-client :s3 credentials13982)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13984
       isRequesterPaysEnabled
       (clojure.core/str (clojure.core/nth args13983 0)))))))
  (clojure.core/defn
   is-requester-pays-enabled-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for isRequesterPaysEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :is-requester-pays-enabled,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   is-requester-pays-enabled
   {:arglists (quote [[credentials string-0]]),
    :doc "Call isRequesterPaysEnabled"}
   [credentials13986 & args13987]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13988
     (com.palletops.awaze.common/aws-client :s3 credentials13986)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13988
      isRequesterPaysEnabled
      (clojure.core/str (clojure.core/nth args13987 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m13989]
   (clojure.core/let
    [credentials13990 (:credentials m13989) args13991 (:args m13989)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13992
      (com.palletops.awaze.common/aws-client :s3 credentials13990)]
     (clojure.core/case
      (clojure.core/count args13991)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13992
        copyObject
        (clojure.core/str (clojure.core/nth args13991 0))
        (clojure.core/str (clojure.core/nth args13991 1))
        (clojure.core/str (clojure.core/nth args13991 2))
        (clojure.core/str (clojure.core/nth args13991 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13992
        copyObject
        (s3/copy-object-request (clojure.core/nth args13991 0))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]]),
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :copy-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-object
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]]),
    :doc "Call copyObject, copyObject"}
   [credentials13998 & args13999]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14004
     (com.palletops.awaze.common/aws-client :s3 credentials13998)]
    (clojure.core/case
     (clojure.core/count args13999)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14004
       copyObject
       (clojure.core/str (clojure.core/nth args13999 0))
       (clojure.core/str (clojure.core/nth args13999 1))
       (clojure.core/str (clojure.core/nth args13999 2))
       (clojure.core/str (clojure.core/nth args13999 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14004
       copyObject
       (s3/copy-object-request (clojure.core/nth args13999 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m14005]
   (clojure.core/let
    [credentials14006 (:credentials m14005) args14007 (:args m14005)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14008
      (com.palletops.awaze.common/aws-client :s3 credentials14006)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14008
       deleteObjects
       (s3/delete-objects-request (clojure.core/nth args14007 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for deleteObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call deleteObjects"}
   [credentials14011 & args14012]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14014
     (com.palletops.awaze.common/aws-client :s3 credentials14011)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14014
      deleteObjects
      (s3/delete-objects-request (clojure.core/nth args14012 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m14015]
   (clojure.core/let
    [credentials14016 (:credentials m14015) args14017 (:args m14015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14018
      (com.palletops.awaze.common/aws-client :s3 credentials14016)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14018
       setBucketVersioningConfiguration
       (s3/set-bucket-versioning-configuration-request
        (clojure.core/nth args14017 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketVersioningConfiguration"}
   [credentials14022 & args14023]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14026
     (com.palletops.awaze.common/aws-client :s3 credentials14022)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14026
      setBucketVersioningConfiguration
      (s3/set-bucket-versioning-configuration-request
       (clojure.core/nth args14023 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m14027]
   (clojure.core/let
    [credentials14028 (:credentials m14027) args14029 (:args m14027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14030
      (com.palletops.awaze.common/aws-client :s3 credentials14028)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14030
       setBucketLoggingConfiguration
       (s3/set-bucket-logging-configuration-request
        (clojure.core/nth args14029 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-logging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketLoggingConfiguration"}
   [credentials14034 & args14035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14038
     (com.palletops.awaze.common/aws-client :s3 credentials14034)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14038
      setBucketLoggingConfiguration
      (s3/set-bucket-logging-configuration-request
       (clojure.core/nth args14035 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m14039]
   (clojure.core/let
    [credentials14040 (:credentials m14039) args14041 (:args m14039)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14042
      (com.palletops.awaze.common/aws-client :s3 credentials14040)]
     (clojure.core/case
      (clojure.core/count args14041)
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetObjectRequest
           (clojure.core/nth args14041 0))
^{:tag java.io.File}
b
          (com.palletops.awaze.common/coerce-value-form
           java.io.File
           (clojure.core/nth args14041 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14042
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14041 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14041 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14042
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args14041}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14042
        getObject
        (s3/get-object-request (clojure.core/nth args14041 0))))))))
  (clojure.core/defn
   get-object-map
   {:arglists (quote
               [[credentials {:keys []} file-1]
                [credentials string-0 string-1]
                [credentials {:keys []}]]),
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object
   {:arglists (quote
               [[credentials {:keys []} file-1]
                [credentials string-0 string-1]
                [credentials {:keys []}]]),
    :doc "Call getObject, getObject, getObject"}
   [credentials14048 & args14049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14054
     (com.palletops.awaze.common/aws-client :s3 credentials14048)]
    (clojure.core/case
     (clojure.core/count args14049)
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetObjectRequest
          (clojure.core/nth args14049 0))
^{:tag java.io.File}
b
         (com.palletops.awaze.common/coerce-value-form
          java.io.File
          (clojure.core/nth args14049 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14054
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14049 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14049 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14054
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args14049}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14054
       getObject
       (s3/get-object-request (clojure.core/nth args14049 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m14055]
   (clojure.core/let
    [credentials14056 (:credentials m14055) args14057 (:args m14055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14058
      (com.palletops.awaze.common/aws-client :s3 credentials14056)]
     (clojure.core/case
      (clojure.core/count args14057)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14057 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14058
           deleteBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
               (clojure.core/nth args14057 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14058
               deleteBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketCrossOriginConfiguration")
                {:args args14057}))))))))))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   [credentials14061 & args14062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14064
     (com.palletops.awaze.common/aws-client :s3 credentials14061)]
    (clojure.core/case
     (clojure.core/count args14062)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14062 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14064
          deleteBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
              (clojure.core/nth args14062 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14064
              deleteBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketCrossOriginConfiguration")
               {:args args14062}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m14065]
   (clojure.core/let
    [credentials14066 (:credentials m14065) args14067 (:args m14065)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14068
      (com.palletops.awaze.common/aws-client :s3 credentials14066)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14068
       completeMultipartUpload
       (s3/complete-multipart-upload-request
        (clojure.core/nth args14067 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials14070 & args14071]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14072
     (com.palletops.awaze.common/aws-client :s3 credentials14070)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14072
      completeMultipartUpload
      (s3/complete-multipart-upload-request
       (clojure.core/nth args14071 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m14073]
   (clojure.core/let
    [credentials14074 (:credentials m14073) args14075 (:args m14073)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14076
      (com.palletops.awaze.common/aws-client :s3 credentials14074)]
     (clojure.core/case
      (clojure.core/count args14075)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14076
        restoreObject
        (s3/restore-object-request (clojure.core/nth args14075 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14076
        restoreObject
        (clojure.core/str (clojure.core/nth args14075 0))
        (clojure.core/str (clojure.core/nth args14075 1))
        (clojure.core/int (clojure.core/nth args14075 2))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :restore-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   restore-object
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Call restoreObject, restoreObject"}
   [credentials14080 & args14081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14084
     (com.palletops.awaze.common/aws-client :s3 credentials14080)]
    (clojure.core/case
     (clojure.core/count args14081)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14084
       restoreObject
       (s3/restore-object-request (clojure.core/nth args14081 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14084
       restoreObject
       (clojure.core/str (clojure.core/nth args14081 0))
       (clojure.core/str (clojure.core/nth args14081 1))
       (clojure.core/int (clojure.core/nth args14081 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m14085]
   (clojure.core/let
    [credentials14086 (:credentials m14085) args14087 (:args m14085)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14088
      (com.palletops.awaze.common/aws-client :s3 credentials14086)]
     (clojure.core/case
      (clojure.core/count args14087)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketPolicyRequest
           (clojure.core/nth args14087 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14088
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14087 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14088
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args14087}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials14091 & args14092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14094
     (com.palletops.awaze.common/aws-client :s3 credentials14091)]
    (clojure.core/case
     (clojure.core/count args14092)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketPolicyRequest
          (clojure.core/nth args14092 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14094
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14092 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14094
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args14092}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-replication-configuration
   [m14095]
   (clojure.core/let
    [credentials14096 (:credentials m14095) args14097 (:args m14095)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14098
      (com.palletops.awaze.common/aws-client :s3 credentials14096)]
     (clojure.core/case
      (clojure.core/count args14097)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14098
        setBucketReplicationConfiguration
        (s3/set-bucket-replication-configuration-request
         (clojure.core/nth args14097 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14098
        setBucketReplicationConfiguration
        (clojure.core/str (clojure.core/nth args14097 0))
        (s3/bucket-replication-configuration
         (clojure.core/nth args14097 1))))))))
  (clojure.core/defn
   set-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [role-arn rules]}]]),
    :doc "Generate map for setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-replication-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [role-arn rules]}]]),
    :doc "Call setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   [credentials14100 & args14101]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14102
     (com.palletops.awaze.common/aws-client :s3 credentials14100)]
    (clojure.core/case
     (clojure.core/count args14101)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14102
       setBucketReplicationConfiguration
       (s3/set-bucket-replication-configuration-request
        (clojure.core/nth args14101 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14102
       setBucketReplicationConfiguration
       (clojure.core/str (clojure.core/nth args14101 0))
       (s3/bucket-replication-configuration
        (clojure.core/nth args14101 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m14103]
   (clojure.core/let
    [credentials14104 (:credentials m14103) args14105 (:args m14103)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14106
      (com.palletops.awaze.common/aws-client :s3 credentials14104)]
     (clojure.core/case
      (clojure.core/count args14105)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CreateBucketRequest
           (clojure.core/nth args14105 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14106
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14105 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14106
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14105}))))))))))
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14105 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.Region
           (clojure.core/nth args14105 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14106
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14105 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14105 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14106
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14105}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials string-0]
                [credentials string-0 region-1]
                [credentials string-0 string-1]]),
    :doc "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-bucket,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :create-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   create-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials string-0]
                [credentials string-0 region-1]
                [credentials string-0 string-1]]),
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials14109 & args14110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14112
     (com.palletops.awaze.common/aws-client :s3 credentials14109)]
    (clojure.core/case
     (clojure.core/count args14110)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CreateBucketRequest
          (clojure.core/nth args14110 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14112
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14110 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14112
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14110}))))))))))
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14110 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.Region
          (clojure.core/nth args14110 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14112
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14110 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14110 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14112
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14110}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m14113]
   (clojure.core/let
    [credentials14114 (:credentials m14113) args14115 (:args m14113)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14116
      (com.palletops.awaze.common/aws-client :s3 credentials14114)]
     (clojure.core/case
      (clojure.core/count args14115)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14116
        deleteVersion
        (clojure.core/str (clojure.core/nth args14115 0))
        (clojure.core/str (clojure.core/nth args14115 1))
        (clojure.core/str (clojure.core/nth args14115 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14116
        deleteVersion
        (s3/delete-version-request (clojure.core/nth args14115 0))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-version,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :delete-version,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-version
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVersion, deleteVersion"}
   [credentials14121 & args14122]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14126
     (com.palletops.awaze.common/aws-client :s3 credentials14121)]
    (clojure.core/case
     (clojure.core/count args14122)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14126
       deleteVersion
       (clojure.core/str (clojure.core/nth args14122 0))
       (clojure.core/str (clojure.core/nth args14122 1))
       (clojure.core/str (clojure.core/nth args14122 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14126
       deleteVersion
       (s3/delete-version-request (clojure.core/nth args14122 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m14127]
   (clojure.core/let
    [credentials14128 (:credentials m14127) args14129 (:args m14127)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14130
      (com.palletops.awaze.common/aws-client :s3 credentials14128)]
     (clojure.core/case
      (clojure.core/count args14129)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
        putObject
        (s3/put-object-request (clojure.core/nth args14129 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
        putObject
        (clojure.core/str (clojure.core/nth args14129 0))
        (clojure.core/str (clojure.core/nth args14129 1))
        (clojure.java.io/input-stream (clojure.core/nth args14129 2))
        (s3/object-metadata (clojure.core/nth args14129 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
        putObject
        (clojure.core/str (clojure.core/nth args14129 0))
        (clojure.core/str (clojure.core/nth args14129 1))
        (clojure.java.io/file (clojure.core/nth args14129 2))))))))
  (clojure.core/defn
   put-object-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   put-object
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Call putObject, putObject, putObject"}
   [credentials14138 & args14139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14146
     (com.palletops.awaze.common/aws-client :s3 credentials14138)]
    (clojure.core/case
     (clojure.core/count args14139)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14146
       putObject
       (s3/put-object-request (clojure.core/nth args14139 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14146
       putObject
       (clojure.core/str (clojure.core/nth args14139 0))
       (clojure.core/str (clojure.core/nth args14139 1))
       (clojure.java.io/input-stream (clojure.core/nth args14139 2))
       (s3/object-metadata (clojure.core/nth args14139 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14146
       putObject
       (clojure.core/str (clojure.core/nth args14139 0))
       (clojure.core/str (clojure.core/nth args14139 1))
       (clojure.java.io/file (clojure.core/nth args14139 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m14147]
   (clojure.core/let
    [credentials14148 (:credentials m14147) args14149 (:args m14147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14150
      (com.palletops.awaze.common/aws-client :s3 credentials14148)]
     (clojure.core/case
      (clojure.core/count args14149)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14150
        listVersions
        (s3/list-versions-request (clojure.core/nth args14149 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14150
        listVersions
        (clojure.core/str (clojure.core/nth args14149 0))
        (clojure.core/str (clojure.core/nth args14149 1))))
      6
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14150
        listVersions
        (clojure.core/str (clojure.core/nth args14149 0))
        (clojure.core/str (clojure.core/nth args14149 1))
        (clojure.core/str (clojure.core/nth args14149 2))
        (clojure.core/str (clojure.core/nth args14149 3))
        (clojure.core/str (clojure.core/nth args14149 4))
        (clojure.core/int (clojure.core/nth args14149 5))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]
                [credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]]),
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d e f]
    {:args [a b c d e f],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]
                [credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]]),
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials14152 & args14153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14154
     (com.palletops.awaze.common/aws-client :s3 credentials14152)]
    (clojure.core/case
     (clojure.core/count args14153)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14154
       listVersions
       (s3/list-versions-request (clojure.core/nth args14153 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14154
       listVersions
       (clojure.core/str (clojure.core/nth args14153 0))
       (clojure.core/str (clojure.core/nth args14153 1))))
     6
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14154
       listVersions
       (clojure.core/str (clojure.core/nth args14153 0))
       (clojure.core/str (clojure.core/nth args14153 1))
       (clojure.core/str (clojure.core/nth args14153 2))
       (clojure.core/str (clojure.core/nth args14153 3))
       (clojure.core/str (clojure.core/nth args14153 4))
       (clojure.core/int (clojure.core/nth args14153 5))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m14155]
   (clojure.core/let
    [credentials14156 (:credentials m14155) args14157 (:args m14155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14158
      (com.palletops.awaze.common/aws-client :s3 credentials14156)]
     (clojure.core/case
      (clojure.core/count args14157)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14158
        setBucketTaggingConfiguration
        (clojure.core/str (clojure.core/nth args14157 0))
        (s3/bucket-tagging-configuration
         (clojure.core/nth args14157 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14158
        setBucketTaggingConfiguration
        (s3/set-bucket-tagging-configuration-request
         (clojure.core/nth args14157 0))))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys []}]
                [credentials {:keys []}]]),
    :doc "Generate map for setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists (quote
               [[credentials string-0 {:keys []}]
                [credentials {:keys []}]]),
    :doc "Call setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   [credentials14162 & args14163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14166
     (com.palletops.awaze.common/aws-client :s3 credentials14162)]
    (clojure.core/case
     (clojure.core/count args14163)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14166
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args14163 0))
       (s3/bucket-tagging-configuration
        (clojure.core/nth args14163 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14166
       setBucketTaggingConfiguration
       (s3/set-bucket-tagging-configuration-request
        (clojure.core/nth args14163 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m14167]
   (clojure.core/let
    [credentials14168 (:credentials m14167) args14169 (:args m14167)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14170
      (com.palletops.awaze.common/aws-client :s3 credentials14168)]
     (clojure.core/case
      (clojure.core/count args14169)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
           (clojure.core/nth args14169 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14170
           getBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14169 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14170
               getBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketCrossOriginConfiguration")
                {:args args14169}))))))))))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   [credentials14173 & args14174]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14176
     (com.palletops.awaze.common/aws-client :s3 credentials14173)]
    (clojure.core/case
     (clojure.core/count args14174)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
          (clojure.core/nth args14174 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14176
          getBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14174 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14176
              getBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketCrossOriginConfiguration")
               {:args args14174}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m14177]
   (clojure.core/let
    [credentials14178 (:credentials m14177) args14179 (:args m14177)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14180
      (com.palletops.awaze.common/aws-client :s3 credentials14178)]
     (clojure.core/case
      (clojure.core/count args14179)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14180
        setBucketPolicy
        (s3/set-bucket-policy-request (clojure.core/nth args14179 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14180
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args14179 0))
        (clojure.core/str (clojure.core/nth args14179 1))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials14184 & args14185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14188
     (com.palletops.awaze.common/aws-client :s3 credentials14184)]
    (clojure.core/case
     (clojure.core/count args14185)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14188
       setBucketPolicy
       (s3/set-bucket-policy-request (clojure.core/nth args14185 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14188
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args14185 0))
       (clojure.core/str (clojure.core/nth args14185 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m14189]
   (clojure.core/let
    [credentials14190 (:credentials m14189) args14191 (:args m14189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14192
      (com.palletops.awaze.common/aws-client :s3 credentials14190)]
     (clojure.core/case
      (clojure.core/count args14191)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ObjectListing}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ObjectListing
           (clojure.core/nth args14191 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14192
           listNextBatchOfObjects
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
               (clojure.core/nth args14191 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14192
               listNextBatchOfObjects
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfObjects")
                {:args args14191}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listNextBatchOfObjects, listNextBatchOfObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listNextBatchOfObjects, listNextBatchOfObjects"}
   [credentials14195 & args14196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14198
     (com.palletops.awaze.common/aws-client :s3 credentials14195)]
    (clojure.core/case
     (clojure.core/count args14196)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ObjectListing}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ObjectListing
          (clojure.core/nth args14196 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14198
          listNextBatchOfObjects
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
              (clojure.core/nth args14196 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14198
              listNextBatchOfObjects
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfObjects")
               {:args args14196}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m14199]
   (clojure.core/let
    [credentials14200 (:credentials m14199) args14201 (:args m14199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14202
      (com.palletops.awaze.common/aws-client :s3 credentials14200)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14202
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args14201 0))
       (clojure.core/str (clojure.core/nth args14201 1))
       (s3/storage-class (clojure.core/nth args14201 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :change-object-storage-class,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Call changeObjectStorageClass"}
   [credentials14204 & args14205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14206
     (com.palletops.awaze.common/aws-client :s3 credentials14204)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14206
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args14205 0))
      (clojure.core/str (clojure.core/nth args14205 1))
      (s3/storage-class (clojure.core/nth args14205 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m14207]
   (clojure.core/let
    [credentials14208 (:credentials m14207) args14209 (:args m14207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14210
      (com.palletops.awaze.common/aws-client :s3 credentials14208)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14210
       initiateMultipartUpload
       (s3/initiate-multipart-upload-request
        (clojure.core/nth args14209 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials14214 & args14215]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14218
     (com.palletops.awaze.common/aws-client :s3 credentials14214)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14218
      initiateMultipartUpload
      (s3/initiate-multipart-upload-request
       (clojure.core/nth args14215 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-region
   [m14219]
   (clojure.core/let
    [credentials14220 (:credentials m14219) args14221 (:args m14219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14222
      (com.palletops.awaze.common/aws-client :s3 credentials14220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14222
       setRegion
       (regions/region (clojure.core/nth args14221 0)))))))
  (clojure.core/defn
   set-region-map
   {:arglists (quote [[credentials region-0]]),
    :doc "Generate map for setRegion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-region,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-region
   {:arglists (quote [[credentials region-0]]), :doc "Call setRegion"}
   [credentials14224 & args14225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14226
     (com.palletops.awaze.common/aws-client :s3 credentials14224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14226
      setRegion
      (regions/region (clojure.core/nth args14225 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m14227]
   (clojure.core/let
    [credentials14228 (:credentials m14227) args14229 (:args m14227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14230
      (com.palletops.awaze.common/aws-client :s3 credentials14228)]
     (clojure.core/case
      (clojure.core/count args14229)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14229 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14230
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketRequest
               (clojure.core/nth args14229 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14230
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args14229}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteBucket, deleteBucket"}
   [credentials14233 & args14234]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14236
     (com.palletops.awaze.common/aws-client :s3 credentials14233)]
    (clojure.core/case
     (clojure.core/count args14234)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14234 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14236
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketRequest
              (clojure.core/nth args14234 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14236
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args14234}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m14237]
   (clojure.core/let
    [credentials14238 (:credentials m14237) args14239 (:args m14237)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14240
      (com.palletops.awaze.common/aws-client :s3 credentials14238)]
     (clojure.core/case
      (clojure.core/count args14239)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
           (clojure.core/nth args14239 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14240
           getBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14239 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14240
               getBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketTaggingConfiguration")
                {:args args14239}))))))))))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   [credentials14243 & args14244]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14246
     (com.palletops.awaze.common/aws-client :s3 credentials14243)]
    (clojure.core/case
     (clojure.core/count args14244)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
          (clojure.core/nth args14244 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14246
          getBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14244 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14246
              getBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketTaggingConfiguration")
               {:args args14244}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m14247]
   (clojure.core/let
    [credentials14248 (:credentials m14247) args14249 (:args m14247)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14250
      (com.palletops.awaze.common/aws-client :s3 credentials14248)]
     (clojure.core/case
      (clojure.core/count args14249)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14249 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14250
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLocationRequest
               (clojure.core/nth args14249 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14250
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args14249}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-location,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-location
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials14253 & args14254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14256
     (com.palletops.awaze.common/aws-client :s3 credentials14253)]
    (clojure.core/case
     (clojure.core/count args14254)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14254 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14256
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLocationRequest
              (clojure.core/nth args14254 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14256
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args14254}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m14257]
   (clojure.core/let
    [credentials14258 (:credentials m14257) args14259 (:args m14257)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14260
      (com.palletops.awaze.common/aws-client :s3 credentials14258)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14260
       doesBucketExist
       (clojure.core/str (clojure.core/nth args14259 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for doesBucketExist"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :does-bucket-exist,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists (quote [[credentials string-0]]),
    :doc "Call doesBucketExist"}
   [credentials14262 & args14263]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14264
     (com.palletops.awaze.common/aws-client :s3 credentials14262)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14264
      doesBucketExist
      (clojure.core/str (clojure.core/nth args14263 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m14265]
   (clojure.core/let
    [credentials14266 (:credentials m14265) args14267 (:args m14265)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14268
      (com.palletops.awaze.common/aws-client :s3 credentials14266)]
     (clojure.core/case
      (clojure.core/count args14267)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14268
        getObjectAcl
        (s3/get-object-acl-request (clojure.core/nth args14267 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14268
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14267 0))
        (clojure.core/str (clojure.core/nth args14267 1))
        (clojure.core/str (clojure.core/nth args14267 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14268
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14267 0))
        (clojure.core/str (clojure.core/nth args14267 1))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectAcl, getObjectAcl, getObjectAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Call getObjectAcl, getObjectAcl, getObjectAcl"}
   [credentials14272 & args14273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14276
     (com.palletops.awaze.common/aws-client :s3 credentials14272)]
    (clojure.core/case
     (clojure.core/count args14273)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14276
       getObjectAcl
       (s3/get-object-acl-request (clojure.core/nth args14273 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14276
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14273 0))
       (clojure.core/str (clojure.core/nth args14273 1))
       (clojure.core/str (clojure.core/nth args14273 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14276
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14273 0))
       (clojure.core/str (clojure.core/nth args14273 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m14277]
   (clojure.core/let
    [credentials14278 (:credentials m14277) args14279 (:args m14277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14280
      (com.palletops.awaze.common/aws-client :s3 credentials14278)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14280
       uploadPart
       (s3/upload-part-request (clojure.core/nth args14279 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for uploadPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-part,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   upload-part
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Call uploadPart"}
   [credentials14282 & args14283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14284
     (com.palletops.awaze.common/aws-client :s3 credentials14282)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14284
      uploadPart
      (s3/upload-part-request (clojure.core/nth args14283 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m14285]
   (clojure.core/let
    [credentials14286 (:credentials m14285) args14287 (:args m14285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14288
      (com.palletops.awaze.common/aws-client :s3 credentials14286)]
     (clojure.core/case
      (clojure.core/count args14287)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14288
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args14287 0))
        (s3/bucket-website-configuration
         (clojure.core/nth args14287 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14288
        setBucketWebsiteConfiguration
        (s3/set-bucket-website-configuration-request
         (clojure.core/nth args14287 0))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials14292 & args14293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14296
     (com.palletops.awaze.common/aws-client :s3 credentials14292)]
    (clojure.core/case
     (clojure.core/count args14293)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14296
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args14293 0))
       (s3/bucket-website-configuration
        (clojure.core/nth args14293 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14296
       setBucketWebsiteConfiguration
       (s3/set-bucket-website-configuration-request
        (clojure.core/nth args14293 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m14297]
   (clojure.core/let
    [credentials14298 (:credentials m14297) args14299 (:args m14297)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14300
      (com.palletops.awaze.common/aws-client :s3 credentials14298)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14300
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getRegion"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-region,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-region
   {:arglists (quote [[credentials]]), :doc "Call getRegion"}
   [credentials14302 & args14303]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14304
     (com.palletops.awaze.common/aws-client :s3 credentials14302)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14304
      getRegion))))))
