(ns
 com.palletops.awaze.route53
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.route53 :as route53]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AliasTarget}
alias-target
  [m11154]
  (clojure.core/let
   [bean11153 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/let
    [v11155
     (:evaluate-target-health
      m11154
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11155 :com.palletops.awaze.client-builder/undef)
     (.
      bean11153
      setEvaluateTargetHealth
      (clojure.core/boolean v11155))))
   (clojure.core/let
    [v11155
     (:dnsname m11154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11155 :com.palletops.awaze.client-builder/undef)
     (. bean11153 setDNSName (clojure.core/str v11155))))
   (clojure.core/let
    [v11155
     (:hosted-zone-id
      m11154
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11155 :com.palletops.awaze.client-builder/undef)
     (. bean11153 setHostedZoneId (clojure.core/str v11155))))
   bean11153))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSetFailover}
resource-record-set-failover
  [m11157]
  (.
   com.amazonaws.services.route53.model.ResourceRecordSetFailover
   fromValue
   (clojure.core/name m11157)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecord}
resource-record
  [m11160]
  (clojure.core/let
   [bean11159
    (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/let
    [v11161 (:value m11160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11161 :com.palletops.awaze.client-builder/undef)
     (. bean11159 setValue (clojure.core/str v11161))))
   bean11159))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GeoLocation}
geo-location
  [m11163]
  (clojure.core/let
   [bean11162 (new com.amazonaws.services.route53.model.GeoLocation)]
   (clojure.core/let
    [v11164
     (:continent-code
      m11163
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11164 :com.palletops.awaze.client-builder/undef)
     (. bean11162 setContinentCode (clojure.core/str v11164))))
   (clojure.core/let
    [v11164
     (:country-code m11163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11164 :com.palletops.awaze.client-builder/undef)
     (. bean11162 setCountryCode (clojure.core/str v11164))))
   (clojure.core/let
    [v11164
     (:subdivision-code
      m11163
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11164 :com.palletops.awaze.client-builder/undef)
     (. bean11162 setSubdivisionCode (clojure.core/str v11164))))
   bean11162))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSet}
resource-record-set
  [m11166]
  (clojure.core/let
   [bean11165
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/let
    [v11167
     (:alias-target m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setAliasTarget (route53/alias-target v11167))))
   (clojure.core/let
    [v11167
     (:region m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setRegion (clojure.core/str v11167))))
   (clojure.core/let
    [v11167
     (:failover m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (.
      bean11165
      setFailover
      (route53/resource-record-set-failover v11167))))
   (clojure.core/let
    [v11167
     (:set-identifier
      m11166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setSetIdentifier (clojure.core/str v11167))))
   (clojure.core/let
    [v11167
     (:traffic-policy-instance-id
      m11166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (.
      bean11165
      setTrafficPolicyInstanceId
      (clojure.core/str v11167))))
   (clojure.core/let
    [v11167 (:type m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setType (clojure.core/str v11167))))
   (clojure.core/let
    [v11167 (:name m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setName (clojure.core/str v11167))))
   (clojure.core/let
    [v11167
     (:weight m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setWeight (clojure.core/long v11167))))
   (clojure.core/let
    [v11167 (:ttl m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setTTL (clojure.core/long v11167))))
   (clojure.core/let
    [v11167
     (:health-check-id
      m11166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setHealthCheckId (clojure.core/str v11167))))
   (clojure.core/let
    [v11167
     (:resource-records
      m11166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (.
      bean11165
      setResourceRecords
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11339] (route53/resource-record arg11339))
 v11167))))
   (clojure.core/let
    [v11167
     (:geo-location m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setGeoLocation (route53/geo-location v11167))))
   bean11165))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Change}
change
  [m11169]
  (clojure.core/let
   [bean11168 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/let
    [v11170
     (:resource-record-set
      m11169
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11170 :com.palletops.awaze.client-builder/undef)
     (.
      bean11168
      setResourceRecordSet
      (route53/resource-record-set v11170))))
   (clojure.core/let
    [v11170
     (:action m11169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11170 :com.palletops.awaze.client-builder/undef)
     (. bean11168 setAction (clojure.core/str v11170))))
   bean11168))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPCRegion}
vpcregion
  [m11172]
  (.
   com.amazonaws.services.route53.model.VPCRegion
   fromValue
   (clojure.core/name m11172)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeBatch}
change-batch
  [m11175]
  (clojure.core/let
   [bean11174 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/let
    [v11176
     (:comment m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setComment (clojure.core/str v11176))))
   (clojure.core/let
    [v11176
     (:changes m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (.
      bean11174
      setChanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11340] (route53/change arg11340))
 v11176))))
   bean11174))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.RRType}
rrtype
  [m11178]
  (.
   com.amazonaws.services.route53.model.RRType
   fromValue
   (clojure.core/name m11178)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPC}
vpc
  [m11181]
  (clojure.core/let
   [bean11180 (new com.amazonaws.services.route53.model.VPC)]
   (clojure.core/let
    [v11182
     (:vpcregion m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setVPCRegion (route53/vpcregion v11182))))
   (clojure.core/let
    [v11182 (:vpcid m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setVPCId (clojure.core/str v11182))))
   bean11180))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.TagResourceType}
tag-resource-type
  [m11184]
  (.
   com.amazonaws.services.route53.model.TagResourceType
   fromValue
   (clojure.core/name m11184)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HostedZoneConfig}
hosted-zone-config
  [m11187]
  (clojure.core/let
   [bean11186
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/let
    [v11188
     (:comment m11187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11188 :com.palletops.awaze.client-builder/undef)
     (. bean11186 setComment (clojure.core/str v11188))))
   (clojure.core/let
    [v11188
     (:private-zone m11187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11188 :com.palletops.awaze.client-builder/undef)
     (. bean11186 setPrivateZone (clojure.core/boolean v11188))))
   bean11186))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckConfig}
health-check-config
  [m11190]
  (clojure.core/let
   [bean11189
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/let
    [v11191
     (:inverted m11190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setInverted (clojure.core/boolean v11191))))
   (clojure.core/let
    [v11191 (:type m11190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setType (clojure.core/str v11191))))
   (clojure.core/let
    [v11191
     (:resource-path m11190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setResourcePath (clojure.core/str v11191))))
   (clojure.core/let
    [v11191
     (:search-string m11190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setSearchString (clojure.core/str v11191))))
   (clojure.core/let
    [v11191
     (:child-health-checks
      m11190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (.
      bean11189
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11341] (clojure.core/str arg11341))
 v11191))))
   (clojure.core/let
    [v11191 (:port m11190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setPort (clojure.core/int v11191))))
   (clojure.core/let
    [v11191
     (:health-threshold
      m11190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setHealthThreshold (clojure.core/int v11191))))
   (clojure.core/let
    [v11191
     (:request-interval
      m11190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setRequestInterval (clojure.core/int v11191))))
   (clojure.core/let
    [v11191
     (:ipaddress m11190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setIPAddress (clojure.core/str v11191))))
   (clojure.core/let
    [v11191
     (:fully-qualified-domain-name
      m11190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (.
      bean11189
      setFullyQualifiedDomainName
      (clojure.core/str v11191))))
   (clojure.core/let
    [v11191
     (:enable-sni m11190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setEnableSNI (clojure.core/boolean v11191))))
   (clojure.core/let
    [v11191
     (:measure-latency
      m11190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setMeasureLatency (clojure.core/boolean v11191))))
   (clojure.core/let
    [v11191
     (:failure-threshold
      m11190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setFailureThreshold (clojure.core/int v11191))))
   bean11189))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Tag}
tag
  [m11193]
  (clojure.core/let
   [bean11192 (new com.amazonaws.services.route53.model.Tag)]
   (clojure.core/let
    [v11194 (:key m11193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (. bean11192 setKey (clojure.core/str v11194))))
   (clojure.core/let
    [v11194 (:value m11193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (. bean11192 setValue (clojure.core/str v11194))))
   bean11192))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest}
create-traffic-policy-version-request
  [m11196]
  (clojure.core/let
   [bean11195
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest)]
   (clojure.core/let
    [v11197
     (:comment m11196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11197 :com.palletops.awaze.client-builder/undef)
     (. bean11195 setComment (clojure.core/str v11197))))
   (clojure.core/let
    [v11197
     (:document m11196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11197 :com.palletops.awaze.client-builder/undef)
     (. bean11195 setDocument (clojure.core/str v11197))))
   (clojure.core/let
    [v11197 (:id m11196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11197 :com.palletops.awaze.client-builder/undef)
     (. bean11195 setId (clojure.core/str v11197))))
   bean11195))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest}
delete-traffic-policy-request
  [m11199]
  (clojure.core/let
   [bean11198
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest)]
   (clojure.core/let
    [v11200
     (:version m11199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11200 :com.palletops.awaze.client-builder/undef)
     (. bean11198 setVersion (clojure.core/int v11200))))
   (clojure.core/let
    [v11200 (:id m11199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11200 :com.palletops.awaze.client-builder/undef)
     (. bean11198 setId (clojure.core/str v11200))))
   bean11198))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest}
change-resource-record-sets-request
  [m11202]
  (clojure.core/let
   [bean11201
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/let
    [v11203
     (:change-batch m11202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11203 :com.palletops.awaze.client-builder/undef)
     (. bean11201 setChangeBatch (route53/change-batch v11203))))
   (clojure.core/let
    [v11203
     (:hosted-zone-id
      m11202
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11203 :com.palletops.awaze.client-builder/undef)
     (. bean11201 setHostedZoneId (clojure.core/str v11203))))
   bean11201))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPoliciesRequest}
list-traffic-policies-request
  [m11205]
  (clojure.core/let
   [bean11204
    (new
     com.amazonaws.services.route53.model.ListTrafficPoliciesRequest)]
   (clojure.core/let
    [v11206
     (:traffic-policy-id-marker
      m11205
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setTrafficPolicyIdMarker (clojure.core/str v11206))))
   (clojure.core/let
    [v11206
     (:max-items m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setMaxItems (clojure.core/str v11206))))
   bean11204))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest}
list-traffic-policy-instances-by-policy-request
  [m11208]
  (clojure.core/let
   [bean11207
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest)]
   (clojure.core/let
    [v11209
     (:traffic-policy-id
      m11208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (. bean11207 setTrafficPolicyId (clojure.core/str v11209))))
   (clojure.core/let
    [v11209
     (:traffic-policy-version
      m11208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (. bean11207 setTrafficPolicyVersion (clojure.core/int v11209))))
   (clojure.core/let
    [v11209
     (:traffic-policy-instance-name-marker
      m11208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (.
      bean11207
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11209))))
   (clojure.core/let
    [v11209
     (:traffic-policy-instance-type-marker
      m11208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (.
      bean11207
      setTrafficPolicyInstanceTypeMarker
      (route53/rrtype v11209))))
   (clojure.core/let
    [v11209
     (:hosted-zone-id-marker
      m11208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (. bean11207 setHostedZoneIdMarker (clojure.core/str v11209))))
   (clojure.core/let
    [v11209
     (:max-items m11208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (. bean11207 setMaxItems (clojure.core/str v11209))))
   bean11207))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest}
list-traffic-policy-versions-request
  [m11211]
  (clojure.core/let
   [bean11210
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest)]
   (clojure.core/let
    [v11212
     (:traffic-policy-version-marker
      m11211
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (.
      bean11210
      setTrafficPolicyVersionMarker
      (clojure.core/str v11212))))
   (clojure.core/let
    [v11212
     (:max-items m11211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (. bean11210 setMaxItems (clojure.core/str v11212))))
   (clojure.core/let
    [v11212 (:id m11211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (. bean11210 setId (clojure.core/str v11212))))
   bean11210))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest}
list-traffic-policy-instances-by-hosted-zone-request
  [m11214]
  (clojure.core/let
   [bean11213
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest)]
   (clojure.core/let
    [v11215
     (:traffic-policy-instance-name-marker
      m11214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (.
      bean11213
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11215))))
   (clojure.core/let
    [v11215
     (:traffic-policy-instance-type-marker
      m11214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (.
      bean11213
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11215))))
   (clojure.core/let
    [v11215
     (:max-items m11214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (. bean11213 setMaxItems (clojure.core/str v11215))))
   (clojure.core/let
    [v11215
     (:hosted-zone-id
      m11214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (. bean11213 setHostedZoneId (clojure.core/str v11215))))
   bean11213))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest}
delete-reusable-delegation-set-request
  [m11217]
  (clojure.core/let
   [bean11216
    (new
     com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest)]
   (clojure.core/let
    [v11218 (:id m11217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11218 :com.palletops.awaze.client-builder/undef)
     (. bean11216 setId (clojure.core/str v11218))))
   bean11216))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetReusableDelegationSetRequest}
get-reusable-delegation-set-request
  [m11220]
  (clojure.core/let
   [bean11219
    (new
     com.amazonaws.services.route53.model.GetReusableDelegationSetRequest)]
   (clojure.core/let
    [v11221 (:id m11220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11221 :com.palletops.awaze.client-builder/undef)
     (. bean11219 setId (clojure.core/str v11221))))
   bean11219))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHostedZoneRequest}
delete-hosted-zone-request
  [m11223]
  (clojure.core/let
   [bean11222
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/let
    [v11224 (:id m11223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11224 :com.palletops.awaze.client-builder/undef)
     (. bean11222 setId (clojure.core/str v11224))))
   bean11222))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest}
associate-vpcwith-hosted-zone-request
  [m11226]
  (clojure.core/let
   [bean11225
    (new
     com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest)]
   (clojure.core/let
    [v11227
     (:comment m11226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11227 :com.palletops.awaze.client-builder/undef)
     (. bean11225 setComment (clojure.core/str v11227))))
   (clojure.core/let
    [v11227 (:vpc m11226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11227 :com.palletops.awaze.client-builder/undef)
     (. bean11225 setVPC (route53/vpc v11227))))
   (clojure.core/let
    [v11227
     (:hosted-zone-id
      m11226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11227 :com.palletops.awaze.client-builder/undef)
     (. bean11225 setHostedZoneId (clojure.core/str v11227))))
   bean11225))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesRequest}
list-hosted-zones-request
  [m11229]
  (clojure.core/let
   [bean11228
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/let
    [v11230
     (:delegation-set-id
      m11229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11230 :com.palletops.awaze.client-builder/undef)
     (. bean11228 setDelegationSetId (clojure.core/str v11230))))
   (clojure.core/let
    [v11230
     (:marker m11229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11230 :com.palletops.awaze.client-builder/undef)
     (. bean11228 setMarker (clojure.core/str v11230))))
   (clojure.core/let
    [v11230
     (:max-items m11229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11230 :com.palletops.awaze.client-builder/undef)
     (. bean11228 setMaxItems (clojure.core/str v11230))))
   bean11228))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest}
list-reusable-delegation-sets-request
  [m11232]
  (clojure.core/let
   [bean11231
    (new
     com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest)]
   (clojure.core/let
    [v11233
     (:marker m11232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11233 :com.palletops.awaze.client-builder/undef)
     (. bean11231 setMarker (clojure.core/str v11233))))
   (clojure.core/let
    [v11233
     (:max-items m11232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11233 :com.palletops.awaze.client-builder/undef)
     (. bean11231 setMaxItems (clojure.core/str v11233))))
   bean11231))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest}
delete-traffic-policy-instance-request
  [m11235]
  (clojure.core/let
   [bean11234
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11236 (:id m11235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11236 :com.palletops.awaze.client-builder/undef)
     (. bean11234 setId (clojure.core/str v11236))))
   bean11234))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckRequest}
get-health-check-request
  [m11238]
  (clojure.core/let
   [bean11237
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/let
    [v11239
     (:health-check-id
      m11238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setHealthCheckId (clojure.core/str v11239))))
   bean11237))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourcesRequest}
list-tags-for-resources-request
  [m11241]
  (clojure.core/let
   [bean11240
    (new
     com.amazonaws.services.route53.model.ListTagsForResourcesRequest)]
   (clojure.core/let
    [v11242
     (:resource-ids m11241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11242 :com.palletops.awaze.client-builder/undef)
     (.
      bean11240
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11342] (clojure.core/str arg11342))
 v11242))))
   (clojure.core/let
    [v11242
     (:resource-type m11241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11242 :com.palletops.awaze.client-builder/undef)
     (. bean11240 setResourceType (route53/tag-resource-type v11242))))
   bean11240))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetCheckerIpRangesRequest}
get-checker-ip-ranges-request
  [m11244]
  (clojure.core/let
   [bean11243
    (new
     com.amazonaws.services.route53.model.GetCheckerIpRangesRequest)]
   bean11243))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHostedZoneRequest}
create-hosted-zone-request
  [m11247]
  (clojure.core/let
   [bean11246
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/let
    [v11248 (:vpc m11247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setVPC (route53/vpc v11248))))
   (clojure.core/let
    [v11248
     (:caller-reference
      m11247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setCallerReference (clojure.core/str v11248))))
   (clojure.core/let
    [v11248
     (:hosted-zone-config
      m11247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (.
      bean11246
      setHostedZoneConfig
      (route53/hosted-zone-config v11248))))
   (clojure.core/let
    [v11248
     (:delegation-set-id
      m11247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setDelegationSetId (clojure.core/str v11248))))
   (clojure.core/let
    [v11248 (:name m11247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setName (clojure.core/str v11248))))
   bean11246))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest}
list-change-batches-by-hosted-zone-request
  [m11250]
  (clojure.core/let
   [bean11249
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest)]
   (clojure.core/let
    [v11251
     (:marker m11250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11251 :com.palletops.awaze.client-builder/undef)
     (. bean11249 setMarker (clojure.core/str v11251))))
   (clojure.core/let
    [v11251
     (:max-items m11250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11251 :com.palletops.awaze.client-builder/undef)
     (. bean11249 setMaxItems (clojure.core/str v11251))))
   (clojure.core/let
    [v11251
     (:end-date m11250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11251 :com.palletops.awaze.client-builder/undef)
     (. bean11249 setEndDate (clojure.core/str v11251))))
   (clojure.core/let
    [v11251
     (:start-date m11250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11251 :com.palletops.awaze.client-builder/undef)
     (. bean11249 setStartDate (clojure.core/str v11251))))
   (clojure.core/let
    [v11251
     (:hosted-zone-id
      m11250
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11251 :com.palletops.awaze.client-builder/undef)
     (. bean11249 setHostedZoneId (clojure.core/str v11251))))
   bean11249))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHealthCheckRequest}
update-health-check-request
  [m11253]
  (clojure.core/let
   [bean11252
    (new
     com.amazonaws.services.route53.model.UpdateHealthCheckRequest)]
   (clojure.core/let
    [v11254
     (:inverted m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setInverted (clojure.core/boolean v11254))))
   (clojure.core/let
    [v11254
     (:resource-path m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setResourcePath (clojure.core/str v11254))))
   (clojure.core/let
    [v11254
     (:search-string m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setSearchString (clojure.core/str v11254))))
   (clojure.core/let
    [v11254
     (:health-check-id
      m11253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setHealthCheckId (clojure.core/str v11254))))
   (clojure.core/let
    [v11254
     (:child-health-checks
      m11253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (.
      bean11252
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11343] (clojure.core/str arg11343))
 v11254))))
   (clojure.core/let
    [v11254 (:port m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setPort (clojure.core/int v11254))))
   (clojure.core/let
    [v11254
     (:health-check-version
      m11253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setHealthCheckVersion (clojure.core/long v11254))))
   (clojure.core/let
    [v11254
     (:health-threshold
      m11253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setHealthThreshold (clojure.core/int v11254))))
   (clojure.core/let
    [v11254
     (:ipaddress m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setIPAddress (clojure.core/str v11254))))
   (clojure.core/let
    [v11254
     (:fully-qualified-domain-name
      m11253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (.
      bean11252
      setFullyQualifiedDomainName
      (clojure.core/str v11254))))
   (clojure.core/let
    [v11254
     (:enable-sni m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setEnableSNI (clojure.core/boolean v11254))))
   (clojure.core/let
    [v11254
     (:failure-threshold
      m11253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setFailureThreshold (clojure.core/int v11254))))
   bean11252))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest}
get-health-check-last-failure-reason-request
  [m11256]
  (clojure.core/let
   [bean11255
    (new
     com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest)]
   (clojure.core/let
    [v11257
     (:health-check-id
      m11256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11257 :com.palletops.awaze.client-builder/undef)
     (. bean11255 setHealthCheckId (clojure.core/str v11257))))
   bean11255))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHealthCheckRequest}
create-health-check-request
  [m11259]
  (clojure.core/let
   [bean11258
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/let
    [v11260
     (:caller-reference
      m11259
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11260 :com.palletops.awaze.client-builder/undef)
     (. bean11258 setCallerReference (clojure.core/str v11260))))
   (clojure.core/let
    [v11260
     (:health-check-config
      m11259
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11260 :com.palletops.awaze.client-builder/undef)
     (.
      bean11258
      setHealthCheckConfig
      (route53/health-check-config v11260))))
   bean11258))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest}
create-traffic-policy-instance-request
  [m11262]
  (clojure.core/let
   [bean11261
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11263 (:ttl m11262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setTTL (clojure.core/long v11263))))
   (clojure.core/let
    [v11263
     (:traffic-policy-id
      m11262
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setTrafficPolicyId (clojure.core/str v11263))))
   (clojure.core/let
    [v11263
     (:traffic-policy-version
      m11262
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setTrafficPolicyVersion (clojure.core/int v11263))))
   (clojure.core/let
    [v11263
     (:hosted-zone-id
      m11262
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setHostedZoneId (clojure.core/str v11263))))
   (clojure.core/let
    [v11263 (:name m11262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setName (clojure.core/str v11263))))
   bean11261))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeDetailsRequest}
get-change-details-request
  [m11265]
  (clojure.core/let
   [bean11264
    (new com.amazonaws.services.route53.model.GetChangeDetailsRequest)]
   (clojure.core/let
    [v11266 (:id m11265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11266 :com.palletops.awaze.client-builder/undef)
     (. bean11264 setId (clojure.core/str v11266))))
   bean11264))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyRequest}
create-traffic-policy-request
  [m11268]
  (clojure.core/let
   [bean11267
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyRequest)]
   (clojure.core/let
    [v11269
     (:comment m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setComment (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:document m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setDocument (clojure.core/str v11269))))
   (clojure.core/let
    [v11269 (:name m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setName (clojure.core/str v11269))))
   bean11267))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeTagsForResourceRequest}
change-tags-for-resource-request
  [m11271]
  (clojure.core/let
   [bean11270
    (new
     com.amazonaws.services.route53.model.ChangeTagsForResourceRequest)]
   (clojure.core/let
    [v11272
     (:add-tags m11271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11272 :com.palletops.awaze.client-builder/undef)
     (.
      bean11270
      setAddTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11344] (route53/tag arg11344))
 v11272))))
   (clojure.core/let
    [v11272
     (:remove-tag-keys
      m11271
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11272 :com.palletops.awaze.client-builder/undef)
     (.
      bean11270
      setRemoveTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11345] (clojure.core/str arg11345))
 v11272))))
   (clojure.core/let
    [v11272
     (:resource-type m11271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11272 :com.palletops.awaze.client-builder/undef)
     (. bean11270 setResourceType (route53/tag-resource-type v11272))))
   (clojure.core/let
    [v11272
     (:resource-id m11271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11272 :com.palletops.awaze.client-builder/undef)
     (. bean11270 setResourceId (clojure.core/str v11272))))
   bean11270))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest}
get-traffic-policy-instance-count-request
  [m11274]
  (clojure.core/let
   [bean11273
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest)]
   bean11273))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckStatusRequest}
get-health-check-status-request
  [m11277]
  (clojure.core/let
   [bean11276
    (new
     com.amazonaws.services.route53.model.GetHealthCheckStatusRequest)]
   (clojure.core/let
    [v11278
     (:health-check-id
      m11277
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11278 :com.palletops.awaze.client-builder/undef)
     (. bean11276 setHealthCheckId (clojure.core/str v11278))))
   bean11276))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeRequest}
get-change-request
  [m11280]
  (clojure.core/let
   [bean11279
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/let
    [v11281 (:id m11280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11281 :com.palletops.awaze.client-builder/undef)
     (. bean11279 setId (clojure.core/str v11281))))
   bean11279))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListGeoLocationsRequest}
list-geo-locations-request
  [m11283]
  (clojure.core/let
   [bean11282
    (new com.amazonaws.services.route53.model.ListGeoLocationsRequest)]
   (clojure.core/let
    [v11284
     (:start-country-code
      m11283
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setStartCountryCode (clojure.core/str v11284))))
   (clojure.core/let
    [v11284
     (:start-continent-code
      m11283
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setStartContinentCode (clojure.core/str v11284))))
   (clojure.core/let
    [v11284
     (:start-subdivision-code
      m11283
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setStartSubdivisionCode (clojure.core/str v11284))))
   (clojure.core/let
    [v11284
     (:max-items m11283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setMaxItems (clojure.core/str v11284))))
   bean11282))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneCountRequest}
get-hosted-zone-count-request
  [m11286]
  (clojure.core/let
   [bean11285
    (new
     com.amazonaws.services.route53.model.GetHostedZoneCountRequest)]
   bean11285))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest}
update-hosted-zone-comment-request
  [m11289]
  (clojure.core/let
   [bean11288
    (new
     com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest)]
   (clojure.core/let
    [v11290
     (:comment m11289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11290 :com.palletops.awaze.client-builder/undef)
     (. bean11288 setComment (clojure.core/str v11290))))
   (clojure.core/let
    [v11290 (:id m11289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11290 :com.palletops.awaze.client-builder/undef)
     (. bean11288 setId (clojure.core/str v11290))))
   bean11288))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckCountRequest}
get-health-check-count-request
  [m11292]
  (clojure.core/let
   [bean11291
    (new
     com.amazonaws.services.route53.model.GetHealthCheckCountRequest)]
   bean11291))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneRequest}
get-hosted-zone-request
  [m11295]
  (clojure.core/let
   [bean11294
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/let
    [v11296 (:id m11295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11296 :com.palletops.awaze.client-builder/undef)
     (. bean11294 setId (clojure.core/str v11296))))
   bean11294))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest}
update-traffic-policy-comment-request
  [m11298]
  (clojure.core/let
   [bean11297
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest)]
   (clojure.core/let
    [v11299
     (:version m11298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setVersion (clojure.core/int v11299))))
   (clojure.core/let
    [v11299
     (:comment m11298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setComment (clojure.core/str v11299))))
   (clojure.core/let
    [v11299 (:id m11298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setId (clojure.core/str v11299))))
   bean11297))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest}
get-traffic-policy-instance-request
  [m11301]
  (clojure.core/let
   [bean11300
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11302 (:id m11301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11302 :com.palletops.awaze.client-builder/undef)
     (. bean11300 setId (clojure.core/str v11302))))
   bean11300))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesByNameRequest}
list-hosted-zones-by-name-request
  [m11304]
  (clojure.core/let
   [bean11303
    (new
     com.amazonaws.services.route53.model.ListHostedZonesByNameRequest)]
   (clojure.core/let
    [v11305
     (:max-items m11304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setMaxItems (clojure.core/str v11305))))
   (clojure.core/let
    [v11305
     (:dnsname m11304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setDNSName (clojure.core/str v11305))))
   (clojure.core/let
    [v11305
     (:hosted-zone-id
      m11304
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setHostedZoneId (clojure.core/str v11305))))
   bean11303))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetGeoLocationRequest}
get-geo-location-request
  [m11307]
  (clojure.core/let
   [bean11306
    (new com.amazonaws.services.route53.model.GetGeoLocationRequest)]
   (clojure.core/let
    [v11308
     (:continent-code
      m11307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11308 :com.palletops.awaze.client-builder/undef)
     (. bean11306 setContinentCode (clojure.core/str v11308))))
   (clojure.core/let
    [v11308
     (:country-code m11307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11308 :com.palletops.awaze.client-builder/undef)
     (. bean11306 setCountryCode (clojure.core/str v11308))))
   (clojure.core/let
    [v11308
     (:subdivision-code
      m11307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11308 :com.palletops.awaze.client-builder/undef)
     (. bean11306 setSubdivisionCode (clojure.core/str v11308))))
   bean11306))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m11310]
  (clojure.core/let
   [bean11309
    (new
     com.amazonaws.services.route53.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v11311
     (:resource-type m11310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11311 :com.palletops.awaze.client-builder/undef)
     (. bean11309 setResourceType (route53/tag-resource-type v11311))))
   (clojure.core/let
    [v11311
     (:resource-id m11310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11311 :com.palletops.awaze.client-builder/undef)
     (. bean11309 setResourceId (clojure.core/str v11311))))
   bean11309))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest}
create-reusable-delegation-set-request
  [m11313]
  (clojure.core/let
   [bean11312
    (new
     com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest)]
   (clojure.core/let
    [v11314
     (:caller-reference
      m11313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setCallerReference (clojure.core/str v11314))))
   (clojure.core/let
    [v11314
     (:hosted-zone-id
      m11313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setHostedZoneId (clojure.core/str v11314))))
   bean11312))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHealthChecksRequest}
list-health-checks-request
  [m11316]
  (clojure.core/let
   [bean11315
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/let
    [v11317
     (:marker m11316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11317 :com.palletops.awaze.client-builder/undef)
     (. bean11315 setMarker (clojure.core/str v11317))))
   (clojure.core/let
    [v11317
     (:max-items m11316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11317 :com.palletops.awaze.client-builder/undef)
     (. bean11315 setMaxItems (clojure.core/str v11317))))
   bean11315))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest}
update-traffic-policy-instance-request
  [m11319]
  (clojure.core/let
   [bean11318
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11320 (:ttl m11319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setTTL (clojure.core/long v11320))))
   (clojure.core/let
    [v11320
     (:traffic-policy-id
      m11319
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setTrafficPolicyId (clojure.core/str v11320))))
   (clojure.core/let
    [v11320
     (:traffic-policy-version
      m11319
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setTrafficPolicyVersion (clojure.core/int v11320))))
   (clojure.core/let
    [v11320 (:id m11319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setId (clojure.core/str v11320))))
   bean11318))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHealthCheckRequest}
delete-health-check-request
  [m11322]
  (clojure.core/let
   [bean11321
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/let
    [v11323
     (:health-check-id
      m11322
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11323 :com.palletops.awaze.client-builder/undef)
     (. bean11321 setHealthCheckId (clojure.core/str v11323))))
   bean11321))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyRequest}
get-traffic-policy-request
  [m11325]
  (clojure.core/let
   [bean11324
    (new com.amazonaws.services.route53.model.GetTrafficPolicyRequest)]
   (clojure.core/let
    [v11326
     (:version m11325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11326 :com.palletops.awaze.client-builder/undef)
     (. bean11324 setVersion (clojure.core/int v11326))))
   (clojure.core/let
    [v11326 (:id m11325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11326 :com.palletops.awaze.client-builder/undef)
     (. bean11324 setId (clojure.core/str v11326))))
   bean11324))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest}
list-change-batches-by-rrset-request
  [m11328]
  (clojure.core/let
   [bean11327
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest)]
   (clojure.core/let
    [v11329
     (:set-identifier
      m11328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setSetIdentifier (clojure.core/str v11329))))
   (clojure.core/let
    [v11329
     (:marker m11328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setMarker (clojure.core/str v11329))))
   (clojure.core/let
    [v11329
     (:max-items m11328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setMaxItems (clojure.core/str v11329))))
   (clojure.core/let
    [v11329 (:type m11328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setType (route53/rrtype v11329))))
   (clojure.core/let
    [v11329
     (:end-date m11328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setEndDate (clojure.core/str v11329))))
   (clojure.core/let
    [v11329
     (:start-date m11328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setStartDate (clojure.core/str v11329))))
   (clojure.core/let
    [v11329
     (:hosted-zone-id
      m11328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setHostedZoneId (clojure.core/str v11329))))
   (clojure.core/let
    [v11329 (:name m11328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setName (clojure.core/str v11329))))
   bean11327))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListResourceRecordSetsRequest}
list-resource-record-sets-request
  [m11331]
  (clojure.core/let
   [bean11330
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/let
    [v11332
     (:start-record-type
      m11331
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11332 :com.palletops.awaze.client-builder/undef)
     (. bean11330 setStartRecordType (clojure.core/str v11332))))
   (clojure.core/let
    [v11332
     (:start-record-name
      m11331
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11332 :com.palletops.awaze.client-builder/undef)
     (. bean11330 setStartRecordName (clojure.core/str v11332))))
   (clojure.core/let
    [v11332
     (:start-record-identifier
      m11331
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11332 :com.palletops.awaze.client-builder/undef)
     (. bean11330 setStartRecordIdentifier (clojure.core/str v11332))))
   (clojure.core/let
    [v11332
     (:max-items m11331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11332 :com.palletops.awaze.client-builder/undef)
     (. bean11330 setMaxItems (clojure.core/str v11332))))
   (clojure.core/let
    [v11332
     (:hosted-zone-id
      m11331
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11332 :com.palletops.awaze.client-builder/undef)
     (. bean11330 setHostedZoneId (clojure.core/str v11332))))
   bean11330))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest}
disassociate-vpcfrom-hosted-zone-request
  [m11334]
  (clojure.core/let
   [bean11333
    (new
     com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest)]
   (clojure.core/let
    [v11335
     (:comment m11334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11335 :com.palletops.awaze.client-builder/undef)
     (. bean11333 setComment (clojure.core/str v11335))))
   (clojure.core/let
    [v11335 (:vpc m11334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11335 :com.palletops.awaze.client-builder/undef)
     (. bean11333 setVPC (route53/vpc v11335))))
   (clojure.core/let
    [v11335
     (:hosted-zone-id
      m11334
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11335 :com.palletops.awaze.client-builder/undef)
     (. bean11333 setHostedZoneId (clojure.core/str v11335))))
   bean11333))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest}
list-traffic-policy-instances-request
  [m11337]
  (clojure.core/let
   [bean11336
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest)]
   (clojure.core/let
    [v11338
     (:traffic-policy-instance-name-marker
      m11337
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11338 :com.palletops.awaze.client-builder/undef)
     (.
      bean11336
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11338))))
   (clojure.core/let
    [v11338
     (:traffic-policy-instance-type-marker
      m11337
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11338 :com.palletops.awaze.client-builder/undef)
     (.
      bean11336
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11338))))
   (clojure.core/let
    [v11338
     (:hosted-zone-id-marker
      m11337
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11338 :com.palletops.awaze.client-builder/undef)
     (. bean11336 setHostedZoneIdMarker (clojure.core/str v11338))))
   (clojure.core/let
    [v11338
     (:max-items m11337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11338 :com.palletops.awaze.client-builder/undef)
     (. bean11336 setMaxItems (clojure.core/str v11338))))
   bean11336))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-version
   [m11346]
   (clojure.core/let
    [credentials11347 (:credentials m11346) args11348 (:args m11346)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11349
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11347)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11349
       createTrafficPolicyVersion
       (route53/create-traffic-policy-version-request
        (clojure.core/nth args11348 0)))))))
  (clojure.core/defn
   create-traffic-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-version,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicyVersion"}
   [credentials11351 & args11352]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11353
     (com.palletops.awaze.common/aws-client :route53 credentials11351)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11353
      createTrafficPolicyVersion
      (route53/create-traffic-policy-version-request
       (clojure.core/nth args11352 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy
   [m11354]
   (clojure.core/let
    [credentials11355 (:credentials m11354) args11356 (:args m11354)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11357
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11355)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11357
       deleteTrafficPolicy
       (route53/delete-traffic-policy-request
        (clojure.core/nth args11356 0)))))))
  (clojure.core/defn
   delete-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicy"}
   [credentials11359 & args11360]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11361
     (com.palletops.awaze.common/aws-client :route53 credentials11359)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11361
      deleteTrafficPolicy
      (route53/delete-traffic-policy-request
       (clojure.core/nth args11360 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m11362]
   (clojure.core/let
    [credentials11363 (:credentials m11362) args11364 (:args m11362)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11365
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11363)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11365
       changeResourceRecordSets
       (route53/change-resource-record-sets-request
        (clojure.core/nth args11364 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-resource-record-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call changeResourceRecordSets"}
   [credentials11367 & args11368]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11369
     (com.palletops.awaze.common/aws-client :route53 credentials11367)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11369
      changeResourceRecordSets
      (route53/change-resource-record-sets-request
       (clojure.core/nth args11368 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policies
   [m11370]
   (clojure.core/let
    [credentials11371 (:credentials m11370) args11372 (:args m11370)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11373
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11371)]
     (clojure.core/case
      (clojure.core/count args11372)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11373
        listTrafficPolicies
        (route53/list-traffic-policies-request
         (clojure.core/nth args11372 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11373
        listTrafficPolicies))))))
  (clojure.core/defn
   list-traffic-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listTrafficPolicies, listTrafficPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-traffic-policies,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policies,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listTrafficPolicies, listTrafficPolicies"}
   [credentials11375 & args11376]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11377
     (com.palletops.awaze.common/aws-client :route53 credentials11375)]
    (clojure.core/case
     (clojure.core/count args11376)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11377
       listTrafficPolicies
       (route53/list-traffic-policies-request
        (clojure.core/nth args11376 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11377
       listTrafficPolicies))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-policy
   [m11378]
   (clojure.core/let
    [credentials11379 (:credentials m11378) args11380 (:args m11378)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11381
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11379)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11381
       listTrafficPolicyInstancesByPolicy
       (route53/list-traffic-policy-instances-by-policy-request
        (clojure.core/nth args11380 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstancesByPolicy"}
   [credentials11383 & args11384]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11385
     (com.palletops.awaze.common/aws-client :route53 credentials11383)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11385
      listTrafficPolicyInstancesByPolicy
      (route53/list-traffic-policy-instances-by-policy-request
       (clojure.core/nth args11384 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-versions
   [m11386]
   (clojure.core/let
    [credentials11387 (:credentials m11386) args11388 (:args m11386)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11389
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11387)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11389
       listTrafficPolicyVersions
       (route53/list-traffic-policy-versions-request
        (clojure.core/nth args11388 0)))))))
  (clojure.core/defn
   list-traffic-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-versions,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyVersions"}
   [credentials11391 & args11392]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11393
     (com.palletops.awaze.common/aws-client :route53 credentials11391)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11393
      listTrafficPolicyVersions
      (route53/list-traffic-policy-versions-request
       (clojure.core/nth args11392 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-hosted-zone
   [m11394]
   (clojure.core/let
    [credentials11395 (:credentials m11394) args11396 (:args m11394)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11397
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11395)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11397
       listTrafficPolicyInstancesByHostedZone
       (route53/list-traffic-policy-instances-by-hosted-zone-request
        (clojure.core/nth args11396 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listTrafficPolicyInstancesByHostedZone"}
   [credentials11399 & args11400]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11401
     (com.palletops.awaze.common/aws-client :route53 credentials11399)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11401
      listTrafficPolicyInstancesByHostedZone
      (route53/list-traffic-policy-instances-by-hosted-zone-request
       (clojure.core/nth args11400 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-reusable-delegation-set
   [m11402]
   (clojure.core/let
    [credentials11403 (:credentials m11402) args11404 (:args m11402)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11405
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11403)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11405
       deleteReusableDelegationSet
       (route53/delete-reusable-delegation-set-request
        (clojure.core/nth args11404 0)))))))
  (clojure.core/defn
   delete-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReusableDelegationSet"}
   [credentials11407 & args11408]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11409
     (com.palletops.awaze.common/aws-client :route53 credentials11407)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11409
      deleteReusableDelegationSet
      (route53/delete-reusable-delegation-set-request
       (clojure.core/nth args11408 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-reusable-delegation-set
   [m11410]
   (clojure.core/let
    [credentials11411 (:credentials m11410) args11412 (:args m11410)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11413
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11411)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11413
       getReusableDelegationSet
       (route53/get-reusable-delegation-set-request
        (clojure.core/nth args11412 0)))))))
  (clojure.core/defn
   get-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getReusableDelegationSet"}
   [credentials11415 & args11416]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11417
     (com.palletops.awaze.common/aws-client :route53 credentials11415)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11417
      getReusableDelegationSet
      (route53/get-reusable-delegation-set-request
       (clojure.core/nth args11416 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m11418]
   (clojure.core/let
    [credentials11419 (:credentials m11418) args11420 (:args m11418)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11421
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11419)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11421
       deleteHostedZone
       (route53/delete-hosted-zone-request
        (clojure.core/nth args11420 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHostedZone"}
   [credentials11423 & args11424]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11425
     (com.palletops.awaze.common/aws-client :route53 credentials11423)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11425
      deleteHostedZone
      (route53/delete-hosted-zone-request
       (clojure.core/nth args11424 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :associate-vpcwith-hosted-zone
   [m11426]
   (clojure.core/let
    [credentials11427 (:credentials m11426) args11428 (:args m11426)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11429
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11427)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11429
       associateVPCWithHostedZone
       (route53/associate-vpcwith-hosted-zone-request
        (clojure.core/nth args11428 0)))))))
  (clojure.core/defn
   associate-vpcwith-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for associateVPCWithHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-vpcwith-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   associate-vpcwith-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call associateVPCWithHostedZone"}
   [credentials11431 & args11432]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11433
     (com.palletops.awaze.common/aws-client :route53 credentials11431)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11433
      associateVPCWithHostedZone
      (route53/associate-vpcwith-hosted-zone-request
       (clojure.core/nth args11432 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m11434]
   (clojure.core/let
    [credentials11435 (:credentials m11434) args11436 (:args m11434)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11437
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11435)]
     (clojure.core/case
      (clojure.core/count args11436)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11437
        listHostedZones
        (route53/list-hosted-zones-request
         (clojure.core/nth args11436 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11437
        listHostedZones))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-hosted-zones,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-hosted-zones,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHostedZones, listHostedZones"}
   [credentials11439 & args11440]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11441
     (com.palletops.awaze.common/aws-client :route53 credentials11439)]
    (clojure.core/case
     (clojure.core/count args11440)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11441
       listHostedZones
       (route53/list-hosted-zones-request
        (clojure.core/nth args11440 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11441
       listHostedZones))))))
 (do
  (clojure.core/defmethod
   route53
   :list-reusable-delegation-sets
   [m11442]
   (clojure.core/let
    [credentials11443 (:credentials m11442) args11444 (:args m11442)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11445
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11443)]
     (clojure.core/case
      (clojure.core/count args11444)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11445
        listReusableDelegationSets
        (route53/list-reusable-delegation-sets-request
         (clojure.core/nth args11444 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11445
        listReusableDelegationSets))))))
  (clojure.core/defn
   list-reusable-delegation-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listReusableDelegationSets, listReusableDelegationSets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-reusable-delegation-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listReusableDelegationSets, listReusableDelegationSets"}
   [credentials11447 & args11448]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11449
     (com.palletops.awaze.common/aws-client :route53 credentials11447)]
    (clojure.core/case
     (clojure.core/count args11448)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11449
       listReusableDelegationSets
       (route53/list-reusable-delegation-sets-request
        (clojure.core/nth args11448 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11449
       listReusableDelegationSets))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy-instance
   [m11450]
   (clojure.core/let
    [credentials11451 (:credentials m11450) args11452 (:args m11450)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11453
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11451)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11453
       deleteTrafficPolicyInstance
       (route53/delete-traffic-policy-instance-request
        (clojure.core/nth args11452 0)))))))
  (clojure.core/defn
   delete-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicyInstance"}
   [credentials11455 & args11456]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11457
     (com.palletops.awaze.common/aws-client :route53 credentials11455)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11457
      deleteTrafficPolicyInstance
      (route53/delete-traffic-policy-instance-request
       (clojure.core/nth args11456 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m11458]
   (clojure.core/let
    [credentials11459 (:credentials m11458) args11460 (:args m11458)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11461
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11459)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11461
       getHealthCheck
       (route53/get-health-check-request
        (clojure.core/nth args11460 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheck"}
   [credentials11463 & args11464]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11465
     (com.palletops.awaze.common/aws-client :route53 credentials11463)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11465
      getHealthCheck
      (route53/get-health-check-request
       (clojure.core/nth args11464 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resources
   [m11466]
   (clojure.core/let
    [credentials11467 (:credentials m11466) args11468 (:args m11466)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11469
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11467)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11469
       listTagsForResources
       (route53/list-tags-for-resources-request
        (clojure.core/nth args11468 0)))))))
  (clojure.core/defn
   list-tags-for-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resources,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResources"}
   [credentials11471 & args11472]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11473
     (com.palletops.awaze.common/aws-client :route53 credentials11471)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11473
      listTagsForResources
      (route53/list-tags-for-resources-request
       (clojure.core/nth args11472 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-checker-ip-ranges
   [m11474]
   (clojure.core/let
    [credentials11475 (:credentials m11474) args11476 (:args m11474)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11477
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11475)]
     (clojure.core/case
      (clojure.core/count args11476)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11477
        getCheckerIpRanges
        (route53/get-checker-ip-ranges-request
         (clojure.core/nth args11476 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11477
        getCheckerIpRanges))))))
  (clojure.core/defn
   get-checker-ip-ranges-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getCheckerIpRanges, getCheckerIpRanges"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-checker-ip-ranges
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getCheckerIpRanges, getCheckerIpRanges"}
   [credentials11479 & args11480]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11481
     (com.palletops.awaze.common/aws-client :route53 credentials11479)]
    (clojure.core/case
     (clojure.core/count args11480)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11481
       getCheckerIpRanges
       (route53/get-checker-ip-ranges-request
        (clojure.core/nth args11480 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11481
       getCheckerIpRanges))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m11482]
   (clojure.core/let
    [credentials11483 (:credentials m11482) args11484 (:args m11482)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11485
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11483)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11485
       createHostedZone
       (route53/create-hosted-zone-request
        (clojure.core/nth args11484 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHostedZone"}
   [credentials11487 & args11488]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11489
     (com.palletops.awaze.common/aws-client :route53 credentials11487)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11489
      createHostedZone
      (route53/create-hosted-zone-request
       (clojure.core/nth args11488 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-hosted-zone
   [m11490]
   (clojure.core/let
    [credentials11491 (:credentials m11490) args11492 (:args m11490)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11493
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11491)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11493
       listChangeBatchesByHostedZone
       (route53/list-change-batches-by-hosted-zone-request
        (clojure.core/nth args11492 0)))))))
  (clojure.core/defn
   list-change-batches-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByHostedZone"}
   [credentials11495 & args11496]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11497
     (com.palletops.awaze.common/aws-client :route53 credentials11495)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11497
      listChangeBatchesByHostedZone
      (route53/list-change-batches-by-hosted-zone-request
       (clojure.core/nth args11496 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-health-check
   [m11498]
   (clojure.core/let
    [credentials11499 (:credentials m11498) args11500 (:args m11498)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11501
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11499)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11501
       updateHealthCheck
       (route53/update-health-check-request
        (clojure.core/nth args11500 0)))))))
  (clojure.core/defn
   update-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         clone-root
                         inverted]}]]),
    :doc "Generate map for updateHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         clone-root
                         inverted]}]]),
    :doc "Call updateHealthCheck"}
   [credentials11503 & args11504]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11505
     (com.palletops.awaze.common/aws-client :route53 credentials11503)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11505
      updateHealthCheck
      (route53/update-health-check-request
       (clojure.core/nth args11504 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-last-failure-reason
   [m11506]
   (clojure.core/let
    [credentials11507 (:credentials m11506) args11508 (:args m11506)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11509
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11507)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11509
       getHealthCheckLastFailureReason
       (route53/get-health-check-last-failure-reason-request
        (clojure.core/nth args11508 0)))))))
  (clojure.core/defn
   get-health-check-last-failure-reason-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckLastFailureReason"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-last-failure-reason,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-last-failure-reason
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckLastFailureReason"}
   [credentials11511 & args11512]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11513
     (com.palletops.awaze.common/aws-client :route53 credentials11511)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11513
      getHealthCheckLastFailureReason
      (route53/get-health-check-last-failure-reason-request
       (clojure.core/nth args11512 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m11514]
   (clojure.core/let
    [credentials11515 (:credentials m11514) args11516 (:args m11514)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11517
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11515)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11517
       createHealthCheck
       (route53/create-health-check-request
        (clojure.core/nth args11516 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Generate map for createHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-health-check
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Call createHealthCheck"}
   [credentials11519 & args11520]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11521
     (com.palletops.awaze.common/aws-client :route53 credentials11519)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11521
      createHealthCheck
      (route53/create-health-check-request
       (clojure.core/nth args11520 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-instance
   [m11522]
   (clojure.core/let
    [credentials11523 (:credentials m11522) args11524 (:args m11522)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11525
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11523)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11525
       createTrafficPolicyInstance
       (route53/create-traffic-policy-instance-request
        (clojure.core/nth args11524 0)))))))
  (clojure.core/defn
   create-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createTrafficPolicyInstance"}
   [credentials11527 & args11528]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11529
     (com.palletops.awaze.common/aws-client :route53 credentials11527)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11529
      createTrafficPolicyInstance
      (route53/create-traffic-policy-instance-request
       (clojure.core/nth args11528 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change-details
   [m11530]
   (clojure.core/let
    [credentials11531 (:credentials m11530) args11532 (:args m11530)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11533
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11531)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11533
       getChangeDetails
       (route53/get-change-details-request
        (clojure.core/nth args11532 0)))))))
  (clojure.core/defn
   get-change-details-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChangeDetails"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-change-details,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change-details
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChangeDetails"}
   [credentials11535 & args11536]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11537
     (com.palletops.awaze.common/aws-client :route53 credentials11535)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11537
      getChangeDetails
      (route53/get-change-details-request
       (clojure.core/nth args11536 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy
   [m11538]
   (clojure.core/let
    [credentials11539 (:credentials m11538) args11540 (:args m11538)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11541
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11539)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11541
       createTrafficPolicy
       (route53/create-traffic-policy-request
        (clojure.core/nth args11540 0)))))))
  (clojure.core/defn
   create-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicy"}
   [credentials11543 & args11544]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11545
     (com.palletops.awaze.common/aws-client :route53 credentials11543)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11545
      createTrafficPolicy
      (route53/create-traffic-policy-request
       (clojure.core/nth args11544 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-tags-for-resource
   [m11546]
   (clojure.core/let
    [credentials11547 (:credentials m11546) args11548 (:args m11546)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11549
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11547)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11549
       changeTagsForResource
       (route53/change-tags-for-resource-request
        (clojure.core/nth args11548 0)))))))
  (clojure.core/defn
   change-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for changeTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   change-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call changeTagsForResource"}
   [credentials11551 & args11552]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11553
     (com.palletops.awaze.common/aws-client :route53 credentials11551)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11553
      changeTagsForResource
      (route53/change-tags-for-resource-request
       (clojure.core/nth args11552 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance-count
   [m11554]
   (clojure.core/let
    [credentials11555 (:credentials m11554) args11556 (:args m11554)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11557
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11555)]
     (clojure.core/case
      (clojure.core/count args11556)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11557
        getTrafficPolicyInstanceCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11557
        getTrafficPolicyInstanceCount
        (route53/get-traffic-policy-instance-count-request
         (clojure.core/nth args11556 0))))))))
  (clojure.core/defn
   get-traffic-policy-instance-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   [credentials11559 & args11560]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11561
     (com.palletops.awaze.common/aws-client :route53 credentials11559)]
    (clojure.core/case
     (clojure.core/count args11560)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11561
       getTrafficPolicyInstanceCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11561
       getTrafficPolicyInstanceCount
       (route53/get-traffic-policy-instance-count-request
        (clojure.core/nth args11560 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-status
   [m11562]
   (clojure.core/let
    [credentials11563 (:credentials m11562) args11564 (:args m11562)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11565
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11563)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11565
       getHealthCheckStatus
       (route53/get-health-check-status-request
        (clojure.core/nth args11564 0)))))))
  (clojure.core/defn
   get-health-check-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-status,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckStatus"}
   [credentials11567 & args11568]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11569
     (com.palletops.awaze.common/aws-client :route53 credentials11567)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11569
      getHealthCheckStatus
      (route53/get-health-check-status-request
       (clojure.core/nth args11568 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m11570]
   (clojure.core/let
    [credentials11571 (:credentials m11570) args11572 (:args m11570)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11573
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11571)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11573
       getChange
       (route53/get-change-request (clojure.core/nth args11572 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChange"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-change,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChange"}
   [credentials11575 & args11576]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11577
     (com.palletops.awaze.common/aws-client :route53 credentials11575)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11577
      getChange
      (route53/get-change-request (clojure.core/nth args11576 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-geo-locations
   [m11578]
   (clojure.core/let
    [credentials11579 (:credentials m11578) args11580 (:args m11578)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11581
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11579)]
     (clojure.core/case
      (clojure.core/count args11580)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11581
        listGeoLocations
        (route53/list-geo-locations-request
         (clojure.core/nth args11580 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11581
        listGeoLocations))))))
  (clojure.core/defn
   list-geo-locations-map
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGeoLocations, listGeoLocations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-geo-locations,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-geo-locations,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-geo-locations
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGeoLocations, listGeoLocations"}
   [credentials11583 & args11584]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11585
     (com.palletops.awaze.common/aws-client :route53 credentials11583)]
    (clojure.core/case
     (clojure.core/count args11584)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11585
       listGeoLocations
       (route53/list-geo-locations-request
        (clojure.core/nth args11584 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11585
       listGeoLocations))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone-count
   [m11586]
   (clojure.core/let
    [credentials11587 (:credentials m11586) args11588 (:args m11586)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11589
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11587)]
     (clojure.core/case
      (clojure.core/count args11588)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11589
        getHostedZoneCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11589
        getHostedZoneCount
        (route53/get-hosted-zone-count-request
         (clojure.core/nth args11588 0))))))))
  (clojure.core/defn
   get-hosted-zone-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZoneCount, getHostedZoneCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-hosted-zone-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-hosted-zone-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZoneCount, getHostedZoneCount"}
   [credentials11591 & args11592]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11593
     (com.palletops.awaze.common/aws-client :route53 credentials11591)]
    (clojure.core/case
     (clojure.core/count args11592)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11593
       getHostedZoneCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11593
       getHostedZoneCount
       (route53/get-hosted-zone-count-request
        (clojure.core/nth args11592 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :update-hosted-zone-comment
   [m11594]
   (clojure.core/let
    [credentials11595 (:credentials m11594) args11596 (:args m11594)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11597
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11595)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11597
       updateHostedZoneComment
       (route53/update-hosted-zone-comment-request
        (clojure.core/nth args11596 0)))))))
  (clojure.core/defn
   update-hosted-zone-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateHostedZoneComment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-hosted-zone-comment,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-hosted-zone-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateHostedZoneComment"}
   [credentials11599 & args11600]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11601
     (com.palletops.awaze.common/aws-client :route53 credentials11599)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11601
      updateHostedZoneComment
      (route53/update-hosted-zone-comment-request
       (clojure.core/nth args11600 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-count
   [m11602]
   (clojure.core/let
    [credentials11603 (:credentials m11602) args11604 (:args m11602)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11605
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11603)]
     (clojure.core/case
      (clojure.core/count args11604)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11605
        getHealthCheckCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11605
        getHealthCheckCount
        (route53/get-health-check-count-request
         (clojure.core/nth args11604 0))))))))
  (clojure.core/defn
   get-health-check-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckCount, getHealthCheckCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-health-check-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckCount, getHealthCheckCount"}
   [credentials11607 & args11608]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11609
     (com.palletops.awaze.common/aws-client :route53 credentials11607)]
    (clojure.core/case
     (clojure.core/count args11608)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11609
       getHealthCheckCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11609
       getHealthCheckCount
       (route53/get-health-check-count-request
        (clojure.core/nth args11608 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m11610]
   (clojure.core/let
    [credentials11611 (:credentials m11610) args11612 (:args m11610)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11613
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11611)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11613
       getHostedZone
       (route53/get-hosted-zone-request
        (clojure.core/nth args11612 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZone"}
   [credentials11615 & args11616]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11617
     (com.palletops.awaze.common/aws-client :route53 credentials11615)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11617
      getHostedZone
      (route53/get-hosted-zone-request (clojure.core/nth args11616 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-comment
   [m11618]
   (clojure.core/let
    [credentials11619 (:credentials m11618) args11620 (:args m11618)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11621
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11619)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11621
       updateTrafficPolicyComment
       (route53/update-traffic-policy-comment-request
        (clojure.core/nth args11620 0)))))))
  (clojure.core/defn
   update-traffic-policy-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyComment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-comment,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyComment"}
   [credentials11623 & args11624]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11625
     (com.palletops.awaze.common/aws-client :route53 credentials11623)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11625
      updateTrafficPolicyComment
      (route53/update-traffic-policy-comment-request
       (clojure.core/nth args11624 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance
   [m11626]
   (clojure.core/let
    [credentials11627 (:credentials m11626) args11628 (:args m11626)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11629
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11627)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11629
       getTrafficPolicyInstance
       (route53/get-traffic-policy-instance-request
        (clojure.core/nth args11628 0)))))))
  (clojure.core/defn
   get-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstance"}
   [credentials11631 & args11632]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11633
     (com.palletops.awaze.common/aws-client :route53 credentials11631)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11633
      getTrafficPolicyInstance
      (route53/get-traffic-policy-instance-request
       (clojure.core/nth args11632 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones-by-name
   [m11634]
   (clojure.core/let
    [credentials11635 (:credentials m11634) args11636 (:args m11634)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11637
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11635)]
     (clojure.core/case
      (clojure.core/count args11636)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11637
        listHostedZonesByName))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11637
        listHostedZonesByName
        (route53/list-hosted-zones-by-name-request
         (clojure.core/nth args11636 0))))))))
  (clojure.core/defn
   list-hosted-zones-by-name-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listHostedZonesByName, listHostedZonesByName"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones-by-name
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listHostedZonesByName, listHostedZonesByName"}
   [credentials11639 & args11640]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11641
     (com.palletops.awaze.common/aws-client :route53 credentials11639)]
    (clojure.core/case
     (clojure.core/count args11640)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11641
       listHostedZonesByName))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11641
       listHostedZonesByName
       (route53/list-hosted-zones-by-name-request
        (clojure.core/nth args11640 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-geo-location
   [m11642]
   (clojure.core/let
    [credentials11643 (:credentials m11642) args11644 (:args m11642)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11645
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11643)]
     (clojure.core/case
      (clojure.core/count args11644)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11645
        getGeoLocation
        (route53/get-geo-location-request
         (clojure.core/nth args11644 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11645
        getGeoLocation))))))
  (clojure.core/defn
   get-geo-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getGeoLocation, getGeoLocation"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-geo-location,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-geo-location,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-geo-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]
                [credentials]]),
    :doc "Call getGeoLocation, getGeoLocation"}
   [credentials11647 & args11648]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11649
     (com.palletops.awaze.common/aws-client :route53 credentials11647)]
    (clojure.core/case
     (clojure.core/count args11648)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11649
       getGeoLocation
       (route53/get-geo-location-request
        (clojure.core/nth args11648 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11649
       getGeoLocation))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resource
   [m11650]
   (clojure.core/let
    [credentials11651 (:credentials m11650) args11652 (:args m11650)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11653
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11651)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11653
       listTagsForResource
       (route53/list-tags-for-resource-request
        (clojure.core/nth args11652 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials11655 & args11656]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11657
     (com.palletops.awaze.common/aws-client :route53 credentials11655)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11657
      listTagsForResource
      (route53/list-tags-for-resource-request
       (clojure.core/nth args11656 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-reusable-delegation-set
   [m11658]
   (clojure.core/let
    [credentials11659 (:credentials m11658) args11660 (:args m11658)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11661
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11659)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11661
       createReusableDelegationSet
       (route53/create-reusable-delegation-set-request
        (clojure.core/nth args11660 0)))))))
  (clojure.core/defn
   create-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createReusableDelegationSet"}
   [credentials11663 & args11664]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11665
     (com.palletops.awaze.common/aws-client :route53 credentials11663)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11665
      createReusableDelegationSet
      (route53/create-reusable-delegation-set-request
       (clojure.core/nth args11664 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m11666]
   (clojure.core/let
    [credentials11667 (:credentials m11666) args11668 (:args m11666)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11669
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11667)]
     (clojure.core/case
      (clojure.core/count args11668)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11669
        listHealthChecks
        (route53/list-health-checks-request
         (clojure.core/nth args11668 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11669
        listHealthChecks))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-health-checks,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-health-checks,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-health-checks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials11671 & args11672]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11673
     (com.palletops.awaze.common/aws-client :route53 credentials11671)]
    (clojure.core/case
     (clojure.core/count args11672)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11673
       listHealthChecks
       (route53/list-health-checks-request
        (clojure.core/nth args11672 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11673
       listHealthChecks))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-instance
   [m11674]
   (clojure.core/let
    [credentials11675 (:credentials m11674) args11676 (:args m11674)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11677
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11675)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11677
       updateTrafficPolicyInstance
       (route53/update-traffic-policy-instance-request
        (clojure.core/nth args11676 0)))))))
  (clojure.core/defn
   update-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyInstance"}
   [credentials11679 & args11680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11681
     (com.palletops.awaze.common/aws-client :route53 credentials11679)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11681
      updateTrafficPolicyInstance
      (route53/update-traffic-policy-instance-request
       (clojure.core/nth args11680 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m11682]
   (clojure.core/let
    [credentials11683 (:credentials m11682) args11684 (:args m11682)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11685
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11683)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11685
       deleteHealthCheck
       (route53/delete-health-check-request
        (clojure.core/nth args11684 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHealthCheck"}
   [credentials11687 & args11688]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11689
     (com.palletops.awaze.common/aws-client :route53 credentials11687)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11689
      deleteHealthCheck
      (route53/delete-health-check-request
       (clojure.core/nth args11688 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy
   [m11690]
   (clojure.core/let
    [credentials11691 (:credentials m11690) args11692 (:args m11690)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11693
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11691)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11693
       getTrafficPolicy
       (route53/get-traffic-policy-request
        (clojure.core/nth args11692 0)))))))
  (clojure.core/defn
   get-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call getTrafficPolicy"}
   [credentials11695 & args11696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11697
     (com.palletops.awaze.common/aws-client :route53 credentials11695)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11697
      getTrafficPolicy
      (route53/get-traffic-policy-request
       (clojure.core/nth args11696 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-rrset
   [m11698]
   (clojure.core/let
    [credentials11699 (:credentials m11698) args11700 (:args m11698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11701
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11699)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11701
       listChangeBatchesByRRSet
       (route53/list-change-batches-by-rrset-request
        (clojure.core/nth args11700 0)))))))
  (clojure.core/defn
   list-change-batches-by-rrset-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByRRSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-rrset,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-rrset
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByRRSet"}
   [credentials11703 & args11704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11705
     (com.palletops.awaze.common/aws-client :route53 credentials11703)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11705
      listChangeBatchesByRRSet
      (route53/list-change-batches-by-rrset-request
       (clojure.core/nth args11704 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m11706]
   (clojure.core/let
    [credentials11707 (:credentials m11706) args11708 (:args m11706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11709
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11709
       listResourceRecordSets
       (route53/list-resource-record-sets-request
        (clojure.core/nth args11708 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-resource-record-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Call listResourceRecordSets"}
   [credentials11711 & args11712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11713
     (com.palletops.awaze.common/aws-client :route53 credentials11711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11713
      listResourceRecordSets
      (route53/list-resource-record-sets-request
       (clojure.core/nth args11712 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :disassociate-vpcfrom-hosted-zone
   [m11714]
   (clojure.core/let
    [credentials11715 (:credentials m11714) args11716 (:args m11714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11717
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11717
       disassociateVPCFromHostedZone
       (route53/disassociate-vpcfrom-hosted-zone-request
        (clojure.core/nth args11716 0)))))))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for disassociateVPCFromHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-vpcfrom-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call disassociateVPCFromHostedZone"}
   [credentials11719 & args11720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11721
     (com.palletops.awaze.common/aws-client :route53 credentials11719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11721
      disassociateVPCFromHostedZone
      (route53/disassociate-vpcfrom-hosted-zone-request
       (clojure.core/nth args11720 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances
   [m11722]
   (clojure.core/let
    [credentials11723 (:credentials m11722) args11724 (:args m11722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11725
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11723)]
     (clojure.core/case
      (clojure.core/count args11724)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11725
        listTrafficPolicyInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11725
        listTrafficPolicyInstances
        (route53/list-traffic-policy-instances-request
         (clojure.core/nth args11724 0))))))))
  (clojure.core/defn
   list-traffic-policy-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstances, listTrafficPolicyInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstances, listTrafficPolicyInstances"}
   [credentials11727 & args11728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11729
     (com.palletops.awaze.common/aws-client :route53 credentials11727)]
    (clojure.core/case
     (clojure.core/count args11728)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11729
       listTrafficPolicyInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11729
       listTrafficPolicyInstances
       (route53/list-traffic-policy-instances-request
        (clojure.core/nth args11728 0)))))))))
