(ns
 com.palletops.awaze.redshift
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.redshift :as redshift]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ParameterApplyType}
parameter-apply-type
  [m8854]
  (.
   com.amazonaws.services.redshift.model.ParameterApplyType
   fromValue
   (clojure.core/name m8854)))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Tag}
tag
  [m8857]
  (clojure.core/let
   [bean8856 (new com.amazonaws.services.redshift.model.Tag)]
   (clojure.core/let
    [v8858 (:key m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (. bean8856 setKey (clojure.core/str v8858))))
   (clojure.core/let
    [v8858 (:value m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (. bean8856 setValue (clojure.core/str v8858))))
   bean8856))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Parameter}
parameter
  [m8860]
  (clojure.core/let
   [bean8859 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/let
    [v8861
     (:description m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setDescription (clojure.core/str v8861))))
   (clojure.core/let
    [v8861
     (:data-type m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setDataType (clojure.core/str v8861))))
   (clojure.core/let
    [v8861
     (:parameter-value
      m8860
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setParameterValue (clojure.core/str v8861))))
   (clojure.core/let
    [v8861
     (:parameter-name m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setParameterName (clojure.core/str v8861))))
   (clojure.core/let
    [v8861
     (:is-modifiable m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setIsModifiable (clojure.core/boolean v8861))))
   (clojure.core/let
    [v8861
     (:minimum-engine-version
      m8860
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setMinimumEngineVersion (clojure.core/str v8861))))
   (clojure.core/let
    [v8861
     (:apply-type m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setApplyType (redshift/parameter-apply-type v8861))))
   (clojure.core/let
    [v8861
     (:allowed-values m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setAllowedValues (clojure.core/str v8861))))
   (clojure.core/let
    [v8861 (:source m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setSource (clojure.core/str v8861))))
   bean8859))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeResizeRequest}
describe-resize-request
  [m8863]
  (clojure.core/let
   [bean8862
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/let
    [v8864
     (:cluster-identifier
      m8863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8864 :com.palletops.awaze.client-builder/undef)
     (. bean8862 setClusterIdentifier (clojure.core/str v8864))))
   bean8862))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest}
describe-cluster-snapshots-request
  [m8866]
  (clojure.core/let
   [bean8865
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/let
    [v8867
     (:cluster-identifier
      m8866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setClusterIdentifier (clojure.core/str v8867))))
   (clojure.core/let
    [v8867
     (:snapshot-type m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setSnapshotType (clojure.core/str v8867))))
   (clojure.core/let
    [v8867 (:marker m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setMarker (clojure.core/str v8867))))
   (clojure.core/let
    [v8867
     (:tag-values m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (.
      bean8865
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9048] (clojure.core/str arg9048))
 v8867))))
   (clojure.core/let
    [v8867
     (:start-time m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (.
      bean8865
      setStartTime
      (com.palletops.awaze.common/to-date v8867))))
   (clojure.core/let
    [v8867
     (:max-records m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setMaxRecords (clojure.core/int v8867))))
   (clojure.core/let
    [v8867
     (:end-time m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (.
      bean8865
      setEndTime
      (com.palletops.awaze.common/to-date v8867))))
   (clojure.core/let
    [v8867
     (:snapshot-identifier
      m8866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setSnapshotIdentifier (clojure.core/str v8867))))
   (clojure.core/let
    [v8867
     (:owner-account m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setOwnerAccount (clojure.core/str v8867))))
   (clojure.core/let
    [v8867
     (:tag-keys m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (.
      bean8865
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9049] (clojure.core/str arg9049))
 v8867))))
   bean8865))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest}
describe-default-cluster-parameters-request
  [m8869]
  (clojure.core/let
   [bean8868
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/let
    [v8870 (:marker m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setMarker (clojure.core/str v8870))))
   (clojure.core/let
    [v8870
     (:max-records m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setMaxRecords (clojure.core/int v8870))))
   (clojure.core/let
    [v8870
     (:parameter-group-family
      m8869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setParameterGroupFamily (clojure.core/str v8870))))
   bean8868))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest}
create-hsm-client-certificate-request
  [m8872]
  (clojure.core/let
   [bean8871
    (new
     com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest)]
   (clojure.core/let
    [v8873 (:tags m8872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8873 :com.palletops.awaze.client-builder/undef)
     (.
      bean8871
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9050] (redshift/tag arg9050))
 v8873))))
   (clojure.core/let
    [v8873
     (:hsm-client-certificate-identifier
      m8872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8873 :com.palletops.awaze.client-builder/undef)
     (.
      bean8871
      setHsmClientCertificateIdentifier
      (clojure.core/str v8873))))
   bean8871))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest}
describe-cluster-versions-request
  [m8875]
  (clojure.core/let
   [bean8874
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/let
    [v8876 (:marker m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setMarker (clojure.core/str v8876))))
   (clojure.core/let
    [v8876
     (:max-records m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setMaxRecords (clojure.core/int v8876))))
   (clojure.core/let
    [v8876
     (:cluster-version
      m8875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setClusterVersion (clojure.core/str v8876))))
   (clojure.core/let
    [v8876
     (:cluster-parameter-group-family
      m8875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (.
      bean8874
      setClusterParameterGroupFamily
      (clojure.core/str v8876))))
   bean8874))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest}
enable-snapshot-copy-request
  [m8878]
  (clojure.core/let
   [bean8877
    (new
     com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest)]
   (clojure.core/let
    [v8879
     (:destination-region
      m8878
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8879 :com.palletops.awaze.client-builder/undef)
     (. bean8877 setDestinationRegion (clojure.core/str v8879))))
   (clojure.core/let
    [v8879
     (:cluster-identifier
      m8878
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8879 :com.palletops.awaze.client-builder/undef)
     (. bean8877 setClusterIdentifier (clojure.core/str v8879))))
   (clojure.core/let
    [v8879
     (:retention-period
      m8878
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8879 :com.palletops.awaze.client-builder/undef)
     (. bean8877 setRetentionPeriod (clojure.core/int v8879))))
   (clojure.core/let
    [v8879
     (:snapshot-copy-grant-name
      m8878
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8879 :com.palletops.awaze.client-builder/undef)
     (. bean8877 setSnapshotCopyGrantName (clojure.core/str v8879))))
   bean8877))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest}
create-snapshot-copy-grant-request
  [m8881]
  (clojure.core/let
   [bean8880
    (new
     com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8882
     (:kms-key-id m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (. bean8880 setKmsKeyId (clojure.core/str v8882))))
   (clojure.core/let
    [v8882 (:tags m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (.
      bean8880
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9051] (redshift/tag arg9051))
 v8882))))
   (clojure.core/let
    [v8882
     (:snapshot-copy-grant-name
      m8881
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (. bean8880 setSnapshotCopyGrantName (clojure.core/str v8882))))
   bean8880))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest}
describe-cluster-parameter-groups-request
  [m8884]
  (clojure.core/let
   [bean8883
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/let
    [v8885 (:marker m8884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setMarker (clojure.core/str v8885))))
   (clojure.core/let
    [v8885
     (:max-records m8884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setMaxRecords (clojure.core/int v8885))))
   (clojure.core/let
    [v8885
     (:tag-values m8884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (.
      bean8883
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9052] (clojure.core/str arg9052))
 v8885))))
   (clojure.core/let
    [v8885
     (:parameter-group-name
      m8884
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setParameterGroupName (clojure.core/str v8885))))
   (clojure.core/let
    [v8885
     (:tag-keys m8884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (.
      bean8883
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9053] (clojure.core/str arg9053))
 v8885))))
   bean8883))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest}
delete-cluster-parameter-group-request
  [m8887]
  (clojure.core/let
   [bean8886
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/let
    [v8888
     (:parameter-group-name
      m8887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8888 :com.palletops.awaze.client-builder/undef)
     (. bean8886 setParameterGroupName (clojure.core/str v8888))))
   bean8886))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventsRequest}
describe-events-request
  [m8890]
  (clojure.core/let
   [bean8889
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/let
    [v8891 (:marker m8890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (. bean8889 setMarker (clojure.core/str v8891))))
   (clojure.core/let
    [v8891
     (:max-records m8890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (. bean8889 setMaxRecords (clojure.core/int v8891))))
   (clojure.core/let
    [v8891
     (:start-time m8890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (.
      bean8889
      setStartTime
      (com.palletops.awaze.common/to-date v8891))))
   (clojure.core/let
    [v8891
     (:end-time m8890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (.
      bean8889
      setEndTime
      (com.palletops.awaze.common/to-date v8891))))
   (clojure.core/let
    [v8891
     (:source-identifier
      m8890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (. bean8889 setSourceIdentifier (clojure.core/str v8891))))
   (clojure.core/let
    [v8891
     (:source-type m8890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (. bean8889 setSourceType (clojure.core/str v8891))))
   (clojure.core/let
    [v8891
     (:duration m8890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (. bean8889 setDuration (clojure.core/int v8891))))
   bean8889))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodesRequest}
describe-reserved-nodes-request
  [m8893]
  (clojure.core/let
   [bean8892
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/let
    [v8894 (:marker m8893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (. bean8892 setMarker (clojure.core/str v8894))))
   (clojure.core/let
    [v8894
     (:max-records m8893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (. bean8892 setMaxRecords (clojure.core/int v8894))))
   (clojure.core/let
    [v8894
     (:reserved-node-id
      m8893
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (. bean8892 setReservedNodeId (clojure.core/str v8894))))
   bean8892))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest}
modify-cluster-iam-roles-request
  [m8896]
  (clojure.core/let
   [bean8895
    (new
     com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest)]
   (clojure.core/let
    [v8897
     (:cluster-identifier
      m8896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8897 :com.palletops.awaze.client-builder/undef)
     (. bean8895 setClusterIdentifier (clojure.core/str v8897))))
   (clojure.core/let
    [v8897
     (:add-iam-roles m8896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8897 :com.palletops.awaze.client-builder/undef)
     (.
      bean8895
      setAddIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9054] (clojure.core/str arg9054))
 v8897))))
   (clojure.core/let
    [v8897
     (:remove-iam-roles
      m8896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8897 :com.palletops.awaze.client-builder/undef)
     (.
      bean8895
      setRemoveIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9055] (clojure.core/str arg9055))
 v8897))))
   bean8895))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m8899]
  (clojure.core/let
   [bean8898
    (new
     com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest)]
   (clojure.core/let
    [v8900
     (:subscription-name
      m8899
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (. bean8898 setSubscriptionName (clojure.core/str v8900))))
   bean8898))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RebootClusterRequest}
reboot-cluster-request
  [m8902]
  (clojure.core/let
   [bean8901
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/let
    [v8903
     (:cluster-identifier
      m8902
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8903 :com.palletops.awaze.client-builder/undef)
     (. bean8901 setClusterIdentifier (clojure.core/str v8903))))
   bean8901))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest}
create-cluster-security-group-request
  [m8905]
  (clojure.core/let
   [bean8904
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/let
    [v8906
     (:description m8905 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8906 :com.palletops.awaze.client-builder/undef)
     (. bean8904 setDescription (clojure.core/str v8906))))
   (clojure.core/let
    [v8906 (:tags m8905 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8906 :com.palletops.awaze.client-builder/undef)
     (.
      bean8904
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9056] (redshift/tag arg9056))
 v8906))))
   (clojure.core/let
    [v8906
     (:cluster-security-group-name
      m8905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8906 :com.palletops.awaze.client-builder/undef)
     (. bean8904 setClusterSecurityGroupName (clojure.core/str v8906))))
   bean8904))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest}
modify-cluster-parameter-group-request
  [m8908]
  (clojure.core/let
   [bean8907
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/let
    [v8909
     (:parameter-group-name
      m8908
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8909 :com.palletops.awaze.client-builder/undef)
     (. bean8907 setParameterGroupName (clojure.core/str v8909))))
   (clojure.core/let
    [v8909
     (:parameters m8908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8909 :com.palletops.awaze.client-builder/undef)
     (.
      bean8907
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9057] (redshift/parameter arg9057))
 v8909))))
   bean8907))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest}
modify-snapshot-copy-retention-period-request
  [m8911]
  (clojure.core/let
   [bean8910
    (new
     com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest)]
   (clojure.core/let
    [v8912
     (:cluster-identifier
      m8911
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8912 :com.palletops.awaze.client-builder/undef)
     (. bean8910 setClusterIdentifier (clojure.core/str v8912))))
   (clojure.core/let
    [v8912
     (:retention-period
      m8911
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8912 :com.palletops.awaze.client-builder/undef)
     (. bean8910 setRetentionPeriod (clojure.core/int v8912))))
   bean8910))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest}
delete-snapshot-copy-grant-request
  [m8914]
  (clojure.core/let
   [bean8913
    (new
     com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8915
     (:snapshot-copy-grant-name
      m8914
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (. bean8913 setSnapshotCopyGrantName (clojure.core/str v8915))))
   bean8913))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest}
authorize-snapshot-access-request
  [m8917]
  (clojure.core/let
   [bean8916
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/let
    [v8918
     (:snapshot-identifier
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setSnapshotIdentifier (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:snapshot-cluster-identifier
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setSnapshotClusterIdentifier
      (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:account-with-restore-access
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setAccountWithRestoreAccess (clojure.core/str v8918))))
   bean8916))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableLoggingRequest}
disable-logging-request
  [m8920]
  (clojure.core/let
   [bean8919
    (new com.amazonaws.services.redshift.model.DisableLoggingRequest)]
   (clojure.core/let
    [v8921
     (:cluster-identifier
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setClusterIdentifier (clojure.core/str v8921))))
   bean8919))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest}
modify-cluster-subnet-group-request
  [m8923]
  (clojure.core/let
   [bean8922
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8924
     (:description m8923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8924 :com.palletops.awaze.client-builder/undef)
     (. bean8922 setDescription (clojure.core/str v8924))))
   (clojure.core/let
    [v8924
     (:subnet-ids m8923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8924 :com.palletops.awaze.client-builder/undef)
     (.
      bean8922
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9058] (clojure.core/str arg9058))
 v8924))))
   (clojure.core/let
    [v8924
     (:cluster-subnet-group-name
      m8923
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8924 :com.palletops.awaze.client-builder/undef)
     (. bean8922 setClusterSubnetGroupName (clojure.core/str v8924))))
   bean8922))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterRequest}
modify-cluster-request
  [m8926]
  (clojure.core/let
   [bean8925
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/let
    [v8927
     (:cluster-version
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setClusterVersion (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:cluster-type m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setClusterType (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:cluster-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setClusterIdentifier (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:elastic-ip m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setElasticIp (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:allow-version-upgrade
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setAllowVersionUpgrade (clojure.core/boolean v8927))))
   (clojure.core/let
    [v8927
     (:hsm-client-certificate-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setHsmClientCertificateIdentifier
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:new-cluster-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setNewClusterIdentifier (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:automated-snapshot-retention-period
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8927))))
   (clojure.core/let
    [v8927
     (:master-user-password
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setMasterUserPassword (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:publicly-accessible
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setPubliclyAccessible (clojure.core/boolean v8927))))
   (clojure.core/let
    [v8927
     (:preferred-maintenance-window
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setPreferredMaintenanceWindow
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:node-type m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setNodeType (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:hsm-configuration-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setHsmConfigurationIdentifier
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:cluster-security-groups
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9059] (clojure.core/str arg9059))
 v8927))))
   (clojure.core/let
    [v8927
     (:vpc-security-group-ids
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9060] (clojure.core/str arg9060))
 v8927))))
   (clojure.core/let
    [v8927
     (:cluster-parameter-group-name
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setClusterParameterGroupName
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:number-of-nodes
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setNumberOfNodes (clojure.core/int v8927))))
   bean8925))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest}
restore-from-cluster-snapshot-request
  [m8929]
  (clojure.core/let
   [bean8928
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/let
    [v8930
     (:cluster-subnet-group-name
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setClusterSubnetGroupName (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:cluster-identifier
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setClusterIdentifier (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:elastic-ip m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setElasticIp (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:allow-version-upgrade
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setAllowVersionUpgrade (clojure.core/boolean v8930))))
   (clojure.core/let
    [v8930
     (:additional-info
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setAdditionalInfo (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:hsm-client-certificate-identifier
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setHsmClientCertificateIdentifier
      (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:availability-zone
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setAvailabilityZone (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:automated-snapshot-retention-period
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8930))))
   (clojure.core/let
    [v8930
     (:publicly-accessible
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setPubliclyAccessible (clojure.core/boolean v8930))))
   (clojure.core/let
    [v8930
     (:preferred-maintenance-window
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setPreferredMaintenanceWindow
      (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:snapshot-cluster-identifier
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setSnapshotClusterIdentifier
      (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:iam-roles m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9061] (clojure.core/str arg9061))
 v8930))))
   (clojure.core/let
    [v8930 (:port m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setPort (clojure.core/int v8930))))
   (clojure.core/let
    [v8930
     (:node-type m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setNodeType (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:hsm-configuration-identifier
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setHsmConfigurationIdentifier
      (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:cluster-security-groups
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9062] (clojure.core/str arg9062))
 v8930))))
   (clojure.core/let
    [v8930
     (:snapshot-identifier
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setSnapshotIdentifier (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:owner-account m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setOwnerAccount (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:vpc-security-group-ids
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9063] (clojure.core/str arg9063))
 v8930))))
   (clojure.core/let
    [v8930
     (:cluster-parameter-group-name
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (.
      bean8928
      setClusterParameterGroupName
      (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:kms-key-id m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setKmsKeyId (clojure.core/str v8930))))
   bean8928))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest}
delete-hsm-client-certificate-request
  [m8932]
  (clojure.core/let
   [bean8931
    (new
     com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest)]
   (clojure.core/let
    [v8933
     (:hsm-client-certificate-identifier
      m8932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (.
      bean8931
      setHsmClientCertificateIdentifier
      (clojure.core/str v8933))))
   bean8931))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterRequest}
create-cluster-request
  [m8935]
  (clojure.core/let
   [bean8934
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/let
    [v8936
     (:cluster-version
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setClusterVersion (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:cluster-type m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setClusterType (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:cluster-subnet-group-name
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setClusterSubnetGroupName (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:cluster-identifier
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setClusterIdentifier (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:elastic-ip m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setElasticIp (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:allow-version-upgrade
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setAllowVersionUpgrade (clojure.core/boolean v8936))))
   (clojure.core/let
    [v8936
     (:additional-info
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setAdditionalInfo (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:hsm-client-certificate-identifier
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setHsmClientCertificateIdentifier
      (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:availability-zone
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setAvailabilityZone (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:automated-snapshot-retention-period
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8936))))
   (clojure.core/let
    [v8936
     (:master-user-password
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setMasterUserPassword (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:publicly-accessible
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setPubliclyAccessible (clojure.core/boolean v8936))))
   (clojure.core/let
    [v8936
     (:preferred-maintenance-window
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setPreferredMaintenanceWindow
      (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:iam-roles m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9064] (clojure.core/str arg9064))
 v8936))))
   (clojure.core/let
    [v8936 (:port m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setPort (clojure.core/int v8936))))
   (clojure.core/let
    [v8936 (:tags m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9065] (redshift/tag arg9065))
 v8936))))
   (clojure.core/let
    [v8936
     (:node-type m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setNodeType (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:hsm-configuration-identifier
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setHsmConfigurationIdentifier
      (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:cluster-security-groups
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9066] (clojure.core/str arg9066))
 v8936))))
   (clojure.core/let
    [v8936
     (:vpc-security-group-ids
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9067] (clojure.core/str arg9067))
 v8936))))
   (clojure.core/let
    [v8936
     (:cluster-parameter-group-name
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setClusterParameterGroupName
      (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:master-username
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setMasterUsername (clojure.core/str v8936))))
   (clojure.core/let
    [v8936 (:dbname m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setDBName (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:kms-key-id m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setKmsKeyId (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:encrypted m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setEncrypted (clojure.core/boolean v8936))))
   (clojure.core/let
    [v8936
     (:number-of-nodes
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setNumberOfNodes (clojure.core/int v8936))))
   bean8934))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest}
describe-logging-status-request
  [m8938]
  (clojure.core/let
   [bean8937
    (new
     com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest)]
   (clojure.core/let
    [v8939
     (:cluster-identifier
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setClusterIdentifier (clojure.core/str v8939))))
   bean8937))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest}
describe-table-restore-status-request
  [m8941]
  (clojure.core/let
   [bean8940
    (new
     com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest)]
   (clojure.core/let
    [v8942 (:marker m8941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setMarker (clojure.core/str v8942))))
   (clojure.core/let
    [v8942
     (:max-records m8941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setMaxRecords (clojure.core/int v8942))))
   (clojure.core/let
    [v8942
     (:cluster-identifier
      m8941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setClusterIdentifier (clojure.core/str v8942))))
   (clojure.core/let
    [v8942
     (:table-restore-request-id
      m8941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setTableRestoreRequestId (clojure.core/str v8942))))
   bean8940))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m8944]
  (clojure.core/let
   [bean8943
    (new
     com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest)]
   (clojure.core/let
    [v8945
     (:source-type m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setSourceType (clojure.core/str v8945))))
   bean8943))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParametersRequest}
describe-cluster-parameters-request
  [m8947]
  (clojure.core/let
   [bean8946
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/let
    [v8948 (:marker m8947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8948 :com.palletops.awaze.client-builder/undef)
     (. bean8946 setMarker (clojure.core/str v8948))))
   (clojure.core/let
    [v8948
     (:max-records m8947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8948 :com.palletops.awaze.client-builder/undef)
     (. bean8946 setMaxRecords (clojure.core/int v8948))))
   (clojure.core/let
    [v8948 (:source m8947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8948 :com.palletops.awaze.client-builder/undef)
     (. bean8946 setSource (clojure.core/str v8948))))
   (clojure.core/let
    [v8948
     (:parameter-group-name
      m8947
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8948 :com.palletops.awaze.client-builder/undef)
     (. bean8946 setParameterGroupName (clojure.core/str v8948))))
   bean8946))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest}
authorize-cluster-security-group-ingress-request
  [m8950]
  (clojure.core/let
   [bean8949
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v8951
     (:cluster-security-group-name
      m8950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setClusterSecurityGroupName (clojure.core/str v8951))))
   (clojure.core/let
    [v8951 (:cidrip m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setCIDRIP (clojure.core/str v8951))))
   (clojure.core/let
    [v8951
     (:ec2security-group-name
      m8950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setEC2SecurityGroupName (clojure.core/str v8951))))
   (clojure.core/let
    [v8951
     (:ec2security-group-owner-id
      m8950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setEC2SecurityGroupOwnerId (clojure.core/str v8951))))
   bean8949))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClustersRequest}
describe-clusters-request
  [m8953]
  (clojure.core/let
   [bean8952
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/let
    [v8954 (:marker m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setMarker (clojure.core/str v8954))))
   (clojure.core/let
    [v8954
     (:max-records m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setMaxRecords (clojure.core/int v8954))))
   (clojure.core/let
    [v8954
     (:tag-values m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (.
      bean8952
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9068] (clojure.core/str arg9068))
 v8954))))
   (clojure.core/let
    [v8954
     (:cluster-identifier
      m8953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setClusterIdentifier (clojure.core/str v8954))))
   (clojure.core/let
    [v8954
     (:tag-keys m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (.
      bean8952
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9069] (clojure.core/str arg9069))
 v8954))))
   bean8952))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest}
delete-cluster-subnet-group-request
  [m8956]
  (clojure.core/let
   [bean8955
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8957
     (:cluster-subnet-group-name
      m8956
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8957 :com.palletops.awaze.client-builder/undef)
     (. bean8955 setClusterSubnetGroupName (clojure.core/str v8957))))
   bean8955))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest}
describe-cluster-security-groups-request
  [m8959]
  (clojure.core/let
   [bean8958
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/let
    [v8960 (:marker m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setMarker (clojure.core/str v8960))))
   (clojure.core/let
    [v8960
     (:max-records m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setMaxRecords (clojure.core/int v8960))))
   (clojure.core/let
    [v8960
     (:tag-values m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (.
      bean8958
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9070] (clojure.core/str arg9070))
 v8960))))
   (clojure.core/let
    [v8960
     (:cluster-security-group-name
      m8959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setClusterSecurityGroupName (clojure.core/str v8960))))
   (clojure.core/let
    [v8960
     (:tag-keys m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (.
      bean8958
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9071] (clojure.core/str arg9071))
 v8960))))
   bean8958))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTagsRequest}
describe-tags-request
  [m8962]
  (clojure.core/let
   [bean8961
    (new com.amazonaws.services.redshift.model.DescribeTagsRequest)]
   (clojure.core/let
    [v8963 (:marker m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setMarker (clojure.core/str v8963))))
   (clojure.core/let
    [v8963
     (:max-records m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setMaxRecords (clojure.core/int v8963))))
   (clojure.core/let
    [v8963
     (:resource-type m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setResourceType (clojure.core/str v8963))))
   (clojure.core/let
    [v8963
     (:resource-name m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setResourceName (clojure.core/str v8963))))
   (clojure.core/let
    [v8963
     (:tag-values m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (.
      bean8961
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9072] (clojure.core/str arg9072))
 v8963))))
   (clojure.core/let
    [v8963
     (:tag-keys m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (.
      bean8961
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9073] (clojure.core/str arg9073))
 v8963))))
   bean8961))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest}
disable-snapshot-copy-request
  [m8965]
  (clojure.core/let
   [bean8964
    (new
     com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest)]
   (clojure.core/let
    [v8966
     (:cluster-identifier
      m8965
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8966 :com.palletops.awaze.client-builder/undef)
     (. bean8964 setClusterIdentifier (clojure.core/str v8966))))
   bean8964))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteTagsRequest}
delete-tags-request
  [m8968]
  (clojure.core/let
   [bean8967
    (new com.amazonaws.services.redshift.model.DeleteTagsRequest)]
   (clojure.core/let
    [v8969
     (:resource-name m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (. bean8967 setResourceName (clojure.core/str v8969))))
   (clojure.core/let
    [v8969
     (:tag-keys m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (.
      bean8967
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9074] (clojure.core/str arg9074))
 v8969))))
   bean8967))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest}
purchase-reserved-node-offering-request
  [m8971]
  (clojure.core/let
   [bean8970
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/let
    [v8972
     (:reserved-node-offering-id
      m8971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setReservedNodeOfferingId (clojure.core/str v8972))))
   (clojure.core/let
    [v8972
     (:node-count m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setNodeCount (clojure.core/int v8972))))
   bean8970))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest}
delete-cluster-snapshot-request
  [m8974]
  (clojure.core/let
   [bean8973
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/let
    [v8975
     (:snapshot-identifier
      m8974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (. bean8973 setSnapshotIdentifier (clojure.core/str v8975))))
   (clojure.core/let
    [v8975
     (:snapshot-cluster-identifier
      m8974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (.
      bean8973
      setSnapshotClusterIdentifier
      (clojure.core/str v8975))))
   bean8973))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest}
create-cluster-parameter-group-request
  [m8977]
  (clojure.core/let
   [bean8976
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/let
    [v8978
     (:description m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (. bean8976 setDescription (clojure.core/str v8978))))
   (clojure.core/let
    [v8978 (:tags m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (.
      bean8976
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9075] (redshift/tag arg9075))
 v8978))))
   (clojure.core/let
    [v8978
     (:parameter-group-family
      m8977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (. bean8976 setParameterGroupFamily (clojure.core/str v8978))))
   (clojure.core/let
    [v8978
     (:parameter-group-name
      m8977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (. bean8976 setParameterGroupName (clojure.core/str v8978))))
   bean8976))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest}
rotate-encryption-key-request
  [m8980]
  (clojure.core/let
   [bean8979
    (new
     com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest)]
   (clojure.core/let
    [v8981
     (:cluster-identifier
      m8980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8981 :com.palletops.awaze.client-builder/undef)
     (. bean8979 setClusterIdentifier (clojure.core/str v8981))))
   bean8979))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest}
describe-hsm-client-certificates-request
  [m8983]
  (clojure.core/let
   [bean8982
    (new
     com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest)]
   (clojure.core/let
    [v8984 (:marker m8983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (. bean8982 setMarker (clojure.core/str v8984))))
   (clojure.core/let
    [v8984
     (:max-records m8983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (. bean8982 setMaxRecords (clojure.core/int v8984))))
   (clojure.core/let
    [v8984
     (:tag-values m8983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (.
      bean8982
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9076] (clojure.core/str arg9076))
 v8984))))
   (clojure.core/let
    [v8984
     (:hsm-client-certificate-identifier
      m8983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (.
      bean8982
      setHsmClientCertificateIdentifier
      (clojure.core/str v8984))))
   (clojure.core/let
    [v8984
     (:tag-keys m8983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (.
      bean8982
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9077] (clojure.core/str arg9077))
 v8984))))
   bean8982))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest}
describe-snapshot-copy-grants-request
  [m8986]
  (clojure.core/let
   [bean8985
    (new
     com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest)]
   (clojure.core/let
    [v8987 (:marker m8986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setMarker (clojure.core/str v8987))))
   (clojure.core/let
    [v8987
     (:max-records m8986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setMaxRecords (clojure.core/int v8987))))
   (clojure.core/let
    [v8987
     (:tag-values m8986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (.
      bean8985
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9078] (clojure.core/str arg9078))
 v8987))))
   (clojure.core/let
    [v8987
     (:snapshot-copy-grant-name
      m8986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setSnapshotCopyGrantName (clojure.core/str v8987))))
   (clojure.core/let
    [v8987
     (:tag-keys m8986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (.
      bean8985
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9079] (clojure.core/str arg9079))
 v8987))))
   bean8985))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest}
reset-cluster-parameter-group-request
  [m8989]
  (clojure.core/let
   [bean8988
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/let
    [v8990
     (:parameter-group-name
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setParameterGroupName (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:reset-all-parameters
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setResetAllParameters (clojure.core/boolean v8990))))
   (clojure.core/let
    [v8990
     (:parameters m8989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (.
      bean8988
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9080] (redshift/parameter arg9080))
 v8990))))
   bean8988))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest}
delete-cluster-security-group-request
  [m8992]
  (clojure.core/let
   [bean8991
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/let
    [v8993
     (:cluster-security-group-name
      m8992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setClusterSecurityGroupName (clojure.core/str v8993))))
   bean8991))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest}
copy-cluster-snapshot-request
  [m8995]
  (clojure.core/let
   [bean8994
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/let
    [v8996
     (:source-snapshot-identifier
      m8995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setSourceSnapshotIdentifier (clojure.core/str v8996))))
   (clojure.core/let
    [v8996
     (:source-snapshot-cluster-identifier
      m8995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (.
      bean8994
      setSourceSnapshotClusterIdentifier
      (clojure.core/str v8996))))
   (clojure.core/let
    [v8996
     (:target-snapshot-identifier
      m8995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setTargetSnapshotIdentifier (clojure.core/str v8996))))
   bean8994))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest}
restore-table-from-cluster-snapshot-request
  [m8998]
  (clojure.core/let
   [bean8997
    (new
     com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest)]
   (clojure.core/let
    [v8999
     (:snapshot-identifier
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setSnapshotIdentifier (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:cluster-identifier
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setClusterIdentifier (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:source-database-name
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setSourceDatabaseName (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:source-schema-name
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setSourceSchemaName (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:source-table-name
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setSourceTableName (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:target-database-name
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setTargetDatabaseName (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:target-schema-name
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setTargetSchemaName (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:new-table-name m8998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setNewTableName (clojure.core/str v8999))))
   bean8997))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m9001]
  (clojure.core/let
   [bean9000
    (new
     com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest)]
   (clojure.core/let
    [v9002
     (:source-type m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setSourceType (clojure.core/str v9002))))
   (clojure.core/let
    [v9002
     (:sns-topic-arn m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setSnsTopicArn (clojure.core/str v9002))))
   (clojure.core/let
    [v9002
     (:source-ids m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (.
      bean9000
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9081] (clojure.core/str arg9081))
 v9002))))
   (clojure.core/let
    [v9002
     (:event-categories
      m9001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (.
      bean9000
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9082] (clojure.core/str arg9082))
 v9002))))
   (clojure.core/let
    [v9002
     (:severity m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setSeverity (clojure.core/str v9002))))
   (clojure.core/let
    [v9002
     (:subscription-name
      m9001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setSubscriptionName (clojure.core/str v9002))))
   (clojure.core/let
    [v9002 (:enabled m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setEnabled (clojure.core/boolean v9002))))
   bean9000))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest}
create-hsm-configuration-request
  [m9004]
  (clojure.core/let
   [bean9003
    (new
     com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest)]
   (clojure.core/let
    [v9005
     (:description m9004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setDescription (clojure.core/str v9005))))
   (clojure.core/let
    [v9005 (:tags m9004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (.
      bean9003
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9083] (redshift/tag arg9083))
 v9005))))
   (clojure.core/let
    [v9005
     (:hsm-configuration-identifier
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (.
      bean9003
      setHsmConfigurationIdentifier
      (clojure.core/str v9005))))
   (clojure.core/let
    [v9005
     (:hsm-ip-address m9004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setHsmIpAddress (clojure.core/str v9005))))
   (clojure.core/let
    [v9005
     (:hsm-partition-name
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setHsmPartitionName (clojure.core/str v9005))))
   (clojure.core/let
    [v9005
     (:hsm-partition-password
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setHsmPartitionPassword (clojure.core/str v9005))))
   (clojure.core/let
    [v9005
     (:hsm-server-public-certificate
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (.
      bean9003
      setHsmServerPublicCertificate
      (clojure.core/str v9005))))
   bean9003))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest}
describe-hsm-configurations-request
  [m9007]
  (clojure.core/let
   [bean9006
    (new
     com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest)]
   (clojure.core/let
    [v9008 (:marker m9007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setMarker (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:max-records m9007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setMaxRecords (clojure.core/int v9008))))
   (clojure.core/let
    [v9008
     (:tag-values m9007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (.
      bean9006
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9084] (clojure.core/str arg9084))
 v9008))))
   (clojure.core/let
    [v9008
     (:hsm-configuration-identifier
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (.
      bean9006
      setHsmConfigurationIdentifier
      (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:tag-keys m9007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (.
      bean9006
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9085] (clojure.core/str arg9085))
 v9008))))
   bean9006))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest}
describe-cluster-subnet-groups-request
  [m9010]
  (clojure.core/let
   [bean9009
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/let
    [v9011 (:marker m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setMarker (clojure.core/str v9011))))
   (clojure.core/let
    [v9011
     (:max-records m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setMaxRecords (clojure.core/int v9011))))
   (clojure.core/let
    [v9011
     (:tag-values m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (.
      bean9009
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9086] (clojure.core/str arg9086))
 v9011))))
   (clojure.core/let
    [v9011
     (:cluster-subnet-group-name
      m9010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setClusterSubnetGroupName (clojure.core/str v9011))))
   (clojure.core/let
    [v9011
     (:tag-keys m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (.
      bean9009
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9087] (clojure.core/str arg9087))
 v9011))))
   bean9009))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterRequest}
delete-cluster-request
  [m9013]
  (clojure.core/let
   [bean9012
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/let
    [v9014
     (:cluster-identifier
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (. bean9012 setClusterIdentifier (clojure.core/str v9014))))
   (clojure.core/let
    [v9014
     (:skip-final-cluster-snapshot
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (.
      bean9012
      setSkipFinalClusterSnapshot
      (clojure.core/boolean v9014))))
   (clojure.core/let
    [v9014
     (:final-cluster-snapshot-identifier
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (.
      bean9012
      setFinalClusterSnapshotIdentifier
      (clojure.core/str v9014))))
   bean9012))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest}
revoke-cluster-security-group-ingress-request
  [m9016]
  (clojure.core/let
   [bean9015
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v9017
     (:cluster-security-group-name
      m9016
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (. bean9015 setClusterSecurityGroupName (clojure.core/str v9017))))
   (clojure.core/let
    [v9017 (:cidrip m9016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (. bean9015 setCIDRIP (clojure.core/str v9017))))
   (clojure.core/let
    [v9017
     (:ec2security-group-name
      m9016
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (. bean9015 setEC2SecurityGroupName (clojure.core/str v9017))))
   (clojure.core/let
    [v9017
     (:ec2security-group-owner-id
      m9016
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (. bean9015 setEC2SecurityGroupOwnerId (clojure.core/str v9017))))
   bean9015))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest}
create-cluster-subnet-group-request
  [m9019]
  (clojure.core/let
   [bean9018
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/let
    [v9020
     (:description m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setDescription (clojure.core/str v9020))))
   (clojure.core/let
    [v9020 (:tags m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (.
      bean9018
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9088] (redshift/tag arg9088))
 v9020))))
   (clojure.core/let
    [v9020
     (:subnet-ids m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (.
      bean9018
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9089] (clojure.core/str arg9089))
 v9020))))
   (clojure.core/let
    [v9020
     (:cluster-subnet-group-name
      m9019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setClusterSubnetGroupName (clojure.core/str v9020))))
   bean9018))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest}
create-cluster-snapshot-request
  [m9022]
  (clojure.core/let
   [bean9021
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/let
    [v9023 (:tags m9022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (.
      bean9021
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9090] (redshift/tag arg9090))
 v9023))))
   (clojure.core/let
    [v9023
     (:snapshot-identifier
      m9022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (. bean9021 setSnapshotIdentifier (clojure.core/str v9023))))
   (clojure.core/let
    [v9023
     (:cluster-identifier
      m9022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (. bean9021 setClusterIdentifier (clojure.core/str v9023))))
   bean9021))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateTagsRequest}
create-tags-request
  [m9025]
  (clojure.core/let
   [bean9024
    (new com.amazonaws.services.redshift.model.CreateTagsRequest)]
   (clojure.core/let
    [v9026 (:tags m9025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (.
      bean9024
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9091] (redshift/tag arg9091))
 v9026))))
   (clojure.core/let
    [v9026
     (:resource-name m9025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (. bean9024 setResourceName (clojure.core/str v9026))))
   bean9024))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest}
describe-orderable-cluster-options-request
  [m9028]
  (clojure.core/let
   [bean9027
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/let
    [v9029 (:marker m9028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setMarker (clojure.core/str v9029))))
   (clojure.core/let
    [v9029
     (:max-records m9028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setMaxRecords (clojure.core/int v9029))))
   (clojure.core/let
    [v9029
     (:node-type m9028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setNodeType (clojure.core/str v9029))))
   (clojure.core/let
    [v9029
     (:cluster-version
      m9028
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setClusterVersion (clojure.core/str v9029))))
   bean9027))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableLoggingRequest}
enable-logging-request
  [m9031]
  (clojure.core/let
   [bean9030
    (new com.amazonaws.services.redshift.model.EnableLoggingRequest)]
   (clojure.core/let
    [v9032
     (:cluster-identifier
      m9031
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (. bean9030 setClusterIdentifier (clojure.core/str v9032))))
   (clojure.core/let
    [v9032
     (:s3key-prefix m9031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (. bean9030 setS3KeyPrefix (clojure.core/str v9032))))
   (clojure.core/let
    [v9032
     (:bucket-name m9031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (. bean9030 setBucketName (clojure.core/str v9032))))
   bean9030))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest}
revoke-snapshot-access-request
  [m9034]
  (clojure.core/let
   [bean9033
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/let
    [v9035
     (:snapshot-identifier
      m9034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9035 :com.palletops.awaze.client-builder/undef)
     (. bean9033 setSnapshotIdentifier (clojure.core/str v9035))))
   (clojure.core/let
    [v9035
     (:snapshot-cluster-identifier
      m9034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9035 :com.palletops.awaze.client-builder/undef)
     (.
      bean9033
      setSnapshotClusterIdentifier
      (clojure.core/str v9035))))
   (clojure.core/let
    [v9035
     (:account-with-restore-access
      m9034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9035 :com.palletops.awaze.client-builder/undef)
     (. bean9033 setAccountWithRestoreAccess (clojure.core/str v9035))))
   bean9033))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m9037]
  (clojure.core/let
   [bean9036
    (new
     com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/let
    [v9038 (:marker m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setMarker (clojure.core/str v9038))))
   (clojure.core/let
    [v9038
     (:max-records m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setMaxRecords (clojure.core/int v9038))))
   (clojure.core/let
    [v9038
     (:subscription-name
      m9037
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setSubscriptionName (clojure.core/str v9038))))
   bean9036))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest}
describe-reserved-node-offerings-request
  [m9040]
  (clojure.core/let
   [bean9039
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/let
    [v9041 (:marker m9040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9041 :com.palletops.awaze.client-builder/undef)
     (. bean9039 setMarker (clojure.core/str v9041))))
   (clojure.core/let
    [v9041
     (:max-records m9040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9041 :com.palletops.awaze.client-builder/undef)
     (. bean9039 setMaxRecords (clojure.core/int v9041))))
   (clojure.core/let
    [v9041
     (:reserved-node-offering-id
      m9040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9041 :com.palletops.awaze.client-builder/undef)
     (. bean9039 setReservedNodeOfferingId (clojure.core/str v9041))))
   bean9039))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest}
delete-hsm-configuration-request
  [m9043]
  (clojure.core/let
   [bean9042
    (new
     com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest)]
   (clojure.core/let
    [v9044
     (:hsm-configuration-identifier
      m9043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9044 :com.palletops.awaze.client-builder/undef)
     (.
      bean9042
      setHsmConfigurationIdentifier
      (clojure.core/str v9044))))
   bean9042))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m9046]
  (clojure.core/let
   [bean9045
    (new
     com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest)]
   (clojure.core/let
    [v9047 (:tags m9046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (.
      bean9045
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9196] (redshift/tag arg9196))
 v9047))))
   (clojure.core/let
    [v9047
     (:source-type m9046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (. bean9045 setSourceType (clojure.core/str v9047))))
   (clojure.core/let
    [v9047
     (:sns-topic-arn m9046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (. bean9045 setSnsTopicArn (clojure.core/str v9047))))
   (clojure.core/let
    [v9047
     (:source-ids m9046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (.
      bean9045
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9197] (clojure.core/str arg9197))
 v9047))))
   (clojure.core/let
    [v9047
     (:event-categories
      m9046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (.
      bean9045
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9198] (clojure.core/str arg9198))
 v9047))))
   (clojure.core/let
    [v9047
     (:severity m9046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (. bean9045 setSeverity (clojure.core/str v9047))))
   (clojure.core/let
    [v9047
     (:subscription-name
      m9046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (. bean9045 setSubscriptionName (clojure.core/str v9047))))
   (clojure.core/let
    [v9047 (:enabled m9046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (. bean9045 setEnabled (clojure.core/boolean v9047))))
   bean9045))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m9092]
   (clojure.core/let
    [credentials9093 (:credentials m9092) args9094 (:args m9092)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9095
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9093)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9095
       describeResize
       (redshift/describe-resize-request
        (clojure.core/nth args9094 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-resize,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeResize"}
   [credentials9097 & args9098]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9099
     (com.palletops.awaze.common/aws-client :redshift credentials9097)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9099
      describeResize
      (redshift/describe-resize-request (clojure.core/nth args9098 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m9100]
   (clojure.core/let
    [credentials9101 (:credentials m9100) args9102 (:args m9100)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9103
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9101)]
     (clojure.core/case
      (clojure.core/count args9102)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9103
        describeClusterSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9103
        describeClusterSnapshots
        (redshift/describe-cluster-snapshots-request
         (clojure.core/nth args9102 0))))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials9105 & args9106]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9107
     (com.palletops.awaze.common/aws-client :redshift credentials9105)]
    (clojure.core/case
     (clojure.core/count args9106)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9107
       describeClusterSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9107
       describeClusterSnapshots
       (redshift/describe-cluster-snapshots-request
        (clojure.core/nth args9106 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m9108]
   (clojure.core/let
    [credentials9109 (:credentials m9108) args9110 (:args m9108)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9111
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9109)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9111
       describeDefaultClusterParameters
       (redshift/describe-default-cluster-parameters-request
        (clojure.core/nth args9110 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials9113 & args9114]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9115
     (com.palletops.awaze.common/aws-client :redshift credentials9113)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9115
      describeDefaultClusterParameters
      (redshift/describe-default-cluster-parameters-request
       (clojure.core/nth args9114 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-client-certificate
   [m9116]
   (clojure.core/let
    [credentials9117 (:credentials m9116) args9118 (:args m9116)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9119
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9117)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9119
       createHsmClientCertificate
       (redshift/create-hsm-client-certificate-request
        (clojure.core/nth args9118 0)))))))
  (clojure.core/defn
   create-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmClientCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hsm-client-certificate,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmClientCertificate"}
   [credentials9121 & args9122]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9123
     (com.palletops.awaze.common/aws-client :redshift credentials9121)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9123
      createHsmClientCertificate
      (redshift/create-hsm-client-certificate-request
       (clojure.core/nth args9122 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m9124]
   (clojure.core/let
    [credentials9125 (:credentials m9124) args9126 (:args m9124)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9127
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9125)]
     (clojure.core/case
      (clojure.core/count args9126)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9127
        describeClusterVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9127
        describeClusterVersions
        (redshift/describe-cluster-versions-request
         (clojure.core/nth args9126 0))))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-versions,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-versions,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials9129 & args9130]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9131
     (com.palletops.awaze.common/aws-client :redshift credentials9129)]
    (clojure.core/case
     (clojure.core/count args9130)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9131
       describeClusterVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9131
       describeClusterVersions
       (redshift/describe-cluster-versions-request
        (clojure.core/nth args9130 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-snapshot-copy
   [m9132]
   (clojure.core/let
    [credentials9133 (:credentials m9132) args9134 (:args m9132)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9135
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9133)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9135
       enableSnapshotCopy
       (redshift/enable-snapshot-copy-request
        (clojure.core/nth args9134 0)))))))
  (clojure.core/defn
   enable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for enableSnapshotCopy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-snapshot-copy,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call enableSnapshotCopy"}
   [credentials9137 & args9138]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9139
     (com.palletops.awaze.common/aws-client :redshift credentials9137)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9139
      enableSnapshotCopy
      (redshift/enable-snapshot-copy-request
       (clojure.core/nth args9138 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-snapshot-copy-grant
   [m9140]
   (clojure.core/let
    [credentials9141 (:credentials m9140) args9142 (:args m9140)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9143
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9141)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9143
       createSnapshotCopyGrant
       (redshift/create-snapshot-copy-grant-request
        (clojure.core/nth args9142 0)))))))
  (clojure.core/defn
   create-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for createSnapshotCopyGrant"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot-copy-grant,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call createSnapshotCopyGrant"}
   [credentials9145 & args9146]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9147
     (com.palletops.awaze.common/aws-client :redshift credentials9145)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9147
      createSnapshotCopyGrant
      (redshift/create-snapshot-copy-grant-request
       (clojure.core/nth args9146 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m9148]
   (clojure.core/let
    [credentials9149 (:credentials m9148) args9150 (:args m9148)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9151
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9149)]
     (clojure.core/case
      (clojure.core/count args9150)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9151
        describeClusterParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9151
        describeClusterParameterGroups
        (redshift/describe-cluster-parameter-groups-request
         (clojure.core/nth args9150 0))))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials9153 & args9154]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9155
     (com.palletops.awaze.common/aws-client :redshift credentials9153)]
    (clojure.core/case
     (clojure.core/count args9154)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9155
       describeClusterParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9155
       describeClusterParameterGroups
       (redshift/describe-cluster-parameter-groups-request
        (clojure.core/nth args9154 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m9156]
   (clojure.core/let
    [credentials9157 (:credentials m9156) args9158 (:args m9156)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9159
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9157)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9159
       deleteClusterParameterGroup
       (redshift/delete-cluster-parameter-group-request
        (clojure.core/nth args9158 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials9161 & args9162]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9163
     (com.palletops.awaze.common/aws-client :redshift credentials9161)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9163
      deleteClusterParameterGroup
      (redshift/delete-cluster-parameter-group-request
       (clojure.core/nth args9162 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m9164]
   (clojure.core/let
    [credentials9165 (:credentials m9164) args9166 (:args m9164)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9167
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9165)]
     (clojure.core/case
      (clojure.core/count args9166)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9167
        describeEvents
        (redshift/describe-events-request
         (clojure.core/nth args9166 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9167
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials9169 & args9170]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9171
     (com.palletops.awaze.common/aws-client :redshift credentials9169)]
    (clojure.core/case
     (clojure.core/count args9170)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9171
       describeEvents
       (redshift/describe-events-request
        (clojure.core/nth args9170 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9171
       describeEvents))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m9172]
   (clojure.core/let
    [credentials9173 (:credentials m9172) args9174 (:args m9172)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9175
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9173)]
     (clojure.core/case
      (clojure.core/count args9174)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9175
        describeReservedNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9175
        describeReservedNodes
        (redshift/describe-reserved-nodes-request
         (clojure.core/nth args9174 0))))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-nodes,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-nodes,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials9177 & args9178]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9179
     (com.palletops.awaze.common/aws-client :redshift credentials9177)]
    (clojure.core/case
     (clojure.core/count args9178)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9179
       describeReservedNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9179
       describeReservedNodes
       (redshift/describe-reserved-nodes-request
        (clojure.core/nth args9178 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-iam-roles
   [m9180]
   (clojure.core/let
    [credentials9181 (:credentials m9180) args9182 (:args m9180)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9183
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9181)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9183
       modifyClusterIamRoles
       (redshift/modify-cluster-iam-roles-request
        (clojure.core/nth args9182 0)))))))
  (clojure.core/defn
   modify-cluster-iam-roles-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyClusterIamRoles"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-iam-roles,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-iam-roles
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyClusterIamRoles"}
   [credentials9185 & args9186]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9187
     (com.palletops.awaze.common/aws-client :redshift credentials9185)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9187
      modifyClusterIamRoles
      (redshift/modify-cluster-iam-roles-request
       (clojure.core/nth args9186 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-event-subscription
   [m9188]
   (clojure.core/let
    [credentials9189 (:credentials m9188) args9190 (:args m9188)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9191
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9189)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9191
       deleteEventSubscription
       (redshift/delete-event-subscription-request
        (clojure.core/nth args9190 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials9193 & args9194]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9195
     (com.palletops.awaze.common/aws-client :redshift credentials9193)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9195
      deleteEventSubscription
      (redshift/delete-event-subscription-request
       (clojure.core/nth args9194 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m9199]
   (clojure.core/let
    [credentials9200 (:credentials m9199) args9201 (:args m9199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9202
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9200)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9202
       rebootCluster
       (redshift/reboot-cluster-request (clojure.core/nth args9201 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCluster"}
   [credentials9204 & args9205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9206
     (com.palletops.awaze.common/aws-client :redshift credentials9204)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9206
      rebootCluster
      (redshift/reboot-cluster-request (clojure.core/nth args9205 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m9207]
   (clojure.core/let
    [credentials9208 (:credentials m9207) args9209 (:args m9207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9210
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9208)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9210
       createClusterSecurityGroup
       (redshift/create-cluster-security-group-request
        (clojure.core/nth args9209 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-security-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials9212 & args9213]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9214
     (com.palletops.awaze.common/aws-client :redshift credentials9212)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9214
      createClusterSecurityGroup
      (redshift/create-cluster-security-group-request
       (clojure.core/nth args9213 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m9215]
   (clojure.core/let
    [credentials9216 (:credentials m9215) args9217 (:args m9215)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9218
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9216)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9218
       modifyClusterParameterGroup
       (redshift/modify-cluster-parameter-group-request
        (clojure.core/nth args9217 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials9220 & args9221]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9222
     (com.palletops.awaze.common/aws-client :redshift credentials9220)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9222
      modifyClusterParameterGroup
      (redshift/modify-cluster-parameter-group-request
       (clojure.core/nth args9221 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-snapshot-copy-retention-period
   [m9223]
   (clojure.core/let
    [credentials9224 (:credentials m9223) args9225 (:args m9223)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9226
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9224)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9226
       modifySnapshotCopyRetentionPeriod
       (redshift/modify-snapshot-copy-retention-period-request
        (clojure.core/nth args9225 0)))))))
  (clojure.core/defn
   modify-snapshot-copy-retention-period-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotCopyRetentionPeriod"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-snapshot-copy-retention-period,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-snapshot-copy-retention-period
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySnapshotCopyRetentionPeriod"}
   [credentials9228 & args9229]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9230
     (com.palletops.awaze.common/aws-client :redshift credentials9228)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9230
      modifySnapshotCopyRetentionPeriod
      (redshift/modify-snapshot-copy-retention-period-request
       (clojure.core/nth args9229 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-snapshot-copy-grant
   [m9231]
   (clojure.core/let
    [credentials9232 (:credentials m9231) args9233 (:args m9231)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9234
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9232)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9234
       deleteSnapshotCopyGrant
       (redshift/delete-snapshot-copy-grant-request
        (clojure.core/nth args9233 0)))))))
  (clojure.core/defn
   delete-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotCopyGrant"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot-copy-grant,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call deleteSnapshotCopyGrant"}
   [credentials9236 & args9237]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9238
     (com.palletops.awaze.common/aws-client :redshift credentials9236)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9238
      deleteSnapshotCopyGrant
      (redshift/delete-snapshot-copy-grant-request
       (clojure.core/nth args9237 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m9239]
   (clojure.core/let
    [credentials9240 (:credentials m9239) args9241 (:args m9239)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9242
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9240)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9242
       authorizeSnapshotAccess
       (redshift/authorize-snapshot-access-request
        (clojure.core/nth args9241 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-snapshot-access,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials9244 & args9245]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9246
     (com.palletops.awaze.common/aws-client :redshift credentials9244)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9246
      authorizeSnapshotAccess
      (redshift/authorize-snapshot-access-request
       (clojure.core/nth args9245 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-logging
   [m9247]
   (clojure.core/let
    [credentials9248 (:credentials m9247) args9249 (:args m9247)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9250
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9248)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9250
       disableLogging
       (redshift/disable-logging-request
        (clojure.core/nth args9249 0)))))))
  (clojure.core/defn
   disable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableLogging"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-logging,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-logging
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableLogging"}
   [credentials9252 & args9253]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9254
     (com.palletops.awaze.common/aws-client :redshift credentials9252)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9254
      disableLogging
      (redshift/disable-logging-request (clojure.core/nth args9253 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m9255]
   (clojure.core/let
    [credentials9256 (:credentials m9255) args9257 (:args m9255)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9258
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9256)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9258
       modifyClusterSubnetGroup
       (redshift/modify-cluster-subnet-group-request
        (clojure.core/nth args9257 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials9260 & args9261]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9262
     (com.palletops.awaze.common/aws-client :redshift credentials9260)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9262
      modifyClusterSubnetGroup
      (redshift/modify-cluster-subnet-group-request
       (clojure.core/nth args9261 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m9263]
   (clojure.core/let
    [credentials9264 (:credentials m9263) args9265 (:args m9263)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9266
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9264)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9266
       modifyCluster
       (redshift/modify-cluster-request (clojure.core/nth args9265 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Call modifyCluster"}
   [credentials9268 & args9269]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9270
     (com.palletops.awaze.common/aws-client :redshift credentials9268)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9270
      modifyCluster
      (redshift/modify-cluster-request (clojure.core/nth args9269 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m9271]
   (clojure.core/let
    [credentials9272 (:credentials m9271) args9273 (:args m9271)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9274
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9272)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9274
       restoreFromClusterSnapshot
       (redshift/restore-from-cluster-snapshot-request
        (clojure.core/nth args9273 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials9276 & args9277]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9278
     (com.palletops.awaze.common/aws-client :redshift credentials9276)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9278
      restoreFromClusterSnapshot
      (redshift/restore-from-cluster-snapshot-request
       (clojure.core/nth args9277 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-client-certificate
   [m9279]
   (clojure.core/let
    [credentials9280 (:credentials m9279) args9281 (:args m9279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9282
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9280)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9282
       deleteHsmClientCertificate
       (redshift/delete-hsm-client-certificate-request
        (clojure.core/nth args9281 0)))))))
  (clojure.core/defn
   delete-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmClientCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hsm-client-certificate,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmClientCertificate"}
   [credentials9284 & args9285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9286
     (com.palletops.awaze.common/aws-client :redshift credentials9284)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9286
      deleteHsmClientCertificate
      (redshift/delete-hsm-client-certificate-request
       (clojure.core/nth args9285 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m9287]
   (clojure.core/let
    [credentials9288 (:credentials m9287) args9289 (:args m9287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9290
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9288)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9290
       createCluster
       (redshift/create-cluster-request (clojure.core/nth args9289 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Call createCluster"}
   [credentials9292 & args9293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9294
     (com.palletops.awaze.common/aws-client :redshift credentials9292)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9294
      createCluster
      (redshift/create-cluster-request (clojure.core/nth args9293 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-logging-status
   [m9295]
   (clojure.core/let
    [credentials9296 (:credentials m9295) args9297 (:args m9295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9298
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9296)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9298
       describeLoggingStatus
       (redshift/describe-logging-status-request
        (clojure.core/nth args9297 0)))))))
  (clojure.core/defn
   describe-logging-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoggingStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-logging-status,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-logging-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoggingStatus"}
   [credentials9300 & args9301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9302
     (com.palletops.awaze.common/aws-client :redshift credentials9300)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9302
      describeLoggingStatus
      (redshift/describe-logging-status-request
       (clojure.core/nth args9301 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-table-restore-status
   [m9303]
   (clojure.core/let
    [credentials9304 (:credentials m9303) args9305 (:args m9303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9306
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9304)]
     (clojure.core/case
      (clojure.core/count args9305)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9306
        describeTableRestoreStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9306
        describeTableRestoreStatus
        (redshift/describe-table-restore-status-request
         (clojure.core/nth args9305 0))))))))
  (clojure.core/defn
   describe-table-restore-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]]),
    :doc "Generate map for describeTableRestoreStatus, describeTableRestoreStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-table-restore-status,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-table-restore-status,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-table-restore-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]]),
    :doc "Call describeTableRestoreStatus, describeTableRestoreStatus"}
   [credentials9308 & args9309]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9310
     (com.palletops.awaze.common/aws-client :redshift credentials9308)]
    (clojure.core/case
     (clojure.core/count args9309)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9310
       describeTableRestoreStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9310
       describeTableRestoreStatus
       (redshift/describe-table-restore-status-request
        (clojure.core/nth args9309 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-categories
   [m9311]
   (clojure.core/let
    [credentials9312 (:credentials m9311) args9313 (:args m9311)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9314
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9312)]
     (clojure.core/case
      (clojure.core/count args9313)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9314
        describeEventCategories))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9314
        describeEventCategories
        (redshift/describe-event-categories-request
         (clojure.core/nth args9313 0))))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials9316 & args9317]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9318
     (com.palletops.awaze.common/aws-client :redshift credentials9316)]
    (clojure.core/case
     (clojure.core/count args9317)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9318
       describeEventCategories))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9318
       describeEventCategories
       (redshift/describe-event-categories-request
        (clojure.core/nth args9317 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m9319]
   (clojure.core/let
    [credentials9320 (:credentials m9319) args9321 (:args m9319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9322
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9320)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9322
       describeClusterParameters
       (redshift/describe-cluster-parameters-request
        (clojure.core/nth args9321 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameters"}
   [credentials9324 & args9325]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9326
     (com.palletops.awaze.common/aws-client :redshift credentials9324)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9326
      describeClusterParameters
      (redshift/describe-cluster-parameters-request
       (clojure.core/nth args9325 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m9327]
   (clojure.core/let
    [credentials9328 (:credentials m9327) args9329 (:args m9327)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9330
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9328)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9330
       authorizeClusterSecurityGroupIngress
       (redshift/authorize-cluster-security-group-ingress-request
        (clojure.core/nth args9329 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials9332 & args9333]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9334
     (com.palletops.awaze.common/aws-client :redshift credentials9332)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9334
      authorizeClusterSecurityGroupIngress
      (redshift/authorize-cluster-security-group-ingress-request
       (clojure.core/nth args9333 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m9335]
   (clojure.core/let
    [credentials9336 (:credentials m9335) args9337 (:args m9335)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9338
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9336)]
     (clojure.core/case
      (clojure.core/count args9337)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9338
        describeClusters
        (redshift/describe-clusters-request
         (clojure.core/nth args9337 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9338
        describeClusters))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-clusters,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-clusters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials9340 & args9341]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9342
     (com.palletops.awaze.common/aws-client :redshift credentials9340)]
    (clojure.core/case
     (clojure.core/count args9341)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9342
       describeClusters
       (redshift/describe-clusters-request
        (clojure.core/nth args9341 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9342
       describeClusters))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m9343]
   (clojure.core/let
    [credentials9344 (:credentials m9343) args9345 (:args m9343)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9346
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9344)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9346
       deleteClusterSubnetGroup
       (redshift/delete-cluster-subnet-group-request
        (clojure.core/nth args9345 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials9348 & args9349]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9350
     (com.palletops.awaze.common/aws-client :redshift credentials9348)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9350
      deleteClusterSubnetGroup
      (redshift/delete-cluster-subnet-group-request
       (clojure.core/nth args9349 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m9351]
   (clojure.core/let
    [credentials9352 (:credentials m9351) args9353 (:args m9351)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9354
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9352)]
     (clojure.core/case
      (clojure.core/count args9353)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9354
        describeClusterSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9354
        describeClusterSecurityGroups
        (redshift/describe-cluster-security-groups-request
         (clojure.core/nth args9353 0))))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials9356 & args9357]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9358
     (com.palletops.awaze.common/aws-client :redshift credentials9356)]
    (clojure.core/case
     (clojure.core/count args9357)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9358
       describeClusterSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9358
       describeClusterSecurityGroups
       (redshift/describe-cluster-security-groups-request
        (clojure.core/nth args9357 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-tags
   [m9359]
   (clojure.core/let
    [credentials9360 (:credentials m9359) args9361 (:args m9359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9362
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9360)]
     (clojure.core/case
      (clojure.core/count args9361)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9362
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9362
        describeTags
        (redshift/describe-tags-request (clojure.core/nth args9361 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials9364 & args9365]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9366
     (com.palletops.awaze.common/aws-client :redshift credentials9364)]
    (clojure.core/case
     (clojure.core/count args9365)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9366
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9366
       describeTags
       (redshift/describe-tags-request (clojure.core/nth args9365 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-snapshot-copy
   [m9367]
   (clojure.core/let
    [credentials9368 (:credentials m9367) args9369 (:args m9367)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9370
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9368)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9370
       disableSnapshotCopy
       (redshift/disable-snapshot-copy-request
        (clojure.core/nth args9369 0)))))))
  (clojure.core/defn
   disable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableSnapshotCopy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-snapshot-copy,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableSnapshotCopy"}
   [credentials9372 & args9373]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9374
     (com.palletops.awaze.common/aws-client :redshift credentials9372)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9374
      disableSnapshotCopy
      (redshift/disable-snapshot-copy-request
       (clojure.core/nth args9373 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-tags
   [m9375]
   (clojure.core/let
    [credentials9376 (:credentials m9375) args9377 (:args m9375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9378
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9376)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9378
       deleteTags
       (redshift/delete-tags-request (clojure.core/nth args9377 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials9380 & args9381]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9382
     (com.palletops.awaze.common/aws-client :redshift credentials9380)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9382
      deleteTags
      (redshift/delete-tags-request (clojure.core/nth args9381 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m9383]
   (clojure.core/let
    [credentials9384 (:credentials m9383) args9385 (:args m9383)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9386
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9384)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9386
       purchaseReservedNodeOffering
       (redshift/purchase-reserved-node-offering-request
        (clojure.core/nth args9385 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials9388 & args9389]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9390
     (com.palletops.awaze.common/aws-client :redshift credentials9388)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9390
      purchaseReservedNodeOffering
      (redshift/purchase-reserved-node-offering-request
       (clojure.core/nth args9389 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m9391]
   (clojure.core/let
    [credentials9392 (:credentials m9391) args9393 (:args m9391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9394
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9392)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9394
       deleteClusterSnapshot
       (redshift/delete-cluster-snapshot-request
        (clojure.core/nth args9393 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials9396 & args9397]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9398
     (com.palletops.awaze.common/aws-client :redshift credentials9396)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9398
      deleteClusterSnapshot
      (redshift/delete-cluster-snapshot-request
       (clojure.core/nth args9397 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m9399]
   (clojure.core/let
    [credentials9400 (:credentials m9399) args9401 (:args m9399)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9402
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9400)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9402
       createClusterParameterGroup
       (redshift/create-cluster-parameter-group-request
        (clojure.core/nth args9401 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials9404 & args9405]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9406
     (com.palletops.awaze.common/aws-client :redshift credentials9404)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9406
      createClusterParameterGroup
      (redshift/create-cluster-parameter-group-request
       (clojure.core/nth args9405 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :rotate-encryption-key
   [m9407]
   (clojure.core/let
    [credentials9408 (:credentials m9407) args9409 (:args m9407)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9410
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9408)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9410
       rotateEncryptionKey
       (redshift/rotate-encryption-key-request
        (clojure.core/nth args9409 0)))))))
  (clojure.core/defn
   rotate-encryption-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rotateEncryptionKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :rotate-encryption-key,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   rotate-encryption-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rotateEncryptionKey"}
   [credentials9412 & args9413]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9414
     (com.palletops.awaze.common/aws-client :redshift credentials9412)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9414
      rotateEncryptionKey
      (redshift/rotate-encryption-key-request
       (clojure.core/nth args9413 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-client-certificates
   [m9415]
   (clojure.core/let
    [credentials9416 (:credentials m9415) args9417 (:args m9415)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9418
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9416)]
     (clojure.core/case
      (clojure.core/count args9417)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9418
        describeHsmClientCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9418
        describeHsmClientCertificates
        (redshift/describe-hsm-client-certificates-request
         (clojure.core/nth args9417 0))))))))
  (clojure.core/defn
   describe-hsm-client-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeHsmClientCertificates, describeHsmClientCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-client-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeHsmClientCertificates, describeHsmClientCertificates"}
   [credentials9420 & args9421]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9422
     (com.palletops.awaze.common/aws-client :redshift credentials9420)]
    (clojure.core/case
     (clojure.core/count args9421)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9422
       describeHsmClientCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9422
       describeHsmClientCertificates
       (redshift/describe-hsm-client-certificates-request
        (clojure.core/nth args9421 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-snapshot-copy-grants
   [m9423]
   (clojure.core/let
    [credentials9424 (:credentials m9423) args9425 (:args m9423)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9426
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9424)]
     (clojure.core/case
      (clojure.core/count args9425)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9426
        describeSnapshotCopyGrants))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9426
        describeSnapshotCopyGrants
        (redshift/describe-snapshot-copy-grants-request
         (clojure.core/nth args9425 0))))))))
  (clojure.core/defn
   describe-snapshot-copy-grants-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-snapshot-copy-grants
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   [credentials9428 & args9429]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9430
     (com.palletops.awaze.common/aws-client :redshift credentials9428)]
    (clojure.core/case
     (clojure.core/count args9429)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9430
       describeSnapshotCopyGrants))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9430
       describeSnapshotCopyGrants
       (redshift/describe-snapshot-copy-grants-request
        (clojure.core/nth args9429 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m9431]
   (clojure.core/let
    [credentials9432 (:credentials m9431) args9433 (:args m9431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9434
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9432)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9434
       resetClusterParameterGroup
       (redshift/reset-cluster-parameter-group-request
        (clojure.core/nth args9433 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials9436 & args9437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9438
     (com.palletops.awaze.common/aws-client :redshift credentials9436)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9438
      resetClusterParameterGroup
      (redshift/reset-cluster-parameter-group-request
       (clojure.core/nth args9437 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m9439]
   (clojure.core/let
    [credentials9440 (:credentials m9439) args9441 (:args m9439)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9442
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9440)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9442
       deleteClusterSecurityGroup
       (redshift/delete-cluster-security-group-request
        (clojure.core/nth args9441 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-security-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials9444 & args9445]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9446
     (com.palletops.awaze.common/aws-client :redshift credentials9444)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9446
      deleteClusterSecurityGroup
      (redshift/delete-cluster-security-group-request
       (clojure.core/nth args9445 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m9447]
   (clojure.core/let
    [credentials9448 (:credentials m9447) args9449 (:args m9447)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9450
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9448)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9450
       copyClusterSnapshot
       (redshift/copy-cluster-snapshot-request
        (clojure.core/nth args9449 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials9452 & args9453]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9454
     (com.palletops.awaze.common/aws-client :redshift credentials9452)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9454
      copyClusterSnapshot
      (redshift/copy-cluster-snapshot-request
       (clojure.core/nth args9453 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-table-from-cluster-snapshot
   [m9455]
   (clojure.core/let
    [credentials9456 (:credentials m9455) args9457 (:args m9455)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9458
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9456)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9458
       restoreTableFromClusterSnapshot
       (redshift/restore-table-from-cluster-snapshot-request
        (clojure.core/nth args9457 0)))))))
  (clojure.core/defn
   restore-table-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Generate map for restoreTableFromClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-table-from-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-table-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Call restoreTableFromClusterSnapshot"}
   [credentials9460 & args9461]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9462
     (com.palletops.awaze.common/aws-client :redshift credentials9460)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9462
      restoreTableFromClusterSnapshot
      (redshift/restore-table-from-cluster-snapshot-request
       (clojure.core/nth args9461 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-event-subscription
   [m9463]
   (clojure.core/let
    [credentials9464 (:credentials m9463) args9465 (:args m9463)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9466
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9464)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9466
       modifyEventSubscription
       (redshift/modify-event-subscription-request
        (clojure.core/nth args9465 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials9468 & args9469]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9470
     (com.palletops.awaze.common/aws-client :redshift credentials9468)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9470
      modifyEventSubscription
      (redshift/modify-event-subscription-request
       (clojure.core/nth args9469 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-configuration
   [m9471]
   (clojure.core/let
    [credentials9472 (:credentials m9471) args9473 (:args m9471)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9474
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9472)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9474
       createHsmConfiguration
       (redshift/create-hsm-configuration-request
        (clojure.core/nth args9473 0)))))))
  (clojure.core/defn
   create-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hsm-configuration,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmConfiguration"}
   [credentials9476 & args9477]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9478
     (com.palletops.awaze.common/aws-client :redshift credentials9476)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9478
      createHsmConfiguration
      (redshift/create-hsm-configuration-request
       (clojure.core/nth args9477 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-configurations
   [m9479]
   (clojure.core/let
    [credentials9480 (:credentials m9479) args9481 (:args m9479)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9482
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9480)]
     (clojure.core/case
      (clojure.core/count args9481)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9482
        describeHsmConfigurations
        (redshift/describe-hsm-configurations-request
         (clojure.core/nth args9481 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9482
        describeHsmConfigurations))))))
  (clojure.core/defn
   describe-hsm-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeHsmConfigurations, describeHsmConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hsm-configurations,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hsm-configurations,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-configurations
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeHsmConfigurations, describeHsmConfigurations"}
   [credentials9484 & args9485]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9486
     (com.palletops.awaze.common/aws-client :redshift credentials9484)]
    (clojure.core/case
     (clojure.core/count args9485)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9486
       describeHsmConfigurations
       (redshift/describe-hsm-configurations-request
        (clojure.core/nth args9485 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9486
       describeHsmConfigurations))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m9487]
   (clojure.core/let
    [credentials9488 (:credentials m9487) args9489 (:args m9487)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9490
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9488)]
     (clojure.core/case
      (clojure.core/count args9489)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9490
        describeClusterSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9490
        describeClusterSubnetGroups
        (redshift/describe-cluster-subnet-groups-request
         (clojure.core/nth args9489 0))))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials9492 & args9493]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9494
     (com.palletops.awaze.common/aws-client :redshift credentials9492)]
    (clojure.core/case
     (clojure.core/count args9493)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9494
       describeClusterSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9494
       describeClusterSubnetGroups
       (redshift/describe-cluster-subnet-groups-request
        (clojure.core/nth args9493 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m9495]
   (clojure.core/let
    [credentials9496 (:credentials m9495) args9497 (:args m9495)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9498
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9496)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9498
       deleteCluster
       (redshift/delete-cluster-request (clojure.core/nth args9497 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCluster"}
   [credentials9500 & args9501]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9502
     (com.palletops.awaze.common/aws-client :redshift credentials9500)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9502
      deleteCluster
      (redshift/delete-cluster-request (clojure.core/nth args9501 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m9503]
   (clojure.core/let
    [credentials9504 (:credentials m9503) args9505 (:args m9503)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9506
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9504)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9506
       revokeClusterSecurityGroupIngress
       (redshift/revoke-cluster-security-group-ingress-request
        (clojure.core/nth args9505 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials9508 & args9509]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9510
     (com.palletops.awaze.common/aws-client :redshift credentials9508)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9510
      revokeClusterSecurityGroupIngress
      (redshift/revoke-cluster-security-group-ingress-request
       (clojure.core/nth args9509 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m9511]
   (clojure.core/let
    [credentials9512 (:credentials m9511) args9513 (:args m9511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9514
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9512)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9514
       createClusterSubnetGroup
       (redshift/create-cluster-subnet-group-request
        (clojure.core/nth args9513 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials9516 & args9517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9518
     (com.palletops.awaze.common/aws-client :redshift credentials9516)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9518
      createClusterSubnetGroup
      (redshift/create-cluster-subnet-group-request
       (clojure.core/nth args9517 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m9519]
   (clojure.core/let
    [credentials9520 (:credentials m9519) args9521 (:args m9519)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9522
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9520)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9522
       createClusterSnapshot
       (redshift/create-cluster-snapshot-request
        (clojure.core/nth args9521 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials9524 & args9525]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9526
     (com.palletops.awaze.common/aws-client :redshift credentials9524)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9526
      createClusterSnapshot
      (redshift/create-cluster-snapshot-request
       (clojure.core/nth args9525 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-tags
   [m9527]
   (clojure.core/let
    [credentials9528 (:credentials m9527) args9529 (:args m9527)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9530
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9528)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9530
       createTags
       (redshift/create-tags-request (clojure.core/nth args9529 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials9532 & args9533]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9534
     (com.palletops.awaze.common/aws-client :redshift credentials9532)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9534
      createTags
      (redshift/create-tags-request (clojure.core/nth args9533 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m9535]
   (clojure.core/let
    [credentials9536 (:credentials m9535) args9537 (:args m9535)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9538
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9536)]
     (clojure.core/case
      (clojure.core/count args9537)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9538
        describeOrderableClusterOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9538
        describeOrderableClusterOptions
        (redshift/describe-orderable-cluster-options-request
         (clojure.core/nth args9537 0))))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials9540 & args9541]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9542
     (com.palletops.awaze.common/aws-client :redshift credentials9540)]
    (clojure.core/case
     (clojure.core/count args9541)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9542
       describeOrderableClusterOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9542
       describeOrderableClusterOptions
       (redshift/describe-orderable-cluster-options-request
        (clojure.core/nth args9541 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-logging
   [m9543]
   (clojure.core/let
    [credentials9544 (:credentials m9543) args9545 (:args m9543)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9546
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9544)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9546
       enableLogging
       (redshift/enable-logging-request (clojure.core/nth args9545 0)))))))
  (clojure.core/defn
   enable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableLogging"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-logging,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-logging
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call enableLogging"}
   [credentials9548 & args9549]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9550
     (com.palletops.awaze.common/aws-client :redshift credentials9548)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9550
      enableLogging
      (redshift/enable-logging-request (clojure.core/nth args9549 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m9551]
   (clojure.core/let
    [credentials9552 (:credentials m9551) args9553 (:args m9551)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9554
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9552)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9554
       revokeSnapshotAccess
       (redshift/revoke-snapshot-access-request
        (clojure.core/nth args9553 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-snapshot-access,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials9556 & args9557]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9558
     (com.palletops.awaze.common/aws-client :redshift credentials9556)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9558
      revokeSnapshotAccess
      (redshift/revoke-snapshot-access-request
       (clojure.core/nth args9557 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-subscriptions
   [m9559]
   (clojure.core/let
    [credentials9560 (:credentials m9559) args9561 (:args m9559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9562
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9560)]
     (clojure.core/case
      (clojure.core/count args9561)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9562
        describeEventSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9562
        describeEventSubscriptions
        (redshift/describe-event-subscriptions-request
         (clojure.core/nth args9561 0))))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials9564 & args9565]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9566
     (com.palletops.awaze.common/aws-client :redshift credentials9564)]
    (clojure.core/case
     (clojure.core/count args9565)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9566
       describeEventSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9566
       describeEventSubscriptions
       (redshift/describe-event-subscriptions-request
        (clojure.core/nth args9565 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m9567]
   (clojure.core/let
    [credentials9568 (:credentials m9567) args9569 (:args m9567)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9570
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9568)]
     (clojure.core/case
      (clojure.core/count args9569)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9570
        describeReservedNodeOfferings
        (redshift/describe-reserved-node-offerings-request
         (clojure.core/nth args9569 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9570
        describeReservedNodeOfferings))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials9572 & args9573]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9574
     (com.palletops.awaze.common/aws-client :redshift credentials9572)]
    (clojure.core/case
     (clojure.core/count args9573)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9574
       describeReservedNodeOfferings
       (redshift/describe-reserved-node-offerings-request
        (clojure.core/nth args9573 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9574
       describeReservedNodeOfferings))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-configuration
   [m9575]
   (clojure.core/let
    [credentials9576 (:credentials m9575) args9577 (:args m9575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9578
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9576)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9578
       deleteHsmConfiguration
       (redshift/delete-hsm-configuration-request
        (clojure.core/nth args9577 0)))))))
  (clojure.core/defn
   delete-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hsm-configuration,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmConfiguration"}
   [credentials9580 & args9581]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9582
     (com.palletops.awaze.common/aws-client :redshift credentials9580)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9582
      deleteHsmConfiguration
      (redshift/delete-hsm-configuration-request
       (clojure.core/nth args9581 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-event-subscription
   [m9583]
   (clojure.core/let
    [credentials9584 (:credentials m9583) args9585 (:args m9583)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9586
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9584)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9586
       createEventSubscription
       (redshift/create-event-subscription-request
        (clojure.core/nth args9585 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call createEventSubscription"}
   [credentials9588 & args9589]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9590
     (com.palletops.awaze.common/aws-client :redshift credentials9588)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9590
      createEventSubscription
      (redshift/create-event-subscription-request
       (clojure.core/nth args9589 0))))))))
