(ns
 com.palletops.awaze.iam
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.iam :as iam]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1792__auto__))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m12310]
   (clojure.core/let
    [credentials12311 (:credentials m12310) args12312 (:args m12310)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12313
      (com.palletops.awaze.common/aws-client :iam credentials12311)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12313
       listGroupsForUser
       (identitymanagement/list-groups-for-user-request
        (clojure.core/nth args12312 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-groups-for-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupsForUser"}
   [credentials12315 & args12316]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12317
     (com.palletops.awaze.common/aws-client :iam credentials12315)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12317
      listGroupsForUser
      (identitymanagement/list-groups-for-user-request
       (clojure.core/nth args12316 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m12318]
   (clojure.core/let
    [credentials12319 (:credentials m12318) args12320 (:args m12318)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12321
      (com.palletops.awaze.common/aws-client :iam credentials12319)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12321
       createUser
       (identitymanagement/create-user-request
        (clojure.core/nth args12320 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createUser"}
   [credentials12323 & args12324]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12325
     (com.palletops.awaze.common/aws-client :iam credentials12323)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12325
      createUser
      (identitymanagement/create-user-request
       (clojure.core/nth args12324 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-credential-report
   [m12326]
   (clojure.core/let
    [credentials12327 (:credentials m12326) args12328 (:args m12326)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12329
      (com.palletops.awaze.common/aws-client :iam credentials12327)]
     (clojure.core/case
      (clojure.core/count args12328)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12329
        getCredentialReport))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12329
        getCredentialReport
        (identitymanagement/get-credential-report-request
         (clojure.core/nth args12328 0))))))))
  (clojure.core/defn
   get-credential-report-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCredentialReport, getCredentialReport"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-credential-report
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCredentialReport, getCredentialReport"}
   [credentials12331 & args12332]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12333
     (com.palletops.awaze.common/aws-client :iam credentials12331)]
    (clojure.core/case
     (clojure.core/count args12332)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12333
       getCredentialReport))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12333
       getCredentialReport
       (identitymanagement/get-credential-report-request
        (clojure.core/nth args12332 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-open-idconnect-provider
   [m12334]
   (clojure.core/let
    [credentials12335 (:credentials m12334) args12336 (:args m12334)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12337
      (com.palletops.awaze.common/aws-client :iam credentials12335)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12337
       getOpenIDConnectProvider
       (identitymanagement/get-open-idconnect-provider-request
        (clojure.core/nth args12336 0)))))))
  (clojure.core/defn
   get-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getOpenIDConnectProvider"}
   [credentials12339 & args12340]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12341
     (com.palletops.awaze.common/aws-client :iam credentials12339)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12341
      getOpenIDConnectProvider
      (identitymanagement/get-open-idconnect-provider-request
       (clojure.core/nth args12340 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m12342]
   (clojure.core/let
    [credentials12343 (:credentials m12342) args12344 (:args m12342)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12345
      (com.palletops.awaze.common/aws-client :iam credentials12343)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12345
       deleteSigningCertificate
       (identitymanagement/delete-signing-certificate-request
        (clojure.core/nth args12344 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials12347 & args12348]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12349
     (com.palletops.awaze.common/aws-client :iam credentials12347)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12349
      deleteSigningCertificate
      (identitymanagement/delete-signing-certificate-request
       (clojure.core/nth args12348 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m12350]
   (clojure.core/let
    [credentials12351 (:credentials m12350) args12352 (:args m12350)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12353
      (com.palletops.awaze.common/aws-client :iam credentials12351)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12353
       changePassword
       (identitymanagement/change-password-request
        (clojure.core/nth args12352 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-password,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Call changePassword"}
   [credentials12355 & args12356]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12357
     (com.palletops.awaze.common/aws-client :iam credentials12355)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12357
      changePassword
      (identitymanagement/change-password-request
       (clojure.core/nth args12356 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m12358]
   (clojure.core/let
    [credentials12359 (:credentials m12358) args12360 (:args m12358)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12361
      (com.palletops.awaze.common/aws-client :iam credentials12359)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12361
       listInstanceProfilesForRole
       (identitymanagement/list-instance-profiles-for-role-request
        (clojure.core/nth args12360 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials12363 & args12364]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12365
     (com.palletops.awaze.common/aws-client :iam credentials12363)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12365
      listInstanceProfilesForRole
      (identitymanagement/list-instance-profiles-for-role-request
       (clojure.core/nth args12364 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m12366]
   (clojure.core/let
    [credentials12367 (:credentials m12366) args12368 (:args m12366)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12369
      (com.palletops.awaze.common/aws-client :iam credentials12367)]
     (clojure.core/case
      (clojure.core/count args12368)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12369
        listInstanceProfiles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12369
        listInstanceProfiles
        (identitymanagement/list-instance-profiles-request
         (clojure.core/nth args12368 0))))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-instance-profiles,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-profiles,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials12371 & args12372]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12373
     (com.palletops.awaze.common/aws-client :iam credentials12371)]
    (clojure.core/case
     (clojure.core/count args12372)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12373
       listInstanceProfiles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12373
       listInstanceProfiles
       (identitymanagement/list-instance-profiles-request
        (clojure.core/nth args12372 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :set-default-policy-version
   [m12374]
   (clojure.core/let
    [credentials12375 (:credentials m12374) args12376 (:args m12374)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12377
      (com.palletops.awaze.common/aws-client :iam credentials12375)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12377
       setDefaultPolicyVersion
       (identitymanagement/set-default-policy-version-request
        (clojure.core/nth args12376 0)))))))
  (clojure.core/defn
   set-default-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDefaultPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-default-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   set-default-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call setDefaultPolicyVersion"}
   [credentials12379 & args12380]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12381
     (com.palletops.awaze.common/aws-client :iam credentials12379)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12381
      setDefaultPolicyVersion
      (identitymanagement/set-default-policy-version-request
       (clojure.core/nth args12380 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m12382]
   (clojure.core/let
    [credentials12383 (:credentials m12382) args12384 (:args m12382)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12385
      (com.palletops.awaze.common/aws-client :iam credentials12383)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12385
       deleteUserPolicy
       (identitymanagement/delete-user-policy-request
        (clojure.core/nth args12384 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials12387 & args12388]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12389
     (com.palletops.awaze.common/aws-client :iam credentials12387)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12389
      deleteUserPolicy
      (identitymanagement/delete-user-policy-request
       (clojure.core/nth args12388 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-access-key-last-used
   [m12390]
   (clojure.core/let
    [credentials12391 (:credentials m12390) args12392 (:args m12390)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12393
      (com.palletops.awaze.common/aws-client :iam credentials12391)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12393
       getAccessKeyLastUsed
       (identitymanagement/get-access-key-last-used-request
        (clojure.core/nth args12392 0)))))))
  (clojure.core/defn
   get-access-key-last-used-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for getAccessKeyLastUsed"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-access-key-last-used,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-access-key-last-used
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call getAccessKeyLastUsed"}
   [credentials12395 & args12396]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12397
     (com.palletops.awaze.common/aws-client :iam credentials12395)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12397
      getAccessKeyLastUsed
      (identitymanagement/get-access-key-last-used-request
       (clojure.core/nth args12396 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-group-policy
   [m12398]
   (clojure.core/let
    [credentials12399 (:credentials m12398) args12400 (:args m12398)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12401
      (com.palletops.awaze.common/aws-client :iam credentials12399)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12401
       attachGroupPolicy
       (identitymanagement/attach-group-policy-request
        (clojure.core/nth args12400 0)))))))
  (clojure.core/defn
   attach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachGroupPolicy"}
   [credentials12403 & args12404]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12405
     (com.palletops.awaze.common/aws-client :iam credentials12403)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12405
      attachGroupPolicy
      (identitymanagement/attach-group-policy-request
       (clojure.core/nth args12404 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m12406]
   (clojure.core/let
    [credentials12407 (:credentials m12406) args12408 (:args m12406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12409
      (com.palletops.awaze.common/aws-client :iam credentials12407)]
     (clojure.core/case
      (clojure.core/count args12408)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12409
        getUser
        (identitymanagement/get-user-request
         (clojure.core/nth args12408 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12409
        getUser))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-user,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getUser, getUser"}
   [credentials12411 & args12412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12413
     (com.palletops.awaze.common/aws-client :iam credentials12411)]
    (clojure.core/case
     (clojure.core/count args12412)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12413
       getUser
       (identitymanagement/get-user-request
        (clojure.core/nth args12412 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12413
       getUser))))))
 (do
  (clojure.core/defmethod
   iam
   :generate-credential-report
   [m12414]
   (clojure.core/let
    [credentials12415 (:credentials m12414) args12416 (:args m12414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12417
      (com.palletops.awaze.common/aws-client :iam credentials12415)]
     (clojure.core/case
      (clojure.core/count args12416)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12417
        generateCredentialReport
        (identitymanagement/generate-credential-report-request
         (clojure.core/nth args12416 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12417
        generateCredentialReport))))))
  (clojure.core/defn
   generate-credential-report-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for generateCredentialReport, generateCredentialReport"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :generate-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :generate-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   generate-credential-report
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call generateCredentialReport, generateCredentialReport"}
   [credentials12419 & args12420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12421
     (com.palletops.awaze.common/aws-client :iam credentials12419)]
    (clojure.core/case
     (clojure.core/count args12420)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12421
       generateCredentialReport
       (identitymanagement/generate-credential-report-request
        (clojure.core/nth args12420 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12421
       generateCredentialReport))))))
 (do
  (clojure.core/defmethod
   iam
   :get-sshpublic-key
   [m12422]
   (clojure.core/let
    [credentials12423 (:credentials m12422) args12424 (:args m12422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12425
      (com.palletops.awaze.common/aws-client :iam credentials12423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12425
       getSSHPublicKey
       (identitymanagement/get-sshpublic-key-request
        (clojure.core/nth args12424 0)))))))
  (clojure.core/defn
   get-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSSHPublicKey"}
   [credentials12427 & args12428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12429
     (com.palletops.awaze.common/aws-client :iam credentials12427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12429
      getSSHPublicKey
      (identitymanagement/get-sshpublic-key-request
       (clojure.core/nth args12428 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m12430]
   (clojure.core/let
    [credentials12431 (:credentials m12430) args12432 (:args m12430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12433
      (com.palletops.awaze.common/aws-client :iam credentials12431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12433
       createAccountAlias
       (identitymanagement/create-account-alias-request
        (clojure.core/nth args12432 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-account-alias,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call createAccountAlias"}
   [credentials12435 & args12436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12437
     (com.palletops.awaze.common/aws-client :iam credentials12435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12437
      createAccountAlias
      (identitymanagement/create-account-alias-request
       (clojure.core/nth args12436 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-samlprovider
   [m12438]
   (clojure.core/let
    [credentials12439 (:credentials m12438) args12440 (:args m12438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12441
      (com.palletops.awaze.common/aws-client :iam credentials12439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12441
       getSAMLProvider
       (identitymanagement/get-samlprovider-request
        (clojure.core/nth args12440 0)))))))
  (clojure.core/defn
   get-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSAMLProvider"}
   [credentials12443 & args12444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12445
     (com.palletops.awaze.common/aws-client :iam credentials12443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12445
      getSAMLProvider
      (identitymanagement/get-samlprovider-request
       (clojure.core/nth args12444 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy-version
   [m12446]
   (clojure.core/let
    [credentials12447 (:credentials m12446) args12448 (:args m12446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12449
      (com.palletops.awaze.common/aws-client :iam credentials12447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12449
       getPolicyVersion
       (identitymanagement/get-policy-version-request
        (clojure.core/nth args12448 0)))))))
  (clojure.core/defn
   get-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicyVersion"}
   [credentials12451 & args12452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12453
     (com.palletops.awaze.common/aws-client :iam credentials12451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12453
      getPolicyVersion
      (identitymanagement/get-policy-version-request
       (clojure.core/nth args12452 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m12454]
   (clojure.core/let
    [credentials12455 (:credentials m12454) args12456 (:args m12454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12457
      (com.palletops.awaze.common/aws-client :iam credentials12455)]
     (clojure.core/case
      (clojure.core/count args12456)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12457
        listMFADevices
        (identitymanagement/list-mfadevices-request
         (clojure.core/nth args12456 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12457
        listMFADevices))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials12459 & args12460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12461
     (com.palletops.awaze.common/aws-client :iam credentials12459)]
    (clojure.core/case
     (clojure.core/count args12460)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12461
       listMFADevices
       (identitymanagement/list-mfadevices-request
        (clojure.core/nth args12460 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12461
       listMFADevices))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m12462]
   (clojure.core/let
    [credentials12463 (:credentials m12462) args12464 (:args m12462)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12465
      (com.palletops.awaze.common/aws-client :iam credentials12463)]
     (clojure.core/case
      (clojure.core/count args12464)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12465
        listServerCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12465
        listServerCertificates
        (identitymanagement/list-server-certificates-request
         (clojure.core/nth args12464 0))))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-server-certificates,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-server-certificates,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials12467 & args12468]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12469
     (com.palletops.awaze.common/aws-client :iam credentials12467)]
    (clojure.core/case
     (clojure.core/count args12468)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12469
       listServerCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12469
       listServerCertificates
       (identitymanagement/list-server-certificates-request
        (clojure.core/nth args12468 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m12470]
   (clojure.core/let
    [credentials12471 (:credentials m12470) args12472 (:args m12470)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12473
      (com.palletops.awaze.common/aws-client :iam credentials12471)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12473
       putGroupPolicy
       (identitymanagement/put-group-policy-request
        (clojure.core/nth args12472 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putGroupPolicy"}
   [credentials12475 & args12476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12477
     (com.palletops.awaze.common/aws-client :iam credentials12475)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12477
      putGroupPolicy
      (identitymanagement/put-group-policy-request
       (clojure.core/nth args12476 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-authorization-details
   [m12478]
   (clojure.core/let
    [credentials12479 (:credentials m12478) args12480 (:args m12478)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12481
      (com.palletops.awaze.common/aws-client :iam credentials12479)]
     (clojure.core/case
      (clojure.core/count args12480)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12481
        getAccountAuthorizationDetails))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12481
        getAccountAuthorizationDetails
        (identitymanagement/get-account-authorization-details-request
         (clojure.core/nth args12480 0))))))))
  (clojure.core/defn
   get-account-authorization-details-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-authorization-details,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-authorization-details,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-authorization-details
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   [credentials12483 & args12484]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12485
     (com.palletops.awaze.common/aws-client :iam credentials12483)]
    (clojure.core/case
     (clojure.core/count args12484)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12485
       getAccountAuthorizationDetails))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12485
       getAccountAuthorizationDetails
       (identitymanagement/get-account-authorization-details-request
        (clojure.core/nth args12484 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m12486]
   (clojure.core/let
    [credentials12487 (:credentials m12486) args12488 (:args m12486)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12489
      (com.palletops.awaze.common/aws-client :iam credentials12487)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12489
       deleteGroupPolicy
       (identitymanagement/delete-group-policy-request
        (clojure.core/nth args12488 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials12491 & args12492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12493
     (com.palletops.awaze.common/aws-client :iam credentials12491)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12493
      deleteGroupPolicy
      (identitymanagement/delete-group-policy-request
       (clojure.core/nth args12492 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-open-idconnect-providers
   [m12494]
   (clojure.core/let
    [credentials12495 (:credentials m12494) args12496 (:args m12494)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12497
      (com.palletops.awaze.common/aws-client :iam credentials12495)]
     (clojure.core/case
      (clojure.core/count args12496)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12497
        listOpenIDConnectProviders))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12497
        listOpenIDConnectProviders
        (identitymanagement/list-open-idconnect-providers-request
         (clojure.core/nth args12496 0))))))))
  (clojure.core/defn
   list-open-idconnect-providers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listOpenIDConnectProviders, listOpenIDConnectProviders"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-open-idconnect-providers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listOpenIDConnectProviders, listOpenIDConnectProviders"}
   [credentials12499 & args12500]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12501
     (com.palletops.awaze.common/aws-client :iam credentials12499)]
    (clojure.core/case
     (clojure.core/count args12500)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12501
       listOpenIDConnectProviders))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12501
       listOpenIDConnectProviders
       (identitymanagement/list-open-idconnect-providers-request
        (clojure.core/nth args12500 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m12502]
   (clojure.core/let
    [credentials12503 (:credentials m12502) args12504 (:args m12502)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12505
      (com.palletops.awaze.common/aws-client :iam credentials12503)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12505
       listRolePolicies
       (identitymanagement/list-role-policies-request
        (clojure.core/nth args12504 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-role-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRolePolicies"}
   [credentials12507 & args12508]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12509
     (com.palletops.awaze.common/aws-client :iam credentials12507)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12509
      listRolePolicies
      (identitymanagement/list-role-policies-request
       (clojure.core/nth args12508 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m12510]
   (clojure.core/let
    [credentials12511 (:credentials m12510) args12512 (:args m12510)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12513
      (com.palletops.awaze.common/aws-client :iam credentials12511)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12513
       updateAccountPasswordPolicy
       (identitymanagement/update-account-password-policy-request
        (clojure.core/nth args12512 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials12515 & args12516]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12517
     (com.palletops.awaze.common/aws-client :iam credentials12515)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12517
      updateAccountPasswordPolicy
      (identitymanagement/update-account-password-policy-request
       (clojure.core/nth args12516 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m12518]
   (clojure.core/let
    [credentials12519 (:credentials m12518) args12520 (:args m12518)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12521
      (com.palletops.awaze.common/aws-client :iam credentials12519)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12521
       putUserPolicy
       (identitymanagement/put-user-policy-request
        (clojure.core/nth args12520 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putUserPolicy"}
   [credentials12523 & args12524]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12525
     (com.palletops.awaze.common/aws-client :iam credentials12523)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12525
      putUserPolicy
      (identitymanagement/put-user-policy-request
       (clojure.core/nth args12524 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m12526]
   (clojure.core/let
    [credentials12527 (:credentials m12526) args12528 (:args m12526)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12529
      (com.palletops.awaze.common/aws-client :iam credentials12527)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12529
       updateAssumeRolePolicy
       (identitymanagement/update-assume-role-policy-request
        (clojure.core/nth args12528 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-assume-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials12531 & args12532]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12533
     (com.palletops.awaze.common/aws-client :iam credentials12531)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12533
      updateAssumeRolePolicy
      (identitymanagement/update-assume-role-policy-request
       (clojure.core/nth args12532 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy
   [m12534]
   (clojure.core/let
    [credentials12535 (:credentials m12534) args12536 (:args m12534)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12537
      (com.palletops.awaze.common/aws-client :iam credentials12535)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12537
       getPolicy
       (identitymanagement/get-policy-request
        (clojure.core/nth args12536 0)))))))
  (clojure.core/defn
   get-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicy"}
   [credentials12539 & args12540]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12541
     (com.palletops.awaze.common/aws-client :iam credentials12539)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12541
      getPolicy
      (identitymanagement/get-policy-request
       (clojure.core/nth args12540 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m12542]
   (clojure.core/let
    [credentials12543 (:credentials m12542) args12544 (:args m12542)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12545
      (com.palletops.awaze.common/aws-client :iam credentials12543)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12545
       updateUser
       (identitymanagement/update-user-request
        (clojure.core/nth args12544 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateUser"}
   [credentials12547 & args12548]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12549
     (com.palletops.awaze.common/aws-client :iam credentials12547)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12549
      updateUser
      (identitymanagement/update-user-request
       (clojure.core/nth args12548 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m12550]
   (clojure.core/let
    [credentials12551 (:credentials m12550) args12552 (:args m12550)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12553
      (com.palletops.awaze.common/aws-client :iam credentials12551)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12553
       getRolePolicy
       (identitymanagement/get-role-policy-request
        (clojure.core/nth args12552 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRolePolicy"}
   [credentials12555 & args12556]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12557
     (com.palletops.awaze.common/aws-client :iam credentials12555)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12557
      getRolePolicy
      (identitymanagement/get-role-policy-request
       (clojure.core/nth args12556 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m12558]
   (clojure.core/let
    [credentials12559 (:credentials m12558) args12560 (:args m12558)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12561
      (com.palletops.awaze.common/aws-client :iam credentials12559)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12561
       deleteGroup
       (identitymanagement/delete-group-request
        (clojure.core/nth args12560 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroup"}
   [credentials12563 & args12564]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12565
     (com.palletops.awaze.common/aws-client :iam credentials12563)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12565
      deleteGroup
      (identitymanagement/delete-group-request
       (clojure.core/nth args12564 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m12566]
   (clojure.core/let
    [credentials12567 (:credentials m12566) args12568 (:args m12566)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12569
      (com.palletops.awaze.common/aws-client :iam credentials12567)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12569
       getLoginProfile
       (identitymanagement/get-login-profile-request
        (clojure.core/nth args12568 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getLoginProfile"}
   [credentials12571 & args12572]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12573
     (com.palletops.awaze.common/aws-client :iam credentials12571)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12573
      getLoginProfile
      (identitymanagement/get-login-profile-request
       (clojure.core/nth args12572 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-samlproviders
   [m12574]
   (clojure.core/let
    [credentials12575 (:credentials m12574) args12576 (:args m12574)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12577
      (com.palletops.awaze.common/aws-client :iam credentials12575)]
     (clojure.core/case
      (clojure.core/count args12576)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12577
        listSAMLProviders))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12577
        listSAMLProviders
        (identitymanagement/list-samlproviders-request
         (clojure.core/nth args12576 0))))))))
  (clojure.core/defn
   list-samlproviders-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listSAMLProviders, listSAMLProviders"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-samlproviders,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-samlproviders,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-samlproviders
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listSAMLProviders, listSAMLProviders"}
   [credentials12579 & args12580]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12581
     (com.palletops.awaze.common/aws-client :iam credentials12579)]
    (clojure.core/case
     (clojure.core/count args12580)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12581
       listSAMLProviders))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12581
       listSAMLProviders
       (identitymanagement/list-samlproviders-request
        (clojure.core/nth args12580 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m12582]
   (clojure.core/let
    [credentials12583 (:credentials m12582) args12584 (:args m12582)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12585
      (com.palletops.awaze.common/aws-client :iam credentials12583)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12585
       createRole
       (identitymanagement/create-role-request
        (clojure.core/nth args12584 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRole"}
   [credentials12587 & args12588]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12589
     (com.palletops.awaze.common/aws-client :iam credentials12587)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12589
      createRole
      (identitymanagement/create-role-request
       (clojure.core/nth args12588 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-group-policies
   [m12590]
   (clojure.core/let
    [credentials12591 (:credentials m12590) args12592 (:args m12590)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12593
      (com.palletops.awaze.common/aws-client :iam credentials12591)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12593
       listAttachedGroupPolicies
       (identitymanagement/list-attached-group-policies-request
        (clojure.core/nth args12592 0)))))))
  (clojure.core/defn
   list-attached-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedGroupPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-group-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedGroupPolicies"}
   [credentials12595 & args12596]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12597
     (com.palletops.awaze.common/aws-client :iam credentials12595)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12597
      listAttachedGroupPolicies
      (identitymanagement/list-attached-group-policies-request
       (clojure.core/nth args12596 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m12598]
   (clojure.core/let
    [credentials12599 (:credentials m12598) args12600 (:args m12598)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12601
      (com.palletops.awaze.common/aws-client :iam credentials12599)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12601
       deleteAccessKey
       (identitymanagement/delete-access-key-request
        (clojure.core/nth args12600 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call deleteAccessKey"}
   [credentials12603 & args12604]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12605
     (com.palletops.awaze.common/aws-client :iam credentials12603)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12605
      deleteAccessKey
      (identitymanagement/delete-access-key-request
       (clojure.core/nth args12604 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m12606]
   (clojure.core/let
    [credentials12607 (:credentials m12606) args12608 (:args m12606)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12609
      (com.palletops.awaze.common/aws-client :iam credentials12607)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12609
       getGroup
       (identitymanagement/get-group-request
        (clojure.core/nth args12608 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroup"}
   [credentials12611 & args12612]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12613
     (com.palletops.awaze.common/aws-client :iam credentials12611)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12613
      getGroup
      (identitymanagement/get-group-request
       (clojure.core/nth args12612 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m12614]
   (clojure.core/let
    [credentials12615 (:credentials m12614) args12616 (:args m12614)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12617
      (com.palletops.awaze.common/aws-client :iam credentials12615)]
     (clojure.core/case
      (clojure.core/count args12616)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12617
        deleteAccountPasswordPolicy
        (identitymanagement/delete-account-password-policy-request
         (clojure.core/nth args12616 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12617
        deleteAccountPasswordPolicy))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :delete-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials12619 & args12620]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12621
     (com.palletops.awaze.common/aws-client :iam credentials12619)]
    (clojure.core/case
     (clojure.core/count args12620)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12621
       deleteAccountPasswordPolicy
       (identitymanagement/delete-account-password-policy-request
        (clojure.core/nth args12620 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12621
       deleteAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m12622]
   (clojure.core/let
    [credentials12623 (:credentials m12622) args12624 (:args m12622)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12625
      (com.palletops.awaze.common/aws-client :iam credentials12623)]
     (clojure.core/case
      (clojure.core/count args12624)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12625
        getAccountSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12625
        getAccountSummary
        (identitymanagement/get-account-summary-request
         (clojure.core/nth args12624 0))))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-summary,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-summary,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials12627 & args12628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12629
     (com.palletops.awaze.common/aws-client :iam credentials12627)]
    (clojure.core/case
     (clojure.core/count args12628)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12629
       getAccountSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12629
       getAccountSummary
       (identitymanagement/get-account-summary-request
        (clojure.core/nth args12628 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy
   [m12630]
   (clojure.core/let
    [credentials12631 (:credentials m12630) args12632 (:args m12630)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12633
      (com.palletops.awaze.common/aws-client :iam credentials12631)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12633
       deletePolicy
       (identitymanagement/delete-policy-request
        (clojure.core/nth args12632 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicy"}
   [credentials12635 & args12636]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12637
     (com.palletops.awaze.common/aws-client :iam credentials12635)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12637
      deletePolicy
      (identitymanagement/delete-policy-request
       (clojure.core/nth args12636 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m12638]
   (clojure.core/let
    [credentials12639 (:credentials m12638) args12640 (:args m12638)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12641
      (com.palletops.awaze.common/aws-client :iam credentials12639)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12641
       createGroup
       (identitymanagement/create-group-request
        (clojure.core/nth args12640 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createGroup"}
   [credentials12643 & args12644]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12645
     (com.palletops.awaze.common/aws-client :iam credentials12643)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12645
      createGroup
      (identitymanagement/create-group-request
       (clojure.core/nth args12644 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m12646]
   (clojure.core/let
    [credentials12647 (:credentials m12646) args12648 (:args m12646)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12649
      (com.palletops.awaze.common/aws-client :iam credentials12647)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12649
       getRole
       (identitymanagement/get-role-request
        (clojure.core/nth args12648 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRole"}
   [credentials12651 & args12652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12653
     (com.palletops.awaze.common/aws-client :iam credentials12651)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12653
      getRole
      (identitymanagement/get-role-request
       (clojure.core/nth args12652 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policy-versions
   [m12654]
   (clojure.core/let
    [credentials12655 (:credentials m12654) args12656 (:args m12654)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12657
      (com.palletops.awaze.common/aws-client :iam credentials12655)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12657
       listPolicyVersions
       (identitymanagement/list-policy-versions-request
        (clojure.core/nth args12656 0)))))))
  (clojure.core/defn
   list-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPolicyVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-policy-versions,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listPolicyVersions"}
   [credentials12659 & args12660]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12661
     (com.palletops.awaze.common/aws-client :iam credentials12659)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12661
      listPolicyVersions
      (identitymanagement/list-policy-versions-request
       (clojure.core/nth args12660 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m12662]
   (clojure.core/let
    [credentials12663 (:credentials m12662) args12664 (:args m12662)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12665
      (com.palletops.awaze.common/aws-client :iam credentials12663)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12665
       listGroupPolicies
       (identitymanagement/list-group-policies-request
        (clojure.core/nth args12664 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-group-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupPolicies"}
   [credentials12667 & args12668]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12669
     (com.palletops.awaze.common/aws-client :iam credentials12667)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12669
      listGroupPolicies
      (identitymanagement/list-group-policies-request
       (clojure.core/nth args12668 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-samlprovider
   [m12670]
   (clojure.core/let
    [credentials12671 (:credentials m12670) args12672 (:args m12670)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12673
      (com.palletops.awaze.common/aws-client :iam credentials12671)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12673
       deleteSAMLProvider
       (identitymanagement/delete-samlprovider-request
        (clojure.core/nth args12672 0)))))))
  (clojure.core/defn
   delete-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSAMLProvider"}
   [credentials12675 & args12676]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12677
     (com.palletops.awaze.common/aws-client :iam credentials12675)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12677
      deleteSAMLProvider
      (identitymanagement/delete-samlprovider-request
       (clojure.core/nth args12676 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-role-policy
   [m12678]
   (clojure.core/let
    [credentials12679 (:credentials m12678) args12680 (:args m12678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12681
      (com.palletops.awaze.common/aws-client :iam credentials12679)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12681
       detachRolePolicy
       (identitymanagement/detach-role-policy-request
        (clojure.core/nth args12680 0)))))))
  (clojure.core/defn
   detach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachRolePolicy"}
   [credentials12683 & args12684]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12685
     (com.palletops.awaze.common/aws-client :iam credentials12683)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12685
      detachRolePolicy
      (identitymanagement/detach-role-policy-request
       (clojure.core/nth args12684 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m12686]
   (clojure.core/let
    [credentials12687 (:credentials m12686) args12688 (:args m12686)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12689
      (com.palletops.awaze.common/aws-client :iam credentials12687)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12689
       updateLoginProfile
       (identitymanagement/update-login-profile-request
        (clojure.core/nth args12688 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateLoginProfile"}
   [credentials12691 & args12692]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12693
     (com.palletops.awaze.common/aws-client :iam credentials12691)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12693
      updateLoginProfile
      (identitymanagement/update-login-profile-request
       (clojure.core/nth args12692 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-open-idconnect-provider-thumbprint
   [m12694]
   (clojure.core/let
    [credentials12695 (:credentials m12694) args12696 (:args m12694)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12697
      (com.palletops.awaze.common/aws-client :iam credentials12695)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12697
       updateOpenIDConnectProviderThumbprint
       (identitymanagement/update-open-idconnect-provider-thumbprint-request
        (clojure.core/nth args12696 0)))))))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateOpenIDConnectProviderThumbprint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-open-idconnect-provider-thumbprint,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateOpenIDConnectProviderThumbprint"}
   [credentials12699 & args12700]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12701
     (com.palletops.awaze.common/aws-client :iam credentials12699)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12701
      updateOpenIDConnectProviderThumbprint
      (identitymanagement/update-open-idconnect-provider-thumbprint-request
       (clojure.core/nth args12700 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-sshpublic-key
   [m12702]
   (clojure.core/let
    [credentials12703 (:credentials m12702) args12704 (:args m12702)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12705
      (com.palletops.awaze.common/aws-client :iam credentials12703)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12705
       updateSSHPublicKey
       (identitymanagement/update-sshpublic-key-request
        (clojure.core/nth args12704 0)))))))
  (clojure.core/defn
   update-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSSHPublicKey"}
   [credentials12707 & args12708]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12709
     (com.palletops.awaze.common/aws-client :iam credentials12707)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12709
      updateSSHPublicKey
      (identitymanagement/update-sshpublic-key-request
       (clojure.core/nth args12708 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m12710]
   (clojure.core/let
    [credentials12711 (:credentials m12710) args12712 (:args m12710)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12713
      (com.palletops.awaze.common/aws-client :iam credentials12711)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12713
       deleteServerCertificate
       (identitymanagement/delete-server-certificate-request
        (clojure.core/nth args12712 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials12715 & args12716]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12717
     (com.palletops.awaze.common/aws-client :iam credentials12715)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12717
      deleteServerCertificate
      (identitymanagement/delete-server-certificate-request
       (clojure.core/nth args12716 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m12718]
   (clojure.core/let
    [credentials12719 (:credentials m12718) args12720 (:args m12718)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12721
      (com.palletops.awaze.common/aws-client :iam credentials12719)]
     (clojure.core/case
      (clojure.core/count args12720)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12721
        listVirtualMFADevices
        (identitymanagement/list-virtual-mfadevices-request
         (clojure.core/nth args12720 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12721
        listVirtualMFADevices))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials12723 & args12724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12725
     (com.palletops.awaze.common/aws-client :iam credentials12723)]
    (clojure.core/case
     (clojure.core/count args12724)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12725
       listVirtualMFADevices
       (identitymanagement/list-virtual-mfadevices-request
        (clojure.core/nth args12724 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12725
       listVirtualMFADevices))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m12726]
   (clojure.core/let
    [credentials12727 (:credentials m12726) args12728 (:args m12726)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12729
      (com.palletops.awaze.common/aws-client :iam credentials12727)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12729
       getServerCertificate
       (identitymanagement/get-server-certificate-request
        (clojure.core/nth args12728 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getServerCertificate"}
   [credentials12731 & args12732]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12733
     (com.palletops.awaze.common/aws-client :iam credentials12731)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12733
      getServerCertificate
      (identitymanagement/get-server-certificate-request
       (clojure.core/nth args12732 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m12734]
   (clojure.core/let
    [credentials12735 (:credentials m12734) args12736 (:args m12734)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12737
      (com.palletops.awaze.common/aws-client :iam credentials12735)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12737
       deleteRolePolicy
       (identitymanagement/delete-role-policy-request
        (clojure.core/nth args12736 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials12739 & args12740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12741
     (com.palletops.awaze.common/aws-client :iam credentials12739)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12741
      deleteRolePolicy
      (identitymanagement/delete-role-policy-request
       (clojure.core/nth args12740 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m12742]
   (clojure.core/let
    [credentials12743 (:credentials m12742) args12744 (:args m12742)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12745
      (com.palletops.awaze.common/aws-client :iam credentials12743)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12745
       deleteInstanceProfile
       (identitymanagement/delete-instance-profile-request
        (clojure.core/nth args12744 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials12747 & args12748]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12749
     (com.palletops.awaze.common/aws-client :iam credentials12747)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12749
      deleteInstanceProfile
      (identitymanagement/delete-instance-profile-request
       (clojure.core/nth args12748 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m12750]
   (clojure.core/let
    [credentials12751 (:credentials m12750) args12752 (:args m12750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12753
      (com.palletops.awaze.common/aws-client :iam credentials12751)]
     (clojure.core/case
      (clojure.core/count args12752)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12753
        listAccountAliases
        (identitymanagement/list-account-aliases-request
         (clojure.core/nth args12752 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12753
        listAccountAliases))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-account-aliases,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-account-aliases,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials12755 & args12756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12757
     (com.palletops.awaze.common/aws-client :iam credentials12755)]
    (clojure.core/case
     (clojure.core/count args12756)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12757
       listAccountAliases
       (identitymanagement/list-account-aliases-request
        (clojure.core/nth args12756 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12757
       listAccountAliases))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m12758]
   (clojure.core/let
    [credentials12759 (:credentials m12758) args12760 (:args m12758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12761
      (com.palletops.awaze.common/aws-client :iam credentials12759)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12761
       addUserToGroup
       (identitymanagement/add-user-to-group-request
        (clojure.core/nth args12760 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-user-to-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addUserToGroup"}
   [credentials12763 & args12764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12765
     (com.palletops.awaze.common/aws-client :iam credentials12763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12765
      addUserToGroup
      (identitymanagement/add-user-to-group-request
       (clojure.core/nth args12764 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-open-idconnect-provider
   [m12766]
   (clojure.core/let
    [credentials12767 (:credentials m12766) args12768 (:args m12766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12769
      (com.palletops.awaze.common/aws-client :iam credentials12767)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12769
       deleteOpenIDConnectProvider
       (identitymanagement/delete-open-idconnect-provider-request
        (clojure.core/nth args12768 0)))))))
  (clojure.core/defn
   delete-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteOpenIDConnectProvider"}
   [credentials12771 & args12772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12773
     (com.palletops.awaze.common/aws-client :iam credentials12771)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12773
      deleteOpenIDConnectProvider
      (identitymanagement/delete-open-idconnect-provider-request
       (clojure.core/nth args12772 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m12774]
   (clojure.core/let
    [credentials12775 (:credentials m12774) args12776 (:args m12774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12777
      (com.palletops.awaze.common/aws-client :iam credentials12775)]
     (clojure.core/case
      (clojure.core/count args12776)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12777
        listUsers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12777
        listUsers
        (identitymanagement/list-users-request
         (clojure.core/nth args12776 0))))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-users,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-users,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUsers, listUsers"}
   [credentials12779 & args12780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12781
     (com.palletops.awaze.common/aws-client :iam credentials12779)]
    (clojure.core/case
     (clojure.core/count args12780)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12781
       listUsers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12781
       listUsers
       (identitymanagement/list-users-request
        (clojure.core/nth args12780 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m12782]
   (clojure.core/let
    [credentials12783 (:credentials m12782) args12784 (:args m12782)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12785
      (com.palletops.awaze.common/aws-client :iam credentials12783)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12785
       createInstanceProfile
       (identitymanagement/create-instance-profile-request
        (clojure.core/nth args12784 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceProfile"}
   [credentials12787 & args12788]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12789
     (com.palletops.awaze.common/aws-client :iam credentials12787)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12789
      createInstanceProfile
      (identitymanagement/create-instance-profile-request
       (clojure.core/nth args12788 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m12790]
   (clojure.core/let
    [credentials12791 (:credentials m12790) args12792 (:args m12790)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12793
      (com.palletops.awaze.common/aws-client :iam credentials12791)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12793
       getUserPolicy
       (identitymanagement/get-user-policy-request
        (clojure.core/nth args12792 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getUserPolicy"}
   [credentials12795 & args12796]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12797
     (com.palletops.awaze.common/aws-client :iam credentials12795)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12797
      getUserPolicy
      (identitymanagement/get-user-policy-request
       (clojure.core/nth args12796 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m12798]
   (clojure.core/let
    [credentials12799 (:credentials m12798) args12800 (:args m12798)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12801
      (com.palletops.awaze.common/aws-client :iam credentials12799)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12801
       deleteLoginProfile
       (identitymanagement/delete-login-profile-request
        (clojure.core/nth args12800 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials12803 & args12804]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12805
     (com.palletops.awaze.common/aws-client :iam credentials12803)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12805
      deleteLoginProfile
      (identitymanagement/delete-login-profile-request
       (clojure.core/nth args12804 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-user-policy
   [m12806]
   (clojure.core/let
    [credentials12807 (:credentials m12806) args12808 (:args m12806)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12809
      (com.palletops.awaze.common/aws-client :iam credentials12807)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12809
       attachUserPolicy
       (identitymanagement/attach-user-policy-request
        (clojure.core/nth args12808 0)))))))
  (clojure.core/defn
   attach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachUserPolicy"}
   [credentials12811 & args12812]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12813
     (com.palletops.awaze.common/aws-client :iam credentials12811)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12813
      attachUserPolicy
      (identitymanagement/attach-user-policy-request
       (clojure.core/nth args12812 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m12814]
   (clojure.core/let
    [credentials12815 (:credentials m12814) args12816 (:args m12814)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12817
      (com.palletops.awaze.common/aws-client :iam credentials12815)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12817
       putRolePolicy
       (identitymanagement/put-role-policy-request
        (clojure.core/nth args12816 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putRolePolicy"}
   [credentials12819 & args12820]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12821
     (com.palletops.awaze.common/aws-client :iam credentials12819)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12821
      putRolePolicy
      (identitymanagement/put-role-policy-request
       (clojure.core/nth args12820 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m12822]
   (clojure.core/let
    [credentials12823 (:credentials m12822) args12824 (:args m12822)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12825
      (com.palletops.awaze.common/aws-client :iam credentials12823)]
     (clojure.core/case
      (clojure.core/count args12824)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12825
        listAccessKeys
        (identitymanagement/list-access-keys-request
         (clojure.core/nth args12824 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12825
        listAccessKeys))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-access-keys,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-access-keys,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials12827 & args12828]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12829
     (com.palletops.awaze.common/aws-client :iam credentials12827)]
    (clojure.core/case
     (clojure.core/count args12828)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12829
       listAccessKeys
       (identitymanagement/list-access-keys-request
        (clojure.core/nth args12828 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12829
       listAccessKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m12830]
   (clojure.core/let
    [credentials12831 (:credentials m12830) args12832 (:args m12830)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12833
      (com.palletops.awaze.common/aws-client :iam credentials12831)]
     (clojure.core/case
      (clojure.core/count args12832)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12833
        listSigningCertificates
        (identitymanagement/list-signing-certificates-request
         (clojure.core/nth args12832 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12833
        listSigningCertificates))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-signing-certificates,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-signing-certificates,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials12835 & args12836]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12837
     (com.palletops.awaze.common/aws-client :iam credentials12835)]
    (clojure.core/case
     (clojure.core/count args12836)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12837
       listSigningCertificates
       (identitymanagement/list-signing-certificates-request
        (clojure.core/nth args12836 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12837
       listSigningCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-group-policy
   [m12838]
   (clojure.core/let
    [credentials12839 (:credentials m12838) args12840 (:args m12838)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12841
      (com.palletops.awaze.common/aws-client :iam credentials12839)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12841
       detachGroupPolicy
       (identitymanagement/detach-group-policy-request
        (clojure.core/nth args12840 0)))))))
  (clojure.core/defn
   detach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachGroupPolicy"}
   [credentials12843 & args12844]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12845
     (com.palletops.awaze.common/aws-client :iam credentials12843)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12845
      detachGroupPolicy
      (identitymanagement/detach-group-policy-request
       (clojure.core/nth args12844 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m12846]
   (clojure.core/let
    [credentials12847 (:credentials m12846) args12848 (:args m12846)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12849
      (com.palletops.awaze.common/aws-client :iam credentials12847)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12849
       updateAccessKey
       (identitymanagement/update-access-key-request
        (clojure.core/nth args12848 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call updateAccessKey"}
   [credentials12851 & args12852]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12853
     (com.palletops.awaze.common/aws-client :iam credentials12851)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12853
      updateAccessKey
      (identitymanagement/update-access-key-request
       (clojure.core/nth args12852 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-sshpublic-key
   [m12854]
   (clojure.core/let
    [credentials12855 (:credentials m12854) args12856 (:args m12854)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12857
      (com.palletops.awaze.common/aws-client :iam credentials12855)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12857
       uploadSSHPublicKey
       (identitymanagement/upload-sshpublic-key-request
        (clojure.core/nth args12856 0)))))))
  (clojure.core/defn
   upload-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSSHPublicKey"}
   [credentials12859 & args12860]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12861
     (com.palletops.awaze.common/aws-client :iam credentials12859)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12861
      uploadSSHPublicKey
      (identitymanagement/upload-sshpublic-key-request
       (clojure.core/nth args12860 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m12862]
   (clojure.core/let
    [credentials12863 (:credentials m12862) args12864 (:args m12862)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12865
      (com.palletops.awaze.common/aws-client :iam credentials12863)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12865
       uploadServerCertificate
       (identitymanagement/upload-server-certificate-request
        (clojure.core/nth args12864 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials12867 & args12868]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12869
     (com.palletops.awaze.common/aws-client :iam credentials12867)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12869
      uploadServerCertificate
      (identitymanagement/upload-server-certificate-request
       (clojure.core/nth args12868 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m12870]
   (clojure.core/let
    [credentials12871 (:credentials m12870) args12872 (:args m12870)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12873
      (com.palletops.awaze.common/aws-client :iam credentials12871)]
     (clojure.core/case
      (clojure.core/count args12872)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12873
        getAccountPasswordPolicy
        (identitymanagement/get-account-password-policy-request
         (clojure.core/nth args12872 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12873
        getAccountPasswordPolicy))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials12875 & args12876]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12877
     (com.palletops.awaze.common/aws-client :iam credentials12875)]
    (clojure.core/case
     (clojure.core/count args12876)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12877
       getAccountPasswordPolicy
       (identitymanagement/get-account-password-policy-request
        (clojure.core/nth args12876 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12877
       getAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m12878]
   (clojure.core/let
    [credentials12879 (:credentials m12878) args12880 (:args m12878)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12881
      (com.palletops.awaze.common/aws-client :iam credentials12879)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12881
       deleteRole
       (identitymanagement/delete-role-request
        (clojure.core/nth args12880 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRole"}
   [credentials12883 & args12884]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12885
     (com.palletops.awaze.common/aws-client :iam credentials12883)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12885
      deleteRole
      (identitymanagement/delete-role-request
       (clojure.core/nth args12884 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-client-idfrom-open-idconnect-provider
   [m12886]
   (clojure.core/let
    [credentials12887 (:credentials m12886) args12888 (:args m12886)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12889
      (com.palletops.awaze.common/aws-client :iam credentials12887)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12889
       removeClientIDFromOpenIDConnectProvider
       (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
        (clojure.core/nth args12888 0)))))))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeClientIDFromOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-client-idfrom-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeClientIDFromOpenIDConnectProvider"}
   [credentials12891 & args12892]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12893
     (com.palletops.awaze.common/aws-client :iam credentials12891)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12893
      removeClientIDFromOpenIDConnectProvider
      (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
       (clojure.core/nth args12892 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m12894]
   (clojure.core/let
    [credentials12895 (:credentials m12894) args12896 (:args m12894)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12897
      (com.palletops.awaze.common/aws-client :iam credentials12895)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12897
       removeUserFromGroup
       (identitymanagement/remove-user-from-group-request
        (clojure.core/nth args12896 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-user-from-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials12899 & args12900]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12901
     (com.palletops.awaze.common/aws-client :iam credentials12899)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12901
      removeUserFromGroup
      (identitymanagement/remove-user-from-group-request
       (clojure.core/nth args12900 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m12902]
   (clojure.core/let
    [credentials12903 (:credentials m12902) args12904 (:args m12902)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12905
      (com.palletops.awaze.common/aws-client :iam credentials12903)]
     (clojure.core/case
      (clojure.core/count args12904)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12905
        listRoles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12905
        listRoles
        (identitymanagement/list-roles-request
         (clojure.core/nth args12904 0))))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-roles,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-roles,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRoles, listRoles"}
   [credentials12907 & args12908]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12909
     (com.palletops.awaze.common/aws-client :iam credentials12907)]
    (clojure.core/case
     (clojure.core/count args12908)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12909
       listRoles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12909
       listRoles
       (identitymanagement/list-roles-request
        (clojure.core/nth args12908 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-role-policies
   [m12910]
   (clojure.core/let
    [credentials12911 (:credentials m12910) args12912 (:args m12910)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12913
      (com.palletops.awaze.common/aws-client :iam credentials12911)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12913
       listAttachedRolePolicies
       (identitymanagement/list-attached-role-policies-request
        (clojure.core/nth args12912 0)))))))
  (clojure.core/defn
   list-attached-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedRolePolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-role-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedRolePolicies"}
   [credentials12915 & args12916]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12917
     (com.palletops.awaze.common/aws-client :iam credentials12915)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12917
      listAttachedRolePolicies
      (identitymanagement/list-attached-role-policies-request
       (clojure.core/nth args12916 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m12918]
   (clojure.core/let
    [credentials12919 (:credentials m12918) args12920 (:args m12918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12921
      (com.palletops.awaze.common/aws-client :iam credentials12919)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12921
       removeRoleFromInstanceProfile
       (identitymanagement/remove-role-from-instance-profile-request
        (clojure.core/nth args12920 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials12923 & args12924]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12925
     (com.palletops.awaze.common/aws-client :iam credentials12923)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12925
      removeRoleFromInstanceProfile
      (identitymanagement/remove-role-from-instance-profile-request
       (clojure.core/nth args12924 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy
   [m12926]
   (clojure.core/let
    [credentials12927 (:credentials m12926) args12928 (:args m12926)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12929
      (com.palletops.awaze.common/aws-client :iam credentials12927)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12929
       createPolicy
       (identitymanagement/create-policy-request
        (clojure.core/nth args12928 0)))))))
  (clojure.core/defn
   create-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPolicy"}
   [credentials12931 & args12932]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12933
     (com.palletops.awaze.common/aws-client :iam credentials12931)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12933
      createPolicy
      (identitymanagement/create-policy-request
       (clojure.core/nth args12932 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-client-idto-open-idconnect-provider
   [m12934]
   (clojure.core/let
    [credentials12935 (:credentials m12934) args12936 (:args m12934)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12937
      (com.palletops.awaze.common/aws-client :iam credentials12935)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12937
       addClientIDToOpenIDConnectProvider
       (identitymanagement/add-client-idto-open-idconnect-provider-request
        (clojure.core/nth args12936 0)))))))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addClientIDToOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-client-idto-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addClientIDToOpenIDConnectProvider"}
   [credentials12939 & args12940]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12941
     (com.palletops.awaze.common/aws-client :iam credentials12939)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12941
      addClientIDToOpenIDConnectProvider
      (identitymanagement/add-client-idto-open-idconnect-provider-request
       (clojure.core/nth args12940 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m12942]
   (clojure.core/let
    [credentials12943 (:credentials m12942) args12944 (:args m12942)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12945
      (com.palletops.awaze.common/aws-client :iam credentials12943)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12945
       createVirtualMFADevice
       (identitymanagement/create-virtual-mfadevice-request
        (clojure.core/nth args12944 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-virtual-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials12947 & args12948]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12949
     (com.palletops.awaze.common/aws-client :iam credentials12947)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12949
      createVirtualMFADevice
      (identitymanagement/create-virtual-mfadevice-request
       (clojure.core/nth args12948 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m12950]
   (clojure.core/let
    [credentials12951 (:credentials m12950) args12952 (:args m12950)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12953
      (com.palletops.awaze.common/aws-client :iam credentials12951)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12953
       deleteAccountAlias
       (identitymanagement/delete-account-alias-request
        (clojure.core/nth args12952 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-account-alias,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials12955 & args12956]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12957
     (com.palletops.awaze.common/aws-client :iam credentials12955)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12957
      deleteAccountAlias
      (identitymanagement/delete-account-alias-request
       (clojure.core/nth args12956 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m12958]
   (clojure.core/let
    [credentials12959 (:credentials m12958) args12960 (:args m12958)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12961
      (com.palletops.awaze.common/aws-client :iam credentials12959)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12961
       uploadSigningCertificate
       (identitymanagement/upload-signing-certificate-request
        (clojure.core/nth args12960 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials12963 & args12964]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12965
     (com.palletops.awaze.common/aws-client :iam credentials12963)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12965
      uploadSigningCertificate
      (identitymanagement/upload-signing-certificate-request
       (clojure.core/nth args12964 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m12966]
   (clojure.core/let
    [credentials12967 (:credentials m12966) args12968 (:args m12966)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12969
      (com.palletops.awaze.common/aws-client :iam credentials12967)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12969
       deactivateMFADevice
       (identitymanagement/deactivate-mfadevice-request
        (clojure.core/nth args12968 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deactivate-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials12971 & args12972]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12973
     (com.palletops.awaze.common/aws-client :iam credentials12971)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12973
      deactivateMFADevice
      (identitymanagement/deactivate-mfadevice-request
       (clojure.core/nth args12972 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m12974]
   (clojure.core/let
    [credentials12975 (:credentials m12974) args12976 (:args m12974)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12977
      (com.palletops.awaze.common/aws-client :iam credentials12975)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12977
       resyncMFADevice
       (identitymanagement/resync-mfadevice-request
        (clojure.core/nth args12976 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :resync-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resyncMFADevice"}
   [credentials12979 & args12980]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12981
     (com.palletops.awaze.common/aws-client :iam credentials12979)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12981
      resyncMFADevice
      (identitymanagement/resync-mfadevice-request
       (clojure.core/nth args12980 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-sshpublic-keys
   [m12982]
   (clojure.core/let
    [credentials12983 (:credentials m12982) args12984 (:args m12982)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12985
      (com.palletops.awaze.common/aws-client :iam credentials12983)]
     (clojure.core/case
      (clojure.core/count args12984)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12985
        listSSHPublicKeys))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12985
        listSSHPublicKeys
        (identitymanagement/list-sshpublic-keys-request
         (clojure.core/nth args12984 0))))))))
  (clojure.core/defn
   list-sshpublic-keys-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listSSHPublicKeys, listSSHPublicKeys"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-sshpublic-keys,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-sshpublic-keys,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-sshpublic-keys
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listSSHPublicKeys, listSSHPublicKeys"}
   [credentials12987 & args12988]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12989
     (com.palletops.awaze.common/aws-client :iam credentials12987)]
    (clojure.core/case
     (clojure.core/count args12988)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12989
       listSSHPublicKeys))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12989
       listSSHPublicKeys
       (identitymanagement/list-sshpublic-keys-request
        (clojure.core/nth args12988 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m12990]
   (clojure.core/let
    [credentials12991 (:credentials m12990) args12992 (:args m12990)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12993
      (com.palletops.awaze.common/aws-client :iam credentials12991)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12993
       addRoleToInstanceProfile
       (identitymanagement/add-role-to-instance-profile-request
        (clojure.core/nth args12992 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-role-to-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials12995 & args12996]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12997
     (com.palletops.awaze.common/aws-client :iam credentials12995)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12997
      addRoleToInstanceProfile
      (identitymanagement/add-role-to-instance-profile-request
       (clojure.core/nth args12996 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m12998]
   (clojure.core/let
    [credentials12999 (:credentials m12998) args13000 (:args m12998)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13001
      (com.palletops.awaze.common/aws-client :iam credentials12999)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13001
       enableMFADevice
       (identitymanagement/enable-mfadevice-request
        (clojure.core/nth args13000 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableMFADevice"}
   [credentials13003 & args13004]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13005
     (com.palletops.awaze.common/aws-client :iam credentials13003)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13005
      enableMFADevice
      (identitymanagement/enable-mfadevice-request
       (clojure.core/nth args13004 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m13006]
   (clojure.core/let
    [credentials13007 (:credentials m13006) args13008 (:args m13006)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13009
      (com.palletops.awaze.common/aws-client :iam credentials13007)]
     (clojure.core/case
      (clojure.core/count args13008)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13009
        listGroups
        (identitymanagement/list-groups-request
         (clojure.core/nth args13008 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13009
        listGroups))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-groups,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-groups,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGroups, listGroups"}
   [credentials13011 & args13012]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13013
     (com.palletops.awaze.common/aws-client :iam credentials13011)]
    (clojure.core/case
     (clojure.core/count args13012)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13013
       listGroups
       (identitymanagement/list-groups-request
        (clojure.core/nth args13012 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13013
       listGroups))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy-version
   [m13014]
   (clojure.core/let
    [credentials13015 (:credentials m13014) args13016 (:args m13014)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13017
      (com.palletops.awaze.common/aws-client :iam credentials13015)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13017
       deletePolicyVersion
       (identitymanagement/delete-policy-version-request
        (clojure.core/nth args13016 0)))))))
  (clojure.core/defn
   delete-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicyVersion"}
   [credentials13019 & args13020]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13021
     (com.palletops.awaze.common/aws-client :iam credentials13019)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13021
      deletePolicyVersion
      (identitymanagement/delete-policy-version-request
       (clojure.core/nth args13020 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m13022]
   (clojure.core/let
    [credentials13023 (:credentials m13022) args13024 (:args m13022)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13025
      (com.palletops.awaze.common/aws-client :iam credentials13023)]
     (clojure.core/case
      (clojure.core/count args13024)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13025
        createAccessKey))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13025
        createAccessKey
        (identitymanagement/create-access-key-request
         (clojure.core/nth args13024 0))))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-access-key,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials13027 & args13028]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13029
     (com.palletops.awaze.common/aws-client :iam credentials13027)]
    (clojure.core/case
     (clojure.core/count args13028)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13029
       createAccessKey))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13029
       createAccessKey
       (identitymanagement/create-access-key-request
        (clojure.core/nth args13028 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m13030]
   (clojure.core/let
    [credentials13031 (:credentials m13030) args13032 (:args m13030)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13033
      (com.palletops.awaze.common/aws-client :iam credentials13031)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13033
       deleteVirtualMFADevice
       (identitymanagement/delete-virtual-mfadevice-request
        (clojure.core/nth args13032 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials13035 & args13036]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13037
     (com.palletops.awaze.common/aws-client :iam credentials13035)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13037
      deleteVirtualMFADevice
      (identitymanagement/delete-virtual-mfadevice-request
       (clojure.core/nth args13036 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m13038]
   (clojure.core/let
    [credentials13039 (:credentials m13038) args13040 (:args m13038)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13041
      (com.palletops.awaze.common/aws-client :iam credentials13039)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13041
       getInstanceProfile
       (identitymanagement/get-instance-profile-request
        (clojure.core/nth args13040 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInstanceProfile"}
   [credentials13043 & args13044]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13045
     (com.palletops.awaze.common/aws-client :iam credentials13043)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13045
      getInstanceProfile
      (identitymanagement/get-instance-profile-request
       (clojure.core/nth args13044 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-samlprovider
   [m13046]
   (clojure.core/let
    [credentials13047 (:credentials m13046) args13048 (:args m13046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13049
      (com.palletops.awaze.common/aws-client :iam credentials13047)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13049
       createSAMLProvider
       (identitymanagement/create-samlprovider-request
        (clojure.core/nth args13048 0)))))))
  (clojure.core/defn
   create-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSAMLProvider"}
   [credentials13051 & args13052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13053
     (com.palletops.awaze.common/aws-client :iam credentials13051)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13053
      createSAMLProvider
      (identitymanagement/create-samlprovider-request
       (clojure.core/nth args13052 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-samlprovider
   [m13054]
   (clojure.core/let
    [credentials13055 (:credentials m13054) args13056 (:args m13054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13057
      (com.palletops.awaze.common/aws-client :iam credentials13055)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13057
       updateSAMLProvider
       (identitymanagement/update-samlprovider-request
        (clojure.core/nth args13056 0)))))))
  (clojure.core/defn
   update-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSAMLProvider"}
   [credentials13059 & args13060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13061
     (com.palletops.awaze.common/aws-client :iam credentials13059)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13061
      updateSAMLProvider
      (identitymanagement/update-samlprovider-request
       (clojure.core/nth args13060 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-sshpublic-key
   [m13062]
   (clojure.core/let
    [credentials13063 (:credentials m13062) args13064 (:args m13062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13065
      (com.palletops.awaze.common/aws-client :iam credentials13063)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13065
       deleteSSHPublicKey
       (identitymanagement/delete-sshpublic-key-request
        (clojure.core/nth args13064 0)))))))
  (clojure.core/defn
   delete-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSSHPublicKey"}
   [credentials13067 & args13068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13069
     (com.palletops.awaze.common/aws-client :iam credentials13067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13069
      deleteSSHPublicKey
      (identitymanagement/delete-sshpublic-key-request
       (clojure.core/nth args13068 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-custom-policy
   [m13070]
   (clojure.core/let
    [credentials13071 (:credentials m13070) args13072 (:args m13070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13073
      (com.palletops.awaze.common/aws-client :iam credentials13071)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13073
       simulateCustomPolicy
       (identitymanagement/simulate-custom-policy-request
        (clojure.core/nth args13072 0)))))))
  (clojure.core/defn
   simulate-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulateCustomPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :simulate-custom-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulateCustomPolicy"}
   [credentials13075 & args13076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13077
     (com.palletops.awaze.common/aws-client :iam credentials13075)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13077
      simulateCustomPolicy
      (identitymanagement/simulate-custom-policy-request
       (clojure.core/nth args13076 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-custom-policy
   [m13078]
   (clojure.core/let
    [credentials13079 (:credentials m13078) args13080 (:args m13078)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13081
      (com.palletops.awaze.common/aws-client :iam credentials13079)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13081
       getContextKeysForCustomPolicy
       (identitymanagement/get-context-keys-for-custom-policy-request
        (clojure.core/nth args13080 0)))))))
  (clojure.core/defn
   get-context-keys-for-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForCustomPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-custom-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForCustomPolicy"}
   [credentials13083 & args13084]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13085
     (com.palletops.awaze.common/aws-client :iam credentials13083)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13085
      getContextKeysForCustomPolicy
      (identitymanagement/get-context-keys-for-custom-policy-request
       (clojure.core/nth args13084 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m13086]
   (clojure.core/let
    [credentials13087 (:credentials m13086) args13088 (:args m13086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13089
      (com.palletops.awaze.common/aws-client :iam credentials13087)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13089
       listUserPolicies
       (identitymanagement/list-user-policies-request
        (clojure.core/nth args13088 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-user-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUserPolicies"}
   [credentials13091 & args13092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13093
     (com.palletops.awaze.common/aws-client :iam credentials13091)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13093
      listUserPolicies
      (identitymanagement/list-user-policies-request
       (clojure.core/nth args13092 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m13094]
   (clojure.core/let
    [credentials13095 (:credentials m13094) args13096 (:args m13094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13097
      (com.palletops.awaze.common/aws-client :iam credentials13095)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13097
       updateGroup
       (identitymanagement/update-group-request
        (clojure.core/nth args13096 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Call updateGroup"}
   [credentials13099 & args13100]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13101
     (com.palletops.awaze.common/aws-client :iam credentials13099)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13101
      updateGroup
      (identitymanagement/update-group-request
       (clojure.core/nth args13100 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-entities-for-policy
   [m13102]
   (clojure.core/let
    [credentials13103 (:credentials m13102) args13104 (:args m13102)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13105
      (com.palletops.awaze.common/aws-client :iam credentials13103)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13105
       listEntitiesForPolicy
       (identitymanagement/list-entities-for-policy-request
        (clojure.core/nth args13104 0)))))))
  (clojure.core/defn
   list-entities-for-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listEntitiesForPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-entities-for-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-entities-for-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listEntitiesForPolicy"}
   [credentials13107 & args13108]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13109
     (com.palletops.awaze.common/aws-client :iam credentials13107)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13109
      listEntitiesForPolicy
      (identitymanagement/list-entities-for-policy-request
       (clojure.core/nth args13108 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policies
   [m13110]
   (clojure.core/let
    [credentials13111 (:credentials m13110) args13112 (:args m13110)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13113
      (com.palletops.awaze.common/aws-client :iam credentials13111)]
     (clojure.core/case
      (clojure.core/count args13112)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13113
        listPolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13113
        listPolicies
        (identitymanagement/list-policies-request
         (clojure.core/nth args13112 0))))))))
  (clojure.core/defn
   list-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPolicies, listPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-policies,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listPolicies, listPolicies"}
   [credentials13115 & args13116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13117
     (com.palletops.awaze.common/aws-client :iam credentials13115)]
    (clojure.core/case
     (clojure.core/count args13116)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13117
       listPolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13117
       listPolicies
       (identitymanagement/list-policies-request
        (clojure.core/nth args13116 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m13118]
   (clojure.core/let
    [credentials13119 (:credentials m13118) args13120 (:args m13118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13121
      (com.palletops.awaze.common/aws-client :iam credentials13119)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13121
       deleteUser
       (identitymanagement/delete-user-request
        (clojure.core/nth args13120 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUser"}
   [credentials13123 & args13124]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13125
     (com.palletops.awaze.common/aws-client :iam credentials13123)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13125
      deleteUser
      (identitymanagement/delete-user-request
       (clojure.core/nth args13124 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m13126]
   (clojure.core/let
    [credentials13127 (:credentials m13126) args13128 (:args m13126)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13129
      (com.palletops.awaze.common/aws-client :iam credentials13127)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13129
       updateSigningCertificate
       (identitymanagement/update-signing-certificate-request
        (clojure.core/nth args13128 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials13131 & args13132]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13133
     (com.palletops.awaze.common/aws-client :iam credentials13131)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13133
      updateSigningCertificate
      (identitymanagement/update-signing-certificate-request
       (clojure.core/nth args13132 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-principal-policy
   [m13134]
   (clojure.core/let
    [credentials13135 (:credentials m13134) args13136 (:args m13134)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13137
      (com.palletops.awaze.common/aws-client :iam credentials13135)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13137
       getContextKeysForPrincipalPolicy
       (identitymanagement/get-context-keys-for-principal-policy-request
        (clojure.core/nth args13136 0)))))))
  (clojure.core/defn
   get-context-keys-for-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForPrincipalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-principal-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForPrincipalPolicy"}
   [credentials13139 & args13140]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13141
     (com.palletops.awaze.common/aws-client :iam credentials13139)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13141
      getContextKeysForPrincipalPolicy
      (identitymanagement/get-context-keys-for-principal-policy-request
       (clojure.core/nth args13140 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m13142]
   (clojure.core/let
    [credentials13143 (:credentials m13142) args13144 (:args m13142)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13145
      (com.palletops.awaze.common/aws-client :iam credentials13143)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13145
       updateServerCertificate
       (identitymanagement/update-server-certificate-request
        (clojure.core/nth args13144 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServerCertificate"}
   [credentials13147 & args13148]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13149
     (com.palletops.awaze.common/aws-client :iam credentials13147)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13149
      updateServerCertificate
      (identitymanagement/update-server-certificate-request
       (clojure.core/nth args13148 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-user-policies
   [m13150]
   (clojure.core/let
    [credentials13151 (:credentials m13150) args13152 (:args m13150)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13153
      (com.palletops.awaze.common/aws-client :iam credentials13151)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13153
       listAttachedUserPolicies
       (identitymanagement/list-attached-user-policies-request
        (clojure.core/nth args13152 0)))))))
  (clojure.core/defn
   list-attached-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedUserPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-user-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedUserPolicies"}
   [credentials13155 & args13156]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13157
     (com.palletops.awaze.common/aws-client :iam credentials13155)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13157
      listAttachedUserPolicies
      (identitymanagement/list-attached-user-policies-request
       (clojure.core/nth args13156 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy-version
   [m13158]
   (clojure.core/let
    [credentials13159 (:credentials m13158) args13160 (:args m13158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13161
      (com.palletops.awaze.common/aws-client :iam credentials13159)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13161
       createPolicyVersion
       (identitymanagement/create-policy-version-request
        (clojure.core/nth args13160 0)))))))
  (clojure.core/defn
   create-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Generate map for createPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Call createPolicyVersion"}
   [credentials13163 & args13164]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13165
     (com.palletops.awaze.common/aws-client :iam credentials13163)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13165
      createPolicyVersion
      (identitymanagement/create-policy-version-request
       (clojure.core/nth args13164 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m13166]
   (clojure.core/let
    [credentials13167 (:credentials m13166) args13168 (:args m13166)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13169
      (com.palletops.awaze.common/aws-client :iam credentials13167)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13169
       createLoginProfile
       (identitymanagement/create-login-profile-request
        (clojure.core/nth args13168 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoginProfile"}
   [credentials13171 & args13172]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13173
     (com.palletops.awaze.common/aws-client :iam credentials13171)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13173
      createLoginProfile
      (identitymanagement/create-login-profile-request
       (clojure.core/nth args13172 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-principal-policy
   [m13174]
   (clojure.core/let
    [credentials13175 (:credentials m13174) args13176 (:args m13174)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13177
      (com.palletops.awaze.common/aws-client :iam credentials13175)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13177
       simulatePrincipalPolicy
       (identitymanagement/simulate-principal-policy-request
        (clojure.core/nth args13176 0)))))))
  (clojure.core/defn
   simulate-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulatePrincipalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :simulate-principal-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulatePrincipalPolicy"}
   [credentials13179 & args13180]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13181
     (com.palletops.awaze.common/aws-client :iam credentials13179)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13181
      simulatePrincipalPolicy
      (identitymanagement/simulate-principal-policy-request
       (clojure.core/nth args13180 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-open-idconnect-provider
   [m13182]
   (clojure.core/let
    [credentials13183 (:credentials m13182) args13184 (:args m13182)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13185
      (com.palletops.awaze.common/aws-client :iam credentials13183)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13185
       createOpenIDConnectProvider
       (identitymanagement/create-open-idconnect-provider-request
        (clojure.core/nth args13184 0)))))))
  (clojure.core/defn
   create-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Call createOpenIDConnectProvider"}
   [credentials13187 & args13188]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13189
     (com.palletops.awaze.common/aws-client :iam credentials13187)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13189
      createOpenIDConnectProvider
      (identitymanagement/create-open-idconnect-provider-request
       (clojure.core/nth args13188 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-role-policy
   [m13190]
   (clojure.core/let
    [credentials13191 (:credentials m13190) args13192 (:args m13190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13193
      (com.palletops.awaze.common/aws-client :iam credentials13191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13193
       attachRolePolicy
       (identitymanagement/attach-role-policy-request
        (clojure.core/nth args13192 0)))))))
  (clojure.core/defn
   attach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachRolePolicy"}
   [credentials13195 & args13196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13197
     (com.palletops.awaze.common/aws-client :iam credentials13195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13197
      attachRolePolicy
      (identitymanagement/attach-role-policy-request
       (clojure.core/nth args13196 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m13198]
   (clojure.core/let
    [credentials13199 (:credentials m13198) args13200 (:args m13198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13201
      (com.palletops.awaze.common/aws-client :iam credentials13199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13201
       getGroupPolicy
       (identitymanagement/get-group-policy-request
        (clojure.core/nth args13200 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroupPolicy"}
   [credentials13203 & args13204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13205
     (com.palletops.awaze.common/aws-client :iam credentials13203)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13205
      getGroupPolicy
      (identitymanagement/get-group-policy-request
       (clojure.core/nth args13204 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-user-policy
   [m13206]
   (clojure.core/let
    [credentials13207 (:credentials m13206) args13208 (:args m13206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13209
      (com.palletops.awaze.common/aws-client :iam credentials13207)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13209
       detachUserPolicy
       (identitymanagement/detach-user-policy-request
        (clojure.core/nth args13208 0)))))))
  (clojure.core/defn
   detach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachUserPolicy"}
   [credentials13211 & args13212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13213
     (com.palletops.awaze.common/aws-client :iam credentials13211)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13213
      detachUserPolicy
      (identitymanagement/detach-user-policy-request
       (clojure.core/nth args13212 0))))))))
