(ns
 com.palletops.awaze.elasticmapreduce
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticmapreduce :as elasticmapreduce]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Configuration}
configuration
  [m8153]
  (clojure.core/let
   [bean8152
    (new com.amazonaws.services.elasticmapreduce.model.Configuration)]
   (clojure.core/let
    [v8154
     (:configurations m8153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8154 :com.palletops.awaze.client-builder/undef)
     (.
      bean8152
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8257] (elasticmapreduce/configuration arg8257))
 v8154))))
   (clojure.core/let
    [v8154
     (:classification m8153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8154 :com.palletops.awaze.client-builder/undef)
     (. bean8152 setClassification (clojure.core/str v8154))))
   (clojure.core/let
    [v8154
     (:properties m8153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8154 :com.palletops.awaze.client-builder/undef)
     (.
      bean8152
      setProperties
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8258] (clojure.core/str arg8258))
  (clojure.core/keys v8154))
 (clojure.core/map
  (clojure.core/fn [arg8258] (clojure.core/str arg8258))
  (clojure.core/vals v8154))))))
   bean8152))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.VolumeSpecification}
volume-specification
  [m8156]
  (clojure.core/let
   [bean8155
    (new
     com.amazonaws.services.elasticmapreduce.model.VolumeSpecification)]
   (clojure.core/let
    [v8157
     (:size-in-gb m8156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8157 :com.palletops.awaze.client-builder/undef)
     (. bean8155 setSizeInGB (clojure.core/int v8157))))
   (clojure.core/let
    [v8157
     (:volume-type m8156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8157 :com.palletops.awaze.client-builder/undef)
     (. bean8155 setVolumeType (clojure.core/str v8157))))
   (clojure.core/let
    [v8157 (:iops m8156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8157 :com.palletops.awaze.client-builder/undef)
     (. bean8155 setIops (clojure.core/int v8157))))
   bean8155))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig}
ebs-block-device-config
  [m8159]
  (clojure.core/let
   [bean8158
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig)]
   (clojure.core/let
    [v8160
     (:volume-specification
      m8159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8160 :com.palletops.awaze.client-builder/undef)
     (.
      bean8158
      setVolumeSpecification
      (elasticmapreduce/volume-specification v8160))))
   (clojure.core/let
    [v8160
     (:volumes-per-instance
      m8159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8160 :com.palletops.awaze.client-builder/undef)
     (. bean8158 setVolumesPerInstance (clojure.core/int v8160))))
   bean8158))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceRoleType}
instance-role-type
  [m8162]
  (.
   com.amazonaws.services.elasticmapreduce.model.InstanceRoleType
   fromValue
   (clojure.core/name m8162)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsConfiguration}
ebs-configuration
  [m8165]
  (clojure.core/let
   [bean8164
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsConfiguration)]
   (clojure.core/let
    [v8166
     (:ebs-optimized m8165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (. bean8164 setEbsOptimized (clojure.core/boolean v8166))))
   (clojure.core/let
    [v8166
     (:ebs-block-device-configs
      m8165
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (.
      bean8164
      setEbsBlockDeviceConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8259]
  (elasticmapreduce/ebs-block-device-config arg8259))
 v8166))))
   bean8164))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.KeyValue}
key-value
  [m8168]
  (clojure.core/let
   [bean8167
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/let
    [v8169 (:key m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (. bean8167 setKey (clojure.core/str v8169))))
   (clojure.core/let
    [v8169 (:value m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (. bean8167 setValue (clojure.core/str v8169))))
   bean8167))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.PlacementType}
placement-type
  [m8171]
  (clojure.core/let
   [bean8170
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/let
    [v8172
     (:availability-zone
      m8171
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8172 :com.palletops.awaze.client-builder/undef)
     (. bean8170 setAvailabilityZone (clojure.core/str v8172))))
   bean8170))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig}
instance-group-config
  [m8174]
  (clojure.core/let
   [bean8173
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/let
    [v8175
     (:configurations m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (.
      bean8173
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8260] (elasticmapreduce/configuration arg8260))
 v8175))))
   (clojure.core/let
    [v8175 (:market m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setMarket (clojure.core/str v8175))))
   (clojure.core/let
    [v8175
     (:instance-role m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (.
      bean8173
      setInstanceRole
      (elasticmapreduce/instance-role-type v8175))))
   (clojure.core/let
    [v8175
     (:bid-price m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setBidPrice (clojure.core/str v8175))))
   (clojure.core/let
    [v8175
     (:ebs-configuration
      m8174
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (.
      bean8173
      setEbsConfiguration
      (elasticmapreduce/ebs-configuration v8175))))
   (clojure.core/let
    [v8175
     (:instance-type m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setInstanceType (clojure.core/str v8175))))
   (clojure.core/let
    [v8175
     (:instance-count m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setInstanceCount (clojure.core/int v8175))))
   (clojure.core/let
    [v8175 (:name m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setName (clojure.core/str v8175))))
   bean8173))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig}
hadoop-jar-step-config
  [m8177]
  (clojure.core/let
   [bean8176
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/let
    [v8178 (:args m8177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8178 :com.palletops.awaze.client-builder/undef)
     (.
      bean8176
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8261] (clojure.core/str arg8261))
 v8178))))
   (clojure.core/let
    [v8178 (:jar m8177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8178 :com.palletops.awaze.client-builder/undef)
     (. bean8176 setJar (clojure.core/str v8178))))
   (clojure.core/let
    [v8178
     (:main-class m8177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8178 :com.palletops.awaze.client-builder/undef)
     (. bean8176 setMainClass (clojure.core/str v8178))))
   (clojure.core/let
    [v8178
     (:properties m8177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8178 :com.palletops.awaze.client-builder/undef)
     (.
      bean8176
      setProperties
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8262] (elasticmapreduce/key-value arg8262))
 v8178))))
   bean8176))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ActionOnFailure}
action-on-failure
  [m8180]
  (.
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   fromValue
   (clojure.core/name m8180)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig}
script-bootstrap-action-config
  [m8183]
  (clojure.core/let
   [bean8182
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/let
    [v8184 (:args m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8263] (clojure.core/str arg8263))
 v8184))))
   (clojure.core/let
    [v8184 (:path m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setPath (clojure.core/str v8184))))
   bean8182))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig}
instance-group-modify-config
  [m8186]
  (clojure.core/let
   [bean8185
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/let
    [v8187
     (:instance-group-id
      m8186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (. bean8185 setInstanceGroupId (clojure.core/str v8187))))
   (clojure.core/let
    [v8187
     (:ec2instance-ids-to-terminate
      m8186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (.
      bean8185
      setEC2InstanceIdsToTerminate
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8264] (clojure.core/str arg8264))
 v8187))))
   (clojure.core/let
    [v8187
     (:instance-count m8186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (. bean8185 setInstanceCount (clojure.core/int v8187))))
   bean8185))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Tag}
tag
  [m8189]
  (clojure.core/let
   [bean8188 (new com.amazonaws.services.elasticmapreduce.model.Tag)]
   (clojure.core/let
    [v8190 (:key m8189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8190 :com.palletops.awaze.client-builder/undef)
     (. bean8188 setKey (clojure.core/str v8190))))
   (clojure.core/let
    [v8190 (:value m8189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8190 :com.palletops.awaze.client-builder/undef)
     (. bean8188 setValue (clojure.core/str v8190))))
   bean8188))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig}
job-flow-instances-config
  [m8192]
  (clojure.core/let
   [bean8191
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/let
    [v8193
     (:additional-master-security-groups
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setAdditionalMasterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8265] (clojure.core/str arg8265))
 v8193))))
   (clojure.core/let
    [v8193
     (:keep-job-flow-alive-when-no-steps
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setKeepJobFlowAliveWhenNoSteps
      (clojure.core/boolean v8193))))
   (clojure.core/let
    [v8193
     (:placement m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setPlacement (elasticmapreduce/placement-type v8193))))
   (clojure.core/let
    [v8193
     (:hadoop-version m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setHadoopVersion (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:ec2subnet-id m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setEc2SubnetId (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:master-instance-type
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setMasterInstanceType (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:slave-instance-type
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setSlaveInstanceType (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:termination-protected
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setTerminationProtected (clojure.core/boolean v8193))))
   (clojure.core/let
    [v8193
     (:emr-managed-master-security-group
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setEmrManagedMasterSecurityGroup
      (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:additional-slave-security-groups
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setAdditionalSlaveSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8266] (clojure.core/str arg8266))
 v8193))))
   (clojure.core/let
    [v8193
     (:ec2key-name m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setEc2KeyName (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:instance-count m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setInstanceCount (clojure.core/int v8193))))
   (clojure.core/let
    [v8193
     (:instance-groups
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8267]
  (elasticmapreduce/instance-group-config arg8267))
 v8193))))
   (clojure.core/let
    [v8193
     (:service-access-security-group
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setServiceAccessSecurityGroup
      (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:emr-managed-slave-security-group
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setEmrManagedSlaveSecurityGroup
      (clojure.core/str v8193))))
   bean8191))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Application}
application
  [m8195]
  (clojure.core/let
   [bean8194
    (new com.amazonaws.services.elasticmapreduce.model.Application)]
   (clojure.core/let
    [v8196 (:version m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (. bean8194 setVersion (clojure.core/str v8196))))
   (clojure.core/let
    [v8196
     (:additional-info
      m8195
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (.
      bean8194
      setAdditionalInfo
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8268] (clojure.core/str arg8268))
  (clojure.core/keys v8196))
 (clojure.core/map
  (clojure.core/fn [arg8268] (clojure.core/str arg8268))
  (clojure.core/vals v8196))))))
   (clojure.core/let
    [v8196 (:args m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (.
      bean8194
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8269] (clojure.core/str arg8269))
 v8196))))
   (clojure.core/let
    [v8196 (:name m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (. bean8194 setName (clojure.core/str v8196))))
   bean8194))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.StepConfig}
step-config
  [m8198]
  (clojure.core/let
   [bean8197
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/let
    [v8199
     (:hadoop-jar-step
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setHadoopJarStep
      (elasticmapreduce/hadoop-jar-step-config v8199))))
   (clojure.core/let
    [v8199
     (:action-on-failure
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setActionOnFailure
      (elasticmapreduce/action-on-failure v8199))))
   (clojure.core/let
    [v8199 (:name m8198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setName (clojure.core/str v8199))))
   bean8197))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig}
supported-product-config
  [m8201]
  (clojure.core/let
   [bean8200
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/let
    [v8202 (:args m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (.
      bean8200
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8270] (clojure.core/str arg8270))
 v8202))))
   (clojure.core/let
    [v8202 (:name m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (. bean8200 setName (clojure.core/str v8202))))
   bean8200))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig}
bootstrap-action-config
  [m8204]
  (clojure.core/let
   [bean8203
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/let
    [v8205
     (:script-bootstrap-action
      m8204
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (.
      bean8203
      setScriptBootstrapAction
      (elasticmapreduce/script-bootstrap-action-config v8205))))
   (clojure.core/let
    [v8205 (:name m8204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (. bean8203 setName (clojure.core/str v8205))))
   bean8203))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest}
modify-instance-groups-request
  [m8207]
  (clojure.core/let
   [bean8206
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/let
    [v8208
     (:instance-groups
      m8207
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8208 :com.palletops.awaze.client-builder/undef)
     (.
      bean8206
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8271]
  (elasticmapreduce/instance-group-modify-config arg8271))
 v8208))))
   bean8206))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest}
list-instance-groups-request
  [m8210]
  (clojure.core/let
   [bean8209
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/let
    [v8211 (:marker m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setMarker (clojure.core/str v8211))))
   (clojure.core/let
    [v8211
     (:cluster-id m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setClusterId (clojure.core/str v8211))))
   bean8209))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListClustersRequest}
list-clusters-request
  [m8213]
  (clojure.core/let
   [bean8212
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/let
    [v8214 (:marker m8213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (. bean8212 setMarker (clojure.core/str v8214))))
   (clojure.core/let
    [v8214
     (:created-after m8213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (.
      bean8212
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8214))))
   (clojure.core/let
    [v8214
     (:created-before m8213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (.
      bean8212
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8214))))
   (clojure.core/let
    [v8214
     (:cluster-states m8213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (.
      bean8212
      setClusterStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8272] (clojure.core/str arg8272))
 v8214))))
   bean8212))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest}
remove-tags-request
  [m8216]
  (clojure.core/let
   [bean8215
    (new
     com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest)]
   (clojure.core/let
    [v8217
     (:resource-id m8216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (. bean8215 setResourceId (clojure.core/str v8217))))
   (clojure.core/let
    [v8217
     (:tag-keys m8216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (.
      bean8215
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8273] (clojure.core/str arg8273))
 v8217))))
   bean8215))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddTagsRequest}
add-tags-request
  [m8219]
  (clojure.core/let
   [bean8218
    (new com.amazonaws.services.elasticmapreduce.model.AddTagsRequest)]
   (clojure.core/let
    [v8220 (:tags m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (.
      bean8218
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8274] (elasticmapreduce/tag arg8274))
 v8220))))
   (clojure.core/let
    [v8220
     (:resource-id m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (. bean8218 setResourceId (clojure.core/str v8220))))
   bean8218))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest}
set-visible-to-all-users-request
  [m8222]
  (clojure.core/let
   [bean8221
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/let
    [v8223
     (:job-flow-ids m8222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8223 :com.palletops.awaze.client-builder/undef)
     (.
      bean8221
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8275] (clojure.core/str arg8275))
 v8223))))
   (clojure.core/let
    [v8223
     (:visible-to-all-users
      m8222
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8223 :com.palletops.awaze.client-builder/undef)
     (. bean8221 setVisibleToAllUsers (clojure.core/boolean v8223))))
   bean8221))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest}
list-instances-request
  [m8225]
  (clojure.core/let
   [bean8224
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/let
    [v8226 (:marker m8225 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8226 :com.palletops.awaze.client-builder/undef)
     (. bean8224 setMarker (clojure.core/str v8226))))
   (clojure.core/let
    [v8226
     (:cluster-id m8225 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8226 :com.palletops.awaze.client-builder/undef)
     (. bean8224 setClusterId (clojure.core/str v8226))))
   (clojure.core/let
    [v8226
     (:instance-group-id
      m8225
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8226 :com.palletops.awaze.client-builder/undef)
     (. bean8224 setInstanceGroupId (clojure.core/str v8226))))
   (clojure.core/let
    [v8226
     (:instance-group-types
      m8225
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8226 :com.palletops.awaze.client-builder/undef)
     (.
      bean8224
      setInstanceGroupTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8276] (clojure.core/str arg8276))
 v8226))))
   bean8224))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest}
describe-cluster-request
  [m8228]
  (clojure.core/let
   [bean8227
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/let
    [v8229
     (:cluster-id m8228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (. bean8227 setClusterId (clojure.core/str v8229))))
   bean8227))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest}
list-bootstrap-actions-request
  [m8231]
  (clojure.core/let
   [bean8230
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/let
    [v8232 (:marker m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setMarker (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:cluster-id m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setClusterId (clojure.core/str v8232))))
   bean8230))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest}
terminate-job-flows-request
  [m8234]
  (clojure.core/let
   [bean8233
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/let
    [v8235
     (:job-flow-ids m8234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8235 :com.palletops.awaze.client-builder/undef)
     (.
      bean8233
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8277] (clojure.core/str arg8277))
 v8235))))
   bean8233))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest}
describe-job-flows-request
  [m8237]
  (clojure.core/let
   [bean8236
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/let
    [v8238
     (:job-flow-ids m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (.
      bean8236
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8278] (clojure.core/str arg8278))
 v8238))))
   (clojure.core/let
    [v8238
     (:created-after m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (.
      bean8236
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8238))))
   (clojure.core/let
    [v8238
     (:created-before m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (.
      bean8236
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8238))))
   (clojure.core/let
    [v8238
     (:job-flow-states
      m8237
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (.
      bean8236
      setJobFlowStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8279] (clojure.core/str arg8279))
 v8238))))
   bean8236))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest}
run-job-flow-request
  [m8240]
  (clojure.core/let
   [bean8239
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/let
    [v8241
     (:job-flow-role m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setJobFlowRole (clojure.core/str v8241))))
   (clojure.core/let
    [v8241
     (:instances m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setInstances
      (elasticmapreduce/job-flow-instances-config v8241))))
   (clojure.core/let
    [v8241
     (:additional-info
      m8240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setAdditionalInfo (clojure.core/str v8241))))
   (clojure.core/let
    [v8241
     (:visible-to-all-users
      m8240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setVisibleToAllUsers (clojure.core/boolean v8241))))
   (clojure.core/let
    [v8241 (:name m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setName (clojure.core/str v8241))))
   (clojure.core/let
    [v8241
     (:applications m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setApplications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8280] (elasticmapreduce/application arg8280))
 v8241))))
   (clojure.core/let
    [v8241
     (:service-role m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setServiceRole (clojure.core/str v8241))))
   (clojure.core/let
    [v8241 (:steps m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8281] (elasticmapreduce/step-config arg8281))
 v8241))))
   (clojure.core/let
    [v8241
     (:supported-products
      m8240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8282] (clojure.core/str arg8282))
 v8241))))
   (clojure.core/let
    [v8241
     (:ami-version m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setAmiVersion (clojure.core/str v8241))))
   (clojure.core/let
    [v8241 (:tags m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8283] (elasticmapreduce/tag arg8283))
 v8241))))
   (clojure.core/let
    [v8241 (:log-uri m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setLogUri (clojure.core/str v8241))))
   (clojure.core/let
    [v8241
     (:configurations m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8284] (elasticmapreduce/configuration arg8284))
 v8241))))
   (clojure.core/let
    [v8241
     (:release-label m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setReleaseLabel (clojure.core/str v8241))))
   (clojure.core/let
    [v8241
     (:new-supported-products
      m8240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setNewSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8285]
  (elasticmapreduce/supported-product-config arg8285))
 v8241))))
   (clojure.core/let
    [v8241
     (:bootstrap-actions
      m8240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setBootstrapActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8286]
  (elasticmapreduce/bootstrap-action-config arg8286))
 v8241))))
   bean8239))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest}
add-instance-groups-request
  [m8243]
  (clojure.core/let
   [bean8242
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/let
    [v8244
     (:job-flow-id m8243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (. bean8242 setJobFlowId (clojure.core/str v8244))))
   (clojure.core/let
    [v8244
     (:instance-groups
      m8243
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (.
      bean8242
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8375]
  (elasticmapreduce/instance-group-config arg8375))
 v8244))))
   bean8242))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListStepsRequest}
list-steps-request
  [m8246]
  (clojure.core/let
   [bean8245
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/let
    [v8247 (:marker m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setMarker (clojure.core/str v8247))))
   (clojure.core/let
    [v8247
     (:cluster-id m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setClusterId (clojure.core/str v8247))))
   (clojure.core/let
    [v8247
     (:step-states m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setStepStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8376] (clojure.core/str arg8376))
 v8247))))
   (clojure.core/let
    [v8247
     (:step-ids m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setStepIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8377] (clojure.core/str arg8377))
 v8247))))
   bean8245))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest}
add-job-flow-steps-request
  [m8249]
  (clojure.core/let
   [bean8248
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/let
    [v8250
     (:job-flow-id m8249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8250 :com.palletops.awaze.client-builder/undef)
     (. bean8248 setJobFlowId (clojure.core/str v8250))))
   (clojure.core/let
    [v8250 (:steps m8249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8250 :com.palletops.awaze.client-builder/undef)
     (.
      bean8248
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8378] (elasticmapreduce/step-config arg8378))
 v8250))))
   bean8248))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest}
set-termination-protection-request
  [m8252]
  (clojure.core/let
   [bean8251
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/let
    [v8253
     (:job-flow-ids m8252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8253 :com.palletops.awaze.client-builder/undef)
     (.
      bean8251
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8379] (clojure.core/str arg8379))
 v8253))))
   (clojure.core/let
    [v8253
     (:termination-protected
      m8252
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8253 :com.palletops.awaze.client-builder/undef)
     (. bean8251 setTerminationProtected (clojure.core/boolean v8253))))
   bean8251))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest}
describe-step-request
  [m8255]
  (clojure.core/let
   [bean8254
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/let
    [v8256
     (:cluster-id m8255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8256 :com.palletops.awaze.client-builder/undef)
     (. bean8254 setClusterId (clojure.core/str v8256))))
   (clojure.core/let
    [v8256 (:step-id m8255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8256 :com.palletops.awaze.client-builder/undef)
     (. bean8254 setStepId (clojure.core/str v8256))))
   bean8254))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m8287]
   (clojure.core/let
    [credentials8288 (:credentials m8287) args8289 (:args m8287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8290
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8288)]
     (clojure.core/case
      (clojure.core/count args8289)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8290
        modifyInstanceGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8290
        modifyInstanceGroups
        (elasticmapreduce/modify-instance-groups-request
         (clojure.core/nth args8289 0))))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :modify-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials8292 & args8293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8294
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8292)]
    (clojure.core/case
     (clojure.core/count args8293)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8294
       modifyInstanceGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8294
       modifyInstanceGroups
       (elasticmapreduce/modify-instance-groups-request
        (clojure.core/nth args8293 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m8295]
   (clojure.core/let
    [credentials8296 (:credentials m8295) args8297 (:args m8295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8298
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8296)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8298
       listInstanceGroups
       (elasticmapreduce/list-instance-groups-request
        (clojure.core/nth args8297 0)))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceGroups"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceGroups"}
   [credentials8300 & args8301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8302
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8300)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8302
      listInstanceGroups
      (elasticmapreduce/list-instance-groups-request
       (clojure.core/nth args8301 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m8303]
   (clojure.core/let
    [credentials8304 (:credentials m8303) args8305 (:args m8303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8306
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8304)]
     (clojure.core/case
      (clojure.core/count args8305)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8306
        listClusters
        (elasticmapreduce/list-clusters-request
         (clojure.core/nth args8305 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8306
        listClusters))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Call listClusters, listClusters"}
   [credentials8308 & args8309]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8310
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8308)]
    (clojure.core/case
     (clojure.core/count args8309)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8310
       listClusters
       (elasticmapreduce/list-clusters-request
        (clojure.core/nth args8309 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8310
       listClusters))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :remove-tags
   [m8311]
   (clojure.core/let
    [credentials8312 (:credentials m8311) args8313 (:args m8311)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8314
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8312)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8314
       removeTags
       (elasticmapreduce/remove-tags-request
        (clojure.core/nth args8313 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials8316 & args8317]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8318
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8316)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8318
      removeTags
      (elasticmapreduce/remove-tags-request
       (clojure.core/nth args8317 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-tags
   [m8319]
   (clojure.core/let
    [credentials8320 (:credentials m8319) args8321 (:args m8319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8322
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8320)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8322
       addTags
       (elasticmapreduce/add-tags-request
        (clojure.core/nth args8321 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials8324 & args8325]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8326
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8324)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8326
      addTags
      (elasticmapreduce/add-tags-request
       (clojure.core/nth args8325 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m8327]
   (clojure.core/let
    [credentials8328 (:credentials m8327) args8329 (:args m8327)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8330
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8328)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8330
       setVisibleToAllUsers
       (elasticmapreduce/set-visible-to-all-users-request
        (clojure.core/nth args8329 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-visible-to-all-users,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials8332 & args8333]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8334
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8332)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8334
      setVisibleToAllUsers
      (elasticmapreduce/set-visible-to-all-users-request
       (clojure.core/nth args8333 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m8335]
   (clojure.core/let
    [credentials8336 (:credentials m8335) args8337 (:args m8335)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8338
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8336)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8338
       listInstances
       (elasticmapreduce/list-instances-request
        (clojure.core/nth args8337 0)))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instances,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstances"}
   [credentials8340 & args8341]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8342
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8340)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8342
      listInstances
      (elasticmapreduce/list-instances-request
       (clojure.core/nth args8341 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m8343]
   (clojure.core/let
    [credentials8344 (:credentials m8343) args8345 (:args m8343)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8346
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8344)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8346
       describeCluster
       (elasticmapreduce/describe-cluster-request
        (clojure.core/nth args8345 0)))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCluster"}
   [credentials8348 & args8349]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8350
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8348)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8350
      describeCluster
      (elasticmapreduce/describe-cluster-request
       (clojure.core/nth args8349 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m8351]
   (clojure.core/let
    [credentials8352 (:credentials m8351) args8353 (:args m8351)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8354
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8352)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8354
       listBootstrapActions
       (elasticmapreduce/list-bootstrap-actions-request
        (clojure.core/nth args8353 0)))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listBootstrapActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-bootstrap-actions,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listBootstrapActions"}
   [credentials8356 & args8357]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8358
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8356)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8358
      listBootstrapActions
      (elasticmapreduce/list-bootstrap-actions-request
       (clojure.core/nth args8357 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m8359]
   (clojure.core/let
    [credentials8360 (:credentials m8359) args8361 (:args m8359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8362
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8360)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8362
       terminateJobFlows
       (elasticmapreduce/terminate-job-flows-request
        (clojure.core/nth args8361 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateJobFlows"}
   [credentials8364 & args8365]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8366
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8364)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8366
      terminateJobFlows
      (elasticmapreduce/terminate-job-flows-request
       (clojure.core/nth args8365 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m8367]
   (clojure.core/let
    [credentials8368 (:credentials m8367) args8369 (:args m8367)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8370
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8368)]
     (clojure.core/case
      (clojure.core/count args8369)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8370
        describeJobFlows))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8370
        describeJobFlows
        (elasticmapreduce/describe-job-flows-request
         (clojure.core/nth args8369 0))))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials8372 & args8373]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8374
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8372)]
    (clojure.core/case
     (clojure.core/count args8373)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8374
       describeJobFlows))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8374
       describeJobFlows
       (elasticmapreduce/describe-job-flows-request
        (clojure.core/nth args8373 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m8380]
   (clojure.core/let
    [credentials8381 (:credentials m8380) args8382 (:args m8380)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8383
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8381)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8383
       runJobFlow
       (elasticmapreduce/run-job-flow-request
        (clojure.core/nth args8382 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-job-flow,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Call runJobFlow"}
   [credentials8385 & args8386]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8387
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8385)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8387
      runJobFlow
      (elasticmapreduce/run-job-flow-request
       (clojure.core/nth args8386 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m8388]
   (clojure.core/let
    [credentials8389 (:credentials m8388) args8390 (:args m8388)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8391
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8389)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8391
       addInstanceGroups
       (elasticmapreduce/add-instance-groups-request
        (clojure.core/nth args8390 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addInstanceGroups"}
   [credentials8393 & args8394]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8395
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8393)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8395
      addInstanceGroups
      (elasticmapreduce/add-instance-groups-request
       (clojure.core/nth args8394 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m8396]
   (clojure.core/let
    [credentials8397 (:credentials m8396) args8398 (:args m8396)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8399
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8397)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8399
       listSteps
       (elasticmapreduce/list-steps-request
        (clojure.core/nth args8398 0)))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Generate map for listSteps"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-steps,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Call listSteps"}
   [credentials8401 & args8402]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8403
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8401)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8403
      listSteps
      (elasticmapreduce/list-steps-request
       (clojure.core/nth args8402 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m8404]
   (clojure.core/let
    [credentials8405 (:credentials m8404) args8406 (:args m8404)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8407
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8405)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8407
       addJobFlowSteps
       (elasticmapreduce/add-job-flow-steps-request
        (clojure.core/nth args8406 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-job-flow-steps,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials8409 & args8410]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8411
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8409)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8411
      addJobFlowSteps
      (elasticmapreduce/add-job-flow-steps-request
       (clojure.core/nth args8410 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m8412]
   (clojure.core/let
    [credentials8413 (:credentials m8412) args8414 (:args m8412)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8415
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8413)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8415
       setTerminationProtection
       (elasticmapreduce/set-termination-protection-request
        (clojure.core/nth args8414 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-termination-protection,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setTerminationProtection"}
   [credentials8417 & args8418]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8419
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8417)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8419
      setTerminationProtection
      (elasticmapreduce/set-termination-protection-request
       (clojure.core/nth args8418 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m8420]
   (clojure.core/let
    [credentials8421 (:credentials m8420) args8422 (:args m8420)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8423
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8421)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8423
       describeStep
       (elasticmapreduce/describe-step-request
        (clojure.core/nth args8422 0)))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Generate map for describeStep"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-step,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Call describeStep"}
   [credentials8425 & args8426]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8427
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8425)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8427
      describeStep
      (elasticmapreduce/describe-step-request
       (clojure.core/nth args8426 0))))))))
