(ns
 com.palletops.awaze.elasticache
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticache :as elasticache]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ParameterNameValue}
parameter-name-value
  [m14306]
  (clojure.core/let
   [bean14305
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/let
    [v14307
     (:parameter-value
      m14306
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14307 :com.palletops.awaze.client-builder/undef)
     (. bean14305 setParameterValue (clojure.core/str v14307))))
   (clojure.core/let
    [v14307
     (:parameter-name
      m14306
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14307 :com.palletops.awaze.client-builder/undef)
     (. bean14305 setParameterName (clojure.core/str v14307))))
   bean14305))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AZMode}
azmode
  [m14309]
  (.
   com.amazonaws.services.elasticache.model.AZMode
   fromValue
   (clojure.core/name m14309)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.Tag}
tag
  [m14312]
  (clojure.core/let
   [bean14311 (new com.amazonaws.services.elasticache.model.Tag)]
   (clojure.core/let
    [v14313 (:key m14312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setKey (clojure.core/str v14313))))
   (clojure.core/let
    [v14313 (:value m14312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setValue (clojure.core/str v14313))))
   bean14311))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest}
modify-cache-parameter-group-request
  [m14315]
  (clojure.core/let
   [bean14314
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/let
    [v14316
     (:cache-parameter-group-name
      m14315
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14316 :com.palletops.awaze.client-builder/undef)
     (.
      bean14314
      setCacheParameterGroupName
      (clojure.core/str v14316))))
   (clojure.core/let
    [v14316
     (:parameter-name-values
      m14315
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14316 :com.palletops.awaze.client-builder/undef)
     (.
      bean14314
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14428]
  (elasticache/parameter-name-value arg14428))
 v14316))))
   bean14314))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest}
describe-replication-groups-request
  [m14318]
  (clojure.core/let
   [bean14317
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/let
    [v14319
     (:replication-group-id
      m14318
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14319 :com.palletops.awaze.client-builder/undef)
     (. bean14317 setReplicationGroupId (clojure.core/str v14319))))
   (clojure.core/let
    [v14319
     (:marker m14318 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14319 :com.palletops.awaze.client-builder/undef)
     (. bean14317 setMarker (clojure.core/str v14319))))
   (clojure.core/let
    [v14319
     (:max-records m14318 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14319 :com.palletops.awaze.client-builder/undef)
     (. bean14317 setMaxRecords (clojure.core/int v14319))))
   bean14317))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheClusterRequest}
create-cache-cluster-request
  [m14321]
  (clojure.core/let
   [bean14320
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/let
    [v14322
     (:engine m14321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setEngine (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:preferred-availability-zones
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setPreferredAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14429] (clojure.core/str arg14429))
 v14322))))
   (clojure.core/let
    [v14322
     (:cache-subnet-group-name
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setCacheSubnetGroupName (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:replication-group-id
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setReplicationGroupId (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:security-group-ids
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14430] (clojure.core/str arg14430))
 v14322))))
   (clojure.core/let
    [v14322
     (:snapshot-retention-limit
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setSnapshotRetentionLimit (clojure.core/int v14322))))
   (clojure.core/let
    [v14322
     (:preferred-maintenance-window
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setPreferredMaintenanceWindow
      (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:azmode m14321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setAZMode (elasticache/azmode v14322))))
   (clojure.core/let
    [v14322
     (:notification-topic-arn
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setNotificationTopicArn (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:cache-security-group-names
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14431] (clojure.core/str arg14431))
 v14322))))
   (clojure.core/let
    [v14322
     (:snapshot-name m14321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setSnapshotName (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:preferred-availability-zone
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setPreferredAvailabilityZone
      (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:snapshot-arns m14321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14432] (clojure.core/str arg14432))
 v14322))))
   (clojure.core/let
    [v14322 (:port m14321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setPort (clojure.core/int v14322))))
   (clojure.core/let
    [v14322 (:tags m14321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14433] (elasticache/tag arg14433))
 v14322))))
   (clojure.core/let
    [v14322
     (:cache-parameter-group-name
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setCacheParameterGroupName
      (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:cache-cluster-id
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setCacheClusterId (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:num-cache-nodes
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setNumCacheNodes (clojure.core/int v14322))))
   (clojure.core/let
    [v14322
     (:auto-minor-version-upgrade
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (.
      bean14320
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14322))))
   (clojure.core/let
    [v14322
     (:snapshot-window
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setSnapshotWindow (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:engine-version
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setEngineVersion (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:cache-node-type
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setCacheNodeType (clojure.core/str v14322))))
   bean14320))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest}
describe-cache-parameter-groups-request
  [m14324]
  (clojure.core/let
   [bean14323
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/let
    [v14325
     (:cache-parameter-group-name
      m14324
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14325 :com.palletops.awaze.client-builder/undef)
     (.
      bean14323
      setCacheParameterGroupName
      (clojure.core/str v14325))))
   (clojure.core/let
    [v14325
     (:marker m14324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14325 :com.palletops.awaze.client-builder/undef)
     (. bean14323 setMarker (clojure.core/str v14325))))
   (clojure.core/let
    [v14325
     (:max-records m14324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14325 :com.palletops.awaze.client-builder/undef)
     (. bean14323 setMaxRecords (clojure.core/int v14325))))
   bean14323))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest}
delete-cache-parameter-group-request
  [m14327]
  (clojure.core/let
   [bean14326
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/let
    [v14328
     (:cache-parameter-group-name
      m14327
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14328 :com.palletops.awaze.client-builder/undef)
     (.
      bean14326
      setCacheParameterGroupName
      (clojure.core/str v14328))))
   bean14326))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest}
create-cache-security-group-request
  [m14330]
  (clojure.core/let
   [bean14329
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14331
     (:cache-security-group-name
      m14330
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14331 :com.palletops.awaze.client-builder/undef)
     (. bean14329 setCacheSecurityGroupName (clojure.core/str v14331))))
   (clojure.core/let
    [v14331
     (:description m14330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14331 :com.palletops.awaze.client-builder/undef)
     (. bean14329 setDescription (clojure.core/str v14331))))
   bean14329))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m14333]
  (clojure.core/let
   [bean14332
    (new
     com.amazonaws.services.elasticache.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v14334 (:tags m14333 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14334 :com.palletops.awaze.client-builder/undef)
     (.
      bean14332
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14434] (elasticache/tag arg14434))
 v14334))))
   (clojure.core/let
    [v14334
     (:resource-name m14333 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14334 :com.palletops.awaze.client-builder/undef)
     (. bean14332 setResourceName (clojure.core/str v14334))))
   bean14332))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEventsRequest}
describe-events-request
  [m14336]
  (clojure.core/let
   [bean14335
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/let
    [v14337
     (:marker m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setMarker (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:max-records m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setMaxRecords (clojure.core/int v14337))))
   (clojure.core/let
    [v14337
     (:start-time m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (.
      bean14335
      setStartTime
      (com.palletops.awaze.common/to-date v14337))))
   (clojure.core/let
    [v14337
     (:end-time m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (.
      bean14335
      setEndTime
      (com.palletops.awaze.common/to-date v14337))))
   (clojure.core/let
    [v14337
     (:source-identifier
      m14336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setSourceIdentifier (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:source-type m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setSourceType (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:duration m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setDuration (clojure.core/int v14337))))
   bean14335))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest}
modify-cache-subnet-group-request
  [m14339]
  (clojure.core/let
   [bean14338
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14340
     (:cache-subnet-group-name
      m14339
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14340 :com.palletops.awaze.client-builder/undef)
     (. bean14338 setCacheSubnetGroupName (clojure.core/str v14340))))
   (clojure.core/let
    [v14340
     (:cache-subnet-group-description
      m14339
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14340 :com.palletops.awaze.client-builder/undef)
     (.
      bean14338
      setCacheSubnetGroupDescription
      (clojure.core/str v14340))))
   (clojure.core/let
    [v14340
     (:subnet-ids m14339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14340 :com.palletops.awaze.client-builder/undef)
     (.
      bean14338
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14435] (clojure.core/str arg14435))
 v14340))))
   bean14338))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest}
revoke-cache-security-group-ingress-request
  [m14342]
  (clojure.core/let
   [bean14341
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14343
     (:cache-security-group-name
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setCacheSecurityGroupName (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:ec2security-group-name
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setEC2SecurityGroupName (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:ec2security-group-owner-id
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14343))))
   bean14341))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest}
describe-reserved-cache-nodes-request
  [m14345]
  (clojure.core/let
   [bean14344
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/let
    [v14346
     (:cache-node-type
      m14345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setCacheNodeType (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:reserved-cache-node-id
      m14345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setReservedCacheNodeId (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:reserved-cache-nodes-offering-id
      m14345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (.
      bean14344
      setReservedCacheNodesOfferingId
      (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:marker m14345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setMarker (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:max-records m14345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setMaxRecords (clojure.core/int v14346))))
   (clojure.core/let
    [v14346
     (:product-description
      m14345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setProductDescription (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:offering-type m14345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setOfferingType (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:duration m14345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setDuration (clojure.core/str v14346))))
   bean14344))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RebootCacheClusterRequest}
reboot-cache-cluster-request
  [m14348]
  (clojure.core/let
   [bean14347
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/let
    [v14349
     (:cache-cluster-id
      m14348
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14349 :com.palletops.awaze.client-builder/undef)
     (. bean14347 setCacheClusterId (clojure.core/str v14349))))
   (clojure.core/let
    [v14349
     (:cache-node-ids-to-reboot
      m14348
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14349 :com.palletops.awaze.client-builder/undef)
     (.
      bean14347
      setCacheNodeIdsToReboot
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14436] (clojure.core/str arg14436))
 v14349))))
   bean14347))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest}
describe-cache-clusters-request
  [m14351]
  (clojure.core/let
   [bean14350
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/let
    [v14352
     (:cache-cluster-id
      m14351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setCacheClusterId (clojure.core/str v14352))))
   (clojure.core/let
    [v14352
     (:show-cache-node-info
      m14351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setShowCacheNodeInfo (clojure.core/boolean v14352))))
   (clojure.core/let
    [v14352
     (:marker m14351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setMarker (clojure.core/str v14352))))
   (clojure.core/let
    [v14352
     (:max-records m14351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setMaxRecords (clojure.core/int v14352))))
   bean14350))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CopySnapshotRequest}
copy-snapshot-request
  [m14354]
  (clojure.core/let
   [bean14353
    (new com.amazonaws.services.elasticache.model.CopySnapshotRequest)]
   (clojure.core/let
    [v14355
     (:source-snapshot-name
      m14354
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14355 :com.palletops.awaze.client-builder/undef)
     (. bean14353 setSourceSnapshotName (clojure.core/str v14355))))
   (clojure.core/let
    [v14355
     (:target-snapshot-name
      m14354
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14355 :com.palletops.awaze.client-builder/undef)
     (. bean14353 setTargetSnapshotName (clojure.core/str v14355))))
   bean14353))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m14357]
  (clojure.core/let
   [bean14356
    (new
     com.amazonaws.services.elasticache.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v14358
     (:snapshot-name m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setSnapshotName (clojure.core/str v14358))))
   bean14356))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest}
describe-cache-engine-versions-request
  [m14360]
  (clojure.core/let
   [bean14359
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/let
    [v14361
     (:cache-parameter-group-family
      m14360
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (.
      bean14359
      setCacheParameterGroupFamily
      (clojure.core/str v14361))))
   (clojure.core/let
    [v14361
     (:marker m14360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (. bean14359 setMarker (clojure.core/str v14361))))
   (clojure.core/let
    [v14361
     (:max-records m14360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (. bean14359 setMaxRecords (clojure.core/int v14361))))
   (clojure.core/let
    [v14361
     (:engine m14360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (. bean14359 setEngine (clojure.core/str v14361))))
   (clojure.core/let
    [v14361
     (:engine-version
      m14360
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (. bean14359 setEngineVersion (clojure.core/str v14361))))
   (clojure.core/let
    [v14361
     (:default-only m14360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (. bean14359 setDefaultOnly (clojure.core/boolean v14361))))
   bean14359))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m14363]
  (clojure.core/let
   [bean14362
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/let
    [v14364
     (:cache-parameter-group-family
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setCacheParameterGroupFamily
      (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:marker m14363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setMarker (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:max-records m14363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setMaxRecords (clojure.core/int v14364))))
   bean14362))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest}
delete-replication-group-request
  [m14366]
  (clojure.core/let
   [bean14365
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/let
    [v14367
     (:replication-group-id
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setReplicationGroupId (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:retain-primary-cluster
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (.
      bean14365
      setRetainPrimaryCluster
      (clojure.core/boolean v14367))))
   (clojure.core/let
    [v14367
     (:final-snapshot-identifier
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (.
      bean14365
      setFinalSnapshotIdentifier
      (clojure.core/str v14367))))
   bean14365))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest}
create-cache-subnet-group-request
  [m14369]
  (clojure.core/let
   [bean14368
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14370
     (:cache-subnet-group-name
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setCacheSubnetGroupName (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:cache-subnet-group-description
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setCacheSubnetGroupDescription
      (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:subnet-ids m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14437] (clojure.core/str arg14437))
 v14370))))
   bean14368))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest}
modify-cache-cluster-request
  [m14372]
  (clojure.core/let
   [bean14371
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/let
    [v14373
     (:new-availability-zones
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setNewAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14438] (clojure.core/str arg14438))
 v14373))))
   (clojure.core/let
    [v14373
     (:security-group-ids
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14439] (clojure.core/str arg14439))
 v14373))))
   (clojure.core/let
    [v14373
     (:snapshot-retention-limit
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setSnapshotRetentionLimit (clojure.core/int v14373))))
   (clojure.core/let
    [v14373
     (:apply-immediately
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setApplyImmediately (clojure.core/boolean v14373))))
   (clojure.core/let
    [v14373
     (:preferred-maintenance-window
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setPreferredMaintenanceWindow
      (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:azmode m14372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setAZMode (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:notification-topic-arn
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setNotificationTopicArn (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:cache-security-group-names
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14440] (clojure.core/str arg14440))
 v14373))))
   (clojure.core/let
    [v14373
     (:cache-parameter-group-name
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setCacheParameterGroupName
      (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:cache-cluster-id
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setCacheClusterId (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:notification-topic-status
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setNotificationTopicStatus
      (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:num-cache-nodes
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setNumCacheNodes (clojure.core/int v14373))))
   (clojure.core/let
    [v14373
     (:cache-node-ids-to-remove
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setCacheNodeIdsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14441] (clojure.core/str arg14441))
 v14373))))
   (clojure.core/let
    [v14373
     (:auto-minor-version-upgrade
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14373))))
   (clojure.core/let
    [v14373
     (:snapshot-window
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setSnapshotWindow (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:engine-version
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setEngineVersion (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:cache-node-type
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setCacheNodeType (clojure.core/str v14373))))
   bean14371))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest}
authorize-cache-security-group-ingress-request
  [m14375]
  (clojure.core/let
   [bean14374
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14376
     (:cache-security-group-name
      m14375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14376 :com.palletops.awaze.client-builder/undef)
     (. bean14374 setCacheSecurityGroupName (clojure.core/str v14376))))
   (clojure.core/let
    [v14376
     (:ec2security-group-name
      m14375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14376 :com.palletops.awaze.client-builder/undef)
     (. bean14374 setEC2SecurityGroupName (clojure.core/str v14376))))
   (clojure.core/let
    [v14376
     (:ec2security-group-owner-id
      m14375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14376 :com.palletops.awaze.client-builder/undef)
     (.
      bean14374
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14376))))
   bean14374))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest}
describe-cache-parameters-request
  [m14378]
  (clojure.core/let
   [bean14377
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/let
    [v14379
     (:cache-parameter-group-name
      m14378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (.
      bean14377
      setCacheParameterGroupName
      (clojure.core/str v14379))))
   (clojure.core/let
    [v14379
     (:marker m14378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (. bean14377 setMarker (clojure.core/str v14379))))
   (clojure.core/let
    [v14379
     (:max-records m14378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (. bean14377 setMaxRecords (clojure.core/int v14379))))
   (clojure.core/let
    [v14379
     (:source m14378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (. bean14377 setSource (clojure.core/str v14379))))
   bean14377))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest}
delete-cache-cluster-request
  [m14381]
  (clojure.core/let
   [bean14380
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/let
    [v14382
     (:cache-cluster-id
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setCacheClusterId (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:final-snapshot-identifier
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setFinalSnapshotIdentifier
      (clojure.core/str v14382))))
   bean14380))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest}
list-allowed-node-type-modifications-request
  [m14384]
  (clojure.core/let
   [bean14383
    (new
     com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest)]
   (clojure.core/let
    [v14385
     (:cache-cluster-id
      m14384
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setCacheClusterId (clojure.core/str v14385))))
   (clojure.core/let
    [v14385
     (:replication-group-id
      m14384
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setReplicationGroupId (clojure.core/str v14385))))
   bean14383))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest}
create-cache-parameter-group-request
  [m14387]
  (clojure.core/let
   [bean14386
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/let
    [v14388
     (:cache-parameter-group-name
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (.
      bean14386
      setCacheParameterGroupName
      (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:cache-parameter-group-family
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (.
      bean14386
      setCacheParameterGroupFamily
      (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:description m14387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setDescription (clojure.core/str v14388))))
   bean14386))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest}
modify-replication-group-request
  [m14390]
  (clojure.core/let
   [bean14389
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/let
    [v14391
     (:snapshotting-cluster-id
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setSnapshottingClusterId (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:replication-group-description
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setReplicationGroupDescription
      (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:replication-group-id
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setReplicationGroupId (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:security-group-ids
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14442] (clojure.core/str arg14442))
 v14391))))
   (clojure.core/let
    [v14391
     (:snapshot-retention-limit
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setSnapshotRetentionLimit (clojure.core/int v14391))))
   (clojure.core/let
    [v14391
     (:apply-immediately
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setApplyImmediately (clojure.core/boolean v14391))))
   (clojure.core/let
    [v14391
     (:primary-cluster-id
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setPrimaryClusterId (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:preferred-maintenance-window
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setPreferredMaintenanceWindow
      (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:notification-topic-arn
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setNotificationTopicArn (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:cache-security-group-names
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14443] (clojure.core/str arg14443))
 v14391))))
   (clojure.core/let
    [v14391
     (:cache-parameter-group-name
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setCacheParameterGroupName
      (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:notification-topic-status
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setNotificationTopicStatus
      (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:auto-minor-version-upgrade
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14391))))
   (clojure.core/let
    [v14391
     (:automatic-failover-enabled
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14391))))
   (clojure.core/let
    [v14391
     (:snapshot-window
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setSnapshotWindow (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:engine-version
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setEngineVersion (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:cache-node-type
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setCacheNodeType (clojure.core/str v14391))))
   bean14389))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m14393]
  (clojure.core/let
   [bean14392
    (new
     com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v14394
     (:resource-name m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setResourceName (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:tag-keys m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14444] (clojure.core/str arg14444))
 v14394))))
   bean14392))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest}
describe-reserved-cache-nodes-offerings-request
  [m14396]
  (clojure.core/let
   [bean14395
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/let
    [v14397
     (:cache-node-type
      m14396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setCacheNodeType (clojure.core/str v14397))))
   (clojure.core/let
    [v14397
     (:reserved-cache-nodes-offering-id
      m14396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (.
      bean14395
      setReservedCacheNodesOfferingId
      (clojure.core/str v14397))))
   (clojure.core/let
    [v14397
     (:marker m14396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setMarker (clojure.core/str v14397))))
   (clojure.core/let
    [v14397
     (:max-records m14396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setMaxRecords (clojure.core/int v14397))))
   (clojure.core/let
    [v14397
     (:product-description
      m14396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setProductDescription (clojure.core/str v14397))))
   (clojure.core/let
    [v14397
     (:offering-type m14396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setOfferingType (clojure.core/str v14397))))
   (clojure.core/let
    [v14397
     (:duration m14396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setDuration (clojure.core/str v14397))))
   bean14395))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest}
describe-cache-security-groups-request
  [m14399]
  (clojure.core/let
   [bean14398
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/let
    [v14400
     (:cache-security-group-name
      m14399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setCacheSecurityGroupName (clojure.core/str v14400))))
   (clojure.core/let
    [v14400
     (:marker m14399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setMarker (clojure.core/str v14400))))
   (clojure.core/let
    [v14400
     (:max-records m14399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setMaxRecords (clojure.core/int v14400))))
   bean14398))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest}
create-replication-group-request
  [m14402]
  (clojure.core/let
   [bean14401
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/let
    [v14403
     (:preferred-cache-cluster-azs
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setPreferredCacheClusterAZs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14485] (clojure.core/str arg14485))
 v14403))))
   (clojure.core/let
    [v14403
     (:engine m14402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setEngine (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:replication-group-description
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setReplicationGroupDescription
      (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:cache-subnet-group-name
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setCacheSubnetGroupName (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:replication-group-id
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setReplicationGroupId (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:security-group-ids
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14486] (clojure.core/str arg14486))
 v14403))))
   (clojure.core/let
    [v14403
     (:snapshot-retention-limit
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setSnapshotRetentionLimit (clojure.core/int v14403))))
   (clojure.core/let
    [v14403
     (:primary-cluster-id
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setPrimaryClusterId (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:preferred-maintenance-window
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setPreferredMaintenanceWindow
      (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:notification-topic-arn
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setNotificationTopicArn (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:cache-security-group-names
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14487] (clojure.core/str arg14487))
 v14403))))
   (clojure.core/let
    [v14403
     (:snapshot-name m14402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setSnapshotName (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:snapshot-arns m14402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14488] (clojure.core/str arg14488))
 v14403))))
   (clojure.core/let
    [v14403 (:port m14402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setPort (clojure.core/int v14403))))
   (clojure.core/let
    [v14403 (:tags m14402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14489] (elasticache/tag arg14489))
 v14403))))
   (clojure.core/let
    [v14403
     (:cache-parameter-group-name
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setCacheParameterGroupName
      (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:auto-minor-version-upgrade
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14403))))
   (clojure.core/let
    [v14403
     (:automatic-failover-enabled
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14403))))
   (clojure.core/let
    [v14403
     (:snapshot-window
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setSnapshotWindow (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:engine-version
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setEngineVersion (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:num-cache-clusters
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setNumCacheClusters (clojure.core/int v14403))))
   (clojure.core/let
    [v14403
     (:cache-node-type
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setCacheNodeType (clojure.core/str v14403))))
   bean14401))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m14405]
  (clojure.core/let
   [bean14404
    (new
     com.amazonaws.services.elasticache.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v14406
     (:resource-name m14405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14406 :com.palletops.awaze.client-builder/undef)
     (. bean14404 setResourceName (clojure.core/str v14406))))
   bean14404))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest}
reset-cache-parameter-group-request
  [m14408]
  (clojure.core/let
   [bean14407
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/let
    [v14409
     (:cache-parameter-group-name
      m14408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (.
      bean14407
      setCacheParameterGroupName
      (clojure.core/str v14409))))
   (clojure.core/let
    [v14409
     (:parameter-name-values
      m14408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (.
      bean14407
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14490]
  (elasticache/parameter-name-value arg14490))
 v14409))))
   (clojure.core/let
    [v14409
     (:reset-all-parameters
      m14408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setResetAllParameters (clojure.core/boolean v14409))))
   bean14407))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m14411]
  (clojure.core/let
   [bean14410
    (new
     com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v14412
     (:cache-cluster-id
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setCacheClusterId (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:snapshot-name m14411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setSnapshotName (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:snapshot-source
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setSnapshotSource (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:marker m14411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setMarker (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:max-records m14411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setMaxRecords (clojure.core/int v14412))))
   bean14410))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest}
delete-cache-subnet-group-request
  [m14414]
  (clojure.core/let
   [bean14413
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14415
     (:cache-subnet-group-name
      m14414
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14415 :com.palletops.awaze.client-builder/undef)
     (. bean14413 setCacheSubnetGroupName (clojure.core/str v14415))))
   bean14413))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateSnapshotRequest}
create-snapshot-request
  [m14417]
  (clojure.core/let
   [bean14416
    (new
     com.amazonaws.services.elasticache.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v14418
     (:cache-cluster-id
      m14417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setCacheClusterId (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:snapshot-name m14417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setSnapshotName (clojure.core/str v14418))))
   bean14416))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest}
purchase-reserved-cache-nodes-offering-request
  [m14420]
  (clojure.core/let
   [bean14419
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/let
    [v14421
     (:reserved-cache-node-id
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setReservedCacheNodeId (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:reserved-cache-nodes-offering-id
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (.
      bean14419
      setReservedCacheNodesOfferingId
      (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:cache-node-count
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setCacheNodeCount (clojure.core/int v14421))))
   bean14419))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest}
delete-cache-security-group-request
  [m14423]
  (clojure.core/let
   [bean14422
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14424
     (:cache-security-group-name
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setCacheSecurityGroupName (clojure.core/str v14424))))
   bean14422))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest}
describe-cache-subnet-groups-request
  [m14426]
  (clojure.core/let
   [bean14425
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/let
    [v14427
     (:cache-subnet-group-name
      m14426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14427 :com.palletops.awaze.client-builder/undef)
     (. bean14425 setCacheSubnetGroupName (clojure.core/str v14427))))
   (clojure.core/let
    [v14427
     (:marker m14426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14427 :com.palletops.awaze.client-builder/undef)
     (. bean14425 setMarker (clojure.core/str v14427))))
   (clojure.core/let
    [v14427
     (:max-records m14426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14427 :com.palletops.awaze.client-builder/undef)
     (. bean14425 setMaxRecords (clojure.core/int v14427))))
   bean14425))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m14445]
   (clojure.core/let
    [credentials14446 (:credentials m14445) args14447 (:args m14445)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14448
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14446)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14448
       modifyCacheParameterGroup
       (elasticache/modify-cache-parameter-group-request
        (clojure.core/nth args14447 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials14450 & args14451]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14452
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14450)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14452
      modifyCacheParameterGroup
      (elasticache/modify-cache-parameter-group-request
       (clojure.core/nth args14451 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m14453]
   (clojure.core/let
    [credentials14454 (:credentials m14453) args14455 (:args m14453)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14456
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14454)]
     (clojure.core/case
      (clojure.core/count args14455)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14456
        describeReplicationGroups
        (elasticache/describe-replication-groups-request
         (clojure.core/nth args14455 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14456
        describeReplicationGroups))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-replication-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-replication-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials14458 & args14459]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14460
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14458)]
    (clojure.core/case
     (clojure.core/count args14459)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14460
       describeReplicationGroups
       (elasticache/describe-replication-groups-request
        (clojure.core/nth args14459 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14460
       describeReplicationGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m14461]
   (clojure.core/let
    [credentials14462 (:credentials m14461) args14463 (:args m14461)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14464
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14462)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14464
       createCacheCluster
       (elasticache/create-cache-cluster-request
        (clojure.core/nth args14463 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createCacheCluster"}
   [credentials14466 & args14467]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14468
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14466)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14468
      createCacheCluster
      (elasticache/create-cache-cluster-request
       (clojure.core/nth args14467 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m14469]
   (clojure.core/let
    [credentials14470 (:credentials m14469) args14471 (:args m14469)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14472
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14470)]
     (clojure.core/case
      (clojure.core/count args14471)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14472
        describeCacheParameterGroups
        (elasticache/describe-cache-parameter-groups-request
         (clojure.core/nth args14471 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14472
        describeCacheParameterGroups))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials14474 & args14475]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14476
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14474)]
    (clojure.core/case
     (clojure.core/count args14475)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14476
       describeCacheParameterGroups
       (elasticache/describe-cache-parameter-groups-request
        (clojure.core/nth args14475 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14476
       describeCacheParameterGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m14477]
   (clojure.core/let
    [credentials14478 (:credentials m14477) args14479 (:args m14477)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14480
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14478)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14480
       deleteCacheParameterGroup
       (elasticache/delete-cache-parameter-group-request
        (clojure.core/nth args14479 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials14482 & args14483]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14484
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14482)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14484
      deleteCacheParameterGroup
      (elasticache/delete-cache-parameter-group-request
       (clojure.core/nth args14483 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m14491]
   (clojure.core/let
    [credentials14492 (:credentials m14491) args14493 (:args m14491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14494
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14494
       createCacheSecurityGroup
       (elasticache/create-cache-security-group-request
        (clojure.core/nth args14493 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-security-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials14496 & args14497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14498
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14498
      createCacheSecurityGroup
      (elasticache/create-cache-security-group-request
       (clojure.core/nth args14497 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :add-tags-to-resource
   [m14499]
   (clojure.core/let
    [credentials14500 (:credentials m14499) args14501 (:args m14499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14502
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14500)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14502
       addTagsToResource
       (elasticache/add-tags-to-resource-request
        (clojure.core/nth args14501 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials14504 & args14505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14506
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14504)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14506
      addTagsToResource
      (elasticache/add-tags-to-resource-request
       (clojure.core/nth args14505 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m14507]
   (clojure.core/let
    [credentials14508 (:credentials m14507) args14509 (:args m14507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14510
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14508)]
     (clojure.core/case
      (clojure.core/count args14509)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14510
        describeEvents
        (elasticache/describe-events-request
         (clojure.core/nth args14509 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14510
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials14512 & args14513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14514
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14512)]
    (clojure.core/case
     (clojure.core/count args14513)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14514
       describeEvents
       (elasticache/describe-events-request
        (clojure.core/nth args14513 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14514
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m14515]
   (clojure.core/let
    [credentials14516 (:credentials m14515) args14517 (:args m14515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14518
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14516)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14518
       modifyCacheSubnetGroup
       (elasticache/modify-cache-subnet-group-request
        (clojure.core/nth args14517 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials14520 & args14521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14522
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14520)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14522
      modifyCacheSubnetGroup
      (elasticache/modify-cache-subnet-group-request
       (clojure.core/nth args14521 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m14523]
   (clojure.core/let
    [credentials14524 (:credentials m14523) args14525 (:args m14523)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14526
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14524)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14526
       revokeCacheSecurityGroupIngress
       (elasticache/revoke-cache-security-group-ingress-request
        (clojure.core/nth args14525 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials14528 & args14529]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14530
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14528)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14530
      revokeCacheSecurityGroupIngress
      (elasticache/revoke-cache-security-group-ingress-request
       (clojure.core/nth args14529 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m14531]
   (clojure.core/let
    [credentials14532 (:credentials m14531) args14533 (:args m14531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14534
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14532)]
     (clojure.core/case
      (clojure.core/count args14533)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14534
        describeReservedCacheNodes
        (elasticache/describe-reserved-cache-nodes-request
         (clojure.core/nth args14533 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14534
        describeReservedCacheNodes))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials14536 & args14537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14538
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14536)]
    (clojure.core/case
     (clojure.core/count args14537)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14538
       describeReservedCacheNodes
       (elasticache/describe-reserved-cache-nodes-request
        (clojure.core/nth args14537 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14538
       describeReservedCacheNodes))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m14539]
   (clojure.core/let
    [credentials14540 (:credentials m14539) args14541 (:args m14539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14542
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14540)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14542
       rebootCacheCluster
       (elasticache/reboot-cache-cluster-request
        (clojure.core/nth args14541 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials14544 & args14545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14546
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14544)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14546
      rebootCacheCluster
      (elasticache/reboot-cache-cluster-request
       (clojure.core/nth args14545 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m14547]
   (clojure.core/let
    [credentials14548 (:credentials m14547) args14549 (:args m14547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14550
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14548)]
     (clojure.core/case
      (clojure.core/count args14549)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14550
        describeCacheClusters
        (elasticache/describe-cache-clusters-request
         (clojure.core/nth args14549 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14550
        describeCacheClusters))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials14552 & args14553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14554
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14552)]
    (clojure.core/case
     (clojure.core/count args14553)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14554
       describeCacheClusters
       (elasticache/describe-cache-clusters-request
        (clojure.core/nth args14553 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14554
       describeCacheClusters))))))
 (do
  (clojure.core/defmethod
   elasticache
   :copy-snapshot
   [m14555]
   (clojure.core/let
    [credentials14556 (:credentials m14555) args14557 (:args m14555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14558
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14556)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14558
       copySnapshot
       (elasticache/copy-snapshot-request
        (clojure.core/nth args14557 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Call copySnapshot"}
   [credentials14560 & args14561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14562
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14560)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14562
      copySnapshot
      (elasticache/copy-snapshot-request
       (clojure.core/nth args14561 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-snapshot
   [m14563]
   (clojure.core/let
    [credentials14564 (:credentials m14563) args14565 (:args m14563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14566
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14566
       deleteSnapshot
       (elasticache/delete-snapshot-request
        (clojure.core/nth args14565 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials14568 & args14569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14570
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14570
      deleteSnapshot
      (elasticache/delete-snapshot-request
       (clojure.core/nth args14569 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m14571]
   (clojure.core/let
    [credentials14572 (:credentials m14571) args14573 (:args m14571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14574
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14572)]
     (clojure.core/case
      (clojure.core/count args14573)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14574
        describeCacheEngineVersions
        (elasticache/describe-cache-engine-versions-request
         (clojure.core/nth args14573 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14574
        describeCacheEngineVersions))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]
                [credentials]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]
                [credentials]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials14576 & args14577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14578
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14576)]
    (clojure.core/case
     (clojure.core/count args14577)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14578
       describeCacheEngineVersions
       (elasticache/describe-cache-engine-versions-request
        (clojure.core/nth args14577 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14578
       describeCacheEngineVersions))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m14579]
   (clojure.core/let
    [credentials14580 (:credentials m14579) args14581 (:args m14579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14582
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14582
       describeEngineDefaultParameters
       (elasticache/describe-engine-default-parameters-request
        (clojure.core/nth args14581 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-engine-default-parameters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials14584 & args14585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14586
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14586
      describeEngineDefaultParameters
      (elasticache/describe-engine-default-parameters-request
       (clojure.core/nth args14585 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m14587]
   (clojure.core/let
    [credentials14588 (:credentials m14587) args14589 (:args m14587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14590
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14588)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14590
       deleteReplicationGroup
       (elasticache/delete-replication-group-request
        (clojure.core/nth args14589 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials14592 & args14593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14594
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14592)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14594
      deleteReplicationGroup
      (elasticache/delete-replication-group-request
       (clojure.core/nth args14593 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m14595]
   (clojure.core/let
    [credentials14596 (:credentials m14595) args14597 (:args m14595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14598
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14596)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14598
       createCacheSubnetGroup
       (elasticache/create-cache-subnet-group-request
        (clojure.core/nth args14597 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials14600 & args14601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14602
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14600)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14602
      createCacheSubnetGroup
      (elasticache/create-cache-subnet-group-request
       (clojure.core/nth args14601 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m14603]
   (clojure.core/let
    [credentials14604 (:credentials m14603) args14605 (:args m14603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14606
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14606
       modifyCacheCluster
       (elasticache/modify-cache-cluster-request
        (clojure.core/nth args14605 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials14608 & args14609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14610
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14610
      modifyCacheCluster
      (elasticache/modify-cache-cluster-request
       (clojure.core/nth args14609 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m14611]
   (clojure.core/let
    [credentials14612 (:credentials m14611) args14613 (:args m14611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14614
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14614
       authorizeCacheSecurityGroupIngress
       (elasticache/authorize-cache-security-group-ingress-request
        (clojure.core/nth args14613 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials14616 & args14617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14618
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14618
      authorizeCacheSecurityGroupIngress
      (elasticache/authorize-cache-security-group-ingress-request
       (clojure.core/nth args14617 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m14619]
   (clojure.core/let
    [credentials14620 (:credentials m14619) args14621 (:args m14619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14622
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14620)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14622
       describeCacheParameters
       (elasticache/describe-cache-parameters-request
        (clojure.core/nth args14621 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-parameters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call describeCacheParameters"}
   [credentials14624 & args14625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14626
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14624)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14626
      describeCacheParameters
      (elasticache/describe-cache-parameters-request
       (clojure.core/nth args14625 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m14627]
   (clojure.core/let
    [credentials14628 (:credentials m14627) args14629 (:args m14627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14630
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14628)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14630
       deleteCacheCluster
       (elasticache/delete-cache-cluster-request
        (clojure.core/nth args14629 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials14632 & args14633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14634
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14632)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14634
      deleteCacheCluster
      (elasticache/delete-cache-cluster-request
       (clojure.core/nth args14633 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-allowed-node-type-modifications
   [m14635]
   (clojure.core/let
    [credentials14636 (:credentials m14635) args14637 (:args m14635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14638
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14636)]
     (clojure.core/case
      (clojure.core/count args14637)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14638
        listAllowedNodeTypeModifications
        (elasticache/list-allowed-node-type-modifications-request
         (clojure.core/nth args14637 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14638
        listAllowedNodeTypeModifications))))))
  (clojure.core/defn
   list-allowed-node-type-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-allowed-node-type-modifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   [credentials14640 & args14641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14642
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14640)]
    (clojure.core/case
     (clojure.core/count args14641)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14642
       listAllowedNodeTypeModifications
       (elasticache/list-allowed-node-type-modifications-request
        (clojure.core/nth args14641 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14642
       listAllowedNodeTypeModifications))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m14643]
   (clojure.core/let
    [credentials14644 (:credentials m14643) args14645 (:args m14643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14646
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14646
       createCacheParameterGroup
       (elasticache/create-cache-parameter-group-request
        (clojure.core/nth args14645 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials14648 & args14649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14650
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14650
      createCacheParameterGroup
      (elasticache/create-cache-parameter-group-request
       (clojure.core/nth args14649 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m14651]
   (clojure.core/let
    [credentials14652 (:credentials m14651) args14653 (:args m14651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14654
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14652)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14654
       modifyReplicationGroup
       (elasticache/modify-replication-group-request
        (clojure.core/nth args14653 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials14656 & args14657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14658
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14656)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14658
      modifyReplicationGroup
      (elasticache/modify-replication-group-request
       (clojure.core/nth args14657 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :remove-tags-from-resource
   [m14659]
   (clojure.core/let
    [credentials14660 (:credentials m14659) args14661 (:args m14659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14662
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14660)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14662
       removeTagsFromResource
       (elasticache/remove-tags-from-resource-request
        (clojure.core/nth args14661 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials14664 & args14665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14666
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14664)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14666
      removeTagsFromResource
      (elasticache/remove-tags-from-resource-request
       (clojure.core/nth args14665 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m14667]
   (clojure.core/let
    [credentials14668 (:credentials m14667) args14669 (:args m14667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14670
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14668)]
     (clojure.core/case
      (clojure.core/count args14669)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14670
        describeReservedCacheNodesOfferings
        (elasticache/describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args14669 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14670
        describeReservedCacheNodesOfferings))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials14672 & args14673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14674
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14672)]
    (clojure.core/case
     (clojure.core/count args14673)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14674
       describeReservedCacheNodesOfferings
       (elasticache/describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args14673 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14674
       describeReservedCacheNodesOfferings))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m14675]
   (clojure.core/let
    [credentials14676 (:credentials m14675) args14677 (:args m14675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14678
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14676)]
     (clojure.core/case
      (clojure.core/count args14677)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14678
        describeCacheSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14678
        describeCacheSecurityGroups
        (elasticache/describe-cache-security-groups-request
         (clojure.core/nth args14677 0))))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-security-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-security-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials14680 & args14681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14682
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14680)]
    (clojure.core/case
     (clojure.core/count args14681)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14682
       describeCacheSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14682
       describeCacheSecurityGroups
       (elasticache/describe-cache-security-groups-request
        (clojure.core/nth args14681 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m14683]
   (clojure.core/let
    [credentials14684 (:credentials m14683) args14685 (:args m14683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14686
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14686
       createReplicationGroup
       (elasticache/create-replication-group-request
        (clojure.core/nth args14685 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createReplicationGroup"}
   [credentials14688 & args14689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14690
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14690
      createReplicationGroup
      (elasticache/create-replication-group-request
       (clojure.core/nth args14689 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-tags-for-resource
   [m14691]
   (clojure.core/let
    [credentials14692 (:credentials m14691) args14693 (:args m14691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14694
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14694
       listTagsForResource
       (elasticache/list-tags-for-resource-request
        (clojure.core/nth args14693 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials14696 & args14697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14698
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14698
      listTagsForResource
      (elasticache/list-tags-for-resource-request
       (clojure.core/nth args14697 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m14699]
   (clojure.core/let
    [credentials14700 (:credentials m14699) args14701 (:args m14699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14702
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14702
       resetCacheParameterGroup
       (elasticache/reset-cache-parameter-group-request
        (clojure.core/nth args14701 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials14704 & args14705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14706
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14706
      resetCacheParameterGroup
      (elasticache/reset-cache-parameter-group-request
       (clojure.core/nth args14705 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-snapshots
   [m14707]
   (clojure.core/let
    [credentials14708 (:credentials m14707) args14709 (:args m14707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14710
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14708)]
     (clojure.core/case
      (clojure.core/count args14709)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14710
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14710
        describeSnapshots
        (elasticache/describe-snapshots-request
         (clojure.core/nth args14709 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials14712 & args14713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14714
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14712)]
    (clojure.core/case
     (clojure.core/count args14713)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14714
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14714
       describeSnapshots
       (elasticache/describe-snapshots-request
        (clojure.core/nth args14713 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m14715]
   (clojure.core/let
    [credentials14716 (:credentials m14715) args14717 (:args m14715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14718
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14716)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14718
       deleteCacheSubnetGroup
       (elasticache/delete-cache-subnet-group-request
        (clojure.core/nth args14717 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials14720 & args14721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14722
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14720)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14722
      deleteCacheSubnetGroup
      (elasticache/delete-cache-subnet-group-request
       (clojure.core/nth args14721 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-snapshot
   [m14723]
   (clojure.core/let
    [credentials14724 (:credentials m14723) args14725 (:args m14723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14726
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14726
       createSnapshot
       (elasticache/create-snapshot-request
        (clojure.core/nth args14725 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials14728 & args14729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14730
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14730
      createSnapshot
      (elasticache/create-snapshot-request
       (clojure.core/nth args14729 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m14731]
   (clojure.core/let
    [credentials14732 (:credentials m14731) args14733 (:args m14731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14734
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14734
       purchaseReservedCacheNodesOffering
       (elasticache/purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args14733 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials14736 & args14737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14738
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14738
      purchaseReservedCacheNodesOffering
      (elasticache/purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args14737 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m14739]
   (clojure.core/let
    [credentials14740 (:credentials m14739) args14741 (:args m14739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14742
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14740)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14742
       deleteCacheSecurityGroup
       (elasticache/delete-cache-security-group-request
        (clojure.core/nth args14741 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-security-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials14744 & args14745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14746
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14744)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14746
      deleteCacheSecurityGroup
      (elasticache/delete-cache-security-group-request
       (clojure.core/nth args14745 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m14747]
   (clojure.core/let
    [credentials14748 (:credentials m14747) args14749 (:args m14747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14750
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14748)]
     (clojure.core/case
      (clojure.core/count args14749)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14750
        describeCacheSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14750
        describeCacheSubnetGroups
        (elasticache/describe-cache-subnet-groups-request
         (clojure.core/nth args14749 0))))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials14752 & args14753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14754
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14752)]
    (clojure.core/case
     (clojure.core/count args14753)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14754
       describeCacheSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14754
       describeCacheSubnetGroups
       (elasticache/describe-cache-subnet-groups-request
        (clojure.core/nth args14753 0)))))))))
