(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.ec2 :as ec2]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsBlockDevice}
ebs-block-device
  [m1947]
  (clojure.core/let
   [bean1946 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/let
    [v1948
     (:encrypted m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setEncrypted (clojure.core/boolean v1948))))
   (clojure.core/let
    [v1948
     (:snapshot-id m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setSnapshotId (clojure.core/str v1948))))
   (clojure.core/let
    [v1948
     (:volume-type m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setVolumeType (clojure.core/str v1948))))
   (clojure.core/let
    [v1948 (:iops m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setIops (clojure.core/int v1948))))
   (clojure.core/let
    [v1948
     (:delete-on-termination
      m1947
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setDeleteOnTermination (clojure.core/boolean v1948))))
   (clojure.core/let
    [v1948
     (:volume-size m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setVolumeSize (clojure.core/int v1948))))
   bean1946))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrivateIpAddressSpecification}
private-ip-address-specification
  [m1950]
  (clojure.core/let
   [bean1949
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/let
    [v1951
     (:private-ip-address
      m1950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setPrivateIpAddress (clojure.core/str v1951))))
   (clojure.core/let
    [v1951 (:primary m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setPrimary (clojure.core/boolean v1951))))
   bean1949))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageFormat}
disk-image-format
  [m1953]
  (.
   com.amazonaws.services.ec2.model.DiskImageFormat
   fromValue
   (clojure.core/name m1953)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IamInstanceProfileSpecification}
iam-instance-profile-specification
  [m1956]
  (clojure.core/let
   [bean1955
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/let
    [v1957 (:arn m1956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1957 :com.palletops.awaze.client-builder/undef)
     (. bean1955 setArn (clojure.core/str v1957))))
   (clojure.core/let
    [v1957 (:name m1956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1957 :com.palletops.awaze.client-builder/undef)
     (. bean1955 setName (clojure.core/str v1957))))
   bean1955))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotPlacement}
spot-placement
  [m1959]
  (clojure.core/let
   [bean1958 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/let
    [v1960
     (:availability-zone
      m1959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1960 :com.palletops.awaze.client-builder/undef)
     (. bean1958 setAvailabilityZone (clojure.core/str v1960))))
   (clojure.core/let
    [v1960
     (:group-name m1959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1960 :com.palletops.awaze.client-builder/undef)
     (. bean1958 setGroupName (clojure.core/str v1960))))
   bean1958))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceType}
instance-type
  [m1962]
  (.
   com.amazonaws.services.ec2.model.InstanceType
   fromValue
   (clojure.core/name m1962)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetMonitoring}
spot-fleet-monitoring
  [m1965]
  (clojure.core/let
   [bean1964
    (new com.amazonaws.services.ec2.model.SpotFleetMonitoring)]
   (clojure.core/let
    [v1966 (:enabled m1965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1966 :com.palletops.awaze.client-builder/undef)
     (. bean1964 setEnabled (clojure.core/boolean v1966))))
   bean1964))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GroupIdentifier}
group-identifier
  [m1968]
  (clojure.core/let
   [bean1967 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/let
    [v1969
     (:group-id m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setGroupId (clojure.core/str v1969))))
   (clojure.core/let
    [v1969
     (:group-name m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setGroupName (clojure.core/str v1969))))
   bean1967))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BlockDeviceMapping}
block-device-mapping
  [m1971]
  (clojure.core/let
   [bean1970
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/let
    [v1972
     (:device-name m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setDeviceName (clojure.core/str v1972))))
   (clojure.core/let
    [v1972
     (:virtual-name m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setVirtualName (clojure.core/str v1972))))
   (clojure.core/let
    [v1972 (:ebs m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setEbs (ec2/ebs-block-device v1972))))
   (clojure.core/let
    [v1972
     (:no-device m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setNoDevice (clojure.core/str v1972))))
   bean1970))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification}
instance-network-interface-specification
  [m1974]
  (clojure.core/let
   [bean1973
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/let
    [v1975
     (:description m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setDescription (clojure.core/str v1975))))
   (clojure.core/let
    [v1975
     (:subnet-id m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setSubnetId (clojure.core/str v1975))))
   (clojure.core/let
    [v1975
     (:secondary-private-ip-address-count
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (.
      bean1973
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v1975))))
   (clojure.core/let
    [v1975
     (:device-index m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setDeviceIndex (clojure.core/int v1975))))
   (clojure.core/let
    [v1975
     (:private-ip-address
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setPrivateIpAddress (clojure.core/str v1975))))
   (clojure.core/let
    [v1975 (:groups m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (.
      bean1973
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2765] (clojure.core/str arg2765))
 v1975))))
   (clojure.core/let
    [v1975
     (:network-interface-id
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setNetworkInterfaceId (clojure.core/str v1975))))
   (clojure.core/let
    [v1975
     (:associate-public-ip-address
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (.
      bean1973
      setAssociatePublicIpAddress
      (clojure.core/boolean v1975))))
   (clojure.core/let
    [v1975
     (:private-ip-addresses
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (.
      bean1973
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2766]
  (ec2/private-ip-address-specification arg2766))
 v1975))))
   (clojure.core/let
    [v1975
     (:delete-on-termination
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setDeleteOnTermination (clojure.core/boolean v1975))))
   bean1973))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesEbs}
scheduled-instances-ebs
  [m1977]
  (clojure.core/let
   [bean1976
    (new com.amazonaws.services.ec2.model.ScheduledInstancesEbs)]
   (clojure.core/let
    [v1978
     (:encrypted m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setEncrypted (clojure.core/boolean v1978))))
   (clojure.core/let
    [v1978
     (:snapshot-id m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setSnapshotId (clojure.core/str v1978))))
   (clojure.core/let
    [v1978
     (:volume-type m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setVolumeType (clojure.core/str v1978))))
   (clojure.core/let
    [v1978 (:iops m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setIops (clojure.core/int v1978))))
   (clojure.core/let
    [v1978
     (:delete-on-termination
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setDeleteOnTermination (clojure.core/boolean v1978))))
   (clojure.core/let
    [v1978
     (:volume-size m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setVolumeSize (clojure.core/int v1978))))
   bean1976))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig}
scheduled-instances-private-ip-address-config
  [m1980]
  (clojure.core/let
   [bean1979
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig)]
   (clojure.core/let
    [v1981
     (:private-ip-address
      m1980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setPrivateIpAddress (clojure.core/str v1981))))
   (clojure.core/let
    [v1981 (:primary m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setPrimary (clojure.core/boolean v1981))))
   bean1979))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrefixListId}
prefix-list-id
  [m1983]
  (clojure.core/let
   [bean1982 (new com.amazonaws.services.ec2.model.PrefixListId)]
   (clojure.core/let
    [v1984
     (:prefix-list-id m1983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setPrefixListId (clojure.core/str v1984))))
   bean1982))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserIdGroupPair}
user-id-group-pair
  [m1986]
  (clojure.core/let
   [bean1985 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/let
    [v1987
     (:group-id m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setGroupId (clojure.core/str v1987))))
   (clojure.core/let
    [v1987 (:vpc-id m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setVpcId (clojure.core/str v1987))))
   (clojure.core/let
    [v1987
     (:vpc-peering-connection-id
      m1986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setVpcPeeringConnectionId (clojure.core/str v1987))))
   (clojure.core/let
    [v1987
     (:group-name m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setGroupName (clojure.core/str v1987))))
   (clojure.core/let
    [v1987 (:user-id m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setUserId (clojure.core/str v1987))))
   (clojure.core/let
    [v1987
     (:peering-status m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setPeeringStatus (clojure.core/str v1987))))
   bean1985))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification}
ebs-instance-block-device-specification
  [m1989]
  (clojure.core/let
   [bean1988
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/let
    [v1990
     (:volume-id m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setVolumeId (clojure.core/str v1990))))
   (clojure.core/let
    [v1990
     (:delete-on-termination
      m1989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setDeleteOnTermination (clojure.core/boolean v1990))))
   bean1988))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Placement}
placement
  [m1992]
  (clojure.core/let
   [bean1991 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/let
    [v1993 (:tenancy m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setTenancy (clojure.core/str v1993))))
   (clojure.core/let
    [v1993
     (:affinity m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setAffinity (clojure.core/str v1993))))
   (clojure.core/let
    [v1993 (:host-id m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setHostId (clojure.core/str v1993))))
   (clojure.core/let
    [v1993
     (:availability-zone
      m1992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setAvailabilityZone (clojure.core/str v1993))))
   (clojure.core/let
    [v1993
     (:group-name m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setGroupName (clojure.core/str v1993))))
   bean1991))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ShutdownBehavior}
shutdown-behavior
  [m1995]
  (.
   com.amazonaws.services.ec2.model.ShutdownBehavior
   fromValue
   (clojure.core/name m1995)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ArchitectureValues}
architecture-values
  [m1998]
  (.
   com.amazonaws.services.ec2.model.ArchitectureValues
   fromValue
   (clojure.core/name m1998)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserData}
user-data
  [m2001]
  (clojure.core/let
   [bean2000 (new com.amazonaws.services.ec2.model.UserData)]
   (clojure.core/let
    [v2002 (:data m2001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2002 :com.palletops.awaze.client-builder/undef)
     (. bean2000 setData (clojure.core/str v2002))))
   bean2000))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageDetail}
disk-image-detail
  [m2004]
  (clojure.core/let
   [bean2003 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/let
    [v2005 (:format m2004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setFormat (ec2/disk-image-format v2005))))
   (clojure.core/let
    [v2005 (:bytes m2004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setBytes (clojure.core/long v2005))))
   (clojure.core/let
    [v2005
     (:import-manifest-url
      m2004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setImportManifestUrl (clojure.core/str v2005))))
   bean2003))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeDetail}
volume-detail
  [m2007]
  (clojure.core/let
   [bean2006 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/let
    [v2008 (:size m2007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2008 :com.palletops.awaze.client-builder/undef)
     (. bean2006 setSize (clojure.core/long v2008))))
   bean2006))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermission}
create-volume-permission
  [m2010]
  (clojure.core/let
   [bean2009
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/let
    [v2011 (:group m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setGroup (clojure.core/str v2011))))
   (clojure.core/let
    [v2011 (:user-id m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setUserId (clojure.core/str v2011))))
   bean2009))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification}
spot-fleet-launch-specification
  [m2013]
  (clojure.core/let
   [bean2012
    (new
     com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification)]
   (clojure.core/let
    [v2014
     (:spot-price m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setSpotPrice (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:iam-instance-profile
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (.
      bean2012
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2014))))
   (clojure.core/let
    [v2014
     (:subnet-id m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setSubnetId (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:placement m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setPlacement (ec2/spot-placement v2014))))
   (clojure.core/let
    [v2014
     (:addressing-type
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setAddressingType (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:instance-type m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setInstanceType (ec2/instance-type v2014))))
   (clojure.core/let
    [v2014
     (:ebs-optimized m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setEbsOptimized (clojure.core/boolean v2014))))
   (clojure.core/let
    [v2014
     (:ramdisk-id m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setRamdiskId (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:weighted-capacity
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setWeightedCapacity (clojure.core/double v2014))))
   (clojure.core/let
    [v2014
     (:image-id m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setImageId (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:key-name m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setKeyName (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:kernel-id m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setKernelId (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:monitoring m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setMonitoring (ec2/spot-fleet-monitoring v2014))))
   (clojure.core/let
    [v2014
     (:security-groups
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (.
      bean2012
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2767] (ec2/group-identifier arg2767))
 v2014))))
   (clojure.core/let
    [v2014
     (:block-device-mappings
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (.
      bean2012
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2768] (ec2/block-device-mapping arg2768))
 v2014))))
   (clojure.core/let
    [v2014
     (:user-data m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setUserData (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:network-interfaces
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (.
      bean2012
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2769]
  (ec2/instance-network-interface-specification arg2769))
 v2014))))
   bean2012))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocationStrategy}
allocation-strategy
  [m2016]
  (.
   com.amazonaws.services.ec2.model.AllocationStrategy
   fromValue
   (clojure.core/name m2016)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserBucket}
user-bucket
  [m2019]
  (clojure.core/let
   [bean2018 (new com.amazonaws.services.ec2.model.UserBucket)]
   (clojure.core/let
    [v2020
     (:s3bucket m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setS3Bucket (clojure.core/str v2020))))
   (clojure.core/let
    [v2020 (:s3key m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setS3Key (clojure.core/str v2020))))
   bean2018))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.S3Storage}
s3storage
  [m2022]
  (clojure.core/let
   [bean2021 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/let
    [v2023 (:prefix m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setPrefix (clojure.core/str v2023))))
   (clojure.core/let
    [v2023 (:bucket m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setBucket (clojure.core/str v2023))))
   (clojure.core/let
    [v2023
     (:upload-policy m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setUploadPolicy (clojure.core/str v2023))))
   (clojure.core/let
    [v2023
     (:upload-policy-signature
      m2022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setUploadPolicySignature (clojure.core/str v2023))))
   (clojure.core/let
    [v2023
     (:awsaccess-key-id
      m2022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setAWSAccessKeyId (clojure.core/str v2023))))
   bean2021))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermission}
launch-permission
  [m2025]
  (clojure.core/let
   [bean2024 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/let
    [v2026 (:group m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setGroup (clojure.core/str v2026))))
   (clojure.core/let
    [v2026 (:user-id m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setUserId (clojure.core/str v2026))))
   bean2024))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile}
scheduled-instances-iam-instance-profile
  [m2028]
  (clojure.core/let
   [bean2027
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile)]
   (clojure.core/let
    [v2029 (:arn m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setArn (clojure.core/str v2029))))
   (clojure.core/let
    [v2029 (:name m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setName (clojure.core/str v2029))))
   bean2027))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPlacement}
scheduled-instances-placement
  [m2031]
  (clojure.core/let
   [bean2030
    (new com.amazonaws.services.ec2.model.ScheduledInstancesPlacement)]
   (clojure.core/let
    [v2032
     (:availability-zone
      m2031
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setAvailabilityZone (clojure.core/str v2032))))
   (clojure.core/let
    [v2032
     (:group-name m2031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setGroupName (clojure.core/str v2032))))
   bean2030))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring}
scheduled-instances-monitoring
  [m2034]
  (clojure.core/let
   [bean2033
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring)]
   (clojure.core/let
    [v2035 (:enabled m2034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (. bean2033 setEnabled (clojure.core/boolean v2035))))
   bean2033))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping}
scheduled-instances-block-device-mapping
  [m2037]
  (clojure.core/let
   [bean2036
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping)]
   (clojure.core/let
    [v2038
     (:device-name m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setDeviceName (clojure.core/str v2038))))
   (clojure.core/let
    [v2038
     (:virtual-name m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setVirtualName (clojure.core/str v2038))))
   (clojure.core/let
    [v2038 (:ebs m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setEbs (ec2/scheduled-instances-ebs v2038))))
   (clojure.core/let
    [v2038
     (:no-device m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setNoDevice (clojure.core/str v2038))))
   bean2036))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface}
scheduled-instances-network-interface
  [m2040]
  (clojure.core/let
   [bean2039
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface)]
   (clojure.core/let
    [v2041
     (:description m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setDescription (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:subnet-id m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setSubnetId (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:secondary-private-ip-address-count
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2041))))
   (clojure.core/let
    [v2041
     (:device-index m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setDeviceIndex (clojure.core/int v2041))))
   (clojure.core/let
    [v2041
     (:private-ip-address
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setPrivateIpAddress (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:private-ip-address-configs
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setPrivateIpAddressConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2770]
  (ec2/scheduled-instances-private-ip-address-config arg2770))
 v2041))))
   (clojure.core/let
    [v2041 (:groups m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2771] (clojure.core/str arg2771))
 v2041))))
   (clojure.core/let
    [v2041
     (:network-interface-id
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setNetworkInterfaceId (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:associate-public-ip-address
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setAssociatePublicIpAddress
      (clojure.core/boolean v2041))))
   (clojure.core/let
    [v2041
     (:delete-on-termination
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setDeleteOnTermination (clojure.core/boolean v2041))))
   bean2039))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PriceScheduleSpecification}
price-schedule-specification
  [m2043]
  (clojure.core/let
   [bean2042
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/let
    [v2044
     (:currency-code m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setCurrencyCode (clojure.core/str v2044))))
   (clojure.core/let
    [v2044 (:price m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setPrice (clojure.core/double v2044))))
   (clojure.core/let
    [v2044 (:term m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setTerm (clojure.core/long v2044))))
   bean2042))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IpPermission}
ip-permission
  [m2046]
  (clojure.core/let
   [bean2045 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/let
    [v2047
     (:ip-protocol m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setIpProtocol (clojure.core/str v2047))))
   (clojure.core/let
    [v2047
     (:from-port m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setFromPort (clojure.core/int v2047))))
   (clojure.core/let
    [v2047 (:to-port m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setToPort (clojure.core/int v2047))))
   (clojure.core/let
    [v2047
     (:prefix-list-ids
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2772] (ec2/prefix-list-id arg2772))
 v2047))))
   (clojure.core/let
    [v2047
     (:user-id-group-pairs
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setUserIdGroupPairs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2773] (ec2/user-id-group-pair arg2773))
 v2047))))
   (clojure.core/let
    [v2047
     (:ip-ranges m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setIpRanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2774] (clojure.core/str arg2774))
 v2047))))
   bean2045))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceAttributeName}
instance-attribute-name
  [m2049]
  (.
   com.amazonaws.services.ec2.model.InstanceAttributeName
   fromValue
   (clojure.core/name m2049)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification}
instance-block-device-mapping-specification
  [m2052]
  (clojure.core/let
   [bean2051
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/let
    [v2053
     (:device-name m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setDeviceName (clojure.core/str v2053))))
   (clojure.core/let
    [v2053
     (:virtual-name m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setVirtualName (clojure.core/str v2053))))
   (clojure.core/let
    [v2053 (:ebs m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setEbs
      (ec2/ebs-instance-block-device-specification v2053))))
   (clojure.core/let
    [v2053
     (:no-device m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setNoDevice (clojure.core/str v2053))))
   bean2051))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Filter}
filter
  [m2055]
  (clojure.core/let
   [bean2054 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/let
    [v2056 (:values m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (.
      bean2054
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2775] (clojure.core/str arg2775))
 v2056))))
   (clojure.core/let
    [v2056 (:name m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setName (clojure.core/str v2056))))
   bean2054))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest}
slot-start-time-range-request
  [m2058]
  (clojure.core/let
   [bean2057
    (new com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest)]
   (clojure.core/let
    [v2059
     (:latest-time m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (.
      bean2057
      setLatestTime
      (com.palletops.awaze.common/to-date v2059))))
   (clojure.core/let
    [v2059
     (:earliest-time m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (.
      bean2057
      setEarliestTime
      (com.palletops.awaze.common/to-date v2059))))
   bean2057))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IcmpTypeCode}
icmp-type-code
  [m2061]
  (clojure.core/let
   [bean2060 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/let
    [v2062 (:type m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setType (clojure.core/int v2062))))
   (clojure.core/let
    [v2062 (:code m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setCode (clojure.core/int v2062))))
   bean2060))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PortRange}
port-range
  [m2064]
  (clojure.core/let
   [bean2063 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/let
    [v2065 (:to m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setTo (clojure.core/int v2065))))
   (clojure.core/let
    [v2065 (:from m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setFrom (clojure.core/int v2065))))
   bean2063))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification}
import-instance-launch-specification
  [m2067]
  (clojure.core/let
   [bean2066
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/let
    [v2068
     (:group-ids m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (.
      bean2066
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2776] (clojure.core/str arg2776))
 v2068))))
   (clojure.core/let
    [v2068
     (:subnet-id m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setSubnetId (clojure.core/str v2068))))
   (clojure.core/let
    [v2068
     (:additional-info
      m2067
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setAdditionalInfo (clojure.core/str v2068))))
   (clojure.core/let
    [v2068
     (:placement m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setPlacement (ec2/placement v2068))))
   (clojure.core/let
    [v2068
     (:group-names m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (.
      bean2066
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2777] (clojure.core/str arg2777))
 v2068))))
   (clojure.core/let
    [v2068
     (:private-ip-address
      m2067
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setPrivateIpAddress (clojure.core/str v2068))))
   (clojure.core/let
    [v2068
     (:instance-type m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setInstanceType (clojure.core/str v2068))))
   (clojure.core/let
    [v2068
     (:instance-initiated-shutdown-behavior
      m2067
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (.
      bean2066
      setInstanceInitiatedShutdownBehavior
      (ec2/shutdown-behavior v2068))))
   (clojure.core/let
    [v2068
     (:monitoring m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setMonitoring (clojure.core/boolean v2068))))
   (clojure.core/let
    [v2068
     (:architecture m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setArchitecture (ec2/architecture-values v2068))))
   (clojure.core/let
    [v2068
     (:user-data m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setUserData (ec2/user-data v2068))))
   bean2066))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImage}
disk-image
  [m2070]
  (clojure.core/let
   [bean2069 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/let
    [v2071 (:image m2070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2071 :com.palletops.awaze.client-builder/undef)
     (. bean2069 setImage (ec2/disk-image-detail v2071))))
   (clojure.core/let
    [v2071 (:volume m2070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2071 :com.palletops.awaze.client-builder/undef)
     (. bean2069 setVolume (ec2/volume-detail v2071))))
   (clojure.core/let
    [v2071
     (:description m2070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2071 :com.palletops.awaze.client-builder/undef)
     (. bean2069 setDescription (clojure.core/str v2071))))
   bean2069))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OperationType}
operation-type
  [m2073]
  (.
   com.amazonaws.services.ec2.model.OperationType
   fromValue
   (clojure.core/name m2073)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermissionModifications}
create-volume-permission-modifications
  [m2076]
  (clojure.core/let
   [bean2075
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/let
    [v2077 (:add m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (.
      bean2075
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2778] (ec2/create-volume-permission arg2778))
 v2077))))
   (clojure.core/let
    [v2077 (:remove m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (.
      bean2075
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2779] (ec2/create-volume-permission arg2779))
 v2077))))
   bean2075))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetRequestConfigData}
spot-fleet-request-config-data
  [m2079]
  (clojure.core/let
   [bean2078
    (new com.amazonaws.services.ec2.model.SpotFleetRequestConfigData)]
   (clojure.core/let
    [v2080
     (:iam-fleet-role m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setIamFleetRole (clojure.core/str v2080))))
   (clojure.core/let
    [v2080
     (:spot-price m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setSpotPrice (clojure.core/str v2080))))
   (clojure.core/let
    [v2080
     (:launch-specifications
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setLaunchSpecifications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2780]
  (ec2/spot-fleet-launch-specification arg2780))
 v2080))))
   (clojure.core/let
    [v2080
     (:valid-from m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setValidFrom
      (com.palletops.awaze.common/to-date v2080))))
   (clojure.core/let
    [v2080
     (:client-token m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setClientToken (clojure.core/str v2080))))
   (clojure.core/let
    [v2080
     (:allocation-strategy
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setAllocationStrategy
      (ec2/allocation-strategy v2080))))
   (clojure.core/let
    [v2080
     (:terminate-instances-with-expiration
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setTerminateInstancesWithExpiration
      (clojure.core/boolean v2080))))
   (clojure.core/let
    [v2080
     (:target-capacity
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setTargetCapacity (clojure.core/int v2080))))
   (clojure.core/let
    [v2080
     (:valid-until m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setValidUntil
      (com.palletops.awaze.common/to-date v2080))))
   (clojure.core/let
    [v2080
     (:excess-capacity-termination-policy
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setExcessCapacityTerminationPolicy
      (clojure.core/str v2080))))
   bean2078))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportEnvironment}
export-environment
  [m2082]
  (.
   com.amazonaws.services.ec2.model.ExportEnvironment
   fromValue
   (clojure.core/name m2082)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportToS3TaskSpecification}
export-to-s3task-specification
  [m2085]
  (clojure.core/let
   [bean2084
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/let
    [v2086
     (:disk-image-format
      m2085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setDiskImageFormat (ec2/disk-image-format v2086))))
   (clojure.core/let
    [v2086
     (:container-format
      m2085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setContainerFormat (clojure.core/str v2086))))
   (clojure.core/let
    [v2086
     (:s3bucket m2085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setS3Bucket (clojure.core/str v2086))))
   (clojure.core/let
    [v2086
     (:s3prefix m2085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setS3Prefix (clojure.core/str v2086))))
   bean2084))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseRequest}
purchase-request
  [m2088]
  (clojure.core/let
   [bean2087 (new com.amazonaws.services.ec2.model.PurchaseRequest)]
   (clojure.core/let
    [v2089
     (:instance-count m2088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (. bean2087 setInstanceCount (clojure.core/int v2089))))
   (clojure.core/let
    [v2089
     (:purchase-token m2088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (. bean2087 setPurchaseToken (clojure.core/str v2089))))
   bean2087))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice}
reserved-instance-limit-price
  [m2091]
  (clojure.core/let
   [bean2090
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/let
    [v2092
     (:currency-code m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setCurrencyCode (clojure.core/str v2092))))
   (clojure.core/let
    [v2092 (:amount m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setAmount (clojure.core/double v2092))))
   bean2090))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeType}
volume-type
  [m2094]
  (.
   com.amazonaws.services.ec2.model.VolumeType
   fromValue
   (clojure.core/name m2094)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DhcpConfiguration}
dhcp-configuration
  [m2097]
  (clojure.core/let
   [bean2096 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/let
    [v2098 (:values m2097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (.
      bean2096
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2781] (clojure.core/str arg2781))
 v2098))))
   (clojure.core/let
    [v2098 (:key m2097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setKey (clojure.core/str v2098))))
   bean2096))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotInstanceType}
spot-instance-type
  [m2100]
  (.
   com.amazonaws.services.ec2.model.SpotInstanceType
   fromValue
   (clojure.core/name m2100)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchSpecification}
launch-specification
  [m2103]
  (clojure.core/let
   [bean2102
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/let
    [v2104
     (:iam-instance-profile
      m2103
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (.
      bean2102
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2104))))
   (clojure.core/let
    [v2104
     (:subnet-id m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setSubnetId (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:placement m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setPlacement (ec2/spot-placement v2104))))
   (clojure.core/let
    [v2104
     (:addressing-type
      m2103
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setAddressingType (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:instance-type m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setInstanceType (ec2/instance-type v2104))))
   (clojure.core/let
    [v2104
     (:ebs-optimized m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setEbsOptimized (clojure.core/boolean v2104))))
   (clojure.core/let
    [v2104
     (:ramdisk-id m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setRamdiskId (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:all-security-groups
      m2103
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (.
      bean2102
      setAllSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2782] (ec2/group-identifier arg2782))
 v2104))))
   (clojure.core/let
    [v2104
     (:image-id m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setImageId (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:key-name m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setKeyName (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:monitoring-enabled
      m2103
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setMonitoringEnabled (clojure.core/boolean v2104))))
   (clojure.core/let
    [v2104
     (:kernel-id m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setKernelId (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:security-groups
      m2103
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (.
      bean2102
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2783] (clojure.core/str arg2783))
 v2104))))
   (clojure.core/let
    [v2104
     (:block-device-mappings
      m2103
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (.
      bean2102
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2784] (ec2/block-device-mapping arg2784))
 v2104))))
   (clojure.core/let
    [v2104
     (:user-data m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setUserData (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:network-interfaces
      m2103
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (.
      bean2102
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2785]
  (ec2/instance-network-interface-specification arg2785))
 v2104))))
   bean2102))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ClientData}
client-data
  [m2106]
  (clojure.core/let
   [bean2105 (new com.amazonaws.services.ec2.model.ClientData)]
   (clojure.core/let
    [v2107 (:comment m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (. bean2105 setComment (clojure.core/str v2107))))
   (clojure.core/let
    [v2107
     (:upload-start m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (.
      bean2105
      setUploadStart
      (com.palletops.awaze.common/to-date v2107))))
   (clojure.core/let
    [v2107
     (:upload-end m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (.
      bean2105
      setUploadEnd
      (com.palletops.awaze.common/to-date v2107))))
   (clojure.core/let
    [v2107
     (:upload-size m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (. bean2105 setUploadSize (clojure.core/double v2107))))
   bean2105))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotDiskContainer}
snapshot-disk-container
  [m2109]
  (clojure.core/let
   [bean2108
    (new com.amazonaws.services.ec2.model.SnapshotDiskContainer)]
   (clojure.core/let
    [v2110 (:format m2109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2110 :com.palletops.awaze.client-builder/undef)
     (. bean2108 setFormat (clojure.core/str v2110))))
   (clojure.core/let
    [v2110
     (:description m2109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2110 :com.palletops.awaze.client-builder/undef)
     (. bean2108 setDescription (clojure.core/str v2110))))
   (clojure.core/let
    [v2110 (:url m2109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2110 :com.palletops.awaze.client-builder/undef)
     (. bean2108 setUrl (clojure.core/str v2110))))
   (clojure.core/let
    [v2110
     (:user-bucket m2109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2110 :com.palletops.awaze.client-builder/undef)
     (. bean2108 setUserBucket (ec2/user-bucket v2110))))
   bean2108))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tag}
tag
  [m2112]
  (clojure.core/let
   [bean2111 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/let
    [v2113 (:key m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setKey (clojure.core/str v2113))))
   (clojure.core/let
    [v2113 (:value m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setValue (clojure.core/str v2113))))
   bean2111))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RIProductDescription}
riproduct-description
  [m2115]
  (.
   com.amazonaws.services.ec2.model.RIProductDescription
   fromValue
   (clojure.core/name m2115)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GatewayType}
gateway-type
  [m2118]
  (.
   com.amazonaws.services.ec2.model.GatewayType
   fromValue
   (clojure.core/name m2118)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.FlowLogsResourceType}
flow-logs-resource-type
  [m2121]
  (.
   com.amazonaws.services.ec2.model.FlowLogsResourceType
   fromValue
   (clojure.core/name m2121)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Storage}
storage
  [m2124]
  (clojure.core/let
   [bean2123 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/let
    [v2125 (:s3 m2124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2125 :com.palletops.awaze.client-builder/undef)
     (. bean2123 setS3 (ec2/s3storage v2125))))
   bean2123))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EventType}
event-type
  [m2127]
  (.
   com.amazonaws.services.ec2.model.EventType
   fromValue
   (clojure.core/name m2127)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.HostTenancy}
host-tenancy
  [m2130]
  (.
   com.amazonaws.services.ec2.model.HostTenancy
   fromValue
   (clojure.core/name m2130)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Affinity}
affinity
  [m2133]
  (.
   com.amazonaws.services.ec2.model.Affinity
   fromValue
   (clojure.core/name m2133)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermissionModifications}
launch-permission-modifications
  [m2136]
  (clojure.core/let
   [bean2135
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/let
    [v2137 (:add m2136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2137 :com.palletops.awaze.client-builder/undef)
     (.
      bean2135
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2786] (ec2/launch-permission arg2786))
 v2137))))
   (clojure.core/let
    [v2137 (:remove m2136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2137 :com.palletops.awaze.client-builder/undef)
     (.
      bean2135
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2787] (ec2/launch-permission arg2787))
 v2137))))
   bean2135))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AutoPlacement}
auto-placement
  [m2139]
  (.
   com.amazonaws.services.ec2.model.AutoPlacement
   fromValue
   (clojure.core/name m2139)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification}
vpn-connection-options-specification
  [m2142]
  (clojure.core/let
   [bean2141
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/let
    [v2143
     (:static-routes-only
      m2142
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2143 :com.palletops.awaze.client-builder/undef)
     (. bean2141 setStaticRoutesOnly (clojure.core/boolean v2143))))
   bean2141))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest}
scheduled-instance-recurrence-request
  [m2145]
  (clojure.core/let
   [bean2144
    (new
     com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest)]
   (clojure.core/let
    [v2146
     (:frequency m2145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2146 :com.palletops.awaze.client-builder/undef)
     (. bean2144 setFrequency (clojure.core/str v2146))))
   (clojure.core/let
    [v2146
     (:interval m2145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2146 :com.palletops.awaze.client-builder/undef)
     (. bean2144 setInterval (clojure.core/int v2146))))
   (clojure.core/let
    [v2146
     (:occurrence-days
      m2145
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2146 :com.palletops.awaze.client-builder/undef)
     (.
      bean2144
      setOccurrenceDays
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2788] (clojure.core/int arg2788))
 v2146))))
   (clojure.core/let
    [v2146
     (:occurrence-relative-to-end
      m2145
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2146 :com.palletops.awaze.client-builder/undef)
     (.
      bean2144
      setOccurrenceRelativeToEnd
      (clojure.core/boolean v2146))))
   (clojure.core/let
    [v2146
     (:occurrence-unit
      m2145
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2146 :com.palletops.awaze.client-builder/undef)
     (. bean2144 setOccurrenceUnit (clojure.core/str v2146))))
   bean2144))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest}
slot-date-time-range-request
  [m2148]
  (clojure.core/let
   [bean2147
    (new com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest)]
   (clojure.core/let
    [v2149
     (:latest-time m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (.
      bean2147
      setLatestTime
      (com.palletops.awaze.common/to-date v2149))))
   (clojure.core/let
    [v2149
     (:earliest-time m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (.
      bean2147
      setEarliestTime
      (com.palletops.awaze.common/to-date v2149))))
   bean2147))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OfferingTypeValues}
offering-type-values
  [m2151]
  (.
   com.amazonaws.services.ec2.model.OfferingTypeValues
   fromValue
   (clojure.core/name m2151)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImageDiskContainer}
image-disk-container
  [m2154]
  (clojure.core/let
   [bean2153
    (new com.amazonaws.services.ec2.model.ImageDiskContainer)]
   (clojure.core/let
    [v2155 (:format m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setFormat (clojure.core/str v2155))))
   (clojure.core/let
    [v2155
     (:description m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setDescription (clojure.core/str v2155))))
   (clojure.core/let
    [v2155
     (:snapshot-id m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setSnapshotId (clojure.core/str v2155))))
   (clojure.core/let
    [v2155
     (:device-name m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setDeviceName (clojure.core/str v2155))))
   (clojure.core/let
    [v2155 (:url m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setUrl (clojure.core/str v2155))))
   (clojure.core/let
    [v2155
     (:user-bucket m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setUserBucket (ec2/user-bucket v2155))))
   bean2153))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification}
scheduled-instances-launch-specification
  [m2157]
  (clojure.core/let
   [bean2156
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification)]
   (clojure.core/let
    [v2158
     (:iam-instance-profile
      m2157
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (.
      bean2156
      setIamInstanceProfile
      (ec2/scheduled-instances-iam-instance-profile v2158))))
   (clojure.core/let
    [v2158
     (:subnet-id m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setSubnetId (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:security-group-ids
      m2157
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (.
      bean2156
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2789] (clojure.core/str arg2789))
 v2158))))
   (clojure.core/let
    [v2158
     (:placement m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (.
      bean2156
      setPlacement
      (ec2/scheduled-instances-placement v2158))))
   (clojure.core/let
    [v2158
     (:instance-type m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setInstanceType (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:ebs-optimized m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setEbsOptimized (clojure.core/boolean v2158))))
   (clojure.core/let
    [v2158
     (:ramdisk-id m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setRamdiskId (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:image-id m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setImageId (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:key-name m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setKeyName (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:kernel-id m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setKernelId (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:monitoring m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (.
      bean2156
      setMonitoring
      (ec2/scheduled-instances-monitoring v2158))))
   (clojure.core/let
    [v2158
     (:block-device-mappings
      m2157
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (.
      bean2156
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2790]
  (ec2/scheduled-instances-block-device-mapping arg2790))
 v2158))))
   (clojure.core/let
    [v2158
     (:user-data m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setUserData (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:network-interfaces
      m2157
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (.
      bean2156
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2791]
  (ec2/scheduled-instances-network-interface arg2791))
 v2158))))
   bean2156))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstancesConfiguration}
reserved-instances-configuration
  [m2160]
  (clojure.core/let
   [bean2159
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/let
    [v2161
     (:platform m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setPlatform (clojure.core/str v2161))))
   (clojure.core/let
    [v2161
     (:instance-type m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setInstanceType (ec2/instance-type v2161))))
   (clojure.core/let
    [v2161
     (:availability-zone
      m2160
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setAvailabilityZone (clojure.core/str v2161))))
   (clojure.core/let
    [v2161
     (:instance-count m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (. bean2159 setInstanceCount (clojure.core/int v2161))))
   bean2159))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges}
network-interface-attachment-changes
  [m2163]
  (clojure.core/let
   [bean2162
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/let
    [v2164
     (:attachment-id m2163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2164 :com.palletops.awaze.client-builder/undef)
     (. bean2162 setAttachmentId (clojure.core/str v2164))))
   (clojure.core/let
    [v2164
     (:delete-on-termination
      m2163
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2164 :com.palletops.awaze.client-builder/undef)
     (. bean2162 setDeleteOnTermination (clojure.core/boolean v2164))))
   bean2162))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest}
delete-vpc-endpoints-request
  [m2166]
  (clojure.core/let
   [bean2165
    (new com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest)]
   (clojure.core/let
    [v2167
     (:vpc-endpoint-ids
      m2166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (.
      bean2165
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2792] (clojure.core/str arg2792))
 v2167))))
   bean2165))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNatGatewayRequest}
create-nat-gateway-request
  [m2169]
  (clojure.core/let
   [bean2168
    (new com.amazonaws.services.ec2.model.CreateNatGatewayRequest)]
   (clojure.core/let
    [v2170
     (:client-token m2169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setClientToken (clojure.core/str v2170))))
   (clojure.core/let
    [v2170
     (:subnet-id m2169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setSubnetId (clojure.core/str v2170))))
   (clojure.core/let
    [v2170
     (:allocation-id m2169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setAllocationId (clojure.core/str v2170))))
   bean2168))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StopInstancesRequest}
stop-instances-request
  [m2172]
  (clojure.core/let
   [bean2171
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/let
    [v2173 (:force m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setForce (clojure.core/boolean v2173))))
   (clojure.core/let
    [v2173
     (:instance-ids m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (.
      bean2171
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2793] (clojure.core/str arg2793))
 v2173))))
   bean2171))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreatePlacementGroupRequest}
create-placement-group-request
  [m2175]
  (clojure.core/let
   [bean2174
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/let
    [v2176
     (:group-name m2175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2176 :com.palletops.awaze.client-builder/undef)
     (. bean2174 setGroupName (clojure.core/str v2176))))
   (clojure.core/let
    [v2176
     (:strategy m2175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2176 :com.palletops.awaze.client-builder/undef)
     (. bean2174 setStrategy (clojure.core/str v2176))))
   bean2174))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest}
create-reserved-instances-listing-request
  [m2178]
  (clojure.core/let
   [bean2177
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/let
    [v2179
     (:client-token m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setClientToken (clojure.core/str v2179))))
   (clojure.core/let
    [v2179
     (:reserved-instances-id
      m2178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setReservedInstancesId (clojure.core/str v2179))))
   (clojure.core/let
    [v2179
     (:instance-count m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setInstanceCount (clojure.core/int v2179))))
   (clojure.core/let
    [v2179
     (:price-schedules
      m2178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (.
      bean2177
      setPriceSchedules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2794]
  (ec2/price-schedule-specification arg2794))
 v2179))))
   bean2177))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseHostsRequest}
release-hosts-request
  [m2181]
  (clojure.core/let
   [bean2180
    (new com.amazonaws.services.ec2.model.ReleaseHostsRequest)]
   (clojure.core/let
    [v2182
     (:host-ids m2181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2182 :com.palletops.awaze.client-builder/undef)
     (.
      bean2180
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2795] (clojure.core/str arg2795))
 v2182))))
   bean2180))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest}
revoke-security-group-ingress-request
  [m2184]
  (clojure.core/let
   [bean2183
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2185 (:cidr-ip m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setCidrIp (clojure.core/str v2185))))
   (clojure.core/let
    [v2185
     (:group-id m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setGroupId (clojure.core/str v2185))))
   (clojure.core/let
    [v2185 (:to-port m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setToPort (clojure.core/int v2185))))
   (clojure.core/let
    [v2185
     (:source-security-group-owner-id
      m2184
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (.
      bean2183
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2185))))
   (clojure.core/let
    [v2185
     (:ip-permissions m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (.
      bean2183
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2796] (ec2/ip-permission arg2796))
 v2185))))
   (clojure.core/let
    [v2185
     (:source-security-group-name
      m2184
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setSourceSecurityGroupName (clojure.core/str v2185))))
   (clojure.core/let
    [v2185
     (:group-name m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setGroupName (clojure.core/str v2185))))
   (clojure.core/let
    [v2185
     (:ip-protocol m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setIpProtocol (clojure.core/str v2185))))
   (clojure.core/let
    [v2185
     (:from-port m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setFromPort (clojure.core/int v2185))))
   bean2183))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest}
attach-classic-link-vpc-request
  [m2187]
  (clojure.core/let
   [bean2186
    (new com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2188 (:vpc-id m2187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2188 :com.palletops.awaze.client-builder/undef)
     (. bean2186 setVpcId (clojure.core/str v2188))))
   (clojure.core/let
    [v2188
     (:instance-id m2187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2188 :com.palletops.awaze.client-builder/undef)
     (. bean2186 setInstanceId (clojure.core/str v2188))))
   (clojure.core/let
    [v2188 (:groups m2187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2188 :com.palletops.awaze.client-builder/undef)
     (.
      bean2186
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2797] (clojure.core/str arg2797))
 v2188))))
   bean2186))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest}
replace-network-acl-association-request
  [m2190]
  (clojure.core/let
   [bean2189
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/let
    [v2191
     (:association-id m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setAssociationId (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:network-acl-id m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setNetworkAclId (clojure.core/str v2191))))
   bean2189))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNatGatewayRequest}
delete-nat-gateway-request
  [m2193]
  (clojure.core/let
   [bean2192
    (new com.amazonaws.services.ec2.model.DeleteNatGatewayRequest)]
   (clojure.core/let
    [v2194
     (:nat-gateway-id m2193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2194 :com.palletops.awaze.client-builder/undef)
     (. bean2192 setNatGatewayId (clojure.core/str v2194))))
   bean2192))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest}
modify-instance-attribute-request
  [m2196]
  (clojure.core/let
   [bean2195
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/let
    [v2197 (:kernel m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setKernel (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:instance-type m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setInstanceType (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:ebs-optimized m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setEbsOptimized (clojure.core/boolean v2197))))
   (clojure.core/let
    [v2197
     (:source-dest-check
      m2196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setSourceDestCheck (clojure.core/boolean v2197))))
   (clojure.core/let
    [v2197
     (:instance-id m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setInstanceId (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:instance-initiated-shutdown-behavior
      m2196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v2197))))
   (clojure.core/let
    [v2197 (:groups m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2798] (clojure.core/str arg2798))
 v2197))))
   (clojure.core/let
    [v2197
     (:disable-api-termination
      m2196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setDisableApiTermination
      (clojure.core/boolean v2197))))
   (clojure.core/let
    [v2197
     (:attribute m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setAttribute (ec2/instance-attribute-name v2197))))
   (clojure.core/let
    [v2197
     (:sriov-net-support
      m2196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setSriovNetSupport (clojure.core/str v2197))))
   (clojure.core/let
    [v2197 (:value m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setValue (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:block-device-mappings
      m2196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2799]
  (ec2/instance-block-device-mapping-specification arg2799))
 v2197))))
   (clojure.core/let
    [v2197 (:ramdisk m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setRamdisk (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:user-data m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setUserData (clojure.core/str v2197))))
   bean2195))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest}
describe-network-acls-request
  [m2199]
  (clojure.core/let
   [bean2198
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/let
    [v2200 (:filters m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2800] (ec2/filter arg2800))
 v2200))))
   (clojure.core/let
    [v2200
     (:network-acl-ids
      m2199
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setNetworkAclIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2801] (clojure.core/str arg2801))
 v2200))))
   bean2198))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportInstanceStatusRequest}
report-instance-status-request
  [m2202]
  (clojure.core/let
   [bean2201
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/let
    [v2203
     (:instances m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (.
      bean2201
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2802] (clojure.core/str arg2802))
 v2203))))
   (clojure.core/let
    [v2203 (:status m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (. bean2201 setStatus (clojure.core/str v2203))))
   (clojure.core/let
    [v2203
     (:reason-codes m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (.
      bean2201
      setReasonCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2803] (clojure.core/str arg2803))
 v2203))))
   (clojure.core/let
    [v2203
     (:description m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (. bean2201 setDescription (clojure.core/str v2203))))
   (clojure.core/let
    [v2203
     (:start-time m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (.
      bean2201
      setStartTime
      (com.palletops.awaze.common/to-date v2203))))
   (clojure.core/let
    [v2203
     (:end-time m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (.
      bean2201
      setEndTime
      (com.palletops.awaze.common/to-date v2203))))
   bean2201))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImagesRequest}
describe-images-request
  [m2205]
  (clojure.core/let
   [bean2204
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/let
    [v2206 (:filters m2205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (.
      bean2204
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2804] (ec2/filter arg2804))
 v2206))))
   (clojure.core/let
    [v2206
     (:image-ids m2205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (.
      bean2204
      setImageIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2805] (clojure.core/str arg2805))
 v2206))))
   (clojure.core/let
    [v2206 (:owners m2205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (.
      bean2204
      setOwners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2806] (clojure.core/str arg2806))
 v2206))))
   (clojure.core/let
    [v2206
     (:executable-users
      m2205
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (.
      bean2204
      setExecutableUsers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2807] (clojure.core/str arg2807))
 v2206))))
   bean2204))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest}
describe-import-image-tasks-request
  [m2208]
  (clojure.core/let
   [bean2207
    (new
     com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest)]
   (clojure.core/let
    [v2209 (:filters m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (.
      bean2207
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2808] (ec2/filter arg2808))
 v2209))))
   (clojure.core/let
    [v2209
     (:next-token m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setNextToken (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:max-results m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setMaxResults (clojure.core/int v2209))))
   (clojure.core/let
    [v2209
     (:import-task-ids
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (.
      bean2207
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2809] (clojure.core/str arg2809))
 v2209))))
   bean2207))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyHostsRequest}
modify-hosts-request
  [m2211]
  (clojure.core/let
   [bean2210
    (new com.amazonaws.services.ec2.model.ModifyHostsRequest)]
   (clojure.core/let
    [v2212
     (:auto-placement m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setAutoPlacement (clojure.core/str v2212))))
   (clojure.core/let
    [v2212
     (:host-ids m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (.
      bean2210
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2810] (clojure.core/str arg2810))
 v2212))))
   bean2210))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RegisterImageRequest}
register-image-request
  [m2214]
  (clojure.core/let
   [bean2213
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/let
    [v2215
     (:description m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setDescription (clojure.core/str v2215))))
   (clojure.core/let
    [v2215 (:name m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setName (clojure.core/str v2215))))
   (clojure.core/let
    [v2215
     (:root-device-name
      m2214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setRootDeviceName (clojure.core/str v2215))))
   (clojure.core/let
    [v2215
     (:ramdisk-id m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setRamdiskId (clojure.core/str v2215))))
   (clojure.core/let
    [v2215
     (:virtualization-type
      m2214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setVirtualizationType (clojure.core/str v2215))))
   (clojure.core/let
    [v2215
     (:sriov-net-support
      m2214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setSriovNetSupport (clojure.core/str v2215))))
   (clojure.core/let
    [v2215
     (:kernel-id m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setKernelId (clojure.core/str v2215))))
   (clojure.core/let
    [v2215
     (:image-location m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setImageLocation (clojure.core/str v2215))))
   (clojure.core/let
    [v2215
     (:architecture m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setArchitecture (ec2/architecture-values v2215))))
   (clojure.core/let
    [v2215
     (:block-device-mappings
      m2214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (.
      bean2213
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2811] (ec2/block-device-mapping arg2811))
 v2215))))
   bean2213))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVpnGatewayRequest}
detach-vpn-gateway-request
  [m2217]
  (clojure.core/let
   [bean2216
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/let
    [v2218 (:vpc-id m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (. bean2216 setVpcId (clojure.core/str v2218))))
   (clojure.core/let
    [v2218
     (:vpn-gateway-id m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (. bean2216 setVpnGatewayId (clojure.core/str v2218))))
   bean2216))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVolumeRequest}
delete-volume-request
  [m2220]
  (clojure.core/let
   [bean2219
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v2221
     (:volume-id m2220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (. bean2219 setVolumeId (clojure.core/str v2221))))
   bean2219))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest}
delete-internet-gateway-request
  [m2223]
  (clojure.core/let
   [bean2222
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/let
    [v2224
     (:internet-gateway-id
      m2223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (. bean2222 setInternetGatewayId (clojure.core/str v2224))))
   bean2222))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSubnetRequest}
delete-subnet-request
  [m2226]
  (clojure.core/let
   [bean2225
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/let
    [v2227
     (:subnet-id m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setSubnetId (clojure.core/str v2227))))
   bean2225))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest}
reset-instance-attribute-request
  [m2229]
  (clojure.core/let
   [bean2228
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/let
    [v2230
     (:attribute m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setAttribute (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:instance-id m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setInstanceId (clojure.core/str v2230))))
   bean2228))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVolumeRequest}
detach-volume-request
  [m2232]
  (clojure.core/let
   [bean2231
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/let
    [v2233 (:force m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setForce (clojure.core/boolean v2233))))
   (clojure.core/let
    [v2233
     (:instance-id m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setInstanceId (clojure.core/str v2233))))
   (clojure.core/let
    [v2233 (:device m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setDevice (clojure.core/str v2233))))
   (clojure.core/let
    [v2233
     (:volume-id m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setVolumeId (clojure.core/str v2233))))
   bean2231))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeExportTasksRequest}
describe-export-tasks-request
  [m2235]
  (clojure.core/let
   [bean2234
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/let
    [v2236
     (:export-task-ids
      m2235
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2236 :com.palletops.awaze.client-builder/undef)
     (.
      bean2234
      setExportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2812] (clojure.core/str arg2812))
 v2236))))
   bean2234))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest}
describe-scheduled-instances-request
  [m2238]
  (clojure.core/let
   [bean2237
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest)]
   (clojure.core/let
    [v2239 (:filters m2238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (.
      bean2237
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2813] (ec2/filter arg2813))
 v2239))))
   (clojure.core/let
    [v2239
     (:next-token m2238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (. bean2237 setNextToken (clojure.core/str v2239))))
   (clojure.core/let
    [v2239
     (:max-results m2238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (. bean2237 setMaxResults (clojure.core/int v2239))))
   (clojure.core/let
    [v2239
     (:scheduled-instance-ids
      m2238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (.
      bean2237
      setScheduledInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2814] (clojure.core/str arg2814))
 v2239))))
   (clojure.core/let
    [v2239
     (:slot-start-time-range
      m2238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (.
      bean2237
      setSlotStartTimeRange
      (ec2/slot-start-time-range-request v2239))))
   bean2237))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteFlowLogsRequest}
delete-flow-logs-request
  [m2241]
  (clojure.core/let
   [bean2240
    (new com.amazonaws.services.ec2.model.DeleteFlowLogsRequest)]
   (clojure.core/let
    [v2242
     (:flow-log-ids m2241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2242 :com.palletops.awaze.client-builder/undef)
     (.
      bean2240
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2815] (clojure.core/str arg2815))
 v2242))))
   bean2240))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcRequest}
create-vpc-request
  [m2244]
  (clojure.core/let
   [bean2243 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/let
    [v2245
     (:instance-tenancy
      m2244
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (. bean2243 setInstanceTenancy (clojure.core/str v2245))))
   (clojure.core/let
    [v2245
     (:cidr-block m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (. bean2243 setCidrBlock (clojure.core/str v2245))))
   bean2243))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest}
create-spot-datafeed-subscription-request
  [m2247]
  (clojure.core/let
   [bean2246
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/let
    [v2248 (:prefix m2247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (. bean2246 setPrefix (clojure.core/str v2248))))
   (clojure.core/let
    [v2248 (:bucket m2247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (. bean2246 setBucket (clojure.core/str v2248))))
   bean2246))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest}
describe-vpc-classic-link-request
  [m2250]
  (clojure.core/let
   [bean2249
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest)]
   (clojure.core/let
    [v2251 (:filters m2250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (.
      bean2249
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2816] (ec2/filter arg2816))
 v2251))))
   (clojure.core/let
    [v2251 (:vpc-ids m2250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (.
      bean2249
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2817] (clojure.core/str arg2817))
 v2251))))
   bean2249))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteRequest}
delete-route-request
  [m2253]
  (clojure.core/let
   [bean2252
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/let
    [v2254
     (:route-table-id m2253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (. bean2252 setRouteTableId (clojure.core/str v2254))))
   (clojure.core/let
    [v2254
     (:destination-cidr-block
      m2253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (. bean2252 setDestinationCidrBlock (clojure.core/str v2254))))
   bean2252))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeIdFormatRequest}
describe-id-format-request
  [m2256]
  (clojure.core/let
   [bean2255
    (new com.amazonaws.services.ec2.model.DescribeIdFormatRequest)]
   (clojure.core/let
    [v2257
     (:resource m2256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2257 :com.palletops.awaze.client-builder/undef)
     (. bean2255 setResource (clojure.core/str v2257))))
   bean2255))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVolumeRequest}
attach-volume-request
  [m2259]
  (clojure.core/let
   [bean2258
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/let
    [v2260
     (:instance-id m2259 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setInstanceId (clojure.core/str v2260))))
   (clojure.core/let
    [v2260 (:device m2259 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setDevice (clojure.core/str v2260))))
   (clojure.core/let
    [v2260
     (:volume-id m2259 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setVolumeId (clojure.core/str v2260))))
   bean2258))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVolumeIORequest}
enable-volume-iorequest
  [m2262]
  (clojure.core/let
   [bean2261
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/let
    [v2263
     (:volume-id m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setVolumeId (clojure.core/str v2263))))
   bean2261))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVpnGatewayRequest}
attach-vpn-gateway-request
  [m2265]
  (clojure.core/let
   [bean2264
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/let
    [v2266 (:vpc-id m2265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2266 :com.palletops.awaze.client-builder/undef)
     (. bean2264 setVpcId (clojure.core/str v2266))))
   (clojure.core/let
    [v2266
     (:vpn-gateway-id m2265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2266 :com.palletops.awaze.client-builder/undef)
     (. bean2264 setVpnGatewayId (clojure.core/str v2266))))
   bean2264))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest}
replace-network-acl-entry-request
  [m2268]
  (clojure.core/let
   [bean2267
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/let
    [v2269
     (:protocol m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setProtocol (clojure.core/str v2269))))
   (clojure.core/let
    [v2269
     (:network-acl-id m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setNetworkAclId (clojure.core/str v2269))))
   (clojure.core/let
    [v2269
     (:rule-number m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setRuleNumber (clojure.core/int v2269))))
   (clojure.core/let
    [v2269
     (:rule-action m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setRuleAction (clojure.core/str v2269))))
   (clojure.core/let
    [v2269 (:egress m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setEgress (clojure.core/boolean v2269))))
   (clojure.core/let
    [v2269
     (:cidr-block m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setCidrBlock (clojure.core/str v2269))))
   (clojure.core/let
    [v2269
     (:icmp-type-code m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setIcmpTypeCode (ec2/icmp-type-code v2269))))
   (clojure.core/let
    [v2269
     (:port-range m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setPortRange (ec2/port-range v2269))))
   bean2267))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest}
describe-snapshot-attribute-request
  [m2271]
  (clojure.core/let
   [bean2270
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/let
    [v2272
     (:attribute m2271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2272 :com.palletops.awaze.client-builder/undef)
     (. bean2270 setAttribute (clojure.core/str v2272))))
   (clojure.core/let
    [v2272
     (:snapshot-id m2271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2272 :com.palletops.awaze.client-builder/undef)
     (. bean2270 setSnapshotId (clojure.core/str v2272))))
   bean2270))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RebootInstancesRequest}
reboot-instances-request
  [m2274]
  (clojure.core/let
   [bean2273
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/let
    [v2275
     (:instance-ids m2274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2275 :com.palletops.awaze.client-builder/undef)
     (.
      bean2273
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2818] (clojure.core/str arg2818))
 v2275))))
   bean2273))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest}
reject-vpc-peering-connection-request
  [m2277]
  (clojure.core/let
   [bean2276
    (new
     com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2278
     (:vpc-peering-connection-id
      m2277
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2278 :com.palletops.awaze.client-builder/undef)
     (. bean2276 setVpcPeeringConnectionId (clojure.core/str v2278))))
   bean2276))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSecurityGroupRequest}
create-security-group-request
  [m2280]
  (clojure.core/let
   [bean2279
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/let
    [v2281 (:vpc-id m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setVpcId (clojure.core/str v2281))))
   (clojure.core/let
    [v2281
     (:group-name m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setGroupName (clojure.core/str v2281))))
   (clojure.core/let
    [v2281
     (:description m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setDescription (clojure.core/str v2281))))
   bean2279))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest}
describe-spot-instance-requests-request
  [m2283]
  (clojure.core/let
   [bean2282
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2284
     (:spot-instance-request-ids
      m2283
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (.
      bean2282
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2819] (clojure.core/str arg2819))
 v2284))))
   (clojure.core/let
    [v2284 (:filters m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (.
      bean2282
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2820] (ec2/filter arg2820))
 v2284))))
   bean2282))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest}
describe-spot-datafeed-subscription-request
  [m2286]
  (clojure.core/let
   [bean2285
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean2285))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MoveAddressToVpcRequest}
move-address-to-vpc-request
  [m2289]
  (clojure.core/let
   [bean2288
    (new com.amazonaws.services.ec2.model.MoveAddressToVpcRequest)]
   (clojure.core/let
    [v2290
     (:public-ip m2289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2290 :com.palletops.awaze.client-builder/undef)
     (. bean2288 setPublicIp (clojure.core/str v2290))))
   bean2288))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest}
modify-vpc-endpoint-request
  [m2292]
  (clojure.core/let
   [bean2291
    (new com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest)]
   (clojure.core/let
    [v2293
     (:add-route-table-ids
      m2292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (.
      bean2291
      setAddRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2821] (clojure.core/str arg2821))
 v2293))))
   (clojure.core/let
    [v2293
     (:remove-route-table-ids
      m2292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (.
      bean2291
      setRemoveRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2822] (clojure.core/str arg2822))
 v2293))))
   (clojure.core/let
    [v2293
     (:vpc-endpoint-id
      m2292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setVpcEndpointId (clojure.core/str v2293))))
   (clojure.core/let
    [v2293
     (:reset-policy m2292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setResetPolicy (clojure.core/boolean v2293))))
   (clojure.core/let
    [v2293
     (:policy-document
      m2292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setPolicyDocument (clojure.core/str v2293))))
   bean2291))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest}
attach-network-interface-request
  [m2295]
  (clojure.core/let
   [bean2294
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2296
     (:network-interface-id
      m2295
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (. bean2294 setNetworkInterfaceId (clojure.core/str v2296))))
   (clojure.core/let
    [v2296
     (:instance-id m2295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (. bean2294 setInstanceId (clojure.core/str v2296))))
   (clojure.core/let
    [v2296
     (:device-index m2295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (. bean2294 setDeviceIndex (clojure.core/int v2296))))
   bean2294))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest}
detach-network-interface-request
  [m2298]
  (clojure.core/let
   [bean2297
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2299 (:force m2298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2299 :com.palletops.awaze.client-builder/undef)
     (. bean2297 setForce (clojure.core/boolean v2299))))
   (clojure.core/let
    [v2299
     (:attachment-id m2298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2299 :com.palletops.awaze.client-builder/undef)
     (. bean2297 setAttachmentId (clojure.core/str v2299))))
   bean2297))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest}
delete-dhcp-options-request
  [m2301]
  (clojure.core/let
   [bean2300
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/let
    [v2302
     (:dhcp-options-id
      m2301
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2302 :com.palletops.awaze.client-builder/undef)
     (. bean2300 setDhcpOptionsId (clojure.core/str v2302))))
   bean2300))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest}
describe-vpc-endpoints-request
  [m2304]
  (clojure.core/let
   [bean2303
    (new com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest)]
   (clojure.core/let
    [v2305 (:filters m2304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (.
      bean2303
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2823] (ec2/filter arg2823))
 v2305))))
   (clojure.core/let
    [v2305
     (:vpc-endpoint-ids
      m2304
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (.
      bean2303
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2824] (clojure.core/str arg2824))
 v2305))))
   (clojure.core/let
    [v2305
     (:next-token m2304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (. bean2303 setNextToken (clojure.core/str v2305))))
   (clojure.core/let
    [v2305
     (:max-results m2304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (. bean2303 setMaxResults (clojure.core/int v2305))))
   bean2303))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest}
confirm-product-instance-request
  [m2307]
  (clojure.core/let
   [bean2306
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/let
    [v2308
     (:instance-id m2307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setInstanceId (clojure.core/str v2308))))
   (clojure.core/let
    [v2308
     (:product-code m2307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setProductCode (clojure.core/str v2308))))
   bean2306))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateAddressRequest}
allocate-address-request
  [m2310]
  (clojure.core/let
   [bean2309
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/let
    [v2311 (:domain m2310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2311 :com.palletops.awaze.client-builder/undef)
     (. bean2309 setDomain (clojure.core/str v2311))))
   bean2309))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcEndpointRequest}
create-vpc-endpoint-request
  [m2313]
  (clojure.core/let
   [bean2312
    (new com.amazonaws.services.ec2.model.CreateVpcEndpointRequest)]
   (clojure.core/let
    [v2314
     (:client-token m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setClientToken (clojure.core/str v2314))))
   (clojure.core/let
    [v2314 (:vpc-id m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setVpcId (clojure.core/str v2314))))
   (clojure.core/let
    [v2314
     (:service-name m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setServiceName (clojure.core/str v2314))))
   (clojure.core/let
    [v2314
     (:policy-document
      m2313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setPolicyDocument (clojure.core/str v2314))))
   (clojure.core/let
    [v2314
     (:route-table-ids
      m2313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (.
      bean2312
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2825] (clojure.core/str arg2825))
 v2314))))
   bean2312))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportKeyPairRequest}
import-key-pair-request
  [m2316]
  (clojure.core/let
   [bean2315
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/let
    [v2317
     (:public-key-material
      m2316
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2317 :com.palletops.awaze.client-builder/undef)
     (. bean2315 setPublicKeyMaterial (clojure.core/str v2317))))
   (clojure.core/let
    [v2317
     (:key-name m2316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2317 :com.palletops.awaze.client-builder/undef)
     (. bean2315 setKeyName (clojure.core/str v2317))))
   bean2315))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopySnapshotRequest}
copy-snapshot-request
  [m2319]
  (clojure.core/let
   [bean2318
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/let
    [v2320
     (:description m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setDescription (clojure.core/str v2320))))
   (clojure.core/let
    [v2320
     (:source-region m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setSourceRegion (clojure.core/str v2320))))
   (clojure.core/let
    [v2320
     (:encrypted m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setEncrypted (clojure.core/boolean v2320))))
   (clojure.core/let
    [v2320
     (:kms-key-id m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setKmsKeyId (clojure.core/str v2320))))
   (clojure.core/let
    [v2320
     (:source-snapshot-id
      m2319
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setSourceSnapshotId (clojure.core/str v2320))))
   (clojure.core/let
    [v2320
     (:destination-region
      m2319
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setDestinationRegion (clojure.core/str v2320))))
   (clojure.core/let
    [v2320
     (:presigned-url m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setPresignedUrl (clojure.core/str v2320))))
   bean2318))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m2322]
  (clojure.core/let
   [bean2321
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v2323
     (:snapshot-id m2322 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2323 :com.palletops.awaze.client-builder/undef)
     (. bean2321 setSnapshotId (clojure.core/str v2323))))
   bean2321))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeRequest}
reset-image-attribute-request
  [m2325]
  (clojure.core/let
   [bean2324
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/let
    [v2326
     (:attribute m2325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (. bean2324 setAttribute (clojure.core/str v2326))))
   (clojure.core/let
    [v2326
     (:image-id m2325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (. bean2324 setImageId (clojure.core/str v2326))))
   bean2324))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInternetGatewayRequest}
create-internet-gateway-request
  [m2328]
  (clojure.core/let
   [bean2327
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean2327))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MonitorInstancesRequest}
monitor-instances-request
  [m2331]
  (clojure.core/let
   [bean2330
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/let
    [v2332
     (:instance-ids m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (.
      bean2330
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2826] (clojure.core/str arg2826))
 v2332))))
   bean2330))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest}
revoke-security-group-egress-request
  [m2334]
  (clojure.core/let
   [bean2333
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2335
     (:group-id m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setGroupId (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:source-security-group-name
      m2334
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setSourceSecurityGroupName (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:source-security-group-owner-id
      m2334
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (.
      bean2333
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:ip-protocol m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setIpProtocol (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:from-port m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setFromPort (clojure.core/int v2335))))
   (clojure.core/let
    [v2335 (:to-port m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setToPort (clojure.core/int v2335))))
   (clojure.core/let
    [v2335 (:cidr-ip m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setCidrIp (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:ip-permissions m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (.
      bean2333
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2827] (ec2/ip-permission arg2827))
 v2335))))
   bean2333))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcsRequest}
describe-vpcs-request
  [m2337]
  (clojure.core/let
   [bean2336
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/let
    [v2338 (:filters m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (.
      bean2336
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2828] (ec2/filter arg2828))
 v2338))))
   (clojure.core/let
    [v2338 (:vpc-ids m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (.
      bean2336
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2829] (clojure.core/str arg2829))
 v2338))))
   bean2336))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceRequest}
import-instance-request
  [m2340]
  (clojure.core/let
   [bean2339
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/let
    [v2341
     (:platform m2340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2341 :com.palletops.awaze.client-builder/undef)
     (. bean2339 setPlatform (clojure.core/str v2341))))
   (clojure.core/let
    [v2341
     (:launch-specification
      m2340
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2341 :com.palletops.awaze.client-builder/undef)
     (.
      bean2339
      setLaunchSpecification
      (ec2/import-instance-launch-specification v2341))))
   (clojure.core/let
    [v2341
     (:disk-images m2340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2341 :com.palletops.awaze.client-builder/undef)
     (.
      bean2339
      setDiskImages
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2830] (ec2/disk-image arg2830))
 v2341))))
   (clojure.core/let
    [v2341
     (:description m2340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2341 :com.palletops.awaze.client-builder/undef)
     (. bean2339 setDescription (clojure.core/str v2341))))
   bean2339))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopyImageRequest}
copy-image-request
  [m2343]
  (clojure.core/let
   [bean2342 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/let
    [v2344
     (:client-token m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setClientToken (clojure.core/str v2344))))
   (clojure.core/let
    [v2344
     (:description m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setDescription (clojure.core/str v2344))))
   (clojure.core/let
    [v2344
     (:source-image-id
      m2343
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setSourceImageId (clojure.core/str v2344))))
   (clojure.core/let
    [v2344
     (:source-region m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setSourceRegion (clojure.core/str v2344))))
   (clojure.core/let
    [v2344
     (:encrypted m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setEncrypted (clojure.core/boolean v2344))))
   (clojure.core/let
    [v2344
     (:kms-key-id m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setKmsKeyId (clojure.core/str v2344))))
   (clojure.core/let
    [v2344 (:name m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setName (clojure.core/str v2344))))
   bean2342))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetConsoleOutputRequest}
get-console-output-request
  [m2346]
  (clojure.core/let
   [bean2345
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/let
    [v2347
     (:instance-id m2346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (. bean2345 setInstanceId (clojure.core/str v2347))))
   bean2345))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest}
modify-snapshot-attribute-request
  [m2349]
  (clojure.core/let
   [bean2348
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/let
    [v2350
     (:attribute m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setAttribute (clojure.core/str v2350))))
   (clojure.core/let
    [v2350
     (:operation-type m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setOperationType (ec2/operation-type v2350))))
   (clojure.core/let
    [v2350
     (:user-ids m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (.
      bean2348
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2831] (clojure.core/str arg2831))
 v2350))))
   (clojure.core/let
    [v2350
     (:create-volume-permission
      m2349
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (.
      bean2348
      setCreateVolumePermission
      (ec2/create-volume-permission-modifications v2350))))
   (clojure.core/let
    [v2350
     (:snapshot-id m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setSnapshotId (clojure.core/str v2350))))
   (clojure.core/let
    [v2350
     (:group-names m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (.
      bean2348
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2832] (clojure.core/str arg2832))
 v2350))))
   bean2348))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotFleetRequest}
request-spot-fleet-request
  [m2352]
  (clojure.core/let
   [bean2351
    (new com.amazonaws.services.ec2.model.RequestSpotFleetRequest)]
   (clojure.core/let
    [v2353
     (:spot-fleet-request-config
      m2352
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (.
      bean2351
      setSpotFleetRequestConfig
      (ec2/spot-fleet-request-config-data v2353))))
   bean2351))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest}
restore-address-to-classic-request
  [m2355]
  (clojure.core/let
   [bean2354
    (new
     com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest)]
   (clojure.core/let
    [v2356
     (:public-ip m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setPublicIp (clojure.core/str v2356))))
   bean2354))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest}
modify-subnet-attribute-request
  [m2358]
  (clojure.core/let
   [bean2357
    (new
     com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest)]
   (clojure.core/let
    [v2359
     (:map-public-ip-on-launch
      m2358
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setMapPublicIpOnLaunch (clojure.core/boolean v2359))))
   (clojure.core/let
    [v2359
     (:subnet-id m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setSubnetId (clojure.core/str v2359))))
   bean2357))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeConversionTasksRequest}
describe-conversion-tasks-request
  [m2361]
  (clojure.core/let
   [bean2360
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/let
    [v2362 (:filters m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (.
      bean2360
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2833] (ec2/filter arg2833))
 v2362))))
   (clojure.core/let
    [v2362
     (:conversion-task-ids
      m2361
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (.
      bean2360
      setConversionTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2834] (clojure.core/str arg2834))
 v2362))))
   bean2360))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest}
authorize-security-group-egress-request
  [m2364]
  (clojure.core/let
   [bean2363
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2365
     (:group-id m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setGroupId (clojure.core/str v2365))))
   (clojure.core/let
    [v2365
     (:source-security-group-name
      m2364
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setSourceSecurityGroupName (clojure.core/str v2365))))
   (clojure.core/let
    [v2365
     (:source-security-group-owner-id
      m2364
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2365))))
   (clojure.core/let
    [v2365
     (:ip-protocol m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setIpProtocol (clojure.core/str v2365))))
   (clojure.core/let
    [v2365
     (:from-port m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setFromPort (clojure.core/int v2365))))
   (clojure.core/let
    [v2365 (:to-port m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setToPort (clojure.core/int v2365))))
   (clojure.core/let
    [v2365 (:cidr-ip m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setCidrIp (clojure.core/str v2365))))
   (clojure.core/let
    [v2365
     (:ip-permissions m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2835] (ec2/ip-permission arg2835))
 v2365))))
   bean2363))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest}
authorize-security-group-ingress-request
  [m2367]
  (clojure.core/let
   [bean2366
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2368 (:cidr-ip m2367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setCidrIp (clojure.core/str v2368))))
   (clojure.core/let
    [v2368
     (:group-id m2367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setGroupId (clojure.core/str v2368))))
   (clojure.core/let
    [v2368 (:to-port m2367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setToPort (clojure.core/int v2368))))
   (clojure.core/let
    [v2368
     (:source-security-group-owner-id
      m2367
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (.
      bean2366
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2368))))
   (clojure.core/let
    [v2368
     (:ip-permissions m2367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (.
      bean2366
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2836] (ec2/ip-permission arg2836))
 v2368))))
   (clojure.core/let
    [v2368
     (:source-security-group-name
      m2367
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setSourceSecurityGroupName (clojure.core/str v2368))))
   (clojure.core/let
    [v2368
     (:group-name m2367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setGroupName (clojure.core/str v2368))))
   (clojure.core/let
    [v2368
     (:ip-protocol m2367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setIpProtocol (clojure.core/str v2368))))
   (clojure.core/let
    [v2368
     (:from-port m2367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setFromPort (clojure.core/int v2368))))
   bean2366))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAddressesRequest}
describe-addresses-request
  [m2370]
  (clojure.core/let
   [bean2369
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/let
    [v2371
     (:public-ips m2370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (.
      bean2369
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2837] (clojure.core/str arg2837))
 v2371))))
   (clojure.core/let
    [v2371 (:filters m2370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (.
      bean2369
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2838] (ec2/filter arg2838))
 v2371))))
   (clojure.core/let
    [v2371
     (:allocation-ids m2370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (.
      bean2369
      setAllocationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2839] (clojure.core/str arg2839))
 v2371))))
   bean2369))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest}
create-vpn-connection-route-request
  [m2373]
  (clojure.core/let
   [bean2372
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2374
     (:destination-cidr-block
      m2373
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (. bean2372 setDestinationCidrBlock (clojure.core/str v2374))))
   (clojure.core/let
    [v2374
     (:vpn-connection-id
      m2373
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (. bean2372 setVpnConnectionId (clojure.core/str v2374))))
   bean2372))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateAddressRequest}
associate-address-request
  [m2376]
  (clojure.core/let
   [bean2375
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/let
    [v2377
     (:network-interface-id
      m2376
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setNetworkInterfaceId (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:instance-id m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setInstanceId (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:public-ip m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setPublicIp (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:allocation-id m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setAllocationId (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:private-ip-address
      m2376
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setPrivateIpAddress (clojure.core/str v2377))))
   (clojure.core/let
    [v2377
     (:allow-reassociation
      m2376
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (. bean2375 setAllowReassociation (clojure.core/boolean v2377))))
   bean2375))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest}
create-instance-export-task-request
  [m2379]
  (clojure.core/let
   [bean2378
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/let
    [v2380
     (:instance-id m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setInstanceId (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:description m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setDescription (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:target-environment
      m2379
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setTargetEnvironment (ec2/export-environment v2380))))
   (clojure.core/let
    [v2380
     (:export-to-s3task
      m2379
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (.
      bean2378
      setExportToS3Task
      (ec2/export-to-s3task-specification v2380))))
   bean2378))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeKeyPairsRequest}
describe-key-pairs-request
  [m2382]
  (clojure.core/let
   [bean2381
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/let
    [v2383 (:filters m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (.
      bean2381
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2840] (ec2/filter arg2840))
 v2383))))
   (clojure.core/let
    [v2383
     (:key-names m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (.
      bean2381
      setKeyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2841] (clojure.core/str arg2841))
 v2383))))
   bean2381))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest}
describe-spot-fleet-requests-request
  [m2385]
  (clojure.core/let
   [bean2384
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2386
     (:spot-fleet-request-ids
      m2385
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (.
      bean2384
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2842] (clojure.core/str arg2842))
 v2386))))
   (clojure.core/let
    [v2386
     (:next-token m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (. bean2384 setNextToken (clojure.core/str v2386))))
   (clojure.core/let
    [v2386
     (:max-results m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (. bean2384 setMaxResults (clojure.core/int v2386))))
   bean2384))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImageAttributeRequest}
describe-image-attribute-request
  [m2388]
  (clojure.core/let
   [bean2387
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/let
    [v2389
     (:attribute m2388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setAttribute (clojure.core/str v2389))))
   (clojure.core/let
    [v2389
     (:image-id m2388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setImageId (clojure.core/str v2389))))
   bean2387))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest}
describe-moving-addresses-request
  [m2391]
  (clojure.core/let
   [bean2390
    (new
     com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest)]
   (clojure.core/let
    [v2392
     (:public-ips m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (.
      bean2390
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2843] (clojure.core/str arg2843))
 v2392))))
   (clojure.core/let
    [v2392 (:filters m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (.
      bean2390
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2844] (ec2/filter arg2844))
 v2392))))
   (clojure.core/let
    [v2392
     (:next-token m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setNextToken (clojure.core/str v2392))))
   (clojure.core/let
    [v2392
     (:max-results m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setMaxResults (clojure.core/int v2392))))
   bean2390))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclRequest}
delete-network-acl-request
  [m2394]
  (clojure.core/let
   [bean2393
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/let
    [v2395
     (:network-acl-id m2394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2395 :com.palletops.awaze.client-builder/undef)
     (. bean2393 setNetworkAclId (clojure.core/str v2395))))
   bean2393))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest}
delete-network-interface-request
  [m2397]
  (clojure.core/let
   [bean2396
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/let
    [v2398
     (:network-interface-id
      m2397
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2398 :com.palletops.awaze.client-builder/undef)
     (. bean2396 setNetworkInterfaceId (clojure.core/str v2398))))
   bean2396))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest}
delete-vpn-connection-request
  [m2400]
  (clojure.core/let
   [bean2399
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/let
    [v2401
     (:vpn-connection-id
      m2400
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (. bean2399 setVpnConnectionId (clojure.core/str v2401))))
   bean2399))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest}
purchase-scheduled-instances-request
  [m2403]
  (clojure.core/let
   [bean2402
    (new
     com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest)]
   (clojure.core/let
    [v2404
     (:purchase-requests
      m2403
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (.
      bean2402
      setPurchaseRequests
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2845] (ec2/purchase-request arg2845))
 v2404))))
   (clojure.core/let
    [v2404
     (:client-token m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (. bean2402 setClientToken (clojure.core/str v2404))))
   bean2402))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest}
describe-reserved-instances-modifications-request
  [m2406]
  (clojure.core/let
   [bean2405
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/let
    [v2407 (:filters m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (.
      bean2405
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2846] (ec2/filter arg2846))
 v2407))))
   (clojure.core/let
    [v2407
     (:next-token m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (. bean2405 setNextToken (clojure.core/str v2407))))
   (clojure.core/let
    [v2407
     (:reserved-instances-modification-ids
      m2406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (.
      bean2405
      setReservedInstancesModificationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2847] (clojure.core/str arg2847))
 v2407))))
   bean2405))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest}
describe-classic-link-instances-request
  [m2409]
  (clojure.core/let
   [bean2408
    (new
     com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest)]
   (clojure.core/let
    [v2410 (:filters m2409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2410 :com.palletops.awaze.client-builder/undef)
     (.
      bean2408
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2848] (ec2/filter arg2848))
 v2410))))
   (clojure.core/let
    [v2410
     (:instance-ids m2409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2410 :com.palletops.awaze.client-builder/undef)
     (.
      bean2408
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2849] (clojure.core/str arg2849))
 v2410))))
   (clojure.core/let
    [v2410
     (:next-token m2409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2410 :com.palletops.awaze.client-builder/undef)
     (. bean2408 setNextToken (clojure.core/str v2410))))
   (clojure.core/let
    [v2410
     (:max-results m2409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2410 :com.palletops.awaze.client-builder/undef)
     (. bean2408 setMaxResults (clojure.core/int v2410))))
   bean2408))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest}
purchase-reserved-instances-offering-request
  [m2412]
  (clojure.core/let
   [bean2411
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/let
    [v2413
     (:reserved-instances-offering-id
      m2412
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2413 :com.palletops.awaze.client-builder/undef)
     (.
      bean2411
      setReservedInstancesOfferingId
      (clojure.core/str v2413))))
   (clojure.core/let
    [v2413
     (:limit-price m2412 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2413 :com.palletops.awaze.client-builder/undef)
     (.
      bean2411
      setLimitPrice
      (ec2/reserved-instance-limit-price v2413))))
   (clojure.core/let
    [v2413
     (:instance-count m2412 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2413 :com.palletops.awaze.client-builder/undef)
     (. bean2411 setInstanceCount (clojure.core/int v2413))))
   bean2411))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StartInstancesRequest}
start-instances-request
  [m2415]
  (clojure.core/let
   [bean2414
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/let
    [v2416
     (:additional-info
      m2415
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2416 :com.palletops.awaze.client-builder/undef)
     (. bean2414 setAdditionalInfo (clojure.core/str v2416))))
   (clojure.core/let
    [v2416
     (:instance-ids m2415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2416 :com.palletops.awaze.client-builder/undef)
     (.
      bean2414
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2850] (clojure.core/str arg2850))
 v2416))))
   bean2414))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest}
describe-instance-attribute-request
  [m2418]
  (clojure.core/let
   [bean2417
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/let
    [v2419
     (:attribute m2418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (. bean2417 setAttribute (clojure.core/str v2419))))
   (clojure.core/let
    [v2419
     (:instance-id m2418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (. bean2417 setInstanceId (clojure.core/str v2419))))
   bean2417))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest}
cancel-spot-fleet-requests-request
  [m2421]
  (clojure.core/let
   [bean2420
    (new
     com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2422
     (:spot-fleet-request-ids
      m2421
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (.
      bean2420
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2851] (clojure.core/str arg2851))
 v2422))))
   (clojure.core/let
    [v2422
     (:terminate-instances
      m2421
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setTerminateInstances (clojure.core/boolean v2422))))
   bean2420))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSubnetsRequest}
describe-subnets-request
  [m2424]
  (clojure.core/let
   [bean2423
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/let
    [v2425 (:filters m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (.
      bean2423
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2852] (ec2/filter arg2852))
 v2425))))
   (clojure.core/let
    [v2425
     (:subnet-ids m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (.
      bean2423
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2853] (clojure.core/str arg2853))
 v2425))))
   bean2423))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumeRequest}
create-volume-request
  [m2427]
  (clojure.core/let
   [bean2426
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/let
    [v2428
     (:availability-zone
      m2427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setAvailabilityZone (clojure.core/str v2428))))
   (clojure.core/let
    [v2428
     (:encrypted m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setEncrypted (clojure.core/boolean v2428))))
   (clojure.core/let
    [v2428
     (:kms-key-id m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setKmsKeyId (clojure.core/str v2428))))
   (clojure.core/let
    [v2428
     (:snapshot-id m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setSnapshotId (clojure.core/str v2428))))
   (clojure.core/let
    [v2428
     (:volume-type m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setVolumeType (ec2/volume-type v2428))))
   (clojure.core/let
    [v2428 (:iops m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setIops (clojure.core/int v2428))))
   (clojure.core/let
    [v2428 (:size m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setSize (clojure.core/int v2428))))
   bean2426))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest}
describe-reserved-instances-listings-request
  [m2430]
  (clojure.core/let
   [bean2429
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/let
    [v2431
     (:reserved-instances-listing-id
      m2430
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (.
      bean2429
      setReservedInstancesListingId
      (clojure.core/str v2431))))
   (clojure.core/let
    [v2431
     (:reserved-instances-id
      m2430
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (. bean2429 setReservedInstancesId (clojure.core/str v2431))))
   (clojure.core/let
    [v2431 (:filters m2430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (.
      bean2429
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2854] (ec2/filter arg2854))
 v2431))))
   bean2429))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest}
create-dhcp-options-request
  [m2433]
  (clojure.core/let
   [bean2432
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/let
    [v2434
     (:dhcp-configurations
      m2433
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2434 :com.palletops.awaze.client-builder/undef)
     (.
      bean2432
      setDhcpConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2855] (ec2/dhcp-configuration arg2855))
 v2434))))
   bean2432))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachInternetGatewayRequest}
detach-internet-gateway-request
  [m2436]
  (clojure.core/let
   [bean2435
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/let
    [v2437 (:vpc-id m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setVpcId (clojure.core/str v2437))))
   (clojure.core/let
    [v2437
     (:internet-gateway-id
      m2436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setInternetGatewayId (clojure.core/str v2437))))
   bean2435))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest}
delete-vpn-gateway-request
  [m2439]
  (clojure.core/let
   [bean2438
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/let
    [v2440
     (:vpn-gateway-id m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setVpnGatewayId (clojure.core/str v2440))))
   bean2438))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotInstancesRequest}
request-spot-instances-request
  [m2442]
  (clojure.core/let
   [bean2441
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/let
    [v2443
     (:spot-price m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setSpotPrice (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:valid-from m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (.
      bean2441
      setValidFrom
      (com.palletops.awaze.common/to-date v2443))))
   (clojure.core/let
    [v2443
     (:block-duration-minutes
      m2442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setBlockDurationMinutes (clojure.core/int v2443))))
   (clojure.core/let
    [v2443 (:type m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setType (ec2/spot-instance-type v2443))))
   (clojure.core/let
    [v2443
     (:client-token m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setClientToken (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:launch-group m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setLaunchGroup (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:instance-count m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setInstanceCount (clojure.core/int v2443))))
   (clojure.core/let
    [v2443
     (:launch-specification
      m2442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (.
      bean2441
      setLaunchSpecification
      (ec2/launch-specification v2443))))
   (clojure.core/let
    [v2443
     (:valid-until m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (.
      bean2441
      setValidUntil
      (com.palletops.awaze.common/to-date v2443))))
   (clojure.core/let
    [v2443
     (:availability-zone-group
      m2442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setAvailabilityZoneGroup (clojure.core/str v2443))))
   bean2441))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportVolumeRequest}
import-volume-request
  [m2445]
  (clojure.core/let
   [bean2444
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/let
    [v2446 (:image m2445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (. bean2444 setImage (ec2/disk-image-detail v2446))))
   (clojure.core/let
    [v2446 (:volume m2445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (. bean2444 setVolume (ec2/volume-detail v2446))))
   (clojure.core/let
    [v2446
     (:availability-zone
      m2445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (. bean2444 setAvailabilityZone (clojure.core/str v2446))))
   (clojure.core/let
    [v2446
     (:description m2445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (. bean2444 setDescription (clojure.core/str v2446))))
   bean2444))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportSnapshotRequest}
import-snapshot-request
  [m2448]
  (clojure.core/let
   [bean2447
    (new com.amazonaws.services.ec2.model.ImportSnapshotRequest)]
   (clojure.core/let
    [v2449
     (:client-data m2448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (. bean2447 setClientData (ec2/client-data v2449))))
   (clojure.core/let
    [v2449
     (:disk-container m2448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (. bean2447 setDiskContainer (ec2/snapshot-disk-container v2449))))
   (clojure.core/let
    [v2449
     (:role-name m2448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (. bean2447 setRoleName (clojure.core/str v2449))))
   (clojure.core/let
    [v2449
     (:client-token m2448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (. bean2447 setClientToken (clojure.core/str v2449))))
   (clojure.core/let
    [v2449
     (:description m2448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (. bean2447 setDescription (clojure.core/str v2449))))
   bean2447))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeTagsRequest}
describe-tags-request
  [m2451]
  (clojure.core/let
   [bean2450
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/let
    [v2452 (:filters m2451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2452 :com.palletops.awaze.client-builder/undef)
     (.
      bean2450
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2856] (ec2/filter arg2856))
 v2452))))
   (clojure.core/let
    [v2452
     (:next-token m2451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2452 :com.palletops.awaze.client-builder/undef)
     (. bean2450 setNextToken (clojure.core/str v2452))))
   (clojure.core/let
    [v2452
     (:max-results m2451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2452 :com.palletops.awaze.client-builder/undef)
     (. bean2450 setMaxResults (clojure.core/int v2452))))
   bean2450))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteTagsRequest}
delete-tags-request
  [m2454]
  (clojure.core/let
   [bean2453 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/let
    [v2455
     (:resources m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (.
      bean2453
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2857] (clojure.core/str arg2857))
 v2455))))
   (clojure.core/let
    [v2455 (:tags m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (.
      bean2453
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2858] (ec2/tag arg2858)) v2455))))
   bean2453))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest}
enable-vpc-classic-link-request
  [m2457]
  (clojure.core/let
   [bean2456
    (new com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2458 (:vpc-id m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setVpcId (clojure.core/str v2458))))
   bean2456))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest}
describe-reserved-instances-offerings-request
  [m2460]
  (clojure.core/let
   [bean2459
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/let
    [v2461
     (:include-marketplace
      m2460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setIncludeMarketplace (clojure.core/boolean v2461))))
   (clojure.core/let
    [v2461
     (:reserved-instances-offering-ids
      m2460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (.
      bean2459
      setReservedInstancesOfferingIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2859] (clojure.core/str arg2859))
 v2461))))
   (clojure.core/let
    [v2461
     (:product-description
      m2460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (.
      bean2459
      setProductDescription
      (ec2/riproduct-description v2461))))
   (clojure.core/let
    [v2461
     (:availability-zone
      m2460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setAvailabilityZone (clojure.core/str v2461))))
   (clojure.core/let
    [v2461
     (:min-duration m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setMinDuration (clojure.core/long v2461))))
   (clojure.core/let
    [v2461
     (:instance-type m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setInstanceType (ec2/instance-type v2461))))
   (clojure.core/let
    [v2461 (:filters m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (.
      bean2459
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2860] (ec2/filter arg2860))
 v2461))))
   (clojure.core/let
    [v2461
     (:offering-type m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setOfferingType (clojure.core/str v2461))))
   (clojure.core/let
    [v2461
     (:instance-tenancy
      m2460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setInstanceTenancy (clojure.core/str v2461))))
   (clojure.core/let
    [v2461
     (:max-duration m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setMaxDuration (clojure.core/long v2461))))
   (clojure.core/let
    [v2461
     (:next-token m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setNextToken (clojure.core/str v2461))))
   (clojure.core/let
    [v2461
     (:max-results m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setMaxResults (clojure.core/int v2461))))
   (clojure.core/let
    [v2461
     (:max-instance-count
      m2460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setMaxInstanceCount (clojure.core/int v2461))))
   bean2459))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnGatewayRequest}
create-vpn-gateway-request
  [m2463]
  (clojure.core/let
   [bean2462
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/let
    [v2464
     (:availability-zone
      m2463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setAvailabilityZone (clojure.core/str v2464))))
   (clojure.core/let
    [v2464 (:type m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setType (ec2/gateway-type v2464))))
   bean2462))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRouteTablesRequest}
describe-route-tables-request
  [m2466]
  (clojure.core/let
   [bean2465
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/let
    [v2467
     (:route-table-ids
      m2466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (.
      bean2465
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2861] (clojure.core/str arg2861))
 v2467))))
   (clojure.core/let
    [v2467 (:filters m2466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (.
      bean2465
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2862] (ec2/filter arg2862))
 v2467))))
   bean2465))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest}
cancel-spot-instance-requests-request
  [m2469]
  (clojure.core/let
   [bean2468
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2470
     (:spot-instance-request-ids
      m2469
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2470 :com.palletops.awaze.client-builder/undef)
     (.
      bean2468
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2863] (clojure.core/str arg2863))
 v2470))))
   bean2468))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest}
assign-private-ip-addresses-request
  [m2472]
  (clojure.core/let
   [bean2471
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2473
     (:network-interface-id
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setNetworkInterfaceId (clojure.core/str v2473))))
   (clojure.core/let
    [v2473
     (:private-ip-addresses
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (.
      bean2471
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2864] (clojure.core/str arg2864))
 v2473))))
   (clojure.core/let
    [v2473
     (:secondary-private-ip-address-count
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (.
      bean2471
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2473))))
   (clojure.core/let
    [v2473
     (:allow-reassignment
      m2472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setAllowReassignment (clojure.core/boolean v2473))))
   bean2471))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest}
disable-vpc-classic-link-dns-support-request
  [m2475]
  (clojure.core/let
   [bean2474
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2476 (:vpc-id m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setVpcId (clojure.core/str v2476))))
   bean2474))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeletePlacementGroupRequest}
delete-placement-group-request
  [m2478]
  (clojure.core/let
   [bean2477
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/let
    [v2479
     (:group-name m2478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (. bean2477 setGroupName (clojure.core/str v2479))))
   bean2477))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstancesRequest}
describe-instances-request
  [m2481]
  (clojure.core/let
   [bean2480
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/let
    [v2482 (:filters m2481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (.
      bean2480
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2865] (ec2/filter arg2865))
 v2482))))
   (clojure.core/let
    [v2482
     (:instance-ids m2481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (.
      bean2480
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2866] (clojure.core/str arg2866))
 v2482))))
   (clojure.core/let
    [v2482
     (:next-token m2481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (. bean2480 setNextToken (clojure.core/str v2482))))
   (clojure.core/let
    [v2482
     (:max-results m2481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (. bean2480 setMaxResults (clojure.core/int v2482))))
   bean2480))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumesRequest}
describe-volumes-request
  [m2484]
  (clojure.core/let
   [bean2483
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/let
    [v2485 (:filters m2484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (.
      bean2483
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2867] (ec2/filter arg2867))
 v2485))))
   (clojure.core/let
    [v2485
     (:next-token m2484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (. bean2483 setNextToken (clojure.core/str v2485))))
   (clojure.core/let
    [v2485
     (:max-results m2484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (. bean2483 setMaxResults (clojure.core/int v2485))))
   (clojure.core/let
    [v2485
     (:volume-ids m2484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (.
      bean2483
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2868] (clojure.core/str arg2868))
 v2485))))
   bean2483))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeBundleTasksRequest}
describe-bundle-tasks-request
  [m2487]
  (clojure.core/let
   [bean2486
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/let
    [v2488 (:filters m2487 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (.
      bean2486
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2869] (ec2/filter arg2869))
 v2488))))
   (clojure.core/let
    [v2488
     (:bundle-ids m2487 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (.
      bean2486
      setBundleIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2870] (clojure.core/str arg2870))
 v2488))))
   bean2486))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest}
associate-dhcp-options-request
  [m2490]
  (clojure.core/let
   [bean2489
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/let
    [v2491 (:vpc-id m2490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setVpcId (clojure.core/str v2491))))
   (clojure.core/let
    [v2491
     (:dhcp-options-id
      m2490
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setDhcpOptionsId (clojure.core/str v2491))))
   bean2489))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest}
modify-vpc-attribute-request
  [m2493]
  (clojure.core/let
   [bean2492
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/let
    [v2494
     (:enable-dns-support
      m2493
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (. bean2492 setEnableDnsSupport (clojure.core/boolean v2494))))
   (clojure.core/let
    [v2494
     (:enable-dns-hostnames
      m2493
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (. bean2492 setEnableDnsHostnames (clojure.core/boolean v2494))))
   (clojure.core/let
    [v2494 (:vpc-id m2493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (. bean2492 setVpcId (clojure.core/str v2494))))
   bean2492))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateFlowLogsRequest}
create-flow-logs-request
  [m2496]
  (clojure.core/let
   [bean2495
    (new com.amazonaws.services.ec2.model.CreateFlowLogsRequest)]
   (clojure.core/let
    [v2497
     (:client-token m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setClientToken (clojure.core/str v2497))))
   (clojure.core/let
    [v2497
     (:resource-ids m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (.
      bean2495
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2871] (clojure.core/str arg2871))
 v2497))))
   (clojure.core/let
    [v2497
     (:resource-type m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setResourceType (ec2/flow-logs-resource-type v2497))))
   (clojure.core/let
    [v2497
     (:traffic-type m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setTrafficType (clojure.core/str v2497))))
   (clojure.core/let
    [v2497
     (:log-group-name m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setLogGroupName (clojure.core/str v2497))))
   (clojure.core/let
    [v2497
     (:deliver-logs-permission-arn
      m2496
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setDeliverLogsPermissionArn (clojure.core/str v2497))))
   bean2495))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateAddressRequest}
disassociate-address-request
  [m2499]
  (clojure.core/let
   [bean2498
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/let
    [v2500
     (:association-id m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (. bean2498 setAssociationId (clojure.core/str v2500))))
   (clojure.core/let
    [v2500
     (:public-ip m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (. bean2498 setPublicIp (clojure.core/str v2500))))
   bean2498))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest}
reset-network-interface-attribute-request
  [m2502]
  (clojure.core/let
   [bean2501
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2503
     (:source-dest-check
      m2502
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2503 :com.palletops.awaze.client-builder/undef)
     (. bean2501 setSourceDestCheck (clojure.core/str v2503))))
   (clojure.core/let
    [v2503
     (:network-interface-id
      m2502
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2503 :com.palletops.awaze.client-builder/undef)
     (. bean2501 setNetworkInterfaceId (clojure.core/str v2503))))
   bean2501))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest}
describe-placement-groups-request
  [m2505]
  (clojure.core/let
   [bean2504
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/let
    [v2506 (:filters m2505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (.
      bean2504
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2872] (ec2/filter arg2872))
 v2506))))
   (clojure.core/let
    [v2506
     (:group-names m2505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (.
      bean2504
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2873] (clojure.core/str arg2873))
 v2506))))
   bean2504))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest}
reset-snapshot-attribute-request
  [m2508]
  (clojure.core/let
   [bean2507
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/let
    [v2509
     (:attribute m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setAttribute (clojure.core/str v2509))))
   (clojure.core/let
    [v2509
     (:snapshot-id m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setSnapshotId (clojure.core/str v2509))))
   bean2507))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseAddressRequest}
release-address-request
  [m2511]
  (clojure.core/let
   [bean2510
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/let
    [v2512
     (:public-ip m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setPublicIp (clojure.core/str v2512))))
   (clojure.core/let
    [v2512
     (:allocation-id m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setAllocationId (clojure.core/str v2512))))
   bean2510))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest}
describe-volume-status-request
  [m2514]
  (clojure.core/let
   [bean2513
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/let
    [v2515 (:filters m2514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (.
      bean2513
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2874] (ec2/filter arg2874))
 v2515))))
   (clojure.core/let
    [v2515
     (:next-token m2514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (. bean2513 setNextToken (clojure.core/str v2515))))
   (clojure.core/let
    [v2515
     (:max-results m2514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (. bean2513 setMaxResults (clojure.core/int v2515))))
   (clojure.core/let
    [v2515
     (:volume-ids m2514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (.
      bean2513
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2875] (clojure.core/str arg2875))
 v2515))))
   bean2513))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BundleInstanceRequest}
bundle-instance-request
  [m2517]
  (clojure.core/let
   [bean2516
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/let
    [v2518
     (:instance-id m2517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setInstanceId (clojure.core/str v2518))))
   (clojure.core/let
    [v2518 (:storage m2517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setStorage (ec2/storage v2518))))
   bean2516))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest}
describe-vpn-connections-request
  [m2520]
  (clojure.core/let
   [bean2519
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/let
    [v2521
     (:vpn-connection-ids
      m2520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setVpnConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2876] (clojure.core/str arg2876))
 v2521))))
   (clojure.core/let
    [v2521 (:filters m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2877] (ec2/filter arg2877))
 v2521))))
   bean2519))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteRequest}
create-route-request
  [m2523]
  (clojure.core/let
   [bean2522
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/let
    [v2524
     (:route-table-id m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setRouteTableId (clojure.core/str v2524))))
   (clojure.core/let
    [v2524
     (:vpc-peering-connection-id
      m2523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setVpcPeeringConnectionId (clojure.core/str v2524))))
   (clojure.core/let
    [v2524
     (:network-interface-id
      m2523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setNetworkInterfaceId (clojure.core/str v2524))))
   (clojure.core/let
    [v2524
     (:instance-id m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setInstanceId (clojure.core/str v2524))))
   (clojure.core/let
    [v2524
     (:destination-cidr-block
      m2523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setDestinationCidrBlock (clojure.core/str v2524))))
   (clojure.core/let
    [v2524
     (:gateway-id m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setGatewayId (clojure.core/str v2524))))
   (clojure.core/let
    [v2524
     (:nat-gateway-id m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setNatGatewayId (clojure.core/str v2524))))
   bean2522))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest}
describe-spot-price-history-request
  [m2526]
  (clojure.core/let
   [bean2525
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/let
    [v2527
     (:availability-zone
      m2526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setAvailabilityZone (clojure.core/str v2527))))
   (clojure.core/let
    [v2527 (:filters m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (.
      bean2525
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2878] (ec2/filter arg2878))
 v2527))))
   (clojure.core/let
    [v2527
     (:next-token m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setNextToken (clojure.core/str v2527))))
   (clojure.core/let
    [v2527
     (:max-results m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setMaxResults (clojure.core/int v2527))))
   (clojure.core/let
    [v2527
     (:start-time m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (.
      bean2525
      setStartTime
      (com.palletops.awaze.common/to-date v2527))))
   (clojure.core/let
    [v2527
     (:end-time m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (.
      bean2525
      setEndTime
      (com.palletops.awaze.common/to-date v2527))))
   (clojure.core/let
    [v2527
     (:instance-types m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (.
      bean2525
      setInstanceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2879] (clojure.core/str arg2879))
 v2527))))
   (clojure.core/let
    [v2527
     (:product-descriptions
      m2526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (.
      bean2525
      setProductDescriptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2880] (clojure.core/str arg2880))
 v2527))))
   bean2525))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest}
describe-availability-zones-request
  [m2529]
  (clojure.core/let
   [bean2528
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/let
    [v2530 (:filters m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (.
      bean2528
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2881] (ec2/filter arg2881))
 v2530))))
   (clojure.core/let
    [v2530
     (:zone-names m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (.
      bean2528
      setZoneNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2882] (clojure.core/str arg2882))
 v2530))))
   bean2528))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest}
create-vpc-peering-connection-request
  [m2532]
  (clojure.core/let
   [bean2531
    (new
     com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2533 (:vpc-id m2532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2533 :com.palletops.awaze.client-builder/undef)
     (. bean2531 setVpcId (clojure.core/str v2533))))
   (clojure.core/let
    [v2533
     (:peer-vpc-id m2532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2533 :com.palletops.awaze.client-builder/undef)
     (. bean2531 setPeerVpcId (clojure.core/str v2533))))
   (clojure.core/let
    [v2533
     (:peer-owner-id m2532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2533 :com.palletops.awaze.client-builder/undef)
     (. bean2531 setPeerOwnerId (clojure.core/str v2533))))
   bean2531))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest}
describe-internet-gateways-request
  [m2535]
  (clojure.core/let
   [bean2534
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/let
    [v2536 (:filters m2535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (.
      bean2534
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2883] (ec2/filter arg2883))
 v2536))))
   (clojure.core/let
    [v2536
     (:internet-gateway-ids
      m2535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (.
      bean2534
      setInternetGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2884] (clojure.core/str arg2884))
 v2536))))
   bean2534))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateRouteTableRequest}
disassociate-route-table-request
  [m2538]
  (clojure.core/let
   [bean2537
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/let
    [v2539
     (:association-id m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setAssociationId (clojure.core/str v2539))))
   bean2537))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRegionsRequest}
describe-regions-request
  [m2541]
  (clojure.core/let
   [bean2540
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/let
    [v2542 (:filters m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2885] (ec2/filter arg2885))
 v2542))))
   (clojure.core/let
    [v2542
     (:region-names m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setRegionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2886] (clojure.core/str arg2886))
 v2542))))
   bean2540))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest}
enable-vpc-classic-link-dns-support-request
  [m2544]
  (clojure.core/let
   [bean2543
    (new
     com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2545 (:vpc-id m2544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2545 :com.palletops.awaze.client-builder/undef)
     (. bean2543 setVpcId (clojure.core/str v2545))))
   bean2543))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeregisterImageRequest}
deregister-image-request
  [m2547]
  (clojure.core/let
   [bean2546
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/let
    [v2548
     (:image-id m2547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2548 :com.palletops.awaze.client-builder/undef)
     (. bean2546 setImageId (clojure.core/str v2548))))
   bean2546))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest}
delete-spot-datafeed-subscription-request
  [m2550]
  (clojure.core/let
   [bean2549
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean2549))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest}
describe-customer-gateways-request
  [m2553]
  (clojure.core/let
   [bean2552
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/let
    [v2554 (:filters m2553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2554 :com.palletops.awaze.client-builder/undef)
     (.
      bean2552
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2887] (ec2/filter arg2887))
 v2554))))
   (clojure.core/let
    [v2554
     (:customer-gateway-ids
      m2553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2554 :com.palletops.awaze.client-builder/undef)
     (.
      bean2552
      setCustomerGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2888] (clojure.core/str arg2888))
 v2554))))
   bean2552))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest}
describe-spot-fleet-request-history-request
  [m2556]
  (clojure.core/let
   [bean2555
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest)]
   (clojure.core/let
    [v2557
     (:next-token m2556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (. bean2555 setNextToken (clojure.core/str v2557))))
   (clojure.core/let
    [v2557
     (:max-results m2556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (. bean2555 setMaxResults (clojure.core/int v2557))))
   (clojure.core/let
    [v2557
     (:spot-fleet-request-id
      m2556
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (. bean2555 setSpotFleetRequestId (clojure.core/str v2557))))
   (clojure.core/let
    [v2557
     (:start-time m2556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (.
      bean2555
      setStartTime
      (com.palletops.awaze.common/to-date v2557))))
   (clojure.core/let
    [v2557
     (:event-type m2556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (. bean2555 setEventType (ec2/event-type v2557))))
   bean2555))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSubnetRequest}
create-subnet-request
  [m2559]
  (clojure.core/let
   [bean2558
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/let
    [v2560
     (:availability-zone
      m2559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setAvailabilityZone (clojure.core/str v2560))))
   (clojure.core/let
    [v2560 (:vpc-id m2559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setVpcId (clojure.core/str v2560))))
   (clojure.core/let
    [v2560
     (:cidr-block m2559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setCidrBlock (clojure.core/str v2560))))
   bean2558))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest}
describe-network-interface-attribute-request
  [m2562]
  (clojure.core/let
   [bean2561
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2563
     (:attribute m2562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2563 :com.palletops.awaze.client-builder/undef)
     (. bean2561 setAttribute (clojure.core/str v2563))))
   (clojure.core/let
    [v2563
     (:network-interface-id
      m2562
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2563 :com.palletops.awaze.client-builder/undef)
     (. bean2561 setNetworkInterfaceId (clojure.core/str v2563))))
   bean2561))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest}
modify-instance-placement-request
  [m2565]
  (clojure.core/let
   [bean2564
    (new
     com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest)]
   (clojure.core/let
    [v2566 (:tenancy m2565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2566 :com.palletops.awaze.client-builder/undef)
     (. bean2564 setTenancy (ec2/host-tenancy v2566))))
   (clojure.core/let
    [v2566
     (:affinity m2565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2566 :com.palletops.awaze.client-builder/undef)
     (. bean2564 setAffinity (ec2/affinity v2566))))
   (clojure.core/let
    [v2566 (:host-id m2565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2566 :com.palletops.awaze.client-builder/undef)
     (. bean2564 setHostId (clojure.core/str v2566))))
   (clojure.core/let
    [v2566
     (:instance-id m2565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2566 :com.palletops.awaze.client-builder/undef)
     (. bean2564 setInstanceId (clojure.core/str v2566))))
   bean2564))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest}
detach-classic-link-vpc-request
  [m2568]
  (clojure.core/let
   [bean2567
    (new com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2569 (:vpc-id m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setVpcId (clojure.core/str v2569))))
   (clojure.core/let
    [v2569
     (:instance-id m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setInstanceId (clojure.core/str v2569))))
   bean2567))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelConversionTaskRequest}
cancel-conversion-task-request
  [m2571]
  (clojure.core/let
   [bean2570
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/let
    [v2572
     (:conversion-task-id
      m2571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setConversionTaskId (clojure.core/str v2572))))
   (clojure.core/let
    [v2572
     (:reason-message m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setReasonMessage (clojure.core/str v2572))))
   bean2570))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest}
create-network-interface-request
  [m2574]
  (clojure.core/let
   [bean2573
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/let
    [v2575
     (:subnet-id m2574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setSubnetId (clojure.core/str v2575))))
   (clojure.core/let
    [v2575
     (:private-ip-addresses
      m2574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (.
      bean2573
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2889]
  (ec2/private-ip-address-specification arg2889))
 v2575))))
   (clojure.core/let
    [v2575
     (:secondary-private-ip-address-count
      m2574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (.
      bean2573
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2575))))
   (clojure.core/let
    [v2575
     (:private-ip-address
      m2574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setPrivateIpAddress (clojure.core/str v2575))))
   (clojure.core/let
    [v2575 (:groups m2574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (.
      bean2573
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2890] (clojure.core/str arg2890))
 v2575))))
   (clojure.core/let
    [v2575
     (:description m2574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setDescription (clojure.core/str v2575))))
   bean2573))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyImageAttributeRequest}
modify-image-attribute-request
  [m2577]
  (clojure.core/let
   [bean2576
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/let
    [v2578
     (:description m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setDescription (clojure.core/str v2578))))
   (clojure.core/let
    [v2578
     (:operation-type m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setOperationType (clojure.core/str v2578))))
   (clojure.core/let
    [v2578
     (:product-codes m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (.
      bean2576
      setProductCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2891] (clojure.core/str arg2891))
 v2578))))
   (clojure.core/let
    [v2578
     (:user-ids m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (.
      bean2576
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2892] (clojure.core/str arg2892))
 v2578))))
   (clojure.core/let
    [v2578
     (:attribute m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setAttribute (clojure.core/str v2578))))
   (clojure.core/let
    [v2578
     (:image-id m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setImageId (clojure.core/str v2578))))
   (clojure.core/let
    [v2578
     (:launch-permission
      m2577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (.
      bean2576
      setLaunchPermission
      (ec2/launch-permission-modifications v2578))))
   (clojure.core/let
    [v2578 (:value m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setValue (clojure.core/str v2578))))
   (clojure.core/let
    [v2578
     (:user-groups m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (.
      bean2576
      setUserGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2893] (clojure.core/str arg2893))
 v2578))))
   bean2576))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteTableRequest}
delete-route-table-request
  [m2580]
  (clojure.core/let
   [bean2579
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/let
    [v2581
     (:route-table-id m2580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2581 :com.palletops.awaze.client-builder/undef)
     (. bean2579 setRouteTableId (clojure.core/str v2581))))
   bean2579))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateRouteTableRequest}
associate-route-table-request
  [m2583]
  (clojure.core/let
   [bean2582
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/let
    [v2584
     (:route-table-id m2583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2584 :com.palletops.awaze.client-builder/undef)
     (. bean2582 setRouteTableId (clojure.core/str v2584))))
   (clojure.core/let
    [v2584
     (:subnet-id m2583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2584 :com.palletops.awaze.client-builder/undef)
     (. bean2582 setSubnetId (clojure.core/str v2584))))
   bean2582))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest}
delete-customer-gateway-request
  [m2586]
  (clojure.core/let
   [bean2585
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/let
    [v2587
     (:customer-gateway-id
      m2586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (. bean2585 setCustomerGatewayId (clojure.core/str v2587))))
   bean2585))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest}
replace-route-table-association-request
  [m2589]
  (clojure.core/let
   [bean2588
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/let
    [v2590
     (:association-id m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setAssociationId (clojure.core/str v2590))))
   (clojure.core/let
    [v2590
     (:route-table-id m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setRouteTableId (clojure.core/str v2590))))
   bean2588))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcRequest}
delete-vpc-request
  [m2592]
  (clojure.core/let
   [bean2591 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/let
    [v2593 (:vpc-id m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setVpcId (clojure.core/str v2593))))
   bean2591))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateKeyPairRequest}
create-key-pair-request
  [m2595]
  (clojure.core/let
   [bean2594
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/let
    [v2596
     (:key-name m2595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setKeyName (clojure.core/str v2596))))
   bean2594))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateHostsRequest}
allocate-hosts-request
  [m2598]
  (clojure.core/let
   [bean2597
    (new com.amazonaws.services.ec2.model.AllocateHostsRequest)]
   (clojure.core/let
    [v2599
     (:client-token m2598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (. bean2597 setClientToken (clojure.core/str v2599))))
   (clojure.core/let
    [v2599
     (:instance-type m2598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (. bean2597 setInstanceType (clojure.core/str v2599))))
   (clojure.core/let
    [v2599
     (:availability-zone
      m2598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (. bean2597 setAvailabilityZone (clojure.core/str v2599))))
   (clojure.core/let
    [v2599
     (:quantity m2598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (. bean2597 setQuantity (clojure.core/int v2599))))
   (clojure.core/let
    [v2599
     (:auto-placement m2598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (. bean2597 setAutoPlacement (ec2/auto-placement v2599))))
   bean2597))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteRequest}
replace-route-request
  [m2601]
  (clojure.core/let
   [bean2600
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/let
    [v2602
     (:route-table-id m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setRouteTableId (clojure.core/str v2602))))
   (clojure.core/let
    [v2602
     (:vpc-peering-connection-id
      m2601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setVpcPeeringConnectionId (clojure.core/str v2602))))
   (clojure.core/let
    [v2602
     (:network-interface-id
      m2601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setNetworkInterfaceId (clojure.core/str v2602))))
   (clojure.core/let
    [v2602
     (:instance-id m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setInstanceId (clojure.core/str v2602))))
   (clojure.core/let
    [v2602
     (:destination-cidr-block
      m2601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setDestinationCidrBlock (clojure.core/str v2602))))
   (clojure.core/let
    [v2602
     (:gateway-id m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setGatewayId (clojure.core/str v2602))))
   (clojure.core/let
    [v2602
     (:nat-gateway-id m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setNatGatewayId (clojure.core/str v2602))))
   bean2600))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TerminateInstancesRequest}
terminate-instances-request
  [m2604]
  (clojure.core/let
   [bean2603
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/let
    [v2605
     (:instance-ids m2604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2605 :com.palletops.awaze.client-builder/undef)
     (.
      bean2603
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2894] (clojure.core/str arg2894))
 v2605))))
   bean2603))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m2607]
  (clojure.core/let
   [bean2606
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v2608 (:filters m2607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (.
      bean2606
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2895] (ec2/filter arg2895))
 v2608))))
   (clojure.core/let
    [v2608
     (:next-token m2607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (. bean2606 setNextToken (clojure.core/str v2608))))
   (clojure.core/let
    [v2608
     (:max-results m2607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (. bean2606 setMaxResults (clojure.core/int v2608))))
   (clojure.core/let
    [v2608
     (:snapshot-ids m2607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (.
      bean2606
      setSnapshotIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2896] (clojure.core/str arg2896))
 v2608))))
   (clojure.core/let
    [v2608
     (:owner-ids m2607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (.
      bean2606
      setOwnerIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2897] (clojure.core/str arg2897))
 v2608))))
   (clojure.core/let
    [v2608
     (:restorable-by-user-ids
      m2607
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (.
      bean2606
      setRestorableByUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2898] (clojure.core/str arg2898))
 v2608))))
   bean2606))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest}
describe-vpn-gateways-request
  [m2610]
  (clojure.core/let
   [bean2609
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/let
    [v2611
     (:vpn-gateway-ids
      m2610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (.
      bean2609
      setVpnGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2899] (clojure.core/str arg2899))
 v2611))))
   (clojure.core/let
    [v2611 (:filters m2610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (.
      bean2609
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2900] (ec2/filter arg2900))
 v2611))))
   bean2609))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetPasswordDataRequest}
get-password-data-request
  [m2613]
  (clojure.core/let
   [bean2612
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/let
    [v2614
     (:instance-id m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setInstanceId (clojure.core/str v2614))))
   bean2612))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest}
modify-volume-attribute-request
  [m2616]
  (clojure.core/let
   [bean2615
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/let
    [v2617
     (:auto-enable-io m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setAutoEnableIO (clojure.core/boolean v2617))))
   (clojure.core/let
    [v2617
     (:volume-id m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setVolumeId (clojure.core/str v2617))))
   bean2615))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest}
disable-vgw-route-propagation-request
  [m2619]
  (clojure.core/let
   [bean2618
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2620
     (:route-table-id m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (. bean2618 setRouteTableId (clojure.core/str v2620))))
   (clojure.core/let
    [v2620
     (:gateway-id m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (. bean2618 setGatewayId (clojure.core/str v2620))))
   bean2618))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest}
describe-spot-fleet-instances-request
  [m2622]
  (clojure.core/let
   [bean2621
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest)]
   (clojure.core/let
    [v2623
     (:next-token m2622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (. bean2621 setNextToken (clojure.core/str v2623))))
   (clojure.core/let
    [v2623
     (:max-results m2622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (. bean2621 setMaxResults (clojure.core/int v2623))))
   (clojure.core/let
    [v2623
     (:spot-fleet-request-id
      m2622
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (. bean2621 setSpotFleetRequestId (clojure.core/str v2623))))
   bean2621))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePrefixListsRequest}
describe-prefix-lists-request
  [m2625]
  (clojure.core/let
   [bean2624
    (new com.amazonaws.services.ec2.model.DescribePrefixListsRequest)]
   (clojure.core/let
    [v2626 (:filters m2625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (.
      bean2624
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2901] (ec2/filter arg2901))
 v2626))))
   (clojure.core/let
    [v2626
     (:next-token m2625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (. bean2624 setNextToken (clojure.core/str v2626))))
   (clojure.core/let
    [v2626
     (:max-results m2625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (. bean2624 setMaxResults (clojure.core/int v2626))))
   (clojure.core/let
    [v2626
     (:prefix-list-ids
      m2625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (.
      bean2624
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2902] (clojure.core/str arg2902))
 v2626))))
   bean2624))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m2628]
  (clojure.core/let
   [bean2627
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/let
    [v2629
     (:attribute-names
      m2628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2629 :com.palletops.awaze.client-builder/undef)
     (.
      bean2627
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2903] (clojure.core/str arg2903))
 v2629))))
   bean2627))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRequest}
create-vpn-connection-request
  [m2631]
  (clojure.core/let
   [bean2630
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/let
    [v2632
     (:vpn-gateway-id m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setVpnGatewayId (clojure.core/str v2632))))
   (clojure.core/let
    [v2632 (:type m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setType (clojure.core/str v2632))))
   (clojure.core/let
    [v2632 (:options m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (.
      bean2630
      setOptions
      (ec2/vpn-connection-options-specification v2632))))
   (clojure.core/let
    [v2632
     (:customer-gateway-id
      m2631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setCustomerGatewayId (clojure.core/str v2632))))
   bean2630))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest}
describe-vpc-peering-connections-request
  [m2634]
  (clojure.core/let
   [bean2633
    (new
     com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest)]
   (clojure.core/let
    [v2635
     (:vpc-peering-connection-ids
      m2634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (.
      bean2633
      setVpcPeeringConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2904] (clojure.core/str arg2904))
 v2635))))
   (clojure.core/let
    [v2635 (:filters m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (.
      bean2633
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2905] (ec2/filter arg2905))
 v2635))))
   bean2633))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest}
describe-scheduled-instance-availability-request
  [m2637]
  (clojure.core/let
   [bean2636
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest)]
   (clojure.core/let
    [v2638 (:filters m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (.
      bean2636
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2906] (ec2/filter arg2906))
 v2638))))
   (clojure.core/let
    [v2638
     (:next-token m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setNextToken (clojure.core/str v2638))))
   (clojure.core/let
    [v2638
     (:max-results m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setMaxResults (clojure.core/int v2638))))
   (clojure.core/let
    [v2638
     (:recurrence m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (.
      bean2636
      setRecurrence
      (ec2/scheduled-instance-recurrence-request v2638))))
   (clojure.core/let
    [v2638
     (:first-slot-start-time-range
      m2637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (.
      bean2636
      setFirstSlotStartTimeRange
      (ec2/slot-date-time-range-request v2638))))
   (clojure.core/let
    [v2638
     (:min-slot-duration-in-hours
      m2637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setMinSlotDurationInHours (clojure.core/int v2638))))
   (clojure.core/let
    [v2638
     (:max-slot-duration-in-hours
      m2637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setMaxSlotDurationInHours (clojure.core/int v2638))))
   bean2636))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeFlowLogsRequest}
describe-flow-logs-request
  [m2640]
  (clojure.core/let
   [bean2639
    (new com.amazonaws.services.ec2.model.DescribeFlowLogsRequest)]
   (clojure.core/let
    [v2641
     (:flow-log-ids m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (.
      bean2639
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2907] (clojure.core/str arg2907))
 v2641))))
   (clojure.core/let
    [v2641
     (:next-token m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (. bean2639 setNextToken (clojure.core/str v2641))))
   (clojure.core/let
    [v2641
     (:max-results m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (. bean2639 setMaxResults (clojure.core/int v2641))))
   (clojure.core/let
    [v2641 (:filter m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (.
      bean2639
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2908] (ec2/filter arg2908))
 v2641))))
   bean2639))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelBundleTaskRequest}
cancel-bundle-task-request
  [m2643]
  (clojure.core/let
   [bean2642
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/let
    [v2644
     (:bundle-id m2643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2644 :com.palletops.awaze.client-builder/undef)
     (. bean2642 setBundleId (clojure.core/str v2644))))
   bean2642))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest}
describe-reserved-instances-request
  [m2646]
  (clojure.core/let
   [bean2645
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/let
    [v2647 (:filters m2646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (.
      bean2645
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2909] (ec2/filter arg2909))
 v2647))))
   (clojure.core/let
    [v2647
     (:reserved-instances-ids
      m2646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (.
      bean2645
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2910] (clojure.core/str arg2910))
 v2647))))
   (clojure.core/let
    [v2647
     (:offering-type m2646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (. bean2645 setOfferingType (ec2/offering-type-values v2647))))
   bean2645))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnmonitorInstancesRequest}
unmonitor-instances-request
  [m2649]
  (clojure.core/let
   [bean2648
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/let
    [v2650
     (:instance-ids m2649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (.
      bean2648
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2911] (clojure.core/str arg2911))
 v2650))))
   bean2648))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest}
delete-security-group-request
  [m2652]
  (clojure.core/let
   [bean2651
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/let
    [v2653
     (:group-id m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setGroupId (clojure.core/str v2653))))
   (clojure.core/let
    [v2653
     (:group-name m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setGroupName (clojure.core/str v2653))))
   bean2651))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest}
describe-vpc-attribute-request
  [m2655]
  (clojure.core/let
   [bean2654
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/let
    [v2656
     (:attribute m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (. bean2654 setAttribute (clojure.core/str v2656))))
   (clojure.core/let
    [v2656 (:vpc-id m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (. bean2654 setVpcId (clojure.core/str v2656))))
   bean2654))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclRequest}
create-network-acl-request
  [m2658]
  (clojure.core/let
   [bean2657
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/let
    [v2659 (:vpc-id m2658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2659 :com.palletops.awaze.client-builder/undef)
     (. bean2657 setVpcId (clojure.core/str v2659))))
   bean2657))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelImportTaskRequest}
cancel-import-task-request
  [m2661]
  (clojure.core/let
   [bean2660
    (new com.amazonaws.services.ec2.model.CancelImportTaskRequest)]
   (clojure.core/let
    [v2662
     (:import-task-id m2661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2662 :com.palletops.awaze.client-builder/undef)
     (. bean2660 setImportTaskId (clojure.core/str v2662))))
   (clojure.core/let
    [v2662
     (:cancel-reason m2661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2662 :com.palletops.awaze.client-builder/undef)
     (. bean2660 setCancelReason (clojure.core/str v2662))))
   bean2660))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest}
accept-vpc-peering-connection-request
  [m2664]
  (clojure.core/let
   [bean2663
    (new
     com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2665
     (:vpc-peering-connection-id
      m2664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2665 :com.palletops.awaze.client-builder/undef)
     (. bean2663 setVpcPeeringConnectionId (clojure.core/str v2665))))
   bean2663))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest}
describe-vpc-endpoint-services-request
  [m2667]
  (clojure.core/let
   [bean2666
    (new
     com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest)]
   (clojure.core/let
    [v2668
     (:next-token m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setNextToken (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:max-results m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setMaxResults (clojure.core/int v2668))))
   bean2666))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest}
delete-vpc-peering-connection-request
  [m2670]
  (clojure.core/let
   [bean2669
    (new
     com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2671
     (:vpc-peering-connection-id
      m2670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (. bean2669 setVpcPeeringConnectionId (clojure.core/str v2671))))
   bean2669))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunInstancesRequest}
run-instances-request
  [m2673]
  (clojure.core/let
   [bean2672
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/let
    [v2674
     (:iam-instance-profile
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (.
      bean2672
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2674))))
   (clojure.core/let
    [v2674
     (:max-count m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setMaxCount (clojure.core/int v2674))))
   (clojure.core/let
    [v2674
     (:subnet-id m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setSubnetId (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:additional-info
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setAdditionalInfo (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:security-group-ids
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (.
      bean2672
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2912] (clojure.core/str arg2912))
 v2674))))
   (clojure.core/let
    [v2674
     (:placement m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setPlacement (ec2/placement v2674))))
   (clojure.core/let
    [v2674
     (:private-ip-address
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setPrivateIpAddress (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:client-token m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setClientToken (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:instance-type m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setInstanceType (ec2/instance-type v2674))))
   (clojure.core/let
    [v2674
     (:ebs-optimized m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setEbsOptimized (clojure.core/boolean v2674))))
   (clojure.core/let
    [v2674
     (:ramdisk-id m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setRamdiskId (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:instance-initiated-shutdown-behavior
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (.
      bean2672
      setInstanceInitiatedShutdownBehavior
      (ec2/shutdown-behavior v2674))))
   (clojure.core/let
    [v2674
     (:disable-api-termination
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (.
      bean2672
      setDisableApiTermination
      (clojure.core/boolean v2674))))
   (clojure.core/let
    [v2674
     (:image-id m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setImageId (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:key-name m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setKeyName (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:min-count m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setMinCount (clojure.core/int v2674))))
   (clojure.core/let
    [v2674
     (:kernel-id m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setKernelId (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:monitoring m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setMonitoring (clojure.core/boolean v2674))))
   (clojure.core/let
    [v2674
     (:security-groups
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (.
      bean2672
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2913] (clojure.core/str arg2913))
 v2674))))
   (clojure.core/let
    [v2674
     (:block-device-mappings
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (.
      bean2672
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2914] (ec2/block-device-mapping arg2914))
 v2674))))
   (clojure.core/let
    [v2674
     (:user-data m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setUserData (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:network-interfaces
      m2673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (.
      bean2672
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2915]
  (ec2/instance-network-interface-specification arg2915))
 v2674))))
   bean2672))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest}
describe-instance-status-request
  [m2676]
  (clojure.core/let
   [bean2675
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/let
    [v2677 (:filters m2676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (.
      bean2675
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2916] (ec2/filter arg2916))
 v2677))))
   (clojure.core/let
    [v2677
     (:instance-ids m2676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (.
      bean2675
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2917] (clojure.core/str arg2917))
 v2677))))
   (clojure.core/let
    [v2677
     (:next-token m2676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (. bean2675 setNextToken (clojure.core/str v2677))))
   (clojure.core/let
    [v2677
     (:max-results m2676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (. bean2675 setMaxResults (clojure.core/int v2677))))
   (clojure.core/let
    [v2677
     (:include-all-instances
      m2676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (. bean2675 setIncludeAllInstances (clojure.core/boolean v2677))))
   bean2675))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest}
describe-vpc-classic-link-dns-support-request
  [m2679]
  (clojure.core/let
   [bean2678
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2680
     (:next-token m2679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (. bean2678 setNextToken (clojure.core/str v2680))))
   (clojure.core/let
    [v2680
     (:max-results m2679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (. bean2678 setMaxResults (clojure.core/int v2680))))
   (clojure.core/let
    [v2680 (:vpc-ids m2679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (.
      bean2678
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2918] (clojure.core/str arg2918))
 v2680))))
   bean2678))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest}
unassign-private-ip-addresses-request
  [m2682]
  (clojure.core/let
   [bean2681
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2683
     (:network-interface-id
      m2682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2683 :com.palletops.awaze.client-builder/undef)
     (. bean2681 setNetworkInterfaceId (clojure.core/str v2683))))
   (clojure.core/let
    [v2683
     (:private-ip-addresses
      m2682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2683 :com.palletops.awaze.client-builder/undef)
     (.
      bean2681
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2919] (clojure.core/str arg2919))
 v2683))))
   bean2681))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest}
describe-security-groups-request
  [m2685]
  (clojure.core/let
   [bean2684
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/let
    [v2686 (:filters m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2920] (ec2/filter arg2920))
 v2686))))
   (clojure.core/let
    [v2686
     (:group-names m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2921] (clojure.core/str arg2921))
 v2686))))
   (clojure.core/let
    [v2686
     (:group-ids m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (.
      bean2684
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2922] (clojure.core/str arg2922))
 v2686))))
   bean2684))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest}
describe-network-interfaces-request
  [m2688]
  (clojure.core/let
   [bean2687
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/let
    [v2689 (:filters m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2923] (ec2/filter arg2923))
 v2689))))
   (clojure.core/let
    [v2689
     (:network-interface-ids
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setNetworkInterfaceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2924] (clojure.core/str arg2924))
 v2689))))
   bean2687))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest}
create-customer-gateway-request
  [m2691]
  (clojure.core/let
   [bean2690
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/let
    [v2692
     (:public-ip m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (. bean2690 setPublicIp (clojure.core/str v2692))))
   (clojure.core/let
    [v2692 (:type m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (. bean2690 setType (ec2/gateway-type v2692))))
   (clojure.core/let
    [v2692 (:bgp-asn m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (. bean2690 setBgpAsn (clojure.core/int v2692))))
   bean2690))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest}
describe-dhcp-options-request
  [m2694]
  (clojure.core/let
   [bean2693
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/let
    [v2695 (:filters m2694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (.
      bean2693
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2925] (ec2/filter arg2925))
 v2695))))
   (clojure.core/let
    [v2695
     (:dhcp-options-ids
      m2694
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (.
      bean2693
      setDhcpOptionsIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2926] (clojure.core/str arg2926))
 v2695))))
   bean2693))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateTagsRequest}
create-tags-request
  [m2697]
  (clojure.core/let
   [bean2696 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/let
    [v2698
     (:resources m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (.
      bean2696
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2927] (clojure.core/str arg2927))
 v2698))))
   (clojure.core/let
    [v2698 (:tags m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (.
      bean2696
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2928] (ec2/tag arg2928)) v2698))))
   bean2696))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSnapshotRequest}
create-snapshot-request
  [m2700]
  (clojure.core/let
   [bean2699
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v2701
     (:volume-id m2700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2701 :com.palletops.awaze.client-builder/undef)
     (. bean2699 setVolumeId (clojure.core/str v2701))))
   (clojure.core/let
    [v2701
     (:description m2700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2701 :com.palletops.awaze.client-builder/undef)
     (. bean2699 setDescription (clojure.core/str v2701))))
   bean2699))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportImageRequest}
import-image-request
  [m2703]
  (clojure.core/let
   [bean2702
    (new com.amazonaws.services.ec2.model.ImportImageRequest)]
   (clojure.core/let
    [v2704
     (:description m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setDescription (clojure.core/str v2704))))
   (clojure.core/let
    [v2704
     (:disk-containers
      m2703
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (.
      bean2702
      setDiskContainers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2929] (ec2/image-disk-container arg2929))
 v2704))))
   (clojure.core/let
    [v2704
     (:client-data m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setClientData (ec2/client-data v2704))))
   (clojure.core/let
    [v2704
     (:client-token m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setClientToken (clojure.core/str v2704))))
   (clojure.core/let
    [v2704
     (:role-name m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setRoleName (clojure.core/str v2704))))
   (clojure.core/let
    [v2704
     (:hypervisor m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setHypervisor (clojure.core/str v2704))))
   (clojure.core/let
    [v2704
     (:platform m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setPlatform (clojure.core/str v2704))))
   (clojure.core/let
    [v2704
     (:license-type m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setLicenseType (clojure.core/str v2704))))
   (clojure.core/let
    [v2704
     (:architecture m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setArchitecture (clojure.core/str v2704))))
   bean2702))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteTableRequest}
create-route-table-request
  [m2706]
  (clojure.core/let
   [bean2705
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/let
    [v2707 (:vpc-id m2706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2707 :com.palletops.awaze.client-builder/undef)
     (. bean2705 setVpcId (clojure.core/str v2707))))
   bean2705))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeHostsRequest}
describe-hosts-request
  [m2709]
  (clojure.core/let
   [bean2708
    (new com.amazonaws.services.ec2.model.DescribeHostsRequest)]
   (clojure.core/let
    [v2710
     (:next-token m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (. bean2708 setNextToken (clojure.core/str v2710))))
   (clojure.core/let
    [v2710
     (:max-results m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (. bean2708 setMaxResults (clojure.core/int v2710))))
   (clojure.core/let
    [v2710
     (:host-ids m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (.
      bean2708
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2930] (clojure.core/str arg2930))
 v2710))))
   (clojure.core/let
    [v2710 (:filter m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (.
      bean2708
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2931] (ec2/filter arg2931))
 v2710))))
   bean2708))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest}
describe-volume-attribute-request
  [m2712]
  (clojure.core/let
   [bean2711
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/let
    [v2713
     (:attribute m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setAttribute (clojure.core/str v2713))))
   (clojure.core/let
    [v2713
     (:volume-id m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setVolumeId (clojure.core/str v2713))))
   bean2711))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyIdFormatRequest}
modify-id-format-request
  [m2715]
  (clojure.core/let
   [bean2714
    (new com.amazonaws.services.ec2.model.ModifyIdFormatRequest)]
   (clojure.core/let
    [v2716
     (:use-long-ids m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setUseLongIds (clojure.core/boolean v2716))))
   (clojure.core/let
    [v2716
     (:resource m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setResource (clojure.core/str v2716))))
   bean2714))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest}
create-network-acl-entry-request
  [m2718]
  (clojure.core/let
   [bean2717
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/let
    [v2719
     (:protocol m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setProtocol (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:network-acl-id m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setNetworkAclId (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:rule-number m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setRuleNumber (clojure.core/int v2719))))
   (clojure.core/let
    [v2719
     (:rule-action m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setRuleAction (clojure.core/str v2719))))
   (clojure.core/let
    [v2719 (:egress m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setEgress (clojure.core/boolean v2719))))
   (clojure.core/let
    [v2719
     (:cidr-block m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setCidrBlock (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:icmp-type-code m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setIcmpTypeCode (ec2/icmp-type-code v2719))))
   (clojure.core/let
    [v2719
     (:port-range m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setPortRange (ec2/port-range v2719))))
   bean2717))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest}
describe-nat-gateways-request
  [m2721]
  (clojure.core/let
   [bean2720
    (new com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest)]
   (clojure.core/let
    [v2722
     (:next-token m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (. bean2720 setNextToken (clojure.core/str v2722))))
   (clojure.core/let
    [v2722
     (:max-results m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (. bean2720 setMaxResults (clojure.core/int v2722))))
   (clojure.core/let
    [v2722 (:filter m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (.
      bean2720
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2932] (ec2/filter arg2932))
 v2722))))
   (clojure.core/let
    [v2722
     (:nat-gateway-ids
      m2721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (.
      bean2720
      setNatGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2933] (clojure.core/str arg2933))
 v2722))))
   bean2720))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest}
cancel-reserved-instances-listing-request
  [m2724]
  (clojure.core/let
   [bean2723
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/let
    [v2725
     (:reserved-instances-listing-id
      m2724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (.
      bean2723
      setReservedInstancesListingId
      (clojure.core/str v2725))))
   bean2723))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest}
disable-vpc-classic-link-request
  [m2727]
  (clojure.core/let
   [bean2726
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2728 (:vpc-id m2727 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2728 :com.palletops.awaze.client-builder/undef)
     (. bean2726 setVpcId (clojure.core/str v2728))))
   bean2726))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunScheduledInstancesRequest}
run-scheduled-instances-request
  [m2730]
  (clojure.core/let
   [bean2729
    (new
     com.amazonaws.services.ec2.model.RunScheduledInstancesRequest)]
   (clojure.core/let
    [v2731
     (:launch-specification
      m2730
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (.
      bean2729
      setLaunchSpecification
      (ec2/scheduled-instances-launch-specification v2731))))
   (clojure.core/let
    [v2731
     (:scheduled-instance-id
      m2730
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setScheduledInstanceId (clojure.core/str v2731))))
   (clojure.core/let
    [v2731
     (:client-token m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setClientToken (clojure.core/str v2731))))
   (clojure.core/let
    [v2731
     (:instance-count m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setInstanceCount (clojure.core/int v2731))))
   bean2729))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteKeyPairRequest}
delete-key-pair-request
  [m2733]
  (clojure.core/let
   [bean2732
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/let
    [v2734
     (:key-name m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setKeyName (clojure.core/str v2734))))
   bean2732))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest}
modify-reserved-instances-request
  [m2736]
  (clojure.core/let
   [bean2735
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/let
    [v2737
     (:target-configurations
      m2736
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (.
      bean2735
      setTargetConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2934]
  (ec2/reserved-instances-configuration arg2934))
 v2737))))
   (clojure.core/let
    [v2737
     (:client-token m2736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (. bean2735 setClientToken (clojure.core/str v2737))))
   (clojure.core/let
    [v2737
     (:reserved-instances-ids
      m2736
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (.
      bean2735
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2935] (clojure.core/str arg2935))
 v2737))))
   bean2735))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest}
delete-vpn-connection-route-request
  [m2739]
  (clojure.core/let
   [bean2738
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2740
     (:destination-cidr-block
      m2739
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (. bean2738 setDestinationCidrBlock (clojure.core/str v2740))))
   (clojure.core/let
    [v2740
     (:vpn-connection-id
      m2739
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (. bean2738 setVpnConnectionId (clojure.core/str v2740))))
   bean2738))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachInternetGatewayRequest}
attach-internet-gateway-request
  [m2742]
  (clojure.core/let
   [bean2741
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/let
    [v2743 (:vpc-id m2742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (. bean2741 setVpcId (clojure.core/str v2743))))
   (clojure.core/let
    [v2743
     (:internet-gateway-id
      m2742
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (. bean2741 setInternetGatewayId (clojure.core/str v2743))))
   bean2741))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest}
modify-network-interface-attribute-request
  [m2745]
  (clojure.core/let
   [bean2744
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2746
     (:source-dest-check
      m2745
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setSourceDestCheck (clojure.core/boolean v2746))))
   (clojure.core/let
    [v2746
     (:attachment m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (.
      bean2744
      setAttachment
      (ec2/network-interface-attachment-changes v2746))))
   (clojure.core/let
    [v2746
     (:network-interface-id
      m2745
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setNetworkInterfaceId (clojure.core/str v2746))))
   (clojure.core/let
    [v2746 (:groups m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (.
      bean2744
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2936] (clojure.core/str arg2936))
 v2746))))
   (clojure.core/let
    [v2746
     (:description m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setDescription (clojure.core/str v2746))))
   bean2744))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest}
enable-vgw-route-propagation-request
  [m2748]
  (clojure.core/let
   [bean2747
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2749
     (:route-table-id m2748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2749 :com.palletops.awaze.client-builder/undef)
     (. bean2747 setRouteTableId (clojure.core/str v2749))))
   (clojure.core/let
    [v2749
     (:gateway-id m2748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2749 :com.palletops.awaze.client-builder/undef)
     (. bean2747 setGatewayId (clojure.core/str v2749))))
   bean2747))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest}
delete-network-acl-entry-request
  [m2751]
  (clojure.core/let
   [bean2750
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/let
    [v2752
     (:network-acl-id m2751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setNetworkAclId (clojure.core/str v2752))))
   (clojure.core/let
    [v2752
     (:rule-number m2751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setRuleNumber (clojure.core/int v2752))))
   (clojure.core/let
    [v2752 (:egress m2751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setEgress (clojure.core/boolean v2752))))
   bean2750))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelExportTaskRequest}
cancel-export-task-request
  [m2754]
  (clojure.core/let
   [bean2753
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/let
    [v2755
     (:export-task-id m2754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2755 :com.palletops.awaze.client-builder/undef)
     (. bean2753 setExportTaskId (clojure.core/str v2755))))
   bean2753))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateImageRequest}
create-image-request
  [m2757]
  (clojure.core/let
   [bean2756
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/let
    [v2758
     (:instance-id m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setInstanceId (clojure.core/str v2758))))
   (clojure.core/let
    [v2758
     (:description m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setDescription (clojure.core/str v2758))))
   (clojure.core/let
    [v2758
     (:no-reboot m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setNoReboot (clojure.core/boolean v2758))))
   (clojure.core/let
    [v2758
     (:block-device-mappings
      m2757
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (.
      bean2756
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3041] (ec2/block-device-mapping arg3041))
 v2758))))
   (clojure.core/let
    [v2758 (:name m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setName (clojure.core/str v2758))))
   bean2756))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest}
modify-spot-fleet-request-request
  [m2760]
  (clojure.core/let
   [bean2759
    (new
     com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest)]
   (clojure.core/let
    [v2761
     (:target-capacity
      m2760
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (. bean2759 setTargetCapacity (clojure.core/int v2761))))
   (clojure.core/let
    [v2761
     (:excess-capacity-termination-policy
      m2760
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (.
      bean2759
      setExcessCapacityTerminationPolicy
      (clojure.core/str v2761))))
   (clojure.core/let
    [v2761
     (:spot-fleet-request-id
      m2760
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (. bean2759 setSpotFleetRequestId (clojure.core/str v2761))))
   bean2759))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest}
describe-import-snapshot-tasks-request
  [m2763]
  (clojure.core/let
   [bean2762
    (new
     com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest)]
   (clojure.core/let
    [v2764 (:filters m2763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (.
      bean2762
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3042] (ec2/filter arg3042))
 v2764))))
   (clojure.core/let
    [v2764
     (:next-token m2763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (. bean2762 setNextToken (clojure.core/str v2764))))
   (clojure.core/let
    [v2764
     (:max-results m2763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (. bean2762 setMaxResults (clojure.core/int v2764))))
   (clojure.core/let
    [v2764
     (:import-task-ids
      m2763
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (.
      bean2762
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3043] (clojure.core/str arg3043))
 v2764))))
   bean2762))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-endpoints
   [m2937]
   (clojure.core/let
    [credentials2938 (:credentials m2937) args2939 (:args m2937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2940
      (com.palletops.awaze.common/aws-client :ec2 credentials2938)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2940
       deleteVpcEndpoints
       (ec2/delete-vpc-endpoints-request
        (clojure.core/nth args2939 0)))))))
  (clojure.core/defn
   delete-vpc-endpoints-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Generate map for deleteVpcEndpoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-endpoints
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Call deleteVpcEndpoints"}
   [credentials2942 & args2943]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2944
     (com.palletops.awaze.common/aws-client :ec2 credentials2942)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2944
      deleteVpcEndpoints
      (ec2/delete-vpc-endpoints-request (clojure.core/nth args2943 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-nat-gateway
   [m2945]
   (clojure.core/let
    [credentials2946 (:credentials m2945) args2947 (:args m2945)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2948
      (com.palletops.awaze.common/aws-client :ec2 credentials2946)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2948
       createNatGateway
       (ec2/create-nat-gateway-request (clojure.core/nth args2947 0)))))))
  (clojure.core/defn
   create-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createNatGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-nat-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createNatGateway"}
   [credentials2950 & args2951]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2952
     (com.palletops.awaze.common/aws-client :ec2 credentials2950)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2952
      createNatGateway
      (ec2/create-nat-gateway-request (clojure.core/nth args2951 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m2953]
   (clojure.core/let
    [credentials2954 (:credentials m2953) args2955 (:args m2953)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2956
      (com.palletops.awaze.common/aws-client :ec2 credentials2954)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2956
       stopInstances
       (ec2/stop-instances-request (clojure.core/nth args2955 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :stop-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call stopInstances"}
   [credentials2958 & args2959]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2960
     (com.palletops.awaze.common/aws-client :ec2 credentials2958)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2960
      stopInstances
      (ec2/stop-instances-request (clojure.core/nth args2959 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m2961]
   (clojure.core/let
    [credentials2962 (:credentials m2961) args2963 (:args m2961)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2964
      (com.palletops.awaze.common/aws-client :ec2 credentials2962)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2964
       createPlacementGroup
       (ec2/create-placement-group-request
        (clojure.core/nth args2963 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-placement-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPlacementGroup"}
   [credentials2966 & args2967]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2968
     (com.palletops.awaze.common/aws-client :ec2 credentials2966)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2968
      createPlacementGroup
      (ec2/create-placement-group-request
       (clojure.core/nth args2967 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m2969]
   (clojure.core/let
    [credentials2970 (:credentials m2969) args2971 (:args m2969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2972
      (com.palletops.awaze.common/aws-client :ec2 credentials2970)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2972
       createReservedInstancesListing
       (ec2/create-reserved-instances-listing-request
        (clojure.core/nth args2971 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-reserved-instances-listing,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials2974 & args2975]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2976
     (com.palletops.awaze.common/aws-client :ec2 credentials2974)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2976
      createReservedInstancesListing
      (ec2/create-reserved-instances-listing-request
       (clojure.core/nth args2975 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-hosts
   [m2977]
   (clojure.core/let
    [credentials2978 (:credentials m2977) args2979 (:args m2977)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2980
      (com.palletops.awaze.common/aws-client :ec2 credentials2978)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2980
       releaseHosts
       (ec2/release-hosts-request (clojure.core/nth args2979 0)))))))
  (clojure.core/defn
   release-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for releaseHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :release-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call releaseHosts"}
   [credentials2982 & args2983]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2984
     (com.palletops.awaze.common/aws-client :ec2 credentials2982)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2984
      releaseHosts
      (ec2/release-hosts-request (clojure.core/nth args2983 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m2985]
   (clojure.core/let
    [credentials2986 (:credentials m2985) args2987 (:args m2985)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2988
      (com.palletops.awaze.common/aws-client :ec2 credentials2986)]
     (clojure.core/case
      (clojure.core/count args2987)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2988
        revokeSecurityGroupIngress
        (ec2/revoke-security-group-ingress-request
         (clojure.core/nth args2987 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2988
        revokeSecurityGroupIngress))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]
                [credentials]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials2990 & args2991]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2992
     (com.palletops.awaze.common/aws-client :ec2 credentials2990)]
    (clojure.core/case
     (clojure.core/count args2991)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2992
       revokeSecurityGroupIngress
       (ec2/revoke-security-group-ingress-request
        (clojure.core/nth args2991 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2992
       revokeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-classic-link-vpc
   [m2993]
   (clojure.core/let
    [credentials2994 (:credentials m2993) args2995 (:args m2993)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2996
      (com.palletops.awaze.common/aws-client :ec2 credentials2994)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2996
       attachClassicLinkVpc
       (ec2/attach-classic-link-vpc-request
        (clojure.core/nth args2995 0)))))))
  (clojure.core/defn
   attach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Generate map for attachClassicLinkVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-classic-link-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Call attachClassicLinkVpc"}
   [credentials2998 & args2999]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3000
     (com.palletops.awaze.common/aws-client :ec2 credentials2998)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3000
      attachClassicLinkVpc
      (ec2/attach-classic-link-vpc-request
       (clojure.core/nth args2999 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m3001]
   (clojure.core/let
    [credentials3002 (:credentials m3001) args3003 (:args m3001)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3004
      (com.palletops.awaze.common/aws-client :ec2 credentials3002)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3004
       replaceNetworkAclAssociation
       (ec2/replace-network-acl-association-request
        (clojure.core/nth args3003 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-network-acl-association,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials3006 & args3007]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3008
     (com.palletops.awaze.common/aws-client :ec2 credentials3006)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3008
      replaceNetworkAclAssociation
      (ec2/replace-network-acl-association-request
       (clojure.core/nth args3007 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-nat-gateway
   [m3009]
   (clojure.core/let
    [credentials3010 (:credentials m3009) args3011 (:args m3009)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3012
      (com.palletops.awaze.common/aws-client :ec2 credentials3010)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3012
       deleteNatGateway
       (ec2/delete-nat-gateway-request (clojure.core/nth args3011 0)))))))
  (clojure.core/defn
   delete-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNatGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-nat-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNatGateway"}
   [credentials3014 & args3015]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3016
     (com.palletops.awaze.common/aws-client :ec2 credentials3014)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3016
      deleteNatGateway
      (ec2/delete-nat-gateway-request (clojure.core/nth args3015 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m3017]
   (clojure.core/let
    [credentials3018 (:credentials m3017) args3019 (:args m3017)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3020
      (com.palletops.awaze.common/aws-client :ec2 credentials3018)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3020
       modifyInstanceAttribute
       (ec2/modify-instance-attribute-request
        (clojure.core/nth args3019 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials3022 & args3023]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3024
     (com.palletops.awaze.common/aws-client :ec2 credentials3022)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3024
      modifyInstanceAttribute
      (ec2/modify-instance-attribute-request
       (clojure.core/nth args3023 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m3025]
   (clojure.core/let
    [credentials3026 (:credentials m3025) args3027 (:args m3025)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3028
      (com.palletops.awaze.common/aws-client :ec2 credentials3026)]
     (clojure.core/case
      (clojure.core/count args3027)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3028
        describeNetworkAcls))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3028
        describeNetworkAcls
        (ec2/describe-network-acls-request
         (clojure.core/nth args3027 0))))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-network-acls,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-acls,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials3030 & args3031]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3032
     (com.palletops.awaze.common/aws-client :ec2 credentials3030)]
    (clojure.core/case
     (clojure.core/count args3031)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3032
       describeNetworkAcls))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3032
       describeNetworkAcls
       (ec2/describe-network-acls-request
        (clojure.core/nth args3031 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m3033]
   (clojure.core/let
    [credentials3034 (:credentials m3033) args3035 (:args m3033)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3036
      (com.palletops.awaze.common/aws-client :ec2 credentials3034)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3036
       reportInstanceStatus
       (ec2/report-instance-status-request
        (clojure.core/nth args3035 0)))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportInstanceStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportInstanceStatus"}
   [credentials3038 & args3039]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3040
     (com.palletops.awaze.common/aws-client :ec2 credentials3038)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3040
      reportInstanceStatus
      (ec2/report-instance-status-request
       (clojure.core/nth args3039 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m3044]
   (clojure.core/let
    [credentials3045 (:credentials m3044) args3046 (:args m3044)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3047
      (com.palletops.awaze.common/aws-client :ec2 credentials3045)]
     (clojure.core/case
      (clojure.core/count args3046)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3047
        describeImages
        (ec2/describe-images-request (clojure.core/nth args3046 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3047
        describeImages))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-images,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-images,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeImages, describeImages"}
   [credentials3049 & args3050]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3051
     (com.palletops.awaze.common/aws-client :ec2 credentials3049)]
    (clojure.core/case
     (clojure.core/count args3050)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3051
       describeImages
       (ec2/describe-images-request (clojure.core/nth args3050 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3051
       describeImages))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-image-tasks
   [m3052]
   (clojure.core/let
    [credentials3053 (:credentials m3052) args3054 (:args m3052)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3055
      (com.palletops.awaze.common/aws-client :ec2 credentials3053)]
     (clojure.core/case
      (clojure.core/count args3054)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3055
        describeImportImageTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3055
        describeImportImageTasks
        (ec2/describe-import-image-tasks-request
         (clojure.core/nth args3054 0))))))))
  (clojure.core/defn
   describe-import-image-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeImportImageTasks, describeImportImageTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-import-image-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-import-image-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-image-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeImportImageTasks, describeImportImageTasks"}
   [credentials3057 & args3058]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3059
     (com.palletops.awaze.common/aws-client :ec2 credentials3057)]
    (clojure.core/case
     (clojure.core/count args3058)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3059
       describeImportImageTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3059
       describeImportImageTasks
       (ec2/describe-import-image-tasks-request
        (clojure.core/nth args3058 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-hosts
   [m3060]
   (clojure.core/let
    [credentials3061 (:credentials m3060) args3062 (:args m3060)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3063
      (com.palletops.awaze.common/aws-client :ec2 credentials3061)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3063
       modifyHosts
       (ec2/modify-hosts-request (clojure.core/nth args3062 0)))))))
  (clojure.core/defn
   modify-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyHosts"}
   [credentials3065 & args3066]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3067
     (com.palletops.awaze.common/aws-client :ec2 credentials3065)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3067
      modifyHosts
      (ec2/modify-hosts-request (clojure.core/nth args3066 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m3068]
   (clojure.core/let
    [credentials3069 (:credentials m3068) args3070 (:args m3068)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3071
      (com.palletops.awaze.common/aws-client :ec2 credentials3069)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3071
       registerImage
       (ec2/register-image-request (clojure.core/nth args3070 0)))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for registerImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :register-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call registerImage"}
   [credentials3073 & args3074]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3075
     (com.palletops.awaze.common/aws-client :ec2 credentials3073)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3075
      registerImage
      (ec2/register-image-request (clojure.core/nth args3074 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m3076]
   (clojure.core/let
    [credentials3077 (:credentials m3076) args3078 (:args m3076)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3079
      (com.palletops.awaze.common/aws-client :ec2 credentials3077)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3079
       detachVpnGateway
       (ec2/detach-vpn-gateway-request (clojure.core/nth args3078 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVpnGateway"}
   [credentials3081 & args3082]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3083
     (com.palletops.awaze.common/aws-client :ec2 credentials3081)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3083
      detachVpnGateway
      (ec2/detach-vpn-gateway-request (clojure.core/nth args3082 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m3084]
   (clojure.core/let
    [credentials3085 (:credentials m3084) args3086 (:args m3084)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3087
      (com.palletops.awaze.common/aws-client :ec2 credentials3085)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3087
       deleteVolume
       (ec2/delete-volume-request (clojure.core/nth args3086 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials3089 & args3090]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3091
     (com.palletops.awaze.common/aws-client :ec2 credentials3089)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3091
      deleteVolume
      (ec2/delete-volume-request (clojure.core/nth args3090 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m3092]
   (clojure.core/let
    [credentials3093 (:credentials m3092) args3094 (:args m3092)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3095
      (com.palletops.awaze.common/aws-client :ec2 credentials3093)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3095
       deleteInternetGateway
       (ec2/delete-internet-gateway-request
        (clojure.core/nth args3094 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials3097 & args3098]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3099
     (com.palletops.awaze.common/aws-client :ec2 credentials3097)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3099
      deleteInternetGateway
      (ec2/delete-internet-gateway-request
       (clojure.core/nth args3098 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m3100]
   (clojure.core/let
    [credentials3101 (:credentials m3100) args3102 (:args m3100)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3103
      (com.palletops.awaze.common/aws-client :ec2 credentials3101)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3103
       deleteSubnet
       (ec2/delete-subnet-request (clojure.core/nth args3102 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-subnet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSubnet"}
   [credentials3105 & args3106]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3107
     (com.palletops.awaze.common/aws-client :ec2 credentials3105)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3107
      deleteSubnet
      (ec2/delete-subnet-request (clojure.core/nth args3106 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m3108]
   (clojure.core/let
    [credentials3109 (:credentials m3108) args3110 (:args m3108)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3111
      (com.palletops.awaze.common/aws-client :ec2 credentials3109)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3111
       resetInstanceAttribute
       (ec2/reset-instance-attribute-request
        (clojure.core/nth args3110 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials3113 & args3114]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3115
     (com.palletops.awaze.common/aws-client :ec2 credentials3113)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3115
      resetInstanceAttribute
      (ec2/reset-instance-attribute-request
       (clojure.core/nth args3114 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m3116]
   (clojure.core/let
    [credentials3117 (:credentials m3116) args3118 (:args m3116)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3119
      (com.palletops.awaze.common/aws-client :ec2 credentials3117)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3119
       detachVolume
       (ec2/detach-volume-request (clojure.core/nth args3118 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVolume"}
   [credentials3121 & args3122]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3123
     (com.palletops.awaze.common/aws-client :ec2 credentials3121)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3123
      detachVolume
      (ec2/detach-volume-request (clojure.core/nth args3122 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m3124]
   (clojure.core/let
    [credentials3125 (:credentials m3124) args3126 (:args m3124)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3127
      (com.palletops.awaze.common/aws-client :ec2 credentials3125)]
     (clojure.core/case
      (clojure.core/count args3126)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3127
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3127
        describeExportTasks
        (ec2/describe-export-tasks-request
         (clojure.core/nth args3126 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-export-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-export-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials3129 & args3130]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3131
     (com.palletops.awaze.common/aws-client :ec2 credentials3129)]
    (clojure.core/case
     (clojure.core/count args3130)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3131
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3131
       describeExportTasks
       (ec2/describe-export-tasks-request
        (clojure.core/nth args3130 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instances
   [m3132]
   (clojure.core/let
    [credentials3133 (:credentials m3132) args3134 (:args m3132)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3135
      (com.palletops.awaze.common/aws-client :ec2 credentials3133)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3135
       describeScheduledInstances
       (ec2/describe-scheduled-instances-request
        (clojure.core/nth args3134 0)))))))
  (clojure.core/defn
   describe-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstances"}
   [credentials3137 & args3138]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3139
     (com.palletops.awaze.common/aws-client :ec2 credentials3137)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3139
      describeScheduledInstances
      (ec2/describe-scheduled-instances-request
       (clojure.core/nth args3138 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-flow-logs
   [m3140]
   (clojure.core/let
    [credentials3141 (:credentials m3140) args3142 (:args m3140)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3143
      (com.palletops.awaze.common/aws-client :ec2 credentials3141)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3143
       deleteFlowLogs
       (ec2/delete-flow-logs-request (clojure.core/nth args3142 0)))))))
  (clojure.core/defn
   delete-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteFlowLogs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteFlowLogs"}
   [credentials3145 & args3146]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3147
     (com.palletops.awaze.common/aws-client :ec2 credentials3145)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3147
      deleteFlowLogs
      (ec2/delete-flow-logs-request (clojure.core/nth args3146 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m3148]
   (clojure.core/let
    [credentials3149 (:credentials m3148) args3150 (:args m3148)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3151
      (com.palletops.awaze.common/aws-client :ec2 credentials3149)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3151
       createVpc
       (ec2/create-vpc-request (clojure.core/nth args3150 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Call createVpc"}
   [credentials3153 & args3154]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3155
     (com.palletops.awaze.common/aws-client :ec2 credentials3153)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3155
      createVpc
      (ec2/create-vpc-request (clojure.core/nth args3154 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m3156]
   (clojure.core/let
    [credentials3157 (:credentials m3156) args3158 (:args m3156)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3159
      (com.palletops.awaze.common/aws-client :ec2 credentials3157)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3159
       createSpotDatafeedSubscription
       (ec2/create-spot-datafeed-subscription-request
        (clojure.core/nth args3158 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials3161 & args3162]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3163
     (com.palletops.awaze.common/aws-client :ec2 credentials3161)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3163
      createSpotDatafeedSubscription
      (ec2/create-spot-datafeed-subscription-request
       (clojure.core/nth args3162 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link
   [m3164]
   (clojure.core/let
    [credentials3165 (:credentials m3164) args3166 (:args m3164)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3167
      (com.palletops.awaze.common/aws-client :ec2 credentials3165)]
     (clojure.core/case
      (clojure.core/count args3166)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3167
        describeVpcClassicLink))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3167
        describeVpcClassicLink
        (ec2/describe-vpc-classic-link-request
         (clojure.core/nth args3166 0))))))))
  (clojure.core/defn
   describe-vpc-classic-link-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcClassicLink, describeVpcClassicLink"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcClassicLink, describeVpcClassicLink"}
   [credentials3169 & args3170]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3171
     (com.palletops.awaze.common/aws-client :ec2 credentials3169)]
    (clojure.core/case
     (clojure.core/count args3170)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3171
       describeVpcClassicLink))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3171
       describeVpcClassicLink
       (ec2/describe-vpc-classic-link-request
        (clojure.core/nth args3170 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m3172]
   (clojure.core/let
    [credentials3173 (:credentials m3172) args3174 (:args m3172)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3175
      (com.palletops.awaze.common/aws-client :ec2 credentials3173)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3175
       deleteRoute
       (ec2/delete-route-request (clojure.core/nth args3174 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRoute"}
   [credentials3177 & args3178]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3179
     (com.palletops.awaze.common/aws-client :ec2 credentials3177)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3179
      deleteRoute
      (ec2/delete-route-request (clojure.core/nth args3178 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-id-format
   [m3180]
   (clojure.core/let
    [credentials3181 (:credentials m3180) args3182 (:args m3180)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3183
      (com.palletops.awaze.common/aws-client :ec2 credentials3181)]
     (clojure.core/case
      (clojure.core/count args3182)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3183
        describeIdFormat))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3183
        describeIdFormat
        (ec2/describe-id-format-request (clojure.core/nth args3182 0))))))))
  (clojure.core/defn
   describe-id-format-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeIdFormat, describeIdFormat"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-id-format
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeIdFormat, describeIdFormat"}
   [credentials3185 & args3186]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3187
     (com.palletops.awaze.common/aws-client :ec2 credentials3185)]
    (clojure.core/case
     (clojure.core/count args3186)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3187
       describeIdFormat))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3187
       describeIdFormat
       (ec2/describe-id-format-request (clojure.core/nth args3186 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m3188]
   (clojure.core/let
    [credentials3189 (:credentials m3188) args3190 (:args m3188)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3191
      (com.palletops.awaze.common/aws-client :ec2 credentials3189)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3191
       attachVolume
       (ec2/attach-volume-request (clojure.core/nth args3190 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVolume"}
   [credentials3193 & args3194]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3195
     (com.palletops.awaze.common/aws-client :ec2 credentials3193)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3195
      attachVolume
      (ec2/attach-volume-request (clojure.core/nth args3194 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m3196]
   (clojure.core/let
    [credentials3197 (:credentials m3196) args3198 (:args m3196)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3199
      (com.palletops.awaze.common/aws-client :ec2 credentials3197)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3199
       enableVolumeIO
       (ec2/enable-volume-iorequest (clojure.core/nth args3198 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-volume-io,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVolumeIO"}
   [credentials3201 & args3202]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3203
     (com.palletops.awaze.common/aws-client :ec2 credentials3201)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3203
      enableVolumeIO
      (ec2/enable-volume-iorequest (clojure.core/nth args3202 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m3204]
   (clojure.core/let
    [credentials3205 (:credentials m3204) args3206 (:args m3204)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3207
      (com.palletops.awaze.common/aws-client :ec2 credentials3205)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3207
       attachVpnGateway
       (ec2/attach-vpn-gateway-request (clojure.core/nth args3206 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVpnGateway"}
   [credentials3209 & args3210]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3211
     (com.palletops.awaze.common/aws-client :ec2 credentials3209)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3211
      attachVpnGateway
      (ec2/attach-vpn-gateway-request (clojure.core/nth args3210 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m3212]
   (clojure.core/let
    [credentials3213 (:credentials m3212) args3214 (:args m3212)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3215
      (com.palletops.awaze.common/aws-client :ec2 credentials3213)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3215
       replaceNetworkAclEntry
       (ec2/replace-network-acl-entry-request
        (clojure.core/nth args3214 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials3217 & args3218]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3219
     (com.palletops.awaze.common/aws-client :ec2 credentials3217)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3219
      replaceNetworkAclEntry
      (ec2/replace-network-acl-entry-request
       (clojure.core/nth args3218 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m3220]
   (clojure.core/let
    [credentials3221 (:credentials m3220) args3222 (:args m3220)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3223
      (com.palletops.awaze.common/aws-client :ec2 credentials3221)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3223
       describeSnapshotAttribute
       (ec2/describe-snapshot-attribute-request
        (clojure.core/nth args3222 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials3225 & args3226]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3227
     (com.palletops.awaze.common/aws-client :ec2 credentials3225)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3227
      describeSnapshotAttribute
      (ec2/describe-snapshot-attribute-request
       (clojure.core/nth args3226 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m3228]
   (clojure.core/let
    [credentials3229 (:credentials m3228) args3230 (:args m3228)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3231
      (com.palletops.awaze.common/aws-client :ec2 credentials3229)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3231
       rebootInstances
       (ec2/reboot-instances-request (clojure.core/nth args3230 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootInstances"}
   [credentials3233 & args3234]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3235
     (com.palletops.awaze.common/aws-client :ec2 credentials3233)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3235
      rebootInstances
      (ec2/reboot-instances-request (clojure.core/nth args3234 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reject-vpc-peering-connection
   [m3236]
   (clojure.core/let
    [credentials3237 (:credentials m3236) args3238 (:args m3236)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3239
      (com.palletops.awaze.common/aws-client :ec2 credentials3237)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3239
       rejectVpcPeeringConnection
       (ec2/reject-vpc-peering-connection-request
        (clojure.core/nth args3238 0)))))))
  (clojure.core/defn
   reject-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rejectVpcPeeringConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reject-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rejectVpcPeeringConnection"}
   [credentials3241 & args3242]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3243
     (com.palletops.awaze.common/aws-client :ec2 credentials3241)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3243
      rejectVpcPeeringConnection
      (ec2/reject-vpc-peering-connection-request
       (clojure.core/nth args3242 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m3244]
   (clojure.core/let
    [credentials3245 (:credentials m3244) args3246 (:args m3244)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3247
      (com.palletops.awaze.common/aws-client :ec2 credentials3245)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3247
       createSecurityGroup
       (ec2/create-security-group-request
        (clojure.core/nth args3246 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-security-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSecurityGroup"}
   [credentials3249 & args3250]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3251
     (com.palletops.awaze.common/aws-client :ec2 credentials3249)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3251
      createSecurityGroup
      (ec2/create-security-group-request
       (clojure.core/nth args3250 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m3252]
   (clojure.core/let
    [credentials3253 (:credentials m3252) args3254 (:args m3252)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3255
      (com.palletops.awaze.common/aws-client :ec2 credentials3253)]
     (clojure.core/case
      (clojure.core/count args3254)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3255
        describeSpotInstanceRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3255
        describeSpotInstanceRequests
        (ec2/describe-spot-instance-requests-request
         (clojure.core/nth args3254 0))))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials3257 & args3258]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3259
     (com.palletops.awaze.common/aws-client :ec2 credentials3257)]
    (clojure.core/case
     (clojure.core/count args3258)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3259
       describeSpotInstanceRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3259
       describeSpotInstanceRequests
       (ec2/describe-spot-instance-requests-request
        (clojure.core/nth args3258 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m3260]
   (clojure.core/let
    [credentials3261 (:credentials m3260) args3262 (:args m3260)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3263
      (com.palletops.awaze.common/aws-client :ec2 credentials3261)]
     (clojure.core/case
      (clojure.core/count args3262)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3263
        describeSpotDatafeedSubscription
        (ec2/describe-spot-datafeed-subscription-request
         (clojure.core/nth args3262 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3263
        describeSpotDatafeedSubscription))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials3265 & args3266]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3267
     (com.palletops.awaze.common/aws-client :ec2 credentials3265)]
    (clojure.core/case
     (clojure.core/count args3266)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3267
       describeSpotDatafeedSubscription
       (ec2/describe-spot-datafeed-subscription-request
        (clojure.core/nth args3266 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3267
       describeSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :move-address-to-vpc
   [m3268]
   (clojure.core/let
    [credentials3269 (:credentials m3268) args3270 (:args m3268)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3271
      (com.palletops.awaze.common/aws-client :ec2 credentials3269)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3271
       moveAddressToVpc
       (ec2/move-address-to-vpc-request (clojure.core/nth args3270 0)))))))
  (clojure.core/defn
   move-address-to-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for moveAddressToVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :move-address-to-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   move-address-to-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call moveAddressToVpc"}
   [credentials3273 & args3274]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3275
     (com.palletops.awaze.common/aws-client :ec2 credentials3273)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3275
      moveAddressToVpc
      (ec2/move-address-to-vpc-request (clojure.core/nth args3274 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-endpoint
   [m3276]
   (clojure.core/let
    [credentials3277 (:credentials m3276) args3278 (:args m3276)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3279
      (com.palletops.awaze.common/aws-client :ec2 credentials3277)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3279
       modifyVpcEndpoint
       (ec2/modify-vpc-endpoint-request (clojure.core/nth args3278 0)))))))
  (clojure.core/defn
   modify-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Generate map for modifyVpcEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-vpc-endpoint,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Call modifyVpcEndpoint"}
   [credentials3281 & args3282]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3283
     (com.palletops.awaze.common/aws-client :ec2 credentials3281)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3283
      modifyVpcEndpoint
      (ec2/modify-vpc-endpoint-request (clojure.core/nth args3282 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m3284]
   (clojure.core/let
    [credentials3285 (:credentials m3284) args3286 (:args m3284)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3287
      (com.palletops.awaze.common/aws-client :ec2 credentials3285)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3287
       attachNetworkInterface
       (ec2/attach-network-interface-request
        (clojure.core/nth args3286 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials3289 & args3290]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3291
     (com.palletops.awaze.common/aws-client :ec2 credentials3289)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3291
      attachNetworkInterface
      (ec2/attach-network-interface-request
       (clojure.core/nth args3290 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m3292]
   (clojure.core/let
    [credentials3293 (:credentials m3292) args3294 (:args m3292)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3295
      (com.palletops.awaze.common/aws-client :ec2 credentials3293)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3295
       detachNetworkInterface
       (ec2/detach-network-interface-request
        (clojure.core/nth args3294 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials3297 & args3298]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3299
     (com.palletops.awaze.common/aws-client :ec2 credentials3297)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3299
      detachNetworkInterface
      (ec2/detach-network-interface-request
       (clojure.core/nth args3298 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m3300]
   (clojure.core/let
    [credentials3301 (:credentials m3300) args3302 (:args m3300)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3303
      (com.palletops.awaze.common/aws-client :ec2 credentials3301)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3303
       deleteDhcpOptions
       (ec2/delete-dhcp-options-request (clojure.core/nth args3302 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials3305 & args3306]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3307
     (com.palletops.awaze.common/aws-client :ec2 credentials3305)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3307
      deleteDhcpOptions
      (ec2/delete-dhcp-options-request (clojure.core/nth args3306 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoints
   [m3308]
   (clojure.core/let
    [credentials3309 (:credentials m3308) args3310 (:args m3308)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3311
      (com.palletops.awaze.common/aws-client :ec2 credentials3309)]
     (clojure.core/case
      (clojure.core/count args3310)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3311
        describeVpcEndpoints))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3311
        describeVpcEndpoints
        (ec2/describe-vpc-endpoints-request
         (clojure.core/nth args3310 0))))))))
  (clojure.core/defn
   describe-vpc-endpoints-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcEndpoints, describeVpcEndpoints"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoints
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcEndpoints, describeVpcEndpoints"}
   [credentials3313 & args3314]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3315
     (com.palletops.awaze.common/aws-client :ec2 credentials3313)]
    (clojure.core/case
     (clojure.core/count args3314)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3315
       describeVpcEndpoints))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3315
       describeVpcEndpoints
       (ec2/describe-vpc-endpoints-request
        (clojure.core/nth args3314 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m3316]
   (clojure.core/let
    [credentials3317 (:credentials m3316) args3318 (:args m3316)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3319
      (com.palletops.awaze.common/aws-client :ec2 credentials3317)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3319
       confirmProductInstance
       (ec2/confirm-product-instance-request
        (clojure.core/nth args3318 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-product-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmProductInstance"}
   [credentials3321 & args3322]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3323
     (com.palletops.awaze.common/aws-client :ec2 credentials3321)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3323
      confirmProductInstance
      (ec2/confirm-product-instance-request
       (clojure.core/nth args3322 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m3324]
   (clojure.core/let
    [credentials3325 (:credentials m3324) args3326 (:args m3324)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3327
      (com.palletops.awaze.common/aws-client :ec2 credentials3325)]
     (clojure.core/case
      (clojure.core/count args3326)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3327
        allocateAddress
        (ec2/allocate-address-request (clojure.core/nth args3326 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3327
        allocateAddress))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :allocate-address,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials3329 & args3330]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3331
     (com.palletops.awaze.common/aws-client :ec2 credentials3329)]
    (clojure.core/case
     (clojure.core/count args3330)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3331
       allocateAddress
       (ec2/allocate-address-request (clojure.core/nth args3330 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3331
       allocateAddress))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-endpoint
   [m3332]
   (clojure.core/let
    [credentials3333 (:credentials m3332) args3334 (:args m3332)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3335
      (com.palletops.awaze.common/aws-client :ec2 credentials3333)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3335
       createVpcEndpoint
       (ec2/create-vpc-endpoint-request (clojure.core/nth args3334 0)))))))
  (clojure.core/defn
   create-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createVpcEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc-endpoint,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createVpcEndpoint"}
   [credentials3337 & args3338]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3339
     (com.palletops.awaze.common/aws-client :ec2 credentials3337)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3339
      createVpcEndpoint
      (ec2/create-vpc-endpoint-request (clojure.core/nth args3338 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m3340]
   (clojure.core/let
    [credentials3341 (:credentials m3340) args3342 (:args m3340)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3343
      (com.palletops.awaze.common/aws-client :ec2 credentials3341)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3343
       importKeyPair
       (ec2/import-key-pair-request (clojure.core/nth args3342 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call importKeyPair"}
   [credentials3345 & args3346]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3347
     (com.palletops.awaze.common/aws-client :ec2 credentials3345)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3347
      importKeyPair
      (ec2/import-key-pair-request (clojure.core/nth args3346 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m3348]
   (clojure.core/let
    [credentials3349 (:credentials m3348) args3350 (:args m3348)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3351
      (com.palletops.awaze.common/aws-client :ec2 credentials3349)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3351
       copySnapshot
       (ec2/copy-snapshot-request (clojure.core/nth args3350 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Call copySnapshot"}
   [credentials3353 & args3354]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3355
     (com.palletops.awaze.common/aws-client :ec2 credentials3353)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3355
      copySnapshot
      (ec2/copy-snapshot-request (clojure.core/nth args3354 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m3356]
   (clojure.core/let
    [credentials3357 (:credentials m3356) args3358 (:args m3356)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3359
      (com.palletops.awaze.common/aws-client :ec2 credentials3357)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3359
       deleteSnapshot
       (ec2/delete-snapshot-request (clojure.core/nth args3358 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials3361 & args3362]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3363
     (com.palletops.awaze.common/aws-client :ec2 credentials3361)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3363
      deleteSnapshot
      (ec2/delete-snapshot-request (clojure.core/nth args3362 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m3364]
   (clojure.core/let
    [credentials3365 (:credentials m3364) args3366 (:args m3364)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3367
      (com.palletops.awaze.common/aws-client :ec2 credentials3365)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3367
       resetImageAttribute
       (ec2/reset-image-attribute-request
        (clojure.core/nth args3366 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetImageAttribute"}
   [credentials3369 & args3370]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3371
     (com.palletops.awaze.common/aws-client :ec2 credentials3369)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3371
      resetImageAttribute
      (ec2/reset-image-attribute-request
       (clojure.core/nth args3370 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m3372]
   (clojure.core/let
    [credentials3373 (:credentials m3372) args3374 (:args m3372)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3375
      (com.palletops.awaze.common/aws-client :ec2 credentials3373)]
     (clojure.core/case
      (clojure.core/count args3374)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3375
        createInternetGateway))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3375
        createInternetGateway
        (ec2/create-internet-gateway-request
         (clojure.core/nth args3374 0))))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials3377 & args3378]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3379
     (com.palletops.awaze.common/aws-client :ec2 credentials3377)]
    (clojure.core/case
     (clojure.core/count args3378)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3379
       createInternetGateway))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3379
       createInternetGateway
       (ec2/create-internet-gateway-request
        (clojure.core/nth args3378 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m3380]
   (clojure.core/let
    [credentials3381 (:credentials m3380) args3382 (:args m3380)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3383
      (com.palletops.awaze.common/aws-client :ec2 credentials3381)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3383
       monitorInstances
       (ec2/monitor-instances-request (clojure.core/nth args3382 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :monitor-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call monitorInstances"}
   [credentials3385 & args3386]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3387
     (com.palletops.awaze.common/aws-client :ec2 credentials3385)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3387
      monitorInstances
      (ec2/monitor-instances-request (clojure.core/nth args3386 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m3388]
   (clojure.core/let
    [credentials3389 (:credentials m3388) args3390 (:args m3388)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3391
      (com.palletops.awaze.common/aws-client :ec2 credentials3389)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3391
       revokeSecurityGroupEgress
       (ec2/revoke-security-group-egress-request
        (clojure.core/nth args3390 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-security-group-egress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials3393 & args3394]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3395
     (com.palletops.awaze.common/aws-client :ec2 credentials3393)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3395
      revokeSecurityGroupEgress
      (ec2/revoke-security-group-egress-request
       (clojure.core/nth args3394 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m3396]
   (clojure.core/let
    [credentials3397 (:credentials m3396) args3398 (:args m3396)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3399
      (com.palletops.awaze.common/aws-client :ec2 credentials3397)]
     (clojure.core/case
      (clojure.core/count args3398)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3399
        describeVpcs
        (ec2/describe-vpcs-request (clojure.core/nth args3398 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3399
        describeVpcs))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpcs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpcs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials3401 & args3402]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3403
     (com.palletops.awaze.common/aws-client :ec2 credentials3401)]
    (clojure.core/case
     (clojure.core/count args3402)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3403
       describeVpcs
       (ec2/describe-vpcs-request (clojure.core/nth args3402 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3403
       describeVpcs))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m3404]
   (clojure.core/let
    [credentials3405 (:credentials m3404) args3406 (:args m3404)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3407
      (com.palletops.awaze.common/aws-client :ec2 credentials3405)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3407
       importInstance
       (ec2/import-instance-request (clojure.core/nth args3406 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Call importInstance"}
   [credentials3409 & args3410]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3411
     (com.palletops.awaze.common/aws-client :ec2 credentials3409)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3411
      importInstance
      (ec2/import-instance-request (clojure.core/nth args3410 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m3412]
   (clojure.core/let
    [credentials3413 (:credentials m3412) args3414 (:args m3412)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3415
      (com.palletops.awaze.common/aws-client :ec2 credentials3413)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3415
       copyImage
       (ec2/copy-image-request (clojure.core/nth args3414 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Call copyImage"}
   [credentials3417 & args3418]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3419
     (com.palletops.awaze.common/aws-client :ec2 credentials3417)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3419
      copyImage
      (ec2/copy-image-request (clojure.core/nth args3418 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m3420]
   (clojure.core/let
    [credentials3421 (:credentials m3420) args3422 (:args m3420)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3423
      (com.palletops.awaze.common/aws-client :ec2 credentials3421)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3423
       getConsoleOutput
       (ec2/get-console-output-request (clojure.core/nth args3422 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-console-output,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getConsoleOutput"}
   [credentials3425 & args3426]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3427
     (com.palletops.awaze.common/aws-client :ec2 credentials3425)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3427
      getConsoleOutput
      (ec2/get-console-output-request (clojure.core/nth args3426 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m3428]
   (clojure.core/let
    [credentials3429 (:credentials m3428) args3430 (:args m3428)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3431
      (com.palletops.awaze.common/aws-client :ec2 credentials3429)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3431
       modifySnapshotAttribute
       (ec2/modify-snapshot-attribute-request
        (clojure.core/nth args3430 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials3433 & args3434]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3435
     (com.palletops.awaze.common/aws-client :ec2 credentials3433)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3435
      modifySnapshotAttribute
      (ec2/modify-snapshot-attribute-request
       (clojure.core/nth args3434 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-fleet
   [m3436]
   (clojure.core/let
    [credentials3437 (:credentials m3436) args3438 (:args m3436)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3439
      (com.palletops.awaze.common/aws-client :ec2 credentials3437)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3439
       requestSpotFleet
       (ec2/request-spot-fleet-request (clojure.core/nth args3438 0)))))))
  (clojure.core/defn
   request-spot-fleet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for requestSpotFleet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-spot-fleet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-fleet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call requestSpotFleet"}
   [credentials3441 & args3442]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3443
     (com.palletops.awaze.common/aws-client :ec2 credentials3441)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3443
      requestSpotFleet
      (ec2/request-spot-fleet-request (clojure.core/nth args3442 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :restore-address-to-classic
   [m3444]
   (clojure.core/let
    [credentials3445 (:credentials m3444) args3446 (:args m3444)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3447
      (com.palletops.awaze.common/aws-client :ec2 credentials3445)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3447
       restoreAddressToClassic
       (ec2/restore-address-to-classic-request
        (clojure.core/nth args3446 0)))))))
  (clojure.core/defn
   restore-address-to-classic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for restoreAddressToClassic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-address-to-classic,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   restore-address-to-classic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call restoreAddressToClassic"}
   [credentials3449 & args3450]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3451
     (com.palletops.awaze.common/aws-client :ec2 credentials3449)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3451
      restoreAddressToClassic
      (ec2/restore-address-to-classic-request
       (clojure.core/nth args3450 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-subnet-attribute
   [m3452]
   (clojure.core/let
    [credentials3453 (:credentials m3452) args3454 (:args m3452)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3455
      (com.palletops.awaze.common/aws-client :ec2 credentials3453)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3455
       modifySubnetAttribute
       (ec2/modify-subnet-attribute-request
        (clojure.core/nth args3454 0)))))))
  (clojure.core/defn
   modify-subnet-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySubnetAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-subnet-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-subnet-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySubnetAttribute"}
   [credentials3457 & args3458]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3459
     (com.palletops.awaze.common/aws-client :ec2 credentials3457)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3459
      modifySubnetAttribute
      (ec2/modify-subnet-attribute-request
       (clojure.core/nth args3458 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m3460]
   (clojure.core/let
    [credentials3461 (:credentials m3460) args3462 (:args m3460)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3463
      (com.palletops.awaze.common/aws-client :ec2 credentials3461)]
     (clojure.core/case
      (clojure.core/count args3462)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3463
        describeConversionTasks
        (ec2/describe-conversion-tasks-request
         (clojure.core/nth args3462 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3463
        describeConversionTasks))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-conversion-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-conversion-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials3465 & args3466]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3467
     (com.palletops.awaze.common/aws-client :ec2 credentials3465)]
    (clojure.core/case
     (clojure.core/count args3466)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3467
       describeConversionTasks
       (ec2/describe-conversion-tasks-request
        (clojure.core/nth args3466 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3467
       describeConversionTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m3468]
   (clojure.core/let
    [credentials3469 (:credentials m3468) args3470 (:args m3468)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3471
      (com.palletops.awaze.common/aws-client :ec2 credentials3469)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3471
       authorizeSecurityGroupEgress
       (ec2/authorize-security-group-egress-request
        (clojure.core/nth args3470 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-security-group-egress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials3473 & args3474]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3475
     (com.palletops.awaze.common/aws-client :ec2 credentials3473)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3475
      authorizeSecurityGroupEgress
      (ec2/authorize-security-group-egress-request
       (clojure.core/nth args3474 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m3476]
   (clojure.core/let
    [credentials3477 (:credentials m3476) args3478 (:args m3476)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3479
      (com.palletops.awaze.common/aws-client :ec2 credentials3477)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3479
       authorizeSecurityGroupIngress
       (ec2/authorize-security-group-ingress-request
        (clojure.core/nth args3478 0)))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupIngress"}
   [credentials3481 & args3482]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3483
     (com.palletops.awaze.common/aws-client :ec2 credentials3481)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3483
      authorizeSecurityGroupIngress
      (ec2/authorize-security-group-ingress-request
       (clojure.core/nth args3482 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m3484]
   (clojure.core/let
    [credentials3485 (:credentials m3484) args3486 (:args m3484)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3487
      (com.palletops.awaze.common/aws-client :ec2 credentials3485)]
     (clojure.core/case
      (clojure.core/count args3486)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3487
        describeAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3487
        describeAddresses
        (ec2/describe-addresses-request (clojure.core/nth args3486 0))))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials3489 & args3490]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3491
     (com.palletops.awaze.common/aws-client :ec2 credentials3489)]
    (clojure.core/case
     (clojure.core/count args3490)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3491
       describeAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3491
       describeAddresses
       (ec2/describe-addresses-request (clojure.core/nth args3490 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m3492]
   (clojure.core/let
    [credentials3493 (:credentials m3492) args3494 (:args m3492)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3495
      (com.palletops.awaze.common/aws-client :ec2 credentials3493)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3495
       createVpnConnectionRoute
       (ec2/create-vpn-connection-route-request
        (clojure.core/nth args3494 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-connection-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials3497 & args3498]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3499
     (com.palletops.awaze.common/aws-client :ec2 credentials3497)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3499
      createVpnConnectionRoute
      (ec2/create-vpn-connection-route-request
       (clojure.core/nth args3498 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m3500]
   (clojure.core/let
    [credentials3501 (:credentials m3500) args3502 (:args m3500)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3503
      (com.palletops.awaze.common/aws-client :ec2 credentials3501)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3503
       associateAddress
       (ec2/associate-address-request (clojure.core/nth args3502 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call associateAddress"}
   [credentials3505 & args3506]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3507
     (com.palletops.awaze.common/aws-client :ec2 credentials3505)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3507
      associateAddress
      (ec2/associate-address-request (clojure.core/nth args3506 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m3508]
   (clojure.core/let
    [credentials3509 (:credentials m3508) args3510 (:args m3508)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3511
      (com.palletops.awaze.common/aws-client :ec2 credentials3509)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3511
       createInstanceExportTask
       (ec2/create-instance-export-task-request
        (clojure.core/nth args3510 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-instance-export-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials3513 & args3514]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3515
     (com.palletops.awaze.common/aws-client :ec2 credentials3513)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3515
      createInstanceExportTask
      (ec2/create-instance-export-task-request
       (clojure.core/nth args3514 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m3516]
   (clojure.core/let
    [credentials3517 (:credentials m3516) args3518 (:args m3516)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3519
      (com.palletops.awaze.common/aws-client :ec2 credentials3517)]
     (clojure.core/case
      (clojure.core/count args3518)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3519
        describeKeyPairs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3519
        describeKeyPairs
        (ec2/describe-key-pairs-request (clojure.core/nth args3518 0))))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-key-pairs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-key-pairs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials3521 & args3522]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3523
     (com.palletops.awaze.common/aws-client :ec2 credentials3521)]
    (clojure.core/case
     (clojure.core/count args3522)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3523
       describeKeyPairs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3523
       describeKeyPairs
       (ec2/describe-key-pairs-request (clojure.core/nth args3522 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-requests
   [m3524]
   (clojure.core/let
    [credentials3525 (:credentials m3524) args3526 (:args m3524)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3527
      (com.palletops.awaze.common/aws-client :ec2 credentials3525)]
     (clojure.core/case
      (clojure.core/count args3526)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3527
        describeSpotFleetRequests
        (ec2/describe-spot-fleet-requests-request
         (clojure.core/nth args3526 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3527
        describeSpotFleetRequests))))))
  (clojure.core/defn
   describe-spot-fleet-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSpotFleetRequests, describeSpotFleetRequests"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeSpotFleetRequests, describeSpotFleetRequests"}
   [credentials3529 & args3530]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3531
     (com.palletops.awaze.common/aws-client :ec2 credentials3529)]
    (clojure.core/case
     (clojure.core/count args3530)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3531
       describeSpotFleetRequests
       (ec2/describe-spot-fleet-requests-request
        (clojure.core/nth args3530 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3531
       describeSpotFleetRequests))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m3532]
   (clojure.core/let
    [credentials3533 (:credentials m3532) args3534 (:args m3532)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3535
      (com.palletops.awaze.common/aws-client :ec2 credentials3533)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3535
       describeImageAttribute
       (ec2/describe-image-attribute-request
        (clojure.core/nth args3534 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImageAttribute"}
   [credentials3537 & args3538]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3539
     (com.palletops.awaze.common/aws-client :ec2 credentials3537)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3539
      describeImageAttribute
      (ec2/describe-image-attribute-request
       (clojure.core/nth args3538 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-moving-addresses
   [m3540]
   (clojure.core/let
    [credentials3541 (:credentials m3540) args3542 (:args m3540)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3543
      (com.palletops.awaze.common/aws-client :ec2 credentials3541)]
     (clojure.core/case
      (clojure.core/count args3542)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3543
        describeMovingAddresses
        (ec2/describe-moving-addresses-request
         (clojure.core/nth args3542 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3543
        describeMovingAddresses))))))
  (clojure.core/defn
   describe-moving-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeMovingAddresses, describeMovingAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-moving-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-moving-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-moving-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeMovingAddresses, describeMovingAddresses"}
   [credentials3545 & args3546]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3547
     (com.palletops.awaze.common/aws-client :ec2 credentials3545)]
    (clojure.core/case
     (clojure.core/count args3546)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3547
       describeMovingAddresses
       (ec2/describe-moving-addresses-request
        (clojure.core/nth args3546 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3547
       describeMovingAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m3548]
   (clojure.core/let
    [credentials3549 (:credentials m3548) args3550 (:args m3548)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3551
      (com.palletops.awaze.common/aws-client :ec2 credentials3549)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3551
       deleteNetworkAcl
       (ec2/delete-network-acl-request (clojure.core/nth args3550 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-acl,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials3553 & args3554]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3555
     (com.palletops.awaze.common/aws-client :ec2 credentials3553)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3555
      deleteNetworkAcl
      (ec2/delete-network-acl-request (clojure.core/nth args3554 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m3556]
   (clojure.core/let
    [credentials3557 (:credentials m3556) args3558 (:args m3556)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3559
      (com.palletops.awaze.common/aws-client :ec2 credentials3557)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3559
       deleteNetworkInterface
       (ec2/delete-network-interface-request
        (clojure.core/nth args3558 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials3561 & args3562]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3563
     (com.palletops.awaze.common/aws-client :ec2 credentials3561)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3563
      deleteNetworkInterface
      (ec2/delete-network-interface-request
       (clojure.core/nth args3562 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m3564]
   (clojure.core/let
    [credentials3565 (:credentials m3564) args3566 (:args m3564)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3567
      (com.palletops.awaze.common/aws-client :ec2 credentials3565)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3567
       deleteVpnConnection
       (ec2/delete-vpn-connection-request
        (clojure.core/nth args3566 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials3569 & args3570]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3571
     (com.palletops.awaze.common/aws-client :ec2 credentials3569)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3571
      deleteVpnConnection
      (ec2/delete-vpn-connection-request
       (clojure.core/nth args3570 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-scheduled-instances
   [m3572]
   (clojure.core/let
    [credentials3573 (:credentials m3572) args3574 (:args m3572)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3575
      (com.palletops.awaze.common/aws-client :ec2 credentials3573)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3575
       purchaseScheduledInstances
       (ec2/purchase-scheduled-instances-request
        (clojure.core/nth args3574 0)))))))
  (clojure.core/defn
   purchase-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for purchaseScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call purchaseScheduledInstances"}
   [credentials3577 & args3578]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3579
     (com.palletops.awaze.common/aws-client :ec2 credentials3577)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3579
      purchaseScheduledInstances
      (ec2/purchase-scheduled-instances-request
       (clojure.core/nth args3578 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m3580]
   (clojure.core/let
    [credentials3581 (:credentials m3580) args3582 (:args m3580)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3583
      (com.palletops.awaze.common/aws-client :ec2 credentials3581)]
     (clojure.core/case
      (clojure.core/count args3582)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3583
        describeReservedInstancesModifications
        (ec2/describe-reserved-instances-modifications-request
         (clojure.core/nth args3582 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3583
        describeReservedInstancesModifications))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials3585 & args3586]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3587
     (com.palletops.awaze.common/aws-client :ec2 credentials3585)]
    (clojure.core/case
     (clojure.core/count args3586)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3587
       describeReservedInstancesModifications
       (ec2/describe-reserved-instances-modifications-request
        (clojure.core/nth args3586 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3587
       describeReservedInstancesModifications))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-classic-link-instances
   [m3588]
   (clojure.core/let
    [credentials3589 (:credentials m3588) args3590 (:args m3588)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3591
      (com.palletops.awaze.common/aws-client :ec2 credentials3589)]
     (clojure.core/case
      (clojure.core/count args3590)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3591
        describeClassicLinkInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3591
        describeClassicLinkInstances
        (ec2/describe-classic-link-instances-request
         (clojure.core/nth args3590 0))))))))
  (clojure.core/defn
   describe-classic-link-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeClassicLinkInstances, describeClassicLinkInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-classic-link-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-classic-link-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-classic-link-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeClassicLinkInstances, describeClassicLinkInstances"}
   [credentials3593 & args3594]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3595
     (com.palletops.awaze.common/aws-client :ec2 credentials3593)]
    (clojure.core/case
     (clojure.core/count args3594)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3595
       describeClassicLinkInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3595
       describeClassicLinkInstances
       (ec2/describe-classic-link-instances-request
        (clojure.core/nth args3594 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m3596]
   (clojure.core/let
    [credentials3597 (:credentials m3596) args3598 (:args m3596)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3599
      (com.palletops.awaze.common/aws-client :ec2 credentials3597)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3599
       purchaseReservedInstancesOffering
       (ec2/purchase-reserved-instances-offering-request
        (clojure.core/nth args3598 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials3601 & args3602]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3603
     (com.palletops.awaze.common/aws-client :ec2 credentials3601)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3603
      purchaseReservedInstancesOffering
      (ec2/purchase-reserved-instances-offering-request
       (clojure.core/nth args3602 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m3604]
   (clojure.core/let
    [credentials3605 (:credentials m3604) args3606 (:args m3604)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3607
      (com.palletops.awaze.common/aws-client :ec2 credentials3605)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3607
       startInstances
       (ec2/start-instances-request (clojure.core/nth args3606 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :start-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call startInstances"}
   [credentials3609 & args3610]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3611
     (com.palletops.awaze.common/aws-client :ec2 credentials3609)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3611
      startInstances
      (ec2/start-instances-request (clojure.core/nth args3610 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m3612]
   (clojure.core/let
    [credentials3613 (:credentials m3612) args3614 (:args m3612)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3615
      (com.palletops.awaze.common/aws-client :ec2 credentials3613)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3615
       describeInstanceAttribute
       (ec2/describe-instance-attribute-request
        (clojure.core/nth args3614 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials3617 & args3618]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3619
     (com.palletops.awaze.common/aws-client :ec2 credentials3617)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3619
      describeInstanceAttribute
      (ec2/describe-instance-attribute-request
       (clojure.core/nth args3618 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-fleet-requests
   [m3620]
   (clojure.core/let
    [credentials3621 (:credentials m3620) args3622 (:args m3620)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3623
      (com.palletops.awaze.common/aws-client :ec2 credentials3621)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3623
       cancelSpotFleetRequests
       (ec2/cancel-spot-fleet-requests-request
        (clojure.core/nth args3622 0)))))))
  (clojure.core/defn
   cancel-spot-fleet-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Generate map for cancelSpotFleetRequests"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-fleet-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Call cancelSpotFleetRequests"}
   [credentials3625 & args3626]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3627
     (com.palletops.awaze.common/aws-client :ec2 credentials3625)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3627
      cancelSpotFleetRequests
      (ec2/cancel-spot-fleet-requests-request
       (clojure.core/nth args3626 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m3628]
   (clojure.core/let
    [credentials3629 (:credentials m3628) args3630 (:args m3628)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3631
      (com.palletops.awaze.common/aws-client :ec2 credentials3629)]
     (clojure.core/case
      (clojure.core/count args3630)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3631
        describeSubnets))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3631
        describeSubnets
        (ec2/describe-subnets-request (clojure.core/nth args3630 0))))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-subnets,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-subnets,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials3633 & args3634]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3635
     (com.palletops.awaze.common/aws-client :ec2 credentials3633)]
    (clojure.core/case
     (clojure.core/count args3634)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3635
       describeSubnets))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3635
       describeSubnets
       (ec2/describe-subnets-request (clojure.core/nth args3634 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m3636]
   (clojure.core/let
    [credentials3637 (:credentials m3636) args3638 (:args m3636)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3639
      (com.palletops.awaze.common/aws-client :ec2 credentials3637)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3639
       createVolume
       (ec2/create-volume-request (clojure.core/nth args3638 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Call createVolume"}
   [credentials3641 & args3642]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3643
     (com.palletops.awaze.common/aws-client :ec2 credentials3641)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3643
      createVolume
      (ec2/create-volume-request (clojure.core/nth args3642 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m3644]
   (clojure.core/let
    [credentials3645 (:credentials m3644) args3646 (:args m3644)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3647
      (com.palletops.awaze.common/aws-client :ec2 credentials3645)]
     (clojure.core/case
      (clojure.core/count args3646)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3647
        describeReservedInstancesListings
        (ec2/describe-reserved-instances-listings-request
         (clojure.core/nth args3646 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3647
        describeReservedInstancesListings))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials3649 & args3650]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3651
     (com.palletops.awaze.common/aws-client :ec2 credentials3649)]
    (clojure.core/case
     (clojure.core/count args3650)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3651
       describeReservedInstancesListings
       (ec2/describe-reserved-instances-listings-request
        (clojure.core/nth args3650 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3651
       describeReservedInstancesListings))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m3652]
   (clojure.core/let
    [credentials3653 (:credentials m3652) args3654 (:args m3652)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3655
      (com.palletops.awaze.common/aws-client :ec2 credentials3653)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3655
       createDhcpOptions
       (ec2/create-dhcp-options-request (clojure.core/nth args3654 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Call createDhcpOptions"}
   [credentials3657 & args3658]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3659
     (com.palletops.awaze.common/aws-client :ec2 credentials3657)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3659
      createDhcpOptions
      (ec2/create-dhcp-options-request (clojure.core/nth args3658 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m3660]
   (clojure.core/let
    [credentials3661 (:credentials m3660) args3662 (:args m3660)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3663
      (com.palletops.awaze.common/aws-client :ec2 credentials3661)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3663
       detachInternetGateway
       (ec2/detach-internet-gateway-request
        (clojure.core/nth args3662 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call detachInternetGateway"}
   [credentials3665 & args3666]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3667
     (com.palletops.awaze.common/aws-client :ec2 credentials3665)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3667
      detachInternetGateway
      (ec2/detach-internet-gateway-request
       (clojure.core/nth args3666 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m3668]
   (clojure.core/let
    [credentials3669 (:credentials m3668) args3670 (:args m3668)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3671
      (com.palletops.awaze.common/aws-client :ec2 credentials3669)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3671
       deleteVpnGateway
       (ec2/delete-vpn-gateway-request (clojure.core/nth args3670 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials3673 & args3674]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3675
     (com.palletops.awaze.common/aws-client :ec2 credentials3673)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3675
      deleteVpnGateway
      (ec2/delete-vpn-gateway-request (clojure.core/nth args3674 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m3676]
   (clojure.core/let
    [credentials3677 (:credentials m3676) args3678 (:args m3676)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3679
      (com.palletops.awaze.common/aws-client :ec2 credentials3677)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3679
       requestSpotInstances
       (ec2/request-spot-instances-request
        (clojure.core/nth args3678 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-spot-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call requestSpotInstances"}
   [credentials3681 & args3682]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3683
     (com.palletops.awaze.common/aws-client :ec2 credentials3681)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3683
      requestSpotInstances
      (ec2/request-spot-instances-request
       (clojure.core/nth args3682 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m3684]
   (clojure.core/let
    [credentials3685 (:credentials m3684) args3686 (:args m3684)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3687
      (com.palletops.awaze.common/aws-client :ec2 credentials3685)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3687
       importVolume
       (ec2/import-volume-request (clojure.core/nth args3686 0)))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Call importVolume"}
   [credentials3689 & args3690]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3691
     (com.palletops.awaze.common/aws-client :ec2 credentials3689)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3691
      importVolume
      (ec2/import-volume-request (clojure.core/nth args3690 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-snapshot
   [m3692]
   (clojure.core/let
    [credentials3693 (:credentials m3692) args3694 (:args m3692)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3695
      (com.palletops.awaze.common/aws-client :ec2 credentials3693)]
     (clojure.core/case
      (clojure.core/count args3694)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3695
        importSnapshot
        (ec2/import-snapshot-request (clojure.core/nth args3694 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3695
        importSnapshot))))))
  (clojure.core/defn
   import-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]
                [credentials]]),
    :doc "Generate map for importSnapshot, importSnapshot"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :import-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]
                [credentials]]),
    :doc "Call importSnapshot, importSnapshot"}
   [credentials3697 & args3698]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3699
     (com.palletops.awaze.common/aws-client :ec2 credentials3697)]
    (clojure.core/case
     (clojure.core/count args3698)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3699
       importSnapshot
       (ec2/import-snapshot-request (clojure.core/nth args3698 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3699
       importSnapshot))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m3700]
   (clojure.core/let
    [credentials3701 (:credentials m3700) args3702 (:args m3700)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3703
      (com.palletops.awaze.common/aws-client :ec2 credentials3701)]
     (clojure.core/case
      (clojure.core/count args3702)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3703
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3703
        describeTags
        (ec2/describe-tags-request (clojure.core/nth args3702 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials3705 & args3706]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3707
     (com.palletops.awaze.common/aws-client :ec2 credentials3705)]
    (clojure.core/case
     (clojure.core/count args3706)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3707
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3707
       describeTags
       (ec2/describe-tags-request (clojure.core/nth args3706 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m3708]
   (clojure.core/let
    [credentials3709 (:credentials m3708) args3710 (:args m3708)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3711
      (com.palletops.awaze.common/aws-client :ec2 credentials3709)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3711
       deleteTags
       (ec2/delete-tags-request (clojure.core/nth args3710 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials3713 & args3714]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3715
     (com.palletops.awaze.common/aws-client :ec2 credentials3713)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3715
      deleteTags
      (ec2/delete-tags-request (clojure.core/nth args3714 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link
   [m3716]
   (clojure.core/let
    [credentials3717 (:credentials m3716) args3718 (:args m3716)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3719
      (com.palletops.awaze.common/aws-client :ec2 credentials3717)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3719
       enableVpcClassicLink
       (ec2/enable-vpc-classic-link-request
        (clojure.core/nth args3718 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLink"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLink"}
   [credentials3721 & args3722]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3723
     (com.palletops.awaze.common/aws-client :ec2 credentials3721)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3723
      enableVpcClassicLink
      (ec2/enable-vpc-classic-link-request
       (clojure.core/nth args3722 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m3724]
   (clojure.core/let
    [credentials3725 (:credentials m3724) args3726 (:args m3724)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3727
      (com.palletops.awaze.common/aws-client :ec2 credentials3725)]
     (clojure.core/case
      (clojure.core/count args3726)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3727
        describeReservedInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3727
        describeReservedInstancesOfferings
        (ec2/describe-reserved-instances-offerings-request
         (clojure.core/nth args3726 0))))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials3729 & args3730]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3731
     (com.palletops.awaze.common/aws-client :ec2 credentials3729)]
    (clojure.core/case
     (clojure.core/count args3730)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3731
       describeReservedInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3731
       describeReservedInstancesOfferings
       (ec2/describe-reserved-instances-offerings-request
        (clojure.core/nth args3730 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m3732]
   (clojure.core/let
    [credentials3733 (:credentials m3732) args3734 (:args m3732)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3735
      (com.palletops.awaze.common/aws-client :ec2 credentials3733)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3735
       createVpnGateway
       (ec2/create-vpn-gateway-request (clojure.core/nth args3734 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnGateway"}
   [credentials3737 & args3738]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3739
     (com.palletops.awaze.common/aws-client :ec2 credentials3737)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3739
      createVpnGateway
      (ec2/create-vpn-gateway-request (clojure.core/nth args3738 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m3740]
   (clojure.core/let
    [credentials3741 (:credentials m3740) args3742 (:args m3740)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3743
      (com.palletops.awaze.common/aws-client :ec2 credentials3741)]
     (clojure.core/case
      (clojure.core/count args3742)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3743
        describeRouteTables
        (ec2/describe-route-tables-request
         (clojure.core/nth args3742 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3743
        describeRouteTables))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-route-tables,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-route-tables,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials3745 & args3746]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3747
     (com.palletops.awaze.common/aws-client :ec2 credentials3745)]
    (clojure.core/case
     (clojure.core/count args3746)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3747
       describeRouteTables
       (ec2/describe-route-tables-request
        (clojure.core/nth args3746 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3747
       describeRouteTables))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m3748]
   (clojure.core/let
    [credentials3749 (:credentials m3748) args3750 (:args m3748)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3751
      (com.palletops.awaze.common/aws-client :ec2 credentials3749)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3751
       cancelSpotInstanceRequests
       (ec2/cancel-spot-instance-requests-request
        (clojure.core/nth args3750 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials3753 & args3754]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3755
     (com.palletops.awaze.common/aws-client :ec2 credentials3753)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3755
      cancelSpotInstanceRequests
      (ec2/cancel-spot-instance-requests-request
       (clojure.core/nth args3754 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m3756]
   (clojure.core/let
    [credentials3757 (:credentials m3756) args3758 (:args m3756)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3759
      (com.palletops.awaze.common/aws-client :ec2 credentials3757)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3759
       assignPrivateIpAddresses
       (ec2/assign-private-ip-addresses-request
        (clojure.core/nth args3758 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assign-private-ip-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials3761 & args3762]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3763
     (com.palletops.awaze.common/aws-client :ec2 credentials3761)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3763
      assignPrivateIpAddresses
      (ec2/assign-private-ip-addresses-request
       (clojure.core/nth args3762 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link-dns-support
   [m3764]
   (clojure.core/let
    [credentials3765 (:credentials m3764) args3766 (:args m3764)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3767
      (com.palletops.awaze.common/aws-client :ec2 credentials3765)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3767
       disableVpcClassicLinkDnsSupport
       (ec2/disable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3766 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLinkDnsSupport"}
   [credentials3769 & args3770]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3771
     (com.palletops.awaze.common/aws-client :ec2 credentials3769)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3771
      disableVpcClassicLinkDnsSupport
      (ec2/disable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3770 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m3772]
   (clojure.core/let
    [credentials3773 (:credentials m3772) args3774 (:args m3772)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3775
      (com.palletops.awaze.common/aws-client :ec2 credentials3773)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3775
       deletePlacementGroup
       (ec2/delete-placement-group-request
        (clojure.core/nth args3774 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-placement-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials3777 & args3778]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3779
     (com.palletops.awaze.common/aws-client :ec2 credentials3777)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3779
      deletePlacementGroup
      (ec2/delete-placement-group-request
       (clojure.core/nth args3778 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m3780]
   (clojure.core/let
    [credentials3781 (:credentials m3780) args3782 (:args m3780)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3783
      (com.palletops.awaze.common/aws-client :ec2 credentials3781)]
     (clojure.core/case
      (clojure.core/count args3782)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3783
        describeInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3783
        describeInstances
        (ec2/describe-instances-request (clojure.core/nth args3782 0))))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials3785 & args3786]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3787
     (com.palletops.awaze.common/aws-client :ec2 credentials3785)]
    (clojure.core/case
     (clojure.core/count args3786)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3787
       describeInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3787
       describeInstances
       (ec2/describe-instances-request (clojure.core/nth args3786 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m3788]
   (clojure.core/let
    [credentials3789 (:credentials m3788) args3790 (:args m3788)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3791
      (com.palletops.awaze.common/aws-client :ec2 credentials3789)]
     (clojure.core/case
      (clojure.core/count args3790)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3791
        describeVolumes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3791
        describeVolumes
        (ec2/describe-volumes-request (clojure.core/nth args3790 0))))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-volumes,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volumes,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials3793 & args3794]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3795
     (com.palletops.awaze.common/aws-client :ec2 credentials3793)]
    (clojure.core/case
     (clojure.core/count args3794)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3795
       describeVolumes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3795
       describeVolumes
       (ec2/describe-volumes-request (clojure.core/nth args3794 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m3796]
   (clojure.core/let
    [credentials3797 (:credentials m3796) args3798 (:args m3796)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3799
      (com.palletops.awaze.common/aws-client :ec2 credentials3797)]
     (clojure.core/case
      (clojure.core/count args3798)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3799
        describeBundleTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3799
        describeBundleTasks
        (ec2/describe-bundle-tasks-request
         (clojure.core/nth args3798 0))))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-bundle-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-bundle-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials3801 & args3802]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3803
     (com.palletops.awaze.common/aws-client :ec2 credentials3801)]
    (clojure.core/case
     (clojure.core/count args3802)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3803
       describeBundleTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3803
       describeBundleTasks
       (ec2/describe-bundle-tasks-request
        (clojure.core/nth args3802 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m3804]
   (clojure.core/let
    [credentials3805 (:credentials m3804) args3806 (:args m3804)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3807
      (com.palletops.awaze.common/aws-client :ec2 credentials3805)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3807
       associateDhcpOptions
       (ec2/associate-dhcp-options-request
        (clojure.core/nth args3806 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials3809 & args3810]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3811
     (com.palletops.awaze.common/aws-client :ec2 credentials3809)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3811
      associateDhcpOptions
      (ec2/associate-dhcp-options-request
       (clojure.core/nth args3810 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m3812]
   (clojure.core/let
    [credentials3813 (:credentials m3812) args3814 (:args m3812)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3815
      (com.palletops.awaze.common/aws-client :ec2 credentials3813)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3815
       modifyVpcAttribute
       (ec2/modify-vpc-attribute-request
        (clojure.core/nth args3814 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-vpc-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials3817 & args3818]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3819
     (com.palletops.awaze.common/aws-client :ec2 credentials3817)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3819
      modifyVpcAttribute
      (ec2/modify-vpc-attribute-request (clojure.core/nth args3818 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-flow-logs
   [m3820]
   (clojure.core/let
    [credentials3821 (:credentials m3820) args3822 (:args m3820)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3823
      (com.palletops.awaze.common/aws-client :ec2 credentials3821)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3823
       createFlowLogs
       (ec2/create-flow-logs-request (clojure.core/nth args3822 0)))))))
  (clojure.core/defn
   create-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createFlowLogs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createFlowLogs"}
   [credentials3825 & args3826]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3827
     (com.palletops.awaze.common/aws-client :ec2 credentials3825)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3827
      createFlowLogs
      (ec2/create-flow-logs-request (clojure.core/nth args3826 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m3828]
   (clojure.core/let
    [credentials3829 (:credentials m3828) args3830 (:args m3828)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3831
      (com.palletops.awaze.common/aws-client :ec2 credentials3829)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3831
       disassociateAddress
       (ec2/disassociate-address-request
        (clojure.core/nth args3830 0)))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for disassociateAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call disassociateAddress"}
   [credentials3833 & args3834]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3835
     (com.palletops.awaze.common/aws-client :ec2 credentials3833)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3835
      disassociateAddress
      (ec2/disassociate-address-request (clojure.core/nth args3834 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m3836]
   (clojure.core/let
    [credentials3837 (:credentials m3836) args3838 (:args m3836)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3839
      (com.palletops.awaze.common/aws-client :ec2 credentials3837)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3839
       resetNetworkInterfaceAttribute
       (ec2/reset-network-interface-attribute-request
        (clojure.core/nth args3838 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials3841 & args3842]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3843
     (com.palletops.awaze.common/aws-client :ec2 credentials3841)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3843
      resetNetworkInterfaceAttribute
      (ec2/reset-network-interface-attribute-request
       (clojure.core/nth args3842 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m3844]
   (clojure.core/let
    [credentials3845 (:credentials m3844) args3846 (:args m3844)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3847
      (com.palletops.awaze.common/aws-client :ec2 credentials3845)]
     (clojure.core/case
      (clojure.core/count args3846)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3847
        describePlacementGroups
        (ec2/describe-placement-groups-request
         (clojure.core/nth args3846 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3847
        describePlacementGroups))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-placement-groups,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-placement-groups,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials3849 & args3850]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3851
     (com.palletops.awaze.common/aws-client :ec2 credentials3849)]
    (clojure.core/case
     (clojure.core/count args3850)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3851
       describePlacementGroups
       (ec2/describe-placement-groups-request
        (clojure.core/nth args3850 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3851
       describePlacementGroups))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m3852]
   (clojure.core/let
    [credentials3853 (:credentials m3852) args3854 (:args m3852)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3855
      (com.palletops.awaze.common/aws-client :ec2 credentials3853)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3855
       resetSnapshotAttribute
       (ec2/reset-snapshot-attribute-request
        (clojure.core/nth args3854 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials3857 & args3858]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3859
     (com.palletops.awaze.common/aws-client :ec2 credentials3857)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3859
      resetSnapshotAttribute
      (ec2/reset-snapshot-attribute-request
       (clojure.core/nth args3858 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m3860]
   (clojure.core/let
    [credentials3861 (:credentials m3860) args3862 (:args m3860)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3863
      (com.palletops.awaze.common/aws-client :ec2 credentials3861)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3863
       releaseAddress
       (ec2/release-address-request (clojure.core/nth args3862 0)))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for releaseAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :release-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call releaseAddress"}
   [credentials3865 & args3866]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3867
     (com.palletops.awaze.common/aws-client :ec2 credentials3865)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3867
      releaseAddress
      (ec2/release-address-request (clojure.core/nth args3866 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m3868]
   (clojure.core/let
    [credentials3869 (:credentials m3868) args3870 (:args m3868)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3871
      (com.palletops.awaze.common/aws-client :ec2 credentials3869)]
     (clojure.core/case
      (clojure.core/count args3870)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3871
        describeVolumeStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3871
        describeVolumeStatus
        (ec2/describe-volume-status-request
         (clojure.core/nth args3870 0))))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-volume-status,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volume-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials3873 & args3874]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3875
     (com.palletops.awaze.common/aws-client :ec2 credentials3873)]
    (clojure.core/case
     (clojure.core/count args3874)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3875
       describeVolumeStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3875
       describeVolumeStatus
       (ec2/describe-volume-status-request
        (clojure.core/nth args3874 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m3876]
   (clojure.core/let
    [credentials3877 (:credentials m3876) args3878 (:args m3876)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3879
      (com.palletops.awaze.common/aws-client :ec2 credentials3877)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3879
       bundleInstance
       (ec2/bundle-instance-request (clojure.core/nth args3878 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :bundle-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Call bundleInstance"}
   [credentials3881 & args3882]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3883
     (com.palletops.awaze.common/aws-client :ec2 credentials3881)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3883
      bundleInstance
      (ec2/bundle-instance-request (clojure.core/nth args3882 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m3884]
   (clojure.core/let
    [credentials3885 (:credentials m3884) args3886 (:args m3884)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3887
      (com.palletops.awaze.common/aws-client :ec2 credentials3885)]
     (clojure.core/case
      (clojure.core/count args3886)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3887
        describeVpnConnections
        (ec2/describe-vpn-connections-request
         (clojure.core/nth args3886 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3887
        describeVpnConnections))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpn-connections,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpn-connections,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials3889 & args3890]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3891
     (com.palletops.awaze.common/aws-client :ec2 credentials3889)]
    (clojure.core/case
     (clojure.core/count args3890)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3891
       describeVpnConnections
       (ec2/describe-vpn-connections-request
        (clojure.core/nth args3890 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3891
       describeVpnConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m3892]
   (clojure.core/let
    [credentials3893 (:credentials m3892) args3894 (:args m3892)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3895
      (com.palletops.awaze.common/aws-client :ec2 credentials3893)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3895
       createRoute
       (ec2/create-route-request (clojure.core/nth args3894 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call createRoute"}
   [credentials3897 & args3898]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3899
     (com.palletops.awaze.common/aws-client :ec2 credentials3897)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3899
      createRoute
      (ec2/create-route-request (clojure.core/nth args3898 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m3900]
   (clojure.core/let
    [credentials3901 (:credentials m3900) args3902 (:args m3900)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3903
      (com.palletops.awaze.common/aws-client :ec2 credentials3901)]
     (clojure.core/case
      (clojure.core/count args3902)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3903
        describeSpotPriceHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3903
        describeSpotPriceHistory
        (ec2/describe-spot-price-history-request
         (clojure.core/nth args3902 0))))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-price-history,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-price-history,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials3905 & args3906]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3907
     (com.palletops.awaze.common/aws-client :ec2 credentials3905)]
    (clojure.core/case
     (clojure.core/count args3906)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3907
       describeSpotPriceHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3907
       describeSpotPriceHistory
       (ec2/describe-spot-price-history-request
        (clojure.core/nth args3906 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m3908]
   (clojure.core/let
    [credentials3909 (:credentials m3908) args3910 (:args m3908)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3911
      (com.palletops.awaze.common/aws-client :ec2 credentials3909)]
     (clojure.core/case
      (clojure.core/count args3910)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3911
        describeAvailabilityZones
        (ec2/describe-availability-zones-request
         (clojure.core/nth args3910 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3911
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-availability-zones,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-availability-zones,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials3913 & args3914]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3915
     (com.palletops.awaze.common/aws-client :ec2 credentials3913)]
    (clojure.core/case
     (clojure.core/count args3914)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3915
       describeAvailabilityZones
       (ec2/describe-availability-zones-request
        (clojure.core/nth args3914 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3915
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-peering-connection
   [m3916]
   (clojure.core/let
    [credentials3917 (:credentials m3916) args3918 (:args m3916)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3919
      (com.palletops.awaze.common/aws-client :ec2 credentials3917)]
     (clojure.core/case
      (clojure.core/count args3918)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3919
        createVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3919
        createVpcPeeringConnection
        (ec2/create-vpc-peering-connection-request
         (clojure.core/nth args3918 0))))))))
  (clojure.core/defn
   create-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpcPeeringConnection, createVpcPeeringConnection"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpcPeeringConnection, createVpcPeeringConnection"}
   [credentials3921 & args3922]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3923
     (com.palletops.awaze.common/aws-client :ec2 credentials3921)]
    (clojure.core/case
     (clojure.core/count args3922)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3923
       createVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3923
       createVpcPeeringConnection
       (ec2/create-vpc-peering-connection-request
        (clojure.core/nth args3922 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m3924]
   (clojure.core/let
    [credentials3925 (:credentials m3924) args3926 (:args m3924)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3927
      (com.palletops.awaze.common/aws-client :ec2 credentials3925)]
     (clojure.core/case
      (clojure.core/count args3926)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3927
        describeInternetGateways
        (ec2/describe-internet-gateways-request
         (clojure.core/nth args3926 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3927
        describeInternetGateways))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-internet-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-internet-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials3929 & args3930]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3931
     (com.palletops.awaze.common/aws-client :ec2 credentials3929)]
    (clojure.core/case
     (clojure.core/count args3930)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3931
       describeInternetGateways
       (ec2/describe-internet-gateways-request
        (clojure.core/nth args3930 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3931
       describeInternetGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m3932]
   (clojure.core/let
    [credentials3933 (:credentials m3932) args3934 (:args m3932)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3935
      (com.palletops.awaze.common/aws-client :ec2 credentials3933)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3935
       disassociateRouteTable
       (ec2/disassociate-route-table-request
        (clojure.core/nth args3934 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials3937 & args3938]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3939
     (com.palletops.awaze.common/aws-client :ec2 credentials3937)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3939
      disassociateRouteTable
      (ec2/disassociate-route-table-request
       (clojure.core/nth args3938 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m3940]
   (clojure.core/let
    [credentials3941 (:credentials m3940) args3942 (:args m3940)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3943
      (com.palletops.awaze.common/aws-client :ec2 credentials3941)]
     (clojure.core/case
      (clojure.core/count args3942)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3943
        describeRegions
        (ec2/describe-regions-request (clojure.core/nth args3942 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3943
        describeRegions))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-regions,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-regions,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials3945 & args3946]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3947
     (com.palletops.awaze.common/aws-client :ec2 credentials3945)]
    (clojure.core/case
     (clojure.core/count args3946)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3947
       describeRegions
       (ec2/describe-regions-request (clojure.core/nth args3946 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3947
       describeRegions))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link-dns-support
   [m3948]
   (clojure.core/let
    [credentials3949 (:credentials m3948) args3950 (:args m3948)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3951
      (com.palletops.awaze.common/aws-client :ec2 credentials3949)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3951
       enableVpcClassicLinkDnsSupport
       (ec2/enable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3950 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLinkDnsSupport"}
   [credentials3953 & args3954]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3955
     (com.palletops.awaze.common/aws-client :ec2 credentials3953)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3955
      enableVpcClassicLinkDnsSupport
      (ec2/enable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3954 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m3956]
   (clojure.core/let
    [credentials3957 (:credentials m3956) args3958 (:args m3956)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3959
      (com.palletops.awaze.common/aws-client :ec2 credentials3957)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3959
       deregisterImage
       (ec2/deregister-image-request (clojure.core/nth args3958 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deregister-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterImage"}
   [credentials3961 & args3962]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3963
     (com.palletops.awaze.common/aws-client :ec2 credentials3961)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3963
      deregisterImage
      (ec2/deregister-image-request (clojure.core/nth args3962 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m3964]
   (clojure.core/let
    [credentials3965 (:credentials m3964) args3966 (:args m3964)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3967
      (com.palletops.awaze.common/aws-client :ec2 credentials3965)]
     (clojure.core/case
      (clojure.core/count args3966)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3967
        deleteSpotDatafeedSubscription
        (ec2/delete-spot-datafeed-subscription-request
         (clojure.core/nth args3966 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3967
        deleteSpotDatafeedSubscription))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials3969 & args3970]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3971
     (com.palletops.awaze.common/aws-client :ec2 credentials3969)]
    (clojure.core/case
     (clojure.core/count args3970)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3971
       deleteSpotDatafeedSubscription
       (ec2/delete-spot-datafeed-subscription-request
        (clojure.core/nth args3970 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3971
       deleteSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m3972]
   (clojure.core/let
    [credentials3973 (:credentials m3972) args3974 (:args m3972)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3975
      (com.palletops.awaze.common/aws-client :ec2 credentials3973)]
     (clojure.core/case
      (clojure.core/count args3974)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3975
        describeCustomerGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3975
        describeCustomerGateways
        (ec2/describe-customer-gateways-request
         (clojure.core/nth args3974 0))))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-customer-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-customer-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials3977 & args3978]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3979
     (com.palletops.awaze.common/aws-client :ec2 credentials3977)]
    (clojure.core/case
     (clojure.core/count args3978)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3979
       describeCustomerGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3979
       describeCustomerGateways
       (ec2/describe-customer-gateways-request
        (clojure.core/nth args3978 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-request-history
   [m3980]
   (clojure.core/let
    [credentials3981 (:credentials m3980) args3982 (:args m3980)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3983
      (com.palletops.awaze.common/aws-client :ec2 credentials3981)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3983
       describeSpotFleetRequestHistory
       (ec2/describe-spot-fleet-request-history-request
        (clojure.core/nth args3982 0)))))))
  (clojure.core/defn
   describe-spot-fleet-request-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetRequestHistory"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-request-history,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-request-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetRequestHistory"}
   [credentials3985 & args3986]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3987
     (com.palletops.awaze.common/aws-client :ec2 credentials3985)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3987
      describeSpotFleetRequestHistory
      (ec2/describe-spot-fleet-request-history-request
       (clojure.core/nth args3986 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m3988]
   (clojure.core/let
    [credentials3989 (:credentials m3988) args3990 (:args m3988)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3991
      (com.palletops.awaze.common/aws-client :ec2 credentials3989)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3991
       createSubnet
       (ec2/create-subnet-request (clojure.core/nth args3990 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-subnet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createSubnet"}
   [credentials3993 & args3994]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3995
     (com.palletops.awaze.common/aws-client :ec2 credentials3993)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3995
      createSubnet
      (ec2/create-subnet-request (clojure.core/nth args3994 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m3996]
   (clojure.core/let
    [credentials3997 (:credentials m3996) args3998 (:args m3996)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3999
      (com.palletops.awaze.common/aws-client :ec2 credentials3997)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3999
       describeNetworkInterfaceAttribute
       (ec2/describe-network-interface-attribute-request
        (clojure.core/nth args3998 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials4001 & args4002]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4003
     (com.palletops.awaze.common/aws-client :ec2 credentials4001)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4003
      describeNetworkInterfaceAttribute
      (ec2/describe-network-interface-attribute-request
       (clojure.core/nth args4002 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-placement
   [m4004]
   (clojure.core/let
    [credentials4005 (:credentials m4004) args4006 (:args m4004)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4007
      (com.palletops.awaze.common/aws-client :ec2 credentials4005)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4007
       modifyInstancePlacement
       (ec2/modify-instance-placement-request
        (clojure.core/nth args4006 0)))))))
  (clojure.core/defn
   modify-instance-placement-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstancePlacement"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-placement,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-placement
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstancePlacement"}
   [credentials4009 & args4010]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4011
     (com.palletops.awaze.common/aws-client :ec2 credentials4009)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4011
      modifyInstancePlacement
      (ec2/modify-instance-placement-request
       (clojure.core/nth args4010 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-classic-link-vpc
   [m4012]
   (clojure.core/let
    [credentials4013 (:credentials m4012) args4014 (:args m4012)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4015
      (com.palletops.awaze.common/aws-client :ec2 credentials4013)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4015
       detachClassicLinkVpc
       (ec2/detach-classic-link-vpc-request
        (clojure.core/nth args4014 0)))))))
  (clojure.core/defn
   detach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachClassicLinkVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-classic-link-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachClassicLinkVpc"}
   [credentials4017 & args4018]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4019
     (com.palletops.awaze.common/aws-client :ec2 credentials4017)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4019
      detachClassicLinkVpc
      (ec2/detach-classic-link-vpc-request
       (clojure.core/nth args4018 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m4020]
   (clojure.core/let
    [credentials4021 (:credentials m4020) args4022 (:args m4020)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4023
      (com.palletops.awaze.common/aws-client :ec2 credentials4021)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4023
       cancelConversionTask
       (ec2/cancel-conversion-task-request
        (clojure.core/nth args4022 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-conversion-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelConversionTask"}
   [credentials4025 & args4026]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4027
     (com.palletops.awaze.common/aws-client :ec2 credentials4025)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4027
      cancelConversionTask
      (ec2/cancel-conversion-task-request
       (clojure.core/nth args4026 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m4028]
   (clojure.core/let
    [credentials4029 (:credentials m4028) args4030 (:args m4028)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4031
      (com.palletops.awaze.common/aws-client :ec2 credentials4029)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4031
       createNetworkInterface
       (ec2/create-network-interface-request
        (clojure.core/nth args4030 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Call createNetworkInterface"}
   [credentials4033 & args4034]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4035
     (com.palletops.awaze.common/aws-client :ec2 credentials4033)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4035
      createNetworkInterface
      (ec2/create-network-interface-request
       (clojure.core/nth args4034 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m4036]
   (clojure.core/let
    [credentials4037 (:credentials m4036) args4038 (:args m4036)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4039
      (com.palletops.awaze.common/aws-client :ec2 credentials4037)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4039
       modifyImageAttribute
       (ec2/modify-image-attribute-request
        (clojure.core/nth args4038 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials4041 & args4042]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4043
     (com.palletops.awaze.common/aws-client :ec2 credentials4041)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4043
      modifyImageAttribute
      (ec2/modify-image-attribute-request
       (clojure.core/nth args4042 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m4044]
   (clojure.core/let
    [credentials4045 (:credentials m4044) args4046 (:args m4044)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4047
      (com.palletops.awaze.common/aws-client :ec2 credentials4045)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4047
       deleteRouteTable
       (ec2/delete-route-table-request (clojure.core/nth args4046 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRouteTable"}
   [credentials4049 & args4050]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4051
     (com.palletops.awaze.common/aws-client :ec2 credentials4049)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4051
      deleteRouteTable
      (ec2/delete-route-table-request (clojure.core/nth args4050 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m4052]
   (clojure.core/let
    [credentials4053 (:credentials m4052) args4054 (:args m4052)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4055
      (com.palletops.awaze.common/aws-client :ec2 credentials4053)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4055
       associateRouteTable
       (ec2/associate-route-table-request
        (clojure.core/nth args4054 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call associateRouteTable"}
   [credentials4057 & args4058]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4059
     (com.palletops.awaze.common/aws-client :ec2 credentials4057)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4059
      associateRouteTable
      (ec2/associate-route-table-request
       (clojure.core/nth args4058 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m4060]
   (clojure.core/let
    [credentials4061 (:credentials m4060) args4062 (:args m4060)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4063
      (com.palletops.awaze.common/aws-client :ec2 credentials4061)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4063
       deleteCustomerGateway
       (ec2/delete-customer-gateway-request
        (clojure.core/nth args4062 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-customer-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials4065 & args4066]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4067
     (com.palletops.awaze.common/aws-client :ec2 credentials4065)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4067
      deleteCustomerGateway
      (ec2/delete-customer-gateway-request
       (clojure.core/nth args4066 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m4068]
   (clojure.core/let
    [credentials4069 (:credentials m4068) args4070 (:args m4068)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4071
      (com.palletops.awaze.common/aws-client :ec2 credentials4069)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4071
       replaceRouteTableAssociation
       (ec2/replace-route-table-association-request
        (clojure.core/nth args4070 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-route-table-association,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials4073 & args4074]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4075
     (com.palletops.awaze.common/aws-client :ec2 credentials4073)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4075
      replaceRouteTableAssociation
      (ec2/replace-route-table-association-request
       (clojure.core/nth args4074 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m4076]
   (clojure.core/let
    [credentials4077 (:credentials m4076) args4078 (:args m4076)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4079
      (com.palletops.awaze.common/aws-client :ec2 credentials4077)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4079
       deleteVpc
       (ec2/delete-vpc-request (clojure.core/nth args4078 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpc"}
   [credentials4081 & args4082]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4083
     (com.palletops.awaze.common/aws-client :ec2 credentials4081)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4083
      deleteVpc
      (ec2/delete-vpc-request (clojure.core/nth args4082 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m4084]
   (clojure.core/let
    [credentials4085 (:credentials m4084) args4086 (:args m4084)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4087
      (com.palletops.awaze.common/aws-client :ec2 credentials4085)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4087
       createKeyPair
       (ec2/create-key-pair-request (clojure.core/nth args4086 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createKeyPair"}
   [credentials4089 & args4090]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4091
     (com.palletops.awaze.common/aws-client :ec2 credentials4089)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4091
      createKeyPair
      (ec2/create-key-pair-request (clojure.core/nth args4090 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-hosts
   [m4092]
   (clojure.core/let
    [credentials4093 (:credentials m4092) args4094 (:args m4092)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4095
      (com.palletops.awaze.common/aws-client :ec2 credentials4093)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4095
       allocateHosts
       (ec2/allocate-hosts-request (clojure.core/nth args4094 0)))))))
  (clojure.core/defn
   allocate-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Generate map for allocateHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Call allocateHosts"}
   [credentials4097 & args4098]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4099
     (com.palletops.awaze.common/aws-client :ec2 credentials4097)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4099
      allocateHosts
      (ec2/allocate-hosts-request (clojure.core/nth args4098 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m4100]
   (clojure.core/let
    [credentials4101 (:credentials m4100) args4102 (:args m4100)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4103
      (com.palletops.awaze.common/aws-client :ec2 credentials4101)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4103
       replaceRoute
       (ec2/replace-route-request (clojure.core/nth args4102 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRoute"}
   [credentials4105 & args4106]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4107
     (com.palletops.awaze.common/aws-client :ec2 credentials4105)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4107
      replaceRoute
      (ec2/replace-route-request (clojure.core/nth args4106 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m4108]
   (clojure.core/let
    [credentials4109 (:credentials m4108) args4110 (:args m4108)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4111
      (com.palletops.awaze.common/aws-client :ec2 credentials4109)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4111
       terminateInstances
       (ec2/terminate-instances-request (clojure.core/nth args4110 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstances"}
   [credentials4113 & args4114]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4115
     (com.palletops.awaze.common/aws-client :ec2 credentials4113)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4115
      terminateInstances
      (ec2/terminate-instances-request (clojure.core/nth args4114 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m4116]
   (clojure.core/let
    [credentials4117 (:credentials m4116) args4118 (:args m4116)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4119
      (com.palletops.awaze.common/aws-client :ec2 credentials4117)]
     (clojure.core/case
      (clojure.core/count args4118)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4119
        describeSnapshots
        (ec2/describe-snapshots-request (clojure.core/nth args4118 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4119
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials4121 & args4122]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4123
     (com.palletops.awaze.common/aws-client :ec2 credentials4121)]
    (clojure.core/case
     (clojure.core/count args4122)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4123
       describeSnapshots
       (ec2/describe-snapshots-request (clojure.core/nth args4122 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4123
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m4124]
   (clojure.core/let
    [credentials4125 (:credentials m4124) args4126 (:args m4124)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4127
      (com.palletops.awaze.common/aws-client :ec2 credentials4125)]
     (clojure.core/case
      (clojure.core/count args4126)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4127
        describeVpnGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4127
        describeVpnGateways
        (ec2/describe-vpn-gateways-request
         (clojure.core/nth args4126 0))))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpn-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpn-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials4129 & args4130]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4131
     (com.palletops.awaze.common/aws-client :ec2 credentials4129)]
    (clojure.core/case
     (clojure.core/count args4130)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4131
       describeVpnGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4131
       describeVpnGateways
       (ec2/describe-vpn-gateways-request
        (clojure.core/nth args4130 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m4132]
   (clojure.core/let
    [credentials4133 (:credentials m4132) args4134 (:args m4132)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4135
      (com.palletops.awaze.common/aws-client :ec2 credentials4133)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4135
       getPasswordData
       (ec2/get-password-data-request (clojure.core/nth args4134 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-password-data,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPasswordData"}
   [credentials4137 & args4138]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4139
     (com.palletops.awaze.common/aws-client :ec2 credentials4137)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4139
      getPasswordData
      (ec2/get-password-data-request (clojure.core/nth args4138 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m4140]
   (clojure.core/let
    [credentials4141 (:credentials m4140) args4142 (:args m4140)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4143
      (com.palletops.awaze.common/aws-client :ec2 credentials4141)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4143
       modifyVolumeAttribute
       (ec2/modify-volume-attribute-request
        (clojure.core/nth args4142 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-volume-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials4145 & args4146]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4147
     (com.palletops.awaze.common/aws-client :ec2 credentials4145)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4147
      modifyVolumeAttribute
      (ec2/modify-volume-attribute-request
       (clojure.core/nth args4146 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m4148]
   (clojure.core/let
    [credentials4149 (:credentials m4148) args4150 (:args m4148)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4151
      (com.palletops.awaze.common/aws-client :ec2 credentials4149)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4151
       disableVgwRoutePropagation
       (ec2/disable-vgw-route-propagation-request
        (clojure.core/nth args4150 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials4153 & args4154]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4155
     (com.palletops.awaze.common/aws-client :ec2 credentials4153)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4155
      disableVgwRoutePropagation
      (ec2/disable-vgw-route-propagation-request
       (clojure.core/nth args4154 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-instances
   [m4156]
   (clojure.core/let
    [credentials4157 (:credentials m4156) args4158 (:args m4156)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4159
      (com.palletops.awaze.common/aws-client :ec2 credentials4157)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4159
       describeSpotFleetInstances
       (ec2/describe-spot-fleet-instances-request
        (clojure.core/nth args4158 0)))))))
  (clojure.core/defn
   describe-spot-fleet-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetInstances"}
   [credentials4161 & args4162]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4163
     (com.palletops.awaze.common/aws-client :ec2 credentials4161)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4163
      describeSpotFleetInstances
      (ec2/describe-spot-fleet-instances-request
       (clojure.core/nth args4162 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-prefix-lists
   [m4164]
   (clojure.core/let
    [credentials4165 (:credentials m4164) args4166 (:args m4164)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4167
      (com.palletops.awaze.common/aws-client :ec2 credentials4165)]
     (clojure.core/case
      (clojure.core/count args4166)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4167
        describePrefixLists))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4167
        describePrefixLists
        (ec2/describe-prefix-lists-request
         (clojure.core/nth args4166 0))))))))
  (clojure.core/defn
   describe-prefix-lists-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describePrefixLists, describePrefixLists"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-prefix-lists,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-prefix-lists,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-prefix-lists
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describePrefixLists, describePrefixLists"}
   [credentials4169 & args4170]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4171
     (com.palletops.awaze.common/aws-client :ec2 credentials4169)]
    (clojure.core/case
     (clojure.core/count args4170)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4171
       describePrefixLists))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4171
       describePrefixLists
       (ec2/describe-prefix-lists-request
        (clojure.core/nth args4170 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m4172]
   (clojure.core/let
    [credentials4173 (:credentials m4172) args4174 (:args m4172)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4175
      (com.palletops.awaze.common/aws-client :ec2 credentials4173)]
     (clojure.core/case
      (clojure.core/count args4174)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4175
        describeAccountAttributes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4175
        describeAccountAttributes
        (ec2/describe-account-attributes-request
         (clojure.core/nth args4174 0))))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials4177 & args4178]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4179
     (com.palletops.awaze.common/aws-client :ec2 credentials4177)]
    (clojure.core/case
     (clojure.core/count args4178)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4179
       describeAccountAttributes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4179
       describeAccountAttributes
       (ec2/describe-account-attributes-request
        (clojure.core/nth args4178 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m4180]
   (clojure.core/let
    [credentials4181 (:credentials m4180) args4182 (:args m4180)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4183
      (com.palletops.awaze.common/aws-client :ec2 credentials4181)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4183
       createVpnConnection
       (ec2/create-vpn-connection-request
        (clojure.core/nth args4182 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnection"}
   [credentials4185 & args4186]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4187
     (com.palletops.awaze.common/aws-client :ec2 credentials4185)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4187
      createVpnConnection
      (ec2/create-vpn-connection-request
       (clojure.core/nth args4186 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-peering-connections
   [m4188]
   (clojure.core/let
    [credentials4189 (:credentials m4188) args4190 (:args m4188)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4191
      (com.palletops.awaze.common/aws-client :ec2 credentials4189)]
     (clojure.core/case
      (clojure.core/count args4190)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4191
        describeVpcPeeringConnections
        (ec2/describe-vpc-peering-connections-request
         (clojure.core/nth args4190 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4191
        describeVpcPeeringConnections))))))
  (clojure.core/defn
   describe-vpc-peering-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcPeeringConnections, describeVpcPeeringConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-peering-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcPeeringConnections, describeVpcPeeringConnections"}
   [credentials4193 & args4194]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4195
     (com.palletops.awaze.common/aws-client :ec2 credentials4193)]
    (clojure.core/case
     (clojure.core/count args4194)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4195
       describeVpcPeeringConnections
       (ec2/describe-vpc-peering-connections-request
        (clojure.core/nth args4194 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4195
       describeVpcPeeringConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instance-availability
   [m4196]
   (clojure.core/let
    [credentials4197 (:credentials m4196) args4198 (:args m4196)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4199
      (com.palletops.awaze.common/aws-client :ec2 credentials4197)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4199
       describeScheduledInstanceAvailability
       (ec2/describe-scheduled-instance-availability-request
        (clojure.core/nth args4198 0)))))))
  (clojure.core/defn
   describe-scheduled-instance-availability-map
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstanceAvailability"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instance-availability,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instance-availability
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstanceAvailability"}
   [credentials4201 & args4202]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4203
     (com.palletops.awaze.common/aws-client :ec2 credentials4201)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4203
      describeScheduledInstanceAvailability
      (ec2/describe-scheduled-instance-availability-request
       (clojure.core/nth args4202 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-flow-logs
   [m4204]
   (clojure.core/let
    [credentials4205 (:credentials m4204) args4206 (:args m4204)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4207
      (com.palletops.awaze.common/aws-client :ec2 credentials4205)]
     (clojure.core/case
      (clojure.core/count args4206)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4207
        describeFlowLogs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4207
        describeFlowLogs
        (ec2/describe-flow-logs-request (clojure.core/nth args4206 0))))))))
  (clojure.core/defn
   describe-flow-logs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeFlowLogs, describeFlowLogs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-flow-logs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeFlowLogs, describeFlowLogs"}
   [credentials4209 & args4210]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4211
     (com.palletops.awaze.common/aws-client :ec2 credentials4209)]
    (clojure.core/case
     (clojure.core/count args4210)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4211
       describeFlowLogs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4211
       describeFlowLogs
       (ec2/describe-flow-logs-request (clojure.core/nth args4210 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m4212]
   (clojure.core/let
    [credentials4213 (:credentials m4212) args4214 (:args m4212)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4215
      (com.palletops.awaze.common/aws-client :ec2 credentials4213)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4215
       cancelBundleTask
       (ec2/cancel-bundle-task-request (clojure.core/nth args4214 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-bundle-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelBundleTask"}
   [credentials4217 & args4218]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4219
     (com.palletops.awaze.common/aws-client :ec2 credentials4217)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4219
      cancelBundleTask
      (ec2/cancel-bundle-task-request (clojure.core/nth args4218 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m4220]
   (clojure.core/let
    [credentials4221 (:credentials m4220) args4222 (:args m4220)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4223
      (com.palletops.awaze.common/aws-client :ec2 credentials4221)]
     (clojure.core/case
      (clojure.core/count args4222)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4223
        describeReservedInstances
        (ec2/describe-reserved-instances-request
         (clojure.core/nth args4222 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4223
        describeReservedInstances))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials4225 & args4226]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4227
     (com.palletops.awaze.common/aws-client :ec2 credentials4225)]
    (clojure.core/case
     (clojure.core/count args4226)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4227
       describeReservedInstances
       (ec2/describe-reserved-instances-request
        (clojure.core/nth args4226 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4227
       describeReservedInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m4228]
   (clojure.core/let
    [credentials4229 (:credentials m4228) args4230 (:args m4228)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4231
      (com.palletops.awaze.common/aws-client :ec2 credentials4229)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4231
       unmonitorInstances
       (ec2/unmonitor-instances-request (clojure.core/nth args4230 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unmonitor-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unmonitorInstances"}
   [credentials4233 & args4234]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4235
     (com.palletops.awaze.common/aws-client :ec2 credentials4233)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4235
      unmonitorInstances
      (ec2/unmonitor-instances-request (clojure.core/nth args4234 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m4236]
   (clojure.core/let
    [credentials4237 (:credentials m4236) args4238 (:args m4236)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4239
      (com.palletops.awaze.common/aws-client :ec2 credentials4237)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4239
       deleteSecurityGroup
       (ec2/delete-security-group-request
        (clojure.core/nth args4238 0)))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-security-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSecurityGroup"}
   [credentials4241 & args4242]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4243
     (com.palletops.awaze.common/aws-client :ec2 credentials4241)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4243
      deleteSecurityGroup
      (ec2/delete-security-group-request
       (clojure.core/nth args4242 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m4244]
   (clojure.core/let
    [credentials4245 (:credentials m4244) args4246 (:args m4244)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4247
      (com.palletops.awaze.common/aws-client :ec2 credentials4245)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4247
       describeVpcAttribute
       (ec2/describe-vpc-attribute-request
        (clojure.core/nth args4246 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials4249 & args4250]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4251
     (com.palletops.awaze.common/aws-client :ec2 credentials4249)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4251
      describeVpcAttribute
      (ec2/describe-vpc-attribute-request
       (clojure.core/nth args4250 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m4252]
   (clojure.core/let
    [credentials4253 (:credentials m4252) args4254 (:args m4252)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4255
      (com.palletops.awaze.common/aws-client :ec2 credentials4253)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4255
       createNetworkAcl
       (ec2/create-network-acl-request (clojure.core/nth args4254 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-acl,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createNetworkAcl"}
   [credentials4257 & args4258]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4259
     (com.palletops.awaze.common/aws-client :ec2 credentials4257)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4259
      createNetworkAcl
      (ec2/create-network-acl-request (clojure.core/nth args4258 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-import-task
   [m4260]
   (clojure.core/let
    [credentials4261 (:credentials m4260) args4262 (:args m4260)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4263
      (com.palletops.awaze.common/aws-client :ec2 credentials4261)]
     (clojure.core/case
      (clojure.core/count args4262)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4263
        cancelImportTask
        (ec2/cancel-import-task-request (clojure.core/nth args4262 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4263
        cancelImportTask))))))
  (clojure.core/defn
   cancel-import-task-map
   {:arglists (quote
               [[credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for cancelImportTask, cancelImportTask"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :cancel-import-task,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-import-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-import-task
   {:arglists (quote
               [[credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]
                [credentials]]),
    :doc "Call cancelImportTask, cancelImportTask"}
   [credentials4265 & args4266]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4267
     (com.palletops.awaze.common/aws-client :ec2 credentials4265)]
    (clojure.core/case
     (clojure.core/count args4266)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4267
       cancelImportTask
       (ec2/cancel-import-task-request (clojure.core/nth args4266 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4267
       cancelImportTask))))))
 (do
  (clojure.core/defmethod
   ec2
   :accept-vpc-peering-connection
   [m4268]
   (clojure.core/let
    [credentials4269 (:credentials m4268) args4270 (:args m4268)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4271
      (com.palletops.awaze.common/aws-client :ec2 credentials4269)]
     (clojure.core/case
      (clojure.core/count args4270)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4271
        acceptVpcPeeringConnection
        (ec2/accept-vpc-peering-connection-request
         (clojure.core/nth args4270 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4271
        acceptVpcPeeringConnection))))))
  (clojure.core/defn
   accept-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   accept-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   [credentials4273 & args4274]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4275
     (com.palletops.awaze.common/aws-client :ec2 credentials4273)]
    (clojure.core/case
     (clojure.core/count args4274)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4275
       acceptVpcPeeringConnection
       (ec2/accept-vpc-peering-connection-request
        (clojure.core/nth args4274 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4275
       acceptVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoint-services
   [m4276]
   (clojure.core/let
    [credentials4277 (:credentials m4276) args4278 (:args m4276)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4279
      (com.palletops.awaze.common/aws-client :ec2 credentials4277)]
     (clojure.core/case
      (clojure.core/count args4278)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4279
        describeVpcEndpointServices
        (ec2/describe-vpc-endpoint-services-request
         (clojure.core/nth args4278 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4279
        describeVpcEndpointServices))))))
  (clojure.core/defn
   describe-vpc-endpoint-services-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVpcEndpointServices, describeVpcEndpointServices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoint-services
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVpcEndpointServices, describeVpcEndpointServices"}
   [credentials4281 & args4282]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4283
     (com.palletops.awaze.common/aws-client :ec2 credentials4281)]
    (clojure.core/case
     (clojure.core/count args4282)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4283
       describeVpcEndpointServices
       (ec2/describe-vpc-endpoint-services-request
        (clojure.core/nth args4282 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4283
       describeVpcEndpointServices))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-peering-connection
   [m4284]
   (clojure.core/let
    [credentials4285 (:credentials m4284) args4286 (:args m4284)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4287
      (com.palletops.awaze.common/aws-client :ec2 credentials4285)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4287
       deleteVpcPeeringConnection
       (ec2/delete-vpc-peering-connection-request
        (clojure.core/nth args4286 0)))))))
  (clojure.core/defn
   delete-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpcPeeringConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpcPeeringConnection"}
   [credentials4289 & args4290]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4291
     (com.palletops.awaze.common/aws-client :ec2 credentials4289)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4291
      deleteVpcPeeringConnection
      (ec2/delete-vpc-peering-connection-request
       (clojure.core/nth args4290 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m4292]
   (clojure.core/let
    [credentials4293 (:credentials m4292) args4294 (:args m4292)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4295
      (com.palletops.awaze.common/aws-client :ec2 credentials4293)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4295
       runInstances
       (ec2/run-instances-request (clojure.core/nth args4294 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call runInstances"}
   [credentials4297 & args4298]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4299
     (com.palletops.awaze.common/aws-client :ec2 credentials4297)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4299
      runInstances
      (ec2/run-instances-request (clojure.core/nth args4298 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m4300]
   (clojure.core/let
    [credentials4301 (:credentials m4300) args4302 (:args m4300)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4303
      (com.palletops.awaze.common/aws-client :ec2 credentials4301)]
     (clojure.core/case
      (clojure.core/count args4302)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4303
        describeInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4303
        describeInstanceStatus
        (ec2/describe-instance-status-request
         (clojure.core/nth args4302 0))))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials4305 & args4306]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4307
     (com.palletops.awaze.common/aws-client :ec2 credentials4305)]
    (clojure.core/case
     (clojure.core/count args4306)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4307
       describeInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4307
       describeInstanceStatus
       (ec2/describe-instance-status-request
        (clojure.core/nth args4306 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link-dns-support
   [m4308]
   (clojure.core/let
    [credentials4309 (:credentials m4308) args4310 (:args m4308)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4311
      (com.palletops.awaze.common/aws-client :ec2 credentials4309)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4311
       describeVpcClassicLinkDnsSupport
       (ec2/describe-vpc-classic-link-dns-support-request
        (clojure.core/nth args4310 0)))))))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcClassicLinkDnsSupport"}
   [credentials4313 & args4314]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4315
     (com.palletops.awaze.common/aws-client :ec2 credentials4313)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4315
      describeVpcClassicLinkDnsSupport
      (ec2/describe-vpc-classic-link-dns-support-request
       (clojure.core/nth args4314 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m4316]
   (clojure.core/let
    [credentials4317 (:credentials m4316) args4318 (:args m4316)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4319
      (com.palletops.awaze.common/aws-client :ec2 credentials4317)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4319
       unassignPrivateIpAddresses
       (ec2/unassign-private-ip-addresses-request
        (clojure.core/nth args4318 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials4321 & args4322]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4323
     (com.palletops.awaze.common/aws-client :ec2 credentials4321)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4323
      unassignPrivateIpAddresses
      (ec2/unassign-private-ip-addresses-request
       (clojure.core/nth args4322 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m4324]
   (clojure.core/let
    [credentials4325 (:credentials m4324) args4326 (:args m4324)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4327
      (com.palletops.awaze.common/aws-client :ec2 credentials4325)]
     (clojure.core/case
      (clojure.core/count args4326)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4327
        describeSecurityGroups
        (ec2/describe-security-groups-request
         (clojure.core/nth args4326 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4327
        describeSecurityGroups))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-security-groups,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-security-groups,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials4329 & args4330]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4331
     (com.palletops.awaze.common/aws-client :ec2 credentials4329)]
    (clojure.core/case
     (clojure.core/count args4330)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4331
       describeSecurityGroups
       (ec2/describe-security-groups-request
        (clojure.core/nth args4330 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4331
       describeSecurityGroups))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m4332]
   (clojure.core/let
    [credentials4333 (:credentials m4332) args4334 (:args m4332)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4335
      (com.palletops.awaze.common/aws-client :ec2 credentials4333)]
     (clojure.core/case
      (clojure.core/count args4334)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4335
        describeNetworkInterfaces
        (ec2/describe-network-interfaces-request
         (clojure.core/nth args4334 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4335
        describeNetworkInterfaces))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]
                [credentials]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-network-interfaces,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-interfaces,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]
                [credentials]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials4337 & args4338]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4339
     (com.palletops.awaze.common/aws-client :ec2 credentials4337)]
    (clojure.core/case
     (clojure.core/count args4338)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4339
       describeNetworkInterfaces
       (ec2/describe-network-interfaces-request
        (clojure.core/nth args4338 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4339
       describeNetworkInterfaces))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m4340]
   (clojure.core/let
    [credentials4341 (:credentials m4340) args4342 (:args m4340)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4343
      (com.palletops.awaze.common/aws-client :ec2 credentials4341)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4343
       createCustomerGateway
       (ec2/create-customer-gateway-request
        (clojure.core/nth args4342 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-customer-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call createCustomerGateway"}
   [credentials4345 & args4346]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4347
     (com.palletops.awaze.common/aws-client :ec2 credentials4345)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4347
      createCustomerGateway
      (ec2/create-customer-gateway-request
       (clojure.core/nth args4346 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m4348]
   (clojure.core/let
    [credentials4349 (:credentials m4348) args4350 (:args m4348)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4351
      (com.palletops.awaze.common/aws-client :ec2 credentials4349)]
     (clojure.core/case
      (clojure.core/count args4350)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4351
        describeDhcpOptions
        (ec2/describe-dhcp-options-request
         (clojure.core/nth args4350 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4351
        describeDhcpOptions))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials4353 & args4354]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4355
     (com.palletops.awaze.common/aws-client :ec2 credentials4353)]
    (clojure.core/case
     (clojure.core/count args4354)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4355
       describeDhcpOptions
       (ec2/describe-dhcp-options-request
        (clojure.core/nth args4354 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4355
       describeDhcpOptions))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m4356]
   (clojure.core/let
    [credentials4357 (:credentials m4356) args4358 (:args m4356)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4359
      (com.palletops.awaze.common/aws-client :ec2 credentials4357)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4359
       createTags
       (ec2/create-tags-request (clojure.core/nth args4358 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials4361 & args4362]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4363
     (com.palletops.awaze.common/aws-client :ec2 credentials4361)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4363
      createTags
      (ec2/create-tags-request (clojure.core/nth args4362 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m4364]
   (clojure.core/let
    [credentials4365 (:credentials m4364) args4366 (:args m4364)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4367
      (com.palletops.awaze.common/aws-client :ec2 credentials4365)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4367
       createSnapshot
       (ec2/create-snapshot-request (clojure.core/nth args4366 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials4369 & args4370]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4371
     (com.palletops.awaze.common/aws-client :ec2 credentials4369)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4371
      createSnapshot
      (ec2/create-snapshot-request (clojure.core/nth args4370 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-image
   [m4372]
   (clojure.core/let
    [credentials4373 (:credentials m4372) args4374 (:args m4372)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4375
      (com.palletops.awaze.common/aws-client :ec2 credentials4373)]
     (clojure.core/case
      (clojure.core/count args4374)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4375
        importImage))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4375
        importImage
        (ec2/import-image-request (clojure.core/nth args4374 0))))))))
  (clojure.core/defn
   import-image-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]]),
    :doc "Generate map for importImage, importImage"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :import-image,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-image
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]]),
    :doc "Call importImage, importImage"}
   [credentials4377 & args4378]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4379
     (com.palletops.awaze.common/aws-client :ec2 credentials4377)]
    (clojure.core/case
     (clojure.core/count args4378)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4379
       importImage))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4379
       importImage
       (ec2/import-image-request (clojure.core/nth args4378 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m4380]
   (clojure.core/let
    [credentials4381 (:credentials m4380) args4382 (:args m4380)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4383
      (com.palletops.awaze.common/aws-client :ec2 credentials4381)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4383
       createRouteTable
       (ec2/create-route-table-request (clojure.core/nth args4382 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRouteTable"}
   [credentials4385 & args4386]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4387
     (com.palletops.awaze.common/aws-client :ec2 credentials4385)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4387
      createRouteTable
      (ec2/create-route-table-request (clojure.core/nth args4386 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-hosts
   [m4388]
   (clojure.core/let
    [credentials4389 (:credentials m4388) args4390 (:args m4388)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4391
      (com.palletops.awaze.common/aws-client :ec2 credentials4389)]
     (clojure.core/case
      (clojure.core/count args4390)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4391
        describeHosts))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4391
        describeHosts
        (ec2/describe-hosts-request (clojure.core/nth args4390 0))))))))
  (clojure.core/defn
   describe-hosts-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeHosts, describeHosts"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-hosts
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeHosts, describeHosts"}
   [credentials4393 & args4394]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4395
     (com.palletops.awaze.common/aws-client :ec2 credentials4393)]
    (clojure.core/case
     (clojure.core/count args4394)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4395
       describeHosts))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4395
       describeHosts
       (ec2/describe-hosts-request (clojure.core/nth args4394 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m4396]
   (clojure.core/let
    [credentials4397 (:credentials m4396) args4398 (:args m4396)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4399
      (com.palletops.awaze.common/aws-client :ec2 credentials4397)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4399
       describeVolumeAttribute
       (ec2/describe-volume-attribute-request
        (clojure.core/nth args4398 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volume-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials4401 & args4402]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4403
     (com.palletops.awaze.common/aws-client :ec2 credentials4401)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4403
      describeVolumeAttribute
      (ec2/describe-volume-attribute-request
       (clojure.core/nth args4402 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-id-format
   [m4404]
   (clojure.core/let
    [credentials4405 (:credentials m4404) args4406 (:args m4404)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4407
      (com.palletops.awaze.common/aws-client :ec2 credentials4405)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4407
       modifyIdFormat
       (ec2/modify-id-format-request (clojure.core/nth args4406 0)))))))
  (clojure.core/defn
   modify-id-format-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyIdFormat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-id-format
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyIdFormat"}
   [credentials4409 & args4410]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4411
     (com.palletops.awaze.common/aws-client :ec2 credentials4409)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4411
      modifyIdFormat
      (ec2/modify-id-format-request (clojure.core/nth args4410 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m4412]
   (clojure.core/let
    [credentials4413 (:credentials m4412) args4414 (:args m4412)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4415
      (com.palletops.awaze.common/aws-client :ec2 credentials4413)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4415
       createNetworkAclEntry
       (ec2/create-network-acl-entry-request
        (clojure.core/nth args4414 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials4417 & args4418]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4419
     (com.palletops.awaze.common/aws-client :ec2 credentials4417)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4419
      createNetworkAclEntry
      (ec2/create-network-acl-entry-request
       (clojure.core/nth args4418 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-nat-gateways
   [m4420]
   (clojure.core/let
    [credentials4421 (:credentials m4420) args4422 (:args m4420)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4423
      (com.palletops.awaze.common/aws-client :ec2 credentials4421)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4423
       describeNatGateways
       (ec2/describe-nat-gateways-request
        (clojure.core/nth args4422 0)))))))
  (clojure.core/defn
   describe-nat-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeNatGateways"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-nat-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-nat-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeNatGateways"}
   [credentials4425 & args4426]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4427
     (com.palletops.awaze.common/aws-client :ec2 credentials4425)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4427
      describeNatGateways
      (ec2/describe-nat-gateways-request
       (clojure.core/nth args4426 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m4428]
   (clojure.core/let
    [credentials4429 (:credentials m4428) args4430 (:args m4428)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4431
      (com.palletops.awaze.common/aws-client :ec2 credentials4429)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4431
       cancelReservedInstancesListing
       (ec2/cancel-reserved-instances-listing-request
        (clojure.core/nth args4430 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials4433 & args4434]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4435
     (com.palletops.awaze.common/aws-client :ec2 credentials4433)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4435
      cancelReservedInstancesListing
      (ec2/cancel-reserved-instances-listing-request
       (clojure.core/nth args4434 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link
   [m4436]
   (clojure.core/let
    [credentials4437 (:credentials m4436) args4438 (:args m4436)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4439
      (com.palletops.awaze.common/aws-client :ec2 credentials4437)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4439
       disableVpcClassicLink
       (ec2/disable-vpc-classic-link-request
        (clojure.core/nth args4438 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLink"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLink"}
   [credentials4441 & args4442]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4443
     (com.palletops.awaze.common/aws-client :ec2 credentials4441)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4443
      disableVpcClassicLink
      (ec2/disable-vpc-classic-link-request
       (clojure.core/nth args4442 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-scheduled-instances
   [m4444]
   (clojure.core/let
    [credentials4445 (:credentials m4444) args4446 (:args m4444)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4447
      (com.palletops.awaze.common/aws-client :ec2 credentials4445)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4447
       runScheduledInstances
       (ec2/run-scheduled-instances-request
        (clojure.core/nth args4446 0)))))))
  (clojure.core/defn
   run-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for runScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call runScheduledInstances"}
   [credentials4449 & args4450]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4451
     (com.palletops.awaze.common/aws-client :ec2 credentials4449)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4451
      runScheduledInstances
      (ec2/run-scheduled-instances-request
       (clojure.core/nth args4450 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m4452]
   (clojure.core/let
    [credentials4453 (:credentials m4452) args4454 (:args m4452)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4455
      (com.palletops.awaze.common/aws-client :ec2 credentials4453)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4455
       deleteKeyPair
       (ec2/delete-key-pair-request (clojure.core/nth args4454 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteKeyPair"}
   [credentials4457 & args4458]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4459
     (com.palletops.awaze.common/aws-client :ec2 credentials4457)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4459
      deleteKeyPair
      (ec2/delete-key-pair-request (clojure.core/nth args4458 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m4460]
   (clojure.core/let
    [credentials4461 (:credentials m4460) args4462 (:args m4460)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4463
      (com.palletops.awaze.common/aws-client :ec2 credentials4461)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4463
       modifyReservedInstances
       (ec2/modify-reserved-instances-request
        (clojure.core/nth args4462 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials4465 & args4466]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4467
     (com.palletops.awaze.common/aws-client :ec2 credentials4465)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4467
      modifyReservedInstances
      (ec2/modify-reserved-instances-request
       (clojure.core/nth args4466 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m4468]
   (clojure.core/let
    [credentials4469 (:credentials m4468) args4470 (:args m4468)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4471
      (com.palletops.awaze.common/aws-client :ec2 credentials4469)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4471
       deleteVpnConnectionRoute
       (ec2/delete-vpn-connection-route-request
        (clojure.core/nth args4470 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials4473 & args4474]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4475
     (com.palletops.awaze.common/aws-client :ec2 credentials4473)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4475
      deleteVpnConnectionRoute
      (ec2/delete-vpn-connection-route-request
       (clojure.core/nth args4474 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m4476]
   (clojure.core/let
    [credentials4477 (:credentials m4476) args4478 (:args m4476)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4479
      (com.palletops.awaze.common/aws-client :ec2 credentials4477)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4479
       attachInternetGateway
       (ec2/attach-internet-gateway-request
        (clojure.core/nth args4478 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call attachInternetGateway"}
   [credentials4481 & args4482]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4483
     (com.palletops.awaze.common/aws-client :ec2 credentials4481)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4483
      attachInternetGateway
      (ec2/attach-internet-gateway-request
       (clojure.core/nth args4482 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m4484]
   (clojure.core/let
    [credentials4485 (:credentials m4484) args4486 (:args m4484)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4487
      (com.palletops.awaze.common/aws-client :ec2 credentials4485)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4487
       modifyNetworkInterfaceAttribute
       (ec2/modify-network-interface-attribute-request
        (clojure.core/nth args4486 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials4489 & args4490]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4491
     (com.palletops.awaze.common/aws-client :ec2 credentials4489)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4491
      modifyNetworkInterfaceAttribute
      (ec2/modify-network-interface-attribute-request
       (clojure.core/nth args4490 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m4492]
   (clojure.core/let
    [credentials4493 (:credentials m4492) args4494 (:args m4492)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4495
      (com.palletops.awaze.common/aws-client :ec2 credentials4493)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4495
       enableVgwRoutePropagation
       (ec2/enable-vgw-route-propagation-request
        (clojure.core/nth args4494 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials4497 & args4498]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4499
     (com.palletops.awaze.common/aws-client :ec2 credentials4497)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4499
      enableVgwRoutePropagation
      (ec2/enable-vgw-route-propagation-request
       (clojure.core/nth args4498 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m4500]
   (clojure.core/let
    [credentials4501 (:credentials m4500) args4502 (:args m4500)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4503
      (com.palletops.awaze.common/aws-client :ec2 credentials4501)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4503
       deleteNetworkAclEntry
       (ec2/delete-network-acl-entry-request
        (clojure.core/nth args4502 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials4505 & args4506]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4507
     (com.palletops.awaze.common/aws-client :ec2 credentials4505)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4507
      deleteNetworkAclEntry
      (ec2/delete-network-acl-entry-request
       (clojure.core/nth args4506 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m4508]
   (clojure.core/let
    [credentials4509 (:credentials m4508) args4510 (:args m4508)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4511
      (com.palletops.awaze.common/aws-client :ec2 credentials4509)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4511
       cancelExportTask
       (ec2/cancel-export-task-request (clojure.core/nth args4510 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-export-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelExportTask"}
   [credentials4513 & args4514]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4515
     (com.palletops.awaze.common/aws-client :ec2 credentials4513)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4515
      cancelExportTask
      (ec2/cancel-export-task-request (clojure.core/nth args4514 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m4516]
   (clojure.core/let
    [credentials4517 (:credentials m4516) args4518 (:args m4516)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4519
      (com.palletops.awaze.common/aws-client :ec2 credentials4517)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4519
       createImage
       (ec2/create-image-request (clojure.core/nth args4518 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createImage"}
   [credentials4521 & args4522]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4523
     (com.palletops.awaze.common/aws-client :ec2 credentials4521)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4523
      createImage
      (ec2/create-image-request (clojure.core/nth args4522 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-spot-fleet-request
   [m4524]
   (clojure.core/let
    [credentials4525 (:credentials m4524) args4526 (:args m4524)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4527
      (com.palletops.awaze.common/aws-client :ec2 credentials4525)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4527
       modifySpotFleetRequest
       (ec2/modify-spot-fleet-request-request
        (clojure.core/nth args4526 0)))))))
  (clojure.core/defn
   modify-spot-fleet-request-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Generate map for modifySpotFleetRequest"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-spot-fleet-request,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-spot-fleet-request
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Call modifySpotFleetRequest"}
   [credentials4529 & args4530]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4531
     (com.palletops.awaze.common/aws-client :ec2 credentials4529)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4531
      modifySpotFleetRequest
      (ec2/modify-spot-fleet-request-request
       (clojure.core/nth args4530 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-snapshot-tasks
   [m4532]
   (clojure.core/let
    [credentials4533 (:credentials m4532) args4534 (:args m4532)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4535
      (com.palletops.awaze.common/aws-client :ec2 credentials4533)]
     (clojure.core/case
      (clojure.core/count args4534)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4535
        describeImportSnapshotTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4535
        describeImportSnapshotTasks
        (ec2/describe-import-snapshot-tasks-request
         (clojure.core/nth args4534 0))))))))
  (clojure.core/defn
   describe-import-snapshot-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeImportSnapshotTasks, describeImportSnapshotTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-snapshot-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeImportSnapshotTasks, describeImportSnapshotTasks"}
   [credentials4537 & args4538]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4539
     (com.palletops.awaze.common/aws-client :ec2 credentials4537)]
    (clojure.core/case
     (clojure.core/count args4538)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4539
       describeImportSnapshotTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4539
       describeImportSnapshotTasks
       (ec2/describe-import-snapshot-tasks-request
        (clojure.core/nth args4538 0)))))))))
