(ns
 com.palletops.awaze.cloudwatch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudwatch :as cloudwatch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Dimension}
dimension
  [m10543]
  (clojure.core/let
   [bean10542 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/let
    [v10544 (:name m10543 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10544 :com.palletops.awaze.client-builder/undef)
     (. bean10542 setName (clojure.core/str v10544))))
   (clojure.core/let
    [v10544 (:value m10543 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10544 :com.palletops.awaze.client-builder/undef)
     (. bean10542 setValue (clojure.core/str v10544))))
   bean10542))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StandardUnit}
standard-unit
  [m10546]
  (.
   com.amazonaws.services.cloudwatch.model.StandardUnit
   fromValue
   (clojure.core/name m10546)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StatisticSet}
statistic-set
  [m10549]
  (clojure.core/let
   [bean10548
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/let
    [v10550
     (:sample-count m10549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10550 :com.palletops.awaze.client-builder/undef)
     (. bean10548 setSampleCount (clojure.core/double v10550))))
   (clojure.core/let
    [v10550 (:sum m10549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10550 :com.palletops.awaze.client-builder/undef)
     (. bean10548 setSum (clojure.core/double v10550))))
   (clojure.core/let
    [v10550
     (:minimum m10549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10550 :com.palletops.awaze.client-builder/undef)
     (. bean10548 setMinimum (clojure.core/double v10550))))
   (clojure.core/let
    [v10550
     (:maximum m10549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10550 :com.palletops.awaze.client-builder/undef)
     (. bean10548 setMaximum (clojure.core/double v10550))))
   bean10548))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Statistic}
statistic
  [m10552]
  (.
   com.amazonaws.services.cloudwatch.model.Statistic
   fromValue
   (clojure.core/name m10552)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.MetricDatum}
metric-datum
  [m10555]
  (clojure.core/let
   [bean10554
    (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/let
    [v10556
     (:metric-name m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (. bean10554 setMetricName (clojure.core/str v10556))))
   (clojure.core/let
    [v10556
     (:dimensions m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (.
      bean10554
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10599] (cloudwatch/dimension arg10599))
 v10556))))
   (clojure.core/let
    [v10556 (:unit m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (. bean10554 setUnit (cloudwatch/standard-unit v10556))))
   (clojure.core/let
    [v10556
     (:statistic-values
      m10555
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (.
      bean10554
      setStatisticValues
      (cloudwatch/statistic-set v10556))))
   (clojure.core/let
    [v10556 (:value m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (. bean10554 setValue (clojure.core/double v10556))))
   (clojure.core/let
    [v10556
     (:timestamp m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (.
      bean10554
      setTimestamp
      (com.palletops.awaze.common/to-date v10556))))
   bean10554))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StateValue}
state-value
  [m10558]
  (.
   com.amazonaws.services.cloudwatch.model.StateValue
   fromValue
   (clojure.core/name m10558)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.HistoryItemType}
history-item-type
  [m10561]
  (.
   com.amazonaws.services.cloudwatch.model.HistoryItemType
   fromValue
   (clojure.core/name m10561)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DimensionFilter}
dimension-filter
  [m10564]
  (clojure.core/let
   [bean10563
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/let
    [v10565 (:name m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setName (clojure.core/str v10565))))
   (clojure.core/let
    [v10565 (:value m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setValue (clojure.core/str v10565))))
   bean10563))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest}
delete-alarms-request
  [m10567]
  (clojure.core/let
   [bean10566
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/let
    [v10568
     (:alarm-names m10567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10568 :com.palletops.awaze.client-builder/undef)
     (.
      bean10566
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10600] (clojure.core/str arg10600))
 v10568))))
   bean10566))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest}
enable-alarm-actions-request
  [m10570]
  (clojure.core/let
   [bean10569
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/let
    [v10571
     (:alarm-names m10570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10571 :com.palletops.awaze.client-builder/undef)
     (.
      bean10569
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10601] (clojure.core/str arg10601))
 v10571))))
   bean10569))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest}
disable-alarm-actions-request
  [m10573]
  (clojure.core/let
   [bean10572
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/let
    [v10574
     (:alarm-names m10573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (.
      bean10572
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10602] (clojure.core/str arg10602))
 v10574))))
   bean10572))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest}
set-alarm-state-request
  [m10576]
  (clojure.core/let
   [bean10575
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/let
    [v10577
     (:state-value m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (. bean10575 setStateValue (clojure.core/str v10577))))
   (clojure.core/let
    [v10577
     (:alarm-name m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (. bean10575 setAlarmName (clojure.core/str v10577))))
   (clojure.core/let
    [v10577
     (:state-reason m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (. bean10575 setStateReason (clojure.core/str v10577))))
   (clojure.core/let
    [v10577
     (:state-reason-data
      m10576
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (. bean10575 setStateReasonData (clojure.core/str v10577))))
   bean10575))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest}
describe-alarms-for-metric-request
  [m10579]
  (clojure.core/let
   [bean10578
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/let
    [v10580
     (:namespace m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setNamespace (clojure.core/str v10580))))
   (clojure.core/let
    [v10580
     (:metric-name m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setMetricName (clojure.core/str v10580))))
   (clojure.core/let
    [v10580
     (:statistic m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setStatistic (cloudwatch/statistic v10580))))
   (clojure.core/let
    [v10580
     (:dimensions m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (.
      bean10578
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10603] (cloudwatch/dimension arg10603))
 v10580))))
   (clojure.core/let
    [v10580
     (:period m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setPeriod (clojure.core/int v10580))))
   (clojure.core/let
    [v10580 (:unit m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setUnit (cloudwatch/standard-unit v10580))))
   bean10578))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricDataRequest}
put-metric-data-request
  [m10582]
  (clojure.core/let
   [bean10581
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/let
    [v10583
     (:namespace m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (. bean10581 setNamespace (clojure.core/str v10583))))
   (clojure.core/let
    [v10583
     (:metric-data m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (.
      bean10581
      setMetricData
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10604] (cloudwatch/metric-datum arg10604))
 v10583))))
   bean10581))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest}
describe-alarms-request
  [m10585]
  (clojure.core/let
   [bean10584
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/let
    [v10586
     (:max-records m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setMaxRecords (clojure.core/int v10586))))
   (clojure.core/let
    [v10586
     (:next-token m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setNextToken (clojure.core/str v10586))))
   (clojure.core/let
    [v10586
     (:alarm-name-prefix
      m10585
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setAlarmNamePrefix (clojure.core/str v10586))))
   (clojure.core/let
    [v10586
     (:state-value m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setStateValue (cloudwatch/state-value v10586))))
   (clojure.core/let
    [v10586
     (:action-prefix m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setActionPrefix (clojure.core/str v10586))))
   (clojure.core/let
    [v10586
     (:alarm-names m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (.
      bean10584
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10693] (clojure.core/str arg10693))
 v10586))))
   bean10584))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest}
describe-alarm-history-request
  [m10588]
  (clojure.core/let
   [bean10587
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/let
    [v10589
     (:max-records m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (. bean10587 setMaxRecords (clojure.core/int v10589))))
   (clojure.core/let
    [v10589
     (:next-token m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (. bean10587 setNextToken (clojure.core/str v10589))))
   (clojure.core/let
    [v10589
     (:alarm-name m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (. bean10587 setAlarmName (clojure.core/str v10589))))
   (clojure.core/let
    [v10589
     (:end-date m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (.
      bean10587
      setEndDate
      (com.palletops.awaze.common/to-date v10589))))
   (clojure.core/let
    [v10589
     (:start-date m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (.
      bean10587
      setStartDate
      (com.palletops.awaze.common/to-date v10589))))
   (clojure.core/let
    [v10589
     (:history-item-type
      m10588
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (.
      bean10587
      setHistoryItemType
      (cloudwatch/history-item-type v10589))))
   bean10587))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest}
put-metric-alarm-request
  [m10591]
  (clojure.core/let
   [bean10590
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/let
    [v10592
     (:alarm-name m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setAlarmName (clojure.core/str v10592))))
   (clojure.core/let
    [v10592
     (:alarm-description
      m10591
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setAlarmDescription (clojure.core/str v10592))))
   (clojure.core/let
    [v10592
     (:okactions m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (.
      bean10590
      setOKActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10694] (clojure.core/str arg10694))
 v10592))))
   (clojure.core/let
    [v10592 (:unit m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setUnit (clojure.core/str v10592))))
   (clojure.core/let
    [v10592
     (:metric-name m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setMetricName (clojure.core/str v10592))))
   (clojure.core/let
    [v10592
     (:dimensions m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (.
      bean10590
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10695] (cloudwatch/dimension arg10695))
 v10592))))
   (clojure.core/let
    [v10592
     (:evaluation-periods
      m10591
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setEvaluationPeriods (clojure.core/int v10592))))
   (clojure.core/let
    [v10592
     (:namespace m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setNamespace (clojure.core/str v10592))))
   (clojure.core/let
    [v10592
     (:period m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setPeriod (clojure.core/int v10592))))
   (clojure.core/let
    [v10592
     (:comparison-operator
      m10591
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setComparisonOperator (clojure.core/str v10592))))
   (clojure.core/let
    [v10592
     (:actions-enabled
      m10591
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setActionsEnabled (clojure.core/boolean v10592))))
   (clojure.core/let
    [v10592
     (:alarm-actions m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (.
      bean10590
      setAlarmActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10696] (clojure.core/str arg10696))
 v10592))))
   (clojure.core/let
    [v10592
     (:insufficient-data-actions
      m10591
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (.
      bean10590
      setInsufficientDataActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10697] (clojure.core/str arg10697))
 v10592))))
   (clojure.core/let
    [v10592
     (:threshold m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setThreshold (clojure.core/double v10592))))
   (clojure.core/let
    [v10592
     (:statistic m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setStatistic (clojure.core/str v10592))))
   bean10590))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest}
get-metric-statistics-request
  [m10594]
  (clojure.core/let
   [bean10593
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/let
    [v10595
     (:namespace m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setNamespace (clojure.core/str v10595))))
   (clojure.core/let
    [v10595
     (:start-time m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (.
      bean10593
      setStartTime
      (com.palletops.awaze.common/to-date v10595))))
   (clojure.core/let
    [v10595
     (:end-time m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (.
      bean10593
      setEndTime
      (com.palletops.awaze.common/to-date v10595))))
   (clojure.core/let
    [v10595
     (:metric-name m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setMetricName (clojure.core/str v10595))))
   (clojure.core/let
    [v10595
     (:dimensions m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (.
      bean10593
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10698] (cloudwatch/dimension arg10698))
 v10595))))
   (clojure.core/let
    [v10595
     (:statistics m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (.
      bean10593
      setStatistics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10699] (clojure.core/str arg10699))
 v10595))))
   (clojure.core/let
    [v10595
     (:period m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setPeriod (clojure.core/int v10595))))
   (clojure.core/let
    [v10595 (:unit m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setUnit (cloudwatch/standard-unit v10595))))
   bean10593))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ListMetricsRequest}
list-metrics-request
  [m10597]
  (clojure.core/let
   [bean10596
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/let
    [v10598
     (:namespace m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (. bean10596 setNamespace (clojure.core/str v10598))))
   (clojure.core/let
    [v10598
     (:next-token m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (. bean10596 setNextToken (clojure.core/str v10598))))
   (clojure.core/let
    [v10598
     (:metric-name m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (. bean10596 setMetricName (clojure.core/str v10598))))
   (clojure.core/let
    [v10598
     (:dimensions m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (.
      bean10596
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10700] (cloudwatch/dimension-filter arg10700))
 v10598))))
   bean10596))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m10605]
   (clojure.core/let
    [credentials10606 (:credentials m10605) args10607 (:args m10605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10608
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10606)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10608
       deleteAlarms
       (cloudwatch/delete-alarms-request
        (clojure.core/nth args10607 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteAlarms"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   delete-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteAlarms"}
   [credentials10610 & args10611]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10612
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10610)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10612
      deleteAlarms
      (cloudwatch/delete-alarms-request
       (clojure.core/nth args10611 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m10613]
   (clojure.core/let
    [credentials10614 (:credentials m10613) args10615 (:args m10613)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10616
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10614)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10616
       enableAlarmActions
       (cloudwatch/enable-alarm-actions-request
        (clojure.core/nth args10615 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAlarmActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-alarm-actions,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAlarmActions"}
   [credentials10618 & args10619]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10620
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10618)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10620
      enableAlarmActions
      (cloudwatch/enable-alarm-actions-request
       (clojure.core/nth args10619 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m10621]
   (clojure.core/let
    [credentials10622 (:credentials m10621) args10623 (:args m10621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10624
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10622)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10624
       disableAlarmActions
       (cloudwatch/disable-alarm-actions-request
        (clojure.core/nth args10623 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAlarmActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-alarm-actions,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAlarmActions"}
   [credentials10626 & args10627]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10628
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10626)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10628
      disableAlarmActions
      (cloudwatch/disable-alarm-actions-request
       (clojure.core/nth args10627 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m10629]
   (clojure.core/let
    [credentials10630 (:credentials m10629) args10631 (:args m10629)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10632
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10630)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10632
       setAlarmState
       (cloudwatch/set-alarm-state-request
        (clojure.core/nth args10631 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Generate map for setAlarmState"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-alarm-state,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   set-alarm-state
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Call setAlarmState"}
   [credentials10634 & args10635]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10636
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10634)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10636
      setAlarmState
      (cloudwatch/set-alarm-state-request
       (clojure.core/nth args10635 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m10637]
   (clojure.core/let
    [credentials10638 (:credentials m10637) args10639 (:args m10637)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10640
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10638)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10640
       describeAlarmsForMetric
       (cloudwatch/describe-alarms-for-metric-request
        (clojure.core/nth args10639 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarms-for-metric,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call describeAlarmsForMetric"}
   [credentials10642 & args10643]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10644
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10642)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10644
      describeAlarmsForMetric
      (cloudwatch/describe-alarms-for-metric-request
       (clojure.core/nth args10643 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m10645]
   (clojure.core/let
    [credentials10646 (:credentials m10645) args10647 (:args m10645)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10648
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10646)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10648
       putMetricData
       (cloudwatch/put-metric-data-request
        (clojure.core/nth args10647 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricData"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-metric-data,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricData"}
   [credentials10650 & args10651]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10652
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10650)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10652
      putMetricData
      (cloudwatch/put-metric-data-request
       (clojure.core/nth args10651 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m10653]
   (clojure.core/let
    [credentials10654 (:credentials m10653) args10655 (:args m10653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10656
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10654)]
     (clojure.core/case
      (clojure.core/count args10655)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10656
        describeAlarms
        (cloudwatch/describe-alarms-request
         (clojure.core/nth args10655 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10656
        describeAlarms))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAlarms, describeAlarms"}
   [credentials10658 & args10659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10660
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10658)]
    (clojure.core/case
     (clojure.core/count args10659)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10660
       describeAlarms
       (cloudwatch/describe-alarms-request
        (clojure.core/nth args10659 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10660
       describeAlarms))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m10661]
   (clojure.core/let
    [credentials10662 (:credentials m10661) args10663 (:args m10661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10664
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10662)]
     (clojure.core/case
      (clojure.core/count args10663)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10664
        describeAlarmHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10664
        describeAlarmHistory
        (cloudwatch/describe-alarm-history-request
         (clojure.core/nth args10663 0))))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-alarm-history,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarm-history,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]]),
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials10666 & args10667]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10668
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10666)]
    (clojure.core/case
     (clojure.core/count args10667)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10668
       describeAlarmHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10668
       describeAlarmHistory
       (cloudwatch/describe-alarm-history-request
        (clojure.core/nth args10667 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m10669]
   (clojure.core/let
    [credentials10670 (:credentials m10669) args10671 (:args m10669)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10672
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10670)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10672
       putMetricAlarm
       (cloudwatch/put-metric-alarm-request
        (clojure.core/nth args10671 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricAlarm"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-metric-alarm,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricAlarm"}
   [credentials10674 & args10675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10676
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10674)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10676
      putMetricAlarm
      (cloudwatch/put-metric-alarm-request
       (clojure.core/nth args10675 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m10677]
   (clojure.core/let
    [credentials10678 (:credentials m10677) args10679 (:args m10677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10680
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10678)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10680
       getMetricStatistics
       (cloudwatch/get-metric-statistics-request
        (clojure.core/nth args10679 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for getMetricStatistics"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-metric-statistics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call getMetricStatistics"}
   [credentials10682 & args10683]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10684
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10682)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10684
      getMetricStatistics
      (cloudwatch/get-metric-statistics-request
       (clojure.core/nth args10683 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m10685]
   (clojure.core/let
    [credentials10686 (:credentials m10685) args10687 (:args m10685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10688
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10686)]
     (clojure.core/case
      (clojure.core/count args10687)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10688
        listMetrics))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10688
        listMetrics
        (cloudwatch/list-metrics-request
         (clojure.core/nth args10687 0))))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-metrics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-metrics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   list-metrics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]]),
    :doc "Call listMetrics, listMetrics"}
   [credentials10690 & args10691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10692
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10690)]
    (clojure.core/case
     (clojure.core/count args10691)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10692
       listMetrics))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10692
       listMetrics
       (cloudwatch/list-metrics-request
        (clojure.core/nth args10691 0)))))))))
