(ns
 com.palletops.awaze.autoscaling
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.autoscaling :as autoscaling]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Ebs}
ebs
  [m6400]
  (clojure.core/let
   [bean6399 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/let
    [v6401
     (:encrypted m6400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6401 :com.palletops.awaze.client-builder/undef)
     (. bean6399 setEncrypted (clojure.core/boolean v6401))))
   (clojure.core/let
    [v6401
     (:snapshot-id m6400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6401 :com.palletops.awaze.client-builder/undef)
     (. bean6399 setSnapshotId (clojure.core/str v6401))))
   (clojure.core/let
    [v6401
     (:volume-type m6400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6401 :com.palletops.awaze.client-builder/undef)
     (. bean6399 setVolumeType (clojure.core/str v6401))))
   (clojure.core/let
    [v6401 (:iops m6400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6401 :com.palletops.awaze.client-builder/undef)
     (. bean6399 setIops (clojure.core/int v6401))))
   (clojure.core/let
    [v6401
     (:delete-on-termination
      m6400
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6401 :com.palletops.awaze.client-builder/undef)
     (. bean6399 setDeleteOnTermination (clojure.core/boolean v6401))))
   (clojure.core/let
    [v6401
     (:volume-size m6400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6401 :com.palletops.awaze.client-builder/undef)
     (. bean6399 setVolumeSize (clojure.core/int v6401))))
   bean6399))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Tag}
tag
  [m6403]
  (clojure.core/let
   [bean6402 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/let
    [v6404
     (:resource-type m6403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6404 :com.palletops.awaze.client-builder/undef)
     (. bean6402 setResourceType (clojure.core/str v6404))))
   (clojure.core/let
    [v6404
     (:resource-id m6403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6404 :com.palletops.awaze.client-builder/undef)
     (. bean6402 setResourceId (clojure.core/str v6404))))
   (clojure.core/let
    [v6404
     (:propagate-at-launch
      m6403
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6404 :com.palletops.awaze.client-builder/undef)
     (. bean6402 setPropagateAtLaunch (clojure.core/boolean v6404))))
   (clojure.core/let
    [v6404 (:key m6403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6404 :com.palletops.awaze.client-builder/undef)
     (. bean6402 setKey (clojure.core/str v6404))))
   (clojure.core/let
    [v6404 (:value m6403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6404 :com.palletops.awaze.client-builder/undef)
     (. bean6402 setValue (clojure.core/str v6404))))
   bean6402))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.StepAdjustment}
step-adjustment
  [m6406]
  (clojure.core/let
   [bean6405
    (new com.amazonaws.services.autoscaling.model.StepAdjustment)]
   (clojure.core/let
    [v6407
     (:scaling-adjustment
      m6406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6407 :com.palletops.awaze.client-builder/undef)
     (. bean6405 setScalingAdjustment (clojure.core/int v6407))))
   (clojure.core/let
    [v6407
     (:metric-interval-lower-bound
      m6406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6407 :com.palletops.awaze.client-builder/undef)
     (.
      bean6405
      setMetricIntervalLowerBound
      (clojure.core/double v6407))))
   (clojure.core/let
    [v6407
     (:metric-interval-upper-bound
      m6406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6407 :com.palletops.awaze.client-builder/undef)
     (.
      bean6405
      setMetricIntervalUpperBound
      (clojure.core/double v6407))))
   bean6405))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Filter}
filter
  [m6409]
  (clojure.core/let
   [bean6408 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/let
    [v6410 (:values m6409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (.
      bean6408
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6564] (clojure.core/str arg6564))
 v6410))))
   (clojure.core/let
    [v6410 (:name m6409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setName (clojure.core/str v6410))))
   bean6408))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.InstanceMonitoring}
instance-monitoring
  [m6412]
  (clojure.core/let
   [bean6411
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/let
    [v6413 (:enabled m6412 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6413 :com.palletops.awaze.client-builder/undef)
     (. bean6411 setEnabled (clojure.core/boolean v6413))))
   bean6411))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.BlockDeviceMapping}
block-device-mapping
  [m6415]
  (clojure.core/let
   [bean6414
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/let
    [v6416
     (:device-name m6415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6416 :com.palletops.awaze.client-builder/undef)
     (. bean6414 setDeviceName (clojure.core/str v6416))))
   (clojure.core/let
    [v6416
     (:virtual-name m6415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6416 :com.palletops.awaze.client-builder/undef)
     (. bean6414 setVirtualName (clojure.core/str v6416))))
   (clojure.core/let
    [v6416 (:ebs m6415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6416 :com.palletops.awaze.client-builder/undef)
     (. bean6414 setEbs (autoscaling/ebs v6416))))
   (clojure.core/let
    [v6416
     (:no-device m6415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6416 :com.palletops.awaze.client-builder/undef)
     (. bean6414 setNoDevice (clojure.core/boolean v6416))))
   bean6414))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest}
update-auto-scaling-group-request
  [m6418]
  (clojure.core/let
   [bean6417
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/let
    [v6419
     (:health-check-type
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setHealthCheckType (clojure.core/str v6419))))
   (clojure.core/let
    [v6419
     (:new-instances-protected-from-scale-in
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (.
      bean6417
      setNewInstancesProtectedFromScaleIn
      (clojure.core/boolean v6419))))
   (clojure.core/let
    [v6419
     (:availability-zones
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (.
      bean6417
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6565] (clojure.core/str arg6565))
 v6419))))
   (clojure.core/let
    [v6419
     (:desired-capacity
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setDesiredCapacity (clojure.core/int v6419))))
   (clojure.core/let
    [v6419
     (:placement-group
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setPlacementGroup (clojure.core/str v6419))))
   (clojure.core/let
    [v6419
     (:min-size m6418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setMinSize (clojure.core/int v6419))))
   (clojure.core/let
    [v6419
     (:launch-configuration-name
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setLaunchConfigurationName (clojure.core/str v6419))))
   (clojure.core/let
    [v6419
     (:health-check-grace-period
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setHealthCheckGracePeriod (clojure.core/int v6419))))
   (clojure.core/let
    [v6419
     (:termination-policies
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (.
      bean6417
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6566] (clojure.core/str arg6566))
 v6419))))
   (clojure.core/let
    [v6419
     (:auto-scaling-group-name
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setAutoScalingGroupName (clojure.core/str v6419))))
   (clojure.core/let
    [v6419
     (:max-size m6418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setMaxSize (clojure.core/int v6419))))
   (clojure.core/let
    [v6419
     (:vpczone-identifier
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setVPCZoneIdentifier (clojure.core/str v6419))))
   (clojure.core/let
    [v6419
     (:default-cooldown
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setDefaultCooldown (clojure.core/int v6419))))
   bean6417))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest}
attach-load-balancers-request
  [m6421]
  (clojure.core/let
   [bean6420
    (new
     com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest)]
   (clojure.core/let
    [v6422
     (:load-balancer-names
      m6421
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (.
      bean6420
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6567] (clojure.core/str arg6567))
 v6422))))
   (clojure.core/let
    [v6422
     (:auto-scaling-group-name
      m6421
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (. bean6420 setAutoScalingGroupName (clojure.core/str v6422))))
   bean6420))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest}
create-or-update-tags-request
  [m6424]
  (clojure.core/let
   [bean6423
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/let
    [v6425 (:tags m6424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6425 :com.palletops.awaze.client-builder/undef)
     (.
      bean6423
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6568] (autoscaling/tag arg6568))
 v6425))))
   bean6423))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ResumeProcessesRequest}
resume-processes-request
  [m6427]
  (clojure.core/let
   [bean6426
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/let
    [v6428
     (:scaling-processes
      m6427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6428 :com.palletops.awaze.client-builder/undef)
     (.
      bean6426
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6569] (clojure.core/str arg6569))
 v6428))))
   (clojure.core/let
    [v6428
     (:auto-scaling-group-name
      m6427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6428 :com.palletops.awaze.client-builder/undef)
     (. bean6426 setAutoScalingGroupName (clojure.core/str v6428))))
   bean6426))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest}
terminate-instance-in-auto-scaling-group-request
  [m6430]
  (clojure.core/let
   [bean6429
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/let
    [v6431
     (:should-decrement-desired-capacity
      m6430
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6431 :com.palletops.awaze.client-builder/undef)
     (.
      bean6429
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6431))))
   (clojure.core/let
    [v6431
     (:instance-id m6430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6431 :com.palletops.awaze.client-builder/undef)
     (. bean6429 setInstanceId (clojure.core/str v6431))))
   bean6429))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest}
delete-auto-scaling-group-request
  [m6433]
  (clojure.core/let
   [bean6432
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/let
    [v6434
     (:force-delete m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setForceDelete (clojure.core/boolean v6434))))
   (clojure.core/let
    [v6434
     (:auto-scaling-group-name
      m6433
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setAutoScalingGroupName (clojure.core/str v6434))))
   bean6432))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m6436]
  (clojure.core/let
   [bean6435
    (new
     com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v6437
     (:max-records m6436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setMaxRecords (clojure.core/int v6437))))
   (clojure.core/let
    [v6437
     (:next-token m6436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setNextToken (clojure.core/str v6437))))
   (clojure.core/let
    [v6437
     (:auto-scaling-group-name
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setAutoScalingGroupName (clojure.core/str v6437))))
   bean6435))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest}
disable-metrics-collection-request
  [m6439]
  (clojure.core/let
   [bean6438
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/let
    [v6440 (:metrics m6439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (.
      bean6438
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6570] (clojure.core/str arg6570))
 v6440))))
   (clojure.core/let
    [v6440
     (:auto-scaling-group-name
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setAutoScalingGroupName (clojure.core/str v6440))))
   bean6438))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest}
describe-scheduled-actions-request
  [m6442]
  (clojure.core/let
   [bean6441
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/let
    [v6443
     (:scheduled-action-names
      m6442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (.
      bean6441
      setScheduledActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6571] (clojure.core/str arg6571))
 v6443))))
   (clojure.core/let
    [v6443
     (:max-records m6442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (. bean6441 setMaxRecords (clojure.core/int v6443))))
   (clojure.core/let
    [v6443
     (:next-token m6442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (. bean6441 setNextToken (clojure.core/str v6443))))
   (clojure.core/let
    [v6443
     (:start-time m6442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (.
      bean6441
      setStartTime
      (com.palletops.awaze.common/to-date v6443))))
   (clojure.core/let
    [v6443
     (:end-time m6442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (.
      bean6441
      setEndTime
      (com.palletops.awaze.common/to-date v6443))))
   (clojure.core/let
    [v6443
     (:auto-scaling-group-name
      m6442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (. bean6441 setAutoScalingGroupName (clojure.core/str v6443))))
   bean6441))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest}
delete-notification-configuration-request
  [m6445]
  (clojure.core/let
   [bean6444
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/let
    [v6446
     (:topic-arn m6445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6446 :com.palletops.awaze.client-builder/undef)
     (. bean6444 setTopicARN (clojure.core/str v6446))))
   (clojure.core/let
    [v6446
     (:auto-scaling-group-name
      m6445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6446 :com.palletops.awaze.client-builder/undef)
     (. bean6444 setAutoScalingGroupName (clojure.core/str v6446))))
   bean6444))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest}
put-scaling-policy-request
  [m6448]
  (clojure.core/let
   [bean6447
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/let
    [v6449
     (:policy-type m6448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setPolicyType (clojure.core/str v6449))))
   (clojure.core/let
    [v6449
     (:policy-name m6448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setPolicyName (clojure.core/str v6449))))
   (clojure.core/let
    [v6449
     (:adjustment-type
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setAdjustmentType (clojure.core/str v6449))))
   (clojure.core/let
    [v6449
     (:step-adjustments
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (.
      bean6447
      setStepAdjustments
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6572] (autoscaling/step-adjustment arg6572))
 v6449))))
   (clojure.core/let
    [v6449
     (:min-adjustment-magnitude
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setMinAdjustmentMagnitude (clojure.core/int v6449))))
   (clojure.core/let
    [v6449
     (:scaling-adjustment
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setScalingAdjustment (clojure.core/int v6449))))
   (clojure.core/let
    [v6449
     (:auto-scaling-group-name
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setAutoScalingGroupName (clojure.core/str v6449))))
   (clojure.core/let
    [v6449
     (:cooldown m6448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setCooldown (clojure.core/int v6449))))
   (clojure.core/let
    [v6449
     (:metric-aggregation-type
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setMetricAggregationType (clojure.core/str v6449))))
   (clojure.core/let
    [v6449
     (:estimated-instance-warmup
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setEstimatedInstanceWarmup (clojure.core/int v6449))))
   (clojure.core/let
    [v6449
     (:min-adjustment-step
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setMinAdjustmentStep (clojure.core/int v6449))))
   bean6447))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest}
describe-scaling-activities-request
  [m6451]
  (clojure.core/let
   [bean6450
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/let
    [v6452
     (:activity-ids m6451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6452 :com.palletops.awaze.client-builder/undef)
     (.
      bean6450
      setActivityIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6573] (clojure.core/str arg6573))
 v6452))))
   (clojure.core/let
    [v6452
     (:max-records m6451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6452 :com.palletops.awaze.client-builder/undef)
     (. bean6450 setMaxRecords (clojure.core/int v6452))))
   (clojure.core/let
    [v6452
     (:next-token m6451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6452 :com.palletops.awaze.client-builder/undef)
     (. bean6450 setNextToken (clojure.core/str v6452))))
   (clojure.core/let
    [v6452
     (:auto-scaling-group-name
      m6451
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6452 :com.palletops.awaze.client-builder/undef)
     (. bean6450 setAutoScalingGroupName (clojure.core/str v6452))))
   bean6450))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest}
describe-lifecycle-hooks-request
  [m6454]
  (clojure.core/let
   [bean6453
    (new
     com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest)]
   (clojure.core/let
    [v6455
     (:lifecycle-hook-names
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (.
      bean6453
      setLifecycleHookNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6574] (clojure.core/str arg6574))
 v6455))))
   (clojure.core/let
    [v6455
     (:auto-scaling-group-name
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setAutoScalingGroupName (clojure.core/str v6455))))
   bean6453))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest}
delete-launch-configuration-request
  [m6457]
  (clojure.core/let
   [bean6456
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/let
    [v6458
     (:launch-configuration-name
      m6457
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6458 :com.palletops.awaze.client-builder/undef)
     (. bean6456 setLaunchConfigurationName (clojure.core/str v6458))))
   bean6456))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeletePolicyRequest}
delete-policy-request
  [m6460]
  (clojure.core/let
   [bean6459
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/let
    [v6461
     (:auto-scaling-group-name
      m6460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6461 :com.palletops.awaze.client-builder/undef)
     (. bean6459 setAutoScalingGroupName (clojure.core/str v6461))))
   (clojure.core/let
    [v6461
     (:policy-name m6460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6461 :com.palletops.awaze.client-builder/undef)
     (. bean6459 setPolicyName (clojure.core/str v6461))))
   bean6459))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest}
create-auto-scaling-group-request
  [m6463]
  (clojure.core/let
   [bean6462
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/let
    [v6464
     (:health-check-type
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setHealthCheckType (clojure.core/str v6464))))
   (clojure.core/let
    [v6464
     (:new-instances-protected-from-scale-in
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (.
      bean6462
      setNewInstancesProtectedFromScaleIn
      (clojure.core/boolean v6464))))
   (clojure.core/let
    [v6464
     (:availability-zones
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (.
      bean6462
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6575] (clojure.core/str arg6575))
 v6464))))
   (clojure.core/let
    [v6464
     (:desired-capacity
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setDesiredCapacity (clojure.core/int v6464))))
   (clojure.core/let
    [v6464
     (:instance-id m6463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setInstanceId (clojure.core/str v6464))))
   (clojure.core/let
    [v6464
     (:placement-group
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setPlacementGroup (clojure.core/str v6464))))
   (clojure.core/let
    [v6464
     (:min-size m6463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setMinSize (clojure.core/int v6464))))
   (clojure.core/let
    [v6464 (:tags m6463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (.
      bean6462
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6576] (autoscaling/tag arg6576))
 v6464))))
   (clojure.core/let
    [v6464
     (:load-balancer-names
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (.
      bean6462
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6577] (clojure.core/str arg6577))
 v6464))))
   (clojure.core/let
    [v6464
     (:launch-configuration-name
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setLaunchConfigurationName (clojure.core/str v6464))))
   (clojure.core/let
    [v6464
     (:health-check-grace-period
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setHealthCheckGracePeriod (clojure.core/int v6464))))
   (clojure.core/let
    [v6464
     (:termination-policies
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (.
      bean6462
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6578] (clojure.core/str arg6578))
 v6464))))
   (clojure.core/let
    [v6464
     (:auto-scaling-group-name
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setAutoScalingGroupName (clojure.core/str v6464))))
   (clojure.core/let
    [v6464
     (:max-size m6463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setMaxSize (clojure.core/int v6464))))
   (clojure.core/let
    [v6464
     (:vpczone-identifier
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setVPCZoneIdentifier (clojure.core/str v6464))))
   (clojure.core/let
    [v6464
     (:default-cooldown
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setDefaultCooldown (clojure.core/int v6464))))
   bean6462))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest}
describe-scaling-process-types-request
  [m6466]
  (clojure.core/let
   [bean6465
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean6465))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m6469]
  (clojure.core/let
   [bean6468
    (new
     com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest)]
   bean6468))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest}
delete-scheduled-action-request
  [m6472]
  (clojure.core/let
   [bean6471
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/let
    [v6473
     (:scheduled-action-name
      m6472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6473 :com.palletops.awaze.client-builder/undef)
     (. bean6471 setScheduledActionName (clojure.core/str v6473))))
   (clojure.core/let
    [v6473
     (:auto-scaling-group-name
      m6472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6473 :com.palletops.awaze.client-builder/undef)
     (. bean6471 setAutoScalingGroupName (clojure.core/str v6473))))
   bean6471))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest}
describe-notification-configurations-request
  [m6475]
  (clojure.core/let
   [bean6474
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/let
    [v6476
     (:auto-scaling-group-names
      m6475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6476 :com.palletops.awaze.client-builder/undef)
     (.
      bean6474
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6579] (clojure.core/str arg6579))
 v6476))))
   (clojure.core/let
    [v6476
     (:max-records m6475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6476 :com.palletops.awaze.client-builder/undef)
     (. bean6474 setMaxRecords (clojure.core/int v6476))))
   (clojure.core/let
    [v6476
     (:next-token m6475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6476 :com.palletops.awaze.client-builder/undef)
     (. bean6474 setNextToken (clojure.core/str v6476))))
   bean6474))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest}
describe-adjustment-types-request
  [m6478]
  (clojure.core/let
   [bean6477
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean6477))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest}
describe-auto-scaling-instances-request
  [m6481]
  (clojure.core/let
   [bean6480
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/let
    [v6482
     (:max-records m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setMaxRecords (clojure.core/int v6482))))
   (clojure.core/let
    [v6482
     (:instance-ids m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (.
      bean6480
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6580] (clojure.core/str arg6580))
 v6482))))
   (clojure.core/let
    [v6482
     (:next-token m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setNextToken (clojure.core/str v6482))))
   bean6480))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest}
describe-termination-policy-types-request
  [m6484]
  (clojure.core/let
   [bean6483
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean6483))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachInstancesRequest}
attach-instances-request
  [m6487]
  (clojure.core/let
   [bean6486
    (new
     com.amazonaws.services.autoscaling.model.AttachInstancesRequest)]
   (clojure.core/let
    [v6488
     (:instance-ids m6487 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6488 :com.palletops.awaze.client-builder/undef)
     (.
      bean6486
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6581] (clojure.core/str arg6581))
 v6488))))
   (clojure.core/let
    [v6488
     (:auto-scaling-group-name
      m6487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6488 :com.palletops.awaze.client-builder/undef)
     (. bean6486 setAutoScalingGroupName (clojure.core/str v6488))))
   bean6486))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTagsRequest}
describe-tags-request
  [m6490]
  (clojure.core/let
   [bean6489
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/let
    [v6491
     (:max-records m6490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6491 :com.palletops.awaze.client-builder/undef)
     (. bean6489 setMaxRecords (clojure.core/int v6491))))
   (clojure.core/let
    [v6491 (:filters m6490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6491 :com.palletops.awaze.client-builder/undef)
     (.
      bean6489
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6582] (autoscaling/filter arg6582))
 v6491))))
   (clojure.core/let
    [v6491
     (:next-token m6490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6491 :com.palletops.awaze.client-builder/undef)
     (. bean6489 setNextToken (clojure.core/str v6491))))
   bean6489))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteTagsRequest}
delete-tags-request
  [m6493]
  (clojure.core/let
   [bean6492
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/let
    [v6494 (:tags m6493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6494 :com.palletops.awaze.client-builder/undef)
     (.
      bean6492
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6583] (autoscaling/tag arg6583))
 v6494))))
   bean6492))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest}
put-notification-configuration-request
  [m6496]
  (clojure.core/let
   [bean6495
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/let
    [v6497
     (:notification-types
      m6496
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6497 :com.palletops.awaze.client-builder/undef)
     (.
      bean6495
      setNotificationTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6584] (clojure.core/str arg6584))
 v6497))))
   (clojure.core/let
    [v6497
     (:topic-arn m6496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6497 :com.palletops.awaze.client-builder/undef)
     (. bean6495 setTopicARN (clojure.core/str v6497))))
   (clojure.core/let
    [v6497
     (:auto-scaling-group-name
      m6496
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6497 :com.palletops.awaze.client-builder/undef)
     (. bean6495 setAutoScalingGroupName (clojure.core/str v6497))))
   bean6495))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest}
detach-load-balancers-request
  [m6499]
  (clojure.core/let
   [bean6498
    (new
     com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest)]
   (clojure.core/let
    [v6500
     (:load-balancer-names
      m6499
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (.
      bean6498
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6585] (clojure.core/str arg6585))
 v6500))))
   (clojure.core/let
    [v6500
     (:auto-scaling-group-name
      m6499
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (. bean6498 setAutoScalingGroupName (clojure.core/str v6500))))
   bean6498))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest}
describe-auto-scaling-notification-types-request
  [m6502]
  (clojure.core/let
   [bean6501
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean6501))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest}
set-instance-protection-request
  [m6505]
  (clojure.core/let
   [bean6504
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest)]
   (clojure.core/let
    [v6506
     (:protected-from-scale-in
      m6505
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6506 :com.palletops.awaze.client-builder/undef)
     (. bean6504 setProtectedFromScaleIn (clojure.core/boolean v6506))))
   (clojure.core/let
    [v6506
     (:instance-ids m6505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6506 :com.palletops.awaze.client-builder/undef)
     (.
      bean6504
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6586] (clojure.core/str arg6586))
 v6506))))
   (clojure.core/let
    [v6506
     (:auto-scaling-group-name
      m6505
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6506 :com.palletops.awaze.client-builder/undef)
     (. bean6504 setAutoScalingGroupName (clojure.core/str v6506))))
   bean6504))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest}
complete-lifecycle-action-request
  [m6508]
  (clojure.core/let
   [bean6507
    (new
     com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest)]
   (clojure.core/let
    [v6509
     (:lifecycle-action-token
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setLifecycleActionToken (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:lifecycle-action-result
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setLifecycleActionResult (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:lifecycle-hook-name
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setLifecycleHookName (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:instance-id m6508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setInstanceId (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:auto-scaling-group-name
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setAutoScalingGroupName (clojure.core/str v6509))))
   bean6507))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SuspendProcessesRequest}
suspend-processes-request
  [m6511]
  (clojure.core/let
   [bean6510
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/let
    [v6512
     (:scaling-processes
      m6511
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6512 :com.palletops.awaze.client-builder/undef)
     (.
      bean6510
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6587] (clojure.core/str arg6587))
 v6512))))
   (clojure.core/let
    [v6512
     (:auto-scaling-group-name
      m6511
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6512 :com.palletops.awaze.client-builder/undef)
     (. bean6510 setAutoScalingGroupName (clojure.core/str v6512))))
   bean6510))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest}
describe-auto-scaling-groups-request
  [m6514]
  (clojure.core/let
   [bean6513
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/let
    [v6515
     (:auto-scaling-group-names
      m6514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (.
      bean6513
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6588] (clojure.core/str arg6588))
 v6515))))
   (clojure.core/let
    [v6515
     (:max-records m6514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (. bean6513 setMaxRecords (clojure.core/int v6515))))
   (clojure.core/let
    [v6515
     (:next-token m6514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (. bean6513 setNextToken (clojure.core/str v6515))))
   bean6513))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest}
put-lifecycle-hook-request
  [m6517]
  (clojure.core/let
   [bean6516
    (new
     com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest)]
   (clojure.core/let
    [v6518
     (:lifecycle-transition
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setLifecycleTransition (clojure.core/str v6518))))
   (clojure.core/let
    [v6518
     (:notification-target-arn
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setNotificationTargetARN (clojure.core/str v6518))))
   (clojure.core/let
    [v6518
     (:notification-metadata
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setNotificationMetadata (clojure.core/str v6518))))
   (clojure.core/let
    [v6518
     (:heartbeat-timeout
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setHeartbeatTimeout (clojure.core/int v6518))))
   (clojure.core/let
    [v6518
     (:default-result m6517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setDefaultResult (clojure.core/str v6518))))
   (clojure.core/let
    [v6518
     (:lifecycle-hook-name
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setLifecycleHookName (clojure.core/str v6518))))
   (clojure.core/let
    [v6518
     (:role-arn m6517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setRoleARN (clojure.core/str v6518))))
   (clojure.core/let
    [v6518
     (:auto-scaling-group-name
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setAutoScalingGroupName (clojure.core/str v6518))))
   bean6516))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExecutePolicyRequest}
execute-policy-request
  [m6520]
  (clojure.core/let
   [bean6519
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/let
    [v6521
     (:honor-cooldown m6520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6521 :com.palletops.awaze.client-builder/undef)
     (. bean6519 setHonorCooldown (clojure.core/boolean v6521))))
   (clojure.core/let
    [v6521
     (:metric-value m6520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6521 :com.palletops.awaze.client-builder/undef)
     (. bean6519 setMetricValue (clojure.core/double v6521))))
   (clojure.core/let
    [v6521
     (:breach-threshold
      m6520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6521 :com.palletops.awaze.client-builder/undef)
     (. bean6519 setBreachThreshold (clojure.core/double v6521))))
   (clojure.core/let
    [v6521
     (:auto-scaling-group-name
      m6520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6521 :com.palletops.awaze.client-builder/undef)
     (. bean6519 setAutoScalingGroupName (clojure.core/str v6521))))
   (clojure.core/let
    [v6521
     (:policy-name m6520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6521 :com.palletops.awaze.client-builder/undef)
     (. bean6519 setPolicyName (clojure.core/str v6521))))
   bean6519))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest}
record-lifecycle-action-heartbeat-request
  [m6523]
  (clojure.core/let
   [bean6522
    (new
     com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest)]
   (clojure.core/let
    [v6524
     (:lifecycle-action-token
      m6523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setLifecycleActionToken (clojure.core/str v6524))))
   (clojure.core/let
    [v6524
     (:lifecycle-hook-name
      m6523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setLifecycleHookName (clojure.core/str v6524))))
   (clojure.core/let
    [v6524
     (:instance-id m6523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setInstanceId (clojure.core/str v6524))))
   (clojure.core/let
    [v6524
     (:auto-scaling-group-name
      m6523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setAutoScalingGroupName (clojure.core/str v6524))))
   bean6522))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExitStandbyRequest}
exit-standby-request
  [m6526]
  (clojure.core/let
   [bean6525
    (new com.amazonaws.services.autoscaling.model.ExitStandbyRequest)]
   (clojure.core/let
    [v6527
     (:instance-ids m6526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (.
      bean6525
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6589] (clojure.core/str arg6589))
 v6527))))
   (clojure.core/let
    [v6527
     (:auto-scaling-group-name
      m6526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (. bean6525 setAutoScalingGroupName (clojure.core/str v6527))))
   bean6525))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DetachInstancesRequest}
detach-instances-request
  [m6529]
  (clojure.core/let
   [bean6528
    (new
     com.amazonaws.services.autoscaling.model.DetachInstancesRequest)]
   (clojure.core/let
    [v6530
     (:should-decrement-desired-capacity
      m6529
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (.
      bean6528
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6530))))
   (clojure.core/let
    [v6530
     (:instance-ids m6529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (.
      bean6528
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6590] (clojure.core/str arg6590))
 v6530))))
   (clojure.core/let
    [v6530
     (:auto-scaling-group-name
      m6529
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (. bean6528 setAutoScalingGroupName (clojure.core/str v6530))))
   bean6528))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest}
set-desired-capacity-request
  [m6532]
  (clojure.core/let
   [bean6531
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/let
    [v6533
     (:desired-capacity
      m6532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setDesiredCapacity (clojure.core/int v6533))))
   (clojure.core/let
    [v6533
     (:honor-cooldown m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setHonorCooldown (clojure.core/boolean v6533))))
   (clojure.core/let
    [v6533
     (:auto-scaling-group-name
      m6532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setAutoScalingGroupName (clojure.core/str v6533))))
   bean6531))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest}
set-instance-health-request
  [m6535]
  (clojure.core/let
   [bean6534
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/let
    [v6536
     (:health-status m6535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setHealthStatus (clojure.core/str v6536))))
   (clojure.core/let
    [v6536
     (:should-respect-grace-period
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (.
      bean6534
      setShouldRespectGracePeriod
      (clojure.core/boolean v6536))))
   (clojure.core/let
    [v6536
     (:instance-id m6535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setInstanceId (clojure.core/str v6536))))
   bean6534))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribePoliciesRequest}
describe-policies-request
  [m6538]
  (clojure.core/let
   [bean6537
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/let
    [v6539
     (:policy-types m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (.
      bean6537
      setPolicyTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6647] (clojure.core/str arg6647))
 v6539))))
   (clojure.core/let
    [v6539
     (:max-records m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setMaxRecords (clojure.core/int v6539))))
   (clojure.core/let
    [v6539
     (:next-token m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setNextToken (clojure.core/str v6539))))
   (clojure.core/let
    [v6539
     (:auto-scaling-group-name
      m6538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setAutoScalingGroupName (clojure.core/str v6539))))
   (clojure.core/let
    [v6539
     (:policy-names m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (.
      bean6537
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6648] (clojure.core/str arg6648))
 v6539))))
   bean6537))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest}
put-scheduled-update-group-action-request
  [m6541]
  (clojure.core/let
   [bean6540
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/let
    [v6542 (:time m6541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setTime (com.palletops.awaze.common/to-date v6542))))
   (clojure.core/let
    [v6542
     (:desired-capacity
      m6541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setDesiredCapacity (clojure.core/int v6542))))
   (clojure.core/let
    [v6542
     (:scheduled-action-name
      m6541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setScheduledActionName (clojure.core/str v6542))))
   (clojure.core/let
    [v6542
     (:start-time m6541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (.
      bean6540
      setStartTime
      (com.palletops.awaze.common/to-date v6542))))
   (clojure.core/let
    [v6542
     (:recurrence m6541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setRecurrence (clojure.core/str v6542))))
   (clojure.core/let
    [v6542
     (:min-size m6541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setMinSize (clojure.core/int v6542))))
   (clojure.core/let
    [v6542
     (:end-time m6541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (.
      bean6540
      setEndTime
      (com.palletops.awaze.common/to-date v6542))))
   (clojure.core/let
    [v6542
     (:auto-scaling-group-name
      m6541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setAutoScalingGroupName (clojure.core/str v6542))))
   (clojure.core/let
    [v6542
     (:max-size m6541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6542 :com.palletops.awaze.client-builder/undef)
     (. bean6540 setMaxSize (clojure.core/int v6542))))
   bean6540))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnterStandbyRequest}
enter-standby-request
  [m6544]
  (clojure.core/let
   [bean6543
    (new com.amazonaws.services.autoscaling.model.EnterStandbyRequest)]
   (clojure.core/let
    [v6545
     (:should-decrement-desired-capacity
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (.
      bean6543
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6545))))
   (clojure.core/let
    [v6545
     (:instance-ids m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (.
      bean6543
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6649] (clojure.core/str arg6649))
 v6545))))
   (clojure.core/let
    [v6545
     (:auto-scaling-group-name
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setAutoScalingGroupName (clojure.core/str v6545))))
   bean6543))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest}
enable-metrics-collection-request
  [m6547]
  (clojure.core/let
   [bean6546
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/let
    [v6548 (:metrics m6547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6548 :com.palletops.awaze.client-builder/undef)
     (.
      bean6546
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6650] (clojure.core/str arg6650))
 v6548))))
   (clojure.core/let
    [v6548
     (:granularity m6547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6548 :com.palletops.awaze.client-builder/undef)
     (. bean6546 setGranularity (clojure.core/str v6548))))
   (clojure.core/let
    [v6548
     (:auto-scaling-group-name
      m6547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6548 :com.palletops.awaze.client-builder/undef)
     (. bean6546 setAutoScalingGroupName (clojure.core/str v6548))))
   bean6546))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest}
describe-metric-collection-types-request
  [m6550]
  (clojure.core/let
   [bean6549
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean6549))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest}
create-launch-configuration-request
  [m6553]
  (clojure.core/let
   [bean6552
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/let
    [v6554
     (:instance-monitoring
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (.
      bean6552
      setInstanceMonitoring
      (autoscaling/instance-monitoring v6554))))
   (clojure.core/let
    [v6554
     (:spot-price m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setSpotPrice (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:iam-instance-profile
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setIamInstanceProfile (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:classic-link-vpcid
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setClassicLinkVPCId (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:instance-type m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setInstanceType (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:ebs-optimized m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setEbsOptimized (clojure.core/boolean v6554))))
   (clojure.core/let
    [v6554
     (:ramdisk-id m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setRamdiskId (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:instance-id m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setInstanceId (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:image-id m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setImageId (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:launch-configuration-name
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setLaunchConfigurationName (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:key-name m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setKeyName (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:classic-link-vpcsecurity-groups
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (.
      bean6552
      setClassicLinkVPCSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6651] (clojure.core/str arg6651))
 v6554))))
   (clojure.core/let
    [v6554
     (:placement-tenancy
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setPlacementTenancy (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:kernel-id m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setKernelId (clojure.core/str v6554))))
   (clojure.core/let
    [v6554
     (:associate-public-ip-address
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (.
      bean6552
      setAssociatePublicIpAddress
      (clojure.core/boolean v6554))))
   (clojure.core/let
    [v6554
     (:security-groups
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (.
      bean6552
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6652] (clojure.core/str arg6652))
 v6554))))
   (clojure.core/let
    [v6554
     (:block-device-mappings
      m6553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (.
      bean6552
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6653]
  (autoscaling/block-device-mapping arg6653))
 v6554))))
   (clojure.core/let
    [v6554
     (:user-data m6553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6554 :com.palletops.awaze.client-builder/undef)
     (. bean6552 setUserData (clojure.core/str v6554))))
   bean6552))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest}
delete-lifecycle-hook-request
  [m6556]
  (clojure.core/let
   [bean6555
    (new
     com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest)]
   (clojure.core/let
    [v6557
     (:lifecycle-hook-name
      m6556
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6557 :com.palletops.awaze.client-builder/undef)
     (. bean6555 setLifecycleHookName (clojure.core/str v6557))))
   (clojure.core/let
    [v6557
     (:auto-scaling-group-name
      m6556
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6557 :com.palletops.awaze.client-builder/undef)
     (. bean6555 setAutoScalingGroupName (clojure.core/str v6557))))
   bean6555))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest}
describe-launch-configurations-request
  [m6559]
  (clojure.core/let
   [bean6558
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/let
    [v6560
     (:launch-configuration-names
      m6559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (.
      bean6558
      setLaunchConfigurationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6654] (clojure.core/str arg6654))
 v6560))))
   (clojure.core/let
    [v6560
     (:max-records m6559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setMaxRecords (clojure.core/int v6560))))
   (clojure.core/let
    [v6560
     (:next-token m6559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6560 :com.palletops.awaze.client-builder/undef)
     (. bean6558 setNextToken (clojure.core/str v6560))))
   bean6558))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest}
describe-lifecycle-hook-types-request
  [m6562]
  (clojure.core/let
   [bean6561
    (new
     com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest)]
   bean6561))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn
   autoscaling
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m6591]
   (clojure.core/let
    [credentials6592 (:credentials m6591) args6593 (:args m6591)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6594
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6592)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6594
       updateAutoScalingGroup
       (autoscaling/update-auto-scaling-group-request
        (clojure.core/nth args6593 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Call updateAutoScalingGroup"}
   [credentials6596 & args6597]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6598
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6596)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6598
      updateAutoScalingGroup
      (autoscaling/update-auto-scaling-group-request
       (clojure.core/nth args6597 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-load-balancers
   [m6599]
   (clojure.core/let
    [credentials6600 (:credentials m6599) args6601 (:args m6599)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6602
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6600)]
     (clojure.core/case
      (clojure.core/count args6601)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6602
        attachLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6602
        attachLoadBalancers
        (autoscaling/attach-load-balancers-request
         (clojure.core/nth args6601 0))))))))
  (clojure.core/defn
   attach-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for attachLoadBalancers, attachLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :attach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   attach-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call attachLoadBalancers, attachLoadBalancers"}
   [credentials6604 & args6605]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6606
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6604)]
    (clojure.core/case
     (clojure.core/count args6605)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6606
       attachLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6606
       attachLoadBalancers
       (autoscaling/attach-load-balancers-request
        (clojure.core/nth args6605 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m6607]
   (clojure.core/let
    [credentials6608 (:credentials m6607) args6609 (:args m6607)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6610
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6608)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6610
       createOrUpdateTags
       (autoscaling/create-or-update-tags-request
        (clojure.core/nth args6609 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-or-update-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createOrUpdateTags"}
   [credentials6612 & args6613]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6614
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6612)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6614
      createOrUpdateTags
      (autoscaling/create-or-update-tags-request
       (clojure.core/nth args6613 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m6615]
   (clojure.core/let
    [credentials6616 (:credentials m6615) args6617 (:args m6615)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6618
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6616)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6618
       resumeProcesses
       (autoscaling/resume-processes-request
        (clojure.core/nth args6617 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for resumeProcesses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :resume-processes,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   resume-processes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call resumeProcesses"}
   [credentials6620 & args6621]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6622
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6620)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6622
      resumeProcesses
      (autoscaling/resume-processes-request
       (clojure.core/nth args6621 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m6623]
   (clojure.core/let
    [credentials6624 (:credentials m6623) args6625 (:args m6623)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6626
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6624)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6626
       terminateInstanceInAutoScalingGroup
       (autoscaling/terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args6625 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         should-decrement-desired-capacity
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         should-decrement-desired-capacity
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials6628 & args6629]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6630
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6628)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6630
      terminateInstanceInAutoScalingGroup
      (autoscaling/terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args6629 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m6631]
   (clojure.core/let
    [credentials6632 (:credentials m6631) args6633 (:args m6631)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6634
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6632)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6634
       deleteAutoScalingGroup
       (autoscaling/delete-auto-scaling-group-request
        (clojure.core/nth args6633 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         force-delete
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         force-delete
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteAutoScalingGroup"}
   [credentials6636 & args6637]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6638
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6636)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6638
      deleteAutoScalingGroup
      (autoscaling/delete-auto-scaling-group-request
       (clojure.core/nth args6637 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-load-balancers
   [m6639]
   (clojure.core/let
    [credentials6640 (:credentials m6639) args6641 (:args m6639)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6642
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6640)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6642
       describeLoadBalancers
       (autoscaling/describe-load-balancers-request
        (clojure.core/nth args6641 0)))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeLoadBalancers"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeLoadBalancers"}
   [credentials6644 & args6645]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6646
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6644)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6646
      describeLoadBalancers
      (autoscaling/describe-load-balancers-request
       (clojure.core/nth args6645 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m6655]
   (clojure.core/let
    [credentials6656 (:credentials m6655) args6657 (:args m6655)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6658
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6656)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6658
       disableMetricsCollection
       (autoscaling/disable-metrics-collection-request
        (clojure.core/nth args6657 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-metrics-collection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call disableMetricsCollection"}
   [credentials6660 & args6661]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6662
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6660)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6662
      disableMetricsCollection
      (autoscaling/disable-metrics-collection-request
       (clojure.core/nth args6661 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m6663]
   (clojure.core/let
    [credentials6664 (:credentials m6663) args6665 (:args m6663)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6666
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6664)]
     (clojure.core/case
      (clojure.core/count args6665)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6666
        describeScheduledActions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6666
        describeScheduledActions
        (autoscaling/describe-scheduled-actions-request
         (clojure.core/nth args6665 0))))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scheduled-action-names
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scheduled-actions,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-actions,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scheduled-action-names
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials6668 & args6669]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6670
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6668)]
    (clojure.core/case
     (clojure.core/count args6669)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6670
       describeScheduledActions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6670
       describeScheduledActions
       (autoscaling/describe-scheduled-actions-request
        (clojure.core/nth args6669 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m6671]
   (clojure.core/let
    [credentials6672 (:credentials m6671) args6673 (:args m6671)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6674
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6672)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6674
       deleteNotificationConfiguration
       (autoscaling/delete-notification-configuration-request
        (clojure.core/nth args6673 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteNotificationConfiguration"}
   [credentials6676 & args6677]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6678
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6676)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6678
      deleteNotificationConfiguration
      (autoscaling/delete-notification-configuration-request
       (clojure.core/nth args6677 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m6679]
   (clojure.core/let
    [credentials6680 (:credentials m6679) args6681 (:args m6679)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6682
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6680)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6682
       putScalingPolicy
       (autoscaling/put-scaling-policy-request
        (clojure.core/nth args6681 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [estimated-instance-warmup
                         adjustment-type
                         custom-request-headers
                         sdk-client-execution-timeout
                         metric-aggregation-type
                         sdk-request-timeout
                         scaling-adjustment
                         min-adjustment-magnitude
                         custom-query-parameters
                         cooldown
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-type
                         clone-source
                         step-adjustments
                         clone-root
                         min-adjustment-step
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScalingPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-scaling-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists (quote
               [[credentials
                 {:keys [estimated-instance-warmup
                         adjustment-type
                         custom-request-headers
                         sdk-client-execution-timeout
                         metric-aggregation-type
                         sdk-request-timeout
                         scaling-adjustment
                         min-adjustment-magnitude
                         custom-query-parameters
                         cooldown
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-type
                         clone-source
                         step-adjustments
                         clone-root
                         min-adjustment-step
                         auto-scaling-group-name]}]]),
    :doc "Call putScalingPolicy"}
   [credentials6684 & args6685]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6686
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6684)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6686
      putScalingPolicy
      (autoscaling/put-scaling-policy-request
       (clojure.core/nth args6685 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m6687]
   (clojure.core/let
    [credentials6688 (:credentials m6687) args6689 (:args m6687)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6690
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6688)]
     (clojure.core/case
      (clojure.core/count args6689)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6690
        describeScalingActivities))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6690
        describeScalingActivities
        (autoscaling/describe-scaling-activities-request
         (clojure.core/nth args6689 0))))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         activity-ids
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scaling-activities,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scaling-activities,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         activity-ids
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials6692 & args6693]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6694
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6692)]
    (clojure.core/case
     (clojure.core/count args6693)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6694
       describeScalingActivities))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6694
       describeScalingActivities
       (autoscaling/describe-scaling-activities-request
        (clojure.core/nth args6693 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-lifecycle-hooks
   [m6695]
   (clojure.core/let
    [credentials6696 (:credentials m6695) args6697 (:args m6695)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6698
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6696)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6698
       describeLifecycleHooks
       (autoscaling/describe-lifecycle-hooks-request
        (clojure.core/nth args6697 0)))))))
  (clojure.core/defn
   describe-lifecycle-hooks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-hook-names
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for describeLifecycleHooks"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-lifecycle-hooks,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-lifecycle-hooks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-hook-names
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call describeLifecycleHooks"}
   [credentials6700 & args6701]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6702
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6700)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6702
      describeLifecycleHooks
      (autoscaling/describe-lifecycle-hooks-request
       (clojure.core/nth args6701 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m6703]
   (clojure.core/let
    [credentials6704 (:credentials m6703) args6705 (:args m6703)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6706
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6704)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6706
       deleteLaunchConfiguration
       (autoscaling/delete-launch-configuration-request
        (clojure.core/nth args6705 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-launch-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLaunchConfiguration"}
   [credentials6708 & args6709]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6710
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6708)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6710
      deleteLaunchConfiguration
      (autoscaling/delete-launch-configuration-request
       (clojure.core/nth args6709 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m6711]
   (clojure.core/let
    [credentials6712 (:credentials m6711) args6713 (:args m6711)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6714
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6712)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6714
       deletePolicy
       (autoscaling/delete-policy-request
        (clojure.core/nth args6713 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deletePolicy"}
   [credentials6716 & args6717]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6718
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6716)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6718
      deletePolicy
      (autoscaling/delete-policy-request
       (clojure.core/nth args6717 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m6719]
   (clojure.core/let
    [credentials6720 (:credentials m6719) args6721 (:args m6719)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6722
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6720)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6722
       createAutoScalingGroup
       (autoscaling/create-auto-scaling-group-request
        (clojure.core/nth args6721 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         instance-id
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         instance-id
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Call createAutoScalingGroup"}
   [credentials6724 & args6725]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6726
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6724)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6726
      createAutoScalingGroup
      (autoscaling/create-auto-scaling-group-request
       (clojure.core/nth args6725 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m6727]
   (clojure.core/let
    [credentials6728 (:credentials m6727) args6729 (:args m6727)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6730
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6728)]
     (clojure.core/case
      (clojure.core/count args6729)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6730
        describeScalingProcessTypes
        (autoscaling/describe-scaling-process-types-request
         (clojure.core/nth args6729 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6730
        describeScalingProcessTypes))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scaling-process-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scaling-process-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials6732 & args6733]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6734
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6732)]
    (clojure.core/case
     (clojure.core/count args6733)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6734
       describeScalingProcessTypes
       (autoscaling/describe-scaling-process-types-request
        (clojure.core/nth args6733 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6734
       describeScalingProcessTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-account-limits
   [m6735]
   (clojure.core/let
    [credentials6736 (:credentials m6735) args6737 (:args m6735)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6738
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6736)]
     (clojure.core/case
      (clojure.core/count args6737)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6738
        describeAccountLimits
        (autoscaling/describe-account-limits-request
         (clojure.core/nth args6737 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6738
        describeAccountLimits))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAccountLimits, describeAccountLimits"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAccountLimits, describeAccountLimits"}
   [credentials6740 & args6741]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6742
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6740)]
    (clojure.core/case
     (clojure.core/count args6741)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6742
       describeAccountLimits
       (autoscaling/describe-account-limits-request
        (clojure.core/nth args6741 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6742
       describeAccountLimits))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m6743]
   (clojure.core/let
    [credentials6744 (:credentials m6743) args6745 (:args m6743)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6746
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6744)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6746
       deleteScheduledAction
       (autoscaling/delete-scheduled-action-request
        (clojure.core/nth args6745 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-scheduled-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteScheduledAction"}
   [credentials6748 & args6749]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6750
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6748)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6750
      deleteScheduledAction
      (autoscaling/delete-scheduled-action-request
       (clojure.core/nth args6749 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m6751]
   (clojure.core/let
    [credentials6752 (:credentials m6751) args6753 (:args m6751)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6754
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6752)]
     (clojure.core/case
      (clojure.core/count args6753)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6754
        describeNotificationConfigurations
        (autoscaling/describe-notification-configurations-request
         (clojure.core/nth args6753 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6754
        describeNotificationConfigurations))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-notification-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-notification-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials6756 & args6757]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6758
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6756)]
    (clojure.core/case
     (clojure.core/count args6757)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6758
       describeNotificationConfigurations
       (autoscaling/describe-notification-configurations-request
        (clojure.core/nth args6757 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6758
       describeNotificationConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m6759]
   (clojure.core/let
    [credentials6760 (:credentials m6759) args6761 (:args m6759)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6762
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6760)]
     (clojure.core/case
      (clojure.core/count args6761)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6762
        describeAdjustmentTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6762
        describeAdjustmentTypes
        (autoscaling/describe-adjustment-types-request
         (clojure.core/nth args6761 0))))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-adjustment-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-adjustment-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials6764 & args6765]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6766
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6764)]
    (clojure.core/case
     (clojure.core/count args6765)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6766
       describeAdjustmentTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6766
       describeAdjustmentTypes
       (autoscaling/describe-adjustment-types-request
        (clojure.core/nth args6765 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m6767]
   (clojure.core/let
    [credentials6768 (:credentials m6767) args6769 (:args m6767)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6770
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6768)]
     (clojure.core/case
      (clojure.core/count args6769)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6770
        describeAutoScalingInstances
        (autoscaling/describe-auto-scaling-instances-request
         (clojure.core/nth args6769 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6770
        describeAutoScalingInstances))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials6772 & args6773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6774
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6772)]
    (clojure.core/case
     (clojure.core/count args6773)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6774
       describeAutoScalingInstances
       (autoscaling/describe-auto-scaling-instances-request
        (clojure.core/nth args6773 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6774
       describeAutoScalingInstances))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m6775]
   (clojure.core/let
    [credentials6776 (:credentials m6775) args6777 (:args m6775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6778
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6776)]
     (clojure.core/case
      (clojure.core/count args6777)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6778
        describeTerminationPolicyTypes
        (autoscaling/describe-termination-policy-types-request
         (clojure.core/nth args6777 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6778
        describeTerminationPolicyTypes))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-termination-policy-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-termination-policy-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials6780 & args6781]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6782
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6780)]
    (clojure.core/case
     (clojure.core/count args6781)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6782
       describeTerminationPolicyTypes
       (autoscaling/describe-termination-policy-types-request
        (clojure.core/nth args6781 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6782
       describeTerminationPolicyTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-instances
   [m6783]
   (clojure.core/let
    [credentials6784 (:credentials m6783) args6785 (:args m6783)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6786
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6784)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6786
       attachInstances
       (autoscaling/attach-instances-request
        (clojure.core/nth args6785 0)))))))
  (clojure.core/defn
   attach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for attachInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   attach-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call attachInstances"}
   [credentials6788 & args6789]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6790
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6788)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6790
      attachInstances
      (autoscaling/attach-instances-request
       (clojure.core/nth args6789 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m6791]
   (clojure.core/let
    [credentials6792 (:credentials m6791) args6793 (:args m6791)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6794
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6792)]
     (clojure.core/case
      (clojure.core/count args6793)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6794
        describeTags
        (autoscaling/describe-tags-request
         (clojure.core/nth args6793 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6794
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials6796 & args6797]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6798
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6796)]
    (clojure.core/case
     (clojure.core/count args6797)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6798
       describeTags
       (autoscaling/describe-tags-request
        (clojure.core/nth args6797 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6798
       describeTags))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m6799]
   (clojure.core/let
    [credentials6800 (:credentials m6799) args6801 (:args m6799)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6802
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6800)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6802
       deleteTags
       (autoscaling/delete-tags-request (clojure.core/nth args6801 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials6804 & args6805]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6806
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6804)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6806
      deleteTags
      (autoscaling/delete-tags-request (clojure.core/nth args6805 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m6807]
   (clojure.core/let
    [credentials6808 (:credentials m6807) args6809 (:args m6807)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6810
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6808)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6810
       putNotificationConfiguration
       (autoscaling/put-notification-configuration-request
        (clojure.core/nth args6809 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         notification-types
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         notification-types
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call putNotificationConfiguration"}
   [credentials6812 & args6813]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6814
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6812)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6814
      putNotificationConfiguration
      (autoscaling/put-notification-configuration-request
       (clojure.core/nth args6813 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :detach-load-balancers
   [m6815]
   (clojure.core/let
    [credentials6816 (:credentials m6815) args6817 (:args m6815)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6818
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6816)]
     (clojure.core/case
      (clojure.core/count args6817)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6818
        detachLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6818
        detachLoadBalancers
        (autoscaling/detach-load-balancers-request
         (clojure.core/nth args6817 0))))))))
  (clojure.core/defn
   detach-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for detachLoadBalancers, detachLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :detach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   detach-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call detachLoadBalancers, detachLoadBalancers"}
   [credentials6820 & args6821]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6822
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6820)]
    (clojure.core/case
     (clojure.core/count args6821)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6822
       detachLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6822
       detachLoadBalancers
       (autoscaling/detach-load-balancers-request
        (clojure.core/nth args6821 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m6823]
   (clojure.core/let
    [credentials6824 (:credentials m6823) args6825 (:args m6823)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6826
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6824)]
     (clojure.core/case
      (clojure.core/count args6825)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6826
        describeAutoScalingNotificationTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6826
        describeAutoScalingNotificationTypes
        (autoscaling/describe-auto-scaling-notification-types-request
         (clojure.core/nth args6825 0))))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials6828 & args6829]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6830
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6828)]
    (clojure.core/case
     (clojure.core/count args6829)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6830
       describeAutoScalingNotificationTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6830
       describeAutoScalingNotificationTypes
       (autoscaling/describe-auto-scaling-notification-types-request
        (clojure.core/nth args6829 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-protection
   [m6831]
   (clojure.core/let
    [credentials6832 (:credentials m6831) args6833 (:args m6831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6834
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6832)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6834
       setInstanceProtection
       (autoscaling/set-instance-protection-request
        (clojure.core/nth args6833 0)))))))
  (clojure.core/defn
   set-instance-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         protected-from-scale-in
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setInstanceProtection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-instance-protection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-instance-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         protected-from-scale-in
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call setInstanceProtection"}
   [credentials6836 & args6837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6838
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6836)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6838
      setInstanceProtection
      (autoscaling/set-instance-protection-request
       (clojure.core/nth args6837 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :complete-lifecycle-action
   [m6839]
   (clojure.core/let
    [credentials6840 (:credentials m6839) args6841 (:args m6839)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6842
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6840)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6842
       completeLifecycleAction
       (autoscaling/complete-lifecycle-action-request
        (clojure.core/nth args6841 0)))))))
  (clojure.core/defn
   complete-lifecycle-action-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         lifecycle-action-result
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for completeLifecycleAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-lifecycle-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   complete-lifecycle-action
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         lifecycle-action-result
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call completeLifecycleAction"}
   [credentials6844 & args6845]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6846
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6844)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6846
      completeLifecycleAction
      (autoscaling/complete-lifecycle-action-request
       (clojure.core/nth args6845 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m6847]
   (clojure.core/let
    [credentials6848 (:credentials m6847) args6849 (:args m6847)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6850
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6848)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6850
       suspendProcesses
       (autoscaling/suspend-processes-request
        (clojure.core/nth args6849 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for suspendProcesses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :suspend-processes,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   suspend-processes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call suspendProcesses"}
   [credentials6852 & args6853]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6854
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6852)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6854
      suspendProcesses
      (autoscaling/suspend-processes-request
       (clojure.core/nth args6853 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m6855]
   (clojure.core/let
    [credentials6856 (:credentials m6855) args6857 (:args m6855)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6858
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6856)]
     (clojure.core/case
      (clojure.core/count args6857)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6858
        describeAutoScalingGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6858
        describeAutoScalingGroups
        (autoscaling/describe-auto-scaling-groups-request
         (clojure.core/nth args6857 0))))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials6860 & args6861]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6862
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6860)]
    (clojure.core/case
     (clojure.core/count args6861)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6862
       describeAutoScalingGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6862
       describeAutoScalingGroups
       (autoscaling/describe-auto-scaling-groups-request
        (clojure.core/nth args6861 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-lifecycle-hook
   [m6863]
   (clojure.core/let
    [credentials6864 (:credentials m6863) args6865 (:args m6863)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6866
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6864)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6866
       putLifecycleHook
       (autoscaling/put-lifecycle-hook-request
        (clojure.core/nth args6865 0)))))))
  (clojure.core/defn
   put-lifecycle-hook-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-metadata
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-target-arn
                         sdk-request-timeout
                         custom-query-parameters
                         heartbeat-timeout
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-transition
                         clone-root
                         auto-scaling-group-name
                         default-result]}]]),
    :doc "Generate map for putLifecycleHook"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-lifecycle-hook,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-lifecycle-hook
   {:arglists (quote
               [[credentials
                 {:keys [notification-metadata
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-target-arn
                         sdk-request-timeout
                         custom-query-parameters
                         heartbeat-timeout
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-transition
                         clone-root
                         auto-scaling-group-name
                         default-result]}]]),
    :doc "Call putLifecycleHook"}
   [credentials6868 & args6869]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6870
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6868)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6870
      putLifecycleHook
      (autoscaling/put-lifecycle-hook-request
       (clojure.core/nth args6869 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m6871]
   (clojure.core/let
    [credentials6872 (:credentials m6871) args6873 (:args m6871)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6874
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6872)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6874
       executePolicy
       (autoscaling/execute-policy-request
        (clojure.core/nth args6873 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         breach-threshold
                         metric-value
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for executePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :execute-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   execute-policy
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         breach-threshold
                         metric-value
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call executePolicy"}
   [credentials6876 & args6877]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6878
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6876)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6878
      executePolicy
      (autoscaling/execute-policy-request
       (clojure.core/nth args6877 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :record-lifecycle-action-heartbeat
   [m6879]
   (clojure.core/let
    [credentials6880 (:credentials m6879) args6881 (:args m6879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6882
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6880)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6882
       recordLifecycleActionHeartbeat
       (autoscaling/record-lifecycle-action-heartbeat-request
        (clojure.core/nth args6881 0)))))))
  (clojure.core/defn
   record-lifecycle-action-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for recordLifecycleActionHeartbeat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :record-lifecycle-action-heartbeat,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   record-lifecycle-action-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call recordLifecycleActionHeartbeat"}
   [credentials6884 & args6885]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6886
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6884)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6886
      recordLifecycleActionHeartbeat
      (autoscaling/record-lifecycle-action-heartbeat-request
       (clojure.core/nth args6885 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :exit-standby
   [m6887]
   (clojure.core/let
    [credentials6888 (:credentials m6887) args6889 (:args m6887)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6890
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6888)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6890
       exitStandby
       (autoscaling/exit-standby-request
        (clojure.core/nth args6889 0)))))))
  (clojure.core/defn
   exit-standby-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for exitStandby"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :exit-standby,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   exit-standby
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call exitStandby"}
   [credentials6892 & args6893]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6894
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6892)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6894
      exitStandby
      (autoscaling/exit-standby-request (clojure.core/nth args6893 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :detach-instances
   [m6895]
   (clojure.core/let
    [credentials6896 (:credentials m6895) args6897 (:args m6895)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6898
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6896)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6898
       detachInstances
       (autoscaling/detach-instances-request
        (clojure.core/nth args6897 0)))))))
  (clojure.core/defn
   detach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for detachInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   detach-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call detachInstances"}
   [credentials6900 & args6901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6902
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6900)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6902
      detachInstances
      (autoscaling/detach-instances-request
       (clojure.core/nth args6901 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m6903]
   (clojure.core/let
    [credentials6904 (:credentials m6903) args6905 (:args m6903)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6906
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6904)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6906
       setDesiredCapacity
       (autoscaling/set-desired-capacity-request
        (clojure.core/nth args6905 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         desired-capacity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-desired-capacity,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         desired-capacity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call setDesiredCapacity"}
   [credentials6908 & args6909]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6910
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6908)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6910
      setDesiredCapacity
      (autoscaling/set-desired-capacity-request
       (clojure.core/nth args6909 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m6911]
   (clojure.core/let
    [credentials6912 (:credentials m6911) args6913 (:args m6911)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6914
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6912)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6914
       setInstanceHealth
       (autoscaling/set-instance-health-request
        (clojure.core/nth args6913 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [health-status
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         should-respect-grace-period]}]]),
    :doc "Generate map for setInstanceHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-instance-health,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [health-status
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         should-respect-grace-period]}]]),
    :doc "Call setInstanceHealth"}
   [credentials6916 & args6917]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6918
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6916)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6918
      setInstanceHealth
      (autoscaling/set-instance-health-request
       (clojure.core/nth args6917 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m6919]
   (clojure.core/let
    [credentials6920 (:credentials m6919) args6921 (:args m6919)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6922
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6920)]
     (clojure.core/case
      (clojure.core/count args6921)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6922
        describePolicies
        (autoscaling/describe-policies-request
         (clojure.core/nth args6921 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6922
        describePolicies))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         policy-types
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-policies,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-policies,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         policy-types
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]
                [credentials]]),
    :doc "Call describePolicies, describePolicies"}
   [credentials6924 & args6925]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6926
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6924)]
    (clojure.core/case
     (clojure.core/count args6925)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6926
       describePolicies
       (autoscaling/describe-policies-request
        (clojure.core/nth args6925 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6926
       describePolicies))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m6927]
   (clojure.core/let
    [credentials6928 (:credentials m6927) args6929 (:args m6927)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6930
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6928)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6930
       putScheduledUpdateGroupAction
       (autoscaling/put-scheduled-update-group-action-request
        (clojure.core/nth args6929 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         time
                         start-time
                         custom-query-parameters
                         end-time
                         max-size
                         desired-capacity
                         min-size
                         read-limit
                         general-progress-listener
                         recurrence
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-scheduled-update-group-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         time
                         start-time
                         custom-query-parameters
                         end-time
                         max-size
                         desired-capacity
                         min-size
                         read-limit
                         general-progress-listener
                         recurrence
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials6932 & args6933]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6934
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6932)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6934
      putScheduledUpdateGroupAction
      (autoscaling/put-scheduled-update-group-action-request
       (clojure.core/nth args6933 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enter-standby
   [m6935]
   (clojure.core/let
    [credentials6936 (:credentials m6935) args6937 (:args m6935)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6938
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6936)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6938
       enterStandby
       (autoscaling/enter-standby-request
        (clojure.core/nth args6937 0)))))))
  (clojure.core/defn
   enter-standby-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enterStandby"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enter-standby,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   enter-standby
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call enterStandby"}
   [credentials6940 & args6941]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6942
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6940)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6942
      enterStandby
      (autoscaling/enter-standby-request
       (clojure.core/nth args6941 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m6943]
   (clojure.core/let
    [credentials6944 (:credentials m6943) args6945 (:args m6943)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6946
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6944)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6946
       enableMetricsCollection
       (autoscaling/enable-metrics-collection-request
        (clojure.core/nth args6945 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         granularity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-metrics-collection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         granularity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call enableMetricsCollection"}
   [credentials6948 & args6949]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6950
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6948)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6950
      enableMetricsCollection
      (autoscaling/enable-metrics-collection-request
       (clojure.core/nth args6949 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m6951]
   (clojure.core/let
    [credentials6952 (:credentials m6951) args6953 (:args m6951)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6954
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6952)]
     (clojure.core/case
      (clojure.core/count args6953)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6954
        describeMetricCollectionTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6954
        describeMetricCollectionTypes
        (autoscaling/describe-metric-collection-types-request
         (clojure.core/nth args6953 0))))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-metric-collection-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-metric-collection-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials6956 & args6957]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6958
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6956)]
    (clojure.core/case
     (clojure.core/count args6957)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6958
       describeMetricCollectionTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6958
       describeMetricCollectionTypes
       (autoscaling/describe-metric-collection-types-request
        (clojure.core/nth args6957 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m6959]
   (clojure.core/let
    [credentials6960 (:credentials m6959) args6961 (:args m6959)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6962
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6960)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6962
       createLaunchConfiguration
       (autoscaling/create-launch-configuration-request
        (clojure.core/nth args6961 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         security-groups
                         sdk-request-timeout
                         placement-tenancy
                         launch-configuration-name
                         instance-type
                         image-id
                         spot-price
                         instance-monitoring
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         iam-instance-profile
                         read-limit
                         classic-link-vpcsecurity-groups
                         kernel-id
                         general-progress-listener
                         associate-public-ip-address
                         classic-link-vpcid
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-launch-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         security-groups
                         sdk-request-timeout
                         placement-tenancy
                         launch-configuration-name
                         instance-type
                         image-id
                         spot-price
                         instance-monitoring
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         iam-instance-profile
                         read-limit
                         classic-link-vpcsecurity-groups
                         kernel-id
                         general-progress-listener
                         associate-public-ip-address
                         classic-link-vpcid
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createLaunchConfiguration"}
   [credentials6964 & args6965]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6966
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6964)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6966
      createLaunchConfiguration
      (autoscaling/create-launch-configuration-request
       (clojure.core/nth args6965 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-lifecycle-hook
   [m6967]
   (clojure.core/let
    [credentials6968 (:credentials m6967) args6969 (:args m6967)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6970
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6968)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6970
       deleteLifecycleHook
       (autoscaling/delete-lifecycle-hook-request
        (clojure.core/nth args6969 0)))))))
  (clojure.core/defn
   delete-lifecycle-hook-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteLifecycleHook"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-lifecycle-hook,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-lifecycle-hook
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteLifecycleHook"}
   [credentials6972 & args6973]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6974
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6972)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6974
      deleteLifecycleHook
      (autoscaling/delete-lifecycle-hook-request
       (clojure.core/nth args6973 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m6975]
   (clojure.core/let
    [credentials6976 (:credentials m6975) args6977 (:args m6975)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6978
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6976)]
     (clojure.core/case
      (clojure.core/count args6977)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6978
        describeLaunchConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6978
        describeLaunchConfigurations
        (autoscaling/describe-launch-configurations-request
         (clojure.core/nth args6977 0))))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-launch-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-launch-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials6980 & args6981]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6982
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6980)]
    (clojure.core/case
     (clojure.core/count args6981)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6982
       describeLaunchConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6982
       describeLaunchConfigurations
       (autoscaling/describe-launch-configurations-request
        (clojure.core/nth args6981 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-lifecycle-hook-types
   [m6983]
   (clojure.core/let
    [credentials6984 (:credentials m6983) args6985 (:args m6983)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6986
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6984)]
     (clojure.core/case
      (clojure.core/count args6985)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6986
        describeLifecycleHookTypes
        (autoscaling/describe-lifecycle-hook-types-request
         (clojure.core/nth args6985 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6986
        describeLifecycleHookTypes))))))
  (clojure.core/defn
   describe-lifecycle-hook-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeLifecycleHookTypes, describeLifecycleHookTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-lifecycle-hook-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-lifecycle-hook-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-lifecycle-hook-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeLifecycleHookTypes, describeLifecycleHookTypes"}
   [credentials6988 & args6989]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6990
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6988)]
    (clojure.core/case
     (clojure.core/count args6989)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6990
       describeLifecycleHookTypes
       (autoscaling/describe-lifecycle-hook-types-request
        (clojure.core/nth args6989 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6990
       describeLifecycleHookTypes)))))))
