(ns
 com.palletops.awaze.storagegateway
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.storagegateway :as storagegateway]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.Tag}
tag
  [m6983]
  (clojure.core/let
   [bean6982 (new com.amazonaws.services.storagegateway.model.Tag)]
   (clojure.core/let
    [v6984 (:key m6983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6984 :com.palletops.awaze.client-builder/undef)
     (. bean6982 setKey (clojure.core/str v6984))))
   (clojure.core/let
    [v6984 (:value m6983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6984 :com.palletops.awaze.client-builder/undef)
     (. bean6982 setValue (clojure.core/str v6984))))
   bean6982))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest}
update-chap-credentials-request
  [m6986]
  (clojure.core/let
   [bean6985
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/let
    [v6987
     (:target-arn m6986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6987 :com.palletops.awaze.client-builder/undef)
     (. bean6985 setTargetARN (clojure.core/str v6987))))
   (clojure.core/let
    [v6987
     (:initiator-name m6986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6987 :com.palletops.awaze.client-builder/undef)
     (. bean6985 setInitiatorName (clojure.core/str v6987))))
   (clojure.core/let
    [v6987
     (:secret-to-authenticate-initiator
      m6986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6987 :com.palletops.awaze.client-builder/undef)
     (.
      bean6985
      setSecretToAuthenticateInitiator
      (clojure.core/str v6987))))
   (clojure.core/let
    [v6987
     (:secret-to-authenticate-target
      m6986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6987 :com.palletops.awaze.client-builder/undef)
     (.
      bean6985
      setSecretToAuthenticateTarget
      (clojure.core/str v6987))))
   bean6985))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest}
add-working-storage-request
  [m6989]
  (clojure.core/let
   [bean6988
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/let
    [v6990
     (:gateway-arn m6989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6990 :com.palletops.awaze.client-builder/undef)
     (. bean6988 setGatewayARN (clojure.core/str v6990))))
   (clojure.core/let
    [v6990
     (:disk-ids m6989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6990 :com.palletops.awaze.client-builder/undef)
     (.
      bean6988
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7150] (clojure.core/str arg7150))
 v6990))))
   bean6988))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest}
describe-gateway-information-request
  [m6992]
  (clojure.core/let
   [bean6991
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/let
    [v6993
     (:gateway-arn m6992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6993 :com.palletops.awaze.client-builder/undef)
     (. bean6991 setGatewayARN (clojure.core/str v6993))))
   bean6991))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeRequest}
delete-tape-request
  [m6995]
  (clojure.core/let
   [bean6994
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeRequest)]
   (clojure.core/let
    [v6996
     (:gateway-arn m6995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6996 :com.palletops.awaze.client-builder/undef)
     (. bean6994 setGatewayARN (clojure.core/str v6996))))
   (clojure.core/let
    [v6996
     (:tape-arn m6995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6996 :com.palletops.awaze.client-builder/undef)
     (. bean6994 setTapeARN (clojure.core/str v6996))))
   bean6994))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest}
describe-snapshot-schedule-request
  [m6998]
  (clojure.core/let
   [bean6997
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/let
    [v6999
     (:volume-arn m6998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6999 :com.palletops.awaze.client-builder/undef)
     (. bean6997 setVolumeARN (clojure.core/str v6999))))
   bean6997))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapesRequest}
create-tapes-request
  [m7001]
  (clojure.core/let
   [bean7000
    (new
     com.amazonaws.services.storagegateway.model.CreateTapesRequest)]
   (clojure.core/let
    [v7002
     (:gateway-arn m7001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7002 :com.palletops.awaze.client-builder/undef)
     (. bean7000 setGatewayARN (clojure.core/str v7002))))
   (clojure.core/let
    [v7002
     (:tape-size-in-bytes
      m7001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7002 :com.palletops.awaze.client-builder/undef)
     (. bean7000 setTapeSizeInBytes (clojure.core/long v7002))))
   (clojure.core/let
    [v7002
     (:num-tapes-to-create
      m7001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7002 :com.palletops.awaze.client-builder/undef)
     (. bean7000 setNumTapesToCreate (clojure.core/int v7002))))
   (clojure.core/let
    [v7002
     (:tape-barcode-prefix
      m7001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7002 :com.palletops.awaze.client-builder/undef)
     (. bean7000 setTapeBarcodePrefix (clojure.core/str v7002))))
   (clojure.core/let
    [v7002
     (:client-token m7001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7002 :com.palletops.awaze.client-builder/undef)
     (. bean7000 setClientToken (clojure.core/str v7002))))
   bean7000))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest}
delete-chap-credentials-request
  [m7004]
  (clojure.core/let
   [bean7003
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/let
    [v7005
     (:target-arn m7004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7005 :com.palletops.awaze.client-builder/undef)
     (. bean7003 setTargetARN (clojure.core/str v7005))))
   (clojure.core/let
    [v7005
     (:initiator-name m7004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7005 :com.palletops.awaze.client-builder/undef)
     (. bean7003 setInitiatorName (clojure.core/str v7005))))
   bean7003))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelArchivalRequest}
cancel-archival-request
  [m7007]
  (clojure.core/let
   [bean7006
    (new
     com.amazonaws.services.storagegateway.model.CancelArchivalRequest)]
   (clojure.core/let
    [v7008
     (:gateway-arn m7007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7008 :com.palletops.awaze.client-builder/undef)
     (. bean7006 setGatewayARN (clojure.core/str v7008))))
   (clojure.core/let
    [v7008
     (:tape-arn m7007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7008 :com.palletops.awaze.client-builder/undef)
     (. bean7006 setTapeARN (clojure.core/str v7008))))
   bean7006))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelRetrievalRequest}
cancel-retrieval-request
  [m7010]
  (clojure.core/let
   [bean7009
    (new
     com.amazonaws.services.storagegateway.model.CancelRetrievalRequest)]
   (clojure.core/let
    [v7011
     (:gateway-arn m7010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setGatewayARN (clojure.core/str v7011))))
   (clojure.core/let
    [v7011
     (:tape-arn m7010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setTapeARN (clojure.core/str v7011))))
   bean7009))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteVolumeRequest}
delete-volume-request
  [m7013]
  (clojure.core/let
   [bean7012
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v7014
     (:volume-arn m7013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7014 :com.palletops.awaze.client-builder/undef)
     (. bean7012 setVolumeARN (clojure.core/str v7014))))
   bean7012))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest}
describe-storedi-scsivolumes-request
  [m7016]
  (clojure.core/let
   [bean7015
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/let
    [v7017
     (:volume-arns m7016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7017 :com.palletops.awaze.client-builder/undef)
     (.
      bean7015
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7151] (clojure.core/str arg7151))
 v7017))))
   bean7015))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m7019]
  (clojure.core/let
   [bean7018
    (new
     com.amazonaws.services.storagegateway.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v7020
     (:resource-arn m7019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7020 :com.palletops.awaze.client-builder/undef)
     (. bean7018 setResourceARN (clojure.core/str v7020))))
   (clojure.core/let
    [v7020 (:tags m7019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7020 :com.palletops.awaze.client-builder/undef)
     (.
      bean7018
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7152] (storagegateway/tag arg7152))
 v7020))))
   bean7018))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest}
create-cachedi-scsivolume-request
  [m7022]
  (clojure.core/let
   [bean7021
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/let
    [v7023
     (:gateway-arn m7022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setGatewayARN (clojure.core/str v7023))))
   (clojure.core/let
    [v7023
     (:volume-size-in-bytes
      m7022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setVolumeSizeInBytes (clojure.core/long v7023))))
   (clojure.core/let
    [v7023
     (:target-name m7022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setTargetName (clojure.core/str v7023))))
   (clojure.core/let
    [v7023
     (:client-token m7022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setClientToken (clojure.core/str v7023))))
   (clojure.core/let
    [v7023
     (:network-interface-id
      m7022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setNetworkInterfaceId (clojure.core/str v7023))))
   (clojure.core/let
    [v7023
     (:snapshot-id m7022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setSnapshotId (clojure.core/str v7023))))
   bean7021))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest}
retrieve-tape-archive-request
  [m7025]
  (clojure.core/let
   [bean7024
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest)]
   (clojure.core/let
    [v7026
     (:gateway-arn m7025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7026 :com.palletops.awaze.client-builder/undef)
     (. bean7024 setGatewayARN (clojure.core/str v7026))))
   (clojure.core/let
    [v7026
     (:tape-arn m7025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7026 :com.palletops.awaze.client-builder/undef)
     (. bean7024 setTapeARN (clojure.core/str v7026))))
   bean7024))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddUploadBufferRequest}
add-upload-buffer-request
  [m7028]
  (clojure.core/let
   [bean7027
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/let
    [v7029
     (:gateway-arn m7028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (. bean7027 setGatewayARN (clojure.core/str v7029))))
   (clojure.core/let
    [v7029
     (:disk-ids m7028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (.
      bean7027
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7153] (clojure.core/str arg7153))
 v7029))))
   bean7027))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumesRequest}
list-volumes-request
  [m7031]
  (clojure.core/let
   [bean7030
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/let
    [v7032 (:limit m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setLimit (clojure.core/int v7032))))
   (clojure.core/let
    [v7032 (:marker m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setMarker (clojure.core/str v7032))))
   (clojure.core/let
    [v7032
     (:gateway-arn m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setGatewayARN (clojure.core/str v7032))))
   bean7030))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest}
describe-tape-archives-request
  [m7034]
  (clojure.core/let
   [bean7033
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest)]
   (clojure.core/let
    [v7035 (:limit m7034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7035 :com.palletops.awaze.client-builder/undef)
     (. bean7033 setLimit (clojure.core/int v7035))))
   (clojure.core/let
    [v7035 (:marker m7034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7035 :com.palletops.awaze.client-builder/undef)
     (. bean7033 setMarker (clojure.core/str v7035))))
   (clojure.core/let
    [v7035
     (:tape-arns m7034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7035 :com.palletops.awaze.client-builder/undef)
     (.
      bean7033
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7154] (clojure.core/str arg7154))
 v7035))))
   bean7033))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest}
describe-upload-buffer-request
  [m7037]
  (clojure.core/let
   [bean7036
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/let
    [v7038
     (:gateway-arn m7037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7038 :com.palletops.awaze.client-builder/undef)
     (. bean7036 setGatewayARN (clojure.core/str v7038))))
   bean7036))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListLocalDisksRequest}
list-local-disks-request
  [m7040]
  (clojure.core/let
   [bean7039
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/let
    [v7041
     (:gateway-arn m7040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7041 :com.palletops.awaze.client-builder/undef)
     (. bean7039 setGatewayARN (clojure.core/str v7041))))
   bean7039))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateVTLDeviceTypeRequest}
update-vtldevice-type-request
  [m7043]
  (clojure.core/let
   [bean7042
    (new
     com.amazonaws.services.storagegateway.model.UpdateVTLDeviceTypeRequest)]
   (clojure.core/let
    [v7044
     (:vtldevice-arn m7043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7044 :com.palletops.awaze.client-builder/undef)
     (. bean7042 setVTLDeviceARN (clojure.core/str v7044))))
   (clojure.core/let
    [v7044
     (:device-type m7043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7044 :com.palletops.awaze.client-builder/undef)
     (. bean7042 setDeviceType (clojure.core/str v7044))))
   bean7042))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest}
describe-tape-recovery-points-request
  [m7046]
  (clojure.core/let
   [bean7045
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)]
   (clojure.core/let
    [v7047 (:limit m7046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7047 :com.palletops.awaze.client-builder/undef)
     (. bean7045 setLimit (clojure.core/int v7047))))
   (clojure.core/let
    [v7047 (:marker m7046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7047 :com.palletops.awaze.client-builder/undef)
     (. bean7045 setMarker (clojure.core/str v7047))))
   (clojure.core/let
    [v7047
     (:gateway-arn m7046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7047 :com.palletops.awaze.client-builder/undef)
     (. bean7045 setGatewayARN (clojure.core/str v7047))))
   bean7045))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest}
delete-tape-archive-request
  [m7049]
  (clojure.core/let
   [bean7048
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest)]
   (clojure.core/let
    [v7050
     (:tape-arn m7049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7050 :com.palletops.awaze.client-builder/undef)
     (. bean7048 setTapeARN (clojure.core/str v7050))))
   bean7048))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest}
delete-bandwidth-rate-limit-request
  [m7052]
  (clojure.core/let
   [bean7051
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7053
     (:gateway-arn m7052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7053 :com.palletops.awaze.client-builder/undef)
     (. bean7051 setGatewayARN (clojure.core/str v7053))))
   (clojure.core/let
    [v7053
     (:bandwidth-type m7052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7053 :com.palletops.awaze.client-builder/undef)
     (. bean7051 setBandwidthType (clojure.core/str v7053))))
   bean7051))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DisableGatewayRequest}
disable-gateway-request
  [m7055]
  (clojure.core/let
   [bean7054
    (new
     com.amazonaws.services.storagegateway.model.DisableGatewayRequest)]
   (clojure.core/let
    [v7056
     (:gateway-arn m7055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7056 :com.palletops.awaze.client-builder/undef)
     (. bean7054 setGatewayARN (clojure.core/str v7056))))
   bean7054))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteGatewayRequest}
delete-gateway-request
  [m7058]
  (clojure.core/let
   [bean7057
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/let
    [v7059
     (:gateway-arn m7058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7059 :com.palletops.awaze.client-builder/undef)
     (. bean7057 setGatewayARN (clojure.core/str v7059))))
   bean7057))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ActivateGatewayRequest}
activate-gateway-request
  [m7061]
  (clojure.core/let
   [bean7060
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/let
    [v7062
     (:activation-key m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setActivationKey (clojure.core/str v7062))))
   (clojure.core/let
    [v7062
     (:gateway-name m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setGatewayName (clojure.core/str v7062))))
   (clojure.core/let
    [v7062
     (:gateway-timezone
      m7061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setGatewayTimezone (clojure.core/str v7062))))
   (clojure.core/let
    [v7062
     (:gateway-region m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setGatewayRegion (clojure.core/str v7062))))
   (clojure.core/let
    [v7062
     (:gateway-type m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setGatewayType (clojure.core/str v7062))))
   (clojure.core/let
    [v7062
     (:tape-drive-type
      m7061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setTapeDriveType (clojure.core/str v7062))))
   (clojure.core/let
    [v7062
     (:medium-changer-type
      m7061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setMediumChangerType (clojure.core/str v7062))))
   bean7060))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest}
describe-maintenance-start-time-request
  [m7064]
  (clojure.core/let
   [bean7063
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v7065
     (:gateway-arn m7064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7065 :com.palletops.awaze.client-builder/undef)
     (. bean7063 setGatewayARN (clojure.core/str v7065))))
   bean7063))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest}
describe-bandwidth-rate-limit-request
  [m7067]
  (clojure.core/let
   [bean7066
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7068
     (:gateway-arn m7067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7068 :com.palletops.awaze.client-builder/undef)
     (. bean7066 setGatewayARN (clojure.core/str v7068))))
   bean7066))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapesRequest}
describe-tapes-request
  [m7070]
  (clojure.core/let
   [bean7069
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapesRequest)]
   (clojure.core/let
    [v7071 (:limit m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setLimit (clojure.core/int v7071))))
   (clojure.core/let
    [v7071 (:marker m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setMarker (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:gateway-arn m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setGatewayARN (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:tape-arns m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (.
      bean7069
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7155] (clojure.core/str arg7155))
 v7071))))
   bean7069))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.StartGatewayRequest}
start-gateway-request
  [m7073]
  (clojure.core/let
   [bean7072
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/let
    [v7074
     (:gateway-arn m7073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7074 :com.palletops.awaze.client-builder/undef)
     (. bean7072 setGatewayARN (clojure.core/str v7074))))
   bean7072))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest}
update-snapshot-schedule-request
  [m7076]
  (clojure.core/let
   [bean7075
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/let
    [v7077
     (:volume-arn m7076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7077 :com.palletops.awaze.client-builder/undef)
     (. bean7075 setVolumeARN (clojure.core/str v7077))))
   (clojure.core/let
    [v7077
     (:start-at m7076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7077 :com.palletops.awaze.client-builder/undef)
     (. bean7075 setStartAt (clojure.core/int v7077))))
   (clojure.core/let
    [v7077
     (:recurrence-in-hours
      m7076
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7077 :com.palletops.awaze.client-builder/undef)
     (. bean7075 setRecurrenceInHours (clojure.core/int v7077))))
   (clojure.core/let
    [v7077
     (:description m7076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7077 :com.palletops.awaze.client-builder/undef)
     (. bean7075 setDescription (clojure.core/str v7077))))
   bean7075))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest}
update-bandwidth-rate-limit-request
  [m7079]
  (clojure.core/let
   [bean7078
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7080
     (:gateway-arn m7079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (. bean7078 setGatewayARN (clojure.core/str v7080))))
   (clojure.core/let
    [v7080
     (:average-upload-rate-limit-in-bits-per-sec
      m7079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (.
      bean7078
      setAverageUploadRateLimitInBitsPerSec
      (clojure.core/long v7080))))
   (clojure.core/let
    [v7080
     (:average-download-rate-limit-in-bits-per-sec
      m7079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (.
      bean7078
      setAverageDownloadRateLimitInBitsPerSec
      (clojure.core/long v7080))))
   bean7078))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest}
update-gateway-software-now-request
  [m7082]
  (clojure.core/let
   [bean7081
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/let
    [v7083
     (:gateway-arn m7082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7083 :com.palletops.awaze.client-builder/undef)
     (. bean7081 setGatewayARN (clojure.core/str v7083))))
   bean7081))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest}
create-storedi-scsivolume-request
  [m7085]
  (clojure.core/let
   [bean7084
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/let
    [v7086
     (:gateway-arn m7085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setGatewayARN (clojure.core/str v7086))))
   (clojure.core/let
    [v7086
     (:preserve-existing-data
      m7085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setPreserveExistingData (clojure.core/boolean v7086))))
   (clojure.core/let
    [v7086 (:disk-id m7085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setDiskId (clojure.core/str v7086))))
   (clojure.core/let
    [v7086
     (:target-name m7085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setTargetName (clojure.core/str v7086))))
   (clojure.core/let
    [v7086
     (:network-interface-id
      m7085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setNetworkInterfaceId (clojure.core/str v7086))))
   (clojure.core/let
    [v7086
     (:snapshot-id m7085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setSnapshotId (clojure.core/str v7086))))
   bean7084))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest}
update-gateway-information-request
  [m7088]
  (clojure.core/let
   [bean7087
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/let
    [v7089
     (:gateway-arn m7088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setGatewayARN (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:gateway-name m7088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setGatewayName (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:gateway-timezone
      m7088
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setGatewayTimezone (clojure.core/str v7089))))
   bean7087))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest}
delete-snapshot-schedule-request
  [m7091]
  (clojure.core/let
   [bean7090
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/let
    [v7092
     (:volume-arn m7091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7092 :com.palletops.awaze.client-builder/undef)
     (. bean7090 setVolumeARN (clojure.core/str v7092))))
   bean7090))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCacheRequest}
describe-cache-request
  [m7094]
  (clojure.core/let
   [bean7093
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/let
    [v7095
     (:gateway-arn m7094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7095 :com.palletops.awaze.client-builder/undef)
     (. bean7093 setGatewayARN (clojure.core/str v7095))))
   bean7093))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest}
describe-chap-credentials-request
  [m7097]
  (clojure.core/let
   [bean7096
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/let
    [v7098
     (:target-arn m7097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7098 :com.palletops.awaze.client-builder/undef)
     (. bean7096 setTargetARN (clojure.core/str v7098))))
   bean7096))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest}
list-volume-recovery-points-request
  [m7100]
  (clojure.core/let
   [bean7099
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/let
    [v7101
     (:gateway-arn m7100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7101 :com.palletops.awaze.client-builder/undef)
     (. bean7099 setGatewayARN (clojure.core/str v7101))))
   bean7099))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m7103]
  (clojure.core/let
   [bean7102
    (new
     com.amazonaws.services.storagegateway.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v7104
     (:resource-arn m7103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7104 :com.palletops.awaze.client-builder/undef)
     (. bean7102 setResourceARN (clojure.core/str v7104))))
   (clojure.core/let
    [v7104
     (:tag-keys m7103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7104 :com.palletops.awaze.client-builder/undef)
     (.
      bean7102
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7156] (clojure.core/str arg7156))
 v7104))))
   bean7102))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest}
create-tape-with-barcode-request
  [m7106]
  (clojure.core/let
   [bean7105
    (new
     com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest)]
   (clojure.core/let
    [v7107
     (:gateway-arn m7106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7107 :com.palletops.awaze.client-builder/undef)
     (. bean7105 setGatewayARN (clojure.core/str v7107))))
   (clojure.core/let
    [v7107
     (:tape-size-in-bytes
      m7106
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7107 :com.palletops.awaze.client-builder/undef)
     (. bean7105 setTapeSizeInBytes (clojure.core/long v7107))))
   (clojure.core/let
    [v7107
     (:tape-barcode m7106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7107 :com.palletops.awaze.client-builder/undef)
     (. bean7105 setTapeBarcode (clojure.core/str v7107))))
   bean7105))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddCacheRequest}
add-cache-request
  [m7109]
  (clojure.core/let
   [bean7108
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/let
    [v7110
     (:gateway-arn m7109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7110 :com.palletops.awaze.client-builder/undef)
     (. bean7108 setGatewayARN (clojure.core/str v7110))))
   (clojure.core/let
    [v7110
     (:disk-ids m7109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7110 :com.palletops.awaze.client-builder/undef)
     (.
      bean7108
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7157] (clojure.core/str arg7157))
 v7110))))
   bean7108))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListGatewaysRequest}
list-gateways-request
  [m7112]
  (clojure.core/let
   [bean7111
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/let
    [v7113 (:limit m7112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setLimit (clojure.core/int v7113))))
   (clojure.core/let
    [v7113 (:marker m7112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setMarker (clojure.core/str v7113))))
   bean7111))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m7115]
  (clojure.core/let
   [bean7114
    (new
     com.amazonaws.services.storagegateway.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v7116 (:limit m7115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setLimit (clojure.core/int v7116))))
   (clojure.core/let
    [v7116 (:marker m7115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setMarker (clojure.core/str v7116))))
   (clojure.core/let
    [v7116
     (:resource-arn m7115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setResourceARN (clojure.core/str v7116))))
   bean7114))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest}
retrieve-tape-recovery-point-request
  [m7118]
  (clojure.core/let
   [bean7117
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest)]
   (clojure.core/let
    [v7119
     (:gateway-arn m7118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7119 :com.palletops.awaze.client-builder/undef)
     (. bean7117 setGatewayARN (clojure.core/str v7119))))
   (clojure.core/let
    [v7119
     (:tape-arn m7118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7119 :com.palletops.awaze.client-builder/undef)
     (. bean7117 setTapeARN (clojure.core/str v7119))))
   bean7117))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest}
update-maintenance-start-time-request
  [m7121]
  (clojure.core/let
   [bean7120
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v7122
     (:day-of-week m7121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7122 :com.palletops.awaze.client-builder/undef)
     (. bean7120 setDayOfWeek (clojure.core/int v7122))))
   (clojure.core/let
    [v7122
     (:hour-of-day m7121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7122 :com.palletops.awaze.client-builder/undef)
     (. bean7120 setHourOfDay (clojure.core/int v7122))))
   (clojure.core/let
    [v7122
     (:minute-of-hour m7121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7122 :com.palletops.awaze.client-builder/undef)
     (. bean7120 setMinuteOfHour (clojure.core/int v7122))))
   (clojure.core/let
    [v7122
     (:gateway-arn m7121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7122 :com.palletops.awaze.client-builder/undef)
     (. bean7120 setGatewayARN (clojure.core/str v7122))))
   bean7120))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ResetCacheRequest}
reset-cache-request
  [m7124]
  (clojure.core/let
   [bean7123
    (new
     com.amazonaws.services.storagegateway.model.ResetCacheRequest)]
   (clojure.core/let
    [v7125
     (:gateway-arn m7124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7125 :com.palletops.awaze.client-builder/undef)
     (. bean7123 setGatewayARN (clojure.core/str v7125))))
   bean7123))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest}
describe-vtldevices-request
  [m7127]
  (clojure.core/let
   [bean7126
    (new
     com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest)]
   (clojure.core/let
    [v7128 (:limit m7127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7128 :com.palletops.awaze.client-builder/undef)
     (. bean7126 setLimit (clojure.core/int v7128))))
   (clojure.core/let
    [v7128 (:marker m7127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7128 :com.palletops.awaze.client-builder/undef)
     (. bean7126 setMarker (clojure.core/str v7128))))
   (clojure.core/let
    [v7128
     (:gateway-arn m7127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7128 :com.palletops.awaze.client-builder/undef)
     (. bean7126 setGatewayARN (clojure.core/str v7128))))
   (clojure.core/let
    [v7128
     (:vtldevice-arns m7127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7128 :com.palletops.awaze.client-builder/undef)
     (.
      bean7126
      setVTLDeviceARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7206] (clojure.core/str arg7206))
 v7128))))
   bean7126))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest}
describe-cachedi-scsivolumes-request
  [m7130]
  (clojure.core/let
   [bean7129
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/let
    [v7131
     (:volume-arns m7130 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7131 :com.palletops.awaze.client-builder/undef)
     (.
      bean7129
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7207] (clojure.core/str arg7207))
 v7131))))
   bean7129))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.SetLocalConsolePasswordRequest}
set-local-console-password-request
  [m7133]
  (clojure.core/let
   [bean7132
    (new
     com.amazonaws.services.storagegateway.model.SetLocalConsolePasswordRequest)]
   (clojure.core/let
    [v7134
     (:local-console-password
      m7133
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7134 :com.palletops.awaze.client-builder/undef)
     (. bean7132 setLocalConsolePassword (clojure.core/str v7134))))
   (clojure.core/let
    [v7134
     (:gateway-arn m7133 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7134 :com.palletops.awaze.client-builder/undef)
     (. bean7132 setGatewayARN (clojure.core/str v7134))))
   bean7132))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest}
create-snapshot-from-volume-recovery-point-request
  [m7136]
  (clojure.core/let
   [bean7135
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/let
    [v7137
     (:snapshot-description
      m7136
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7137 :com.palletops.awaze.client-builder/undef)
     (. bean7135 setSnapshotDescription (clojure.core/str v7137))))
   (clojure.core/let
    [v7137
     (:volume-arn m7136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7137 :com.palletops.awaze.client-builder/undef)
     (. bean7135 setVolumeARN (clojure.core/str v7137))))
   bean7135))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotRequest}
create-snapshot-request
  [m7139]
  (clojure.core/let
   [bean7138
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v7140
     (:snapshot-description
      m7139
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7140 :com.palletops.awaze.client-builder/undef)
     (. bean7138 setSnapshotDescription (clojure.core/str v7140))))
   (clojure.core/let
    [v7140
     (:volume-arn m7139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7140 :com.palletops.awaze.client-builder/undef)
     (. bean7138 setVolumeARN (clojure.core/str v7140))))
   bean7138))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest}
describe-working-storage-request
  [m7142]
  (clojure.core/let
   [bean7141
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/let
    [v7143
     (:gateway-arn m7142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7143 :com.palletops.awaze.client-builder/undef)
     (. bean7141 setGatewayARN (clojure.core/str v7143))))
   bean7141))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeInitiatorsRequest}
list-volume-initiators-request
  [m7145]
  (clojure.core/let
   [bean7144
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeInitiatorsRequest)]
   (clojure.core/let
    [v7146
     (:volume-arn m7145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7146 :com.palletops.awaze.client-builder/undef)
     (. bean7144 setVolumeARN (clojure.core/str v7146))))
   bean7144))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest}
shutdown-gateway-request
  [m7148]
  (clojure.core/let
   [bean7147
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/let
    [v7149
     (:gateway-arn m7148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7149 :com.palletops.awaze.client-builder/undef)
     (. bean7147 setGatewayARN (clojure.core/str v7149))))
   bean7147))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m7158]
   (clojure.core/let
    [credentials7159 (:credentials m7158) args7160 (:args m7158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7161
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7159)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7161
       updateChapCredentials
       (storagegateway/update-chap-credentials-request
        (clojure.core/nth args7160 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         secret-to-authenticate-target
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn
                         secret-to-authenticate-initiator]}]]),
    :doc "Generate map for updateChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         secret-to-authenticate-target
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn
                         secret-to-authenticate-initiator]}]]),
    :doc "Call updateChapCredentials"}
   [credentials7163 & args7164]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7165
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7163)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7165
      updateChapCredentials
      (storagegateway/update-chap-credentials-request
       (clojure.core/nth args7164 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m7166]
   (clojure.core/let
    [credentials7167 (:credentials m7166) args7168 (:args m7166)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7169
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7167)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7169
       addWorkingStorage
       (storagegateway/add-working-storage-request
        (clojure.core/nth args7168 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addWorkingStorage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-working-storage,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addWorkingStorage"}
   [credentials7171 & args7172]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7173
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7171)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7173
      addWorkingStorage
      (storagegateway/add-working-storage-request
       (clojure.core/nth args7172 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m7174]
   (clojure.core/let
    [credentials7175 (:credentials m7174) args7176 (:args m7174)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7177
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7175)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7177
       describeGatewayInformation
       (storagegateway/describe-gateway-information-request
        (clojure.core/nth args7176 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-gateway-information,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeGatewayInformation"}
   [credentials7179 & args7180]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7181
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7179)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7181
      describeGatewayInformation
      (storagegateway/describe-gateway-information-request
       (clojure.core/nth args7180 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape
   [m7182]
   (clojure.core/let
    [credentials7183 (:credentials m7182) args7184 (:args m7182)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7185
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7183)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7185
       deleteTape
       (storagegateway/delete-tape-request
        (clojure.core/nth args7184 0)))))))
  (clojure.core/defn
   delete-tape-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for deleteTape"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tape,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-tape
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call deleteTape"}
   [credentials7187 & args7188]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7189
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7187)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7189
      deleteTape
      (storagegateway/delete-tape-request
       (clojure.core/nth args7188 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m7190]
   (clojure.core/let
    [credentials7191 (:credentials m7190) args7192 (:args m7190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7193
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7193
       describeSnapshotSchedule
       (storagegateway/describe-snapshot-schedule-request
        (clojure.core/nth args7192 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotSchedule"}
   [credentials7195 & args7196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7197
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7197
      describeSnapshotSchedule
      (storagegateway/describe-snapshot-schedule-request
       (clojure.core/nth args7196 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tapes
   [m7198]
   (clojure.core/let
    [credentials7199 (:credentials m7198) args7200 (:args m7198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7201
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7201
       createTapes
       (storagegateway/create-tapes-request
        (clojure.core/nth args7200 0)))))))
  (clojure.core/defn
   create-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         num-tapes-to-create
                         tape-barcode-prefix
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createTapes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tapes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-tapes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         num-tapes-to-create
                         tape-barcode-prefix
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         client-token
                         clone-root]}]]),
    :doc "Call createTapes"}
   [credentials7203 & args7204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7205
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7203)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7205
      createTapes
      (storagegateway/create-tapes-request
       (clojure.core/nth args7204 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m7208]
   (clojure.core/let
    [credentials7209 (:credentials m7208) args7210 (:args m7208)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7211
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7209)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7211
       deleteChapCredentials
       (storagegateway/delete-chap-credentials-request
        (clojure.core/nth args7210 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Call deleteChapCredentials"}
   [credentials7213 & args7214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7215
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7213)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7215
      deleteChapCredentials
      (storagegateway/delete-chap-credentials-request
       (clojure.core/nth args7214 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-archival
   [m7216]
   (clojure.core/let
    [credentials7217 (:credentials m7216) args7218 (:args m7216)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7219
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7217)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7219
       cancelArchival
       (storagegateway/cancel-archival-request
        (clojure.core/nth args7218 0)))))))
  (clojure.core/defn
   cancel-archival-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for cancelArchival"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-archival,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   cancel-archival
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call cancelArchival"}
   [credentials7221 & args7222]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7223
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7221)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7223
      cancelArchival
      (storagegateway/cancel-archival-request
       (clojure.core/nth args7222 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-retrieval
   [m7224]
   (clojure.core/let
    [credentials7225 (:credentials m7224) args7226 (:args m7224)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7227
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7225)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7227
       cancelRetrieval
       (storagegateway/cancel-retrieval-request
        (clojure.core/nth args7226 0)))))))
  (clojure.core/defn
   cancel-retrieval-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for cancelRetrieval"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-retrieval,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   cancel-retrieval
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call cancelRetrieval"}
   [credentials7229 & args7230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7231
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7229)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7231
      cancelRetrieval
      (storagegateway/cancel-retrieval-request
       (clojure.core/nth args7230 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m7232]
   (clojure.core/let
    [credentials7233 (:credentials m7232) args7234 (:args m7232)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7235
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7233)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7235
       deleteVolume
       (storagegateway/delete-volume-request
        (clojure.core/nth args7234 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials7237 & args7238]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7239
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7237)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7239
      deleteVolume
      (storagegateway/delete-volume-request
       (clojure.core/nth args7238 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m7240]
   (clojure.core/let
    [credentials7241 (:credentials m7240) args7242 (:args m7240)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7243
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7241)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7243
       describeStorediSCSIVolumes
       (storagegateway/describe-storedi-scsivolumes-request
        (clojure.core/nth args7242 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStorediSCSIVolumes"}
   [credentials7245 & args7246]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7247
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7245)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7247
      describeStorediSCSIVolumes
      (storagegateway/describe-storedi-scsivolumes-request
       (clojure.core/nth args7246 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-tags-to-resource
   [m7248]
   (clojure.core/let
    [credentials7249 (:credentials m7248) args7250 (:args m7248)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7251
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7249)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7251
       addTagsToResource
       (storagegateway/add-tags-to-resource-request
        (clojure.core/nth args7250 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials7253 & args7254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7255
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7253)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7255
      addTagsToResource
      (storagegateway/add-tags-to-resource-request
       (clojure.core/nth args7254 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m7256]
   (clojure.core/let
    [credentials7257 (:credentials m7256) args7258 (:args m7256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7259
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7257)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7259
       createCachediSCSIVolume
       (storagegateway/create-cachedi-scsivolume-request
        (clojure.core/nth args7258 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         volume-size-in-bytes
                         clone-source
                         gateway-arn
                         client-token
                         clone-root
                         target-name]}]]),
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cachedi-scsivolume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         volume-size-in-bytes
                         clone-source
                         gateway-arn
                         client-token
                         clone-root
                         target-name]}]]),
    :doc "Call createCachediSCSIVolume"}
   [credentials7261 & args7262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7263
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7261)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7263
      createCachediSCSIVolume
      (storagegateway/create-cachedi-scsivolume-request
       (clojure.core/nth args7262 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-archive
   [m7264]
   (clojure.core/let
    [credentials7265 (:credentials m7264) args7266 (:args m7264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7267
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7265)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7267
       retrieveTapeArchive
       (storagegateway/retrieve-tape-archive-request
        (clojure.core/nth args7266 0)))))))
  (clojure.core/defn
   retrieve-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for retrieveTapeArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-tape-archive,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   retrieve-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call retrieveTapeArchive"}
   [credentials7269 & args7270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7271
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7269)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7271
      retrieveTapeArchive
      (storagegateway/retrieve-tape-archive-request
       (clojure.core/nth args7270 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m7272]
   (clojure.core/let
    [credentials7273 (:credentials m7272) args7274 (:args m7272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7275
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7273)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7275
       addUploadBuffer
       (storagegateway/add-upload-buffer-request
        (clojure.core/nth args7274 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addUploadBuffer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-upload-buffer,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addUploadBuffer"}
   [credentials7277 & args7278]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7279
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7277)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7279
      addUploadBuffer
      (storagegateway/add-upload-buffer-request
       (clojure.core/nth args7278 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m7280]
   (clojure.core/let
    [credentials7281 (:credentials m7280) args7282 (:args m7280)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7283
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7281)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7283
       listVolumes
       (storagegateway/list-volumes-request
        (clojure.core/nth args7282 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listVolumes"}
   [credentials7285 & args7286]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7287
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7285)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7287
      listVolumes
      (storagegateway/list-volumes-request
       (clojure.core/nth args7286 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-archives
   [m7288]
   (clojure.core/let
    [credentials7289 (:credentials m7288) args7290 (:args m7288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7291
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7289)]
     (clojure.core/case
      (clojure.core/count args7290)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7291
        describeTapeArchives
        (storagegateway/describe-tape-archives-request
         (clojure.core/nth args7290 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7291
        describeTapeArchives))))))
  (clojure.core/defn
   describe-tape-archives-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeTapeArchives, describeTapeArchives"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tape-archives,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tape-archives,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tape-archives
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeTapeArchives, describeTapeArchives"}
   [credentials7293 & args7294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7295
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7293)]
    (clojure.core/case
     (clojure.core/count args7294)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7295
       describeTapeArchives
       (storagegateway/describe-tape-archives-request
        (clojure.core/nth args7294 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7295
       describeTapeArchives))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m7296]
   (clojure.core/let
    [credentials7297 (:credentials m7296) args7298 (:args m7296)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7299
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7297)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7299
       describeUploadBuffer
       (storagegateway/describe-upload-buffer-request
        (clojure.core/nth args7298 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-upload-buffer,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeUploadBuffer"}
   [credentials7301 & args7302]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7303
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7301)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7303
      describeUploadBuffer
      (storagegateway/describe-upload-buffer-request
       (clojure.core/nth args7302 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m7304]
   (clojure.core/let
    [credentials7305 (:credentials m7304) args7306 (:args m7304)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7307
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7305)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7307
       listLocalDisks
       (storagegateway/list-local-disks-request
        (clojure.core/nth args7306 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listLocalDisks"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-local-disks,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-local-disks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listLocalDisks"}
   [credentials7309 & args7310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7311
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7311
      listLocalDisks
      (storagegateway/list-local-disks-request
       (clojure.core/nth args7310 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-vtldevice-type
   [m7312]
   (clojure.core/let
    [credentials7313 (:credentials m7312) args7314 (:args m7312)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7315
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7313)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7315
       updateVTLDeviceType
       (storagegateway/update-vtldevice-type-request
        (clojure.core/nth args7314 0)))))))
  (clojure.core/defn
   update-vtldevice-type-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vtldevice-arn
                         custom-query-parameters
                         device-type
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateVTLDeviceType"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-vtldevice-type,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-vtldevice-type
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vtldevice-arn
                         custom-query-parameters
                         device-type
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateVTLDeviceType"}
   [credentials7317 & args7318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7319
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7317)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7319
      updateVTLDeviceType
      (storagegateway/update-vtldevice-type-request
       (clojure.core/nth args7318 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-recovery-points
   [m7320]
   (clojure.core/let
    [credentials7321 (:credentials m7320) args7322 (:args m7320)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7323
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7321)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7323
       describeTapeRecoveryPoints
       (storagegateway/describe-tape-recovery-points-request
        (clojure.core/nth args7322 0)))))))
  (clojure.core/defn
   describe-tape-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeTapeRecoveryPoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tape-recovery-points,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tape-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeTapeRecoveryPoints"}
   [credentials7325 & args7326]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7327
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7325)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7327
      describeTapeRecoveryPoints
      (storagegateway/describe-tape-recovery-points-request
       (clojure.core/nth args7326 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape-archive
   [m7328]
   (clojure.core/let
    [credentials7329 (:credentials m7328) args7330 (:args m7328)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7331
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7329)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7331
       deleteTapeArchive
       (storagegateway/delete-tape-archive-request
        (clojure.core/nth args7330 0)))))))
  (clojure.core/defn
   delete-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTapeArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tape-archive,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTapeArchive"}
   [credentials7333 & args7334]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7335
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7333)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7335
      deleteTapeArchive
      (storagegateway/delete-tape-archive-request
       (clojure.core/nth args7334 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m7336]
   (clojure.core/let
    [credentials7337 (:credentials m7336) args7338 (:args m7336)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7339
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7337)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7339
       deleteBandwidthRateLimit
       (storagegateway/delete-bandwidth-rate-limit-request
        (clojure.core/nth args7338 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         bandwidth-type
                         clone-root]}]]),
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         bandwidth-type
                         clone-root]}]]),
    :doc "Call deleteBandwidthRateLimit"}
   [credentials7341 & args7342]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7343
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7341)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7343
      deleteBandwidthRateLimit
      (storagegateway/delete-bandwidth-rate-limit-request
       (clojure.core/nth args7342 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :disable-gateway
   [m7344]
   (clojure.core/let
    [credentials7345 (:credentials m7344) args7346 (:args m7344)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7347
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7345)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7347
       disableGateway
       (storagegateway/disable-gateway-request
        (clojure.core/nth args7346 0)))))))
  (clojure.core/defn
   disable-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for disableGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   disable-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call disableGateway"}
   [credentials7349 & args7350]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7351
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7349)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7351
      disableGateway
      (storagegateway/disable-gateway-request
       (clojure.core/nth args7350 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m7352]
   (clojure.core/let
    [credentials7353 (:credentials m7352) args7354 (:args m7352)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7355
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7353)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7355
       deleteGateway
       (storagegateway/delete-gateway-request
        (clojure.core/nth args7354 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for deleteGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call deleteGateway"}
   [credentials7357 & args7358]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7359
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7357)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7359
      deleteGateway
      (storagegateway/delete-gateway-request
       (clojure.core/nth args7358 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m7360]
   (clojure.core/let
    [credentials7361 (:credentials m7360) args7362 (:args m7360)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7363
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7361)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7363
       activateGateway
       (storagegateway/activate-gateway-request
        (clojure.core/nth args7362 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tape-drive-type
                         gateway-name
                         sdk-request-timeout
                         gateway-type
                         custom-query-parameters
                         activation-key
                         medium-changer-type
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-region
                         gateway-timezone
                         clone-root]}]]),
    :doc "Generate map for activateGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :activate-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   activate-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tape-drive-type
                         gateway-name
                         sdk-request-timeout
                         gateway-type
                         custom-query-parameters
                         activation-key
                         medium-changer-type
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-region
                         gateway-timezone
                         clone-root]}]]),
    :doc "Call activateGateway"}
   [credentials7365 & args7366]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7367
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7365)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7367
      activateGateway
      (storagegateway/activate-gateway-request
       (clojure.core/nth args7366 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m7368]
   (clojure.core/let
    [credentials7369 (:credentials m7368) args7370 (:args m7368)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7371
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7369)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7371
       describeMaintenanceStartTime
       (storagegateway/describe-maintenance-start-time-request
        (clojure.core/nth args7370 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-maintenance-start-time,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeMaintenanceStartTime"}
   [credentials7373 & args7374]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7375
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7373)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7375
      describeMaintenanceStartTime
      (storagegateway/describe-maintenance-start-time-request
       (clojure.core/nth args7374 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m7376]
   (clojure.core/let
    [credentials7377 (:credentials m7376) args7378 (:args m7376)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7379
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7377)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7379
       describeBandwidthRateLimit
       (storagegateway/describe-bandwidth-rate-limit-request
        (clojure.core/nth args7378 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeBandwidthRateLimit"}
   [credentials7381 & args7382]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7383
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7381)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7383
      describeBandwidthRateLimit
      (storagegateway/describe-bandwidth-rate-limit-request
       (clojure.core/nth args7382 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tapes
   [m7384]
   (clojure.core/let
    [credentials7385 (:credentials m7384) args7386 (:args m7384)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7387
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7385)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7387
       describeTapes
       (storagegateway/describe-tapes-request
        (clojure.core/nth args7386 0)))))))
  (clojure.core/defn
   describe-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeTapes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tapes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tapes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeTapes"}
   [credentials7389 & args7390]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7391
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7389)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7391
      describeTapes
      (storagegateway/describe-tapes-request
       (clojure.core/nth args7390 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m7392]
   (clojure.core/let
    [credentials7393 (:credentials m7392) args7394 (:args m7392)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7395
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7393)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7395
       startGateway
       (storagegateway/start-gateway-request
        (clojure.core/nth args7394 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for startGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :start-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   start-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call startGateway"}
   [credentials7397 & args7398]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7399
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7397)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7399
      startGateway
      (storagegateway/start-gateway-request
       (clojure.core/nth args7398 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m7400]
   (clojure.core/let
    [credentials7401 (:credentials m7400) args7402 (:args m7400)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7403
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7401)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7403
       updateSnapshotSchedule
       (storagegateway/update-snapshot-schedule-request
        (clojure.core/nth args7402 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-at
                         volume-arn
                         custom-query-parameters
                         recurrence-in-hours
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-at
                         volume-arn
                         custom-query-parameters
                         recurrence-in-hours
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSnapshotSchedule"}
   [credentials7405 & args7406]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7407
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7405)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7407
      updateSnapshotSchedule
      (storagegateway/update-snapshot-schedule-request
       (clojure.core/nth args7406 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m7408]
   (clojure.core/let
    [credentials7409 (:credentials m7408) args7410 (:args m7408)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7411
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7409)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7411
       updateBandwidthRateLimit
       (storagegateway/update-bandwidth-rate-limit-request
        (clojure.core/nth args7410 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         average-download-rate-limit-in-bits-per-sec
                         sdk-request-timeout
                         custom-query-parameters
                         average-upload-rate-limit-in-bits-per-sec
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         average-download-rate-limit-in-bits-per-sec
                         sdk-request-timeout
                         custom-query-parameters
                         average-upload-rate-limit-in-bits-per-sec
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call updateBandwidthRateLimit"}
   [credentials7413 & args7414]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7415
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7413)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7415
      updateBandwidthRateLimit
      (storagegateway/update-bandwidth-rate-limit-request
       (clojure.core/nth args7414 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m7416]
   (clojure.core/let
    [credentials7417 (:credentials m7416) args7418 (:args m7416)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7419
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7417)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7419
       updateGatewaySoftwareNow
       (storagegateway/update-gateway-software-now-request
        (clojure.core/nth args7418 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-gateway-software-now,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call updateGatewaySoftwareNow"}
   [credentials7421 & args7422]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7423
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7421)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7423
      updateGatewaySoftwareNow
      (storagegateway/update-gateway-software-now-request
       (clojure.core/nth args7422 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m7424]
   (clojure.core/let
    [credentials7425 (:credentials m7424) args7426 (:args m7424)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7427
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7425)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7427
       createStorediSCSIVolume
       (storagegateway/create-storedi-scsivolume-request
        (clojure.core/nth args7426 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         preserve-existing-data
                         general-progress-listener
                         disk-id
                         clone-source
                         gateway-arn
                         clone-root
                         target-name]}]]),
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-storedi-scsivolume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         preserve-existing-data
                         general-progress-listener
                         disk-id
                         clone-source
                         gateway-arn
                         clone-root
                         target-name]}]]),
    :doc "Call createStorediSCSIVolume"}
   [credentials7429 & args7430]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7431
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7429)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7431
      createStorediSCSIVolume
      (storagegateway/create-storedi-scsivolume-request
       (clojure.core/nth args7430 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m7432]
   (clojure.core/let
    [credentials7433 (:credentials m7432) args7434 (:args m7432)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7435
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7433)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7435
       updateGatewayInformation
       (storagegateway/update-gateway-information-request
        (clojure.core/nth args7434 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         gateway-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         gateway-timezone
                         clone-root]}]]),
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-gateway-information,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         gateway-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         gateway-timezone
                         clone-root]}]]),
    :doc "Call updateGatewayInformation"}
   [credentials7437 & args7438]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7439
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7437)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7439
      updateGatewayInformation
      (storagegateway/update-gateway-information-request
       (clojure.core/nth args7438 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m7440]
   (clojure.core/let
    [credentials7441 (:credentials m7440) args7442 (:args m7440)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7443
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7441)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7443
       deleteSnapshotSchedule
       (storagegateway/delete-snapshot-schedule-request
        (clojure.core/nth args7442 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshotSchedule"}
   [credentials7445 & args7446]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7447
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7445)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7447
      deleteSnapshotSchedule
      (storagegateway/delete-snapshot-schedule-request
       (clojure.core/nth args7446 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m7448]
   (clojure.core/let
    [credentials7449 (:credentials m7448) args7450 (:args m7448)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7451
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7449)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7451
       describeCache
       (storagegateway/describe-cache-request
        (clojure.core/nth args7450 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeCache"}
   [credentials7453 & args7454]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7455
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7453)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7455
      describeCache
      (storagegateway/describe-cache-request
       (clojure.core/nth args7454 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m7456]
   (clojure.core/let
    [credentials7457 (:credentials m7456) args7458 (:args m7456)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7459
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7457)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7459
       describeChapCredentials
       (storagegateway/describe-chap-credentials-request
        (clojure.core/nth args7458 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Generate map for describeChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Call describeChapCredentials"}
   [credentials7461 & args7462]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7463
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7461)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7463
      describeChapCredentials
      (storagegateway/describe-chap-credentials-request
       (clojure.core/nth args7462 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m7464]
   (clojure.core/let
    [credentials7465 (:credentials m7464) args7466 (:args m7464)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7467
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7465)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7467
       listVolumeRecoveryPoints
       (storagegateway/list-volume-recovery-points-request
        (clojure.core/nth args7466 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volume-recovery-points,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listVolumeRecoveryPoints"}
   [credentials7469 & args7470]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7471
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7469)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7471
      listVolumeRecoveryPoints
      (storagegateway/list-volume-recovery-points-request
       (clojure.core/nth args7470 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :remove-tags-from-resource
   [m7472]
   (clojure.core/let
    [credentials7473 (:credentials m7472) args7474 (:args m7472)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7475
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7473)]
     (clojure.core/case
      (clojure.core/count args7474)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7475
        removeTagsFromResource))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7475
        removeTagsFromResource
        (storagegateway/remove-tags-from-resource-request
         (clojure.core/nth args7474 0))))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromResource, removeTagsFromResource"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromResource, removeTagsFromResource"}
   [credentials7477 & args7478]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7479
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7477)]
    (clojure.core/case
     (clojure.core/count args7478)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7479
       removeTagsFromResource))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7479
       removeTagsFromResource
       (storagegateway/remove-tags-from-resource-request
        (clojure.core/nth args7478 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tape-with-barcode
   [m7480]
   (clojure.core/let
    [credentials7481 (:credentials m7480) args7482 (:args m7480)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7483
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7481)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7483
       createTapeWithBarcode
       (storagegateway/create-tape-with-barcode-request
        (clojure.core/nth args7482 0)))))))
  (clojure.core/defn
   create-tape-with-barcode-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tape-barcode
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for createTapeWithBarcode"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tape-with-barcode,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-tape-with-barcode
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tape-barcode
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         clone-root]}]]),
    :doc "Call createTapeWithBarcode"}
   [credentials7485 & args7486]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7487
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7485)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7487
      createTapeWithBarcode
      (storagegateway/create-tape-with-barcode-request
       (clojure.core/nth args7486 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m7488]
   (clojure.core/let
    [credentials7489 (:credentials m7488) args7490 (:args m7488)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7491
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7489)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7491
       addCache
       (storagegateway/add-cache-request
        (clojure.core/nth args7490 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addCache"}
   [credentials7493 & args7494]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7495
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7493)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7495
      addCache
      (storagegateway/add-cache-request (clojure.core/nth args7494 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m7496]
   (clojure.core/let
    [credentials7497 (:credentials m7496) args7498 (:args m7496)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7499
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7497)]
     (clojure.core/case
      (clojure.core/count args7498)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7499
        listGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7499
        listGateways
        (storagegateway/list-gateways-request
         (clojure.core/nth args7498 0))))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-gateways,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-gateways,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGateways, listGateways"}
   [credentials7501 & args7502]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7503
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7501)]
    (clojure.core/case
     (clojure.core/count args7502)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7503
       listGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7503
       listGateways
       (storagegateway/list-gateways-request
        (clojure.core/nth args7502 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-tags-for-resource
   [m7504]
   (clojure.core/let
    [credentials7505 (:credentials m7504) args7506 (:args m7504)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7507
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7505)]
     (clojure.core/case
      (clojure.core/count args7506)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7507
        listTagsForResource))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7507
        listTagsForResource
        (storagegateway/list-tags-for-resource-request
         (clojure.core/nth args7506 0))))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource, listTagsForResource"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource, listTagsForResource"}
   [credentials7509 & args7510]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7511
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7509)]
    (clojure.core/case
     (clojure.core/count args7510)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7511
       listTagsForResource))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7511
       listTagsForResource
       (storagegateway/list-tags-for-resource-request
        (clojure.core/nth args7510 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-recovery-point
   [m7512]
   (clojure.core/let
    [credentials7513 (:credentials m7512) args7514 (:args m7512)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7515
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7513)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7515
       retrieveTapeRecoveryPoint
       (storagegateway/retrieve-tape-recovery-point-request
        (clojure.core/nth args7514 0)))))))
  (clojure.core/defn
   retrieve-tape-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for retrieveTapeRecoveryPoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-tape-recovery-point,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   retrieve-tape-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call retrieveTapeRecoveryPoint"}
   [credentials7517 & args7518]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7519
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7517)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7519
      retrieveTapeRecoveryPoint
      (storagegateway/retrieve-tape-recovery-point-request
       (clojure.core/nth args7518 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m7520]
   (clojure.core/let
    [credentials7521 (:credentials m7520) args7522 (:args m7520)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7523
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7521)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7523
       updateMaintenanceStartTime
       (storagegateway/update-maintenance-start-time-request
        (clojure.core/nth args7522 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         day-of-week
                         hour-of-day
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root
                         minute-of-hour]}]]),
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-maintenance-start-time,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         day-of-week
                         hour-of-day
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root
                         minute-of-hour]}]]),
    :doc "Call updateMaintenanceStartTime"}
   [credentials7525 & args7526]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7527
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7525)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7527
      updateMaintenanceStartTime
      (storagegateway/update-maintenance-start-time-request
       (clojure.core/nth args7526 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :reset-cache
   [m7528]
   (clojure.core/let
    [credentials7529 (:credentials m7528) args7530 (:args m7528)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7531
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7529)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7531
       resetCache
       (storagegateway/reset-cache-request
        (clojure.core/nth args7530 0)))))))
  (clojure.core/defn
   reset-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for resetCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   reset-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call resetCache"}
   [credentials7533 & args7534]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7535
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7533)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7535
      resetCache
      (storagegateway/reset-cache-request
       (clojure.core/nth args7534 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-vtldevices
   [m7536]
   (clojure.core/let
    [credentials7537 (:credentials m7536) args7538 (:args m7536)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7539
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7537)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7539
       describeVTLDevices
       (storagegateway/describe-vtldevices-request
        (clojure.core/nth args7538 0)))))))
  (clojure.core/defn
   describe-vtldevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         vtldevice-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeVTLDevices"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vtldevices,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-vtldevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         vtldevice-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeVTLDevices"}
   [credentials7541 & args7542]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7543
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7541)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7543
      describeVTLDevices
      (storagegateway/describe-vtldevices-request
       (clojure.core/nth args7542 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m7544]
   (clojure.core/let
    [credentials7545 (:credentials m7544) args7546 (:args m7544)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7547
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7545)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7547
       describeCachediSCSIVolumes
       (storagegateway/describe-cachedi-scsivolumes-request
        (clojure.core/nth args7546 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCachediSCSIVolumes"}
   [credentials7549 & args7550]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7551
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7549)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7551
      describeCachediSCSIVolumes
      (storagegateway/describe-cachedi-scsivolumes-request
       (clojure.core/nth args7550 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :set-local-console-password
   [m7552]
   (clojure.core/let
    [credentials7553 (:credentials m7552) args7554 (:args m7552)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7555
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7553)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7555
       setLocalConsolePassword
       (storagegateway/set-local-console-password-request
        (clojure.core/nth args7554 0)))))))
  (clojure.core/defn
   set-local-console-password-map
   {:arglists (quote
               [[credentials
                 {:keys [local-console-password
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for setLocalConsolePassword"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-local-console-password,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   set-local-console-password
   {:arglists (quote
               [[credentials
                 {:keys [local-console-password
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call setLocalConsolePassword"}
   [credentials7557 & args7558]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7559
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7557)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7559
      setLocalConsolePassword
      (storagegateway/set-local-console-password-request
       (clojure.core/nth args7558 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m7560]
   (clojure.core/let
    [credentials7561 (:credentials m7560) args7562 (:args m7560)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7563
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7561)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7563
       createSnapshotFromVolumeRecoveryPoint
       (storagegateway/create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args7562 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials7565 & args7566]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7567
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7565)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7567
      createSnapshotFromVolumeRecoveryPoint
      (storagegateway/create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args7566 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m7568]
   (clojure.core/let
    [credentials7569 (:credentials m7568) args7570 (:args m7568)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7571
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7569)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7571
       createSnapshot
       (storagegateway/create-snapshot-request
        (clojure.core/nth args7570 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials7573 & args7574]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7575
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7573)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7575
      createSnapshot
      (storagegateway/create-snapshot-request
       (clojure.core/nth args7574 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m7576]
   (clojure.core/let
    [credentials7577 (:credentials m7576) args7578 (:args m7576)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7579
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7577)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7579
       describeWorkingStorage
       (storagegateway/describe-working-storage-request
        (clojure.core/nth args7578 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-working-storage,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeWorkingStorage"}
   [credentials7581 & args7582]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7583
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7581)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7583
      describeWorkingStorage
      (storagegateway/describe-working-storage-request
       (clojure.core/nth args7582 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-initiators
   [m7584]
   (clojure.core/let
    [credentials7585 (:credentials m7584) args7586 (:args m7584)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7587
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7585)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7587
       listVolumeInitiators
       (storagegateway/list-volume-initiators-request
        (clojure.core/nth args7586 0)))))))
  (clojure.core/defn
   list-volume-initiators-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVolumeInitiators"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volume-initiators,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volume-initiators
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVolumeInitiators"}
   [credentials7589 & args7590]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7591
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7589)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7591
      listVolumeInitiators
      (storagegateway/list-volume-initiators-request
       (clojure.core/nth args7590 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m7592]
   (clojure.core/let
    [credentials7593 (:credentials m7592) args7594 (:args m7592)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7595
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7593)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7595
       shutdownGateway
       (storagegateway/shutdown-gateway-request
        (clojure.core/nth args7594 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for shutdownGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :shutdown-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call shutdownGateway"}
   [credentials7597 & args7598]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7599
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7597)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7599
      shutdownGateway
      (storagegateway/shutdown-gateway-request
       (clojure.core/nth args7598 0))))))))
