(ns
 com.palletops.awaze.sqs
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sqs :as sqs]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sqs
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.sqs.AmazonSQSClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.MessageAttributeValue}
message-attribute-value
  [m8486]
  (clojure.core/let
   [bean8485
    (new com.amazonaws.services.sqs.model.MessageAttributeValue)]
   (clojure.core/let
    [v8487
     (:string-list-values
      m8486
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8487 :com.palletops.awaze.client-builder/undef)
     (.
      bean8485
      setStringListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8548] (clojure.core/str arg8548))
 v8487))))
   (clojure.core/let
    [v8487
     (:binary-list-values
      m8486
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8487 :com.palletops.awaze.client-builder/undef)
     (.
      bean8485
      setBinaryListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8549] (clojure.core/identity arg8549))
 v8487))))
   (clojure.core/let
    [v8487
     (:data-type m8486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8487 :com.palletops.awaze.client-builder/undef)
     (. bean8485 setDataType (clojure.core/str v8487))))
   (clojure.core/let
    [v8487
     (:string-value m8486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8487 :com.palletops.awaze.client-builder/undef)
     (. bean8485 setStringValue (clojure.core/str v8487))))
   (clojure.core/let
    [v8487
     (:binary-value m8486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8487 :com.palletops.awaze.client-builder/undef)
     (. bean8485 setBinaryValue (clojure.core/identity v8487))))
   bean8485))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry}
change-message-visibility-batch-request-entry
  [m8489]
  (clojure.core/let
   [bean8488
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry)]
   (clojure.core/let
    [v8490
     (:receipt-handle m8489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8490 :com.palletops.awaze.client-builder/undef)
     (. bean8488 setReceiptHandle (clojure.core/str v8490))))
   (clojure.core/let
    [v8490
     (:visibility-timeout
      m8489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8490 :com.palletops.awaze.client-builder/undef)
     (. bean8488 setVisibilityTimeout (clojure.core/int v8490))))
   (clojure.core/let
    [v8490 (:id m8489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8490 :com.palletops.awaze.client-builder/undef)
     (. bean8488 setId (clojure.core/str v8490))))
   bean8488))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry}
delete-message-batch-request-entry
  [m8492]
  (clojure.core/let
   [bean8491
    (new
     com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry)]
   (clojure.core/let
    [v8493
     (:receipt-handle m8492 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8493 :com.palletops.awaze.client-builder/undef)
     (. bean8491 setReceiptHandle (clojure.core/str v8493))))
   (clojure.core/let
    [v8493 (:id m8492 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8493 :com.palletops.awaze.client-builder/undef)
     (. bean8491 setId (clojure.core/str v8493))))
   bean8491))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry}
send-message-batch-request-entry
  [m8495]
  (clojure.core/let
   [bean8494
    (new
     com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry)]
   (clojure.core/let
    [v8496
     (:message-body m8495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (. bean8494 setMessageBody (clojure.core/str v8496))))
   (clojure.core/let
    [v8496
     (:delay-seconds m8495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (. bean8494 setDelaySeconds (clojure.core/int v8496))))
   (clojure.core/let
    [v8496
     (:message-attributes
      m8495
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (.
      bean8494
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8550] (clojure.core/str arg8550))
  (clojure.core/keys v8496))
 (clojure.core/map
  (clojure.core/fn [arg8550] (sqs/message-attribute-value arg8550))
  (clojure.core/vals v8496))))))
   (clojure.core/let
    [v8496 (:id m8495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (. bean8494 setId (clojure.core/str v8496))))
   bean8494))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
get-queue-url-request
  [m8498]
  (clojure.core/let
   [bean8497
    (new com.amazonaws.services.sqs.model.GetQueueUrlRequest)]
   (clojure.core/let
    [v8499
     (:queue-name m8498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8499 :com.palletops.awaze.client-builder/undef)
     (. bean8497 setQueueName (clojure.core/str v8499))))
   (clojure.core/let
    [v8499
     (:queue-owner-awsaccount-id
      m8498
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8499 :com.palletops.awaze.client-builder/undef)
     (. bean8497 setQueueOwnerAWSAccountId (clojure.core/str v8499))))
   bean8497))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
create-queue-request
  [m8501]
  (clojure.core/let
   [bean8500
    (new com.amazonaws.services.sqs.model.CreateQueueRequest)]
   (clojure.core/let
    [v8502
     (:attributes m8501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (.
      bean8500
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8551] (clojure.core/str arg8551))
  (clojure.core/keys v8502))
 (clojure.core/map
  (clojure.core/fn [arg8551] (clojure.core/str arg8551))
  (clojure.core/vals v8502))))))
   (clojure.core/let
    [v8502
     (:queue-name m8501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (. bean8500 setQueueName (clojure.core/str v8502))))
   bean8500))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest}
list-dead-letter-source-queues-request
  [m8504]
  (clojure.core/let
   [bean8503
    (new
     com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest)]
   (clojure.core/let
    [v8505
     (:queue-url m8504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8505 :com.palletops.awaze.client-builder/undef)
     (. bean8503 setQueueUrl (clojure.core/str v8505))))
   bean8503))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.RemovePermissionRequest}
remove-permission-request
  [m8507]
  (clojure.core/let
   [bean8506
    (new com.amazonaws.services.sqs.model.RemovePermissionRequest)]
   (clojure.core/let
    [v8508
     (:queue-url m8507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8508 :com.palletops.awaze.client-builder/undef)
     (. bean8506 setQueueUrl (clojure.core/str v8508))))
   (clojure.core/let
    [v8508 (:label m8507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8508 :com.palletops.awaze.client-builder/undef)
     (. bean8506 setLabel (clojure.core/str v8508))))
   bean8506))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SetQueueAttributesRequest}
set-queue-attributes-request
  [m8510]
  (clojure.core/let
   [bean8509
    (new com.amazonaws.services.sqs.model.SetQueueAttributesRequest)]
   (clojure.core/let
    [v8511
     (:attributes m8510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8511 :com.palletops.awaze.client-builder/undef)
     (.
      bean8509
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8552] (clojure.core/str arg8552))
  (clojure.core/keys v8511))
 (clojure.core/map
  (clojure.core/fn [arg8552] (clojure.core/str arg8552))
  (clojure.core/vals v8511))))))
   (clojure.core/let
    [v8511
     (:queue-url m8510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8511 :com.palletops.awaze.client-builder/undef)
     (. bean8509 setQueueUrl (clojure.core/str v8511))))
   bean8509))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
receive-message-request
  [m8513]
  (clojure.core/let
   [bean8512
    (new com.amazonaws.services.sqs.model.ReceiveMessageRequest)]
   (clojure.core/let
    [v8514
     (:queue-url m8513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (. bean8512 setQueueUrl (clojure.core/str v8514))))
   (clojure.core/let
    [v8514
     (:attribute-names
      m8513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (.
      bean8512
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8553] (clojure.core/str arg8553))
 v8514))))
   (clojure.core/let
    [v8514
     (:visibility-timeout
      m8513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (. bean8512 setVisibilityTimeout (clojure.core/int v8514))))
   (clojure.core/let
    [v8514
     (:message-attribute-names
      m8513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (.
      bean8512
      setMessageAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8554] (clojure.core/str arg8554))
 v8514))))
   (clojure.core/let
    [v8514
     (:max-number-of-messages
      m8513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (. bean8512 setMaxNumberOfMessages (clojure.core/int v8514))))
   (clojure.core/let
    [v8514
     (:wait-time-seconds
      m8513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (. bean8512 setWaitTimeSeconds (clojure.core/int v8514))))
   bean8512))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageRequest}
delete-message-request
  [m8516]
  (clojure.core/let
   [bean8515
    (new com.amazonaws.services.sqs.model.DeleteMessageRequest)]
   (clojure.core/let
    [v8517
     (:queue-url m8516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8517 :com.palletops.awaze.client-builder/undef)
     (. bean8515 setQueueUrl (clojure.core/str v8517))))
   (clojure.core/let
    [v8517
     (:receipt-handle m8516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8517 :com.palletops.awaze.client-builder/undef)
     (. bean8515 setReceiptHandle (clojure.core/str v8517))))
   bean8515))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageRequest}
send-message-request
  [m8519]
  (clojure.core/let
   [bean8518
    (new com.amazonaws.services.sqs.model.SendMessageRequest)]
   (clojure.core/let
    [v8520
     (:queue-url m8519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8520 :com.palletops.awaze.client-builder/undef)
     (. bean8518 setQueueUrl (clojure.core/str v8520))))
   (clojure.core/let
    [v8520
     (:message-body m8519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8520 :com.palletops.awaze.client-builder/undef)
     (. bean8518 setMessageBody (clojure.core/str v8520))))
   (clojure.core/let
    [v8520
     (:delay-seconds m8519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8520 :com.palletops.awaze.client-builder/undef)
     (. bean8518 setDelaySeconds (clojure.core/int v8520))))
   (clojure.core/let
    [v8520
     (:message-attributes
      m8519
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8520 :com.palletops.awaze.client-builder/undef)
     (.
      bean8518
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8555] (clojure.core/str arg8555))
  (clojure.core/keys v8520))
 (clojure.core/map
  (clojure.core/fn [arg8555] (sqs/message-attribute-value arg8555))
  (clojure.core/vals v8520))))))
   bean8518))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest}
change-message-visibility-batch-request
  [m8522]
  (clojure.core/let
   [bean8521
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest)]
   (clojure.core/let
    [v8523
     (:queue-url m8522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (. bean8521 setQueueUrl (clojure.core/str v8523))))
   (clojure.core/let
    [v8523 (:entries m8522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (.
      bean8521
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8556]
  (sqs/change-message-visibility-batch-request-entry arg8556))
 v8523))))
   bean8521))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest}
change-message-visibility-request
  [m8525]
  (clojure.core/let
   [bean8524
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest)]
   (clojure.core/let
    [v8526
     (:queue-url m8525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8526 :com.palletops.awaze.client-builder/undef)
     (. bean8524 setQueueUrl (clojure.core/str v8526))))
   (clojure.core/let
    [v8526
     (:receipt-handle m8525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8526 :com.palletops.awaze.client-builder/undef)
     (. bean8524 setReceiptHandle (clojure.core/str v8526))))
   (clojure.core/let
    [v8526
     (:visibility-timeout
      m8525
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8526 :com.palletops.awaze.client-builder/undef)
     (. bean8524 setVisibilityTimeout (clojure.core/int v8526))))
   bean8524))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
list-queues-request
  [m8528]
  (clojure.core/let
   [bean8527 (new com.amazonaws.services.sqs.model.ListQueuesRequest)]
   (clojure.core/let
    [v8529
     (:queue-name-prefix
      m8528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (. bean8527 setQueueNamePrefix (clojure.core/str v8529))))
   bean8527))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequest}
delete-message-batch-request
  [m8531]
  (clojure.core/let
   [bean8530
    (new com.amazonaws.services.sqs.model.DeleteMessageBatchRequest)]
   (clojure.core/let
    [v8532
     (:queue-url m8531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8532 :com.palletops.awaze.client-builder/undef)
     (. bean8530 setQueueUrl (clojure.core/str v8532))))
   (clojure.core/let
    [v8532 (:entries m8531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8532 :com.palletops.awaze.client-builder/undef)
     (.
      bean8530
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8629]
  (sqs/delete-message-batch-request-entry arg8629))
 v8532))))
   bean8530))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
delete-queue-request
  [m8534]
  (clojure.core/let
   [bean8533
    (new com.amazonaws.services.sqs.model.DeleteQueueRequest)]
   (clojure.core/let
    [v8535
     (:queue-url m8534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8535 :com.palletops.awaze.client-builder/undef)
     (. bean8533 setQueueUrl (clojure.core/str v8535))))
   bean8533))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.AddPermissionRequest}
add-permission-request
  [m8537]
  (clojure.core/let
   [bean8536
    (new com.amazonaws.services.sqs.model.AddPermissionRequest)]
   (clojure.core/let
    [v8538 (:actions m8537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8538 :com.palletops.awaze.client-builder/undef)
     (.
      bean8536
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8630] (clojure.core/str arg8630))
 v8538))))
   (clojure.core/let
    [v8538
     (:queue-url m8537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8538 :com.palletops.awaze.client-builder/undef)
     (. bean8536 setQueueUrl (clojure.core/str v8538))))
   (clojure.core/let
    [v8538 (:label m8537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8538 :com.palletops.awaze.client-builder/undef)
     (. bean8536 setLabel (clojure.core/str v8538))))
   (clojure.core/let
    [v8538
     (:awsaccount-ids m8537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8538 :com.palletops.awaze.client-builder/undef)
     (.
      bean8536
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8631] (clojure.core/str arg8631))
 v8538))))
   bean8536))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.PurgeQueueRequest}
purge-queue-request
  [m8540]
  (clojure.core/let
   [bean8539 (new com.amazonaws.services.sqs.model.PurgeQueueRequest)]
   (clojure.core/let
    [v8541
     (:queue-url m8540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8541 :com.palletops.awaze.client-builder/undef)
     (. bean8539 setQueueUrl (clojure.core/str v8541))))
   bean8539))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueAttributesRequest}
get-queue-attributes-request
  [m8543]
  (clojure.core/let
   [bean8542
    (new com.amazonaws.services.sqs.model.GetQueueAttributesRequest)]
   (clojure.core/let
    [v8544
     (:queue-url m8543 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8544 :com.palletops.awaze.client-builder/undef)
     (. bean8542 setQueueUrl (clojure.core/str v8544))))
   (clojure.core/let
    [v8544
     (:attribute-names
      m8543
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8544 :com.palletops.awaze.client-builder/undef)
     (.
      bean8542
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8632] (clojure.core/str arg8632))
 v8544))))
   bean8542))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequest}
send-message-batch-request
  [m8546]
  (clojure.core/let
   [bean8545
    (new com.amazonaws.services.sqs.model.SendMessageBatchRequest)]
   (clojure.core/let
    [v8547
     (:queue-url m8546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8547 :com.palletops.awaze.client-builder/undef)
     (. bean8545 setQueueUrl (clojure.core/str v8547))))
   (clojure.core/let
    [v8547 (:entries m8546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8547 :com.palletops.awaze.client-builder/undef)
     (.
      bean8545
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8633]
  (sqs/send-message-batch-request-entry arg8633))
 v8547))))
   bean8545))
 (clojure.core/defmulti
  sqs
  (clojure.core/fn sqs [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-url
   [m8557]
   (clojure.core/let
    [credentials8558 (:credentials m8557) args8559 (:args m8557)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8560
      (com.palletops.awaze.common/aws-client :sqs credentials8558)]
     (clojure.core/case
      (clojure.core/count args8559)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.GetQueueUrlRequest
           (clojure.core/nth args8559 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8560
           getQueueUrl
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8559 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8560
               getQueueUrl
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getQueueUrl")
                {:args args8559}))))))))))))))
  (clojure.core/defn
   get-queue-url-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getQueueUrl, getQueueUrl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-queue-url,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-url
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getQueueUrl, getQueueUrl"}
   [credentials8562 & args8563]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8564
     (com.palletops.awaze.common/aws-client :sqs credentials8562)]
    (clojure.core/case
     (clojure.core/count args8563)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.GetQueueUrlRequest
          (clojure.core/nth args8563 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8564
          getQueueUrl
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8563 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8564
              getQueueUrl
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getQueueUrl")
               {:args args8563}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :create-queue
   [m8565]
   (clojure.core/let
    [credentials8566 (:credentials m8565) args8567 (:args m8565)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8568
      (com.palletops.awaze.common/aws-client :sqs credentials8566)]
     (clojure.core/case
      (clojure.core/count args8567)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8567 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8568
           createQueue
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.CreateQueueRequest
               (clojure.core/nth args8567 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8568
               createQueue
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createQueue")
                {:args args8567}))))))))))))))
  (clojure.core/defn
   create-queue-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]]),
    :doc "Generate map for createQueue, createQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   create-queue
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]]),
    :doc "Call createQueue, createQueue"}
   [credentials8570 & args8571]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8572
     (com.palletops.awaze.common/aws-client :sqs credentials8570)]
    (clojure.core/case
     (clojure.core/count args8571)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8571 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8572
          createQueue
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.CreateQueueRequest
              (clojure.core/nth args8571 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8572
              createQueue
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createQueue")
               {:args args8571}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-dead-letter-source-queues
   [m8573]
   (clojure.core/let
    [credentials8574 (:credentials m8573) args8575 (:args m8573)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8576
      (com.palletops.awaze.common/aws-client :sqs credentials8574)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8576
       listDeadLetterSourceQueues
       (sqs/list-dead-letter-source-queues-request
        (clojure.core/nth args8575 0)))))))
  (clojure.core/defn
   list-dead-letter-source-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for listDeadLetterSourceQueues"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-dead-letter-source-queues,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-dead-letter-source-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call listDeadLetterSourceQueues"}
   [credentials8578 & args8579]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8580
     (com.palletops.awaze.common/aws-client :sqs credentials8578)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8580
      listDeadLetterSourceQueues
      (sqs/list-dead-letter-source-queues-request
       (clojure.core/nth args8579 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :remove-permission
   [m8581]
   (clojure.core/let
    [credentials8582 (:credentials m8581) args8583 (:args m8581)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8584
      (com.palletops.awaze.common/aws-client :sqs credentials8582)]
     (clojure.core/case
      (clojure.core/count args8583)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8584
        removePermission
        (clojure.core/str (clojure.core/nth args8583 0))
        (clojure.core/str (clojure.core/nth args8583 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8584
        removePermission
        (sqs/remove-permission-request (clojure.core/nth args8583 0))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call removePermission, removePermission"}
   [credentials8586 & args8587]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8588
     (com.palletops.awaze.common/aws-client :sqs credentials8586)]
    (clojure.core/case
     (clojure.core/count args8587)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8588
       removePermission
       (clojure.core/str (clojure.core/nth args8587 0))
       (clojure.core/str (clojure.core/nth args8587 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8588
       removePermission
       (sqs/remove-permission-request (clojure.core/nth args8587 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :set-queue-attributes
   [m8589]
   (clojure.core/let
    [credentials8590 (:credentials m8589) args8591 (:args m8589)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8592
      (com.palletops.awaze.common/aws-client :sqs credentials8590)]
     (clojure.core/case
      (clojure.core/count args8591)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8592
        setQueueAttributes
        (clojure.core/str (clojure.core/nth args8591 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8634] (clojure.core/str arg8634))
  (clojure.core/keys (clojure.core/nth args8591 1)))
 (clojure.core/map
  (clojure.core/fn [arg8634] (clojure.core/str arg8634))
  (clojure.core/vals (clojure.core/nth args8591 1))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8592
        setQueueAttributes
        (sqs/set-queue-attributes-request
         (clojure.core/nth args8591 0))))))))
  (clojure.core/defn
   set-queue-attributes-map
   {:arglists (quote
               [[credentials string-0 map-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for setQueueAttributes, setQueueAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   set-queue-attributes
   {:arglists (quote
               [[credentials string-0 map-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]]),
    :doc "Call setQueueAttributes, setQueueAttributes"}
   [credentials8594 & args8595]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8596
     (com.palletops.awaze.common/aws-client :sqs credentials8594)]
    (clojure.core/case
     (clojure.core/count args8595)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8596
       setQueueAttributes
       (clojure.core/str (clojure.core/nth args8595 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8635] (clojure.core/str arg8635))
  (clojure.core/keys (clojure.core/nth args8595 1)))
 (clojure.core/map
  (clojure.core/fn [arg8635] (clojure.core/str arg8635))
  (clojure.core/vals (clojure.core/nth args8595 1))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8596
       setQueueAttributes
       (sqs/set-queue-attributes-request
        (clojure.core/nth args8595 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :receive-message
   [m8597]
   (clojure.core/let
    [credentials8598 (:credentials m8597) args8599 (:args m8597)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8600
      (com.palletops.awaze.common/aws-client :sqs credentials8598)]
     (clojure.core/case
      (clojure.core/count args8599)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ReceiveMessageRequest
           (clojure.core/nth args8599 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8600
           receiveMessage
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8599 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8600
               receiveMessage
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "receiveMessage")
                {:args args8599}))))))))))))))
  (clojure.core/defn
   receive-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Generate map for receiveMessage, receiveMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :receive-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   receive-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Call receiveMessage, receiveMessage"}
   [credentials8602 & args8603]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8604
     (com.palletops.awaze.common/aws-client :sqs credentials8602)]
    (clojure.core/case
     (clojure.core/count args8603)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ReceiveMessageRequest
          (clojure.core/nth args8603 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8604
          receiveMessage
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8603 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8604
              receiveMessage
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "receiveMessage")
               {:args args8603}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message
   [m8605]
   (clojure.core/let
    [credentials8606 (:credentials m8605) args8607 (:args m8605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8608
      (com.palletops.awaze.common/aws-client :sqs credentials8606)]
     (clojure.core/case
      (clojure.core/count args8607)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8608
        deleteMessage
        (clojure.core/str (clojure.core/nth args8607 0))
        (clojure.core/str (clojure.core/nth args8607 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8608
        deleteMessage
        (sqs/delete-message-request (clojure.core/nth args8607 0))))))))
  (clojure.core/defn
   delete-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessage, deleteMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-message,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessage, deleteMessage"}
   [credentials8610 & args8611]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8612
     (com.palletops.awaze.common/aws-client :sqs credentials8610)]
    (clojure.core/case
     (clojure.core/count args8611)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8612
       deleteMessage
       (clojure.core/str (clojure.core/nth args8611 0))
       (clojure.core/str (clojure.core/nth args8611 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8612
       deleteMessage
       (sqs/delete-message-request (clojure.core/nth args8611 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message
   [m8613]
   (clojure.core/let
    [credentials8614 (:credentials m8613) args8615 (:args m8613)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8616
      (com.palletops.awaze.common/aws-client :sqs credentials8614)]
     (clojure.core/case
      (clojure.core/count args8615)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8616
        sendMessage
        (sqs/send-message-request (clojure.core/nth args8615 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8616
        sendMessage
        (clojure.core/str (clojure.core/nth args8615 0))
        (clojure.core/str (clojure.core/nth args8615 1))))))))
  (clojure.core/defn
   send-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for sendMessage, sendMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-message,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :send-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Call sendMessage, sendMessage"}
   [credentials8618 & args8619]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8620
     (com.palletops.awaze.common/aws-client :sqs credentials8618)]
    (clojure.core/case
     (clojure.core/count args8619)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8620
       sendMessage
       (sqs/send-message-request (clojure.core/nth args8619 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8620
       sendMessage
       (clojure.core/str (clojure.core/nth args8619 0))
       (clojure.core/str (clojure.core/nth args8619 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility-batch
   [m8621]
   (clojure.core/let
    [credentials8622 (:credentials m8621) args8623 (:args m8621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8624
      (com.palletops.awaze.common/aws-client :sqs credentials8622)]
     (clojure.core/case
      (clojure.core/count args8623)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8624
        changeMessageVisibilityBatch
        (clojure.core/str (clojure.core/nth args8623 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8700]
  (sqs/change-message-visibility-batch-request-entry arg8700))
 (clojure.core/nth args8623 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8624
        changeMessageVisibilityBatch
        (sqs/change-message-visibility-batch-request
         (clojure.core/nth args8623 0))))))))
  (clojure.core/defn
   change-message-visibility-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-message-visibility-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :change-message-visibility-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   [credentials8626 & args8627]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8628
     (com.palletops.awaze.common/aws-client :sqs credentials8626)]
    (clojure.core/case
     (clojure.core/count args8627)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8628
       changeMessageVisibilityBatch
       (clojure.core/str (clojure.core/nth args8627 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8701]
  (sqs/change-message-visibility-batch-request-entry arg8701))
 (clojure.core/nth args8627 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8628
       changeMessageVisibilityBatch
       (sqs/change-message-visibility-batch-request
        (clojure.core/nth args8627 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility
   [m8636]
   (clojure.core/let
    [credentials8637 (:credentials m8636) args8638 (:args m8636)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8639
      (com.palletops.awaze.common/aws-client :sqs credentials8637)]
     (clojure.core/case
      (clojure.core/count args8638)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8639
        changeMessageVisibility
        (sqs/change-message-visibility-request
         (clojure.core/nth args8638 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8639
        changeMessageVisibility
        (clojure.core/str (clojure.core/nth args8638 0))
        (clojure.core/str (clojure.core/nth args8638 1))
        (clojure.core/int (clojure.core/nth args8638 2))))))))
  (clojure.core/defn
   change-message-visibility-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Generate map for changeMessageVisibility, changeMessageVisibility"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-message-visibility,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :change-message-visibility,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Call changeMessageVisibility, changeMessageVisibility"}
   [credentials8641 & args8642]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8643
     (com.palletops.awaze.common/aws-client :sqs credentials8641)]
    (clojure.core/case
     (clojure.core/count args8642)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8643
       changeMessageVisibility
       (sqs/change-message-visibility-request
        (clojure.core/nth args8642 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8643
       changeMessageVisibility
       (clojure.core/str (clojure.core/nth args8642 0))
       (clojure.core/str (clojure.core/nth args8642 1))
       (clojure.core/int (clojure.core/nth args8642 2))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-queues
   [m8644]
   (clojure.core/let
    [credentials8645 (:credentials m8644) args8646 (:args m8644)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8647
      (com.palletops.awaze.common/aws-client :sqs credentials8645)]
     (clojure.core/case
      (clojure.core/count args8646)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ListQueuesRequest
           (clojure.core/nth args8646 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8647
           listQueues
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8646 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8647
               listQueues
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listQueues")
                {:args args8646}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8647
        listQueues))))))
  (clojure.core/defn
   list-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]
                [credentials string-0]]),
    :doc "Generate map for listQueues, listQueues, listQueues"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-queues,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-queues,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]
                [credentials string-0]]),
    :doc "Call listQueues, listQueues, listQueues"}
   [credentials8649 & args8650]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8651
     (com.palletops.awaze.common/aws-client :sqs credentials8649)]
    (clojure.core/case
     (clojure.core/count args8650)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ListQueuesRequest
          (clojure.core/nth args8650 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8651
          listQueues
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8650 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8651
              listQueues
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listQueues")
               {:args args8650}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8651
       listQueues))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message-batch
   [m8652]
   (clojure.core/let
    [credentials8653 (:credentials m8652) args8654 (:args m8652)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8655
      (com.palletops.awaze.common/aws-client :sqs credentials8653)]
     (clojure.core/case
      (clojure.core/count args8654)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8655
        deleteMessageBatch
        (clojure.core/str (clojure.core/nth args8654 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8702]
  (sqs/delete-message-batch-request-entry arg8702))
 (clojure.core/nth args8654 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8655
        deleteMessageBatch
        (sqs/delete-message-batch-request
         (clojure.core/nth args8654 0))))))))
  (clojure.core/defn
   delete-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessageBatch, deleteMessageBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessageBatch, deleteMessageBatch"}
   [credentials8657 & args8658]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8659
     (com.palletops.awaze.common/aws-client :sqs credentials8657)]
    (clojure.core/case
     (clojure.core/count args8658)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8659
       deleteMessageBatch
       (clojure.core/str (clojure.core/nth args8658 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8703]
  (sqs/delete-message-batch-request-entry arg8703))
 (clojure.core/nth args8658 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8659
       deleteMessageBatch
       (sqs/delete-message-batch-request
        (clojure.core/nth args8658 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-queue
   [m8660]
   (clojure.core/let
    [credentials8661 (:credentials m8660) args8662 (:args m8660)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8663
      (com.palletops.awaze.common/aws-client :sqs credentials8661)]
     (clojure.core/case
      (clojure.core/count args8662)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8662 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8663
           deleteQueue
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.DeleteQueueRequest
               (clojure.core/nth args8662 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8663
               deleteQueue
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteQueue")
                {:args args8662}))))))))))))))
  (clojure.core/defn
   delete-queue-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteQueue, deleteQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-queue
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteQueue, deleteQueue"}
   [credentials8665 & args8666]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8667
     (com.palletops.awaze.common/aws-client :sqs credentials8665)]
    (clojure.core/case
     (clojure.core/count args8666)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8666 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8667
          deleteQueue
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.DeleteQueueRequest
              (clojure.core/nth args8666 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8667
              deleteQueue
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteQueue")
               {:args args8666}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :add-permission
   [m8668]
   (clojure.core/let
    [credentials8669 (:credentials m8668) args8670 (:args m8668)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8671
      (com.palletops.awaze.common/aws-client :sqs credentials8669)]
     (clojure.core/case
      (clojure.core/count args8670)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8671
        addPermission
        (sqs/add-permission-request (clojure.core/nth args8670 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8671
        addPermission
        (clojure.core/str (clojure.core/nth args8670 0))
        (clojure.core/str (clojure.core/nth args8670 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8704] (clojure.core/str arg8704))
 (clojure.core/nth args8670 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8705] (clojure.core/str arg8705))
 (clojure.core/nth args8670 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials8673 & args8674]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8675
     (com.palletops.awaze.common/aws-client :sqs credentials8673)]
    (clojure.core/case
     (clojure.core/count args8674)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8675
       addPermission
       (sqs/add-permission-request (clojure.core/nth args8674 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8675
       addPermission
       (clojure.core/str (clojure.core/nth args8674 0))
       (clojure.core/str (clojure.core/nth args8674 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8706] (clojure.core/str arg8706))
 (clojure.core/nth args8674 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8707] (clojure.core/str arg8707))
 (clojure.core/nth args8674 3))))))))
 (do
  (clojure.core/defmethod
   sqs
   :purge-queue
   [m8676]
   (clojure.core/let
    [credentials8677 (:credentials m8676) args8678 (:args m8676)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8679
      (com.palletops.awaze.common/aws-client :sqs credentials8677)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8679
       purgeQueue
       (sqs/purge-queue-request (clojure.core/nth args8678 0)))))))
  (clojure.core/defn
   purge-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for purgeQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purge-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   purge-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call purgeQueue"}
   [credentials8681 & args8682]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8683
     (com.palletops.awaze.common/aws-client :sqs credentials8681)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8683
      purgeQueue
      (sqs/purge-queue-request (clojure.core/nth args8682 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-attributes
   [m8684]
   (clojure.core/let
    [credentials8685 (:credentials m8684) args8686 (:args m8684)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8687
      (com.palletops.awaze.common/aws-client :sqs credentials8685)]
     (clojure.core/case
      (clojure.core/count args8686)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8687
        getQueueAttributes
        (clojure.core/str (clojure.core/nth args8686 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8708] (clojure.core/str arg8708))
 (clojure.core/nth args8686 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8687
        getQueueAttributes
        (sqs/get-queue-attributes-request
         (clojure.core/nth args8686 0))))))))
  (clojure.core/defn
   get-queue-attributes-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for getQueueAttributes, getQueueAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-attributes
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call getQueueAttributes, getQueueAttributes"}
   [credentials8689 & args8690]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8691
     (com.palletops.awaze.common/aws-client :sqs credentials8689)]
    (clojure.core/case
     (clojure.core/count args8690)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8691
       getQueueAttributes
       (clojure.core/str (clojure.core/nth args8690 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8709] (clojure.core/str arg8709))
 (clojure.core/nth args8690 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8691
       getQueueAttributes
       (sqs/get-queue-attributes-request
        (clojure.core/nth args8690 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message-batch
   [m8692]
   (clojure.core/let
    [credentials8693 (:credentials m8692) args8694 (:args m8692)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8695
      (com.palletops.awaze.common/aws-client :sqs credentials8693)]
     (clojure.core/case
      (clojure.core/count args8694)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8695
        sendMessageBatch
        (sqs/send-message-batch-request (clojure.core/nth args8694 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8695
        sendMessageBatch
        (clojure.core/str (clojure.core/nth args8694 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8710]
  (sqs/send-message-batch-request-entry arg8710))
 (clojure.core/nth args8694 1))))))))
  (clojure.core/defn
   send-message-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for sendMessageBatch, sendMessageBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :send-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message-batch
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Call sendMessageBatch, sendMessageBatch"}
   [credentials8697 & args8698]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8699
     (com.palletops.awaze.common/aws-client :sqs credentials8697)]
    (clojure.core/case
     (clojure.core/count args8698)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8699
       sendMessageBatch
       (sqs/send-message-batch-request (clojure.core/nth args8698 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8699
       sendMessageBatch
       (clojure.core/str (clojure.core/nth args8698 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8711]
  (sqs/send-message-batch-request-entry arg8711))
 (clojure.core/nth args8698 1)))))))))
