(ns
 com.palletops.awaze.sns
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sns :as sns]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.MessageAttributeValue}
message-attribute-value
  [m6102]
  (clojure.core/let
   [bean6101
    (new com.amazonaws.services.sns.model.MessageAttributeValue)]
   (clojure.core/let
    [v6103
     (:data-type m6102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6103 :com.palletops.awaze.client-builder/undef)
     (. bean6101 setDataType (clojure.core/str v6103))))
   (clojure.core/let
    [v6103
     (:string-value m6102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6103 :com.palletops.awaze.client-builder/undef)
     (. bean6101 setStringValue (clojure.core/str v6103))))
   (clojure.core/let
    [v6103
     (:binary-value m6102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6103 :com.palletops.awaze.client-builder/undef)
     (. bean6101 setBinaryValue (clojure.core/identity v6103))))
   bean6101))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
list-topics-request
  [m6105]
  (clojure.core/let
   [bean6104 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/let
    [v6106
     (:next-token m6105 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6106 :com.palletops.awaze.client-builder/undef)
     (. bean6104 setNextToken (clojure.core/str v6106))))
   bean6104))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetTopicAttributesRequest}
set-topic-attributes-request
  [m6108]
  (clojure.core/let
   [bean6107
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/let
    [v6109
     (:topic-arn m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setTopicArn (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:attribute-name m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setAttributeName (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:attribute-value
      m6108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setAttributeValue (clojure.core/str v6109))))
   bean6107))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.RemovePermissionRequest}
remove-permission-request
  [m6111]
  (clojure.core/let
   [bean6110
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/let
    [v6112
     (:topic-arn m6111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6112 :com.palletops.awaze.client-builder/undef)
     (. bean6110 setTopicArn (clojure.core/str v6112))))
   (clojure.core/let
    [v6112 (:label m6111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6112 :com.palletops.awaze.client-builder/undef)
     (. bean6110 setLabel (clojure.core/str v6112))))
   bean6110))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
unsubscribe-request
  [m6114]
  (clojure.core/let
   [bean6113
    (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/let
    [v6115
     (:subscription-arn
      m6114
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6115 :com.palletops.awaze.client-builder/undef)
     (. bean6113 setSubscriptionArn (clojure.core/str v6115))))
   bean6113))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeletePlatformApplicationRequest}
delete-platform-application-request
  [m6117]
  (clojure.core/let
   [bean6116
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/let
    [v6118
     (:platform-application-arn
      m6117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6118 :com.palletops.awaze.client-builder/undef)
     (. bean6116 setPlatformApplicationArn (clojure.core/str v6118))))
   bean6116))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteEndpointRequest}
delete-endpoint-request
  [m6120]
  (clojure.core/let
   [bean6119
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/let
    [v6121
     (:endpoint-arn m6120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6121 :com.palletops.awaze.client-builder/undef)
     (. bean6119 setEndpointArn (clojure.core/str v6121))))
   bean6119))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
get-subscription-attributes-request
  [m6123]
  (clojure.core/let
   [bean6122
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v6124
     (:subscription-arn
      m6123
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setSubscriptionArn (clojure.core/str v6124))))
   bean6122))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformApplicationRequest}
create-platform-application-request
  [m6126]
  (clojure.core/let
   [bean6125
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/let
    [v6127
     (:attributes m6126 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6127 :com.palletops.awaze.client-builder/undef)
     (.
      bean6125
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6179] (clojure.core/str arg6179))
  (clojure.core/keys v6127))
 (clojure.core/map
  (clojure.core/fn [arg6179] (clojure.core/str arg6179))
  (clojure.core/vals v6127))))))
   (clojure.core/let
    [v6127
     (:platform m6126 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6127 :com.palletops.awaze.client-builder/undef)
     (. bean6125 setPlatform (clojure.core/str v6127))))
   (clojure.core/let
    [v6127 (:name m6126 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6127 :com.palletops.awaze.client-builder/undef)
     (. bean6125 setName (clojure.core/str v6127))))
   bean6125))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest}
set-platform-application-attributes-request
  [m6129]
  (clojure.core/let
   [bean6128
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v6130
     (:attributes m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (.
      bean6128
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6180] (clojure.core/str arg6180))
  (clojure.core/keys v6130))
 (clojure.core/map
  (clojure.core/fn [arg6180] (clojure.core/str arg6180))
  (clojure.core/vals v6130))))))
   (clojure.core/let
    [v6130
     (:platform-application-arn
      m6129
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setPlatformApplicationArn (clojure.core/str v6130))))
   bean6128))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ConfirmSubscriptionRequest}
confirm-subscription-request
  [m6132]
  (clojure.core/let
   [bean6131
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/let
    [v6133
     (:topic-arn m6132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6133 :com.palletops.awaze.client-builder/undef)
     (. bean6131 setTopicArn (clojure.core/str v6133))))
   (clojure.core/let
    [v6133 (:token m6132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6133 :com.palletops.awaze.client-builder/undef)
     (. bean6131 setToken (clojure.core/str v6133))))
   (clojure.core/let
    [v6133
     (:authenticate-on-unsubscribe
      m6132
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6133 :com.palletops.awaze.client-builder/undef)
     (.
      bean6131
      setAuthenticateOnUnsubscribe
      (clojure.core/str v6133))))
   bean6131))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformEndpointRequest}
create-platform-endpoint-request
  [m6135]
  (clojure.core/let
   [bean6134
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/let
    [v6136
     (:attributes m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (.
      bean6134
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6181] (clojure.core/str arg6181))
  (clojure.core/keys v6136))
 (clojure.core/map
  (clojure.core/fn [arg6181] (clojure.core/str arg6181))
  (clojure.core/vals v6136))))))
   (clojure.core/let
    [v6136
     (:platform-application-arn
      m6135
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setPlatformApplicationArn (clojure.core/str v6136))))
   (clojure.core/let
    [v6136
     (:custom-user-data
      m6135
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setCustomUserData (clojure.core/str v6136))))
   (clojure.core/let
    [v6136 (:token m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setToken (clojure.core/str v6136))))
   bean6134))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListPlatformApplicationsRequest}
list-platform-applications-request
  [m6138]
  (clojure.core/let
   [bean6137
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/let
    [v6139
     (:next-token m6138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6139 :com.palletops.awaze.client-builder/undef)
     (. bean6137 setNextToken (clojure.core/str v6139))))
   bean6137))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
create-topic-request
  [m6141]
  (clojure.core/let
   [bean6140
    (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/let
    [v6142 (:name m6141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6142 :com.palletops.awaze.client-builder/undef)
     (. bean6140 setName (clojure.core/str v6142))))
   bean6140))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest}
list-endpoints-by-platform-application-request
  [m6144]
  (clojure.core/let
   [bean6143
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/let
    [v6145
     (:next-token m6144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (. bean6143 setNextToken (clojure.core/str v6145))))
   (clojure.core/let
    [v6145
     (:platform-application-arn
      m6144
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (. bean6143 setPlatformApplicationArn (clojure.core/str v6145))))
   bean6143))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest}
get-platform-application-attributes-request
  [m6147]
  (clojure.core/let
   [bean6146
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v6148
     (:platform-application-arn
      m6147
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6148 :com.palletops.awaze.client-builder/undef)
     (. bean6146 setPlatformApplicationArn (clojure.core/str v6148))))
   bean6146))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest}
set-subscription-attributes-request
  [m6150]
  (clojure.core/let
   [bean6149
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v6151
     (:attribute-name m6150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (. bean6149 setAttributeName (clojure.core/str v6151))))
   (clojure.core/let
    [v6151
     (:attribute-value
      m6150
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (. bean6149 setAttributeValue (clojure.core/str v6151))))
   (clojure.core/let
    [v6151
     (:subscription-arn
      m6150
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (. bean6149 setSubscriptionArn (clojure.core/str v6151))))
   bean6149))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.AddPermissionRequest}
add-permission-request
  [m6153]
  (clojure.core/let
   [bean6152
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/let
    [v6154
     (:topic-arn m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setTopicArn (clojure.core/str v6154))))
   (clojure.core/let
    [v6154 (:label m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setLabel (clojure.core/str v6154))))
   (clojure.core/let
    [v6154
     (:awsaccount-ids m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (.
      bean6152
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6214] (clojure.core/str arg6214))
 v6154))))
   (clojure.core/let
    [v6154
     (:action-names m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (.
      bean6152
      setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6215] (clojure.core/str arg6215))
 v6154))))
   bean6152))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
list-subscriptions-request
  [m6156]
  (clojure.core/let
   [bean6155
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/let
    [v6157
     (:next-token m6156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6157 :com.palletops.awaze.client-builder/undef)
     (. bean6155 setNextToken (clojure.core/str v6157))))
   bean6155))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
get-topic-attributes-request
  [m6159]
  (clojure.core/let
   [bean6158
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/let
    [v6160
     (:topic-arn m6159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (. bean6158 setTopicArn (clojure.core/str v6160))))
   bean6158))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetEndpointAttributesRequest}
get-endpoint-attributes-request
  [m6162]
  (clojure.core/let
   [bean6161
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/let
    [v6163
     (:endpoint-arn m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (. bean6161 setEndpointArn (clojure.core/str v6163))))
   bean6161))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
delete-topic-request
  [m6165]
  (clojure.core/let
   [bean6164
    (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/let
    [v6166
     (:topic-arn m6165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6166 :com.palletops.awaze.client-builder/undef)
     (. bean6164 setTopicArn (clojure.core/str v6166))))
   bean6164))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SubscribeRequest}
subscribe-request
  [m6168]
  (clojure.core/let
   [bean6167 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/let
    [v6169
     (:topic-arn m6168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6169 :com.palletops.awaze.client-builder/undef)
     (. bean6167 setTopicArn (clojure.core/str v6169))))
   (clojure.core/let
    [v6169
     (:protocol m6168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6169 :com.palletops.awaze.client-builder/undef)
     (. bean6167 setProtocol (clojure.core/str v6169))))
   (clojure.core/let
    [v6169
     (:endpoint m6168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6169 :com.palletops.awaze.client-builder/undef)
     (. bean6167 setEndpoint (clojure.core/str v6169))))
   bean6167))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
list-subscriptions-by-topic-request
  [m6171]
  (clojure.core/let
   [bean6170
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/let
    [v6172
     (:topic-arn m6171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setTopicArn (clojure.core/str v6172))))
   (clojure.core/let
    [v6172
     (:next-token m6171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setNextToken (clojure.core/str v6172))))
   bean6170))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.PublishRequest}
publish-request
  [m6174]
  (clojure.core/let
   [bean6173 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/let
    [v6175 (:subject m6174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (. bean6173 setSubject (clojure.core/str v6175))))
   (clojure.core/let
    [v6175
     (:topic-arn m6174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (. bean6173 setTopicArn (clojure.core/str v6175))))
   (clojure.core/let
    [v6175
     (:target-arn m6174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (. bean6173 setTargetArn (clojure.core/str v6175))))
   (clojure.core/let
    [v6175
     (:message-structure
      m6174
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (. bean6173 setMessageStructure (clojure.core/str v6175))))
   (clojure.core/let
    [v6175
     (:message-attributes
      m6174
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (.
      bean6173
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6216] (clojure.core/str arg6216))
  (clojure.core/keys v6175))
 (clojure.core/map
  (clojure.core/fn [arg6216] (sns/message-attribute-value arg6216))
  (clojure.core/vals v6175))))))
   (clojure.core/let
    [v6175 (:message m6174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (. bean6173 setMessage (clojure.core/str v6175))))
   bean6173))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetEndpointAttributesRequest}
set-endpoint-attributes-request
  [m6177]
  (clojure.core/let
   [bean6176
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/let
    [v6178
     (:attributes m6177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (.
      bean6176
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6217] (clojure.core/str arg6217))
  (clojure.core/keys v6178))
 (clojure.core/map
  (clojure.core/fn [arg6217] (clojure.core/str arg6217))
  (clojure.core/vals v6178))))))
   (clojure.core/let
    [v6178
     (:endpoint-arn m6177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setEndpointArn (clojure.core/str v6178))))
   bean6176))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m6182]
   (clojure.core/let
    [credentials6183 (:credentials m6182) args6184 (:args m6182)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6185
      (com.palletops.awaze.common/aws-client :sns credentials6183)]
     (clojure.core/case
      (clojure.core/count args6184)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListTopicsRequest
           (clojure.core/nth args6184 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6185
           listTopics
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6184 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6185
               listTopics
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listTopics")
                {:args args6184}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6185
        listTopics))))))
  (clojure.core/defn
   list-topics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]
                [credentials string-0]]),
    :doc "Generate map for listTopics, listTopics, listTopics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-topics,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-topics,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-topics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]
                [credentials string-0]]),
    :doc "Call listTopics, listTopics, listTopics"}
   [credentials6187 & args6188]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6189
     (com.palletops.awaze.common/aws-client :sns credentials6187)]
    (clojure.core/case
     (clojure.core/count args6188)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListTopicsRequest
          (clojure.core/nth args6188 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6189
          listTopics
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6188 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6189
              listTopics
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listTopics")
               {:args args6188}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6189
       listTopics))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m6190]
   (clojure.core/let
    [credentials6191 (:credentials m6190) args6192 (:args m6190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6193
      (com.palletops.awaze.common/aws-client :sns credentials6191)]
     (clojure.core/case
      (clojure.core/count args6192)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6193
        setTopicAttributes
        (clojure.core/str (clojure.core/nth args6192 0))
        (clojure.core/str (clojure.core/nth args6192 1))
        (clojure.core/str (clojure.core/nth args6192 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6193
        setTopicAttributes
        (sns/set-topic-attributes-request
         (clojure.core/nth args6192 0))))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTopicAttributes, setTopicAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setTopicAttributes, setTopicAttributes"}
   [credentials6195 & args6196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6197
     (com.palletops.awaze.common/aws-client :sns credentials6195)]
    (clojure.core/case
     (clojure.core/count args6196)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6197
       setTopicAttributes
       (clojure.core/str (clojure.core/nth args6196 0))
       (clojure.core/str (clojure.core/nth args6196 1))
       (clojure.core/str (clojure.core/nth args6196 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6197
       setTopicAttributes
       (sns/set-topic-attributes-request
        (clojure.core/nth args6196 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m6198]
   (clojure.core/let
    [credentials6199 (:credentials m6198) args6200 (:args m6198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6201
      (com.palletops.awaze.common/aws-client :sns credentials6199)]
     (clojure.core/case
      (clojure.core/count args6200)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6201
        removePermission
        (sns/remove-permission-request (clojure.core/nth args6200 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6201
        removePermission
        (clojure.core/str (clojure.core/nth args6200 0))
        (clojure.core/str (clojure.core/nth args6200 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials6203 & args6204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6205
     (com.palletops.awaze.common/aws-client :sns credentials6203)]
    (clojure.core/case
     (clojure.core/count args6204)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6205
       removePermission
       (sns/remove-permission-request (clojure.core/nth args6204 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6205
       removePermission
       (clojure.core/str (clojure.core/nth args6204 0))
       (clojure.core/str (clojure.core/nth args6204 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m6206]
   (clojure.core/let
    [credentials6207 (:credentials m6206) args6208 (:args m6206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6209
      (com.palletops.awaze.common/aws-client :sns credentials6207)]
     (clojure.core/case
      (clojure.core/count args6208)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.UnsubscribeRequest
           (clojure.core/nth args6208 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6209
           unsubscribe
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6208 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6209
               unsubscribe
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "unsubscribe")
                {:args args6208}))))))))))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0]]),
    :doc "Generate map for unsubscribe, unsubscribe"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unsubscribe,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   unsubscribe
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0]]),
    :doc "Call unsubscribe, unsubscribe"}
   [credentials6211 & args6212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6213
     (com.palletops.awaze.common/aws-client :sns credentials6211)]
    (clojure.core/case
     (clojure.core/count args6212)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.UnsubscribeRequest
          (clojure.core/nth args6212 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6213
          unsubscribe
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6212 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6213
              unsubscribe
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "unsubscribe")
               {:args args6212}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m6218]
   (clojure.core/let
    [credentials6219 (:credentials m6218) args6220 (:args m6218)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6221
      (com.palletops.awaze.common/aws-client :sns credentials6219)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6221
       deletePlatformApplication
       (sns/delete-platform-application-request
        (clojure.core/nth args6220 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlatformApplication"}
   [credentials6223 & args6224]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6225
     (com.palletops.awaze.common/aws-client :sns credentials6223)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6225
      deletePlatformApplication
      (sns/delete-platform-application-request
       (clojure.core/nth args6224 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m6226]
   (clojure.core/let
    [credentials6227 (:credentials m6226) args6228 (:args m6226)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6229
      (com.palletops.awaze.common/aws-client :sns credentials6227)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6229
       deleteEndpoint
       (sns/delete-endpoint-request (clojure.core/nth args6228 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-endpoint,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEndpoint"}
   [credentials6231 & args6232]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6233
     (com.palletops.awaze.common/aws-client :sns credentials6231)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6233
      deleteEndpoint
      (sns/delete-endpoint-request (clojure.core/nth args6232 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m6234]
   (clojure.core/let
    [credentials6235 (:credentials m6234) args6236 (:args m6234)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6237
      (com.palletops.awaze.common/aws-client :sns credentials6235)]
     (clojure.core/case
      (clojure.core/count args6236)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6236 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6237
           getSubscriptionAttributes
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
               (clojure.core/nth args6236 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6237
               getSubscriptionAttributes
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getSubscriptionAttributes")
                {:args args6236}))))))))))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Generate map for getSubscriptionAttributes, getSubscriptionAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Call getSubscriptionAttributes, getSubscriptionAttributes"}
   [credentials6239 & args6240]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6241
     (com.palletops.awaze.common/aws-client :sns credentials6239)]
    (clojure.core/case
     (clojure.core/count args6240)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6240 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6241
          getSubscriptionAttributes
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
              (clojure.core/nth args6240 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6241
              getSubscriptionAttributes
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getSubscriptionAttributes")
               {:args args6240}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m6242]
   (clojure.core/let
    [credentials6243 (:credentials m6242) args6244 (:args m6242)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6245
      (com.palletops.awaze.common/aws-client :sns credentials6243)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6245
       createPlatformApplication
       (sns/create-platform-application-request
        (clojure.core/nth args6244 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         platform]}]]),
    :doc "Generate map for createPlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         platform]}]]),
    :doc "Call createPlatformApplication"}
   [credentials6247 & args6248]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6249
     (com.palletops.awaze.common/aws-client :sns credentials6247)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6249
      createPlatformApplication
      (sns/create-platform-application-request
       (clojure.core/nth args6248 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m6250]
   (clojure.core/let
    [credentials6251 (:credentials m6250) args6252 (:args m6250)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6253
      (com.palletops.awaze.common/aws-client :sns credentials6251)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6253
       setPlatformApplicationAttributes
       (sns/set-platform-application-attributes-request
        (clojure.core/nth args6252 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-platform-application-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call setPlatformApplicationAttributes"}
   [credentials6255 & args6256]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6257
     (com.palletops.awaze.common/aws-client :sns credentials6255)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6257
      setPlatformApplicationAttributes
      (sns/set-platform-application-attributes-request
       (clojure.core/nth args6256 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m6258]
   (clojure.core/let
    [credentials6259 (:credentials m6258) args6260 (:args m6258)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6261
      (com.palletops.awaze.common/aws-client :sns credentials6259)]
     (clojure.core/case
      (clojure.core/count args6260)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6261
        confirmSubscription
        (sns/confirm-subscription-request
         (clojure.core/nth args6260 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6261
        confirmSubscription
        (clojure.core/str (clojure.core/nth args6260 0))
        (clojure.core/str (clojure.core/nth args6260 1))
        (clojure.core/str (clojure.core/nth args6260 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6261
        confirmSubscription
        (clojure.core/str (clojure.core/nth args6260 0))
        (clojure.core/str (clojure.core/nth args6260 1))))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         authenticate-on-unsubscribe
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Generate map for confirmSubscription, confirmSubscription, confirmSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   confirm-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         authenticate-on-unsubscribe
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Call confirmSubscription, confirmSubscription, confirmSubscription"}
   [credentials6263 & args6264]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6265
     (com.palletops.awaze.common/aws-client :sns credentials6263)]
    (clojure.core/case
     (clojure.core/count args6264)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6265
       confirmSubscription
       (sns/confirm-subscription-request
        (clojure.core/nth args6264 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6265
       confirmSubscription
       (clojure.core/str (clojure.core/nth args6264 0))
       (clojure.core/str (clojure.core/nth args6264 1))
       (clojure.core/str (clojure.core/nth args6264 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6265
       confirmSubscription
       (clojure.core/str (clojure.core/nth args6264 0))
       (clojure.core/str (clojure.core/nth args6264 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m6266]
   (clojure.core/let
    [credentials6267 (:credentials m6266) args6268 (:args m6266)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6269
      (com.palletops.awaze.common/aws-client :sns credentials6267)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6269
       createPlatformEndpoint
       (sns/create-platform-endpoint-request
        (clojure.core/nth args6268 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-user-data
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-platform-endpoint,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-user-data
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call createPlatformEndpoint"}
   [credentials6271 & args6272]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6273
     (com.palletops.awaze.common/aws-client :sns credentials6271)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6273
      createPlatformEndpoint
      (sns/create-platform-endpoint-request
       (clojure.core/nth args6272 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m6274]
   (clojure.core/let
    [credentials6275 (:credentials m6274) args6276 (:args m6274)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6277
      (com.palletops.awaze.common/aws-client :sns credentials6275)]
     (clojure.core/case
      (clojure.core/count args6276)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6277
        listPlatformApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6277
        listPlatformApplications
        (sns/list-platform-applications-request
         (clojure.core/nth args6276 0))))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-platform-applications,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-platform-applications,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-platform-applications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials6279 & args6280]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6281
     (com.palletops.awaze.common/aws-client :sns credentials6279)]
    (clojure.core/case
     (clojure.core/count args6280)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6281
       listPlatformApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6281
       listPlatformApplications
       (sns/list-platform-applications-request
        (clojure.core/nth args6280 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m6282]
   (clojure.core/let
    [credentials6283 (:credentials m6282) args6284 (:args m6282)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6285
      (com.palletops.awaze.common/aws-client :sns credentials6283)]
     (clojure.core/case
      (clojure.core/count args6284)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6284 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6285
           createTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.CreateTopicRequest
               (clojure.core/nth args6284 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6285
               createTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createTopic")
                {:args args6284}))))))))))))))
  (clojure.core/defn
   create-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTopic, createTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTopic, createTopic"}
   [credentials6287 & args6288]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6289
     (com.palletops.awaze.common/aws-client :sns credentials6287)]
    (clojure.core/case
     (clojure.core/count args6288)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6288 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6289
          createTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.CreateTopicRequest
              (clojure.core/nth args6288 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6289
              createTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createTopic")
               {:args args6288}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m6290]
   (clojure.core/let
    [credentials6291 (:credentials m6290) args6292 (:args m6290)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6293
      (com.palletops.awaze.common/aws-client :sns credentials6291)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6293
       listEndpointsByPlatformApplication
       (sns/list-endpoints-by-platform-application-request
        (clojure.core/nth args6292 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials6295 & args6296]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6297
     (com.palletops.awaze.common/aws-client :sns credentials6295)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6297
      listEndpointsByPlatformApplication
      (sns/list-endpoints-by-platform-application-request
       (clojure.core/nth args6296 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m6298]
   (clojure.core/let
    [credentials6299 (:credentials m6298) args6300 (:args m6298)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6301
      (com.palletops.awaze.common/aws-client :sns credentials6299)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6301
       getPlatformApplicationAttributes
       (sns/get-platform-application-attributes-request
        (clojure.core/nth args6300 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-platform-application-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPlatformApplicationAttributes"}
   [credentials6303 & args6304]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6305
     (com.palletops.awaze.common/aws-client :sns credentials6303)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6305
      getPlatformApplicationAttributes
      (sns/get-platform-application-attributes-request
       (clojure.core/nth args6304 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m6306]
   (clojure.core/let
    [credentials6307 (:credentials m6306) args6308 (:args m6306)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6309
      (com.palletops.awaze.common/aws-client :sns credentials6307)]
     (clojure.core/case
      (clojure.core/count args6308)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6309
        setSubscriptionAttributes
        (sns/set-subscription-attributes-request
         (clojure.core/nth args6308 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6309
        setSubscriptionAttributes
        (clojure.core/str (clojure.core/nth args6308 0))
        (clojure.core/str (clojure.core/nth args6308 1))
        (clojure.core/str (clojure.core/nth args6308 2))))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setSubscriptionAttributes, setSubscriptionAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setSubscriptionAttributes, setSubscriptionAttributes"}
   [credentials6311 & args6312]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6313
     (com.palletops.awaze.common/aws-client :sns credentials6311)]
    (clojure.core/case
     (clojure.core/count args6312)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6313
       setSubscriptionAttributes
       (sns/set-subscription-attributes-request
        (clojure.core/nth args6312 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6313
       setSubscriptionAttributes
       (clojure.core/str (clojure.core/nth args6312 0))
       (clojure.core/str (clojure.core/nth args6312 1))
       (clojure.core/str (clojure.core/nth args6312 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m6314]
   (clojure.core/let
    [credentials6315 (:credentials m6314) args6316 (:args m6314)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6317
      (com.palletops.awaze.common/aws-client :sns credentials6315)]
     (clojure.core/case
      (clojure.core/count args6316)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6317
        addPermission
        (sns/add-permission-request (clojure.core/nth args6316 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6317
        addPermission
        (clojure.core/str (clojure.core/nth args6316 0))
        (clojure.core/str (clojure.core/nth args6316 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6346] (clojure.core/str arg6346))
 (clojure.core/nth args6316 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6347] (clojure.core/str arg6347))
 (clojure.core/nth args6316 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         action-names
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         action-names
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials6319 & args6320]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6321
     (com.palletops.awaze.common/aws-client :sns credentials6319)]
    (clojure.core/case
     (clojure.core/count args6320)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6321
       addPermission
       (sns/add-permission-request (clojure.core/nth args6320 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6321
       addPermission
       (clojure.core/str (clojure.core/nth args6320 0))
       (clojure.core/str (clojure.core/nth args6320 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6348] (clojure.core/str arg6348))
 (clojure.core/nth args6320 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6349] (clojure.core/str arg6349))
 (clojure.core/nth args6320 3))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m6322]
   (clojure.core/let
    [credentials6323 (:credentials m6322) args6324 (:args m6322)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6325
      (com.palletops.awaze.common/aws-client :sns credentials6323)]
     (clojure.core/case
      (clojure.core/count args6324)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListSubscriptionsRequest
           (clojure.core/nth args6324 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6325
           listSubscriptions
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6324 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6325
               listSubscriptions
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptions")
                {:args args6324}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6325
        listSubscriptions))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0]
                [credentials]]),
    :doc "Generate map for listSubscriptions, listSubscriptions, listSubscriptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-subscriptions,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-subscriptions,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-subscriptions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0]
                [credentials]]),
    :doc "Call listSubscriptions, listSubscriptions, listSubscriptions"}
   [credentials6327 & args6328]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6329
     (com.palletops.awaze.common/aws-client :sns credentials6327)]
    (clojure.core/case
     (clojure.core/count args6328)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListSubscriptionsRequest
          (clojure.core/nth args6328 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6329
          listSubscriptions
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6328 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6329
              listSubscriptions
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptions")
               {:args args6328}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6329
       listSubscriptions))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m6330]
   (clojure.core/let
    [credentials6331 (:credentials m6330) args6332 (:args m6330)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6333
      (com.palletops.awaze.common/aws-client :sns credentials6331)]
     (clojure.core/case
      (clojure.core/count args6332)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6332 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6333
           getTopicAttributes
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.GetTopicAttributesRequest
               (clojure.core/nth args6332 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6333
               getTopicAttributes
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getTopicAttributes")
                {:args args6332}))))))))))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTopicAttributes, getTopicAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTopicAttributes, getTopicAttributes"}
   [credentials6335 & args6336]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6337
     (com.palletops.awaze.common/aws-client :sns credentials6335)]
    (clojure.core/case
     (clojure.core/count args6336)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6336 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6337
          getTopicAttributes
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.GetTopicAttributesRequest
              (clojure.core/nth args6336 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6337
              getTopicAttributes
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getTopicAttributes")
               {:args args6336}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m6338]
   (clojure.core/let
    [credentials6339 (:credentials m6338) args6340 (:args m6338)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6341
      (com.palletops.awaze.common/aws-client :sns credentials6339)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6341
       getEndpointAttributes
       (sns/get-endpoint-attributes-request
        (clojure.core/nth args6340 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-endpoint-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getEndpointAttributes"}
   [credentials6343 & args6344]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6345
     (com.palletops.awaze.common/aws-client :sns credentials6343)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6345
      getEndpointAttributes
      (sns/get-endpoint-attributes-request
       (clojure.core/nth args6344 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m6350]
   (clojure.core/let
    [credentials6351 (:credentials m6350) args6352 (:args m6350)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6353
      (com.palletops.awaze.common/aws-client :sns credentials6351)]
     (clojure.core/case
      (clojure.core/count args6352)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.DeleteTopicRequest
           (clojure.core/nth args6352 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6353
           deleteTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6352 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6353
               deleteTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteTopic")
                {:args args6352}))))))))))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for deleteTopic, deleteTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call deleteTopic, deleteTopic"}
   [credentials6355 & args6356]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6357
     (com.palletops.awaze.common/aws-client :sns credentials6355)]
    (clojure.core/case
     (clojure.core/count args6356)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.DeleteTopicRequest
          (clojure.core/nth args6356 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6357
          deleteTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6356 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6357
              deleteTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteTopic")
               {:args args6356}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m6358]
   (clojure.core/let
    [credentials6359 (:credentials m6358) args6360 (:args m6358)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6361
      (com.palletops.awaze.common/aws-client :sns credentials6359)]
     (clojure.core/case
      (clojure.core/count args6360)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6361
        subscribe
        (clojure.core/str (clojure.core/nth args6360 0))
        (clojure.core/str (clojure.core/nth args6360 1))
        (clojure.core/str (clojure.core/nth args6360 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6361
        subscribe
        (sns/subscribe-request (clojure.core/nth args6360 0))))))))
  (clojure.core/defn
   subscribe-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         protocol
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         endpoint
                         clone-root]}]]),
    :doc "Generate map for subscribe, subscribe"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :subscribe,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :subscribe,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   subscribe
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         protocol
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         endpoint
                         clone-root]}]]),
    :doc "Call subscribe, subscribe"}
   [credentials6363 & args6364]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6365
     (com.palletops.awaze.common/aws-client :sns credentials6363)]
    (clojure.core/case
     (clojure.core/count args6364)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6365
       subscribe
       (clojure.core/str (clojure.core/nth args6364 0))
       (clojure.core/str (clojure.core/nth args6364 1))
       (clojure.core/str (clojure.core/nth args6364 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6365
       subscribe
       (sns/subscribe-request (clojure.core/nth args6364 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m6366]
   (clojure.core/let
    [credentials6367 (:credentials m6366) args6368 (:args m6366)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6369
      (com.palletops.awaze.common/aws-client :sns credentials6367)]
     (clojure.core/case
      (clojure.core/count args6368)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
           (clojure.core/nth args6368 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6369
           listSubscriptionsByTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6368 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6369
               listSubscriptionsByTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptionsByTopic")
                {:args args6368}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6369
        listSubscriptionsByTopic
        (clojure.core/str (clojure.core/nth args6368 0))
        (clojure.core/str (clojure.core/nth args6368 1))))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   [credentials6371 & args6372]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6373
     (com.palletops.awaze.common/aws-client :sns credentials6371)]
    (clojure.core/case
     (clojure.core/count args6372)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
          (clojure.core/nth args6372 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6373
          listSubscriptionsByTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6372 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6373
              listSubscriptionsByTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptionsByTopic")
               {:args args6372}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6373
       listSubscriptionsByTopic
       (clojure.core/str (clojure.core/nth args6372 0))
       (clojure.core/str (clojure.core/nth args6372 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m6374]
   (clojure.core/let
    [credentials6375 (:credentials m6374) args6376 (:args m6374)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6377
      (com.palletops.awaze.common/aws-client :sns credentials6375)]
     (clojure.core/case
      (clojure.core/count args6376)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6377
        publish
        (clojure.core/str (clojure.core/nth args6376 0))
        (clojure.core/str (clojure.core/nth args6376 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6377
        publish
        (sns/publish-request (clojure.core/nth args6376 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6377
        publish
        (clojure.core/str (clojure.core/nth args6376 0))
        (clojure.core/str (clojure.core/nth args6376 1))
        (clojure.core/str (clojure.core/nth args6376 2))))))))
  (clojure.core/defn
   publish-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-structure
                         clone-source
                         subject
                         clone-root
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for publish, publish, publish"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   publish
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-structure
                         clone-source
                         subject
                         clone-root
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call publish, publish, publish"}
   [credentials6379 & args6380]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6381
     (com.palletops.awaze.common/aws-client :sns credentials6379)]
    (clojure.core/case
     (clojure.core/count args6380)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6381
       publish
       (clojure.core/str (clojure.core/nth args6380 0))
       (clojure.core/str (clojure.core/nth args6380 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6381
       publish
       (sns/publish-request (clojure.core/nth args6380 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6381
       publish
       (clojure.core/str (clojure.core/nth args6380 0))
       (clojure.core/str (clojure.core/nth args6380 1))
       (clojure.core/str (clojure.core/nth args6380 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m6382]
   (clojure.core/let
    [credentials6383 (:credentials m6382) args6384 (:args m6382)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6385
      (com.palletops.awaze.common/aws-client :sns credentials6383)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6385
       setEndpointAttributes
       (sns/set-endpoint-attributes-request
        (clojure.core/nth args6384 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-endpoint-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call setEndpointAttributes"}
   [credentials6387 & args6388]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6389
     (com.palletops.awaze.common/aws-client :sns credentials6387)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6389
      setEndpointAttributes
      (sns/set-endpoint-attributes-request
       (clojure.core/nth args6388 0))))))))
