(ns
 com.palletops.awaze.simpleemail
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpleemail :as simpleemail]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpleemail
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.InvocationType}
invocation-type
  [m5197]
  (.
   com.amazonaws.services.simpleemail.model.InvocationType
   fromValue
   (clojure.core/name m5197)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.StopScope}
stop-scope
  [m5200]
  (.
   com.amazonaws.services.simpleemail.model.StopScope
   fromValue
   (clojure.core/name m5200)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ExtensionField}
extension-field
  [m5203]
  (clojure.core/let
   [bean5202
    (new com.amazonaws.services.simpleemail.model.ExtensionField)]
   (clojure.core/let
    [v5204 (:name m5203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5204 :com.palletops.awaze.client-builder/undef)
     (. bean5202 setName (clojure.core/str v5204))))
   (clojure.core/let
    [v5204 (:value m5203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5204 :com.palletops.awaze.client-builder/undef)
     (. bean5202 setValue (clojure.core/str v5204))))
   bean5202))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.S3Action}
s3action
  [m5206]
  (clojure.core/let
   [bean5205 (new com.amazonaws.services.simpleemail.model.S3Action)]
   (clojure.core/let
    [v5207
     (:topic-arn m5206 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5207 :com.palletops.awaze.client-builder/undef)
     (. bean5205 setTopicArn (clojure.core/str v5207))))
   (clojure.core/let
    [v5207
     (:bucket-name m5206 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5207 :com.palletops.awaze.client-builder/undef)
     (. bean5205 setBucketName (clojure.core/str v5207))))
   (clojure.core/let
    [v5207
     (:object-key-prefix
      m5206
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5207 :com.palletops.awaze.client-builder/undef)
     (. bean5205 setObjectKeyPrefix (clojure.core/str v5207))))
   (clojure.core/let
    [v5207
     (:kms-key-arn m5206 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5207 :com.palletops.awaze.client-builder/undef)
     (. bean5205 setKmsKeyArn (clojure.core/str v5207))))
   bean5205))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BounceAction}
bounce-action
  [m5209]
  (clojure.core/let
   [bean5208
    (new com.amazonaws.services.simpleemail.model.BounceAction)]
   (clojure.core/let
    [v5210
     (:status-code m5209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5210 :com.palletops.awaze.client-builder/undef)
     (. bean5208 setStatusCode (clojure.core/str v5210))))
   (clojure.core/let
    [v5210
     (:topic-arn m5209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5210 :com.palletops.awaze.client-builder/undef)
     (. bean5208 setTopicArn (clojure.core/str v5210))))
   (clojure.core/let
    [v5210
     (:smtp-reply-code
      m5209
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5210 :com.palletops.awaze.client-builder/undef)
     (. bean5208 setSmtpReplyCode (clojure.core/str v5210))))
   (clojure.core/let
    [v5210 (:sender m5209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5210 :com.palletops.awaze.client-builder/undef)
     (. bean5208 setSender (clojure.core/str v5210))))
   (clojure.core/let
    [v5210 (:message m5209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5210 :com.palletops.awaze.client-builder/undef)
     (. bean5208 setMessage (clojure.core/str v5210))))
   bean5208))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.WorkmailAction}
workmail-action
  [m5212]
  (clojure.core/let
   [bean5211
    (new com.amazonaws.services.simpleemail.model.WorkmailAction)]
   (clojure.core/let
    [v5213
     (:topic-arn m5212 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5213 :com.palletops.awaze.client-builder/undef)
     (. bean5211 setTopicArn (clojure.core/str v5213))))
   (clojure.core/let
    [v5213
     (:organization-arn
      m5212
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5213 :com.palletops.awaze.client-builder/undef)
     (. bean5211 setOrganizationArn (clojure.core/str v5213))))
   bean5211))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.LambdaAction}
lambda-action
  [m5215]
  (clojure.core/let
   [bean5214
    (new com.amazonaws.services.simpleemail.model.LambdaAction)]
   (clojure.core/let
    [v5216
     (:topic-arn m5215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5216 :com.palletops.awaze.client-builder/undef)
     (. bean5214 setTopicArn (clojure.core/str v5216))))
   (clojure.core/let
    [v5216
     (:function-arn m5215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5216 :com.palletops.awaze.client-builder/undef)
     (. bean5214 setFunctionArn (clojure.core/str v5216))))
   (clojure.core/let
    [v5216
     (:invocation-type
      m5215
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5216 :com.palletops.awaze.client-builder/undef)
     (.
      bean5214
      setInvocationType
      (simpleemail/invocation-type v5216))))
   bean5214))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.StopAction}
stop-action
  [m5218]
  (clojure.core/let
   [bean5217
    (new com.amazonaws.services.simpleemail.model.StopAction)]
   (clojure.core/let
    [v5219
     (:topic-arn m5218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5219 :com.palletops.awaze.client-builder/undef)
     (. bean5217 setTopicArn (clojure.core/str v5219))))
   (clojure.core/let
    [v5219 (:scope m5218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5219 :com.palletops.awaze.client-builder/undef)
     (. bean5217 setScope (simpleemail/stop-scope v5219))))
   bean5217))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.AddHeaderAction}
add-header-action
  [m5221]
  (clojure.core/let
   [bean5220
    (new com.amazonaws.services.simpleemail.model.AddHeaderAction)]
   (clojure.core/let
    [v5222
     (:header-name m5221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5222 :com.palletops.awaze.client-builder/undef)
     (. bean5220 setHeaderName (clojure.core/str v5222))))
   (clojure.core/let
    [v5222
     (:header-value m5221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5222 :com.palletops.awaze.client-builder/undef)
     (. bean5220 setHeaderValue (clojure.core/str v5222))))
   bean5220))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SNSAction}
snsaction
  [m5224]
  (clojure.core/let
   [bean5223 (new com.amazonaws.services.simpleemail.model.SNSAction)]
   (clojure.core/let
    [v5225
     (:encoding m5224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5225 :com.palletops.awaze.client-builder/undef)
     (. bean5223 setEncoding (clojure.core/str v5225))))
   (clojure.core/let
    [v5225
     (:topic-arn m5224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5225 :com.palletops.awaze.client-builder/undef)
     (. bean5223 setTopicArn (clojure.core/str v5225))))
   bean5223))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Content}
content
  [m5227]
  (clojure.core/let
   [bean5226 (new com.amazonaws.services.simpleemail.model.Content)]
   (clojure.core/let
    [v5228 (:charset m5227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5228 :com.palletops.awaze.client-builder/undef)
     (. bean5226 setCharset (clojure.core/str v5228))))
   (clojure.core/let
    [v5228 (:data m5227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5228 :com.palletops.awaze.client-builder/undef)
     (. bean5226 setData (clojure.core/str v5228))))
   bean5226))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptIpFilter}
receipt-ip-filter
  [m5230]
  (clojure.core/let
   [bean5229
    (new com.amazonaws.services.simpleemail.model.ReceiptIpFilter)]
   (clojure.core/let
    [v5231 (:cidr m5230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5231 :com.palletops.awaze.client-builder/undef)
     (. bean5229 setCidr (clojure.core/str v5231))))
   (clojure.core/let
    [v5231 (:policy m5230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5231 :com.palletops.awaze.client-builder/undef)
     (. bean5229 setPolicy (clojure.core/str v5231))))
   bean5229))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RecipientDsnFields}
recipient-dsn-fields
  [m5233]
  (clojure.core/let
   [bean5232
    (new com.amazonaws.services.simpleemail.model.RecipientDsnFields)]
   (clojure.core/let
    [v5234 (:status m5233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setStatus (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:extension-fields
      m5233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (.
      bean5232
      setExtensionFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5391] (simpleemail/extension-field arg5391))
 v5234))))
   (clojure.core/let
    [v5234 (:action m5233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setAction (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:final-recipient
      m5233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setFinalRecipient (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:remote-mta m5233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setRemoteMta (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:diagnostic-code
      m5233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setDiagnosticCode (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:last-attempt-date
      m5233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (.
      bean5232
      setLastAttemptDate
      (com.palletops.awaze.common/to-date v5234))))
   bean5232))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.TlsPolicy}
tls-policy
  [m5236]
  (.
   com.amazonaws.services.simpleemail.model.TlsPolicy
   fromValue
   (clojure.core/name m5236)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptAction}
receipt-action
  [m5239]
  (clojure.core/let
   [bean5238
    (new com.amazonaws.services.simpleemail.model.ReceiptAction)]
   (clojure.core/let
    [v5240
     (:s3action m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setS3Action (simpleemail/s3action v5240))))
   (clojure.core/let
    [v5240
     (:bounce-action m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setBounceAction (simpleemail/bounce-action v5240))))
   (clojure.core/let
    [v5240
     (:workmail-action
      m5239
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (.
      bean5238
      setWorkmailAction
      (simpleemail/workmail-action v5240))))
   (clojure.core/let
    [v5240
     (:lambda-action m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setLambdaAction (simpleemail/lambda-action v5240))))
   (clojure.core/let
    [v5240
     (:stop-action m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setStopAction (simpleemail/stop-action v5240))))
   (clojure.core/let
    [v5240
     (:add-header-action
      m5239
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (.
      bean5238
      setAddHeaderAction
      (simpleemail/add-header-action v5240))))
   (clojure.core/let
    [v5240
     (:snsaction m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setSNSAction (simpleemail/snsaction v5240))))
   bean5238))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Body}
body
  [m5242]
  (clojure.core/let
   [bean5241 (new com.amazonaws.services.simpleemail.model.Body)]
   (clojure.core/let
    [v5243 (:text m5242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setText (simpleemail/content v5243))))
   (clojure.core/let
    [v5243 (:html m5242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setHtml (simpleemail/content v5243))))
   bean5241))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptFilter}
receipt-filter
  [m5245]
  (clojure.core/let
   [bean5244
    (new com.amazonaws.services.simpleemail.model.ReceiptFilter)]
   (clojure.core/let
    [v5246
     (:ip-filter m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setIpFilter (simpleemail/receipt-ip-filter v5246))))
   (clojure.core/let
    [v5246 (:name m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setName (clojure.core/str v5246))))
   bean5244))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BouncedRecipientInfo}
bounced-recipient-info
  [m5248]
  (clojure.core/let
   [bean5247
    (new
     com.amazonaws.services.simpleemail.model.BouncedRecipientInfo)]
   (clojure.core/let
    [v5249
     (:recipient m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setRecipient (clojure.core/str v5249))))
   (clojure.core/let
    [v5249
     (:recipient-arn m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setRecipientArn (clojure.core/str v5249))))
   (clojure.core/let
    [v5249
     (:bounce-type m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setBounceType (clojure.core/str v5249))))
   (clojure.core/let
    [v5249
     (:recipient-dsn-fields
      m5248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (.
      bean5247
      setRecipientDsnFields
      (simpleemail/recipient-dsn-fields v5249))))
   bean5247))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.MessageDsn}
message-dsn
  [m5251]
  (clojure.core/let
   [bean5250
    (new com.amazonaws.services.simpleemail.model.MessageDsn)]
   (clojure.core/let
    [v5252
     (:reporting-mta m5251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5252 :com.palletops.awaze.client-builder/undef)
     (. bean5250 setReportingMta (clojure.core/str v5252))))
   (clojure.core/let
    [v5252
     (:arrival-date m5251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5252 :com.palletops.awaze.client-builder/undef)
     (.
      bean5250
      setArrivalDate
      (com.palletops.awaze.common/to-date v5252))))
   (clojure.core/let
    [v5252
     (:extension-fields
      m5251
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5252 :com.palletops.awaze.client-builder/undef)
     (.
      bean5250
      setExtensionFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5392] (simpleemail/extension-field arg5392))
 v5252))))
   bean5250))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptRule}
receipt-rule
  [m5254]
  (clojure.core/let
   [bean5253
    (new com.amazonaws.services.simpleemail.model.ReceiptRule)]
   (clojure.core/let
    [v5255
     (:tls-policy m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (. bean5253 setTlsPolicy (simpleemail/tls-policy v5255))))
   (clojure.core/let
    [v5255
     (:recipients m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (.
      bean5253
      setRecipients
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5393] (clojure.core/str arg5393))
 v5255))))
   (clojure.core/let
    [v5255 (:actions m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (.
      bean5253
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5394] (simpleemail/receipt-action arg5394))
 v5255))))
   (clojure.core/let
    [v5255
     (:scan-enabled m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (. bean5253 setScanEnabled (clojure.core/boolean v5255))))
   (clojure.core/let
    [v5255 (:enabled m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (. bean5253 setEnabled (clojure.core/boolean v5255))))
   (clojure.core/let
    [v5255 (:name m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (. bean5253 setName (clojure.core/str v5255))))
   bean5253))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Destination}
destination
  [m5257]
  (clojure.core/let
   [bean5256
    (new com.amazonaws.services.simpleemail.model.Destination)]
   (clojure.core/let
    [v5258
     (:to-addresses m5257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (.
      bean5256
      setToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5395] (clojure.core/str arg5395))
 v5258))))
   (clojure.core/let
    [v5258
     (:cc-addresses m5257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (.
      bean5256
      setCcAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5396] (clojure.core/str arg5396))
 v5258))))
   (clojure.core/let
    [v5258
     (:bcc-addresses m5257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (.
      bean5256
      setBccAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5397] (clojure.core/str arg5397))
 v5258))))
   bean5256))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Message}
message
  [m5260]
  (clojure.core/let
   [bean5259 (new com.amazonaws.services.simpleemail.model.Message)]
   (clojure.core/let
    [v5261 (:subject m5260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5261 :com.palletops.awaze.client-builder/undef)
     (. bean5259 setSubject (simpleemail/content v5261))))
   (clojure.core/let
    [v5261 (:body m5260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5261 :com.palletops.awaze.client-builder/undef)
     (. bean5259 setBody (simpleemail/body v5261))))
   bean5259))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RawMessage}
raw-message
  [m5263]
  (clojure.core/let
   [bean5262
    (new com.amazonaws.services.simpleemail.model.RawMessage)]
   (clojure.core/let
    [v5264 (:data m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setData (clojure.core/identity v5264))))
   bean5262))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.IdentityType}
identity-type
  [m5266]
  (.
   com.amazonaws.services.simpleemail.model.IdentityType
   fromValue
   (clojure.core/name m5266)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListReceiptRuleSetsRequest}
list-receipt-rule-sets-request
  [m5269]
  (clojure.core/let
   [bean5268
    (new
     com.amazonaws.services.simpleemail.model.ListReceiptRuleSetsRequest)]
   (clojure.core/let
    [v5270
     (:next-token m5269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5270 :com.palletops.awaze.client-builder/undef)
     (. bean5268 setNextToken (clojure.core/str v5270))))
   bean5268))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest}
verify-email-address-request
  [m5272]
  (clojure.core/let
   [bean5271
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest)]
   (clojure.core/let
    [v5273
     (:email-address m5272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5273 :com.palletops.awaze.client-builder/undef)
     (. bean5271 setEmailAddress (clojure.core/str v5273))))
   bean5271))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeActiveReceiptRuleSetRequest}
describe-active-receipt-rule-set-request
  [m5275]
  (clojure.core/let
   [bean5274
    (new
     com.amazonaws.services.simpleemail.model.DescribeActiveReceiptRuleSetRequest)]
   bean5274))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListReceiptFiltersRequest}
list-receipt-filters-request
  [m5278]
  (clojure.core/let
   [bean5277
    (new
     com.amazonaws.services.simpleemail.model.ListReceiptFiltersRequest)]
   bean5277))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityRequest}
delete-identity-request
  [m5281]
  (clojure.core/let
   [bean5280
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityRequest)]
   (clojure.core/let
    [v5282
     (:identity m5281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5282 :com.palletops.awaze.client-builder/undef)
     (. bean5280 setIdentity (clojure.core/str v5282))))
   bean5280))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest}
verify-email-identity-request
  [m5284]
  (clojure.core/let
   [bean5283
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest)]
   (clojure.core/let
    [v5285
     (:email-address m5284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5285 :com.palletops.awaze.client-builder/undef)
     (. bean5283 setEmailAddress (clojure.core/str v5285))))
   bean5283))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest}
list-verified-email-addresses-request
  [m5287]
  (clojure.core/let
   [bean5286
    (new
     com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest)]
   bean5286))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeReceiptRuleRequest}
describe-receipt-rule-request
  [m5290]
  (clojure.core/let
   [bean5289
    (new
     com.amazonaws.services.simpleemail.model.DescribeReceiptRuleRequest)]
   (clojure.core/let
    [v5291
     (:rule-set-name m5290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5291 :com.palletops.awaze.client-builder/undef)
     (. bean5289 setRuleSetName (clojure.core/str v5291))))
   (clojure.core/let
    [v5291
     (:rule-name m5290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5291 :com.palletops.awaze.client-builder/undef)
     (. bean5289 setRuleName (clojure.core/str v5291))))
   bean5289))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptFilterRequest}
delete-receipt-filter-request
  [m5293]
  (clojure.core/let
   [bean5292
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptFilterRequest)]
   (clojure.core/let
    [v5294
     (:filter-name m5293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5294 :com.palletops.awaze.client-builder/undef)
     (. bean5292 setFilterName (clojure.core/str v5294))))
   bean5292))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest}
get-identity-verification-attributes-request
  [m5296]
  (clojure.core/let
   [bean5295
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest)]
   (clojure.core/let
    [v5297
     (:identities m5296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5297 :com.palletops.awaze.client-builder/undef)
     (.
      bean5295
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5398] (clojure.core/str arg5398))
 v5297))))
   bean5295))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendQuotaRequest}
get-send-quota-request
  [m5299]
  (clojure.core/let
   [bean5298
    (new com.amazonaws.services.simpleemail.model.GetSendQuotaRequest)]
   bean5298))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptRuleSetRequest}
create-receipt-rule-set-request
  [m5302]
  (clojure.core/let
   [bean5301
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptRuleSetRequest)]
   (clojure.core/let
    [v5303
     (:rule-set-name m5302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5303 :com.palletops.awaze.client-builder/undef)
     (. bean5301 setRuleSetName (clojure.core/str v5303))))
   bean5301))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest}
set-identity-notification-topic-request
  [m5305]
  (clojure.core/let
   [bean5304
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest)]
   (clojure.core/let
    [v5306
     (:identity m5305 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5306 :com.palletops.awaze.client-builder/undef)
     (. bean5304 setIdentity (clojure.core/str v5306))))
   (clojure.core/let
    [v5306
     (:notification-type
      m5305
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5306 :com.palletops.awaze.client-builder/undef)
     (. bean5304 setNotificationType (clojure.core/str v5306))))
   (clojure.core/let
    [v5306
     (:sns-topic m5305 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5306 :com.palletops.awaze.client-builder/undef)
     (. bean5304 setSnsTopic (clojure.core/str v5306))))
   bean5304))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest}
verify-domain-identity-request
  [m5308]
  (clojure.core/let
   [bean5307
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest)]
   (clojure.core/let
    [v5309 (:domain m5308 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5309 :com.palletops.awaze.client-builder/undef)
     (. bean5307 setDomain (clojure.core/str v5309))))
   bean5307))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentityPoliciesRequest}
list-identity-policies-request
  [m5311]
  (clojure.core/let
   [bean5310
    (new
     com.amazonaws.services.simpleemail.model.ListIdentityPoliciesRequest)]
   (clojure.core/let
    [v5312
     (:identity m5311 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5312 :com.palletops.awaze.client-builder/undef)
     (. bean5310 setIdentity (clojure.core/str v5312))))
   bean5310))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest}
create-receipt-filter-request
  [m5314]
  (clojure.core/let
   [bean5313
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest)]
   (clojure.core/let
    [v5315 (:filter m5314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5315 :com.palletops.awaze.client-builder/undef)
     (. bean5313 setFilter (simpleemail/receipt-filter v5315))))
   bean5313))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.PutIdentityPolicyRequest}
put-identity-policy-request
  [m5317]
  (clojure.core/let
   [bean5316
    (new
     com.amazonaws.services.simpleemail.model.PutIdentityPolicyRequest)]
   (clojure.core/let
    [v5318 (:policy m5317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5318 :com.palletops.awaze.client-builder/undef)
     (. bean5316 setPolicy (clojure.core/str v5318))))
   (clojure.core/let
    [v5318
     (:identity m5317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5318 :com.palletops.awaze.client-builder/undef)
     (. bean5316 setIdentity (clojure.core/str v5318))))
   (clojure.core/let
    [v5318
     (:policy-name m5317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5318 :com.palletops.awaze.client-builder/undef)
     (. bean5316 setPolicyName (clojure.core/str v5318))))
   bean5316))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest}
verify-domain-dkim-request
  [m5320]
  (clojure.core/let
   [bean5319
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest)]
   (clojure.core/let
    [v5321 (:domain m5320 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5321 :com.palletops.awaze.client-builder/undef)
     (. bean5319 setDomain (clojure.core/str v5321))))
   bean5319))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityMailFromDomainRequest}
set-identity-mail-from-domain-request
  [m5323]
  (clojure.core/let
   [bean5322
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityMailFromDomainRequest)]
   (clojure.core/let
    [v5324
     (:identity m5323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5324 :com.palletops.awaze.client-builder/undef)
     (. bean5322 setIdentity (clojure.core/str v5324))))
   (clojure.core/let
    [v5324
     (:mail-from-domain
      m5323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5324 :com.palletops.awaze.client-builder/undef)
     (. bean5322 setMailFromDomain (clojure.core/str v5324))))
   (clojure.core/let
    [v5324
     (:behavior-on-mxfailure
      m5323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5324 :com.palletops.awaze.client-builder/undef)
     (. bean5322 setBehaviorOnMXFailure (clojure.core/str v5324))))
   bean5322))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest}
get-identity-notification-attributes-request
  [m5326]
  (clojure.core/let
   [bean5325
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest)]
   (clojure.core/let
    [v5327
     (:identities m5326 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5327 :com.palletops.awaze.client-builder/undef)
     (.
      bean5325
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5399] (clojure.core/str arg5399))
 v5327))))
   bean5325))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptRuleRequest}
delete-receipt-rule-request
  [m5329]
  (clojure.core/let
   [bean5328
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptRuleRequest)]
   (clojure.core/let
    [v5330
     (:rule-set-name m5329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5330 :com.palletops.awaze.client-builder/undef)
     (. bean5328 setRuleSetName (clojure.core/str v5330))))
   (clojure.core/let
    [v5330
     (:rule-name m5329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5330 :com.palletops.awaze.client-builder/undef)
     (. bean5328 setRuleName (clojure.core/str v5330))))
   bean5328))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest}
reorder-receipt-rule-set-request
  [m5332]
  (clojure.core/let
   [bean5331
    (new
     com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest)]
   (clojure.core/let
    [v5333
     (:rule-set-name m5332 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5333 :com.palletops.awaze.client-builder/undef)
     (. bean5331 setRuleSetName (clojure.core/str v5333))))
   (clojure.core/let
    [v5333
     (:rule-names m5332 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5333 :com.palletops.awaze.client-builder/undef)
     (.
      bean5331
      setRuleNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5400] (clojure.core/str arg5400))
 v5333))))
   bean5331))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptRuleSetRequest}
delete-receipt-rule-set-request
  [m5335]
  (clojure.core/let
   [bean5334
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptRuleSetRequest)]
   (clojure.core/let
    [v5336
     (:rule-set-name m5335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5336 :com.palletops.awaze.client-builder/undef)
     (. bean5334 setRuleSetName (clojure.core/str v5336))))
   bean5334))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CloneReceiptRuleSetRequest}
clone-receipt-rule-set-request
  [m5338]
  (clojure.core/let
   [bean5337
    (new
     com.amazonaws.services.simpleemail.model.CloneReceiptRuleSetRequest)]
   (clojure.core/let
    [v5339
     (:rule-set-name m5338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5339 :com.palletops.awaze.client-builder/undef)
     (. bean5337 setRuleSetName (clojure.core/str v5339))))
   (clojure.core/let
    [v5339
     (:original-rule-set-name
      m5338
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5339 :com.palletops.awaze.client-builder/undef)
     (. bean5337 setOriginalRuleSetName (clojure.core/str v5339))))
   bean5337))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendBounceRequest}
send-bounce-request
  [m5341]
  (clojure.core/let
   [bean5340
    (new com.amazonaws.services.simpleemail.model.SendBounceRequest)]
   (clojure.core/let
    [v5342
     (:bounce-sender-arn
      m5341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (. bean5340 setBounceSenderArn (clojure.core/str v5342))))
   (clojure.core/let
    [v5342
     (:original-message-id
      m5341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (. bean5340 setOriginalMessageId (clojure.core/str v5342))))
   (clojure.core/let
    [v5342
     (:bounced-recipient-info-list
      m5341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (.
      bean5340
      setBouncedRecipientInfoList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg5401]
  (simpleemail/bounced-recipient-info arg5401))
 v5342))))
   (clojure.core/let
    [v5342
     (:bounce-sender m5341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (. bean5340 setBounceSender (clojure.core/str v5342))))
   (clojure.core/let
    [v5342
     (:explanation m5341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (. bean5340 setExplanation (clojure.core/str v5342))))
   (clojure.core/let
    [v5342
     (:message-dsn m5341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (. bean5340 setMessageDsn (simpleemail/message-dsn v5342))))
   bean5340))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityPolicyRequest}
delete-identity-policy-request
  [m5344]
  (clojure.core/let
   [bean5343
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityPolicyRequest)]
   (clojure.core/let
    [v5345
     (:identity m5344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5345 :com.palletops.awaze.client-builder/undef)
     (. bean5343 setIdentity (clojure.core/str v5345))))
   (clojure.core/let
    [v5345
     (:policy-name m5344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5345 :com.palletops.awaze.client-builder/undef)
     (. bean5343 setPolicyName (clojure.core/str v5345))))
   bean5343))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest}
get-send-statistics-request
  [m5347]
  (clojure.core/let
   [bean5346
    (new
     com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest)]
   bean5346))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest}
get-identity-dkim-attributes-request
  [m5350]
  (clojure.core/let
   [bean5349
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest)]
   (clojure.core/let
    [v5351
     (:identities m5350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (.
      bean5349
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5402] (clojure.core/str arg5402))
 v5351))))
   bean5349))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityMailFromDomainAttributesRequest}
get-identity-mail-from-domain-attributes-request
  [m5353]
  (clojure.core/let
   [bean5352
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityMailFromDomainAttributesRequest)]
   (clojure.core/let
    [v5354
     (:identities m5353 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5354 :com.palletops.awaze.client-builder/undef)
     (.
      bean5352
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5403] (clojure.core/str arg5403))
 v5354))))
   bean5352))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest}
delete-verified-email-address-request
  [m5356]
  (clojure.core/let
   [bean5355
    (new
     com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest)]
   (clojure.core/let
    [v5357
     (:email-address m5356 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5357 :com.palletops.awaze.client-builder/undef)
     (. bean5355 setEmailAddress (clojure.core/str v5357))))
   bean5355))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest}
create-receipt-rule-request
  [m5359]
  (clojure.core/let
   [bean5358
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest)]
   (clojure.core/let
    [v5360
     (:rule-set-name m5359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5360 :com.palletops.awaze.client-builder/undef)
     (. bean5358 setRuleSetName (clojure.core/str v5360))))
   (clojure.core/let
    [v5360 (:rule m5359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5360 :com.palletops.awaze.client-builder/undef)
     (. bean5358 setRule (simpleemail/receipt-rule v5360))))
   (clojure.core/let
    [v5360 (:after m5359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5360 :com.palletops.awaze.client-builder/undef)
     (. bean5358 setAfter (clojure.core/str v5360))))
   bean5358))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeReceiptRuleSetRequest}
describe-receipt-rule-set-request
  [m5362]
  (clojure.core/let
   [bean5361
    (new
     com.amazonaws.services.simpleemail.model.DescribeReceiptRuleSetRequest)]
   (clojure.core/let
    [v5363
     (:rule-set-name m5362 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5363 :com.palletops.awaze.client-builder/undef)
     (. bean5361 setRuleSetName (clojure.core/str v5363))))
   bean5361))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest}
get-identity-policies-request
  [m5365]
  (clojure.core/let
   [bean5364
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest)]
   (clojure.core/let
    [v5366
     (:policy-names m5365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5366 :com.palletops.awaze.client-builder/undef)
     (.
      bean5364
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5404] (clojure.core/str arg5404))
 v5366))))
   (clojure.core/let
    [v5366
     (:identity m5365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5366 :com.palletops.awaze.client-builder/undef)
     (. bean5364 setIdentity (clojure.core/str v5366))))
   bean5364))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.UpdateReceiptRuleRequest}
update-receipt-rule-request
  [m5368]
  (clojure.core/let
   [bean5367
    (new
     com.amazonaws.services.simpleemail.model.UpdateReceiptRuleRequest)]
   (clojure.core/let
    [v5369
     (:rule-set-name m5368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setRuleSetName (clojure.core/str v5369))))
   (clojure.core/let
    [v5369 (:rule m5368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setRule (simpleemail/receipt-rule v5369))))
   bean5367))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetReceiptRulePositionRequest}
set-receipt-rule-position-request
  [m5371]
  (clojure.core/let
   [bean5370
    (new
     com.amazonaws.services.simpleemail.model.SetReceiptRulePositionRequest)]
   (clojure.core/let
    [v5372
     (:rule-set-name m5371 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5372 :com.palletops.awaze.client-builder/undef)
     (. bean5370 setRuleSetName (clojure.core/str v5372))))
   (clojure.core/let
    [v5372
     (:rule-name m5371 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5372 :com.palletops.awaze.client-builder/undef)
     (. bean5370 setRuleName (clojure.core/str v5372))))
   (clojure.core/let
    [v5372 (:after m5371 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5372 :com.palletops.awaze.client-builder/undef)
     (. bean5370 setAfter (clojure.core/str v5372))))
   bean5370))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest}
set-identity-dkim-enabled-request
  [m5374]
  (clojure.core/let
   [bean5373
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest)]
   (clojure.core/let
    [v5375
     (:identity m5374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5375 :com.palletops.awaze.client-builder/undef)
     (. bean5373 setIdentity (clojure.core/str v5375))))
   (clojure.core/let
    [v5375
     (:dkim-enabled m5374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5375 :com.palletops.awaze.client-builder/undef)
     (. bean5373 setDkimEnabled (clojure.core/boolean v5375))))
   bean5373))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendEmailRequest}
send-email-request
  [m5377]
  (clojure.core/let
   [bean5376
    (new com.amazonaws.services.simpleemail.model.SendEmailRequest)]
   (clojure.core/let
    [v5378 (:source m5377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (. bean5376 setSource (clojure.core/str v5378))))
   (clojure.core/let
    [v5378
     (:destination m5377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (. bean5376 setDestination (simpleemail/destination v5378))))
   (clojure.core/let
    [v5378
     (:reply-to-addresses
      m5377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (.
      bean5376
      setReplyToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5405] (clojure.core/str arg5405))
 v5378))))
   (clojure.core/let
    [v5378
     (:return-path m5377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (. bean5376 setReturnPath (clojure.core/str v5378))))
   (clojure.core/let
    [v5378
     (:source-arn m5377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (. bean5376 setSourceArn (clojure.core/str v5378))))
   (clojure.core/let
    [v5378
     (:return-path-arn
      m5377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (. bean5376 setReturnPathArn (clojure.core/str v5378))))
   (clojure.core/let
    [v5378 (:message m5377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (. bean5376 setMessage (simpleemail/message v5378))))
   bean5376))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest}
set-identity-feedback-forwarding-enabled-request
  [m5380]
  (clojure.core/let
   [bean5379
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest)]
   (clojure.core/let
    [v5381
     (:identity m5380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5381 :com.palletops.awaze.client-builder/undef)
     (. bean5379 setIdentity (clojure.core/str v5381))))
   (clojure.core/let
    [v5381
     (:forwarding-enabled
      m5380
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5381 :com.palletops.awaze.client-builder/undef)
     (. bean5379 setForwardingEnabled (clojure.core/boolean v5381))))
   bean5379))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendRawEmailRequest}
send-raw-email-request
  [m5383]
  (clojure.core/let
   [bean5382
    (new com.amazonaws.services.simpleemail.model.SendRawEmailRequest)]
   (clojure.core/let
    [v5384 (:source m5383 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (. bean5382 setSource (clojure.core/str v5384))))
   (clojure.core/let
    [v5384
     (:source-arn m5383 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (. bean5382 setSourceArn (clojure.core/str v5384))))
   (clojure.core/let
    [v5384
     (:return-path-arn
      m5383
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (. bean5382 setReturnPathArn (clojure.core/str v5384))))
   (clojure.core/let
    [v5384
     (:destinations m5383 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (.
      bean5382
      setDestinations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5510] (clojure.core/str arg5510))
 v5384))))
   (clojure.core/let
    [v5384
     (:raw-message m5383 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (. bean5382 setRawMessage (simpleemail/raw-message v5384))))
   (clojure.core/let
    [v5384
     (:from-arn m5383 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (. bean5382 setFromArn (clojure.core/str v5384))))
   bean5382))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetActiveReceiptRuleSetRequest}
set-active-receipt-rule-set-request
  [m5386]
  (clojure.core/let
   [bean5385
    (new
     com.amazonaws.services.simpleemail.model.SetActiveReceiptRuleSetRequest)]
   (clojure.core/let
    [v5387
     (:rule-set-name m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setRuleSetName (clojure.core/str v5387))))
   bean5385))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentitiesRequest}
list-identities-request
  [m5389]
  (clojure.core/let
   [bean5388
    (new
     com.amazonaws.services.simpleemail.model.ListIdentitiesRequest)]
   (clojure.core/let
    [v5390
     (:next-token m5389 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5390 :com.palletops.awaze.client-builder/undef)
     (. bean5388 setNextToken (clojure.core/str v5390))))
   (clojure.core/let
    [v5390
     (:identity-type m5389 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5390 :com.palletops.awaze.client-builder/undef)
     (. bean5388 setIdentityType (simpleemail/identity-type v5390))))
   (clojure.core/let
    [v5390
     (:max-items m5389 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5390 :com.palletops.awaze.client-builder/undef)
     (. bean5388 setMaxItems (clojure.core/int v5390))))
   bean5388))
 (clojure.core/defmulti
  simpleemail
  (clojure.core/fn
   simpleemail
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-receipt-rule-sets
   [m5406]
   (clojure.core/let
    [credentials5407 (:credentials m5406) args5408 (:args m5406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5409
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5407)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5409
       listReceiptRuleSets
       (simpleemail/list-receipt-rule-sets-request
        (clojure.core/nth args5408 0)))))))
  (clojure.core/defn
   list-receipt-rule-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listReceiptRuleSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-receipt-rule-sets,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-receipt-rule-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listReceiptRuleSets"}
   [credentials5411 & args5412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5413
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5411)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5413
      listReceiptRuleSets
      (simpleemail/list-receipt-rule-sets-request
       (clojure.core/nth args5412 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-address
   [m5414]
   (clojure.core/let
    [credentials5415 (:credentials m5414) args5416 (:args m5414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5417
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5415)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5417
       verifyEmailAddress
       (simpleemail/verify-email-address-request
        (clojure.core/nth args5416 0)))))))
  (clojure.core/defn
   verify-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyEmailAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-email-address,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-email-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyEmailAddress"}
   [credentials5419 & args5420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5421
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5419)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5421
      verifyEmailAddress
      (simpleemail/verify-email-address-request
       (clojure.core/nth args5420 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-active-receipt-rule-set
   [m5422]
   (clojure.core/let
    [credentials5423 (:credentials m5422) args5424 (:args m5422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5425
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5425
       describeActiveReceiptRuleSet
       (simpleemail/describe-active-receipt-rule-set-request
        (clojure.core/nth args5424 0)))))))
  (clojure.core/defn
   describe-active-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeActiveReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-active-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-active-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeActiveReceiptRuleSet"}
   [credentials5427 & args5428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5429
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5429
      describeActiveReceiptRuleSet
      (simpleemail/describe-active-receipt-rule-set-request
       (clojure.core/nth args5428 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-receipt-filters
   [m5430]
   (clojure.core/let
    [credentials5431 (:credentials m5430) args5432 (:args m5430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5433
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5433
       listReceiptFilters
       (simpleemail/list-receipt-filters-request
        (clojure.core/nth args5432 0)))))))
  (clojure.core/defn
   list-receipt-filters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listReceiptFilters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-receipt-filters,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-receipt-filters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listReceiptFilters"}
   [credentials5435 & args5436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5437
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5437
      listReceiptFilters
      (simpleemail/list-receipt-filters-request
       (clojure.core/nth args5436 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity
   [m5438]
   (clojure.core/let
    [credentials5439 (:credentials m5438) args5440 (:args m5438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5441
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5441
       deleteIdentity
       (simpleemail/delete-identity-request
        (clojure.core/nth args5440 0)))))))
  (clojure.core/defn
   delete-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIdentity"}
   [credentials5443 & args5444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5445
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5445
      deleteIdentity
      (simpleemail/delete-identity-request
       (clojure.core/nth args5444 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-identity
   [m5446]
   (clojure.core/let
    [credentials5447 (:credentials m5446) args5448 (:args m5446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5449
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5449
       verifyEmailIdentity
       (simpleemail/verify-email-identity-request
        (clojure.core/nth args5448 0)))))))
  (clojure.core/defn
   verify-email-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyEmailIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-email-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-email-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyEmailIdentity"}
   [credentials5451 & args5452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5453
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5453
      verifyEmailIdentity
      (simpleemail/verify-email-identity-request
       (clojure.core/nth args5452 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-verified-email-addresses
   [m5454]
   (clojure.core/let
    [credentials5455 (:credentials m5454) args5456 (:args m5454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5457
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5455)]
     (clojure.core/case
      (clojure.core/count args5456)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5457
        listVerifiedEmailAddresses
        (simpleemail/list-verified-email-addresses-request
         (clojure.core/nth args5456 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5457
        listVerifiedEmailAddresses))))))
  (clojure.core/defn
   list-verified-email-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-verified-email-addresses,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-verified-email-addresses,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-verified-email-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   [credentials5459 & args5460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5461
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5459)]
    (clojure.core/case
     (clojure.core/count args5460)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5461
       listVerifiedEmailAddresses
       (simpleemail/list-verified-email-addresses-request
        (clojure.core/nth args5460 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5461
       listVerifiedEmailAddresses))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-receipt-rule
   [m5462]
   (clojure.core/let
    [credentials5463 (:credentials m5462) args5464 (:args m5462)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5465
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5463)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5465
       describeReceiptRule
       (simpleemail/describe-receipt-rule-request
        (clojure.core/nth args5464 0)))))))
  (clojure.core/defn
   describe-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for describeReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call describeReceiptRule"}
   [credentials5467 & args5468]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5469
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5467)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5469
      describeReceiptRule
      (simpleemail/describe-receipt-rule-request
       (clojure.core/nth args5468 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-filter
   [m5470]
   (clojure.core/let
    [credentials5471 (:credentials m5470) args5472 (:args m5470)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5473
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5471)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5473
       deleteReceiptFilter
       (simpleemail/delete-receipt-filter-request
        (clojure.core/nth args5472 0)))))))
  (clojure.core/defn
   delete-receipt-filter-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filter-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReceiptFilter"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-filter,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-filter
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filter-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReceiptFilter"}
   [credentials5475 & args5476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5477
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5475)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5477
      deleteReceiptFilter
      (simpleemail/delete-receipt-filter-request
       (clojure.core/nth args5476 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-verification-attributes
   [m5478]
   (clojure.core/let
    [credentials5479 (:credentials m5478) args5480 (:args m5478)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5481
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5479)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5481
       getIdentityVerificationAttributes
       (simpleemail/get-identity-verification-attributes-request
        (clojure.core/nth args5480 0)))))))
  (clojure.core/defn
   get-identity-verification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityVerificationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-verification-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-verification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityVerificationAttributes"}
   [credentials5483 & args5484]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5485
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5483)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5485
      getIdentityVerificationAttributes
      (simpleemail/get-identity-verification-attributes-request
       (clojure.core/nth args5484 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-quota
   [m5486]
   (clojure.core/let
    [credentials5487 (:credentials m5486) args5488 (:args m5486)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5489
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5487)]
     (clojure.core/case
      (clojure.core/count args5488)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5489
        getSendQuota
        (simpleemail/get-send-quota-request
         (clojure.core/nth args5488 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5489
        getSendQuota))))))
  (clojure.core/defn
   get-send-quota-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getSendQuota, getSendQuota"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-send-quota,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-send-quota,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-send-quota
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getSendQuota, getSendQuota"}
   [credentials5491 & args5492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5493
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5491)]
    (clojure.core/case
     (clojure.core/count args5492)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5493
       getSendQuota
       (simpleemail/get-send-quota-request
        (clojure.core/nth args5492 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5493
       getSendQuota))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-rule-set
   [m5494]
   (clojure.core/let
    [credentials5495 (:credentials m5494) args5496 (:args m5494)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5497
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5495)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5497
       createReceiptRuleSet
       (simpleemail/create-receipt-rule-set-request
        (clojure.core/nth args5496 0)))))))
  (clojure.core/defn
   create-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptRuleSet"}
   [credentials5499 & args5500]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5501
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5499)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5501
      createReceiptRuleSet
      (simpleemail/create-receipt-rule-set-request
       (clojure.core/nth args5500 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-notification-topic
   [m5502]
   (clojure.core/let
    [credentials5503 (:credentials m5502) args5504 (:args m5502)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5505
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5503)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5505
       setIdentityNotificationTopic
       (simpleemail/set-identity-notification-topic-request
        (clojure.core/nth args5504 0)))))))
  (clojure.core/defn
   set-identity-notification-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         sns-topic
                         notification-type
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setIdentityNotificationTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-notification-topic,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-notification-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         sns-topic
                         notification-type
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setIdentityNotificationTopic"}
   [credentials5507 & args5508]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5509
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5507)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5509
      setIdentityNotificationTopic
      (simpleemail/set-identity-notification-topic-request
       (clojure.core/nth args5508 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-identity
   [m5511]
   (clojure.core/let
    [credentials5512 (:credentials m5511) args5513 (:args m5511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5514
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5512)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5514
       verifyDomainIdentity
       (simpleemail/verify-domain-identity-request
        (clojure.core/nth args5513 0)))))))
  (clojure.core/defn
   verify-domain-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyDomainIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-domain-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-domain-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyDomainIdentity"}
   [credentials5516 & args5517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5518
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5516)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5518
      verifyDomainIdentity
      (simpleemail/verify-domain-identity-request
       (clojure.core/nth args5517 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identity-policies
   [m5519]
   (clojure.core/let
    [credentials5520 (:credentials m5519) args5521 (:args m5519)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5522
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5520)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5522
       listIdentityPolicies
       (simpleemail/list-identity-policies-request
        (clojure.core/nth args5521 0)))))))
  (clojure.core/defn
   list-identity-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listIdentityPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-identity-policies,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-identity-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listIdentityPolicies"}
   [credentials5524 & args5525]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5526
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5524)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5526
      listIdentityPolicies
      (simpleemail/list-identity-policies-request
       (clojure.core/nth args5525 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-filter
   [m5527]
   (clojure.core/let
    [credentials5528 (:credentials m5527) args5529 (:args m5527)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5530
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5528)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5530
       createReceiptFilter
       (simpleemail/create-receipt-filter-request
        (clojure.core/nth args5529 0)))))))
  (clojure.core/defn
   create-receipt-filter-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptFilter"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-filter,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-filter
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptFilter"}
   [credentials5532 & args5533]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5534
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5532)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5534
      createReceiptFilter
      (simpleemail/create-receipt-filter-request
       (clojure.core/nth args5533 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :put-identity-policy
   [m5535]
   (clojure.core/let
    [credentials5536 (:credentials m5535) args5537 (:args m5535)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5538
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5536)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5538
       putIdentityPolicy
       (simpleemail/put-identity-policy-request
        (clojure.core/nth args5537 0)))))))
  (clojure.core/defn
   put-identity-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putIdentityPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-identity-policy,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   put-identity-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putIdentityPolicy"}
   [credentials5540 & args5541]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5542
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5540)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5542
      putIdentityPolicy
      (simpleemail/put-identity-policy-request
       (clojure.core/nth args5541 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-dkim
   [m5543]
   (clojure.core/let
    [credentials5544 (:credentials m5543) args5545 (:args m5543)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5546
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5544)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5546
       verifyDomainDkim
       (simpleemail/verify-domain-dkim-request
        (clojure.core/nth args5545 0)))))))
  (clojure.core/defn
   verify-domain-dkim-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyDomainDkim"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-domain-dkim,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-domain-dkim
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyDomainDkim"}
   [credentials5548 & args5549]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5550
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5548)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5550
      verifyDomainDkim
      (simpleemail/verify-domain-dkim-request
       (clojure.core/nth args5549 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-mail-from-domain
   [m5551]
   (clojure.core/let
    [credentials5552 (:credentials m5551) args5553 (:args m5551)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5554
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5552)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5554
       setIdentityMailFromDomain
       (simpleemail/set-identity-mail-from-domain-request
        (clojure.core/nth args5553 0)))))))
  (clojure.core/defn
   set-identity-mail-from-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         behavior-on-mxfailure
                         clone-root
                         mail-from-domain]}]]),
    :doc "Generate map for setIdentityMailFromDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-mail-from-domain,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-mail-from-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         behavior-on-mxfailure
                         clone-root
                         mail-from-domain]}]]),
    :doc "Call setIdentityMailFromDomain"}
   [credentials5556 & args5557]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5558
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5556)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5558
      setIdentityMailFromDomain
      (simpleemail/set-identity-mail-from-domain-request
       (clojure.core/nth args5557 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-notification-attributes
   [m5559]
   (clojure.core/let
    [credentials5560 (:credentials m5559) args5561 (:args m5559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5562
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5560)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5562
       getIdentityNotificationAttributes
       (simpleemail/get-identity-notification-attributes-request
        (clojure.core/nth args5561 0)))))))
  (clojure.core/defn
   get-identity-notification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityNotificationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-notification-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-notification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityNotificationAttributes"}
   [credentials5564 & args5565]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5566
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5564)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5566
      getIdentityNotificationAttributes
      (simpleemail/get-identity-notification-attributes-request
       (clojure.core/nth args5565 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-rule
   [m5567]
   (clojure.core/let
    [credentials5568 (:credentials m5567) args5569 (:args m5567)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5570
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5568)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5570
       deleteReceiptRule
       (simpleemail/delete-receipt-rule-request
        (clojure.core/nth args5569 0)))))))
  (clojure.core/defn
   delete-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for deleteReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call deleteReceiptRule"}
   [credentials5572 & args5573]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5574
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5572)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5574
      deleteReceiptRule
      (simpleemail/delete-receipt-rule-request
       (clojure.core/nth args5573 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :reorder-receipt-rule-set
   [m5575]
   (clojure.core/let
    [credentials5576 (:credentials m5575) args5577 (:args m5575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5578
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5576)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5578
       reorderReceiptRuleSet
       (simpleemail/reorder-receipt-rule-set-request
        (clojure.core/nth args5577 0)))))))
  (clojure.core/defn
   reorder-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         rule-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reorderReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reorder-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   reorder-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         rule-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reorderReceiptRuleSet"}
   [credentials5580 & args5581]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5582
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5580)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5582
      reorderReceiptRuleSet
      (simpleemail/reorder-receipt-rule-set-request
       (clojure.core/nth args5581 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-rule-set
   [m5583]
   (clojure.core/let
    [credentials5584 (:credentials m5583) args5585 (:args m5583)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5586
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5584)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5586
       deleteReceiptRuleSet
       (simpleemail/delete-receipt-rule-set-request
        (clojure.core/nth args5585 0)))))))
  (clojure.core/defn
   delete-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReceiptRuleSet"}
   [credentials5588 & args5589]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5590
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5588)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5590
      deleteReceiptRuleSet
      (simpleemail/delete-receipt-rule-set-request
       (clojure.core/nth args5589 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :clone-receipt-rule-set
   [m5591]
   (clojure.core/let
    [credentials5592 (:credentials m5591) args5593 (:args m5591)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5594
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5592)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5594
       cloneReceiptRuleSet
       (simpleemail/clone-receipt-rule-set-request
        (clojure.core/nth args5593 0)))))))
  (clojure.core/defn
   clone-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         original-rule-set-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cloneReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :clone-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   clone-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         original-rule-set-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cloneReceiptRuleSet"}
   [credentials5596 & args5597]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5598
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5596)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5598
      cloneReceiptRuleSet
      (simpleemail/clone-receipt-rule-set-request
       (clojure.core/nth args5597 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-bounce
   [m5599]
   (clojure.core/let
    [credentials5600 (:credentials m5599) args5601 (:args m5599)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5602
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5600)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5602
       sendBounce
       (simpleemail/send-bounce-request (clojure.core/nth args5601 0)))))))
  (clojure.core/defn
   send-bounce-map
   {:arglists (quote
               [[credentials
                 {:keys [explanation
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bounce-sender
                         read-limit
                         bounced-recipient-info-list
                         general-progress-listener
                         message-dsn
                         original-message-id
                         clone-source
                         clone-root
                         bounce-sender-arn]}]]),
    :doc "Generate map for sendBounce"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-bounce,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-bounce
   {:arglists (quote
               [[credentials
                 {:keys [explanation
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bounce-sender
                         read-limit
                         bounced-recipient-info-list
                         general-progress-listener
                         message-dsn
                         original-message-id
                         clone-source
                         clone-root
                         bounce-sender-arn]}]]),
    :doc "Call sendBounce"}
   [credentials5604 & args5605]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5606
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5604)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5606
      sendBounce
      (simpleemail/send-bounce-request (clojure.core/nth args5605 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity-policy
   [m5607]
   (clojure.core/let
    [credentials5608 (:credentials m5607) args5609 (:args m5607)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5610
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5608)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5610
       deleteIdentityPolicy
       (simpleemail/delete-identity-policy-request
        (clojure.core/nth args5609 0)))))))
  (clojure.core/defn
   delete-identity-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIdentityPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-identity-policy,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-identity-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIdentityPolicy"}
   [credentials5612 & args5613]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5614
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5612)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5614
      deleteIdentityPolicy
      (simpleemail/delete-identity-policy-request
       (clojure.core/nth args5613 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-statistics
   [m5615]
   (clojure.core/let
    [credentials5616 (:credentials m5615) args5617 (:args m5615)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5618
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5616)]
     (clojure.core/case
      (clojure.core/count args5617)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5618
        getSendStatistics))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5618
        getSendStatistics
        (simpleemail/get-send-statistics-request
         (clojure.core/nth args5617 0))))))))
  (clojure.core/defn
   get-send-statistics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSendStatistics, getSendStatistics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-send-statistics,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-send-statistics,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-send-statistics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSendStatistics, getSendStatistics"}
   [credentials5620 & args5621]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5622
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5620)]
    (clojure.core/case
     (clojure.core/count args5621)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5622
       getSendStatistics))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5622
       getSendStatistics
       (simpleemail/get-send-statistics-request
        (clojure.core/nth args5621 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-dkim-attributes
   [m5623]
   (clojure.core/let
    [credentials5624 (:credentials m5623) args5625 (:args m5623)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5626
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5624)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5626
       getIdentityDkimAttributes
       (simpleemail/get-identity-dkim-attributes-request
        (clojure.core/nth args5625 0)))))))
  (clojure.core/defn
   get-identity-dkim-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityDkimAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-dkim-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-dkim-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityDkimAttributes"}
   [credentials5628 & args5629]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5630
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5628)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5630
      getIdentityDkimAttributes
      (simpleemail/get-identity-dkim-attributes-request
       (clojure.core/nth args5629 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-mail-from-domain-attributes
   [m5631]
   (clojure.core/let
    [credentials5632 (:credentials m5631) args5633 (:args m5631)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5634
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5632)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5634
       getIdentityMailFromDomainAttributes
       (simpleemail/get-identity-mail-from-domain-attributes-request
        (clojure.core/nth args5633 0)))))))
  (clojure.core/defn
   get-identity-mail-from-domain-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityMailFromDomainAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-mail-from-domain-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-mail-from-domain-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityMailFromDomainAttributes"}
   [credentials5636 & args5637]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5638
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5636)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5638
      getIdentityMailFromDomainAttributes
      (simpleemail/get-identity-mail-from-domain-attributes-request
       (clojure.core/nth args5637 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-verified-email-address
   [m5639]
   (clojure.core/let
    [credentials5640 (:credentials m5639) args5641 (:args m5639)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5642
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5640)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5642
       deleteVerifiedEmailAddress
       (simpleemail/delete-verified-email-address-request
        (clojure.core/nth args5641 0)))))))
  (clojure.core/defn
   delete-verified-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVerifiedEmailAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-verified-email-address,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-verified-email-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVerifiedEmailAddress"}
   [credentials5644 & args5645]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5646
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5644)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5646
      deleteVerifiedEmailAddress
      (simpleemail/delete-verified-email-address-request
       (clojure.core/nth args5645 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-rule
   [m5647]
   (clojure.core/let
    [credentials5648 (:credentials m5647) args5649 (:args m5647)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5650
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5648)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5650
       createReceiptRule
       (simpleemail/create-receipt-rule-request
        (clojure.core/nth args5649 0)))))))
  (clojure.core/defn
   create-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptRule"}
   [credentials5652 & args5653]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5654
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5652)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5654
      createReceiptRule
      (simpleemail/create-receipt-rule-request
       (clojure.core/nth args5653 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-receipt-rule-set
   [m5655]
   (clojure.core/let
    [credentials5656 (:credentials m5655) args5657 (:args m5655)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5658
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5656)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5658
       describeReceiptRuleSet
       (simpleemail/describe-receipt-rule-set-request
        (clojure.core/nth args5657 0)))))))
  (clojure.core/defn
   describe-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReceiptRuleSet"}
   [credentials5660 & args5661]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5662
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5660)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5662
      describeReceiptRuleSet
      (simpleemail/describe-receipt-rule-set-request
       (clojure.core/nth args5661 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-policies
   [m5663]
   (clojure.core/let
    [credentials5664 (:credentials m5663) args5665 (:args m5663)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5666
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5664)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5666
       getIdentityPolicies
       (simpleemail/get-identity-policies-request
        (clojure.core/nth args5665 0)))))))
  (clojure.core/defn
   get-identity-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getIdentityPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-policies,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getIdentityPolicies"}
   [credentials5668 & args5669]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5670
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5668)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5670
      getIdentityPolicies
      (simpleemail/get-identity-policies-request
       (clojure.core/nth args5669 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :update-receipt-rule
   [m5671]
   (clojure.core/let
    [credentials5672 (:credentials m5671) args5673 (:args m5671)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5674
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5672)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5674
       updateReceiptRule
       (simpleemail/update-receipt-rule-request
        (clojure.core/nth args5673 0)))))))
  (clojure.core/defn
   update-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   update-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateReceiptRule"}
   [credentials5676 & args5677]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5678
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5676)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5678
      updateReceiptRule
      (simpleemail/update-receipt-rule-request
       (clojure.core/nth args5677 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-receipt-rule-position
   [m5679]
   (clojure.core/let
    [credentials5680 (:credentials m5679) args5681 (:args m5679)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5682
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5680)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5682
       setReceiptRulePosition
       (simpleemail/set-receipt-rule-position-request
        (clojure.core/nth args5681 0)))))))
  (clojure.core/defn
   set-receipt-rule-position-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for setReceiptRulePosition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-receipt-rule-position,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-receipt-rule-position
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call setReceiptRulePosition"}
   [credentials5684 & args5685]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5686
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5684)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5686
      setReceiptRulePosition
      (simpleemail/set-receipt-rule-position-request
       (clojure.core/nth args5685 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-dkim-enabled
   [m5687]
   (clojure.core/let
    [credentials5688 (:credentials m5687) args5689 (:args m5687)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5690
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5688)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5690
       setIdentityDkimEnabled
       (simpleemail/set-identity-dkim-enabled-request
        (clojure.core/nth args5689 0)))))))
  (clojure.core/defn
   set-identity-dkim-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dkim-enabled
                         clone-root]}]]),
    :doc "Generate map for setIdentityDkimEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-dkim-enabled,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-dkim-enabled
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dkim-enabled
                         clone-root]}]]),
    :doc "Call setIdentityDkimEnabled"}
   [credentials5692 & args5693]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5694
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5692)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5694
      setIdentityDkimEnabled
      (simpleemail/set-identity-dkim-enabled-request
       (clojure.core/nth args5693 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-email
   [m5695]
   (clojure.core/let
    [credentials5696 (:credentials m5695) args5697 (:args m5695)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5698
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5696)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5698
       sendEmail
       (simpleemail/send-email-request (clojure.core/nth args5697 0)))))))
  (clojure.core/defn
   send-email-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         reply-to-addresses
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         clone-root
                         destination
                         return-path
                         message]}]]),
    :doc "Generate map for sendEmail"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-email,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-email
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         reply-to-addresses
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         clone-root
                         destination
                         return-path
                         message]}]]),
    :doc "Call sendEmail"}
   [credentials5700 & args5701]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5702
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5700)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5702
      sendEmail
      (simpleemail/send-email-request (clojure.core/nth args5701 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-feedback-forwarding-enabled
   [m5703]
   (clojure.core/let
    [credentials5704 (:credentials m5703) args5705 (:args m5703)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5706
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5704)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5706
       setIdentityFeedbackForwardingEnabled
       (simpleemail/set-identity-feedback-forwarding-enabled-request
        (clojure.core/nth args5705 0)))))))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         forwarding-enabled
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setIdentityFeedbackForwardingEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-feedback-forwarding-enabled,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         forwarding-enabled
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setIdentityFeedbackForwardingEnabled"}
   [credentials5708 & args5709]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5710
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5708)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5710
      setIdentityFeedbackForwardingEnabled
      (simpleemail/set-identity-feedback-forwarding-enabled-request
       (clojure.core/nth args5709 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-raw-email
   [m5711]
   (clojure.core/let
    [credentials5712 (:credentials m5711) args5713 (:args m5711)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5714
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5712)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5714
       sendRawEmail
       (simpleemail/send-raw-email-request
        (clojure.core/nth args5713 0)))))))
  (clojure.core/defn
   send-raw-email-map
   {:arglists (quote
               [[credentials
                 {:keys [destinations
                         custom-request-headers
                         sdk-client-execution-timeout
                         from-arn
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         raw-message
                         clone-root]}]]),
    :doc "Generate map for sendRawEmail"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-raw-email,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-raw-email
   {:arglists (quote
               [[credentials
                 {:keys [destinations
                         custom-request-headers
                         sdk-client-execution-timeout
                         from-arn
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         raw-message
                         clone-root]}]]),
    :doc "Call sendRawEmail"}
   [credentials5716 & args5717]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5718
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5716)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5718
      sendRawEmail
      (simpleemail/send-raw-email-request
       (clojure.core/nth args5717 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-active-receipt-rule-set
   [m5719]
   (clojure.core/let
    [credentials5720 (:credentials m5719) args5721 (:args m5719)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5722
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5720)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5722
       setActiveReceiptRuleSet
       (simpleemail/set-active-receipt-rule-set-request
        (clojure.core/nth args5721 0)))))))
  (clojure.core/defn
   set-active-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setActiveReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-active-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-active-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setActiveReceiptRuleSet"}
   [credentials5724 & args5725]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5726
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5724)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5726
      setActiveReceiptRuleSet
      (simpleemail/set-active-receipt-rule-set-request
       (clojure.core/nth args5725 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identities
   [m5727]
   (clojure.core/let
    [credentials5728 (:credentials m5727) args5729 (:args m5727)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5730
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5728)]
     (clojure.core/case
      (clojure.core/count args5729)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5730
        listIdentities
        (simpleemail/list-identities-request
         (clojure.core/nth args5729 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5730
        listIdentities))))))
  (clojure.core/defn
   list-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         identity-type
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listIdentities, listIdentities"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-identities,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-identities,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         identity-type
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listIdentities, listIdentities"}
   [credentials5732 & args5733]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5734
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5732)]
    (clojure.core/case
     (clojure.core/count args5733)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5734
       listIdentities
       (simpleemail/list-identities-request
        (clojure.core/nth args5733 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5734
       listIdentities)))))))
