(ns
 com.palletops.awaze.simpledb
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpledb :as simpledb]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableAttribute}
replaceable-attribute
  [m8713]
  (clojure.core/let
   [bean8712
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/let
    [v8714 (:replace m8713 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8714 :com.palletops.awaze.client-builder/undef)
     (. bean8712 setReplace (clojure.core/boolean v8714))))
   (clojure.core/let
    [v8714 (:name m8713 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8714 :com.palletops.awaze.client-builder/undef)
     (. bean8712 setName (clojure.core/str v8714))))
   (clojure.core/let
    [v8714 (:value m8713 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8714 :com.palletops.awaze.client-builder/undef)
     (. bean8712 setValue (clojure.core/str v8714))))
   bean8712))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.Attribute}
attribute
  [m8716]
  (clojure.core/let
   [bean8715 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/let
    [v8717
     (:alternate-name-encoding
      m8716
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8717 :com.palletops.awaze.client-builder/undef)
     (. bean8715 setAlternateNameEncoding (clojure.core/str v8717))))
   (clojure.core/let
    [v8717
     (:alternate-value-encoding
      m8716
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8717 :com.palletops.awaze.client-builder/undef)
     (. bean8715 setAlternateValueEncoding (clojure.core/str v8717))))
   (clojure.core/let
    [v8717 (:name m8716 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8717 :com.palletops.awaze.client-builder/undef)
     (. bean8715 setName (clojure.core/str v8717))))
   (clojure.core/let
    [v8717 (:value m8716 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8717 :com.palletops.awaze.client-builder/undef)
     (. bean8715 setValue (clojure.core/str v8717))))
   bean8715))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableItem}
replaceable-item
  [m8719]
  (clojure.core/let
   [bean8718
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/let
    [v8720
     (:attributes m8719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8720 :com.palletops.awaze.client-builder/undef)
     (.
      bean8718
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8757] (simpledb/replaceable-attribute arg8757))
 v8720))))
   (clojure.core/let
    [v8720 (:name m8719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8720 :com.palletops.awaze.client-builder/undef)
     (. bean8718 setName (clojure.core/str v8720))))
   bean8718))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeletableItem}
deletable-item
  [m8722]
  (clojure.core/let
   [bean8721
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/let
    [v8723
     (:attributes m8722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8723 :com.palletops.awaze.client-builder/undef)
     (.
      bean8721
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8758] (simpledb/attribute arg8758))
 v8723))))
   (clojure.core/let
    [v8723 (:name m8722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8723 :com.palletops.awaze.client-builder/undef)
     (. bean8721 setName (clojure.core/str v8723))))
   bean8721))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.UpdateCondition}
update-condition
  [m8725]
  (clojure.core/let
   [bean8724
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/let
    [v8726 (:exists m8725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8726 :com.palletops.awaze.client-builder/undef)
     (. bean8724 setExists (clojure.core/boolean v8726))))
   (clojure.core/let
    [v8726 (:name m8725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8726 :com.palletops.awaze.client-builder/undef)
     (. bean8724 setName (clojure.core/str v8726))))
   (clojure.core/let
    [v8726 (:value m8725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8726 :com.palletops.awaze.client-builder/undef)
     (. bean8724 setValue (clojure.core/str v8726))))
   bean8724))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ListDomainsRequest}
list-domains-request
  [m8728]
  (clojure.core/let
   [bean8727
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/let
    [v8729
     (:next-token m8728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8729 :com.palletops.awaze.client-builder/undef)
     (. bean8727 setNextToken (clojure.core/str v8729))))
   (clojure.core/let
    [v8729
     (:max-number-of-domains
      m8728
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8729 :com.palletops.awaze.client-builder/undef)
     (. bean8727 setMaxNumberOfDomains (clojure.core/int v8729))))
   bean8727))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteDomainRequest}
delete-domain-request
  [m8731]
  (clojure.core/let
   [bean8730
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/let
    [v8732
     (:domain-name m8731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setDomainName (clojure.core/str v8732))))
   bean8730))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DomainMetadataRequest}
domain-metadata-request
  [m8734]
  (clojure.core/let
   [bean8733
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/let
    [v8735
     (:domain-name m8734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8735 :com.palletops.awaze.client-builder/undef)
     (. bean8733 setDomainName (clojure.core/str v8735))))
   bean8733))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchPutAttributesRequest}
batch-put-attributes-request
  [m8737]
  (clojure.core/let
   [bean8736
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/let
    [v8738
     (:domain-name m8737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8738 :com.palletops.awaze.client-builder/undef)
     (. bean8736 setDomainName (clojure.core/str v8738))))
   (clojure.core/let
    [v8738 (:items m8737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8738 :com.palletops.awaze.client-builder/undef)
     (.
      bean8736
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8759] (simpledb/replaceable-item arg8759))
 v8738))))
   bean8736))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest}
batch-delete-attributes-request
  [m8740]
  (clojure.core/let
   [bean8739
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/let
    [v8741
     (:domain-name m8740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8741 :com.palletops.awaze.client-builder/undef)
     (. bean8739 setDomainName (clojure.core/str v8741))))
   (clojure.core/let
    [v8741 (:items m8740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8741 :com.palletops.awaze.client-builder/undef)
     (.
      bean8739
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8760] (simpledb/deletable-item arg8760))
 v8741))))
   bean8739))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.GetAttributesRequest}
get-attributes-request
  [m8743]
  (clojure.core/let
   [bean8742
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/let
    [v8744
     (:domain-name m8743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (. bean8742 setDomainName (clojure.core/str v8744))))
   (clojure.core/let
    [v8744
     (:attribute-names
      m8743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (.
      bean8742
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8761] (clojure.core/str arg8761))
 v8744))))
   (clojure.core/let
    [v8744
     (:item-name m8743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (. bean8742 setItemName (clojure.core/str v8744))))
   (clojure.core/let
    [v8744
     (:consistent-read
      m8743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (. bean8742 setConsistentRead (clojure.core/boolean v8744))))
   bean8742))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.PutAttributesRequest}
put-attributes-request
  [m8746]
  (clojure.core/let
   [bean8745
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/let
    [v8747
     (:attributes m8746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8747 :com.palletops.awaze.client-builder/undef)
     (.
      bean8745
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8762] (simpledb/replaceable-attribute arg8762))
 v8747))))
   (clojure.core/let
    [v8747
     (:domain-name m8746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8747 :com.palletops.awaze.client-builder/undef)
     (. bean8745 setDomainName (clojure.core/str v8747))))
   (clojure.core/let
    [v8747
     (:item-name m8746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8747 :com.palletops.awaze.client-builder/undef)
     (. bean8745 setItemName (clojure.core/str v8747))))
   (clojure.core/let
    [v8747
     (:expected m8746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8747 :com.palletops.awaze.client-builder/undef)
     (. bean8745 setExpected (simpledb/update-condition v8747))))
   bean8745))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteAttributesRequest}
delete-attributes-request
  [m8749]
  (clojure.core/let
   [bean8748
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/let
    [v8750
     (:attributes m8749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8750 :com.palletops.awaze.client-builder/undef)
     (.
      bean8748
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8763] (simpledb/attribute arg8763))
 v8750))))
   (clojure.core/let
    [v8750
     (:domain-name m8749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8750 :com.palletops.awaze.client-builder/undef)
     (. bean8748 setDomainName (clojure.core/str v8750))))
   (clojure.core/let
    [v8750
     (:item-name m8749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8750 :com.palletops.awaze.client-builder/undef)
     (. bean8748 setItemName (clojure.core/str v8750))))
   (clojure.core/let
    [v8750
     (:expected m8749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8750 :com.palletops.awaze.client-builder/undef)
     (. bean8748 setExpected (simpledb/update-condition v8750))))
   bean8748))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.CreateDomainRequest}
create-domain-request
  [m8752]
  (clojure.core/let
   [bean8751
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/let
    [v8753
     (:domain-name m8752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (. bean8751 setDomainName (clojure.core/str v8753))))
   bean8751))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.SelectRequest}
select-request
  [m8755]
  (clojure.core/let
   [bean8754
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/let
    [v8756
     (:next-token m8755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (. bean8754 setNextToken (clojure.core/str v8756))))
   (clojure.core/let
    [v8756
     (:select-expression
      m8755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (. bean8754 setSelectExpression (clojure.core/str v8756))))
   (clojure.core/let
    [v8756
     (:consistent-read
      m8755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (. bean8754 setConsistentRead (clojure.core/boolean v8756))))
   bean8754))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m8764]
   (clojure.core/let
    [credentials8765 (:credentials m8764) args8766 (:args m8764)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8767
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8765)]
     (clojure.core/case
      (clojure.core/count args8766)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8767
        listDomains
        (simpledb/list-domains-request (clojure.core/nth args8766 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8767
        listDomains))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-domains,
     :credentials credentials__1842__auto__,
     :client :simpledb})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-domains,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listDomains, listDomains"}
   [credentials8769 & args8770]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8771
     (com.palletops.awaze.common/aws-client :simpledb credentials8769)]
    (clojure.core/case
     (clojure.core/count args8770)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8771
       listDomains
       (simpledb/list-domains-request (clojure.core/nth args8770 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8771
       listDomains))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m8772]
   (clojure.core/let
    [credentials8773 (:credentials m8772) args8774 (:args m8772)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8775
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8773)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8775
       deleteDomain
       (simpledb/delete-domain-request (clojure.core/nth args8774 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials8777 & args8778]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8779
     (com.palletops.awaze.common/aws-client :simpledb credentials8777)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8779
      deleteDomain
      (simpledb/delete-domain-request (clojure.core/nth args8778 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m8780]
   (clojure.core/let
    [credentials8781 (:credentials m8780) args8782 (:args m8780)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8783
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8781)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8783
       domainMetadata
       (simpledb/domain-metadata-request
        (clojure.core/nth args8782 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :domain-metadata,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call domainMetadata"}
   [credentials8785 & args8786]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8787
     (com.palletops.awaze.common/aws-client :simpledb credentials8785)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8787
      domainMetadata
      (simpledb/domain-metadata-request (clojure.core/nth args8786 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m8788]
   (clojure.core/let
    [credentials8789 (:credentials m8788) args8790 (:args m8788)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8791
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8789)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8791
       batchPutAttributes
       (simpledb/batch-put-attributes-request
        (clojure.core/nth args8790 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :batch-put-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchPutAttributes"}
   [credentials8793 & args8794]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8795
     (com.palletops.awaze.common/aws-client :simpledb credentials8793)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8795
      batchPutAttributes
      (simpledb/batch-put-attributes-request
       (clojure.core/nth args8794 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m8796]
   (clojure.core/let
    [credentials8797 (:credentials m8796) args8798 (:args m8796)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8799
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8797)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8799
       batchDeleteAttributes
       (simpledb/batch-delete-attributes-request
        (clojure.core/nth args8798 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :batch-delete-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials8801 & args8802]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8803
     (com.palletops.awaze.common/aws-client :simpledb credentials8801)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8803
      batchDeleteAttributes
      (simpledb/batch-delete-attributes-request
       (clojure.core/nth args8802 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m8804]
   (clojure.core/let
    [credentials8805 (:credentials m8804) args8806 (:args m8804)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8807
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8805)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8807
       getAttributes
       (simpledb/get-attributes-request (clojure.core/nth args8806 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAttributes"}
   [credentials8809 & args8810]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8811
     (com.palletops.awaze.common/aws-client :simpledb credentials8809)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8811
      getAttributes
      (simpledb/get-attributes-request (clojure.core/nth args8810 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m8812]
   (clojure.core/let
    [credentials8813 (:credentials m8812) args8814 (:args m8812)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8815
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8813)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8815
       putAttributes
       (simpledb/put-attributes-request (clojure.core/nth args8814 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call putAttributes"}
   [credentials8817 & args8818]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8819
     (com.palletops.awaze.common/aws-client :simpledb credentials8817)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8819
      putAttributes
      (simpledb/put-attributes-request (clojure.core/nth args8818 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m8820]
   (clojure.core/let
    [credentials8821 (:credentials m8820) args8822 (:args m8820)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8823
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8821)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8823
       deleteAttributes
       (simpledb/delete-attributes-request
        (clojure.core/nth args8822 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call deleteAttributes"}
   [credentials8825 & args8826]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8827
     (com.palletops.awaze.common/aws-client :simpledb credentials8825)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8827
      deleteAttributes
      (simpledb/delete-attributes-request
       (clojure.core/nth args8826 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m8828]
   (clojure.core/let
    [credentials8829 (:credentials m8828) args8830 (:args m8828)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8831
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8829)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8831
       createDomain
       (simpledb/create-domain-request (clojure.core/nth args8830 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8833 & args8834]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8835
     (com.palletops.awaze.common/aws-client :simpledb credentials8833)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8835
      createDomain
      (simpledb/create-domain-request (clojure.core/nth args8834 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m8836]
   (clojure.core/let
    [credentials8837 (:credentials m8836) args8838 (:args m8836)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8839
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8837)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8839
       select
       (simpledb/select-request (clojure.core/nth args8838 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for select"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :select,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call select"}
   [credentials8841 & args8842]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8843
     (com.palletops.awaze.common/aws-client :simpledb credentials8841)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8843
      select
      (simpledb/select-request (clojure.core/nth args8842 0))))))))
