(ns
 com.palletops.awaze.route53
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.route53 :as route53]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AliasTarget}
alias-target
  [m11136]
  (clojure.core/let
   [bean11135 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/let
    [v11137
     (:hosted-zone-id
      m11136
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11137 :com.palletops.awaze.client-builder/undef)
     (. bean11135 setHostedZoneId (clojure.core/str v11137))))
   (clojure.core/let
    [v11137
     (:evaluate-target-health
      m11136
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11137 :com.palletops.awaze.client-builder/undef)
     (.
      bean11135
      setEvaluateTargetHealth
      (clojure.core/boolean v11137))))
   (clojure.core/let
    [v11137
     (:dnsname m11136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11137 :com.palletops.awaze.client-builder/undef)
     (. bean11135 setDNSName (clojure.core/str v11137))))
   bean11135))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSetRegion}
resource-record-set-region
  [m11139]
  (.
   com.amazonaws.services.route53.model.ResourceRecordSetRegion
   fromValue
   (clojure.core/name m11139)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSetFailover}
resource-record-set-failover
  [m11142]
  (.
   com.amazonaws.services.route53.model.ResourceRecordSetFailover
   fromValue
   (clojure.core/name m11142)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecord}
resource-record
  [m11145]
  (clojure.core/let
   [bean11144
    (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/let
    [v11146 (:value m11145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11146 :com.palletops.awaze.client-builder/undef)
     (. bean11144 setValue (clojure.core/str v11146))))
   bean11144))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GeoLocation}
geo-location
  [m11148]
  (clojure.core/let
   [bean11147 (new com.amazonaws.services.route53.model.GeoLocation)]
   (clojure.core/let
    [v11149
     (:continent-code
      m11148
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11149 :com.palletops.awaze.client-builder/undef)
     (. bean11147 setContinentCode (clojure.core/str v11149))))
   (clojure.core/let
    [v11149
     (:country-code m11148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11149 :com.palletops.awaze.client-builder/undef)
     (. bean11147 setCountryCode (clojure.core/str v11149))))
   (clojure.core/let
    [v11149
     (:subdivision-code
      m11148
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11149 :com.palletops.awaze.client-builder/undef)
     (. bean11147 setSubdivisionCode (clojure.core/str v11149))))
   bean11147))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSet}
resource-record-set
  [m11151]
  (clojure.core/let
   [bean11150
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/let
    [v11152
     (:alias-target m11151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (. bean11150 setAliasTarget (route53/alias-target v11152))))
   (clojure.core/let
    [v11152
     (:region m11151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (.
      bean11150
      setRegion
      (route53/resource-record-set-region v11152))))
   (clojure.core/let
    [v11152
     (:failover m11151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (.
      bean11150
      setFailover
      (route53/resource-record-set-failover v11152))))
   (clojure.core/let
    [v11152
     (:set-identifier
      m11151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (. bean11150 setSetIdentifier (clojure.core/str v11152))))
   (clojure.core/let
    [v11152
     (:traffic-policy-instance-id
      m11151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (.
      bean11150
      setTrafficPolicyInstanceId
      (clojure.core/str v11152))))
   (clojure.core/let
    [v11152 (:type m11151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (. bean11150 setType (clojure.core/str v11152))))
   (clojure.core/let
    [v11152 (:name m11151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (. bean11150 setName (clojure.core/str v11152))))
   (clojure.core/let
    [v11152
     (:weight m11151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (. bean11150 setWeight (clojure.core/long v11152))))
   (clojure.core/let
    [v11152 (:ttl m11151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (. bean11150 setTTL (clojure.core/long v11152))))
   (clojure.core/let
    [v11152
     (:health-check-id
      m11151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (. bean11150 setHealthCheckId (clojure.core/str v11152))))
   (clojure.core/let
    [v11152
     (:resource-records
      m11151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (.
      bean11150
      setResourceRecords
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11324] (route53/resource-record arg11324))
 v11152))))
   (clojure.core/let
    [v11152
     (:geo-location m11151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11152 :com.palletops.awaze.client-builder/undef)
     (. bean11150 setGeoLocation (route53/geo-location v11152))))
   bean11150))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Change}
change
  [m11154]
  (clojure.core/let
   [bean11153 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/let
    [v11155
     (:resource-record-set
      m11154
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11155 :com.palletops.awaze.client-builder/undef)
     (.
      bean11153
      setResourceRecordSet
      (route53/resource-record-set v11155))))
   (clojure.core/let
    [v11155
     (:action m11154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11155 :com.palletops.awaze.client-builder/undef)
     (. bean11153 setAction (clojure.core/str v11155))))
   bean11153))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPCRegion}
vpcregion
  [m11157]
  (.
   com.amazonaws.services.route53.model.VPCRegion
   fromValue
   (clojure.core/name m11157)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeBatch}
change-batch
  [m11160]
  (clojure.core/let
   [bean11159 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/let
    [v11161
     (:comment m11160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11161 :com.palletops.awaze.client-builder/undef)
     (. bean11159 setComment (clojure.core/str v11161))))
   (clojure.core/let
    [v11161
     (:changes m11160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11161 :com.palletops.awaze.client-builder/undef)
     (.
      bean11159
      setChanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11325] (route53/change arg11325))
 v11161))))
   bean11159))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.RRType}
rrtype
  [m11163]
  (.
   com.amazonaws.services.route53.model.RRType
   fromValue
   (clojure.core/name m11163)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPC}
vpc
  [m11166]
  (clojure.core/let
   [bean11165 (new com.amazonaws.services.route53.model.VPC)]
   (clojure.core/let
    [v11167
     (:vpcregion m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setVPCRegion (route53/vpcregion v11167))))
   (clojure.core/let
    [v11167 (:vpcid m11166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11167 :com.palletops.awaze.client-builder/undef)
     (. bean11165 setVPCId (clojure.core/str v11167))))
   bean11165))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.TagResourceType}
tag-resource-type
  [m11169]
  (.
   com.amazonaws.services.route53.model.TagResourceType
   fromValue
   (clojure.core/name m11169)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HostedZoneConfig}
hosted-zone-config
  [m11172]
  (clojure.core/let
   [bean11171
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/let
    [v11173
     (:comment m11172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11173 :com.palletops.awaze.client-builder/undef)
     (. bean11171 setComment (clojure.core/str v11173))))
   (clojure.core/let
    [v11173
     (:private-zone m11172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11173 :com.palletops.awaze.client-builder/undef)
     (. bean11171 setPrivateZone (clojure.core/boolean v11173))))
   bean11171))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckConfig}
health-check-config
  [m11175]
  (clojure.core/let
   [bean11174
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/let
    [v11176
     (:inverted m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setInverted (clojure.core/boolean v11176))))
   (clojure.core/let
    [v11176 (:type m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setType (clojure.core/str v11176))))
   (clojure.core/let
    [v11176
     (:resource-path m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setResourcePath (clojure.core/str v11176))))
   (clojure.core/let
    [v11176
     (:search-string m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setSearchString (clojure.core/str v11176))))
   (clojure.core/let
    [v11176
     (:child-health-checks
      m11175
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (.
      bean11174
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11326] (clojure.core/str arg11326))
 v11176))))
   (clojure.core/let
    [v11176 (:port m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setPort (clojure.core/int v11176))))
   (clojure.core/let
    [v11176
     (:health-threshold
      m11175
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setHealthThreshold (clojure.core/int v11176))))
   (clojure.core/let
    [v11176
     (:request-interval
      m11175
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setRequestInterval (clojure.core/int v11176))))
   (clojure.core/let
    [v11176
     (:ipaddress m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setIPAddress (clojure.core/str v11176))))
   (clojure.core/let
    [v11176
     (:fully-qualified-domain-name
      m11175
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (.
      bean11174
      setFullyQualifiedDomainName
      (clojure.core/str v11176))))
   (clojure.core/let
    [v11176
     (:enable-sni m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setEnableSNI (clojure.core/boolean v11176))))
   (clojure.core/let
    [v11176
     (:measure-latency
      m11175
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setMeasureLatency (clojure.core/boolean v11176))))
   (clojure.core/let
    [v11176
     (:failure-threshold
      m11175
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setFailureThreshold (clojure.core/int v11176))))
   bean11174))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Tag}
tag
  [m11178]
  (clojure.core/let
   [bean11177 (new com.amazonaws.services.route53.model.Tag)]
   (clojure.core/let
    [v11179 (:key m11178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11179 :com.palletops.awaze.client-builder/undef)
     (. bean11177 setKey (clojure.core/str v11179))))
   (clojure.core/let
    [v11179 (:value m11178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11179 :com.palletops.awaze.client-builder/undef)
     (. bean11177 setValue (clojure.core/str v11179))))
   bean11177))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest}
create-traffic-policy-version-request
  [m11181]
  (clojure.core/let
   [bean11180
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest)]
   (clojure.core/let
    [v11182
     (:comment m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setComment (clojure.core/str v11182))))
   (clojure.core/let
    [v11182
     (:document m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setDocument (clojure.core/str v11182))))
   (clojure.core/let
    [v11182 (:id m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setId (clojure.core/str v11182))))
   bean11180))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest}
delete-traffic-policy-request
  [m11184]
  (clojure.core/let
   [bean11183
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest)]
   (clojure.core/let
    [v11185
     (:version m11184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11185 :com.palletops.awaze.client-builder/undef)
     (. bean11183 setVersion (clojure.core/int v11185))))
   (clojure.core/let
    [v11185 (:id m11184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11185 :com.palletops.awaze.client-builder/undef)
     (. bean11183 setId (clojure.core/str v11185))))
   bean11183))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest}
change-resource-record-sets-request
  [m11187]
  (clojure.core/let
   [bean11186
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/let
    [v11188
     (:hosted-zone-id
      m11187
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11188 :com.palletops.awaze.client-builder/undef)
     (. bean11186 setHostedZoneId (clojure.core/str v11188))))
   (clojure.core/let
    [v11188
     (:change-batch m11187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11188 :com.palletops.awaze.client-builder/undef)
     (. bean11186 setChangeBatch (route53/change-batch v11188))))
   bean11186))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPoliciesRequest}
list-traffic-policies-request
  [m11190]
  (clojure.core/let
   [bean11189
    (new
     com.amazonaws.services.route53.model.ListTrafficPoliciesRequest)]
   (clojure.core/let
    [v11191
     (:traffic-policy-id-marker
      m11190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setTrafficPolicyIdMarker (clojure.core/str v11191))))
   (clojure.core/let
    [v11191
     (:max-items m11190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11191 :com.palletops.awaze.client-builder/undef)
     (. bean11189 setMaxItems (clojure.core/str v11191))))
   bean11189))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest}
list-traffic-policy-instances-by-policy-request
  [m11193]
  (clojure.core/let
   [bean11192
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest)]
   (clojure.core/let
    [v11194
     (:traffic-policy-id
      m11193
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (. bean11192 setTrafficPolicyId (clojure.core/str v11194))))
   (clojure.core/let
    [v11194
     (:traffic-policy-version
      m11193
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (. bean11192 setTrafficPolicyVersion (clojure.core/int v11194))))
   (clojure.core/let
    [v11194
     (:traffic-policy-instance-name-marker
      m11193
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (.
      bean11192
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11194))))
   (clojure.core/let
    [v11194
     (:traffic-policy-instance-type-marker
      m11193
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (.
      bean11192
      setTrafficPolicyInstanceTypeMarker
      (route53/rrtype v11194))))
   (clojure.core/let
    [v11194
     (:hosted-zone-id-marker
      m11193
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (. bean11192 setHostedZoneIdMarker (clojure.core/str v11194))))
   (clojure.core/let
    [v11194
     (:max-items m11193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (. bean11192 setMaxItems (clojure.core/str v11194))))
   bean11192))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest}
list-traffic-policy-versions-request
  [m11196]
  (clojure.core/let
   [bean11195
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest)]
   (clojure.core/let
    [v11197
     (:traffic-policy-version-marker
      m11196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11197 :com.palletops.awaze.client-builder/undef)
     (.
      bean11195
      setTrafficPolicyVersionMarker
      (clojure.core/str v11197))))
   (clojure.core/let
    [v11197
     (:max-items m11196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11197 :com.palletops.awaze.client-builder/undef)
     (. bean11195 setMaxItems (clojure.core/str v11197))))
   (clojure.core/let
    [v11197 (:id m11196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11197 :com.palletops.awaze.client-builder/undef)
     (. bean11195 setId (clojure.core/str v11197))))
   bean11195))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest}
list-traffic-policy-instances-by-hosted-zone-request
  [m11199]
  (clojure.core/let
   [bean11198
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest)]
   (clojure.core/let
    [v11200
     (:hosted-zone-id
      m11199
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11200 :com.palletops.awaze.client-builder/undef)
     (. bean11198 setHostedZoneId (clojure.core/str v11200))))
   (clojure.core/let
    [v11200
     (:traffic-policy-instance-name-marker
      m11199
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11200 :com.palletops.awaze.client-builder/undef)
     (.
      bean11198
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11200))))
   (clojure.core/let
    [v11200
     (:traffic-policy-instance-type-marker
      m11199
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11200 :com.palletops.awaze.client-builder/undef)
     (.
      bean11198
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11200))))
   (clojure.core/let
    [v11200
     (:max-items m11199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11200 :com.palletops.awaze.client-builder/undef)
     (. bean11198 setMaxItems (clojure.core/str v11200))))
   bean11198))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest}
delete-reusable-delegation-set-request
  [m11202]
  (clojure.core/let
   [bean11201
    (new
     com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest)]
   (clojure.core/let
    [v11203 (:id m11202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11203 :com.palletops.awaze.client-builder/undef)
     (. bean11201 setId (clojure.core/str v11203))))
   bean11201))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetReusableDelegationSetRequest}
get-reusable-delegation-set-request
  [m11205]
  (clojure.core/let
   [bean11204
    (new
     com.amazonaws.services.route53.model.GetReusableDelegationSetRequest)]
   (clojure.core/let
    [v11206 (:id m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setId (clojure.core/str v11206))))
   bean11204))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHostedZoneRequest}
delete-hosted-zone-request
  [m11208]
  (clojure.core/let
   [bean11207
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/let
    [v11209 (:id m11208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (. bean11207 setId (clojure.core/str v11209))))
   bean11207))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest}
associate-vpcwith-hosted-zone-request
  [m11211]
  (clojure.core/let
   [bean11210
    (new
     com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest)]
   (clojure.core/let
    [v11212
     (:comment m11211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (. bean11210 setComment (clojure.core/str v11212))))
   (clojure.core/let
    [v11212
     (:hosted-zone-id
      m11211
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (. bean11210 setHostedZoneId (clojure.core/str v11212))))
   (clojure.core/let
    [v11212 (:vpc m11211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (. bean11210 setVPC (route53/vpc v11212))))
   bean11210))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesRequest}
list-hosted-zones-request
  [m11214]
  (clojure.core/let
   [bean11213
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/let
    [v11215
     (:delegation-set-id
      m11214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (. bean11213 setDelegationSetId (clojure.core/str v11215))))
   (clojure.core/let
    [v11215
     (:marker m11214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (. bean11213 setMarker (clojure.core/str v11215))))
   (clojure.core/let
    [v11215
     (:max-items m11214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (. bean11213 setMaxItems (clojure.core/str v11215))))
   bean11213))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest}
list-reusable-delegation-sets-request
  [m11217]
  (clojure.core/let
   [bean11216
    (new
     com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest)]
   (clojure.core/let
    [v11218
     (:marker m11217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11218 :com.palletops.awaze.client-builder/undef)
     (. bean11216 setMarker (clojure.core/str v11218))))
   (clojure.core/let
    [v11218
     (:max-items m11217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11218 :com.palletops.awaze.client-builder/undef)
     (. bean11216 setMaxItems (clojure.core/str v11218))))
   bean11216))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest}
delete-traffic-policy-instance-request
  [m11220]
  (clojure.core/let
   [bean11219
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11221 (:id m11220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11221 :com.palletops.awaze.client-builder/undef)
     (. bean11219 setId (clojure.core/str v11221))))
   bean11219))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckRequest}
get-health-check-request
  [m11223]
  (clojure.core/let
   [bean11222
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/let
    [v11224
     (:health-check-id
      m11223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11224 :com.palletops.awaze.client-builder/undef)
     (. bean11222 setHealthCheckId (clojure.core/str v11224))))
   bean11222))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourcesRequest}
list-tags-for-resources-request
  [m11226]
  (clojure.core/let
   [bean11225
    (new
     com.amazonaws.services.route53.model.ListTagsForResourcesRequest)]
   (clojure.core/let
    [v11227
     (:resource-ids m11226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11227 :com.palletops.awaze.client-builder/undef)
     (.
      bean11225
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11327] (clojure.core/str arg11327))
 v11227))))
   (clojure.core/let
    [v11227
     (:resource-type m11226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11227 :com.palletops.awaze.client-builder/undef)
     (. bean11225 setResourceType (route53/tag-resource-type v11227))))
   bean11225))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetCheckerIpRangesRequest}
get-checker-ip-ranges-request
  [m11229]
  (clojure.core/let
   [bean11228
    (new
     com.amazonaws.services.route53.model.GetCheckerIpRangesRequest)]
   bean11228))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHostedZoneRequest}
create-hosted-zone-request
  [m11232]
  (clojure.core/let
   [bean11231
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/let
    [v11233 (:vpc m11232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11233 :com.palletops.awaze.client-builder/undef)
     (. bean11231 setVPC (route53/vpc v11233))))
   (clojure.core/let
    [v11233
     (:caller-reference
      m11232
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11233 :com.palletops.awaze.client-builder/undef)
     (. bean11231 setCallerReference (clojure.core/str v11233))))
   (clojure.core/let
    [v11233
     (:hosted-zone-config
      m11232
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11233 :com.palletops.awaze.client-builder/undef)
     (.
      bean11231
      setHostedZoneConfig
      (route53/hosted-zone-config v11233))))
   (clojure.core/let
    [v11233
     (:delegation-set-id
      m11232
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11233 :com.palletops.awaze.client-builder/undef)
     (. bean11231 setDelegationSetId (clojure.core/str v11233))))
   (clojure.core/let
    [v11233 (:name m11232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11233 :com.palletops.awaze.client-builder/undef)
     (. bean11231 setName (clojure.core/str v11233))))
   bean11231))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest}
list-change-batches-by-hosted-zone-request
  [m11235]
  (clojure.core/let
   [bean11234
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest)]
   (clojure.core/let
    [v11236
     (:hosted-zone-id
      m11235
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11236 :com.palletops.awaze.client-builder/undef)
     (. bean11234 setHostedZoneId (clojure.core/str v11236))))
   (clojure.core/let
    [v11236
     (:marker m11235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11236 :com.palletops.awaze.client-builder/undef)
     (. bean11234 setMarker (clojure.core/str v11236))))
   (clojure.core/let
    [v11236
     (:max-items m11235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11236 :com.palletops.awaze.client-builder/undef)
     (. bean11234 setMaxItems (clojure.core/str v11236))))
   (clojure.core/let
    [v11236
     (:end-date m11235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11236 :com.palletops.awaze.client-builder/undef)
     (. bean11234 setEndDate (clojure.core/str v11236))))
   (clojure.core/let
    [v11236
     (:start-date m11235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11236 :com.palletops.awaze.client-builder/undef)
     (. bean11234 setStartDate (clojure.core/str v11236))))
   bean11234))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHealthCheckRequest}
update-health-check-request
  [m11238]
  (clojure.core/let
   [bean11237
    (new
     com.amazonaws.services.route53.model.UpdateHealthCheckRequest)]
   (clojure.core/let
    [v11239
     (:inverted m11238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setInverted (clojure.core/boolean v11239))))
   (clojure.core/let
    [v11239
     (:resource-path m11238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setResourcePath (clojure.core/str v11239))))
   (clojure.core/let
    [v11239
     (:search-string m11238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setSearchString (clojure.core/str v11239))))
   (clojure.core/let
    [v11239
     (:health-check-id
      m11238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setHealthCheckId (clojure.core/str v11239))))
   (clojure.core/let
    [v11239
     (:child-health-checks
      m11238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (.
      bean11237
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11328] (clojure.core/str arg11328))
 v11239))))
   (clojure.core/let
    [v11239 (:port m11238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setPort (clojure.core/int v11239))))
   (clojure.core/let
    [v11239
     (:health-check-version
      m11238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setHealthCheckVersion (clojure.core/long v11239))))
   (clojure.core/let
    [v11239
     (:health-threshold
      m11238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setHealthThreshold (clojure.core/int v11239))))
   (clojure.core/let
    [v11239
     (:ipaddress m11238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setIPAddress (clojure.core/str v11239))))
   (clojure.core/let
    [v11239
     (:fully-qualified-domain-name
      m11238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (.
      bean11237
      setFullyQualifiedDomainName
      (clojure.core/str v11239))))
   (clojure.core/let
    [v11239
     (:enable-sni m11238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setEnableSNI (clojure.core/boolean v11239))))
   (clojure.core/let
    [v11239
     (:failure-threshold
      m11238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setFailureThreshold (clojure.core/int v11239))))
   bean11237))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest}
get-health-check-last-failure-reason-request
  [m11241]
  (clojure.core/let
   [bean11240
    (new
     com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest)]
   (clojure.core/let
    [v11242
     (:health-check-id
      m11241
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11242 :com.palletops.awaze.client-builder/undef)
     (. bean11240 setHealthCheckId (clojure.core/str v11242))))
   bean11240))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHealthCheckRequest}
create-health-check-request
  [m11244]
  (clojure.core/let
   [bean11243
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/let
    [v11245
     (:caller-reference
      m11244
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11245 :com.palletops.awaze.client-builder/undef)
     (. bean11243 setCallerReference (clojure.core/str v11245))))
   (clojure.core/let
    [v11245
     (:health-check-config
      m11244
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11245 :com.palletops.awaze.client-builder/undef)
     (.
      bean11243
      setHealthCheckConfig
      (route53/health-check-config v11245))))
   bean11243))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest}
create-traffic-policy-instance-request
  [m11247]
  (clojure.core/let
   [bean11246
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11248
     (:hosted-zone-id
      m11247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setHostedZoneId (clojure.core/str v11248))))
   (clojure.core/let
    [v11248 (:ttl m11247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setTTL (clojure.core/long v11248))))
   (clojure.core/let
    [v11248
     (:traffic-policy-id
      m11247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setTrafficPolicyId (clojure.core/str v11248))))
   (clojure.core/let
    [v11248
     (:traffic-policy-version
      m11247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setTrafficPolicyVersion (clojure.core/int v11248))))
   (clojure.core/let
    [v11248 (:name m11247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setName (clojure.core/str v11248))))
   bean11246))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeDetailsRequest}
get-change-details-request
  [m11250]
  (clojure.core/let
   [bean11249
    (new com.amazonaws.services.route53.model.GetChangeDetailsRequest)]
   (clojure.core/let
    [v11251 (:id m11250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11251 :com.palletops.awaze.client-builder/undef)
     (. bean11249 setId (clojure.core/str v11251))))
   bean11249))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyRequest}
create-traffic-policy-request
  [m11253]
  (clojure.core/let
   [bean11252
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyRequest)]
   (clojure.core/let
    [v11254
     (:comment m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setComment (clojure.core/str v11254))))
   (clojure.core/let
    [v11254
     (:document m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setDocument (clojure.core/str v11254))))
   (clojure.core/let
    [v11254 (:name m11253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setName (clojure.core/str v11254))))
   bean11252))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeTagsForResourceRequest}
change-tags-for-resource-request
  [m11256]
  (clojure.core/let
   [bean11255
    (new
     com.amazonaws.services.route53.model.ChangeTagsForResourceRequest)]
   (clojure.core/let
    [v11257
     (:add-tags m11256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11257 :com.palletops.awaze.client-builder/undef)
     (.
      bean11255
      setAddTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11329] (route53/tag arg11329))
 v11257))))
   (clojure.core/let
    [v11257
     (:remove-tag-keys
      m11256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11257 :com.palletops.awaze.client-builder/undef)
     (.
      bean11255
      setRemoveTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11330] (clojure.core/str arg11330))
 v11257))))
   (clojure.core/let
    [v11257
     (:resource-id m11256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11257 :com.palletops.awaze.client-builder/undef)
     (. bean11255 setResourceId (clojure.core/str v11257))))
   (clojure.core/let
    [v11257
     (:resource-type m11256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11257 :com.palletops.awaze.client-builder/undef)
     (. bean11255 setResourceType (route53/tag-resource-type v11257))))
   bean11255))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest}
get-traffic-policy-instance-count-request
  [m11259]
  (clojure.core/let
   [bean11258
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest)]
   bean11258))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckStatusRequest}
get-health-check-status-request
  [m11262]
  (clojure.core/let
   [bean11261
    (new
     com.amazonaws.services.route53.model.GetHealthCheckStatusRequest)]
   (clojure.core/let
    [v11263
     (:health-check-id
      m11262
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setHealthCheckId (clojure.core/str v11263))))
   bean11261))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeRequest}
get-change-request
  [m11265]
  (clojure.core/let
   [bean11264
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/let
    [v11266 (:id m11265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11266 :com.palletops.awaze.client-builder/undef)
     (. bean11264 setId (clojure.core/str v11266))))
   bean11264))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListGeoLocationsRequest}
list-geo-locations-request
  [m11268]
  (clojure.core/let
   [bean11267
    (new com.amazonaws.services.route53.model.ListGeoLocationsRequest)]
   (clojure.core/let
    [v11269
     (:start-continent-code
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setStartContinentCode (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:start-country-code
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setStartCountryCode (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:start-subdivision-code
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setStartSubdivisionCode (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:max-items m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setMaxItems (clojure.core/str v11269))))
   bean11267))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneCountRequest}
get-hosted-zone-count-request
  [m11271]
  (clojure.core/let
   [bean11270
    (new
     com.amazonaws.services.route53.model.GetHostedZoneCountRequest)]
   bean11270))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest}
update-hosted-zone-comment-request
  [m11274]
  (clojure.core/let
   [bean11273
    (new
     com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest)]
   (clojure.core/let
    [v11275
     (:comment m11274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11275 :com.palletops.awaze.client-builder/undef)
     (. bean11273 setComment (clojure.core/str v11275))))
   (clojure.core/let
    [v11275 (:id m11274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11275 :com.palletops.awaze.client-builder/undef)
     (. bean11273 setId (clojure.core/str v11275))))
   bean11273))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckCountRequest}
get-health-check-count-request
  [m11277]
  (clojure.core/let
   [bean11276
    (new
     com.amazonaws.services.route53.model.GetHealthCheckCountRequest)]
   bean11276))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneRequest}
get-hosted-zone-request
  [m11280]
  (clojure.core/let
   [bean11279
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/let
    [v11281 (:id m11280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11281 :com.palletops.awaze.client-builder/undef)
     (. bean11279 setId (clojure.core/str v11281))))
   bean11279))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest}
update-traffic-policy-comment-request
  [m11283]
  (clojure.core/let
   [bean11282
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest)]
   (clojure.core/let
    [v11284
     (:version m11283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setVersion (clojure.core/int v11284))))
   (clojure.core/let
    [v11284
     (:comment m11283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setComment (clojure.core/str v11284))))
   (clojure.core/let
    [v11284 (:id m11283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setId (clojure.core/str v11284))))
   bean11282))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest}
get-traffic-policy-instance-request
  [m11286]
  (clojure.core/let
   [bean11285
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11287 (:id m11286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11287 :com.palletops.awaze.client-builder/undef)
     (. bean11285 setId (clojure.core/str v11287))))
   bean11285))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesByNameRequest}
list-hosted-zones-by-name-request
  [m11289]
  (clojure.core/let
   [bean11288
    (new
     com.amazonaws.services.route53.model.ListHostedZonesByNameRequest)]
   (clojure.core/let
    [v11290
     (:hosted-zone-id
      m11289
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11290 :com.palletops.awaze.client-builder/undef)
     (. bean11288 setHostedZoneId (clojure.core/str v11290))))
   (clojure.core/let
    [v11290
     (:dnsname m11289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11290 :com.palletops.awaze.client-builder/undef)
     (. bean11288 setDNSName (clojure.core/str v11290))))
   (clojure.core/let
    [v11290
     (:max-items m11289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11290 :com.palletops.awaze.client-builder/undef)
     (. bean11288 setMaxItems (clojure.core/str v11290))))
   bean11288))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetGeoLocationRequest}
get-geo-location-request
  [m11292]
  (clojure.core/let
   [bean11291
    (new com.amazonaws.services.route53.model.GetGeoLocationRequest)]
   (clojure.core/let
    [v11293
     (:continent-code
      m11292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11293 :com.palletops.awaze.client-builder/undef)
     (. bean11291 setContinentCode (clojure.core/str v11293))))
   (clojure.core/let
    [v11293
     (:country-code m11292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11293 :com.palletops.awaze.client-builder/undef)
     (. bean11291 setCountryCode (clojure.core/str v11293))))
   (clojure.core/let
    [v11293
     (:subdivision-code
      m11292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11293 :com.palletops.awaze.client-builder/undef)
     (. bean11291 setSubdivisionCode (clojure.core/str v11293))))
   bean11291))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m11295]
  (clojure.core/let
   [bean11294
    (new
     com.amazonaws.services.route53.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v11296
     (:resource-id m11295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11296 :com.palletops.awaze.client-builder/undef)
     (. bean11294 setResourceId (clojure.core/str v11296))))
   (clojure.core/let
    [v11296
     (:resource-type m11295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11296 :com.palletops.awaze.client-builder/undef)
     (. bean11294 setResourceType (clojure.core/str v11296))))
   bean11294))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest}
create-reusable-delegation-set-request
  [m11298]
  (clojure.core/let
   [bean11297
    (new
     com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest)]
   (clojure.core/let
    [v11299
     (:hosted-zone-id
      m11298
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setHostedZoneId (clojure.core/str v11299))))
   (clojure.core/let
    [v11299
     (:caller-reference
      m11298
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setCallerReference (clojure.core/str v11299))))
   bean11297))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHealthChecksRequest}
list-health-checks-request
  [m11301]
  (clojure.core/let
   [bean11300
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/let
    [v11302
     (:marker m11301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11302 :com.palletops.awaze.client-builder/undef)
     (. bean11300 setMarker (clojure.core/str v11302))))
   (clojure.core/let
    [v11302
     (:max-items m11301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11302 :com.palletops.awaze.client-builder/undef)
     (. bean11300 setMaxItems (clojure.core/str v11302))))
   bean11300))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest}
update-traffic-policy-instance-request
  [m11304]
  (clojure.core/let
   [bean11303
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11305 (:ttl m11304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setTTL (clojure.core/long v11305))))
   (clojure.core/let
    [v11305
     (:traffic-policy-id
      m11304
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setTrafficPolicyId (clojure.core/str v11305))))
   (clojure.core/let
    [v11305
     (:traffic-policy-version
      m11304
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setTrafficPolicyVersion (clojure.core/int v11305))))
   (clojure.core/let
    [v11305 (:id m11304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setId (clojure.core/str v11305))))
   bean11303))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHealthCheckRequest}
delete-health-check-request
  [m11307]
  (clojure.core/let
   [bean11306
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/let
    [v11308
     (:health-check-id
      m11307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11308 :com.palletops.awaze.client-builder/undef)
     (. bean11306 setHealthCheckId (clojure.core/str v11308))))
   bean11306))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyRequest}
get-traffic-policy-request
  [m11310]
  (clojure.core/let
   [bean11309
    (new com.amazonaws.services.route53.model.GetTrafficPolicyRequest)]
   (clojure.core/let
    [v11311
     (:version m11310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11311 :com.palletops.awaze.client-builder/undef)
     (. bean11309 setVersion (clojure.core/int v11311))))
   (clojure.core/let
    [v11311 (:id m11310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11311 :com.palletops.awaze.client-builder/undef)
     (. bean11309 setId (clojure.core/str v11311))))
   bean11309))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest}
list-change-batches-by-rrset-request
  [m11313]
  (clojure.core/let
   [bean11312
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest)]
   (clojure.core/let
    [v11314
     (:hosted-zone-id
      m11313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setHostedZoneId (clojure.core/str v11314))))
   (clojure.core/let
    [v11314
     (:set-identifier
      m11313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setSetIdentifier (clojure.core/str v11314))))
   (clojure.core/let
    [v11314
     (:marker m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setMarker (clojure.core/str v11314))))
   (clojure.core/let
    [v11314 (:type m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setType (route53/rrtype v11314))))
   (clojure.core/let
    [v11314
     (:max-items m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setMaxItems (clojure.core/str v11314))))
   (clojure.core/let
    [v11314
     (:end-date m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setEndDate (clojure.core/str v11314))))
   (clojure.core/let
    [v11314
     (:start-date m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setStartDate (clojure.core/str v11314))))
   (clojure.core/let
    [v11314 (:name m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setName (clojure.core/str v11314))))
   bean11312))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListResourceRecordSetsRequest}
list-resource-record-sets-request
  [m11316]
  (clojure.core/let
   [bean11315
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/let
    [v11317
     (:hosted-zone-id
      m11316
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11317 :com.palletops.awaze.client-builder/undef)
     (. bean11315 setHostedZoneId (clojure.core/str v11317))))
   (clojure.core/let
    [v11317
     (:start-record-name
      m11316
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11317 :com.palletops.awaze.client-builder/undef)
     (. bean11315 setStartRecordName (clojure.core/str v11317))))
   (clojure.core/let
    [v11317
     (:start-record-type
      m11316
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11317 :com.palletops.awaze.client-builder/undef)
     (. bean11315 setStartRecordType (clojure.core/str v11317))))
   (clojure.core/let
    [v11317
     (:start-record-identifier
      m11316
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11317 :com.palletops.awaze.client-builder/undef)
     (. bean11315 setStartRecordIdentifier (clojure.core/str v11317))))
   (clojure.core/let
    [v11317
     (:max-items m11316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11317 :com.palletops.awaze.client-builder/undef)
     (. bean11315 setMaxItems (clojure.core/str v11317))))
   bean11315))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest}
disassociate-vpcfrom-hosted-zone-request
  [m11319]
  (clojure.core/let
   [bean11318
    (new
     com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest)]
   (clojure.core/let
    [v11320
     (:comment m11319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setComment (clojure.core/str v11320))))
   (clojure.core/let
    [v11320
     (:hosted-zone-id
      m11319
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setHostedZoneId (clojure.core/str v11320))))
   (clojure.core/let
    [v11320 (:vpc m11319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setVPC (route53/vpc v11320))))
   bean11318))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest}
list-traffic-policy-instances-request
  [m11322]
  (clojure.core/let
   [bean11321
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest)]
   (clojure.core/let
    [v11323
     (:traffic-policy-instance-name-marker
      m11322
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11323 :com.palletops.awaze.client-builder/undef)
     (.
      bean11321
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11323))))
   (clojure.core/let
    [v11323
     (:traffic-policy-instance-type-marker
      m11322
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11323 :com.palletops.awaze.client-builder/undef)
     (.
      bean11321
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11323))))
   (clojure.core/let
    [v11323
     (:hosted-zone-id-marker
      m11322
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11323 :com.palletops.awaze.client-builder/undef)
     (. bean11321 setHostedZoneIdMarker (clojure.core/str v11323))))
   (clojure.core/let
    [v11323
     (:max-items m11322 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11323 :com.palletops.awaze.client-builder/undef)
     (. bean11321 setMaxItems (clojure.core/str v11323))))
   bean11321))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-version
   [m11331]
   (clojure.core/let
    [credentials11332 (:credentials m11331) args11333 (:args m11331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11334
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11332)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11334
       createTrafficPolicyVersion
       (route53/create-traffic-policy-version-request
        (clojure.core/nth args11333 0)))))))
  (clojure.core/defn
   create-traffic-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-version,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicyVersion"}
   [credentials11336 & args11337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11338
     (com.palletops.awaze.common/aws-client :route53 credentials11336)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11338
      createTrafficPolicyVersion
      (route53/create-traffic-policy-version-request
       (clojure.core/nth args11337 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy
   [m11339]
   (clojure.core/let
    [credentials11340 (:credentials m11339) args11341 (:args m11339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11342
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11340)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11342
       deleteTrafficPolicy
       (route53/delete-traffic-policy-request
        (clojure.core/nth args11341 0)))))))
  (clojure.core/defn
   delete-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicy"}
   [credentials11344 & args11345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11346
     (com.palletops.awaze.common/aws-client :route53 credentials11344)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11346
      deleteTrafficPolicy
      (route53/delete-traffic-policy-request
       (clojure.core/nth args11345 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m11347]
   (clojure.core/let
    [credentials11348 (:credentials m11347) args11349 (:args m11347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11350
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11348)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11350
       changeResourceRecordSets
       (route53/change-resource-record-sets-request
        (clojure.core/nth args11349 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-resource-record-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call changeResourceRecordSets"}
   [credentials11352 & args11353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11354
     (com.palletops.awaze.common/aws-client :route53 credentials11352)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11354
      changeResourceRecordSets
      (route53/change-resource-record-sets-request
       (clojure.core/nth args11353 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policies
   [m11355]
   (clojure.core/let
    [credentials11356 (:credentials m11355) args11357 (:args m11355)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11358
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11356)]
     (clojure.core/case
      (clojure.core/count args11357)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11358
        listTrafficPolicies
        (route53/list-traffic-policies-request
         (clojure.core/nth args11357 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11358
        listTrafficPolicies))))))
  (clojure.core/defn
   list-traffic-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listTrafficPolicies, listTrafficPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-traffic-policies,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policies,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listTrafficPolicies, listTrafficPolicies"}
   [credentials11360 & args11361]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11362
     (com.palletops.awaze.common/aws-client :route53 credentials11360)]
    (clojure.core/case
     (clojure.core/count args11361)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11362
       listTrafficPolicies
       (route53/list-traffic-policies-request
        (clojure.core/nth args11361 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11362
       listTrafficPolicies))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-policy
   [m11363]
   (clojure.core/let
    [credentials11364 (:credentials m11363) args11365 (:args m11363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11366
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11364)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11366
       listTrafficPolicyInstancesByPolicy
       (route53/list-traffic-policy-instances-by-policy-request
        (clojure.core/nth args11365 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstancesByPolicy"}
   [credentials11368 & args11369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11370
     (com.palletops.awaze.common/aws-client :route53 credentials11368)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11370
      listTrafficPolicyInstancesByPolicy
      (route53/list-traffic-policy-instances-by-policy-request
       (clojure.core/nth args11369 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-versions
   [m11371]
   (clojure.core/let
    [credentials11372 (:credentials m11371) args11373 (:args m11371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11374
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11372)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11374
       listTrafficPolicyVersions
       (route53/list-traffic-policy-versions-request
        (clojure.core/nth args11373 0)))))))
  (clojure.core/defn
   list-traffic-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-versions,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyVersions"}
   [credentials11376 & args11377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11378
     (com.palletops.awaze.common/aws-client :route53 credentials11376)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11378
      listTrafficPolicyVersions
      (route53/list-traffic-policy-versions-request
       (clojure.core/nth args11377 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-hosted-zone
   [m11379]
   (clojure.core/let
    [credentials11380 (:credentials m11379) args11381 (:args m11379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11382
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11380)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11382
       listTrafficPolicyInstancesByHostedZone
       (route53/list-traffic-policy-instances-by-hosted-zone-request
        (clojure.core/nth args11381 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listTrafficPolicyInstancesByHostedZone"}
   [credentials11384 & args11385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11386
     (com.palletops.awaze.common/aws-client :route53 credentials11384)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11386
      listTrafficPolicyInstancesByHostedZone
      (route53/list-traffic-policy-instances-by-hosted-zone-request
       (clojure.core/nth args11385 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-reusable-delegation-set
   [m11387]
   (clojure.core/let
    [credentials11388 (:credentials m11387) args11389 (:args m11387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11390
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11388)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11390
       deleteReusableDelegationSet
       (route53/delete-reusable-delegation-set-request
        (clojure.core/nth args11389 0)))))))
  (clojure.core/defn
   delete-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReusableDelegationSet"}
   [credentials11392 & args11393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11394
     (com.palletops.awaze.common/aws-client :route53 credentials11392)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11394
      deleteReusableDelegationSet
      (route53/delete-reusable-delegation-set-request
       (clojure.core/nth args11393 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-reusable-delegation-set
   [m11395]
   (clojure.core/let
    [credentials11396 (:credentials m11395) args11397 (:args m11395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11398
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11398
       getReusableDelegationSet
       (route53/get-reusable-delegation-set-request
        (clojure.core/nth args11397 0)))))))
  (clojure.core/defn
   get-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getReusableDelegationSet"}
   [credentials11400 & args11401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11402
     (com.palletops.awaze.common/aws-client :route53 credentials11400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11402
      getReusableDelegationSet
      (route53/get-reusable-delegation-set-request
       (clojure.core/nth args11401 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m11403]
   (clojure.core/let
    [credentials11404 (:credentials m11403) args11405 (:args m11403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11406
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11406
       deleteHostedZone
       (route53/delete-hosted-zone-request
        (clojure.core/nth args11405 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHostedZone"}
   [credentials11408 & args11409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11410
     (com.palletops.awaze.common/aws-client :route53 credentials11408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11410
      deleteHostedZone
      (route53/delete-hosted-zone-request
       (clojure.core/nth args11409 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :associate-vpcwith-hosted-zone
   [m11411]
   (clojure.core/let
    [credentials11412 (:credentials m11411) args11413 (:args m11411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11414
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11412)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11414
       associateVPCWithHostedZone
       (route53/associate-vpcwith-hosted-zone-request
        (clojure.core/nth args11413 0)))))))
  (clojure.core/defn
   associate-vpcwith-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for associateVPCWithHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-vpcwith-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   associate-vpcwith-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call associateVPCWithHostedZone"}
   [credentials11416 & args11417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11418
     (com.palletops.awaze.common/aws-client :route53 credentials11416)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11418
      associateVPCWithHostedZone
      (route53/associate-vpcwith-hosted-zone-request
       (clojure.core/nth args11417 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m11419]
   (clojure.core/let
    [credentials11420 (:credentials m11419) args11421 (:args m11419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11422
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11420)]
     (clojure.core/case
      (clojure.core/count args11421)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11422
        listHostedZones
        (route53/list-hosted-zones-request
         (clojure.core/nth args11421 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11422
        listHostedZones))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-hosted-zones,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-hosted-zones,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHostedZones, listHostedZones"}
   [credentials11424 & args11425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11426
     (com.palletops.awaze.common/aws-client :route53 credentials11424)]
    (clojure.core/case
     (clojure.core/count args11425)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11426
       listHostedZones
       (route53/list-hosted-zones-request
        (clojure.core/nth args11425 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11426
       listHostedZones))))))
 (do
  (clojure.core/defmethod
   route53
   :list-reusable-delegation-sets
   [m11427]
   (clojure.core/let
    [credentials11428 (:credentials m11427) args11429 (:args m11427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11430
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11428)]
     (clojure.core/case
      (clojure.core/count args11429)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11430
        listReusableDelegationSets
        (route53/list-reusable-delegation-sets-request
         (clojure.core/nth args11429 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11430
        listReusableDelegationSets))))))
  (clojure.core/defn
   list-reusable-delegation-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listReusableDelegationSets, listReusableDelegationSets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-reusable-delegation-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listReusableDelegationSets, listReusableDelegationSets"}
   [credentials11432 & args11433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11434
     (com.palletops.awaze.common/aws-client :route53 credentials11432)]
    (clojure.core/case
     (clojure.core/count args11433)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11434
       listReusableDelegationSets
       (route53/list-reusable-delegation-sets-request
        (clojure.core/nth args11433 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11434
       listReusableDelegationSets))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy-instance
   [m11435]
   (clojure.core/let
    [credentials11436 (:credentials m11435) args11437 (:args m11435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11438
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11438
       deleteTrafficPolicyInstance
       (route53/delete-traffic-policy-instance-request
        (clojure.core/nth args11437 0)))))))
  (clojure.core/defn
   delete-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicyInstance"}
   [credentials11440 & args11441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11442
     (com.palletops.awaze.common/aws-client :route53 credentials11440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11442
      deleteTrafficPolicyInstance
      (route53/delete-traffic-policy-instance-request
       (clojure.core/nth args11441 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m11443]
   (clojure.core/let
    [credentials11444 (:credentials m11443) args11445 (:args m11443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11446
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11446
       getHealthCheck
       (route53/get-health-check-request
        (clojure.core/nth args11445 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheck"}
   [credentials11448 & args11449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11450
     (com.palletops.awaze.common/aws-client :route53 credentials11448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11450
      getHealthCheck
      (route53/get-health-check-request
       (clojure.core/nth args11449 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resources
   [m11451]
   (clojure.core/let
    [credentials11452 (:credentials m11451) args11453 (:args m11451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11454
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11452)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11454
       listTagsForResources
       (route53/list-tags-for-resources-request
        (clojure.core/nth args11453 0)))))))
  (clojure.core/defn
   list-tags-for-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resources,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResources"}
   [credentials11456 & args11457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11458
     (com.palletops.awaze.common/aws-client :route53 credentials11456)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11458
      listTagsForResources
      (route53/list-tags-for-resources-request
       (clojure.core/nth args11457 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-checker-ip-ranges
   [m11459]
   (clojure.core/let
    [credentials11460 (:credentials m11459) args11461 (:args m11459)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11462
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11460)]
     (clojure.core/case
      (clojure.core/count args11461)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11462
        getCheckerIpRanges))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11462
        getCheckerIpRanges
        (route53/get-checker-ip-ranges-request
         (clojure.core/nth args11461 0))))))))
  (clojure.core/defn
   get-checker-ip-ranges-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCheckerIpRanges, getCheckerIpRanges"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-checker-ip-ranges
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCheckerIpRanges, getCheckerIpRanges"}
   [credentials11464 & args11465]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11466
     (com.palletops.awaze.common/aws-client :route53 credentials11464)]
    (clojure.core/case
     (clojure.core/count args11465)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11466
       getCheckerIpRanges))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11466
       getCheckerIpRanges
       (route53/get-checker-ip-ranges-request
        (clojure.core/nth args11465 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m11467]
   (clojure.core/let
    [credentials11468 (:credentials m11467) args11469 (:args m11467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11470
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11468)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11470
       createHostedZone
       (route53/create-hosted-zone-request
        (clojure.core/nth args11469 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHostedZone"}
   [credentials11472 & args11473]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11474
     (com.palletops.awaze.common/aws-client :route53 credentials11472)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11474
      createHostedZone
      (route53/create-hosted-zone-request
       (clojure.core/nth args11473 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-hosted-zone
   [m11475]
   (clojure.core/let
    [credentials11476 (:credentials m11475) args11477 (:args m11475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11478
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11476)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11478
       listChangeBatchesByHostedZone
       (route53/list-change-batches-by-hosted-zone-request
        (clojure.core/nth args11477 0)))))))
  (clojure.core/defn
   list-change-batches-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByHostedZone"}
   [credentials11480 & args11481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11482
     (com.palletops.awaze.common/aws-client :route53 credentials11480)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11482
      listChangeBatchesByHostedZone
      (route53/list-change-batches-by-hosted-zone-request
       (clojure.core/nth args11481 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-health-check
   [m11483]
   (clojure.core/let
    [credentials11484 (:credentials m11483) args11485 (:args m11483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11486
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11486
       updateHealthCheck
       (route53/update-health-check-request
        (clojure.core/nth args11485 0)))))))
  (clojure.core/defn
   update-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         clone-root
                         inverted]}]]),
    :doc "Generate map for updateHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         clone-root
                         inverted]}]]),
    :doc "Call updateHealthCheck"}
   [credentials11488 & args11489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11490
     (com.palletops.awaze.common/aws-client :route53 credentials11488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11490
      updateHealthCheck
      (route53/update-health-check-request
       (clojure.core/nth args11489 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-last-failure-reason
   [m11491]
   (clojure.core/let
    [credentials11492 (:credentials m11491) args11493 (:args m11491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11494
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11494
       getHealthCheckLastFailureReason
       (route53/get-health-check-last-failure-reason-request
        (clojure.core/nth args11493 0)))))))
  (clojure.core/defn
   get-health-check-last-failure-reason-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckLastFailureReason"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-last-failure-reason,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-last-failure-reason
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckLastFailureReason"}
   [credentials11496 & args11497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11498
     (com.palletops.awaze.common/aws-client :route53 credentials11496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11498
      getHealthCheckLastFailureReason
      (route53/get-health-check-last-failure-reason-request
       (clojure.core/nth args11497 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m11499]
   (clojure.core/let
    [credentials11500 (:credentials m11499) args11501 (:args m11499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11502
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11500)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11502
       createHealthCheck
       (route53/create-health-check-request
        (clojure.core/nth args11501 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Generate map for createHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-health-check
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Call createHealthCheck"}
   [credentials11504 & args11505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11506
     (com.palletops.awaze.common/aws-client :route53 credentials11504)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11506
      createHealthCheck
      (route53/create-health-check-request
       (clojure.core/nth args11505 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-instance
   [m11507]
   (clojure.core/let
    [credentials11508 (:credentials m11507) args11509 (:args m11507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11510
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11508)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11510
       createTrafficPolicyInstance
       (route53/create-traffic-policy-instance-request
        (clojure.core/nth args11509 0)))))))
  (clojure.core/defn
   create-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createTrafficPolicyInstance"}
   [credentials11512 & args11513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11514
     (com.palletops.awaze.common/aws-client :route53 credentials11512)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11514
      createTrafficPolicyInstance
      (route53/create-traffic-policy-instance-request
       (clojure.core/nth args11513 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change-details
   [m11515]
   (clojure.core/let
    [credentials11516 (:credentials m11515) args11517 (:args m11515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11518
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11516)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11518
       getChangeDetails
       (route53/get-change-details-request
        (clojure.core/nth args11517 0)))))))
  (clojure.core/defn
   get-change-details-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChangeDetails"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-change-details,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change-details
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChangeDetails"}
   [credentials11520 & args11521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11522
     (com.palletops.awaze.common/aws-client :route53 credentials11520)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11522
      getChangeDetails
      (route53/get-change-details-request
       (clojure.core/nth args11521 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy
   [m11523]
   (clojure.core/let
    [credentials11524 (:credentials m11523) args11525 (:args m11523)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11526
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11524)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11526
       createTrafficPolicy
       (route53/create-traffic-policy-request
        (clojure.core/nth args11525 0)))))))
  (clojure.core/defn
   create-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicy"}
   [credentials11528 & args11529]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11530
     (com.palletops.awaze.common/aws-client :route53 credentials11528)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11530
      createTrafficPolicy
      (route53/create-traffic-policy-request
       (clojure.core/nth args11529 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-tags-for-resource
   [m11531]
   (clojure.core/let
    [credentials11532 (:credentials m11531) args11533 (:args m11531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11534
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11532)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11534
       changeTagsForResource
       (route53/change-tags-for-resource-request
        (clojure.core/nth args11533 0)))))))
  (clojure.core/defn
   change-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for changeTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   change-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call changeTagsForResource"}
   [credentials11536 & args11537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11538
     (com.palletops.awaze.common/aws-client :route53 credentials11536)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11538
      changeTagsForResource
      (route53/change-tags-for-resource-request
       (clojure.core/nth args11537 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance-count
   [m11539]
   (clojure.core/let
    [credentials11540 (:credentials m11539) args11541 (:args m11539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11542
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11540)]
     (clojure.core/case
      (clojure.core/count args11541)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11542
        getTrafficPolicyInstanceCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11542
        getTrafficPolicyInstanceCount
        (route53/get-traffic-policy-instance-count-request
         (clojure.core/nth args11541 0))))))))
  (clojure.core/defn
   get-traffic-policy-instance-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   [credentials11544 & args11545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11546
     (com.palletops.awaze.common/aws-client :route53 credentials11544)]
    (clojure.core/case
     (clojure.core/count args11545)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11546
       getTrafficPolicyInstanceCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11546
       getTrafficPolicyInstanceCount
       (route53/get-traffic-policy-instance-count-request
        (clojure.core/nth args11545 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-status
   [m11547]
   (clojure.core/let
    [credentials11548 (:credentials m11547) args11549 (:args m11547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11550
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11548)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11550
       getHealthCheckStatus
       (route53/get-health-check-status-request
        (clojure.core/nth args11549 0)))))))
  (clojure.core/defn
   get-health-check-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-status,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckStatus"}
   [credentials11552 & args11553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11554
     (com.palletops.awaze.common/aws-client :route53 credentials11552)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11554
      getHealthCheckStatus
      (route53/get-health-check-status-request
       (clojure.core/nth args11553 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m11555]
   (clojure.core/let
    [credentials11556 (:credentials m11555) args11557 (:args m11555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11558
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11556)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11558
       getChange
       (route53/get-change-request (clojure.core/nth args11557 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChange"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-change,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChange"}
   [credentials11560 & args11561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11562
     (com.palletops.awaze.common/aws-client :route53 credentials11560)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11562
      getChange
      (route53/get-change-request (clojure.core/nth args11561 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-geo-locations
   [m11563]
   (clojure.core/let
    [credentials11564 (:credentials m11563) args11565 (:args m11563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11566
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11564)]
     (clojure.core/case
      (clojure.core/count args11565)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11566
        listGeoLocations
        (route53/list-geo-locations-request
         (clojure.core/nth args11565 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11566
        listGeoLocations))))))
  (clojure.core/defn
   list-geo-locations-map
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGeoLocations, listGeoLocations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-geo-locations,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-geo-locations,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-geo-locations
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGeoLocations, listGeoLocations"}
   [credentials11568 & args11569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11570
     (com.palletops.awaze.common/aws-client :route53 credentials11568)]
    (clojure.core/case
     (clojure.core/count args11569)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11570
       listGeoLocations
       (route53/list-geo-locations-request
        (clojure.core/nth args11569 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11570
       listGeoLocations))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone-count
   [m11571]
   (clojure.core/let
    [credentials11572 (:credentials m11571) args11573 (:args m11571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11574
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11572)]
     (clojure.core/case
      (clojure.core/count args11573)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11574
        getHostedZoneCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11574
        getHostedZoneCount
        (route53/get-hosted-zone-count-request
         (clojure.core/nth args11573 0))))))))
  (clojure.core/defn
   get-hosted-zone-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZoneCount, getHostedZoneCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-hosted-zone-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-hosted-zone-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZoneCount, getHostedZoneCount"}
   [credentials11576 & args11577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11578
     (com.palletops.awaze.common/aws-client :route53 credentials11576)]
    (clojure.core/case
     (clojure.core/count args11577)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11578
       getHostedZoneCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11578
       getHostedZoneCount
       (route53/get-hosted-zone-count-request
        (clojure.core/nth args11577 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :update-hosted-zone-comment
   [m11579]
   (clojure.core/let
    [credentials11580 (:credentials m11579) args11581 (:args m11579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11582
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11582
       updateHostedZoneComment
       (route53/update-hosted-zone-comment-request
        (clojure.core/nth args11581 0)))))))
  (clojure.core/defn
   update-hosted-zone-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateHostedZoneComment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-hosted-zone-comment,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-hosted-zone-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateHostedZoneComment"}
   [credentials11584 & args11585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11586
     (com.palletops.awaze.common/aws-client :route53 credentials11584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11586
      updateHostedZoneComment
      (route53/update-hosted-zone-comment-request
       (clojure.core/nth args11585 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-count
   [m11587]
   (clojure.core/let
    [credentials11588 (:credentials m11587) args11589 (:args m11587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11590
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11588)]
     (clojure.core/case
      (clojure.core/count args11589)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11590
        getHealthCheckCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11590
        getHealthCheckCount
        (route53/get-health-check-count-request
         (clojure.core/nth args11589 0))))))))
  (clojure.core/defn
   get-health-check-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckCount, getHealthCheckCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-health-check-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckCount, getHealthCheckCount"}
   [credentials11592 & args11593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11594
     (com.palletops.awaze.common/aws-client :route53 credentials11592)]
    (clojure.core/case
     (clojure.core/count args11593)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11594
       getHealthCheckCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11594
       getHealthCheckCount
       (route53/get-health-check-count-request
        (clojure.core/nth args11593 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m11595]
   (clojure.core/let
    [credentials11596 (:credentials m11595) args11597 (:args m11595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11598
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11596)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11598
       getHostedZone
       (route53/get-hosted-zone-request
        (clojure.core/nth args11597 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZone"}
   [credentials11600 & args11601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11602
     (com.palletops.awaze.common/aws-client :route53 credentials11600)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11602
      getHostedZone
      (route53/get-hosted-zone-request (clojure.core/nth args11601 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-comment
   [m11603]
   (clojure.core/let
    [credentials11604 (:credentials m11603) args11605 (:args m11603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11606
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11606
       updateTrafficPolicyComment
       (route53/update-traffic-policy-comment-request
        (clojure.core/nth args11605 0)))))))
  (clojure.core/defn
   update-traffic-policy-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyComment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-comment,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyComment"}
   [credentials11608 & args11609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11610
     (com.palletops.awaze.common/aws-client :route53 credentials11608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11610
      updateTrafficPolicyComment
      (route53/update-traffic-policy-comment-request
       (clojure.core/nth args11609 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance
   [m11611]
   (clojure.core/let
    [credentials11612 (:credentials m11611) args11613 (:args m11611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11614
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11614
       getTrafficPolicyInstance
       (route53/get-traffic-policy-instance-request
        (clojure.core/nth args11613 0)))))))
  (clojure.core/defn
   get-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstance"}
   [credentials11616 & args11617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11618
     (com.palletops.awaze.common/aws-client :route53 credentials11616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11618
      getTrafficPolicyInstance
      (route53/get-traffic-policy-instance-request
       (clojure.core/nth args11617 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones-by-name
   [m11619]
   (clojure.core/let
    [credentials11620 (:credentials m11619) args11621 (:args m11619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11622
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11620)]
     (clojure.core/case
      (clojure.core/count args11621)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11622
        listHostedZonesByName))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11622
        listHostedZonesByName
        (route53/list-hosted-zones-by-name-request
         (clojure.core/nth args11621 0))))))))
  (clojure.core/defn
   list-hosted-zones-by-name-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listHostedZonesByName, listHostedZonesByName"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones-by-name
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listHostedZonesByName, listHostedZonesByName"}
   [credentials11624 & args11625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11626
     (com.palletops.awaze.common/aws-client :route53 credentials11624)]
    (clojure.core/case
     (clojure.core/count args11625)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11626
       listHostedZonesByName))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11626
       listHostedZonesByName
       (route53/list-hosted-zones-by-name-request
        (clojure.core/nth args11625 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-geo-location
   [m11627]
   (clojure.core/let
    [credentials11628 (:credentials m11627) args11629 (:args m11627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11630
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11628)]
     (clojure.core/case
      (clojure.core/count args11629)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11630
        getGeoLocation
        (route53/get-geo-location-request
         (clojure.core/nth args11629 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11630
        getGeoLocation))))))
  (clojure.core/defn
   get-geo-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getGeoLocation, getGeoLocation"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-geo-location,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-geo-location,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-geo-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]
                [credentials]]),
    :doc "Call getGeoLocation, getGeoLocation"}
   [credentials11632 & args11633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11634
     (com.palletops.awaze.common/aws-client :route53 credentials11632)]
    (clojure.core/case
     (clojure.core/count args11633)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11634
       getGeoLocation
       (route53/get-geo-location-request
        (clojure.core/nth args11633 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11634
       getGeoLocation))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resource
   [m11635]
   (clojure.core/let
    [credentials11636 (:credentials m11635) args11637 (:args m11635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11638
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11636)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11638
       listTagsForResource
       (route53/list-tags-for-resource-request
        (clojure.core/nth args11637 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials11640 & args11641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11642
     (com.palletops.awaze.common/aws-client :route53 credentials11640)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11642
      listTagsForResource
      (route53/list-tags-for-resource-request
       (clojure.core/nth args11641 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-reusable-delegation-set
   [m11643]
   (clojure.core/let
    [credentials11644 (:credentials m11643) args11645 (:args m11643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11646
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11646
       createReusableDelegationSet
       (route53/create-reusable-delegation-set-request
        (clojure.core/nth args11645 0)))))))
  (clojure.core/defn
   create-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createReusableDelegationSet"}
   [credentials11648 & args11649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11650
     (com.palletops.awaze.common/aws-client :route53 credentials11648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11650
      createReusableDelegationSet
      (route53/create-reusable-delegation-set-request
       (clojure.core/nth args11649 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m11651]
   (clojure.core/let
    [credentials11652 (:credentials m11651) args11653 (:args m11651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11654
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11652)]
     (clojure.core/case
      (clojure.core/count args11653)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11654
        listHealthChecks
        (route53/list-health-checks-request
         (clojure.core/nth args11653 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11654
        listHealthChecks))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-health-checks,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-health-checks,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-health-checks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials11656 & args11657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11658
     (com.palletops.awaze.common/aws-client :route53 credentials11656)]
    (clojure.core/case
     (clojure.core/count args11657)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11658
       listHealthChecks
       (route53/list-health-checks-request
        (clojure.core/nth args11657 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11658
       listHealthChecks))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-instance
   [m11659]
   (clojure.core/let
    [credentials11660 (:credentials m11659) args11661 (:args m11659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11662
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11660)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11662
       updateTrafficPolicyInstance
       (route53/update-traffic-policy-instance-request
        (clojure.core/nth args11661 0)))))))
  (clojure.core/defn
   update-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyInstance"}
   [credentials11664 & args11665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11666
     (com.palletops.awaze.common/aws-client :route53 credentials11664)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11666
      updateTrafficPolicyInstance
      (route53/update-traffic-policy-instance-request
       (clojure.core/nth args11665 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m11667]
   (clojure.core/let
    [credentials11668 (:credentials m11667) args11669 (:args m11667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11670
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11668)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11670
       deleteHealthCheck
       (route53/delete-health-check-request
        (clojure.core/nth args11669 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHealthCheck"}
   [credentials11672 & args11673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11674
     (com.palletops.awaze.common/aws-client :route53 credentials11672)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11674
      deleteHealthCheck
      (route53/delete-health-check-request
       (clojure.core/nth args11673 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy
   [m11675]
   (clojure.core/let
    [credentials11676 (:credentials m11675) args11677 (:args m11675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11678
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11676)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11678
       getTrafficPolicy
       (route53/get-traffic-policy-request
        (clojure.core/nth args11677 0)))))))
  (clojure.core/defn
   get-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call getTrafficPolicy"}
   [credentials11680 & args11681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11682
     (com.palletops.awaze.common/aws-client :route53 credentials11680)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11682
      getTrafficPolicy
      (route53/get-traffic-policy-request
       (clojure.core/nth args11681 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-rrset
   [m11683]
   (clojure.core/let
    [credentials11684 (:credentials m11683) args11685 (:args m11683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11686
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11686
       listChangeBatchesByRRSet
       (route53/list-change-batches-by-rrset-request
        (clojure.core/nth args11685 0)))))))
  (clojure.core/defn
   list-change-batches-by-rrset-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByRRSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-rrset,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-rrset
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByRRSet"}
   [credentials11688 & args11689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11690
     (com.palletops.awaze.common/aws-client :route53 credentials11688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11690
      listChangeBatchesByRRSet
      (route53/list-change-batches-by-rrset-request
       (clojure.core/nth args11689 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m11691]
   (clojure.core/let
    [credentials11692 (:credentials m11691) args11693 (:args m11691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11694
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11694
       listResourceRecordSets
       (route53/list-resource-record-sets-request
        (clojure.core/nth args11693 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-resource-record-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Call listResourceRecordSets"}
   [credentials11696 & args11697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11698
     (com.palletops.awaze.common/aws-client :route53 credentials11696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11698
      listResourceRecordSets
      (route53/list-resource-record-sets-request
       (clojure.core/nth args11697 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :disassociate-vpcfrom-hosted-zone
   [m11699]
   (clojure.core/let
    [credentials11700 (:credentials m11699) args11701 (:args m11699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11702
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11702
       disassociateVPCFromHostedZone
       (route53/disassociate-vpcfrom-hosted-zone-request
        (clojure.core/nth args11701 0)))))))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for disassociateVPCFromHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-vpcfrom-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call disassociateVPCFromHostedZone"}
   [credentials11704 & args11705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11706
     (com.palletops.awaze.common/aws-client :route53 credentials11704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11706
      disassociateVPCFromHostedZone
      (route53/disassociate-vpcfrom-hosted-zone-request
       (clojure.core/nth args11705 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances
   [m11707]
   (clojure.core/let
    [credentials11708 (:credentials m11707) args11709 (:args m11707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11710
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11708)]
     (clojure.core/case
      (clojure.core/count args11709)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11710
        listTrafficPolicyInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11710
        listTrafficPolicyInstances
        (route53/list-traffic-policy-instances-request
         (clojure.core/nth args11709 0))))))))
  (clojure.core/defn
   list-traffic-policy-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstances, listTrafficPolicyInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstances, listTrafficPolicyInstances"}
   [credentials11712 & args11713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11714
     (com.palletops.awaze.common/aws-client :route53 credentials11712)]
    (clojure.core/case
     (clojure.core/count args11713)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11714
       listTrafficPolicyInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11714
       listTrafficPolicyInstances
       (route53/list-traffic-policy-instances-request
        (clojure.core/nth args11713 0)))))))))
