(ns
 com.palletops.awaze.redshift
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.redshift :as redshift]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Tag}
tag
  [m8845]
  (clojure.core/let
   [bean8844 (new com.amazonaws.services.redshift.model.Tag)]
   (clojure.core/let
    [v8846 (:key m8845 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8846 :com.palletops.awaze.client-builder/undef)
     (. bean8844 setKey (clojure.core/str v8846))))
   (clojure.core/let
    [v8846 (:value m8845 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8846 :com.palletops.awaze.client-builder/undef)
     (. bean8844 setValue (clojure.core/str v8846))))
   bean8844))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.SourceType}
source-type
  [m8848]
  (.
   com.amazonaws.services.redshift.model.SourceType
   fromValue
   (clojure.core/name m8848)))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Parameter}
parameter
  [m8851]
  (clojure.core/let
   [bean8850 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/let
    [v8852
     (:description m8851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setDescription (clojure.core/str v8852))))
   (clojure.core/let
    [v8852
     (:data-type m8851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setDataType (clojure.core/str v8852))))
   (clojure.core/let
    [v8852
     (:parameter-value
      m8851
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setParameterValue (clojure.core/str v8852))))
   (clojure.core/let
    [v8852
     (:parameter-name m8851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setParameterName (clojure.core/str v8852))))
   (clojure.core/let
    [v8852
     (:is-modifiable m8851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setIsModifiable (clojure.core/boolean v8852))))
   (clojure.core/let
    [v8852
     (:minimum-engine-version
      m8851
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setMinimumEngineVersion (clojure.core/str v8852))))
   (clojure.core/let
    [v8852
     (:apply-type m8851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setApplyType (clojure.core/str v8852))))
   (clojure.core/let
    [v8852
     (:allowed-values m8851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setAllowedValues (clojure.core/str v8852))))
   (clojure.core/let
    [v8852 (:source m8851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8852 :com.palletops.awaze.client-builder/undef)
     (. bean8850 setSource (clojure.core/str v8852))))
   bean8850))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeResizeRequest}
describe-resize-request
  [m8854]
  (clojure.core/let
   [bean8853
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/let
    [v8855
     (:cluster-identifier
      m8854
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8855 :com.palletops.awaze.client-builder/undef)
     (. bean8853 setClusterIdentifier (clojure.core/str v8855))))
   bean8853))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest}
describe-cluster-snapshots-request
  [m8857]
  (clojure.core/let
   [bean8856
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/let
    [v8858
     (:cluster-identifier
      m8857
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (. bean8856 setClusterIdentifier (clojure.core/str v8858))))
   (clojure.core/let
    [v8858
     (:snapshot-type m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (. bean8856 setSnapshotType (clojure.core/str v8858))))
   (clojure.core/let
    [v8858 (:marker m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (. bean8856 setMarker (clojure.core/str v8858))))
   (clojure.core/let
    [v8858
     (:tag-values m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (.
      bean8856
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9039] (clojure.core/str arg9039))
 v8858))))
   (clojure.core/let
    [v8858
     (:start-time m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (.
      bean8856
      setStartTime
      (com.palletops.awaze.common/to-date v8858))))
   (clojure.core/let
    [v8858
     (:max-records m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (. bean8856 setMaxRecords (clojure.core/int v8858))))
   (clojure.core/let
    [v8858
     (:end-time m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (.
      bean8856
      setEndTime
      (com.palletops.awaze.common/to-date v8858))))
   (clojure.core/let
    [v8858
     (:snapshot-identifier
      m8857
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (. bean8856 setSnapshotIdentifier (clojure.core/str v8858))))
   (clojure.core/let
    [v8858
     (:owner-account m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (. bean8856 setOwnerAccount (clojure.core/str v8858))))
   (clojure.core/let
    [v8858
     (:tag-keys m8857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8858 :com.palletops.awaze.client-builder/undef)
     (.
      bean8856
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9040] (clojure.core/str arg9040))
 v8858))))
   bean8856))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest}
describe-default-cluster-parameters-request
  [m8860]
  (clojure.core/let
   [bean8859
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/let
    [v8861 (:marker m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setMarker (clojure.core/str v8861))))
   (clojure.core/let
    [v8861
     (:max-records m8860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setMaxRecords (clojure.core/int v8861))))
   (clojure.core/let
    [v8861
     (:parameter-group-family
      m8860
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8861 :com.palletops.awaze.client-builder/undef)
     (. bean8859 setParameterGroupFamily (clojure.core/str v8861))))
   bean8859))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest}
create-hsm-client-certificate-request
  [m8863]
  (clojure.core/let
   [bean8862
    (new
     com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest)]
   (clojure.core/let
    [v8864 (:tags m8863 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8864 :com.palletops.awaze.client-builder/undef)
     (.
      bean8862
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9041] (redshift/tag arg9041))
 v8864))))
   (clojure.core/let
    [v8864
     (:hsm-client-certificate-identifier
      m8863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8864 :com.palletops.awaze.client-builder/undef)
     (.
      bean8862
      setHsmClientCertificateIdentifier
      (clojure.core/str v8864))))
   bean8862))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest}
describe-cluster-versions-request
  [m8866]
  (clojure.core/let
   [bean8865
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/let
    [v8867 (:marker m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setMarker (clojure.core/str v8867))))
   (clojure.core/let
    [v8867
     (:max-records m8866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setMaxRecords (clojure.core/int v8867))))
   (clojure.core/let
    [v8867
     (:cluster-version
      m8866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (. bean8865 setClusterVersion (clojure.core/str v8867))))
   (clojure.core/let
    [v8867
     (:cluster-parameter-group-family
      m8866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8867 :com.palletops.awaze.client-builder/undef)
     (.
      bean8865
      setClusterParameterGroupFamily
      (clojure.core/str v8867))))
   bean8865))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest}
enable-snapshot-copy-request
  [m8869]
  (clojure.core/let
   [bean8868
    (new
     com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest)]
   (clojure.core/let
    [v8870
     (:destination-region
      m8869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setDestinationRegion (clojure.core/str v8870))))
   (clojure.core/let
    [v8870
     (:cluster-identifier
      m8869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setClusterIdentifier (clojure.core/str v8870))))
   (clojure.core/let
    [v8870
     (:retention-period
      m8869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setRetentionPeriod (clojure.core/int v8870))))
   (clojure.core/let
    [v8870
     (:snapshot-copy-grant-name
      m8869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setSnapshotCopyGrantName (clojure.core/str v8870))))
   bean8868))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest}
create-snapshot-copy-grant-request
  [m8872]
  (clojure.core/let
   [bean8871
    (new
     com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8873
     (:kms-key-id m8872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8873 :com.palletops.awaze.client-builder/undef)
     (. bean8871 setKmsKeyId (clojure.core/str v8873))))
   (clojure.core/let
    [v8873 (:tags m8872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8873 :com.palletops.awaze.client-builder/undef)
     (.
      bean8871
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9042] (redshift/tag arg9042))
 v8873))))
   (clojure.core/let
    [v8873
     (:snapshot-copy-grant-name
      m8872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8873 :com.palletops.awaze.client-builder/undef)
     (. bean8871 setSnapshotCopyGrantName (clojure.core/str v8873))))
   bean8871))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest}
describe-cluster-parameter-groups-request
  [m8875]
  (clojure.core/let
   [bean8874
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/let
    [v8876 (:marker m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setMarker (clojure.core/str v8876))))
   (clojure.core/let
    [v8876
     (:tag-keys m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (.
      bean8874
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9043] (clojure.core/str arg9043))
 v8876))))
   (clojure.core/let
    [v8876
     (:max-records m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setMaxRecords (clojure.core/int v8876))))
   (clojure.core/let
    [v8876
     (:parameter-group-name
      m8875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setParameterGroupName (clojure.core/str v8876))))
   (clojure.core/let
    [v8876
     (:tag-values m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (.
      bean8874
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9044] (clojure.core/str arg9044))
 v8876))))
   bean8874))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest}
delete-cluster-parameter-group-request
  [m8878]
  (clojure.core/let
   [bean8877
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/let
    [v8879
     (:parameter-group-name
      m8878
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8879 :com.palletops.awaze.client-builder/undef)
     (. bean8877 setParameterGroupName (clojure.core/str v8879))))
   bean8877))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventsRequest}
describe-events-request
  [m8881]
  (clojure.core/let
   [bean8880
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/let
    [v8882 (:marker m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (. bean8880 setMarker (clojure.core/str v8882))))
   (clojure.core/let
    [v8882
     (:end-time m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (.
      bean8880
      setEndTime
      (com.palletops.awaze.common/to-date v8882))))
   (clojure.core/let
    [v8882
     (:start-time m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (.
      bean8880
      setStartTime
      (com.palletops.awaze.common/to-date v8882))))
   (clojure.core/let
    [v8882
     (:max-records m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (. bean8880 setMaxRecords (clojure.core/int v8882))))
   (clojure.core/let
    [v8882
     (:source-identifier
      m8881
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (. bean8880 setSourceIdentifier (clojure.core/str v8882))))
   (clojure.core/let
    [v8882
     (:source-type m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (. bean8880 setSourceType (redshift/source-type v8882))))
   (clojure.core/let
    [v8882
     (:duration m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (. bean8880 setDuration (clojure.core/int v8882))))
   bean8880))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodesRequest}
describe-reserved-nodes-request
  [m8884]
  (clojure.core/let
   [bean8883
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/let
    [v8885 (:marker m8884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setMarker (clojure.core/str v8885))))
   (clojure.core/let
    [v8885
     (:max-records m8884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setMaxRecords (clojure.core/int v8885))))
   (clojure.core/let
    [v8885
     (:reserved-node-id
      m8884
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setReservedNodeId (clojure.core/str v8885))))
   bean8883))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest}
modify-cluster-iam-roles-request
  [m8887]
  (clojure.core/let
   [bean8886
    (new
     com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest)]
   (clojure.core/let
    [v8888
     (:add-iam-roles m8887 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8888 :com.palletops.awaze.client-builder/undef)
     (.
      bean8886
      setAddIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9045] (clojure.core/str arg9045))
 v8888))))
   (clojure.core/let
    [v8888
     (:remove-iam-roles
      m8887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8888 :com.palletops.awaze.client-builder/undef)
     (.
      bean8886
      setRemoveIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9046] (clojure.core/str arg9046))
 v8888))))
   (clojure.core/let
    [v8888
     (:cluster-identifier
      m8887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8888 :com.palletops.awaze.client-builder/undef)
     (. bean8886 setClusterIdentifier (clojure.core/str v8888))))
   bean8886))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m8890]
  (clojure.core/let
   [bean8889
    (new
     com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest)]
   (clojure.core/let
    [v8891
     (:subscription-name
      m8890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (. bean8889 setSubscriptionName (clojure.core/str v8891))))
   bean8889))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RebootClusterRequest}
reboot-cluster-request
  [m8893]
  (clojure.core/let
   [bean8892
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/let
    [v8894
     (:cluster-identifier
      m8893
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (. bean8892 setClusterIdentifier (clojure.core/str v8894))))
   bean8892))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest}
create-cluster-security-group-request
  [m8896]
  (clojure.core/let
   [bean8895
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/let
    [v8897
     (:description m8896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8897 :com.palletops.awaze.client-builder/undef)
     (. bean8895 setDescription (clojure.core/str v8897))))
   (clojure.core/let
    [v8897 (:tags m8896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8897 :com.palletops.awaze.client-builder/undef)
     (.
      bean8895
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9047] (redshift/tag arg9047))
 v8897))))
   (clojure.core/let
    [v8897
     (:cluster-security-group-name
      m8896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8897 :com.palletops.awaze.client-builder/undef)
     (. bean8895 setClusterSecurityGroupName (clojure.core/str v8897))))
   bean8895))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest}
modify-cluster-parameter-group-request
  [m8899]
  (clojure.core/let
   [bean8898
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/let
    [v8900
     (:parameters m8899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (.
      bean8898
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9048] (redshift/parameter arg9048))
 v8900))))
   (clojure.core/let
    [v8900
     (:parameter-group-name
      m8899
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (. bean8898 setParameterGroupName (clojure.core/str v8900))))
   bean8898))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest}
modify-snapshot-copy-retention-period-request
  [m8902]
  (clojure.core/let
   [bean8901
    (new
     com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest)]
   (clojure.core/let
    [v8903
     (:cluster-identifier
      m8902
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8903 :com.palletops.awaze.client-builder/undef)
     (. bean8901 setClusterIdentifier (clojure.core/str v8903))))
   (clojure.core/let
    [v8903
     (:retention-period
      m8902
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8903 :com.palletops.awaze.client-builder/undef)
     (. bean8901 setRetentionPeriod (clojure.core/int v8903))))
   bean8901))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest}
delete-snapshot-copy-grant-request
  [m8905]
  (clojure.core/let
   [bean8904
    (new
     com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8906
     (:snapshot-copy-grant-name
      m8905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8906 :com.palletops.awaze.client-builder/undef)
     (. bean8904 setSnapshotCopyGrantName (clojure.core/str v8906))))
   bean8904))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest}
authorize-snapshot-access-request
  [m8908]
  (clojure.core/let
   [bean8907
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/let
    [v8909
     (:snapshot-identifier
      m8908
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8909 :com.palletops.awaze.client-builder/undef)
     (. bean8907 setSnapshotIdentifier (clojure.core/str v8909))))
   (clojure.core/let
    [v8909
     (:snapshot-cluster-identifier
      m8908
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8909 :com.palletops.awaze.client-builder/undef)
     (.
      bean8907
      setSnapshotClusterIdentifier
      (clojure.core/str v8909))))
   (clojure.core/let
    [v8909
     (:account-with-restore-access
      m8908
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8909 :com.palletops.awaze.client-builder/undef)
     (. bean8907 setAccountWithRestoreAccess (clojure.core/str v8909))))
   bean8907))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableLoggingRequest}
disable-logging-request
  [m8911]
  (clojure.core/let
   [bean8910
    (new com.amazonaws.services.redshift.model.DisableLoggingRequest)]
   (clojure.core/let
    [v8912
     (:cluster-identifier
      m8911
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8912 :com.palletops.awaze.client-builder/undef)
     (. bean8910 setClusterIdentifier (clojure.core/str v8912))))
   bean8910))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest}
modify-cluster-subnet-group-request
  [m8914]
  (clojure.core/let
   [bean8913
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8915
     (:description m8914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (. bean8913 setDescription (clojure.core/str v8915))))
   (clojure.core/let
    [v8915
     (:subnet-ids m8914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (.
      bean8913
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9049] (clojure.core/str arg9049))
 v8915))))
   (clojure.core/let
    [v8915
     (:cluster-subnet-group-name
      m8914
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (. bean8913 setClusterSubnetGroupName (clojure.core/str v8915))))
   bean8913))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterRequest}
modify-cluster-request
  [m8917]
  (clojure.core/let
   [bean8916
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/let
    [v8918
     (:cluster-version
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setClusterVersion (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:cluster-type m8917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setClusterType (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:cluster-identifier
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setClusterIdentifier (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:elastic-ip m8917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setElasticIp (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:allow-version-upgrade
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setAllowVersionUpgrade (clojure.core/boolean v8918))))
   (clojure.core/let
    [v8918
     (:hsm-client-certificate-identifier
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setHsmClientCertificateIdentifier
      (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:new-cluster-identifier
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setNewClusterIdentifier (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:automated-snapshot-retention-period
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8918))))
   (clojure.core/let
    [v8918
     (:master-user-password
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setMasterUserPassword (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:publicly-accessible
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setPubliclyAccessible (clojure.core/boolean v8918))))
   (clojure.core/let
    [v8918
     (:preferred-maintenance-window
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setPreferredMaintenanceWindow
      (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:node-type m8917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setNodeType (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:hsm-configuration-identifier
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setHsmConfigurationIdentifier
      (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:cluster-security-groups
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9050] (clojure.core/str arg9050))
 v8918))))
   (clojure.core/let
    [v8918
     (:vpc-security-group-ids
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9051] (clojure.core/str arg9051))
 v8918))))
   (clojure.core/let
    [v8918
     (:cluster-parameter-group-name
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setClusterParameterGroupName
      (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:number-of-nodes
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setNumberOfNodes (clojure.core/int v8918))))
   bean8916))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest}
restore-from-cluster-snapshot-request
  [m8920]
  (clojure.core/let
   [bean8919
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/let
    [v8921
     (:cluster-subnet-group-name
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setClusterSubnetGroupName (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:cluster-identifier
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setClusterIdentifier (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:elastic-ip m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setElasticIp (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:allow-version-upgrade
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setAllowVersionUpgrade (clojure.core/boolean v8921))))
   (clojure.core/let
    [v8921
     (:additional-info
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setAdditionalInfo (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:hsm-client-certificate-identifier
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setHsmClientCertificateIdentifier
      (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:availability-zone
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setAvailabilityZone (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:automated-snapshot-retention-period
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8921))))
   (clojure.core/let
    [v8921
     (:publicly-accessible
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setPubliclyAccessible (clojure.core/boolean v8921))))
   (clojure.core/let
    [v8921
     (:preferred-maintenance-window
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setPreferredMaintenanceWindow
      (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:snapshot-cluster-identifier
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setSnapshotClusterIdentifier
      (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:iam-roles m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9052] (clojure.core/str arg9052))
 v8921))))
   (clojure.core/let
    [v8921 (:port m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setPort (clojure.core/int v8921))))
   (clojure.core/let
    [v8921
     (:node-type m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setNodeType (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:hsm-configuration-identifier
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setHsmConfigurationIdentifier
      (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:cluster-security-groups
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9053] (clojure.core/str arg9053))
 v8921))))
   (clojure.core/let
    [v8921
     (:snapshot-identifier
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setSnapshotIdentifier (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:owner-account m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setOwnerAccount (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:vpc-security-group-ids
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9054] (clojure.core/str arg9054))
 v8921))))
   (clojure.core/let
    [v8921
     (:cluster-parameter-group-name
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setClusterParameterGroupName
      (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:kms-key-id m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setKmsKeyId (clojure.core/str v8921))))
   bean8919))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest}
delete-hsm-client-certificate-request
  [m8923]
  (clojure.core/let
   [bean8922
    (new
     com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest)]
   (clojure.core/let
    [v8924
     (:hsm-client-certificate-identifier
      m8923
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8924 :com.palletops.awaze.client-builder/undef)
     (.
      bean8922
      setHsmClientCertificateIdentifier
      (clojure.core/str v8924))))
   bean8922))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterRequest}
create-cluster-request
  [m8926]
  (clojure.core/let
   [bean8925
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/let
    [v8927
     (:cluster-version
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setClusterVersion (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:cluster-type m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setClusterType (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:cluster-subnet-group-name
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setClusterSubnetGroupName (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:cluster-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setClusterIdentifier (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:elastic-ip m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setElasticIp (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:allow-version-upgrade
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setAllowVersionUpgrade (clojure.core/boolean v8927))))
   (clojure.core/let
    [v8927
     (:additional-info
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setAdditionalInfo (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:hsm-client-certificate-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setHsmClientCertificateIdentifier
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:availability-zone
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setAvailabilityZone (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:automated-snapshot-retention-period
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8927))))
   (clojure.core/let
    [v8927
     (:master-user-password
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setMasterUserPassword (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:publicly-accessible
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setPubliclyAccessible (clojure.core/boolean v8927))))
   (clojure.core/let
    [v8927
     (:preferred-maintenance-window
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setPreferredMaintenanceWindow
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:iam-roles m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9055] (clojure.core/str arg9055))
 v8927))))
   (clojure.core/let
    [v8927 (:port m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setPort (clojure.core/int v8927))))
   (clojure.core/let
    [v8927 (:tags m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9056] (redshift/tag arg9056))
 v8927))))
   (clojure.core/let
    [v8927
     (:node-type m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setNodeType (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:hsm-configuration-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setHsmConfigurationIdentifier
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:cluster-security-groups
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9057] (clojure.core/str arg9057))
 v8927))))
   (clojure.core/let
    [v8927
     (:vpc-security-group-ids
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9058] (clojure.core/str arg9058))
 v8927))))
   (clojure.core/let
    [v8927
     (:cluster-parameter-group-name
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setClusterParameterGroupName
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:master-username
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setMasterUsername (clojure.core/str v8927))))
   (clojure.core/let
    [v8927 (:dbname m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setDBName (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:kms-key-id m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setKmsKeyId (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:encrypted m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setEncrypted (clojure.core/boolean v8927))))
   (clojure.core/let
    [v8927
     (:number-of-nodes
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setNumberOfNodes (clojure.core/int v8927))))
   bean8925))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest}
describe-logging-status-request
  [m8929]
  (clojure.core/let
   [bean8928
    (new
     com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest)]
   (clojure.core/let
    [v8930
     (:cluster-identifier
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setClusterIdentifier (clojure.core/str v8930))))
   bean8928))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest}
describe-table-restore-status-request
  [m8932]
  (clojure.core/let
   [bean8931
    (new
     com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest)]
   (clojure.core/let
    [v8933 (:marker m8932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setMarker (clojure.core/str v8933))))
   (clojure.core/let
    [v8933
     (:max-records m8932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setMaxRecords (clojure.core/int v8933))))
   (clojure.core/let
    [v8933
     (:cluster-identifier
      m8932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setClusterIdentifier (clojure.core/str v8933))))
   (clojure.core/let
    [v8933
     (:table-restore-request-id
      m8932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setTableRestoreRequestId (clojure.core/str v8933))))
   bean8931))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m8935]
  (clojure.core/let
   [bean8934
    (new
     com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest)]
   (clojure.core/let
    [v8936
     (:source-type m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setSourceType (clojure.core/str v8936))))
   bean8934))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParametersRequest}
describe-cluster-parameters-request
  [m8938]
  (clojure.core/let
   [bean8937
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/let
    [v8939 (:marker m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setMarker (clojure.core/str v8939))))
   (clojure.core/let
    [v8939 (:source m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setSource (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:max-records m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setMaxRecords (clojure.core/int v8939))))
   (clojure.core/let
    [v8939
     (:parameter-group-name
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setParameterGroupName (clojure.core/str v8939))))
   bean8937))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest}
authorize-cluster-security-group-ingress-request
  [m8941]
  (clojure.core/let
   [bean8940
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v8942
     (:cluster-security-group-name
      m8941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setClusterSecurityGroupName (clojure.core/str v8942))))
   (clojure.core/let
    [v8942 (:cidrip m8941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setCIDRIP (clojure.core/str v8942))))
   (clojure.core/let
    [v8942
     (:ec2security-group-name
      m8941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setEC2SecurityGroupName (clojure.core/str v8942))))
   (clojure.core/let
    [v8942
     (:ec2security-group-owner-id
      m8941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setEC2SecurityGroupOwnerId (clojure.core/str v8942))))
   bean8940))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClustersRequest}
describe-clusters-request
  [m8944]
  (clojure.core/let
   [bean8943
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/let
    [v8945 (:marker m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setMarker (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:tag-keys m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9059] (clojure.core/str arg9059))
 v8945))))
   (clojure.core/let
    [v8945
     (:max-records m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setMaxRecords (clojure.core/int v8945))))
   (clojure.core/let
    [v8945
     (:tag-values m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9060] (clojure.core/str arg9060))
 v8945))))
   (clojure.core/let
    [v8945
     (:cluster-identifier
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setClusterIdentifier (clojure.core/str v8945))))
   bean8943))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest}
delete-cluster-subnet-group-request
  [m8947]
  (clojure.core/let
   [bean8946
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8948
     (:cluster-subnet-group-name
      m8947
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8948 :com.palletops.awaze.client-builder/undef)
     (. bean8946 setClusterSubnetGroupName (clojure.core/str v8948))))
   bean8946))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest}
describe-cluster-security-groups-request
  [m8950]
  (clojure.core/let
   [bean8949
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/let
    [v8951 (:marker m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setMarker (clojure.core/str v8951))))
   (clojure.core/let
    [v8951
     (:tag-keys m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (.
      bean8949
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9061] (clojure.core/str arg9061))
 v8951))))
   (clojure.core/let
    [v8951
     (:max-records m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setMaxRecords (clojure.core/int v8951))))
   (clojure.core/let
    [v8951
     (:tag-values m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (.
      bean8949
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9062] (clojure.core/str arg9062))
 v8951))))
   (clojure.core/let
    [v8951
     (:cluster-security-group-name
      m8950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setClusterSecurityGroupName (clojure.core/str v8951))))
   bean8949))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTagsRequest}
describe-tags-request
  [m8953]
  (clojure.core/let
   [bean8952
    (new com.amazonaws.services.redshift.model.DescribeTagsRequest)]
   (clojure.core/let
    [v8954 (:marker m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setMarker (clojure.core/str v8954))))
   (clojure.core/let
    [v8954
     (:resource-type m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setResourceType (clojure.core/str v8954))))
   (clojure.core/let
    [v8954
     (:tag-keys m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (.
      bean8952
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9063] (clojure.core/str arg9063))
 v8954))))
   (clojure.core/let
    [v8954
     (:max-records m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setMaxRecords (clojure.core/int v8954))))
   (clojure.core/let
    [v8954
     (:resource-name m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setResourceName (clojure.core/str v8954))))
   (clojure.core/let
    [v8954
     (:tag-values m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (.
      bean8952
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9064] (clojure.core/str arg9064))
 v8954))))
   bean8952))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest}
disable-snapshot-copy-request
  [m8956]
  (clojure.core/let
   [bean8955
    (new
     com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest)]
   (clojure.core/let
    [v8957
     (:cluster-identifier
      m8956
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8957 :com.palletops.awaze.client-builder/undef)
     (. bean8955 setClusterIdentifier (clojure.core/str v8957))))
   bean8955))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteTagsRequest}
delete-tags-request
  [m8959]
  (clojure.core/let
   [bean8958
    (new com.amazonaws.services.redshift.model.DeleteTagsRequest)]
   (clojure.core/let
    [v8960
     (:tag-keys m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (.
      bean8958
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9065] (clojure.core/str arg9065))
 v8960))))
   (clojure.core/let
    [v8960
     (:resource-name m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setResourceName (clojure.core/str v8960))))
   bean8958))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest}
purchase-reserved-node-offering-request
  [m8962]
  (clojure.core/let
   [bean8961
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/let
    [v8963
     (:reserved-node-offering-id
      m8962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setReservedNodeOfferingId (clojure.core/str v8963))))
   (clojure.core/let
    [v8963
     (:node-count m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setNodeCount (clojure.core/int v8963))))
   bean8961))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest}
delete-cluster-snapshot-request
  [m8965]
  (clojure.core/let
   [bean8964
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/let
    [v8966
     (:snapshot-identifier
      m8965
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8966 :com.palletops.awaze.client-builder/undef)
     (. bean8964 setSnapshotIdentifier (clojure.core/str v8966))))
   (clojure.core/let
    [v8966
     (:snapshot-cluster-identifier
      m8965
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8966 :com.palletops.awaze.client-builder/undef)
     (.
      bean8964
      setSnapshotClusterIdentifier
      (clojure.core/str v8966))))
   bean8964))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest}
create-cluster-parameter-group-request
  [m8968]
  (clojure.core/let
   [bean8967
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/let
    [v8969
     (:description m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (. bean8967 setDescription (clojure.core/str v8969))))
   (clojure.core/let
    [v8969 (:tags m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (.
      bean8967
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9066] (redshift/tag arg9066))
 v8969))))
   (clojure.core/let
    [v8969
     (:parameter-group-name
      m8968
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (. bean8967 setParameterGroupName (clojure.core/str v8969))))
   (clojure.core/let
    [v8969
     (:parameter-group-family
      m8968
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (. bean8967 setParameterGroupFamily (clojure.core/str v8969))))
   bean8967))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest}
rotate-encryption-key-request
  [m8971]
  (clojure.core/let
   [bean8970
    (new
     com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest)]
   (clojure.core/let
    [v8972
     (:cluster-identifier
      m8971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setClusterIdentifier (clojure.core/str v8972))))
   bean8970))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest}
describe-hsm-client-certificates-request
  [m8974]
  (clojure.core/let
   [bean8973
    (new
     com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest)]
   (clojure.core/let
    [v8975 (:marker m8974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (. bean8973 setMarker (clojure.core/str v8975))))
   (clojure.core/let
    [v8975
     (:tag-keys m8974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (.
      bean8973
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9067] (clojure.core/str arg9067))
 v8975))))
   (clojure.core/let
    [v8975
     (:max-records m8974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (. bean8973 setMaxRecords (clojure.core/int v8975))))
   (clojure.core/let
    [v8975
     (:tag-values m8974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (.
      bean8973
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9068] (clojure.core/str arg9068))
 v8975))))
   (clojure.core/let
    [v8975
     (:hsm-client-certificate-identifier
      m8974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (.
      bean8973
      setHsmClientCertificateIdentifier
      (clojure.core/str v8975))))
   bean8973))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest}
describe-snapshot-copy-grants-request
  [m8977]
  (clojure.core/let
   [bean8976
    (new
     com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest)]
   (clojure.core/let
    [v8978 (:marker m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (. bean8976 setMarker (clojure.core/str v8978))))
   (clojure.core/let
    [v8978
     (:tag-keys m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (.
      bean8976
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9069] (clojure.core/str arg9069))
 v8978))))
   (clojure.core/let
    [v8978
     (:max-records m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (. bean8976 setMaxRecords (clojure.core/int v8978))))
   (clojure.core/let
    [v8978
     (:tag-values m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (.
      bean8976
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9070] (clojure.core/str arg9070))
 v8978))))
   (clojure.core/let
    [v8978
     (:snapshot-copy-grant-name
      m8977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (. bean8976 setSnapshotCopyGrantName (clojure.core/str v8978))))
   bean8976))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest}
reset-cluster-parameter-group-request
  [m8980]
  (clojure.core/let
   [bean8979
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/let
    [v8981
     (:parameters m8980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8981 :com.palletops.awaze.client-builder/undef)
     (.
      bean8979
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9071] (redshift/parameter arg9071))
 v8981))))
   (clojure.core/let
    [v8981
     (:parameter-group-name
      m8980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8981 :com.palletops.awaze.client-builder/undef)
     (. bean8979 setParameterGroupName (clojure.core/str v8981))))
   (clojure.core/let
    [v8981
     (:reset-all-parameters
      m8980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8981 :com.palletops.awaze.client-builder/undef)
     (. bean8979 setResetAllParameters (clojure.core/boolean v8981))))
   bean8979))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest}
delete-cluster-security-group-request
  [m8983]
  (clojure.core/let
   [bean8982
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/let
    [v8984
     (:cluster-security-group-name
      m8983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (. bean8982 setClusterSecurityGroupName (clojure.core/str v8984))))
   bean8982))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest}
copy-cluster-snapshot-request
  [m8986]
  (clojure.core/let
   [bean8985
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/let
    [v8987
     (:source-snapshot-identifier
      m8986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setSourceSnapshotIdentifier (clojure.core/str v8987))))
   (clojure.core/let
    [v8987
     (:source-snapshot-cluster-identifier
      m8986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (.
      bean8985
      setSourceSnapshotClusterIdentifier
      (clojure.core/str v8987))))
   (clojure.core/let
    [v8987
     (:target-snapshot-identifier
      m8986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setTargetSnapshotIdentifier (clojure.core/str v8987))))
   bean8985))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest}
restore-table-from-cluster-snapshot-request
  [m8989]
  (clojure.core/let
   [bean8988
    (new
     com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest)]
   (clojure.core/let
    [v8990
     (:source-database-name
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setSourceDatabaseName (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:source-schema-name
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setSourceSchemaName (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:source-table-name
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setSourceTableName (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:target-database-name
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setTargetDatabaseName (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:target-schema-name
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setTargetSchemaName (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:new-table-name m8989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setNewTableName (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:snapshot-identifier
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setSnapshotIdentifier (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:cluster-identifier
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setClusterIdentifier (clojure.core/str v8990))))
   bean8988))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m8992]
  (clojure.core/let
   [bean8991
    (new
     com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest)]
   (clojure.core/let
    [v8993 (:enabled m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setEnabled (clojure.core/boolean v8993))))
   (clojure.core/let
    [v8993
     (:source-type m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setSourceType (clojure.core/str v8993))))
   (clojure.core/let
    [v8993
     (:sns-topic-arn m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setSnsTopicArn (clojure.core/str v8993))))
   (clojure.core/let
    [v8993
     (:source-ids m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (.
      bean8991
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9072] (clojure.core/str arg9072))
 v8993))))
   (clojure.core/let
    [v8993
     (:event-categories
      m8992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (.
      bean8991
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9073] (clojure.core/str arg9073))
 v8993))))
   (clojure.core/let
    [v8993
     (:severity m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setSeverity (clojure.core/str v8993))))
   (clojure.core/let
    [v8993
     (:subscription-name
      m8992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setSubscriptionName (clojure.core/str v8993))))
   bean8991))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest}
create-hsm-configuration-request
  [m8995]
  (clojure.core/let
   [bean8994
    (new
     com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest)]
   (clojure.core/let
    [v8996
     (:description m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setDescription (clojure.core/str v8996))))
   (clojure.core/let
    [v8996 (:tags m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (.
      bean8994
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9074] (redshift/tag arg9074))
 v8996))))
   (clojure.core/let
    [v8996
     (:hsm-ip-address m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setHsmIpAddress (clojure.core/str v8996))))
   (clojure.core/let
    [v8996
     (:hsm-partition-name
      m8995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setHsmPartitionName (clojure.core/str v8996))))
   (clojure.core/let
    [v8996
     (:hsm-partition-password
      m8995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setHsmPartitionPassword (clojure.core/str v8996))))
   (clojure.core/let
    [v8996
     (:hsm-server-public-certificate
      m8995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (.
      bean8994
      setHsmServerPublicCertificate
      (clojure.core/str v8996))))
   (clojure.core/let
    [v8996
     (:hsm-configuration-identifier
      m8995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (.
      bean8994
      setHsmConfigurationIdentifier
      (clojure.core/str v8996))))
   bean8994))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest}
describe-hsm-configurations-request
  [m8998]
  (clojure.core/let
   [bean8997
    (new
     com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest)]
   (clojure.core/let
    [v8999 (:marker m8998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setMarker (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:tag-keys m8998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (.
      bean8997
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9075] (clojure.core/str arg9075))
 v8999))))
   (clojure.core/let
    [v8999
     (:max-records m8998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setMaxRecords (clojure.core/int v8999))))
   (clojure.core/let
    [v8999
     (:tag-values m8998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (.
      bean8997
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9076] (clojure.core/str arg9076))
 v8999))))
   (clojure.core/let
    [v8999
     (:hsm-configuration-identifier
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (.
      bean8997
      setHsmConfigurationIdentifier
      (clojure.core/str v8999))))
   bean8997))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest}
describe-cluster-subnet-groups-request
  [m9001]
  (clojure.core/let
   [bean9000
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/let
    [v9002 (:marker m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setMarker (clojure.core/str v9002))))
   (clojure.core/let
    [v9002
     (:tag-keys m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (.
      bean9000
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9077] (clojure.core/str arg9077))
 v9002))))
   (clojure.core/let
    [v9002
     (:max-records m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setMaxRecords (clojure.core/int v9002))))
   (clojure.core/let
    [v9002
     (:tag-values m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (.
      bean9000
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9078] (clojure.core/str arg9078))
 v9002))))
   (clojure.core/let
    [v9002
     (:cluster-subnet-group-name
      m9001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setClusterSubnetGroupName (clojure.core/str v9002))))
   bean9000))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterRequest}
delete-cluster-request
  [m9004]
  (clojure.core/let
   [bean9003
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/let
    [v9005
     (:cluster-identifier
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setClusterIdentifier (clojure.core/str v9005))))
   (clojure.core/let
    [v9005
     (:skip-final-cluster-snapshot
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (.
      bean9003
      setSkipFinalClusterSnapshot
      (clojure.core/boolean v9005))))
   (clojure.core/let
    [v9005
     (:final-cluster-snapshot-identifier
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (.
      bean9003
      setFinalClusterSnapshotIdentifier
      (clojure.core/str v9005))))
   bean9003))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest}
revoke-cluster-security-group-ingress-request
  [m9007]
  (clojure.core/let
   [bean9006
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v9008
     (:cluster-security-group-name
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setClusterSecurityGroupName (clojure.core/str v9008))))
   (clojure.core/let
    [v9008 (:cidrip m9007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setCIDRIP (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:ec2security-group-name
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setEC2SecurityGroupName (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:ec2security-group-owner-id
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setEC2SecurityGroupOwnerId (clojure.core/str v9008))))
   bean9006))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest}
create-cluster-subnet-group-request
  [m9010]
  (clojure.core/let
   [bean9009
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/let
    [v9011
     (:description m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setDescription (clojure.core/str v9011))))
   (clojure.core/let
    [v9011 (:tags m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (.
      bean9009
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9079] (redshift/tag arg9079))
 v9011))))
   (clojure.core/let
    [v9011
     (:subnet-ids m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (.
      bean9009
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9080] (clojure.core/str arg9080))
 v9011))))
   (clojure.core/let
    [v9011
     (:cluster-subnet-group-name
      m9010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setClusterSubnetGroupName (clojure.core/str v9011))))
   bean9009))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest}
create-cluster-snapshot-request
  [m9013]
  (clojure.core/let
   [bean9012
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/let
    [v9014 (:tags m9013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (.
      bean9012
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9081] (redshift/tag arg9081))
 v9014))))
   (clojure.core/let
    [v9014
     (:snapshot-identifier
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (. bean9012 setSnapshotIdentifier (clojure.core/str v9014))))
   (clojure.core/let
    [v9014
     (:cluster-identifier
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (. bean9012 setClusterIdentifier (clojure.core/str v9014))))
   bean9012))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateTagsRequest}
create-tags-request
  [m9016]
  (clojure.core/let
   [bean9015
    (new com.amazonaws.services.redshift.model.CreateTagsRequest)]
   (clojure.core/let
    [v9017 (:tags m9016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (.
      bean9015
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9082] (redshift/tag arg9082))
 v9017))))
   (clojure.core/let
    [v9017
     (:resource-name m9016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (. bean9015 setResourceName (clojure.core/str v9017))))
   bean9015))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest}
describe-orderable-cluster-options-request
  [m9019]
  (clojure.core/let
   [bean9018
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/let
    [v9020 (:marker m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setMarker (clojure.core/str v9020))))
   (clojure.core/let
    [v9020
     (:max-records m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setMaxRecords (clojure.core/int v9020))))
   (clojure.core/let
    [v9020
     (:cluster-version
      m9019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setClusterVersion (clojure.core/str v9020))))
   (clojure.core/let
    [v9020
     (:node-type m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setNodeType (clojure.core/str v9020))))
   bean9018))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableLoggingRequest}
enable-logging-request
  [m9022]
  (clojure.core/let
   [bean9021
    (new com.amazonaws.services.redshift.model.EnableLoggingRequest)]
   (clojure.core/let
    [v9023
     (:bucket-name m9022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (. bean9021 setBucketName (clojure.core/str v9023))))
   (clojure.core/let
    [v9023
     (:cluster-identifier
      m9022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (. bean9021 setClusterIdentifier (clojure.core/str v9023))))
   (clojure.core/let
    [v9023
     (:s3key-prefix m9022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (. bean9021 setS3KeyPrefix (clojure.core/str v9023))))
   bean9021))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest}
revoke-snapshot-access-request
  [m9025]
  (clojure.core/let
   [bean9024
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/let
    [v9026
     (:snapshot-identifier
      m9025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (. bean9024 setSnapshotIdentifier (clojure.core/str v9026))))
   (clojure.core/let
    [v9026
     (:snapshot-cluster-identifier
      m9025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (.
      bean9024
      setSnapshotClusterIdentifier
      (clojure.core/str v9026))))
   (clojure.core/let
    [v9026
     (:account-with-restore-access
      m9025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (. bean9024 setAccountWithRestoreAccess (clojure.core/str v9026))))
   bean9024))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m9028]
  (clojure.core/let
   [bean9027
    (new
     com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/let
    [v9029 (:marker m9028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setMarker (clojure.core/str v9029))))
   (clojure.core/let
    [v9029
     (:max-records m9028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setMaxRecords (clojure.core/int v9029))))
   (clojure.core/let
    [v9029
     (:subscription-name
      m9028
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setSubscriptionName (clojure.core/str v9029))))
   bean9027))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest}
describe-reserved-node-offerings-request
  [m9031]
  (clojure.core/let
   [bean9030
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/let
    [v9032 (:marker m9031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (. bean9030 setMarker (clojure.core/str v9032))))
   (clojure.core/let
    [v9032
     (:max-records m9031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (. bean9030 setMaxRecords (clojure.core/int v9032))))
   (clojure.core/let
    [v9032
     (:reserved-node-offering-id
      m9031
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (. bean9030 setReservedNodeOfferingId (clojure.core/str v9032))))
   bean9030))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest}
delete-hsm-configuration-request
  [m9034]
  (clojure.core/let
   [bean9033
    (new
     com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest)]
   (clojure.core/let
    [v9035
     (:hsm-configuration-identifier
      m9034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9035 :com.palletops.awaze.client-builder/undef)
     (.
      bean9033
      setHsmConfigurationIdentifier
      (clojure.core/str v9035))))
   bean9033))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m9037]
  (clojure.core/let
   [bean9036
    (new
     com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest)]
   (clojure.core/let
    [v9038 (:tags m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (.
      bean9036
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9187] (redshift/tag arg9187))
 v9038))))
   (clojure.core/let
    [v9038 (:enabled m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setEnabled (clojure.core/boolean v9038))))
   (clojure.core/let
    [v9038
     (:source-type m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setSourceType (clojure.core/str v9038))))
   (clojure.core/let
    [v9038
     (:sns-topic-arn m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setSnsTopicArn (clojure.core/str v9038))))
   (clojure.core/let
    [v9038
     (:source-ids m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (.
      bean9036
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9188] (clojure.core/str arg9188))
 v9038))))
   (clojure.core/let
    [v9038
     (:event-categories
      m9037
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (.
      bean9036
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9189] (clojure.core/str arg9189))
 v9038))))
   (clojure.core/let
    [v9038
     (:severity m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setSeverity (clojure.core/str v9038))))
   (clojure.core/let
    [v9038
     (:subscription-name
      m9037
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setSubscriptionName (clojure.core/str v9038))))
   bean9036))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m9083]
   (clojure.core/let
    [credentials9084 (:credentials m9083) args9085 (:args m9083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9086
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9086
       describeResize
       (redshift/describe-resize-request
        (clojure.core/nth args9085 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-resize,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeResize"}
   [credentials9088 & args9089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9090
     (com.palletops.awaze.common/aws-client :redshift credentials9088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9090
      describeResize
      (redshift/describe-resize-request (clojure.core/nth args9089 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m9091]
   (clojure.core/let
    [credentials9092 (:credentials m9091) args9093 (:args m9091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9094
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9092)]
     (clojure.core/case
      (clojure.core/count args9093)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9094
        describeClusterSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9094
        describeClusterSnapshots
        (redshift/describe-cluster-snapshots-request
         (clojure.core/nth args9093 0))))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials9096 & args9097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9098
     (com.palletops.awaze.common/aws-client :redshift credentials9096)]
    (clojure.core/case
     (clojure.core/count args9097)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9098
       describeClusterSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9098
       describeClusterSnapshots
       (redshift/describe-cluster-snapshots-request
        (clojure.core/nth args9097 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m9099]
   (clojure.core/let
    [credentials9100 (:credentials m9099) args9101 (:args m9099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9102
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9100)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9102
       describeDefaultClusterParameters
       (redshift/describe-default-cluster-parameters-request
        (clojure.core/nth args9101 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials9104 & args9105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9106
     (com.palletops.awaze.common/aws-client :redshift credentials9104)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9106
      describeDefaultClusterParameters
      (redshift/describe-default-cluster-parameters-request
       (clojure.core/nth args9105 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-client-certificate
   [m9107]
   (clojure.core/let
    [credentials9108 (:credentials m9107) args9109 (:args m9107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9110
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9108)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9110
       createHsmClientCertificate
       (redshift/create-hsm-client-certificate-request
        (clojure.core/nth args9109 0)))))))
  (clojure.core/defn
   create-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmClientCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hsm-client-certificate,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmClientCertificate"}
   [credentials9112 & args9113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9114
     (com.palletops.awaze.common/aws-client :redshift credentials9112)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9114
      createHsmClientCertificate
      (redshift/create-hsm-client-certificate-request
       (clojure.core/nth args9113 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m9115]
   (clojure.core/let
    [credentials9116 (:credentials m9115) args9117 (:args m9115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9118
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9116)]
     (clojure.core/case
      (clojure.core/count args9117)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9118
        describeClusterVersions
        (redshift/describe-cluster-versions-request
         (clojure.core/nth args9117 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9118
        describeClusterVersions))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-versions,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-versions,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials9120 & args9121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9122
     (com.palletops.awaze.common/aws-client :redshift credentials9120)]
    (clojure.core/case
     (clojure.core/count args9121)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9122
       describeClusterVersions
       (redshift/describe-cluster-versions-request
        (clojure.core/nth args9121 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9122
       describeClusterVersions))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-snapshot-copy
   [m9123]
   (clojure.core/let
    [credentials9124 (:credentials m9123) args9125 (:args m9123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9126
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9126
       enableSnapshotCopy
       (redshift/enable-snapshot-copy-request
        (clojure.core/nth args9125 0)))))))
  (clojure.core/defn
   enable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for enableSnapshotCopy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-snapshot-copy,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call enableSnapshotCopy"}
   [credentials9128 & args9129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9130
     (com.palletops.awaze.common/aws-client :redshift credentials9128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9130
      enableSnapshotCopy
      (redshift/enable-snapshot-copy-request
       (clojure.core/nth args9129 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-snapshot-copy-grant
   [m9131]
   (clojure.core/let
    [credentials9132 (:credentials m9131) args9133 (:args m9131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9134
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9132)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9134
       createSnapshotCopyGrant
       (redshift/create-snapshot-copy-grant-request
        (clojure.core/nth args9133 0)))))))
  (clojure.core/defn
   create-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for createSnapshotCopyGrant"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot-copy-grant,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call createSnapshotCopyGrant"}
   [credentials9136 & args9137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9138
     (com.palletops.awaze.common/aws-client :redshift credentials9136)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9138
      createSnapshotCopyGrant
      (redshift/create-snapshot-copy-grant-request
       (clojure.core/nth args9137 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m9139]
   (clojure.core/let
    [credentials9140 (:credentials m9139) args9141 (:args m9139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9142
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9140)]
     (clojure.core/case
      (clojure.core/count args9141)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9142
        describeClusterParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9142
        describeClusterParameterGroups
        (redshift/describe-cluster-parameter-groups-request
         (clojure.core/nth args9141 0))))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials9144 & args9145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9146
     (com.palletops.awaze.common/aws-client :redshift credentials9144)]
    (clojure.core/case
     (clojure.core/count args9145)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9146
       describeClusterParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9146
       describeClusterParameterGroups
       (redshift/describe-cluster-parameter-groups-request
        (clojure.core/nth args9145 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m9147]
   (clojure.core/let
    [credentials9148 (:credentials m9147) args9149 (:args m9147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9150
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9148)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9150
       deleteClusterParameterGroup
       (redshift/delete-cluster-parameter-group-request
        (clojure.core/nth args9149 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials9152 & args9153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9154
     (com.palletops.awaze.common/aws-client :redshift credentials9152)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9154
      deleteClusterParameterGroup
      (redshift/delete-cluster-parameter-group-request
       (clojure.core/nth args9153 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m9155]
   (clojure.core/let
    [credentials9156 (:credentials m9155) args9157 (:args m9155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9158
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9156)]
     (clojure.core/case
      (clojure.core/count args9157)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9158
        describeEvents
        (redshift/describe-events-request
         (clojure.core/nth args9157 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9158
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials9160 & args9161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9162
     (com.palletops.awaze.common/aws-client :redshift credentials9160)]
    (clojure.core/case
     (clojure.core/count args9161)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9162
       describeEvents
       (redshift/describe-events-request
        (clojure.core/nth args9161 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9162
       describeEvents))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m9163]
   (clojure.core/let
    [credentials9164 (:credentials m9163) args9165 (:args m9163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9166
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9164)]
     (clojure.core/case
      (clojure.core/count args9165)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9166
        describeReservedNodes
        (redshift/describe-reserved-nodes-request
         (clojure.core/nth args9165 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9166
        describeReservedNodes))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-nodes,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-nodes,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials9168 & args9169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9170
     (com.palletops.awaze.common/aws-client :redshift credentials9168)]
    (clojure.core/case
     (clojure.core/count args9169)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9170
       describeReservedNodes
       (redshift/describe-reserved-nodes-request
        (clojure.core/nth args9169 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9170
       describeReservedNodes))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-iam-roles
   [m9171]
   (clojure.core/let
    [credentials9172 (:credentials m9171) args9173 (:args m9171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9174
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9174
       modifyClusterIamRoles
       (redshift/modify-cluster-iam-roles-request
        (clojure.core/nth args9173 0)))))))
  (clojure.core/defn
   modify-cluster-iam-roles-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyClusterIamRoles"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-iam-roles,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-iam-roles
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyClusterIamRoles"}
   [credentials9176 & args9177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9178
     (com.palletops.awaze.common/aws-client :redshift credentials9176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9178
      modifyClusterIamRoles
      (redshift/modify-cluster-iam-roles-request
       (clojure.core/nth args9177 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-event-subscription
   [m9179]
   (clojure.core/let
    [credentials9180 (:credentials m9179) args9181 (:args m9179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9182
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9182
       deleteEventSubscription
       (redshift/delete-event-subscription-request
        (clojure.core/nth args9181 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials9184 & args9185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9186
     (com.palletops.awaze.common/aws-client :redshift credentials9184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9186
      deleteEventSubscription
      (redshift/delete-event-subscription-request
       (clojure.core/nth args9185 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m9190]
   (clojure.core/let
    [credentials9191 (:credentials m9190) args9192 (:args m9190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9193
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9193
       rebootCluster
       (redshift/reboot-cluster-request (clojure.core/nth args9192 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCluster"}
   [credentials9195 & args9196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9197
     (com.palletops.awaze.common/aws-client :redshift credentials9195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9197
      rebootCluster
      (redshift/reboot-cluster-request (clojure.core/nth args9196 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m9198]
   (clojure.core/let
    [credentials9199 (:credentials m9198) args9200 (:args m9198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9201
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9201
       createClusterSecurityGroup
       (redshift/create-cluster-security-group-request
        (clojure.core/nth args9200 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-security-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials9203 & args9204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9205
     (com.palletops.awaze.common/aws-client :redshift credentials9203)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9205
      createClusterSecurityGroup
      (redshift/create-cluster-security-group-request
       (clojure.core/nth args9204 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m9206]
   (clojure.core/let
    [credentials9207 (:credentials m9206) args9208 (:args m9206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9209
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9207)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9209
       modifyClusterParameterGroup
       (redshift/modify-cluster-parameter-group-request
        (clojure.core/nth args9208 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials9211 & args9212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9213
     (com.palletops.awaze.common/aws-client :redshift credentials9211)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9213
      modifyClusterParameterGroup
      (redshift/modify-cluster-parameter-group-request
       (clojure.core/nth args9212 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-snapshot-copy-retention-period
   [m9214]
   (clojure.core/let
    [credentials9215 (:credentials m9214) args9216 (:args m9214)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9217
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9215)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9217
       modifySnapshotCopyRetentionPeriod
       (redshift/modify-snapshot-copy-retention-period-request
        (clojure.core/nth args9216 0)))))))
  (clojure.core/defn
   modify-snapshot-copy-retention-period-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotCopyRetentionPeriod"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-snapshot-copy-retention-period,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-snapshot-copy-retention-period
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySnapshotCopyRetentionPeriod"}
   [credentials9219 & args9220]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9221
     (com.palletops.awaze.common/aws-client :redshift credentials9219)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9221
      modifySnapshotCopyRetentionPeriod
      (redshift/modify-snapshot-copy-retention-period-request
       (clojure.core/nth args9220 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-snapshot-copy-grant
   [m9222]
   (clojure.core/let
    [credentials9223 (:credentials m9222) args9224 (:args m9222)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9225
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9223)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9225
       deleteSnapshotCopyGrant
       (redshift/delete-snapshot-copy-grant-request
        (clojure.core/nth args9224 0)))))))
  (clojure.core/defn
   delete-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotCopyGrant"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot-copy-grant,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call deleteSnapshotCopyGrant"}
   [credentials9227 & args9228]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9229
     (com.palletops.awaze.common/aws-client :redshift credentials9227)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9229
      deleteSnapshotCopyGrant
      (redshift/delete-snapshot-copy-grant-request
       (clojure.core/nth args9228 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m9230]
   (clojure.core/let
    [credentials9231 (:credentials m9230) args9232 (:args m9230)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9233
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9231)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9233
       authorizeSnapshotAccess
       (redshift/authorize-snapshot-access-request
        (clojure.core/nth args9232 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-snapshot-access,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials9235 & args9236]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9237
     (com.palletops.awaze.common/aws-client :redshift credentials9235)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9237
      authorizeSnapshotAccess
      (redshift/authorize-snapshot-access-request
       (clojure.core/nth args9236 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-logging
   [m9238]
   (clojure.core/let
    [credentials9239 (:credentials m9238) args9240 (:args m9238)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9241
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9239)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9241
       disableLogging
       (redshift/disable-logging-request
        (clojure.core/nth args9240 0)))))))
  (clojure.core/defn
   disable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableLogging"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-logging,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-logging
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableLogging"}
   [credentials9243 & args9244]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9245
     (com.palletops.awaze.common/aws-client :redshift credentials9243)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9245
      disableLogging
      (redshift/disable-logging-request (clojure.core/nth args9244 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m9246]
   (clojure.core/let
    [credentials9247 (:credentials m9246) args9248 (:args m9246)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9249
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9247)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9249
       modifyClusterSubnetGroup
       (redshift/modify-cluster-subnet-group-request
        (clojure.core/nth args9248 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials9251 & args9252]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9253
     (com.palletops.awaze.common/aws-client :redshift credentials9251)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9253
      modifyClusterSubnetGroup
      (redshift/modify-cluster-subnet-group-request
       (clojure.core/nth args9252 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m9254]
   (clojure.core/let
    [credentials9255 (:credentials m9254) args9256 (:args m9254)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9257
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9255)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9257
       modifyCluster
       (redshift/modify-cluster-request (clojure.core/nth args9256 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Call modifyCluster"}
   [credentials9259 & args9260]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9261
     (com.palletops.awaze.common/aws-client :redshift credentials9259)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9261
      modifyCluster
      (redshift/modify-cluster-request (clojure.core/nth args9260 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m9262]
   (clojure.core/let
    [credentials9263 (:credentials m9262) args9264 (:args m9262)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9265
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9263)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9265
       restoreFromClusterSnapshot
       (redshift/restore-from-cluster-snapshot-request
        (clojure.core/nth args9264 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials9267 & args9268]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9269
     (com.palletops.awaze.common/aws-client :redshift credentials9267)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9269
      restoreFromClusterSnapshot
      (redshift/restore-from-cluster-snapshot-request
       (clojure.core/nth args9268 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-client-certificate
   [m9270]
   (clojure.core/let
    [credentials9271 (:credentials m9270) args9272 (:args m9270)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9273
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9271)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9273
       deleteHsmClientCertificate
       (redshift/delete-hsm-client-certificate-request
        (clojure.core/nth args9272 0)))))))
  (clojure.core/defn
   delete-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmClientCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hsm-client-certificate,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmClientCertificate"}
   [credentials9275 & args9276]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9277
     (com.palletops.awaze.common/aws-client :redshift credentials9275)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9277
      deleteHsmClientCertificate
      (redshift/delete-hsm-client-certificate-request
       (clojure.core/nth args9276 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m9278]
   (clojure.core/let
    [credentials9279 (:credentials m9278) args9280 (:args m9278)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9281
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9279)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9281
       createCluster
       (redshift/create-cluster-request (clojure.core/nth args9280 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Call createCluster"}
   [credentials9283 & args9284]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9285
     (com.palletops.awaze.common/aws-client :redshift credentials9283)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9285
      createCluster
      (redshift/create-cluster-request (clojure.core/nth args9284 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-logging-status
   [m9286]
   (clojure.core/let
    [credentials9287 (:credentials m9286) args9288 (:args m9286)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9289
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9287)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9289
       describeLoggingStatus
       (redshift/describe-logging-status-request
        (clojure.core/nth args9288 0)))))))
  (clojure.core/defn
   describe-logging-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoggingStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-logging-status,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-logging-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoggingStatus"}
   [credentials9291 & args9292]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9293
     (com.palletops.awaze.common/aws-client :redshift credentials9291)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9293
      describeLoggingStatus
      (redshift/describe-logging-status-request
       (clojure.core/nth args9292 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-table-restore-status
   [m9294]
   (clojure.core/let
    [credentials9295 (:credentials m9294) args9296 (:args m9294)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9297
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9295)]
     (clojure.core/case
      (clojure.core/count args9296)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9297
        describeTableRestoreStatus
        (redshift/describe-table-restore-status-request
         (clojure.core/nth args9296 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9297
        describeTableRestoreStatus))))))
  (clojure.core/defn
   describe-table-restore-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]
                [credentials]]),
    :doc "Generate map for describeTableRestoreStatus, describeTableRestoreStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-table-restore-status,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-table-restore-status,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-table-restore-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]
                [credentials]]),
    :doc "Call describeTableRestoreStatus, describeTableRestoreStatus"}
   [credentials9299 & args9300]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9301
     (com.palletops.awaze.common/aws-client :redshift credentials9299)]
    (clojure.core/case
     (clojure.core/count args9300)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9301
       describeTableRestoreStatus
       (redshift/describe-table-restore-status-request
        (clojure.core/nth args9300 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9301
       describeTableRestoreStatus))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-categories
   [m9302]
   (clojure.core/let
    [credentials9303 (:credentials m9302) args9304 (:args m9302)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9305
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9303)]
     (clojure.core/case
      (clojure.core/count args9304)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9305
        describeEventCategories))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9305
        describeEventCategories
        (redshift/describe-event-categories-request
         (clojure.core/nth args9304 0))))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials9307 & args9308]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9309
     (com.palletops.awaze.common/aws-client :redshift credentials9307)]
    (clojure.core/case
     (clojure.core/count args9308)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9309
       describeEventCategories))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9309
       describeEventCategories
       (redshift/describe-event-categories-request
        (clojure.core/nth args9308 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m9310]
   (clojure.core/let
    [credentials9311 (:credentials m9310) args9312 (:args m9310)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9313
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9311)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9313
       describeClusterParameters
       (redshift/describe-cluster-parameters-request
        (clojure.core/nth args9312 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameters"}
   [credentials9315 & args9316]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9317
     (com.palletops.awaze.common/aws-client :redshift credentials9315)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9317
      describeClusterParameters
      (redshift/describe-cluster-parameters-request
       (clojure.core/nth args9316 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m9318]
   (clojure.core/let
    [credentials9319 (:credentials m9318) args9320 (:args m9318)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9321
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9319)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9321
       authorizeClusterSecurityGroupIngress
       (redshift/authorize-cluster-security-group-ingress-request
        (clojure.core/nth args9320 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials9323 & args9324]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9325
     (com.palletops.awaze.common/aws-client :redshift credentials9323)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9325
      authorizeClusterSecurityGroupIngress
      (redshift/authorize-cluster-security-group-ingress-request
       (clojure.core/nth args9324 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m9326]
   (clojure.core/let
    [credentials9327 (:credentials m9326) args9328 (:args m9326)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9329
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9327)]
     (clojure.core/case
      (clojure.core/count args9328)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9329
        describeClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9329
        describeClusters
        (redshift/describe-clusters-request
         (clojure.core/nth args9328 0))))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-clusters,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-clusters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials9331 & args9332]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9333
     (com.palletops.awaze.common/aws-client :redshift credentials9331)]
    (clojure.core/case
     (clojure.core/count args9332)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9333
       describeClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9333
       describeClusters
       (redshift/describe-clusters-request
        (clojure.core/nth args9332 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m9334]
   (clojure.core/let
    [credentials9335 (:credentials m9334) args9336 (:args m9334)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9337
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9335)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9337
       deleteClusterSubnetGroup
       (redshift/delete-cluster-subnet-group-request
        (clojure.core/nth args9336 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials9339 & args9340]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9341
     (com.palletops.awaze.common/aws-client :redshift credentials9339)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9341
      deleteClusterSubnetGroup
      (redshift/delete-cluster-subnet-group-request
       (clojure.core/nth args9340 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m9342]
   (clojure.core/let
    [credentials9343 (:credentials m9342) args9344 (:args m9342)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9345
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9343)]
     (clojure.core/case
      (clojure.core/count args9344)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9345
        describeClusterSecurityGroups
        (redshift/describe-cluster-security-groups-request
         (clojure.core/nth args9344 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9345
        describeClusterSecurityGroups))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials9347 & args9348]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9349
     (com.palletops.awaze.common/aws-client :redshift credentials9347)]
    (clojure.core/case
     (clojure.core/count args9348)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9349
       describeClusterSecurityGroups
       (redshift/describe-cluster-security-groups-request
        (clojure.core/nth args9348 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9349
       describeClusterSecurityGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-tags
   [m9350]
   (clojure.core/let
    [credentials9351 (:credentials m9350) args9352 (:args m9350)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9353
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9351)]
     (clojure.core/case
      (clojure.core/count args9352)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9353
        describeTags
        (redshift/describe-tags-request (clojure.core/nth args9352 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9353
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials9355 & args9356]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9357
     (com.palletops.awaze.common/aws-client :redshift credentials9355)]
    (clojure.core/case
     (clojure.core/count args9356)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9357
       describeTags
       (redshift/describe-tags-request (clojure.core/nth args9356 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9357
       describeTags))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-snapshot-copy
   [m9358]
   (clojure.core/let
    [credentials9359 (:credentials m9358) args9360 (:args m9358)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9361
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9359)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9361
       disableSnapshotCopy
       (redshift/disable-snapshot-copy-request
        (clojure.core/nth args9360 0)))))))
  (clojure.core/defn
   disable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableSnapshotCopy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-snapshot-copy,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableSnapshotCopy"}
   [credentials9363 & args9364]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9365
     (com.palletops.awaze.common/aws-client :redshift credentials9363)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9365
      disableSnapshotCopy
      (redshift/disable-snapshot-copy-request
       (clojure.core/nth args9364 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-tags
   [m9366]
   (clojure.core/let
    [credentials9367 (:credentials m9366) args9368 (:args m9366)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9369
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9367)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9369
       deleteTags
       (redshift/delete-tags-request (clojure.core/nth args9368 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials9371 & args9372]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9373
     (com.palletops.awaze.common/aws-client :redshift credentials9371)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9373
      deleteTags
      (redshift/delete-tags-request (clojure.core/nth args9372 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m9374]
   (clojure.core/let
    [credentials9375 (:credentials m9374) args9376 (:args m9374)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9377
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9375)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9377
       purchaseReservedNodeOffering
       (redshift/purchase-reserved-node-offering-request
        (clojure.core/nth args9376 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials9379 & args9380]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9381
     (com.palletops.awaze.common/aws-client :redshift credentials9379)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9381
      purchaseReservedNodeOffering
      (redshift/purchase-reserved-node-offering-request
       (clojure.core/nth args9380 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m9382]
   (clojure.core/let
    [credentials9383 (:credentials m9382) args9384 (:args m9382)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9385
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9383)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9385
       deleteClusterSnapshot
       (redshift/delete-cluster-snapshot-request
        (clojure.core/nth args9384 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials9387 & args9388]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9389
     (com.palletops.awaze.common/aws-client :redshift credentials9387)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9389
      deleteClusterSnapshot
      (redshift/delete-cluster-snapshot-request
       (clojure.core/nth args9388 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m9390]
   (clojure.core/let
    [credentials9391 (:credentials m9390) args9392 (:args m9390)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9393
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9391)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9393
       createClusterParameterGroup
       (redshift/create-cluster-parameter-group-request
        (clojure.core/nth args9392 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials9395 & args9396]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9397
     (com.palletops.awaze.common/aws-client :redshift credentials9395)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9397
      createClusterParameterGroup
      (redshift/create-cluster-parameter-group-request
       (clojure.core/nth args9396 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :rotate-encryption-key
   [m9398]
   (clojure.core/let
    [credentials9399 (:credentials m9398) args9400 (:args m9398)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9401
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9399)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9401
       rotateEncryptionKey
       (redshift/rotate-encryption-key-request
        (clojure.core/nth args9400 0)))))))
  (clojure.core/defn
   rotate-encryption-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rotateEncryptionKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :rotate-encryption-key,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   rotate-encryption-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rotateEncryptionKey"}
   [credentials9403 & args9404]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9405
     (com.palletops.awaze.common/aws-client :redshift credentials9403)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9405
      rotateEncryptionKey
      (redshift/rotate-encryption-key-request
       (clojure.core/nth args9404 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-client-certificates
   [m9406]
   (clojure.core/let
    [credentials9407 (:credentials m9406) args9408 (:args m9406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9409
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9407)]
     (clojure.core/case
      (clojure.core/count args9408)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9409
        describeHsmClientCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9409
        describeHsmClientCertificates
        (redshift/describe-hsm-client-certificates-request
         (clojure.core/nth args9408 0))))))))
  (clojure.core/defn
   describe-hsm-client-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeHsmClientCertificates, describeHsmClientCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-client-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeHsmClientCertificates, describeHsmClientCertificates"}
   [credentials9411 & args9412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9413
     (com.palletops.awaze.common/aws-client :redshift credentials9411)]
    (clojure.core/case
     (clojure.core/count args9412)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9413
       describeHsmClientCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9413
       describeHsmClientCertificates
       (redshift/describe-hsm-client-certificates-request
        (clojure.core/nth args9412 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-snapshot-copy-grants
   [m9414]
   (clojure.core/let
    [credentials9415 (:credentials m9414) args9416 (:args m9414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9417
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9415)]
     (clojure.core/case
      (clojure.core/count args9416)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9417
        describeSnapshotCopyGrants))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9417
        describeSnapshotCopyGrants
        (redshift/describe-snapshot-copy-grants-request
         (clojure.core/nth args9416 0))))))))
  (clojure.core/defn
   describe-snapshot-copy-grants-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-snapshot-copy-grants
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   [credentials9419 & args9420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9421
     (com.palletops.awaze.common/aws-client :redshift credentials9419)]
    (clojure.core/case
     (clojure.core/count args9420)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9421
       describeSnapshotCopyGrants))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9421
       describeSnapshotCopyGrants
       (redshift/describe-snapshot-copy-grants-request
        (clojure.core/nth args9420 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m9422]
   (clojure.core/let
    [credentials9423 (:credentials m9422) args9424 (:args m9422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9425
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9425
       resetClusterParameterGroup
       (redshift/reset-cluster-parameter-group-request
        (clojure.core/nth args9424 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials9427 & args9428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9429
     (com.palletops.awaze.common/aws-client :redshift credentials9427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9429
      resetClusterParameterGroup
      (redshift/reset-cluster-parameter-group-request
       (clojure.core/nth args9428 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m9430]
   (clojure.core/let
    [credentials9431 (:credentials m9430) args9432 (:args m9430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9433
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9433
       deleteClusterSecurityGroup
       (redshift/delete-cluster-security-group-request
        (clojure.core/nth args9432 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-security-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials9435 & args9436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9437
     (com.palletops.awaze.common/aws-client :redshift credentials9435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9437
      deleteClusterSecurityGroup
      (redshift/delete-cluster-security-group-request
       (clojure.core/nth args9436 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m9438]
   (clojure.core/let
    [credentials9439 (:credentials m9438) args9440 (:args m9438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9441
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9441
       copyClusterSnapshot
       (redshift/copy-cluster-snapshot-request
        (clojure.core/nth args9440 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials9443 & args9444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9445
     (com.palletops.awaze.common/aws-client :redshift credentials9443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9445
      copyClusterSnapshot
      (redshift/copy-cluster-snapshot-request
       (clojure.core/nth args9444 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-table-from-cluster-snapshot
   [m9446]
   (clojure.core/let
    [credentials9447 (:credentials m9446) args9448 (:args m9446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9449
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9449
       restoreTableFromClusterSnapshot
       (redshift/restore-table-from-cluster-snapshot-request
        (clojure.core/nth args9448 0)))))))
  (clojure.core/defn
   restore-table-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Generate map for restoreTableFromClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-table-from-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-table-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Call restoreTableFromClusterSnapshot"}
   [credentials9451 & args9452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9453
     (com.palletops.awaze.common/aws-client :redshift credentials9451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9453
      restoreTableFromClusterSnapshot
      (redshift/restore-table-from-cluster-snapshot-request
       (clojure.core/nth args9452 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-event-subscription
   [m9454]
   (clojure.core/let
    [credentials9455 (:credentials m9454) args9456 (:args m9454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9457
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9455)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9457
       modifyEventSubscription
       (redshift/modify-event-subscription-request
        (clojure.core/nth args9456 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials9459 & args9460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9461
     (com.palletops.awaze.common/aws-client :redshift credentials9459)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9461
      modifyEventSubscription
      (redshift/modify-event-subscription-request
       (clojure.core/nth args9460 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-configuration
   [m9462]
   (clojure.core/let
    [credentials9463 (:credentials m9462) args9464 (:args m9462)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9465
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9463)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9465
       createHsmConfiguration
       (redshift/create-hsm-configuration-request
        (clojure.core/nth args9464 0)))))))
  (clojure.core/defn
   create-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hsm-configuration,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmConfiguration"}
   [credentials9467 & args9468]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9469
     (com.palletops.awaze.common/aws-client :redshift credentials9467)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9469
      createHsmConfiguration
      (redshift/create-hsm-configuration-request
       (clojure.core/nth args9468 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-configurations
   [m9470]
   (clojure.core/let
    [credentials9471 (:credentials m9470) args9472 (:args m9470)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9473
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9471)]
     (clojure.core/case
      (clojure.core/count args9472)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9473
        describeHsmConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9473
        describeHsmConfigurations
        (redshift/describe-hsm-configurations-request
         (clojure.core/nth args9472 0))))))))
  (clojure.core/defn
   describe-hsm-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeHsmConfigurations, describeHsmConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hsm-configurations,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hsm-configurations,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeHsmConfigurations, describeHsmConfigurations"}
   [credentials9475 & args9476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9477
     (com.palletops.awaze.common/aws-client :redshift credentials9475)]
    (clojure.core/case
     (clojure.core/count args9476)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9477
       describeHsmConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9477
       describeHsmConfigurations
       (redshift/describe-hsm-configurations-request
        (clojure.core/nth args9476 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m9478]
   (clojure.core/let
    [credentials9479 (:credentials m9478) args9480 (:args m9478)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9481
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9479)]
     (clojure.core/case
      (clojure.core/count args9480)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9481
        describeClusterSubnetGroups
        (redshift/describe-cluster-subnet-groups-request
         (clojure.core/nth args9480 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9481
        describeClusterSubnetGroups))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials9483 & args9484]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9485
     (com.palletops.awaze.common/aws-client :redshift credentials9483)]
    (clojure.core/case
     (clojure.core/count args9484)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9485
       describeClusterSubnetGroups
       (redshift/describe-cluster-subnet-groups-request
        (clojure.core/nth args9484 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9485
       describeClusterSubnetGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m9486]
   (clojure.core/let
    [credentials9487 (:credentials m9486) args9488 (:args m9486)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9489
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9487)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9489
       deleteCluster
       (redshift/delete-cluster-request (clojure.core/nth args9488 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCluster"}
   [credentials9491 & args9492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9493
     (com.palletops.awaze.common/aws-client :redshift credentials9491)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9493
      deleteCluster
      (redshift/delete-cluster-request (clojure.core/nth args9492 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m9494]
   (clojure.core/let
    [credentials9495 (:credentials m9494) args9496 (:args m9494)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9497
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9495)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9497
       revokeClusterSecurityGroupIngress
       (redshift/revoke-cluster-security-group-ingress-request
        (clojure.core/nth args9496 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials9499 & args9500]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9501
     (com.palletops.awaze.common/aws-client :redshift credentials9499)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9501
      revokeClusterSecurityGroupIngress
      (redshift/revoke-cluster-security-group-ingress-request
       (clojure.core/nth args9500 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m9502]
   (clojure.core/let
    [credentials9503 (:credentials m9502) args9504 (:args m9502)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9505
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9503)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9505
       createClusterSubnetGroup
       (redshift/create-cluster-subnet-group-request
        (clojure.core/nth args9504 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials9507 & args9508]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9509
     (com.palletops.awaze.common/aws-client :redshift credentials9507)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9509
      createClusterSubnetGroup
      (redshift/create-cluster-subnet-group-request
       (clojure.core/nth args9508 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m9510]
   (clojure.core/let
    [credentials9511 (:credentials m9510) args9512 (:args m9510)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9513
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9511)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9513
       createClusterSnapshot
       (redshift/create-cluster-snapshot-request
        (clojure.core/nth args9512 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials9515 & args9516]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9517
     (com.palletops.awaze.common/aws-client :redshift credentials9515)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9517
      createClusterSnapshot
      (redshift/create-cluster-snapshot-request
       (clojure.core/nth args9516 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-tags
   [m9518]
   (clojure.core/let
    [credentials9519 (:credentials m9518) args9520 (:args m9518)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9521
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9519)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9521
       createTags
       (redshift/create-tags-request (clojure.core/nth args9520 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials9523 & args9524]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9525
     (com.palletops.awaze.common/aws-client :redshift credentials9523)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9525
      createTags
      (redshift/create-tags-request (clojure.core/nth args9524 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m9526]
   (clojure.core/let
    [credentials9527 (:credentials m9526) args9528 (:args m9526)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9529
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9527)]
     (clojure.core/case
      (clojure.core/count args9528)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9529
        describeOrderableClusterOptions
        (redshift/describe-orderable-cluster-options-request
         (clojure.core/nth args9528 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9529
        describeOrderableClusterOptions))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials9531 & args9532]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9533
     (com.palletops.awaze.common/aws-client :redshift credentials9531)]
    (clojure.core/case
     (clojure.core/count args9532)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9533
       describeOrderableClusterOptions
       (redshift/describe-orderable-cluster-options-request
        (clojure.core/nth args9532 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9533
       describeOrderableClusterOptions))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-logging
   [m9534]
   (clojure.core/let
    [credentials9535 (:credentials m9534) args9536 (:args m9534)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9537
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9535)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9537
       enableLogging
       (redshift/enable-logging-request (clojure.core/nth args9536 0)))))))
  (clojure.core/defn
   enable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableLogging"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-logging,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-logging
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call enableLogging"}
   [credentials9539 & args9540]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9541
     (com.palletops.awaze.common/aws-client :redshift credentials9539)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9541
      enableLogging
      (redshift/enable-logging-request (clojure.core/nth args9540 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m9542]
   (clojure.core/let
    [credentials9543 (:credentials m9542) args9544 (:args m9542)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9545
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9543)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9545
       revokeSnapshotAccess
       (redshift/revoke-snapshot-access-request
        (clojure.core/nth args9544 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-snapshot-access,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials9547 & args9548]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9549
     (com.palletops.awaze.common/aws-client :redshift credentials9547)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9549
      revokeSnapshotAccess
      (redshift/revoke-snapshot-access-request
       (clojure.core/nth args9548 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-subscriptions
   [m9550]
   (clojure.core/let
    [credentials9551 (:credentials m9550) args9552 (:args m9550)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9553
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9551)]
     (clojure.core/case
      (clojure.core/count args9552)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9553
        describeEventSubscriptions
        (redshift/describe-event-subscriptions-request
         (clojure.core/nth args9552 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9553
        describeEventSubscriptions))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials9555 & args9556]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9557
     (com.palletops.awaze.common/aws-client :redshift credentials9555)]
    (clojure.core/case
     (clojure.core/count args9556)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9557
       describeEventSubscriptions
       (redshift/describe-event-subscriptions-request
        (clojure.core/nth args9556 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9557
       describeEventSubscriptions))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m9558]
   (clojure.core/let
    [credentials9559 (:credentials m9558) args9560 (:args m9558)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9561
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9559)]
     (clojure.core/case
      (clojure.core/count args9560)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9561
        describeReservedNodeOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9561
        describeReservedNodeOfferings
        (redshift/describe-reserved-node-offerings-request
         (clojure.core/nth args9560 0))))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials9563 & args9564]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9565
     (com.palletops.awaze.common/aws-client :redshift credentials9563)]
    (clojure.core/case
     (clojure.core/count args9564)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9565
       describeReservedNodeOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9565
       describeReservedNodeOfferings
       (redshift/describe-reserved-node-offerings-request
        (clojure.core/nth args9564 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-configuration
   [m9566]
   (clojure.core/let
    [credentials9567 (:credentials m9566) args9568 (:args m9566)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9569
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9567)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9569
       deleteHsmConfiguration
       (redshift/delete-hsm-configuration-request
        (clojure.core/nth args9568 0)))))))
  (clojure.core/defn
   delete-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hsm-configuration,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmConfiguration"}
   [credentials9571 & args9572]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9573
     (com.palletops.awaze.common/aws-client :redshift credentials9571)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9573
      deleteHsmConfiguration
      (redshift/delete-hsm-configuration-request
       (clojure.core/nth args9572 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-event-subscription
   [m9574]
   (clojure.core/let
    [credentials9575 (:credentials m9574) args9576 (:args m9574)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9577
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9575)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9577
       createEventSubscription
       (redshift/create-event-subscription-request
        (clojure.core/nth args9576 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call createEventSubscription"}
   [credentials9579 & args9580]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9581
     (com.palletops.awaze.common/aws-client :redshift credentials9579)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9581
      createEventSubscription
      (redshift/create-event-subscription-request
       (clojure.core/nth args9580 0))))))))
