(ns
 com.palletops.awaze.iam
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.iam :as iam]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1792__auto__))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m12301]
   (clojure.core/let
    [credentials12302 (:credentials m12301) args12303 (:args m12301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12304
      (com.palletops.awaze.common/aws-client :iam credentials12302)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12304
       listGroupsForUser
       (identitymanagement/list-groups-for-user-request
        (clojure.core/nth args12303 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-groups-for-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupsForUser"}
   [credentials12306 & args12307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12308
     (com.palletops.awaze.common/aws-client :iam credentials12306)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12308
      listGroupsForUser
      (identitymanagement/list-groups-for-user-request
       (clojure.core/nth args12307 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m12309]
   (clojure.core/let
    [credentials12310 (:credentials m12309) args12311 (:args m12309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12312
      (com.palletops.awaze.common/aws-client :iam credentials12310)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12312
       createUser
       (identitymanagement/create-user-request
        (clojure.core/nth args12311 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createUser"}
   [credentials12314 & args12315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12316
     (com.palletops.awaze.common/aws-client :iam credentials12314)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12316
      createUser
      (identitymanagement/create-user-request
       (clojure.core/nth args12315 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-credential-report
   [m12317]
   (clojure.core/let
    [credentials12318 (:credentials m12317) args12319 (:args m12317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12320
      (com.palletops.awaze.common/aws-client :iam credentials12318)]
     (clojure.core/case
      (clojure.core/count args12319)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12320
        getCredentialReport))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12320
        getCredentialReport
        (identitymanagement/get-credential-report-request
         (clojure.core/nth args12319 0))))))))
  (clojure.core/defn
   get-credential-report-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCredentialReport, getCredentialReport"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-credential-report
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCredentialReport, getCredentialReport"}
   [credentials12322 & args12323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12324
     (com.palletops.awaze.common/aws-client :iam credentials12322)]
    (clojure.core/case
     (clojure.core/count args12323)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12324
       getCredentialReport))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12324
       getCredentialReport
       (identitymanagement/get-credential-report-request
        (clojure.core/nth args12323 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-open-idconnect-provider
   [m12325]
   (clojure.core/let
    [credentials12326 (:credentials m12325) args12327 (:args m12325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12328
      (com.palletops.awaze.common/aws-client :iam credentials12326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12328
       getOpenIDConnectProvider
       (identitymanagement/get-open-idconnect-provider-request
        (clojure.core/nth args12327 0)))))))
  (clojure.core/defn
   get-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getOpenIDConnectProvider"}
   [credentials12330 & args12331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12332
     (com.palletops.awaze.common/aws-client :iam credentials12330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12332
      getOpenIDConnectProvider
      (identitymanagement/get-open-idconnect-provider-request
       (clojure.core/nth args12331 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m12333]
   (clojure.core/let
    [credentials12334 (:credentials m12333) args12335 (:args m12333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12336
      (com.palletops.awaze.common/aws-client :iam credentials12334)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12336
       deleteSigningCertificate
       (identitymanagement/delete-signing-certificate-request
        (clojure.core/nth args12335 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials12338 & args12339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12340
     (com.palletops.awaze.common/aws-client :iam credentials12338)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12340
      deleteSigningCertificate
      (identitymanagement/delete-signing-certificate-request
       (clojure.core/nth args12339 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m12341]
   (clojure.core/let
    [credentials12342 (:credentials m12341) args12343 (:args m12341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12344
      (com.palletops.awaze.common/aws-client :iam credentials12342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12344
       changePassword
       (identitymanagement/change-password-request
        (clojure.core/nth args12343 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-password,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Call changePassword"}
   [credentials12346 & args12347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12348
     (com.palletops.awaze.common/aws-client :iam credentials12346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12348
      changePassword
      (identitymanagement/change-password-request
       (clojure.core/nth args12347 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m12349]
   (clojure.core/let
    [credentials12350 (:credentials m12349) args12351 (:args m12349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12352
      (com.palletops.awaze.common/aws-client :iam credentials12350)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12352
       listInstanceProfilesForRole
       (identitymanagement/list-instance-profiles-for-role-request
        (clojure.core/nth args12351 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials12354 & args12355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12356
     (com.palletops.awaze.common/aws-client :iam credentials12354)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12356
      listInstanceProfilesForRole
      (identitymanagement/list-instance-profiles-for-role-request
       (clojure.core/nth args12355 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m12357]
   (clojure.core/let
    [credentials12358 (:credentials m12357) args12359 (:args m12357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12360
      (com.palletops.awaze.common/aws-client :iam credentials12358)]
     (clojure.core/case
      (clojure.core/count args12359)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12360
        listInstanceProfiles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12360
        listInstanceProfiles
        (identitymanagement/list-instance-profiles-request
         (clojure.core/nth args12359 0))))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-instance-profiles,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-profiles,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials12362 & args12363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12364
     (com.palletops.awaze.common/aws-client :iam credentials12362)]
    (clojure.core/case
     (clojure.core/count args12363)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12364
       listInstanceProfiles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12364
       listInstanceProfiles
       (identitymanagement/list-instance-profiles-request
        (clojure.core/nth args12363 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :set-default-policy-version
   [m12365]
   (clojure.core/let
    [credentials12366 (:credentials m12365) args12367 (:args m12365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12368
      (com.palletops.awaze.common/aws-client :iam credentials12366)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12368
       setDefaultPolicyVersion
       (identitymanagement/set-default-policy-version-request
        (clojure.core/nth args12367 0)))))))
  (clojure.core/defn
   set-default-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDefaultPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-default-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   set-default-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call setDefaultPolicyVersion"}
   [credentials12370 & args12371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12372
     (com.palletops.awaze.common/aws-client :iam credentials12370)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12372
      setDefaultPolicyVersion
      (identitymanagement/set-default-policy-version-request
       (clojure.core/nth args12371 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m12373]
   (clojure.core/let
    [credentials12374 (:credentials m12373) args12375 (:args m12373)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12376
      (com.palletops.awaze.common/aws-client :iam credentials12374)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12376
       deleteUserPolicy
       (identitymanagement/delete-user-policy-request
        (clojure.core/nth args12375 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials12378 & args12379]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12380
     (com.palletops.awaze.common/aws-client :iam credentials12378)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12380
      deleteUserPolicy
      (identitymanagement/delete-user-policy-request
       (clojure.core/nth args12379 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-access-key-last-used
   [m12381]
   (clojure.core/let
    [credentials12382 (:credentials m12381) args12383 (:args m12381)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12384
      (com.palletops.awaze.common/aws-client :iam credentials12382)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12384
       getAccessKeyLastUsed
       (identitymanagement/get-access-key-last-used-request
        (clojure.core/nth args12383 0)))))))
  (clojure.core/defn
   get-access-key-last-used-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for getAccessKeyLastUsed"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-access-key-last-used,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-access-key-last-used
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call getAccessKeyLastUsed"}
   [credentials12386 & args12387]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12388
     (com.palletops.awaze.common/aws-client :iam credentials12386)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12388
      getAccessKeyLastUsed
      (identitymanagement/get-access-key-last-used-request
       (clojure.core/nth args12387 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-group-policy
   [m12389]
   (clojure.core/let
    [credentials12390 (:credentials m12389) args12391 (:args m12389)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12392
      (com.palletops.awaze.common/aws-client :iam credentials12390)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12392
       attachGroupPolicy
       (identitymanagement/attach-group-policy-request
        (clojure.core/nth args12391 0)))))))
  (clojure.core/defn
   attach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachGroupPolicy"}
   [credentials12394 & args12395]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12396
     (com.palletops.awaze.common/aws-client :iam credentials12394)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12396
      attachGroupPolicy
      (identitymanagement/attach-group-policy-request
       (clojure.core/nth args12395 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m12397]
   (clojure.core/let
    [credentials12398 (:credentials m12397) args12399 (:args m12397)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12400
      (com.palletops.awaze.common/aws-client :iam credentials12398)]
     (clojure.core/case
      (clojure.core/count args12399)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12400
        getUser))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12400
        getUser
        (identitymanagement/get-user-request
         (clojure.core/nth args12399 0))))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-user,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getUser, getUser"}
   [credentials12402 & args12403]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12404
     (com.palletops.awaze.common/aws-client :iam credentials12402)]
    (clojure.core/case
     (clojure.core/count args12403)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12404
       getUser))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12404
       getUser
       (identitymanagement/get-user-request
        (clojure.core/nth args12403 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :generate-credential-report
   [m12405]
   (clojure.core/let
    [credentials12406 (:credentials m12405) args12407 (:args m12405)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12408
      (com.palletops.awaze.common/aws-client :iam credentials12406)]
     (clojure.core/case
      (clojure.core/count args12407)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12408
        generateCredentialReport))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12408
        generateCredentialReport
        (identitymanagement/generate-credential-report-request
         (clojure.core/nth args12407 0))))))))
  (clojure.core/defn
   generate-credential-report-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for generateCredentialReport, generateCredentialReport"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :generate-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :generate-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   generate-credential-report
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call generateCredentialReport, generateCredentialReport"}
   [credentials12410 & args12411]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12412
     (com.palletops.awaze.common/aws-client :iam credentials12410)]
    (clojure.core/case
     (clojure.core/count args12411)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12412
       generateCredentialReport))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12412
       generateCredentialReport
       (identitymanagement/generate-credential-report-request
        (clojure.core/nth args12411 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-sshpublic-key
   [m12413]
   (clojure.core/let
    [credentials12414 (:credentials m12413) args12415 (:args m12413)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12416
      (com.palletops.awaze.common/aws-client :iam credentials12414)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12416
       getSSHPublicKey
       (identitymanagement/get-sshpublic-key-request
        (clojure.core/nth args12415 0)))))))
  (clojure.core/defn
   get-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSSHPublicKey"}
   [credentials12418 & args12419]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12420
     (com.palletops.awaze.common/aws-client :iam credentials12418)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12420
      getSSHPublicKey
      (identitymanagement/get-sshpublic-key-request
       (clojure.core/nth args12419 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m12421]
   (clojure.core/let
    [credentials12422 (:credentials m12421) args12423 (:args m12421)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12424
      (com.palletops.awaze.common/aws-client :iam credentials12422)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12424
       createAccountAlias
       (identitymanagement/create-account-alias-request
        (clojure.core/nth args12423 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-account-alias,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call createAccountAlias"}
   [credentials12426 & args12427]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12428
     (com.palletops.awaze.common/aws-client :iam credentials12426)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12428
      createAccountAlias
      (identitymanagement/create-account-alias-request
       (clojure.core/nth args12427 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-samlprovider
   [m12429]
   (clojure.core/let
    [credentials12430 (:credentials m12429) args12431 (:args m12429)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12432
      (com.palletops.awaze.common/aws-client :iam credentials12430)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12432
       getSAMLProvider
       (identitymanagement/get-samlprovider-request
        (clojure.core/nth args12431 0)))))))
  (clojure.core/defn
   get-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSAMLProvider"}
   [credentials12434 & args12435]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12436
     (com.palletops.awaze.common/aws-client :iam credentials12434)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12436
      getSAMLProvider
      (identitymanagement/get-samlprovider-request
       (clojure.core/nth args12435 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy-version
   [m12437]
   (clojure.core/let
    [credentials12438 (:credentials m12437) args12439 (:args m12437)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12440
      (com.palletops.awaze.common/aws-client :iam credentials12438)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12440
       getPolicyVersion
       (identitymanagement/get-policy-version-request
        (clojure.core/nth args12439 0)))))))
  (clojure.core/defn
   get-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicyVersion"}
   [credentials12442 & args12443]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12444
     (com.palletops.awaze.common/aws-client :iam credentials12442)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12444
      getPolicyVersion
      (identitymanagement/get-policy-version-request
       (clojure.core/nth args12443 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m12445]
   (clojure.core/let
    [credentials12446 (:credentials m12445) args12447 (:args m12445)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12448
      (com.palletops.awaze.common/aws-client :iam credentials12446)]
     (clojure.core/case
      (clojure.core/count args12447)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12448
        listMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12448
        listMFADevices
        (identitymanagement/list-mfadevices-request
         (clojure.core/nth args12447 0))))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials12450 & args12451]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12452
     (com.palletops.awaze.common/aws-client :iam credentials12450)]
    (clojure.core/case
     (clojure.core/count args12451)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12452
       listMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12452
       listMFADevices
       (identitymanagement/list-mfadevices-request
        (clojure.core/nth args12451 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m12453]
   (clojure.core/let
    [credentials12454 (:credentials m12453) args12455 (:args m12453)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12456
      (com.palletops.awaze.common/aws-client :iam credentials12454)]
     (clojure.core/case
      (clojure.core/count args12455)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12456
        listServerCertificates
        (identitymanagement/list-server-certificates-request
         (clojure.core/nth args12455 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12456
        listServerCertificates))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-server-certificates,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-server-certificates,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials12458 & args12459]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12460
     (com.palletops.awaze.common/aws-client :iam credentials12458)]
    (clojure.core/case
     (clojure.core/count args12459)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12460
       listServerCertificates
       (identitymanagement/list-server-certificates-request
        (clojure.core/nth args12459 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12460
       listServerCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m12461]
   (clojure.core/let
    [credentials12462 (:credentials m12461) args12463 (:args m12461)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12464
      (com.palletops.awaze.common/aws-client :iam credentials12462)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12464
       putGroupPolicy
       (identitymanagement/put-group-policy-request
        (clojure.core/nth args12463 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putGroupPolicy"}
   [credentials12466 & args12467]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12468
     (com.palletops.awaze.common/aws-client :iam credentials12466)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12468
      putGroupPolicy
      (identitymanagement/put-group-policy-request
       (clojure.core/nth args12467 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-authorization-details
   [m12469]
   (clojure.core/let
    [credentials12470 (:credentials m12469) args12471 (:args m12469)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12472
      (com.palletops.awaze.common/aws-client :iam credentials12470)]
     (clojure.core/case
      (clojure.core/count args12471)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12472
        getAccountAuthorizationDetails))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12472
        getAccountAuthorizationDetails
        (identitymanagement/get-account-authorization-details-request
         (clojure.core/nth args12471 0))))))))
  (clojure.core/defn
   get-account-authorization-details-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-authorization-details,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-authorization-details,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-authorization-details
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   [credentials12474 & args12475]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12476
     (com.palletops.awaze.common/aws-client :iam credentials12474)]
    (clojure.core/case
     (clojure.core/count args12475)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12476
       getAccountAuthorizationDetails))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12476
       getAccountAuthorizationDetails
       (identitymanagement/get-account-authorization-details-request
        (clojure.core/nth args12475 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m12477]
   (clojure.core/let
    [credentials12478 (:credentials m12477) args12479 (:args m12477)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12480
      (com.palletops.awaze.common/aws-client :iam credentials12478)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12480
       deleteGroupPolicy
       (identitymanagement/delete-group-policy-request
        (clojure.core/nth args12479 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials12482 & args12483]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12484
     (com.palletops.awaze.common/aws-client :iam credentials12482)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12484
      deleteGroupPolicy
      (identitymanagement/delete-group-policy-request
       (clojure.core/nth args12483 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-open-idconnect-providers
   [m12485]
   (clojure.core/let
    [credentials12486 (:credentials m12485) args12487 (:args m12485)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12488
      (com.palletops.awaze.common/aws-client :iam credentials12486)]
     (clojure.core/case
      (clojure.core/count args12487)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12488
        listOpenIDConnectProviders))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12488
        listOpenIDConnectProviders
        (identitymanagement/list-open-idconnect-providers-request
         (clojure.core/nth args12487 0))))))))
  (clojure.core/defn
   list-open-idconnect-providers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listOpenIDConnectProviders, listOpenIDConnectProviders"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-open-idconnect-providers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listOpenIDConnectProviders, listOpenIDConnectProviders"}
   [credentials12490 & args12491]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12492
     (com.palletops.awaze.common/aws-client :iam credentials12490)]
    (clojure.core/case
     (clojure.core/count args12491)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12492
       listOpenIDConnectProviders))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12492
       listOpenIDConnectProviders
       (identitymanagement/list-open-idconnect-providers-request
        (clojure.core/nth args12491 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m12493]
   (clojure.core/let
    [credentials12494 (:credentials m12493) args12495 (:args m12493)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12496
      (com.palletops.awaze.common/aws-client :iam credentials12494)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12496
       listRolePolicies
       (identitymanagement/list-role-policies-request
        (clojure.core/nth args12495 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-role-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRolePolicies"}
   [credentials12498 & args12499]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12500
     (com.palletops.awaze.common/aws-client :iam credentials12498)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12500
      listRolePolicies
      (identitymanagement/list-role-policies-request
       (clojure.core/nth args12499 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m12501]
   (clojure.core/let
    [credentials12502 (:credentials m12501) args12503 (:args m12501)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12504
      (com.palletops.awaze.common/aws-client :iam credentials12502)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12504
       updateAccountPasswordPolicy
       (identitymanagement/update-account-password-policy-request
        (clojure.core/nth args12503 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials12506 & args12507]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12508
     (com.palletops.awaze.common/aws-client :iam credentials12506)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12508
      updateAccountPasswordPolicy
      (identitymanagement/update-account-password-policy-request
       (clojure.core/nth args12507 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m12509]
   (clojure.core/let
    [credentials12510 (:credentials m12509) args12511 (:args m12509)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12512
      (com.palletops.awaze.common/aws-client :iam credentials12510)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12512
       putUserPolicy
       (identitymanagement/put-user-policy-request
        (clojure.core/nth args12511 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putUserPolicy"}
   [credentials12514 & args12515]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12516
     (com.palletops.awaze.common/aws-client :iam credentials12514)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12516
      putUserPolicy
      (identitymanagement/put-user-policy-request
       (clojure.core/nth args12515 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m12517]
   (clojure.core/let
    [credentials12518 (:credentials m12517) args12519 (:args m12517)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12520
      (com.palletops.awaze.common/aws-client :iam credentials12518)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12520
       updateAssumeRolePolicy
       (identitymanagement/update-assume-role-policy-request
        (clojure.core/nth args12519 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-assume-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials12522 & args12523]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12524
     (com.palletops.awaze.common/aws-client :iam credentials12522)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12524
      updateAssumeRolePolicy
      (identitymanagement/update-assume-role-policy-request
       (clojure.core/nth args12523 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy
   [m12525]
   (clojure.core/let
    [credentials12526 (:credentials m12525) args12527 (:args m12525)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12528
      (com.palletops.awaze.common/aws-client :iam credentials12526)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12528
       getPolicy
       (identitymanagement/get-policy-request
        (clojure.core/nth args12527 0)))))))
  (clojure.core/defn
   get-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicy"}
   [credentials12530 & args12531]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12532
     (com.palletops.awaze.common/aws-client :iam credentials12530)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12532
      getPolicy
      (identitymanagement/get-policy-request
       (clojure.core/nth args12531 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m12533]
   (clojure.core/let
    [credentials12534 (:credentials m12533) args12535 (:args m12533)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12536
      (com.palletops.awaze.common/aws-client :iam credentials12534)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12536
       updateUser
       (identitymanagement/update-user-request
        (clojure.core/nth args12535 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateUser"}
   [credentials12538 & args12539]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12540
     (com.palletops.awaze.common/aws-client :iam credentials12538)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12540
      updateUser
      (identitymanagement/update-user-request
       (clojure.core/nth args12539 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m12541]
   (clojure.core/let
    [credentials12542 (:credentials m12541) args12543 (:args m12541)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12544
      (com.palletops.awaze.common/aws-client :iam credentials12542)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12544
       getRolePolicy
       (identitymanagement/get-role-policy-request
        (clojure.core/nth args12543 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRolePolicy"}
   [credentials12546 & args12547]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12548
     (com.palletops.awaze.common/aws-client :iam credentials12546)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12548
      getRolePolicy
      (identitymanagement/get-role-policy-request
       (clojure.core/nth args12547 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m12549]
   (clojure.core/let
    [credentials12550 (:credentials m12549) args12551 (:args m12549)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12552
      (com.palletops.awaze.common/aws-client :iam credentials12550)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12552
       deleteGroup
       (identitymanagement/delete-group-request
        (clojure.core/nth args12551 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroup"}
   [credentials12554 & args12555]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12556
     (com.palletops.awaze.common/aws-client :iam credentials12554)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12556
      deleteGroup
      (identitymanagement/delete-group-request
       (clojure.core/nth args12555 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m12557]
   (clojure.core/let
    [credentials12558 (:credentials m12557) args12559 (:args m12557)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12560
      (com.palletops.awaze.common/aws-client :iam credentials12558)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12560
       getLoginProfile
       (identitymanagement/get-login-profile-request
        (clojure.core/nth args12559 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getLoginProfile"}
   [credentials12562 & args12563]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12564
     (com.palletops.awaze.common/aws-client :iam credentials12562)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12564
      getLoginProfile
      (identitymanagement/get-login-profile-request
       (clojure.core/nth args12563 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-samlproviders
   [m12565]
   (clojure.core/let
    [credentials12566 (:credentials m12565) args12567 (:args m12565)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12568
      (com.palletops.awaze.common/aws-client :iam credentials12566)]
     (clojure.core/case
      (clojure.core/count args12567)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12568
        listSAMLProviders
        (identitymanagement/list-samlproviders-request
         (clojure.core/nth args12567 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12568
        listSAMLProviders))))))
  (clojure.core/defn
   list-samlproviders-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listSAMLProviders, listSAMLProviders"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-samlproviders,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-samlproviders,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-samlproviders
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listSAMLProviders, listSAMLProviders"}
   [credentials12570 & args12571]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12572
     (com.palletops.awaze.common/aws-client :iam credentials12570)]
    (clojure.core/case
     (clojure.core/count args12571)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12572
       listSAMLProviders
       (identitymanagement/list-samlproviders-request
        (clojure.core/nth args12571 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12572
       listSAMLProviders))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m12573]
   (clojure.core/let
    [credentials12574 (:credentials m12573) args12575 (:args m12573)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12576
      (com.palletops.awaze.common/aws-client :iam credentials12574)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12576
       createRole
       (identitymanagement/create-role-request
        (clojure.core/nth args12575 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRole"}
   [credentials12578 & args12579]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12580
     (com.palletops.awaze.common/aws-client :iam credentials12578)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12580
      createRole
      (identitymanagement/create-role-request
       (clojure.core/nth args12579 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-group-policies
   [m12581]
   (clojure.core/let
    [credentials12582 (:credentials m12581) args12583 (:args m12581)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12584
      (com.palletops.awaze.common/aws-client :iam credentials12582)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12584
       listAttachedGroupPolicies
       (identitymanagement/list-attached-group-policies-request
        (clojure.core/nth args12583 0)))))))
  (clojure.core/defn
   list-attached-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedGroupPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-group-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedGroupPolicies"}
   [credentials12586 & args12587]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12588
     (com.palletops.awaze.common/aws-client :iam credentials12586)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12588
      listAttachedGroupPolicies
      (identitymanagement/list-attached-group-policies-request
       (clojure.core/nth args12587 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m12589]
   (clojure.core/let
    [credentials12590 (:credentials m12589) args12591 (:args m12589)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12592
      (com.palletops.awaze.common/aws-client :iam credentials12590)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12592
       deleteAccessKey
       (identitymanagement/delete-access-key-request
        (clojure.core/nth args12591 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call deleteAccessKey"}
   [credentials12594 & args12595]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12596
     (com.palletops.awaze.common/aws-client :iam credentials12594)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12596
      deleteAccessKey
      (identitymanagement/delete-access-key-request
       (clojure.core/nth args12595 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m12597]
   (clojure.core/let
    [credentials12598 (:credentials m12597) args12599 (:args m12597)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12600
      (com.palletops.awaze.common/aws-client :iam credentials12598)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12600
       getGroup
       (identitymanagement/get-group-request
        (clojure.core/nth args12599 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroup"}
   [credentials12602 & args12603]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12604
     (com.palletops.awaze.common/aws-client :iam credentials12602)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12604
      getGroup
      (identitymanagement/get-group-request
       (clojure.core/nth args12603 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m12605]
   (clojure.core/let
    [credentials12606 (:credentials m12605) args12607 (:args m12605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12608
      (com.palletops.awaze.common/aws-client :iam credentials12606)]
     (clojure.core/case
      (clojure.core/count args12607)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12608
        deleteAccountPasswordPolicy
        (identitymanagement/delete-account-password-policy-request
         (clojure.core/nth args12607 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12608
        deleteAccountPasswordPolicy))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :delete-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials12610 & args12611]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12612
     (com.palletops.awaze.common/aws-client :iam credentials12610)]
    (clojure.core/case
     (clojure.core/count args12611)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12612
       deleteAccountPasswordPolicy
       (identitymanagement/delete-account-password-policy-request
        (clojure.core/nth args12611 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12612
       deleteAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m12613]
   (clojure.core/let
    [credentials12614 (:credentials m12613) args12615 (:args m12613)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12616
      (com.palletops.awaze.common/aws-client :iam credentials12614)]
     (clojure.core/case
      (clojure.core/count args12615)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12616
        getAccountSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12616
        getAccountSummary
        (identitymanagement/get-account-summary-request
         (clojure.core/nth args12615 0))))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-summary,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-summary,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials12618 & args12619]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12620
     (com.palletops.awaze.common/aws-client :iam credentials12618)]
    (clojure.core/case
     (clojure.core/count args12619)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12620
       getAccountSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12620
       getAccountSummary
       (identitymanagement/get-account-summary-request
        (clojure.core/nth args12619 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy
   [m12621]
   (clojure.core/let
    [credentials12622 (:credentials m12621) args12623 (:args m12621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12624
      (com.palletops.awaze.common/aws-client :iam credentials12622)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12624
       deletePolicy
       (identitymanagement/delete-policy-request
        (clojure.core/nth args12623 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicy"}
   [credentials12626 & args12627]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12628
     (com.palletops.awaze.common/aws-client :iam credentials12626)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12628
      deletePolicy
      (identitymanagement/delete-policy-request
       (clojure.core/nth args12627 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m12629]
   (clojure.core/let
    [credentials12630 (:credentials m12629) args12631 (:args m12629)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12632
      (com.palletops.awaze.common/aws-client :iam credentials12630)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12632
       createGroup
       (identitymanagement/create-group-request
        (clojure.core/nth args12631 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createGroup"}
   [credentials12634 & args12635]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12636
     (com.palletops.awaze.common/aws-client :iam credentials12634)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12636
      createGroup
      (identitymanagement/create-group-request
       (clojure.core/nth args12635 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m12637]
   (clojure.core/let
    [credentials12638 (:credentials m12637) args12639 (:args m12637)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12640
      (com.palletops.awaze.common/aws-client :iam credentials12638)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12640
       getRole
       (identitymanagement/get-role-request
        (clojure.core/nth args12639 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRole"}
   [credentials12642 & args12643]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12644
     (com.palletops.awaze.common/aws-client :iam credentials12642)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12644
      getRole
      (identitymanagement/get-role-request
       (clojure.core/nth args12643 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policy-versions
   [m12645]
   (clojure.core/let
    [credentials12646 (:credentials m12645) args12647 (:args m12645)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12648
      (com.palletops.awaze.common/aws-client :iam credentials12646)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12648
       listPolicyVersions
       (identitymanagement/list-policy-versions-request
        (clojure.core/nth args12647 0)))))))
  (clojure.core/defn
   list-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPolicyVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-policy-versions,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listPolicyVersions"}
   [credentials12650 & args12651]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12652
     (com.palletops.awaze.common/aws-client :iam credentials12650)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12652
      listPolicyVersions
      (identitymanagement/list-policy-versions-request
       (clojure.core/nth args12651 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m12653]
   (clojure.core/let
    [credentials12654 (:credentials m12653) args12655 (:args m12653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12656
      (com.palletops.awaze.common/aws-client :iam credentials12654)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12656
       listGroupPolicies
       (identitymanagement/list-group-policies-request
        (clojure.core/nth args12655 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-group-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupPolicies"}
   [credentials12658 & args12659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12660
     (com.palletops.awaze.common/aws-client :iam credentials12658)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12660
      listGroupPolicies
      (identitymanagement/list-group-policies-request
       (clojure.core/nth args12659 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-samlprovider
   [m12661]
   (clojure.core/let
    [credentials12662 (:credentials m12661) args12663 (:args m12661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12664
      (com.palletops.awaze.common/aws-client :iam credentials12662)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12664
       deleteSAMLProvider
       (identitymanagement/delete-samlprovider-request
        (clojure.core/nth args12663 0)))))))
  (clojure.core/defn
   delete-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSAMLProvider"}
   [credentials12666 & args12667]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12668
     (com.palletops.awaze.common/aws-client :iam credentials12666)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12668
      deleteSAMLProvider
      (identitymanagement/delete-samlprovider-request
       (clojure.core/nth args12667 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-role-policy
   [m12669]
   (clojure.core/let
    [credentials12670 (:credentials m12669) args12671 (:args m12669)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12672
      (com.palletops.awaze.common/aws-client :iam credentials12670)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12672
       detachRolePolicy
       (identitymanagement/detach-role-policy-request
        (clojure.core/nth args12671 0)))))))
  (clojure.core/defn
   detach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachRolePolicy"}
   [credentials12674 & args12675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12676
     (com.palletops.awaze.common/aws-client :iam credentials12674)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12676
      detachRolePolicy
      (identitymanagement/detach-role-policy-request
       (clojure.core/nth args12675 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m12677]
   (clojure.core/let
    [credentials12678 (:credentials m12677) args12679 (:args m12677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12680
      (com.palletops.awaze.common/aws-client :iam credentials12678)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12680
       updateLoginProfile
       (identitymanagement/update-login-profile-request
        (clojure.core/nth args12679 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateLoginProfile"}
   [credentials12682 & args12683]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12684
     (com.palletops.awaze.common/aws-client :iam credentials12682)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12684
      updateLoginProfile
      (identitymanagement/update-login-profile-request
       (clojure.core/nth args12683 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-open-idconnect-provider-thumbprint
   [m12685]
   (clojure.core/let
    [credentials12686 (:credentials m12685) args12687 (:args m12685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12688
      (com.palletops.awaze.common/aws-client :iam credentials12686)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12688
       updateOpenIDConnectProviderThumbprint
       (identitymanagement/update-open-idconnect-provider-thumbprint-request
        (clojure.core/nth args12687 0)))))))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateOpenIDConnectProviderThumbprint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-open-idconnect-provider-thumbprint,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateOpenIDConnectProviderThumbprint"}
   [credentials12690 & args12691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12692
     (com.palletops.awaze.common/aws-client :iam credentials12690)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12692
      updateOpenIDConnectProviderThumbprint
      (identitymanagement/update-open-idconnect-provider-thumbprint-request
       (clojure.core/nth args12691 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-sshpublic-key
   [m12693]
   (clojure.core/let
    [credentials12694 (:credentials m12693) args12695 (:args m12693)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12696
      (com.palletops.awaze.common/aws-client :iam credentials12694)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12696
       updateSSHPublicKey
       (identitymanagement/update-sshpublic-key-request
        (clojure.core/nth args12695 0)))))))
  (clojure.core/defn
   update-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSSHPublicKey"}
   [credentials12698 & args12699]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12700
     (com.palletops.awaze.common/aws-client :iam credentials12698)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12700
      updateSSHPublicKey
      (identitymanagement/update-sshpublic-key-request
       (clojure.core/nth args12699 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m12701]
   (clojure.core/let
    [credentials12702 (:credentials m12701) args12703 (:args m12701)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12704
      (com.palletops.awaze.common/aws-client :iam credentials12702)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12704
       deleteServerCertificate
       (identitymanagement/delete-server-certificate-request
        (clojure.core/nth args12703 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials12706 & args12707]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12708
     (com.palletops.awaze.common/aws-client :iam credentials12706)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12708
      deleteServerCertificate
      (identitymanagement/delete-server-certificate-request
       (clojure.core/nth args12707 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m12709]
   (clojure.core/let
    [credentials12710 (:credentials m12709) args12711 (:args m12709)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12712
      (com.palletops.awaze.common/aws-client :iam credentials12710)]
     (clojure.core/case
      (clojure.core/count args12711)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12712
        listVirtualMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12712
        listVirtualMFADevices
        (identitymanagement/list-virtual-mfadevices-request
         (clojure.core/nth args12711 0))))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials12714 & args12715]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12716
     (com.palletops.awaze.common/aws-client :iam credentials12714)]
    (clojure.core/case
     (clojure.core/count args12715)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12716
       listVirtualMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12716
       listVirtualMFADevices
       (identitymanagement/list-virtual-mfadevices-request
        (clojure.core/nth args12715 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m12717]
   (clojure.core/let
    [credentials12718 (:credentials m12717) args12719 (:args m12717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12720
      (com.palletops.awaze.common/aws-client :iam credentials12718)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12720
       getServerCertificate
       (identitymanagement/get-server-certificate-request
        (clojure.core/nth args12719 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getServerCertificate"}
   [credentials12722 & args12723]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12724
     (com.palletops.awaze.common/aws-client :iam credentials12722)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12724
      getServerCertificate
      (identitymanagement/get-server-certificate-request
       (clojure.core/nth args12723 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m12725]
   (clojure.core/let
    [credentials12726 (:credentials m12725) args12727 (:args m12725)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12728
      (com.palletops.awaze.common/aws-client :iam credentials12726)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12728
       deleteRolePolicy
       (identitymanagement/delete-role-policy-request
        (clojure.core/nth args12727 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials12730 & args12731]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12732
     (com.palletops.awaze.common/aws-client :iam credentials12730)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12732
      deleteRolePolicy
      (identitymanagement/delete-role-policy-request
       (clojure.core/nth args12731 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m12733]
   (clojure.core/let
    [credentials12734 (:credentials m12733) args12735 (:args m12733)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12736
      (com.palletops.awaze.common/aws-client :iam credentials12734)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12736
       deleteInstanceProfile
       (identitymanagement/delete-instance-profile-request
        (clojure.core/nth args12735 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials12738 & args12739]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12740
     (com.palletops.awaze.common/aws-client :iam credentials12738)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12740
      deleteInstanceProfile
      (identitymanagement/delete-instance-profile-request
       (clojure.core/nth args12739 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m12741]
   (clojure.core/let
    [credentials12742 (:credentials m12741) args12743 (:args m12741)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12744
      (com.palletops.awaze.common/aws-client :iam credentials12742)]
     (clojure.core/case
      (clojure.core/count args12743)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12744
        listAccountAliases))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12744
        listAccountAliases
        (identitymanagement/list-account-aliases-request
         (clojure.core/nth args12743 0))))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-account-aliases,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-account-aliases,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials12746 & args12747]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12748
     (com.palletops.awaze.common/aws-client :iam credentials12746)]
    (clojure.core/case
     (clojure.core/count args12747)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12748
       listAccountAliases))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12748
       listAccountAliases
       (identitymanagement/list-account-aliases-request
        (clojure.core/nth args12747 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m12749]
   (clojure.core/let
    [credentials12750 (:credentials m12749) args12751 (:args m12749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12752
      (com.palletops.awaze.common/aws-client :iam credentials12750)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12752
       addUserToGroup
       (identitymanagement/add-user-to-group-request
        (clojure.core/nth args12751 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-user-to-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addUserToGroup"}
   [credentials12754 & args12755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12756
     (com.palletops.awaze.common/aws-client :iam credentials12754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12756
      addUserToGroup
      (identitymanagement/add-user-to-group-request
       (clojure.core/nth args12755 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-open-idconnect-provider
   [m12757]
   (clojure.core/let
    [credentials12758 (:credentials m12757) args12759 (:args m12757)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12760
      (com.palletops.awaze.common/aws-client :iam credentials12758)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12760
       deleteOpenIDConnectProvider
       (identitymanagement/delete-open-idconnect-provider-request
        (clojure.core/nth args12759 0)))))))
  (clojure.core/defn
   delete-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteOpenIDConnectProvider"}
   [credentials12762 & args12763]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12764
     (com.palletops.awaze.common/aws-client :iam credentials12762)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12764
      deleteOpenIDConnectProvider
      (identitymanagement/delete-open-idconnect-provider-request
       (clojure.core/nth args12763 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m12765]
   (clojure.core/let
    [credentials12766 (:credentials m12765) args12767 (:args m12765)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12768
      (com.palletops.awaze.common/aws-client :iam credentials12766)]
     (clojure.core/case
      (clojure.core/count args12767)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12768
        listUsers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12768
        listUsers
        (identitymanagement/list-users-request
         (clojure.core/nth args12767 0))))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-users,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-users,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUsers, listUsers"}
   [credentials12770 & args12771]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12772
     (com.palletops.awaze.common/aws-client :iam credentials12770)]
    (clojure.core/case
     (clojure.core/count args12771)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12772
       listUsers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12772
       listUsers
       (identitymanagement/list-users-request
        (clojure.core/nth args12771 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m12773]
   (clojure.core/let
    [credentials12774 (:credentials m12773) args12775 (:args m12773)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12776
      (com.palletops.awaze.common/aws-client :iam credentials12774)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12776
       createInstanceProfile
       (identitymanagement/create-instance-profile-request
        (clojure.core/nth args12775 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceProfile"}
   [credentials12778 & args12779]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12780
     (com.palletops.awaze.common/aws-client :iam credentials12778)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12780
      createInstanceProfile
      (identitymanagement/create-instance-profile-request
       (clojure.core/nth args12779 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m12781]
   (clojure.core/let
    [credentials12782 (:credentials m12781) args12783 (:args m12781)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12784
      (com.palletops.awaze.common/aws-client :iam credentials12782)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12784
       getUserPolicy
       (identitymanagement/get-user-policy-request
        (clojure.core/nth args12783 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getUserPolicy"}
   [credentials12786 & args12787]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12788
     (com.palletops.awaze.common/aws-client :iam credentials12786)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12788
      getUserPolicy
      (identitymanagement/get-user-policy-request
       (clojure.core/nth args12787 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m12789]
   (clojure.core/let
    [credentials12790 (:credentials m12789) args12791 (:args m12789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12792
      (com.palletops.awaze.common/aws-client :iam credentials12790)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12792
       deleteLoginProfile
       (identitymanagement/delete-login-profile-request
        (clojure.core/nth args12791 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials12794 & args12795]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12796
     (com.palletops.awaze.common/aws-client :iam credentials12794)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12796
      deleteLoginProfile
      (identitymanagement/delete-login-profile-request
       (clojure.core/nth args12795 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-user-policy
   [m12797]
   (clojure.core/let
    [credentials12798 (:credentials m12797) args12799 (:args m12797)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12800
      (com.palletops.awaze.common/aws-client :iam credentials12798)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12800
       attachUserPolicy
       (identitymanagement/attach-user-policy-request
        (clojure.core/nth args12799 0)))))))
  (clojure.core/defn
   attach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachUserPolicy"}
   [credentials12802 & args12803]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12804
     (com.palletops.awaze.common/aws-client :iam credentials12802)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12804
      attachUserPolicy
      (identitymanagement/attach-user-policy-request
       (clojure.core/nth args12803 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m12805]
   (clojure.core/let
    [credentials12806 (:credentials m12805) args12807 (:args m12805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12808
      (com.palletops.awaze.common/aws-client :iam credentials12806)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12808
       putRolePolicy
       (identitymanagement/put-role-policy-request
        (clojure.core/nth args12807 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putRolePolicy"}
   [credentials12810 & args12811]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12812
     (com.palletops.awaze.common/aws-client :iam credentials12810)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12812
      putRolePolicy
      (identitymanagement/put-role-policy-request
       (clojure.core/nth args12811 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m12813]
   (clojure.core/let
    [credentials12814 (:credentials m12813) args12815 (:args m12813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12816
      (com.palletops.awaze.common/aws-client :iam credentials12814)]
     (clojure.core/case
      (clojure.core/count args12815)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12816
        listAccessKeys
        (identitymanagement/list-access-keys-request
         (clojure.core/nth args12815 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12816
        listAccessKeys))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-access-keys,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-access-keys,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials12818 & args12819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12820
     (com.palletops.awaze.common/aws-client :iam credentials12818)]
    (clojure.core/case
     (clojure.core/count args12819)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12820
       listAccessKeys
       (identitymanagement/list-access-keys-request
        (clojure.core/nth args12819 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12820
       listAccessKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m12821]
   (clojure.core/let
    [credentials12822 (:credentials m12821) args12823 (:args m12821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12824
      (com.palletops.awaze.common/aws-client :iam credentials12822)]
     (clojure.core/case
      (clojure.core/count args12823)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12824
        listSigningCertificates
        (identitymanagement/list-signing-certificates-request
         (clojure.core/nth args12823 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12824
        listSigningCertificates))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-signing-certificates,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-signing-certificates,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials12826 & args12827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12828
     (com.palletops.awaze.common/aws-client :iam credentials12826)]
    (clojure.core/case
     (clojure.core/count args12827)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12828
       listSigningCertificates
       (identitymanagement/list-signing-certificates-request
        (clojure.core/nth args12827 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12828
       listSigningCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-group-policy
   [m12829]
   (clojure.core/let
    [credentials12830 (:credentials m12829) args12831 (:args m12829)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12832
      (com.palletops.awaze.common/aws-client :iam credentials12830)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12832
       detachGroupPolicy
       (identitymanagement/detach-group-policy-request
        (clojure.core/nth args12831 0)))))))
  (clojure.core/defn
   detach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachGroupPolicy"}
   [credentials12834 & args12835]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12836
     (com.palletops.awaze.common/aws-client :iam credentials12834)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12836
      detachGroupPolicy
      (identitymanagement/detach-group-policy-request
       (clojure.core/nth args12835 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m12837]
   (clojure.core/let
    [credentials12838 (:credentials m12837) args12839 (:args m12837)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12840
      (com.palletops.awaze.common/aws-client :iam credentials12838)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12840
       updateAccessKey
       (identitymanagement/update-access-key-request
        (clojure.core/nth args12839 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call updateAccessKey"}
   [credentials12842 & args12843]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12844
     (com.palletops.awaze.common/aws-client :iam credentials12842)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12844
      updateAccessKey
      (identitymanagement/update-access-key-request
       (clojure.core/nth args12843 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-sshpublic-key
   [m12845]
   (clojure.core/let
    [credentials12846 (:credentials m12845) args12847 (:args m12845)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12848
      (com.palletops.awaze.common/aws-client :iam credentials12846)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12848
       uploadSSHPublicKey
       (identitymanagement/upload-sshpublic-key-request
        (clojure.core/nth args12847 0)))))))
  (clojure.core/defn
   upload-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSSHPublicKey"}
   [credentials12850 & args12851]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12852
     (com.palletops.awaze.common/aws-client :iam credentials12850)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12852
      uploadSSHPublicKey
      (identitymanagement/upload-sshpublic-key-request
       (clojure.core/nth args12851 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m12853]
   (clojure.core/let
    [credentials12854 (:credentials m12853) args12855 (:args m12853)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12856
      (com.palletops.awaze.common/aws-client :iam credentials12854)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12856
       uploadServerCertificate
       (identitymanagement/upload-server-certificate-request
        (clojure.core/nth args12855 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials12858 & args12859]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12860
     (com.palletops.awaze.common/aws-client :iam credentials12858)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12860
      uploadServerCertificate
      (identitymanagement/upload-server-certificate-request
       (clojure.core/nth args12859 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m12861]
   (clojure.core/let
    [credentials12862 (:credentials m12861) args12863 (:args m12861)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12864
      (com.palletops.awaze.common/aws-client :iam credentials12862)]
     (clojure.core/case
      (clojure.core/count args12863)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12864
        getAccountPasswordPolicy))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12864
        getAccountPasswordPolicy
        (identitymanagement/get-account-password-policy-request
         (clojure.core/nth args12863 0))))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials12866 & args12867]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12868
     (com.palletops.awaze.common/aws-client :iam credentials12866)]
    (clojure.core/case
     (clojure.core/count args12867)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12868
       getAccountPasswordPolicy))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12868
       getAccountPasswordPolicy
       (identitymanagement/get-account-password-policy-request
        (clojure.core/nth args12867 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m12869]
   (clojure.core/let
    [credentials12870 (:credentials m12869) args12871 (:args m12869)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12872
      (com.palletops.awaze.common/aws-client :iam credentials12870)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12872
       deleteRole
       (identitymanagement/delete-role-request
        (clojure.core/nth args12871 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRole"}
   [credentials12874 & args12875]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12876
     (com.palletops.awaze.common/aws-client :iam credentials12874)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12876
      deleteRole
      (identitymanagement/delete-role-request
       (clojure.core/nth args12875 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-client-idfrom-open-idconnect-provider
   [m12877]
   (clojure.core/let
    [credentials12878 (:credentials m12877) args12879 (:args m12877)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12880
      (com.palletops.awaze.common/aws-client :iam credentials12878)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12880
       removeClientIDFromOpenIDConnectProvider
       (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
        (clojure.core/nth args12879 0)))))))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeClientIDFromOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-client-idfrom-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeClientIDFromOpenIDConnectProvider"}
   [credentials12882 & args12883]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12884
     (com.palletops.awaze.common/aws-client :iam credentials12882)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12884
      removeClientIDFromOpenIDConnectProvider
      (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
       (clojure.core/nth args12883 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m12885]
   (clojure.core/let
    [credentials12886 (:credentials m12885) args12887 (:args m12885)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12888
      (com.palletops.awaze.common/aws-client :iam credentials12886)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12888
       removeUserFromGroup
       (identitymanagement/remove-user-from-group-request
        (clojure.core/nth args12887 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-user-from-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials12890 & args12891]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12892
     (com.palletops.awaze.common/aws-client :iam credentials12890)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12892
      removeUserFromGroup
      (identitymanagement/remove-user-from-group-request
       (clojure.core/nth args12891 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m12893]
   (clojure.core/let
    [credentials12894 (:credentials m12893) args12895 (:args m12893)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12896
      (com.palletops.awaze.common/aws-client :iam credentials12894)]
     (clojure.core/case
      (clojure.core/count args12895)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12896
        listRoles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12896
        listRoles
        (identitymanagement/list-roles-request
         (clojure.core/nth args12895 0))))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-roles,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-roles,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRoles, listRoles"}
   [credentials12898 & args12899]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12900
     (com.palletops.awaze.common/aws-client :iam credentials12898)]
    (clojure.core/case
     (clojure.core/count args12899)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12900
       listRoles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12900
       listRoles
       (identitymanagement/list-roles-request
        (clojure.core/nth args12899 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-role-policies
   [m12901]
   (clojure.core/let
    [credentials12902 (:credentials m12901) args12903 (:args m12901)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12904
      (com.palletops.awaze.common/aws-client :iam credentials12902)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12904
       listAttachedRolePolicies
       (identitymanagement/list-attached-role-policies-request
        (clojure.core/nth args12903 0)))))))
  (clojure.core/defn
   list-attached-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedRolePolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-role-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedRolePolicies"}
   [credentials12906 & args12907]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12908
     (com.palletops.awaze.common/aws-client :iam credentials12906)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12908
      listAttachedRolePolicies
      (identitymanagement/list-attached-role-policies-request
       (clojure.core/nth args12907 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m12909]
   (clojure.core/let
    [credentials12910 (:credentials m12909) args12911 (:args m12909)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12912
      (com.palletops.awaze.common/aws-client :iam credentials12910)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12912
       removeRoleFromInstanceProfile
       (identitymanagement/remove-role-from-instance-profile-request
        (clojure.core/nth args12911 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials12914 & args12915]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12916
     (com.palletops.awaze.common/aws-client :iam credentials12914)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12916
      removeRoleFromInstanceProfile
      (identitymanagement/remove-role-from-instance-profile-request
       (clojure.core/nth args12915 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy
   [m12917]
   (clojure.core/let
    [credentials12918 (:credentials m12917) args12919 (:args m12917)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12920
      (com.palletops.awaze.common/aws-client :iam credentials12918)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12920
       createPolicy
       (identitymanagement/create-policy-request
        (clojure.core/nth args12919 0)))))))
  (clojure.core/defn
   create-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPolicy"}
   [credentials12922 & args12923]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12924
     (com.palletops.awaze.common/aws-client :iam credentials12922)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12924
      createPolicy
      (identitymanagement/create-policy-request
       (clojure.core/nth args12923 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-client-idto-open-idconnect-provider
   [m12925]
   (clojure.core/let
    [credentials12926 (:credentials m12925) args12927 (:args m12925)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12928
      (com.palletops.awaze.common/aws-client :iam credentials12926)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12928
       addClientIDToOpenIDConnectProvider
       (identitymanagement/add-client-idto-open-idconnect-provider-request
        (clojure.core/nth args12927 0)))))))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addClientIDToOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-client-idto-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addClientIDToOpenIDConnectProvider"}
   [credentials12930 & args12931]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12932
     (com.palletops.awaze.common/aws-client :iam credentials12930)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12932
      addClientIDToOpenIDConnectProvider
      (identitymanagement/add-client-idto-open-idconnect-provider-request
       (clojure.core/nth args12931 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m12933]
   (clojure.core/let
    [credentials12934 (:credentials m12933) args12935 (:args m12933)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12936
      (com.palletops.awaze.common/aws-client :iam credentials12934)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12936
       createVirtualMFADevice
       (identitymanagement/create-virtual-mfadevice-request
        (clojure.core/nth args12935 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-virtual-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials12938 & args12939]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12940
     (com.palletops.awaze.common/aws-client :iam credentials12938)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12940
      createVirtualMFADevice
      (identitymanagement/create-virtual-mfadevice-request
       (clojure.core/nth args12939 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m12941]
   (clojure.core/let
    [credentials12942 (:credentials m12941) args12943 (:args m12941)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12944
      (com.palletops.awaze.common/aws-client :iam credentials12942)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12944
       deleteAccountAlias
       (identitymanagement/delete-account-alias-request
        (clojure.core/nth args12943 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-account-alias,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials12946 & args12947]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12948
     (com.palletops.awaze.common/aws-client :iam credentials12946)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12948
      deleteAccountAlias
      (identitymanagement/delete-account-alias-request
       (clojure.core/nth args12947 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m12949]
   (clojure.core/let
    [credentials12950 (:credentials m12949) args12951 (:args m12949)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12952
      (com.palletops.awaze.common/aws-client :iam credentials12950)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12952
       uploadSigningCertificate
       (identitymanagement/upload-signing-certificate-request
        (clojure.core/nth args12951 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials12954 & args12955]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12956
     (com.palletops.awaze.common/aws-client :iam credentials12954)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12956
      uploadSigningCertificate
      (identitymanagement/upload-signing-certificate-request
       (clojure.core/nth args12955 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m12957]
   (clojure.core/let
    [credentials12958 (:credentials m12957) args12959 (:args m12957)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12960
      (com.palletops.awaze.common/aws-client :iam credentials12958)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12960
       deactivateMFADevice
       (identitymanagement/deactivate-mfadevice-request
        (clojure.core/nth args12959 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deactivate-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials12962 & args12963]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12964
     (com.palletops.awaze.common/aws-client :iam credentials12962)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12964
      deactivateMFADevice
      (identitymanagement/deactivate-mfadevice-request
       (clojure.core/nth args12963 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m12965]
   (clojure.core/let
    [credentials12966 (:credentials m12965) args12967 (:args m12965)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12968
      (com.palletops.awaze.common/aws-client :iam credentials12966)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12968
       resyncMFADevice
       (identitymanagement/resync-mfadevice-request
        (clojure.core/nth args12967 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :resync-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resyncMFADevice"}
   [credentials12970 & args12971]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12972
     (com.palletops.awaze.common/aws-client :iam credentials12970)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12972
      resyncMFADevice
      (identitymanagement/resync-mfadevice-request
       (clojure.core/nth args12971 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-sshpublic-keys
   [m12973]
   (clojure.core/let
    [credentials12974 (:credentials m12973) args12975 (:args m12973)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12976
      (com.palletops.awaze.common/aws-client :iam credentials12974)]
     (clojure.core/case
      (clojure.core/count args12975)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12976
        listSSHPublicKeys
        (identitymanagement/list-sshpublic-keys-request
         (clojure.core/nth args12975 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12976
        listSSHPublicKeys))))))
  (clojure.core/defn
   list-sshpublic-keys-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listSSHPublicKeys, listSSHPublicKeys"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-sshpublic-keys,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-sshpublic-keys,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-sshpublic-keys
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listSSHPublicKeys, listSSHPublicKeys"}
   [credentials12978 & args12979]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12980
     (com.palletops.awaze.common/aws-client :iam credentials12978)]
    (clojure.core/case
     (clojure.core/count args12979)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12980
       listSSHPublicKeys
       (identitymanagement/list-sshpublic-keys-request
        (clojure.core/nth args12979 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12980
       listSSHPublicKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m12981]
   (clojure.core/let
    [credentials12982 (:credentials m12981) args12983 (:args m12981)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12984
      (com.palletops.awaze.common/aws-client :iam credentials12982)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12984
       addRoleToInstanceProfile
       (identitymanagement/add-role-to-instance-profile-request
        (clojure.core/nth args12983 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-role-to-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials12986 & args12987]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12988
     (com.palletops.awaze.common/aws-client :iam credentials12986)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12988
      addRoleToInstanceProfile
      (identitymanagement/add-role-to-instance-profile-request
       (clojure.core/nth args12987 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m12989]
   (clojure.core/let
    [credentials12990 (:credentials m12989) args12991 (:args m12989)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12992
      (com.palletops.awaze.common/aws-client :iam credentials12990)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12992
       enableMFADevice
       (identitymanagement/enable-mfadevice-request
        (clojure.core/nth args12991 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableMFADevice"}
   [credentials12994 & args12995]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12996
     (com.palletops.awaze.common/aws-client :iam credentials12994)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12996
      enableMFADevice
      (identitymanagement/enable-mfadevice-request
       (clojure.core/nth args12995 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m12997]
   (clojure.core/let
    [credentials12998 (:credentials m12997) args12999 (:args m12997)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13000
      (com.palletops.awaze.common/aws-client :iam credentials12998)]
     (clojure.core/case
      (clojure.core/count args12999)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13000
        listGroups
        (identitymanagement/list-groups-request
         (clojure.core/nth args12999 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13000
        listGroups))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-groups,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-groups,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGroups, listGroups"}
   [credentials13002 & args13003]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13004
     (com.palletops.awaze.common/aws-client :iam credentials13002)]
    (clojure.core/case
     (clojure.core/count args13003)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13004
       listGroups
       (identitymanagement/list-groups-request
        (clojure.core/nth args13003 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13004
       listGroups))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy-version
   [m13005]
   (clojure.core/let
    [credentials13006 (:credentials m13005) args13007 (:args m13005)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13008
      (com.palletops.awaze.common/aws-client :iam credentials13006)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13008
       deletePolicyVersion
       (identitymanagement/delete-policy-version-request
        (clojure.core/nth args13007 0)))))))
  (clojure.core/defn
   delete-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicyVersion"}
   [credentials13010 & args13011]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13012
     (com.palletops.awaze.common/aws-client :iam credentials13010)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13012
      deletePolicyVersion
      (identitymanagement/delete-policy-version-request
       (clojure.core/nth args13011 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m13013]
   (clojure.core/let
    [credentials13014 (:credentials m13013) args13015 (:args m13013)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13016
      (com.palletops.awaze.common/aws-client :iam credentials13014)]
     (clojure.core/case
      (clojure.core/count args13015)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13016
        createAccessKey))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13016
        createAccessKey
        (identitymanagement/create-access-key-request
         (clojure.core/nth args13015 0))))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-access-key,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials13018 & args13019]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13020
     (com.palletops.awaze.common/aws-client :iam credentials13018)]
    (clojure.core/case
     (clojure.core/count args13019)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13020
       createAccessKey))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13020
       createAccessKey
       (identitymanagement/create-access-key-request
        (clojure.core/nth args13019 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m13021]
   (clojure.core/let
    [credentials13022 (:credentials m13021) args13023 (:args m13021)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13024
      (com.palletops.awaze.common/aws-client :iam credentials13022)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13024
       deleteVirtualMFADevice
       (identitymanagement/delete-virtual-mfadevice-request
        (clojure.core/nth args13023 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials13026 & args13027]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13028
     (com.palletops.awaze.common/aws-client :iam credentials13026)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13028
      deleteVirtualMFADevice
      (identitymanagement/delete-virtual-mfadevice-request
       (clojure.core/nth args13027 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m13029]
   (clojure.core/let
    [credentials13030 (:credentials m13029) args13031 (:args m13029)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13032
      (com.palletops.awaze.common/aws-client :iam credentials13030)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13032
       getInstanceProfile
       (identitymanagement/get-instance-profile-request
        (clojure.core/nth args13031 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInstanceProfile"}
   [credentials13034 & args13035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13036
     (com.palletops.awaze.common/aws-client :iam credentials13034)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13036
      getInstanceProfile
      (identitymanagement/get-instance-profile-request
       (clojure.core/nth args13035 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-samlprovider
   [m13037]
   (clojure.core/let
    [credentials13038 (:credentials m13037) args13039 (:args m13037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13040
      (com.palletops.awaze.common/aws-client :iam credentials13038)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13040
       createSAMLProvider
       (identitymanagement/create-samlprovider-request
        (clojure.core/nth args13039 0)))))))
  (clojure.core/defn
   create-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSAMLProvider"}
   [credentials13042 & args13043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13044
     (com.palletops.awaze.common/aws-client :iam credentials13042)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13044
      createSAMLProvider
      (identitymanagement/create-samlprovider-request
       (clojure.core/nth args13043 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-samlprovider
   [m13045]
   (clojure.core/let
    [credentials13046 (:credentials m13045) args13047 (:args m13045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13048
      (com.palletops.awaze.common/aws-client :iam credentials13046)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13048
       updateSAMLProvider
       (identitymanagement/update-samlprovider-request
        (clojure.core/nth args13047 0)))))))
  (clojure.core/defn
   update-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSAMLProvider"}
   [credentials13050 & args13051]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13052
     (com.palletops.awaze.common/aws-client :iam credentials13050)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13052
      updateSAMLProvider
      (identitymanagement/update-samlprovider-request
       (clojure.core/nth args13051 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-sshpublic-key
   [m13053]
   (clojure.core/let
    [credentials13054 (:credentials m13053) args13055 (:args m13053)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13056
      (com.palletops.awaze.common/aws-client :iam credentials13054)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13056
       deleteSSHPublicKey
       (identitymanagement/delete-sshpublic-key-request
        (clojure.core/nth args13055 0)))))))
  (clojure.core/defn
   delete-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSSHPublicKey"}
   [credentials13058 & args13059]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13060
     (com.palletops.awaze.common/aws-client :iam credentials13058)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13060
      deleteSSHPublicKey
      (identitymanagement/delete-sshpublic-key-request
       (clojure.core/nth args13059 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-custom-policy
   [m13061]
   (clojure.core/let
    [credentials13062 (:credentials m13061) args13063 (:args m13061)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13064
      (com.palletops.awaze.common/aws-client :iam credentials13062)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13064
       simulateCustomPolicy
       (identitymanagement/simulate-custom-policy-request
        (clojure.core/nth args13063 0)))))))
  (clojure.core/defn
   simulate-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulateCustomPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :simulate-custom-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulateCustomPolicy"}
   [credentials13066 & args13067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13068
     (com.palletops.awaze.common/aws-client :iam credentials13066)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13068
      simulateCustomPolicy
      (identitymanagement/simulate-custom-policy-request
       (clojure.core/nth args13067 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-custom-policy
   [m13069]
   (clojure.core/let
    [credentials13070 (:credentials m13069) args13071 (:args m13069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13072
      (com.palletops.awaze.common/aws-client :iam credentials13070)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13072
       getContextKeysForCustomPolicy
       (identitymanagement/get-context-keys-for-custom-policy-request
        (clojure.core/nth args13071 0)))))))
  (clojure.core/defn
   get-context-keys-for-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForCustomPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-custom-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForCustomPolicy"}
   [credentials13074 & args13075]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13076
     (com.palletops.awaze.common/aws-client :iam credentials13074)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13076
      getContextKeysForCustomPolicy
      (identitymanagement/get-context-keys-for-custom-policy-request
       (clojure.core/nth args13075 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m13077]
   (clojure.core/let
    [credentials13078 (:credentials m13077) args13079 (:args m13077)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13080
      (com.palletops.awaze.common/aws-client :iam credentials13078)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13080
       listUserPolicies
       (identitymanagement/list-user-policies-request
        (clojure.core/nth args13079 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-user-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUserPolicies"}
   [credentials13082 & args13083]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13084
     (com.palletops.awaze.common/aws-client :iam credentials13082)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13084
      listUserPolicies
      (identitymanagement/list-user-policies-request
       (clojure.core/nth args13083 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m13085]
   (clojure.core/let
    [credentials13086 (:credentials m13085) args13087 (:args m13085)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13088
      (com.palletops.awaze.common/aws-client :iam credentials13086)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13088
       updateGroup
       (identitymanagement/update-group-request
        (clojure.core/nth args13087 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Call updateGroup"}
   [credentials13090 & args13091]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13092
     (com.palletops.awaze.common/aws-client :iam credentials13090)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13092
      updateGroup
      (identitymanagement/update-group-request
       (clojure.core/nth args13091 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-entities-for-policy
   [m13093]
   (clojure.core/let
    [credentials13094 (:credentials m13093) args13095 (:args m13093)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13096
      (com.palletops.awaze.common/aws-client :iam credentials13094)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13096
       listEntitiesForPolicy
       (identitymanagement/list-entities-for-policy-request
        (clojure.core/nth args13095 0)))))))
  (clojure.core/defn
   list-entities-for-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listEntitiesForPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-entities-for-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-entities-for-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listEntitiesForPolicy"}
   [credentials13098 & args13099]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13100
     (com.palletops.awaze.common/aws-client :iam credentials13098)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13100
      listEntitiesForPolicy
      (identitymanagement/list-entities-for-policy-request
       (clojure.core/nth args13099 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policies
   [m13101]
   (clojure.core/let
    [credentials13102 (:credentials m13101) args13103 (:args m13101)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13104
      (com.palletops.awaze.common/aws-client :iam credentials13102)]
     (clojure.core/case
      (clojure.core/count args13103)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13104
        listPolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13104
        listPolicies
        (identitymanagement/list-policies-request
         (clojure.core/nth args13103 0))))))))
  (clojure.core/defn
   list-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPolicies, listPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-policies,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listPolicies, listPolicies"}
   [credentials13106 & args13107]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13108
     (com.palletops.awaze.common/aws-client :iam credentials13106)]
    (clojure.core/case
     (clojure.core/count args13107)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13108
       listPolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13108
       listPolicies
       (identitymanagement/list-policies-request
        (clojure.core/nth args13107 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m13109]
   (clojure.core/let
    [credentials13110 (:credentials m13109) args13111 (:args m13109)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13112
      (com.palletops.awaze.common/aws-client :iam credentials13110)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13112
       deleteUser
       (identitymanagement/delete-user-request
        (clojure.core/nth args13111 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUser"}
   [credentials13114 & args13115]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13116
     (com.palletops.awaze.common/aws-client :iam credentials13114)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13116
      deleteUser
      (identitymanagement/delete-user-request
       (clojure.core/nth args13115 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m13117]
   (clojure.core/let
    [credentials13118 (:credentials m13117) args13119 (:args m13117)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13120
      (com.palletops.awaze.common/aws-client :iam credentials13118)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13120
       updateSigningCertificate
       (identitymanagement/update-signing-certificate-request
        (clojure.core/nth args13119 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials13122 & args13123]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13124
     (com.palletops.awaze.common/aws-client :iam credentials13122)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13124
      updateSigningCertificate
      (identitymanagement/update-signing-certificate-request
       (clojure.core/nth args13123 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-principal-policy
   [m13125]
   (clojure.core/let
    [credentials13126 (:credentials m13125) args13127 (:args m13125)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13128
      (com.palletops.awaze.common/aws-client :iam credentials13126)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13128
       getContextKeysForPrincipalPolicy
       (identitymanagement/get-context-keys-for-principal-policy-request
        (clojure.core/nth args13127 0)))))))
  (clojure.core/defn
   get-context-keys-for-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForPrincipalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-principal-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForPrincipalPolicy"}
   [credentials13130 & args13131]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13132
     (com.palletops.awaze.common/aws-client :iam credentials13130)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13132
      getContextKeysForPrincipalPolicy
      (identitymanagement/get-context-keys-for-principal-policy-request
       (clojure.core/nth args13131 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m13133]
   (clojure.core/let
    [credentials13134 (:credentials m13133) args13135 (:args m13133)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13136
      (com.palletops.awaze.common/aws-client :iam credentials13134)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13136
       updateServerCertificate
       (identitymanagement/update-server-certificate-request
        (clojure.core/nth args13135 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServerCertificate"}
   [credentials13138 & args13139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13140
     (com.palletops.awaze.common/aws-client :iam credentials13138)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13140
      updateServerCertificate
      (identitymanagement/update-server-certificate-request
       (clojure.core/nth args13139 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-user-policies
   [m13141]
   (clojure.core/let
    [credentials13142 (:credentials m13141) args13143 (:args m13141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13144
      (com.palletops.awaze.common/aws-client :iam credentials13142)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13144
       listAttachedUserPolicies
       (identitymanagement/list-attached-user-policies-request
        (clojure.core/nth args13143 0)))))))
  (clojure.core/defn
   list-attached-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedUserPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-user-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedUserPolicies"}
   [credentials13146 & args13147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13148
     (com.palletops.awaze.common/aws-client :iam credentials13146)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13148
      listAttachedUserPolicies
      (identitymanagement/list-attached-user-policies-request
       (clojure.core/nth args13147 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy-version
   [m13149]
   (clojure.core/let
    [credentials13150 (:credentials m13149) args13151 (:args m13149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13152
      (com.palletops.awaze.common/aws-client :iam credentials13150)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13152
       createPolicyVersion
       (identitymanagement/create-policy-version-request
        (clojure.core/nth args13151 0)))))))
  (clojure.core/defn
   create-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Generate map for createPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Call createPolicyVersion"}
   [credentials13154 & args13155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13156
     (com.palletops.awaze.common/aws-client :iam credentials13154)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13156
      createPolicyVersion
      (identitymanagement/create-policy-version-request
       (clojure.core/nth args13155 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m13157]
   (clojure.core/let
    [credentials13158 (:credentials m13157) args13159 (:args m13157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13160
      (com.palletops.awaze.common/aws-client :iam credentials13158)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13160
       createLoginProfile
       (identitymanagement/create-login-profile-request
        (clojure.core/nth args13159 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoginProfile"}
   [credentials13162 & args13163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13164
     (com.palletops.awaze.common/aws-client :iam credentials13162)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13164
      createLoginProfile
      (identitymanagement/create-login-profile-request
       (clojure.core/nth args13163 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-principal-policy
   [m13165]
   (clojure.core/let
    [credentials13166 (:credentials m13165) args13167 (:args m13165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13168
      (com.palletops.awaze.common/aws-client :iam credentials13166)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13168
       simulatePrincipalPolicy
       (identitymanagement/simulate-principal-policy-request
        (clojure.core/nth args13167 0)))))))
  (clojure.core/defn
   simulate-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulatePrincipalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :simulate-principal-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulatePrincipalPolicy"}
   [credentials13170 & args13171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13172
     (com.palletops.awaze.common/aws-client :iam credentials13170)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13172
      simulatePrincipalPolicy
      (identitymanagement/simulate-principal-policy-request
       (clojure.core/nth args13171 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-open-idconnect-provider
   [m13173]
   (clojure.core/let
    [credentials13174 (:credentials m13173) args13175 (:args m13173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13176
      (com.palletops.awaze.common/aws-client :iam credentials13174)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13176
       createOpenIDConnectProvider
       (identitymanagement/create-open-idconnect-provider-request
        (clojure.core/nth args13175 0)))))))
  (clojure.core/defn
   create-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Call createOpenIDConnectProvider"}
   [credentials13178 & args13179]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13180
     (com.palletops.awaze.common/aws-client :iam credentials13178)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13180
      createOpenIDConnectProvider
      (identitymanagement/create-open-idconnect-provider-request
       (clojure.core/nth args13179 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-role-policy
   [m13181]
   (clojure.core/let
    [credentials13182 (:credentials m13181) args13183 (:args m13181)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13184
      (com.palletops.awaze.common/aws-client :iam credentials13182)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13184
       attachRolePolicy
       (identitymanagement/attach-role-policy-request
        (clojure.core/nth args13183 0)))))))
  (clojure.core/defn
   attach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachRolePolicy"}
   [credentials13186 & args13187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13188
     (com.palletops.awaze.common/aws-client :iam credentials13186)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13188
      attachRolePolicy
      (identitymanagement/attach-role-policy-request
       (clojure.core/nth args13187 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m13189]
   (clojure.core/let
    [credentials13190 (:credentials m13189) args13191 (:args m13189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13192
      (com.palletops.awaze.common/aws-client :iam credentials13190)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13192
       getGroupPolicy
       (identitymanagement/get-group-policy-request
        (clojure.core/nth args13191 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroupPolicy"}
   [credentials13194 & args13195]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13196
     (com.palletops.awaze.common/aws-client :iam credentials13194)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13196
      getGroupPolicy
      (identitymanagement/get-group-policy-request
       (clojure.core/nth args13195 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-user-policy
   [m13197]
   (clojure.core/let
    [credentials13198 (:credentials m13197) args13199 (:args m13197)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13200
      (com.palletops.awaze.common/aws-client :iam credentials13198)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13200
       detachUserPolicy
       (identitymanagement/detach-user-policy-request
        (clojure.core/nth args13199 0)))))))
  (clojure.core/defn
   detach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachUserPolicy"}
   [credentials13202 & args13203]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13204
     (com.palletops.awaze.common/aws-client :iam credentials13202)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13204
      detachUserPolicy
      (identitymanagement/detach-user-policy-request
       (clojure.core/nth args13203 0))))))))
