(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.ec2 :as ec2]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsBlockDevice}
ebs-block-device
  [m1947]
  (clojure.core/let
   [bean1946 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/let
    [v1948
     (:encrypted m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setEncrypted (clojure.core/boolean v1948))))
   (clojure.core/let
    [v1948
     (:snapshot-id m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setSnapshotId (clojure.core/str v1948))))
   (clojure.core/let
    [v1948
     (:volume-type m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setVolumeType (clojure.core/str v1948))))
   (clojure.core/let
    [v1948 (:iops m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setIops (clojure.core/int v1948))))
   (clojure.core/let
    [v1948
     (:delete-on-termination
      m1947
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setDeleteOnTermination (clojure.core/boolean v1948))))
   (clojure.core/let
    [v1948
     (:volume-size m1947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1948 :com.palletops.awaze.client-builder/undef)
     (. bean1946 setVolumeSize (clojure.core/int v1948))))
   bean1946))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrivateIpAddressSpecification}
private-ip-address-specification
  [m1950]
  (clojure.core/let
   [bean1949
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/let
    [v1951
     (:private-ip-address
      m1950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setPrivateIpAddress (clojure.core/str v1951))))
   (clojure.core/let
    [v1951 (:primary m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setPrimary (clojure.core/boolean v1951))))
   bean1949))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageFormat}
disk-image-format
  [m1953]
  (.
   com.amazonaws.services.ec2.model.DiskImageFormat
   fromValue
   (clojure.core/name m1953)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IamInstanceProfileSpecification}
iam-instance-profile-specification
  [m1956]
  (clojure.core/let
   [bean1955
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/let
    [v1957 (:arn m1956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1957 :com.palletops.awaze.client-builder/undef)
     (. bean1955 setArn (clojure.core/str v1957))))
   (clojure.core/let
    [v1957 (:name m1956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1957 :com.palletops.awaze.client-builder/undef)
     (. bean1955 setName (clojure.core/str v1957))))
   bean1955))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotPlacement}
spot-placement
  [m1959]
  (clojure.core/let
   [bean1958 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/let
    [v1960
     (:group-name m1959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1960 :com.palletops.awaze.client-builder/undef)
     (. bean1958 setGroupName (clojure.core/str v1960))))
   (clojure.core/let
    [v1960
     (:availability-zone
      m1959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1960 :com.palletops.awaze.client-builder/undef)
     (. bean1958 setAvailabilityZone (clojure.core/str v1960))))
   bean1958))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetMonitoring}
spot-fleet-monitoring
  [m1962]
  (clojure.core/let
   [bean1961
    (new com.amazonaws.services.ec2.model.SpotFleetMonitoring)]
   (clojure.core/let
    [v1963 (:enabled m1962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1963 :com.palletops.awaze.client-builder/undef)
     (. bean1961 setEnabled (clojure.core/boolean v1963))))
   bean1961))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GroupIdentifier}
group-identifier
  [m1965]
  (clojure.core/let
   [bean1964 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/let
    [v1966
     (:group-id m1965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1966 :com.palletops.awaze.client-builder/undef)
     (. bean1964 setGroupId (clojure.core/str v1966))))
   (clojure.core/let
    [v1966
     (:group-name m1965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1966 :com.palletops.awaze.client-builder/undef)
     (. bean1964 setGroupName (clojure.core/str v1966))))
   bean1964))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BlockDeviceMapping}
block-device-mapping
  [m1968]
  (clojure.core/let
   [bean1967
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/let
    [v1969
     (:device-name m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setDeviceName (clojure.core/str v1969))))
   (clojure.core/let
    [v1969
     (:virtual-name m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setVirtualName (clojure.core/str v1969))))
   (clojure.core/let
    [v1969 (:ebs m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setEbs (ec2/ebs-block-device v1969))))
   (clojure.core/let
    [v1969
     (:no-device m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setNoDevice (clojure.core/str v1969))))
   bean1967))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification}
instance-network-interface-specification
  [m1971]
  (clojure.core/let
   [bean1970
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/let
    [v1972
     (:description m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setDescription (clojure.core/str v1972))))
   (clojure.core/let
    [v1972
     (:subnet-id m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setSubnetId (clojure.core/str v1972))))
   (clojure.core/let
    [v1972
     (:secondary-private-ip-address-count
      m1971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (.
      bean1970
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v1972))))
   (clojure.core/let
    [v1972
     (:device-index m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setDeviceIndex (clojure.core/int v1972))))
   (clojure.core/let
    [v1972
     (:private-ip-address
      m1971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setPrivateIpAddress (clojure.core/str v1972))))
   (clojure.core/let
    [v1972 (:groups m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (.
      bean1970
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2759] (clojure.core/str arg2759))
 v1972))))
   (clojure.core/let
    [v1972
     (:network-interface-id
      m1971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setNetworkInterfaceId (clojure.core/str v1972))))
   (clojure.core/let
    [v1972
     (:associate-public-ip-address
      m1971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (.
      bean1970
      setAssociatePublicIpAddress
      (clojure.core/boolean v1972))))
   (clojure.core/let
    [v1972
     (:private-ip-addresses
      m1971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (.
      bean1970
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2760]
  (ec2/private-ip-address-specification arg2760))
 v1972))))
   (clojure.core/let
    [v1972
     (:delete-on-termination
      m1971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setDeleteOnTermination (clojure.core/boolean v1972))))
   bean1970))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesEbs}
scheduled-instances-ebs
  [m1974]
  (clojure.core/let
   [bean1973
    (new com.amazonaws.services.ec2.model.ScheduledInstancesEbs)]
   (clojure.core/let
    [v1975
     (:encrypted m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setEncrypted (clojure.core/boolean v1975))))
   (clojure.core/let
    [v1975
     (:snapshot-id m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setSnapshotId (clojure.core/str v1975))))
   (clojure.core/let
    [v1975
     (:volume-type m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setVolumeType (clojure.core/str v1975))))
   (clojure.core/let
    [v1975 (:iops m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setIops (clojure.core/int v1975))))
   (clojure.core/let
    [v1975
     (:delete-on-termination
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setDeleteOnTermination (clojure.core/boolean v1975))))
   (clojure.core/let
    [v1975
     (:volume-size m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setVolumeSize (clojure.core/int v1975))))
   bean1973))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig}
scheduled-instances-private-ip-address-config
  [m1977]
  (clojure.core/let
   [bean1976
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig)]
   (clojure.core/let
    [v1978
     (:private-ip-address
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setPrivateIpAddress (clojure.core/str v1978))))
   (clojure.core/let
    [v1978 (:primary m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setPrimary (clojure.core/boolean v1978))))
   bean1976))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrefixListId}
prefix-list-id
  [m1980]
  (clojure.core/let
   [bean1979 (new com.amazonaws.services.ec2.model.PrefixListId)]
   (clojure.core/let
    [v1981
     (:prefix-list-id m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setPrefixListId (clojure.core/str v1981))))
   bean1979))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserIdGroupPair}
user-id-group-pair
  [m1983]
  (clojure.core/let
   [bean1982 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/let
    [v1984 (:vpc-id m1983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setVpcId (clojure.core/str v1984))))
   (clojure.core/let
    [v1984
     (:vpc-peering-connection-id
      m1983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setVpcPeeringConnectionId (clojure.core/str v1984))))
   (clojure.core/let
    [v1984
     (:group-id m1983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setGroupId (clojure.core/str v1984))))
   (clojure.core/let
    [v1984
     (:group-name m1983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setGroupName (clojure.core/str v1984))))
   (clojure.core/let
    [v1984 (:user-id m1983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setUserId (clojure.core/str v1984))))
   (clojure.core/let
    [v1984
     (:peering-status m1983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setPeeringStatus (clojure.core/str v1984))))
   bean1982))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification}
ebs-instance-block-device-specification
  [m1986]
  (clojure.core/let
   [bean1985
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/let
    [v1987
     (:volume-id m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setVolumeId (clojure.core/str v1987))))
   (clojure.core/let
    [v1987
     (:delete-on-termination
      m1986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setDeleteOnTermination (clojure.core/boolean v1987))))
   bean1985))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Placement}
placement
  [m1989]
  (clojure.core/let
   [bean1988 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/let
    [v1990 (:tenancy m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setTenancy (clojure.core/str v1990))))
   (clojure.core/let
    [v1990
     (:affinity m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setAffinity (clojure.core/str v1990))))
   (clojure.core/let
    [v1990 (:host-id m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setHostId (clojure.core/str v1990))))
   (clojure.core/let
    [v1990
     (:group-name m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setGroupName (clojure.core/str v1990))))
   (clojure.core/let
    [v1990
     (:availability-zone
      m1989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setAvailabilityZone (clojure.core/str v1990))))
   bean1988))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ShutdownBehavior}
shutdown-behavior
  [m1992]
  (.
   com.amazonaws.services.ec2.model.ShutdownBehavior
   fromValue
   (clojure.core/name m1992)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ArchitectureValues}
architecture-values
  [m1995]
  (.
   com.amazonaws.services.ec2.model.ArchitectureValues
   fromValue
   (clojure.core/name m1995)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserData}
user-data
  [m1998]
  (clojure.core/let
   [bean1997 (new com.amazonaws.services.ec2.model.UserData)]
   (clojure.core/let
    [v1999 (:data m1998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1999 :com.palletops.awaze.client-builder/undef)
     (. bean1997 setData (clojure.core/str v1999))))
   bean1997))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageDetail}
disk-image-detail
  [m2001]
  (clojure.core/let
   [bean2000 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/let
    [v2002 (:format m2001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2002 :com.palletops.awaze.client-builder/undef)
     (. bean2000 setFormat (ec2/disk-image-format v2002))))
   (clojure.core/let
    [v2002
     (:import-manifest-url
      m2001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2002 :com.palletops.awaze.client-builder/undef)
     (. bean2000 setImportManifestUrl (clojure.core/str v2002))))
   (clojure.core/let
    [v2002 (:bytes m2001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2002 :com.palletops.awaze.client-builder/undef)
     (. bean2000 setBytes (clojure.core/long v2002))))
   bean2000))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeDetail}
volume-detail
  [m2004]
  (clojure.core/let
   [bean2003 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/let
    [v2005 (:size m2004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setSize (clojure.core/long v2005))))
   bean2003))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermission}
create-volume-permission
  [m2007]
  (clojure.core/let
   [bean2006
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/let
    [v2008 (:group m2007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2008 :com.palletops.awaze.client-builder/undef)
     (. bean2006 setGroup (clojure.core/str v2008))))
   (clojure.core/let
    [v2008 (:user-id m2007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2008 :com.palletops.awaze.client-builder/undef)
     (. bean2006 setUserId (clojure.core/str v2008))))
   bean2006))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification}
spot-fleet-launch-specification
  [m2010]
  (clojure.core/let
   [bean2009
    (new
     com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification)]
   (clojure.core/let
    [v2011
     (:spot-price m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setSpotPrice (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:iam-instance-profile
      m2010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (.
      bean2009
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2011))))
   (clojure.core/let
    [v2011
     (:subnet-id m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setSubnetId (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:placement m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setPlacement (ec2/spot-placement v2011))))
   (clojure.core/let
    [v2011
     (:addressing-type
      m2010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setAddressingType (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:instance-type m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setInstanceType (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:ebs-optimized m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setEbsOptimized (clojure.core/boolean v2011))))
   (clojure.core/let
    [v2011
     (:ramdisk-id m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setRamdiskId (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:weighted-capacity
      m2010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setWeightedCapacity (clojure.core/double v2011))))
   (clojure.core/let
    [v2011
     (:image-id m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setImageId (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:key-name m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setKeyName (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:kernel-id m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setKernelId (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:monitoring m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setMonitoring (ec2/spot-fleet-monitoring v2011))))
   (clojure.core/let
    [v2011
     (:security-groups
      m2010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (.
      bean2009
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2761] (ec2/group-identifier arg2761))
 v2011))))
   (clojure.core/let
    [v2011
     (:block-device-mappings
      m2010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (.
      bean2009
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2762] (ec2/block-device-mapping arg2762))
 v2011))))
   (clojure.core/let
    [v2011
     (:user-data m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setUserData (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:network-interfaces
      m2010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (.
      bean2009
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2763]
  (ec2/instance-network-interface-specification arg2763))
 v2011))))
   bean2009))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy}
excess-capacity-termination-policy
  [m2013]
  (.
   com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy
   fromValue
   (clojure.core/name m2013)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceType}
instance-type
  [m2016]
  (.
   com.amazonaws.services.ec2.model.InstanceType
   fromValue
   (clojure.core/name m2016)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserBucket}
user-bucket
  [m2019]
  (clojure.core/let
   [bean2018 (new com.amazonaws.services.ec2.model.UserBucket)]
   (clojure.core/let
    [v2020
     (:s3bucket m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setS3Bucket (clojure.core/str v2020))))
   (clojure.core/let
    [v2020 (:s3key m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setS3Key (clojure.core/str v2020))))
   bean2018))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.S3Storage}
s3storage
  [m2022]
  (clojure.core/let
   [bean2021 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/let
    [v2023 (:bucket m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setBucket (clojure.core/str v2023))))
   (clojure.core/let
    [v2023 (:prefix m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setPrefix (clojure.core/str v2023))))
   (clojure.core/let
    [v2023
     (:awsaccess-key-id
      m2022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setAWSAccessKeyId (clojure.core/str v2023))))
   (clojure.core/let
    [v2023
     (:upload-policy m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setUploadPolicy (clojure.core/str v2023))))
   (clojure.core/let
    [v2023
     (:upload-policy-signature
      m2022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setUploadPolicySignature (clojure.core/str v2023))))
   bean2021))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermission}
launch-permission
  [m2025]
  (clojure.core/let
   [bean2024 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/let
    [v2026 (:group m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setGroup (clojure.core/str v2026))))
   (clojure.core/let
    [v2026 (:user-id m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setUserId (clojure.core/str v2026))))
   bean2024))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile}
scheduled-instances-iam-instance-profile
  [m2028]
  (clojure.core/let
   [bean2027
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile)]
   (clojure.core/let
    [v2029 (:arn m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setArn (clojure.core/str v2029))))
   (clojure.core/let
    [v2029 (:name m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setName (clojure.core/str v2029))))
   bean2027))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPlacement}
scheduled-instances-placement
  [m2031]
  (clojure.core/let
   [bean2030
    (new com.amazonaws.services.ec2.model.ScheduledInstancesPlacement)]
   (clojure.core/let
    [v2032
     (:group-name m2031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setGroupName (clojure.core/str v2032))))
   (clojure.core/let
    [v2032
     (:availability-zone
      m2031
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setAvailabilityZone (clojure.core/str v2032))))
   bean2030))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring}
scheduled-instances-monitoring
  [m2034]
  (clojure.core/let
   [bean2033
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring)]
   (clojure.core/let
    [v2035 (:enabled m2034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (. bean2033 setEnabled (clojure.core/boolean v2035))))
   bean2033))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping}
scheduled-instances-block-device-mapping
  [m2037]
  (clojure.core/let
   [bean2036
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping)]
   (clojure.core/let
    [v2038
     (:device-name m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setDeviceName (clojure.core/str v2038))))
   (clojure.core/let
    [v2038
     (:virtual-name m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setVirtualName (clojure.core/str v2038))))
   (clojure.core/let
    [v2038 (:ebs m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setEbs (ec2/scheduled-instances-ebs v2038))))
   (clojure.core/let
    [v2038
     (:no-device m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setNoDevice (clojure.core/str v2038))))
   bean2036))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface}
scheduled-instances-network-interface
  [m2040]
  (clojure.core/let
   [bean2039
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface)]
   (clojure.core/let
    [v2041
     (:description m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setDescription (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:subnet-id m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setSubnetId (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:secondary-private-ip-address-count
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2041))))
   (clojure.core/let
    [v2041
     (:device-index m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setDeviceIndex (clojure.core/int v2041))))
   (clojure.core/let
    [v2041
     (:private-ip-address
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setPrivateIpAddress (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:private-ip-address-configs
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setPrivateIpAddressConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2764]
  (ec2/scheduled-instances-private-ip-address-config arg2764))
 v2041))))
   (clojure.core/let
    [v2041 (:groups m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2765] (clojure.core/str arg2765))
 v2041))))
   (clojure.core/let
    [v2041
     (:network-interface-id
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setNetworkInterfaceId (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:associate-public-ip-address
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setAssociatePublicIpAddress
      (clojure.core/boolean v2041))))
   (clojure.core/let
    [v2041
     (:delete-on-termination
      m2040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setDeleteOnTermination (clojure.core/boolean v2041))))
   bean2039))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PriceScheduleSpecification}
price-schedule-specification
  [m2043]
  (clojure.core/let
   [bean2042
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/let
    [v2044
     (:currency-code m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setCurrencyCode (clojure.core/str v2044))))
   (clojure.core/let
    [v2044 (:price m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setPrice (clojure.core/double v2044))))
   (clojure.core/let
    [v2044 (:term m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setTerm (clojure.core/long v2044))))
   bean2042))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IpPermission}
ip-permission
  [m2046]
  (clojure.core/let
   [bean2045 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/let
    [v2047
     (:ip-protocol m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setIpProtocol (clojure.core/str v2047))))
   (clojure.core/let
    [v2047
     (:from-port m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setFromPort (clojure.core/int v2047))))
   (clojure.core/let
    [v2047 (:to-port m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setToPort (clojure.core/int v2047))))
   (clojure.core/let
    [v2047
     (:prefix-list-ids
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2766] (ec2/prefix-list-id arg2766))
 v2047))))
   (clojure.core/let
    [v2047
     (:user-id-group-pairs
      m2046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setUserIdGroupPairs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2767] (ec2/user-id-group-pair arg2767))
 v2047))))
   (clojure.core/let
    [v2047
     (:ip-ranges m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setIpRanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2768] (clojure.core/str arg2768))
 v2047))))
   bean2045))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification}
instance-block-device-mapping-specification
  [m2049]
  (clojure.core/let
   [bean2048
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/let
    [v2050
     (:device-name m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setDeviceName (clojure.core/str v2050))))
   (clojure.core/let
    [v2050
     (:virtual-name m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setVirtualName (clojure.core/str v2050))))
   (clojure.core/let
    [v2050 (:ebs m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (.
      bean2048
      setEbs
      (ec2/ebs-instance-block-device-specification v2050))))
   (clojure.core/let
    [v2050
     (:no-device m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setNoDevice (clojure.core/str v2050))))
   bean2048))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Filter}
filter
  [m2052]
  (clojure.core/let
   [bean2051 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/let
    [v2053 (:values m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2769] (clojure.core/str arg2769))
 v2053))))
   (clojure.core/let
    [v2053 (:name m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setName (clojure.core/str v2053))))
   bean2051))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest}
slot-start-time-range-request
  [m2055]
  (clojure.core/let
   [bean2054
    (new com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest)]
   (clojure.core/let
    [v2056
     (:latest-time m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (.
      bean2054
      setLatestTime
      (com.palletops.awaze.common/to-date v2056))))
   (clojure.core/let
    [v2056
     (:earliest-time m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (.
      bean2054
      setEarliestTime
      (com.palletops.awaze.common/to-date v2056))))
   bean2054))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IcmpTypeCode}
icmp-type-code
  [m2058]
  (clojure.core/let
   [bean2057 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/let
    [v2059 (:type m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (. bean2057 setType (clojure.core/int v2059))))
   (clojure.core/let
    [v2059 (:code m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (. bean2057 setCode (clojure.core/int v2059))))
   bean2057))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PortRange}
port-range
  [m2061]
  (clojure.core/let
   [bean2060 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/let
    [v2062 (:to m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setTo (clojure.core/int v2062))))
   (clojure.core/let
    [v2062 (:from m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setFrom (clojure.core/int v2062))))
   bean2060))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification}
import-instance-launch-specification
  [m2064]
  (clojure.core/let
   [bean2063
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/let
    [v2065
     (:group-ids m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (.
      bean2063
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2770] (clojure.core/str arg2770))
 v2065))))
   (clojure.core/let
    [v2065
     (:subnet-id m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setSubnetId (clojure.core/str v2065))))
   (clojure.core/let
    [v2065
     (:additional-info
      m2064
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setAdditionalInfo (clojure.core/str v2065))))
   (clojure.core/let
    [v2065
     (:placement m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setPlacement (ec2/placement v2065))))
   (clojure.core/let
    [v2065
     (:group-names m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (.
      bean2063
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2771] (clojure.core/str arg2771))
 v2065))))
   (clojure.core/let
    [v2065
     (:private-ip-address
      m2064
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setPrivateIpAddress (clojure.core/str v2065))))
   (clojure.core/let
    [v2065
     (:instance-type m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setInstanceType (clojure.core/str v2065))))
   (clojure.core/let
    [v2065
     (:instance-initiated-shutdown-behavior
      m2064
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (.
      bean2063
      setInstanceInitiatedShutdownBehavior
      (ec2/shutdown-behavior v2065))))
   (clojure.core/let
    [v2065
     (:monitoring m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setMonitoring (clojure.core/boolean v2065))))
   (clojure.core/let
    [v2065
     (:architecture m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setArchitecture (ec2/architecture-values v2065))))
   (clojure.core/let
    [v2065
     (:user-data m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setUserData (ec2/user-data v2065))))
   bean2063))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImage}
disk-image
  [m2067]
  (clojure.core/let
   [bean2066 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/let
    [v2068 (:image m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setImage (ec2/disk-image-detail v2068))))
   (clojure.core/let
    [v2068 (:volume m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setVolume (ec2/volume-detail v2068))))
   (clojure.core/let
    [v2068
     (:description m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setDescription (clojure.core/str v2068))))
   bean2066))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotAttributeName}
snapshot-attribute-name
  [m2070]
  (.
   com.amazonaws.services.ec2.model.SnapshotAttributeName
   fromValue
   (clojure.core/name m2070)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OperationType}
operation-type
  [m2073]
  (.
   com.amazonaws.services.ec2.model.OperationType
   fromValue
   (clojure.core/name m2073)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermissionModifications}
create-volume-permission-modifications
  [m2076]
  (clojure.core/let
   [bean2075
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/let
    [v2077 (:add m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (.
      bean2075
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2772] (ec2/create-volume-permission arg2772))
 v2077))))
   (clojure.core/let
    [v2077 (:remove m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (.
      bean2075
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2773] (ec2/create-volume-permission arg2773))
 v2077))))
   bean2075))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetRequestConfigData}
spot-fleet-request-config-data
  [m2079]
  (clojure.core/let
   [bean2078
    (new com.amazonaws.services.ec2.model.SpotFleetRequestConfigData)]
   (clojure.core/let
    [v2080
     (:iam-fleet-role m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setIamFleetRole (clojure.core/str v2080))))
   (clojure.core/let
    [v2080
     (:spot-price m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setSpotPrice (clojure.core/str v2080))))
   (clojure.core/let
    [v2080
     (:launch-specifications
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setLaunchSpecifications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2774]
  (ec2/spot-fleet-launch-specification arg2774))
 v2080))))
   (clojure.core/let
    [v2080
     (:valid-from m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setValidFrom
      (com.palletops.awaze.common/to-date v2080))))
   (clojure.core/let
    [v2080
     (:client-token m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setClientToken (clojure.core/str v2080))))
   (clojure.core/let
    [v2080
     (:allocation-strategy
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setAllocationStrategy (clojure.core/str v2080))))
   (clojure.core/let
    [v2080
     (:terminate-instances-with-expiration
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setTerminateInstancesWithExpiration
      (clojure.core/boolean v2080))))
   (clojure.core/let
    [v2080
     (:target-capacity
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setTargetCapacity (clojure.core/int v2080))))
   (clojure.core/let
    [v2080
     (:valid-until m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setValidUntil
      (com.palletops.awaze.common/to-date v2080))))
   (clojure.core/let
    [v2080
     (:excess-capacity-termination-policy
      m2079
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (.
      bean2078
      setExcessCapacityTerminationPolicy
      (ec2/excess-capacity-termination-policy v2080))))
   bean2078))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportEnvironment}
export-environment
  [m2082]
  (.
   com.amazonaws.services.ec2.model.ExportEnvironment
   fromValue
   (clojure.core/name m2082)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportToS3TaskSpecification}
export-to-s3task-specification
  [m2085]
  (clojure.core/let
   [bean2084
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/let
    [v2086
     (:disk-image-format
      m2085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setDiskImageFormat (ec2/disk-image-format v2086))))
   (clojure.core/let
    [v2086
     (:container-format
      m2085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setContainerFormat (clojure.core/str v2086))))
   (clojure.core/let
    [v2086
     (:s3bucket m2085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setS3Bucket (clojure.core/str v2086))))
   (clojure.core/let
    [v2086
     (:s3prefix m2085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setS3Prefix (clojure.core/str v2086))))
   bean2084))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseRequest}
purchase-request
  [m2088]
  (clojure.core/let
   [bean2087 (new com.amazonaws.services.ec2.model.PurchaseRequest)]
   (clojure.core/let
    [v2089
     (:instance-count m2088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (. bean2087 setInstanceCount (clojure.core/int v2089))))
   (clojure.core/let
    [v2089
     (:purchase-token m2088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (. bean2087 setPurchaseToken (clojure.core/str v2089))))
   bean2087))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice}
reserved-instance-limit-price
  [m2091]
  (clojure.core/let
   [bean2090
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/let
    [v2092
     (:currency-code m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setCurrencyCode (clojure.core/str v2092))))
   (clojure.core/let
    [v2092 (:amount m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setAmount (clojure.core/double v2092))))
   bean2090))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DhcpConfiguration}
dhcp-configuration
  [m2094]
  (clojure.core/let
   [bean2093 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/let
    [v2095 (:values m2094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2095 :com.palletops.awaze.client-builder/undef)
     (.
      bean2093
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2775] (clojure.core/str arg2775))
 v2095))))
   (clojure.core/let
    [v2095 (:key m2094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2095 :com.palletops.awaze.client-builder/undef)
     (. bean2093 setKey (clojure.core/str v2095))))
   bean2093))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotInstanceType}
spot-instance-type
  [m2097]
  (.
   com.amazonaws.services.ec2.model.SpotInstanceType
   fromValue
   (clojure.core/name m2097)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchSpecification}
launch-specification
  [m2100]
  (clojure.core/let
   [bean2099
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/let
    [v2101
     (:iam-instance-profile
      m2100
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (.
      bean2099
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2101))))
   (clojure.core/let
    [v2101
     (:subnet-id m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setSubnetId (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:placement m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setPlacement (ec2/spot-placement v2101))))
   (clojure.core/let
    [v2101
     (:addressing-type
      m2100
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setAddressingType (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:instance-type m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setInstanceType (ec2/instance-type v2101))))
   (clojure.core/let
    [v2101
     (:ebs-optimized m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setEbsOptimized (clojure.core/boolean v2101))))
   (clojure.core/let
    [v2101
     (:ramdisk-id m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setRamdiskId (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:all-security-groups
      m2100
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (.
      bean2099
      setAllSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2776] (ec2/group-identifier arg2776))
 v2101))))
   (clojure.core/let
    [v2101
     (:image-id m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setImageId (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:key-name m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setKeyName (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:monitoring-enabled
      m2100
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setMonitoringEnabled (clojure.core/boolean v2101))))
   (clojure.core/let
    [v2101
     (:kernel-id m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setKernelId (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:security-groups
      m2100
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (.
      bean2099
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2777] (clojure.core/str arg2777))
 v2101))))
   (clojure.core/let
    [v2101
     (:block-device-mappings
      m2100
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (.
      bean2099
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2778] (ec2/block-device-mapping arg2778))
 v2101))))
   (clojure.core/let
    [v2101
     (:user-data m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setUserData (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:network-interfaces
      m2100
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (.
      bean2099
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2779]
  (ec2/instance-network-interface-specification arg2779))
 v2101))))
   bean2099))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotDiskContainer}
snapshot-disk-container
  [m2103]
  (clojure.core/let
   [bean2102
    (new com.amazonaws.services.ec2.model.SnapshotDiskContainer)]
   (clojure.core/let
    [v2104 (:format m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setFormat (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:description m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setDescription (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:user-bucket m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setUserBucket (ec2/user-bucket v2104))))
   (clojure.core/let
    [v2104 (:url m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setUrl (clojure.core/str v2104))))
   bean2102))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ClientData}
client-data
  [m2106]
  (clojure.core/let
   [bean2105 (new com.amazonaws.services.ec2.model.ClientData)]
   (clojure.core/let
    [v2107 (:comment m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (. bean2105 setComment (clojure.core/str v2107))))
   (clojure.core/let
    [v2107
     (:upload-start m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (.
      bean2105
      setUploadStart
      (com.palletops.awaze.common/to-date v2107))))
   (clojure.core/let
    [v2107
     (:upload-end m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (.
      bean2105
      setUploadEnd
      (com.palletops.awaze.common/to-date v2107))))
   (clojure.core/let
    [v2107
     (:upload-size m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (. bean2105 setUploadSize (clojure.core/double v2107))))
   bean2105))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tag}
tag
  [m2109]
  (clojure.core/let
   [bean2108 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/let
    [v2110 (:key m2109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2110 :com.palletops.awaze.client-builder/undef)
     (. bean2108 setKey (clojure.core/str v2110))))
   (clojure.core/let
    [v2110 (:value m2109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2110 :com.palletops.awaze.client-builder/undef)
     (. bean2108 setValue (clojure.core/str v2110))))
   bean2108))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RIProductDescription}
riproduct-description
  [m2112]
  (.
   com.amazonaws.services.ec2.model.RIProductDescription
   fromValue
   (clojure.core/name m2112)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tenancy}
tenancy
  [m2115]
  (.
   com.amazonaws.services.ec2.model.Tenancy
   fromValue
   (clojure.core/name m2115)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GatewayType}
gateway-type
  [m2118]
  (.
   com.amazonaws.services.ec2.model.GatewayType
   fromValue
   (clojure.core/name m2118)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.FlowLogsResourceType}
flow-logs-resource-type
  [m2121]
  (.
   com.amazonaws.services.ec2.model.FlowLogsResourceType
   fromValue
   (clojure.core/name m2121)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Storage}
storage
  [m2124]
  (clojure.core/let
   [bean2123 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/let
    [v2125 (:s3 m2124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2125 :com.palletops.awaze.client-builder/undef)
     (. bean2123 setS3 (ec2/s3storage v2125))))
   bean2123))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EventType}
event-type
  [m2127]
  (.
   com.amazonaws.services.ec2.model.EventType
   fromValue
   (clojure.core/name m2127)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Affinity}
affinity
  [m2130]
  (.
   com.amazonaws.services.ec2.model.Affinity
   fromValue
   (clojure.core/name m2130)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermissionModifications}
launch-permission-modifications
  [m2133]
  (clojure.core/let
   [bean2132
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/let
    [v2134 (:add m2133 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2134 :com.palletops.awaze.client-builder/undef)
     (.
      bean2132
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2780] (ec2/launch-permission arg2780))
 v2134))))
   (clojure.core/let
    [v2134 (:remove m2133 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2134 :com.palletops.awaze.client-builder/undef)
     (.
      bean2132
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2781] (ec2/launch-permission arg2781))
 v2134))))
   bean2132))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification}
vpn-connection-options-specification
  [m2136]
  (clojure.core/let
   [bean2135
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/let
    [v2137
     (:static-routes-only
      m2136
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2137 :com.palletops.awaze.client-builder/undef)
     (. bean2135 setStaticRoutesOnly (clojure.core/boolean v2137))))
   bean2135))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest}
scheduled-instance-recurrence-request
  [m2139]
  (clojure.core/let
   [bean2138
    (new
     com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest)]
   (clojure.core/let
    [v2140
     (:frequency m2139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2140 :com.palletops.awaze.client-builder/undef)
     (. bean2138 setFrequency (clojure.core/str v2140))))
   (clojure.core/let
    [v2140
     (:interval m2139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2140 :com.palletops.awaze.client-builder/undef)
     (. bean2138 setInterval (clojure.core/int v2140))))
   (clojure.core/let
    [v2140
     (:occurrence-days
      m2139
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2140 :com.palletops.awaze.client-builder/undef)
     (.
      bean2138
      setOccurrenceDays
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2782] (clojure.core/int arg2782))
 v2140))))
   (clojure.core/let
    [v2140
     (:occurrence-relative-to-end
      m2139
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2140 :com.palletops.awaze.client-builder/undef)
     (.
      bean2138
      setOccurrenceRelativeToEnd
      (clojure.core/boolean v2140))))
   (clojure.core/let
    [v2140
     (:occurrence-unit
      m2139
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2140 :com.palletops.awaze.client-builder/undef)
     (. bean2138 setOccurrenceUnit (clojure.core/str v2140))))
   bean2138))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest}
slot-date-time-range-request
  [m2142]
  (clojure.core/let
   [bean2141
    (new com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest)]
   (clojure.core/let
    [v2143
     (:latest-time m2142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2143 :com.palletops.awaze.client-builder/undef)
     (.
      bean2141
      setLatestTime
      (com.palletops.awaze.common/to-date v2143))))
   (clojure.core/let
    [v2143
     (:earliest-time m2142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2143 :com.palletops.awaze.client-builder/undef)
     (.
      bean2141
      setEarliestTime
      (com.palletops.awaze.common/to-date v2143))))
   bean2141))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OfferingTypeValues}
offering-type-values
  [m2145]
  (.
   com.amazonaws.services.ec2.model.OfferingTypeValues
   fromValue
   (clojure.core/name m2145)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImageDiskContainer}
image-disk-container
  [m2148]
  (clojure.core/let
   [bean2147
    (new com.amazonaws.services.ec2.model.ImageDiskContainer)]
   (clojure.core/let
    [v2149 (:format m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setFormat (clojure.core/str v2149))))
   (clojure.core/let
    [v2149
     (:description m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setDescription (clojure.core/str v2149))))
   (clojure.core/let
    [v2149
     (:snapshot-id m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setSnapshotId (clojure.core/str v2149))))
   (clojure.core/let
    [v2149
     (:device-name m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setDeviceName (clojure.core/str v2149))))
   (clojure.core/let
    [v2149
     (:user-bucket m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setUserBucket (ec2/user-bucket v2149))))
   (clojure.core/let
    [v2149 (:url m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (. bean2147 setUrl (clojure.core/str v2149))))
   bean2147))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification}
scheduled-instances-launch-specification
  [m2151]
  (clojure.core/let
   [bean2150
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification)]
   (clojure.core/let
    [v2152
     (:iam-instance-profile
      m2151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (.
      bean2150
      setIamInstanceProfile
      (ec2/scheduled-instances-iam-instance-profile v2152))))
   (clojure.core/let
    [v2152
     (:subnet-id m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (. bean2150 setSubnetId (clojure.core/str v2152))))
   (clojure.core/let
    [v2152
     (:security-group-ids
      m2151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (.
      bean2150
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2783] (clojure.core/str arg2783))
 v2152))))
   (clojure.core/let
    [v2152
     (:placement m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (.
      bean2150
      setPlacement
      (ec2/scheduled-instances-placement v2152))))
   (clojure.core/let
    [v2152
     (:instance-type m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (. bean2150 setInstanceType (clojure.core/str v2152))))
   (clojure.core/let
    [v2152
     (:ebs-optimized m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (. bean2150 setEbsOptimized (clojure.core/boolean v2152))))
   (clojure.core/let
    [v2152
     (:ramdisk-id m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (. bean2150 setRamdiskId (clojure.core/str v2152))))
   (clojure.core/let
    [v2152
     (:image-id m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (. bean2150 setImageId (clojure.core/str v2152))))
   (clojure.core/let
    [v2152
     (:key-name m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (. bean2150 setKeyName (clojure.core/str v2152))))
   (clojure.core/let
    [v2152
     (:kernel-id m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (. bean2150 setKernelId (clojure.core/str v2152))))
   (clojure.core/let
    [v2152
     (:monitoring m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (.
      bean2150
      setMonitoring
      (ec2/scheduled-instances-monitoring v2152))))
   (clojure.core/let
    [v2152
     (:block-device-mappings
      m2151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (.
      bean2150
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2784]
  (ec2/scheduled-instances-block-device-mapping arg2784))
 v2152))))
   (clojure.core/let
    [v2152
     (:user-data m2151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (. bean2150 setUserData (clojure.core/str v2152))))
   (clojure.core/let
    [v2152
     (:network-interfaces
      m2151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2152 :com.palletops.awaze.client-builder/undef)
     (.
      bean2150
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2785]
  (ec2/scheduled-instances-network-interface arg2785))
 v2152))))
   bean2150))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstancesConfiguration}
reserved-instances-configuration
  [m2154]
  (clojure.core/let
   [bean2153
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/let
    [v2155
     (:platform m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setPlatform (clojure.core/str v2155))))
   (clojure.core/let
    [v2155
     (:instance-count m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setInstanceCount (clojure.core/int v2155))))
   (clojure.core/let
    [v2155
     (:availability-zone
      m2154
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setAvailabilityZone (clojure.core/str v2155))))
   (clojure.core/let
    [v2155
     (:instance-type m2154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setInstanceType (ec2/instance-type v2155))))
   bean2153))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges}
network-interface-attachment-changes
  [m2157]
  (clojure.core/let
   [bean2156
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/let
    [v2158
     (:attachment-id m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setAttachmentId (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:delete-on-termination
      m2157
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setDeleteOnTermination (clojure.core/boolean v2158))))
   bean2156))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest}
delete-vpc-endpoints-request
  [m2160]
  (clojure.core/let
   [bean2159
    (new com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest)]
   (clojure.core/let
    [v2161
     (:vpc-endpoint-ids
      m2160
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (.
      bean2159
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2786] (clojure.core/str arg2786))
 v2161))))
   bean2159))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNatGatewayRequest}
create-nat-gateway-request
  [m2163]
  (clojure.core/let
   [bean2162
    (new com.amazonaws.services.ec2.model.CreateNatGatewayRequest)]
   (clojure.core/let
    [v2164
     (:client-token m2163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2164 :com.palletops.awaze.client-builder/undef)
     (. bean2162 setClientToken (clojure.core/str v2164))))
   (clojure.core/let
    [v2164
     (:allocation-id m2163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2164 :com.palletops.awaze.client-builder/undef)
     (. bean2162 setAllocationId (clojure.core/str v2164))))
   (clojure.core/let
    [v2164
     (:subnet-id m2163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2164 :com.palletops.awaze.client-builder/undef)
     (. bean2162 setSubnetId (clojure.core/str v2164))))
   bean2162))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StopInstancesRequest}
stop-instances-request
  [m2166]
  (clojure.core/let
   [bean2165
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/let
    [v2167 (:force m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setForce (clojure.core/boolean v2167))))
   (clojure.core/let
    [v2167
     (:instance-ids m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (.
      bean2165
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2787] (clojure.core/str arg2787))
 v2167))))
   bean2165))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreatePlacementGroupRequest}
create-placement-group-request
  [m2169]
  (clojure.core/let
   [bean2168
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/let
    [v2170
     (:group-name m2169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setGroupName (clojure.core/str v2170))))
   (clojure.core/let
    [v2170
     (:strategy m2169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2170 :com.palletops.awaze.client-builder/undef)
     (. bean2168 setStrategy (clojure.core/str v2170))))
   bean2168))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest}
create-reserved-instances-listing-request
  [m2172]
  (clojure.core/let
   [bean2171
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/let
    [v2173
     (:client-token m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setClientToken (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:reserved-instances-id
      m2172
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setReservedInstancesId (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:instance-count m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setInstanceCount (clojure.core/int v2173))))
   (clojure.core/let
    [v2173
     (:price-schedules
      m2172
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (.
      bean2171
      setPriceSchedules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2788]
  (ec2/price-schedule-specification arg2788))
 v2173))))
   bean2171))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseHostsRequest}
release-hosts-request
  [m2175]
  (clojure.core/let
   [bean2174
    (new com.amazonaws.services.ec2.model.ReleaseHostsRequest)]
   (clojure.core/let
    [v2176
     (:host-ids m2175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2176 :com.palletops.awaze.client-builder/undef)
     (.
      bean2174
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2789] (clojure.core/str arg2789))
 v2176))))
   bean2174))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest}
revoke-security-group-ingress-request
  [m2178]
  (clojure.core/let
   [bean2177
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2179 (:cidr-ip m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setCidrIp (clojure.core/str v2179))))
   (clojure.core/let
    [v2179
     (:group-id m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setGroupId (clojure.core/str v2179))))
   (clojure.core/let
    [v2179 (:to-port m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setToPort (clojure.core/int v2179))))
   (clojure.core/let
    [v2179
     (:source-security-group-owner-id
      m2178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (.
      bean2177
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2179))))
   (clojure.core/let
    [v2179
     (:ip-permissions m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (.
      bean2177
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2790] (ec2/ip-permission arg2790))
 v2179))))
   (clojure.core/let
    [v2179
     (:source-security-group-name
      m2178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setSourceSecurityGroupName (clojure.core/str v2179))))
   (clojure.core/let
    [v2179
     (:group-name m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setGroupName (clojure.core/str v2179))))
   (clojure.core/let
    [v2179
     (:ip-protocol m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setIpProtocol (clojure.core/str v2179))))
   (clojure.core/let
    [v2179
     (:from-port m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setFromPort (clojure.core/int v2179))))
   bean2177))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest}
attach-classic-link-vpc-request
  [m2181]
  (clojure.core/let
   [bean2180
    (new com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2182 (:vpc-id m2181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2182 :com.palletops.awaze.client-builder/undef)
     (. bean2180 setVpcId (clojure.core/str v2182))))
   (clojure.core/let
    [v2182
     (:instance-id m2181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2182 :com.palletops.awaze.client-builder/undef)
     (. bean2180 setInstanceId (clojure.core/str v2182))))
   (clojure.core/let
    [v2182 (:groups m2181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2182 :com.palletops.awaze.client-builder/undef)
     (.
      bean2180
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2791] (clojure.core/str arg2791))
 v2182))))
   bean2180))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest}
replace-network-acl-association-request
  [m2184]
  (clojure.core/let
   [bean2183
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/let
    [v2185
     (:association-id m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setAssociationId (clojure.core/str v2185))))
   (clojure.core/let
    [v2185
     (:network-acl-id m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setNetworkAclId (clojure.core/str v2185))))
   bean2183))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNatGatewayRequest}
delete-nat-gateway-request
  [m2187]
  (clojure.core/let
   [bean2186
    (new com.amazonaws.services.ec2.model.DeleteNatGatewayRequest)]
   (clojure.core/let
    [v2188
     (:nat-gateway-id m2187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2188 :com.palletops.awaze.client-builder/undef)
     (. bean2186 setNatGatewayId (clojure.core/str v2188))))
   bean2186))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest}
modify-instance-attribute-request
  [m2190]
  (clojure.core/let
   [bean2189
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/let
    [v2191 (:kernel m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setKernel (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:instance-type m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setInstanceType (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:ebs-optimized m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setEbsOptimized (clojure.core/boolean v2191))))
   (clojure.core/let
    [v2191
     (:source-dest-check
      m2190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setSourceDestCheck (clojure.core/boolean v2191))))
   (clojure.core/let
    [v2191
     (:instance-id m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setInstanceId (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:instance-initiated-shutdown-behavior
      m2190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (.
      bean2189
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v2191))))
   (clojure.core/let
    [v2191 (:groups m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (.
      bean2189
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2792] (clojure.core/str arg2792))
 v2191))))
   (clojure.core/let
    [v2191
     (:disable-api-termination
      m2190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (.
      bean2189
      setDisableApiTermination
      (clojure.core/boolean v2191))))
   (clojure.core/let
    [v2191
     (:attribute m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setAttribute (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:sriov-net-support
      m2190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setSriovNetSupport (clojure.core/str v2191))))
   (clojure.core/let
    [v2191 (:value m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setValue (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:block-device-mappings
      m2190
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (.
      bean2189
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2793]
  (ec2/instance-block-device-mapping-specification arg2793))
 v2191))))
   (clojure.core/let
    [v2191 (:ramdisk m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setRamdisk (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:user-data m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setUserData (clojure.core/str v2191))))
   bean2189))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest}
describe-network-acls-request
  [m2193]
  (clojure.core/let
   [bean2192
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/let
    [v2194 (:filters m2193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2194 :com.palletops.awaze.client-builder/undef)
     (.
      bean2192
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2794] (ec2/filter arg2794))
 v2194))))
   (clojure.core/let
    [v2194
     (:network-acl-ids
      m2193
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2194 :com.palletops.awaze.client-builder/undef)
     (.
      bean2192
      setNetworkAclIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2795] (clojure.core/str arg2795))
 v2194))))
   bean2192))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportInstanceStatusRequest}
report-instance-status-request
  [m2196]
  (clojure.core/let
   [bean2195
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/let
    [v2197
     (:instances m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2796] (clojure.core/str arg2796))
 v2197))))
   (clojure.core/let
    [v2197 (:status m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setStatus (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:reason-codes m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setReasonCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2797] (clojure.core/str arg2797))
 v2197))))
   (clojure.core/let
    [v2197
     (:description m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (. bean2195 setDescription (clojure.core/str v2197))))
   (clojure.core/let
    [v2197
     (:end-time m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setEndTime
      (com.palletops.awaze.common/to-date v2197))))
   (clojure.core/let
    [v2197
     (:start-time m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setStartTime
      (com.palletops.awaze.common/to-date v2197))))
   bean2195))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImagesRequest}
describe-images-request
  [m2199]
  (clojure.core/let
   [bean2198
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/let
    [v2200 (:filters m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2798] (ec2/filter arg2798))
 v2200))))
   (clojure.core/let
    [v2200
     (:image-ids m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setImageIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2799] (clojure.core/str arg2799))
 v2200))))
   (clojure.core/let
    [v2200 (:owners m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setOwners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2800] (clojure.core/str arg2800))
 v2200))))
   (clojure.core/let
    [v2200
     (:executable-users
      m2199
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setExecutableUsers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2801] (clojure.core/str arg2801))
 v2200))))
   bean2198))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest}
describe-import-image-tasks-request
  [m2202]
  (clojure.core/let
   [bean2201
    (new
     com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest)]
   (clojure.core/let
    [v2203 (:filters m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (.
      bean2201
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2802] (ec2/filter arg2802))
 v2203))))
   (clojure.core/let
    [v2203
     (:next-token m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (. bean2201 setNextToken (clojure.core/str v2203))))
   (clojure.core/let
    [v2203
     (:max-results m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (. bean2201 setMaxResults (clojure.core/int v2203))))
   (clojure.core/let
    [v2203
     (:import-task-ids
      m2202
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (.
      bean2201
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2803] (clojure.core/str arg2803))
 v2203))))
   bean2201))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyHostsRequest}
modify-hosts-request
  [m2205]
  (clojure.core/let
   [bean2204
    (new com.amazonaws.services.ec2.model.ModifyHostsRequest)]
   (clojure.core/let
    [v2206
     (:host-ids m2205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (.
      bean2204
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2804] (clojure.core/str arg2804))
 v2206))))
   (clojure.core/let
    [v2206
     (:auto-placement m2205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (. bean2204 setAutoPlacement (clojure.core/str v2206))))
   bean2204))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RegisterImageRequest}
register-image-request
  [m2208]
  (clojure.core/let
   [bean2207
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/let
    [v2209
     (:description m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setDescription (clojure.core/str v2209))))
   (clojure.core/let
    [v2209 (:name m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setName (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:root-device-name
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setRootDeviceName (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:ramdisk-id m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setRamdiskId (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:virtualization-type
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setVirtualizationType (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:sriov-net-support
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setSriovNetSupport (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:kernel-id m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setKernelId (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:image-location m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setImageLocation (clojure.core/str v2209))))
   (clojure.core/let
    [v2209
     (:architecture m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setArchitecture (ec2/architecture-values v2209))))
   (clojure.core/let
    [v2209
     (:block-device-mappings
      m2208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (.
      bean2207
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2805] (ec2/block-device-mapping arg2805))
 v2209))))
   bean2207))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVpnGatewayRequest}
detach-vpn-gateway-request
  [m2211]
  (clojure.core/let
   [bean2210
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/let
    [v2212 (:vpc-id m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setVpcId (clojure.core/str v2212))))
   (clojure.core/let
    [v2212
     (:vpn-gateway-id m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setVpnGatewayId (clojure.core/str v2212))))
   bean2210))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVolumeRequest}
delete-volume-request
  [m2214]
  (clojure.core/let
   [bean2213
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v2215
     (:volume-id m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (. bean2213 setVolumeId (clojure.core/str v2215))))
   bean2213))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest}
delete-internet-gateway-request
  [m2217]
  (clojure.core/let
   [bean2216
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/let
    [v2218
     (:internet-gateway-id
      m2217
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (. bean2216 setInternetGatewayId (clojure.core/str v2218))))
   bean2216))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSubnetRequest}
delete-subnet-request
  [m2220]
  (clojure.core/let
   [bean2219
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/let
    [v2221
     (:subnet-id m2220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (. bean2219 setSubnetId (clojure.core/str v2221))))
   bean2219))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest}
reset-instance-attribute-request
  [m2223]
  (clojure.core/let
   [bean2222
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/let
    [v2224
     (:attribute m2223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (. bean2222 setAttribute (clojure.core/str v2224))))
   (clojure.core/let
    [v2224
     (:instance-id m2223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (. bean2222 setInstanceId (clojure.core/str v2224))))
   bean2222))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVolumeRequest}
detach-volume-request
  [m2226]
  (clojure.core/let
   [bean2225
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/let
    [v2227 (:force m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setForce (clojure.core/boolean v2227))))
   (clojure.core/let
    [v2227
     (:volume-id m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setVolumeId (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:instance-id m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setInstanceId (clojure.core/str v2227))))
   (clojure.core/let
    [v2227 (:device m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setDevice (clojure.core/str v2227))))
   bean2225))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeExportTasksRequest}
describe-export-tasks-request
  [m2229]
  (clojure.core/let
   [bean2228
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/let
    [v2230
     (:export-task-ids
      m2229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (.
      bean2228
      setExportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2806] (clojure.core/str arg2806))
 v2230))))
   bean2228))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest}
describe-scheduled-instances-request
  [m2232]
  (clojure.core/let
   [bean2231
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest)]
   (clojure.core/let
    [v2233 (:filters m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (.
      bean2231
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2807] (ec2/filter arg2807))
 v2233))))
   (clojure.core/let
    [v2233
     (:next-token m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setNextToken (clojure.core/str v2233))))
   (clojure.core/let
    [v2233
     (:max-results m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setMaxResults (clojure.core/int v2233))))
   (clojure.core/let
    [v2233
     (:scheduled-instance-ids
      m2232
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (.
      bean2231
      setScheduledInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2808] (clojure.core/str arg2808))
 v2233))))
   (clojure.core/let
    [v2233
     (:slot-start-time-range
      m2232
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (.
      bean2231
      setSlotStartTimeRange
      (ec2/slot-start-time-range-request v2233))))
   bean2231))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteFlowLogsRequest}
delete-flow-logs-request
  [m2235]
  (clojure.core/let
   [bean2234
    (new com.amazonaws.services.ec2.model.DeleteFlowLogsRequest)]
   (clojure.core/let
    [v2236
     (:flow-log-ids m2235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2236 :com.palletops.awaze.client-builder/undef)
     (.
      bean2234
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2809] (clojure.core/str arg2809))
 v2236))))
   bean2234))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcRequest}
create-vpc-request
  [m2238]
  (clojure.core/let
   [bean2237 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/let
    [v2239
     (:cidr-block m2238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (. bean2237 setCidrBlock (clojure.core/str v2239))))
   (clojure.core/let
    [v2239
     (:instance-tenancy
      m2238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (. bean2237 setInstanceTenancy (clojure.core/str v2239))))
   bean2237))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest}
create-spot-datafeed-subscription-request
  [m2241]
  (clojure.core/let
   [bean2240
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/let
    [v2242 (:bucket m2241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2242 :com.palletops.awaze.client-builder/undef)
     (. bean2240 setBucket (clojure.core/str v2242))))
   (clojure.core/let
    [v2242 (:prefix m2241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2242 :com.palletops.awaze.client-builder/undef)
     (. bean2240 setPrefix (clojure.core/str v2242))))
   bean2240))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest}
describe-vpc-classic-link-request
  [m2244]
  (clojure.core/let
   [bean2243
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest)]
   (clojure.core/let
    [v2245 (:filters m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (.
      bean2243
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2810] (ec2/filter arg2810))
 v2245))))
   (clojure.core/let
    [v2245 (:vpc-ids m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (.
      bean2243
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2811] (clojure.core/str arg2811))
 v2245))))
   bean2243))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteRequest}
delete-route-request
  [m2247]
  (clojure.core/let
   [bean2246
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/let
    [v2248
     (:route-table-id m2247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (. bean2246 setRouteTableId (clojure.core/str v2248))))
   (clojure.core/let
    [v2248
     (:destination-cidr-block
      m2247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (. bean2246 setDestinationCidrBlock (clojure.core/str v2248))))
   bean2246))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeIdFormatRequest}
describe-id-format-request
  [m2250]
  (clojure.core/let
   [bean2249
    (new com.amazonaws.services.ec2.model.DescribeIdFormatRequest)]
   (clojure.core/let
    [v2251
     (:resource m2250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (. bean2249 setResource (clojure.core/str v2251))))
   bean2249))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVolumeRequest}
attach-volume-request
  [m2253]
  (clojure.core/let
   [bean2252
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/let
    [v2254
     (:volume-id m2253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (. bean2252 setVolumeId (clojure.core/str v2254))))
   (clojure.core/let
    [v2254
     (:instance-id m2253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (. bean2252 setInstanceId (clojure.core/str v2254))))
   (clojure.core/let
    [v2254 (:device m2253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (. bean2252 setDevice (clojure.core/str v2254))))
   bean2252))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVolumeIORequest}
enable-volume-iorequest
  [m2256]
  (clojure.core/let
   [bean2255
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/let
    [v2257
     (:volume-id m2256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2257 :com.palletops.awaze.client-builder/undef)
     (. bean2255 setVolumeId (clojure.core/str v2257))))
   bean2255))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVpnGatewayRequest}
attach-vpn-gateway-request
  [m2259]
  (clojure.core/let
   [bean2258
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/let
    [v2260 (:vpc-id m2259 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setVpcId (clojure.core/str v2260))))
   (clojure.core/let
    [v2260
     (:vpn-gateway-id m2259 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setVpnGatewayId (clojure.core/str v2260))))
   bean2258))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest}
replace-network-acl-entry-request
  [m2262]
  (clojure.core/let
   [bean2261
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/let
    [v2263
     (:protocol m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setProtocol (clojure.core/str v2263))))
   (clojure.core/let
    [v2263
     (:network-acl-id m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setNetworkAclId (clojure.core/str v2263))))
   (clojure.core/let
    [v2263
     (:rule-number m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setRuleNumber (clojure.core/int v2263))))
   (clojure.core/let
    [v2263
     (:rule-action m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setRuleAction (clojure.core/str v2263))))
   (clojure.core/let
    [v2263 (:egress m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setEgress (clojure.core/boolean v2263))))
   (clojure.core/let
    [v2263
     (:cidr-block m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setCidrBlock (clojure.core/str v2263))))
   (clojure.core/let
    [v2263
     (:icmp-type-code m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setIcmpTypeCode (ec2/icmp-type-code v2263))))
   (clojure.core/let
    [v2263
     (:port-range m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setPortRange (ec2/port-range v2263))))
   bean2261))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest}
describe-snapshot-attribute-request
  [m2265]
  (clojure.core/let
   [bean2264
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/let
    [v2266
     (:attribute m2265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2266 :com.palletops.awaze.client-builder/undef)
     (. bean2264 setAttribute (clojure.core/str v2266))))
   (clojure.core/let
    [v2266
     (:snapshot-id m2265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2266 :com.palletops.awaze.client-builder/undef)
     (. bean2264 setSnapshotId (clojure.core/str v2266))))
   bean2264))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RebootInstancesRequest}
reboot-instances-request
  [m2268]
  (clojure.core/let
   [bean2267
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/let
    [v2269
     (:instance-ids m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (.
      bean2267
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2812] (clojure.core/str arg2812))
 v2269))))
   bean2267))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest}
reject-vpc-peering-connection-request
  [m2271]
  (clojure.core/let
   [bean2270
    (new
     com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2272
     (:vpc-peering-connection-id
      m2271
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2272 :com.palletops.awaze.client-builder/undef)
     (. bean2270 setVpcPeeringConnectionId (clojure.core/str v2272))))
   bean2270))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSecurityGroupRequest}
create-security-group-request
  [m2274]
  (clojure.core/let
   [bean2273
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/let
    [v2275 (:vpc-id m2274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2275 :com.palletops.awaze.client-builder/undef)
     (. bean2273 setVpcId (clojure.core/str v2275))))
   (clojure.core/let
    [v2275
     (:description m2274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2275 :com.palletops.awaze.client-builder/undef)
     (. bean2273 setDescription (clojure.core/str v2275))))
   (clojure.core/let
    [v2275
     (:group-name m2274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2275 :com.palletops.awaze.client-builder/undef)
     (. bean2273 setGroupName (clojure.core/str v2275))))
   bean2273))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest}
describe-spot-instance-requests-request
  [m2277]
  (clojure.core/let
   [bean2276
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2278
     (:spot-instance-request-ids
      m2277
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2278 :com.palletops.awaze.client-builder/undef)
     (.
      bean2276
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2813] (clojure.core/str arg2813))
 v2278))))
   (clojure.core/let
    [v2278 (:filters m2277 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2278 :com.palletops.awaze.client-builder/undef)
     (.
      bean2276
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2814] (ec2/filter arg2814))
 v2278))))
   bean2276))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest}
describe-spot-datafeed-subscription-request
  [m2280]
  (clojure.core/let
   [bean2279
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean2279))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MoveAddressToVpcRequest}
move-address-to-vpc-request
  [m2283]
  (clojure.core/let
   [bean2282
    (new com.amazonaws.services.ec2.model.MoveAddressToVpcRequest)]
   (clojure.core/let
    [v2284
     (:public-ip m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setPublicIp (clojure.core/str v2284))))
   bean2282))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest}
modify-vpc-endpoint-request
  [m2286]
  (clojure.core/let
   [bean2285
    (new com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest)]
   (clojure.core/let
    [v2287
     (:add-route-table-ids
      m2286
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2287 :com.palletops.awaze.client-builder/undef)
     (.
      bean2285
      setAddRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2815] (clojure.core/str arg2815))
 v2287))))
   (clojure.core/let
    [v2287
     (:remove-route-table-ids
      m2286
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2287 :com.palletops.awaze.client-builder/undef)
     (.
      bean2285
      setRemoveRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2816] (clojure.core/str arg2816))
 v2287))))
   (clojure.core/let
    [v2287
     (:vpc-endpoint-id
      m2286
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2287 :com.palletops.awaze.client-builder/undef)
     (. bean2285 setVpcEndpointId (clojure.core/str v2287))))
   (clojure.core/let
    [v2287
     (:reset-policy m2286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2287 :com.palletops.awaze.client-builder/undef)
     (. bean2285 setResetPolicy (clojure.core/boolean v2287))))
   (clojure.core/let
    [v2287
     (:policy-document
      m2286
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2287 :com.palletops.awaze.client-builder/undef)
     (. bean2285 setPolicyDocument (clojure.core/str v2287))))
   bean2285))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest}
attach-network-interface-request
  [m2289]
  (clojure.core/let
   [bean2288
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2290
     (:instance-id m2289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2290 :com.palletops.awaze.client-builder/undef)
     (. bean2288 setInstanceId (clojure.core/str v2290))))
   (clojure.core/let
    [v2290
     (:network-interface-id
      m2289
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2290 :com.palletops.awaze.client-builder/undef)
     (. bean2288 setNetworkInterfaceId (clojure.core/str v2290))))
   (clojure.core/let
    [v2290
     (:device-index m2289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2290 :com.palletops.awaze.client-builder/undef)
     (. bean2288 setDeviceIndex (clojure.core/int v2290))))
   bean2288))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest}
detach-network-interface-request
  [m2292]
  (clojure.core/let
   [bean2291
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2293 (:force m2292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setForce (clojure.core/boolean v2293))))
   (clojure.core/let
    [v2293
     (:attachment-id m2292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setAttachmentId (clojure.core/str v2293))))
   bean2291))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest}
delete-dhcp-options-request
  [m2295]
  (clojure.core/let
   [bean2294
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/let
    [v2296
     (:dhcp-options-id
      m2295
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (. bean2294 setDhcpOptionsId (clojure.core/str v2296))))
   bean2294))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest}
describe-vpc-endpoints-request
  [m2298]
  (clojure.core/let
   [bean2297
    (new com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest)]
   (clojure.core/let
    [v2299 (:filters m2298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2299 :com.palletops.awaze.client-builder/undef)
     (.
      bean2297
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2817] (ec2/filter arg2817))
 v2299))))
   (clojure.core/let
    [v2299
     (:vpc-endpoint-ids
      m2298
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2299 :com.palletops.awaze.client-builder/undef)
     (.
      bean2297
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2818] (clojure.core/str arg2818))
 v2299))))
   (clojure.core/let
    [v2299
     (:next-token m2298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2299 :com.palletops.awaze.client-builder/undef)
     (. bean2297 setNextToken (clojure.core/str v2299))))
   (clojure.core/let
    [v2299
     (:max-results m2298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2299 :com.palletops.awaze.client-builder/undef)
     (. bean2297 setMaxResults (clojure.core/int v2299))))
   bean2297))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest}
confirm-product-instance-request
  [m2301]
  (clojure.core/let
   [bean2300
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/let
    [v2302
     (:instance-id m2301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2302 :com.palletops.awaze.client-builder/undef)
     (. bean2300 setInstanceId (clojure.core/str v2302))))
   (clojure.core/let
    [v2302
     (:product-code m2301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2302 :com.palletops.awaze.client-builder/undef)
     (. bean2300 setProductCode (clojure.core/str v2302))))
   bean2300))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateAddressRequest}
allocate-address-request
  [m2304]
  (clojure.core/let
   [bean2303
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/let
    [v2305 (:domain m2304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (. bean2303 setDomain (clojure.core/str v2305))))
   bean2303))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcEndpointRequest}
create-vpc-endpoint-request
  [m2307]
  (clojure.core/let
   [bean2306
    (new com.amazonaws.services.ec2.model.CreateVpcEndpointRequest)]
   (clojure.core/let
    [v2308 (:vpc-id m2307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setVpcId (clojure.core/str v2308))))
   (clojure.core/let
    [v2308
     (:client-token m2307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setClientToken (clojure.core/str v2308))))
   (clojure.core/let
    [v2308
     (:policy-document
      m2307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setPolicyDocument (clojure.core/str v2308))))
   (clojure.core/let
    [v2308
     (:service-name m2307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setServiceName (clojure.core/str v2308))))
   (clojure.core/let
    [v2308
     (:route-table-ids
      m2307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (.
      bean2306
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2819] (clojure.core/str arg2819))
 v2308))))
   bean2306))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportKeyPairRequest}
import-key-pair-request
  [m2310]
  (clojure.core/let
   [bean2309
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/let
    [v2311
     (:public-key-material
      m2310
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2311 :com.palletops.awaze.client-builder/undef)
     (. bean2309 setPublicKeyMaterial (clojure.core/str v2311))))
   (clojure.core/let
    [v2311
     (:key-name m2310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2311 :com.palletops.awaze.client-builder/undef)
     (. bean2309 setKeyName (clojure.core/str v2311))))
   bean2309))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopySnapshotRequest}
copy-snapshot-request
  [m2313]
  (clojure.core/let
   [bean2312
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/let
    [v2314
     (:description m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setDescription (clojure.core/str v2314))))
   (clojure.core/let
    [v2314
     (:source-region m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setSourceRegion (clojure.core/str v2314))))
   (clojure.core/let
    [v2314
     (:encrypted m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setEncrypted (clojure.core/boolean v2314))))
   (clojure.core/let
    [v2314
     (:kms-key-id m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setKmsKeyId (clojure.core/str v2314))))
   (clojure.core/let
    [v2314
     (:source-snapshot-id
      m2313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setSourceSnapshotId (clojure.core/str v2314))))
   (clojure.core/let
    [v2314
     (:destination-region
      m2313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setDestinationRegion (clojure.core/str v2314))))
   (clojure.core/let
    [v2314
     (:presigned-url m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setPresignedUrl (clojure.core/str v2314))))
   bean2312))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m2316]
  (clojure.core/let
   [bean2315
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v2317
     (:snapshot-id m2316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2317 :com.palletops.awaze.client-builder/undef)
     (. bean2315 setSnapshotId (clojure.core/str v2317))))
   bean2315))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeRequest}
reset-image-attribute-request
  [m2319]
  (clojure.core/let
   [bean2318
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/let
    [v2320
     (:attribute m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setAttribute (clojure.core/str v2320))))
   (clojure.core/let
    [v2320
     (:image-id m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setImageId (clojure.core/str v2320))))
   bean2318))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInternetGatewayRequest}
create-internet-gateway-request
  [m2322]
  (clojure.core/let
   [bean2321
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean2321))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MonitorInstancesRequest}
monitor-instances-request
  [m2325]
  (clojure.core/let
   [bean2324
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/let
    [v2326
     (:instance-ids m2325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (.
      bean2324
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2820] (clojure.core/str arg2820))
 v2326))))
   bean2324))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest}
revoke-security-group-egress-request
  [m2328]
  (clojure.core/let
   [bean2327
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2329
     (:group-id m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setGroupId (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:source-security-group-name
      m2328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setSourceSecurityGroupName (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:source-security-group-owner-id
      m2328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (.
      bean2327
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:ip-protocol m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setIpProtocol (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:from-port m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setFromPort (clojure.core/int v2329))))
   (clojure.core/let
    [v2329 (:to-port m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setToPort (clojure.core/int v2329))))
   (clojure.core/let
    [v2329 (:cidr-ip m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setCidrIp (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:ip-permissions m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (.
      bean2327
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2821] (ec2/ip-permission arg2821))
 v2329))))
   bean2327))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcsRequest}
describe-vpcs-request
  [m2331]
  (clojure.core/let
   [bean2330
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/let
    [v2332 (:filters m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (.
      bean2330
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2822] (ec2/filter arg2822))
 v2332))))
   (clojure.core/let
    [v2332 (:vpc-ids m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (.
      bean2330
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2823] (clojure.core/str arg2823))
 v2332))))
   bean2330))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceRequest}
import-instance-request
  [m2334]
  (clojure.core/let
   [bean2333
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/let
    [v2335
     (:launch-specification
      m2334
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (.
      bean2333
      setLaunchSpecification
      (ec2/import-instance-launch-specification v2335))))
   (clojure.core/let
    [v2335
     (:disk-images m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (.
      bean2333
      setDiskImages
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2824] (ec2/disk-image arg2824))
 v2335))))
   (clojure.core/let
    [v2335
     (:platform m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setPlatform (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:description m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setDescription (clojure.core/str v2335))))
   bean2333))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopyImageRequest}
copy-image-request
  [m2337]
  (clojure.core/let
   [bean2336 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/let
    [v2338
     (:description m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setDescription (clojure.core/str v2338))))
   (clojure.core/let
    [v2338
     (:client-token m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setClientToken (clojure.core/str v2338))))
   (clojure.core/let
    [v2338
     (:source-region m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setSourceRegion (clojure.core/str v2338))))
   (clojure.core/let
    [v2338
     (:source-image-id
      m2337
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setSourceImageId (clojure.core/str v2338))))
   (clojure.core/let
    [v2338
     (:encrypted m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setEncrypted (clojure.core/boolean v2338))))
   (clojure.core/let
    [v2338
     (:kms-key-id m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setKmsKeyId (clojure.core/str v2338))))
   (clojure.core/let
    [v2338 (:name m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setName (clojure.core/str v2338))))
   bean2336))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetConsoleOutputRequest}
get-console-output-request
  [m2340]
  (clojure.core/let
   [bean2339
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/let
    [v2341
     (:instance-id m2340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2341 :com.palletops.awaze.client-builder/undef)
     (. bean2339 setInstanceId (clojure.core/str v2341))))
   bean2339))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest}
modify-snapshot-attribute-request
  [m2343]
  (clojure.core/let
   [bean2342
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/let
    [v2344
     (:attribute m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setAttribute (ec2/snapshot-attribute-name v2344))))
   (clojure.core/let
    [v2344
     (:operation-type m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setOperationType (ec2/operation-type v2344))))
   (clojure.core/let
    [v2344
     (:user-ids m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (.
      bean2342
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2825] (clojure.core/str arg2825))
 v2344))))
   (clojure.core/let
    [v2344
     (:create-volume-permission
      m2343
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (.
      bean2342
      setCreateVolumePermission
      (ec2/create-volume-permission-modifications v2344))))
   (clojure.core/let
    [v2344
     (:snapshot-id m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (. bean2342 setSnapshotId (clojure.core/str v2344))))
   (clojure.core/let
    [v2344
     (:group-names m2343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2344 :com.palletops.awaze.client-builder/undef)
     (.
      bean2342
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2826] (clojure.core/str arg2826))
 v2344))))
   bean2342))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotFleetRequest}
request-spot-fleet-request
  [m2346]
  (clojure.core/let
   [bean2345
    (new com.amazonaws.services.ec2.model.RequestSpotFleetRequest)]
   (clojure.core/let
    [v2347
     (:spot-fleet-request-config
      m2346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (.
      bean2345
      setSpotFleetRequestConfig
      (ec2/spot-fleet-request-config-data v2347))))
   bean2345))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest}
restore-address-to-classic-request
  [m2349]
  (clojure.core/let
   [bean2348
    (new
     com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest)]
   (clojure.core/let
    [v2350
     (:public-ip m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setPublicIp (clojure.core/str v2350))))
   bean2348))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest}
modify-subnet-attribute-request
  [m2352]
  (clojure.core/let
   [bean2351
    (new
     com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest)]
   (clojure.core/let
    [v2353
     (:map-public-ip-on-launch
      m2352
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (. bean2351 setMapPublicIpOnLaunch (clojure.core/boolean v2353))))
   (clojure.core/let
    [v2353
     (:subnet-id m2352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (. bean2351 setSubnetId (clojure.core/str v2353))))
   bean2351))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeConversionTasksRequest}
describe-conversion-tasks-request
  [m2355]
  (clojure.core/let
   [bean2354
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/let
    [v2356 (:filters m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (.
      bean2354
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2827] (ec2/filter arg2827))
 v2356))))
   (clojure.core/let
    [v2356
     (:conversion-task-ids
      m2355
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (.
      bean2354
      setConversionTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2828] (clojure.core/str arg2828))
 v2356))))
   bean2354))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest}
authorize-security-group-egress-request
  [m2358]
  (clojure.core/let
   [bean2357
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2359
     (:group-id m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setGroupId (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:source-security-group-name
      m2358
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setSourceSecurityGroupName (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:source-security-group-owner-id
      m2358
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (.
      bean2357
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:ip-protocol m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setIpProtocol (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:from-port m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setFromPort (clojure.core/int v2359))))
   (clojure.core/let
    [v2359 (:to-port m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setToPort (clojure.core/int v2359))))
   (clojure.core/let
    [v2359 (:cidr-ip m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setCidrIp (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:ip-permissions m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (.
      bean2357
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2829] (ec2/ip-permission arg2829))
 v2359))))
   bean2357))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest}
authorize-security-group-ingress-request
  [m2361]
  (clojure.core/let
   [bean2360
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2362 (:cidr-ip m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setCidrIp (clojure.core/str v2362))))
   (clojure.core/let
    [v2362
     (:group-id m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setGroupId (clojure.core/str v2362))))
   (clojure.core/let
    [v2362 (:to-port m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setToPort (clojure.core/int v2362))))
   (clojure.core/let
    [v2362
     (:source-security-group-owner-id
      m2361
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (.
      bean2360
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2362))))
   (clojure.core/let
    [v2362
     (:ip-permissions m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (.
      bean2360
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2830] (ec2/ip-permission arg2830))
 v2362))))
   (clojure.core/let
    [v2362
     (:source-security-group-name
      m2361
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setSourceSecurityGroupName (clojure.core/str v2362))))
   (clojure.core/let
    [v2362
     (:group-name m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setGroupName (clojure.core/str v2362))))
   (clojure.core/let
    [v2362
     (:ip-protocol m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setIpProtocol (clojure.core/str v2362))))
   (clojure.core/let
    [v2362
     (:from-port m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setFromPort (clojure.core/int v2362))))
   bean2360))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAddressesRequest}
describe-addresses-request
  [m2364]
  (clojure.core/let
   [bean2363
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/let
    [v2365
     (:public-ips m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2831] (clojure.core/str arg2831))
 v2365))))
   (clojure.core/let
    [v2365 (:filters m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2832] (ec2/filter arg2832))
 v2365))))
   (clojure.core/let
    [v2365
     (:allocation-ids m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setAllocationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2833] (clojure.core/str arg2833))
 v2365))))
   bean2363))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest}
create-vpn-connection-route-request
  [m2367]
  (clojure.core/let
   [bean2366
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2368
     (:destination-cidr-block
      m2367
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setDestinationCidrBlock (clojure.core/str v2368))))
   (clojure.core/let
    [v2368
     (:vpn-connection-id
      m2367
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (. bean2366 setVpnConnectionId (clojure.core/str v2368))))
   bean2366))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateAddressRequest}
associate-address-request
  [m2370]
  (clojure.core/let
   [bean2369
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/let
    [v2371
     (:allocation-id m2370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setAllocationId (clojure.core/str v2371))))
   (clojure.core/let
    [v2371
     (:instance-id m2370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setInstanceId (clojure.core/str v2371))))
   (clojure.core/let
    [v2371
     (:network-interface-id
      m2370
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setNetworkInterfaceId (clojure.core/str v2371))))
   (clojure.core/let
    [v2371
     (:public-ip m2370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setPublicIp (clojure.core/str v2371))))
   (clojure.core/let
    [v2371
     (:private-ip-address
      m2370
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setPrivateIpAddress (clojure.core/str v2371))))
   (clojure.core/let
    [v2371
     (:allow-reassociation
      m2370
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setAllowReassociation (clojure.core/boolean v2371))))
   bean2369))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest}
create-instance-export-task-request
  [m2373]
  (clojure.core/let
   [bean2372
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/let
    [v2374
     (:description m2373 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (. bean2372 setDescription (clojure.core/str v2374))))
   (clojure.core/let
    [v2374
     (:target-environment
      m2373
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (. bean2372 setTargetEnvironment (ec2/export-environment v2374))))
   (clojure.core/let
    [v2374
     (:export-to-s3task
      m2373
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (.
      bean2372
      setExportToS3Task
      (ec2/export-to-s3task-specification v2374))))
   (clojure.core/let
    [v2374
     (:instance-id m2373 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (. bean2372 setInstanceId (clojure.core/str v2374))))
   bean2372))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeKeyPairsRequest}
describe-key-pairs-request
  [m2376]
  (clojure.core/let
   [bean2375
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/let
    [v2377 (:filters m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (.
      bean2375
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2834] (ec2/filter arg2834))
 v2377))))
   (clojure.core/let
    [v2377
     (:key-names m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (.
      bean2375
      setKeyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2835] (clojure.core/str arg2835))
 v2377))))
   bean2375))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest}
describe-spot-fleet-requests-request
  [m2379]
  (clojure.core/let
   [bean2378
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2380
     (:spot-fleet-request-ids
      m2379
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (.
      bean2378
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2836] (clojure.core/str arg2836))
 v2380))))
   (clojure.core/let
    [v2380
     (:next-token m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setNextToken (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:max-results m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setMaxResults (clojure.core/int v2380))))
   bean2378))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImageAttributeRequest}
describe-image-attribute-request
  [m2382]
  (clojure.core/let
   [bean2381
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/let
    [v2383
     (:attribute m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setAttribute (clojure.core/str v2383))))
   (clojure.core/let
    [v2383
     (:image-id m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setImageId (clojure.core/str v2383))))
   bean2381))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest}
describe-moving-addresses-request
  [m2385]
  (clojure.core/let
   [bean2384
    (new
     com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest)]
   (clojure.core/let
    [v2386
     (:public-ips m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (.
      bean2384
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2837] (clojure.core/str arg2837))
 v2386))))
   (clojure.core/let
    [v2386 (:filters m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (.
      bean2384
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2838] (ec2/filter arg2838))
 v2386))))
   (clojure.core/let
    [v2386
     (:next-token m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (. bean2384 setNextToken (clojure.core/str v2386))))
   (clojure.core/let
    [v2386
     (:max-results m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (. bean2384 setMaxResults (clojure.core/int v2386))))
   bean2384))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclRequest}
delete-network-acl-request
  [m2388]
  (clojure.core/let
   [bean2387
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/let
    [v2389
     (:network-acl-id m2388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setNetworkAclId (clojure.core/str v2389))))
   bean2387))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest}
delete-network-interface-request
  [m2391]
  (clojure.core/let
   [bean2390
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/let
    [v2392
     (:network-interface-id
      m2391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setNetworkInterfaceId (clojure.core/str v2392))))
   bean2390))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest}
delete-vpn-connection-request
  [m2394]
  (clojure.core/let
   [bean2393
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/let
    [v2395
     (:vpn-connection-id
      m2394
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2395 :com.palletops.awaze.client-builder/undef)
     (. bean2393 setVpnConnectionId (clojure.core/str v2395))))
   bean2393))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest}
purchase-scheduled-instances-request
  [m2397]
  (clojure.core/let
   [bean2396
    (new
     com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest)]
   (clojure.core/let
    [v2398
     (:purchase-requests
      m2397
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2398 :com.palletops.awaze.client-builder/undef)
     (.
      bean2396
      setPurchaseRequests
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2839] (ec2/purchase-request arg2839))
 v2398))))
   (clojure.core/let
    [v2398
     (:client-token m2397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2398 :com.palletops.awaze.client-builder/undef)
     (. bean2396 setClientToken (clojure.core/str v2398))))
   bean2396))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest}
describe-reserved-instances-modifications-request
  [m2400]
  (clojure.core/let
   [bean2399
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/let
    [v2401 (:filters m2400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (.
      bean2399
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2840] (ec2/filter arg2840))
 v2401))))
   (clojure.core/let
    [v2401
     (:next-token m2400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (. bean2399 setNextToken (clojure.core/str v2401))))
   (clojure.core/let
    [v2401
     (:reserved-instances-modification-ids
      m2400
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (.
      bean2399
      setReservedInstancesModificationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2841] (clojure.core/str arg2841))
 v2401))))
   bean2399))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest}
describe-classic-link-instances-request
  [m2403]
  (clojure.core/let
   [bean2402
    (new
     com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest)]
   (clojure.core/let
    [v2404 (:filters m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (.
      bean2402
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2842] (ec2/filter arg2842))
 v2404))))
   (clojure.core/let
    [v2404
     (:next-token m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (. bean2402 setNextToken (clojure.core/str v2404))))
   (clojure.core/let
    [v2404
     (:max-results m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (. bean2402 setMaxResults (clojure.core/int v2404))))
   (clojure.core/let
    [v2404
     (:instance-ids m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (.
      bean2402
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2843] (clojure.core/str arg2843))
 v2404))))
   bean2402))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest}
purchase-reserved-instances-offering-request
  [m2406]
  (clojure.core/let
   [bean2405
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/let
    [v2407
     (:reserved-instances-offering-id
      m2406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (.
      bean2405
      setReservedInstancesOfferingId
      (clojure.core/str v2407))))
   (clojure.core/let
    [v2407
     (:limit-price m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (.
      bean2405
      setLimitPrice
      (ec2/reserved-instance-limit-price v2407))))
   (clojure.core/let
    [v2407
     (:instance-count m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (. bean2405 setInstanceCount (clojure.core/int v2407))))
   bean2405))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StartInstancesRequest}
start-instances-request
  [m2409]
  (clojure.core/let
   [bean2408
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/let
    [v2410
     (:additional-info
      m2409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2410 :com.palletops.awaze.client-builder/undef)
     (. bean2408 setAdditionalInfo (clojure.core/str v2410))))
   (clojure.core/let
    [v2410
     (:instance-ids m2409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2410 :com.palletops.awaze.client-builder/undef)
     (.
      bean2408
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2844] (clojure.core/str arg2844))
 v2410))))
   bean2408))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest}
describe-instance-attribute-request
  [m2412]
  (clojure.core/let
   [bean2411
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/let
    [v2413
     (:attribute m2412 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2413 :com.palletops.awaze.client-builder/undef)
     (. bean2411 setAttribute (clojure.core/str v2413))))
   (clojure.core/let
    [v2413
     (:instance-id m2412 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2413 :com.palletops.awaze.client-builder/undef)
     (. bean2411 setInstanceId (clojure.core/str v2413))))
   bean2411))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest}
cancel-spot-fleet-requests-request
  [m2415]
  (clojure.core/let
   [bean2414
    (new
     com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2416
     (:spot-fleet-request-ids
      m2415
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2416 :com.palletops.awaze.client-builder/undef)
     (.
      bean2414
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2845] (clojure.core/str arg2845))
 v2416))))
   (clojure.core/let
    [v2416
     (:terminate-instances
      m2415
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2416 :com.palletops.awaze.client-builder/undef)
     (. bean2414 setTerminateInstances (clojure.core/boolean v2416))))
   bean2414))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSubnetsRequest}
describe-subnets-request
  [m2418]
  (clojure.core/let
   [bean2417
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/let
    [v2419 (:filters m2418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (.
      bean2417
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2846] (ec2/filter arg2846))
 v2419))))
   (clojure.core/let
    [v2419
     (:subnet-ids m2418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (.
      bean2417
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2847] (clojure.core/str arg2847))
 v2419))))
   bean2417))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumeRequest}
create-volume-request
  [m2421]
  (clojure.core/let
   [bean2420
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/let
    [v2422
     (:encrypted m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setEncrypted (clojure.core/boolean v2422))))
   (clojure.core/let
    [v2422
     (:kms-key-id m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setKmsKeyId (clojure.core/str v2422))))
   (clojure.core/let
    [v2422
     (:availability-zone
      m2421
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setAvailabilityZone (clojure.core/str v2422))))
   (clojure.core/let
    [v2422
     (:snapshot-id m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setSnapshotId (clojure.core/str v2422))))
   (clojure.core/let
    [v2422
     (:volume-type m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setVolumeType (clojure.core/str v2422))))
   (clojure.core/let
    [v2422 (:iops m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setIops (clojure.core/int v2422))))
   (clojure.core/let
    [v2422 (:size m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setSize (clojure.core/int v2422))))
   bean2420))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest}
describe-reserved-instances-listings-request
  [m2424]
  (clojure.core/let
   [bean2423
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/let
    [v2425
     (:reserved-instances-id
      m2424
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (. bean2423 setReservedInstancesId (clojure.core/str v2425))))
   (clojure.core/let
    [v2425
     (:reserved-instances-listing-id
      m2424
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (.
      bean2423
      setReservedInstancesListingId
      (clojure.core/str v2425))))
   (clojure.core/let
    [v2425 (:filters m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (.
      bean2423
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2848] (ec2/filter arg2848))
 v2425))))
   bean2423))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest}
create-dhcp-options-request
  [m2427]
  (clojure.core/let
   [bean2426
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/let
    [v2428
     (:dhcp-configurations
      m2427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (.
      bean2426
      setDhcpConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2849] (ec2/dhcp-configuration arg2849))
 v2428))))
   bean2426))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachInternetGatewayRequest}
detach-internet-gateway-request
  [m2430]
  (clojure.core/let
   [bean2429
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/let
    [v2431 (:vpc-id m2430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (. bean2429 setVpcId (clojure.core/str v2431))))
   (clojure.core/let
    [v2431
     (:internet-gateway-id
      m2430
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (. bean2429 setInternetGatewayId (clojure.core/str v2431))))
   bean2429))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest}
delete-vpn-gateway-request
  [m2433]
  (clojure.core/let
   [bean2432
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/let
    [v2434
     (:vpn-gateway-id m2433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2434 :com.palletops.awaze.client-builder/undef)
     (. bean2432 setVpnGatewayId (clojure.core/str v2434))))
   bean2432))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotInstancesRequest}
request-spot-instances-request
  [m2436]
  (clojure.core/let
   [bean2435
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/let
    [v2437
     (:spot-price m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setSpotPrice (clojure.core/str v2437))))
   (clojure.core/let
    [v2437
     (:valid-from m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (.
      bean2435
      setValidFrom
      (com.palletops.awaze.common/to-date v2437))))
   (clojure.core/let
    [v2437
     (:block-duration-minutes
      m2436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setBlockDurationMinutes (clojure.core/int v2437))))
   (clojure.core/let
    [v2437 (:type m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setType (ec2/spot-instance-type v2437))))
   (clojure.core/let
    [v2437
     (:client-token m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setClientToken (clojure.core/str v2437))))
   (clojure.core/let
    [v2437
     (:launch-group m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setLaunchGroup (clojure.core/str v2437))))
   (clojure.core/let
    [v2437
     (:instance-count m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setInstanceCount (clojure.core/int v2437))))
   (clojure.core/let
    [v2437
     (:launch-specification
      m2436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (.
      bean2435
      setLaunchSpecification
      (ec2/launch-specification v2437))))
   (clojure.core/let
    [v2437
     (:valid-until m2436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (.
      bean2435
      setValidUntil
      (com.palletops.awaze.common/to-date v2437))))
   (clojure.core/let
    [v2437
     (:availability-zone-group
      m2436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setAvailabilityZoneGroup (clojure.core/str v2437))))
   bean2435))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportVolumeRequest}
import-volume-request
  [m2439]
  (clojure.core/let
   [bean2438
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/let
    [v2440 (:image m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setImage (ec2/disk-image-detail v2440))))
   (clojure.core/let
    [v2440 (:volume m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setVolume (ec2/volume-detail v2440))))
   (clojure.core/let
    [v2440
     (:description m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setDescription (clojure.core/str v2440))))
   (clojure.core/let
    [v2440
     (:availability-zone
      m2439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (. bean2438 setAvailabilityZone (clojure.core/str v2440))))
   bean2438))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportSnapshotRequest}
import-snapshot-request
  [m2442]
  (clojure.core/let
   [bean2441
    (new com.amazonaws.services.ec2.model.ImportSnapshotRequest)]
   (clojure.core/let
    [v2443
     (:disk-container m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setDiskContainer (ec2/snapshot-disk-container v2443))))
   (clojure.core/let
    [v2443
     (:client-data m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setClientData (ec2/client-data v2443))))
   (clojure.core/let
    [v2443
     (:role-name m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setRoleName (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:description m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setDescription (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:client-token m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setClientToken (clojure.core/str v2443))))
   bean2441))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeTagsRequest}
describe-tags-request
  [m2445]
  (clojure.core/let
   [bean2444
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/let
    [v2446 (:filters m2445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (.
      bean2444
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2850] (ec2/filter arg2850))
 v2446))))
   (clojure.core/let
    [v2446
     (:next-token m2445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (. bean2444 setNextToken (clojure.core/str v2446))))
   (clojure.core/let
    [v2446
     (:max-results m2445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (. bean2444 setMaxResults (clojure.core/int v2446))))
   bean2444))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteTagsRequest}
delete-tags-request
  [m2448]
  (clojure.core/let
   [bean2447 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/let
    [v2449
     (:resources m2448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (.
      bean2447
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2851] (clojure.core/str arg2851))
 v2449))))
   (clojure.core/let
    [v2449 (:tags m2448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (.
      bean2447
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2852] (ec2/tag arg2852)) v2449))))
   bean2447))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest}
enable-vpc-classic-link-request
  [m2451]
  (clojure.core/let
   [bean2450
    (new com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2452 (:vpc-id m2451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2452 :com.palletops.awaze.client-builder/undef)
     (. bean2450 setVpcId (clojure.core/str v2452))))
   bean2450))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest}
describe-reserved-instances-offerings-request
  [m2454]
  (clojure.core/let
   [bean2453
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/let
    [v2455
     (:include-marketplace
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setIncludeMarketplace (clojure.core/boolean v2455))))
   (clojure.core/let
    [v2455
     (:reserved-instances-offering-ids
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (.
      bean2453
      setReservedInstancesOfferingIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2853] (clojure.core/str arg2853))
 v2455))))
   (clojure.core/let
    [v2455
     (:product-description
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (.
      bean2453
      setProductDescription
      (ec2/riproduct-description v2455))))
   (clojure.core/let
    [v2455
     (:availability-zone
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setAvailabilityZone (clojure.core/str v2455))))
   (clojure.core/let
    [v2455
     (:min-duration m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setMinDuration (clojure.core/long v2455))))
   (clojure.core/let
    [v2455
     (:instance-type m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setInstanceType (clojure.core/str v2455))))
   (clojure.core/let
    [v2455 (:filters m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (.
      bean2453
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2854] (ec2/filter arg2854))
 v2455))))
   (clojure.core/let
    [v2455
     (:offering-type m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setOfferingType (clojure.core/str v2455))))
   (clojure.core/let
    [v2455
     (:instance-tenancy
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setInstanceTenancy (ec2/tenancy v2455))))
   (clojure.core/let
    [v2455
     (:max-duration m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setMaxDuration (clojure.core/long v2455))))
   (clojure.core/let
    [v2455
     (:next-token m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setNextToken (clojure.core/str v2455))))
   (clojure.core/let
    [v2455
     (:max-results m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setMaxResults (clojure.core/int v2455))))
   (clojure.core/let
    [v2455
     (:max-instance-count
      m2454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setMaxInstanceCount (clojure.core/int v2455))))
   bean2453))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnGatewayRequest}
create-vpn-gateway-request
  [m2457]
  (clojure.core/let
   [bean2456
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/let
    [v2458 (:type m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setType (ec2/gateway-type v2458))))
   (clojure.core/let
    [v2458
     (:availability-zone
      m2457
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setAvailabilityZone (clojure.core/str v2458))))
   bean2456))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRouteTablesRequest}
describe-route-tables-request
  [m2460]
  (clojure.core/let
   [bean2459
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/let
    [v2461
     (:route-table-ids
      m2460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (.
      bean2459
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2855] (clojure.core/str arg2855))
 v2461))))
   (clojure.core/let
    [v2461 (:filters m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (.
      bean2459
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2856] (ec2/filter arg2856))
 v2461))))
   bean2459))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest}
cancel-spot-instance-requests-request
  [m2463]
  (clojure.core/let
   [bean2462
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2464
     (:spot-instance-request-ids
      m2463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (.
      bean2462
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2857] (clojure.core/str arg2857))
 v2464))))
   bean2462))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest}
assign-private-ip-addresses-request
  [m2466]
  (clojure.core/let
   [bean2465
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2467
     (:network-interface-id
      m2466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (. bean2465 setNetworkInterfaceId (clojure.core/str v2467))))
   (clojure.core/let
    [v2467
     (:private-ip-addresses
      m2466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (.
      bean2465
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2858] (clojure.core/str arg2858))
 v2467))))
   (clojure.core/let
    [v2467
     (:secondary-private-ip-address-count
      m2466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (.
      bean2465
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2467))))
   (clojure.core/let
    [v2467
     (:allow-reassignment
      m2466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (. bean2465 setAllowReassignment (clojure.core/boolean v2467))))
   bean2465))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest}
disable-vpc-classic-link-dns-support-request
  [m2469]
  (clojure.core/let
   [bean2468
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2470 (:vpc-id m2469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2470 :com.palletops.awaze.client-builder/undef)
     (. bean2468 setVpcId (clojure.core/str v2470))))
   bean2468))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeletePlacementGroupRequest}
delete-placement-group-request
  [m2472]
  (clojure.core/let
   [bean2471
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/let
    [v2473
     (:group-name m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setGroupName (clojure.core/str v2473))))
   bean2471))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstancesRequest}
describe-instances-request
  [m2475]
  (clojure.core/let
   [bean2474
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/let
    [v2476 (:filters m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (.
      bean2474
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2859] (ec2/filter arg2859))
 v2476))))
   (clojure.core/let
    [v2476
     (:next-token m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setNextToken (clojure.core/str v2476))))
   (clojure.core/let
    [v2476
     (:max-results m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setMaxResults (clojure.core/int v2476))))
   (clojure.core/let
    [v2476
     (:instance-ids m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (.
      bean2474
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2860] (clojure.core/str arg2860))
 v2476))))
   bean2474))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumesRequest}
describe-volumes-request
  [m2478]
  (clojure.core/let
   [bean2477
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/let
    [v2479 (:filters m2478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (.
      bean2477
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2861] (ec2/filter arg2861))
 v2479))))
   (clojure.core/let
    [v2479
     (:next-token m2478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (. bean2477 setNextToken (clojure.core/str v2479))))
   (clojure.core/let
    [v2479
     (:max-results m2478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (. bean2477 setMaxResults (clojure.core/int v2479))))
   (clojure.core/let
    [v2479
     (:volume-ids m2478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (.
      bean2477
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2862] (clojure.core/str arg2862))
 v2479))))
   bean2477))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeBundleTasksRequest}
describe-bundle-tasks-request
  [m2481]
  (clojure.core/let
   [bean2480
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/let
    [v2482 (:filters m2481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (.
      bean2480
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2863] (ec2/filter arg2863))
 v2482))))
   (clojure.core/let
    [v2482
     (:bundle-ids m2481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (.
      bean2480
      setBundleIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2864] (clojure.core/str arg2864))
 v2482))))
   bean2480))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest}
associate-dhcp-options-request
  [m2484]
  (clojure.core/let
   [bean2483
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/let
    [v2485
     (:dhcp-options-id
      m2484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (. bean2483 setDhcpOptionsId (clojure.core/str v2485))))
   (clojure.core/let
    [v2485 (:vpc-id m2484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (. bean2483 setVpcId (clojure.core/str v2485))))
   bean2483))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest}
modify-vpc-attribute-request
  [m2487]
  (clojure.core/let
   [bean2486
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/let
    [v2488
     (:enable-dns-support
      m2487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (. bean2486 setEnableDnsSupport (clojure.core/boolean v2488))))
   (clojure.core/let
    [v2488
     (:enable-dns-hostnames
      m2487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (. bean2486 setEnableDnsHostnames (clojure.core/boolean v2488))))
   (clojure.core/let
    [v2488 (:vpc-id m2487 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (. bean2486 setVpcId (clojure.core/str v2488))))
   bean2486))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateFlowLogsRequest}
create-flow-logs-request
  [m2490]
  (clojure.core/let
   [bean2489
    (new com.amazonaws.services.ec2.model.CreateFlowLogsRequest)]
   (clojure.core/let
    [v2491
     (:client-token m2490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setClientToken (clojure.core/str v2491))))
   (clojure.core/let
    [v2491
     (:resource-ids m2490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (.
      bean2489
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2865] (clojure.core/str arg2865))
 v2491))))
   (clojure.core/let
    [v2491
     (:resource-type m2490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setResourceType (ec2/flow-logs-resource-type v2491))))
   (clojure.core/let
    [v2491
     (:traffic-type m2490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setTrafficType (clojure.core/str v2491))))
   (clojure.core/let
    [v2491
     (:log-group-name m2490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setLogGroupName (clojure.core/str v2491))))
   (clojure.core/let
    [v2491
     (:deliver-logs-permission-arn
      m2490
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setDeliverLogsPermissionArn (clojure.core/str v2491))))
   bean2489))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateAddressRequest}
disassociate-address-request
  [m2493]
  (clojure.core/let
   [bean2492
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/let
    [v2494
     (:association-id m2493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (. bean2492 setAssociationId (clojure.core/str v2494))))
   (clojure.core/let
    [v2494
     (:public-ip m2493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (. bean2492 setPublicIp (clojure.core/str v2494))))
   bean2492))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest}
reset-network-interface-attribute-request
  [m2496]
  (clojure.core/let
   [bean2495
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2497
     (:source-dest-check
      m2496
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setSourceDestCheck (clojure.core/str v2497))))
   (clojure.core/let
    [v2497
     (:network-interface-id
      m2496
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setNetworkInterfaceId (clojure.core/str v2497))))
   bean2495))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest}
describe-placement-groups-request
  [m2499]
  (clojure.core/let
   [bean2498
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/let
    [v2500 (:filters m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (.
      bean2498
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2866] (ec2/filter arg2866))
 v2500))))
   (clojure.core/let
    [v2500
     (:group-names m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (.
      bean2498
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2867] (clojure.core/str arg2867))
 v2500))))
   bean2498))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest}
reset-snapshot-attribute-request
  [m2502]
  (clojure.core/let
   [bean2501
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/let
    [v2503
     (:attribute m2502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2503 :com.palletops.awaze.client-builder/undef)
     (. bean2501 setAttribute (clojure.core/str v2503))))
   (clojure.core/let
    [v2503
     (:snapshot-id m2502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2503 :com.palletops.awaze.client-builder/undef)
     (. bean2501 setSnapshotId (clojure.core/str v2503))))
   bean2501))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseAddressRequest}
release-address-request
  [m2505]
  (clojure.core/let
   [bean2504
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/let
    [v2506
     (:allocation-id m2505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (. bean2504 setAllocationId (clojure.core/str v2506))))
   (clojure.core/let
    [v2506
     (:public-ip m2505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (. bean2504 setPublicIp (clojure.core/str v2506))))
   bean2504))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest}
describe-volume-status-request
  [m2508]
  (clojure.core/let
   [bean2507
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/let
    [v2509 (:filters m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (.
      bean2507
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2868] (ec2/filter arg2868))
 v2509))))
   (clojure.core/let
    [v2509
     (:next-token m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setNextToken (clojure.core/str v2509))))
   (clojure.core/let
    [v2509
     (:max-results m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setMaxResults (clojure.core/int v2509))))
   (clojure.core/let
    [v2509
     (:volume-ids m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (.
      bean2507
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2869] (clojure.core/str arg2869))
 v2509))))
   bean2507))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BundleInstanceRequest}
bundle-instance-request
  [m2511]
  (clojure.core/let
   [bean2510
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/let
    [v2512
     (:instance-id m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setInstanceId (clojure.core/str v2512))))
   (clojure.core/let
    [v2512 (:storage m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setStorage (ec2/storage v2512))))
   bean2510))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest}
describe-vpn-connections-request
  [m2514]
  (clojure.core/let
   [bean2513
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/let
    [v2515
     (:vpn-connection-ids
      m2514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (.
      bean2513
      setVpnConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2870] (clojure.core/str arg2870))
 v2515))))
   (clojure.core/let
    [v2515 (:filters m2514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (.
      bean2513
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2871] (ec2/filter arg2871))
 v2515))))
   bean2513))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteRequest}
create-route-request
  [m2517]
  (clojure.core/let
   [bean2516
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/let
    [v2518
     (:route-table-id m2517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setRouteTableId (clojure.core/str v2518))))
   (clojure.core/let
    [v2518
     (:instance-id m2517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setInstanceId (clojure.core/str v2518))))
   (clojure.core/let
    [v2518
     (:network-interface-id
      m2517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setNetworkInterfaceId (clojure.core/str v2518))))
   (clojure.core/let
    [v2518
     (:vpc-peering-connection-id
      m2517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setVpcPeeringConnectionId (clojure.core/str v2518))))
   (clojure.core/let
    [v2518
     (:destination-cidr-block
      m2517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setDestinationCidrBlock (clojure.core/str v2518))))
   (clojure.core/let
    [v2518
     (:gateway-id m2517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setGatewayId (clojure.core/str v2518))))
   (clojure.core/let
    [v2518
     (:nat-gateway-id m2517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setNatGatewayId (clojure.core/str v2518))))
   bean2516))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest}
describe-spot-price-history-request
  [m2520]
  (clojure.core/let
   [bean2519
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/let
    [v2521
     (:availability-zone
      m2520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (. bean2519 setAvailabilityZone (clojure.core/str v2521))))
   (clojure.core/let
    [v2521 (:filters m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2872] (ec2/filter arg2872))
 v2521))))
   (clojure.core/let
    [v2521
     (:next-token m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (. bean2519 setNextToken (clojure.core/str v2521))))
   (clojure.core/let
    [v2521
     (:max-results m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (. bean2519 setMaxResults (clojure.core/int v2521))))
   (clojure.core/let
    [v2521
     (:end-time m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setEndTime
      (com.palletops.awaze.common/to-date v2521))))
   (clojure.core/let
    [v2521
     (:instance-types m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setInstanceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2873] (clojure.core/str arg2873))
 v2521))))
   (clojure.core/let
    [v2521
     (:product-descriptions
      m2520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setProductDescriptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2874] (clojure.core/str arg2874))
 v2521))))
   (clojure.core/let
    [v2521
     (:start-time m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setStartTime
      (com.palletops.awaze.common/to-date v2521))))
   bean2519))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest}
describe-availability-zones-request
  [m2523]
  (clojure.core/let
   [bean2522
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/let
    [v2524 (:filters m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (.
      bean2522
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2875] (ec2/filter arg2875))
 v2524))))
   (clojure.core/let
    [v2524
     (:zone-names m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (.
      bean2522
      setZoneNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2876] (clojure.core/str arg2876))
 v2524))))
   bean2522))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest}
create-vpc-peering-connection-request
  [m2526]
  (clojure.core/let
   [bean2525
    (new
     com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2527 (:vpc-id m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setVpcId (clojure.core/str v2527))))
   (clojure.core/let
    [v2527
     (:peer-vpc-id m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setPeerVpcId (clojure.core/str v2527))))
   (clojure.core/let
    [v2527
     (:peer-owner-id m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setPeerOwnerId (clojure.core/str v2527))))
   bean2525))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest}
describe-internet-gateways-request
  [m2529]
  (clojure.core/let
   [bean2528
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/let
    [v2530 (:filters m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (.
      bean2528
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2877] (ec2/filter arg2877))
 v2530))))
   (clojure.core/let
    [v2530
     (:internet-gateway-ids
      m2529
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (.
      bean2528
      setInternetGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2878] (clojure.core/str arg2878))
 v2530))))
   bean2528))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateRouteTableRequest}
disassociate-route-table-request
  [m2532]
  (clojure.core/let
   [bean2531
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/let
    [v2533
     (:association-id m2532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2533 :com.palletops.awaze.client-builder/undef)
     (. bean2531 setAssociationId (clojure.core/str v2533))))
   bean2531))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRegionsRequest}
describe-regions-request
  [m2535]
  (clojure.core/let
   [bean2534
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/let
    [v2536 (:filters m2535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (.
      bean2534
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2879] (ec2/filter arg2879))
 v2536))))
   (clojure.core/let
    [v2536
     (:region-names m2535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (.
      bean2534
      setRegionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2880] (clojure.core/str arg2880))
 v2536))))
   bean2534))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest}
enable-vpc-classic-link-dns-support-request
  [m2538]
  (clojure.core/let
   [bean2537
    (new
     com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2539 (:vpc-id m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setVpcId (clojure.core/str v2539))))
   bean2537))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeregisterImageRequest}
deregister-image-request
  [m2541]
  (clojure.core/let
   [bean2540
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/let
    [v2542
     (:image-id m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (. bean2540 setImageId (clojure.core/str v2542))))
   bean2540))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest}
delete-spot-datafeed-subscription-request
  [m2544]
  (clojure.core/let
   [bean2543
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean2543))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest}
describe-customer-gateways-request
  [m2547]
  (clojure.core/let
   [bean2546
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/let
    [v2548 (:filters m2547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2548 :com.palletops.awaze.client-builder/undef)
     (.
      bean2546
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2881] (ec2/filter arg2881))
 v2548))))
   (clojure.core/let
    [v2548
     (:customer-gateway-ids
      m2547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2548 :com.palletops.awaze.client-builder/undef)
     (.
      bean2546
      setCustomerGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2882] (clojure.core/str arg2882))
 v2548))))
   bean2546))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest}
describe-spot-fleet-request-history-request
  [m2550]
  (clojure.core/let
   [bean2549
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest)]
   (clojure.core/let
    [v2551
     (:next-token m2550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2551 :com.palletops.awaze.client-builder/undef)
     (. bean2549 setNextToken (clojure.core/str v2551))))
   (clojure.core/let
    [v2551
     (:max-results m2550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2551 :com.palletops.awaze.client-builder/undef)
     (. bean2549 setMaxResults (clojure.core/int v2551))))
   (clojure.core/let
    [v2551
     (:event-type m2550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2551 :com.palletops.awaze.client-builder/undef)
     (. bean2549 setEventType (ec2/event-type v2551))))
   (clojure.core/let
    [v2551
     (:spot-fleet-request-id
      m2550
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2551 :com.palletops.awaze.client-builder/undef)
     (. bean2549 setSpotFleetRequestId (clojure.core/str v2551))))
   (clojure.core/let
    [v2551
     (:start-time m2550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2551 :com.palletops.awaze.client-builder/undef)
     (.
      bean2549
      setStartTime
      (com.palletops.awaze.common/to-date v2551))))
   bean2549))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSubnetRequest}
create-subnet-request
  [m2553]
  (clojure.core/let
   [bean2552
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/let
    [v2554 (:vpc-id m2553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2554 :com.palletops.awaze.client-builder/undef)
     (. bean2552 setVpcId (clojure.core/str v2554))))
   (clojure.core/let
    [v2554
     (:cidr-block m2553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2554 :com.palletops.awaze.client-builder/undef)
     (. bean2552 setCidrBlock (clojure.core/str v2554))))
   (clojure.core/let
    [v2554
     (:availability-zone
      m2553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2554 :com.palletops.awaze.client-builder/undef)
     (. bean2552 setAvailabilityZone (clojure.core/str v2554))))
   bean2552))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest}
describe-network-interface-attribute-request
  [m2556]
  (clojure.core/let
   [bean2555
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2557
     (:attribute m2556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (. bean2555 setAttribute (clojure.core/str v2557))))
   (clojure.core/let
    [v2557
     (:network-interface-id
      m2556
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (. bean2555 setNetworkInterfaceId (clojure.core/str v2557))))
   bean2555))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest}
modify-instance-placement-request
  [m2559]
  (clojure.core/let
   [bean2558
    (new
     com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest)]
   (clojure.core/let
    [v2560 (:tenancy m2559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setTenancy (clojure.core/str v2560))))
   (clojure.core/let
    [v2560
     (:affinity m2559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setAffinity (ec2/affinity v2560))))
   (clojure.core/let
    [v2560 (:host-id m2559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setHostId (clojure.core/str v2560))))
   (clojure.core/let
    [v2560
     (:instance-id m2559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setInstanceId (clojure.core/str v2560))))
   bean2558))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest}
detach-classic-link-vpc-request
  [m2562]
  (clojure.core/let
   [bean2561
    (new com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2563 (:vpc-id m2562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2563 :com.palletops.awaze.client-builder/undef)
     (. bean2561 setVpcId (clojure.core/str v2563))))
   (clojure.core/let
    [v2563
     (:instance-id m2562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2563 :com.palletops.awaze.client-builder/undef)
     (. bean2561 setInstanceId (clojure.core/str v2563))))
   bean2561))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelConversionTaskRequest}
cancel-conversion-task-request
  [m2565]
  (clojure.core/let
   [bean2564
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/let
    [v2566
     (:conversion-task-id
      m2565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2566 :com.palletops.awaze.client-builder/undef)
     (. bean2564 setConversionTaskId (clojure.core/str v2566))))
   (clojure.core/let
    [v2566
     (:reason-message m2565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2566 :com.palletops.awaze.client-builder/undef)
     (. bean2564 setReasonMessage (clojure.core/str v2566))))
   bean2564))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest}
create-network-interface-request
  [m2568]
  (clojure.core/let
   [bean2567
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/let
    [v2569
     (:description m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setDescription (clojure.core/str v2569))))
   (clojure.core/let
    [v2569
     (:subnet-id m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setSubnetId (clojure.core/str v2569))))
   (clojure.core/let
    [v2569
     (:private-ip-address
      m2568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (. bean2567 setPrivateIpAddress (clojure.core/str v2569))))
   (clojure.core/let
    [v2569 (:groups m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (.
      bean2567
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2883] (clojure.core/str arg2883))
 v2569))))
   (clojure.core/let
    [v2569
     (:private-ip-addresses
      m2568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (.
      bean2567
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2884]
  (ec2/private-ip-address-specification arg2884))
 v2569))))
   (clojure.core/let
    [v2569
     (:secondary-private-ip-address-count
      m2568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (.
      bean2567
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2569))))
   bean2567))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyImageAttributeRequest}
modify-image-attribute-request
  [m2571]
  (clojure.core/let
   [bean2570
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/let
    [v2572
     (:description m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setDescription (clojure.core/str v2572))))
   (clojure.core/let
    [v2572
     (:operation-type m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setOperationType (ec2/operation-type v2572))))
   (clojure.core/let
    [v2572
     (:product-codes m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (.
      bean2570
      setProductCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2885] (clojure.core/str arg2885))
 v2572))))
   (clojure.core/let
    [v2572
     (:user-ids m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (.
      bean2570
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2886] (clojure.core/str arg2886))
 v2572))))
   (clojure.core/let
    [v2572
     (:attribute m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setAttribute (clojure.core/str v2572))))
   (clojure.core/let
    [v2572
     (:image-id m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setImageId (clojure.core/str v2572))))
   (clojure.core/let
    [v2572
     (:launch-permission
      m2571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (.
      bean2570
      setLaunchPermission
      (ec2/launch-permission-modifications v2572))))
   (clojure.core/let
    [v2572 (:value m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setValue (clojure.core/str v2572))))
   (clojure.core/let
    [v2572
     (:user-groups m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (.
      bean2570
      setUserGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2887] (clojure.core/str arg2887))
 v2572))))
   bean2570))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteTableRequest}
delete-route-table-request
  [m2574]
  (clojure.core/let
   [bean2573
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/let
    [v2575
     (:route-table-id m2574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setRouteTableId (clojure.core/str v2575))))
   bean2573))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateRouteTableRequest}
associate-route-table-request
  [m2577]
  (clojure.core/let
   [bean2576
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/let
    [v2578
     (:route-table-id m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setRouteTableId (clojure.core/str v2578))))
   (clojure.core/let
    [v2578
     (:subnet-id m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setSubnetId (clojure.core/str v2578))))
   bean2576))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest}
delete-customer-gateway-request
  [m2580]
  (clojure.core/let
   [bean2579
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/let
    [v2581
     (:customer-gateway-id
      m2580
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2581 :com.palletops.awaze.client-builder/undef)
     (. bean2579 setCustomerGatewayId (clojure.core/str v2581))))
   bean2579))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest}
replace-route-table-association-request
  [m2583]
  (clojure.core/let
   [bean2582
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/let
    [v2584
     (:association-id m2583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2584 :com.palletops.awaze.client-builder/undef)
     (. bean2582 setAssociationId (clojure.core/str v2584))))
   (clojure.core/let
    [v2584
     (:route-table-id m2583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2584 :com.palletops.awaze.client-builder/undef)
     (. bean2582 setRouteTableId (clojure.core/str v2584))))
   bean2582))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcRequest}
delete-vpc-request
  [m2586]
  (clojure.core/let
   [bean2585 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/let
    [v2587 (:vpc-id m2586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (. bean2585 setVpcId (clojure.core/str v2587))))
   bean2585))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateKeyPairRequest}
create-key-pair-request
  [m2589]
  (clojure.core/let
   [bean2588
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/let
    [v2590
     (:key-name m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setKeyName (clojure.core/str v2590))))
   bean2588))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateHostsRequest}
allocate-hosts-request
  [m2592]
  (clojure.core/let
   [bean2591
    (new com.amazonaws.services.ec2.model.AllocateHostsRequest)]
   (clojure.core/let
    [v2593
     (:client-token m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setClientToken (clojure.core/str v2593))))
   (clojure.core/let
    [v2593
     (:availability-zone
      m2592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setAvailabilityZone (clojure.core/str v2593))))
   (clojure.core/let
    [v2593
     (:auto-placement m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setAutoPlacement (clojure.core/str v2593))))
   (clojure.core/let
    [v2593
     (:quantity m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setQuantity (clojure.core/int v2593))))
   (clojure.core/let
    [v2593
     (:instance-type m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setInstanceType (clojure.core/str v2593))))
   bean2591))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteRequest}
replace-route-request
  [m2595]
  (clojure.core/let
   [bean2594
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/let
    [v2596
     (:route-table-id m2595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setRouteTableId (clojure.core/str v2596))))
   (clojure.core/let
    [v2596
     (:instance-id m2595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setInstanceId (clojure.core/str v2596))))
   (clojure.core/let
    [v2596
     (:network-interface-id
      m2595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setNetworkInterfaceId (clojure.core/str v2596))))
   (clojure.core/let
    [v2596
     (:vpc-peering-connection-id
      m2595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setVpcPeeringConnectionId (clojure.core/str v2596))))
   (clojure.core/let
    [v2596
     (:destination-cidr-block
      m2595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setDestinationCidrBlock (clojure.core/str v2596))))
   (clojure.core/let
    [v2596
     (:gateway-id m2595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setGatewayId (clojure.core/str v2596))))
   (clojure.core/let
    [v2596
     (:nat-gateway-id m2595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setNatGatewayId (clojure.core/str v2596))))
   bean2594))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TerminateInstancesRequest}
terminate-instances-request
  [m2598]
  (clojure.core/let
   [bean2597
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/let
    [v2599
     (:instance-ids m2598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (.
      bean2597
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2888] (clojure.core/str arg2888))
 v2599))))
   bean2597))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m2601]
  (clojure.core/let
   [bean2600
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v2602 (:filters m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (.
      bean2600
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2889] (ec2/filter arg2889))
 v2602))))
   (clojure.core/let
    [v2602
     (:next-token m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setNextToken (clojure.core/str v2602))))
   (clojure.core/let
    [v2602
     (:max-results m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setMaxResults (clojure.core/int v2602))))
   (clojure.core/let
    [v2602
     (:restorable-by-user-ids
      m2601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (.
      bean2600
      setRestorableByUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2890] (clojure.core/str arg2890))
 v2602))))
   (clojure.core/let
    [v2602
     (:snapshot-ids m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (.
      bean2600
      setSnapshotIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2891] (clojure.core/str arg2891))
 v2602))))
   (clojure.core/let
    [v2602
     (:owner-ids m2601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (.
      bean2600
      setOwnerIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2892] (clojure.core/str arg2892))
 v2602))))
   bean2600))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest}
describe-vpn-gateways-request
  [m2604]
  (clojure.core/let
   [bean2603
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/let
    [v2605
     (:vpn-gateway-ids
      m2604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2605 :com.palletops.awaze.client-builder/undef)
     (.
      bean2603
      setVpnGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2893] (clojure.core/str arg2893))
 v2605))))
   (clojure.core/let
    [v2605 (:filters m2604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2605 :com.palletops.awaze.client-builder/undef)
     (.
      bean2603
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2894] (ec2/filter arg2894))
 v2605))))
   bean2603))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetPasswordDataRequest}
get-password-data-request
  [m2607]
  (clojure.core/let
   [bean2606
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/let
    [v2608
     (:instance-id m2607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (. bean2606 setInstanceId (clojure.core/str v2608))))
   bean2606))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest}
modify-volume-attribute-request
  [m2610]
  (clojure.core/let
   [bean2609
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/let
    [v2611
     (:auto-enable-io m2610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (. bean2609 setAutoEnableIO (clojure.core/boolean v2611))))
   (clojure.core/let
    [v2611
     (:volume-id m2610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (. bean2609 setVolumeId (clojure.core/str v2611))))
   bean2609))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest}
disable-vgw-route-propagation-request
  [m2613]
  (clojure.core/let
   [bean2612
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2614
     (:route-table-id m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setRouteTableId (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:gateway-id m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setGatewayId (clojure.core/str v2614))))
   bean2612))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest}
describe-spot-fleet-instances-request
  [m2616]
  (clojure.core/let
   [bean2615
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest)]
   (clojure.core/let
    [v2617
     (:next-token m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setNextToken (clojure.core/str v2617))))
   (clojure.core/let
    [v2617
     (:max-results m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setMaxResults (clojure.core/int v2617))))
   (clojure.core/let
    [v2617
     (:spot-fleet-request-id
      m2616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setSpotFleetRequestId (clojure.core/str v2617))))
   bean2615))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePrefixListsRequest}
describe-prefix-lists-request
  [m2619]
  (clojure.core/let
   [bean2618
    (new com.amazonaws.services.ec2.model.DescribePrefixListsRequest)]
   (clojure.core/let
    [v2620 (:filters m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (.
      bean2618
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2895] (ec2/filter arg2895))
 v2620))))
   (clojure.core/let
    [v2620
     (:next-token m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (. bean2618 setNextToken (clojure.core/str v2620))))
   (clojure.core/let
    [v2620
     (:max-results m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (. bean2618 setMaxResults (clojure.core/int v2620))))
   (clojure.core/let
    [v2620
     (:prefix-list-ids
      m2619
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (.
      bean2618
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2896] (clojure.core/str arg2896))
 v2620))))
   bean2618))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m2622]
  (clojure.core/let
   [bean2621
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/let
    [v2623
     (:attribute-names
      m2622
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (.
      bean2621
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2897] (clojure.core/str arg2897))
 v2623))))
   bean2621))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRequest}
create-vpn-connection-request
  [m2625]
  (clojure.core/let
   [bean2624
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/let
    [v2626
     (:vpn-gateway-id m2625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (. bean2624 setVpnGatewayId (clojure.core/str v2626))))
   (clojure.core/let
    [v2626 (:type m2625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (. bean2624 setType (clojure.core/str v2626))))
   (clojure.core/let
    [v2626 (:options m2625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (.
      bean2624
      setOptions
      (ec2/vpn-connection-options-specification v2626))))
   (clojure.core/let
    [v2626
     (:customer-gateway-id
      m2625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (. bean2624 setCustomerGatewayId (clojure.core/str v2626))))
   bean2624))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest}
describe-vpc-peering-connections-request
  [m2628]
  (clojure.core/let
   [bean2627
    (new
     com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest)]
   (clojure.core/let
    [v2629
     (:vpc-peering-connection-ids
      m2628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2629 :com.palletops.awaze.client-builder/undef)
     (.
      bean2627
      setVpcPeeringConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2898] (clojure.core/str arg2898))
 v2629))))
   (clojure.core/let
    [v2629 (:filters m2628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2629 :com.palletops.awaze.client-builder/undef)
     (.
      bean2627
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2899] (ec2/filter arg2899))
 v2629))))
   bean2627))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest}
describe-scheduled-instance-availability-request
  [m2631]
  (clojure.core/let
   [bean2630
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest)]
   (clojure.core/let
    [v2632 (:filters m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (.
      bean2630
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2900] (ec2/filter arg2900))
 v2632))))
   (clojure.core/let
    [v2632
     (:next-token m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setNextToken (clojure.core/str v2632))))
   (clojure.core/let
    [v2632
     (:max-results m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setMaxResults (clojure.core/int v2632))))
   (clojure.core/let
    [v2632
     (:recurrence m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (.
      bean2630
      setRecurrence
      (ec2/scheduled-instance-recurrence-request v2632))))
   (clojure.core/let
    [v2632
     (:first-slot-start-time-range
      m2631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (.
      bean2630
      setFirstSlotStartTimeRange
      (ec2/slot-date-time-range-request v2632))))
   (clojure.core/let
    [v2632
     (:min-slot-duration-in-hours
      m2631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setMinSlotDurationInHours (clojure.core/int v2632))))
   (clojure.core/let
    [v2632
     (:max-slot-duration-in-hours
      m2631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setMaxSlotDurationInHours (clojure.core/int v2632))))
   bean2630))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeFlowLogsRequest}
describe-flow-logs-request
  [m2634]
  (clojure.core/let
   [bean2633
    (new com.amazonaws.services.ec2.model.DescribeFlowLogsRequest)]
   (clojure.core/let
    [v2635
     (:flow-log-ids m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (.
      bean2633
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2901] (clojure.core/str arg2901))
 v2635))))
   (clojure.core/let
    [v2635 (:filter m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (.
      bean2633
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2902] (ec2/filter arg2902))
 v2635))))
   (clojure.core/let
    [v2635
     (:next-token m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (. bean2633 setNextToken (clojure.core/str v2635))))
   (clojure.core/let
    [v2635
     (:max-results m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (. bean2633 setMaxResults (clojure.core/int v2635))))
   bean2633))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelBundleTaskRequest}
cancel-bundle-task-request
  [m2637]
  (clojure.core/let
   [bean2636
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/let
    [v2638
     (:bundle-id m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setBundleId (clojure.core/str v2638))))
   bean2636))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest}
describe-reserved-instances-request
  [m2640]
  (clojure.core/let
   [bean2639
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/let
    [v2641 (:filters m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (.
      bean2639
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2903] (ec2/filter arg2903))
 v2641))))
   (clojure.core/let
    [v2641
     (:reserved-instances-ids
      m2640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (.
      bean2639
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2904] (clojure.core/str arg2904))
 v2641))))
   (clojure.core/let
    [v2641
     (:offering-type m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (. bean2639 setOfferingType (ec2/offering-type-values v2641))))
   bean2639))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnmonitorInstancesRequest}
unmonitor-instances-request
  [m2643]
  (clojure.core/let
   [bean2642
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/let
    [v2644
     (:instance-ids m2643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2644 :com.palletops.awaze.client-builder/undef)
     (.
      bean2642
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2905] (clojure.core/str arg2905))
 v2644))))
   bean2642))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest}
delete-security-group-request
  [m2646]
  (clojure.core/let
   [bean2645
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/let
    [v2647
     (:group-id m2646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (. bean2645 setGroupId (clojure.core/str v2647))))
   (clojure.core/let
    [v2647
     (:group-name m2646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (. bean2645 setGroupName (clojure.core/str v2647))))
   bean2645))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest}
describe-vpc-attribute-request
  [m2649]
  (clojure.core/let
   [bean2648
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/let
    [v2650
     (:attribute m2649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (. bean2648 setAttribute (clojure.core/str v2650))))
   (clojure.core/let
    [v2650 (:vpc-id m2649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (. bean2648 setVpcId (clojure.core/str v2650))))
   bean2648))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclRequest}
create-network-acl-request
  [m2652]
  (clojure.core/let
   [bean2651
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/let
    [v2653 (:vpc-id m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setVpcId (clojure.core/str v2653))))
   bean2651))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelImportTaskRequest}
cancel-import-task-request
  [m2655]
  (clojure.core/let
   [bean2654
    (new com.amazonaws.services.ec2.model.CancelImportTaskRequest)]
   (clojure.core/let
    [v2656
     (:cancel-reason m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (. bean2654 setCancelReason (clojure.core/str v2656))))
   (clojure.core/let
    [v2656
     (:import-task-id m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (. bean2654 setImportTaskId (clojure.core/str v2656))))
   bean2654))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest}
accept-vpc-peering-connection-request
  [m2658]
  (clojure.core/let
   [bean2657
    (new
     com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2659
     (:vpc-peering-connection-id
      m2658
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2659 :com.palletops.awaze.client-builder/undef)
     (. bean2657 setVpcPeeringConnectionId (clojure.core/str v2659))))
   bean2657))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest}
describe-vpc-endpoint-services-request
  [m2661]
  (clojure.core/let
   [bean2660
    (new
     com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest)]
   (clojure.core/let
    [v2662
     (:next-token m2661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2662 :com.palletops.awaze.client-builder/undef)
     (. bean2660 setNextToken (clojure.core/str v2662))))
   (clojure.core/let
    [v2662
     (:max-results m2661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2662 :com.palletops.awaze.client-builder/undef)
     (. bean2660 setMaxResults (clojure.core/int v2662))))
   bean2660))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest}
delete-vpc-peering-connection-request
  [m2664]
  (clojure.core/let
   [bean2663
    (new
     com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2665
     (:vpc-peering-connection-id
      m2664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2665 :com.palletops.awaze.client-builder/undef)
     (. bean2663 setVpcPeeringConnectionId (clojure.core/str v2665))))
   bean2663))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunInstancesRequest}
run-instances-request
  [m2667]
  (clojure.core/let
   [bean2666
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/let
    [v2668
     (:iam-instance-profile
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (.
      bean2666
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2668))))
   (clojure.core/let
    [v2668
     (:max-count m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setMaxCount (clojure.core/int v2668))))
   (clojure.core/let
    [v2668
     (:subnet-id m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setSubnetId (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:additional-info
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setAdditionalInfo (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:security-group-ids
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (.
      bean2666
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2906] (clojure.core/str arg2906))
 v2668))))
   (clojure.core/let
    [v2668
     (:placement m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setPlacement (ec2/placement v2668))))
   (clojure.core/let
    [v2668
     (:private-ip-address
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setPrivateIpAddress (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:client-token m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setClientToken (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:instance-type m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setInstanceType (ec2/instance-type v2668))))
   (clojure.core/let
    [v2668
     (:ebs-optimized m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setEbsOptimized (clojure.core/boolean v2668))))
   (clojure.core/let
    [v2668
     (:ramdisk-id m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setRamdiskId (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:instance-initiated-shutdown-behavior
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (.
      bean2666
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:disable-api-termination
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (.
      bean2666
      setDisableApiTermination
      (clojure.core/boolean v2668))))
   (clojure.core/let
    [v2668
     (:image-id m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setImageId (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:key-name m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setKeyName (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:min-count m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setMinCount (clojure.core/int v2668))))
   (clojure.core/let
    [v2668
     (:kernel-id m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setKernelId (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:monitoring m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setMonitoring (clojure.core/boolean v2668))))
   (clojure.core/let
    [v2668
     (:security-groups
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (.
      bean2666
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2907] (clojure.core/str arg2907))
 v2668))))
   (clojure.core/let
    [v2668
     (:block-device-mappings
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (.
      bean2666
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2908] (ec2/block-device-mapping arg2908))
 v2668))))
   (clojure.core/let
    [v2668
     (:user-data m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setUserData (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:network-interfaces
      m2667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (.
      bean2666
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2909]
  (ec2/instance-network-interface-specification arg2909))
 v2668))))
   bean2666))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest}
describe-instance-status-request
  [m2670]
  (clojure.core/let
   [bean2669
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/let
    [v2671 (:filters m2670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (.
      bean2669
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2910] (ec2/filter arg2910))
 v2671))))
   (clojure.core/let
    [v2671
     (:next-token m2670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (. bean2669 setNextToken (clojure.core/str v2671))))
   (clojure.core/let
    [v2671
     (:max-results m2670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (. bean2669 setMaxResults (clojure.core/int v2671))))
   (clojure.core/let
    [v2671
     (:instance-ids m2670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (.
      bean2669
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2911] (clojure.core/str arg2911))
 v2671))))
   (clojure.core/let
    [v2671
     (:include-all-instances
      m2670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (. bean2669 setIncludeAllInstances (clojure.core/boolean v2671))))
   bean2669))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest}
describe-vpc-classic-link-dns-support-request
  [m2673]
  (clojure.core/let
   [bean2672
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2674
     (:next-token m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setNextToken (clojure.core/str v2674))))
   (clojure.core/let
    [v2674
     (:max-results m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setMaxResults (clojure.core/int v2674))))
   (clojure.core/let
    [v2674 (:vpc-ids m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (.
      bean2672
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2912] (clojure.core/str arg2912))
 v2674))))
   bean2672))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest}
unassign-private-ip-addresses-request
  [m2676]
  (clojure.core/let
   [bean2675
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2677
     (:network-interface-id
      m2676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (. bean2675 setNetworkInterfaceId (clojure.core/str v2677))))
   (clojure.core/let
    [v2677
     (:private-ip-addresses
      m2676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (.
      bean2675
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2913] (clojure.core/str arg2913))
 v2677))))
   bean2675))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest}
describe-security-groups-request
  [m2679]
  (clojure.core/let
   [bean2678
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/let
    [v2680 (:filters m2679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (.
      bean2678
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2914] (ec2/filter arg2914))
 v2680))))
   (clojure.core/let
    [v2680
     (:group-names m2679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (.
      bean2678
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2915] (clojure.core/str arg2915))
 v2680))))
   (clojure.core/let
    [v2680
     (:group-ids m2679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (.
      bean2678
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2916] (clojure.core/str arg2916))
 v2680))))
   bean2678))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest}
describe-network-interfaces-request
  [m2682]
  (clojure.core/let
   [bean2681
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/let
    [v2683 (:filters m2682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2683 :com.palletops.awaze.client-builder/undef)
     (.
      bean2681
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2917] (ec2/filter arg2917))
 v2683))))
   (clojure.core/let
    [v2683
     (:network-interface-ids
      m2682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2683 :com.palletops.awaze.client-builder/undef)
     (.
      bean2681
      setNetworkInterfaceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2918] (clojure.core/str arg2918))
 v2683))))
   bean2681))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest}
create-customer-gateway-request
  [m2685]
  (clojure.core/let
   [bean2684
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/let
    [v2686
     (:public-ip m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setPublicIp (clojure.core/str v2686))))
   (clojure.core/let
    [v2686 (:type m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setType (ec2/gateway-type v2686))))
   (clojure.core/let
    [v2686 (:bgp-asn m2685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setBgpAsn (clojure.core/int v2686))))
   bean2684))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest}
describe-dhcp-options-request
  [m2688]
  (clojure.core/let
   [bean2687
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/let
    [v2689 (:filters m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2919] (ec2/filter arg2919))
 v2689))))
   (clojure.core/let
    [v2689
     (:dhcp-options-ids
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setDhcpOptionsIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2920] (clojure.core/str arg2920))
 v2689))))
   bean2687))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateTagsRequest}
create-tags-request
  [m2691]
  (clojure.core/let
   [bean2690 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/let
    [v2692
     (:resources m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (.
      bean2690
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2921] (clojure.core/str arg2921))
 v2692))))
   (clojure.core/let
    [v2692 (:tags m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (.
      bean2690
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2922] (ec2/tag arg2922)) v2692))))
   bean2690))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSnapshotRequest}
create-snapshot-request
  [m2694]
  (clojure.core/let
   [bean2693
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v2695
     (:description m2694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (. bean2693 setDescription (clojure.core/str v2695))))
   (clojure.core/let
    [v2695
     (:volume-id m2694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (. bean2693 setVolumeId (clojure.core/str v2695))))
   bean2693))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportImageRequest}
import-image-request
  [m2697]
  (clojure.core/let
   [bean2696
    (new com.amazonaws.services.ec2.model.ImportImageRequest)]
   (clojure.core/let
    [v2698
     (:description m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setDescription (clojure.core/str v2698))))
   (clojure.core/let
    [v2698
     (:disk-containers
      m2697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (.
      bean2696
      setDiskContainers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2923] (ec2/image-disk-container arg2923))
 v2698))))
   (clojure.core/let
    [v2698
     (:client-data m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setClientData (ec2/client-data v2698))))
   (clojure.core/let
    [v2698
     (:client-token m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setClientToken (clojure.core/str v2698))))
   (clojure.core/let
    [v2698
     (:role-name m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setRoleName (clojure.core/str v2698))))
   (clojure.core/let
    [v2698
     (:hypervisor m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setHypervisor (clojure.core/str v2698))))
   (clojure.core/let
    [v2698
     (:platform m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setPlatform (clojure.core/str v2698))))
   (clojure.core/let
    [v2698
     (:license-type m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setLicenseType (clojure.core/str v2698))))
   (clojure.core/let
    [v2698
     (:architecture m2697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setArchitecture (clojure.core/str v2698))))
   bean2696))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteTableRequest}
create-route-table-request
  [m2700]
  (clojure.core/let
   [bean2699
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/let
    [v2701 (:vpc-id m2700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2701 :com.palletops.awaze.client-builder/undef)
     (. bean2699 setVpcId (clojure.core/str v2701))))
   bean2699))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeHostsRequest}
describe-hosts-request
  [m2703]
  (clojure.core/let
   [bean2702
    (new com.amazonaws.services.ec2.model.DescribeHostsRequest)]
   (clojure.core/let
    [v2704 (:filter m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (.
      bean2702
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2924] (ec2/filter arg2924))
 v2704))))
   (clojure.core/let
    [v2704
     (:next-token m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setNextToken (clojure.core/str v2704))))
   (clojure.core/let
    [v2704
     (:max-results m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (. bean2702 setMaxResults (clojure.core/int v2704))))
   (clojure.core/let
    [v2704
     (:host-ids m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (.
      bean2702
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2925] (clojure.core/str arg2925))
 v2704))))
   bean2702))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest}
describe-volume-attribute-request
  [m2706]
  (clojure.core/let
   [bean2705
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/let
    [v2707
     (:attribute m2706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2707 :com.palletops.awaze.client-builder/undef)
     (. bean2705 setAttribute (clojure.core/str v2707))))
   (clojure.core/let
    [v2707
     (:volume-id m2706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2707 :com.palletops.awaze.client-builder/undef)
     (. bean2705 setVolumeId (clojure.core/str v2707))))
   bean2705))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyIdFormatRequest}
modify-id-format-request
  [m2709]
  (clojure.core/let
   [bean2708
    (new com.amazonaws.services.ec2.model.ModifyIdFormatRequest)]
   (clojure.core/let
    [v2710
     (:use-long-ids m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (. bean2708 setUseLongIds (clojure.core/boolean v2710))))
   (clojure.core/let
    [v2710
     (:resource m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (. bean2708 setResource (clojure.core/str v2710))))
   bean2708))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest}
create-network-acl-entry-request
  [m2712]
  (clojure.core/let
   [bean2711
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/let
    [v2713
     (:protocol m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setProtocol (clojure.core/str v2713))))
   (clojure.core/let
    [v2713
     (:network-acl-id m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setNetworkAclId (clojure.core/str v2713))))
   (clojure.core/let
    [v2713
     (:rule-number m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setRuleNumber (clojure.core/int v2713))))
   (clojure.core/let
    [v2713
     (:rule-action m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setRuleAction (clojure.core/str v2713))))
   (clojure.core/let
    [v2713 (:egress m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setEgress (clojure.core/boolean v2713))))
   (clojure.core/let
    [v2713
     (:cidr-block m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setCidrBlock (clojure.core/str v2713))))
   (clojure.core/let
    [v2713
     (:icmp-type-code m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setIcmpTypeCode (ec2/icmp-type-code v2713))))
   (clojure.core/let
    [v2713
     (:port-range m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (. bean2711 setPortRange (ec2/port-range v2713))))
   bean2711))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest}
describe-nat-gateways-request
  [m2715]
  (clojure.core/let
   [bean2714
    (new com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest)]
   (clojure.core/let
    [v2716 (:filter m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (.
      bean2714
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2926] (ec2/filter arg2926))
 v2716))))
   (clojure.core/let
    [v2716
     (:next-token m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setNextToken (clojure.core/str v2716))))
   (clojure.core/let
    [v2716
     (:max-results m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setMaxResults (clojure.core/int v2716))))
   (clojure.core/let
    [v2716
     (:nat-gateway-ids
      m2715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (.
      bean2714
      setNatGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2927] (clojure.core/str arg2927))
 v2716))))
   bean2714))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest}
cancel-reserved-instances-listing-request
  [m2718]
  (clojure.core/let
   [bean2717
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/let
    [v2719
     (:reserved-instances-listing-id
      m2718
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (.
      bean2717
      setReservedInstancesListingId
      (clojure.core/str v2719))))
   bean2717))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest}
disable-vpc-classic-link-request
  [m2721]
  (clojure.core/let
   [bean2720
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2722 (:vpc-id m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (. bean2720 setVpcId (clojure.core/str v2722))))
   bean2720))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunScheduledInstancesRequest}
run-scheduled-instances-request
  [m2724]
  (clojure.core/let
   [bean2723
    (new
     com.amazonaws.services.ec2.model.RunScheduledInstancesRequest)]
   (clojure.core/let
    [v2725
     (:launch-specification
      m2724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (.
      bean2723
      setLaunchSpecification
      (ec2/scheduled-instances-launch-specification v2725))))
   (clojure.core/let
    [v2725
     (:scheduled-instance-id
      m2724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (. bean2723 setScheduledInstanceId (clojure.core/str v2725))))
   (clojure.core/let
    [v2725
     (:client-token m2724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (. bean2723 setClientToken (clojure.core/str v2725))))
   (clojure.core/let
    [v2725
     (:instance-count m2724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (. bean2723 setInstanceCount (clojure.core/int v2725))))
   bean2723))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteKeyPairRequest}
delete-key-pair-request
  [m2727]
  (clojure.core/let
   [bean2726
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/let
    [v2728
     (:key-name m2727 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2728 :com.palletops.awaze.client-builder/undef)
     (. bean2726 setKeyName (clojure.core/str v2728))))
   bean2726))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest}
modify-reserved-instances-request
  [m2730]
  (clojure.core/let
   [bean2729
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/let
    [v2731
     (:target-configurations
      m2730
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (.
      bean2729
      setTargetConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2928]
  (ec2/reserved-instances-configuration arg2928))
 v2731))))
   (clojure.core/let
    [v2731
     (:client-token m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setClientToken (clojure.core/str v2731))))
   (clojure.core/let
    [v2731
     (:reserved-instances-ids
      m2730
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (.
      bean2729
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2929] (clojure.core/str arg2929))
 v2731))))
   bean2729))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest}
delete-vpn-connection-route-request
  [m2733]
  (clojure.core/let
   [bean2732
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2734
     (:destination-cidr-block
      m2733
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setDestinationCidrBlock (clojure.core/str v2734))))
   (clojure.core/let
    [v2734
     (:vpn-connection-id
      m2733
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setVpnConnectionId (clojure.core/str v2734))))
   bean2732))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachInternetGatewayRequest}
attach-internet-gateway-request
  [m2736]
  (clojure.core/let
   [bean2735
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/let
    [v2737 (:vpc-id m2736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (. bean2735 setVpcId (clojure.core/str v2737))))
   (clojure.core/let
    [v2737
     (:internet-gateway-id
      m2736
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (. bean2735 setInternetGatewayId (clojure.core/str v2737))))
   bean2735))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest}
modify-network-interface-attribute-request
  [m2739]
  (clojure.core/let
   [bean2738
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2740
     (:source-dest-check
      m2739
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (. bean2738 setSourceDestCheck (clojure.core/boolean v2740))))
   (clojure.core/let
    [v2740
     (:attachment m2739 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (.
      bean2738
      setAttachment
      (ec2/network-interface-attachment-changes v2740))))
   (clojure.core/let
    [v2740
     (:description m2739 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (. bean2738 setDescription (clojure.core/str v2740))))
   (clojure.core/let
    [v2740
     (:network-interface-id
      m2739
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (. bean2738 setNetworkInterfaceId (clojure.core/str v2740))))
   (clojure.core/let
    [v2740 (:groups m2739 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (.
      bean2738
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2930] (clojure.core/str arg2930))
 v2740))))
   bean2738))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest}
enable-vgw-route-propagation-request
  [m2742]
  (clojure.core/let
   [bean2741
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2743
     (:route-table-id m2742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (. bean2741 setRouteTableId (clojure.core/str v2743))))
   (clojure.core/let
    [v2743
     (:gateway-id m2742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (. bean2741 setGatewayId (clojure.core/str v2743))))
   bean2741))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest}
delete-network-acl-entry-request
  [m2745]
  (clojure.core/let
   [bean2744
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/let
    [v2746
     (:network-acl-id m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setNetworkAclId (clojure.core/str v2746))))
   (clojure.core/let
    [v2746
     (:rule-number m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setRuleNumber (clojure.core/int v2746))))
   (clojure.core/let
    [v2746 (:egress m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setEgress (clojure.core/boolean v2746))))
   bean2744))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelExportTaskRequest}
cancel-export-task-request
  [m2748]
  (clojure.core/let
   [bean2747
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/let
    [v2749
     (:export-task-id m2748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2749 :com.palletops.awaze.client-builder/undef)
     (. bean2747 setExportTaskId (clojure.core/str v2749))))
   bean2747))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateImageRequest}
create-image-request
  [m2751]
  (clojure.core/let
   [bean2750
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/let
    [v2752
     (:description m2751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setDescription (clojure.core/str v2752))))
   (clojure.core/let
    [v2752
     (:instance-id m2751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setInstanceId (clojure.core/str v2752))))
   (clojure.core/let
    [v2752
     (:no-reboot m2751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setNoReboot (clojure.core/boolean v2752))))
   (clojure.core/let
    [v2752
     (:block-device-mappings
      m2751
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (.
      bean2750
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2931] (ec2/block-device-mapping arg2931))
 v2752))))
   (clojure.core/let
    [v2752 (:name m2751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setName (clojure.core/str v2752))))
   bean2750))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest}
modify-spot-fleet-request-request
  [m2754]
  (clojure.core/let
   [bean2753
    (new
     com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest)]
   (clojure.core/let
    [v2755
     (:target-capacity
      m2754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2755 :com.palletops.awaze.client-builder/undef)
     (. bean2753 setTargetCapacity (clojure.core/int v2755))))
   (clojure.core/let
    [v2755
     (:excess-capacity-termination-policy
      m2754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2755 :com.palletops.awaze.client-builder/undef)
     (.
      bean2753
      setExcessCapacityTerminationPolicy
      (clojure.core/str v2755))))
   (clojure.core/let
    [v2755
     (:spot-fleet-request-id
      m2754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2755 :com.palletops.awaze.client-builder/undef)
     (. bean2753 setSpotFleetRequestId (clojure.core/str v2755))))
   bean2753))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest}
describe-import-snapshot-tasks-request
  [m2757]
  (clojure.core/let
   [bean2756
    (new
     com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest)]
   (clojure.core/let
    [v2758 (:filters m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (.
      bean2756
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3052] (ec2/filter arg3052))
 v2758))))
   (clojure.core/let
    [v2758
     (:next-token m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setNextToken (clojure.core/str v2758))))
   (clojure.core/let
    [v2758
     (:max-results m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setMaxResults (clojure.core/int v2758))))
   (clojure.core/let
    [v2758
     (:import-task-ids
      m2757
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (.
      bean2756
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3053] (clojure.core/str arg3053))
 v2758))))
   bean2756))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-endpoints
   [m2932]
   (clojure.core/let
    [credentials2933 (:credentials m2932) args2934 (:args m2932)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2935
      (com.palletops.awaze.common/aws-client :ec2 credentials2933)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2935
       deleteVpcEndpoints
       (ec2/delete-vpc-endpoints-request
        (clojure.core/nth args2934 0)))))))
  (clojure.core/defn
   delete-vpc-endpoints-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Generate map for deleteVpcEndpoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-endpoints
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Call deleteVpcEndpoints"}
   [credentials2937 & args2938]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2939
     (com.palletops.awaze.common/aws-client :ec2 credentials2937)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2939
      deleteVpcEndpoints
      (ec2/delete-vpc-endpoints-request (clojure.core/nth args2938 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-nat-gateway
   [m2940]
   (clojure.core/let
    [credentials2941 (:credentials m2940) args2942 (:args m2940)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2943
      (com.palletops.awaze.common/aws-client :ec2 credentials2941)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2943
       createNatGateway
       (ec2/create-nat-gateway-request (clojure.core/nth args2942 0)))))))
  (clojure.core/defn
   create-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createNatGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-nat-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createNatGateway"}
   [credentials2945 & args2946]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2947
     (com.palletops.awaze.common/aws-client :ec2 credentials2945)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2947
      createNatGateway
      (ec2/create-nat-gateway-request (clojure.core/nth args2946 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m2948]
   (clojure.core/let
    [credentials2949 (:credentials m2948) args2950 (:args m2948)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2951
      (com.palletops.awaze.common/aws-client :ec2 credentials2949)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2951
       stopInstances
       (ec2/stop-instances-request (clojure.core/nth args2950 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :stop-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call stopInstances"}
   [credentials2953 & args2954]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2955
     (com.palletops.awaze.common/aws-client :ec2 credentials2953)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2955
      stopInstances
      (ec2/stop-instances-request (clojure.core/nth args2954 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m2956]
   (clojure.core/let
    [credentials2957 (:credentials m2956) args2958 (:args m2956)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2959
      (com.palletops.awaze.common/aws-client :ec2 credentials2957)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2959
       createPlacementGroup
       (ec2/create-placement-group-request
        (clojure.core/nth args2958 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-placement-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPlacementGroup"}
   [credentials2961 & args2962]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2963
     (com.palletops.awaze.common/aws-client :ec2 credentials2961)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2963
      createPlacementGroup
      (ec2/create-placement-group-request
       (clojure.core/nth args2962 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m2964]
   (clojure.core/let
    [credentials2965 (:credentials m2964) args2966 (:args m2964)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2967
      (com.palletops.awaze.common/aws-client :ec2 credentials2965)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2967
       createReservedInstancesListing
       (ec2/create-reserved-instances-listing-request
        (clojure.core/nth args2966 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-reserved-instances-listing,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials2969 & args2970]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2971
     (com.palletops.awaze.common/aws-client :ec2 credentials2969)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2971
      createReservedInstancesListing
      (ec2/create-reserved-instances-listing-request
       (clojure.core/nth args2970 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-hosts
   [m2972]
   (clojure.core/let
    [credentials2973 (:credentials m2972) args2974 (:args m2972)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2975
      (com.palletops.awaze.common/aws-client :ec2 credentials2973)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2975
       releaseHosts
       (ec2/release-hosts-request (clojure.core/nth args2974 0)))))))
  (clojure.core/defn
   release-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for releaseHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :release-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call releaseHosts"}
   [credentials2977 & args2978]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2979
     (com.palletops.awaze.common/aws-client :ec2 credentials2977)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2979
      releaseHosts
      (ec2/release-hosts-request (clojure.core/nth args2978 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m2980]
   (clojure.core/let
    [credentials2981 (:credentials m2980) args2982 (:args m2980)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2983
      (com.palletops.awaze.common/aws-client :ec2 credentials2981)]
     (clojure.core/case
      (clojure.core/count args2982)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2983
        revokeSecurityGroupIngress
        (ec2/revoke-security-group-ingress-request
         (clojure.core/nth args2982 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2983
        revokeSecurityGroupIngress))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]
                [credentials]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials2985 & args2986]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2987
     (com.palletops.awaze.common/aws-client :ec2 credentials2985)]
    (clojure.core/case
     (clojure.core/count args2986)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2987
       revokeSecurityGroupIngress
       (ec2/revoke-security-group-ingress-request
        (clojure.core/nth args2986 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2987
       revokeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-classic-link-vpc
   [m2988]
   (clojure.core/let
    [credentials2989 (:credentials m2988) args2990 (:args m2988)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2991
      (com.palletops.awaze.common/aws-client :ec2 credentials2989)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2991
       attachClassicLinkVpc
       (ec2/attach-classic-link-vpc-request
        (clojure.core/nth args2990 0)))))))
  (clojure.core/defn
   attach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Generate map for attachClassicLinkVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-classic-link-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Call attachClassicLinkVpc"}
   [credentials2993 & args2994]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2995
     (com.palletops.awaze.common/aws-client :ec2 credentials2993)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2995
      attachClassicLinkVpc
      (ec2/attach-classic-link-vpc-request
       (clojure.core/nth args2994 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m2996]
   (clojure.core/let
    [credentials2997 (:credentials m2996) args2998 (:args m2996)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2999
      (com.palletops.awaze.common/aws-client :ec2 credentials2997)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2999
       replaceNetworkAclAssociation
       (ec2/replace-network-acl-association-request
        (clojure.core/nth args2998 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-network-acl-association,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials3001 & args3002]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3003
     (com.palletops.awaze.common/aws-client :ec2 credentials3001)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3003
      replaceNetworkAclAssociation
      (ec2/replace-network-acl-association-request
       (clojure.core/nth args3002 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-nat-gateway
   [m3004]
   (clojure.core/let
    [credentials3005 (:credentials m3004) args3006 (:args m3004)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3007
      (com.palletops.awaze.common/aws-client :ec2 credentials3005)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3007
       deleteNatGateway
       (ec2/delete-nat-gateway-request (clojure.core/nth args3006 0)))))))
  (clojure.core/defn
   delete-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNatGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-nat-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNatGateway"}
   [credentials3009 & args3010]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3011
     (com.palletops.awaze.common/aws-client :ec2 credentials3009)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3011
      deleteNatGateway
      (ec2/delete-nat-gateway-request (clojure.core/nth args3010 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m3012]
   (clojure.core/let
    [credentials3013 (:credentials m3012) args3014 (:args m3012)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3015
      (com.palletops.awaze.common/aws-client :ec2 credentials3013)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3015
       modifyInstanceAttribute
       (ec2/modify-instance-attribute-request
        (clojure.core/nth args3014 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials3017 & args3018]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3019
     (com.palletops.awaze.common/aws-client :ec2 credentials3017)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3019
      modifyInstanceAttribute
      (ec2/modify-instance-attribute-request
       (clojure.core/nth args3018 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m3020]
   (clojure.core/let
    [credentials3021 (:credentials m3020) args3022 (:args m3020)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3023
      (com.palletops.awaze.common/aws-client :ec2 credentials3021)]
     (clojure.core/case
      (clojure.core/count args3022)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3023
        describeNetworkAcls))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3023
        describeNetworkAcls
        (ec2/describe-network-acls-request
         (clojure.core/nth args3022 0))))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-network-acls,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-acls,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials3025 & args3026]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3027
     (com.palletops.awaze.common/aws-client :ec2 credentials3025)]
    (clojure.core/case
     (clojure.core/count args3026)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3027
       describeNetworkAcls))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3027
       describeNetworkAcls
       (ec2/describe-network-acls-request
        (clojure.core/nth args3026 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m3028]
   (clojure.core/let
    [credentials3029 (:credentials m3028) args3030 (:args m3028)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3031
      (com.palletops.awaze.common/aws-client :ec2 credentials3029)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3031
       reportInstanceStatus
       (ec2/report-instance-status-request
        (clojure.core/nth args3030 0)))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportInstanceStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportInstanceStatus"}
   [credentials3033 & args3034]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3035
     (com.palletops.awaze.common/aws-client :ec2 credentials3033)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3035
      reportInstanceStatus
      (ec2/report-instance-status-request
       (clojure.core/nth args3034 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m3036]
   (clojure.core/let
    [credentials3037 (:credentials m3036) args3038 (:args m3036)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3039
      (com.palletops.awaze.common/aws-client :ec2 credentials3037)]
     (clojure.core/case
      (clojure.core/count args3038)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3039
        describeImages))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3039
        describeImages
        (ec2/describe-images-request (clojure.core/nth args3038 0))))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-images,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-images,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImages, describeImages"}
   [credentials3041 & args3042]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3043
     (com.palletops.awaze.common/aws-client :ec2 credentials3041)]
    (clojure.core/case
     (clojure.core/count args3042)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3043
       describeImages))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3043
       describeImages
       (ec2/describe-images-request (clojure.core/nth args3042 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-image-tasks
   [m3044]
   (clojure.core/let
    [credentials3045 (:credentials m3044) args3046 (:args m3044)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3047
      (com.palletops.awaze.common/aws-client :ec2 credentials3045)]
     (clojure.core/case
      (clojure.core/count args3046)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3047
        describeImportImageTasks
        (ec2/describe-import-image-tasks-request
         (clojure.core/nth args3046 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3047
        describeImportImageTasks))))))
  (clojure.core/defn
   describe-import-image-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeImportImageTasks, describeImportImageTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-import-image-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-import-image-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-image-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeImportImageTasks, describeImportImageTasks"}
   [credentials3049 & args3050]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3051
     (com.palletops.awaze.common/aws-client :ec2 credentials3049)]
    (clojure.core/case
     (clojure.core/count args3050)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3051
       describeImportImageTasks
       (ec2/describe-import-image-tasks-request
        (clojure.core/nth args3050 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3051
       describeImportImageTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-hosts
   [m3054]
   (clojure.core/let
    [credentials3055 (:credentials m3054) args3056 (:args m3054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3057
      (com.palletops.awaze.common/aws-client :ec2 credentials3055)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3057
       modifyHosts
       (ec2/modify-hosts-request (clojure.core/nth args3056 0)))))))
  (clojure.core/defn
   modify-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyHosts"}
   [credentials3059 & args3060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3061
     (com.palletops.awaze.common/aws-client :ec2 credentials3059)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3061
      modifyHosts
      (ec2/modify-hosts-request (clojure.core/nth args3060 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m3062]
   (clojure.core/let
    [credentials3063 (:credentials m3062) args3064 (:args m3062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3065
      (com.palletops.awaze.common/aws-client :ec2 credentials3063)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3065
       registerImage
       (ec2/register-image-request (clojure.core/nth args3064 0)))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for registerImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :register-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call registerImage"}
   [credentials3067 & args3068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3069
     (com.palletops.awaze.common/aws-client :ec2 credentials3067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3069
      registerImage
      (ec2/register-image-request (clojure.core/nth args3068 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m3070]
   (clojure.core/let
    [credentials3071 (:credentials m3070) args3072 (:args m3070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3073
      (com.palletops.awaze.common/aws-client :ec2 credentials3071)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3073
       detachVpnGateway
       (ec2/detach-vpn-gateway-request (clojure.core/nth args3072 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVpnGateway"}
   [credentials3075 & args3076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3077
     (com.palletops.awaze.common/aws-client :ec2 credentials3075)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3077
      detachVpnGateway
      (ec2/detach-vpn-gateway-request (clojure.core/nth args3076 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m3078]
   (clojure.core/let
    [credentials3079 (:credentials m3078) args3080 (:args m3078)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3081
      (com.palletops.awaze.common/aws-client :ec2 credentials3079)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3081
       deleteVolume
       (ec2/delete-volume-request (clojure.core/nth args3080 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials3083 & args3084]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3085
     (com.palletops.awaze.common/aws-client :ec2 credentials3083)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3085
      deleteVolume
      (ec2/delete-volume-request (clojure.core/nth args3084 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m3086]
   (clojure.core/let
    [credentials3087 (:credentials m3086) args3088 (:args m3086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3089
      (com.palletops.awaze.common/aws-client :ec2 credentials3087)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3089
       deleteInternetGateway
       (ec2/delete-internet-gateway-request
        (clojure.core/nth args3088 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials3091 & args3092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3093
     (com.palletops.awaze.common/aws-client :ec2 credentials3091)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3093
      deleteInternetGateway
      (ec2/delete-internet-gateway-request
       (clojure.core/nth args3092 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m3094]
   (clojure.core/let
    [credentials3095 (:credentials m3094) args3096 (:args m3094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3097
      (com.palletops.awaze.common/aws-client :ec2 credentials3095)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3097
       deleteSubnet
       (ec2/delete-subnet-request (clojure.core/nth args3096 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-subnet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSubnet"}
   [credentials3099 & args3100]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3101
     (com.palletops.awaze.common/aws-client :ec2 credentials3099)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3101
      deleteSubnet
      (ec2/delete-subnet-request (clojure.core/nth args3100 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m3102]
   (clojure.core/let
    [credentials3103 (:credentials m3102) args3104 (:args m3102)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3105
      (com.palletops.awaze.common/aws-client :ec2 credentials3103)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3105
       resetInstanceAttribute
       (ec2/reset-instance-attribute-request
        (clojure.core/nth args3104 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials3107 & args3108]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3109
     (com.palletops.awaze.common/aws-client :ec2 credentials3107)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3109
      resetInstanceAttribute
      (ec2/reset-instance-attribute-request
       (clojure.core/nth args3108 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m3110]
   (clojure.core/let
    [credentials3111 (:credentials m3110) args3112 (:args m3110)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3113
      (com.palletops.awaze.common/aws-client :ec2 credentials3111)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3113
       detachVolume
       (ec2/detach-volume-request (clojure.core/nth args3112 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVolume"}
   [credentials3115 & args3116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3117
     (com.palletops.awaze.common/aws-client :ec2 credentials3115)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3117
      detachVolume
      (ec2/detach-volume-request (clojure.core/nth args3116 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m3118]
   (clojure.core/let
    [credentials3119 (:credentials m3118) args3120 (:args m3118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3121
      (com.palletops.awaze.common/aws-client :ec2 credentials3119)]
     (clojure.core/case
      (clojure.core/count args3120)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3121
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3121
        describeExportTasks
        (ec2/describe-export-tasks-request
         (clojure.core/nth args3120 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-export-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-export-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials3123 & args3124]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3125
     (com.palletops.awaze.common/aws-client :ec2 credentials3123)]
    (clojure.core/case
     (clojure.core/count args3124)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3125
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3125
       describeExportTasks
       (ec2/describe-export-tasks-request
        (clojure.core/nth args3124 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instances
   [m3126]
   (clojure.core/let
    [credentials3127 (:credentials m3126) args3128 (:args m3126)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3129
      (com.palletops.awaze.common/aws-client :ec2 credentials3127)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3129
       describeScheduledInstances
       (ec2/describe-scheduled-instances-request
        (clojure.core/nth args3128 0)))))))
  (clojure.core/defn
   describe-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstances"}
   [credentials3131 & args3132]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3133
     (com.palletops.awaze.common/aws-client :ec2 credentials3131)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3133
      describeScheduledInstances
      (ec2/describe-scheduled-instances-request
       (clojure.core/nth args3132 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-flow-logs
   [m3134]
   (clojure.core/let
    [credentials3135 (:credentials m3134) args3136 (:args m3134)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3137
      (com.palletops.awaze.common/aws-client :ec2 credentials3135)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3137
       deleteFlowLogs
       (ec2/delete-flow-logs-request (clojure.core/nth args3136 0)))))))
  (clojure.core/defn
   delete-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteFlowLogs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteFlowLogs"}
   [credentials3139 & args3140]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3141
     (com.palletops.awaze.common/aws-client :ec2 credentials3139)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3141
      deleteFlowLogs
      (ec2/delete-flow-logs-request (clojure.core/nth args3140 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m3142]
   (clojure.core/let
    [credentials3143 (:credentials m3142) args3144 (:args m3142)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3145
      (com.palletops.awaze.common/aws-client :ec2 credentials3143)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3145
       createVpc
       (ec2/create-vpc-request (clojure.core/nth args3144 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Call createVpc"}
   [credentials3147 & args3148]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3149
     (com.palletops.awaze.common/aws-client :ec2 credentials3147)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3149
      createVpc
      (ec2/create-vpc-request (clojure.core/nth args3148 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m3150]
   (clojure.core/let
    [credentials3151 (:credentials m3150) args3152 (:args m3150)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3153
      (com.palletops.awaze.common/aws-client :ec2 credentials3151)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3153
       createSpotDatafeedSubscription
       (ec2/create-spot-datafeed-subscription-request
        (clojure.core/nth args3152 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials3155 & args3156]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3157
     (com.palletops.awaze.common/aws-client :ec2 credentials3155)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3157
      createSpotDatafeedSubscription
      (ec2/create-spot-datafeed-subscription-request
       (clojure.core/nth args3156 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link
   [m3158]
   (clojure.core/let
    [credentials3159 (:credentials m3158) args3160 (:args m3158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3161
      (com.palletops.awaze.common/aws-client :ec2 credentials3159)]
     (clojure.core/case
      (clojure.core/count args3160)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3161
        describeVpcClassicLink
        (ec2/describe-vpc-classic-link-request
         (clojure.core/nth args3160 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3161
        describeVpcClassicLink))))))
  (clojure.core/defn
   describe-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcClassicLink, describeVpcClassicLink"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcClassicLink, describeVpcClassicLink"}
   [credentials3163 & args3164]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3165
     (com.palletops.awaze.common/aws-client :ec2 credentials3163)]
    (clojure.core/case
     (clojure.core/count args3164)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3165
       describeVpcClassicLink
       (ec2/describe-vpc-classic-link-request
        (clojure.core/nth args3164 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3165
       describeVpcClassicLink))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m3166]
   (clojure.core/let
    [credentials3167 (:credentials m3166) args3168 (:args m3166)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3169
      (com.palletops.awaze.common/aws-client :ec2 credentials3167)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3169
       deleteRoute
       (ec2/delete-route-request (clojure.core/nth args3168 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRoute"}
   [credentials3171 & args3172]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3173
     (com.palletops.awaze.common/aws-client :ec2 credentials3171)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3173
      deleteRoute
      (ec2/delete-route-request (clojure.core/nth args3172 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-id-format
   [m3174]
   (clojure.core/let
    [credentials3175 (:credentials m3174) args3176 (:args m3174)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3177
      (com.palletops.awaze.common/aws-client :ec2 credentials3175)]
     (clojure.core/case
      (clojure.core/count args3176)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3177
        describeIdFormat
        (ec2/describe-id-format-request (clojure.core/nth args3176 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3177
        describeIdFormat))))))
  (clojure.core/defn
   describe-id-format-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeIdFormat, describeIdFormat"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-id-format
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeIdFormat, describeIdFormat"}
   [credentials3179 & args3180]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3181
     (com.palletops.awaze.common/aws-client :ec2 credentials3179)]
    (clojure.core/case
     (clojure.core/count args3180)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3181
       describeIdFormat
       (ec2/describe-id-format-request (clojure.core/nth args3180 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3181
       describeIdFormat))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m3182]
   (clojure.core/let
    [credentials3183 (:credentials m3182) args3184 (:args m3182)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3185
      (com.palletops.awaze.common/aws-client :ec2 credentials3183)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3185
       attachVolume
       (ec2/attach-volume-request (clojure.core/nth args3184 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVolume"}
   [credentials3187 & args3188]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3189
     (com.palletops.awaze.common/aws-client :ec2 credentials3187)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3189
      attachVolume
      (ec2/attach-volume-request (clojure.core/nth args3188 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m3190]
   (clojure.core/let
    [credentials3191 (:credentials m3190) args3192 (:args m3190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3193
      (com.palletops.awaze.common/aws-client :ec2 credentials3191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3193
       enableVolumeIO
       (ec2/enable-volume-iorequest (clojure.core/nth args3192 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-volume-io,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVolumeIO"}
   [credentials3195 & args3196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3197
     (com.palletops.awaze.common/aws-client :ec2 credentials3195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3197
      enableVolumeIO
      (ec2/enable-volume-iorequest (clojure.core/nth args3196 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m3198]
   (clojure.core/let
    [credentials3199 (:credentials m3198) args3200 (:args m3198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3201
      (com.palletops.awaze.common/aws-client :ec2 credentials3199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3201
       attachVpnGateway
       (ec2/attach-vpn-gateway-request (clojure.core/nth args3200 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVpnGateway"}
   [credentials3203 & args3204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3205
     (com.palletops.awaze.common/aws-client :ec2 credentials3203)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3205
      attachVpnGateway
      (ec2/attach-vpn-gateway-request (clojure.core/nth args3204 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m3206]
   (clojure.core/let
    [credentials3207 (:credentials m3206) args3208 (:args m3206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3209
      (com.palletops.awaze.common/aws-client :ec2 credentials3207)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3209
       replaceNetworkAclEntry
       (ec2/replace-network-acl-entry-request
        (clojure.core/nth args3208 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials3211 & args3212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3213
     (com.palletops.awaze.common/aws-client :ec2 credentials3211)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3213
      replaceNetworkAclEntry
      (ec2/replace-network-acl-entry-request
       (clojure.core/nth args3212 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m3214]
   (clojure.core/let
    [credentials3215 (:credentials m3214) args3216 (:args m3214)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3217
      (com.palletops.awaze.common/aws-client :ec2 credentials3215)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3217
       describeSnapshotAttribute
       (ec2/describe-snapshot-attribute-request
        (clojure.core/nth args3216 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials3219 & args3220]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3221
     (com.palletops.awaze.common/aws-client :ec2 credentials3219)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3221
      describeSnapshotAttribute
      (ec2/describe-snapshot-attribute-request
       (clojure.core/nth args3220 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m3222]
   (clojure.core/let
    [credentials3223 (:credentials m3222) args3224 (:args m3222)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3225
      (com.palletops.awaze.common/aws-client :ec2 credentials3223)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3225
       rebootInstances
       (ec2/reboot-instances-request (clojure.core/nth args3224 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootInstances"}
   [credentials3227 & args3228]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3229
     (com.palletops.awaze.common/aws-client :ec2 credentials3227)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3229
      rebootInstances
      (ec2/reboot-instances-request (clojure.core/nth args3228 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reject-vpc-peering-connection
   [m3230]
   (clojure.core/let
    [credentials3231 (:credentials m3230) args3232 (:args m3230)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3233
      (com.palletops.awaze.common/aws-client :ec2 credentials3231)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3233
       rejectVpcPeeringConnection
       (ec2/reject-vpc-peering-connection-request
        (clojure.core/nth args3232 0)))))))
  (clojure.core/defn
   reject-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rejectVpcPeeringConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reject-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rejectVpcPeeringConnection"}
   [credentials3235 & args3236]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3237
     (com.palletops.awaze.common/aws-client :ec2 credentials3235)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3237
      rejectVpcPeeringConnection
      (ec2/reject-vpc-peering-connection-request
       (clojure.core/nth args3236 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m3238]
   (clojure.core/let
    [credentials3239 (:credentials m3238) args3240 (:args m3238)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3241
      (com.palletops.awaze.common/aws-client :ec2 credentials3239)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3241
       createSecurityGroup
       (ec2/create-security-group-request
        (clojure.core/nth args3240 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-security-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSecurityGroup"}
   [credentials3243 & args3244]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3245
     (com.palletops.awaze.common/aws-client :ec2 credentials3243)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3245
      createSecurityGroup
      (ec2/create-security-group-request
       (clojure.core/nth args3244 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m3246]
   (clojure.core/let
    [credentials3247 (:credentials m3246) args3248 (:args m3246)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3249
      (com.palletops.awaze.common/aws-client :ec2 credentials3247)]
     (clojure.core/case
      (clojure.core/count args3248)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3249
        describeSpotInstanceRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3249
        describeSpotInstanceRequests
        (ec2/describe-spot-instance-requests-request
         (clojure.core/nth args3248 0))))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials3251 & args3252]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3253
     (com.palletops.awaze.common/aws-client :ec2 credentials3251)]
    (clojure.core/case
     (clojure.core/count args3252)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3253
       describeSpotInstanceRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3253
       describeSpotInstanceRequests
       (ec2/describe-spot-instance-requests-request
        (clojure.core/nth args3252 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m3254]
   (clojure.core/let
    [credentials3255 (:credentials m3254) args3256 (:args m3254)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3257
      (com.palletops.awaze.common/aws-client :ec2 credentials3255)]
     (clojure.core/case
      (clojure.core/count args3256)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3257
        describeSpotDatafeedSubscription
        (ec2/describe-spot-datafeed-subscription-request
         (clojure.core/nth args3256 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3257
        describeSpotDatafeedSubscription))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials3259 & args3260]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3261
     (com.palletops.awaze.common/aws-client :ec2 credentials3259)]
    (clojure.core/case
     (clojure.core/count args3260)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3261
       describeSpotDatafeedSubscription
       (ec2/describe-spot-datafeed-subscription-request
        (clojure.core/nth args3260 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3261
       describeSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :move-address-to-vpc
   [m3262]
   (clojure.core/let
    [credentials3263 (:credentials m3262) args3264 (:args m3262)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3265
      (com.palletops.awaze.common/aws-client :ec2 credentials3263)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3265
       moveAddressToVpc
       (ec2/move-address-to-vpc-request (clojure.core/nth args3264 0)))))))
  (clojure.core/defn
   move-address-to-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for moveAddressToVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :move-address-to-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   move-address-to-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call moveAddressToVpc"}
   [credentials3267 & args3268]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3269
     (com.palletops.awaze.common/aws-client :ec2 credentials3267)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3269
      moveAddressToVpc
      (ec2/move-address-to-vpc-request (clojure.core/nth args3268 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-endpoint
   [m3270]
   (clojure.core/let
    [credentials3271 (:credentials m3270) args3272 (:args m3270)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3273
      (com.palletops.awaze.common/aws-client :ec2 credentials3271)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3273
       modifyVpcEndpoint
       (ec2/modify-vpc-endpoint-request (clojure.core/nth args3272 0)))))))
  (clojure.core/defn
   modify-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Generate map for modifyVpcEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-vpc-endpoint,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Call modifyVpcEndpoint"}
   [credentials3275 & args3276]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3277
     (com.palletops.awaze.common/aws-client :ec2 credentials3275)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3277
      modifyVpcEndpoint
      (ec2/modify-vpc-endpoint-request (clojure.core/nth args3276 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m3278]
   (clojure.core/let
    [credentials3279 (:credentials m3278) args3280 (:args m3278)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3281
      (com.palletops.awaze.common/aws-client :ec2 credentials3279)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3281
       attachNetworkInterface
       (ec2/attach-network-interface-request
        (clojure.core/nth args3280 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials3283 & args3284]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3285
     (com.palletops.awaze.common/aws-client :ec2 credentials3283)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3285
      attachNetworkInterface
      (ec2/attach-network-interface-request
       (clojure.core/nth args3284 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m3286]
   (clojure.core/let
    [credentials3287 (:credentials m3286) args3288 (:args m3286)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3289
      (com.palletops.awaze.common/aws-client :ec2 credentials3287)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3289
       detachNetworkInterface
       (ec2/detach-network-interface-request
        (clojure.core/nth args3288 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials3291 & args3292]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3293
     (com.palletops.awaze.common/aws-client :ec2 credentials3291)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3293
      detachNetworkInterface
      (ec2/detach-network-interface-request
       (clojure.core/nth args3292 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m3294]
   (clojure.core/let
    [credentials3295 (:credentials m3294) args3296 (:args m3294)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3297
      (com.palletops.awaze.common/aws-client :ec2 credentials3295)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3297
       deleteDhcpOptions
       (ec2/delete-dhcp-options-request (clojure.core/nth args3296 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials3299 & args3300]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3301
     (com.palletops.awaze.common/aws-client :ec2 credentials3299)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3301
      deleteDhcpOptions
      (ec2/delete-dhcp-options-request (clojure.core/nth args3300 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoints
   [m3302]
   (clojure.core/let
    [credentials3303 (:credentials m3302) args3304 (:args m3302)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3305
      (com.palletops.awaze.common/aws-client :ec2 credentials3303)]
     (clojure.core/case
      (clojure.core/count args3304)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3305
        describeVpcEndpoints
        (ec2/describe-vpc-endpoints-request
         (clojure.core/nth args3304 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3305
        describeVpcEndpoints))))))
  (clojure.core/defn
   describe-vpc-endpoints-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVpcEndpoints, describeVpcEndpoints"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoints
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVpcEndpoints, describeVpcEndpoints"}
   [credentials3307 & args3308]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3309
     (com.palletops.awaze.common/aws-client :ec2 credentials3307)]
    (clojure.core/case
     (clojure.core/count args3308)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3309
       describeVpcEndpoints
       (ec2/describe-vpc-endpoints-request
        (clojure.core/nth args3308 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3309
       describeVpcEndpoints))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m3310]
   (clojure.core/let
    [credentials3311 (:credentials m3310) args3312 (:args m3310)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3313
      (com.palletops.awaze.common/aws-client :ec2 credentials3311)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3313
       confirmProductInstance
       (ec2/confirm-product-instance-request
        (clojure.core/nth args3312 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-product-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmProductInstance"}
   [credentials3315 & args3316]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3317
     (com.palletops.awaze.common/aws-client :ec2 credentials3315)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3317
      confirmProductInstance
      (ec2/confirm-product-instance-request
       (clojure.core/nth args3316 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m3318]
   (clojure.core/let
    [credentials3319 (:credentials m3318) args3320 (:args m3318)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3321
      (com.palletops.awaze.common/aws-client :ec2 credentials3319)]
     (clojure.core/case
      (clojure.core/count args3320)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3321
        allocateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3321
        allocateAddress
        (ec2/allocate-address-request (clojure.core/nth args3320 0))))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :allocate-address,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials3323 & args3324]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3325
     (com.palletops.awaze.common/aws-client :ec2 credentials3323)]
    (clojure.core/case
     (clojure.core/count args3324)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3325
       allocateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3325
       allocateAddress
       (ec2/allocate-address-request (clojure.core/nth args3324 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-endpoint
   [m3326]
   (clojure.core/let
    [credentials3327 (:credentials m3326) args3328 (:args m3326)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3329
      (com.palletops.awaze.common/aws-client :ec2 credentials3327)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3329
       createVpcEndpoint
       (ec2/create-vpc-endpoint-request (clojure.core/nth args3328 0)))))))
  (clojure.core/defn
   create-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createVpcEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc-endpoint,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createVpcEndpoint"}
   [credentials3331 & args3332]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3333
     (com.palletops.awaze.common/aws-client :ec2 credentials3331)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3333
      createVpcEndpoint
      (ec2/create-vpc-endpoint-request (clojure.core/nth args3332 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m3334]
   (clojure.core/let
    [credentials3335 (:credentials m3334) args3336 (:args m3334)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3337
      (com.palletops.awaze.common/aws-client :ec2 credentials3335)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3337
       importKeyPair
       (ec2/import-key-pair-request (clojure.core/nth args3336 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call importKeyPair"}
   [credentials3339 & args3340]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3341
     (com.palletops.awaze.common/aws-client :ec2 credentials3339)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3341
      importKeyPair
      (ec2/import-key-pair-request (clojure.core/nth args3340 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m3342]
   (clojure.core/let
    [credentials3343 (:credentials m3342) args3344 (:args m3342)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3345
      (com.palletops.awaze.common/aws-client :ec2 credentials3343)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3345
       copySnapshot
       (ec2/copy-snapshot-request (clojure.core/nth args3344 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Call copySnapshot"}
   [credentials3347 & args3348]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3349
     (com.palletops.awaze.common/aws-client :ec2 credentials3347)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3349
      copySnapshot
      (ec2/copy-snapshot-request (clojure.core/nth args3348 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m3350]
   (clojure.core/let
    [credentials3351 (:credentials m3350) args3352 (:args m3350)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3353
      (com.palletops.awaze.common/aws-client :ec2 credentials3351)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3353
       deleteSnapshot
       (ec2/delete-snapshot-request (clojure.core/nth args3352 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials3355 & args3356]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3357
     (com.palletops.awaze.common/aws-client :ec2 credentials3355)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3357
      deleteSnapshot
      (ec2/delete-snapshot-request (clojure.core/nth args3356 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m3358]
   (clojure.core/let
    [credentials3359 (:credentials m3358) args3360 (:args m3358)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3361
      (com.palletops.awaze.common/aws-client :ec2 credentials3359)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3361
       resetImageAttribute
       (ec2/reset-image-attribute-request
        (clojure.core/nth args3360 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetImageAttribute"}
   [credentials3363 & args3364]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3365
     (com.palletops.awaze.common/aws-client :ec2 credentials3363)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3365
      resetImageAttribute
      (ec2/reset-image-attribute-request
       (clojure.core/nth args3364 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m3366]
   (clojure.core/let
    [credentials3367 (:credentials m3366) args3368 (:args m3366)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3369
      (com.palletops.awaze.common/aws-client :ec2 credentials3367)]
     (clojure.core/case
      (clojure.core/count args3368)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3369
        createInternetGateway))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3369
        createInternetGateway
        (ec2/create-internet-gateway-request
         (clojure.core/nth args3368 0))))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials3371 & args3372]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3373
     (com.palletops.awaze.common/aws-client :ec2 credentials3371)]
    (clojure.core/case
     (clojure.core/count args3372)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3373
       createInternetGateway))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3373
       createInternetGateway
       (ec2/create-internet-gateway-request
        (clojure.core/nth args3372 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m3374]
   (clojure.core/let
    [credentials3375 (:credentials m3374) args3376 (:args m3374)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3377
      (com.palletops.awaze.common/aws-client :ec2 credentials3375)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3377
       monitorInstances
       (ec2/monitor-instances-request (clojure.core/nth args3376 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :monitor-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call monitorInstances"}
   [credentials3379 & args3380]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3381
     (com.palletops.awaze.common/aws-client :ec2 credentials3379)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3381
      monitorInstances
      (ec2/monitor-instances-request (clojure.core/nth args3380 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m3382]
   (clojure.core/let
    [credentials3383 (:credentials m3382) args3384 (:args m3382)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3385
      (com.palletops.awaze.common/aws-client :ec2 credentials3383)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3385
       revokeSecurityGroupEgress
       (ec2/revoke-security-group-egress-request
        (clojure.core/nth args3384 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-security-group-egress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials3387 & args3388]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3389
     (com.palletops.awaze.common/aws-client :ec2 credentials3387)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3389
      revokeSecurityGroupEgress
      (ec2/revoke-security-group-egress-request
       (clojure.core/nth args3388 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m3390]
   (clojure.core/let
    [credentials3391 (:credentials m3390) args3392 (:args m3390)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3393
      (com.palletops.awaze.common/aws-client :ec2 credentials3391)]
     (clojure.core/case
      (clojure.core/count args3392)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3393
        describeVpcs
        (ec2/describe-vpcs-request (clojure.core/nth args3392 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3393
        describeVpcs))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpcs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpcs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials3395 & args3396]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3397
     (com.palletops.awaze.common/aws-client :ec2 credentials3395)]
    (clojure.core/case
     (clojure.core/count args3396)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3397
       describeVpcs
       (ec2/describe-vpcs-request (clojure.core/nth args3396 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3397
       describeVpcs))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m3398]
   (clojure.core/let
    [credentials3399 (:credentials m3398) args3400 (:args m3398)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3401
      (com.palletops.awaze.common/aws-client :ec2 credentials3399)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3401
       importInstance
       (ec2/import-instance-request (clojure.core/nth args3400 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Call importInstance"}
   [credentials3403 & args3404]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3405
     (com.palletops.awaze.common/aws-client :ec2 credentials3403)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3405
      importInstance
      (ec2/import-instance-request (clojure.core/nth args3404 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m3406]
   (clojure.core/let
    [credentials3407 (:credentials m3406) args3408 (:args m3406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3409
      (com.palletops.awaze.common/aws-client :ec2 credentials3407)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3409
       copyImage
       (ec2/copy-image-request (clojure.core/nth args3408 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Call copyImage"}
   [credentials3411 & args3412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3413
     (com.palletops.awaze.common/aws-client :ec2 credentials3411)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3413
      copyImage
      (ec2/copy-image-request (clojure.core/nth args3412 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m3414]
   (clojure.core/let
    [credentials3415 (:credentials m3414) args3416 (:args m3414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3417
      (com.palletops.awaze.common/aws-client :ec2 credentials3415)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3417
       getConsoleOutput
       (ec2/get-console-output-request (clojure.core/nth args3416 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-console-output,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getConsoleOutput"}
   [credentials3419 & args3420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3421
     (com.palletops.awaze.common/aws-client :ec2 credentials3419)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3421
      getConsoleOutput
      (ec2/get-console-output-request (clojure.core/nth args3420 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m3422]
   (clojure.core/let
    [credentials3423 (:credentials m3422) args3424 (:args m3422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3425
      (com.palletops.awaze.common/aws-client :ec2 credentials3423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3425
       modifySnapshotAttribute
       (ec2/modify-snapshot-attribute-request
        (clojure.core/nth args3424 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials3427 & args3428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3429
     (com.palletops.awaze.common/aws-client :ec2 credentials3427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3429
      modifySnapshotAttribute
      (ec2/modify-snapshot-attribute-request
       (clojure.core/nth args3428 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-fleet
   [m3430]
   (clojure.core/let
    [credentials3431 (:credentials m3430) args3432 (:args m3430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3433
      (com.palletops.awaze.common/aws-client :ec2 credentials3431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3433
       requestSpotFleet
       (ec2/request-spot-fleet-request (clojure.core/nth args3432 0)))))))
  (clojure.core/defn
   request-spot-fleet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for requestSpotFleet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-spot-fleet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-fleet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call requestSpotFleet"}
   [credentials3435 & args3436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3437
     (com.palletops.awaze.common/aws-client :ec2 credentials3435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3437
      requestSpotFleet
      (ec2/request-spot-fleet-request (clojure.core/nth args3436 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :restore-address-to-classic
   [m3438]
   (clojure.core/let
    [credentials3439 (:credentials m3438) args3440 (:args m3438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3441
      (com.palletops.awaze.common/aws-client :ec2 credentials3439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3441
       restoreAddressToClassic
       (ec2/restore-address-to-classic-request
        (clojure.core/nth args3440 0)))))))
  (clojure.core/defn
   restore-address-to-classic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for restoreAddressToClassic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-address-to-classic,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   restore-address-to-classic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call restoreAddressToClassic"}
   [credentials3443 & args3444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3445
     (com.palletops.awaze.common/aws-client :ec2 credentials3443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3445
      restoreAddressToClassic
      (ec2/restore-address-to-classic-request
       (clojure.core/nth args3444 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-subnet-attribute
   [m3446]
   (clojure.core/let
    [credentials3447 (:credentials m3446) args3448 (:args m3446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3449
      (com.palletops.awaze.common/aws-client :ec2 credentials3447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3449
       modifySubnetAttribute
       (ec2/modify-subnet-attribute-request
        (clojure.core/nth args3448 0)))))))
  (clojure.core/defn
   modify-subnet-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySubnetAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-subnet-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-subnet-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySubnetAttribute"}
   [credentials3451 & args3452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3453
     (com.palletops.awaze.common/aws-client :ec2 credentials3451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3453
      modifySubnetAttribute
      (ec2/modify-subnet-attribute-request
       (clojure.core/nth args3452 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m3454]
   (clojure.core/let
    [credentials3455 (:credentials m3454) args3456 (:args m3454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3457
      (com.palletops.awaze.common/aws-client :ec2 credentials3455)]
     (clojure.core/case
      (clojure.core/count args3456)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3457
        describeConversionTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3457
        describeConversionTasks
        (ec2/describe-conversion-tasks-request
         (clojure.core/nth args3456 0))))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-conversion-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-conversion-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials3459 & args3460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3461
     (com.palletops.awaze.common/aws-client :ec2 credentials3459)]
    (clojure.core/case
     (clojure.core/count args3460)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3461
       describeConversionTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3461
       describeConversionTasks
       (ec2/describe-conversion-tasks-request
        (clojure.core/nth args3460 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m3462]
   (clojure.core/let
    [credentials3463 (:credentials m3462) args3464 (:args m3462)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3465
      (com.palletops.awaze.common/aws-client :ec2 credentials3463)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3465
       authorizeSecurityGroupEgress
       (ec2/authorize-security-group-egress-request
        (clojure.core/nth args3464 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-security-group-egress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials3467 & args3468]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3469
     (com.palletops.awaze.common/aws-client :ec2 credentials3467)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3469
      authorizeSecurityGroupEgress
      (ec2/authorize-security-group-egress-request
       (clojure.core/nth args3468 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m3470]
   (clojure.core/let
    [credentials3471 (:credentials m3470) args3472 (:args m3470)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3473
      (com.palletops.awaze.common/aws-client :ec2 credentials3471)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3473
       authorizeSecurityGroupIngress
       (ec2/authorize-security-group-ingress-request
        (clojure.core/nth args3472 0)))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupIngress"}
   [credentials3475 & args3476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3477
     (com.palletops.awaze.common/aws-client :ec2 credentials3475)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3477
      authorizeSecurityGroupIngress
      (ec2/authorize-security-group-ingress-request
       (clojure.core/nth args3476 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m3478]
   (clojure.core/let
    [credentials3479 (:credentials m3478) args3480 (:args m3478)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3481
      (com.palletops.awaze.common/aws-client :ec2 credentials3479)]
     (clojure.core/case
      (clojure.core/count args3480)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3481
        describeAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3481
        describeAddresses
        (ec2/describe-addresses-request (clojure.core/nth args3480 0))))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials3483 & args3484]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3485
     (com.palletops.awaze.common/aws-client :ec2 credentials3483)]
    (clojure.core/case
     (clojure.core/count args3484)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3485
       describeAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3485
       describeAddresses
       (ec2/describe-addresses-request (clojure.core/nth args3484 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m3486]
   (clojure.core/let
    [credentials3487 (:credentials m3486) args3488 (:args m3486)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3489
      (com.palletops.awaze.common/aws-client :ec2 credentials3487)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3489
       createVpnConnectionRoute
       (ec2/create-vpn-connection-route-request
        (clojure.core/nth args3488 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-connection-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials3491 & args3492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3493
     (com.palletops.awaze.common/aws-client :ec2 credentials3491)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3493
      createVpnConnectionRoute
      (ec2/create-vpn-connection-route-request
       (clojure.core/nth args3492 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m3494]
   (clojure.core/let
    [credentials3495 (:credentials m3494) args3496 (:args m3494)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3497
      (com.palletops.awaze.common/aws-client :ec2 credentials3495)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3497
       associateAddress
       (ec2/associate-address-request (clojure.core/nth args3496 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call associateAddress"}
   [credentials3499 & args3500]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3501
     (com.palletops.awaze.common/aws-client :ec2 credentials3499)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3501
      associateAddress
      (ec2/associate-address-request (clojure.core/nth args3500 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m3502]
   (clojure.core/let
    [credentials3503 (:credentials m3502) args3504 (:args m3502)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3505
      (com.palletops.awaze.common/aws-client :ec2 credentials3503)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3505
       createInstanceExportTask
       (ec2/create-instance-export-task-request
        (clojure.core/nth args3504 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-instance-export-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials3507 & args3508]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3509
     (com.palletops.awaze.common/aws-client :ec2 credentials3507)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3509
      createInstanceExportTask
      (ec2/create-instance-export-task-request
       (clojure.core/nth args3508 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m3510]
   (clojure.core/let
    [credentials3511 (:credentials m3510) args3512 (:args m3510)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3513
      (com.palletops.awaze.common/aws-client :ec2 credentials3511)]
     (clojure.core/case
      (clojure.core/count args3512)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3513
        describeKeyPairs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3513
        describeKeyPairs
        (ec2/describe-key-pairs-request (clojure.core/nth args3512 0))))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-key-pairs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-key-pairs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials3515 & args3516]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3517
     (com.palletops.awaze.common/aws-client :ec2 credentials3515)]
    (clojure.core/case
     (clojure.core/count args3516)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3517
       describeKeyPairs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3517
       describeKeyPairs
       (ec2/describe-key-pairs-request (clojure.core/nth args3516 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-requests
   [m3518]
   (clojure.core/let
    [credentials3519 (:credentials m3518) args3520 (:args m3518)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3521
      (com.palletops.awaze.common/aws-client :ec2 credentials3519)]
     (clojure.core/case
      (clojure.core/count args3520)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3521
        describeSpotFleetRequests
        (ec2/describe-spot-fleet-requests-request
         (clojure.core/nth args3520 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3521
        describeSpotFleetRequests))))))
  (clojure.core/defn
   describe-spot-fleet-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSpotFleetRequests, describeSpotFleetRequests"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeSpotFleetRequests, describeSpotFleetRequests"}
   [credentials3523 & args3524]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3525
     (com.palletops.awaze.common/aws-client :ec2 credentials3523)]
    (clojure.core/case
     (clojure.core/count args3524)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3525
       describeSpotFleetRequests
       (ec2/describe-spot-fleet-requests-request
        (clojure.core/nth args3524 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3525
       describeSpotFleetRequests))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m3526]
   (clojure.core/let
    [credentials3527 (:credentials m3526) args3528 (:args m3526)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3529
      (com.palletops.awaze.common/aws-client :ec2 credentials3527)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3529
       describeImageAttribute
       (ec2/describe-image-attribute-request
        (clojure.core/nth args3528 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImageAttribute"}
   [credentials3531 & args3532]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3533
     (com.palletops.awaze.common/aws-client :ec2 credentials3531)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3533
      describeImageAttribute
      (ec2/describe-image-attribute-request
       (clojure.core/nth args3532 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-moving-addresses
   [m3534]
   (clojure.core/let
    [credentials3535 (:credentials m3534) args3536 (:args m3534)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3537
      (com.palletops.awaze.common/aws-client :ec2 credentials3535)]
     (clojure.core/case
      (clojure.core/count args3536)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3537
        describeMovingAddresses
        (ec2/describe-moving-addresses-request
         (clojure.core/nth args3536 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3537
        describeMovingAddresses))))))
  (clojure.core/defn
   describe-moving-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeMovingAddresses, describeMovingAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-moving-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-moving-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-moving-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeMovingAddresses, describeMovingAddresses"}
   [credentials3539 & args3540]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3541
     (com.palletops.awaze.common/aws-client :ec2 credentials3539)]
    (clojure.core/case
     (clojure.core/count args3540)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3541
       describeMovingAddresses
       (ec2/describe-moving-addresses-request
        (clojure.core/nth args3540 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3541
       describeMovingAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m3542]
   (clojure.core/let
    [credentials3543 (:credentials m3542) args3544 (:args m3542)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3545
      (com.palletops.awaze.common/aws-client :ec2 credentials3543)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3545
       deleteNetworkAcl
       (ec2/delete-network-acl-request (clojure.core/nth args3544 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-acl,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials3547 & args3548]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3549
     (com.palletops.awaze.common/aws-client :ec2 credentials3547)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3549
      deleteNetworkAcl
      (ec2/delete-network-acl-request (clojure.core/nth args3548 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m3550]
   (clojure.core/let
    [credentials3551 (:credentials m3550) args3552 (:args m3550)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3553
      (com.palletops.awaze.common/aws-client :ec2 credentials3551)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3553
       deleteNetworkInterface
       (ec2/delete-network-interface-request
        (clojure.core/nth args3552 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials3555 & args3556]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3557
     (com.palletops.awaze.common/aws-client :ec2 credentials3555)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3557
      deleteNetworkInterface
      (ec2/delete-network-interface-request
       (clojure.core/nth args3556 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m3558]
   (clojure.core/let
    [credentials3559 (:credentials m3558) args3560 (:args m3558)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3561
      (com.palletops.awaze.common/aws-client :ec2 credentials3559)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3561
       deleteVpnConnection
       (ec2/delete-vpn-connection-request
        (clojure.core/nth args3560 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials3563 & args3564]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3565
     (com.palletops.awaze.common/aws-client :ec2 credentials3563)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3565
      deleteVpnConnection
      (ec2/delete-vpn-connection-request
       (clojure.core/nth args3564 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-scheduled-instances
   [m3566]
   (clojure.core/let
    [credentials3567 (:credentials m3566) args3568 (:args m3566)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3569
      (com.palletops.awaze.common/aws-client :ec2 credentials3567)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3569
       purchaseScheduledInstances
       (ec2/purchase-scheduled-instances-request
        (clojure.core/nth args3568 0)))))))
  (clojure.core/defn
   purchase-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for purchaseScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call purchaseScheduledInstances"}
   [credentials3571 & args3572]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3573
     (com.palletops.awaze.common/aws-client :ec2 credentials3571)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3573
      purchaseScheduledInstances
      (ec2/purchase-scheduled-instances-request
       (clojure.core/nth args3572 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m3574]
   (clojure.core/let
    [credentials3575 (:credentials m3574) args3576 (:args m3574)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3577
      (com.palletops.awaze.common/aws-client :ec2 credentials3575)]
     (clojure.core/case
      (clojure.core/count args3576)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3577
        describeReservedInstancesModifications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3577
        describeReservedInstancesModifications
        (ec2/describe-reserved-instances-modifications-request
         (clojure.core/nth args3576 0))))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials3579 & args3580]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3581
     (com.palletops.awaze.common/aws-client :ec2 credentials3579)]
    (clojure.core/case
     (clojure.core/count args3580)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3581
       describeReservedInstancesModifications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3581
       describeReservedInstancesModifications
       (ec2/describe-reserved-instances-modifications-request
        (clojure.core/nth args3580 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-classic-link-instances
   [m3582]
   (clojure.core/let
    [credentials3583 (:credentials m3582) args3584 (:args m3582)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3585
      (com.palletops.awaze.common/aws-client :ec2 credentials3583)]
     (clojure.core/case
      (clojure.core/count args3584)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3585
        describeClassicLinkInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3585
        describeClassicLinkInstances
        (ec2/describe-classic-link-instances-request
         (clojure.core/nth args3584 0))))))))
  (clojure.core/defn
   describe-classic-link-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeClassicLinkInstances, describeClassicLinkInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-classic-link-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-classic-link-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-classic-link-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeClassicLinkInstances, describeClassicLinkInstances"}
   [credentials3587 & args3588]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3589
     (com.palletops.awaze.common/aws-client :ec2 credentials3587)]
    (clojure.core/case
     (clojure.core/count args3588)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3589
       describeClassicLinkInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3589
       describeClassicLinkInstances
       (ec2/describe-classic-link-instances-request
        (clojure.core/nth args3588 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m3590]
   (clojure.core/let
    [credentials3591 (:credentials m3590) args3592 (:args m3590)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3593
      (com.palletops.awaze.common/aws-client :ec2 credentials3591)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3593
       purchaseReservedInstancesOffering
       (ec2/purchase-reserved-instances-offering-request
        (clojure.core/nth args3592 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials3595 & args3596]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3597
     (com.palletops.awaze.common/aws-client :ec2 credentials3595)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3597
      purchaseReservedInstancesOffering
      (ec2/purchase-reserved-instances-offering-request
       (clojure.core/nth args3596 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m3598]
   (clojure.core/let
    [credentials3599 (:credentials m3598) args3600 (:args m3598)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3601
      (com.palletops.awaze.common/aws-client :ec2 credentials3599)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3601
       startInstances
       (ec2/start-instances-request (clojure.core/nth args3600 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :start-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call startInstances"}
   [credentials3603 & args3604]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3605
     (com.palletops.awaze.common/aws-client :ec2 credentials3603)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3605
      startInstances
      (ec2/start-instances-request (clojure.core/nth args3604 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m3606]
   (clojure.core/let
    [credentials3607 (:credentials m3606) args3608 (:args m3606)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3609
      (com.palletops.awaze.common/aws-client :ec2 credentials3607)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3609
       describeInstanceAttribute
       (ec2/describe-instance-attribute-request
        (clojure.core/nth args3608 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials3611 & args3612]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3613
     (com.palletops.awaze.common/aws-client :ec2 credentials3611)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3613
      describeInstanceAttribute
      (ec2/describe-instance-attribute-request
       (clojure.core/nth args3612 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-fleet-requests
   [m3614]
   (clojure.core/let
    [credentials3615 (:credentials m3614) args3616 (:args m3614)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3617
      (com.palletops.awaze.common/aws-client :ec2 credentials3615)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3617
       cancelSpotFleetRequests
       (ec2/cancel-spot-fleet-requests-request
        (clojure.core/nth args3616 0)))))))
  (clojure.core/defn
   cancel-spot-fleet-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Generate map for cancelSpotFleetRequests"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-fleet-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Call cancelSpotFleetRequests"}
   [credentials3619 & args3620]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3621
     (com.palletops.awaze.common/aws-client :ec2 credentials3619)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3621
      cancelSpotFleetRequests
      (ec2/cancel-spot-fleet-requests-request
       (clojure.core/nth args3620 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m3622]
   (clojure.core/let
    [credentials3623 (:credentials m3622) args3624 (:args m3622)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3625
      (com.palletops.awaze.common/aws-client :ec2 credentials3623)]
     (clojure.core/case
      (clojure.core/count args3624)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3625
        describeSubnets))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3625
        describeSubnets
        (ec2/describe-subnets-request (clojure.core/nth args3624 0))))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-subnets,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-subnets,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials3627 & args3628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3629
     (com.palletops.awaze.common/aws-client :ec2 credentials3627)]
    (clojure.core/case
     (clojure.core/count args3628)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3629
       describeSubnets))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3629
       describeSubnets
       (ec2/describe-subnets-request (clojure.core/nth args3628 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m3630]
   (clojure.core/let
    [credentials3631 (:credentials m3630) args3632 (:args m3630)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3633
      (com.palletops.awaze.common/aws-client :ec2 credentials3631)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3633
       createVolume
       (ec2/create-volume-request (clojure.core/nth args3632 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Call createVolume"}
   [credentials3635 & args3636]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3637
     (com.palletops.awaze.common/aws-client :ec2 credentials3635)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3637
      createVolume
      (ec2/create-volume-request (clojure.core/nth args3636 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m3638]
   (clojure.core/let
    [credentials3639 (:credentials m3638) args3640 (:args m3638)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3641
      (com.palletops.awaze.common/aws-client :ec2 credentials3639)]
     (clojure.core/case
      (clojure.core/count args3640)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3641
        describeReservedInstancesListings
        (ec2/describe-reserved-instances-listings-request
         (clojure.core/nth args3640 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3641
        describeReservedInstancesListings))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials3643 & args3644]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3645
     (com.palletops.awaze.common/aws-client :ec2 credentials3643)]
    (clojure.core/case
     (clojure.core/count args3644)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3645
       describeReservedInstancesListings
       (ec2/describe-reserved-instances-listings-request
        (clojure.core/nth args3644 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3645
       describeReservedInstancesListings))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m3646]
   (clojure.core/let
    [credentials3647 (:credentials m3646) args3648 (:args m3646)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3649
      (com.palletops.awaze.common/aws-client :ec2 credentials3647)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3649
       createDhcpOptions
       (ec2/create-dhcp-options-request (clojure.core/nth args3648 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Call createDhcpOptions"}
   [credentials3651 & args3652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3653
     (com.palletops.awaze.common/aws-client :ec2 credentials3651)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3653
      createDhcpOptions
      (ec2/create-dhcp-options-request (clojure.core/nth args3652 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m3654]
   (clojure.core/let
    [credentials3655 (:credentials m3654) args3656 (:args m3654)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3657
      (com.palletops.awaze.common/aws-client :ec2 credentials3655)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3657
       detachInternetGateway
       (ec2/detach-internet-gateway-request
        (clojure.core/nth args3656 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call detachInternetGateway"}
   [credentials3659 & args3660]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3661
     (com.palletops.awaze.common/aws-client :ec2 credentials3659)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3661
      detachInternetGateway
      (ec2/detach-internet-gateway-request
       (clojure.core/nth args3660 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m3662]
   (clojure.core/let
    [credentials3663 (:credentials m3662) args3664 (:args m3662)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3665
      (com.palletops.awaze.common/aws-client :ec2 credentials3663)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3665
       deleteVpnGateway
       (ec2/delete-vpn-gateway-request (clojure.core/nth args3664 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials3667 & args3668]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3669
     (com.palletops.awaze.common/aws-client :ec2 credentials3667)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3669
      deleteVpnGateway
      (ec2/delete-vpn-gateway-request (clojure.core/nth args3668 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m3670]
   (clojure.core/let
    [credentials3671 (:credentials m3670) args3672 (:args m3670)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3673
      (com.palletops.awaze.common/aws-client :ec2 credentials3671)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3673
       requestSpotInstances
       (ec2/request-spot-instances-request
        (clojure.core/nth args3672 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-spot-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call requestSpotInstances"}
   [credentials3675 & args3676]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3677
     (com.palletops.awaze.common/aws-client :ec2 credentials3675)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3677
      requestSpotInstances
      (ec2/request-spot-instances-request
       (clojure.core/nth args3676 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m3678]
   (clojure.core/let
    [credentials3679 (:credentials m3678) args3680 (:args m3678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3681
      (com.palletops.awaze.common/aws-client :ec2 credentials3679)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3681
       importVolume
       (ec2/import-volume-request (clojure.core/nth args3680 0)))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Call importVolume"}
   [credentials3683 & args3684]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3685
     (com.palletops.awaze.common/aws-client :ec2 credentials3683)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3685
      importVolume
      (ec2/import-volume-request (clojure.core/nth args3684 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-snapshot
   [m3686]
   (clojure.core/let
    [credentials3687 (:credentials m3686) args3688 (:args m3686)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3689
      (com.palletops.awaze.common/aws-client :ec2 credentials3687)]
     (clojure.core/case
      (clojure.core/count args3688)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3689
        importSnapshot))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3689
        importSnapshot
        (ec2/import-snapshot-request (clojure.core/nth args3688 0))))))))
  (clojure.core/defn
   import-snapshot-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]]),
    :doc "Generate map for importSnapshot, importSnapshot"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :import-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-snapshot
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]]),
    :doc "Call importSnapshot, importSnapshot"}
   [credentials3691 & args3692]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3693
     (com.palletops.awaze.common/aws-client :ec2 credentials3691)]
    (clojure.core/case
     (clojure.core/count args3692)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3693
       importSnapshot))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3693
       importSnapshot
       (ec2/import-snapshot-request (clojure.core/nth args3692 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m3694]
   (clojure.core/let
    [credentials3695 (:credentials m3694) args3696 (:args m3694)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3697
      (com.palletops.awaze.common/aws-client :ec2 credentials3695)]
     (clojure.core/case
      (clojure.core/count args3696)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3697
        describeTags
        (ec2/describe-tags-request (clojure.core/nth args3696 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3697
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials3699 & args3700]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3701
     (com.palletops.awaze.common/aws-client :ec2 credentials3699)]
    (clojure.core/case
     (clojure.core/count args3700)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3701
       describeTags
       (ec2/describe-tags-request (clojure.core/nth args3700 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3701
       describeTags))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m3702]
   (clojure.core/let
    [credentials3703 (:credentials m3702) args3704 (:args m3702)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3705
      (com.palletops.awaze.common/aws-client :ec2 credentials3703)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3705
       deleteTags
       (ec2/delete-tags-request (clojure.core/nth args3704 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials3707 & args3708]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3709
     (com.palletops.awaze.common/aws-client :ec2 credentials3707)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3709
      deleteTags
      (ec2/delete-tags-request (clojure.core/nth args3708 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link
   [m3710]
   (clojure.core/let
    [credentials3711 (:credentials m3710) args3712 (:args m3710)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3713
      (com.palletops.awaze.common/aws-client :ec2 credentials3711)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3713
       enableVpcClassicLink
       (ec2/enable-vpc-classic-link-request
        (clojure.core/nth args3712 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLink"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLink"}
   [credentials3715 & args3716]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3717
     (com.palletops.awaze.common/aws-client :ec2 credentials3715)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3717
      enableVpcClassicLink
      (ec2/enable-vpc-classic-link-request
       (clojure.core/nth args3716 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m3718]
   (clojure.core/let
    [credentials3719 (:credentials m3718) args3720 (:args m3718)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3721
      (com.palletops.awaze.common/aws-client :ec2 credentials3719)]
     (clojure.core/case
      (clojure.core/count args3720)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3721
        describeReservedInstancesOfferings
        (ec2/describe-reserved-instances-offerings-request
         (clojure.core/nth args3720 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3721
        describeReservedInstancesOfferings))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]
                [credentials]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials3723 & args3724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3725
     (com.palletops.awaze.common/aws-client :ec2 credentials3723)]
    (clojure.core/case
     (clojure.core/count args3724)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3725
       describeReservedInstancesOfferings
       (ec2/describe-reserved-instances-offerings-request
        (clojure.core/nth args3724 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3725
       describeReservedInstancesOfferings))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m3726]
   (clojure.core/let
    [credentials3727 (:credentials m3726) args3728 (:args m3726)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3729
      (com.palletops.awaze.common/aws-client :ec2 credentials3727)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3729
       createVpnGateway
       (ec2/create-vpn-gateway-request (clojure.core/nth args3728 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnGateway"}
   [credentials3731 & args3732]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3733
     (com.palletops.awaze.common/aws-client :ec2 credentials3731)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3733
      createVpnGateway
      (ec2/create-vpn-gateway-request (clojure.core/nth args3732 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m3734]
   (clojure.core/let
    [credentials3735 (:credentials m3734) args3736 (:args m3734)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3737
      (com.palletops.awaze.common/aws-client :ec2 credentials3735)]
     (clojure.core/case
      (clojure.core/count args3736)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3737
        describeRouteTables
        (ec2/describe-route-tables-request
         (clojure.core/nth args3736 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3737
        describeRouteTables))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-route-tables,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-route-tables,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials3739 & args3740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3741
     (com.palletops.awaze.common/aws-client :ec2 credentials3739)]
    (clojure.core/case
     (clojure.core/count args3740)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3741
       describeRouteTables
       (ec2/describe-route-tables-request
        (clojure.core/nth args3740 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3741
       describeRouteTables))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m3742]
   (clojure.core/let
    [credentials3743 (:credentials m3742) args3744 (:args m3742)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3745
      (com.palletops.awaze.common/aws-client :ec2 credentials3743)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3745
       cancelSpotInstanceRequests
       (ec2/cancel-spot-instance-requests-request
        (clojure.core/nth args3744 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials3747 & args3748]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3749
     (com.palletops.awaze.common/aws-client :ec2 credentials3747)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3749
      cancelSpotInstanceRequests
      (ec2/cancel-spot-instance-requests-request
       (clojure.core/nth args3748 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m3750]
   (clojure.core/let
    [credentials3751 (:credentials m3750) args3752 (:args m3750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3753
      (com.palletops.awaze.common/aws-client :ec2 credentials3751)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3753
       assignPrivateIpAddresses
       (ec2/assign-private-ip-addresses-request
        (clojure.core/nth args3752 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assign-private-ip-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials3755 & args3756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3757
     (com.palletops.awaze.common/aws-client :ec2 credentials3755)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3757
      assignPrivateIpAddresses
      (ec2/assign-private-ip-addresses-request
       (clojure.core/nth args3756 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link-dns-support
   [m3758]
   (clojure.core/let
    [credentials3759 (:credentials m3758) args3760 (:args m3758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3761
      (com.palletops.awaze.common/aws-client :ec2 credentials3759)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3761
       disableVpcClassicLinkDnsSupport
       (ec2/disable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3760 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLinkDnsSupport"}
   [credentials3763 & args3764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3765
     (com.palletops.awaze.common/aws-client :ec2 credentials3763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3765
      disableVpcClassicLinkDnsSupport
      (ec2/disable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3764 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m3766]
   (clojure.core/let
    [credentials3767 (:credentials m3766) args3768 (:args m3766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3769
      (com.palletops.awaze.common/aws-client :ec2 credentials3767)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3769
       deletePlacementGroup
       (ec2/delete-placement-group-request
        (clojure.core/nth args3768 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-placement-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials3771 & args3772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3773
     (com.palletops.awaze.common/aws-client :ec2 credentials3771)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3773
      deletePlacementGroup
      (ec2/delete-placement-group-request
       (clojure.core/nth args3772 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m3774]
   (clojure.core/let
    [credentials3775 (:credentials m3774) args3776 (:args m3774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3777
      (com.palletops.awaze.common/aws-client :ec2 credentials3775)]
     (clojure.core/case
      (clojure.core/count args3776)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3777
        describeInstances
        (ec2/describe-instances-request (clojure.core/nth args3776 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3777
        describeInstances))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials3779 & args3780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3781
     (com.palletops.awaze.common/aws-client :ec2 credentials3779)]
    (clojure.core/case
     (clojure.core/count args3780)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3781
       describeInstances
       (ec2/describe-instances-request (clojure.core/nth args3780 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3781
       describeInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m3782]
   (clojure.core/let
    [credentials3783 (:credentials m3782) args3784 (:args m3782)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3785
      (com.palletops.awaze.common/aws-client :ec2 credentials3783)]
     (clojure.core/case
      (clojure.core/count args3784)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3785
        describeVolumes
        (ec2/describe-volumes-request (clojure.core/nth args3784 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3785
        describeVolumes))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-volumes,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volumes,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials3787 & args3788]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3789
     (com.palletops.awaze.common/aws-client :ec2 credentials3787)]
    (clojure.core/case
     (clojure.core/count args3788)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3789
       describeVolumes
       (ec2/describe-volumes-request (clojure.core/nth args3788 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3789
       describeVolumes))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m3790]
   (clojure.core/let
    [credentials3791 (:credentials m3790) args3792 (:args m3790)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3793
      (com.palletops.awaze.common/aws-client :ec2 credentials3791)]
     (clojure.core/case
      (clojure.core/count args3792)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3793
        describeBundleTasks
        (ec2/describe-bundle-tasks-request
         (clojure.core/nth args3792 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3793
        describeBundleTasks))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]
                [credentials]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-bundle-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-bundle-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]
                [credentials]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials3795 & args3796]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3797
     (com.palletops.awaze.common/aws-client :ec2 credentials3795)]
    (clojure.core/case
     (clojure.core/count args3796)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3797
       describeBundleTasks
       (ec2/describe-bundle-tasks-request
        (clojure.core/nth args3796 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3797
       describeBundleTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m3798]
   (clojure.core/let
    [credentials3799 (:credentials m3798) args3800 (:args m3798)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3801
      (com.palletops.awaze.common/aws-client :ec2 credentials3799)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3801
       associateDhcpOptions
       (ec2/associate-dhcp-options-request
        (clojure.core/nth args3800 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials3803 & args3804]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3805
     (com.palletops.awaze.common/aws-client :ec2 credentials3803)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3805
      associateDhcpOptions
      (ec2/associate-dhcp-options-request
       (clojure.core/nth args3804 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m3806]
   (clojure.core/let
    [credentials3807 (:credentials m3806) args3808 (:args m3806)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3809
      (com.palletops.awaze.common/aws-client :ec2 credentials3807)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3809
       modifyVpcAttribute
       (ec2/modify-vpc-attribute-request
        (clojure.core/nth args3808 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-vpc-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials3811 & args3812]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3813
     (com.palletops.awaze.common/aws-client :ec2 credentials3811)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3813
      modifyVpcAttribute
      (ec2/modify-vpc-attribute-request (clojure.core/nth args3812 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-flow-logs
   [m3814]
   (clojure.core/let
    [credentials3815 (:credentials m3814) args3816 (:args m3814)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3817
      (com.palletops.awaze.common/aws-client :ec2 credentials3815)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3817
       createFlowLogs
       (ec2/create-flow-logs-request (clojure.core/nth args3816 0)))))))
  (clojure.core/defn
   create-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createFlowLogs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createFlowLogs"}
   [credentials3819 & args3820]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3821
     (com.palletops.awaze.common/aws-client :ec2 credentials3819)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3821
      createFlowLogs
      (ec2/create-flow-logs-request (clojure.core/nth args3820 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m3822]
   (clojure.core/let
    [credentials3823 (:credentials m3822) args3824 (:args m3822)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3825
      (com.palletops.awaze.common/aws-client :ec2 credentials3823)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3825
       disassociateAddress
       (ec2/disassociate-address-request
        (clojure.core/nth args3824 0)))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for disassociateAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call disassociateAddress"}
   [credentials3827 & args3828]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3829
     (com.palletops.awaze.common/aws-client :ec2 credentials3827)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3829
      disassociateAddress
      (ec2/disassociate-address-request (clojure.core/nth args3828 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m3830]
   (clojure.core/let
    [credentials3831 (:credentials m3830) args3832 (:args m3830)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3833
      (com.palletops.awaze.common/aws-client :ec2 credentials3831)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3833
       resetNetworkInterfaceAttribute
       (ec2/reset-network-interface-attribute-request
        (clojure.core/nth args3832 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials3835 & args3836]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3837
     (com.palletops.awaze.common/aws-client :ec2 credentials3835)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3837
      resetNetworkInterfaceAttribute
      (ec2/reset-network-interface-attribute-request
       (clojure.core/nth args3836 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m3838]
   (clojure.core/let
    [credentials3839 (:credentials m3838) args3840 (:args m3838)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3841
      (com.palletops.awaze.common/aws-client :ec2 credentials3839)]
     (clojure.core/case
      (clojure.core/count args3840)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3841
        describePlacementGroups
        (ec2/describe-placement-groups-request
         (clojure.core/nth args3840 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3841
        describePlacementGroups))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-placement-groups,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-placement-groups,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials3843 & args3844]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3845
     (com.palletops.awaze.common/aws-client :ec2 credentials3843)]
    (clojure.core/case
     (clojure.core/count args3844)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3845
       describePlacementGroups
       (ec2/describe-placement-groups-request
        (clojure.core/nth args3844 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3845
       describePlacementGroups))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m3846]
   (clojure.core/let
    [credentials3847 (:credentials m3846) args3848 (:args m3846)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3849
      (com.palletops.awaze.common/aws-client :ec2 credentials3847)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3849
       resetSnapshotAttribute
       (ec2/reset-snapshot-attribute-request
        (clojure.core/nth args3848 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials3851 & args3852]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3853
     (com.palletops.awaze.common/aws-client :ec2 credentials3851)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3853
      resetSnapshotAttribute
      (ec2/reset-snapshot-attribute-request
       (clojure.core/nth args3852 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m3854]
   (clojure.core/let
    [credentials3855 (:credentials m3854) args3856 (:args m3854)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3857
      (com.palletops.awaze.common/aws-client :ec2 credentials3855)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3857
       releaseAddress
       (ec2/release-address-request (clojure.core/nth args3856 0)))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for releaseAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :release-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call releaseAddress"}
   [credentials3859 & args3860]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3861
     (com.palletops.awaze.common/aws-client :ec2 credentials3859)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3861
      releaseAddress
      (ec2/release-address-request (clojure.core/nth args3860 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m3862]
   (clojure.core/let
    [credentials3863 (:credentials m3862) args3864 (:args m3862)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3865
      (com.palletops.awaze.common/aws-client :ec2 credentials3863)]
     (clojure.core/case
      (clojure.core/count args3864)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3865
        describeVolumeStatus
        (ec2/describe-volume-status-request
         (clojure.core/nth args3864 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3865
        describeVolumeStatus))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-volume-status,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volume-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials3867 & args3868]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3869
     (com.palletops.awaze.common/aws-client :ec2 credentials3867)]
    (clojure.core/case
     (clojure.core/count args3868)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3869
       describeVolumeStatus
       (ec2/describe-volume-status-request
        (clojure.core/nth args3868 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3869
       describeVolumeStatus))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m3870]
   (clojure.core/let
    [credentials3871 (:credentials m3870) args3872 (:args m3870)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3873
      (com.palletops.awaze.common/aws-client :ec2 credentials3871)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3873
       bundleInstance
       (ec2/bundle-instance-request (clojure.core/nth args3872 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :bundle-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Call bundleInstance"}
   [credentials3875 & args3876]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3877
     (com.palletops.awaze.common/aws-client :ec2 credentials3875)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3877
      bundleInstance
      (ec2/bundle-instance-request (clojure.core/nth args3876 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m3878]
   (clojure.core/let
    [credentials3879 (:credentials m3878) args3880 (:args m3878)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3881
      (com.palletops.awaze.common/aws-client :ec2 credentials3879)]
     (clojure.core/case
      (clojure.core/count args3880)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3881
        describeVpnConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3881
        describeVpnConnections
        (ec2/describe-vpn-connections-request
         (clojure.core/nth args3880 0))))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpn-connections,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpn-connections,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials3883 & args3884]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3885
     (com.palletops.awaze.common/aws-client :ec2 credentials3883)]
    (clojure.core/case
     (clojure.core/count args3884)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3885
       describeVpnConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3885
       describeVpnConnections
       (ec2/describe-vpn-connections-request
        (clojure.core/nth args3884 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m3886]
   (clojure.core/let
    [credentials3887 (:credentials m3886) args3888 (:args m3886)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3889
      (com.palletops.awaze.common/aws-client :ec2 credentials3887)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3889
       createRoute
       (ec2/create-route-request (clojure.core/nth args3888 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call createRoute"}
   [credentials3891 & args3892]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3893
     (com.palletops.awaze.common/aws-client :ec2 credentials3891)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3893
      createRoute
      (ec2/create-route-request (clojure.core/nth args3892 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m3894]
   (clojure.core/let
    [credentials3895 (:credentials m3894) args3896 (:args m3894)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3897
      (com.palletops.awaze.common/aws-client :ec2 credentials3895)]
     (clojure.core/case
      (clojure.core/count args3896)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3897
        describeSpotPriceHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3897
        describeSpotPriceHistory
        (ec2/describe-spot-price-history-request
         (clojure.core/nth args3896 0))))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-price-history,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-price-history,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials3899 & args3900]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3901
     (com.palletops.awaze.common/aws-client :ec2 credentials3899)]
    (clojure.core/case
     (clojure.core/count args3900)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3901
       describeSpotPriceHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3901
       describeSpotPriceHistory
       (ec2/describe-spot-price-history-request
        (clojure.core/nth args3900 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m3902]
   (clojure.core/let
    [credentials3903 (:credentials m3902) args3904 (:args m3902)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3905
      (com.palletops.awaze.common/aws-client :ec2 credentials3903)]
     (clojure.core/case
      (clojure.core/count args3904)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3905
        describeAvailabilityZones
        (ec2/describe-availability-zones-request
         (clojure.core/nth args3904 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3905
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-availability-zones,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-availability-zones,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials3907 & args3908]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3909
     (com.palletops.awaze.common/aws-client :ec2 credentials3907)]
    (clojure.core/case
     (clojure.core/count args3908)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3909
       describeAvailabilityZones
       (ec2/describe-availability-zones-request
        (clojure.core/nth args3908 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3909
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-peering-connection
   [m3910]
   (clojure.core/let
    [credentials3911 (:credentials m3910) args3912 (:args m3910)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3913
      (com.palletops.awaze.common/aws-client :ec2 credentials3911)]
     (clojure.core/case
      (clojure.core/count args3912)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3913
        createVpcPeeringConnection
        (ec2/create-vpc-peering-connection-request
         (clojure.core/nth args3912 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3913
        createVpcPeeringConnection))))))
  (clojure.core/defn
   create-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createVpcPeeringConnection, createVpcPeeringConnection"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createVpcPeeringConnection, createVpcPeeringConnection"}
   [credentials3915 & args3916]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3917
     (com.palletops.awaze.common/aws-client :ec2 credentials3915)]
    (clojure.core/case
     (clojure.core/count args3916)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3917
       createVpcPeeringConnection
       (ec2/create-vpc-peering-connection-request
        (clojure.core/nth args3916 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3917
       createVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m3918]
   (clojure.core/let
    [credentials3919 (:credentials m3918) args3920 (:args m3918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3921
      (com.palletops.awaze.common/aws-client :ec2 credentials3919)]
     (clojure.core/case
      (clojure.core/count args3920)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3921
        describeInternetGateways
        (ec2/describe-internet-gateways-request
         (clojure.core/nth args3920 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3921
        describeInternetGateways))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-internet-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-internet-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials3923 & args3924]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3925
     (com.palletops.awaze.common/aws-client :ec2 credentials3923)]
    (clojure.core/case
     (clojure.core/count args3924)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3925
       describeInternetGateways
       (ec2/describe-internet-gateways-request
        (clojure.core/nth args3924 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3925
       describeInternetGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m3926]
   (clojure.core/let
    [credentials3927 (:credentials m3926) args3928 (:args m3926)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3929
      (com.palletops.awaze.common/aws-client :ec2 credentials3927)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3929
       disassociateRouteTable
       (ec2/disassociate-route-table-request
        (clojure.core/nth args3928 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials3931 & args3932]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3933
     (com.palletops.awaze.common/aws-client :ec2 credentials3931)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3933
      disassociateRouteTable
      (ec2/disassociate-route-table-request
       (clojure.core/nth args3932 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m3934]
   (clojure.core/let
    [credentials3935 (:credentials m3934) args3936 (:args m3934)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3937
      (com.palletops.awaze.common/aws-client :ec2 credentials3935)]
     (clojure.core/case
      (clojure.core/count args3936)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3937
        describeRegions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3937
        describeRegions
        (ec2/describe-regions-request (clojure.core/nth args3936 0))))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-regions,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-regions,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials3939 & args3940]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3941
     (com.palletops.awaze.common/aws-client :ec2 credentials3939)]
    (clojure.core/case
     (clojure.core/count args3940)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3941
       describeRegions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3941
       describeRegions
       (ec2/describe-regions-request (clojure.core/nth args3940 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link-dns-support
   [m3942]
   (clojure.core/let
    [credentials3943 (:credentials m3942) args3944 (:args m3942)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3945
      (com.palletops.awaze.common/aws-client :ec2 credentials3943)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3945
       enableVpcClassicLinkDnsSupport
       (ec2/enable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3944 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLinkDnsSupport"}
   [credentials3947 & args3948]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3949
     (com.palletops.awaze.common/aws-client :ec2 credentials3947)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3949
      enableVpcClassicLinkDnsSupport
      (ec2/enable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3948 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m3950]
   (clojure.core/let
    [credentials3951 (:credentials m3950) args3952 (:args m3950)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3953
      (com.palletops.awaze.common/aws-client :ec2 credentials3951)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3953
       deregisterImage
       (ec2/deregister-image-request (clojure.core/nth args3952 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deregister-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterImage"}
   [credentials3955 & args3956]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3957
     (com.palletops.awaze.common/aws-client :ec2 credentials3955)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3957
      deregisterImage
      (ec2/deregister-image-request (clojure.core/nth args3956 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m3958]
   (clojure.core/let
    [credentials3959 (:credentials m3958) args3960 (:args m3958)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3961
      (com.palletops.awaze.common/aws-client :ec2 credentials3959)]
     (clojure.core/case
      (clojure.core/count args3960)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3961
        deleteSpotDatafeedSubscription
        (ec2/delete-spot-datafeed-subscription-request
         (clojure.core/nth args3960 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3961
        deleteSpotDatafeedSubscription))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials3963 & args3964]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3965
     (com.palletops.awaze.common/aws-client :ec2 credentials3963)]
    (clojure.core/case
     (clojure.core/count args3964)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3965
       deleteSpotDatafeedSubscription
       (ec2/delete-spot-datafeed-subscription-request
        (clojure.core/nth args3964 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3965
       deleteSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m3966]
   (clojure.core/let
    [credentials3967 (:credentials m3966) args3968 (:args m3966)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3969
      (com.palletops.awaze.common/aws-client :ec2 credentials3967)]
     (clojure.core/case
      (clojure.core/count args3968)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3969
        describeCustomerGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3969
        describeCustomerGateways
        (ec2/describe-customer-gateways-request
         (clojure.core/nth args3968 0))))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-customer-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-customer-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials3971 & args3972]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3973
     (com.palletops.awaze.common/aws-client :ec2 credentials3971)]
    (clojure.core/case
     (clojure.core/count args3972)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3973
       describeCustomerGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3973
       describeCustomerGateways
       (ec2/describe-customer-gateways-request
        (clojure.core/nth args3972 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-request-history
   [m3974]
   (clojure.core/let
    [credentials3975 (:credentials m3974) args3976 (:args m3974)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3977
      (com.palletops.awaze.common/aws-client :ec2 credentials3975)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3977
       describeSpotFleetRequestHistory
       (ec2/describe-spot-fleet-request-history-request
        (clojure.core/nth args3976 0)))))))
  (clojure.core/defn
   describe-spot-fleet-request-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetRequestHistory"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-request-history,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-request-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetRequestHistory"}
   [credentials3979 & args3980]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3981
     (com.palletops.awaze.common/aws-client :ec2 credentials3979)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3981
      describeSpotFleetRequestHistory
      (ec2/describe-spot-fleet-request-history-request
       (clojure.core/nth args3980 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m3982]
   (clojure.core/let
    [credentials3983 (:credentials m3982) args3984 (:args m3982)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3985
      (com.palletops.awaze.common/aws-client :ec2 credentials3983)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3985
       createSubnet
       (ec2/create-subnet-request (clojure.core/nth args3984 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-subnet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createSubnet"}
   [credentials3987 & args3988]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3989
     (com.palletops.awaze.common/aws-client :ec2 credentials3987)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3989
      createSubnet
      (ec2/create-subnet-request (clojure.core/nth args3988 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m3990]
   (clojure.core/let
    [credentials3991 (:credentials m3990) args3992 (:args m3990)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3993
      (com.palletops.awaze.common/aws-client :ec2 credentials3991)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3993
       describeNetworkInterfaceAttribute
       (ec2/describe-network-interface-attribute-request
        (clojure.core/nth args3992 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials3995 & args3996]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3997
     (com.palletops.awaze.common/aws-client :ec2 credentials3995)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3997
      describeNetworkInterfaceAttribute
      (ec2/describe-network-interface-attribute-request
       (clojure.core/nth args3996 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-placement
   [m3998]
   (clojure.core/let
    [credentials3999 (:credentials m3998) args4000 (:args m3998)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4001
      (com.palletops.awaze.common/aws-client :ec2 credentials3999)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4001
       modifyInstancePlacement
       (ec2/modify-instance-placement-request
        (clojure.core/nth args4000 0)))))))
  (clojure.core/defn
   modify-instance-placement-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstancePlacement"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-placement,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-placement
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstancePlacement"}
   [credentials4003 & args4004]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4005
     (com.palletops.awaze.common/aws-client :ec2 credentials4003)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4005
      modifyInstancePlacement
      (ec2/modify-instance-placement-request
       (clojure.core/nth args4004 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-classic-link-vpc
   [m4006]
   (clojure.core/let
    [credentials4007 (:credentials m4006) args4008 (:args m4006)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4009
      (com.palletops.awaze.common/aws-client :ec2 credentials4007)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4009
       detachClassicLinkVpc
       (ec2/detach-classic-link-vpc-request
        (clojure.core/nth args4008 0)))))))
  (clojure.core/defn
   detach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachClassicLinkVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-classic-link-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachClassicLinkVpc"}
   [credentials4011 & args4012]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4013
     (com.palletops.awaze.common/aws-client :ec2 credentials4011)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4013
      detachClassicLinkVpc
      (ec2/detach-classic-link-vpc-request
       (clojure.core/nth args4012 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m4014]
   (clojure.core/let
    [credentials4015 (:credentials m4014) args4016 (:args m4014)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4017
      (com.palletops.awaze.common/aws-client :ec2 credentials4015)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4017
       cancelConversionTask
       (ec2/cancel-conversion-task-request
        (clojure.core/nth args4016 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-conversion-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelConversionTask"}
   [credentials4019 & args4020]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4021
     (com.palletops.awaze.common/aws-client :ec2 credentials4019)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4021
      cancelConversionTask
      (ec2/cancel-conversion-task-request
       (clojure.core/nth args4020 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m4022]
   (clojure.core/let
    [credentials4023 (:credentials m4022) args4024 (:args m4022)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4025
      (com.palletops.awaze.common/aws-client :ec2 credentials4023)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4025
       createNetworkInterface
       (ec2/create-network-interface-request
        (clojure.core/nth args4024 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Call createNetworkInterface"}
   [credentials4027 & args4028]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4029
     (com.palletops.awaze.common/aws-client :ec2 credentials4027)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4029
      createNetworkInterface
      (ec2/create-network-interface-request
       (clojure.core/nth args4028 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m4030]
   (clojure.core/let
    [credentials4031 (:credentials m4030) args4032 (:args m4030)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4033
      (com.palletops.awaze.common/aws-client :ec2 credentials4031)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4033
       modifyImageAttribute
       (ec2/modify-image-attribute-request
        (clojure.core/nth args4032 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials4035 & args4036]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4037
     (com.palletops.awaze.common/aws-client :ec2 credentials4035)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4037
      modifyImageAttribute
      (ec2/modify-image-attribute-request
       (clojure.core/nth args4036 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m4038]
   (clojure.core/let
    [credentials4039 (:credentials m4038) args4040 (:args m4038)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4041
      (com.palletops.awaze.common/aws-client :ec2 credentials4039)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4041
       deleteRouteTable
       (ec2/delete-route-table-request (clojure.core/nth args4040 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRouteTable"}
   [credentials4043 & args4044]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4045
     (com.palletops.awaze.common/aws-client :ec2 credentials4043)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4045
      deleteRouteTable
      (ec2/delete-route-table-request (clojure.core/nth args4044 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m4046]
   (clojure.core/let
    [credentials4047 (:credentials m4046) args4048 (:args m4046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4049
      (com.palletops.awaze.common/aws-client :ec2 credentials4047)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4049
       associateRouteTable
       (ec2/associate-route-table-request
        (clojure.core/nth args4048 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call associateRouteTable"}
   [credentials4051 & args4052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4053
     (com.palletops.awaze.common/aws-client :ec2 credentials4051)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4053
      associateRouteTable
      (ec2/associate-route-table-request
       (clojure.core/nth args4052 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m4054]
   (clojure.core/let
    [credentials4055 (:credentials m4054) args4056 (:args m4054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4057
      (com.palletops.awaze.common/aws-client :ec2 credentials4055)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4057
       deleteCustomerGateway
       (ec2/delete-customer-gateway-request
        (clojure.core/nth args4056 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-customer-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials4059 & args4060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4061
     (com.palletops.awaze.common/aws-client :ec2 credentials4059)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4061
      deleteCustomerGateway
      (ec2/delete-customer-gateway-request
       (clojure.core/nth args4060 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m4062]
   (clojure.core/let
    [credentials4063 (:credentials m4062) args4064 (:args m4062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4065
      (com.palletops.awaze.common/aws-client :ec2 credentials4063)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4065
       replaceRouteTableAssociation
       (ec2/replace-route-table-association-request
        (clojure.core/nth args4064 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-route-table-association,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials4067 & args4068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4069
     (com.palletops.awaze.common/aws-client :ec2 credentials4067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4069
      replaceRouteTableAssociation
      (ec2/replace-route-table-association-request
       (clojure.core/nth args4068 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m4070]
   (clojure.core/let
    [credentials4071 (:credentials m4070) args4072 (:args m4070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4073
      (com.palletops.awaze.common/aws-client :ec2 credentials4071)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4073
       deleteVpc
       (ec2/delete-vpc-request (clojure.core/nth args4072 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpc"}
   [credentials4075 & args4076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4077
     (com.palletops.awaze.common/aws-client :ec2 credentials4075)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4077
      deleteVpc
      (ec2/delete-vpc-request (clojure.core/nth args4076 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m4078]
   (clojure.core/let
    [credentials4079 (:credentials m4078) args4080 (:args m4078)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4081
      (com.palletops.awaze.common/aws-client :ec2 credentials4079)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4081
       createKeyPair
       (ec2/create-key-pair-request (clojure.core/nth args4080 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createKeyPair"}
   [credentials4083 & args4084]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4085
     (com.palletops.awaze.common/aws-client :ec2 credentials4083)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4085
      createKeyPair
      (ec2/create-key-pair-request (clojure.core/nth args4084 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-hosts
   [m4086]
   (clojure.core/let
    [credentials4087 (:credentials m4086) args4088 (:args m4086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4089
      (com.palletops.awaze.common/aws-client :ec2 credentials4087)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4089
       allocateHosts
       (ec2/allocate-hosts-request (clojure.core/nth args4088 0)))))))
  (clojure.core/defn
   allocate-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Generate map for allocateHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Call allocateHosts"}
   [credentials4091 & args4092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4093
     (com.palletops.awaze.common/aws-client :ec2 credentials4091)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4093
      allocateHosts
      (ec2/allocate-hosts-request (clojure.core/nth args4092 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m4094]
   (clojure.core/let
    [credentials4095 (:credentials m4094) args4096 (:args m4094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4097
      (com.palletops.awaze.common/aws-client :ec2 credentials4095)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4097
       replaceRoute
       (ec2/replace-route-request (clojure.core/nth args4096 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRoute"}
   [credentials4099 & args4100]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4101
     (com.palletops.awaze.common/aws-client :ec2 credentials4099)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4101
      replaceRoute
      (ec2/replace-route-request (clojure.core/nth args4100 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m4102]
   (clojure.core/let
    [credentials4103 (:credentials m4102) args4104 (:args m4102)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4105
      (com.palletops.awaze.common/aws-client :ec2 credentials4103)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4105
       terminateInstances
       (ec2/terminate-instances-request (clojure.core/nth args4104 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstances"}
   [credentials4107 & args4108]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4109
     (com.palletops.awaze.common/aws-client :ec2 credentials4107)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4109
      terminateInstances
      (ec2/terminate-instances-request (clojure.core/nth args4108 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m4110]
   (clojure.core/let
    [credentials4111 (:credentials m4110) args4112 (:args m4110)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4113
      (com.palletops.awaze.common/aws-client :ec2 credentials4111)]
     (clojure.core/case
      (clojure.core/count args4112)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4113
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4113
        describeSnapshots
        (ec2/describe-snapshots-request (clojure.core/nth args4112 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials4115 & args4116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4117
     (com.palletops.awaze.common/aws-client :ec2 credentials4115)]
    (clojure.core/case
     (clojure.core/count args4116)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4117
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4117
       describeSnapshots
       (ec2/describe-snapshots-request (clojure.core/nth args4116 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m4118]
   (clojure.core/let
    [credentials4119 (:credentials m4118) args4120 (:args m4118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4121
      (com.palletops.awaze.common/aws-client :ec2 credentials4119)]
     (clojure.core/case
      (clojure.core/count args4120)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4121
        describeVpnGateways
        (ec2/describe-vpn-gateways-request
         (clojure.core/nth args4120 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4121
        describeVpnGateways))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpn-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpn-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials4123 & args4124]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4125
     (com.palletops.awaze.common/aws-client :ec2 credentials4123)]
    (clojure.core/case
     (clojure.core/count args4124)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4125
       describeVpnGateways
       (ec2/describe-vpn-gateways-request
        (clojure.core/nth args4124 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4125
       describeVpnGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m4126]
   (clojure.core/let
    [credentials4127 (:credentials m4126) args4128 (:args m4126)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4129
      (com.palletops.awaze.common/aws-client :ec2 credentials4127)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4129
       getPasswordData
       (ec2/get-password-data-request (clojure.core/nth args4128 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-password-data,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPasswordData"}
   [credentials4131 & args4132]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4133
     (com.palletops.awaze.common/aws-client :ec2 credentials4131)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4133
      getPasswordData
      (ec2/get-password-data-request (clojure.core/nth args4132 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m4134]
   (clojure.core/let
    [credentials4135 (:credentials m4134) args4136 (:args m4134)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4137
      (com.palletops.awaze.common/aws-client :ec2 credentials4135)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4137
       modifyVolumeAttribute
       (ec2/modify-volume-attribute-request
        (clojure.core/nth args4136 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-volume-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials4139 & args4140]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4141
     (com.palletops.awaze.common/aws-client :ec2 credentials4139)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4141
      modifyVolumeAttribute
      (ec2/modify-volume-attribute-request
       (clojure.core/nth args4140 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m4142]
   (clojure.core/let
    [credentials4143 (:credentials m4142) args4144 (:args m4142)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4145
      (com.palletops.awaze.common/aws-client :ec2 credentials4143)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4145
       disableVgwRoutePropagation
       (ec2/disable-vgw-route-propagation-request
        (clojure.core/nth args4144 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials4147 & args4148]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4149
     (com.palletops.awaze.common/aws-client :ec2 credentials4147)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4149
      disableVgwRoutePropagation
      (ec2/disable-vgw-route-propagation-request
       (clojure.core/nth args4148 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-instances
   [m4150]
   (clojure.core/let
    [credentials4151 (:credentials m4150) args4152 (:args m4150)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4153
      (com.palletops.awaze.common/aws-client :ec2 credentials4151)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4153
       describeSpotFleetInstances
       (ec2/describe-spot-fleet-instances-request
        (clojure.core/nth args4152 0)))))))
  (clojure.core/defn
   describe-spot-fleet-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetInstances"}
   [credentials4155 & args4156]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4157
     (com.palletops.awaze.common/aws-client :ec2 credentials4155)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4157
      describeSpotFleetInstances
      (ec2/describe-spot-fleet-instances-request
       (clojure.core/nth args4156 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-prefix-lists
   [m4158]
   (clojure.core/let
    [credentials4159 (:credentials m4158) args4160 (:args m4158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4161
      (com.palletops.awaze.common/aws-client :ec2 credentials4159)]
     (clojure.core/case
      (clojure.core/count args4160)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4161
        describePrefixLists))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4161
        describePrefixLists
        (ec2/describe-prefix-lists-request
         (clojure.core/nth args4160 0))))))))
  (clojure.core/defn
   describe-prefix-lists-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describePrefixLists, describePrefixLists"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-prefix-lists,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-prefix-lists,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-prefix-lists
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describePrefixLists, describePrefixLists"}
   [credentials4163 & args4164]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4165
     (com.palletops.awaze.common/aws-client :ec2 credentials4163)]
    (clojure.core/case
     (clojure.core/count args4164)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4165
       describePrefixLists))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4165
       describePrefixLists
       (ec2/describe-prefix-lists-request
        (clojure.core/nth args4164 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m4166]
   (clojure.core/let
    [credentials4167 (:credentials m4166) args4168 (:args m4166)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4169
      (com.palletops.awaze.common/aws-client :ec2 credentials4167)]
     (clojure.core/case
      (clojure.core/count args4168)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4169
        describeAccountAttributes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4169
        describeAccountAttributes
        (ec2/describe-account-attributes-request
         (clojure.core/nth args4168 0))))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials4171 & args4172]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4173
     (com.palletops.awaze.common/aws-client :ec2 credentials4171)]
    (clojure.core/case
     (clojure.core/count args4172)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4173
       describeAccountAttributes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4173
       describeAccountAttributes
       (ec2/describe-account-attributes-request
        (clojure.core/nth args4172 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m4174]
   (clojure.core/let
    [credentials4175 (:credentials m4174) args4176 (:args m4174)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4177
      (com.palletops.awaze.common/aws-client :ec2 credentials4175)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4177
       createVpnConnection
       (ec2/create-vpn-connection-request
        (clojure.core/nth args4176 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnection"}
   [credentials4179 & args4180]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4181
     (com.palletops.awaze.common/aws-client :ec2 credentials4179)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4181
      createVpnConnection
      (ec2/create-vpn-connection-request
       (clojure.core/nth args4180 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-peering-connections
   [m4182]
   (clojure.core/let
    [credentials4183 (:credentials m4182) args4184 (:args m4182)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4185
      (com.palletops.awaze.common/aws-client :ec2 credentials4183)]
     (clojure.core/case
      (clojure.core/count args4184)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4185
        describeVpcPeeringConnections
        (ec2/describe-vpc-peering-connections-request
         (clojure.core/nth args4184 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4185
        describeVpcPeeringConnections))))))
  (clojure.core/defn
   describe-vpc-peering-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcPeeringConnections, describeVpcPeeringConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-peering-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcPeeringConnections, describeVpcPeeringConnections"}
   [credentials4187 & args4188]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4189
     (com.palletops.awaze.common/aws-client :ec2 credentials4187)]
    (clojure.core/case
     (clojure.core/count args4188)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4189
       describeVpcPeeringConnections
       (ec2/describe-vpc-peering-connections-request
        (clojure.core/nth args4188 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4189
       describeVpcPeeringConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instance-availability
   [m4190]
   (clojure.core/let
    [credentials4191 (:credentials m4190) args4192 (:args m4190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4193
      (com.palletops.awaze.common/aws-client :ec2 credentials4191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4193
       describeScheduledInstanceAvailability
       (ec2/describe-scheduled-instance-availability-request
        (clojure.core/nth args4192 0)))))))
  (clojure.core/defn
   describe-scheduled-instance-availability-map
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstanceAvailability"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instance-availability,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instance-availability
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstanceAvailability"}
   [credentials4195 & args4196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4197
     (com.palletops.awaze.common/aws-client :ec2 credentials4195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4197
      describeScheduledInstanceAvailability
      (ec2/describe-scheduled-instance-availability-request
       (clojure.core/nth args4196 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-flow-logs
   [m4198]
   (clojure.core/let
    [credentials4199 (:credentials m4198) args4200 (:args m4198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4201
      (com.palletops.awaze.common/aws-client :ec2 credentials4199)]
     (clojure.core/case
      (clojure.core/count args4200)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4201
        describeFlowLogs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4201
        describeFlowLogs
        (ec2/describe-flow-logs-request (clojure.core/nth args4200 0))))))))
  (clojure.core/defn
   describe-flow-logs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeFlowLogs, describeFlowLogs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-flow-logs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeFlowLogs, describeFlowLogs"}
   [credentials4203 & args4204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4205
     (com.palletops.awaze.common/aws-client :ec2 credentials4203)]
    (clojure.core/case
     (clojure.core/count args4204)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4205
       describeFlowLogs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4205
       describeFlowLogs
       (ec2/describe-flow-logs-request (clojure.core/nth args4204 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m4206]
   (clojure.core/let
    [credentials4207 (:credentials m4206) args4208 (:args m4206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4209
      (com.palletops.awaze.common/aws-client :ec2 credentials4207)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4209
       cancelBundleTask
       (ec2/cancel-bundle-task-request (clojure.core/nth args4208 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-bundle-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelBundleTask"}
   [credentials4211 & args4212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4213
     (com.palletops.awaze.common/aws-client :ec2 credentials4211)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4213
      cancelBundleTask
      (ec2/cancel-bundle-task-request (clojure.core/nth args4212 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m4214]
   (clojure.core/let
    [credentials4215 (:credentials m4214) args4216 (:args m4214)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4217
      (com.palletops.awaze.common/aws-client :ec2 credentials4215)]
     (clojure.core/case
      (clojure.core/count args4216)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4217
        describeReservedInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4217
        describeReservedInstances
        (ec2/describe-reserved-instances-request
         (clojure.core/nth args4216 0))))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials4219 & args4220]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4221
     (com.palletops.awaze.common/aws-client :ec2 credentials4219)]
    (clojure.core/case
     (clojure.core/count args4220)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4221
       describeReservedInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4221
       describeReservedInstances
       (ec2/describe-reserved-instances-request
        (clojure.core/nth args4220 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m4222]
   (clojure.core/let
    [credentials4223 (:credentials m4222) args4224 (:args m4222)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4225
      (com.palletops.awaze.common/aws-client :ec2 credentials4223)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4225
       unmonitorInstances
       (ec2/unmonitor-instances-request (clojure.core/nth args4224 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unmonitor-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unmonitorInstances"}
   [credentials4227 & args4228]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4229
     (com.palletops.awaze.common/aws-client :ec2 credentials4227)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4229
      unmonitorInstances
      (ec2/unmonitor-instances-request (clojure.core/nth args4228 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m4230]
   (clojure.core/let
    [credentials4231 (:credentials m4230) args4232 (:args m4230)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4233
      (com.palletops.awaze.common/aws-client :ec2 credentials4231)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4233
       deleteSecurityGroup
       (ec2/delete-security-group-request
        (clojure.core/nth args4232 0)))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-security-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSecurityGroup"}
   [credentials4235 & args4236]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4237
     (com.palletops.awaze.common/aws-client :ec2 credentials4235)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4237
      deleteSecurityGroup
      (ec2/delete-security-group-request
       (clojure.core/nth args4236 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m4238]
   (clojure.core/let
    [credentials4239 (:credentials m4238) args4240 (:args m4238)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4241
      (com.palletops.awaze.common/aws-client :ec2 credentials4239)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4241
       describeVpcAttribute
       (ec2/describe-vpc-attribute-request
        (clojure.core/nth args4240 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials4243 & args4244]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4245
     (com.palletops.awaze.common/aws-client :ec2 credentials4243)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4245
      describeVpcAttribute
      (ec2/describe-vpc-attribute-request
       (clojure.core/nth args4244 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m4246]
   (clojure.core/let
    [credentials4247 (:credentials m4246) args4248 (:args m4246)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4249
      (com.palletops.awaze.common/aws-client :ec2 credentials4247)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4249
       createNetworkAcl
       (ec2/create-network-acl-request (clojure.core/nth args4248 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-acl,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createNetworkAcl"}
   [credentials4251 & args4252]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4253
     (com.palletops.awaze.common/aws-client :ec2 credentials4251)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4253
      createNetworkAcl
      (ec2/create-network-acl-request (clojure.core/nth args4252 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-import-task
   [m4254]
   (clojure.core/let
    [credentials4255 (:credentials m4254) args4256 (:args m4254)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4257
      (com.palletops.awaze.common/aws-client :ec2 credentials4255)]
     (clojure.core/case
      (clojure.core/count args4256)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4257
        cancelImportTask))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4257
        cancelImportTask
        (ec2/cancel-import-task-request (clojure.core/nth args4256 0))))))))
  (clojure.core/defn
   cancel-import-task-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]]),
    :doc "Generate map for cancelImportTask, cancelImportTask"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :cancel-import-task,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-import-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-import-task
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]]),
    :doc "Call cancelImportTask, cancelImportTask"}
   [credentials4259 & args4260]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4261
     (com.palletops.awaze.common/aws-client :ec2 credentials4259)]
    (clojure.core/case
     (clojure.core/count args4260)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4261
       cancelImportTask))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4261
       cancelImportTask
       (ec2/cancel-import-task-request (clojure.core/nth args4260 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :accept-vpc-peering-connection
   [m4262]
   (clojure.core/let
    [credentials4263 (:credentials m4262) args4264 (:args m4262)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4265
      (com.palletops.awaze.common/aws-client :ec2 credentials4263)]
     (clojure.core/case
      (clojure.core/count args4264)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4265
        acceptVpcPeeringConnection
        (ec2/accept-vpc-peering-connection-request
         (clojure.core/nth args4264 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4265
        acceptVpcPeeringConnection))))))
  (clojure.core/defn
   accept-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   accept-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   [credentials4267 & args4268]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4269
     (com.palletops.awaze.common/aws-client :ec2 credentials4267)]
    (clojure.core/case
     (clojure.core/count args4268)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4269
       acceptVpcPeeringConnection
       (ec2/accept-vpc-peering-connection-request
        (clojure.core/nth args4268 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4269
       acceptVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoint-services
   [m4270]
   (clojure.core/let
    [credentials4271 (:credentials m4270) args4272 (:args m4270)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4273
      (com.palletops.awaze.common/aws-client :ec2 credentials4271)]
     (clojure.core/case
      (clojure.core/count args4272)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4273
        describeVpcEndpointServices
        (ec2/describe-vpc-endpoint-services-request
         (clojure.core/nth args4272 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4273
        describeVpcEndpointServices))))))
  (clojure.core/defn
   describe-vpc-endpoint-services-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVpcEndpointServices, describeVpcEndpointServices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoint-services
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVpcEndpointServices, describeVpcEndpointServices"}
   [credentials4275 & args4276]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4277
     (com.palletops.awaze.common/aws-client :ec2 credentials4275)]
    (clojure.core/case
     (clojure.core/count args4276)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4277
       describeVpcEndpointServices
       (ec2/describe-vpc-endpoint-services-request
        (clojure.core/nth args4276 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4277
       describeVpcEndpointServices))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-peering-connection
   [m4278]
   (clojure.core/let
    [credentials4279 (:credentials m4278) args4280 (:args m4278)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4281
      (com.palletops.awaze.common/aws-client :ec2 credentials4279)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4281
       deleteVpcPeeringConnection
       (ec2/delete-vpc-peering-connection-request
        (clojure.core/nth args4280 0)))))))
  (clojure.core/defn
   delete-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpcPeeringConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpcPeeringConnection"}
   [credentials4283 & args4284]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4285
     (com.palletops.awaze.common/aws-client :ec2 credentials4283)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4285
      deleteVpcPeeringConnection
      (ec2/delete-vpc-peering-connection-request
       (clojure.core/nth args4284 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m4286]
   (clojure.core/let
    [credentials4287 (:credentials m4286) args4288 (:args m4286)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4289
      (com.palletops.awaze.common/aws-client :ec2 credentials4287)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4289
       runInstances
       (ec2/run-instances-request (clojure.core/nth args4288 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call runInstances"}
   [credentials4291 & args4292]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4293
     (com.palletops.awaze.common/aws-client :ec2 credentials4291)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4293
      runInstances
      (ec2/run-instances-request (clojure.core/nth args4292 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m4294]
   (clojure.core/let
    [credentials4295 (:credentials m4294) args4296 (:args m4294)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4297
      (com.palletops.awaze.common/aws-client :ec2 credentials4295)]
     (clojure.core/case
      (clojure.core/count args4296)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4297
        describeInstanceStatus
        (ec2/describe-instance-status-request
         (clojure.core/nth args4296 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4297
        describeInstanceStatus))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials4299 & args4300]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4301
     (com.palletops.awaze.common/aws-client :ec2 credentials4299)]
    (clojure.core/case
     (clojure.core/count args4300)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4301
       describeInstanceStatus
       (ec2/describe-instance-status-request
        (clojure.core/nth args4300 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4301
       describeInstanceStatus))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link-dns-support
   [m4302]
   (clojure.core/let
    [credentials4303 (:credentials m4302) args4304 (:args m4302)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4305
      (com.palletops.awaze.common/aws-client :ec2 credentials4303)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4305
       describeVpcClassicLinkDnsSupport
       (ec2/describe-vpc-classic-link-dns-support-request
        (clojure.core/nth args4304 0)))))))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcClassicLinkDnsSupport"}
   [credentials4307 & args4308]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4309
     (com.palletops.awaze.common/aws-client :ec2 credentials4307)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4309
      describeVpcClassicLinkDnsSupport
      (ec2/describe-vpc-classic-link-dns-support-request
       (clojure.core/nth args4308 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m4310]
   (clojure.core/let
    [credentials4311 (:credentials m4310) args4312 (:args m4310)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4313
      (com.palletops.awaze.common/aws-client :ec2 credentials4311)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4313
       unassignPrivateIpAddresses
       (ec2/unassign-private-ip-addresses-request
        (clojure.core/nth args4312 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials4315 & args4316]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4317
     (com.palletops.awaze.common/aws-client :ec2 credentials4315)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4317
      unassignPrivateIpAddresses
      (ec2/unassign-private-ip-addresses-request
       (clojure.core/nth args4316 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m4318]
   (clojure.core/let
    [credentials4319 (:credentials m4318) args4320 (:args m4318)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4321
      (com.palletops.awaze.common/aws-client :ec2 credentials4319)]
     (clojure.core/case
      (clojure.core/count args4320)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4321
        describeSecurityGroups
        (ec2/describe-security-groups-request
         (clojure.core/nth args4320 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4321
        describeSecurityGroups))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-security-groups,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-security-groups,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials4323 & args4324]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4325
     (com.palletops.awaze.common/aws-client :ec2 credentials4323)]
    (clojure.core/case
     (clojure.core/count args4324)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4325
       describeSecurityGroups
       (ec2/describe-security-groups-request
        (clojure.core/nth args4324 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4325
       describeSecurityGroups))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m4326]
   (clojure.core/let
    [credentials4327 (:credentials m4326) args4328 (:args m4326)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4329
      (com.palletops.awaze.common/aws-client :ec2 credentials4327)]
     (clojure.core/case
      (clojure.core/count args4328)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4329
        describeNetworkInterfaces))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4329
        describeNetworkInterfaces
        (ec2/describe-network-interfaces-request
         (clojure.core/nth args4328 0))))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-network-interfaces,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-interfaces,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials4331 & args4332]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4333
     (com.palletops.awaze.common/aws-client :ec2 credentials4331)]
    (clojure.core/case
     (clojure.core/count args4332)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4333
       describeNetworkInterfaces))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4333
       describeNetworkInterfaces
       (ec2/describe-network-interfaces-request
        (clojure.core/nth args4332 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m4334]
   (clojure.core/let
    [credentials4335 (:credentials m4334) args4336 (:args m4334)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4337
      (com.palletops.awaze.common/aws-client :ec2 credentials4335)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4337
       createCustomerGateway
       (ec2/create-customer-gateway-request
        (clojure.core/nth args4336 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-customer-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call createCustomerGateway"}
   [credentials4339 & args4340]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4341
     (com.palletops.awaze.common/aws-client :ec2 credentials4339)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4341
      createCustomerGateway
      (ec2/create-customer-gateway-request
       (clojure.core/nth args4340 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m4342]
   (clojure.core/let
    [credentials4343 (:credentials m4342) args4344 (:args m4342)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4345
      (com.palletops.awaze.common/aws-client :ec2 credentials4343)]
     (clojure.core/case
      (clojure.core/count args4344)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4345
        describeDhcpOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4345
        describeDhcpOptions
        (ec2/describe-dhcp-options-request
         (clojure.core/nth args4344 0))))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials4347 & args4348]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4349
     (com.palletops.awaze.common/aws-client :ec2 credentials4347)]
    (clojure.core/case
     (clojure.core/count args4348)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4349
       describeDhcpOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4349
       describeDhcpOptions
       (ec2/describe-dhcp-options-request
        (clojure.core/nth args4348 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m4350]
   (clojure.core/let
    [credentials4351 (:credentials m4350) args4352 (:args m4350)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4353
      (com.palletops.awaze.common/aws-client :ec2 credentials4351)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4353
       createTags
       (ec2/create-tags-request (clojure.core/nth args4352 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials4355 & args4356]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4357
     (com.palletops.awaze.common/aws-client :ec2 credentials4355)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4357
      createTags
      (ec2/create-tags-request (clojure.core/nth args4356 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m4358]
   (clojure.core/let
    [credentials4359 (:credentials m4358) args4360 (:args m4358)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4361
      (com.palletops.awaze.common/aws-client :ec2 credentials4359)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4361
       createSnapshot
       (ec2/create-snapshot-request (clojure.core/nth args4360 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials4363 & args4364]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4365
     (com.palletops.awaze.common/aws-client :ec2 credentials4363)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4365
      createSnapshot
      (ec2/create-snapshot-request (clojure.core/nth args4364 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-image
   [m4366]
   (clojure.core/let
    [credentials4367 (:credentials m4366) args4368 (:args m4366)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4369
      (com.palletops.awaze.common/aws-client :ec2 credentials4367)]
     (clojure.core/case
      (clojure.core/count args4368)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4369
        importImage))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4369
        importImage
        (ec2/import-image-request (clojure.core/nth args4368 0))))))))
  (clojure.core/defn
   import-image-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]]),
    :doc "Generate map for importImage, importImage"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :import-image,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-image
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]]),
    :doc "Call importImage, importImage"}
   [credentials4371 & args4372]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4373
     (com.palletops.awaze.common/aws-client :ec2 credentials4371)]
    (clojure.core/case
     (clojure.core/count args4372)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4373
       importImage))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4373
       importImage
       (ec2/import-image-request (clojure.core/nth args4372 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m4374]
   (clojure.core/let
    [credentials4375 (:credentials m4374) args4376 (:args m4374)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4377
      (com.palletops.awaze.common/aws-client :ec2 credentials4375)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4377
       createRouteTable
       (ec2/create-route-table-request (clojure.core/nth args4376 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRouteTable"}
   [credentials4379 & args4380]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4381
     (com.palletops.awaze.common/aws-client :ec2 credentials4379)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4381
      createRouteTable
      (ec2/create-route-table-request (clojure.core/nth args4380 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-hosts
   [m4382]
   (clojure.core/let
    [credentials4383 (:credentials m4382) args4384 (:args m4382)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4385
      (com.palletops.awaze.common/aws-client :ec2 credentials4383)]
     (clojure.core/case
      (clojure.core/count args4384)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4385
        describeHosts))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4385
        describeHosts
        (ec2/describe-hosts-request (clojure.core/nth args4384 0))))))))
  (clojure.core/defn
   describe-hosts-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeHosts, describeHosts"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-hosts
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeHosts, describeHosts"}
   [credentials4387 & args4388]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4389
     (com.palletops.awaze.common/aws-client :ec2 credentials4387)]
    (clojure.core/case
     (clojure.core/count args4388)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4389
       describeHosts))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4389
       describeHosts
       (ec2/describe-hosts-request (clojure.core/nth args4388 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m4390]
   (clojure.core/let
    [credentials4391 (:credentials m4390) args4392 (:args m4390)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4393
      (com.palletops.awaze.common/aws-client :ec2 credentials4391)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4393
       describeVolumeAttribute
       (ec2/describe-volume-attribute-request
        (clojure.core/nth args4392 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volume-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials4395 & args4396]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4397
     (com.palletops.awaze.common/aws-client :ec2 credentials4395)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4397
      describeVolumeAttribute
      (ec2/describe-volume-attribute-request
       (clojure.core/nth args4396 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-id-format
   [m4398]
   (clojure.core/let
    [credentials4399 (:credentials m4398) args4400 (:args m4398)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4401
      (com.palletops.awaze.common/aws-client :ec2 credentials4399)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4401
       modifyIdFormat
       (ec2/modify-id-format-request (clojure.core/nth args4400 0)))))))
  (clojure.core/defn
   modify-id-format-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyIdFormat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-id-format
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyIdFormat"}
   [credentials4403 & args4404]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4405
     (com.palletops.awaze.common/aws-client :ec2 credentials4403)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4405
      modifyIdFormat
      (ec2/modify-id-format-request (clojure.core/nth args4404 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m4406]
   (clojure.core/let
    [credentials4407 (:credentials m4406) args4408 (:args m4406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4409
      (com.palletops.awaze.common/aws-client :ec2 credentials4407)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4409
       createNetworkAclEntry
       (ec2/create-network-acl-entry-request
        (clojure.core/nth args4408 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials4411 & args4412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4413
     (com.palletops.awaze.common/aws-client :ec2 credentials4411)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4413
      createNetworkAclEntry
      (ec2/create-network-acl-entry-request
       (clojure.core/nth args4412 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-nat-gateways
   [m4414]
   (clojure.core/let
    [credentials4415 (:credentials m4414) args4416 (:args m4414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4417
      (com.palletops.awaze.common/aws-client :ec2 credentials4415)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4417
       describeNatGateways
       (ec2/describe-nat-gateways-request
        (clojure.core/nth args4416 0)))))))
  (clojure.core/defn
   describe-nat-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeNatGateways"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-nat-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-nat-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeNatGateways"}
   [credentials4419 & args4420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4421
     (com.palletops.awaze.common/aws-client :ec2 credentials4419)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4421
      describeNatGateways
      (ec2/describe-nat-gateways-request
       (clojure.core/nth args4420 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m4422]
   (clojure.core/let
    [credentials4423 (:credentials m4422) args4424 (:args m4422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4425
      (com.palletops.awaze.common/aws-client :ec2 credentials4423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4425
       cancelReservedInstancesListing
       (ec2/cancel-reserved-instances-listing-request
        (clojure.core/nth args4424 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials4427 & args4428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4429
     (com.palletops.awaze.common/aws-client :ec2 credentials4427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4429
      cancelReservedInstancesListing
      (ec2/cancel-reserved-instances-listing-request
       (clojure.core/nth args4428 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link
   [m4430]
   (clojure.core/let
    [credentials4431 (:credentials m4430) args4432 (:args m4430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4433
      (com.palletops.awaze.common/aws-client :ec2 credentials4431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4433
       disableVpcClassicLink
       (ec2/disable-vpc-classic-link-request
        (clojure.core/nth args4432 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLink"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLink"}
   [credentials4435 & args4436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4437
     (com.palletops.awaze.common/aws-client :ec2 credentials4435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4437
      disableVpcClassicLink
      (ec2/disable-vpc-classic-link-request
       (clojure.core/nth args4436 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-scheduled-instances
   [m4438]
   (clojure.core/let
    [credentials4439 (:credentials m4438) args4440 (:args m4438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4441
      (com.palletops.awaze.common/aws-client :ec2 credentials4439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4441
       runScheduledInstances
       (ec2/run-scheduled-instances-request
        (clojure.core/nth args4440 0)))))))
  (clojure.core/defn
   run-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for runScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call runScheduledInstances"}
   [credentials4443 & args4444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4445
     (com.palletops.awaze.common/aws-client :ec2 credentials4443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4445
      runScheduledInstances
      (ec2/run-scheduled-instances-request
       (clojure.core/nth args4444 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m4446]
   (clojure.core/let
    [credentials4447 (:credentials m4446) args4448 (:args m4446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4449
      (com.palletops.awaze.common/aws-client :ec2 credentials4447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4449
       deleteKeyPair
       (ec2/delete-key-pair-request (clojure.core/nth args4448 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteKeyPair"}
   [credentials4451 & args4452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4453
     (com.palletops.awaze.common/aws-client :ec2 credentials4451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4453
      deleteKeyPair
      (ec2/delete-key-pair-request (clojure.core/nth args4452 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m4454]
   (clojure.core/let
    [credentials4455 (:credentials m4454) args4456 (:args m4454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4457
      (com.palletops.awaze.common/aws-client :ec2 credentials4455)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4457
       modifyReservedInstances
       (ec2/modify-reserved-instances-request
        (clojure.core/nth args4456 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials4459 & args4460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4461
     (com.palletops.awaze.common/aws-client :ec2 credentials4459)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4461
      modifyReservedInstances
      (ec2/modify-reserved-instances-request
       (clojure.core/nth args4460 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m4462]
   (clojure.core/let
    [credentials4463 (:credentials m4462) args4464 (:args m4462)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4465
      (com.palletops.awaze.common/aws-client :ec2 credentials4463)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4465
       deleteVpnConnectionRoute
       (ec2/delete-vpn-connection-route-request
        (clojure.core/nth args4464 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials4467 & args4468]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4469
     (com.palletops.awaze.common/aws-client :ec2 credentials4467)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4469
      deleteVpnConnectionRoute
      (ec2/delete-vpn-connection-route-request
       (clojure.core/nth args4468 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m4470]
   (clojure.core/let
    [credentials4471 (:credentials m4470) args4472 (:args m4470)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4473
      (com.palletops.awaze.common/aws-client :ec2 credentials4471)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4473
       attachInternetGateway
       (ec2/attach-internet-gateway-request
        (clojure.core/nth args4472 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call attachInternetGateway"}
   [credentials4475 & args4476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4477
     (com.palletops.awaze.common/aws-client :ec2 credentials4475)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4477
      attachInternetGateway
      (ec2/attach-internet-gateway-request
       (clojure.core/nth args4476 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m4478]
   (clojure.core/let
    [credentials4479 (:credentials m4478) args4480 (:args m4478)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4481
      (com.palletops.awaze.common/aws-client :ec2 credentials4479)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4481
       modifyNetworkInterfaceAttribute
       (ec2/modify-network-interface-attribute-request
        (clojure.core/nth args4480 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials4483 & args4484]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4485
     (com.palletops.awaze.common/aws-client :ec2 credentials4483)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4485
      modifyNetworkInterfaceAttribute
      (ec2/modify-network-interface-attribute-request
       (clojure.core/nth args4484 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m4486]
   (clojure.core/let
    [credentials4487 (:credentials m4486) args4488 (:args m4486)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4489
      (com.palletops.awaze.common/aws-client :ec2 credentials4487)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4489
       enableVgwRoutePropagation
       (ec2/enable-vgw-route-propagation-request
        (clojure.core/nth args4488 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials4491 & args4492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4493
     (com.palletops.awaze.common/aws-client :ec2 credentials4491)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4493
      enableVgwRoutePropagation
      (ec2/enable-vgw-route-propagation-request
       (clojure.core/nth args4492 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m4494]
   (clojure.core/let
    [credentials4495 (:credentials m4494) args4496 (:args m4494)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4497
      (com.palletops.awaze.common/aws-client :ec2 credentials4495)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4497
       deleteNetworkAclEntry
       (ec2/delete-network-acl-entry-request
        (clojure.core/nth args4496 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials4499 & args4500]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4501
     (com.palletops.awaze.common/aws-client :ec2 credentials4499)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4501
      deleteNetworkAclEntry
      (ec2/delete-network-acl-entry-request
       (clojure.core/nth args4500 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m4502]
   (clojure.core/let
    [credentials4503 (:credentials m4502) args4504 (:args m4502)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4505
      (com.palletops.awaze.common/aws-client :ec2 credentials4503)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4505
       cancelExportTask
       (ec2/cancel-export-task-request (clojure.core/nth args4504 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-export-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelExportTask"}
   [credentials4507 & args4508]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4509
     (com.palletops.awaze.common/aws-client :ec2 credentials4507)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4509
      cancelExportTask
      (ec2/cancel-export-task-request (clojure.core/nth args4508 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m4510]
   (clojure.core/let
    [credentials4511 (:credentials m4510) args4512 (:args m4510)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4513
      (com.palletops.awaze.common/aws-client :ec2 credentials4511)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4513
       createImage
       (ec2/create-image-request (clojure.core/nth args4512 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createImage"}
   [credentials4515 & args4516]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4517
     (com.palletops.awaze.common/aws-client :ec2 credentials4515)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4517
      createImage
      (ec2/create-image-request (clojure.core/nth args4516 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-spot-fleet-request
   [m4518]
   (clojure.core/let
    [credentials4519 (:credentials m4518) args4520 (:args m4518)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4521
      (com.palletops.awaze.common/aws-client :ec2 credentials4519)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4521
       modifySpotFleetRequest
       (ec2/modify-spot-fleet-request-request
        (clojure.core/nth args4520 0)))))))
  (clojure.core/defn
   modify-spot-fleet-request-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Generate map for modifySpotFleetRequest"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-spot-fleet-request,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-spot-fleet-request
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Call modifySpotFleetRequest"}
   [credentials4523 & args4524]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4525
     (com.palletops.awaze.common/aws-client :ec2 credentials4523)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4525
      modifySpotFleetRequest
      (ec2/modify-spot-fleet-request-request
       (clojure.core/nth args4524 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-snapshot-tasks
   [m4526]
   (clojure.core/let
    [credentials4527 (:credentials m4526) args4528 (:args m4526)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4529
      (com.palletops.awaze.common/aws-client :ec2 credentials4527)]
     (clojure.core/case
      (clojure.core/count args4528)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4529
        describeImportSnapshotTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4529
        describeImportSnapshotTasks
        (ec2/describe-import-snapshot-tasks-request
         (clojure.core/nth args4528 0))))))))
  (clojure.core/defn
   describe-import-snapshot-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeImportSnapshotTasks, describeImportSnapshotTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-snapshot-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeImportSnapshotTasks, describeImportSnapshotTasks"}
   [credentials4531 & args4532]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4533
     (com.palletops.awaze.common/aws-client :ec2 credentials4531)]
    (clojure.core/case
     (clojure.core/count args4532)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4533
       describeImportSnapshotTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4533
       describeImportSnapshotTasks
       (ec2/describe-import-snapshot-tasks-request
        (clojure.core/nth args4532 0)))))))))
