(ns
 com.palletops.awaze.cloudfront
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudfront :as cloudfront]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ItemSelection}
item-selection
  [m11942]
  (.
   com.amazonaws.services.cloudfront.model.ItemSelection
   fromValue
   (clojure.core/name m11942)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookieNames}
cookie-names
  [m11945]
  (clojure.core/let
   [bean11944
    (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/let
    [v11946
     (:quantity m11945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11946 :com.palletops.awaze.client-builder/undef)
     (. bean11944 setQuantity (clojure.core/int v11946))))
   (clojure.core/let
    [v11946 (:items m11945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11946 :com.palletops.awaze.client-builder/undef)
     (.
      bean11944
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12112] (clojure.core/str arg12112))
 v11946))))
   bean11944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookiePreference}
cookie-preference
  [m11948]
  (clojure.core/let
   [bean11947
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/let
    [v11949
     (:forward m11948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11949 :com.palletops.awaze.client-builder/undef)
     (. bean11947 setForward (cloudfront/item-selection v11949))))
   (clojure.core/let
    [v11949
     (:whitelisted-names
      m11948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11949 :com.palletops.awaze.client-builder/undef)
     (.
      bean11947
      setWhitelistedNames
      (cloudfront/cookie-names v11949))))
   bean11947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Headers}
headers
  [m11951]
  (clojure.core/let
   [bean11950 (new com.amazonaws.services.cloudfront.model.Headers)]
   (clojure.core/let
    [v11952
     (:quantity m11951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11952 :com.palletops.awaze.client-builder/undef)
     (. bean11950 setQuantity (clojure.core/int v11952))))
   (clojure.core/let
    [v11952 (:items m11951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11952 :com.palletops.awaze.client-builder/undef)
     (.
      bean11950
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12113] (clojure.core/str arg12113))
 v11952))))
   bean11950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CachedMethods}
cached-methods
  [m11954]
  (clojure.core/let
   [bean11953
    (new com.amazonaws.services.cloudfront.model.CachedMethods)]
   (clojure.core/let
    [v11955
     (:quantity m11954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11955 :com.palletops.awaze.client-builder/undef)
     (. bean11953 setQuantity (clojure.core/int v11955))))
   (clojure.core/let
    [v11955 (:items m11954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11955 :com.palletops.awaze.client-builder/undef)
     (.
      bean11953
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12114] (clojure.core/str arg12114))
 v11955))))
   bean11953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginSslProtocols}
origin-ssl-protocols
  [m11957]
  (clojure.core/let
   [bean11956
    (new com.amazonaws.services.cloudfront.model.OriginSslProtocols)]
   (clojure.core/let
    [v11958
     (:quantity m11957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11958 :com.palletops.awaze.client-builder/undef)
     (. bean11956 setQuantity (clojure.core/int v11958))))
   (clojure.core/let
    [v11958 (:items m11957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11958 :com.palletops.awaze.client-builder/undef)
     (.
      bean11956
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12115] (clojure.core/str arg12115))
 v11958))))
   bean11956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginCustomHeader}
origin-custom-header
  [m11960]
  (clojure.core/let
   [bean11959
    (new com.amazonaws.services.cloudfront.model.OriginCustomHeader)]
   (clojure.core/let
    [v11961
     (:header-name m11960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11961 :com.palletops.awaze.client-builder/undef)
     (. bean11959 setHeaderName (clojure.core/str v11961))))
   (clojure.core/let
    [v11961
     (:header-value m11960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11961 :com.palletops.awaze.client-builder/undef)
     (. bean11959 setHeaderValue (clojure.core/str v11961))))
   bean11959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ForwardedValues}
forwarded-values
  [m11963]
  (clojure.core/let
   [bean11962
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/let
    [v11964
     (:query-string m11963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11964 :com.palletops.awaze.client-builder/undef)
     (. bean11962 setQueryString (clojure.core/boolean v11964))))
   (clojure.core/let
    [v11964
     (:cookies m11963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11964 :com.palletops.awaze.client-builder/undef)
     (. bean11962 setCookies (cloudfront/cookie-preference v11964))))
   (clojure.core/let
    [v11964
     (:headers m11963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11964 :com.palletops.awaze.client-builder/undef)
     (. bean11962 setHeaders (cloudfront/headers v11964))))
   bean11962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.TrustedSigners}
trusted-signers
  [m11966]
  (clojure.core/let
   [bean11965
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/let
    [v11967
     (:quantity m11966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11967 :com.palletops.awaze.client-builder/undef)
     (. bean11965 setQuantity (clojure.core/int v11967))))
   (clojure.core/let
    [v11967 (:items m11966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11967 :com.palletops.awaze.client-builder/undef)
     (.
      bean11965
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12116] (clojure.core/str arg12116))
 v11967))))
   (clojure.core/let
    [v11967
     (:enabled m11966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11967 :com.palletops.awaze.client-builder/undef)
     (. bean11965 setEnabled (clojure.core/boolean v11967))))
   bean11965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy}
viewer-protocol-policy
  [m11969]
  (.
   com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy
   fromValue
   (clojure.core/name m11969)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.AllowedMethods}
allowed-methods
  [m11972]
  (clojure.core/let
   [bean11971
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/let
    [v11973
     (:cached-methods
      m11972
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11973 :com.palletops.awaze.client-builder/undef)
     (. bean11971 setCachedMethods (cloudfront/cached-methods v11973))))
   (clojure.core/let
    [v11973
     (:quantity m11972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11973 :com.palletops.awaze.client-builder/undef)
     (. bean11971 setQuantity (clojure.core/int v11973))))
   (clojure.core/let
    [v11973 (:items m11972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11973 :com.palletops.awaze.client-builder/undef)
     (.
      bean11971
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12117] (clojure.core/str arg12117))
 v11973))))
   bean11971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3OriginConfig}
s3origin-config
  [m11975]
  (clojure.core/let
   [bean11974
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/let
    [v11976
     (:origin-access-identity
      m11975
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11976 :com.palletops.awaze.client-builder/undef)
     (. bean11974 setOriginAccessIdentity (clojure.core/str v11976))))
   bean11974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomOriginConfig}
custom-origin-config
  [m11978]
  (clojure.core/let
   [bean11977
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/let
    [v11979
     (:httpport m11978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (. bean11977 setHTTPPort (clojure.core/int v11979))))
   (clojure.core/let
    [v11979
     (:httpsport m11978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (. bean11977 setHTTPSPort (clojure.core/int v11979))))
   (clojure.core/let
    [v11979
     (:origin-protocol-policy
      m11978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (. bean11977 setOriginProtocolPolicy (clojure.core/str v11979))))
   (clojure.core/let
    [v11979
     (:origin-ssl-protocols
      m11978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (.
      bean11977
      setOriginSslProtocols
      (cloudfront/origin-ssl-protocols v11979))))
   bean11977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomHeaders}
custom-headers
  [m11981]
  (clojure.core/let
   [bean11980
    (new com.amazonaws.services.cloudfront.model.CustomHeaders)]
   (clojure.core/let
    [v11982
     (:quantity m11981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11982 :com.palletops.awaze.client-builder/undef)
     (. bean11980 setQuantity (clojure.core/int v11982))))
   (clojure.core/let
    [v11982 (:items m11981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11982 :com.palletops.awaze.client-builder/undef)
     (.
      bean11980
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12118]
  (cloudfront/origin-custom-header arg12118))
 v11982))))
   bean11980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GeoRestriction}
geo-restriction
  [m11984]
  (clojure.core/let
   [bean11983
    (new com.amazonaws.services.cloudfront.model.GeoRestriction)]
   (clojure.core/let
    [v11985
     (:restriction-type
      m11984
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11985 :com.palletops.awaze.client-builder/undef)
     (. bean11983 setRestrictionType (clojure.core/str v11985))))
   (clojure.core/let
    [v11985
     (:quantity m11984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11985 :com.palletops.awaze.client-builder/undef)
     (. bean11983 setQuantity (clojure.core/int v11985))))
   (clojure.core/let
    [v11985 (:items m11984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11985 :com.palletops.awaze.client-builder/undef)
     (.
      bean11983
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12119] (clojure.core/str arg12119))
 v11985))))
   bean11983))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehavior}
cache-behavior
  [m11987]
  (clojure.core/let
   [bean11986
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/let
    [v11988
     (:smooth-streaming
      m11987
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setSmoothStreaming (clojure.core/boolean v11988))))
   (clojure.core/let
    [v11988
     (:path-pattern m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setPathPattern (clojure.core/str v11988))))
   (clojure.core/let
    [v11988
     (:forwarded-values
      m11987
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (.
      bean11986
      setForwardedValues
      (cloudfront/forwarded-values v11988))))
   (clojure.core/let
    [v11988
     (:trusted-signers
      m11987
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (.
      bean11986
      setTrustedSigners
      (cloudfront/trusted-signers v11988))))
   (clojure.core/let
    [v11988
     (:max-ttl m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setMaxTTL (clojure.core/long v11988))))
   (clojure.core/let
    [v11988
     (:viewer-protocol-policy
      m11987
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (.
      bean11986
      setViewerProtocolPolicy
      (cloudfront/viewer-protocol-policy v11988))))
   (clojure.core/let
    [v11988
     (:target-origin-id
      m11987
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setTargetOriginId (clojure.core/str v11988))))
   (clojure.core/let
    [v11988
     (:default-ttl m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setDefaultTTL (clojure.core/long v11988))))
   (clojure.core/let
    [v11988
     (:compress m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setCompress (clojure.core/boolean v11988))))
   (clojure.core/let
    [v11988
     (:allowed-methods
      m11987
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (.
      bean11986
      setAllowedMethods
      (cloudfront/allowed-methods v11988))))
   (clojure.core/let
    [v11988
     (:min-ttl m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setMinTTL (clojure.core/long v11988))))
   bean11986))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.MinimumProtocolVersion}
minimum-protocol-version
  [m11990]
  (.
   com.amazonaws.services.cloudfront.model.MinimumProtocolVersion
   fromValue
   (clojure.core/name m11990)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origin}
origin
  [m11993]
  (clojure.core/let
   [bean11992 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/let
    [v11994
     (:s3origin-config
      m11993
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (.
      bean11992
      setS3OriginConfig
      (cloudfront/s3origin-config v11994))))
   (clojure.core/let
    [v11994
     (:custom-origin-config
      m11993
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (.
      bean11992
      setCustomOriginConfig
      (cloudfront/custom-origin-config v11994))))
   (clojure.core/let
    [v11994
     (:origin-path m11993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setOriginPath (clojure.core/str v11994))))
   (clojure.core/let
    [v11994
     (:custom-headers
      m11993
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setCustomHeaders (cloudfront/custom-headers v11994))))
   (clojure.core/let
    [v11994
     (:domain-name m11993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setDomainName (clojure.core/str v11994))))
   (clojure.core/let
    [v11994 (:id m11993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setId (clojure.core/str v11994))))
   bean11992))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponse}
custom-error-response
  [m11996]
  (clojure.core/let
   [bean11995
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/let
    [v11997
     (:response-page-path
      m11996
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (. bean11995 setResponsePagePath (clojure.core/str v11997))))
   (clojure.core/let
    [v11997
     (:response-code m11996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (. bean11995 setResponseCode (clojure.core/str v11997))))
   (clojure.core/let
    [v11997
     (:error-caching-min-ttl
      m11996
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (. bean11995 setErrorCachingMinTTL (clojure.core/long v11997))))
   (clojure.core/let
    [v11997
     (:error-code m11996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (. bean11995 setErrorCode (clojure.core/int v11997))))
   bean11995))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Paths}
paths
  [m11999]
  (clojure.core/let
   [bean11998 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/let
    [v12000
     (:quantity m11999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setQuantity (clojure.core/int v12000))))
   (clojure.core/let
    [v12000 (:items m11999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (.
      bean11998
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12120] (clojure.core/str arg12120))
 v12000))))
   bean11998))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Restrictions}
restrictions
  [m12002]
  (clojure.core/let
   [bean12001
    (new com.amazonaws.services.cloudfront.model.Restrictions)]
   (clojure.core/let
    [v12003
     (:geo-restriction
      m12002
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (.
      bean12001
      setGeoRestriction
      (cloudfront/geo-restriction v12003))))
   bean12001))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DefaultCacheBehavior}
default-cache-behavior
  [m12005]
  (clojure.core/let
   [bean12004
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/let
    [v12006
     (:smooth-streaming
      m12005
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setSmoothStreaming (clojure.core/boolean v12006))))
   (clojure.core/let
    [v12006
     (:forwarded-values
      m12005
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (.
      bean12004
      setForwardedValues
      (cloudfront/forwarded-values v12006))))
   (clojure.core/let
    [v12006
     (:trusted-signers
      m12005
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (.
      bean12004
      setTrustedSigners
      (cloudfront/trusted-signers v12006))))
   (clojure.core/let
    [v12006
     (:max-ttl m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setMaxTTL (clojure.core/long v12006))))
   (clojure.core/let
    [v12006
     (:viewer-protocol-policy
      m12005
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (.
      bean12004
      setViewerProtocolPolicy
      (cloudfront/viewer-protocol-policy v12006))))
   (clojure.core/let
    [v12006
     (:target-origin-id
      m12005
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setTargetOriginId (clojure.core/str v12006))))
   (clojure.core/let
    [v12006
     (:default-ttl m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setDefaultTTL (clojure.core/long v12006))))
   (clojure.core/let
    [v12006
     (:compress m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setCompress (clojure.core/boolean v12006))))
   (clojure.core/let
    [v12006
     (:allowed-methods
      m12005
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (.
      bean12004
      setAllowedMethods
      (cloudfront/allowed-methods v12006))))
   (clojure.core/let
    [v12006
     (:min-ttl m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setMinTTL (clojure.core/long v12006))))
   bean12004))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehaviors}
cache-behaviors
  [m12008]
  (clojure.core/let
   [bean12007
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/let
    [v12009
     (:quantity m12008 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12009 :com.palletops.awaze.client-builder/undef)
     (. bean12007 setQuantity (clojure.core/int v12009))))
   (clojure.core/let
    [v12009 (:items m12008 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12009 :com.palletops.awaze.client-builder/undef)
     (.
      bean12007
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12121] (cloudfront/cache-behavior arg12121))
 v12009))))
   bean12007))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerCertificate}
viewer-certificate
  [m12011]
  (clojure.core/let
   [bean12010
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/let
    [v12012
     (:sslsupport-method
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setSSLSupportMethod (clojure.core/str v12012))))
   (clojure.core/let
    [v12012
     (:minimum-protocol-version
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (.
      bean12010
      setMinimumProtocolVersion
      (cloudfront/minimum-protocol-version v12012))))
   (clojure.core/let
    [v12012
     (:certificate m12011 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setCertificate (clojure.core/str v12012))))
   (clojure.core/let
    [v12012
     (:certificate-source
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setCertificateSource (clojure.core/str v12012))))
   (clojure.core/let
    [v12012
     (:cloud-front-default-certificate
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (.
      bean12010
      setCloudFrontDefaultCertificate
      (clojure.core/boolean v12012))))
   (clojure.core/let
    [v12012
     (:iamcertificate-id
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setIAMCertificateId (clojure.core/str v12012))))
   (clojure.core/let
    [v12012
     (:acmcertificate-arn
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setACMCertificateArn (clojure.core/str v12012))))
   bean12010))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Aliases}
aliases
  [m12014]
  (clojure.core/let
   [bean12013 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/let
    [v12015
     (:quantity m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setQuantity (clojure.core/int v12015))))
   (clojure.core/let
    [v12015 (:items m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (.
      bean12013
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12122] (clojure.core/str arg12122))
 v12015))))
   bean12013))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.PriceClass}
price-class
  [m12017]
  (.
   com.amazonaws.services.cloudfront.model.PriceClass
   fromValue
   (clojure.core/name m12017)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origins}
origins
  [m12020]
  (clojure.core/let
   [bean12019 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/let
    [v12021
     (:quantity m12020 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setQuantity (clojure.core/int v12021))))
   (clojure.core/let
    [v12021 (:items m12020 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (.
      bean12019
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12123] (cloudfront/origin arg12123))
 v12021))))
   bean12019))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.LoggingConfig}
logging-config
  [m12023]
  (clojure.core/let
   [bean12022
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/let
    [v12024
     (:include-cookies
      m12023
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setIncludeCookies (clojure.core/boolean v12024))))
   (clojure.core/let
    [v12024
     (:bucket m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setBucket (clojure.core/str v12024))))
   (clojure.core/let
    [v12024
     (:prefix m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setPrefix (clojure.core/str v12024))))
   (clojure.core/let
    [v12024
     (:enabled m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setEnabled (clojure.core/boolean v12024))))
   bean12022))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponses}
custom-error-responses
  [m12026]
  (clojure.core/let
   [bean12025
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/let
    [v12027
     (:quantity m12026 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12027 :com.palletops.awaze.client-builder/undef)
     (. bean12025 setQuantity (clojure.core/int v12027))))
   (clojure.core/let
    [v12027 (:items m12026 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12027 :com.palletops.awaze.client-builder/undef)
     (.
      bean12025
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12124]
  (cloudfront/custom-error-response arg12124))
 v12027))))
   bean12025))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingLoggingConfig}
streaming-logging-config
  [m12029]
  (clojure.core/let
   [bean12028
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/let
    [v12030
     (:bucket m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (. bean12028 setBucket (clojure.core/str v12030))))
   (clojure.core/let
    [v12030
     (:prefix m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (. bean12028 setPrefix (clojure.core/str v12030))))
   (clojure.core/let
    [v12030
     (:enabled m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (. bean12028 setEnabled (clojure.core/boolean v12030))))
   bean12028))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3Origin}
s3origin
  [m12032]
  (clojure.core/let
   [bean12031 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/let
    [v12033
     (:origin-access-identity
      m12032
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (. bean12031 setOriginAccessIdentity (clojure.core/str v12033))))
   (clojure.core/let
    [v12033
     (:domain-name m12032 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (. bean12031 setDomainName (clojure.core/str v12033))))
   bean12031))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.InvalidationBatch}
invalidation-batch
  [m12035]
  (clojure.core/let
   [bean12034
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/let
    [v12036
     (:caller-reference
      m12035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setCallerReference (clojure.core/str v12036))))
   (clojure.core/let
    [v12036 (:paths m12035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setPaths (cloudfront/paths v12036))))
   bean12034))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DistributionConfig}
distribution-config
  [m12038]
  (clojure.core/let
   [bean12037
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/let
    [v12039
     (:restrictions m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setRestrictions (cloudfront/restrictions v12039))))
   (clojure.core/let
    [v12039
     (:default-root-object
      m12038
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setDefaultRootObject (clojure.core/str v12039))))
   (clojure.core/let
    [v12039
     (:default-cache-behavior
      m12038
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (.
      bean12037
      setDefaultCacheBehavior
      (cloudfront/default-cache-behavior v12039))))
   (clojure.core/let
    [v12039
     (:comment m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setComment (clojure.core/str v12039))))
   (clojure.core/let
    [v12039
     (:cache-behaviors
      m12038
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (.
      bean12037
      setCacheBehaviors
      (cloudfront/cache-behaviors v12039))))
   (clojure.core/let
    [v12039
     (:viewer-certificate
      m12038
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (.
      bean12037
      setViewerCertificate
      (cloudfront/viewer-certificate v12039))))
   (clojure.core/let
    [v12039
     (:aliases m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setAliases (cloudfront/aliases v12039))))
   (clojure.core/let
    [v12039
     (:enabled m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setEnabled (clojure.core/boolean v12039))))
   (clojure.core/let
    [v12039
     (:price-class m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setPriceClass (cloudfront/price-class v12039))))
   (clojure.core/let
    [v12039
     (:origins m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setOrigins (cloudfront/origins v12039))))
   (clojure.core/let
    [v12039
     (:caller-reference
      m12038
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setCallerReference (clojure.core/str v12039))))
   (clojure.core/let
    [v12039
     (:logging m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setLogging (cloudfront/logging-config v12039))))
   (clojure.core/let
    [v12039
     (:web-aclid m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setWebACLId (clojure.core/str v12039))))
   (clojure.core/let
    [v12039
     (:custom-error-responses
      m12038
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (.
      bean12037
      setCustomErrorResponses
      (cloudfront/custom-error-responses v12039))))
   bean12037))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig}
cloud-front-origin-access-identity-config
  [m12041]
  (clojure.core/let
   [bean12040
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/let
    [v12042
     (:comment m12041 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setComment (clojure.core/str v12042))))
   (clojure.core/let
    [v12042
     (:caller-reference
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setCallerReference (clojure.core/str v12042))))
   bean12040))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingDistributionConfig}
streaming-distribution-config
  [m12044]
  (clojure.core/let
   [bean12043
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/let
    [v12045
     (:comment m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setComment (clojure.core/str v12045))))
   (clojure.core/let
    [v12045
     (:caller-reference
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setCallerReference (clojure.core/str v12045))))
   (clojure.core/let
    [v12045
     (:aliases m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setAliases (cloudfront/aliases v12045))))
   (clojure.core/let
    [v12045
     (:logging m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (.
      bean12043
      setLogging
      (cloudfront/streaming-logging-config v12045))))
   (clojure.core/let
    [v12045
     (:price-class m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setPriceClass (clojure.core/str v12045))))
   (clojure.core/let
    [v12045
     (:s3origin m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setS3Origin (cloudfront/s3origin v12045))))
   (clojure.core/let
    [v12045
     (:trusted-signers
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (.
      bean12043
      setTrustedSigners
      (cloudfront/trusted-signers v12045))))
   (clojure.core/let
    [v12045
     (:enabled m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setEnabled (clojure.core/boolean v12045))))
   bean12043))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest}
get-streaming-distribution-request
  [m12047]
  (clojure.core/let
   [bean12046
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/let
    [v12048 (:id m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setId (clojure.core/str v12048))))
   bean12046))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateInvalidationRequest}
create-invalidation-request
  [m12050]
  (clojure.core/let
   [bean12049
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/let
    [v12051
     (:distribution-id
      m12050
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setDistributionId (clojure.core/str v12051))))
   (clojure.core/let
    [v12051
     (:invalidation-batch
      m12050
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (.
      bean12049
      setInvalidationBatch
      (cloudfront/invalidation-batch v12051))))
   bean12049))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteDistributionRequest}
delete-distribution-request
  [m12053]
  (clojure.core/let
   [bean12052
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/let
    [v12054
     (:if-match m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setIfMatch (clojure.core/str v12054))))
   (clojure.core/let
    [v12054 (:id m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setId (clojure.core/str v12054))))
   bean12052))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest}
delete-cloud-front-origin-access-identity-request
  [m12056]
  (clojure.core/let
   [bean12055
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12057
     (:if-match m12056 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12057 :com.palletops.awaze.client-builder/undef)
     (. bean12055 setIfMatch (clojure.core/str v12057))))
   (clojure.core/let
    [v12057 (:id m12056 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12057 :com.palletops.awaze.client-builder/undef)
     (. bean12055 setId (clojure.core/str v12057))))
   bean12055))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateDistributionRequest}
create-distribution-request
  [m12059]
  (clojure.core/let
   [bean12058
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/let
    [v12060
     (:distribution-config
      m12059
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12060 :com.palletops.awaze.client-builder/undef)
     (.
      bean12058
      setDistributionConfig
      (cloudfront/distribution-config v12060))))
   bean12058))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListInvalidationsRequest}
list-invalidations-request
  [m12062]
  (clojure.core/let
   [bean12061
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/let
    [v12063
     (:distribution-id
      m12062
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setDistributionId (clojure.core/str v12063))))
   (clojure.core/let
    [v12063
     (:marker m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setMarker (clojure.core/str v12063))))
   (clojure.core/let
    [v12063
     (:max-items m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setMaxItems (clojure.core/str v12063))))
   bean12061))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest}
list-streaming-distributions-request
  [m12065]
  (clojure.core/let
   [bean12064
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/let
    [v12066
     (:marker m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setMarker (clojure.core/str v12066))))
   (clojure.core/let
    [v12066
     (:max-items m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setMaxItems (clojure.core/str v12066))))
   bean12064))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest}
get-cloud-front-origin-access-identity-config-request
  [m12068]
  (clojure.core/let
   [bean12067
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/let
    [v12069 (:id m12068 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (. bean12067 setId (clojure.core/str v12069))))
   bean12067))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsRequest}
list-distributions-request
  [m12071]
  (clojure.core/let
   [bean12070
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/let
    [v12072
     (:marker m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setMarker (clojure.core/str v12072))))
   (clojure.core/let
    [v12072
     (:max-items m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setMaxItems (clojure.core/str v12072))))
   bean12070))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest}
create-cloud-front-origin-access-identity-request
  [m12074]
  (clojure.core/let
   [bean12073
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12075
     (:cloud-front-origin-access-identity-config
      m12074
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12075 :com.palletops.awaze.client-builder/undef)
     (.
      bean12073
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12075))))
   bean12073))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest}
update-streaming-distribution-request
  [m12077]
  (clojure.core/let
   [bean12076
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/let
    [v12078
     (:streaming-distribution-config
      m12077
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (.
      bean12076
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12078))))
   (clojure.core/let
    [v12078
     (:if-match m12077 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (. bean12076 setIfMatch (clojure.core/str v12078))))
   (clojure.core/let
    [v12078 (:id m12077 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (. bean12076 setId (clojure.core/str v12078))))
   bean12076))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest}
list-distributions-by-web-aclid-request
  [m12080]
  (clojure.core/let
   [bean12079
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest)]
   (clojure.core/let
    [v12081
     (:web-aclid m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (. bean12079 setWebACLId (clojure.core/str v12081))))
   (clojure.core/let
    [v12081
     (:marker m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (. bean12079 setMarker (clojure.core/str v12081))))
   (clojure.core/let
    [v12081
     (:max-items m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (. bean12079 setMaxItems (clojure.core/str v12081))))
   bean12079))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest}
list-cloud-front-origin-access-identities-request
  [m12083]
  (clojure.core/let
   [bean12082
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/let
    [v12084
     (:marker m12083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12084 :com.palletops.awaze.client-builder/undef)
     (. bean12082 setMarker (clojure.core/str v12084))))
   (clojure.core/let
    [v12084
     (:max-items m12083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12084 :com.palletops.awaze.client-builder/undef)
     (. bean12082 setMaxItems (clojure.core/str v12084))))
   bean12082))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionRequest}
get-distribution-request
  [m12086]
  (clojure.core/let
   [bean12085
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/let
    [v12087 (:id m12086 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12087 :com.palletops.awaze.client-builder/undef)
     (. bean12085 setId (clojure.core/str v12087))))
   bean12085))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest}
delete-streaming-distribution-request
  [m12089]
  (clojure.core/let
   [bean12088
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/let
    [v12090
     (:if-match m12089 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setIfMatch (clojure.core/str v12090))))
   (clojure.core/let
    [v12090 (:id m12089 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setId (clojure.core/str v12090))))
   bean12088))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest}
get-distribution-config-request
  [m12092]
  (clojure.core/let
   [bean12091
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/let
    [v12093 (:id m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setId (clojure.core/str v12093))))
   bean12091))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateDistributionRequest}
update-distribution-request
  [m12095]
  (clojure.core/let
   [bean12094
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/let
    [v12096
     (:distribution-config
      m12095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12096 :com.palletops.awaze.client-builder/undef)
     (.
      bean12094
      setDistributionConfig
      (cloudfront/distribution-config v12096))))
   (clojure.core/let
    [v12096
     (:if-match m12095 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12096 :com.palletops.awaze.client-builder/undef)
     (. bean12094 setIfMatch (clojure.core/str v12096))))
   (clojure.core/let
    [v12096 (:id m12095 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12096 :com.palletops.awaze.client-builder/undef)
     (. bean12094 setId (clojure.core/str v12096))))
   bean12094))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest}
get-cloud-front-origin-access-identity-request
  [m12098]
  (clojure.core/let
   [bean12097
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12099 (:id m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setId (clojure.core/str v12099))))
   bean12097))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest}
get-streaming-distribution-config-request
  [m12101]
  (clojure.core/let
   [bean12100
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/let
    [v12102 (:id m12101 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12102 :com.palletops.awaze.client-builder/undef)
     (. bean12100 setId (clojure.core/str v12102))))
   bean12100))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest}
update-cloud-front-origin-access-identity-request
  [m12104]
  (clojure.core/let
   [bean12103
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12105
     (:cloud-front-origin-access-identity-config
      m12104
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (.
      bean12103
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12105))))
   (clojure.core/let
    [v12105
     (:if-match m12104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (. bean12103 setIfMatch (clojure.core/str v12105))))
   (clojure.core/let
    [v12105 (:id m12104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (. bean12103 setId (clojure.core/str v12105))))
   bean12103))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest}
create-streaming-distribution-request
  [m12107]
  (clojure.core/let
   [bean12106
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/let
    [v12108
     (:streaming-distribution-config
      m12107
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12108 :com.palletops.awaze.client-builder/undef)
     (.
      bean12106
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12108))))
   bean12106))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetInvalidationRequest}
get-invalidation-request
  [m12110]
  (clojure.core/let
   [bean12109
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/let
    [v12111
     (:distribution-id
      m12110
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12111 :com.palletops.awaze.client-builder/undef)
     (. bean12109 setDistributionId (clojure.core/str v12111))))
   (clojure.core/let
    [v12111 (:id m12110 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12111 :com.palletops.awaze.client-builder/undef)
     (. bean12109 setId (clojure.core/str v12111))))
   bean12109))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m12125]
   (clojure.core/let
    [credentials12126 (:credentials m12125) args12127 (:args m12125)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12128
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12126)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12128
       getStreamingDistribution
       (cloudfront/get-streaming-distribution-request
        (clojure.core/nth args12127 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistribution"}
   [credentials12130 & args12131]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12132
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12130)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12132
      getStreamingDistribution
      (cloudfront/get-streaming-distribution-request
       (clojure.core/nth args12131 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m12133]
   (clojure.core/let
    [credentials12134 (:credentials m12133) args12135 (:args m12133)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12136
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12134)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12136
       createInvalidation
       (cloudfront/create-invalidation-request
        (clojure.core/nth args12135 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInvalidation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-invalidation,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInvalidation"}
   [credentials12138 & args12139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12140
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12138)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12140
      createInvalidation
      (cloudfront/create-invalidation-request
       (clojure.core/nth args12139 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m12141]
   (clojure.core/let
    [credentials12142 (:credentials m12141) args12143 (:args m12141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12144
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12142)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12144
       deleteDistribution
       (cloudfront/delete-distribution-request
        (clojure.core/nth args12143 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDistribution"}
   [credentials12146 & args12147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12148
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12146)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12148
      deleteDistribution
      (cloudfront/delete-distribution-request
       (clojure.core/nth args12147 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m12149]
   (clojure.core/let
    [credentials12150 (:credentials m12149) args12151 (:args m12149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12152
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12150)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12152
       deleteCloudFrontOriginAccessIdentity
       (cloudfront/delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args12151 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials12154 & args12155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12156
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12154)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12156
      deleteCloudFrontOriginAccessIdentity
      (cloudfront/delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args12155 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m12157]
   (clojure.core/let
    [credentials12158 (:credentials m12157) args12159 (:args m12157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12160
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12158)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12160
       createDistribution
       (cloudfront/create-distribution-request
        (clojure.core/nth args12159 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDistribution"}
   [credentials12162 & args12163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12164
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12162)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12164
      createDistribution
      (cloudfront/create-distribution-request
       (clojure.core/nth args12163 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m12165]
   (clojure.core/let
    [credentials12166 (:credentials m12165) args12167 (:args m12165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12168
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12166)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12168
       listInvalidations
       (cloudfront/list-invalidations-request
        (clojure.core/nth args12167 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInvalidations"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-invalidations,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-invalidations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInvalidations"}
   [credentials12170 & args12171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12172
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12170)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12172
      listInvalidations
      (cloudfront/list-invalidations-request
       (clojure.core/nth args12171 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m12173]
   (clojure.core/let
    [credentials12174 (:credentials m12173) args12175 (:args m12173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12176
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12174)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12176
       listStreamingDistributions
       (cloudfront/list-streaming-distributions-request
        (clojure.core/nth args12175 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-streaming-distributions,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listStreamingDistributions"}
   [credentials12178 & args12179]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12180
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12178)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12180
      listStreamingDistributions
      (cloudfront/list-streaming-distributions-request
       (clojure.core/nth args12179 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m12181]
   (clojure.core/let
    [credentials12182 (:credentials m12181) args12183 (:args m12181)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12184
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12182)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12184
       getCloudFrontOriginAccessIdentityConfig
       (cloudfront/get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args12183 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials12186 & args12187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12188
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12186)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12188
      getCloudFrontOriginAccessIdentityConfig
      (cloudfront/get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args12187 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m12189]
   (clojure.core/let
    [credentials12190 (:credentials m12189) args12191 (:args m12189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12192
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12190)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12192
       listDistributions
       (cloudfront/list-distributions-request
        (clojure.core/nth args12191 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-distributions,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributions"}
   [credentials12194 & args12195]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12196
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12194)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12196
      listDistributions
      (cloudfront/list-distributions-request
       (clojure.core/nth args12195 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m12197]
   (clojure.core/let
    [credentials12198 (:credentials m12197) args12199 (:args m12197)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12200
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12198)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12200
       createCloudFrontOriginAccessIdentity
       (cloudfront/create-cloud-front-origin-access-identity-request
        (clojure.core/nth args12199 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials12202 & args12203]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12204
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12202)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12204
      createCloudFrontOriginAccessIdentity
      (cloudfront/create-cloud-front-origin-access-identity-request
       (clojure.core/nth args12203 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m12205]
   (clojure.core/let
    [credentials12206 (:credentials m12205) args12207 (:args m12205)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12208
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12206)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12208
       updateStreamingDistribution
       (cloudfront/update-streaming-distribution-request
        (clojure.core/nth args12207 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStreamingDistribution"}
   [credentials12210 & args12211]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12212
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12210)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12212
      updateStreamingDistribution
      (cloudfront/update-streaming-distribution-request
       (clojure.core/nth args12211 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions-by-web-aclid
   [m12213]
   (clojure.core/let
    [credentials12214 (:credentials m12213) args12215 (:args m12213)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12216
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12214)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12216
       listDistributionsByWebACLId
       (cloudfront/list-distributions-by-web-aclid-request
        (clojure.core/nth args12215 0)))))))
  (clojure.core/defn
   list-distributions-by-web-aclid-map
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributionsByWebACLId"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-distributions-by-web-aclid,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions-by-web-aclid
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributionsByWebACLId"}
   [credentials12218 & args12219]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12220
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12218)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12220
      listDistributionsByWebACLId
      (cloudfront/list-distributions-by-web-aclid-request
       (clojure.core/nth args12219 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m12221]
   (clojure.core/let
    [credentials12222 (:credentials m12221) args12223 (:args m12221)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12224
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12222)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12224
       listCloudFrontOriginAccessIdentities
       (cloudfront/list-cloud-front-origin-access-identities-request
        (clojure.core/nth args12223 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials12226 & args12227]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12228
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12226)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12228
      listCloudFrontOriginAccessIdentities
      (cloudfront/list-cloud-front-origin-access-identities-request
       (clojure.core/nth args12227 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m12229]
   (clojure.core/let
    [credentials12230 (:credentials m12229) args12231 (:args m12229)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12232
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12230)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12232
       getDistribution
       (cloudfront/get-distribution-request
        (clojure.core/nth args12231 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistribution"}
   [credentials12234 & args12235]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12236
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12234)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12236
      getDistribution
      (cloudfront/get-distribution-request
       (clojure.core/nth args12235 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m12237]
   (clojure.core/let
    [credentials12238 (:credentials m12237) args12239 (:args m12237)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12240
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12238)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12240
       deleteStreamingDistribution
       (cloudfront/delete-streaming-distribution-request
        (clojure.core/nth args12239 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStreamingDistribution"}
   [credentials12242 & args12243]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12244
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12242)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12244
      deleteStreamingDistribution
      (cloudfront/delete-streaming-distribution-request
       (clojure.core/nth args12243 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m12245]
   (clojure.core/let
    [credentials12246 (:credentials m12245) args12247 (:args m12245)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12248
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12246)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12248
       getDistributionConfig
       (cloudfront/get-distribution-config-request
        (clojure.core/nth args12247 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistributionConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-distribution-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistributionConfig"}
   [credentials12250 & args12251]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12252
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12250)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12252
      getDistributionConfig
      (cloudfront/get-distribution-config-request
       (clojure.core/nth args12251 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m12253]
   (clojure.core/let
    [credentials12254 (:credentials m12253) args12255 (:args m12253)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12256
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12254)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12256
       updateDistribution
       (cloudfront/update-distribution-request
        (clojure.core/nth args12255 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateDistribution"}
   [credentials12258 & args12259]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12260
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12258)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12260
      updateDistribution
      (cloudfront/update-distribution-request
       (clojure.core/nth args12259 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m12261]
   (clojure.core/let
    [credentials12262 (:credentials m12261) args12263 (:args m12261)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12264
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12262)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12264
       getCloudFrontOriginAccessIdentity
       (cloudfront/get-cloud-front-origin-access-identity-request
        (clojure.core/nth args12263 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials12266 & args12267]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12268
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12266)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12268
      getCloudFrontOriginAccessIdentity
      (cloudfront/get-cloud-front-origin-access-identity-request
       (clojure.core/nth args12267 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m12269]
   (clojure.core/let
    [credentials12270 (:credentials m12269) args12271 (:args m12269)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12272
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12270)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12272
       getStreamingDistributionConfig
       (cloudfront/get-streaming-distribution-config-request
        (clojure.core/nth args12271 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistributionConfig"}
   [credentials12274 & args12275]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12276
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12274)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12276
      getStreamingDistributionConfig
      (cloudfront/get-streaming-distribution-config-request
       (clojure.core/nth args12275 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m12277]
   (clojure.core/let
    [credentials12278 (:credentials m12277) args12279 (:args m12277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12280
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12278)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12280
       updateCloudFrontOriginAccessIdentity
       (cloudfront/update-cloud-front-origin-access-identity-request
        (clojure.core/nth args12279 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials12282 & args12283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12284
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12282)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12284
      updateCloudFrontOriginAccessIdentity
      (cloudfront/update-cloud-front-origin-access-identity-request
       (clojure.core/nth args12283 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m12285]
   (clojure.core/let
    [credentials12286 (:credentials m12285) args12287 (:args m12285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12288
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12286)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12288
       createStreamingDistribution
       (cloudfront/create-streaming-distribution-request
        (clojure.core/nth args12287 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createStreamingDistribution"}
   [credentials12290 & args12291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12292
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12290)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12292
      createStreamingDistribution
      (cloudfront/create-streaming-distribution-request
       (clojure.core/nth args12291 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m12293]
   (clojure.core/let
    [credentials12294 (:credentials m12293) args12295 (:args m12293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12296
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12294)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12296
       getInvalidation
       (cloudfront/get-invalidation-request
        (clojure.core/nth args12295 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInvalidation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-invalidation,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInvalidation"}
   [credentials12298 & args12299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12300
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12298)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12300
      getInvalidation
      (cloudfront/get-invalidation-request
       (clojure.core/nth args12299 0))))))))
