(ns
 com.palletops.awaze.autoscaling
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.autoscaling :as autoscaling]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Ebs}
ebs
  [m6391]
  (clojure.core/let
   [bean6390 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/let
    [v6392
     (:encrypted m6391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6392 :com.palletops.awaze.client-builder/undef)
     (. bean6390 setEncrypted (clojure.core/boolean v6392))))
   (clojure.core/let
    [v6392
     (:snapshot-id m6391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6392 :com.palletops.awaze.client-builder/undef)
     (. bean6390 setSnapshotId (clojure.core/str v6392))))
   (clojure.core/let
    [v6392
     (:volume-type m6391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6392 :com.palletops.awaze.client-builder/undef)
     (. bean6390 setVolumeType (clojure.core/str v6392))))
   (clojure.core/let
    [v6392 (:iops m6391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6392 :com.palletops.awaze.client-builder/undef)
     (. bean6390 setIops (clojure.core/int v6392))))
   (clojure.core/let
    [v6392
     (:delete-on-termination
      m6391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6392 :com.palletops.awaze.client-builder/undef)
     (. bean6390 setDeleteOnTermination (clojure.core/boolean v6392))))
   (clojure.core/let
    [v6392
     (:volume-size m6391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6392 :com.palletops.awaze.client-builder/undef)
     (. bean6390 setVolumeSize (clojure.core/int v6392))))
   bean6390))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Tag}
tag
  [m6394]
  (clojure.core/let
   [bean6393 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/let
    [v6395
     (:resource-id m6394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6395 :com.palletops.awaze.client-builder/undef)
     (. bean6393 setResourceId (clojure.core/str v6395))))
   (clojure.core/let
    [v6395
     (:propagate-at-launch
      m6394
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6395 :com.palletops.awaze.client-builder/undef)
     (. bean6393 setPropagateAtLaunch (clojure.core/boolean v6395))))
   (clojure.core/let
    [v6395
     (:resource-type m6394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6395 :com.palletops.awaze.client-builder/undef)
     (. bean6393 setResourceType (clojure.core/str v6395))))
   (clojure.core/let
    [v6395 (:key m6394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6395 :com.palletops.awaze.client-builder/undef)
     (. bean6393 setKey (clojure.core/str v6395))))
   (clojure.core/let
    [v6395 (:value m6394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6395 :com.palletops.awaze.client-builder/undef)
     (. bean6393 setValue (clojure.core/str v6395))))
   bean6393))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.StepAdjustment}
step-adjustment
  [m6397]
  (clojure.core/let
   [bean6396
    (new com.amazonaws.services.autoscaling.model.StepAdjustment)]
   (clojure.core/let
    [v6398
     (:metric-interval-lower-bound
      m6397
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6398 :com.palletops.awaze.client-builder/undef)
     (.
      bean6396
      setMetricIntervalLowerBound
      (clojure.core/double v6398))))
   (clojure.core/let
    [v6398
     (:metric-interval-upper-bound
      m6397
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6398 :com.palletops.awaze.client-builder/undef)
     (.
      bean6396
      setMetricIntervalUpperBound
      (clojure.core/double v6398))))
   (clojure.core/let
    [v6398
     (:scaling-adjustment
      m6397
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6398 :com.palletops.awaze.client-builder/undef)
     (. bean6396 setScalingAdjustment (clojure.core/int v6398))))
   bean6396))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Filter}
filter
  [m6400]
  (clojure.core/let
   [bean6399 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/let
    [v6401 (:values m6400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6401 :com.palletops.awaze.client-builder/undef)
     (.
      bean6399
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6555] (clojure.core/str arg6555))
 v6401))))
   (clojure.core/let
    [v6401 (:name m6400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6401 :com.palletops.awaze.client-builder/undef)
     (. bean6399 setName (clojure.core/str v6401))))
   bean6399))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.InstanceMonitoring}
instance-monitoring
  [m6403]
  (clojure.core/let
   [bean6402
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/let
    [v6404 (:enabled m6403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6404 :com.palletops.awaze.client-builder/undef)
     (. bean6402 setEnabled (clojure.core/boolean v6404))))
   bean6402))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.BlockDeviceMapping}
block-device-mapping
  [m6406]
  (clojure.core/let
   [bean6405
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/let
    [v6407
     (:device-name m6406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6407 :com.palletops.awaze.client-builder/undef)
     (. bean6405 setDeviceName (clojure.core/str v6407))))
   (clojure.core/let
    [v6407
     (:virtual-name m6406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6407 :com.palletops.awaze.client-builder/undef)
     (. bean6405 setVirtualName (clojure.core/str v6407))))
   (clojure.core/let
    [v6407 (:ebs m6406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6407 :com.palletops.awaze.client-builder/undef)
     (. bean6405 setEbs (autoscaling/ebs v6407))))
   (clojure.core/let
    [v6407
     (:no-device m6406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6407 :com.palletops.awaze.client-builder/undef)
     (. bean6405 setNoDevice (clojure.core/boolean v6407))))
   bean6405))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest}
update-auto-scaling-group-request
  [m6409]
  (clojure.core/let
   [bean6408
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/let
    [v6410
     (:health-check-type
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setHealthCheckType (clojure.core/str v6410))))
   (clojure.core/let
    [v6410
     (:new-instances-protected-from-scale-in
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (.
      bean6408
      setNewInstancesProtectedFromScaleIn
      (clojure.core/boolean v6410))))
   (clojure.core/let
    [v6410
     (:availability-zones
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (.
      bean6408
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6556] (clojure.core/str arg6556))
 v6410))))
   (clojure.core/let
    [v6410
     (:desired-capacity
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setDesiredCapacity (clojure.core/int v6410))))
   (clojure.core/let
    [v6410
     (:placement-group
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setPlacementGroup (clojure.core/str v6410))))
   (clojure.core/let
    [v6410
     (:min-size m6409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setMinSize (clojure.core/int v6410))))
   (clojure.core/let
    [v6410
     (:launch-configuration-name
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setLaunchConfigurationName (clojure.core/str v6410))))
   (clojure.core/let
    [v6410
     (:health-check-grace-period
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setHealthCheckGracePeriod (clojure.core/int v6410))))
   (clojure.core/let
    [v6410
     (:termination-policies
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (.
      bean6408
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6557] (clojure.core/str arg6557))
 v6410))))
   (clojure.core/let
    [v6410
     (:auto-scaling-group-name
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setAutoScalingGroupName (clojure.core/str v6410))))
   (clojure.core/let
    [v6410
     (:max-size m6409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setMaxSize (clojure.core/int v6410))))
   (clojure.core/let
    [v6410
     (:vpczone-identifier
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setVPCZoneIdentifier (clojure.core/str v6410))))
   (clojure.core/let
    [v6410
     (:default-cooldown
      m6409
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6410 :com.palletops.awaze.client-builder/undef)
     (. bean6408 setDefaultCooldown (clojure.core/int v6410))))
   bean6408))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest}
attach-load-balancers-request
  [m6412]
  (clojure.core/let
   [bean6411
    (new
     com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest)]
   (clojure.core/let
    [v6413
     (:load-balancer-names
      m6412
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6413 :com.palletops.awaze.client-builder/undef)
     (.
      bean6411
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6558] (clojure.core/str arg6558))
 v6413))))
   (clojure.core/let
    [v6413
     (:auto-scaling-group-name
      m6412
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6413 :com.palletops.awaze.client-builder/undef)
     (. bean6411 setAutoScalingGroupName (clojure.core/str v6413))))
   bean6411))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest}
create-or-update-tags-request
  [m6415]
  (clojure.core/let
   [bean6414
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/let
    [v6416 (:tags m6415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6416 :com.palletops.awaze.client-builder/undef)
     (.
      bean6414
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6559] (autoscaling/tag arg6559))
 v6416))))
   bean6414))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ResumeProcessesRequest}
resume-processes-request
  [m6418]
  (clojure.core/let
   [bean6417
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/let
    [v6419
     (:scaling-processes
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (.
      bean6417
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6560] (clojure.core/str arg6560))
 v6419))))
   (clojure.core/let
    [v6419
     (:auto-scaling-group-name
      m6418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6419 :com.palletops.awaze.client-builder/undef)
     (. bean6417 setAutoScalingGroupName (clojure.core/str v6419))))
   bean6417))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest}
terminate-instance-in-auto-scaling-group-request
  [m6421]
  (clojure.core/let
   [bean6420
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/let
    [v6422
     (:instance-id m6421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (. bean6420 setInstanceId (clojure.core/str v6422))))
   (clojure.core/let
    [v6422
     (:should-decrement-desired-capacity
      m6421
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6422 :com.palletops.awaze.client-builder/undef)
     (.
      bean6420
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6422))))
   bean6420))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest}
delete-auto-scaling-group-request
  [m6424]
  (clojure.core/let
   [bean6423
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/let
    [v6425
     (:auto-scaling-group-name
      m6424
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6425 :com.palletops.awaze.client-builder/undef)
     (. bean6423 setAutoScalingGroupName (clojure.core/str v6425))))
   (clojure.core/let
    [v6425
     (:force-delete m6424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6425 :com.palletops.awaze.client-builder/undef)
     (. bean6423 setForceDelete (clojure.core/boolean v6425))))
   bean6423))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m6427]
  (clojure.core/let
   [bean6426
    (new
     com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v6428
     (:next-token m6427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6428 :com.palletops.awaze.client-builder/undef)
     (. bean6426 setNextToken (clojure.core/str v6428))))
   (clojure.core/let
    [v6428
     (:auto-scaling-group-name
      m6427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6428 :com.palletops.awaze.client-builder/undef)
     (. bean6426 setAutoScalingGroupName (clojure.core/str v6428))))
   (clojure.core/let
    [v6428
     (:max-records m6427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6428 :com.palletops.awaze.client-builder/undef)
     (. bean6426 setMaxRecords (clojure.core/int v6428))))
   bean6426))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest}
disable-metrics-collection-request
  [m6430]
  (clojure.core/let
   [bean6429
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/let
    [v6431
     (:auto-scaling-group-name
      m6430
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6431 :com.palletops.awaze.client-builder/undef)
     (. bean6429 setAutoScalingGroupName (clojure.core/str v6431))))
   (clojure.core/let
    [v6431 (:metrics m6430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6431 :com.palletops.awaze.client-builder/undef)
     (.
      bean6429
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6561] (clojure.core/str arg6561))
 v6431))))
   bean6429))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest}
describe-scheduled-actions-request
  [m6433]
  (clojure.core/let
   [bean6432
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/let
    [v6434
     (:next-token m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setNextToken (clojure.core/str v6434))))
   (clojure.core/let
    [v6434
     (:end-time m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (.
      bean6432
      setEndTime
      (com.palletops.awaze.common/to-date v6434))))
   (clojure.core/let
    [v6434
     (:start-time m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (.
      bean6432
      setStartTime
      (com.palletops.awaze.common/to-date v6434))))
   (clojure.core/let
    [v6434
     (:auto-scaling-group-name
      m6433
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setAutoScalingGroupName (clojure.core/str v6434))))
   (clojure.core/let
    [v6434
     (:max-records m6433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (. bean6432 setMaxRecords (clojure.core/int v6434))))
   (clojure.core/let
    [v6434
     (:scheduled-action-names
      m6433
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6434 :com.palletops.awaze.client-builder/undef)
     (.
      bean6432
      setScheduledActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6562] (clojure.core/str arg6562))
 v6434))))
   bean6432))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest}
delete-notification-configuration-request
  [m6436]
  (clojure.core/let
   [bean6435
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/let
    [v6437
     (:auto-scaling-group-name
      m6436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setAutoScalingGroupName (clojure.core/str v6437))))
   (clojure.core/let
    [v6437
     (:topic-arn m6436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6437 :com.palletops.awaze.client-builder/undef)
     (. bean6435 setTopicARN (clojure.core/str v6437))))
   bean6435))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest}
put-scaling-policy-request
  [m6439]
  (clojure.core/let
   [bean6438
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/let
    [v6440
     (:policy-type m6439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setPolicyType (clojure.core/str v6440))))
   (clojure.core/let
    [v6440
     (:policy-name m6439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setPolicyName (clojure.core/str v6440))))
   (clojure.core/let
    [v6440
     (:adjustment-type
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setAdjustmentType (clojure.core/str v6440))))
   (clojure.core/let
    [v6440
     (:step-adjustments
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (.
      bean6438
      setStepAdjustments
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6563] (autoscaling/step-adjustment arg6563))
 v6440))))
   (clojure.core/let
    [v6440
     (:min-adjustment-magnitude
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setMinAdjustmentMagnitude (clojure.core/int v6440))))
   (clojure.core/let
    [v6440
     (:scaling-adjustment
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setScalingAdjustment (clojure.core/int v6440))))
   (clojure.core/let
    [v6440
     (:auto-scaling-group-name
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setAutoScalingGroupName (clojure.core/str v6440))))
   (clojure.core/let
    [v6440
     (:cooldown m6439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setCooldown (clojure.core/int v6440))))
   (clojure.core/let
    [v6440
     (:metric-aggregation-type
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setMetricAggregationType (clojure.core/str v6440))))
   (clojure.core/let
    [v6440
     (:estimated-instance-warmup
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setEstimatedInstanceWarmup (clojure.core/int v6440))))
   (clojure.core/let
    [v6440
     (:min-adjustment-step
      m6439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6440 :com.palletops.awaze.client-builder/undef)
     (. bean6438 setMinAdjustmentStep (clojure.core/int v6440))))
   bean6438))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest}
describe-scaling-activities-request
  [m6442]
  (clojure.core/let
   [bean6441
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/let
    [v6443
     (:next-token m6442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (. bean6441 setNextToken (clojure.core/str v6443))))
   (clojure.core/let
    [v6443
     (:auto-scaling-group-name
      m6442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (. bean6441 setAutoScalingGroupName (clojure.core/str v6443))))
   (clojure.core/let
    [v6443
     (:max-records m6442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (. bean6441 setMaxRecords (clojure.core/int v6443))))
   (clojure.core/let
    [v6443
     (:activity-ids m6442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6443 :com.palletops.awaze.client-builder/undef)
     (.
      bean6441
      setActivityIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6564] (clojure.core/str arg6564))
 v6443))))
   bean6441))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest}
describe-lifecycle-hooks-request
  [m6445]
  (clojure.core/let
   [bean6444
    (new
     com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest)]
   (clojure.core/let
    [v6446
     (:auto-scaling-group-name
      m6445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6446 :com.palletops.awaze.client-builder/undef)
     (. bean6444 setAutoScalingGroupName (clojure.core/str v6446))))
   (clojure.core/let
    [v6446
     (:lifecycle-hook-names
      m6445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6446 :com.palletops.awaze.client-builder/undef)
     (.
      bean6444
      setLifecycleHookNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6565] (clojure.core/str arg6565))
 v6446))))
   bean6444))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest}
delete-launch-configuration-request
  [m6448]
  (clojure.core/let
   [bean6447
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/let
    [v6449
     (:launch-configuration-name
      m6448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6449 :com.palletops.awaze.client-builder/undef)
     (. bean6447 setLaunchConfigurationName (clojure.core/str v6449))))
   bean6447))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeletePolicyRequest}
delete-policy-request
  [m6451]
  (clojure.core/let
   [bean6450
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/let
    [v6452
     (:auto-scaling-group-name
      m6451
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6452 :com.palletops.awaze.client-builder/undef)
     (. bean6450 setAutoScalingGroupName (clojure.core/str v6452))))
   (clojure.core/let
    [v6452
     (:policy-name m6451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6452 :com.palletops.awaze.client-builder/undef)
     (. bean6450 setPolicyName (clojure.core/str v6452))))
   bean6450))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest}
create-auto-scaling-group-request
  [m6454]
  (clojure.core/let
   [bean6453
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/let
    [v6455
     (:health-check-type
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setHealthCheckType (clojure.core/str v6455))))
   (clojure.core/let
    [v6455
     (:new-instances-protected-from-scale-in
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (.
      bean6453
      setNewInstancesProtectedFromScaleIn
      (clojure.core/boolean v6455))))
   (clojure.core/let
    [v6455
     (:availability-zones
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (.
      bean6453
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6566] (clojure.core/str arg6566))
 v6455))))
   (clojure.core/let
    [v6455
     (:desired-capacity
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setDesiredCapacity (clojure.core/int v6455))))
   (clojure.core/let
    [v6455
     (:instance-id m6454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setInstanceId (clojure.core/str v6455))))
   (clojure.core/let
    [v6455
     (:placement-group
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setPlacementGroup (clojure.core/str v6455))))
   (clojure.core/let
    [v6455
     (:min-size m6454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setMinSize (clojure.core/int v6455))))
   (clojure.core/let
    [v6455 (:tags m6454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (.
      bean6453
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6567] (autoscaling/tag arg6567))
 v6455))))
   (clojure.core/let
    [v6455
     (:load-balancer-names
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (.
      bean6453
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6568] (clojure.core/str arg6568))
 v6455))))
   (clojure.core/let
    [v6455
     (:launch-configuration-name
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setLaunchConfigurationName (clojure.core/str v6455))))
   (clojure.core/let
    [v6455
     (:health-check-grace-period
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setHealthCheckGracePeriod (clojure.core/int v6455))))
   (clojure.core/let
    [v6455
     (:termination-policies
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (.
      bean6453
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6569] (clojure.core/str arg6569))
 v6455))))
   (clojure.core/let
    [v6455
     (:auto-scaling-group-name
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setAutoScalingGroupName (clojure.core/str v6455))))
   (clojure.core/let
    [v6455
     (:max-size m6454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setMaxSize (clojure.core/int v6455))))
   (clojure.core/let
    [v6455
     (:vpczone-identifier
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setVPCZoneIdentifier (clojure.core/str v6455))))
   (clojure.core/let
    [v6455
     (:default-cooldown
      m6454
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6455 :com.palletops.awaze.client-builder/undef)
     (. bean6453 setDefaultCooldown (clojure.core/int v6455))))
   bean6453))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest}
describe-scaling-process-types-request
  [m6457]
  (clojure.core/let
   [bean6456
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean6456))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m6460]
  (clojure.core/let
   [bean6459
    (new
     com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest)]
   bean6459))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest}
delete-scheduled-action-request
  [m6463]
  (clojure.core/let
   [bean6462
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/let
    [v6464
     (:auto-scaling-group-name
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setAutoScalingGroupName (clojure.core/str v6464))))
   (clojure.core/let
    [v6464
     (:scheduled-action-name
      m6463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6464 :com.palletops.awaze.client-builder/undef)
     (. bean6462 setScheduledActionName (clojure.core/str v6464))))
   bean6462))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest}
describe-notification-configurations-request
  [m6466]
  (clojure.core/let
   [bean6465
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/let
    [v6467
     (:next-token m6466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setNextToken (clojure.core/str v6467))))
   (clojure.core/let
    [v6467
     (:max-records m6466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (. bean6465 setMaxRecords (clojure.core/int v6467))))
   (clojure.core/let
    [v6467
     (:auto-scaling-group-names
      m6466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6467 :com.palletops.awaze.client-builder/undef)
     (.
      bean6465
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6570] (clojure.core/str arg6570))
 v6467))))
   bean6465))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest}
describe-adjustment-types-request
  [m6469]
  (clojure.core/let
   [bean6468
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean6468))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest}
describe-auto-scaling-instances-request
  [m6472]
  (clojure.core/let
   [bean6471
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/let
    [v6473
     (:next-token m6472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6473 :com.palletops.awaze.client-builder/undef)
     (. bean6471 setNextToken (clojure.core/str v6473))))
   (clojure.core/let
    [v6473
     (:instance-ids m6472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6473 :com.palletops.awaze.client-builder/undef)
     (.
      bean6471
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6571] (clojure.core/str arg6571))
 v6473))))
   (clojure.core/let
    [v6473
     (:max-records m6472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6473 :com.palletops.awaze.client-builder/undef)
     (. bean6471 setMaxRecords (clojure.core/int v6473))))
   bean6471))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest}
describe-termination-policy-types-request
  [m6475]
  (clojure.core/let
   [bean6474
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean6474))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachInstancesRequest}
attach-instances-request
  [m6478]
  (clojure.core/let
   [bean6477
    (new
     com.amazonaws.services.autoscaling.model.AttachInstancesRequest)]
   (clojure.core/let
    [v6479
     (:instance-ids m6478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6479 :com.palletops.awaze.client-builder/undef)
     (.
      bean6477
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6572] (clojure.core/str arg6572))
 v6479))))
   (clojure.core/let
    [v6479
     (:auto-scaling-group-name
      m6478
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6479 :com.palletops.awaze.client-builder/undef)
     (. bean6477 setAutoScalingGroupName (clojure.core/str v6479))))
   bean6477))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTagsRequest}
describe-tags-request
  [m6481]
  (clojure.core/let
   [bean6480
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/let
    [v6482 (:filters m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (.
      bean6480
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6573] (autoscaling/filter arg6573))
 v6482))))
   (clojure.core/let
    [v6482
     (:next-token m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setNextToken (clojure.core/str v6482))))
   (clojure.core/let
    [v6482
     (:max-records m6481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6482 :com.palletops.awaze.client-builder/undef)
     (. bean6480 setMaxRecords (clojure.core/int v6482))))
   bean6480))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteTagsRequest}
delete-tags-request
  [m6484]
  (clojure.core/let
   [bean6483
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/let
    [v6485 (:tags m6484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6485 :com.palletops.awaze.client-builder/undef)
     (.
      bean6483
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6574] (autoscaling/tag arg6574))
 v6485))))
   bean6483))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest}
put-notification-configuration-request
  [m6487]
  (clojure.core/let
   [bean6486
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/let
    [v6488
     (:auto-scaling-group-name
      m6487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6488 :com.palletops.awaze.client-builder/undef)
     (. bean6486 setAutoScalingGroupName (clojure.core/str v6488))))
   (clojure.core/let
    [v6488
     (:topic-arn m6487 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6488 :com.palletops.awaze.client-builder/undef)
     (. bean6486 setTopicARN (clojure.core/str v6488))))
   (clojure.core/let
    [v6488
     (:notification-types
      m6487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6488 :com.palletops.awaze.client-builder/undef)
     (.
      bean6486
      setNotificationTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6575] (clojure.core/str arg6575))
 v6488))))
   bean6486))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest}
detach-load-balancers-request
  [m6490]
  (clojure.core/let
   [bean6489
    (new
     com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest)]
   (clojure.core/let
    [v6491
     (:load-balancer-names
      m6490
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6491 :com.palletops.awaze.client-builder/undef)
     (.
      bean6489
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6576] (clojure.core/str arg6576))
 v6491))))
   (clojure.core/let
    [v6491
     (:auto-scaling-group-name
      m6490
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6491 :com.palletops.awaze.client-builder/undef)
     (. bean6489 setAutoScalingGroupName (clojure.core/str v6491))))
   bean6489))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest}
describe-auto-scaling-notification-types-request
  [m6493]
  (clojure.core/let
   [bean6492
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean6492))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest}
set-instance-protection-request
  [m6496]
  (clojure.core/let
   [bean6495
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest)]
   (clojure.core/let
    [v6497
     (:instance-ids m6496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6497 :com.palletops.awaze.client-builder/undef)
     (.
      bean6495
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6577] (clojure.core/str arg6577))
 v6497))))
   (clojure.core/let
    [v6497
     (:auto-scaling-group-name
      m6496
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6497 :com.palletops.awaze.client-builder/undef)
     (. bean6495 setAutoScalingGroupName (clojure.core/str v6497))))
   (clojure.core/let
    [v6497
     (:protected-from-scale-in
      m6496
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6497 :com.palletops.awaze.client-builder/undef)
     (. bean6495 setProtectedFromScaleIn (clojure.core/boolean v6497))))
   bean6495))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest}
complete-lifecycle-action-request
  [m6499]
  (clojure.core/let
   [bean6498
    (new
     com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest)]
   (clojure.core/let
    [v6500
     (:instance-id m6499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (. bean6498 setInstanceId (clojure.core/str v6500))))
   (clojure.core/let
    [v6500
     (:auto-scaling-group-name
      m6499
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (. bean6498 setAutoScalingGroupName (clojure.core/str v6500))))
   (clojure.core/let
    [v6500
     (:lifecycle-action-token
      m6499
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (. bean6498 setLifecycleActionToken (clojure.core/str v6500))))
   (clojure.core/let
    [v6500
     (:lifecycle-action-result
      m6499
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (. bean6498 setLifecycleActionResult (clojure.core/str v6500))))
   (clojure.core/let
    [v6500
     (:lifecycle-hook-name
      m6499
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6500 :com.palletops.awaze.client-builder/undef)
     (. bean6498 setLifecycleHookName (clojure.core/str v6500))))
   bean6498))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SuspendProcessesRequest}
suspend-processes-request
  [m6502]
  (clojure.core/let
   [bean6501
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/let
    [v6503
     (:scaling-processes
      m6502
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6503 :com.palletops.awaze.client-builder/undef)
     (.
      bean6501
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6578] (clojure.core/str arg6578))
 v6503))))
   (clojure.core/let
    [v6503
     (:auto-scaling-group-name
      m6502
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6503 :com.palletops.awaze.client-builder/undef)
     (. bean6501 setAutoScalingGroupName (clojure.core/str v6503))))
   bean6501))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest}
describe-auto-scaling-groups-request
  [m6505]
  (clojure.core/let
   [bean6504
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/let
    [v6506
     (:next-token m6505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6506 :com.palletops.awaze.client-builder/undef)
     (. bean6504 setNextToken (clojure.core/str v6506))))
   (clojure.core/let
    [v6506
     (:max-records m6505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6506 :com.palletops.awaze.client-builder/undef)
     (. bean6504 setMaxRecords (clojure.core/int v6506))))
   (clojure.core/let
    [v6506
     (:auto-scaling-group-names
      m6505
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6506 :com.palletops.awaze.client-builder/undef)
     (.
      bean6504
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6579] (clojure.core/str arg6579))
 v6506))))
   bean6504))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest}
put-lifecycle-hook-request
  [m6508]
  (clojure.core/let
   [bean6507
    (new
     com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest)]
   (clojure.core/let
    [v6509
     (:auto-scaling-group-name
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setAutoScalingGroupName (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:lifecycle-hook-name
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setLifecycleHookName (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:lifecycle-transition
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setLifecycleTransition (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:role-arn m6508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setRoleARN (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:notification-target-arn
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setNotificationTargetARN (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:notification-metadata
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setNotificationMetadata (clojure.core/str v6509))))
   (clojure.core/let
    [v6509
     (:heartbeat-timeout
      m6508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setHeartbeatTimeout (clojure.core/int v6509))))
   (clojure.core/let
    [v6509
     (:default-result m6508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6509 :com.palletops.awaze.client-builder/undef)
     (. bean6507 setDefaultResult (clojure.core/str v6509))))
   bean6507))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExecutePolicyRequest}
execute-policy-request
  [m6511]
  (clojure.core/let
   [bean6510
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/let
    [v6512
     (:auto-scaling-group-name
      m6511
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6512 :com.palletops.awaze.client-builder/undef)
     (. bean6510 setAutoScalingGroupName (clojure.core/str v6512))))
   (clojure.core/let
    [v6512
     (:honor-cooldown m6511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6512 :com.palletops.awaze.client-builder/undef)
     (. bean6510 setHonorCooldown (clojure.core/boolean v6512))))
   (clojure.core/let
    [v6512
     (:metric-value m6511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6512 :com.palletops.awaze.client-builder/undef)
     (. bean6510 setMetricValue (clojure.core/double v6512))))
   (clojure.core/let
    [v6512
     (:breach-threshold
      m6511
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6512 :com.palletops.awaze.client-builder/undef)
     (. bean6510 setBreachThreshold (clojure.core/double v6512))))
   (clojure.core/let
    [v6512
     (:policy-name m6511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6512 :com.palletops.awaze.client-builder/undef)
     (. bean6510 setPolicyName (clojure.core/str v6512))))
   bean6510))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest}
record-lifecycle-action-heartbeat-request
  [m6514]
  (clojure.core/let
   [bean6513
    (new
     com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest)]
   (clojure.core/let
    [v6515
     (:instance-id m6514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (. bean6513 setInstanceId (clojure.core/str v6515))))
   (clojure.core/let
    [v6515
     (:auto-scaling-group-name
      m6514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (. bean6513 setAutoScalingGroupName (clojure.core/str v6515))))
   (clojure.core/let
    [v6515
     (:lifecycle-action-token
      m6514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (. bean6513 setLifecycleActionToken (clojure.core/str v6515))))
   (clojure.core/let
    [v6515
     (:lifecycle-hook-name
      m6514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6515 :com.palletops.awaze.client-builder/undef)
     (. bean6513 setLifecycleHookName (clojure.core/str v6515))))
   bean6513))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExitStandbyRequest}
exit-standby-request
  [m6517]
  (clojure.core/let
   [bean6516
    (new com.amazonaws.services.autoscaling.model.ExitStandbyRequest)]
   (clojure.core/let
    [v6518
     (:instance-ids m6517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (.
      bean6516
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6580] (clojure.core/str arg6580))
 v6518))))
   (clojure.core/let
    [v6518
     (:auto-scaling-group-name
      m6517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6518 :com.palletops.awaze.client-builder/undef)
     (. bean6516 setAutoScalingGroupName (clojure.core/str v6518))))
   bean6516))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DetachInstancesRequest}
detach-instances-request
  [m6520]
  (clojure.core/let
   [bean6519
    (new
     com.amazonaws.services.autoscaling.model.DetachInstancesRequest)]
   (clojure.core/let
    [v6521
     (:instance-ids m6520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6521 :com.palletops.awaze.client-builder/undef)
     (.
      bean6519
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6581] (clojure.core/str arg6581))
 v6521))))
   (clojure.core/let
    [v6521
     (:should-decrement-desired-capacity
      m6520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6521 :com.palletops.awaze.client-builder/undef)
     (.
      bean6519
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6521))))
   (clojure.core/let
    [v6521
     (:auto-scaling-group-name
      m6520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6521 :com.palletops.awaze.client-builder/undef)
     (. bean6519 setAutoScalingGroupName (clojure.core/str v6521))))
   bean6519))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest}
set-desired-capacity-request
  [m6523]
  (clojure.core/let
   [bean6522
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/let
    [v6524
     (:auto-scaling-group-name
      m6523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setAutoScalingGroupName (clojure.core/str v6524))))
   (clojure.core/let
    [v6524
     (:honor-cooldown m6523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setHonorCooldown (clojure.core/boolean v6524))))
   (clojure.core/let
    [v6524
     (:desired-capacity
      m6523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6524 :com.palletops.awaze.client-builder/undef)
     (. bean6522 setDesiredCapacity (clojure.core/int v6524))))
   bean6522))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest}
set-instance-health-request
  [m6526]
  (clojure.core/let
   [bean6525
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/let
    [v6527
     (:instance-id m6526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (. bean6525 setInstanceId (clojure.core/str v6527))))
   (clojure.core/let
    [v6527
     (:health-status m6526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (. bean6525 setHealthStatus (clojure.core/str v6527))))
   (clojure.core/let
    [v6527
     (:should-respect-grace-period
      m6526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6527 :com.palletops.awaze.client-builder/undef)
     (.
      bean6525
      setShouldRespectGracePeriod
      (clojure.core/boolean v6527))))
   bean6525))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribePoliciesRequest}
describe-policies-request
  [m6529]
  (clojure.core/let
   [bean6528
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/let
    [v6530
     (:next-token m6529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (. bean6528 setNextToken (clojure.core/str v6530))))
   (clojure.core/let
    [v6530
     (:policy-names m6529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (.
      bean6528
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6638] (clojure.core/str arg6638))
 v6530))))
   (clojure.core/let
    [v6530
     (:auto-scaling-group-name
      m6529
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (. bean6528 setAutoScalingGroupName (clojure.core/str v6530))))
   (clojure.core/let
    [v6530
     (:max-records m6529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (. bean6528 setMaxRecords (clojure.core/int v6530))))
   (clojure.core/let
    [v6530
     (:policy-types m6529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6530 :com.palletops.awaze.client-builder/undef)
     (.
      bean6528
      setPolicyTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6639] (clojure.core/str arg6639))
 v6530))))
   bean6528))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest}
put-scheduled-update-group-action-request
  [m6532]
  (clojure.core/let
   [bean6531
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/let
    [v6533 (:time m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setTime (com.palletops.awaze.common/to-date v6533))))
   (clojure.core/let
    [v6533
     (:desired-capacity
      m6532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setDesiredCapacity (clojure.core/int v6533))))
   (clojure.core/let
    [v6533
     (:scheduled-action-name
      m6532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setScheduledActionName (clojure.core/str v6533))))
   (clojure.core/let
    [v6533
     (:start-time m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (.
      bean6531
      setStartTime
      (com.palletops.awaze.common/to-date v6533))))
   (clojure.core/let
    [v6533
     (:recurrence m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setRecurrence (clojure.core/str v6533))))
   (clojure.core/let
    [v6533
     (:min-size m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setMinSize (clojure.core/int v6533))))
   (clojure.core/let
    [v6533
     (:end-time m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (.
      bean6531
      setEndTime
      (com.palletops.awaze.common/to-date v6533))))
   (clojure.core/let
    [v6533
     (:auto-scaling-group-name
      m6532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setAutoScalingGroupName (clojure.core/str v6533))))
   (clojure.core/let
    [v6533
     (:max-size m6532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6533 :com.palletops.awaze.client-builder/undef)
     (. bean6531 setMaxSize (clojure.core/int v6533))))
   bean6531))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnterStandbyRequest}
enter-standby-request
  [m6535]
  (clojure.core/let
   [bean6534
    (new com.amazonaws.services.autoscaling.model.EnterStandbyRequest)]
   (clojure.core/let
    [v6536
     (:instance-ids m6535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (.
      bean6534
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6640] (clojure.core/str arg6640))
 v6536))))
   (clojure.core/let
    [v6536
     (:should-decrement-desired-capacity
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (.
      bean6534
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6536))))
   (clojure.core/let
    [v6536
     (:auto-scaling-group-name
      m6535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6536 :com.palletops.awaze.client-builder/undef)
     (. bean6534 setAutoScalingGroupName (clojure.core/str v6536))))
   bean6534))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest}
enable-metrics-collection-request
  [m6538]
  (clojure.core/let
   [bean6537
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/let
    [v6539
     (:auto-scaling-group-name
      m6538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setAutoScalingGroupName (clojure.core/str v6539))))
   (clojure.core/let
    [v6539 (:metrics m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (.
      bean6537
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6641] (clojure.core/str arg6641))
 v6539))))
   (clojure.core/let
    [v6539
     (:granularity m6538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6539 :com.palletops.awaze.client-builder/undef)
     (. bean6537 setGranularity (clojure.core/str v6539))))
   bean6537))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest}
describe-metric-collection-types-request
  [m6541]
  (clojure.core/let
   [bean6540
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean6540))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest}
create-launch-configuration-request
  [m6544]
  (clojure.core/let
   [bean6543
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/let
    [v6545
     (:instance-monitoring
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (.
      bean6543
      setInstanceMonitoring
      (autoscaling/instance-monitoring v6545))))
   (clojure.core/let
    [v6545
     (:spot-price m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setSpotPrice (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:iam-instance-profile
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setIamInstanceProfile (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:classic-link-vpcid
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setClassicLinkVPCId (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:instance-type m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setInstanceType (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:ebs-optimized m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setEbsOptimized (clojure.core/boolean v6545))))
   (clojure.core/let
    [v6545
     (:ramdisk-id m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setRamdiskId (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:instance-id m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setInstanceId (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:image-id m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setImageId (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:launch-configuration-name
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setLaunchConfigurationName (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:key-name m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setKeyName (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:classic-link-vpcsecurity-groups
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (.
      bean6543
      setClassicLinkVPCSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6642] (clojure.core/str arg6642))
 v6545))))
   (clojure.core/let
    [v6545
     (:placement-tenancy
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setPlacementTenancy (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:kernel-id m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setKernelId (clojure.core/str v6545))))
   (clojure.core/let
    [v6545
     (:associate-public-ip-address
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (.
      bean6543
      setAssociatePublicIpAddress
      (clojure.core/boolean v6545))))
   (clojure.core/let
    [v6545
     (:security-groups
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (.
      bean6543
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6643] (clojure.core/str arg6643))
 v6545))))
   (clojure.core/let
    [v6545
     (:block-device-mappings
      m6544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (.
      bean6543
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6644]
  (autoscaling/block-device-mapping arg6644))
 v6545))))
   (clojure.core/let
    [v6545
     (:user-data m6544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6545 :com.palletops.awaze.client-builder/undef)
     (. bean6543 setUserData (clojure.core/str v6545))))
   bean6543))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest}
delete-lifecycle-hook-request
  [m6547]
  (clojure.core/let
   [bean6546
    (new
     com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest)]
   (clojure.core/let
    [v6548
     (:auto-scaling-group-name
      m6547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6548 :com.palletops.awaze.client-builder/undef)
     (. bean6546 setAutoScalingGroupName (clojure.core/str v6548))))
   (clojure.core/let
    [v6548
     (:lifecycle-hook-name
      m6547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6548 :com.palletops.awaze.client-builder/undef)
     (. bean6546 setLifecycleHookName (clojure.core/str v6548))))
   bean6546))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest}
describe-launch-configurations-request
  [m6550]
  (clojure.core/let
   [bean6549
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/let
    [v6551
     (:next-token m6550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6551 :com.palletops.awaze.client-builder/undef)
     (. bean6549 setNextToken (clojure.core/str v6551))))
   (clojure.core/let
    [v6551
     (:max-records m6550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6551 :com.palletops.awaze.client-builder/undef)
     (. bean6549 setMaxRecords (clojure.core/int v6551))))
   (clojure.core/let
    [v6551
     (:launch-configuration-names
      m6550
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6551 :com.palletops.awaze.client-builder/undef)
     (.
      bean6549
      setLaunchConfigurationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6645] (clojure.core/str arg6645))
 v6551))))
   bean6549))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest}
describe-lifecycle-hook-types-request
  [m6553]
  (clojure.core/let
   [bean6552
    (new
     com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest)]
   bean6552))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn
   autoscaling
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m6582]
   (clojure.core/let
    [credentials6583 (:credentials m6582) args6584 (:args m6582)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6585
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6583)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6585
       updateAutoScalingGroup
       (autoscaling/update-auto-scaling-group-request
        (clojure.core/nth args6584 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Call updateAutoScalingGroup"}
   [credentials6587 & args6588]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6589
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6587)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6589
      updateAutoScalingGroup
      (autoscaling/update-auto-scaling-group-request
       (clojure.core/nth args6588 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-load-balancers
   [m6590]
   (clojure.core/let
    [credentials6591 (:credentials m6590) args6592 (:args m6590)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6593
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6591)]
     (clojure.core/case
      (clojure.core/count args6592)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6593
        attachLoadBalancers
        (autoscaling/attach-load-balancers-request
         (clojure.core/nth args6592 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6593
        attachLoadBalancers))))))
  (clojure.core/defn
   attach-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Generate map for attachLoadBalancers, attachLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :attach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   attach-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Call attachLoadBalancers, attachLoadBalancers"}
   [credentials6595 & args6596]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6597
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6595)]
    (clojure.core/case
     (clojure.core/count args6596)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6597
       attachLoadBalancers
       (autoscaling/attach-load-balancers-request
        (clojure.core/nth args6596 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6597
       attachLoadBalancers))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m6598]
   (clojure.core/let
    [credentials6599 (:credentials m6598) args6600 (:args m6598)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6601
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6599)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6601
       createOrUpdateTags
       (autoscaling/create-or-update-tags-request
        (clojure.core/nth args6600 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-or-update-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createOrUpdateTags"}
   [credentials6603 & args6604]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6605
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6603)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6605
      createOrUpdateTags
      (autoscaling/create-or-update-tags-request
       (clojure.core/nth args6604 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m6606]
   (clojure.core/let
    [credentials6607 (:credentials m6606) args6608 (:args m6606)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6609
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6607)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6609
       resumeProcesses
       (autoscaling/resume-processes-request
        (clojure.core/nth args6608 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for resumeProcesses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :resume-processes,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   resume-processes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call resumeProcesses"}
   [credentials6611 & args6612]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6613
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6611)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6613
      resumeProcesses
      (autoscaling/resume-processes-request
       (clojure.core/nth args6612 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m6614]
   (clojure.core/let
    [credentials6615 (:credentials m6614) args6616 (:args m6614)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6617
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6615)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6617
       terminateInstanceInAutoScalingGroup
       (autoscaling/terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args6616 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         should-decrement-desired-capacity
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         should-decrement-desired-capacity
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials6619 & args6620]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6621
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6619)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6621
      terminateInstanceInAutoScalingGroup
      (autoscaling/terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args6620 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m6622]
   (clojure.core/let
    [credentials6623 (:credentials m6622) args6624 (:args m6622)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6625
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6623)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6625
       deleteAutoScalingGroup
       (autoscaling/delete-auto-scaling-group-request
        (clojure.core/nth args6624 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         force-delete
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         force-delete
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteAutoScalingGroup"}
   [credentials6627 & args6628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6629
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6627)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6629
      deleteAutoScalingGroup
      (autoscaling/delete-auto-scaling-group-request
       (clojure.core/nth args6628 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-load-balancers
   [m6630]
   (clojure.core/let
    [credentials6631 (:credentials m6630) args6632 (:args m6630)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6633
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6631)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6633
       describeLoadBalancers
       (autoscaling/describe-load-balancers-request
        (clojure.core/nth args6632 0)))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeLoadBalancers"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeLoadBalancers"}
   [credentials6635 & args6636]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6637
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6635)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6637
      describeLoadBalancers
      (autoscaling/describe-load-balancers-request
       (clojure.core/nth args6636 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m6646]
   (clojure.core/let
    [credentials6647 (:credentials m6646) args6648 (:args m6646)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6649
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6647)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6649
       disableMetricsCollection
       (autoscaling/disable-metrics-collection-request
        (clojure.core/nth args6648 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-metrics-collection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call disableMetricsCollection"}
   [credentials6651 & args6652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6653
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6651)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6653
      disableMetricsCollection
      (autoscaling/disable-metrics-collection-request
       (clojure.core/nth args6652 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m6654]
   (clojure.core/let
    [credentials6655 (:credentials m6654) args6656 (:args m6654)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6657
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6655)]
     (clojure.core/case
      (clojure.core/count args6656)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6657
        describeScheduledActions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6657
        describeScheduledActions
        (autoscaling/describe-scheduled-actions-request
         (clojure.core/nth args6656 0))))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scheduled-action-names
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scheduled-actions,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-actions,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scheduled-action-names
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials6659 & args6660]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6661
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6659)]
    (clojure.core/case
     (clojure.core/count args6660)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6661
       describeScheduledActions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6661
       describeScheduledActions
       (autoscaling/describe-scheduled-actions-request
        (clojure.core/nth args6660 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m6662]
   (clojure.core/let
    [credentials6663 (:credentials m6662) args6664 (:args m6662)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6665
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6663)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6665
       deleteNotificationConfiguration
       (autoscaling/delete-notification-configuration-request
        (clojure.core/nth args6664 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteNotificationConfiguration"}
   [credentials6667 & args6668]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6669
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6667)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6669
      deleteNotificationConfiguration
      (autoscaling/delete-notification-configuration-request
       (clojure.core/nth args6668 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m6670]
   (clojure.core/let
    [credentials6671 (:credentials m6670) args6672 (:args m6670)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6673
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6671)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6673
       putScalingPolicy
       (autoscaling/put-scaling-policy-request
        (clojure.core/nth args6672 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [estimated-instance-warmup
                         adjustment-type
                         custom-request-headers
                         sdk-client-execution-timeout
                         metric-aggregation-type
                         sdk-request-timeout
                         scaling-adjustment
                         min-adjustment-magnitude
                         custom-query-parameters
                         cooldown
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-type
                         clone-source
                         step-adjustments
                         clone-root
                         min-adjustment-step
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScalingPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-scaling-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists (quote
               [[credentials
                 {:keys [estimated-instance-warmup
                         adjustment-type
                         custom-request-headers
                         sdk-client-execution-timeout
                         metric-aggregation-type
                         sdk-request-timeout
                         scaling-adjustment
                         min-adjustment-magnitude
                         custom-query-parameters
                         cooldown
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-type
                         clone-source
                         step-adjustments
                         clone-root
                         min-adjustment-step
                         auto-scaling-group-name]}]]),
    :doc "Call putScalingPolicy"}
   [credentials6675 & args6676]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6677
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6675)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6677
      putScalingPolicy
      (autoscaling/put-scaling-policy-request
       (clojure.core/nth args6676 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m6678]
   (clojure.core/let
    [credentials6679 (:credentials m6678) args6680 (:args m6678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6681
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6679)]
     (clojure.core/case
      (clojure.core/count args6680)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6681
        describeScalingActivities))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6681
        describeScalingActivities
        (autoscaling/describe-scaling-activities-request
         (clojure.core/nth args6680 0))))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         activity-ids
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scaling-activities,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scaling-activities,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         activity-ids
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials6683 & args6684]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6685
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6683)]
    (clojure.core/case
     (clojure.core/count args6684)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6685
       describeScalingActivities))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6685
       describeScalingActivities
       (autoscaling/describe-scaling-activities-request
        (clojure.core/nth args6684 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-lifecycle-hooks
   [m6686]
   (clojure.core/let
    [credentials6687 (:credentials m6686) args6688 (:args m6686)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6689
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6687)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6689
       describeLifecycleHooks
       (autoscaling/describe-lifecycle-hooks-request
        (clojure.core/nth args6688 0)))))))
  (clojure.core/defn
   describe-lifecycle-hooks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-hook-names
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for describeLifecycleHooks"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-lifecycle-hooks,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-lifecycle-hooks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-hook-names
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call describeLifecycleHooks"}
   [credentials6691 & args6692]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6693
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6691)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6693
      describeLifecycleHooks
      (autoscaling/describe-lifecycle-hooks-request
       (clojure.core/nth args6692 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m6694]
   (clojure.core/let
    [credentials6695 (:credentials m6694) args6696 (:args m6694)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6697
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6695)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6697
       deleteLaunchConfiguration
       (autoscaling/delete-launch-configuration-request
        (clojure.core/nth args6696 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-launch-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLaunchConfiguration"}
   [credentials6699 & args6700]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6701
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6699)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6701
      deleteLaunchConfiguration
      (autoscaling/delete-launch-configuration-request
       (clojure.core/nth args6700 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m6702]
   (clojure.core/let
    [credentials6703 (:credentials m6702) args6704 (:args m6702)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6705
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6703)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6705
       deletePolicy
       (autoscaling/delete-policy-request
        (clojure.core/nth args6704 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deletePolicy"}
   [credentials6707 & args6708]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6709
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6707)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6709
      deletePolicy
      (autoscaling/delete-policy-request
       (clojure.core/nth args6708 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m6710]
   (clojure.core/let
    [credentials6711 (:credentials m6710) args6712 (:args m6710)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6713
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6711)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6713
       createAutoScalingGroup
       (autoscaling/create-auto-scaling-group-request
        (clojure.core/nth args6712 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         instance-id
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-auto-scaling-group,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         instance-id
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Call createAutoScalingGroup"}
   [credentials6715 & args6716]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6717
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6715)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6717
      createAutoScalingGroup
      (autoscaling/create-auto-scaling-group-request
       (clojure.core/nth args6716 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m6718]
   (clojure.core/let
    [credentials6719 (:credentials m6718) args6720 (:args m6718)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6721
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6719)]
     (clojure.core/case
      (clojure.core/count args6720)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6721
        describeScalingProcessTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6721
        describeScalingProcessTypes
        (autoscaling/describe-scaling-process-types-request
         (clojure.core/nth args6720 0))))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-scaling-process-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scaling-process-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials6723 & args6724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6725
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6723)]
    (clojure.core/case
     (clojure.core/count args6724)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6725
       describeScalingProcessTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6725
       describeScalingProcessTypes
       (autoscaling/describe-scaling-process-types-request
        (clojure.core/nth args6724 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-account-limits
   [m6726]
   (clojure.core/let
    [credentials6727 (:credentials m6726) args6728 (:args m6726)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6729
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6727)]
     (clojure.core/case
      (clojure.core/count args6728)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6729
        describeAccountLimits
        (autoscaling/describe-account-limits-request
         (clojure.core/nth args6728 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6729
        describeAccountLimits))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAccountLimits, describeAccountLimits"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAccountLimits, describeAccountLimits"}
   [credentials6731 & args6732]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6733
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6731)]
    (clojure.core/case
     (clojure.core/count args6732)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6733
       describeAccountLimits
       (autoscaling/describe-account-limits-request
        (clojure.core/nth args6732 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6733
       describeAccountLimits))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m6734]
   (clojure.core/let
    [credentials6735 (:credentials m6734) args6736 (:args m6734)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6737
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6735)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6737
       deleteScheduledAction
       (autoscaling/delete-scheduled-action-request
        (clojure.core/nth args6736 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-scheduled-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteScheduledAction"}
   [credentials6739 & args6740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6741
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6739)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6741
      deleteScheduledAction
      (autoscaling/delete-scheduled-action-request
       (clojure.core/nth args6740 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m6742]
   (clojure.core/let
    [credentials6743 (:credentials m6742) args6744 (:args m6742)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6745
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6743)]
     (clojure.core/case
      (clojure.core/count args6744)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6745
        describeNotificationConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6745
        describeNotificationConfigurations
        (autoscaling/describe-notification-configurations-request
         (clojure.core/nth args6744 0))))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-notification-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-notification-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials6747 & args6748]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6749
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6747)]
    (clojure.core/case
     (clojure.core/count args6748)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6749
       describeNotificationConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6749
       describeNotificationConfigurations
       (autoscaling/describe-notification-configurations-request
        (clojure.core/nth args6748 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m6750]
   (clojure.core/let
    [credentials6751 (:credentials m6750) args6752 (:args m6750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6753
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6751)]
     (clojure.core/case
      (clojure.core/count args6752)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6753
        describeAdjustmentTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6753
        describeAdjustmentTypes
        (autoscaling/describe-adjustment-types-request
         (clojure.core/nth args6752 0))))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-adjustment-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-adjustment-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials6755 & args6756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6757
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6755)]
    (clojure.core/case
     (clojure.core/count args6756)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6757
       describeAdjustmentTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6757
       describeAdjustmentTypes
       (autoscaling/describe-adjustment-types-request
        (clojure.core/nth args6756 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m6758]
   (clojure.core/let
    [credentials6759 (:credentials m6758) args6760 (:args m6758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6761
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6759)]
     (clojure.core/case
      (clojure.core/count args6760)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6761
        describeAutoScalingInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6761
        describeAutoScalingInstances
        (autoscaling/describe-auto-scaling-instances-request
         (clojure.core/nth args6760 0))))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials6763 & args6764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6765
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6763)]
    (clojure.core/case
     (clojure.core/count args6764)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6765
       describeAutoScalingInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6765
       describeAutoScalingInstances
       (autoscaling/describe-auto-scaling-instances-request
        (clojure.core/nth args6764 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m6766]
   (clojure.core/let
    [credentials6767 (:credentials m6766) args6768 (:args m6766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6769
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6767)]
     (clojure.core/case
      (clojure.core/count args6768)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6769
        describeTerminationPolicyTypes
        (autoscaling/describe-termination-policy-types-request
         (clojure.core/nth args6768 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6769
        describeTerminationPolicyTypes))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-termination-policy-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-termination-policy-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials6771 & args6772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6773
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6771)]
    (clojure.core/case
     (clojure.core/count args6772)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6773
       describeTerminationPolicyTypes
       (autoscaling/describe-termination-policy-types-request
        (clojure.core/nth args6772 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6773
       describeTerminationPolicyTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-instances
   [m6774]
   (clojure.core/let
    [credentials6775 (:credentials m6774) args6776 (:args m6774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6777
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6775)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6777
       attachInstances
       (autoscaling/attach-instances-request
        (clojure.core/nth args6776 0)))))))
  (clojure.core/defn
   attach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for attachInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   attach-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call attachInstances"}
   [credentials6779 & args6780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6781
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6779)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6781
      attachInstances
      (autoscaling/attach-instances-request
       (clojure.core/nth args6780 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m6782]
   (clojure.core/let
    [credentials6783 (:credentials m6782) args6784 (:args m6782)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6785
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6783)]
     (clojure.core/case
      (clojure.core/count args6784)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6785
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6785
        describeTags
        (autoscaling/describe-tags-request
         (clojure.core/nth args6784 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials6787 & args6788]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6789
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6787)]
    (clojure.core/case
     (clojure.core/count args6788)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6789
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6789
       describeTags
       (autoscaling/describe-tags-request
        (clojure.core/nth args6788 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m6790]
   (clojure.core/let
    [credentials6791 (:credentials m6790) args6792 (:args m6790)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6793
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6791)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6793
       deleteTags
       (autoscaling/delete-tags-request (clojure.core/nth args6792 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials6795 & args6796]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6797
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6795)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6797
      deleteTags
      (autoscaling/delete-tags-request (clojure.core/nth args6796 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m6798]
   (clojure.core/let
    [credentials6799 (:credentials m6798) args6800 (:args m6798)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6801
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6799)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6801
       putNotificationConfiguration
       (autoscaling/put-notification-configuration-request
        (clojure.core/nth args6800 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         notification-types
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         notification-types
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call putNotificationConfiguration"}
   [credentials6803 & args6804]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6805
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6803)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6805
      putNotificationConfiguration
      (autoscaling/put-notification-configuration-request
       (clojure.core/nth args6804 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :detach-load-balancers
   [m6806]
   (clojure.core/let
    [credentials6807 (:credentials m6806) args6808 (:args m6806)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6809
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6807)]
     (clojure.core/case
      (clojure.core/count args6808)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6809
        detachLoadBalancers
        (autoscaling/detach-load-balancers-request
         (clojure.core/nth args6808 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6809
        detachLoadBalancers))))))
  (clojure.core/defn
   detach-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Generate map for detachLoadBalancers, detachLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :detach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-load-balancers,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   detach-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Call detachLoadBalancers, detachLoadBalancers"}
   [credentials6811 & args6812]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6813
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6811)]
    (clojure.core/case
     (clojure.core/count args6812)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6813
       detachLoadBalancers
       (autoscaling/detach-load-balancers-request
        (clojure.core/nth args6812 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6813
       detachLoadBalancers))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m6814]
   (clojure.core/let
    [credentials6815 (:credentials m6814) args6816 (:args m6814)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6817
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6815)]
     (clojure.core/case
      (clojure.core/count args6816)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6817
        describeAutoScalingNotificationTypes
        (autoscaling/describe-auto-scaling-notification-types-request
         (clojure.core/nth args6816 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6817
        describeAutoScalingNotificationTypes))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials6819 & args6820]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6821
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6819)]
    (clojure.core/case
     (clojure.core/count args6820)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6821
       describeAutoScalingNotificationTypes
       (autoscaling/describe-auto-scaling-notification-types-request
        (clojure.core/nth args6820 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6821
       describeAutoScalingNotificationTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-protection
   [m6822]
   (clojure.core/let
    [credentials6823 (:credentials m6822) args6824 (:args m6822)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6825
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6823)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6825
       setInstanceProtection
       (autoscaling/set-instance-protection-request
        (clojure.core/nth args6824 0)))))))
  (clojure.core/defn
   set-instance-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         protected-from-scale-in
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setInstanceProtection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-instance-protection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-instance-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         protected-from-scale-in
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call setInstanceProtection"}
   [credentials6827 & args6828]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6829
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6827)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6829
      setInstanceProtection
      (autoscaling/set-instance-protection-request
       (clojure.core/nth args6828 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :complete-lifecycle-action
   [m6830]
   (clojure.core/let
    [credentials6831 (:credentials m6830) args6832 (:args m6830)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6833
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6831)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6833
       completeLifecycleAction
       (autoscaling/complete-lifecycle-action-request
        (clojure.core/nth args6832 0)))))))
  (clojure.core/defn
   complete-lifecycle-action-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         lifecycle-action-result
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for completeLifecycleAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-lifecycle-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   complete-lifecycle-action
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         lifecycle-action-result
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call completeLifecycleAction"}
   [credentials6835 & args6836]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6837
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6835)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6837
      completeLifecycleAction
      (autoscaling/complete-lifecycle-action-request
       (clojure.core/nth args6836 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m6838]
   (clojure.core/let
    [credentials6839 (:credentials m6838) args6840 (:args m6838)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6841
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6839)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6841
       suspendProcesses
       (autoscaling/suspend-processes-request
        (clojure.core/nth args6840 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for suspendProcesses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :suspend-processes,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   suspend-processes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call suspendProcesses"}
   [credentials6843 & args6844]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6845
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6843)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6845
      suspendProcesses
      (autoscaling/suspend-processes-request
       (clojure.core/nth args6844 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m6846]
   (clojure.core/let
    [credentials6847 (:credentials m6846) args6848 (:args m6846)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6849
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6847)]
     (clojure.core/case
      (clojure.core/count args6848)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6849
        describeAutoScalingGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6849
        describeAutoScalingGroups
        (autoscaling/describe-auto-scaling-groups-request
         (clojure.core/nth args6848 0))))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials6851 & args6852]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6853
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6851)]
    (clojure.core/case
     (clojure.core/count args6852)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6853
       describeAutoScalingGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6853
       describeAutoScalingGroups
       (autoscaling/describe-auto-scaling-groups-request
        (clojure.core/nth args6852 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-lifecycle-hook
   [m6854]
   (clojure.core/let
    [credentials6855 (:credentials m6854) args6856 (:args m6854)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6857
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6855)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6857
       putLifecycleHook
       (autoscaling/put-lifecycle-hook-request
        (clojure.core/nth args6856 0)))))))
  (clojure.core/defn
   put-lifecycle-hook-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-metadata
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-target-arn
                         sdk-request-timeout
                         custom-query-parameters
                         heartbeat-timeout
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-transition
                         clone-root
                         auto-scaling-group-name
                         default-result]}]]),
    :doc "Generate map for putLifecycleHook"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-lifecycle-hook,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-lifecycle-hook
   {:arglists (quote
               [[credentials
                 {:keys [notification-metadata
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-target-arn
                         sdk-request-timeout
                         custom-query-parameters
                         heartbeat-timeout
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-transition
                         clone-root
                         auto-scaling-group-name
                         default-result]}]]),
    :doc "Call putLifecycleHook"}
   [credentials6859 & args6860]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6861
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6859)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6861
      putLifecycleHook
      (autoscaling/put-lifecycle-hook-request
       (clojure.core/nth args6860 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m6862]
   (clojure.core/let
    [credentials6863 (:credentials m6862) args6864 (:args m6862)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6865
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6863)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6865
       executePolicy
       (autoscaling/execute-policy-request
        (clojure.core/nth args6864 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         breach-threshold
                         metric-value
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for executePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :execute-policy,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   execute-policy
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         breach-threshold
                         metric-value
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call executePolicy"}
   [credentials6867 & args6868]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6869
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6867)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6869
      executePolicy
      (autoscaling/execute-policy-request
       (clojure.core/nth args6868 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :record-lifecycle-action-heartbeat
   [m6870]
   (clojure.core/let
    [credentials6871 (:credentials m6870) args6872 (:args m6870)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6873
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6871)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6873
       recordLifecycleActionHeartbeat
       (autoscaling/record-lifecycle-action-heartbeat-request
        (clojure.core/nth args6872 0)))))))
  (clojure.core/defn
   record-lifecycle-action-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for recordLifecycleActionHeartbeat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :record-lifecycle-action-heartbeat,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   record-lifecycle-action-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call recordLifecycleActionHeartbeat"}
   [credentials6875 & args6876]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6877
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6875)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6877
      recordLifecycleActionHeartbeat
      (autoscaling/record-lifecycle-action-heartbeat-request
       (clojure.core/nth args6876 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :exit-standby
   [m6878]
   (clojure.core/let
    [credentials6879 (:credentials m6878) args6880 (:args m6878)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6881
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6879)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6881
       exitStandby
       (autoscaling/exit-standby-request
        (clojure.core/nth args6880 0)))))))
  (clojure.core/defn
   exit-standby-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for exitStandby"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :exit-standby,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   exit-standby
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call exitStandby"}
   [credentials6883 & args6884]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6885
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6883)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6885
      exitStandby
      (autoscaling/exit-standby-request (clojure.core/nth args6884 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :detach-instances
   [m6886]
   (clojure.core/let
    [credentials6887 (:credentials m6886) args6888 (:args m6886)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6889
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6887)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6889
       detachInstances
       (autoscaling/detach-instances-request
        (clojure.core/nth args6888 0)))))))
  (clojure.core/defn
   detach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for detachInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-instances,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   detach-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call detachInstances"}
   [credentials6891 & args6892]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6893
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6891)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6893
      detachInstances
      (autoscaling/detach-instances-request
       (clojure.core/nth args6892 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m6894]
   (clojure.core/let
    [credentials6895 (:credentials m6894) args6896 (:args m6894)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6897
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6895)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6897
       setDesiredCapacity
       (autoscaling/set-desired-capacity-request
        (clojure.core/nth args6896 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         desired-capacity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-desired-capacity,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         desired-capacity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call setDesiredCapacity"}
   [credentials6899 & args6900]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6901
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6899)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6901
      setDesiredCapacity
      (autoscaling/set-desired-capacity-request
       (clojure.core/nth args6900 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m6902]
   (clojure.core/let
    [credentials6903 (:credentials m6902) args6904 (:args m6902)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6905
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6903)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6905
       setInstanceHealth
       (autoscaling/set-instance-health-request
        (clojure.core/nth args6904 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [health-status
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         should-respect-grace-period]}]]),
    :doc "Generate map for setInstanceHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-instance-health,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [health-status
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         should-respect-grace-period]}]]),
    :doc "Call setInstanceHealth"}
   [credentials6907 & args6908]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6909
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6907)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6909
      setInstanceHealth
      (autoscaling/set-instance-health-request
       (clojure.core/nth args6908 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m6910]
   (clojure.core/let
    [credentials6911 (:credentials m6910) args6912 (:args m6910)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6913
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6911)]
     (clojure.core/case
      (clojure.core/count args6912)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6913
        describePolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6913
        describePolicies
        (autoscaling/describe-policies-request
         (clojure.core/nth args6912 0))))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         policy-types
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-policies,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-policies,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         policy-types
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describePolicies, describePolicies"}
   [credentials6915 & args6916]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6917
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6915)]
    (clojure.core/case
     (clojure.core/count args6916)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6917
       describePolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6917
       describePolicies
       (autoscaling/describe-policies-request
        (clojure.core/nth args6916 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m6918]
   (clojure.core/let
    [credentials6919 (:credentials m6918) args6920 (:args m6918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6921
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6919)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6921
       putScheduledUpdateGroupAction
       (autoscaling/put-scheduled-update-group-action-request
        (clojure.core/nth args6920 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         time
                         start-time
                         custom-query-parameters
                         end-time
                         max-size
                         desired-capacity
                         min-size
                         read-limit
                         general-progress-listener
                         recurrence
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-scheduled-update-group-action,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         time
                         start-time
                         custom-query-parameters
                         end-time
                         max-size
                         desired-capacity
                         min-size
                         read-limit
                         general-progress-listener
                         recurrence
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials6923 & args6924]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6925
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6923)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6925
      putScheduledUpdateGroupAction
      (autoscaling/put-scheduled-update-group-action-request
       (clojure.core/nth args6924 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enter-standby
   [m6926]
   (clojure.core/let
    [credentials6927 (:credentials m6926) args6928 (:args m6926)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6929
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6927)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6929
       enterStandby
       (autoscaling/enter-standby-request
        (clojure.core/nth args6928 0)))))))
  (clojure.core/defn
   enter-standby-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enterStandby"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enter-standby,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   enter-standby
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call enterStandby"}
   [credentials6931 & args6932]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6933
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6931)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6933
      enterStandby
      (autoscaling/enter-standby-request
       (clojure.core/nth args6932 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m6934]
   (clojure.core/let
    [credentials6935 (:credentials m6934) args6936 (:args m6934)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6937
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6935)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6937
       enableMetricsCollection
       (autoscaling/enable-metrics-collection-request
        (clojure.core/nth args6936 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         granularity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-metrics-collection,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         granularity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call enableMetricsCollection"}
   [credentials6939 & args6940]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6941
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6939)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6941
      enableMetricsCollection
      (autoscaling/enable-metrics-collection-request
       (clojure.core/nth args6940 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m6942]
   (clojure.core/let
    [credentials6943 (:credentials m6942) args6944 (:args m6942)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6945
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6943)]
     (clojure.core/case
      (clojure.core/count args6944)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6945
        describeMetricCollectionTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6945
        describeMetricCollectionTypes
        (autoscaling/describe-metric-collection-types-request
         (clojure.core/nth args6944 0))))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-metric-collection-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-metric-collection-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials6947 & args6948]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6949
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6947)]
    (clojure.core/case
     (clojure.core/count args6948)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6949
       describeMetricCollectionTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6949
       describeMetricCollectionTypes
       (autoscaling/describe-metric-collection-types-request
        (clojure.core/nth args6948 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m6950]
   (clojure.core/let
    [credentials6951 (:credentials m6950) args6952 (:args m6950)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6953
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6951)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6953
       createLaunchConfiguration
       (autoscaling/create-launch-configuration-request
        (clojure.core/nth args6952 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         security-groups
                         sdk-request-timeout
                         placement-tenancy
                         launch-configuration-name
                         instance-type
                         image-id
                         spot-price
                         instance-monitoring
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         iam-instance-profile
                         read-limit
                         classic-link-vpcsecurity-groups
                         kernel-id
                         general-progress-listener
                         associate-public-ip-address
                         classic-link-vpcid
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-launch-configuration,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         security-groups
                         sdk-request-timeout
                         placement-tenancy
                         launch-configuration-name
                         instance-type
                         image-id
                         spot-price
                         instance-monitoring
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         iam-instance-profile
                         read-limit
                         classic-link-vpcsecurity-groups
                         kernel-id
                         general-progress-listener
                         associate-public-ip-address
                         classic-link-vpcid
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createLaunchConfiguration"}
   [credentials6955 & args6956]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6957
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6955)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6957
      createLaunchConfiguration
      (autoscaling/create-launch-configuration-request
       (clojure.core/nth args6956 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-lifecycle-hook
   [m6958]
   (clojure.core/let
    [credentials6959 (:credentials m6958) args6960 (:args m6958)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6961
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6959)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6961
       deleteLifecycleHook
       (autoscaling/delete-lifecycle-hook-request
        (clojure.core/nth args6960 0)))))))
  (clojure.core/defn
   delete-lifecycle-hook-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteLifecycleHook"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-lifecycle-hook,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-lifecycle-hook
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteLifecycleHook"}
   [credentials6963 & args6964]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6965
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6963)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6965
      deleteLifecycleHook
      (autoscaling/delete-lifecycle-hook-request
       (clojure.core/nth args6964 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m6966]
   (clojure.core/let
    [credentials6967 (:credentials m6966) args6968 (:args m6966)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6969
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6967)]
     (clojure.core/case
      (clojure.core/count args6968)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6969
        describeLaunchConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6969
        describeLaunchConfigurations
        (autoscaling/describe-launch-configurations-request
         (clojure.core/nth args6968 0))))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-launch-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-launch-configurations,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials6971 & args6972]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6973
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6971)]
    (clojure.core/case
     (clojure.core/count args6972)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6973
       describeLaunchConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6973
       describeLaunchConfigurations
       (autoscaling/describe-launch-configurations-request
        (clojure.core/nth args6972 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-lifecycle-hook-types
   [m6974]
   (clojure.core/let
    [credentials6975 (:credentials m6974) args6976 (:args m6974)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6977
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6975)]
     (clojure.core/case
      (clojure.core/count args6976)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6977
        describeLifecycleHookTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6977
        describeLifecycleHookTypes
        (autoscaling/describe-lifecycle-hook-types-request
         (clojure.core/nth args6976 0))))))))
  (clojure.core/defn
   describe-lifecycle-hook-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLifecycleHookTypes, describeLifecycleHookTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-lifecycle-hook-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-lifecycle-hook-types,
     :credentials credentials__1842__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-lifecycle-hook-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLifecycleHookTypes, describeLifecycleHookTypes"}
   [credentials6979 & args6980]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6981
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6979)]
    (clojure.core/case
     (clojure.core/count args6980)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6981
       describeLifecycleHookTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6981
       describeLifecycleHookTypes
       (autoscaling/describe-lifecycle-hook-types-request
        (clojure.core/nth args6980 0)))))))))
