(ns stickler.scratch
  (:require [stickler.translate :as translate]
            [clojure.java.io    :as io]))

(def m (translate/translate {:dirs ["test/proto"]}))

(defn flatten-paths
  ([m separator]
   (flatten-paths m separator []))
  ([m separator path]
   (->> (map (fn [[k v]]
               (if (and (map? v) (not-empty v))
                 (flatten-paths v separator (conj path k))
                 [(->> (conj path k)
                       (map name)
                       (clojure.string/join separator)
                       keyword) v]))
             m)
        (into {}))))
