(ns winkel.core
  (:require [compojure.core :refer [routes GET POST]]
            [winkel.gateway.paypal :as paypal]
            [clojure.tools.logging :as log]
            [winkel.api :as api]))

(defn buy [plan]
  (let [resp (paypal/approve plan)]
    (log/info resp)
    (if (= (:state resp) "created")
      resp
      (log/fatal "Paypal approval failed"))))

(defn endpoint [{{queue :queue} :queue}]
  (routes
   (GET "/shop/payment" req (api/payment req queue))
   (GET "/shop/payment-cancel" req api/payment-cancel)
   (GET "/shop/:id/payment" req (api/payment req queue))
   (GET "/shop/:id/payment-cancel" req api/payment-cancel)
   (GET "/shop/:id/agreement" req (api/agreement req queue))
   (GET "/shop/:id/agreement-cancel" req api/agreement-cancel)))

(defn webhook-endpoint [{{queue :queue} :queue}]
  (routes
   (POST "/shop/webhooks" req (api/process-events req queue))))
