(ns winkel.core
  (:require [om.core :as om :include-macros true]
            [om.dom :as dom :include-macros true]
            [om-flash-bootstrap.core :as f]
            [taoensso.sente :as sente]
            [cljs.core.match :refer-macros [match]]
            [cljsjs.ladda]))

(defn plan
  "Om component for new plan"
  [data owner]
  (reify
    om/IDidMount
    (did-mount [_]
      (.bind js/Ladda (om/get-node owner "buy-button")))
    om/IDisplayName
    (display-name [this] "plan")
    om/IRender
    (render [_]
      (let [flash (om/get-state owner :flash)
            chsk-send! (om/get-state owner :chsk-send!)
            logged-in? (om/get-state owner :logged-in?)
            return-url (om/get-state owner :return-url)
            price (str (:amount data) " " (:currency data))]
        (dom/div #js {:className "col-sm-6 col-md-4 col-lg-3"}
                 (dom/div #js {:className "thumbnail"}
                          (dom/div #js {:className "caption"}
                                   (dom/h3 nil (:title data))
                                   (dom/p nil (:description data))
                                   (dom/span #js {:className "label label-default pull-right"} (str "Price: " price))
                                   (dom/button #js {:className "btn btn-primary ladda-button"
                                                    :data-style "expand-right"
                                                    :ref "buy-button"
                                                    :onClick (fn [_]
                                                               (if (not (logged-in?))
                                                                 (do
                                                                   (f/warn flash "You need to sign in first.")
                                                                   (.stopAll js/Ladda))
                                                                 (chsk-send! [:winkel/api {:buy (assoc data
                                                                                                       :return-url return-url)
                                                                                           }] 16000
                                                                             (fn [cb-reply]
                                                                               (match [cb-reply]
                                                                                      [{:status status :cause cause}] (do (f/alert flash (str (or cause status) ". Please try again later."))
                                                                                                                             (.stopAll js/Ladda))
                                                                                      [{:state _ :links links}] (let [approval (first (filter #(= (:rel %) "approval_url") links))
                                                                                                                      url (:href approval)]
                                                                                                                  (set! (.-location js/window) url))
                                                                                      [:chsk/timeout] (do (f/warn flash "The request timed out.")
                                                                                                          (.stopAll js/Ladda))
                                                                                      :else (println "no match found"))))))}
                                               (dom/span #js {:className "ladda-label"} "Buy")))))))))

(defn shop
  "Component that represents the shop."
  [data owner]
  (reify
    om/IWillMount
    (will-mount [_]
      (let [chsk-send! (om/get-state owner :chsk-send!)]
        (chsk-send! [:winkel/api {:get-plans (.. js/window -location -href)}] 8000
                    (fn [plans]
                      (when (sente/cb-success? plans)
                        (om/update! data :plans plans))))))
    om/IDisplayName
    (display-name [this]
      "shop")
    om/IRenderState
    (render-state [_ state]
      (dom/div #js {:className "row"}
               (om/build-all plan (:plans data) {:state state :key-fn :id})))))

