(ns facetious.core
  #?(:clj (:require [compojure.core :refer [routes GET POST]]
                    [facetious.helpers :as helpers]
                    (facetious.authentication 
                     [twitter :as twitter]
                     [etsy :as etsy]
                     [ecwid :as ecwid]
                     [shopify :as shopify]
                     [weebly :as weebly]
                     [bitly :as bitly]
                     [google :as google]
                     [github :as github]
                     [facebook :as facebook]
                     [threedcart :as threedcart]
                     [bigcommerce :as bigcommerce]))
     :cljs (:require [ajax.core :refer [GET POST]]
                     [om-flash-bootstrap.core :as f])))

#?(:clj (defn twitter [_]
          (routes
           (POST "/twitter/authorize" [] twitter/authorize)
           (GET "/twitter/callback" [] twitter/callback))))

#?(:clj (defn etsy [_]
          (routes
           (POST "/etsy/authorize" [] etsy/authorize)
           (GET "/etsy/callback" [] etsy/callback))))

#?(:clj (defn shopify [_]
          (routes
           (GET "/shopify/install" [] shopify/app-store)
           (POST "/shopify/authorize" [] shopify/authorize)
           (GET "/shopify/callback" [] shopify/callback))))

#?(:clj (defn bitly [_]
          (routes
           (POST "/bitly/authorize" [] bitly/authorize)
           (GET "/bitly/callback" [] bitly/callback))))

#?(:clj (defn ecwid [_]
          (routes
           (POST "/ecwid/authorize" [] ecwid/authorize)
           (GET "/ecwid/install" [] ecwid/callback))))

#?(:clj (defn weebly [_]
          (routes
           (GET "/weebly/install" [] weebly/app-store)
           (GET "/weebly/callback" [] weebly/callback)
           (GET "/weebly/jwt" [] weebly/register))))

#?(:clj (defn bigcommerce [_]
          (routes
           (GET "/bigcommerce/authorize" [] bigcommerce/authorize)
           (GET "/bigcommerce/callback" [] bigcommerce/callback))))

#?(:clj (defn threedcart [_]
          (routes
           (POST "/3dcart/callback" [] threedcart/callback))))

#?(:clj (defn facebook [_]
          (routes
              (POST "/facebook/authorize" [] facebook/authorize)
              (GET "/facebook/callback" [] facebook/callback))))

#?(:clj (defn google [_]
          (routes
           (POST "/google/authorize" [] google/authorize)
           (GET "/google/callback" [] google/callback))))

#?(:clj (defn github [_]
          (routes
              (POST "/github/authorize" [] github/authorize)
              (GET "/github/callback" [] github/callback))))

#?(:clj (defn logout [_]
          (routes
           (GET "/logout" [] helpers/logout))))

#?(:cljs
   (defn post [opts]
     (POST (:url opts)
         {:headers {"X-CSRF-Token" (:csrf-token opts)}
          :params {:type (:type opts)
                   :domain (:domain opts)}
          :handler (fn [response] (set! (.-location js/window) (str response)))
          :error-handler (fn [{:keys [status status-text]}]
                           (let [message (str status ":" status-text)]
                             (if (:flash opts)
                               (f/alert (:flash opts) message)
                               (println message))))})))
