(ns facetious.authentication.bigcommerce
  (:require [ring.util.response :as util]
            [environ.core :refer [env]]
            [hiccup.core :refer [html]]
            [hiccup.page :refer [html5 include-js include-css]]
            [clj-http.client :as client]
            [facetious.helpers :as helpers]
            [clojure.data.json :as json]
            [kryptos.core :as crypto :refer [Baze64]]
            [clojure.tools.logging :as log]
            [clojure.string :as str]))

(declare index)
(def oauth2-params
  {:access-token-uri "https://login.bigcommerce.com/oauth2/token"})

(defn callback [{headers :headers session :session params :params :as req}]
  (let [key (env :bigcommerce-secret)
        signature (:signed_payload params)
        [decoded_json_string decoded_hmac_signature] (mapv crypto/decode-base64-url (str/split signature #"\."))
        data (json/read-str decoded_json_string :key-fn keyword)
        session (assoc session :bigcommerce data)]
    (log/info data)
    (when (crypto/verify-hmac key decoded_json_string decoded_hmac_signature)
      (-> (util/redirect "/mini")
          (assoc :session session)))))

(defn authorize [{headers :headers session :session params :params :as req}]
  (let [resp (-> (client/post (:access-token-uri oauth2-params)
                              {:form-params {:client_id (:bigcommerce-client env)
                                             :client_secret (:bigcommerce-secret env)
                                             :code (:code params)
                                             :scope (:scope params)
                                             :context (:context params)
                                             :grant_type  "authorization_code"
                                             :redirect_uri (helpers/derive-callback headers "/bigcommerce/authorize")}
                               :throw-entire-message? true
                               :as :json})
                 :body)]
    (log/info "Bigcommerce auth response:" resp)
    (-> (util/redirect "/mini")
        (assoc :session (assoc session :bigcommerce resp)))) )
