(ns facetious.crypto
  (:require [pandect.algo.sha256 :refer :all])
  (:import javax.crypto.Cipher
           javax.crypto.spec.SecretKeySpec))

(defmulti sign (fn [key data] (type key)))
(defmethod sign javax.crypto.spec.SecretKeySpec [key data]
  (sha256-hmac data (.getEncoded key)))
(defmethod sign java.lang.String [key data]
  (sha256-hmac data key))

(defn verify-hmac [key data hmac]
  (= hmac (sign key data)))
