(ns facetious.helpers
  (:require [environ.core :refer [env]]
            [ring.util.response :refer [redirect]]))

(defn derive-callback [headers path & https?]
  (let [host (get headers "host")
        protocol (if (:facetious-https? env) "https://" "http://")]
    (str protocol host path)))

(defn logout [{session :session}]
  (-> (redirect "/")
      (assoc :session {})))
