(ns facetious.authentication.facebook
  (:require [environ.core :refer [env]]
            [clj-http.client :as client]
            [ring.util.codec :as codec]
            [ring.util.response :as util]
            [facetious.helpers :as helpers]
            [clojure.tools.logging :as log]
            [clojure.string :as str]))

(def oauth2-params
  {:authorize-uri "https://www.facebook.com/v2.8/dialog/oauth"
   :access-token-uri "https://graph.facebook.com/v2.8/oauth/access_token"
   :scope ["email"]})

(defn authorize [{headers :headers session :session params :params :as req}]
  (let [csrf-token (get headers "x-csrf-token")
        redirect-uri (str (:authorize-uri oauth2-params) "?client_id=" (:facebook-app-id env) "&state=" (codec/url-encode csrf-token) "&redirect_uri=" (helpers/derive-callback headers "/facebook/callback") "&scope=" (codec/url-encode (str/join "," (:scope oauth2-params))))]
    {:status 200
     :session (assoc session :facebook {:state csrf-token})
     :body redirect-uri}))

(defn callback [{headers :headers session :session params :params :as req}]
  (let [code (:code params)
        state (:state params)
        error-message {:message "There was a problem authorizing you with Facebook." :level :danger}
        success-message {:message "Successfully logged in via Facebook." :level :success}]
    (if (= state (codec/form-decode (:state (:facebook session))))
      (cond
        (contains? params :error) (do
                                    (log/fatal (:error params) (:error_code params) (:error_description params) (:error_reason params))
                                    (-> (util/redirect "/")
                                        (assoc :flash error-message)))
        (contains? params :code) (let [resp (client/post (:access-token-uri oauth2-params) {:form-params {:client_id (:facebook-app-id env)
                                                                               :client_secret (:facebook-app-secret env)
                                                                               :code code
                                                                               :redirect_uri (helpers/derive-callback headers "/facebook/callback")}
                                                                 :as :auto})
                                       status (:status resp)
                                       body (:body resp)]
                                   (if (= 500 (:status_code body))
                                     (do
                                       (log/fatal "Couldn't authorize you Facebook")
                                       (-> (util/redirect "/")
                                           (assoc :flash error-message)))
                                     (do
                                       (log/info "Successfully authorized Facebook")
                                       (-> (util/redirect "/")
                                           (assoc :session (assoc session :facebook body))
                                           (assoc :flash success-message))))))      
      (do
      (log/fatal "Couldn't authorize Facebook")
      (-> (util/redirect "/")
          (assoc :flash error-message))))))


