(ns facetious.authentication.bitly
  (:require [environ.core :refer [env]]
            [clj-http.client :as client]
            [ring.util.codec :as codec]
            [ring.util.response :as util]
            [facetious.helpers :as helpers]
            [clojure.tools.logging :as log]))

(def oauth2-params
  {:authorize-uri  "https://bitly.com/oauth/authorize"
   :access-token-uri "https://api-ssl.bitly.com/oauth/access_token"
   :grant_type "authorization_code"})

(defn authorize [{headers :headers session :session params :params :as req}]
  (let [csrf-token (get headers "x-csrf-token")
        redirect-uri (str (:authorize-uri oauth2-params) "?client_id=" (:bitly-client env) "&state=" (codec/url-encode csrf-token) "&redirect_uri=" (helpers/derive-callback headers "/bitly/callback"))]
    {:status 200
     :session (assoc session :bitly {:state csrf-token})
     :body redirect-uri}))

(defn callback [{headers :headers session :session params :params :as req}]
  (let [code (:code params)
        state (:state params)
        error-message {:message "There was a problem authorizing you with Bitly." :level :danger}
        success-message {:message "Successfully authorized Bitly." :level :success}]
    (if (= state (codec/form-decode (:state (:bitly session))))
      (let [resp (client/post (:access-token-uri oauth2-params) {:form-params {:client_id (:bitly-client env)
                                                                               :client_secret (:bitly-secret env)
                                                                               :code code
                                                                               :redirect_uri (helpers/derive-callback headers "/bitly/callback")}
                                                                 :as :auto})
            status (:status resp)
            body (:body resp)]
        (if (= 500 (:status_code body))
          (do
            (log/fatal "Couldn't authorize Bitly")
            (-> (util/redirect "/")
                (assoc :flash error-message)))
          (do
            (log/info "Successfully authorized Bitly")
            (-> (util/redirect "/")
                (assoc :session (assoc session :bitly body))
                (assoc :flash success-message)))))
      (do
      (log/fatal "Couldn't authorize Bitly")
      (-> (util/redirect "/")
          (assoc :flash error-message))))))
