(ns facetious.handlers
  (:require [compojure.core :refer [defroutes routes GET POST]]
            (facetious.authentication 
             [twitter :as twitter]
             [etsy :as etsy]
             [ecwid :as ecwid]
             [shopify :as shopify]
             [bitly :as bitly]
             [google :as google])))

(defroutes facetious
  (POST "twitter/authorize" [] twitter/authorize)
  (GET "/twitter/callback" [] twitter/callback)
  (POST "/etsy/authorize" [] etsy/authorize)
  (GET "/etsy/callback" [] etsy/callback)
  (GET "/shopify/install" [] shopify/app-store)
  (POST "/shopify/authorize" [] shopify/authorize)
  (GET "/shopify/callback" [] shopify/callback)
  (POST "/bitly/authorize" [] bitly/authorize)
  (GET "/bitly/callback" [] bitly/callback)
  (POST "/ecwid/authorize" [] ecwid/authorize)
  (GET "/ecwid/callback" [] ecwid/callback)
  (POST "/google/authorize" [] google/authorize)
  (GET "/google/callback" [] google/callback))
