# p

This repo contains the protocol buffer v3 definitions and generated modules for
data types that cross service boundaries in the Discovery Environment.

## Requirements

### TL;DR

You will need the following:

- `protoc`
- `protoc-gen-go`
- `protoc-gen-doc`
- `protoc-gen-prost`
- A symlink to the protobuf `include/` directory in `/usr/local/include`

### Installation

On MacOS, you can install `protoc` and `protoc-gen-go` with `homebrew`.

```
brew install protobuf protoc-gen-go
```

Link the `google/` directory from `protobuf` into `/usr/local/include`,
replacing the `3.19.4` in the directory path with whichever version got
installed above:

```
sudo ln -sf $HOMEBREW_CELLAR/protobuf/3.19.4/include/google /usr/local/include/google
```

You can install `protoc-gen-doc` with the `go install` command:

```
go install github.com/pseudomuto/protoc-gen-doc/cmd/protoc-gen-doc@latest
```


### Install Rust and Cargo on MacOS with zsh

Instructions originally found at https://stackoverflow.com/a/68617314.

Run the following in a terminal.

```bash
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh
```

When prompted, customize the installation. When asked about modifying the PATH,
select `No`. All of the other questions can be set to their default setting.

Next, open your `.zshrc` file (typically located at `~/.zshrc`) and add:

```
export PATH PATH="$HOME/.cargo/bin:$PATH"
```

Finally, source your `.zshrc` file:\

```
. ~/.zshrc
```

Run `rustc --version` to make sure the rust compiler is installed.

Run `cargo --version` to make sure that cargo is installed.

### Install protoc-gen-prost

Install `protoc-gen-prost` with Cargo:

```
cargo install protoc-gen-prost
```

That will install the `protoc-gen-prost` binary in `~/.cargo/bin`. You'll want to
put that directory in your `$PATH` if it isn't already there.

Next, install `protoc-gen-prost-serde` with Cargo:
```bash
cargo install protoc-gen-prost-serde```

## Repo Layout

`protos/` contains the protocol buffers definitions.

`go/` contains the generated Go modules. Do not edit these files directly.

`java/` contains the generated Java packages. Do not edit these files directly.

`debuff/` contains the Rust cargo project containing the generated rust module.
The file containing the generated code is `debuff/src/gen.rs`. Do not edit that
file directly. The other files in `debuff` may contain utility code to make the
generated code

## Building Go packages

The Makefile has a target to build the Go modules, so `make` or `make go` will
both work.

`make clean` will delete the generated files, so it is not run by default.

## NATS Subject Mapping

| Subject                           | Accepts                                                                  | Response                                                        | Responding Service                                                   |
| --------------------------------- | ------------------------------------------------------------------------ | --------------------------------------------------------------- | -------------------------------------------------------------------- |
| `cyverse.qms.user.usages.add`     | [qms.AddUsages](./protos/qms_requests.proto)                             | [qms.UsageResponse](./protos/qms_usages.proto)                  | [subscriptions](https://github.com/cyverse-de/subscriptions)         |
| `cyverse.qms.user.usages.get`     | [qms.GetUsages](./protos/qms_requests.proto)                             | [qms.UsageList](./protos/qms_usages.proto)                      | [subscriptions](https://github.com/cyverse-de/subscriptions)         |
| `cyverse.qms.user.overages.get`   | [qms.AllOveragesRequest](./protos/qms_requests.proto)                    | [qms.OverageList](./protos/qms_overages.proto)                  | [subscriptions](https://github.com/cyverse-de/subscriptions)         |
| `cyverse.qms.user.overages.check` | [qms.IsOverageRequest](./protos/qms_requests.proto)                      | [qms.IsOverage](./protos/qms_overages.proto)                    | [subscriptions](https://github.com/cyverse-de/subscriptions)         |
| `cyverse.discoenv.analyses.>`     | [analysis.AnalysisRecordLookupRequest](./protos/analysis_requests.proto) | [analysis.AnalysisRecordList](./protos/analysis_requests.proto) | [discoenv-analyses](https://github.com/cyverse-de/discoenv-analyses) |
| `cyverse.discoenv.users.>`        | [users.UserLookupRequest](./protos/user_requests.proto)                  | [user.User](./protos/user.proto)                                | [discoenv-users](https://github.com/cyverse-de/discoenv-users)       |
| `cyverse.qms.user.updates.get`    | [qms.UpdateListRequest](./protos/qms_updates.proto)                      | [qms.UpdateListResponse](./protos/qms_updates.proto)            | [subscriptions](https://github.com/cyverse-de/subscriptions)         |
| `cyverse.qms.user.updates.add`    | [qms.AddUpdateRequest](./protos/qms_updates.proto)                       | [qms.AddUpdateResponse](./protos/qms_updates.proto)             | [subscriptions](https://github.com/cyverse-de/subscriptions)         |
| `cyverse.qms.user.summary.get`    | [qms.RequestByUsername](./protos/qms_requests.proto)                     | [qms.UserPlanResponse](./protos/qms_user_plans.proto)           | [subscriptions](https://github.com/cyverse-de/subscriptions)         |

`

## Hints/Tips/Notes

### Reload VScode Window after generating Go code.

Sometimes the VSCode Go support thinks that some of the modules needed by the
`go` package are missing. I've found that reloading the window from the command
palette fixes that problem.
