(ns clj-jargon.users
  (:use [clj-jargon.validations]
        [clj-jargon.gen-query])
  (:import [org.irods.jargon.core.connection IRODSAccount]
           [org.irods.jargon.core.exception DataNotFoundException]
           [org.irods.jargon.core.query RodsGenQueryEnum]
           [org.irods.jargon.core.pub UserGroupAO
                                      UserAO]
           [org.irods.jargon.core.pub.domain UserGroup]))


(defn username->id
  [cm user]
  (->> (execute-gen-query cm
        "select %s where %s = '%s'"
        [RodsGenQueryEnum/COL_USER_ID
         RodsGenQueryEnum/COL_USER_NAME
         user])
       (mapv result-row->vec)
       (first)
       (first)))

(defn user-groups
  "Returns a list of group names that the user is in."
  [{^UserGroupAO ug-ao :userGroupAO} user]
  (for [^UserGroup ug (.findUserGroupsForUser ug-ao user)]
    (.getUserGroupName ug)))

(defn user-group-ids
  "Returns a list of group IDs that the user is in."
  [{^UserGroupAO ug-ao :userGroupAO} user]
  (for [^UserGroup ug (.findUserGroupsForUser ug-ao user)]
    (.getUserGroupId ug)))

(defn user-exists?
  "Returns true if 'user' exists in iRODS."
  [{^UserAO user-ao :userAO} user]
  (try
    (do
      (.findByName user-ao user)
      true)
    (catch DataNotFoundException d false)))

(defn proxied?
  "Returns true if this context map is using a proxied (client) user"
  [{:keys [^IRODSAccount irodsAccount]}]
  (cond (not (= (.getUserName irodsAccount) (.getProxyName irodsAccount))) true
        (not (= (.getZone irodsAccount) (.getProxyZone irodsAccount))) true
        :else false))
