(ns convana.server
  (:require [org.httpkit.server :as s]
            ))

(defn async-handler [ring-request]
  ;; unified API for WebSocket and HTTP long polling/streaming
  (s/with-channel ring-request channel ; get the channel
    (if (s/websocket? channel) ; if you want to distinguish them
      (s/on-receive channel (fn [data] ; two way communication
                              (s/send! channel data)))
      (s/send! channel {:status 200
                        :headers {"Content-Type" "text/plain"}
                        :body "Long polling?"}))))

(defn -main
  [& args]
  (s/run-server async-handler {:port 8080}) ; Ring server
  )

